/*
 * Decompiled with CFR 0.152.
 */
package br.gov.mma.gui.wizards;

import br.gov.mma.banco.AcessoBanco;
import br.gov.mma.bean.Grupo;
import br.gov.mma.bean.Layer;
import br.gov.mma.bean.ParseMapFile;
import com.hardcode.driverManager.DriverLoadException;
import com.hardcode.gdbms.engine.instruction.FieldNotFoundException;
import com.iver.andami.PluginServices;
import com.iver.cit.gvsig.fmap.DriverException;
import com.iver.cit.gvsig.fmap.MapControl;
import com.iver.cit.gvsig.fmap.ViewPort;
import com.iver.cit.gvsig.fmap.core.ICanReproject;
import com.iver.cit.gvsig.fmap.crs.CRSFactory;
import com.iver.cit.gvsig.fmap.drivers.ConnectionFactory;
import com.iver.cit.gvsig.fmap.drivers.ConnectionJDBC;
import com.iver.cit.gvsig.fmap.drivers.DBLayerDefinition;
import com.iver.cit.gvsig.fmap.drivers.DriverIOException;
import com.iver.cit.gvsig.fmap.drivers.IConnection;
import com.iver.cit.gvsig.fmap.drivers.IVectorialDatabaseDriver;
import com.iver.cit.gvsig.fmap.layers.FLayer;
import com.iver.cit.gvsig.fmap.layers.FLayers;
import com.iver.cit.gvsig.fmap.layers.FLyrWMS;
import com.iver.cit.gvsig.fmap.layers.LayerFactory;
import com.iver.cit.gvsig.fmap.layers.XMLException;
import com.iver.cit.gvsig.fmap.layers.layerOperations.ClassifiableVectorial;
import com.iver.cit.gvsig.fmap.rendering.LegendFactory;
import com.iver.cit.gvsig.fmap.rendering.VectorialLegend;
import com.iver.cit.gvsig.gui.WizardPanel;
import com.iver.cit.gvsig.project.documents.view.gui.BaseView;
import com.iver.utiles.XMLEntity;
import com.iver.utiles.xmlEntity.generate.XmlTag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cresques.cts.IProjection;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class I3GeoWizard
extends WizardPanel
implements ActionListener,
ItemListener {
    public static final String MS_POSTGIS = "MS_POSTGIS";
    public static final String MS_WMS = "MS_WMS";
    private JPanel panelCategoria = null;
    private JPanel panelInfoTema = null;
    private JComboBox cmbCategoria = null;
    private JComboBox cmbSubCategoria = null;
    private JComboBox cmbTema = null;
    private JButton btnConectar = null;
    private JButton btnCarregar = null;
    private JLabel labelInfoMap = new JLabel();
    private JLabel labelInfoConexao = new JLabel();
    private JTextField txtLinkMap = new JTextField();
    private JCheckBox chkForcaWMS = null;
    private JCheckBox chkLegendaDefault = null;
    private List<Grupo> grupos = new ArrayList<Grupo>();
    private List<Grupo> subgrupos = new ArrayList<Grupo>();
    private List<Grupo> temas = new ArrayList<Grupo>();
    private String connectiontype = null;
    private ImageIcon imgTema = null;
    private String servidorRss = "http://mapas.mma.gov.br/i3geo/admin/";
    private boolean forcaWMS = false;
    private boolean legendaDefault = false;
    private ParseMapFile parseMapFile = new ParseMapFile();
    private Layer layer = null;
    AcessoBanco banco = new AcessoBanco();

    public I3GeoWizard() {
        this.initialize();
    }

    private void initialize() {
        this.setTabName("I3Geo");
        this.add(this.getPanelCategoria(), null);
        this.add(this.getPanelInfoTema(), null);
        this.labelInfoMap.setBounds(10, 15, 250, 250);
        this.txtLinkMap.setBounds(270, 125, 200, 20);
        this.txtLinkMap.setVisible(false);
        this.panelInfoTema.add((Component)this.labelInfoMap, null);
        this.panelInfoTema.add((Component)this.txtLinkMap, null);
        this.setSize(510, 490);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(750, 420));
        this.setVisible(true);
        this.recarregaCmbCategoria();
    }

    public void execute() {
    }

    public void initWizard() {
    }

    public FLayer getLayer() {
        if (this.connectiontype.equals(MS_POSTGIS)) {
            return this.getLayerPostGIS();
        }
        if (this.connectiontype.equals(MS_WMS)) {
            return this.getLayerWMS();
        }
        return null;
    }

    private JPanel getPanelCategoria() {
        this.panelCategoria = new JPanel();
        this.panelCategoria.setLayout(null);
        this.panelCategoria.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"themas"), 0, 0, null, null));
        this.panelCategoria.setVisible(true);
        this.panelCategoria.setBounds(2, 2, 477, 200);
        this.panelCategoria.add(this.getCmbCategoria());
        this.panelCategoria.add(this.getCmbSubCategoria());
        this.panelCategoria.add(this.getCmbTema());
        this.btnCarregar = new JButton(PluginServices.getText((Object)this, (String)"load"));
        this.btnCarregar.setBounds(350, 160, 80, 20);
        this.btnCarregar.setVisible(true);
        this.btnCarregar.addActionListener(this);
        this.panelCategoria.add(this.btnCarregar);
        this.btnConectar = new JButton(PluginServices.getText((Object)this, (String)"server"));
        this.btnConectar.setBounds(350, 30, 80, 20);
        this.btnConectar.setVisible(true);
        this.btnConectar.addActionListener(this);
        this.btnConectar.setName("btnConectar");
        this.panelCategoria.add(this.btnConectar);
        this.labelInfoConexao.setText(PluginServices.getText((Object)this, (String)"disconnected"));
        this.labelInfoConexao.setForeground(Color.RED);
        this.labelInfoConexao.setBounds(10, 180, 80, 20);
        this.labelInfoConexao.setVisible(true);
        this.panelCategoria.add(this.labelInfoConexao);
        this.chkForcaWMS = new JCheckBox(PluginServices.getText((Object)this, (String)"strong_wms"));
        this.chkForcaWMS.setBounds(330, 80, 130, 20);
        this.chkForcaWMS.addItemListener(this);
        this.chkForcaWMS.setVisible(true);
        this.panelCategoria.add(this.chkForcaWMS);
        this.chkLegendaDefault = new JCheckBox(PluginServices.getText((Object)this, (String)"legend_default"));
        this.chkLegendaDefault.setBounds(330, 100, 130, 20);
        this.chkLegendaDefault.addItemListener(this);
        this.chkLegendaDefault.setVisible(true);
        this.panelCategoria.add(this.chkLegendaDefault);
        return this.panelCategoria;
    }

    private JPanel getPanelInfoTema() {
        this.panelInfoTema = new JPanel();
        this.panelInfoTema.setLayout(null);
        this.panelInfoTema.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"thema_information"), 0, 0, null, null));
        this.panelInfoTema.setVisible(true);
        this.panelInfoTema.setBounds(2, 200, 477, 275);
        return this.panelInfoTema;
    }

    private JComboBox getCmbCategoria() {
        this.cmbCategoria = new JComboBox();
        this.cmbCategoria.setBounds(10, 30, 300, 20);
        this.cmbCategoria.addItem(PluginServices.getText((Object)this, (String)"select_category"));
        this.cmbCategoria.setEnabled(false);
        this.cmbCategoria.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    I3GeoWizard.this.carregaCmbSubGrupos(I3GeoWizard.this.cmbCategoria.getSelectedIndex());
                }
            }
        });
        return this.cmbCategoria;
    }

    private void recarregaCmbCategoria() {
        this.grupos = new ArrayList<Grupo>();
        this.cmbCategoria.removeAllItems();
        this.cmbCategoria.addItem(PluginServices.getText((Object)this, (String)"select_category"));
        this.grupos = this.getGruposRss();
        if (!this.grupos.isEmpty()) {
            for (Grupo grupo : this.grupos) {
                this.cmbCategoria.addItem(grupo.getNome());
            }
        }
        this.cmbCategoria.setEnabled(true);
        this.labelInfoConexao.setText(PluginServices.getText((Object)this, (String)"conectado"));
        this.labelInfoConexao.setForeground(Color.BLUE);
    }

    private JComboBox getCmbSubCategoria() {
        this.cmbSubCategoria = new JComboBox();
        this.cmbSubCategoria.setBounds(10, 70, 300, 20);
        this.cmbSubCategoria.addItem(PluginServices.getText((Object)this, (String)"select_subcategory"));
        this.cmbSubCategoria.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    I3GeoWizard.this.carregaCmbTema(I3GeoWizard.this.cmbSubCategoria.getSelectedIndex());
                }
            }
        });
        this.cmbSubCategoria.setEnabled(false);
        return this.cmbSubCategoria;
    }

    private JComboBox getCmbTema() {
        this.cmbTema = new JComboBox();
        this.cmbTema.setBounds(10, 110, 300, 20);
        this.cmbTema.addItem(PluginServices.getText((Object)this, (String)"select_thema"));
        this.cmbTema.addActionListener(this);
        this.cmbTema.setEnabled(false);
        this.cmbTema.setName("cmbTema");
        this.cmbTema.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    if (I3GeoWizard.this.cmbTema.getSelectedIndex() != 0) {
                        I3GeoWizard.this.panelInfoTema.setVisible(true);
                        I3GeoWizard.this.getInfoTema();
                    } else {
                        I3GeoWizard.this.panelInfoTema.setVisible(false);
                    }
                }
            }
        });
        return this.cmbTema;
    }

    public List getGruposRss() {
        try {
            URL url = new URL(String.valueOf(this.servidorRss) + "rssgrupos.php");
            System.out.println(url);
            InputStream file = url.openStream();
            SAXBuilder sb = new SAXBuilder();
            Document d = sb.build(file);
            Element mural = d.getRootElement();
            List elements = mural.getChildren();
            for (Element element : elements) {
                List listGrupos = element.getChildren();
                for (Element grupoElement : listGrupos) {
                    if (!grupoElement.getName().equals("item")) continue;
                    Grupo grupo = new Grupo();
                    grupo.setLink(grupoElement.getChildText("link"));
                    grupo.setNome(grupoElement.getChildText("title"));
                    this.grupos.add(grupo);
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.labelInfoConexao.setForeground(Color.RED);
            this.labelInfoConexao.setText(PluginServices.getText((Object)this, (String)"disconnected"));
            JOptionPane.showMessageDialog((Component)((Object)this), PluginServices.getText((Object)this, (String)"error_access_server"));
            this.configurarServidorRss();
        }
        return this.grupos;
    }

    public List getSubgruposRss(int indiceGrupo) {
        Grupo grupo = this.grupos.get(indiceGrupo - 1);
        this.subgrupos = new ArrayList<Grupo>();
        try {
            URL url = new URL(String.valueOf(this.servidorRss) + grupo.getLink());
            InputStream file = url.openStream();
            SAXBuilder sb = new SAXBuilder();
            Document d = sb.build(file);
            Element mural = d.getRootElement();
            List elements = mural.getChildren();
            for (Element element : elements) {
                List listSubgrupos = element.getChildren();
                for (Element subgrupoElement : listSubgrupos) {
                    if (!subgrupoElement.getName().equals("item")) continue;
                    Grupo subgrupo = new Grupo();
                    subgrupo.setLink(subgrupoElement.getChildText("link"));
                    subgrupo.setNome(subgrupoElement.getChildText("title"));
                    this.subgrupos.add(subgrupo);
                }
            }
            return this.subgrupos;
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List getTemasRss(int indiceSubGrupo) {
        Grupo grupo = this.subgrupos.get(indiceSubGrupo - 1);
        this.temas = new ArrayList<Grupo>();
        try {
            URL url = new URL(String.valueOf(this.servidorRss) + grupo.getLink());
            System.out.println(url);
            InputStream file = url.openStream();
            SAXBuilder sb = new SAXBuilder();
            Document d = sb.build(file);
            Element mural = d.getRootElement();
            List elements = mural.getChildren();
            for (Element element : elements) {
                List listTemas = element.getChildren();
                for (Element temaElement : listTemas) {
                    if (!temaElement.getName().equals("item")) continue;
                    Grupo tema = new Grupo();
                    tema.setLink(temaElement.getChildText("link"));
                    tema.setNome(temaElement.getChildText("title"));
                    tema.setAuthor(temaElement.getChildText("author"));
                    this.temas.add(tema);
                }
            }
            return this.temas;
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void carregaCmbSubGrupos(int indiceGrupo) {
        this.cmbSubCategoria.removeAllItems();
        this.cmbSubCategoria.addItem(PluginServices.getText((Object)this, (String)"select_subcategory"));
        if (indiceGrupo != 0) {
            List subgrupos = this.getSubgruposRss(indiceGrupo);
            for (Grupo subgrupo : subgrupos) {
                this.cmbSubCategoria.addItem(subgrupo.getNome());
            }
            this.cmbSubCategoria.setEnabled(true);
        } else {
            this.cmbSubCategoria.setEnabled(false);
        }
    }

    public void carregaCmbTema(int indiceSubGrupo) {
        this.cmbTema.removeAllItems();
        this.cmbTema.addItem(PluginServices.getText((Object)this, (String)"select_thema"));
        if (indiceSubGrupo != 0) {
            List temas = this.getTemasRss(indiceSubGrupo);
            for (Grupo tema : temas) {
                this.cmbTema.addItem(tema.getNome());
            }
            this.cmbTema.setEnabled(true);
        } else {
            this.cmbTema.setEnabled(false);
        }
    }

    public void carregaMapFileRss() {
        if (this.cmbTema.getSelectedIndex() != 0 && this.cmbTema.isEnabled()) {
            Grupo tema = this.temas.get(this.cmbTema.getSelectedIndex() - 1);
            try {
                URL url = null;
                url = this.forcaWMS ? new URL(String.valueOf(this.servidorRss) + tema.getLink() + "&forcawms=sim") : new URL(String.valueOf(this.servidorRss) + tema.getLink());
                InputStream file = url.openStream();
                SAXBuilder sb = new SAXBuilder();
                Document d = sb.build(file);
                Element mural = d.getRootElement();
                List elements = mural.getChildren();
                this.parseMapFile = this.parseMapFile.populaMapFile(elements);
                for (Layer this.layer : this.parseMapFile.getLayers()) {
                    if (this.layer.getConnectiontype().equals(MS_POSTGIS)) {
                        this.connectiontype = MS_POSTGIS;
                        this.carregaVisao();
                    } else if (this.layer.getConnectiontype().equals(MS_WMS)) {
                        this.connectiontype = MS_WMS;
                        this.carregaVisao();
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), PluginServices.getText((Object)this, (String)"dont_suport"));
                    }
                    this.layer = null;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        }
    }

    public IVectorialDatabaseDriver getDriverFromName(String drvname) throws DriverLoadException {
        IVectorialDatabaseDriver resp = (IVectorialDatabaseDriver)LayerFactory.getDM().getDriver(drvname);
        return resp;
    }

    public boolean addLayers(MapControl mapControl) {
        FLayer lyr = null;
        lyr = this.getLayer();
        if (lyr != null) {
            lyr.setVisible(true);
            lyr.setActive(true);
            mapControl.getMapContext().beginAtomicEvent();
            this.checkProjection(lyr, mapControl.getViewPort());
            mapControl.getMapContext().getLayers().addLayer(lyr);
            if (this.legendaDefault) {
                this.adicionarLegenda(lyr);
            }
            mapControl.getMapContext().endAtomicEvent();
            return true;
        }
        return false;
    }

    private boolean checkProjection(FLayer lyr, ViewPort viewPort) {
        if (lyr instanceof FLayers) {
            FLayers layers = (FLayers)lyr;
            int i = 0;
            while (i < layers.getLayersCount()) {
                this.checkProjection(layers.getLayer(i), viewPort);
                ++i;
            }
        }
        if (lyr.isReprojectable()) {
            boolean control = true;
            IProjection proj = lyr.getProjection();
            if (proj == null) {
                lyr.setProjection(viewPort.getProjection());
                return control;
            }
            if (proj != viewPort.getProjection()) {
                int option = 0;
                if (!CRSFactory.doesRigurousTransformations()) {
                    option = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), String.valueOf(PluginServices.getText((Object)this, (String)"reproyectar_aviso")) + "\n" + PluginServices.getText((Object)this, (String)"Capa") + ": " + lyr.getName(), PluginServices.getText((Object)this, (String)"reproyectar_pregunta"), 0);
                }
                if (option == 1) {
                    return control;
                }
                control = lyr.reProject(((BaseView)PluginServices.getMDIManager().getActiveWindow()).getMapControl());
                return control;
            }
        }
        return true;
    }

    public void carregaVisao() {
        BaseView theView = (BaseView)PluginServices.getMDIManager().getActiveWindow();
        MapControl mapControl = theView.getMapControl();
        this.addLayers(mapControl);
        mapControl.getMapContext().callLegendChanged();
    }

    public FLayer getLayerPostGIS() {
        IProjection proj = null;
        String dburl = "jdbc:postgresql://" + this.layer.getConnection().getHost() + ":" + this.layer.getConnection().getPort() + "/" + this.layer.getConnection().getDbname();
        String dbuser = this.layer.getConnection().getUser();
        String dbpass = this.layer.getConnection().getPassword();
        try {
            String dbtable = this.layer.getTabela();
            String schema = this.layer.getEsquema();
            String strEPSG = "EPSG:4291";
            IVectorialDatabaseDriver driver = null;
            driver = this.getDriverFromName("PostGIS JDBC Driver");
            Rectangle2D _wa = null;
            driver.setWorkingArea(_wa);
            IConnection conn = null;
            Class.forName("org.postgresql.Driver");
            conn = ConnectionFactory.createConnection((String)dburl, (String)dbuser, (String)dbpass);
            ((ConnectionJDBC)conn).getConnection().setAutoCommit(false);
            DBLayerDefinition lyrDef = new DBLayerDefinition();
            lyrDef.setName(dbtable);
            lyrDef.setTableName(dbtable);
            lyrDef.setWhereClause(this.layer.getWhere());
            String[] fields = null;
            fields = this.layer.getColunas() != null && this.layer.getColunas().length > 0 ? this.layer.getColunas() : this.banco.buscaCampos(String.valueOf(schema) + "." + dbtable);
            lyrDef.setFieldNames(fields);
            lyrDef.setFieldGeometry("the_geom");
            lyrDef.setFieldID("gid");
            lyrDef.setSchema(schema);
            lyrDef.setSRID_EPSG(strEPSG);
            lyrDef.setHost(this.layer.getConnection().getHost());
            lyrDef.setPort(this.layer.getConnection().getPort().intValue());
            lyrDef.setDataBase(this.layer.getConnection().getDbname());
            lyrDef.setUser(this.layer.getConnection().getUser());
            lyrDef.setPassword(this.layer.getConnection().getPassword());
            if (driver instanceof ICanReproject) {
                ((ICanReproject)driver).setDestProjection(strEPSG);
            }
            driver.setData(conn, lyrDef);
            return LayerFactory.createDBLayer((IVectorialDatabaseDriver)driver, (String)this.layer.getTitulo(), proj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public FLayer getLayerWMS() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("host", this.layer.getData());
        args.put("layer", this.layer.getName());
        args.put("SRS", this.layer.getSrs());
        args.put("wmsTransparency", Boolean.FALSE);
        Hashtable<String, String> onLineResources = new Hashtable<String, String>();
        onLineResources.put("GetLegendGraphic", "images/icoLayer.png");
        args.put("onlineResources", onLineResources);
        try {
            FLyrWMS capaWMS = new FLyrWMS(args);
            return capaWMS;
        }
        catch (DriverIOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getInfoTema() {
        Grupo tema = this.temas.get(this.cmbTema.getSelectedIndex() - 1);
        this.parseMapFile = new ParseMapFile();
        this.getParseMapRss();
        Layer layerInfoTema = (Layer)this.parseMapFile.getLayers().get(0);
        try {
            URL url = new URL("http://mapas.mma.gov.br/i3geo/temas/miniaturas/" + layerInfoTema.getName() + ".map.grande.png");
            this.imgTema = new ImageIcon(url);
            this.labelInfoMap.setIcon(this.imgTema);
            this.txtLinkMap.setText(tema.getAuthor());
            this.txtLinkMap.setVisible(true);
            this.txtLinkMap.setCaretPosition(0);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    public void getParseMapRss() {
        if (this.cmbTema.getSelectedIndex() != 0 && this.cmbTema.isEnabled()) {
            Grupo tema = this.temas.get(this.cmbTema.getSelectedIndex() - 1);
            System.out.println(String.valueOf(this.servidorRss) + tema.getLink());
            try {
                URL url = null;
                url = new URL(String.valueOf(this.servidorRss) + tema.getLink());
                InputStream file = url.openStream();
                SAXBuilder sb = new SAXBuilder();
                Document d = sb.build(file);
                Element mural = d.getRootElement();
                List elements = mural.getChildren();
                this.parseMapFile = this.parseMapFile.populaMapFile(elements);
                for (Layer this.layer : this.parseMapFile.getLayers()) {
                    if (this.layer.getConnectiontype().equals(MS_POSTGIS)) {
                        this.connectiontype = MS_POSTGIS;
                    } else if (this.layer.getConnectiontype().equals(MS_WMS)) {
                        this.connectiontype = MS_WMS;
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), PluginServices.getText((Object)this, (String)"dont_suport"));
                    }
                    this.layer = null;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        }
    }

    public void configurarServidorRss() {
        this.cmbCategoria.setEnabled(false);
        String resposta = JOptionPane.showInputDialog(PluginServices.getText((Object)this, (String)"insert_address"), (Object)this.servidorRss);
        if (resposta != null && !"".equals(resposta)) {
            this.servidorRss = resposta;
            this.recarregaCmbCategoria();
        }
    }

    public void adicionarLegenda(FLayer camada) {
        if (!(camada instanceof ClassifiableVectorial)) {
            return;
        }
        try {
            ClassifiableVectorial lyrVect = (ClassifiableVectorial)camada;
            URL url = new URL(String.valueOf(this.servidorRss) + "php/" + this.layer.getGeraxmllegenda());
            XmlTag tag = (XmlTag)XmlTag.unmarshal((Reader)new InputStreamReader(url.openStream()));
            XMLEntity xml = new XMLEntity(tag);
            if (xml.contains("followHeaderEncoding")) {
                boolean useEncoding = xml.getBooleanProperty("followHeaderEncoding");
                if (!useEncoding) {
                    throw new UnsupportedEncodingException("the encoding specified in the xml header is not safe");
                }
            } else {
                throw new UnsupportedEncodingException("the encoding specified in the xml header is not safe");
            }
            VectorialLegend legenda = LegendFactory.createFromXML((XMLEntity)xml);
            lyrVect.setLegend(legenda);
        }
        catch (MarshalException e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"formato_incorrecto"));
        }
        catch (ValidationException e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"formato_incorrecto"));
        }
        catch (XMLException e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"formato_incorrecto"));
        }
        catch (FieldNotFoundException e) {
            e.printStackTrace();
        }
        catch (DriverException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCarregar) {
            this.carregaMapFileRss();
        }
        if (e.getSource() == this.btnConectar) {
            this.configurarServidorRss();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.chkForcaWMS) {
            this.forcaWMS = e.getStateChange() == 1;
        }
        if (source == this.chkLegendaDefault) {
            this.legendaDefault = e.getStateChange() == 1;
        }
    }
}

