<?php
//--------------------------------------------
// Autor: Jaime Rojas Landívar (Jameuge)
// Propósito: Generar un mapa PNG desde MapServer (WMS)
//             y crear un PDF con FPDF que lo contiene.
//--------------------------------------------

// Configuración básica
$layer = "sigapas1,red_alcantarillado";
$bbox  = "806569,8073356,810539,8074276";  // coordenadas visibles
$width = 1000;
$height = 232;
$epsg = "32719";

// URL base del WMS
$wms_url = "https://www.server1.jmap4.com/cgi-bin/mapserv";
$map_path = "/var/www/html/jmapReport/map_files/prueba.map";

// Construcción dinámica de la URL WMS GetMap
$url = "$wms_url?map=$map_path&SERVICE=WMS&VERSION=1.0.0&REQUEST=GetMap".
       "&LAYERS=$layer&SRS=EPSG:$epsg".
       "&BBOX=$bbox".
       "&FORMAT=image/png".
       "&WIDTH=$width&HEIGHT=$height";

//echo "Descargando imagen desde:\n$url\n\n";

// Carpeta temporal para guardar la imagen
$tmp_dir = "/var/www/html/jmapReport/tmp";
if (!is_dir($tmp_dir)) mkdir($tmp_dir, 0777, true);

$output_file = "$tmp_dir/mapa.png";

//--------------------------------------------
// DESCARGAR IMAGEN CON CURL
//--------------------------------------------
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);

$data = curl_exec($ch);

if (curl_errno($ch)) {
    die("Error CURL: " . curl_error($ch));
}
curl_close($ch);

file_put_contents($output_file, $data);

// Verificar si la imagen se guardó
if (!file_exists($output_file)) {
    die("❌ No se pudo guardar la imagen.\n");
}
//echo "✅ Imagen guardada: $output_file\n";

//--------------------------------------------
// CREAR PDF CON FPDF
//--------------------------------------------
require(dirname(__FILE__).'/pacotes/fpdf/fpdf.php');
//require("/var/www/html/jmapReport/fpdf.php");

$pdf = new FPDF("L", "mm", "A4");
$pdf->AddPage();

// Encabezado del reporte
$pdf->SetFont("Arial", "B", 14);
$pdf->Cell(0, 10, utf8_decode("Mapa generado automáticamente desde WMS"), 0, 1, "C");
$pdf->Ln(5);

// Insertar la imagen en el PDF
$pdf->Image($output_file, 10, 30, 270, 0);

// Pie de página
$pdf->SetY(-15);
$pdf->SetFont("Arial", "I", 10);
$pdf->Cell(0, 10, "Generado por jMap - ".date("Y-m-d H:i:s"), 0, 0, "C");

// Salida
$pdf->Output("I", "mapa_generado.pdf");

echo "✅ PDF generado correctamente.\n";
?>
