<?php
//============================================================+
// File name   : example_010.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 010 for TCPDF class
//               Text on multiple columns
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Text on multiple columns
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');


/**
 * Extend TCPDF to work with multiple columns
 */
class MC_TCPDF extends TCPDF {

	/**
	 * Print chapter
	 * @param $num (int) chapter number
	 * @param $title (string) chapter title
	 * @param $file (string) name of the file containing the chapter body
	 * @param $mode (boolean) if true the chapter body is in HTML, otherwise in simple text.
	 * @public
	 */
	public function PrintChapter($num, $title, $file, $mode=false) {
		// add a new page
		$this->AddPage('L');
		// disable existing columns
		$this->resetColumns();
		// print chapter title
		$this->ChapterTitle($num, $title);
		// set columns
		$this->setEqualColumns(2, 120);
		// print chapter body
		$this->ChapterBody($file, $mode);
	}

	/**
	 * Set chapter title
	 * @param $num (int) chapter number
	 * @param $title (string) chapter title
	 * @public
	 */
	public function ChapterTitle($num, $title) {
		$this->SetFont('helvetica', '', 14);
		$this->SetFillColor(200, 220, 255);
		$this->Cell(180, 6, 'Chapter '.$num.' : '.$title, 0, 1, '', 1);
		$this->Ln(4);
	}

	/**
	 * Print chapter body
	 * @param $file (string) name of the file containing the chapter body
	 * @param $mode (boolean) if true the chapter body is in HTML, otherwise in simple text.
	 * @public
	 */
	public function ChapterBody($file, $mode=false) {
		$this->selectColumn();
		// get esternal file content
		//$content = file_get_contents($file, false);
		$content = $file;
		// set font
		$this->SetFont('times', '', 9);
		$this->SetTextColor(50, 50, 50);
		// print content
		if ($mode) {
			// ------ HTML MODE ------
			$this->writeHTML($content, true, false, true, false, 'J');
		} else {
			// ------ TEXT MODE ------
			$this->Write(0, $content, '', 0, 'J', true, 0, false, true, 0);
		}
		$this->Ln();
	}
} // end of extended class

// ---------------------------------------------------------
// EXAMPLE
// ---------------------------------------------------------
// create new PDF document
$pdf = new MC_TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('TCPDF Example 010');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 010', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// print TEXT

$blanco = '.-------.';
$texto = 
'POR CUANTO '.$blanco.', con C.I. Nro. '.$blanco.', de nacionalidad '.$blanco.', de '.$blanco.' años de edad, estado civil '.$blanco.', con domicilio en la colonia '.$blanco.', ha cumplido las formalidades legales exigidas para adquirir en propiedad definitiva, según consta en el expediente Nro. '.$blanco.', el lote '.strtoupper($blanco).', número '.$blanco.', de la manzana '.$blanco.', de la colonia '.$blanco.', situado en el distrito de '.$blanco.', del departamento de '.$blanco.', siendo la superficie de dicho lote de '.(empty($blanco) ? '' : $blanco . ' hectáreas, ').(empty($blanco) ? '' : $blanco . ' metros cuadrados, ').(empty($blanco) ? '' : $blanco . ' centímetros cuadrados, ').' y sus linderos y dimensiones los que se consignan en el informe pericial aprobado por el DEPARTAMENTO DE CATASTRO en fecha 1 de AGOSTO DEL 2.012 que a la letra es como sigue:
En la solicitud presentada por '.$blanco.', sobre compra de un lote de terreno '.$blanco.', situado en la colonia '.$blanco.' , EL DEPARTAMENTO DE CATASTRO informa que el citado lote se refiere al señalado en el plano respectivo con el Nro. '.$blanco.', manzana '.$blanco.', y que consta de ('.(empty($blanco) ? '' : $blanco . ' HAs ').(empty($blanco) ? '' : $blanco . ' MS2 ').(empty($blanco) ? '' : $blanco . ' CMS2 ').') '.(empty($blanco) ? '' : strtoupper($blanco) . ' hectáreas ').(empty($blanco) ? '' : strtoupper($blanco) . ' METROS CUADRADOS ').(empty($blanco) ? '' : strtoupper($blanco) . ' CENTíMETROS CUADRADOS ').' de superficie, siendo sus dimensiones y linderos los siguientes:
'.$blanco.'ANTECEDENTES: '.$blanco.' Corresponde al Instituto Nacional de Desarrollo Rural y de la Tierra, el inmueble descrito según Ley Nro. 2.419/2004 que en su Art 26 dice: El instituto Nacional de Desarrollo Rural y de la Tierra queda subrogado en todos los derechos patrimoniales del Instituto de Bienestar Rural, para todos sus efectos legales, por compra hecha en mayor porción de '.$blanco.', según de cuyo testimonio se tomó razón en la Dirección General de los Registros Públicos como Finca Nro '.$blanco.', del Distritos de '.$blanco.', bajo el Nro '.$blanco.', y al folio '.$blanco.' vuelto y siguientes, de fecha '.$blanco.' Padrón Nro '.$blanco.' FIRMADO: '.strtoupper($blanco).' EL precio total del lote es de (Gs. '.$blanco.') '.strtoupper($blanco).' GUARANIES '.$blanco.' '.$blanco.' La adjudicación '.($blanco ? 'gratuita ':' ').'definitiva fue autorizada por Resolución de Presidencia del Instituto Nacional de Desarrollo Rural y de la Tierra Nro '.$blanco.' de '.$blanco.'.'.$blanco.' El beneficiario '.$blanco.', manifiesta aceptar la transferencia del lote de referencia en las condiciones señaladas más arriba y en prueba de ello suscribe el presente título DE PROPIEDAD._________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________
FIRMA DEL BENEFICIARIO
';

$pdf->PrintChapter(1, 'LOREM IPSUM [TEXT]', $texto, false);

// print HTML
//$pdf->PrintChapter(2, 'LOREM IPSUM [HTML]', 'data/chapter_demo_2.txt', true);

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_010.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
