/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
  @license
  fontmetrics.js - https://github.com/Pomax/fontmetrics.js

  Copyright (C) 2011 by Mike "Pomax" Kamermans

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
**/

/**
@license
topojson - https://github.com/mbostock/topojson

Copyright (c) 2012, Michael Bostock
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* The name Michael Bostock may not be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
	 * Autolinker.js
	 * 0.15.2
	 *
	 * Copyright(c) 2015 Gregory Jacobs <greg@greg-jacobs.com>
	 * MIT Licensed. http://www.opensource.org/licenses/mit-license.php
	 *
	 * https://github.com/gregjacobs/Autolinker.js
	 */

/**
@license
 Copyright (c) 2013 Gildas Lormeau. All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in
 the documentation and/or other materials provided with the distribution.

 3. The names of the authors may not be used to endorse or promote products
 derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
 INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**/

/**
 * @license
 * Knockout JavaScript library v3.2.0
 * (c) Steven Sanderson - http://knockoutjs.com/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * @license
 * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5
 * Copyright (c) Steve Sanderson
 * MIT license
 */

// Copyright 2012 Google Inc., Apache 2.0 license.

/**
@license
tween.js - https://github.com/sole/tween.js

Copyright (c) 2010-2012 Tween.js authors.

Easing equations Copyright (c) 2001 Robert Penner http://robertpenner.com/easing/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/**
 * @license
 * Copyright (c) 2011 NVIDIA Corporation. All rights reserved.
 *
 * TO  THE MAXIMUM  EXTENT PERMITTED  BY APPLICABLE  LAW, THIS SOFTWARE  IS PROVIDED
 * *AS IS*  AND NVIDIA AND  ITS SUPPLIERS DISCLAIM  ALL WARRANTIES,  EITHER  EXPRESS
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED  TO, NONINFRINGEMENT,IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL  NVIDIA 
 * OR ITS SUPPLIERS BE  LIABLE  FOR  ANY  DIRECT, SPECIAL,  INCIDENTAL,  INDIRECT,  OR  
 * CONSEQUENTIAL DAMAGES WHATSOEVER (INCLUDING, WITHOUT LIMITATION,  DAMAGES FOR LOSS 
 * OF BUSINESS PROFITS, BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR ANY 
 * OTHER PECUNIARY LOSS) ARISING OUT OF THE  USE OF OR INABILITY  TO USE THIS SOFTWARE, 
 * EVEN IF NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

/**
 * @license
 * Copyright (c) 2000-2005, Sean O'Neil (s_p_oneil@hotmail.com)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of the project nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modifications made by Analytical Graphics, Inc.
 */

/**
 * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/domReady for details
 */

!function(){define("Cesium/Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Cesium/Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var i,n=t.name,r=t.message;i=e(n)&&e(r)?n+": "+r:t.toString();var o=t.stack;return e(o)&&(i+="\n"+o),i};return t}),define("Cesium/ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var i=n.exec(t);this.scheme=i[1],this.authority=i[2],this.path=i[3],this.query=i[4],this.fragment=i[5]}}function t(e){var t=unescape(e);return o.test(t)?t:e.toUpperCase()}function i(e,t,i,n){return(t||"")+i.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,i).replace(r,t)),this.path&&(this.path=this.path.replace(r,t)),this.query&&(this.query=this.query.replace(r,t)),this.fragment&&(this.fragment=this.fragment.replace(r,t))};var r=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var i=new e;return this.scheme?(i.scheme=this.scheme,i.authority=this.authority,i.path=this.path,i.query=this.query):(i.scheme=t.scheme,this.authority?(i.authority=this.authority,i.path=this.path,i.query=this.query):(i.authority=t.authority,""==this.path?(i.path=t.path,i.query=this.query||t.query):("/"==this.path.charAt(0)?(i.path=this.path,i.removeDotSegments()):(i.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,i.removeDotSegments()),i.query=this.query))),i.fragment=this.fragment,i},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),i=[],n=""==t[0];for(n&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?i.pop():"."!=e&&i.push(e);("."==e||".."==e)&&i.push(""),n&&i.unshift(""),this.path=i.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Cesium/Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(i){t=i.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Cesium/Core/getFilenameFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){var i=new e(t);i.normalize();var n=i.path,r=n.lastIndexOf("/");return-1!==r&&(n=n.substr(r+1)),n};return t}),define("Cesium/Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Cesium/Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,i){"use strict";var n=function(t){var n={};if(""===t)return n;for(var r=t.replace(/\+/g,"%20").split("&"),o=0,a=r.length;a>o;++o){var s=r[o].split("="),l=decodeURIComponent(s[0]),u=s[1];u=e(u)?decodeURIComponent(u):"";var c=n[l];"string"==typeof c?n[l]=[c,u]:i(c)?c.push(u):n[l]=u}return n};return n}),define("Cesium/Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Cesium/Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Cesium/ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var i;for(this.mti==this.N+1&&this.init_genrand(5489),i=0;i<this.N-this.M;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+this.M]^e>>>1^t[1&e];for(;i<this.N-1;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Cesium/Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return 2*(i.clamp(e,0,255)/255)-1},i.sinh=function(e){var t=Math.pow(Math.E,e),i=Math.pow(Math.E,-1*e);return.5*(t-i)},i.cosh=function(e){var t=Math.pow(Math.E,e),i=Math.pow(Math.E,-1*e);return.5*(t+i)},i.lerp=function(e,t,i){return(1-i)*e+i*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=.5*3*Math.PI,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,i,n,r){r=t(r,n);var o=Math.abs(e-i);return r>=o||o<=n*Math.max(Math.abs(e),Math.abs(i))};var n=[1];i.factorial=function(e){var t=n.length;if(e>=t)for(var i=n[t-1],r=t;e>=r;r++)n.push(i*r);return n[e]},i.incrementWrap=function(e,i,n){return n=t(n,0),++e,e>i&&(e=n),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,i){return t>e?t:e>i?i:e};var r=new e;return i.setRandomNumberSeed=function(t){r=new e(t)},i.nextRandomNumber=function(){return r.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i}),define("Cesium/Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r){"use strict";var o=function(t,i){this.x=e(t,0),this.y=e(i,0)};o.fromElements=function(e,i,n){return t(n)?(n.x=e,n.y=i,n):new o(e,i)},o.clone=function(e,i){return t(e)?t(i)?(i.x=e.x,i.y=e.y,i):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(t,i,n){n=e(n,0),i[n++]=t.x,i[n]=t.y},o.unpack=function(i,n,r){return n=e(n,0),t(r)||(r=new o),r.x=i[n++],r.y=i[n],r},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i},o.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var i=o.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i},o.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i},o.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i},o.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i},o.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,i,n){return o.multiplyByScalar(t,i,s),n=o.multiplyByScalar(e,1-i,n),o.add(s,n,n)};var l=new o,u=new o;o.angleBetween=function(e,t){return o.normalize(e,l),o.normalize(t,u),r.acosClamped(o.dot(l,u))};var c=new o;return o.mostOrthogonalAxis=function(e,t){var i=o.normalize(e,c);return o.abs(i,i),t=i.x<=i.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,i){return e===i||t(e)&&t(i)&&e.x===i.x&&e.y===i.y},o.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]},o.equalsEpsilon=function(e,i,n,o){return e===i||t(e)&&t(i)&&r.equalsEpsilon(e.x,i.x,n,o)&&r.equalsEpsilon(e.y,i.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,i){return o.equalsEpsilon(this,e,t,i)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Cesium/Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r){"use strict";var o=function(t,i,n){this.x=e(t,0),this.y=e(i,0),this.z=e(n,0)};o.fromSpherical=function(i,n){t(n)||(n=new o);var r=i.clock,a=i.cone,s=e(i.magnitude,1),l=s*Math.sin(a);return n.x=l*Math.cos(r),n.y=l*Math.sin(r),n.z=s*Math.cos(a),n},o.fromElements=function(e,i,n,r){return t(r)?(r.x=e,r.y=i,r.z=n,r):new o(e,i,n)},o.clone=function(e,i){return t(e)?t(i)?(i.x=e.x,i.y=e.y,i.z=e.z,i):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(t,i,n){n=e(n,0),i[n++]=t.x,i[n++]=t.y,i[n]=t.z},o.unpack=function(i,n,r){return n=e(n,0),t(r)||(r=new o),r.x=i[n++],r.y=i[n++],r.z=i[n],r},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i},o.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var i=o.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i},o.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i},o.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i},o.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i},o.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,i,n){return o.multiplyByScalar(t,i,s),n=o.multiplyByScalar(e,1-i,n),o.add(s,n,n)};var l=new o,u=new o;o.angleBetween=function(e,t){o.normalize(e,l),o.normalize(t,u);var i=o.dot(l,u),n=o.magnitude(o.cross(l,u,l));return Math.atan2(n,i)};var c=new o;o.mostOrthogonalAxis=function(e,t){var i=o.normalize(e,c);return o.abs(i,i),t=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):i.y<=i.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.equals=function(e,i){return e===i||t(e)&&t(i)&&e.x===i.x&&e.y===i.y&&e.z===i.z},o.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]},o.equalsEpsilon=function(e,i,n,o){return e===i||t(e)&&t(i)&&r.equalsEpsilon(e.x,i.x,n,o)&&r.equalsEpsilon(e.y,i.y,n,o)&&r.equalsEpsilon(e.z,i.z,n,o)},o.cross=function(e,t,i){var n=e.x,r=e.y,o=e.z,a=t.x,s=t.y,l=t.z,u=r*l-o*s,c=o*a-n*l,d=n*s-r*a;return i.x=u,i.y=c,i.z=d,i},o.fromDegrees=function(e,t,i,n,a){var s=r.toRadians(e),l=r.toRadians(t);return o.fromRadians(s,l,i,n,a)};var d=new o,h=new o,m=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,r,a,s){r=e(r,0);var l=t(a)?a.radiiSquared:m,u=Math.cos(n);d.x=u*Math.cos(i),d.y=u*Math.sin(i),d.z=Math.sin(n),d=o.normalize(d,d),o.multiplyComponents(l,d,h);var c=Math.sqrt(o.dot(d,h));return h=o.divideByScalar(h,c,h),d=o.multiplyByScalar(d,r,d),t(s)||(s=new o),o.add(h,d,s)},o.fromDegreesArray=function(e,t,i){for(var n=new Array(e.length),a=0;a<e.length;a++)n[a]=r.toRadians(e[a]);return o.fromRadiansArray(n,t,i)},o.fromRadiansArray=function(e,i,n){var r=e.length;t(n)?n.length=r/2:n=new Array(r/2);for(var a=0;r>a;a+=2){var s=e[a],l=e[a+1];n[a/2]=o.fromRadians(s,l,0,i,n[a/2])}return n},o.fromDegreesArrayHeights=function(e,t,i){for(var n=new Array(e.length),a=0;a<e.length;a+=3)n[a]=r.toRadians(e[a]),n[a+1]=r.toRadians(e[a+1]),n[a+2]=e[a+2];return o.fromRadiansArrayHeights(n,t,i)},o.fromRadiansArrayHeights=function(e,i,n){var r=e.length;t(n)?n.length=r/3:n=new Array(r/3);for(var a=0;r>a;a+=3){var s=e[a],l=e[a+1],u=e[a+2];n[a/3]=o.fromRadians(s,l,u,i,n[a/3])}return n},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,i){return o.equalsEpsilon(this,e,t,i)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Cesium/Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r){"use strict";var o=function(t,i,n){this.longitude=e(t,0),this.latitude=e(i,0),this.height=e(n,0)};return o.fromRadians=function(i,n,r,a){return r=e(r,0),t(a)?(a.longitude=i,a.latitude=n,a.height=r,a):new o(i,n,r)},o.fromDegrees=function(e,t,i,n){return e=r.toRadians(e),t=r.toRadians(t),o.fromRadians(e,t,i,n)},o.clone=function(e,i){return t(e)?t(i)?(i.longitude=e.longitude,i.latitude=e.latitude,i.height=e.height,i):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,i){return e===i||t(e)&&t(i)&&e.longitude===i.longitude&&e.latitude===i.latitude&&e.height===i.height},o.equalsEpsilon=function(e,i,n){return e===i||t(e)&&t(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Cesium/Core/ClockRange",["./freezeObject"],function(e){"use strict";var t={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2};return e(t)}),define("Cesium/Core/ClockStep",["./freezeObject"],function(e){"use strict";var t={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2};return e(t)}),define("Cesium/Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),i=Object.defineProperties;return t&&e(i)||(i=function(e){return e}),i}),define("Cesium/Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var i,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},r={};return t(r,{element:{get:function(){return r.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return r.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return r.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return r.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return r.supportsFullscreen()?null!==r.element:void 0}}}),r.supportsFullscreen=function(){if(e(i))return i;i=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",i=!0;for(var r,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var l=o[a];r=l+"RequestFullscreen","function"==typeof t[r]?(n.requestFullscreen=r,i=!0):(r=l+"RequestFullScreen","function"==typeof t[r]&&(n.requestFullscreen=r,i=!0)),r=l+"ExitFullscreen","function"==typeof document[r]?n.exitFullscreen=r:(r=l+"CancelFullScreen","function"==typeof document[r]&&(n.exitFullscreen=r)),r=l+"FullscreenEnabled",e(document[r])?n.fullscreenEnabled=r:(r=l+"FullScreenEnabled",e(document[r])&&(n.fullscreenEnabled=r)),r=l+"FullscreenElement",e(document[r])?n.fullscreenElement=r:(r=l+"FullScreenElement",e(document[r])&&(n.fullscreenElement=r)),r=l+"fullscreenchange",e(document["on"+r])&&("ms"===l&&(r="MSFullscreenChange"),n.fullscreenchange=r),r=l+"fullscreenerror",e(document["on"+r])&&("ms"===l&&(r="MSFullscreenError"),n.fullscreenerror=r)}return i},r.requestFullscreen=function(e){r.supportsFullscreen()&&e[n.requestFullscreen]()},r.exitFullscreen=function(){r.supportsFullscreen()&&document[n.exitFullscreen]()},r}),define("Cesium/Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,i){"use strict";function n(e){for(var t=e.split("."),i=0,n=t.length;n>i;++i)t[i]=parseInt(t[i],10);return t}function r(){if(!t(v)){v=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(v=!0,g=n(e[1]))}return v}function o(){return r()&&g}function a(){if(!t(_)&&(_=!1,!r()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,y=n(e[1]))}return _}function s(){return a()&&y}function l(){if(!t(C)){C=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(C=!0,w=n(e[1]),w.isNightly=!!e[2])}return C}function u(){return l()&&w}function c(){if(!t(E)){E=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,b=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,b=n(e[1])))}return E}function d(){return c()&&b}function h(){if(!t(S)){S=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(S=!0,x=n(e[1]))}return S}function m(){return t(T)||(T=/Windows/i.test(navigator.appVersion)),T}function p(){return h()&&x}function f(){return t(P)||(P=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),P}var v,g,_,y,C,w,E,b,S,x,T,P,A={isChrome:r,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:l,webkitVersion:u,isInternetExplorer:c,internetExplorerVersion:d,isFirefox:h,firefoxVersion:p,isWindows:m,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:f};return A.supportsFullscreen=function(){return i.supportsFullscreen()},A.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},A.supportsWebWorkers=function(){return"undefined"!=typeof Worker},A}),define("Cesium/Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,i,n,r,o){"use strict";function a(e,t,i){return 0>i&&(i+=1),i>1&&(i-=1),1>6*i?e+6*(t-e)*i:1>2*i?t:2>3*i?e+6*(t-e)*(2/3-i):e}var s=function(t,i,n,r){this.red=e(t,1),this.green=e(i,1),this.blue=e(n,1),this.alpha=e(r,1)};s.fromCartesian4=function(e,i){return t(i)?(i.red=e.x,i.green=e.y,i.blue=e.z,i.alpha=e.w,i):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(i,n,r,o,a){return i=s.byteToFloat(e(i,255)),n=s.byteToFloat(e(n,255)),r=s.byteToFloat(e(r,255)),o=s.byteToFloat(e(o,255)),t(a)?(a.red=i,a.green=n,a.blue=r,a.alpha=o,a):new s(i,n,r,o)},s.fromAlpha=function(e,i,n){return t(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=i,n):new s(e.red,e.green,e.blue,i)};var l,u,c;n.supportsTypedArrays()&&(l=new ArrayBuffer(4),u=new Uint32Array(l),c=new Uint8Array(l)),s.fromRgba=function(e){return u[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,i,n,r){t=e(t,0)%1,i=e(i,0),n=e(n,0),r=e(r,1);var o=n,l=n,u=n;if(0!==i){var c;c=.5>n?n*(1+i):n+i-n*i;var d=2*n-c;o=a(d,c,t+1/3),l=a(d,c,t),u=a(d,c,t-1/3)}return new s(o,l,u,r)},s.fromRandom=function(i,n){i=e(i,e.EMPTY_OBJECT);var r=i.red;if(!t(r)){var a=e(i.minimumRed,0),l=e(i.maximumRed,1);r=a+o.nextRandomNumber()*(l-a)}var u=i.green;if(!t(u)){var c=e(i.minimumGreen,0),d=e(i.maximumGreen,1);u=c+o.nextRandomNumber()*(d-c)}var h=i.blue;if(!t(h)){var m=e(i.minimumBlue,0),p=e(i.maximumBlue,1);h=m+o.nextRandomNumber()*(p-m)}var f=i.alpha;if(!t(f)){var v=e(i.minimumAlpha,0),g=e(i.maximumAlpha,1);f=v+o.nextRandomNumber()*(g-v)}return t(n)?(n.red=r,n.green=u,n.blue=h,n.alpha=f,n):new s(r,u,h,f)};var d=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,p=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(i){var n=s[i.toUpperCase()];if(t(n))return s.clone(n);var r=d.exec(i);return null!==r?new s(parseInt(r[1],16)/15,parseInt(r[2],16)/15,parseInt(r[3],16)/15):(r=h.exec(i),null!==r?new s(parseInt(r[1],16)/255,parseInt(r[2],16)/255,parseInt(r[3],16)/255):(r=m.exec(i),null!==r?new s(parseFloat(r[1])/("%"===r[1].substr(-1)?100:255),parseFloat(r[2])/("%"===r[2].substr(-1)?100:255),parseFloat(r[3])/("%"===r[3].substr(-1)?100:255),parseFloat(e(r[4],"1.0"))):(r=p.exec(i),null!==r?s.fromHsl(parseFloat(r[1])/360,parseFloat(r[2])/100,parseFloat(r[3])/100,parseFloat(e(r[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(t,i,n){n=e(n,0),i[n++]=t.red,i[n++]=t.green,i[n++]=t.blue,i[n]=t.alpha},s.unpack=function(i,n,r){return n=e(n,0),t(r)||(r=new s),r.red=i[n++],r.green=i[n++],r.blue=i[n++],r.alpha=i[n],r},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,i){return t(e)?t(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=e.alpha,i):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,i){return e===i||t(e)&&t(i)&&e.red===i.red&&e.green===i.green&&e.blue===i.blue&&e.alpha===i.alpha},s.equalsArray=function(e,t,i){return e.red===t[i]&&e.green===t[i+1]&&e.blue===t[i+2]&&e.alpha===t[i+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,i){return this===e||t(e)&&Math.abs(this.red-e.red)<=i&&Math.abs(this.green-e.green)<=i&&Math.abs(this.blue-e.blue)<=i&&Math.abs(this.alpha-e.alpha)<=i},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),i=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+i+")":"rgba("+e+","+t+","+i+","+this.alpha+")"},s.prototype.toBytes=function(e){var i=s.floatToByte(this.red),n=s.floatToByte(this.green),r=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=i,e[1]=n,e[2]=r,e[3]=o,e):[i,n,r,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),u[0]},s.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},s.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.ALICEBLUE=r(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=r(s.fromCssColorString("#FAEBD7")),s.AQUA=r(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=r(s.fromCssColorString("#7FFFD4")),s.AZURE=r(s.fromCssColorString("#F0FFFF")),s.BEIGE=r(s.fromCssColorString("#F5F5DC")),s.BISQUE=r(s.fromCssColorString("#FFE4C4")),s.BLACK=r(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=r(s.fromCssColorString("#FFEBCD")),s.BLUE=r(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=r(s.fromCssColorString("#8A2BE2")),s.BROWN=r(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=r(s.fromCssColorString("#DEB887")),s.CADETBLUE=r(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=r(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=r(s.fromCssColorString("#D2691E")),s.CORAL=r(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=r(s.fromCssColorString("#6495ED")),s.CORNSILK=r(s.fromCssColorString("#FFF8DC")),s.CRIMSON=r(s.fromCssColorString("#DC143C")),s.CYAN=r(s.fromCssColorString("#00FFFF")),s.DARKBLUE=r(s.fromCssColorString("#00008B")),s.DARKCYAN=r(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=r(s.fromCssColorString("#B8860B")),s.DARKGRAY=r(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=r(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=r(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=r(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=r(s.fromCssColorString("#556B2F")),s.DARKORANGE=r(s.fromCssColorString("#FF8C00")),s.DARKORCHID=r(s.fromCssColorString("#9932CC")),s.DARKRED=r(s.fromCssColorString("#8B0000")),s.DARKSALMON=r(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=r(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=r(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=r(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=r(s.fromCssColorString("#00CED1")),s.DARKVIOLET=r(s.fromCssColorString("#9400D3")),s.DEEPPINK=r(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=r(s.fromCssColorString("#00BFFF")),s.DIMGRAY=r(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=r(s.fromCssColorString("#1E90FF")),s.FIREBRICK=r(s.fromCssColorString("#B22222")),s.FLORALWHITE=r(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=r(s.fromCssColorString("#228B22")),s.FUSCHIA=r(s.fromCssColorString("#FF00FF")),s.GAINSBORO=r(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=r(s.fromCssColorString("#F8F8FF")),s.GOLD=r(s.fromCssColorString("#FFD700")),s.GOLDENROD=r(s.fromCssColorString("#DAA520")),s.GRAY=r(s.fromCssColorString("#808080")),s.GREEN=r(s.fromCssColorString("#008000")),s.GREENYELLOW=r(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=r(s.fromCssColorString("#F0FFF0")),s.HOTPINK=r(s.fromCssColorString("#FF69B4")),s.INDIANRED=r(s.fromCssColorString("#CD5C5C")),s.INDIGO=r(s.fromCssColorString("#4B0082")),s.IVORY=r(s.fromCssColorString("#FFFFF0")),s.KHAKI=r(s.fromCssColorString("#F0E68C")),s.LAVENDER=r(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=r(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=r(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=r(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=r(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=r(s.fromCssColorString("#F08080")),s.LIGHTCYAN=r(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=r(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=r(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=r(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=r(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=r(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=r(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=r(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=r(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=r(s.fromCssColorString("#FFFFE0")),s.LIME=r(s.fromCssColorString("#00FF00")),s.LIMEGREEN=r(s.fromCssColorString("#32CD32")),s.LINEN=r(s.fromCssColorString("#FAF0E6")),s.MAGENTA=r(s.fromCssColorString("#FF00FF")),s.MAROON=r(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=r(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=r(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=r(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=r(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=r(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=r(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=r(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=r(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=r(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=r(s.fromCssColorString("#191970")),s.MINTCREAM=r(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=r(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=r(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=r(s.fromCssColorString("#FFDEAD")),s.NAVY=r(s.fromCssColorString("#000080")),s.OLDLACE=r(s.fromCssColorString("#FDF5E6")),s.OLIVE=r(s.fromCssColorString("#808000")),s.OLIVEDRAB=r(s.fromCssColorString("#6B8E23")),s.ORANGE=r(s.fromCssColorString("#FFA500")),s.ORANGERED=r(s.fromCssColorString("#FF4500")),s.ORCHID=r(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=r(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=r(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=r(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=r(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=r(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=r(s.fromCssColorString("#FFDAB9")),s.PERU=r(s.fromCssColorString("#CD853F")),s.PINK=r(s.fromCssColorString("#FFC0CB")),s.PLUM=r(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=r(s.fromCssColorString("#B0E0E6")),s.PURPLE=r(s.fromCssColorString("#800080")),s.RED=r(s.fromCssColorString("#FF0000")),s.ROSYBROWN=r(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=r(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=r(s.fromCssColorString("#8B4513")),s.SALMON=r(s.fromCssColorString("#FA8072")),s.SANDYBROWN=r(s.fromCssColorString("#F4A460")),s.SEAGREEN=r(s.fromCssColorString("#2E8B57")),s.SEASHELL=r(s.fromCssColorString("#FFF5EE")),s.SIENNA=r(s.fromCssColorString("#A0522D")),s.SILVER=r(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=r(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=r(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=r(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=r(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=r(s.fromCssColorString("#00FF7F")),s.STEELBLUE=r(s.fromCssColorString("#4682B4")),s.TAN=r(s.fromCssColorString("#D2B48C")),s.TEAL=r(s.fromCssColorString("#008080")),s.THISTLE=r(s.fromCssColorString("#D8BFD8")),s.TOMATO=r(s.fromCssColorString("#FF6347")),s.TURQUOISE=r(s.fromCssColorString("#40E0D0")),s.VIOLET=r(s.fromCssColorString("#EE82EE")),s.WHEAT=r(s.fromCssColorString("#F5DEB3")),s.WHITE=r(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=r(s.fromCssColorString("#F5F5F5")),s.YELLOW=r(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=r(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=r(new s(0,0,0,0)),s
}),define("Cesium/Core/createGuid",[],function(){"use strict";var e=function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=0|16*Math.random(),i="x"===e?t:8|3&t;return i.toString(16)})};return e}),define("Cesium/Core/deprecationWarning",["./defined","./DeveloperError"],function(e){"use strict";var t={},i=function(i,n){e(t[i])||(t[i]=!0,console.log(n))};return i}),define("Cesium/Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r,o,a,s){"use strict";function l(t,n,r,o){n=i(n,0),r=i(r,0),o=i(o,0),t._radii=new e(n,r,o),t._radiiSquared=new e(n*n,r*r,o*o),t._radiiToTheFourth=new e(n*n*n*n,r*r*r*r,o*o*o*o),t._oneOverRadii=new e(0===n?0:1/n,0===r?0:1/r,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===r?0:1/(r*r),0===o?0:1/(o*o)),t._minimumRadius=Math.min(n,r,o),t._maximumRadius=Math.max(n,r,o),t._centerToleranceSquared=s.EPSILON1}var u=function(e,t,i){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,l(this,e,t,i)};r(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(t,i){if(!n(t))return void 0;var r=t._radii;return n(i)?(e.clone(r,i._radii),e.clone(t._radiiSquared,i._radiiSquared),e.clone(t._radiiToTheFourth,i._radiiToTheFourth),e.clone(t._oneOverRadii,i._oneOverRadii),e.clone(t._oneOverRadiiSquared,i._oneOverRadiiSquared),i._minimumRadius=t._minimumRadius,i._maximumRadius=t._maximumRadius,i._centerToleranceSquared=t._centerToleranceSquared,i):new u(r.x,r.y,r.z)},u.fromCartesian3=function(e,t){return n(t)||(t=new u),n(e)?(l(t,e.x,e.y,e.z),t):t},u.WGS84=a(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=a(new u(1,1,1)),u.MOON=a(new u(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.packedLength=e.packedLength,u.pack=function(t,n,r){r=i(r,0),e.pack(t._radii,n,r)},u.unpack=function(t,n,r){n=i(n,0);var o=e.unpack(t,n);return u.fromCartesian3(o,r)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(t,i){var r=t.longitude,o=t.latitude,a=Math.cos(o),s=a*Math.cos(r),l=a*Math.sin(r),u=Math.sin(o);return n(i)||(i=new e),i.x=s,i.y=l,i.z=u,e.normalize(i,i)},u.prototype.geodeticSurfaceNormal=function(t,i){return n(i)||(i=new e),i=e.multiplyComponents(t,this._oneOverRadiiSquared,i),e.normalize(i,i)};var c=new e,d=new e;u.prototype.cartographicToCartesian=function(t,i){var r=c,o=d;this.geodeticSurfaceNormalCartographic(t,r),e.multiplyComponents(this._radiiSquared,r,o);var a=Math.sqrt(e.dot(r,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(r,t.height,r),n(i)||(i=new e),e.add(o,r,i)},u.prototype.cartographicArrayToCartesianArray=function(e,t){var i=e.length;n(t)?t.length=i:t=new Array(i);for(var r=0;i>r;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var h=new e,m=new e,p=new e;u.prototype.cartesianToCartographic=function(i,r){var o=this.scaleToGeodeticSurface(i,m);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),l=e.subtract(i,o,p),u=Math.atan2(a.y,a.x),c=Math.asin(a.z),d=s.sign(e.dot(l,i))*e.magnitude(l);return n(r)?(r.longitude=u,r.latitude=c,r.height=d,r):new t(u,c,d)},u.prototype.cartesianArrayToCartographicArray=function(e,t){var i=e.length;n(t)?t.length=i:t=new Array(i);for(var r=0;i>r;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t};var f=new e,v=new e;return u.prototype.scaleToGeodeticSurface=function(t,i){var r=t.x,o=t.y,a=t.z,l=this._oneOverRadii,u=l.x,c=l.y,d=l.z,h=r*r*u*u,m=o*o*c*c,p=a*a*d*d,g=h+m+p,_=Math.sqrt(1/g),y=e.multiplyByScalar(t,_,f);if(g<this._centerToleranceSquared)return isFinite(_)?e.clone(y,i):void 0;var C=this._oneOverRadiiSquared,w=C.x,E=C.y,b=C.z,S=v;S.x=2*y.x*w,S.y=2*y.y*E,S.z=2*y.z*b;var x,T,P,A,M,I,D,O,R,L,N,z=(1-_)*e.magnitude(t)/(.5*e.magnitude(S)),F=0;do{z-=F,P=1/(1+z*w),A=1/(1+z*E),M=1/(1+z*b),I=P*P,D=A*A,O=M*M,R=I*P,L=D*A,N=O*M,x=h*I+m*D+p*O-1,T=h*R*w+m*L*E+p*N*b;var B=-2*T;F=x/B}while(Math.abs(x)>s.EPSILON12);return n(i)?(i.x=r*P,i.y=o*A,i.z=a*M,i):new e(r*P,o*A,a*M)},u.prototype.scaleToGeocentricSurface=function(t,i){n(i)||(i=new e);var r=t.x,o=t.y,a=t.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(r*r*s.x+o*o*s.y+a*a*s.z);return e.multiplyByScalar(t,l,i)},u.prototype.transformPositionToScaledSpace=function(t,i){return n(i)||(i=new e),e.multiplyComponents(t,this._oneOverRadii,i)},u.prototype.transformPositionFromScaledSpace=function(t,i){return n(i)||(i=new e),e.multiplyComponents(t,this._radii,i)},u.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Cesium/Core/Event",["./defined","./defineProperties","./DeveloperError"],function(e,t){"use strict";var i=function(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1};return t(i.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),i.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},i.prototype.removeEventListener=function(e,t){for(var i=this._listeners,n=this._scopes,r=-1,o=0;o<i.length;o++)if(i[o]===e&&n[o]===t){r=o;break}return-1!==r?(this._insideRaiseEvent?(this._toRemove.push(r),i[r]=void 0,n[r]=void 0):(i.splice(r,1),n.splice(r,1)),!0):!1},i.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var t,i=this._listeners,n=this._scopes,r=i.length;for(t=0;r>t;t++){var o=i[t];e(o)&&i[t].apply(n[t],arguments)}var a=this._toRemove;for(r=a.length,t=0;r>t;t++){var s=a[t];i.splice(s,1),n.splice(s,1)}a.length=0,this._insideRaiseEvent=!1},i}),define("Cesium/Core/ExtrapolationType",["./freezeObject"],function(e){"use strict";var t={NONE:0,HOLD:1,EXTRAPOLATE:2};return e(t)}),define("Cesium/Core/HermitePolynomialApproximation",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,i,n){"use strict";function r(e,t,i,n,o,a){var s,l,u,c=0;if(n>0){for(l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(a.push(l),c+=r(e,t,i,n-1,o,a),a.splice(a.length-1,1))}return c}for(c=1,l=0;o>l;l++){for(s=!1,u=0;u<a.length&&!s;u++)l===a[u]&&(s=!0);s||(c*=e-i[t[l]])}return c}function o(e,t,i,r,o,a){for(var s,l,u=-1,c=t.length,d=c*(c+1)/2,h=0;o>h;h++){var m=Math.floor(h*d);for(s=0;c>s;s++)l=t[s]*o*(a+1)+h,e[m+s]=r[l];for(var p=1;c>p;p++){var f=0,v=Math.floor(p*(1-p)/2)+c*p,g=!1;for(s=0;c-p>s;s++){var _,y,C=i[t[s]],w=i[t[s+p]];if(0>=w-C)l=t[s]*o*(a+1)+o*p+h,_=r[l],y=_/n.factorial(p),e[m+v+f]=y,f++;else{var E=Math.floor((p-1)*(2-p)/2)+c*(p-1);_=e[m+E+s+1]-e[m+E+s],y=_/(w-C),e[m+v+f]=y,f++}g=g||0!==_}g&&(u=Math.max(u,p))}}return u}var a=n.factorial,s={type:"Hermite"};s.getRequiredDataPoints=function(t,i){return i=e(i,0),Math.max(Math.floor((t+1)/(i+1)),2)},s.interpolateOrderZero=function(e,i,n,o,s){t(s)||(s=new Array(o));var l,u,c,d,h,m,p=i.length,f=new Array(o);for(l=0;o>l;l++){s[l]=0;var v=new Array(p);for(f[l]=v,u=0;p>u;u++)v[u]=[]}var g=p,_=new Array(g);for(l=0;g>l;l++)_[l]=l;var y=p-1;for(d=0;o>d;d++){for(u=0;g>u;u++)m=_[u]*o+d,f[d][0].push(n[m]);for(l=1;g>l;l++){var C=!1;for(u=0;g-l>u;u++){var w,E=i[_[u]],b=i[_[u+l]];0>=b-E?(m=_[u]*o+o*l+d,w=n[m],f[d][l].push(w/a(l))):(w=f[d][l-1][u+1]-f[d][l-1][u],f[d][l].push(w/(b-E))),C=C||0!==w}C||(y=l-1)}}for(c=0,h=0;h>=c;c++)for(l=c;y>=l;l++){var S=r(e,_,i,c,l,[]);for(d=0;o>d;d++){var x=f[d][l][0];s[d+c*o]+=x*S}}return s};var l=[];return s.interpolate=function(e,i,n,a,s,u,c){var d=a*(u+1);t(c)||(c=new Array(d));for(var h=0;d>h;h++)c[h]=0;for(var m=i.length,p=new Array(m*(s+1)),f=0;m>f;f++)for(var v=0;s+1>v;v++)p[f*(s+1)+v]=f;for(var g=p.length,_=l,y=o(_,p,i,n,a,s),C=[],w=g*(g+1)/2,E=Math.min(y,u),b=0;E>=b;b++)for(f=b;y>=f;f++){C.length=0;for(var S=r(e,p,i,b,f,C),x=Math.floor(f*(1-f)/2)+g*f,T=0;a>T;T++){var P=Math.floor(T*w),A=_[P+x];c[T+b*a]+=A*S}}return c},s}),define("Cesium/ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,i=0,n=t[i++],r=function(e,t,i,n){i||(i=" ");var r=e.length>=t?"":Array(1+t-e.length>>>0).join(i);return n?e+r:r+e},o=function(e,t,i,n,o,a){var s=n-e.length;return s>0&&(e=i||!o?r(e,n,a,i):e.slice(0,t.length)+r("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,i,n,a,s,l){var u=e>>>0;return i=i&&u&&{2:"0b",8:"0",16:"0x"}[t]||"",e=i+r(u.toString(t),s||0,"0",!1),o(e,i,n,a,l)},s=function(e,t,i,n,r,a){return null!=n&&(e=e.slice(0,n)),o(e,"",t,i,r,a)},l=function(e,n,l,u,c,d,h){var m,p,f,v,g;if("%%"==e)return"%";for(var _=!1,y="",C=!1,w=!1,E=" ",b=l.length,S=0;l&&b>S;S++)switch(l.charAt(S)){case" ":y=" ";break;case"+":y="+";break;case"-":_=!0;break;case"'":E=l.charAt(S+1);break;case"0":C=!0;break;case"#":w=!0}if(u=u?"*"==u?+t[i++]:"*"==u.charAt(0)?+t[u.slice(1,-1)]:+u:0,0>u&&(u=-u,_=!0),!isFinite(u))throw new Error("sprintf: (minimum-)width must be finite");switch(d=d?"*"==d?+t[i++]:"*"==d.charAt(0)?+t[d.slice(1,-1)]:+d:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,g=n?t[n.slice(0,-1)]:t[i++],h){case"s":return s(String(g),_,u,d,C,E);case"c":return s(String.fromCharCode(+g),_,u,d,C);case"b":return a(g,2,w,_,u,d,C);case"o":return a(g,8,w,_,u,d,C);case"x":return a(g,16,w,_,u,d,C);case"X":return a(g,16,w,_,u,d,C).toUpperCase();case"u":return a(g,10,w,_,u,d,C);case"i":case"d":return m=+g||0,m=Math.round(m-m%1),p=0>m?"-":y,g=p+r(String(Math.abs(m)),d,"0",!1),o(g,p,_,u,C);case"e":case"E":case"f":case"F":case"g":case"G":return m=+g,p=0>m?"-":y,f=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],v=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],g=p+Math.abs(m)[f](d),o(g,p,_,u,C)[v]();default:return e}};return n.replace(e,l)}return e}),define("Cesium/Core/binarySearch",["./defined","./DeveloperError"],function(){"use strict";var e=function(e,t,i){for(var n,r,o=0,a=e.length-1;a>=o;)if(n=~~((o+a)/2),r=i(e[n],t),0>r)o=n+1;else{if(!(r>0))return n;a=n-1}return~(a+1)};return e}),define("Cesium/Core/GregorianDate",[],function(){"use strict";var e=function(e,t,i,n,r,o,a,s){this.year=e,this.month=t,this.day=i,this.hour=n,this.minute=r,this.second=o,this.millisecond=a,this.isLeapSecond=s};return e}),define("Cesium/Core/isLeapYear",["./DeveloperError"],function(){"use strict";function e(e){return 0===e%4&&0!==e%100||0===e%400}return e}),define("Cesium/Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Cesium/Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Cesium/Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Cesium/Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,i,n,r,o,a,s,l,u){"use strict";function c(e,t){return M.compare(e.julianDate,t.julianDate)}function d(e){_.julianDate=e;var i=M.leapSeconds,n=t(i,_,c);0>n&&(n=~n),n>=i.length&&(n=i.length-1);var r=i[n].offset;if(n>0){var o=M.secondsDifference(i[n].julianDate,e);o>r&&(n--,r=i[n].offset)}M.addSeconds(e,r,e)}function h(e,i){_.julianDate=e;var n=M.leapSeconds,r=t(n,_,c);if(0>r&&(r=~r),0===r)return M.addSeconds(e,-n[0].offset,i);if(r>=n.length)return M.addSeconds(e,-n[r-1].offset,i);var o=M.secondsDifference(n[r].julianDate,e);return 0===o?M.addSeconds(e,-n[r].offset,i):1>=o?void 0:M.addSeconds(e,-n[--r].offset,i)}function m(e,t,i){var n=0|t/l.SECONDS_PER_DAY;return e+=n,t-=l.SECONDS_PER_DAY*n,0>t&&(e--,t+=l.SECONDS_PER_DAY),i.dayNumber=e,i.secondsOfDay=t,i}function p(e,t,i,n,r,o,a){var s=0|(t-14)/12,u=e+4800+s,c=(0|1461*u/4)+(0|367*(t-2-12*s)/12)-(0|3*((u+100)/100)/4)+i-32075;n-=12,0>n&&(n+=24);var d=o+(n*l.SECONDS_PER_HOUR+r*l.SECONDS_PER_MINUTE+a*l.SECONDS_PER_MILLISECOND);return d>=43200&&(c-=1),[c,d]}var f=new o,v=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,_=new s,y=/^(\d{4})$/,C=/^(\d{4})-(\d{2})$/,w=/^(\d{4})-?(\d{3})$/,E=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,b=/^(\d{4})-?(\d{2})-?(\d{2})$/,S=/([Z+\-])?(\d{2})?:?(\d{2})?$/,x=/^(\d{2})(\.\d+)?/.source+S.source,T=/^(\d{2}):?(\d{2})(\.\d+)?/.source+S.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+S.source,A="Invalid ISO 8601 date.",M=function(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=i(e,0),t=i(t,0),n=i(n,u.UTC);var r=0|e;t+=(e-r)*l.SECONDS_PER_DAY,m(r,t,this),n===u.UTC&&d(this)};M.fromDate=function(e,t){var i=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(i[0],i[1],t),d(t),t):new M(i[0],i[1],u.UTC)},M.fromIso8601=function(e,t){e=e.replace(",",".");var i,o,s,l=e.split("T"),c=1,h=1,f=0,_=0,S=0,I=0,D=l[0],O=l[1];if(!n(D))throw new r(A);var R;if(l=D.match(b),null!==l){if(R=D.split("-").length-1,R>0&&2!==R)throw new r(A);i=+l[1],c=+l[2],h=+l[3]}else if(l=D.match(C),null!==l)i=+l[1],c=+l[2];else if(l=D.match(y),null!==l)i=+l[1];else{var L;if(l=D.match(w),null!==l){if(i=+l[1],L=+l[2],s=a(i),1>L||s&&L>366||!s&&L>365)throw new r(A)}else{if(l=D.match(E),null===l)throw new r(A);i=+l[1];var N=+l[2],z=+l[3]||0;if(R=D.split("-").length-1,R>0&&(!n(l[3])&&1!==R||n(l[3])&&2!==R))throw new r(A);var F=new Date(Date.UTC(i,0,4));L=7*N+z-F.getUTCDay()-3}o=new Date(Date.UTC(i,0,1)),o.setUTCDate(L),c=o.getUTCMonth()+1,h=o.getUTCDate()}if(s=a(i),1>c||c>12||1>h||(2!==c||!s)&&h>v[c-1]||s&&2===c&&h>g)throw new r(A);var B;if(n(O)){if(l=O.match(P),null!==l){if(R=O.split(":").length-1,R>0&&2!==R&&3!==R)throw new r(A);f=+l[1],_=+l[2],S=+l[3],I=1e3*+(l[4]||0),B=5}else if(l=O.match(T),null!==l){if(R=O.split(":").length-1,R>0&&1!==R)throw new r(A);f=+l[1],_=+l[2],S=60*+(l[3]||0),B=4}else{if(l=O.match(x),null===l)throw new r(A);f=+l[1],_=60*+(l[2]||0),B=3}if(_>=60||S>=61||f>24||24===f&&(_>0||S>0||I>0))throw new r(A);var V=l[B],k=+l[B+1],U=+(l[B+2]||0);switch(V){case"+":f-=k,_-=U;break;case"-":f+=k,_+=U;break;case"Z":break;default:_+=new Date(Date.UTC(i,c-1,h,f,_)).getTimezoneOffset()}}else _+=new Date(i,c-1,h).getTimezoneOffset();var W=60===S;for(W&&S--;_>=60;)_-=60,f++;for(;f>=24;)f-=24,h++;for(o=s&&2===c?g:v[c-1];h>o;)h-=o,c++,c>12&&(c-=12,i++),o=s&&2===c?g:v[c-1];for(;0>_;)_+=60,f--;for(;0>f;)f+=24,h--;for(;1>h;)c--,1>c&&(c+=12,i--),o=s&&2===c?g:v[c-1],h+=o;var G=p(i,c,h,f,_,S,I);return n(t)?(m(G[0],G[1],t),d(t)):t=new M(G[0],G[1],u.UTC),W&&M.addSeconds(t,1,t),t},M.now=function(e){return M.fromDate(new Date,e)};var I=new M(0,0,u.TAI);return M.toGregorianDate=function(e,t){var i=!1,r=h(e,I);n(r)||(M.addSeconds(e,-1,I),r=h(I,I),i=!0);var a=r.dayNumber,s=r.secondsOfDay;s>=43200&&(a+=1);var u=0|a+68569,c=0|4*u/146097;u=0|u-(0|(146097*c+3)/4);var d=0|4e3*(u+1)/1461001;u=0|u-(0|1461*d/4)+31;var m=0|80*u/2447,p=0|u-(0|2447*m/80);u=0|m/11;var f=0|m+2-12*u,v=0|100*(c-49)+d+u,g=0|s/l.SECONDS_PER_HOUR,_=s-g*l.SECONDS_PER_HOUR,y=0|_/l.SECONDS_PER_MINUTE;_-=y*l.SECONDS_PER_MINUTE;var C=0|_,w=(_-C)/l.SECONDS_PER_MILLISECOND;return g+=12,g>23&&(g-=24),i&&(C+=1),n(t)?(t.year=v,t.month=f,t.day=p,t.hour=g,t.minute=y,t.second=C,t.millisecond=w,t.isLeapSecond=i,t):new o(v,f,p,g,y,C,w,i)},M.toDate=function(e){var t=M.toGregorianDate(e,f),i=t.second;return t.isLeapSecond&&(i-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,i,t.millisecond))},M.toIso8601=function(t,i){var r,o=M.toGregorianDate(t,o);return n(i)||0===o.millisecond?n(i)&&0!==i?(r=(.01*o.millisecond).toFixed(i).replace(".","").slice(0,i),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,r)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(r=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,r))},M.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new M(e.dayNumber,e.secondsOfDay,u.TAI):void 0},M.compare=function(e,t){var i=e.dayNumber-t.dayNumber;return 0!==i?i:e.secondsOfDay-t.secondsOfDay},M.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},M.equalsEpsilon=function(e,t,i){return e===t||n(e)&&n(t)&&Math.abs(M.secondsDifference(e,t))<=i},M.totalDays=function(e){return e.dayNumber+e.secondsOfDay/l.SECONDS_PER_DAY},M.secondsDifference=function(e,t){var i=(e.dayNumber-t.dayNumber)*l.SECONDS_PER_DAY;return i+(e.secondsOfDay-t.secondsOfDay)},M.daysDifference=function(e,t){var i=e.dayNumber-t.dayNumber,n=(e.secondsOfDay-t.secondsOfDay)/l.SECONDS_PER_DAY;return i+n},M.computeTaiMinusUtc=function(e){_.julianDate=e;var i=M.leapSeconds,n=t(i,_,c);return 0>n&&(n=~n,--n,0>n&&(n=0)),i[n].offset},M.addSeconds=function(e,t,i){return m(e.dayNumber,e.secondsOfDay+t,i)},M.addMinutes=function(e,t,i){var n=e.secondsOfDay+t*l.SECONDS_PER_MINUTE;return m(e.dayNumber,n,i)},M.addHours=function(e,t,i){var n=e.secondsOfDay+t*l.SECONDS_PER_HOUR;return m(e.dayNumber,n,i)},M.addDays=function(e,t,i){var n=e.dayNumber+t;return m(n,e.secondsOfDay,i)},M.lessThan=function(e,t){return M.compare(e,t)<0},M.lessThanOrEquals=function(e,t){return M.compare(e,t)<=0},M.greaterThan=function(e,t){return M.compare(e,t)>0},M.greaterThanOrEquals=function(e,t){return M.compare(e,t)>=0},M.prototype.clone=function(e){return M.clone(this,e)},M.prototype.equals=function(e){return M.equals(this,e)},M.prototype.equalsEpsilon=function(e,t){return M.equalsEpsilon(this,e,t)},M.prototype.toString=function(){return M.toIso8601(this)},M.leapSeconds=[new s(new M(2441317,43210,u.TAI),10),new s(new M(2441499,43211,u.TAI),11),new s(new M(2441683,43212,u.TAI),12),new s(new M(2442048,43213,u.TAI),13),new s(new M(2442413,43214,u.TAI),14),new s(new M(2442778,43215,u.TAI),15),new s(new M(2443144,43216,u.TAI),16),new s(new M(2443509,43217,u.TAI),17),new s(new M(2443874,43218,u.TAI),18),new s(new M(2444239,43219,u.TAI),19),new s(new M(2444786,43220,u.TAI),20),new s(new M(2445151,43221,u.TAI),21),new s(new M(2445516,43222,u.TAI),22),new s(new M(2446247,43223,u.TAI),23),new s(new M(2447161,43224,u.TAI),24),new s(new M(2447892,43225,u.TAI),25),new s(new M(2448257,43226,u.TAI),26),new s(new M(2448804,43227,u.TAI),27),new s(new M(2449169,43228,u.TAI),28),new s(new M(2449534,43229,u.TAI),29),new s(new M(2450083,43230,u.TAI),30),new s(new M(2450630,43231,u.TAI),31),new s(new M(2451179,43232,u.TAI),32),new s(new M(2453736,43233,u.TAI),33),new s(new M(2454832,43234,u.TAI),34),new s(new M(2456109,43235,u.TAI),35)],M}),define("Cesium/Core/TimeInterval",["./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./JulianDate"],function(e,t,i,n,r,o){"use strict";var a=function(i){i=e(i,e.EMPTY_OBJECT),this.start=t(i.start)?o.clone(i.start):new o,this.stop=t(i.stop)?o.clone(i.stop):new o,this.data=i.data,this.isStartIncluded=e(i.isStartIncluded,!0),this.isStopIncluded=e(i.isStopIncluded,!0)};i(a.prototype,{isEmpty:{get:function(){var e=o.compare(this.stop,this.start);return 0>e||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var s={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};return a.fromIso8601=function(i,n){var r=i.iso8601.split("/"),l=o.fromIso8601(r[0]),u=o.fromIso8601(r[1]),c=e(i.isStartIncluded,!0),d=e(i.isStopIncluded,!0),h=i.data;return t(n)?(n.start=l,n.stop=u,n.isStartIncluded=c,n.isStopIncluded=d,n.data=h,n):(s.start=l,s.stop=u,s.isStartIncluded=c,s.isStopIncluded=d,s.data=h,new a(s))},a.toIso8601=function(e,t){return o.toIso8601(e.start,t)+"/"+o.toIso8601(e.stop,t)},a.clone=function(e,i){return t(e)?t(i)?(i.start=e.start,i.stop=e.stop,i.isStartIncluded=e.isStartIncluded,i.isStopIncluded=e.isStopIncluded,i.data=e.data,i):new a(e):void 0},a.equals=function(e,i,n){return e===i||t(e)&&t(i)&&(e.isEmpty&&i.isEmpty||e.isStartIncluded===i.isStartIncluded&&e.isStopIncluded===i.isStopIncluded&&o.equals(e.start,i.start)&&o.equals(e.stop,i.stop)&&(e.data===i.data||t(n)&&n(e.data,i.data)))},a.equalsEpsilon=function(e,i,n,r){return e===i||t(e)&&t(i)&&(e.isEmpty&&i.isEmpty||e.isStartIncluded===i.isStartIncluded&&e.isStopIncluded===i.isStopIncluded&&o.equalsEpsilon(e.start,i.start,n)&&o.equalsEpsilon(e.stop,i.stop,n)&&(e.data===i.data||t(r)&&r(e.data,i.data)))},a.intersect=function(e,i,n,r){if(!t(i))return a.clone(a.EMPTY,n);var s=e.start,l=e.stop,u=i.start,c=i.stop,d=o.greaterThanOrEquals(u,s)&&o.greaterThanOrEquals(l,u),h=!d&&o.lessThanOrEquals(u,s)&&o.lessThanOrEquals(s,c);if(!d&&!h)return a.clone(a.EMPTY,n);var m=e.isStartIncluded,p=e.isStopIncluded,f=i.isStartIncluded,v=i.isStopIncluded,g=o.lessThan(l,c);return n.start=d?u:s,n.isStartIncluded=m&&f||!o.equals(u,s)&&(d&&f||h&&m),n.stop=g?l:c,n.isStopIncluded=g?p:p&&v||!o.equals(c,l)&&v,n.data=t(r)?r(e.data,i.data):e.data,n},a.contains=function(e,t){if(e.isEmpty)return!1;var i=o.compare(e.start,t);if(0===i)return e.isStartIncluded;var n=o.compare(t,e.stop);return 0===n?e.isStopIncluded:0>i&&0>n},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e,t){return a.equals(this,e,t)},a.prototype.equalsEpsilon=function(e,t,i){return a.equalsEpsilon(this,e,t,i)},a.prototype.toString=function(){return a.toIso8601(this)},a.EMPTY=r(new a({start:new o,stop:new o,isStartIncluded:!1,isStopIncluded:!1})),a}),define("Cesium/Core/Iso8601",["./freezeObject","./JulianDate","./TimeInterval"],function(e,t,i){"use strict";var n=e(t.fromIso8601("0000-01-01T00:00:00Z")),r=e(t.fromIso8601("9999-12-31T24:00:00Z")),o=e(new i({start:n,stop:r})),a={MINIMUM_VALUE:n,MAXIMUM_VALUE:r,MAXIMUM_INTERVAL:o};return a}),define("Cesium/Core/LagrangePolynomialApproximation",["./defined"],function(e){"use strict";var t={type:"Lagrange"};return t.getRequiredDataPoints=function(e){return Math.max(e+1,2)},t.interpolateOrderZero=function(t,i,n,r,o){e(o)||(o=new Array(r));var a,s,l=i.length;for(a=0;r>a;a++)o[a]=0;for(a=0;l>a;a++){var u=1;for(s=0;l>s;s++)if(s!==a){var c=i[a]-i[s];u*=(t-i[s])/c}for(s=0;r>s;s++)o[s]+=u*n[a*r+s]}return o},t}),define("Cesium/Core/LinearApproximation",["./defined","./DeveloperError"],function(e){"use strict";var t={type:"Linear"};return t.getRequiredDataPoints=function(){return 2},t.interpolateOrderZero=function(t,i,n,r,o){e(o)||(o=new Array(r));var a,s,l,u=i[0],c=i[1];for(a=0;r>a;a++)s=n[a],l=n[a+r],o[a]=((l-s)*t+c*s-u*l)/(c-u);return o},t}),define("Cesium/Core/clone",["./defaultValue"],function(e){"use strict";var t=function(i,n){if(null===i||"object"!=typeof i)return i;n=e(n,!1);var r=new i.constructor;for(var o in i)if(i.hasOwnProperty(o)){var a=i[o];n&&(a=t(a,n)),r[o]=a}return r};return t}),function(e){"use strict";e("Cesium/ThirdParty/when",[],function(){function e(e,i,n,r){return t(e).then(i,n,r)}function t(e){var t,i;return e instanceof n?t=e:s(e)?(i=a(),e.then(function(e){i.resolve(e)},function(e){i.reject(e)},function(e){i.progress(e)}),t=i.promise):t=r(e),t}function i(t){return e(t,o)}function n(e){this.then=e}function r(e){var i=new n(function(i){try{return t(i?i(e):e)}catch(n){return o(n)}});return i}function o(e){var i=new n(function(i,n){try{return n?t(n(e)):o(e)}catch(r){return o(r)}});return i}function a(){function e(e,t,i){return h(e,t,i)}function i(e){return p(e)}function r(e){return p(o(e))}function s(e){return m(e)}var l,u,c,d,h,m,p;return u=new n(e),l={then:e,resolve:i,reject:r,progress:s,promise:u,resolver:{resolve:i,reject:r,progress:s}},c=[],d=[],h=function(e,t,i){var n,r;return n=a(),r="function"==typeof i?function(e){try{n.progress(i(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},c.push(function(i){i.then(e,t).then(n.resolve,n.reject,r)}),d.push(r),n.promise},m=function(e){return f(d,e),e},p=function(e){return e=t(e),h=e.then,p=t,m=g,f(c,e),d=c=w,e},l}function s(e){return e&&"function"==typeof e.then}function l(t,i,n,r,o){return v(2,arguments),e(t,function(t){function s(e){f(e)}function l(e){p(e)}var u,c,d,h,m,p,f,v,_,y;if(_=t.length>>>0,u=Math.max(0,Math.min(i,_)),d=[],c=_-u+1,h=[],m=a(),u)for(v=m.progress,f=function(e){h.push(e),--c||(p=f=g,m.reject(h))},p=function(e){d.push(e),--u||(p=f=g,m.resolve(d))},y=0;_>y;++y)y in t&&e(t[y],l,s,v);else m.resolve(d);return m.then(n,r,o)})}function u(e,t,i,n){function r(e){return t?t(e[0]):e[0]}return l(e,1,r,i,n)}function c(e,t,i,n){return v(1,arguments),h(e,_).then(t,i,n)}function d(){return h(arguments,_)}function h(t,i){return e(t,function(t){var n,r,o,s,l,u;if(o=r=t.length>>>0,n=[],u=a(),o)for(s=function(t,r){e(t,i).then(function(e){n[r]=e,--o||u.resolve(n)},u.reject)},l=0;r>l;l++)l in t?s(t[l],l):--o;else u.resolve(n);return u.promise})}function m(t,i){var n=C.call(arguments,1);return e(t,function(t){var r;return r=t.length,n[0]=function(t,n,o){return e(t,function(t){return e(n,function(e){return i(t,e,o,r)})})},y.apply(t,n)})}function p(t,i,n){var r=arguments.length>2;return e(t,function(e){return e=r?n:e,i.resolve(e),e},function(e){return i.reject(e),o(e)},i.progress)}function f(e,t){for(var i,n=0;i=e[n++];)i(t)}function v(e,t){for(var i,n=t.length;n>e;)if(i=t[--n],null!=i&&"function"!=typeof i)throw new Error("arg "+n+" must be a function")}function g(){}function _(e){return e}var y,C,w;return e.defer=a,e.resolve=t,e.reject=i,e.join=d,e.all=c,e.map=h,e.reduce=m,e.any=u,e.some=l,e.chain=p,e.isPromise=s,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(w,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return c(t,function(t){return e.apply(w,t)})})}},C=[].slice,y=[].reduce||function(e){var t,i,n,r,o;if(o=0,t=Object(this),r=t.length>>>0,i=arguments,i.length<=1)for(;;){if(o in t){n=t[o++];break}if(++o>=r)throw new TypeError}else n=i[1];for(;r>o;++o)o in t&&(n=e(n,t[o],o,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Cesium/Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var i=e.split("\r\n"),n=0;n<i.length;++n){var r=i[n],o=r.indexOf(": ");if(o>0){var a=r.substring(0,o),s=r.substring(o+2);t[a]=s}}return t};return e}),define("Cesium/Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var i=function(e,i,n){this.statusCode=e,this.response=i,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return i.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},i}),define("Cesium/Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(i){t=i.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Cesium/Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,i,n,r,o){"use strict";function a(e,t){var i=decodeURIComponent(t);return e?atob(i):i}function s(e,t){for(var i=a(e,t),n=new ArrayBuffer(i.length),r=new Uint8Array(n),o=0;o<i.length;o++)r[o]=i.charCodeAt(o);return n}function l(e,i){i=t(i,"");var r=e[1],o=!!e[2],l=e[3];switch(i){case"":case"text":return a(o,l);case"arraybuffer":return s(o,l);case"blob":var u=s(o,l);return new Blob([u],{type:r});case"document":var c=new DOMParser;return c.parseFromString(a(o,l),r);case"json":return JSON.parse(a(o,l));default:throw new n("Unhandled responseType: "+i)}}var u=function(i){i=t(i,t.EMPTY_OBJECT);var n=i.responseType,r=t(i.method,"GET"),o=i.data,a=i.headers,s=i.overrideMimeType;return e(i.url,function(t){var i=e.defer();return u.load(t,n,r,o,a,i,s),i.promise})},c=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,t,n,a,s,u,d){var h=c.exec(e);if(null!==h)return u.resolve(l(h,t)),void 0;var m=new XMLHttpRequest;if(i(d)&&i(m.overrideMimeType)&&m.overrideMimeType(d),m.open(n,e,!0),i(s))for(var p in s)s.hasOwnProperty(p)&&m.setRequestHeader(p,s[p]);i(t)&&(m.responseType=t),m.onload=function(){200===m.status?i(m.response)?u.resolve(m.response):i(m.responseXML)&&m.responseXML.hasChildNodes()?u.resolve(m.responseXML):i(m.responseText)?u.resolve(m.responseText):u.reject(new o("unknown XMLHttpRequest response type.")):u.reject(new r(m.status,m.response,m.getAllResponseHeaders()))},m.onerror=function(){u.reject(new r)},m.send(a)},u.defaultLoad=u.load,u}),define("Cesium/Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,i){return e({url:t,headers:i})};return t}),define("Cesium/Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,i,n){"use strict";var r={Accept:"application/json,*/*;q=0.01"},o=function(i,o){return t(o)?t(o.Accept)||(o=e(o),o.Accept=r.Accept):o=r,n(i,o).then(function(e){return JSON.parse(e)})};return o}),define("Cesium/Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r,o){"use strict";function a(e){for(var t=0,i=0;9>i;++i){var n=e[i];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,i=0;3>i;++i){var n=e[u.getElementIndex(m[i],h[i])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var i=o.EPSILON15,n=0,r=1,a=0;3>a;++a){var s=Math.abs(e[u.getElementIndex(m[a],h[a])]);s>n&&(r=a,n=s)}var l=1,c=0,d=h[r],p=m[r];if(Math.abs(e[u.getElementIndex(p,d)])>i){var f,v=e[u.getElementIndex(p,p)],g=e[u.getElementIndex(d,d)],_=e[u.getElementIndex(p,d)],y=(v-g)/2/_;f=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),l=1/Math.sqrt(1+f*f),c=f*l}return t=u.clone(u.IDENTITY,t),t[u.getElementIndex(d,d)]=t[u.getElementIndex(p,p)]=l,t[u.getElementIndex(p,d)]=c,t[u.getElementIndex(d,p)]=-c,t}var u=function(e,i,n,r,o,a,s,l,u){this[0]=t(e,0),this[1]=t(r,0),this[2]=t(s,0),this[3]=t(i,0),this[4]=t(o,0),this[5]=t(l,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(u,0)};u.packedLength=9,u.pack=function(e,i,n){n=t(n,0),i[n++]=e[0],i[n++]=e[1],i[n++]=e[2],i[n++]=e[3],i[n++]=e[4],i[n++]=e[5],i[n++]=e[6],i[n++]=e[7],i[n++]=e[8]},u.unpack=function(e,n,r){return n=t(n,0),i(r)||(r=new u),r[0]=e[n++],r[1]=e[n++],r[2]=e[n++],r[3]=e[n++],r[4]=e[n++],r[5]=e[n++],r[6]=e[n++],r[7]=e[n++],r[8]=e[n++],r},u.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new u(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},u.fromArray=function(e,n,r){return n=t(n,0),i(r)||(r=new u),r[0]=e[n],r[1]=e[n+1],r[2]=e[n+2],r[3]=e[n+3],r[4]=e[n+4],r[5]=e[n+5],r[6]=e[n+6],r[7]=e[n+7],r[8]=e[n+8],r},u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},u.fromQuaternion=function(e,t){var n=e.x*e.x,r=e.x*e.y,o=e.x*e.z,a=e.x*e.w,s=e.y*e.y,l=e.y*e.z,c=e.y*e.w,d=e.z*e.z,h=e.z*e.w,m=e.w*e.w,p=n-s-d+m,f=2*(r-h),v=2*(o+c),g=2*(r+h),_=-n+s-d+m,y=2*(l-a),C=2*(o-c),w=2*(l+a),E=-n-s+d+m;return i(t)?(t[0]=p,t[1]=g,t[2]=C,t[3]=f,t[4]=_,t[5]=w,t[6]=v,t[7]=y,t[8]=E,t):new u(p,f,v,g,_,y,C,w,E)},u.fromScale=function(e,t){return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new u(e.x,0,0,0,e.y,0,0,0,e.z)
},u.fromUniformScale=function(e,t){return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new u(e,0,0,0,e,0,0,0,e)},u.fromCrossProduct=function(e,t){return i(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new u(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},u.fromRotationX=function(e,t){var n=Math.cos(e),r=Math.sin(e);return i(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=r,t[6]=0,t[7]=-r,t[8]=n,t):new u(1,0,0,0,n,-r,0,r,n)},u.fromRotationY=function(e,t){var n=Math.cos(e),r=Math.sin(e);return i(t)?(t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=1,t[5]=0,t[6]=r,t[7]=0,t[8]=n,t):new u(n,0,r,0,1,0,-r,0,n)},u.fromRotationZ=function(e,t){var n=Math.cos(e),r=Math.sin(e);return i(t)?(t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new u(n,-r,0,r,n,0,0,0,1)},u.toArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},u.getElementIndex=function(e,t){return 3*e+t},u.getColumn=function(e,t,i){var n=3*t,r=e[n],o=e[n+1],a=e[n+2];return i.x=r,i.y=o,i.z=a,i},u.setColumn=function(e,t,i,n){n=u.clone(e,n);var r=3*t;return n[r]=i.x,n[r+1]=i.y,n[r+2]=i.z,n},u.getRow=function(e,t,i){var n=e[t],r=e[t+3],o=e[t+6];return i.x=n,i.y=r,i.z=o,i},u.setRow=function(e,t,i,n){return n=u.clone(e,n),n[t]=i.x,n[t+3]=i.y,n[t+6]=i.z,n};var c=new e;u.getScale=function(t,i){return i.x=e.magnitude(e.fromElements(t[0],t[1],t[2],c)),i.y=e.magnitude(e.fromElements(t[3],t[4],t[5],c)),i.z=e.magnitude(e.fromElements(t[6],t[7],t[8],c)),i};var d=new e;u.getMaximumScale=function(t){return u.getScale(t,d),e.maximumComponent(d)},u.multiply=function(e,t,i){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],r=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],o=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],u=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],c=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return i[0]=n,i[1]=r,i[2]=o,i[3]=a,i[4]=s,i[5]=l,i[6]=u,i[7]=c,i[8]=d,i},u.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i},u.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i},u.multiplyByVector=function(e,t,i){var n=t.x,r=t.y,o=t.z,a=e[0]*n+e[3]*r+e[6]*o,s=e[1]*n+e[4]*r+e[7]*o,l=e[2]*n+e[5]*r+e[8]*o;return i.x=a,i.y=s,i.z=l,i},u.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i},u.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},u.transpose=function(e,t){var i=e[0],n=e[3],r=e[6],o=e[1],a=e[4],s=e[7],l=e[2],u=e[5],c=e[8];return t[0]=i,t[1]=n,t[2]=r,t[3]=o,t[4]=a,t[5]=s,t[6]=l,t[7]=u,t[8]=c,t};var h=[1,0,0],m=[2,2,1],p=new u,f=new u;return u.computeEigenDecomposition=function(e,t){var n=o.EPSILON20,r=10,c=0,d=0;i(t)||(t={});for(var h=t.unitary=u.clone(u.IDENTITY,t.unitary),m=t.diagonal=u.clone(e,t.diagonal),v=n*a(m);r>d&&s(m)>v;)l(m,p),u.transpose(p,f),u.multiply(m,p,m),u.multiply(f,m,m),u.multiply(h,p,h),++c>2&&(++d,c=0);return t},u.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},u.determinant=function(e){var t=e[0],i=e[3],n=e[6],r=e[1],o=e[4],a=e[7],s=e[2],l=e[5],u=e[8];return t*(o*u-l*a)+r*(l*n-i*u)+s*(i*a-o*n)},u.inverse=function(e,t){var i=e[0],r=e[1],a=e[2],s=e[3],l=e[4],c=e[5],d=e[6],h=e[7],m=e[8],p=u.determinant(e);if(Math.abs(p)<=o.EPSILON15)throw new n("matrix is not invertible");t[0]=l*m-h*c,t[1]=h*a-r*m,t[2]=r*c-l*a,t[3]=d*c-s*m,t[4]=i*m-d*a,t[5]=s*a-i*c,t[6]=s*h-d*l,t[7]=d*r-i*h,t[8]=i*l-s*r;var f=1/p;return u.multiplyByScalar(t,f,t)},u.equals=function(e,t){return e===t||i(e)&&i(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},u.equalsEpsilon=function(e,t,n){return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},u.IDENTITY=r(new u(1,0,0,0,1,0,0,0,1)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN1ROW0=3,u.COLUMN1ROW1=4,u.COLUMN1ROW2=5,u.COLUMN2ROW0=6,u.COLUMN2ROW1=7,u.COLUMN2ROW2=8,u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},u}),define("Cesium/Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(e,i,n,r){this.x=t(e,0),this.y=t(i,0),this.z=t(n,0),this.w=t(r,0)},u=new e;l.fromAxisAngle=function(t,n,r){var o=n/2,a=Math.sin(o);u=e.normalize(t,u);var s=u.x*a,c=u.y*a,d=u.z*a,h=Math.cos(o);return i(r)?(r.x=s,r.y=c,r.z=d,r.w=h,r):new l(s,c,d,h)};var c=[1,2,0],d=new Array(3);l.fromRotationMatrix=function(e,t){var n,r,o,a,u,h=e[s.COLUMN0ROW0],m=e[s.COLUMN1ROW1],p=e[s.COLUMN2ROW2],f=h+m+p;if(f>0)n=Math.sqrt(f+1),u=.5*n,n=.5/n,r=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*n,o=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*n,a=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*n;else{var v=c,g=0;m>h&&(g=1),p>h&&p>m&&(g=2);var _=v[g],y=v[_];n=Math.sqrt(e[s.getElementIndex(g,g)]-e[s.getElementIndex(_,_)]-e[s.getElementIndex(y,y)]+1);var C=d;C[g]=.5*n,n=.5/n,u=(e[s.getElementIndex(y,_)]-e[s.getElementIndex(_,y)])*n,C[_]=(e[s.getElementIndex(_,g)]+e[s.getElementIndex(g,_)])*n,C[y]=(e[s.getElementIndex(y,g)]+e[s.getElementIndex(g,y)])*n,r=-C[0],o=-C[1],a=-C[2]}return i(t)?(t.x=r,t.y=o,t.z=a,t.w=u,t):new l(r,o,a,u)};var h=new l;l.fromHeadingPitchRoll=function(t,i,n,r){var o=l.fromAxisAngle(e.UNIT_X,n,h),a=l.fromAxisAngle(e.UNIT_Y,-i,r);r=l.multiply(a,o,a);var s=l.fromAxisAngle(e.UNIT_Z,-t,h);return l.multiply(s,r,r)};var m=new e,p=new e,f=new l,v=new l,g=new l;l.packedLength=4,l.pack=function(e,i,n){n=t(n,0),i[n++]=e.x,i[n++]=e.y,i[n++]=e.z,i[n]=e.w},l.unpack=function(e,n,r){return n=t(n,0),i(r)||(r=new l),r.x=e[n],r.y=e[n+1],r.z=e[n+2],r.w=e[n+3],r},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,i,n){l.unpack(e,4*i,g),l.conjugate(g,g);for(var r=0,o=i-t+1;o>r;r++){var a=3*r;l.unpack(e,4*(t+r),f),l.multiply(f,g,f),f.w<0&&l.negate(f,f),l.computeAxis(f,m);var s=l.computeAngle(f);n[a]=m.x*s,n[a+1]=m.y*s,n[a+2]=m.z*s}},l.unpackInterpolationResult=function(t,n,r,o,a){i(a)||(a=new l),e.fromArray(t,0,p);var s=e.magnitude(p);return l.unpack(n,4*o,v),0===s?l.clone(l.IDENTITY,f):l.fromAxisAngle(p,s,f),l.multiply(f,v,a)},l.clone=function(e,t){return i(e)?i(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w):void 0},l.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},l.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,t){var i=1/l.magnitude(e),n=e.x*i,r=e.y*i,o=e.z*i,a=e.w*i;return t.x=n,t.y=r,t.z=o,t.w=a,t},l.inverse=function(e,t){var i=l.magnitudeSquared(e);return t=l.conjugate(e,t),l.multiplyByScalar(t,1/i,t)},l.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},l.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},l.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},l.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},l.multiply=function(e,t,i){var n=e.x,r=e.y,o=e.z,a=e.w,s=t.x,l=t.y,u=t.z,c=t.w,d=a*s+n*c+r*u-o*l,h=a*l-n*u+r*c+o*s,m=a*u+n*l-r*s+o*c,p=a*c-n*s-r*l-o*u;return i.x=d,i.y=h,i.z=m,i.w=p,i},l.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},l.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},l.computeAxis=function(e,t){var i=e.w;if(Math.abs(i-1)<a.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-i*i);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},l.computeAngle=function(e){return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var _=new l;l.lerp=function(e,t,i,n){return _=l.multiplyByScalar(t,i,_),n=l.multiplyByScalar(e,1-i,n),l.add(_,n,n)};var y=new l,C=new l,w=new l;l.slerp=function(e,t,i,n){var r=l.dot(e,t),o=t;if(0>r&&(r=-r,o=y=l.negate(t,y)),1-r<a.EPSILON6)return l.lerp(e,o,i,n);var s=Math.acos(r);return C=l.multiplyByScalar(e,Math.sin((1-i)*s),C),w=l.multiplyByScalar(o,Math.sin(i*s),w),n=l.add(C,w,n),l.multiplyByScalar(n,1/Math.sin(s),n)},l.log=function(t,i){var n=a.acosClamped(t.w),r=0;return 0!==n&&(r=n/Math.sin(n)),e.multiplyByScalar(t,r,i)},l.exp=function(t,i){var n=e.magnitude(t),r=0;return 0!==n&&(r=Math.sin(n)/n),i.x=t.x*r,i.y=t.y*r,i.z=t.z*r,i.w=Math.cos(n),i};var E=new e,b=new e,S=new l,x=new l;l.computeInnerQuadrangle=function(t,i,n,r){var o=l.conjugate(i,S);l.multiply(o,n,x);var a=l.log(x,E);l.multiply(o,t,x);var s=l.log(x,b);return e.add(a,s,a),e.multiplyByScalar(a,.25,a),e.negate(a,a),l.exp(a,S),l.multiply(i,S,r)},l.squad=function(e,t,i,n,r,o){var a=l.slerp(e,t,r,S),s=l.slerp(i,n,r,x);return l.slerp(a,s,2*r*(1-r),o)};for(var T=new l,P=1.9011074535173003,A=r.supportsTypedArrays()?new Float32Array(8):[],M=r.supportsTypedArrays()?new Float32Array(8):[],I=r.supportsTypedArrays()?new Float32Array(8):[],D=r.supportsTypedArrays()?new Float32Array(8):[],O=0;7>O;++O){var R=O+1,L=2*R+1;A[O]=1/(R*L),M[O]=R/L}return A[7]=P/136,M[7]=8*P/17,l.fastSlerp=function(e,t,i,n){var r,o=l.dot(e,t);o>=0?r=1:(r=-1,o=-o);for(var a=o-1,s=1-i,u=i*i,c=s*s,d=7;d>=0;--d)I[d]=(A[d]*u-M[d])*a,D[d]=(A[d]*c-M[d])*a;var h=r*i*(1+I[0]*(1+I[1]*(1+I[2]*(1+I[3]*(1+I[4]*(1+I[5]*(1+I[6]*(1+I[7])))))))),m=s*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),p=l.multiplyByScalar(e,m,T);return l.multiplyByScalar(t,h,n),l.add(p,n,n)},l.fastSquad=function(e,t,i,n,r,o){var a=l.fastSlerp(e,t,r,S),s=l.fastSlerp(i,n,r,x);return l.fastSlerp(a,s,2*r*(1-r),o)},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,t,n){return e===t||i(e)&&i(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},l.ZERO=o(new l(0,0,0,0)),l.IDENTITY=o(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),define("Cesium/Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(e,i,n,r){this.west=t(e,0),this.south=t(i,0),this.east=t(n,0),this.north=t(r,0)};n(l.prototype,{width:{get:function(){return l.computeWidth(this)}},height:{get:function(){return l.computeHeight(this)}}}),l.packedLength=4,l.pack=function(e,i,n){n=t(n,0),i[n++]=e.west,i[n++]=e.south,i[n++]=e.east,i[n]=e.north},l.unpack=function(e,n,r){return n=t(n,0),i(r)||(r=new l),r.west=e[n++],r.south=e[n++],r.east=e[n++],r.north=e[n],r},l.computeWidth=function(e){var t=e.east,i=e.west;return i>t&&(t+=s.TWO_PI),t-i},l.computeHeight=function(e){return e.north-e.south},l.fromDegrees=function(e,n,r,o,a){return e=s.toRadians(t(e,0)),n=s.toRadians(t(n,0)),r=s.toRadians(t(r,0)),o=s.toRadians(t(o,0)),i(a)?(a.west=e,a.south=n,a.east=r,a.north=o,a):new l(e,n,r,o)},l.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,r=-Number.MAX_VALUE,o=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=0,u=e.length;u>s;s++){var c=e[s];n=Math.min(n,c.longitude),r=Math.max(r,c.longitude),o=Math.min(o,c.latitude),a=Math.max(a,c.latitude)}return i(t)?(t.west=n,t.south=o,t.east=r,t.north=a,t):new l(n,o,r,a)},l.packedLength=4,l.pack=function(e,i,n){n=t(n,0),i[n++]=e.west,i[n++]=e.south,i[n++]=e.east,i[n]=e.north},l.unpack=function(e,n,r){return n=t(n,0),i(r)||(r=new l),r.west=e[n++],r.south=e[n++],r.east=e[n++],r.north=e[n],r},l.clone=function(e,t){return i(e)?i(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new l(e.west,e.south,e.east,e.north):void 0},l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},l.prototype.equalsEpsilon=function(e,t){return i(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},l.validate=function(){},l.southwest=function(t,n){return i(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},l.northwest=function(t,n){return i(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},l.northeast=function(t,n){return i(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},l.southeast=function(t,n){return i(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},l.center=function(t,n){var r=t.east,o=t.west;o>r&&(r+=s.TWO_PI);var a=s.negativePiToPi(.5*(o+r)),l=.5*(t.south+t.north);return i(n)?(n.longitude=a,n.latitude=l,n.height=0,n):new e(a,l)},l.intersection=function(e,t,n){var r=e.east,o=e.west,a=t.east,u=t.west;o>r&&a>0?r+=s.TWO_PI:u>a&&r>0&&(a+=s.TWO_PI),o>r&&0>u?u+=s.TWO_PI:u>a&&0>o&&(o+=s.TWO_PI);var c=s.negativePiToPi(Math.max(o,u)),d=s.negativePiToPi(Math.min(r,a));if((e.west<e.east||t.west<t.east)&&c>=d)return void 0;var h=Math.max(e.south,t.south),m=Math.min(e.north,t.north);return h>=m?void 0:i(n)?(n.west=c,n.south=h,n.east=d,n.north=m,n):new l(c,h,d,m)},l.contains=function(e,t){var i=t.longitude,n=t.latitude,r=e.west,o=e.east;return r>o&&(o+=s.TWO_PI,0>i&&(i+=s.TWO_PI)),(i>r||s.equalsEpsilon(i,r,s.EPSILON14))&&(o>i||s.equalsEpsilon(i,o,s.EPSILON14))&&n>=e.south&&n<=e.north};var u=new e;return l.subsample=function(e,n,r,a){n=t(n,o.WGS84),r=t(r,0),i(a)||(a=[]);var c=0,d=e.north,h=e.south,m=e.east,p=e.west,f=u;f.height=r,f.longitude=p,f.latitude=d,a[c]=n.cartographicToCartesian(f,a[c]),c++,f.longitude=m,a[c]=n.cartographicToCartesian(f,a[c]),c++,f.latitude=h,a[c]=n.cartographicToCartesian(f,a[c]),c++,f.longitude=p,a[c]=n.cartographicToCartesian(f,a[c]),c++,f.latitude=0>d?d:h>0?h:0;for(var v=1;8>v;++v)f.longitude=-Math.PI+v*s.PI_OVER_TWO,l.contains(e,f)&&(a[c]=n.cartographicToCartesian(f,a[c]),c++);return 0===f.latitude&&(f.longitude=p,a[c]=n.cartographicToCartesian(f,a[c]),c++,f.longitude=m,a[c]=n.cartographicToCartesian(f,a[c]),c++),a.length=c,a},l.MAX_VALUE=a(new l(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),l}),define("Cesium/Core/ReferenceFrame",["./freezeObject"],function(e){"use strict";var t={FIXED:0,INERTIAL:1};return e(t)}),define("Cesium/Core/Spherical",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var i=function(t,i,n){this.clock=e(t,0),this.cone=e(i,0),this.magnitude=e(n,1)};return i.fromCartesian3=function(e,n){var r=e.x,o=e.y,a=e.z,s=r*r+o*o;return t(n)||(n=new i),n.clock=Math.atan2(o,r),n.cone=Math.atan2(Math.sqrt(s),a),n.magnitude=Math.sqrt(s+a*a),n},i.clone=function(e,n){return t(e)?t(n)?(n.clock=e.clock,n.cone=e.cone,n.magnitude=e.magnitude,n):new i(e.clock,e.cone,e.magnitude):void 0},i.normalize=function(e,n){return t(n)?(n.clock=e.clock,n.cone=e.cone,n.magnitude=1,n):new i(e.clock,e.cone,1)},i.equals=function(e,i){return e===i||t(e)&&t(i)&&e.clock===i.clock&&e.cone===i.cone&&e.magnitude===i.magnitude},i.equalsEpsilon=function(i,n,r){return r=e(r,0),i===n||t(i)&&t(n)&&Math.abs(i.clock-n.clock)<=r&&Math.abs(i.cone-n.cone)<=r&&Math.abs(i.magnitude-n.magnitude)<=r},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"},i}),define("Cesium/Core/TimeIntervalCollection",["./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./Event","./JulianDate","./TimeInterval"],function(e,t,i,n,r,o,a,s){"use strict";function l(e,t){return a.compare(e.start,t.start)}var u=function(e){if(this._intervals=[],this._changedEvent=new o,i(e))for(var t=e.length,n=0;t>n;n++)this.addInterval(e[n])};n(u.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0===e.length?!1:e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0===t?!1:e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),u.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof u))return!1;var i=this._intervals,n=e._intervals,r=i.length;if(r!==n.length)return!1;for(var o=0;r>o;o++)if(!s.equals(i[o],n[o],t))return!1;return!0},u.prototype.get=function(e){return this._intervals[e]},u.prototype.removeAll=function(){this._intervals.length>0&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},u.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},u.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},u.prototype.contains=function(e){return this.indexOf(e)>=0};var c=new s;return u.prototype.indexOf=function(t){var i=this._intervals;c.start=t,c.stop=t;var n=e(i,c,l);return n>=0?i[n].isStartIncluded?n:n>0&&i[n-1].stop.equals(t)&&i[n-1].isStopIncluded?n-1:~n:(n=~n,n>0&&n-1<i.length&&s.contains(i[n-1],t)?n-1:~n)},u.prototype.findInterval=function(e){e=t(e,t.EMPTY_OBJECT);for(var n=e.start,r=e.stop,o=e.isStartIncluded,a=e.isStopIncluded,s=this._intervals,l=0,u=s.length;u>l;l++){var c=s[l];if(!(i(n)&&!c.start.equals(n)||i(r)&&!c.stop.equals(r)||i(o)&&c.isStartIncluded!==o||i(a)&&c.isStopIncluded!==a))return s[l]}return void 0},u.prototype.addInterval=function(t,n){if(!t.isEmpty){var r,o,u=this._intervals;if(0===u.length||a.greaterThan(t.start,u[u.length-1].stop))return u.push(t),this._changedEvent.raiseEvent(this),void 0;for(o=e(u,t,l),0>o?o=~o:o>0&&t.isStartIncluded&&u[o-1].isStartIncluded&&u[o-1].start.equals(t.start)?--o:o<u.length&&!t.isStartIncluded&&u[o].isStartIncluded&&u[o].start.equals(t.start)&&++o,o>0&&(r=a.compare(u[o-1].stop,t.start),(r>0||0===r&&(u[o-1].isStopIncluded||t.isStartIncluded))&&((i(n)?n(u[o-1].data,t.data):u[o-1].data===t.data)?(t=a.greaterThan(t.stop,u[o-1].stop)?new s({start:u[o-1].start,stop:t.stop,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:t.isStopIncluded,data:t.data}):new s({start:u[o-1].start,stop:u[o-1].stop,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:u[o-1].isStopIncluded||t.stop.equals(u[o-1].stop)&&t.isStopIncluded,data:t.data}),u.splice(o-1,1),--o):(r=a.compare(u[o-1].stop,t.stop),r>0||0===r&&u[o-1].isStopIncluded&&!t.isStopIncluded?u.splice(o-1,1,new s({start:u[o-1].start,stop:t.start,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:u[o-1].data}),new s({start:t.stop,stop:u[o-1].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:u[o-1].isStopIncluded,data:u[o-1].data})):u[o-1]=new s({start:u[o-1].start,stop:t.start,isStartIncluded:u[o-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:u[o-1].data}))));o<u.length&&(r=a.compare(t.stop,u[o].start),r>0||0===r&&(t.isStopIncluded||u[o].isStartIncluded));)if(i(n)?n(u[o].data,t.data):u[o].data===t.data)t=new s({start:t.start,stop:a.greaterThan(u[o].stop,t.stop)?u[o].stop:t.stop,isStartIncluded:t.isStartIncluded,isStopIncluded:a.greaterThan(u[o].stop,t.stop)?u[o].isStopIncluded:t.isStopIncluded,data:t.data}),u.splice(o,1);else{if(u[o]=new s({start:t.stop,stop:u[o].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:u[o].isStopIncluded,data:u[o].data}),!u[o].isEmpty)break;u.splice(o,1)}u.splice(o,0,t),this._changedEvent.raiseEvent(this)}},u.prototype.removeInterval=function(t){if(t.isEmpty)return!1;var i=!1,n=this._intervals,r=e(n,t,l);0>r&&(r=~r);var o=t.start,u=t.stop,c=t.isStartIncluded,d=t.isStopIncluded;if(r>0){var h=n[r-1],m=h.stop;(a.greaterThan(m,o)||s.equals(m,o)&&h.isStopIncluded&&c)&&(i=!0,(a.greaterThan(m,u)||h.isStopIncluded&&!d&&s.equals(m,u))&&n.splice(r,0,new s({start:u,stop:m,isStartIncluded:!d,isStopIncluded:h.isStopIncluded,data:h.data})),n[r-1]=new s({start:h.start,stop:o,isStartIncluded:h.isStartIncluded,isStopIncluded:!c,data:h.data}))}var p=n[r];for(r<n.length&&!c&&p.isStartIncluded&&o.equals(p.start)&&(i=!0,n.splice(r,0,new s({start:p.start,stop:p.start,isStartIncluded:!0,isStopIncluded:!0,data:p.data})),++r,p=n[r]);r<n.length&&a.greaterThan(u,p.stop);)i=!0,n.splice(r,1);return r<n.length&&u.equals(p.stop)&&(i=!0,!d&&p.isStopIncluded?(r+1<n.length&&n[r+1].start.equals(u)&&p.data===n[r+1].data?(n.splice(r,1),p=new s({start:p.start,stop:p.stop,isStartIncluded:!0,isStopIncluded:p.isStopIncluded,data:p.data})):p=new s({start:u,stop:u,isStartIncluded:!0,isStopIncluded:!0,data:p.data}),n[r]=p):n.splice(r,1)),r<n.length&&(a.greaterThan(u,p.start)||u.equals(p.start)&&d&&p.isStartIncluded)&&(i=!0,n[r]=new s({start:u,stop:p.stop,isStartIncluded:!d,isStopIncluded:p.isStopIncluded,data:p.data})),i&&this._changedEvent.raiseEvent(this),i},u.prototype.intersect=function(e,t,n){for(var r=0,o=0,l=new u,c=this._intervals,d=e._intervals;r<c.length&&o<d.length;){var h=c[r],m=d[o];if(a.lessThan(h.stop,m.start))++r;else if(a.lessThan(m.stop,h.start))++o;else{if(i(n)||i(t)&&t(h.data,m.data)||!i(t)&&m.data===h.data){var p=s.intersect(h,m,new s,n);p.isEmpty||l.addInterval(p,t)}a.lessThan(h.stop,m.stop)||h.stop.equals(m.stop)&&!h.isStopIncluded&&m.isStopIncluded?++r:++o}}return l},u}),define("Cesium/Scene/HorizontalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,LEFT:1,RIGHT:-1};return e(t)}),define("Cesium/Scene/LabelStyle",["../Core/freezeObject"],function(e){"use strict";var t={FILL:0,OUTLINE:1,FILL_AND_OUTLINE:2};return e(t)}),define("Cesium/Scene/VerticalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,BOTTOM:1,TOP:-1};return e(t)}),define("Cesium/DataSources/ConstantProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,i,n,r){"use strict";var o=function(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new r,this.setValue(e)};return i(o.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),o.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},o.prototype.setValue=function(e){var i=this._value;if(i!==e){var n=t(e),r=n&&"function"==typeof e.clone,o=n&&"function"==typeof e.equals;this._hasClone=r,this._hasEquals=o;var a=!o||!e.equals(i);a&&(this._value=r?e.clone():e,this._definitionChanged.raiseEvent(this))}},o.prototype.equals=function(e){return this===e||e instanceof o&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},o}),define("Cesium/DataSources/createPropertyDescriptor",["../Core/defaultValue","../Core/defined","./ConstantProperty"],function(e,t,i){"use strict";function n(e,i,n,r,o){return{configurable:r,get:function(){return this[i]},set:function(r){var a=this[i],s=this[n];t(s)&&(s(),this[n]=void 0);var l=t(r);l&&!t(r.getValue)&&t(o)&&(r=o(r)),a!==r&&(this[i]=r,this._definitionChanged.raiseEvent(this,e,r,a)),t(r)&&t(r.definitionChanged)&&(this[n]=r.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,e,r,r)},this))}}}function r(e){return new i(e)}function o(t,i,o){return n(t,"_"+t.toString(),"_"+t.toString()+"Subscription",e(i,!1),e(o,r))}return o}),define("Cesium/DataSources/BillboardGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,i,n,r,o){"use strict";var a=function(t){this._image=void 0,this._imageSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),imageSubRegion:o("imageSubRegion"),scale:o("scale"),rotation:o("rotation"),alignedAxis:o("alignedAxis"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),color:o("color"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),show:o("show"),width:o("width"),height:o("height"),scaleByDistance:o("scaleByDistance"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)?(e.color=this._color,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.image=this._image,e.imageSubRegion=this._imageSubRegion,e.pixelOffset=this._pixelOffset,e.scale=this._scale,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.show=this._show,e.verticalOrigin=this._verticalOrigin,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e):new a(this)},a.prototype.merge=function(t){this.color=e(this._color,t.color),this.eyeOffset=e(this._eyeOffset,t.eyeOffset),this.horizontalOrigin=e(this._horizontalOrigin,t.horizontalOrigin),this.image=e(this._image,t.image),this.imageSubRegion=e(this._imageSubRegion,t.imageSubRegion),this.pixelOffset=e(this._pixelOffset,t.pixelOffset),this.scale=e(this._scale,t.scale),this.rotation=e(this._rotation,t.rotation),this.alignedAxis=e(this._alignedAxis,t.alignedAxis),this.show=e(this._show,t.show),this.verticalOrigin=e(this._verticalOrigin,t.verticalOrigin),this.width=e(this._width,t.width),this.height=e(this._height,t.height),this.scaleByDistance=e(this._scaleByDistance,t.scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,t.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,t.pixelOffsetScaleByDistance)},a}),define("Cesium/DataSources/Property",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Iso8601"],function(e,t,i,n){"use strict";var r=function(){n.throwInstantiationError()};return i(r.prototype,{isConstant:{get:n.throwInstantiationError},definitionChanged:{get:n.throwInstantiationError}}),r.prototype.getValue=n.throwInstantiationError,r.prototype.equals=n.throwInstantiationError,r.equals=function(e,i){return e===i||t(e)&&e.equals(i)},r.arrayEquals=function(e,i){if(e===i)return!0;if(!t(e)||!t(i)||e.length!==i.length)return!1;for(var n=e.length,o=0;n>o;o++)if(!r.equals(e[o],i[o]))return!1;return!0},r.isConstant=function(e){return!t(e)||e.isConstant},r.getValueOrUndefined=function(e,i,n){return t(e)?e.getValue(i,n):void 0},r.getValueOrDefault=function(i,n,r,o){return t(i)?e(i.getValue(n,o),r):r},r.getValueOrClonedDefault=function(e,i,n,r){var o;return t(e)&&(o=e.getValue(i,r)),t(o)||(o=n.clone(o)),o},r}),define("Cesium/DataSources/ColorMaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./ConstantProperty","./createPropertyDescriptor","./Property"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(e){this._definitionChanged=new r,this._color=void 0,this._colorSubscription=void 0,this.color=e};return i(l.prototype,{isConstant:{get:function(){return s.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color")}),l.prototype.getType=function(){return"Color"},l.prototype.getValue=function(i,n){return t(n)||(n={}),n.color=s.getValueOrClonedDefault(this._color,i,e.WHITE,n.color),n},l.prototype.equals=function(e){return this===e||e instanceof l&&s.equals(this._color,e._color)},l}),define("Cesium/Core/EventHelper",["./defined","./DeveloperError"],function(){"use strict";var e=function(){this._removalFunctions=[]};return e.prototype.add=function(e,t,i){var n=e.addEventListener(t,i);this._removalFunctions.push(n);var r=this;return function(){n();var e=r._removalFunctions;e.splice(e.indexOf(n),1)}},e.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,i=e.length;i>t;++t)e[t]();e.length=0},e}),define("Cesium/DataSources/CompositeProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/TimeIntervalCollection","./Property"],function(e,t,i,n,r,o,a){"use strict";function s(t,i,n,r){var o=function(){n.raiseEvent(t)},a=[];i.removeAll();for(var s=r.length,l=0;s>l;l++){var u=r.get(l);e(u.data)&&-1===a.indexOf(u.data)&&i.add(u.data.definitionChanged,o)}}var l=function(){this._eventHelper=new r,this._definitionChanged=new n,this._intervals=new o,this._intervals.changedEvent.addEventListener(l.prototype._intervalsChanged,this)};return t(l.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),l.prototype.getValue=function(t,i){var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._intervals.equals(e._intervals,a.equals)},l.prototype._intervalsChanged=function(){s(this,this._eventHelper,this._definitionChanged,this._intervals),this._definitionChanged.raiseEvent(this)},l}),define("Cesium/DataSources/CompositeMaterialProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./CompositeProperty","./Property"],function(e,t,i,n,r,o){"use strict";var a=function(){this._definitionChanged=new n,this._composite=new r,this._composite.definitionChanged.addEventListener(a.prototype._raiseDefinitionChanged,this)};return t(a.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite._intervals}}}),a.prototype.getType=function(t){var i=this._composite._intervals.findDataForIntervalContainingDate(t);
return e(i)?i.getType(t):void 0},a.prototype.getValue=function(t,i){var n=this._composite._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},a.prototype.equals=function(e){return this===e||e instanceof a&&this._composite.equals(e._composite,o.equals)},a.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},a}),define("Cesium/DataSources/CompositePositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./CompositeProperty","./Property"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(t){this._referenceFrame=e(t,o.FIXED),this._definitionChanged=new r,this._composite=new a,this._composite.definitionChanged.addEventListener(l.prototype._raiseDefinitionChanged,this)};return i(l.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite.intervals}},referenceFrame:{get:function(){return this._referenceFrame},set:function(e){this._referenceFrame=e}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,i,n){var r=this._composite._intervals.findDataForIntervalContainingDate(e);return t(r)?r.getValueInReferenceFrame(e,i,n):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._referenceFrame===e._referenceFrame&&this._composite.equals(e._composite,s.equals)},l.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},l}),define("Cesium/Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n,r){"use strict";var o=function(t,i,n,r){this.x=e(t,0),this.y=e(i,0),this.z=e(n,0),this.w=e(r,0)};o.fromElements=function(e,i,n,r,a){return t(a)?(a.x=e,a.y=i,a.z=n,a.w=r,a):new o(e,i,n,r)},o.fromColor=function(e,i){return t(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,i){return t(e)?t(i)?(i.x=e.x,i.y=e.y,i.z=e.z,i.w=e.w,i):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(t,i,n){n=e(n,0),i[n++]=t.x,i[n++]=t.y,i[n++]=t.z,i[n]=t.w},o.unpack=function(i,n,r){return n=e(n,0),t(r)||(r=new o),r.x=i[n++],r.y=i[n++],r.z=i[n++],r.w=i[n],r},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i.w=Math.min(e.w,t.w),i},o.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i.w=Math.max(e.w,t.w),i},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,t){return o.subtract(e,t,a),o.magnitude(a)},o.distanceSquared=function(e,t){return o.subtract(e,t,a),o.magnitudeSquared(a)},o.normalize=function(e,t){var i=o.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t.w=e.w/i,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i.w=e.w*t.w,i},o.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},o.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},o.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},o.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,i,n){return o.multiplyByScalar(t,i,s),n=o.multiplyByScalar(e,1-i,n),o.add(s,n,n)};var l=new o;return o.mostOrthogonalAxis=function(e,t){var i=o.normalize(e,l);return o.abs(i,i),t=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):i.z<=i.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):i.z<=i.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},o.equals=function(e,i){return e===i||t(e)&&t(i)&&e.x===i.x&&e.y===i.y&&e.z===i.z&&e.w===i.w},o.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]&&e.w===t[i+3]},o.equalsEpsilon=function(e,i,n,o){return e===i||t(e)&&t(i)&&r.equalsEpsilon(e.x,i.x,n,o)&&r.equalsEpsilon(e.y,i.y,n,o)&&r.equalsEpsilon(e.z,i.z,n,o)&&r.equalsEpsilon(e.w,i.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,i){return o.equalsEpsilon(this,e,t,i)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Cesium/Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,i,n,r){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=i,this.yPoleOffset=n,this.ut1MinusUtc=r};return e}),define("Cesium/Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";function h(e,t){return a.compare(e.julianDate,t)}function m(e,i){if(!n(i.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(i.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var r=i.columnNames.indexOf("modifiedJulianDateUtc"),o=i.columnNames.indexOf("xPoleWanderRadians"),l=i.columnNames.indexOf("yPoleWanderRadians"),u=i.columnNames.indexOf("ut1MinusUtcSeconds"),m=i.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=i.columnNames.indexOf("yCelestialPoleOffsetRadians"),f=i.columnNames.indexOf("taiMinusUtcSeconds");if(0>r||0>o||0>l||0>u||0>m||0>p||0>f)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var v=e._samples=i.samples,g=e._dates=[];e._dateColumn=r,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=l,e._ut1MinusUtcSecondsColumn=u,e._xCelestialPoleOffsetRadiansColumn=m,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=f,e._columnCount=i.columnNames.length,e._lastIndex=void 0;for(var _,y=e._addNewLeapSeconds,C=0,w=v.length;w>C;C+=e._columnCount){var E=v[C+r],b=v[C+f],S=E+c.MODIFIED_JULIAN_DATE_DIFFERENCE,x=new a(S,b,d.TAI);if(g.push(x),y){if(b!==_&&n(_)){var T=a.leapSeconds,P=t(T,x,h);if(0>P){var A=new s(x,b);T.splice(~P,0,A)}}_=b}}}function p(e,t,i,n,r){var o=i*n;r.xPoleWander=t[o+e._xPoleWanderRadiansColumn],r.yPoleWander=t[o+e._yPoleWanderRadiansColumn],r.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],r.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],r.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function f(e,t,i){return t+e*(i-t)}function v(e,t,i,n,r,o,s){var l=e._columnCount;if(o>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var u=t[r],c=t[o];if(u.equals(c)||n.equals(u))return p(e,i,r,l,s),s;if(n.equals(c))return p(e,i,o,l,s),s;var d=a.secondsDifference(n,u)/a.secondsDifference(c,u),h=r*l,m=o*l,v=i[h+e._ut1MinusUtcSecondsColumn],g=i[m+e._ut1MinusUtcSecondsColumn],_=g-v;if(_>.5||-.5>_){var y=i[h+e._taiMinusUtcSecondsColumn],C=i[m+e._taiMinusUtcSecondsColumn];y!==C&&(c.equals(n)?v=g:g-=C-y)}return s.xPoleWander=f(d,i[h+e._xPoleWanderRadiansColumn],i[m+e._xPoleWanderRadiansColumn]),s.yPoleWander=f(d,i[h+e._yPoleWanderRadiansColumn],i[m+e._yPoleWanderRadiansColumn]),s.xPoleOffset=f(d,i[h+e._xCelestialPoleOffsetRadiansColumn],i[m+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=f(d,i[h+e._yCelestialPoleOffsetRadiansColumn],i[m+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=f(d,v,g),s}var g=function(t){if(t=i(t,i.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=i(t.addNewLeapSeconds,!0),n(t.data))m(this,t.data);else if(n(t.url)){var r=this;this._downloadPromise=e(l(t.url),function(e){m(r,e)},function(){r._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else m(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return g.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new r(0,0,0,0,0),t}}),g.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},g.prototype.compute=function(e,i){if(!n(this._samples)){if(n(this._dataError))throw new u(this._dataError);return void 0}if(n(i)||(i=new r(0,0,0,0,0)),0===this._samples.length)return i.xPoleWander=0,i.yPoleWander=0,i.xPoleOffset=0,i.yPoleOffset=0,i.ut1MinusUtc=0,i;var o=this._dates,s=this._lastIndex,l=0,c=0;if(n(s)){var d=o[s],h=o[s+1],m=a.lessThanOrEquals(d,e),p=!n(h),f=p||a.greaterThanOrEquals(h,e);if(m&&f)return l=s,!p&&h.equals(e)&&++l,c=l+1,v(this,o,this._samples,e,l,c,i),i}var g=t(o,e,a.compare,this._dateColumn);return g>=0?(g<o.length-1&&o[g+1].equals(e)&&++g,l=g,c=g):(c=~g,l=c-1,0>l&&(l=0)),this._lastIndex=l,v(this,o,this._samples,e,l,c,i),i},g}),define("Cesium/Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,i,n){"use strict";function r(){for(var e=document.getElementsByTagName("script"),t=0,i=e.length;i>t;++t){var n=e[t].getAttribute("src"),r=d.exec(n);if(null!==r)return r[1]}return void 0}function o(){if(t(l))return l;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:r(),!t(n))throw new i("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return l=new e(n).resolve(new e(document.location.href))}function a(e){return n.toUrl("../"+e)}function s(t){return new e(t).resolve(o()).toString()}var l,u,c,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){t(u)||(u=t(n.toUrl)?a:s),t(c)||(c=document.createElement("a"));var i=u(e);return c.href=i,c.href=c.href,c.href};return h._cesiumScriptRegex=d,h}),define("Cesium/Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,i){this.x=e,this.y=t,this.s=i};return e}),define("Cesium/Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,i,n,r,o,a,s){"use strict";function l(e,t,i){var n=d;return n.dayNumber=t,n.secondsOfDay=i,o.daysDifference(n,e._sampleZeroDateTT)}function u(i,r){if(i._chunkDownloadsInProgress[r])return i._chunkDownloadsInProgress[r];var o=e.defer();i._chunkDownloadsInProgress[r]=o;var s,l=i._xysFileUrlTemplate;return s=n(l)?l.replace("{0}",r):t("Assets/IAU2006_XYS/IAU2006_XYS_"+r+".json"),e(a(s),function(e){i._chunkDownloadsInProgress[r]=!1;for(var t=i._samples,n=e.samples,a=3*r*i._samplesPerXysFile,s=0,l=n.length;l>s;++s)t[a+s]=n[s];o.resolve()}),o.promise}var c=function(e){e=i(e,i.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=i(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=i(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=i(e.stepSizeDays,1),this._samplesPerXysFile=i(e.samplesPerXysFile,1e3),this._totalSamples=i(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),a=Math.pow(this._stepSizeDays,t),l=0;t>=l;++l){n[l]=a,r[l]=l*this._stepSizeDays;for(var u=0;t>=u;++u)u!==l&&(n[l]*=l-u);n[l]=1/n[l]}this._work=new Array(t+1),this._coef=new Array(t+1)},d=new o(0,0,s.TAI);return c.prototype.preload=function(t,i,n,r){var o=l(this,t,i),a=l(this,n,r),s=0|o/this._stepSizeDays-this._interpolationOrder/2;0>s&&(s=0);var c=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var d=0|s/this._samplesPerXysFile,h=0|c/this._samplesPerXysFile,m=[],p=d;h>=p;++p)m.push(u(this,p));return e.all(m)},c.prototype.computeXysRadians=function(e,t,i){var o=l(this,e,t);if(0>o)return void 0;var a=0|o/this._stepSizeDays;if(a>=this._totalSamples)return void 0;var s=this._interpolationOrder,c=a-(0|s/2);0>c&&(c=0);var d=c+s;d>=this._totalSamples&&(d=this._totalSamples-1,c=d-s,0>c&&(c=0));var h=!1,m=this._samples;if(n(m[3*c])||(u(this,0|c/this._samplesPerXysFile),h=!0),n(m[3*d])||(u(this,0|d/this._samplesPerXysFile),h=!0),h)return void 0;n(i)?(i.x=0,i.y=0,i.s=0):i=new r(0,0,0);var p,f,v=o-c*this._stepSizeDays,g=this._work,_=this._denominators,y=this._coef,C=this._xTable;for(p=0;s>=p;++p)g[p]=v-C[p];for(p=0;s>=p;++p){for(y[p]=1,f=0;s>=f;++f)f!==p&&(y[p]*=g[f]);y[p]*=_[p];var w=3*(c+p);i.x+=y[p]*m[w++],i.y+=y[p]*m[w++],i.s+=y[p]*m[w]}return i},c}),define("Cesium/Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,i,n,r,o,a,s,l){"use strict";var u=function(e,t,n,r,o,a,s,l,u,c,d,h,m,p,f,v){this[0]=i(e,0),this[1]=i(o,0),this[2]=i(u,0),this[3]=i(m,0),this[4]=i(t,0),this[5]=i(a,0),this[6]=i(c,0),this[7]=i(p,0),this[8]=i(n,0),this[9]=i(s,0),this[10]=i(d,0),this[11]=i(f,0),this[12]=i(r,0),this[13]=i(l,0),this[14]=i(h,0),this[15]=i(v,0)};u.packedLength=16,u.pack=function(e,t,n){n=i(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},u.unpack=function(e,t,r){return t=i(t,0),n(r)||(r=new u),r[0]=e[t++],r[1]=e[t++],r[2]=e[t++],r[3]=e[t++],r[4]=e[t++],r[5]=e[t++],r[6]=e[t++],r[7]=e[t++],r[8]=e[t++],r[9]=e[t++],r[10]=e[t++],r[11]=e[t++],r[12]=e[t++],r[13]=e[t++],r[14]=e[t++],r[15]=e[t],r},u.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new u(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},u.fromArray=u.unpack,u.fromColumnMajorArray=function(e,t){return u.clone(e,t)},u.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},u.fromRotationTranslation=function(t,r,o){return r=i(r,e.ZERO),n(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=r.x,o[13]=r.y,o[14]=r.z,o[15]=1,o):new u(t[0],t[3],t[6],r.x,t[1],t[4],t[7],r.y,t[2],t[5],t[8],r.z,0,0,0,1)},u.fromTranslationQuaternionRotationScale=function(e,t,i,r){n(r)||(r=new u);var o=i.x,a=i.y,s=i.z,l=t.x*t.x,c=t.x*t.y,d=t.x*t.z,h=t.x*t.w,m=t.y*t.y,p=t.y*t.z,f=t.y*t.w,v=t.z*t.z,g=t.z*t.w,_=t.w*t.w,y=l-m-v+_,C=2*(c-g),w=2*(d+f),E=2*(c+g),b=-l+m-v+_,S=2*(p-h),x=2*(d-f),T=2*(p+h),P=-l-m+v+_;return r[0]=y*o,r[1]=E*o,r[2]=x*o,r[3]=0,r[4]=C*a,r[5]=b*a,r[6]=T*a,r[7]=0,r[8]=w*s,r[9]=S*s,r[10]=P*s,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},u.fromTranslation=function(e,t){return u.fromRotationTranslation(s.IDENTITY,e,t)},u.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},u.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new u(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,d=new e,h=new e;u.fromCamera=function(t,i){var r=t.eye,o=t.target,a=t.up;e.normalize(e.subtract(o,r,c),c),e.normalize(e.cross(c,a,d),d),e.normalize(e.cross(d,c,h),h);var s=d.x,l=d.y,m=d.z,p=c.x,f=c.y,v=c.z,g=h.x,_=h.y,y=h.z,C=r.x,w=r.y,E=r.z,b=s*-C+l*-w+m*-E,S=g*-C+_*-w+y*-E,x=p*C+f*w+v*E;return n(i)?(i[0]=s,i[1]=g,i[2]=-p,i[3]=0,i[4]=l,i[5]=_,i[6]=-f,i[7]=0,i[8]=m,i[9]=y,i[10]=-v,i[11]=0,i[12]=b,i[13]=S,i[14]=x,i[15]=1,i):new u(s,l,m,b,g,_,y,S,-p,-f,-v,x,0,0,0,1)},u.computePerspectiveFieldOfView=function(e,t,i,n,r){var o=Math.tan(.5*e),a=1/o,s=a/t,l=(n+i)/(i-n),u=2*n*i/(i-n);return r[0]=s,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=a,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=l,r[11]=-1,r[12]=0,r[13]=0,r[14]=u,r[15]=0,r},u.computeOrthographicOffCenter=function(e,t,i,n,r,o,a){var s=1/(t-e),l=1/(n-i),u=1/(o-r),c=-(t+e)*s,d=-(n+i)*l,h=-(o+r)*u;return s*=2,l*=2,u*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=u,a[11]=0,a[12]=c,a[13]=d,a[14]=h,a[15]=1,a},u.computePerspectiveOffCenter=function(e,t,i,n,r,o,a){var s=2*r/(t-e),l=2*r/(n-i),u=(t+e)/(t-e),c=(n+i)/(n-i),d=-(o+r)/(o-r),h=-1,m=-2*o*r/(o-r);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=u,a[9]=c,a[10]=d,a[11]=h,a[12]=0,a[13]=0,a[14]=m,a[15]=0,a},u.computeInfinitePerspectiveOffCenter=function(e,t,i,n,r,o){var a=2*r/(t-e),s=2*r/(n-i),l=(t+e)/(t-e),u=(n+i)/(n-i),c=-1,d=-1,h=-2*r;return o[0]=a,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=l,o[9]=u,o[10]=c,o[11]=d,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},u.computeViewportTransformation=function(e,t,n,r){e=i(e,i.EMPTY_OBJECT);var o=i(e.x,0),a=i(e.y,0),s=i(e.width,0),l=i(e.height,0);t=i(t,0),n=i(n,1);var u=.5*s,c=.5*l,d=.5*(n-t),h=u,m=c,p=d,f=o+u,v=a+c,g=t+d,_=1;return r[0]=h,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=m,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=p,r[11]=0,r[12]=f,r[13]=v,r[14]=g,r[15]=_,r},u.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},u.getElementIndex=function(e,t){return 4*e+t},u.getColumn=function(e,t,i){var n=4*t,r=e[n],o=e[n+1],a=e[n+2],s=e[n+3];return i.x=r,i.y=o,i.z=a,i.w=s,i},u.setColumn=function(e,t,i,n){n=u.clone(e,n);var r=4*t;return n[r]=i.x,n[r+1]=i.y,n[r+2]=i.z,n[r+3]=i.w,n},u.getRow=function(e,t,i){var n=e[t],r=e[t+4],o=e[t+8],a=e[t+12];return i.x=n,i.y=r,i.z=o,i.w=a,i},u.setRow=function(e,t,i,n){return n=u.clone(e,n),n[t]=i.x,n[t+4]=i.y,n[t+8]=i.z,n[t+12]=i.w,n};var m=new e;u.getScale=function(t,i){return i.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),i.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),i.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),i};var p=new e;u.getMaximumScale=function(t){return u.getScale(t,p),e.maximumComponent(p)},u.multiply=function(e,t,i){var n=e[0],r=e[1],o=e[2],a=e[3],s=e[4],l=e[5],u=e[6],c=e[7],d=e[8],h=e[9],m=e[10],p=e[11],f=e[12],v=e[13],g=e[14],_=e[15],y=t[0],C=t[1],w=t[2],E=t[3],b=t[4],S=t[5],x=t[6],T=t[7],P=t[8],A=t[9],M=t[10],I=t[11],D=t[12],O=t[13],R=t[14],L=t[15],N=n*y+s*C+d*w+f*E,z=r*y+l*C+h*w+v*E,F=o*y+u*C+m*w+g*E,B=a*y+c*C+p*w+_*E,V=n*b+s*S+d*x+f*T,k=r*b+l*S+h*x+v*T,U=o*b+u*S+m*x+g*T,W=a*b+c*S+p*x+_*T,G=n*P+s*A+d*M+f*I,H=r*P+l*A+h*M+v*I,q=o*P+u*A+m*M+g*I,j=a*P+c*A+p*M+_*I,Y=n*D+s*O+d*R+f*L,X=r*D+l*O+h*R+v*L,Z=o*D+u*O+m*R+g*L,J=a*D+c*O+p*R+_*L;return i[0]=N,i[1]=z,i[2]=F,i[3]=B,i[4]=V,i[5]=k,i[6]=U,i[7]=W,i[8]=G,i[9]=H,i[10]=q,i[11]=j,i[12]=Y,i[13]=X,i[14]=Z,i[15]=J,i},u.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i[9]=e[9]+t[9],i[10]=e[10]+t[10],i[11]=e[11]+t[11],i[12]=e[12]+t[12],i[13]=e[13]+t[13],i[14]=e[14]+t[14],i[15]=e[15]+t[15],i},u.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i[9]=e[9]-t[9],i[10]=e[10]-t[10],i[11]=e[11]-t[11],i[12]=e[12]-t[12],i[13]=e[13]-t[13],i[14]=e[14]-t[14],i[15]=e[15]-t[15],i},u.multiplyTransformation=function(e,t,i){var n=e[0],r=e[1],o=e[2],a=e[4],s=e[5],l=e[6],u=e[8],c=e[9],d=e[10],h=e[12],m=e[13],p=e[14],f=t[0],v=t[1],g=t[2],_=t[4],y=t[5],C=t[6],w=t[8],E=t[9],b=t[10],S=t[12],x=t[13],T=t[14],P=n*f+a*v+u*g,A=r*f+s*v+c*g,M=o*f+l*v+d*g,I=n*_+a*y+u*C,D=r*_+s*y+c*C,O=o*_+l*y+d*C,R=n*w+a*E+u*b,L=r*w+s*E+c*b,N=o*w+l*E+d*b,z=n*S+a*x+u*T+h,F=r*S+s*x+c*T+m,B=o*S+l*x+d*T+p;return i[0]=P,i[1]=A,i[2]=M,i[3]=0,i[4]=I,i[5]=D,i[6]=O,i[7]=0,i[8]=R,i[9]=L,i[10]=N,i[11]=0,i[12]=z,i[13]=F,i[14]=B,i[15]=1,i},u.multiplyByMatrix3=function(e,t,i){var n=e[0],r=e[1],o=e[2],a=e[4],s=e[5],l=e[6],u=e[8],c=e[9],d=e[10],h=t[0],m=t[1],p=t[2],f=t[3],v=t[4],g=t[5],_=t[6],y=t[7],C=t[8],w=n*h+a*m+u*p,E=r*h+s*m+c*p,b=o*h+l*m+d*p,S=n*f+a*v+u*g,x=r*f+s*v+c*g,T=o*f+l*v+d*g,P=n*_+a*y+u*C,A=r*_+s*y+c*C,M=o*_+l*y+d*C;return i[0]=w,i[1]=E,i[2]=b,i[3]=0,i[4]=S,i[5]=x,i[6]=T,i[7]=0,i[8]=P,i[9]=A,i[10]=M,i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=e[15],i},u.multiplyByTranslation=function(e,t,i){var n=t.x,r=t.y,o=t.z,a=n*e[0]+r*e[4]+o*e[8]+e[12],s=n*e[1]+r*e[5]+o*e[9]+e[13],l=n*e[2]+r*e[6]+o*e[10]+e[14];return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=a,i[13]=s,i[14]=l,i[15]=e[15],i};var f=new e;u.multiplyByUniformScale=function(e,t,i){return f.x=t,f.y=t,f.z=t,u.multiplyByScale(e,f,i)},u.multiplyByScale=function(e,t,i){var n=t.x,r=t.y,o=t.z;return 1===n&&1===r&&1===o?u.clone(e,i):(i[0]=n*e[0],i[1]=n*e[1],i[2]=n*e[2],i[3]=0,i[4]=r*e[4],i[5]=r*e[5],i[6]=r*e[6],i[7]=0,i[8]=o*e[8],i[9]=o*e[9],i[10]=o*e[10],i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=1,i)},u.multiplyByVector=function(e,t,i){var n=t.x,r=t.y,o=t.z,a=t.w,s=e[0]*n+e[4]*r+e[8]*o+e[12]*a,l=e[1]*n+e[5]*r+e[9]*o+e[13]*a,u=e[2]*n+e[6]*r+e[10]*o+e[14]*a,c=e[3]*n+e[7]*r+e[11]*o+e[15]*a;return i.x=s,i.y=l,i.z=u,i.w=c,i},u.multiplyByPointAsVector=function(e,t,i){var n=t.x,r=t.y,o=t.z,a=e[0]*n+e[4]*r+e[8]*o,s=e[1]*n+e[5]*r+e[9]*o,l=e[2]*n+e[6]*r+e[10]*o;return i.x=a,i.y=s,i.z=l,i},u.multiplyByPoint=function(e,t,i){var n=t.x,r=t.y,o=t.z,a=e[0]*n+e[4]*r+e[8]*o+e[12],s=e[1]*n+e[5]*r+e[9]*o+e[13],l=e[2]*n+e[6]*r+e[10]*o+e[14];return i.x=a,i.y=s,i.z=l,i},u.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i[9]=e[9]*t,i[10]=e[10]*t,i[11]=e[11]*t,i[12]=e[12]*t,i[13]=e[13]*t,i[14]=e[14]*t,i[15]=e[15]*t,i},u.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},u.transpose=function(e,t){var i=e[1],n=e[2],r=e[3],o=e[6],a=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=i,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=r,t[13]=a,t[14]=s,t[15]=e[15],t},u.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},u.equalsEpsilon=function(e,t,i){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i&&Math.abs(e[9]-t[9])<=i&&Math.abs(e[10]-t[10])<=i&&Math.abs(e[11]-t[11])<=i&&Math.abs(e[12]-t[12])<=i&&Math.abs(e[13]-t[13])<=i&&Math.abs(e[14]-t[14])<=i&&Math.abs(e[15]-t[15])<=i},u.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},u.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var v=new s,g=new s,_=new t,y=new t(0,0,0,1);return u.inverse=function(e,i){if(s.equalsEpsilon(u.getRotation(e,v),g,a.EPSILON7)&&t.equals(u.getRow(e,3,_),y))return i[0]=0,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=0,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=0,i[11]=0,i[12]=-e[12],i[13]=-e[13],i[14]=-e[14],i[15]=1,i;var n=e[0],r=e[4],o=e[8],c=e[12],d=e[1],h=e[5],m=e[9],p=e[13],f=e[2],C=e[6],w=e[10],E=e[14],b=e[3],S=e[7],x=e[11],T=e[15],P=w*T,A=E*x,M=C*T,I=E*S,D=C*x,O=w*S,R=f*T,L=E*b,N=f*x,z=w*b,F=f*S,B=C*b,V=P*h+I*m+D*p-(A*h+M*m+O*p),k=A*d+R*m+z*p-(P*d+L*m+N*p),U=M*d+L*h+F*p-(I*d+R*h+B*p),W=O*d+N*h+B*m-(D*d+z*h+F*m),G=A*r+M*o+O*c-(P*r+I*o+D*c),H=P*n+L*o+N*c-(A*n+R*o+z*c),q=I*n+R*r+B*c-(M*n+L*r+F*c),j=D*n+z*r+F*o-(O*n+N*r+B*o);P=o*p,A=c*m,M=r*p,I=c*h,D=r*m,O=o*h,R=n*p,L=c*d,N=n*m,z=o*d,F=n*h,B=r*d;var Y=P*S+I*x+D*T-(A*S+M*x+O*T),X=A*b+R*x+z*T-(P*b+L*x+N*T),Z=M*b+L*S+F*T-(I*b+R*S+B*T),J=O*b+N*S+B*x-(D*b+z*S+F*x),K=M*w+O*E+A*C-(D*E+P*C+I*w),Q=N*E+P*f+L*w-(R*w+z*E+A*f),$=R*C+B*E+I*f-(F*E+M*f+L*C),et=F*w+D*f+z*C-(N*C+B*w+O*f),tt=n*V+r*k+o*U+c*W;if(Math.abs(tt)<a.EPSILON20)throw new l("matrix is not invertible because its determinate is zero.");return tt=1/tt,i[0]=V*tt,i[1]=k*tt,i[2]=U*tt,i[3]=W*tt,i[4]=G*tt,i[5]=H*tt,i[6]=q*tt,i[7]=j*tt,i[8]=Y*tt,i[9]=X*tt,i[10]=Z*tt,i[11]=J*tt,i[12]=K*tt,i[13]=Q*tt,i[14]=$*tt,i[15]=et*tt,i},u.inverseTransformation=function(e,t){var i=e[0],n=e[1],r=e[2],o=e[4],a=e[5],s=e[6],l=e[8],u=e[9],c=e[10],d=e[12],h=e[13],m=e[14],p=-i*d-n*h-r*m,f=-o*d-a*h-s*m,v=-l*d-u*h-c*m;return t[0]=i,t[1]=o,t[2]=l,t[3]=0,t[4]=n,t[5]=a,t[6]=u,t[7]=0,t[8]=r,t[9]=s,t[10]=c,t[11]=0,t[12]=p,t[13]=f,t[14]=v,t[15]=1,t},u.IDENTITY=o(new u(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN0ROW3=3,u.COLUMN1ROW0=4,u.COLUMN1ROW1=5,u.COLUMN1ROW2=6,u.COLUMN1ROW3=7,u.COLUMN2ROW0=8,u.COLUMN2ROW1=9,u.COLUMN2ROW2=10,u.COLUMN2ROW3=11,u.COLUMN3ROW0=12,u.COLUMN3ROW1=13,u.COLUMN3ROW2=14,u.COLUMN3ROW3=15,u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]&&e[9]===t[i+9]&&e[10]===t[i+10]&&e[11]===t[i+11]&&e[12]===t[i+12]&&e[13]===t[i+13]&&e[14]===t[i+14]&&e[15]===t[i+15]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},u}),define("Cesium/Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g){"use strict";var _={},y=new i,C=new i,w=new i;_.eastNorthUpToFixedFrame=function(e,t,n){if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var a=m.sign(e.z);return o(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-a,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=a,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(0,-a,0,e.x,1,0,0,e.y,0,0,a,e.z,0,0,0,1)}var s=y,l=C,c=w;return t=r(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,i.normalize(l,l),i.cross(s,l,c),o(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(l.x,c.x,s.x,e.x,l.y,c.y,s.y,e.y,l.z,c.z,s.z,e.z,0,0,0,1)};var E=new i,b=new i,S=new i;_.northEastDownToFixedFrame=function(e,t,n){if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var a=m.sign(e.z);return o(n)?(n[0]=-a,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-a,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(-a,0,0,e.x,0,1,0,e.y,0,0,-a,e.z,0,0,0,1)}var s=E,l=b,c=S;return t=r(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,i.normalize(l,l),i.cross(s,l,c),o(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(c.x,l.x,-s.x,e.x,c.y,l.y,-s.y,e.y,c.z,l.z,-s.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,t,n){if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var a=m.sign(e.z);return o(n)?(n[0]=-a,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=a,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(-a,0,0,e.x,0,0,1,e.y,0,a,0,e.z,0,0,0,1)}var s=y,l=C,c=w;return t=r(t,u.WGS84),t.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,i.normalize(l,l),i.cross(s,l,c),o(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=l.x,n[9]=l.y,n[10]=l.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new f(c.x,s.x,l.x,e.x,c.y,s.y,l.y,e.y,c.z,s.z,l.z,e.z,0,0,0,1)};var x=new v,T=new i(1,1,1),P=new f;_.headingPitchRollToFixedFrame=function(e,t,n,r,o,a){var s=v.fromHeadingPitchRoll(t,n,r,x),l=f.fromTranslationQuaternionRotationScale(i.ZERO,s,T,P);return a=_.eastNorthUpToFixedFrame(e,o,a),f.multiply(a,l,a)};var A=new f,M=new p;_.headingPitchRollQuaternion=function(e,t,i,n,r,o){var a=_.headingPitchRollToFixedFrame(e,t,i,n,r,A),s=f.getRotation(a,M);return v.fromRotationMatrix(s,o)};var I=24110.54841,D=8640184.812866,O=.093104,R=-62e-7,L=1.1772758384668e-19,N=72921158553e-15,z=m.TWO_PI/86400,F=new h;_.computeTemeToPseudoFixedMatrix=function(e,t){F=h.addSeconds(e,-h.computeTaiMinusUtc(e),F);var i,n=F.dayNumber,r=F.secondsOfDay,a=n-2451545;i=r>=43200?(a+.5)/g.DAYS_PER_JULIAN_CENTURY:(a-.5)/g.DAYS_PER_JULIAN_CENTURY;var s=I+i*(D+i*(O+i*R)),l=s*z%m.TWO_PI,u=N+L*(n-2451545.5),c=(r+.5*g.SECONDS_PER_DAY)%g.SECONDS_PER_DAY,d=l+u*c,f=Math.cos(d),v=Math.sin(d);return o(t)?(t[0]=f,t[1]=-v,t[2]=0,t[3]=v,t[4]=f,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new p(f,v,0,-v,f,0,0,0,1)},_.iau2006XysData=new c,_.earthOrientationParameters=s.NONE;var B=32.184,V=2451545;_.preloadIcrfFixed=function(t){var i=t.start.dayNumber,n=t.start.secondsOfDay+B,r=t.stop.dayNumber,o=t.stop.secondsOfDay+B,a=_.iau2006XysData.preload(i,n,r,o),s=_.earthOrientationParameters.getPromiseToLoad();return e.all([a,s])},_.computeIcrfToFixedMatrix=function(e,t){o(t)||(t=new p);var i=_.computeFixedToIcrfMatrix(e,t);return o(i)?p.transpose(i,t):void 0};var k=new d(0,0,0),U=new l(0,0,0,0,0,0),W=new p,G=new p;_.computeFixedToIcrfMatrix=function(e,t){o(t)||(t=new p);var i=_.earthOrientationParameters.compute(e,U);
if(!o(i))return void 0;var n=e.dayNumber,r=e.secondsOfDay+B,a=_.iau2006XysData.computeXysRadians(n,r,k);if(!o(a))return void 0;var s=a.x+i.xPoleOffset,l=a.y+i.yPoleOffset,u=1/(1+Math.sqrt(1-s*s-l*l)),c=W;c[0]=1-u*s*s,c[3]=-u*s*l,c[6]=s,c[1]=-u*s*l,c[4]=1-u*l*l,c[7]=l,c[2]=-s,c[5]=-l,c[8]=1-u*(s*s+l*l);var d=p.fromRotationZ(-a.s,G),f=p.multiply(c,d,W),v=e.dayNumber,y=e.secondsOfDay-h.computeTaiMinusUtc(e)+i.ut1MinusUtc,C=v-2451545,w=y/g.SECONDS_PER_DAY,E=.779057273264+w+.00273781191135448*(C+w);E=E%1*m.TWO_PI;var b=p.fromRotationZ(E,G),S=p.multiply(f,b,W),x=Math.cos(i.xPoleWander),T=Math.cos(i.yPoleWander),P=Math.sin(i.xPoleWander),A=Math.sin(i.yPoleWander),M=n-V+r/g.SECONDS_PER_DAY;M/=36525;var I=-47e-6*M*m.RADIANS_PER_DEGREE/3600,D=Math.cos(I),O=Math.sin(I),R=G;return R[0]=x*D,R[1]=x*O,R[2]=P,R[3]=-T*O+A*P*D,R[4]=T*D+A*P*O,R[5]=-A*x,R[6]=-A*O-T*P*D,R[7]=A*D-T*P*O,R[8]=T*x,p.multiply(S,R,t)};var H=new n;_.pointToWindowCoordinates=function(e,t,i,n){return n=_.pointToGLWindowCoordinates(e,t,i,n),n.y=2*t[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,i,r,a){o(a)||(a=new t);var s=H;return f.multiplyByVector(e,n.fromElements(r.x,r.y,r.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),f.multiplyByVector(i,s,s),t.fromCartesian4(s,a)};var q=new i,j=new i,Y=new i;return _.rotationMatrixFromPositionVelocity=function(e,t,n,a){var s=r(n,u.WGS84).geodeticSurfaceNormal(e,q),l=i.cross(t,s,j);i.equalsEpsilon(l,i.ZERO,m.EPSILON6)&&(l=i.clone(i.UNIT_X,l));var c=i.cross(l,t,Y);return i.cross(t,c,l),i.negate(l,l),o(a)||(a=new p),a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=l.x,a[4]=l.y,a[5]=l.z,a[6]=c.x,a[7]=c.y,a[8]=c.z,a},_}),define("Cesium/DataSources/PositionProperty",["../Core/Cartesian3","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix3","../Core/ReferenceFrame","../Core/Transforms"],function(e,t,i,n,r,o,a){"use strict";var s=function(){n.throwInstantiationError()};i(s.prototype,{isConstant:{get:n.throwInstantiationError},definitionChanged:{get:n.throwInstantiationError},referenceFrame:{get:n.throwInstantiationError}}),s.prototype.getValue=n.throwInstantiationError,s.prototype.getValueInReferenceFrame=n.throwInstantiationError,s.prototype.equals=n.throwInstantiationError;var l=new r;return s.convertToReferenceFrame=function(i,n,s,u,c){if(!t(n))return n;if(t(c)||(c=new e),s===u)return e.clone(n,c);var d=a.computeIcrfToFixedMatrix(i,l);return t(d)||(d=a.computeTemeToPseudoFixedMatrix(i,l)),s===o.INERTIAL?r.multiplyByVector(d,n,c):s===o.FIXED?r.multiplyByVector(r.transpose(d,l),n,c):void 0},s}),define("Cesium/DataSources/ConstantPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(i,n){this._definitionChanged=new o,this._value=e.clone(i),this._referenceFrame=t(n,a.FIXED)};return n(l.prototype,{isConstant:{get:function(){return!i(this._value)||this._referenceFrame===a.FIXED}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},l.prototype.setValue=function(t,n){var r=!1;e.equals(this._value,t)||(r=!0,this._value=e.clone(t)),i(n)&&this._referenceFrame!==n&&(r=!0,this._referenceFrame=n),r&&this._definitionChanged.raiseEvent(this)},l.prototype.getValueInReferenceFrame=function(e,t,i){return s.convertToReferenceFrame(e,this._value,this._referenceFrame,t,i)},l.prototype.equals=function(t){return this===t||t instanceof l&&e.equals(this._value,t._value)&&this._referenceFrame===t._referenceFrame},l}),define("Cesium/DataSources/DataSource",["../Core/defineProperties","../Core/DeveloperError"],function(e,t){"use strict";var i=function(){t.throwInstantiationError()};return e(i.prototype,{name:{get:t.throwInstantiationError},clock:{get:t.throwInstantiationError},entities:{get:t.throwInstantiationError},isLoading:{get:t.throwInstantiationError},changedEvent:{get:t.throwInstantiationError},errorEvent:{get:t.throwInstantiationError},loadingEvent:{get:t.throwInstantiationError}}),i.prototype.update=t.throwInstantiationError,i.setLoading=function(e,t){e._isLoading!==t&&(t?e._entityCollection.suspendEvents():e._entityCollection.resumeEvents(),e._isLoading=t,e._loading.raiseEvent(e,t))},i}),define("Cesium/Core/getTimestamp",["./defined"],function(e){"use strict";var t;return t="undefined"!=typeof performance&&e(performance.now)?function(){return performance.now()}:function(){return Date.now()}}),define("Cesium/Core/Clock",["./ClockRange","./ClockStep","./defaultValue","./defined","./DeveloperError","./Event","./getTimestamp","./JulianDate"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(r){r=i(r,i.EMPTY_OBJECT);var l=r.startTime,u=!n(l),c=r.stopTime,d=!n(c),h=r.currentTime,m=!n(h);u&&d&&m?(h=s.now(),l=s.clone(h),c=s.addDays(h,1,new s)):u&&d?(l=s.clone(h),c=s.addDays(h,1,new s)):u&&m?(l=s.addDays(c,-1,new s),h=s.clone(l)):m&&d?(h=s.clone(l),c=s.addDays(l,1,new s)):m?h=s.clone(l):d?c=s.addDays(h,1,new s):u&&(l=s.clone(h)),this.startTime=l,this.stopTime=c,this.currentTime=h,this.multiplier=i(r.multiplier,1),this.clockStep=i(r.clockStep,t.SYSTEM_CLOCK_MULTIPLIER),this.clockRange=i(r.clockRange,e.UNBOUNDED),this.canAnimate=i(r.canAnimate,!0),this.shouldAnimate=i(r.shouldAnimate,!0),this.onTick=new o,this._lastSystemTime=a()};return l.prototype.tick=function(){var i=a(),n=s.clone(this.currentTime),r=this.startTime,o=this.stopTime,l=this.multiplier;if(this.canAnimate&&this.shouldAnimate)if(this.clockStep===t.SYSTEM_CLOCK)n=s.now(n);else{if(this.clockStep===t.TICK_DEPENDENT)n=s.addSeconds(n,l,n);else{var u=i-this._lastSystemTime;n=s.addSeconds(n,l*(u/1e3),n)}if(this.clockRange===e.CLAMPED)s.lessThan(n,r)?n=s.clone(r,n):s.greaterThan(n,o)&&(n=s.clone(o,n));else if(this.clockRange===e.LOOP_STOP)for(s.lessThan(n,r)&&(n=s.clone(r,n));s.greaterThan(n,o);)n=s.addSeconds(r,s.secondsDifference(n,o),n)}return this.currentTime=n,this._lastSystemTime=i,this.onTick.raiseEvent(this),n},l}),define("Cesium/DataSources/createRawPropertyDescriptor",["./createPropertyDescriptor"],function(e){"use strict";function t(e){return e}function i(i,n){return e(i,n,t)}return i}),define("Cesium/DataSources/DataSourceClock",["../Core/Clock","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","./createRawPropertyDescriptor"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(){this._startTime=void 0,this._stopTime=void 0,this._currentTime=void 0,this._clockRange=void 0,this._clockStep=void 0,this._multiplier=void 0,this._definitionChanged=new o};return n(l.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},startTime:s("startTime"),stopTime:s("stopTime"),currentTime:s("currentTime"),clockRange:s("clockRange"),clockStep:s("clockStep"),multiplier:s("multiplier")}),l.prototype.clone=function(e){return i(e)||(e=new l),e.startTime=this.startTime,e.stopTime=this.stopTime,e.currentTime=this.currentTime,e.clockRange=this.clockRange,e.clockStep=this.clockStep,e.multiplier=this.multiplier,e},l.prototype.equals=function(e){return this===e||i(e)&&a.equals(this.startTime,e.startTime)&&a.equals(this.stopTime,e.stopTime)&&a.equals(this.currentTime,e.currentTime)&&this.clockRange===e.clockRange&&this.clockStep===e.clockStep&&this.multiplier===e.multiplier},l.prototype.merge=function(e){this.startTime=t(this.startTime,e.startTime),this.stopTime=t(this.stopTime,e.stopTime),this.currentTime=t(this.currentTime,e.currentTime),this.clockRange=t(this.clockRange,e.clockRange),this.clockStep=t(this.clockStep,e.clockStep),this.multiplier=t(this.multiplier,e.multiplier)},l.prototype.getValue=function(t){return i(t)||(t=new e),t.startTime=this.startTime,t.stopTime=this.stopTime,t.clockRange=this.clockRange,t.clockStep=this.clockStep,t.multiplier=this.multiplier,t.currentTime=this.currentTime,t},l}),define("Cesium/DataSources/ImageMaterialProperty",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,i,n,r,o,a){"use strict";var s=new e(1,1),l=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new r,this._image=void 0,this._imageSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.image=e.image,this.repeat=e.repeat};return n(l.prototype,{isConstant:{get:function(){return a.isConstant(this._image)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),repeat:o("repeat")}),l.prototype.getType=function(){return"Image"},l.prototype.getValue=function(e,t){return i(t)||(t={}),t.image=a.getValueOrUndefined(this._image,e),t.repeat=a.getValueOrClonedDefault(this._repeat,e,s,t.repeat),t},l.prototype.equals=function(e){return this===e||e instanceof l&&a.equals(this._image,e._image)&&a.equals(this._repeat,e._repeat)},l}),define("Cesium/DataSources/createMaterialPropertyDescriptor",["../Core/Color","../Core/DeveloperError","./ColorMaterialProperty","./createPropertyDescriptor","./ImageMaterialProperty"],function(e,t,i,n,r){"use strict";function o(t){if(t instanceof e)return new i(t);if("string"==typeof t||t instanceof HTMLCanvasElement){var n=new r;return n.image=t,n}}function a(e,t){return n(e,t,o)}return a}),define("Cesium/DataSources/EllipseGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._semiMajorAxis=void 0,this._semiMajorAxisSubscription=void 0,this._semiMinorAxis=void 0,this._semiMinorAxisSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},semiMajorAxis:a("semiMajorAxis"),semiMinorAxis:a("semiMinorAxis"),rotation:a("rotation"),show:a("show"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),numberOfVerticalLines:a("numberOfVerticalLines")}),s.prototype.clone=function(e){return t(e)?(e.rotation=this.rotation,e.semiMajorAxis=this.semiMajorAxis,e.semiMinorAxis=this.semiMinorAxis,e.show=this.show,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.numberOfVerticalLines=this.numberOfVerticalLines,e):new s(this)},s.prototype.merge=function(t){this.rotation=e(this.rotation,t.rotation),this.semiMajorAxis=e(this.semiMajorAxis,t.semiMajorAxis),this.semiMinorAxis=e(this.semiMinorAxis,t.semiMinorAxis),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.numberOfVerticalLines=e(this.numberOfVerticalLines,t.numberOfVerticalLines)},s}),define("Cesium/DataSources/EllipsoidGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._radii=void 0,this._radiiSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._stackPartitions=void 0,this._stackPartitionsSubscription=void 0,this._slicePartitions=void 0,this._slicePartitionsSubscription=void 0,this._subdivisions=void 0,this._subdivisionsSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),radii:a("radii"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),stackPartitions:a("stackPartitions"),slicePartitions:a("slicePartitions"),subdivisions:a("subdivisions")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.radii=this.radii,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.stackPartitions=this.stackPartitions,e.slicePartitions=this.slicePartitions,e.subdivisions=this.subdivisions,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.radii=e(this.radii,t.radii),this.material=e(this.material,t.material),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.stackPartitions=e(this.stackPartitions,t.stackPartitions),this.slicePartitions=e(this.slicePartitions,t.slicePartitions),this.subdivisions=e(this.subdivisions,t.subdivisions)},s}),define("Cesium/Core/AssociativeArray",["./defined","./defineProperties","./DeveloperError"],function(e,t){"use strict";var i=function(){this._array=[],this._hash={}};return t(i.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),i.prototype.contains=function(t){return e(this._hash[t])},i.prototype.set=function(e,t){var i=this._hash[e];t!==i&&(this.remove(e),this._hash[e]=t,this._array.push(t))},i.prototype.get=function(e){return this._hash[e]},i.prototype.remove=function(t){var i=this._hash[t],n=e(i);if(n){var r=this._array;r.splice(r.indexOf(i),1),this._hash[t]=void 0}return n},i.prototype.removeAll=function(){var e=this._array;e.length>0&&(this._hash={},e.length=0)},i}),define("Cesium/DataSources/BoxGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._dimensions=void 0,this._dimensionsSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),dimensions:a("dimensions"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.dimensions=this.dimensions,e.show=this.show,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.dimensions=e(this.dimensions,t.dimensions),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),define("Cesium/DataSources/CorridorGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),width:a("width"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.width=this.width,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.width=e(this.width,t.width),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.cornerType=e(this.cornerType,t.cornerType)},s}),define("Cesium/DataSources/CylinderGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._length=void 0,this._lengthSubscription=void 0,this._topRadius=void 0,this._topRadiusSubscription=void 0,this._bottomRadius=void 0,this._bottomRadiusSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._slices=void 0,this._slicesSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},length:a("length"),topRadius:a("topRadius"),bottomRadius:a("bottomRadius"),numberOfVerticalLines:a("numberOfVerticalLines"),slices:a("slices"),show:a("show"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.bottomRadius=this.bottomRadius,e.length=this.length,e.topRadius=this.topRadius,e.show=this.show,e.material=this.material,e.numberOfVerticalLines=this.numberOfVerticalLines,e.slices=this.slices,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.bottomRadius=e(this.bottomRadius,t.bottomRadius),this.length=e(this.length,t.length),this.topRadius=e(this.topRadius,t.topRadius),this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.numberOfVerticalLines=e(this.numberOfVerticalLines,t.numberOfVerticalLines),this.slices=e(this.slices,t.slices),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),define("Cesium/DataSources/LabelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,i,n,r,o){"use strict";var a=function(t){this._text=void 0,this._textSubscription=void 0,this._font=void 0,this._fontSubscription=void 0,this._style=void 0,this._styleSubscription=void 0,this._fillColor=void 0,this._fillColorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},text:o("text"),font:o("font"),style:o("style"),fillColor:o("fillColor"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),scale:o("scale"),show:o("show"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)?(e.text=this.text,e.font=this.font,e.show=this.show,e.style=this.style,e.fillColor=this.fillColor,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.scale=this.scale,e.horizontalOrigin=this.horizontalOrigin,e.verticalOrigin=this.verticalOrigin,e.eyeOffset=this.eyeOffset,e.pixelOffset=this.pixelOffset,e.translucencyByDistance=this.translucencyByDistance,e.pixelOffsetScaleByDistance=this.pixelOffsetScaleByDistance,e):new a(this)},a.prototype.merge=function(t){this.text=e(this.text,t.text),this.font=e(this.font,t.font),this.show=e(this.show,t.show),this.style=e(this.style,t.style),this.fillColor=e(this.fillColor,t.fillColor),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.scale=e(this.scale,t.scale),this.horizontalOrigin=e(this.horizontalOrigin,t.horizontalOrigin),this.verticalOrigin=e(this.verticalOrigin,t.verticalOrigin),this.eyeOffset=e(this.eyeOffset,t.eyeOffset),this.pixelOffset=e(this.pixelOffset,t.pixelOffset),this.translucencyByDistance=e(this._translucencyByDistance,t.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,t.pixelOffsetScaleByDistance)},a}),define("Cesium/DataSources/ModelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,i,n,r,o){"use strict";var a=function(t){this._show=void 0,this._showSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._minimumPixelSize=void 0,this._minimumPixelSizeSubscription=void 0,this._uri=void 0,this._uriSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:o("show"),scale:o("scale"),minimumPixelSize:o("minimumPixelSize"),uri:o("uri")}),a.prototype.clone=function(e){return t(e)?(e.show=this.show,e.scale=this.scale,e.minimumPixelSize=this.minimumPixelSize,e.uri=this.uri,e):new a(this)},a.prototype.merge=function(t){this.show=e(this.show,t.show),this.scale=e(this.scale,t.scale),this.minimumPixelSize=e(this.minimumPixelSize,t.minimumPixelSize),this.uri=e(this.uri,t.uri)},a}),define("Cesium/DataSources/PathGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._material=void 0,this._materialSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._resolution=void 0,this._resolutionSubscription=void 0,this._leadTime=void 0,this._leadTimeSubscription=void 0,this._trailTime=void 0,this._trailTimeSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),width:a("width"),resolution:a("resolution"),leadTime:a("leadTime"),trailTime:a("trailTime")}),s.prototype.clone=function(e){return t(e)?(e.material=this.material,e.width=this.width,e.resolution=this.resolution,e.show=this.show,e.leadTime=this.leadTime,e.trailTime=this.trailTime,e):new s(this)},s.prototype.merge=function(t){this.material=e(this.material,t.material),this.width=e(this.width,t.width),this.resolution=e(this.resolution,t.resolution),this.show=e(this.show,t.show),this.leadTime=e(this.leadTime,t.leadTime),this.trailTime=e(this.trailTime,t.trailTime)},s}),define("Cesium/DataSources/PointGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,i,n,r,o){"use strict";var a=function(t){this._color=void 0,this._colorSubscription=void 0,this._pixelSize=void 0,this._pixelSizeSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),pixelSize:o("pixelSize"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),show:o("show"),scaleByDistance:o("scaleByDistance")}),a.prototype.clone=function(e){return t(e)?(e.color=this.color,e.pixelSize=this.pixelSize,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.show=this.show,e.scaleByDistance=this.scaleByDistance,e):new a(this)},a.prototype.merge=function(t){this.color=e(this.color,t.color),this.pixelSize=e(this.pixelSize,t.pixelSize),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.show=e(this.show,t.show),this.scaleByDistance=e(this.scaleByDistance,t.scaleByDistance)},a}),define("Cesium/DataSources/PolygonGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/deprecationWarning","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._hierarchy=void 0,this._hierarchySubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._perPositionHeight=void 0,this._perPositionHeightSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new o,this._fill=void 0,this._fillSubscription=void 0,this.merge(e(t,e.EMPTY_OBJECT))};return i(l.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:s("show"),material:a("material"),positions:{get:function(){return n("PolygonGraphics.positions","PolygonGraphics.positions was deprecated in Cesium 1.6, use PolygonGraphics.hierarchy instead."),this.hierarchy},set:function(e){n("PolygonGraphics.positions","PolygonGraphics.positions was deprecated in Cesium 1.6, use PolygonGraphics.hierarchy instead."),this.hierarchy=e}},hierarchy:s("hierarchy"),height:s("height"),extrudedHeight:s("extrudedHeight"),granularity:s("granularity"),stRotation:s("stRotation"),fill:s("fill"),outline:s("outline"),outlineColor:s("outlineColor"),outlineWidth:s("outlineWidth"),perPositionHeight:s("perPositionHeight")}),l.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.hierarchy=this.hierarchy,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.perPositionHeight=this.perPositionHeight,e):new l(this)},l.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.hierarchy=e(this.hierarchy,t.hierarchy),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.perPositionHeight=e(this.perPositionHeight,t.perPositionHeight)},l}),define("Cesium/DataSources/PolylineGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._followSurface=void 0,this._followSurfaceSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._widthSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),width:a("width"),followSurface:a("followSurface"),granularity:a("granularity")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.width=this.width,e.followSurface=this.followSurface,e.granularity=this.granularity,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.width=e(this.width,t.width),this.followSurface=e(this.followSurface,t.followSurface),this.granularity=e(this.granularity,t.granularity)
},s}),define("Cesium/DataSources/PolylineVolumeGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._shape=void 0,this._shapeSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),shape:a("shape"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.shape=this.shape,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.shape=e(this.shape,t.shape),this.granularity=e(this.granularity,t.granularity),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.cornerType=e(this.cornerType,t.cornerType)},s}),define("Cesium/DataSources/RectangleGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._coordinates=void 0,this._coordinatesSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._closeTop=void 0,this._closeTopSubscription=void 0,this._closeBottom=void 0,this._closeBottomSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),coordinates:a("coordinates"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),rotation:a("rotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),closeTop:a("closeTop"),closeBottom:a("closeBottom")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.coordinates=this.coordinates,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.rotation=this.rotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.closeTop=this.closeTop,e.closeBottom=this.closeBottom,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.coordinates=e(this.coordinates,t.coordinates),this.material=e(this.material,t.material),this.height=e(this.height,t.height),this.extrudedHeight=e(this.extrudedHeight,t.extrudedHeight),this.granularity=e(this.granularity,t.granularity),this.stRotation=e(this.stRotation,t.stRotation),this.rotation=e(this.rotation,t.rotation),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth),this.closeTop=e(this.closeTop,t.closeTop),this.closeBottom=e(this.closeBottom,t.closeBottom)},s}),define("Cesium/DataSources/WallGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,i,n,r,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._minimumHeights=void 0,this._minimumHeightsSubscription=void 0,this._maximumHeights=void 0,this._maximumHeightsSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new r,this.merge(e(t,e.EMPTY_OBJECT))};return i(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),minimumHeights:a("minimumHeights"),maximumHeights:a("maximumHeights"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.minimumHeights=this.minimumHeights,e.maximumHeights=this.maximumHeights,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(t){this.show=e(this.show,t.show),this.material=e(this.material,t.material),this.positions=e(this.positions,t.positions),this.minimumHeights=e(this.minimumHeights,t.minimumHeights),this.maximumHeights=e(this.maximumHeights,t.maximumHeights),this.granularity=e(this.granularity,t.granularity),this.fill=e(this.fill,t.fill),this.outline=e(this.outline,t.outline),this.outlineColor=e(this.outlineColor,t.outlineColor),this.outlineWidth=e(this.outlineWidth,t.outlineWidth)},s}),define("Cesium/DataSources/Entity",["../Core/Cartesian3","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Core/Transforms","./BillboardGraphics","./BoxGraphics","./ConstantPositionProperty","./CorridorGraphics","./createPropertyDescriptor","./createRawPropertyDescriptor","./CylinderGraphics","./EllipseGraphics","./EllipsoidGraphics","./LabelGraphics","./ModelGraphics","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGraphics","./PolylineVolumeGraphics","./Property","./RectangleGraphics","./WallGraphics"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M){"use strict";function I(e){return new m(e)}function D(e){return f(e,void 0,I)}function O(e,t){return f(e,void 0,function(e){return e instanceof t?e:new t(e)})}function R(e,t){for(var i=e._children,n=i.length,r=0;n>r;r++){var o=i[r],a=o._show,s=!t&&a,l=t&&a;s!==l&&o._definitionChanged.raiseEvent(o,"isShowing",l,s)}e._definitionChanged.raiseEvent(e,"isShowing",t,!t)}var L=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.id;n(r)||(r=t()),this._availability=void 0,this._id=r,this._definitionChanged=new a,this._name=e.name,this._show=i(e.show,!0),this._parent=void 0,this._propertyNames=["billboard","box","corridor","cylinder","description","ellipse","ellipsoid","label","model","orientation","path","point","polygon","polyline","polylineVolume","position","rectangle","viewFrom","wall"],this._billboard=void 0,this._billboardSubscription=void 0,this._box=void 0,this._boxSubscription=void 0,this._corridor=void 0,this._corridorSubscription=void 0,this._cylinder=void 0,this._cylinderSubscription=void 0,this._description=void 0,this._descriptionSubscription=void 0,this._ellipse=void 0,this._ellipseSubscription=void 0,this._ellipsoid=void 0,this._ellipsoidSubscription=void 0,this._label=void 0,this._labelSubscription=void 0,this._model=void 0,this._modelSubscription=void 0,this._orientation=void 0,this._orientationSubscription=void 0,this._path=void 0,this._pathSubscription=void 0,this._point=void 0,this._pointSubscription=void 0,this._polygon=void 0,this._polygonSubscription=void 0,this._polyline=void 0,this._polylineSubscription=void 0,this._polylineVolume=void 0,this._polylineVolumeSubscription=void 0,this._position=void 0,this._positionSubscription=void 0,this._rectangle=void 0,this._rectangleSubscription=void 0,this._viewFrom=void 0,this._viewFromSubscription=void 0,this._wall=void 0,this._wallSubscription=void 0,this._children=[],this.parent=e.parent,this.merge(e)};r(L.prototype,{availability:v("availability"),id:{get:function(){return this._id}},definitionChanged:{get:function(){return this._definitionChanged}},name:v("name"),show:{get:function(){return this._show},set:function(e){if(e!==this._show){var t=this.isShowing;this._show=e;var i=this.isShowing;t!==i&&R(this,i),this._definitionChanged.raiseEvent(this,"show",e,!e)}}},isShowing:{get:function(){return this._show&&(!n(this._parent)||this._parent._show)}},parent:{get:function(){return this._parent},set:function(e){var t=this._parent;if(t!==e){var i=this.isShowing;if(n(t)){var r=t._children.indexOf(this);t._children.splice(r,1)}this._parent=e,e._children.push(this);var o=this.isShowing;i!==o&&R(this,o),this._definitionChanged.raiseEvent(this,"parent",e,t)}}},propertyNames:{get:function(){return this._propertyNames}},billboard:O("billboard",d),box:O("box",h),corridor:O("corridor",p),cylinder:O("cylinder",g),description:f("description"),ellipse:O("ellipse",_),ellipsoid:O("ellipsoid",y),label:O("label",C),model:O("model",w),orientation:f("orientation"),path:O("path",E),point:O("point",b),polygon:O("polygon",S),polyline:O("polyline",x),polylineVolume:O("polylineVolume",T),position:D("position"),rectangle:O("rectangle",A),viewFrom:f("viewFrom"),wall:O("wall",M)}),L.prototype.isAvailable=function(e){var t=this._availability;return!n(t)||t.contains(e)},L.prototype.addProperty=function(e){var t=this._propertyNames;t.push(e),Object.defineProperty(this,e,v(e,!0))},L.prototype.removeProperty=function(e){this._propertyNames,this._propertyNames.push(e),delete this[e]},L.prototype.merge=function(e){this.name=i(this.name,e.name),this.availability=i(e.availability,this.availability);for(var t=this._propertyNames,r=n(e._propertyNames)?e._propertyNames:Object.keys(e),o=r.length,a=0;o>a;a++){var s=r[a];if("parent"!==s){var l=this[s],u=e[s];n(l)||-1!==t.indexOf(s)||this.addProperty(s),n(u)&&(n(l)?n(l.merge)&&l.merge(u):this[s]=n(u.merge)&&n(u.clone)?u.clone():u)}}};var N=new s,z=new e,F=new u;return L.prototype._getModelMatrix=function(e,t){var i=P.getValueOrUndefined(this._position,e,z);if(!n(i))return void 0;var r=P.getValueOrUndefined(this._orientation,e,F);return t=n(r)?l.fromRotationTranslation(s.fromQuaternion(r,N),i,t):c.eastNorthUpToFixedFrame(i,void 0,t)},L}),define("Cesium/DataSources/EntityCollection",["../Core/AssociativeArray","../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Iso8601","../Core/JulianDate","../Core/RuntimeError","../Core/TimeInterval","./Entity"],function(e,t,i,n,r,o,a,s,l,u,c){"use strict";function d(e){if(0===e._suspendCount){var t=e._addedEntities,i=e._removedEntities,n=e._changedEntities;(0!==n.length||0!==t.length||0!==i.length)&&(e._collectionChanged.raiseEvent(e,t.values,i.values,n.values),t.removeAll(),i.removeAll(),n.removeAll())}}var h={id:void 0},m=function(){this._entities=new e,this._addedEntities=new e,this._removedEntities=new e,this._changedEntities=new e,this._suspendCount=0,this._collectionChanged=new o,this._id=t()};return m.prototype.suspendEvents=function(){this._suspendCount++},m.prototype.resumeEvents=function(){this._suspendCount--,d(this)},m.collectionChangedEventCallback=void 0,n(m.prototype,{collectionChanged:{get:function(){return this._collectionChanged}},id:{get:function(){return this._id}},values:{get:function(){return this._entities.values}}}),m.prototype.computeAvailability=function(){for(var e=a.MAXIMUM_VALUE,t=a.MINIMUM_VALUE,n=this._entities.values,r=0,o=n.length;o>r;r++){var l=n[r],c=l.availability;if(i(c)){var d=c.start,h=c.stop;s.lessThan(d,e)&&!d.equals(a.MINIMUM_VALUE)&&(e=d),s.greaterThan(h,t)&&!h.equals(a.MAXIMUM_VALUE)&&(t=h)}}return a.MAXIMUM_VALUE.equals(e)&&(e=a.MINIMUM_VALUE),a.MINIMUM_VALUE.equals(t)&&(t=a.MAXIMUM_VALUE),new u({start:e,stop:t})},m.prototype.add=function(e){e instanceof c||(e=new c(e));var t=e.id,i=this._entities;if(i.contains(t))throw new l("An entity with id "+t+" already exists in this collection.");return i.set(t,e),this._removedEntities,this._removedEntities.remove(t)||this._addedEntities.set(t,e),e.definitionChanged.addEventListener(m.prototype._onEntityDefinitionChanged,this),d(this),e},m.prototype.remove=function(e){return i(e)?this.removeById(e.id):!1},m.prototype.contains=function(e){return this._entities.get(e.id)===e},m.prototype.removeById=function(e){if(!i(e))return!1;var t=this._entities,n=t.get(e);return this._entities.remove(e)?(this._addedEntities.remove(e)||(this._removedEntities.set(e,n),this._changedEntities.remove(e)),this._entities.remove(e),n.definitionChanged.removeEventListener(m.prototype._onEntityDefinitionChanged,this),d(this),!0):!1},m.prototype.removeAll=function(){for(var e=this._entities,t=e.length,n=e.values,r=this._addedEntities,o=this._removedEntities,a=0;t>a;a++){var s=n[a],l=s.id,u=r.get(l);i(u)||(s.definitionChanged.removeEventListener(m.prototype._onEntityDefinitionChanged,this),o.set(l,s))}e.removeAll(),r.removeAll(),this._changedEntities.removeAll(),d(this)},m.prototype.getById=function(e){return this._entities.get(e)},m.prototype.getOrCreateEntity=function(e){var t=this._entities.get(e);return i(t)||(h.id=e,t=new c(h),this.add(t)),t},m.prototype._onEntityDefinitionChanged=function(e){var t=e.id;this._addedEntities.contains(t)||this._changedEntities.set(t,e),d(this)},m}),define("Cesium/DataSources/GridMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,i,n,r,o,a,s){"use strict";var l=t.WHITE,u=.1,c=new e(8,8),d=new e(0,0),h=new e(1,1),m=function(e){e=i(e,i.EMPTY_OBJECT),this._definitionChanged=new o,this._color=void 0,this._colorSubscription=void 0,this._cellAlpha=void 0,this._cellAlphaSubscription=void 0,this._lineCount=void 0,this._lineCountSubscription=void 0,this._lineThickness=void 0,this._lineThicknessSubscription=void 0,this._lineOffset=void 0,this._lineOffsetSubscription=void 0,this.color=e.color,this.cellAlpha=e.cellAlpha,this.lineCount=e.lineCount,this.lineThickness=e.lineThickness,this.lineOffset=e.lineOffset};return r(m.prototype,{isConstant:{get:function(){return s.isConstant(this._color)&&s.isConstant(this._cellAlpha)&&s.isConstant(this._lineCount)&&s.isConstant(this._lineThickness)&&s.isConstant(this._lineOffset)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color"),cellAlpha:a("cellAlpha"),lineCount:a("lineCount"),lineThickness:a("lineThickness"),lineOffset:a("lineOffset")}),m.prototype.getType=function(){return"Grid"},m.prototype.getValue=function(e,t){return n(t)||(t={}),t.color=s.getValueOrClonedDefault(this._color,e,l,t.color),t.cellAlpha=s.getValueOrDefault(this._cellAlpha,e,u),t.lineCount=s.getValueOrClonedDefault(this._lineCount,e,c,t.lineCount),t.lineThickness=s.getValueOrClonedDefault(this._lineThickness,e,h,t.lineThickness),t.lineOffset=s.getValueOrClonedDefault(this._lineOffset,e,d,t.lineOffset),t},m.prototype.equals=function(e){return this===e||e instanceof m&&s.equals(this._color,e._color)&&s.equals(this._cellAlpha,e._cellAlpha)&&s.equals(this._lineCount,e._lineCount)&&s.equals(this._lineThickness,e._lineThickness)&&s.equals(this._lineOffset,e._lineOffset)},m}),define("Cesium/DataSources/PolylineGlowMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,i,n,r,o,a){"use strict";var s=e.WHITE,l=.25,u=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new r,this._color=void 0,this._colorSubscription=void 0,this._glowPower=void 0,this._glowPowerSubscription=void 0,this.color=e.color,this.glowPower=e.glowPower};return n(u.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._glow)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),glowPower:o("glowPower")}),u.prototype.getType=function(){return"PolylineGlow"},u.prototype.getValue=function(e,t){return i(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,s,t.color),t.glowPower=a.getValueOrDefault(this._glowPower,e,l,t.glowPower),t},u.prototype.equals=function(e){return this===e||e instanceof u&&a.equals(this._color,e._color)&&a.equals(this._glowPower,e._glowPower)},u}),define("Cesium/DataSources/PolylineOutlineMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,i,n,r,o,a){"use strict";var s=e.WHITE,l=e.BLACK,u=1,c=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new r,this._color=void 0,this._colorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this.color=e.color,this.outlineColor=e.outlineColor,this.outlineWidth=e.outlineWidth};return n(c.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._outlineColor)&&a.isConstant(this._outlineWidth)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth")}),c.prototype.getType=function(){return"PolylineOutline"},c.prototype.getValue=function(e,t){return i(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,s,t.color),t.outlineColor=a.getValueOrClonedDefault(this._outlineColor,e,l,t.outlineColor),t.outlineWidth=a.getValueOrDefault(this._outlineWidth,e,u),t},c.prototype.equals=function(e){return this===e||e instanceof c&&a.equals(this._color,e._color)&&a.equals(this._outlineColor,e._outlineColor)&&a.equals(this._outlineWidth,e._outlineWidth)},c}),define("Cesium/DataSources/PositionPropertyArray",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/ReferenceFrame","./Property"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(t,i){this._value=void 0,this._definitionChanged=new r,this._eventHelper=new o,this._referenceFrame=e(i,a.FIXED),this.setValue(t)};return i(l.prototype,{isConstant:{get:function(){var e=this._value;if(!t(e))return!0;for(var i=e.length,n=0;i>n;n++)if(!s.isConstant(e[n]))return!1;return!0}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,i,n){var r=this._value;if(!t(r))return void 0;var o=r.length;t(n)||(n=new Array(o));for(var a=0,s=0;o>a;){var l=r[a],u=l.getValueInReferenceFrame(e,i,n[a]);t(u)&&(n[s]=u,s++),a++}return n.length=s,n},l.prototype.setValue=function(e){var i=this._eventHelper;if(i.removeAll(),t(e)){this._value=e.slice();for(var n=e.length,r=0;n>r;r++){var o=e[r];t(o)&&i.add(o.definitionChanged,l.prototype._raiseDefinitionChanged,this)}}else this._value=void 0;this._definitionChanged.raiseEvent(this)},l.prototype.equals=function(e){return this===e||e instanceof l&&this._referenceFrame===e._referenceFrame&&s.arrayEquals(this._value,e._value)},l.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},l}),define("Cesium/DataSources/ReferenceProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/RuntimeError","./Property"],function(e,t,i,n,r,o){"use strict";function a(t){var i=!0;if(t._resolveEntity){var n=t._targetCollection.getById(t._targetId);if(e(n)?(n.definitionChanged.addEventListener(l.prototype._onTargetEntityDefinitionChanged,t),t._targetEntity=n,t._resolveEntity=!1):(n=t._targetEntity,i=!1),!e(n))throw new r('target entity "'+t._targetId+'" could not be resolved.')}return i}function s(t){var i=t._targetProperty;if(t._resolveProperty){var n=a(t),o=t._targetPropertyNames;i=t._targetEntity;for(var s=o.length,l=0;s>l&&e(i);l++)i=i[o[l]];if(e(i))t._targetProperty=i,t._resolveProperty=!n;else if(!e(t._targetProperty))throw new r('targetProperty "'+t._targetId+"."+o.join(".")+'" could not be resolved.')}return i}var l=function(e,t,i){this._targetCollection=e,this._targetId=t,this._targetPropertyNames=i,this._targetProperty=void 0,this._targetEntity=void 0,this._definitionChanged=new n,this._resolveEntity=!0,this._resolveProperty=!0,e.collectionChanged.addEventListener(l.prototype._onCollectionChanged,this)};return t(l.prototype,{isConstant:{get:function(){return o.isConstant(s(this))}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return s(this).referenceFrame}},targetId:{get:function(){return this._targetId}},targetCollection:{get:function(){return this._targetCollection}},targetPropertyNames:{get:function(){return this._targetPropertyNames}},resolvedProperty:{get:function(){return s(this)}}}),l.fromString=function(e,t){for(var i,n=[],r=!0,o=!1,a="",s=0;s<t.length;++s){var u=t.charAt(s);o?(a+=u,o=!1):"\\"===u?o=!0:r&&"#"===u?(i=a,r=!1,a=""):r||"."!==u?a+=u:(n.push(a),a="")}return n.push(a),new l(e,i,n)},l.prototype.getValue=function(e,t){return s(this).getValue(e,t)},l.prototype.getValueInReferenceFrame=function(e,t,i){return s(this).getValueInReferenceFrame(e,t,i)},l.prototype.getType=function(e){return s(this).getType(e)},l.prototype.equals=function(e){if(this===e)return!0;var t=this._targetPropertyNames,i=e._targetPropertyNames;if(this._targetCollection!==e._targetCollection||this._targetId!==e._targetId||t.length!==i.length)return!1;for(var n=this._targetPropertyNames.length,r=0;n>r;r++)if(t[r]!==i[r])return!1;return!0},l.prototype._onTargetEntityDefinitionChanged=function(e,t){this._targetPropertyNames[0]===t&&(this._resolveProperty=!0,this._definitionChanged.raiseEvent(this))},l.prototype._onCollectionChanged=function(t,i,n){var r=this._targetEntity;e(r)&&(-1!==n.indexOf(r)?(r.definitionChanged.removeEventListener(l.prototype._onTargetEntityDefinitionChanged,this),this._resolveEntity=!0,this._resolveProperty=!0):this._resolveEntity&&(s(this),this._resolveEntity||this._definitionChanged.raiseEvent(this)))},l}),define("Cesium/DataSources/SampledProperty",["../Core/binarySearch","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ExtrapolationType","../Core/JulianDate","../Core/LinearApproximation"],function(e,t,i,n,r,o,a,s,l){"use strict";function u(e,t,i){var n,r=e.length,o=i.length,a=r+o;if(e.length=a,r!==t){var s=r-1;for(n=a-1;n>=t;n--)e[n]=e[s--]}for(n=0;o>n;n++)e[t++]=i[n]}function c(e,t){return e instanceof s?e:"string"==typeof e?s.fromIso8601(e):s.addSeconds(t,e,new s)}var d={packedLength:1,pack:function(e,i,n){n=t(n,0),i[n]=e},unpack:function(e,i){return i=t(i,0),e[i]}},h=[],m=[],p=function(t,n,r,o,a){for(var l,d,p,f,v,g,_=0;_<o.length;){v=c(o[_],t),p=e(n,v,s.compare);var y=0,C=0;if(0>p){for(p=~p,f=p*a,d=void 0,g=n[p];_<o.length&&(v=c(o[_],t),!(i(d)&&s.compare(d,v)>=0||i(g)&&s.compare(v,g)>=0));){for(h[y++]=v,_+=1,l=0;a>l;l++)m[C++]=o[_],_+=1;d=v}y>0&&(m.length=C,u(r,f,m),h.length=y,u(n,p,h))}else{for(l=0;a>l;l++)_++,r[p*a+l]=o[_];_++}}},f=function(e,n){var r=e;r===Number&&(r=d);var s,u=r.packedLength,c=t(r.packedInterpolationLength,u),h=0;if(i(n)){var m=n.length;s=new Array(m);for(var p=0;m>p;p++){var f=n[p];f===Number&&(f=d);var v=f.packedLength;u+=v,c+=t(f.packedInterpolationLength,v),s[p]=f}h=m}this._type=e,this._innerType=r,this._interpolationDegree=1,this._interpolationAlgorithm=l,this._numberOfPoints=0,this._times=[],this._values=[],this._xTable=[],this._yTable=[],this._packedLength=u,this._packedInterpolationLength=c,this._updateTableLength=!0,this._interpolationResult=new Array(c),this._definitionChanged=new o,this._derivativeTypes=n,this._innerDerivativeTypes=s,this._inputOrder=h,this._forwardExtrapolationType=a.NONE,this._forwardExtrapolationDuration=0,this._backwardExtrapolationType=a.NONE,this._backwardExtrapolationDuration=0};return n(f.prototype,{isConstant:{get:function(){return 0===this._values.length}},definitionChanged:{get:function(){return this._definitionChanged}},type:{get:function(){return this._type}},derivativeTypes:{get:function(){return this._derivativeTypes}},interpolationDegree:{get:function(){return this._interpolationDegree}},interpolationAlgorithm:{get:function(){return this._interpolationAlgorithm}},forwardExtrapolationType:{get:function(){return this._forwardExtrapolationType},set:function(e){this._forwardExtrapolationType!==e&&(this._forwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},forwardExtrapolationDuration:{get:function(){return this._forwardExtrapolationDuration},set:function(e){this._forwardExtrapolationDuration!==e&&(this._forwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationType:{get:function(){return this._backwardExtrapolationType},set:function(e){this._backwardExtrapolationType!==e&&(this._backwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationDuration:{get:function(){return this._backwardExtrapolationDuration},set:function(e){this._backwardExtrapolationDuration!==e&&(this._backwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}}}),f.prototype.getValue=function(t,n){var r=this._times,o=r.length;if(0===o)return void 0;var l,u=this._innerType,c=this._values,d=e(r,t,s.compare);if(0>d){if(d=~d,0===d){var h=r[d];if(l=this._backwardExtrapolationDuration,this._backwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(h,t)>l)return void 0;if(this._backwardExtrapolationType===a.HOLD)return u.unpack(c,0,n)}if(d>=o){d=o-1;var m=r[d];if(l=this._forwardExtrapolationDuration,this._forwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(t,m)>l)return void 0;if(this._forwardExtrapolationType===a.HOLD)return d=o-1,u.unpack(c,d*u.packedLength,n)}var p=this._xTable,f=this._yTable,v=this._interpolationAlgorithm,g=this._packedInterpolationLength,_=this._inputOrder;if(this._updateTableLength){this._updateTableLength=!1;var y=Math.min(v.getRequiredDataPoints(this._interpolationDegree,_),o);y!==this._numberOfPoints&&(this._numberOfPoints=y,p.length=y,f.length=y*g)}var C=this._numberOfPoints-1;if(1>C)return void 0;var w=0,E=o-1,b=E-w+1;if(C+1>b);else{var S=d-(0|C/2)-1;w>S&&(S=w);var x=S+C;x>E&&(x=E,S=x-C,w>S&&(S=w)),w=S,E=x}for(var T=E-w+1,P=0;T>P;++P)p[P]=s.secondsDifference(r[w+P],r[E]);if(i(u.convertPackedArrayForInterpolation))u.convertPackedArrayForInterpolation(c,w,E,f);else for(var A=0,M=this._packedLength,I=w*M,D=(E+1)*M;D>I;)f[A]=c[I],I++,A++;var O,R=s.secondsDifference(t,r[E]);if(0!==_&&i(v.interpolate)){var L=Math.floor(g/(_+1));O=v.interpolate(R,p,f,L,_,_,this._interpolationResult)}else O=v.interpolateOrderZero(R,p,f,g,this._interpolationResult);return i(u.unpackInterpolationResult)?u.unpackInterpolationResult(O,c,w,E,n):u.unpack(O,0,n)}return u.unpack(c,d*this._packedLength,n)},f.prototype.setInterpolationOptions=function(e){var t=!1,i=e.interpolationAlgorithm,n=e.interpolationDegree;this._interpolationAlgorithm!==i&&(this._interpolationAlgorithm=i,t=!0),this._interpolationDegree!==n&&(this._interpolationDegree=n,t=!0),t&&(this._updateTableLength=!0,this._definitionChanged.raiseEvent(this))},f.prototype.addSample=function(e,t,n){var r=this._innerDerivativeTypes,o=i(r),a=this._innerType,s=[];if(s.push(e),a.pack(t,s,s.length),o)for(var l=r.length,u=0;l>u;u++)r[u].pack(n[u],s,s.length);p(void 0,this._times,this._values,s,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.addSamples=function(e,t,n){for(var r=this._innerDerivativeTypes,o=i(r),a=this._innerType,s=e.length,l=[],u=0;s>u;u++)if(l.push(e[u]),a.pack(t[u],l,l.length),o)for(var c=n[u],d=r.length,h=0;d>h;h++)r[h].pack(c[h],l,l.length);p(void 0,this._times,this._values,l,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.addSamplesPackedArray=function(e,t){p(t,this._times,this._values,e,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.equals=function(e){if(this===e)return!0;if(!i(e))return!1;if(this._type!==e._type||this._interpolationDegree!==e._interpolationDegree||this._interpolationAlgorithm!==e._interpolationAlgorithm)return!1;var t=this._derivativeTypes,n=i(t),r=e._derivativeTypes,o=i(r);if(n!==o)return!1;var a,l;if(n){if(l=t.length,l!==r.length)return!1;for(a=0;l>a;a++)if(t[a]!==r[a])return!1}var u=this._times,c=e._times;if(l=u.length,l!==c.length)return!1;for(a=0;l>a;a++)if(!s.equals(u[a],c[a]))return!1;var d=this._values,h=e._values;for(a=0;l>a;a++)if(d[a]!==h[a])return!1;return!0},f._mergeNewSamples=p,f}),define("Cesium/DataSources/SampledPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty","./Property","./SampledProperty"],function(e,t,i,n,r,o,a,s,l,u){"use strict";var c=function(i,n){n=t(n,0);var r;if(n>0){r=new Array(n);for(var s=0;n>s;s++)r[s]=e}this._numberOfDerivatives=n,this._property=new u(e,r),this._definitionChanged=new o,this._referenceFrame=t(i,a.FIXED),this._property._definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this)},this)};return n(c.prototype,{isConstant:{get:function(){return this._property.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}},interpolationDegree:{get:function(){return this._property.interpolationDegree}},interpolationAlgorithm:{get:function(){return this._property.interpolationAlgorithm}},numberOfDerivatives:{get:function(){return this._numberOfDerivatives}},forwardExtrapolationType:{get:function(){return this._property.forwardExtrapolationType},set:function(e){this._property.forwardExtrapolationType=e}},forwardExtrapolationDuration:{get:function(){return this._property.forwardExtrapolationDuration},set:function(e){this._property.forwardExtrapolationDuration=e}},backwardExtrapolationType:{get:function(){return this._property.backwardExtrapolationType},set:function(e){this._property.backwardExtrapolationType=e}},backwardExtrapolationDuration:{get:function(){return this._property.backwardExtrapolationDuration},set:function(e){this._property.backwardExtrapolationDuration=e}}}),c.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},c.prototype.getValueInReferenceFrame=function(e,t,n){return n=this._property.getValue(e,n),i(n)?s.convertToReferenceFrame(e,n,this._referenceFrame,t,n):void 0
},c.prototype.setInterpolationOptions=function(e){this._property.setInterpolationOptions(e)},c.prototype.addSample=function(e,t,i){this._numberOfDerivatives,this._property.addSample(e,t,i)},c.prototype.addSamples=function(e,t,i){this._property.addSamples(e,t,i)},c.prototype.addSamplesPackedArray=function(e,t){this._property.addSamplesPackedArray(e,t)},c.prototype.equals=function(e){return this===e||e instanceof c&&l.equals(this._property,e._property)&&this._referenceFrame===e._referenceFrame},c}),define("Cesium/DataSources/StripeOrientation",["../Core/freezeObject"],function(e){"use strict";var t={HORIZONTAL:0,VERTICAL:1};return e(t)}),define("Cesium/DataSources/StripeMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property","./StripeOrientation"],function(e,t,i,n,r,o,a,s){"use strict";var l=s.HORIZONTAL,u=e.WHITE,c=e.BLACK,d=0,h=1,m=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new r,this._orientation=void 0,this._orientationSubscription=void 0,this._evenColor=void 0,this._evenColorSubscription=void 0,this._oddColor=void 0,this._oddColorSubscription=void 0,this._offset=void 0,this._offsetSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.orientation=e.orientation,this.evenColor=e.evenColor,this.oddColor=e.oddColor,this.offset=e.offset,this.repeat=e.repeat};return n(m.prototype,{isConstant:{get:function(){return a.isConstant(this._orientation)&&a.isConstant(this._evenColor)&&a.isConstant(this._oddColor)&&a.isConstant(this._offset)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},orientation:o("orientation"),evenColor:o("evenColor"),oddColor:o("oddColor"),offset:o("offset"),repeat:o("repeat")}),m.prototype.getType=function(){return"Stripe"},m.prototype.getValue=function(e,t){return i(t)||(t={}),t.horizontal=a.getValueOrDefault(this._orientation,e,l)===s.HORIZONTAL,t.evenColor=a.getValueOrClonedDefault(this._evenColor,e,u,t.evenColor),t.oddColor=a.getValueOrClonedDefault(this._oddColor,e,c,t.oddColor),t.offset=a.getValueOrDefault(this._offset,e,d),t.repeat=a.getValueOrDefault(this._repeat,e,h),t},m.prototype.equals=function(e){return this===e||e instanceof m&&a.equals(this._orientation,e._orientation)&&a.equals(this._evenColor,e._evenColor)&&a.equals(this._oddColor,e._oddColor)&&a.equals(this._offset,e._offset)&&a.equals(this._repeat,e._repeat)},m}),define("Cesium/DataSources/TimeIntervalCollectionPositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","../Core/TimeIntervalCollection","./PositionProperty","./Property"],function(e,t,i,n,r,o,a,s,l){"use strict";var u=function(t){this._definitionChanged=new r,this._intervals=new a,this._intervals.changedEvent.addEventListener(u.prototype._intervalsChanged,this),this._referenceFrame=e(t,o.FIXED)};return i(u.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}},referenceFrame:{get:function(){return this._referenceFrame}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,i,n){var r=this._intervals.findDataForIntervalContainingDate(e);return t(r)?s.convertToReferenceFrame(e,r,this._referenceFrame,i,n):void 0},u.prototype.equals=function(e){return this===e||e instanceof u&&this._intervals.equals(e._intervals,l.equals)&&this._referenceFrame===e._referenceFrame},u.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},u}),define("Cesium/DataSources/TimeIntervalCollectionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/TimeIntervalCollection","./Property"],function(e,t,i,n,r,o){"use strict";var a=function(){this._definitionChanged=new n,this._intervals=new r,this._intervals.changedEvent.addEventListener(a.prototype._intervalsChanged,this)};return t(a.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),a.prototype.getValue=function(t,i){var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)&&"function"==typeof n.clone?n.clone(i):n},a.prototype.equals=function(e){return this===e||e instanceof a&&this._intervals.equals(e._intervals,o.equals)},a.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},a}),define("Cesium/DataSources/CzmlDataSource",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/ClockRange","../Core/ClockStep","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/deprecationWarning","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/ExtrapolationType","../Core/getFilenameFromUri","../Core/HermitePolynomialApproximation","../Core/isArray","../Core/Iso8601","../Core/JulianDate","../Core/LagrangePolynomialApproximation","../Core/LinearApproximation","../Core/loadJson","../Core/Math","../Core/Quaternion","../Core/Rectangle","../Core/ReferenceFrame","../Core/RuntimeError","../Core/Spherical","../Core/TimeInterval","../Core/TimeIntervalCollection","../Scene/HorizontalOrigin","../Scene/LabelStyle","../Scene/VerticalOrigin","../ThirdParty/Uri","../ThirdParty/when","./BillboardGraphics","./ColorMaterialProperty","./CompositeMaterialProperty","./CompositePositionProperty","./CompositeProperty","./ConstantPositionProperty","./ConstantProperty","./DataSource","./DataSourceClock","./EllipseGraphics","./EllipsoidGraphics","./EntityCollection","./GridMaterialProperty","./ImageMaterialProperty","./LabelGraphics","./ModelGraphics","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGlowMaterialProperty","./PolylineGraphics","./PolylineOutlineMaterialProperty","./PositionPropertyArray","./RectangleGraphics","./ReferenceProperty","./SampledPositionProperty","./SampledProperty","./StripeMaterialProperty","./StripeOrientation","./TimeIntervalCollectionPositionProperty","./TimeIntervalCollectionProperty","./WallGraphics"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M,I,D,O,R,L,N,z,F,B,V,k,U,W,G,H,q,j,Y,X,Z,J,K,Q,$,et,tt,it,nt,rt,ot,at,st,lt,ut,ct,dt,ht,mt){"use strict";function pt(e,t){return"#"===t[0]&&(t=$t+t),at.fromString(e,t)}function ft(e){var t=e.rgbaf;if(l(t))return t;var i=e.rgba;if(!l(i))return void 0;if(i.length===o.length)return[o.byteToFloat(i[0]),o.byteToFloat(i[1]),o.byteToFloat(i[2]),o.byteToFloat(i[3])];var n=i.length;t=new Array(n);for(var r=0;n>r;r+=5)t[r]=i[r],t[r+1]=o.byteToFloat(i[r+1]),t[r+2]=o.byteToFloat(i[r+2]),t[r+3]=o.byteToFloat(i[r+3]),t[r+4]=o.byteToFloat(i[r+4]);return t}function vt(e,t){var i=s(e.uri,e);if(l(t)){var n=new L(document.location.href);t=new L(t),i=new L(i).resolve(t.resolve(n)).toString()}return i}function gt(e){var t=e.wsenDegrees;if(l(t)){for(var i=t.length,n=0;i>n;n++)t[n]=b.toRadians(t[n]);return t}return e.wsen}function _t(e){if(l(e.cartesian))return e.cartesian;if(l(e.cartesianVelocity))return e.cartesianVelocity;if(l(e.unitCartesian))return e.unitCartesian;var i,n,r,o=e.unitSpherical;if(l(o)){if(n=o.length,2===n)ti.clock=o[0],ti.cone=o[1],t.fromSpherical(ti,ei),r=[ei.x,ei.y,ei.z];else{var a=0;for(r=new Array(4*(n/3)),i=0;n>i;i+=4)r[i]=o[a++],ti.clock=o[a++],ti.cone=o[a++],t.fromSpherical(ti,ei),r[i+1]=ei.x,r[i+2]=ei.y,r[i+3]=ei.z}return r}var s=e.cartographicRadians;if(l(s)){if(3===s.length)ii.longitude=s[0],ii.latitude=s[1],ii.height=s[2],h.WGS84.cartographicToCartesian(ii,ei),r=[ei.x,ei.y,ei.z];else for(n=s.length,r=new Array(n),i=0;n>i;i+=4)ii.longitude=s[i+1],ii.latitude=s[i+2],ii.height=s[i+3],h.WGS84.cartographicToCartesian(ii,ei),r[i]=s[i],r[i+1]=ei.x,r[i+2]=ei.y,r[i+3]=ei.z;return r}var u=e.cartographicDegrees;if(!l(u))throw new P(JSON.stringify(e)+" is not a valid CZML interval.");if(3===u.length)ii.longitude=b.toRadians(u[0]),ii.latitude=b.toRadians(u[1]),ii.height=u[2],h.WGS84.cartographicToCartesian(ii,ei),r=[ei.x,ei.y,ei.z];else for(n=u.length,r=new Array(n),i=0;n>i;i+=4)ii.longitude=b.toRadians(u[i+1]),ii.latitude=b.toRadians(u[i+2]),ii.height=u[i+3],h.WGS84.cartographicToCartesian(ii,ei),r[i]=u[i],r[i+1]=ei.x,r[i+2]=ei.y,r[i+3]=ei.z;return r}function yt(e,t){var i=e[t],n=e[t+1],r=e[t+2],o=e[t+3],a=1/Math.sqrt(i*i+n*n+r*r+o*o);e[t]=i*a,e[t+1]=n*a,e[t+2]=r*a,e[t+3]=o*a}function Ct(e){var t=e.unitQuaternion;if(l(t)){if(4===t.length)return yt(t,0),t;for(var i=1;i<t.length;i+=5)yt(t,i)}return t}function wt(i,n,r){switch(i){case Boolean:return s(n["boolean"],n);case e:return n.cartesian2;case t:return _t(n);case o:return ft(n);case ct:return ct[s(n.stripeOrientation,n)];case D:return D[s(n.horizontalOrigin,n)];case Image:return vt(n,r);case y:return y.fromIso8601(s(n.date,n));case O:return O[s(n.labelStyle,n)];case Number:return s(n.number,n);case String:return s(n.string,n);case Array:return n.array;case S:return Ct(n);case x:return gt(n);case L:return vt(n,r);case R:return R[s(n.verticalOrigin,n)];default:throw new P(i)}}function Et(e,t){var i=e.interpolationAlgorithm;(l(i)||l(e.interpolationDegree))&&t.setInterpolationOptions({interpolationAlgorithm:ri[i],interpolationDegree:e.interpolationDegree});var n=e.forwardExtrapolationType;l(n)&&(t.forwardExtrapolationType=p[n]);var r=e.forwardExtrapolationDuration;l(r)&&(t.forwardExtrapolationDuration=r);var o=e.backwardExtrapolationType;l(o)&&(t.backwardExtrapolationType=p[o]);var a=e.backwardExtrapolationDuration;l(a)&&(t.backwardExtrapolationDuration=a)}function bt(e,t,i,n,r,o,a){var u,c=n.interval;l(c)?(oi.iso8601=c,u=M.fromIso8601(oi),l(r)&&(u=M.intersect(u,r,ni))):l(r)&&(u=r);var d,h,m,p,f=l(n.reference),v=l(u)&&!u.equals(_.MAXIMUM_INTERVAL);if(f||(m=wt(e,n,o),d=s(e.packedLength,1),p=s(m.length,1),h=!l(n.array)&&"string"!=typeof m&&p>d),!h&&!v)return t[i]=f?pt(a,n.reference):l(e.unpack)?new W(e.unpack(m,0)):new W(m),void 0;var g,C=t[i],w=n.epoch;if(l(w)&&(g=y.fromIso8601(w)),h&&!v)return C instanceof lt||(C=new lt(e),t[i]=C),C.addSamplesPackedArray(m,g),Et(n,C),void 0;var E;if(!h&&v)return u=u.clone(),u.data=f?pt(a,n.reference):l(e.unpack)?e.unpack(m,0):m,l(C)||(C=f?new k:new ht,t[i]=C),!f&&C instanceof ht?C.intervals.addInterval(u):C instanceof k?(u.data=f?u.data:new W(u.data),C.intervals.addInterval(u)):(E=_.MAXIMUM_INTERVAL.clone(),E.data=C,C=new k,t[i]=C,C.intervals.addInterval(E),u.data=f?u.data:new W(u.data),C.intervals.addInterval(u)),void 0;l(C)||(C=new k,t[i]=C),C instanceof k||(E=_.MAXIMUM_INTERVAL.clone(),E.data=C,C=new k,t[i]=C,C.intervals.addInterval(E));var b=C.intervals;E=b.findInterval(u),l(E)&&E.data instanceof lt||(E=u.clone(),E.data=new lt(e),b.addInterval(E)),E.data.addSamplesPackedArray(m,g),Et(n,E.data)}function St(e,t,i,n,r,o,a){if(l(n))if(g(n))for(var s=0,u=n.length;u>s;s++)bt(e,t,i,n[s],r,o,a);else bt(e,t,i,n,r,o,a)}function xt(e,i,n,r,o,a){var u,c=n.interval;l(c)?(oi.iso8601=c,u=M.fromIso8601(oi),l(r)&&(u=M.intersect(u,r,ni))):l(r)&&(u=r);var d,h,m,p=!1,f=l(n.cartesianVelocity)?1:0,v=t.packedLength*(f+1),g=l(n.reference),C=l(u)&&!u.equals(_.MAXIMUM_INTERVAL);if(g||(d=s(T[n.referenceFrame],void 0),h=_t(n),m=s(h.length,1),p=m>v),!p&&!C)return e[i]=g?pt(a,n.reference):new U(t.unpack(h),d),void 0;var w,E=e[i],b=n.epoch;if(l(b)&&(w=y.fromIso8601(b)),p&&!C)return(!(E instanceof st)||l(d)&&E.referenceFrame!==d)&&(E=new st(d,f),e[i]=E),E.addSamplesPackedArray(h,w),Et(n,E),void 0;var S;if(!p&&C)return u=u.clone(),u.data=g?pt(a,n.reference):t.unpack(h),l(E)||(E=g?new V(d):new dt(d),e[i]=E),!g&&E instanceof dt&&l(d)&&E.referenceFrame===d?E.intervals.addInterval(u):E instanceof V?(u.data=g?u.data:new U(u.data,d),E.intervals.addInterval(u)):(S=_.MAXIMUM_INTERVAL.clone(),S.data=E,E=new V(E.referenceFrame),e[i]=E,E.intervals.addInterval(S),u.data=g?u.data:new U(u.data,d),E.intervals.addInterval(u)),void 0;l(E)?E instanceof V||(S=_.MAXIMUM_INTERVAL.clone(),S.data=E,E=new V(E.referenceFrame),e[i]=E,E.intervals.addInterval(S)):(E=new V(d),e[i]=E);var x=E.intervals;S=x.findInterval(u),l(S)&&S.data instanceof st&&(!l(d)||S.data.referenceFrame===d)||(S=u.clone(),S.data=new st(d,f),x.addInterval(S)),S.data.addSamplesPackedArray(h,w),Et(n,S.data)}function Tt(e,t,i,n,r,o){if(l(i))if(g(i))for(var a=0,s=i.length;s>a;a++)xt(e,t,i[a],n,r,o);else xt(e,t,i,n,r,o)}function Pt(t,i,n,r,a,s){var u,c=n.interval;l(c)?(oi.iso8601=c,u=M.fromIso8601(oi),l(r)&&(u=M.intersect(u,r,ni))):l(r)&&(u=r);var d,h,m=t[i];if(l(u)){m instanceof B||(m=new B,t[i]=m);var p=m.intervals;h=p.findInterval({start:u.start,stop:u.stop}),l(h)?d=h.data:(h=u.clone(),p.addInterval(h))}else d=m;var f;l(n.solidColor)?(d instanceof F||(d=new F),f=n.solidColor,St(o,d,"color",f.color,void 0,void 0,s)):l(n.grid)?(d instanceof X||(d=new X),f=n.grid,St(o,d,"color",f.color,void 0,a,s),St(Number,d,"cellAlpha",f.cellAlpha,void 0,a,s),St(e,d,"lineThickness",f.lineThickness,void 0,a,s),St(e,d,"lineOffset",f.lineOffset,void 0,a,s),St(e,d,"lineCount",f.lineCount,void 0,a,s)):l(n.image)?(d instanceof Z||(d=new Z),f=n.image,St(Image,d,"image",f.image,void 0,a,s),St(e,d,"repeat",f.repeat,void 0,a,s)):l(n.stripe)?(d instanceof ut||(d=new ut),f=n.stripe,St(ct,d,"orientation",f.orientation,void 0,a,s),St(o,d,"evenColor",f.evenColor,void 0,a,s),St(o,d,"oddColor",f.oddColor,void 0,a,s),St(Number,d,"offset",f.offset,void 0,a,s),St(Number,d,"repeat",f.repeat,void 0,a,s)):l(n.polylineOutline)?(d instanceof nt||(d=new nt),f=n.polylineOutline,St(o,d,"color",f.color,void 0,a,s),St(o,d,"outlineColor",f.outlineColor,void 0,a,s),St(Number,d,"outlineWidth",f.outlineWidth,void 0,a,s)):l(n.polylineGlow)&&(d instanceof tt||(d=new tt),f=n.polylineGlow,St(o,d,"color",f.color,void 0,a,s),St(Number,d,"glowPower",f.glowPower,void 0,a,s)),l(h)?h.data=d:t[i]=d}function At(e,t,i,n,r,o){if(l(i))if(g(i))for(var a=0,s=i.length;s>a;a++)Pt(e,t,i[a],n,r,o);else Pt(e,t,i,n,r,o)}function Mt(e,t){e.name=s(t.name,e.name)}function It(e,t,i,n){var r=t.description;l(r)&&St(String,e,"description",r,void 0,n,i)}function Dt(e,t,i,n){var r=t.position;l(r)&&Tt(e,"position",r,void 0,n,i)}function Ot(e,i,n,r){var o=i.viewFrom;l(o)&&St(t,e,"viewFrom",o,void 0,r,n)}function Rt(e,t,i,n){var r=t.orientation;l(r)&&St(S,e,"orientation",r,void 0,n,i)}function Lt(e,i,n,r){var o,a,s=n.references;if(l(s)){var u=[];for(o=0,a=s.length;a>o;o++)u.push(pt(r,s[o]));var c=n.interval;if(l(c)){if(c=M.fromIso8601(c),!(e[i]instanceof V)){c.data=new rt(u);var d=new V;d.intervals.addInterval(c),e[i]=d}}else e[i]=new rt(u)}else{var m=[],p=n.cartesian;if(l(p)){for(o=0,a=p.length;a>o;o+=3)m.push(new t(p[o],p[o+1],p[o+2]));n.array=m}else if(p=n.cartographicRadians,l(p)){for(o=0,a=p.length;a>o;o+=3)ii.longitude=p[o],ii.latitude=p[o+1],ii.height=p[o+2],m.push(h.WGS84.cartographicToCartesian(ii));n.array=m}else if(p=n.cartographicDegrees,l(p)){for(o=0,a=p.length;a>o;o+=3)m.push(t.fromDegrees(p[o],p[o+1],p[o+2]));n.array=m}l(n.array)&&St(Array,e,i,n,void 0,void 0,r)}}function Nt(e,t,i,n){if(l(i))if(g(i))for(var r=i.length,o=0;r>o;o++)Lt(e,t,i[o],n);else Lt(e,t,i,n)}function zt(e,t){var i,n=t.availability;if(l(n)){var r;if(g(n))for(var o=n.length,a=0;o>a;a++)l(r)||(r=new I),oi.iso8601=n[a],i=M.fromIso8601(oi),r.addInterval(i);else oi.iso8601=n,i=M.fromIso8601(oi),r=new I,r.addInterval(i);e.availability=r}}function Ft(i,n,r,a){var s=n.billboard;if(l(s)){var u,c=s.interval;l(c)&&(oi.iso8601=c,u=M.fromIso8601(oi));var d=i.billboard;l(d)||(i.billboard=d=new z),St(o,d,"color",s.color,u,a,r),St(t,d,"eyeOffset",s.eyeOffset,u,a,r),St(D,d,"horizontalOrigin",s.horizontalOrigin,u,a,r),St(Image,d,"image",s.image,u,a,r),St(e,d,"pixelOffset",s.pixelOffset,u,a,r),St(Number,d,"scale",s.scale,u,a,r),St(Number,d,"rotation",s.rotation,u,a,r),St(t,d,"alignedAxis",s.alignedAxis,u,a,r),St(Boolean,d,"show",s.show,u,a,r),St(R,d,"verticalOrigin",s.verticalOrigin,u,a,r)}}function Bt(e,t){var i=e.version;if(l(i)&&"string"==typeof i){var n=i.split(".");if(2===n.length){if("1"!==n[0])throw new P("Cesium only supports CZML version 1.");t._version=i}}if(!l(t._version))throw new P("CZML version information invalid.  It is expected to be a property on the document object in the <Major>.<Minor> version format.");var r=t._documentPacket;l(e.name)&&(r.name=e.name);var o=e.clock;if(l(o)){var a=r.clock;l(a)?(a.interval=s(o.interval,a.interval),a.currentTime=s(o.currentTime,a.currentTime),a.range=s(o.range,a.range),a.step=s(o.step,a.step),a.multiplier=s(o.multiplier,a.multiplier)):r.clock={interval:o.interval,currentTime:o.currentTime,range:o.range,step:o.step,multiplier:o.multiplier}}}function Vt(e,t,i,n){var r=t.ellipse;if(l(r)){var a,s=r.interval;l(s)&&(oi.iso8601=s,a=M.fromIso8601(oi));var u=e.ellipse;l(u)||(e.ellipse=u=new q),St(Boolean,u,"show",r.show,a,n,i),St(Number,u,"rotation",r.rotation,a,n,i),St(Number,u,"semiMajorAxis",r.semiMajorAxis,a,n,i),St(Number,u,"semiMinorAxis",r.semiMinorAxis,a,n,i),St(Number,u,"height",r.height,a,n,i),St(Number,u,"extrudedHeight",r.extrudedHeight,a,n,i),St(Number,u,"granularity",r.granularity,a,n,i),St(Number,u,"stRotation",r.stRotation,a,n,i),At(u,"material",r.material,a,n,i),St(Boolean,u,"fill",r.fill,a,n,i),St(Boolean,u,"outline",r.outline,a,n,i),St(o,u,"outlineColor",r.outlineColor,a,n,i),St(Number,u,"outlineWidth",r.outlineWidth,a,n,i),St(Number,u,"numberOfVerticalLines",r.numberOfVerticalLines,a,n,i)}}function kt(e,i,n,r){var a=i.ellipsoid;if(l(a)){var s,u=a.interval;l(u)&&(oi.iso8601=u,s=M.fromIso8601(oi));var c=e.ellipsoid;l(c)||(e.ellipsoid=c=new j),St(Boolean,c,"show",a.show,s,r,n),St(t,c,"radii",a.radii,s,r,n),At(c,"material",a.material,s,r,n),St(Boolean,c,"fill",a.fill,s,r,n),St(Boolean,c,"outline",a.outline,s,r,n),St(o,c,"outlineColor",a.outlineColor,s,r,n),St(Number,c,"outlineWidth",a.outlineWidth,s,r,n)}}function Ut(i,n,r,a){var s=n.label;if(l(s)){var u,c=s.interval;l(c)&&(oi.iso8601=c,u=M.fromIso8601(oi));var d=i.label;l(d)||(i.label=d=new J),St(o,d,"fillColor",s.fillColor,u,a,r),St(o,d,"outlineColor",s.outlineColor,u,a,r),St(Number,d,"outlineWidth",s.outlineWidth,u,a,r),St(t,d,"eyeOffset",s.eyeOffset,u,a,r),St(D,d,"horizontalOrigin",s.horizontalOrigin,u,a,r),St(String,d,"text",s.text,u,a,r),St(e,d,"pixelOffset",s.pixelOffset,u,a,r),St(Number,d,"scale",s.scale,u,a,r),St(Boolean,d,"show",s.show,u,a,r),St(R,d,"verticalOrigin",s.verticalOrigin,u,a,r),St(String,d,"font",s.font,u,a,r),St(O,d,"style",s.style,u,a,r)}}function Wt(e,t,i,n){var r=t.model;if(l(r)){var o,a=r.interval;l(a)&&(oi.iso8601=a,o=M.fromIso8601(oi));var s=e.model;l(s)||(e.model=s=new K),St(Boolean,s,"show",r.show,o,n,i),St(Number,s,"scale",r.scale,o,n,i),St(Number,s,"minimumPixelSize",r.minimumPixelSize,o,n,i),St(L,s,"uri",r.gltf,o,n,i)}}function Gt(e,t,i,n){var r=t.path;if(l(r)){var o,a=r.interval;l(a)&&(oi.iso8601=a,o=M.fromIso8601(oi));var s=e.path;l(s)||(e.path=s=new Q),St(Boolean,s,"show",r.show,o,n,i),St(Number,s,"width",r.width,o,n,i),St(Number,s,"resolution",r.resolution,o,n,i),St(Number,s,"leadTime",r.leadTime,o,n,i),St(Number,s,"trailTime",r.trailTime,o,n,i),At(s,"material",r.material,o,n,i)}}function Ht(e,t,i,n){var r=t.point;if(l(r)){var a,s=r.interval;l(s)&&(oi.iso8601=s,a=M.fromIso8601(oi));var u=e.point;l(u)||(e.point=u=new $),St(o,u,"color",r.color,a,n,i),St(Number,u,"pixelSize",r.pixelSize,a,n,i),St(o,u,"outlineColor",r.outlineColor,a,n,i),St(Number,u,"outlineWidth",r.outlineWidth,a,n,i),St(Boolean,u,"show",r.show,a,n,i)}}function qt(e,t,i,n){var r=t.polygon;if(l(r)){var a,s=r.interval;l(s)&&(oi.iso8601=s,a=M.fromIso8601(oi));var u=e.polygon;l(u)||(e.polygon=u=new et),St(Boolean,u,"show",r.show,a,n,i),At(u,"material",r.material,a,n,i),St(Number,u,"height",r.height,a,n,i),St(Number,u,"extrudedHeight",r.extrudedHeight,a,n,i),St(Number,u,"granularity",r.granularity,a,n,i),St(Number,u,"stRotation",r.stRotation,a,n,i),St(Boolean,u,"fill",r.fill,a,n,i),St(Boolean,u,"outline",r.outline,a,n,i),St(o,u,"outlineColor",r.outlineColor,a,n,i),St(Number,u,"outlineWidth",r.outlineWidth,a,n,i),St(Boolean,u,"perPositionHeight",r.perPositionHeight,a,n,i),Nt(u,"hierarchy",r.positions,i)}}function jt(e,t,i,n){var r=t.rectangle;if(l(r)){var a,s=r.interval;l(s)&&(oi.iso8601=s,a=M.fromIso8601(oi));var u=e.rectangle;l(u)||(e.rectangle=u=new ot),St(Boolean,u,"show",r.show,a,n,i),St(x,u,"coordinates",r.coordinates,a,n,i),At(u,"material",r.material,a,n,i),St(Number,u,"height",r.height,a,n,i),St(Number,u,"extrudedHeight",r.extrudedHeight,a,n,i),St(Number,u,"granularity",r.granularity,a,n,i),St(Number,u,"rotation",r.rotation,a,n,i),St(Number,u,"stRotation",r.stRotation,a,n,i),St(Boolean,u,"fill",r.fill,a,n,i),St(Boolean,u,"outline",r.outline,a,n,i),St(o,u,"outlineColor",r.outlineColor,a,n,i),St(Number,u,"outlineWidth",r.outlineWidth,a,n,i),St(Boolean,u,"closeBottom",r.closeBottom,a,n,i),St(Boolean,u,"closeTop",r.closeTop,a,n,i)}}function Yt(e,t,i,n){var r=t.wall;if(l(r)){var a,s=r.interval;l(s)&&(oi.iso8601=s,a=M.fromIso8601(oi));var u=e.wall;l(u)||(e.wall=u=new mt),St(Boolean,u,"show",r.show,a,n,i),At(u,"material",r.material,a,n,i),St(Array,u,"minimumHeights",r.minimumHeights,a,n,i),St(Array,u,"maximumHeights",r.maximumHeights,a,n,i),St(Number,u,"granularity",r.granularity,a,n,i),St(Boolean,u,"fill",r.fill,a,n,i),St(Boolean,u,"outline",r.outline,a,n,i),St(o,u,"outlineColor",r.outlineColor,a,n,i),St(Number,u,"outlineWidth",r.outlineWidth,a,n,i),Nt(u,"positions",r.positions,i)}}function Xt(e,t,i,n){var r=t.polyline;if(l(r)){var o,a=r.interval;l(a)&&(oi.iso8601=a,o=M.fromIso8601(oi));var s=e.polyline;l(s)||(e.polyline=s=new it),St(Boolean,s,"show",r.show,o,n,i),St(Number,s,"width",r.width,o,n,i),At(s,"material",r.material,o,n,i),St(Boolean,s,"followSurface",r.followSurface,o,n,i),St(Number,s,"granularity",r.granularity,o,n,i),Nt(s,"positions",r.positions,i)}}function Zt(e,t,i,n,r){var o=e.id;if(l(o)||(o=a()),$t=o,!l(r._version)&&"document"!==o)throw new P("The first CZML packet is required to be the document object.");if(e["delete"]===!0)t.removeById(o);else if("document"===o)Bt(e,r);else{var s=t.getOrCreateEntity(o),u=e.parent;l(u)&&(s.parent=t.getOrCreateEntity(u));for(var c=i.length-1;c>-1;c--)i[c](s,e,t,n)}$t=void 0}function Jt(e){var t,i=e._documentPacket.clock;if(!l(i)){if(!l(e._clock)){var o=e._entityCollection.computeAvailability();if(!o.start.equals(_.MINIMUM_VALUE)){var a=o.start,u=o.stop,c=y.secondsDifference(u,a),d=Math.round(c/120);return t=new H,t.startTime=y.clone(a),t.stopTime=y.clone(u),t.clockRange=n.LOOP_STOP,t.multiplier=d,t.currentTime=y.clone(a),t.clockStep=r.SYSTEM_CLOCK_MULTIPLIER,e._clock=t,!0}}return!1}if(l(e._clock)?t=e._clock.clone():(t=new H,t.startTime=_.MINIMUM_VALUE.clone(),t.stopTime=_.MAXIMUM_VALUE.clone(),t.currentTime=_.MINIMUM_VALUE.clone(),t.clockRange=n.LOOP_STOP,t.clockStep=r.SYSTEM_CLOCK_MULTIPLIER,t.multiplier=1),l(i.interval)){oi.iso8601=i.interval;var h=M.fromIso8601(oi);t.startTime=h.start,t.stopTime=h.stop}return l(i.currentTime)&&(t.currentTime=y.fromIso8601(i.currentTime)),l(i.range)&&(t.clockRange=s(n[i.range],n.LOOP_STOP)),l(i.step)&&(t.clockStep=s(r[i.step],r.SYSTEM_CLOCK_MULTIPLIER)),l(i.multiplier)&&(t.multiplier=i.multiplier),t.equals(e._clock)?!1:(e._clock=t.clone(e._clock),!0)}function Kt(e,t,i,n){i=s(i,s.EMPTY_OBJECT);var r=t,o=i.sourceUri;return"string"==typeof t&&(r=E(t),o=s(o,t)),G.setLoading(e,!0),N(r,function(t){return Qt(e,t,o,n)}).otherwise(function(t){return G.setLoading(e,!1),e._error.raiseEvent(e,t),window.console.log(t),N.reject(t)})}function Qt(e,t,i,n){G.setLoading(e,!0);var r=e._entityCollection;n&&(e._version=void 0,e._documentPacket=new ai,r.removeAll()),si._processCzml(t,r,i,void 0,e);var o=Jt(e),a=e._documentPacket;return l(a.name)&&e._name!==a.name?(e._name=a.name,o=!0):!l(e._name)&&l(i)&&(e._name=f(i),o=!0),G.setLoading(e,!1),o&&e._changed.raiseEvent(e),e}var $t,ei=new t,ti=new A,ii=new i,ni=new M,ri={HERMITE:v,LAGRANGE:C,LINEAR:w},oi={iso8601:void 0},ai=function(){this.name=void 0,this.clock=void 0},si=function(e){this._name=e,this._changed=new m,this._error=new m,this._isLoading=!1,this._loading=new m,this._clock=void 0,this._documentPacket=new ai,this._version=void 0,this._entityCollection=new Y};return si.load=function(e,t){return(new si).load(e,t)},u(si.prototype,{name:{get:function(){return this._name}},clock:{get:function(){return this._clock}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),si.updaters=[Ft,Vt,kt,Ut,Wt,Mt,It,Gt,Ht,qt,Xt,jt,Dt,Ot,Yt,Rt,zt],si.prototype.process=function(e,t){return"string"==typeof t&&(t={sourceUri:t},c("CzmlDataSource.process.options","Passing a sourceUri string as the second paraameter to CzmlDataSource.process has been deprecated. Pass an options object instead.")),Kt(this,e,t,!1)},si.prototype.load=function(e,t){return"string"==typeof t&&(t={sourceUri:t},c("CzmlDataSource.process.load","Passing a sourceUri string as the second paraameter to CzmlDataSource.load has been deprecated. Pass an options object instead.")),Kt(this,e,t,!0)},si.prototype.processUrl=function(e){return c("CzmlDataSource.prototype.processUrl","CzmlDataSource.processUrl has been deprecated.  Use CzmlDataSource.process instead."),this.process(e)},si.prototype.loadUrl=function(e){return c("CzmlDataSource.prototype.loadUrl","CzmlDataSource.loadUrl has been deprecated.  Use CzmlDataSource.load instead."),this.load(e)},si.processPacketData=St,si.processPositionPacketData=Tt,si.processMaterialPacketData=At,si._processCzml=function(e,t,i,n,r){if(n=l(n)?n:si.updaters,g(e))for(var o=0,a=e.length;a>o;o++)Zt(e[o],t,n,i,r);else Zt(e,t,n,i,r)},si}),define("Cesium/Core/definedNotNull",[],function(){"use strict";var e=function(e){return void 0!==e&&null!==e};return e}),define("Cesium/Core/isCrossOriginUrl",["./defined"],function(e){"use strict";var t,i=function(i){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,r=t.protocol;return t.href=i,t.href=t.href,r!==t.protocol||n!==t.host};return i}),define("Cesium/Core/loadImage",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./isCrossOriginUrl"],function(e,t,i,n,r){"use strict";var o=/^data:/,a=function(i,n){return n=t(n,!0),e(i,function(t){var i;i=o.test(t)||!n?!1:r(t);var s=e.defer();return a.createImage(t,i,s),s.promise})};return a.createImage=function(e,t,i){var n=new Image;n.onload=function(){i.resolve(n)},n.onerror=function(e){i.reject(e)},t&&(n.crossOrigin=""),n.src=e},a.defaultCreateImage=a.createImage,a}),define("Cesium/ThirdParty/measureText",[],function(){var e=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},t=function(t,i,n,r){var o=t.measureText(i),a=e(t.canvas,"font-family"),s=e(t.canvas,"font-size").replace("px",""),l=!/\S/.test(i);o.fontsize=s;var u=document.createElement("div");u.style.position="absolute",u.style.opacity=0,u.style.font=s+"px "+a,u.innerHTML=i+"<br/>"+i,document.body.appendChild(u),o.leading=1.2*s;var c=e(u,"height");if(c=c.replace("px",""),c>=2*s&&(o.leading=0|c/2),document.body.removeChild(u),l)o.ascent=0,o.descent=0,o.bounds={minx:0,maxx:o.width,miny:0,maxy:0},o.height=0;else{var d=document.createElement("canvas"),h=100;d.width=o.width+h,d.height=3*s,d.style.opacity=1,d.style.fontFamily=a,d.style.fontSize=s;var m=d.getContext("2d");m.font=s+"px "+a;var p=d.width,f=d.height,v=f/2;m.fillStyle="white",m.fillRect(-1,-1,p+2,f+2),n&&(m.strokeStyle="black",m.lineWidth=t.lineWidth,m.strokeText(i,h/2,v)),r&&(m.fillStyle="black",m.fillText(i,h/2,v));for(var g=m.getImageData(0,0,p,f).data,_=0,y=4*p,C=g.length;++_<C&&255===g[_];);var w=0|_/y;for(_=C-1;--_>0&&255===g[_];);var E=0|_/y;for(_=0;C>_&&255===g[_];)_+=y,_>=C&&(_=_-C+4);var b=0|_%y/4,S=1;for(_=C-3;_>=0&&255===g[_];)_-=y,0>_&&(_=C-3-4*S++);var x=0|_%y/4+1;o.ascent=v-w,o.descent=E-v,o.bounds={minx:b-h/2,maxx:x-h/2,miny:0,maxy:E-w},o.height=1+(E-w)}return o};return t}),define("Cesium/Core/writeTextToCanvas",["../ThirdParty/measureText","./Color","./defaultValue","./defined","./DeveloperError"],function(e,t,i,n){"use strict";var r,o=function(o,a){if(""===o)return void 0;a=i(a,i.EMPTY_OBJECT);var s=i(a.font,"10px sans-serif"),l=i(a.stroke,!1),u=i(a.fill,!0),c=i(a.strokeWidth,1),d=document.createElement("canvas");d.width=1,d.height=1,d.style.font=s;var h=d.getContext("2d");n(r)||(n(h.imageSmoothingEnabled)?r="imageSmoothingEnabled":n(h.mozImageSmoothingEnabled)?r="mozImageSmoothingEnabled":n(h.webkitImageSmoothingEnabled)?r="webkitImageSmoothingEnabled":n(h.msImageSmoothingEnabled)&&(r="msImageSmoothingEnabled")),h.font=s,h.lineJoin="round",h.lineWidth=c,h[r]=!1,h.textBaseline=i(a.textBaseline,"bottom"),d.style.visibility="hidden",document.body.appendChild(d);var m=e(h,o,l,u);m.computedWidth=Math.max(m.width,m.bounds.maxx-m.bounds.minx),d.dimensions=m,document.body.removeChild(d),d.style.visibility="";var p=m.height-m.ascent;d.width=m.computedWidth,d.height=m.height;var f=d.height-p;if(h.font=s,h.lineJoin="round",h.lineWidth=c,h[r]=!1,l){var v=i(a.strokeColor,t.BLACK);h.strokeStyle=v.toCssColorString(),h.strokeText(o,0,f)}if(u){var g=i(a.fillColor,t.WHITE);h.fillStyle=g.toCssColorString(),h.fillText(o,0,f)}return d};return o}),define("Cesium/Core/PinBuilder",["./buildModuleUrl","./Color","./defined","./DeveloperError","./loadImage","./writeTextToCanvas"],function(e,t,i,n,r,o){"use strict";function a(e,t,i){e.save(),e.scale(i/24,i/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,c).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function s(e,i,n){var r=n/2.5,o=r,a=r;i.width>i.height?a=r*(i.height/i.width):i.width<i.height&&(o=r*(i.width/i.height));var s=(n-o)/2,l=7/24*n-a/2;e.globalCompositeOperation="destination-out",e.drawImage(i,s-1,l,o,a),e.drawImage(i,s,l-1,o,a),e.drawImage(i,s+1,l,o,a),e.drawImage(i,s,l+1,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.BLACK.toCssColorString(),e.fillRect(s-1,l-1,o+1,a+1),e.globalCompositeOperation="destination-out",e.drawImage(i,s,l,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.WHITE.toCssColorString(),e.fillRect(s,l,o,a)}function l(e,t,n,l,u){d[0]=e,d[1]=t,d[2]=n,d[3]=l;var c=JSON.stringify(d),h=u[c];if(i(h))return h;var m=document.createElement("canvas");m.width=l,m.height=l;var p=m.getContext("2d");if(a(p,n,l),i(e)){var f=r(e).then(function(e){return s(p,e,l),u[c]=m,m});return u[c]=f,f}if(i(t)){var v=o(t,{font:"bold "+l+"px sans-serif"});s(p,v,l)}return u[c]=m,m}var u=function(){this._cache={}};u.prototype.fromColor=function(e,t){return l(void 0,void 0,e,t,this._cache)},u.prototype.fromUrl=function(e,t,i){return l(e,void 0,t,i,this._cache)},u.prototype.fromMakiIconId=function(t,i,n){return l(e("Assets/Textures/maki/"+encodeURIComponent(t)+".png"),void 0,i,n,this._cache)},u.prototype.fromText=function(e,t,i){return l(void 0,e,t,i,this._cache)};var c=new t,d=new Array(4);return u}),define("Cesium/Core/PolygonHierarchy",["./defined"],function(e){"use strict";var t=function(t,i){this.positions=e(t)?t:[],this.holes=e(i)?i:[]};return t}),!function(){function e(e,t){function i(t){var i,n=e.arcs[0>t?~t:t],r=n[0];return e.transform?(i=[0,0],n.forEach(function(e){i[0]+=e[0],i[1]+=e[1]})):i=n[n.length-1],0>t?[i,r]:[r,i]}function n(e,t){for(var i in e){var n=e[i];delete t[n.start],delete n.start,delete n.end,n.forEach(function(e){r[0>e?~e:e]=1
}),s.push(n)}}var r={},o={},a={},s=[],l=-1;return t.forEach(function(i,n){var r,o=e.arcs[0>i?~i:i];o.length<3&&!o[1][0]&&!o[1][1]&&(r=t[++l],t[l]=i,t[n]=r)}),t.forEach(function(e){var t,n,r=i(e),s=r[0],l=r[1];if(t=a[s])if(delete a[t.end],t.push(e),t.end=l,n=o[l]){delete o[n.start];var u=n===t?t:t.concat(n);o[u.start=t.start]=a[u.end=n.end]=u}else o[t.start]=a[t.end]=t;else if(t=o[l])if(delete o[t.start],t.unshift(e),t.start=s,n=a[s]){delete a[n.end];var c=n===t?t:n.concat(t);o[c.start=n.start]=a[c.end=t.end]=c}else o[t.start]=a[t.end]=t;else t=[e],o[t.start=s]=a[t.end=l]=t}),n(a,o),n(o,a),t.forEach(function(e){r[0>e?~e:e]||s.push([e])}),s}function t(t,i,n){function r(e){var t=0>e?~e:e;(c[t]||(c[t]=[])).push({i:e,g:u})}function o(e){e.forEach(r)}function a(e){e.forEach(o)}function s(e){"GeometryCollection"===e.type?e.geometries.forEach(s):e.type in d&&(u=e,d[e.type](e.arcs))}var l=[];if(arguments.length>1){var u,c=[],d={LineString:o,MultiLineString:a,Polygon:a,MultiPolygon:function(e){e.forEach(a)}};s(i),c.forEach(arguments.length<3?function(e){l.push(e[0].i)}:function(e){n(e[0].g,e[e.length-1].g)&&l.push(e[0].i)})}else for(var h=0,m=t.arcs.length;m>h;++h)l.push(h);return{type:"MultiLineString",arcs:e(t,l)}}function i(t,i){function r(e){e.forEach(function(t){t.forEach(function(t){(s[t=0>t?~t:t]||(s[t]=[])).push(e)})}),l.push(e)}function o(e){return d(a(t,{type:"Polygon",arcs:[e]}).coordinates[0])>0}var s={},l=[],u=[];return i.forEach(function(e){"Polygon"===e.type?r(e.arcs):"MultiPolygon"===e.type&&e.arcs.forEach(r)}),l.forEach(function(e){if(!e._){var t=[],i=[e];for(e._=1,u.push(t);e=i.pop();)t.push(e),e.forEach(function(e){e.forEach(function(e){s[0>e?~e:e].forEach(function(e){e._||(e._=1,i.push(e))})})})}}),l.forEach(function(e){delete e._}),{type:"MultiPolygon",arcs:u.map(function(i){var r=[];if(i.forEach(function(e){e.forEach(function(e){e.forEach(function(e){s[0>e?~e:e].length<2&&r.push(e)})})}),r=e(t,r),(n=r.length)>1)for(var a,l=o(i[0][0]),u=0;n>u;++u)if(l===o(r[u])){a=r[0],r[0]=r[u],r[u]=a;break}return r})}}function r(e,t){return"GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map(function(t){return o(e,t)})}:o(e,t)}function o(e,t){var i={type:"Feature",id:t.id,properties:t.properties||{},geometry:a(e,t)};return null==t.id&&delete i.id,i}function a(e,t){function i(e,t){t.length&&t.pop();for(var i,n=c[0>e?~e:e],r=0,o=n.length;o>r;++r)t.push(i=n[r].slice()),u(i,r);0>e&&s(t,o)}function n(e){return e=e.slice(),u(e,0),e}function r(e){for(var t=[],n=0,r=e.length;r>n;++n)i(e[n],t);return t.length<2&&t.push(t[0].slice()),t}function o(e){for(var t=r(e);t.length<4;)t.push(t[0].slice());return t}function a(e){return e.map(o)}function l(e){var t=e.type;return"GeometryCollection"===t?{type:t,geometries:e.geometries.map(l)}:t in d?{type:t,coordinates:d[t](e)}:null}var u=f(e.transform),c=e.arcs,d={Point:function(e){return n(e.coordinates)},MultiPoint:function(e){return e.coordinates.map(n)},LineString:function(e){return r(e.arcs)},MultiLineString:function(e){return e.arcs.map(r)},Polygon:function(e){return a(e.arcs)},MultiPolygon:function(e){return e.arcs.map(a)}};return l(t)}function s(e,t){for(var i,n=e.length,r=n-t;r<--n;)i=e[r],e[r++]=e[n],e[n]=i}function l(e,t){for(var i=0,n=e.length;n>i;){var r=i+n>>>1;e[r]<t?i=r+1:n=r}return i}function u(e){function t(e,t){e.forEach(function(e){0>e&&(e=~e);var i=r[e];i?i.push(t):r[e]=[t]})}function i(e,i){e.forEach(function(e){t(e,i)})}function n(e,t){"GeometryCollection"===e.type?e.geometries.forEach(function(e){n(e,t)}):e.type in a&&a[e.type](e.arcs,t)}var r={},o=e.map(function(){return[]}),a={LineString:t,MultiLineString:i,Polygon:i,MultiPolygon:function(e,t){e.forEach(function(e){i(e,t)})}};e.forEach(n);for(var s in r)for(var u=r[s],c=u.length,d=0;c>d;++d)for(var h=d+1;c>h;++h){var m,p=u[d],f=u[h];(m=o[p])[s=l(m,f)]!==f&&m.splice(s,0,f),(m=o[f])[s=l(m,p)]!==p&&m.splice(s,0,p)}return o}function c(e,t){function i(e){o.remove(e),e[1][2]=t(e),o.push(e)}var n=f(e.transform),r=v(e.transform),o=p();return t||(t=h),e.arcs.forEach(function(e){for(var a,s,l=[],u=0,c=0,d=e.length;d>c;++c)s=e[c],n(e[c]=[s[0],s[1],1/0],c);for(var c=1,d=e.length-1;d>c;++c)a=e.slice(c-1,c+2),a[1][2]=t(a),l.push(a),o.push(a);for(var c=0,d=l.length;d>c;++c)a=l[c],a.previous=l[c-1],a.next=l[c+1];for(;a=o.pop();){var h=a.previous,m=a.next;a[1][2]<u?a[1][2]=u:u=a[1][2],h&&(h.next=m,h[2]=a[2],i(h)),m&&(m.previous=h,m[0]=a[0],i(m))}e.forEach(r)}),e}function d(e){for(var t,i=-1,n=e.length,r=e[n-1],o=0;++i<n;)t=r,r=e[i],o+=t[0]*r[1]-t[1]*r[0];return.5*o}function h(e){var t=e[0],i=e[1],n=e[2];return Math.abs((t[0]-n[0])*(i[1]-t[1])-(t[0]-i[0])*(n[1]-t[1]))}function m(e,t){return e[1][2]-t[1][2]}function p(){function e(e,t){for(;t>0;){var i=(t+1>>1)-1,r=n[i];if(m(e,r)>=0)break;n[r._=t]=r,n[e._=t=i]=e}}function t(e,t){for(;;){var i=t+1<<1,o=i-1,a=t,s=n[a];if(r>o&&m(n[o],s)<0&&(s=n[a=o]),r>i&&m(n[i],s)<0&&(s=n[a=i]),a===t)break;n[s._=t]=s,n[e._=t=a]=e}}var i={},n=[],r=0;return i.push=function(t){return e(n[t._=r]=t,r++),r},i.pop=function(){if(!(0>=r)){var e,i=n[0];return--r>0&&(e=n[r],t(n[e._=0]=e,0)),i}},i.remove=function(i){var o,a=i._;if(n[a]===i)return a!==--r&&(o=n[r],(m(o,i)<0?e:t)(n[o._=a]=o,a)),a},i}function f(e){if(!e)return g;var t,i,n=e.scale[0],r=e.scale[1],o=e.translate[0],a=e.translate[1];return function(e,s){s||(t=i=0),e[0]=(t+=e[0])*n+o,e[1]=(i+=e[1])*r+a}}function v(e){if(!e)return g;var t,i,n=e.scale[0],r=e.scale[1],o=e.translate[0],a=e.translate[1];return function(e,s){s||(t=i=0);var l=0|(e[0]-o)/n,u=0|(e[1]-a)/r;e[0]=l-t,e[1]=u-i,t=l,i=u}}function g(){}var _={version:"1.6.18",mesh:function(e){return a(e,t.apply(this,arguments))},meshArcs:t,merge:function(e){return a(e,i.apply(this,arguments))},mergeArcs:i,feature:r,neighbors:u,presimplify:c};"function"==typeof define&&define.amd?define("Cesium/ThirdParty/topojson",_):"object"==typeof module&&module.exports?module.exports=_:this.topojson=_}(),define("Cesium/DataSources/CallbackProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,i,n){"use strict";var r=function(e,t){this._callback=void 0,this._isConstant=void 0,this._definitionChanged=new n,this.setCallback(e,t)};return t(r.prototype,{isConstant:{get:function(){return this._isConstant}},definitionChanged:{get:function(){return this._definitionChanged}}}),r.prototype.getValue=function(e,t){return this._callback(e,t)},r.prototype.setCallback=function(e,t){var i=this._callback!==e||this._isConstant!==t;this._callback=e,this._isConstant=t,i&&this._definitionChanged.raiseEvent(this)},r.prototype.equals=function(e){return this===e||e instanceof r&&this._callback===e._callback&&this._isConstant===e._isConstant},r}),define("Cesium/DataSources/GeoJsonDataSource",["../Core/Cartesian3","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/definedNotNull","../Core/defineProperties","../Core/deprecationWarning","../Core/DeveloperError","../Core/Event","../Core/getFilenameFromUri","../Core/loadJson","../Core/PinBuilder","../Core/PolygonHierarchy","../Core/RuntimeError","../Scene/VerticalOrigin","../ThirdParty/topojson","../ThirdParty/when","./BillboardGraphics","./CallbackProperty","./ColorMaterialProperty","./ConstantPositionProperty","./ConstantProperty","./DataSource","./EntityCollection","./PolygonGraphics","./PolylineGraphics"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T){"use strict";function P(t){return e.fromDegrees(t[0],t[1],t[2])}function A(e,t){var i="";for(var n in e)if(e.hasOwnProperty(n)){if(n===t||-1!==ot.indexOf(n))continue;var r=e[n];o(r)&&(i+="object"==typeof r?"<tr><th>"+n+"</th><td>"+A(r)+"</td></tr>":"<tr><th>"+n+"</th><td>"+r+"</td></tr>")}return i.length>0&&(i='<table class="cesium-infoBox-defaultTable"><tbody>'+i+"</tbody></table>"),i}function M(e,t){var i;return function(){return r(i)||(i=A(e,t)),i}}function I(e,t){var n=e.id;if(o(n)&&"Feature"===e.type){for(var a=2,s=n;r(t.getById(s));)s=n+"_"+a,a++;n=s}else n=i();var l=t.getOrCreateEntity(n),u=e.properties;if(o(u)){l.addProperty("properties"),l.properties=u;var c,d=u.title;if(o(d))l.name=d,c="title";else{var h=Number.MAX_VALUE;for(var m in u)if(u.hasOwnProperty(m)&&u[m]){var p=m.toLowerCase();if(h>1&&"title"===p){h=1,c=m;break}h>2&&"name"===p?(h=2,c=m):h>3&&/title/i.test(m)?(h=3,c=m):h>4&&/name/i.test(m)&&(h=4,c=m)}o(c)&&(l.name=u[c])}var f=u.description;r(f)?null!==f&&(l.description=new E(f)):l.description=new y(M(u,c),!0)}return l}function D(e,t){for(var i=new Array(e.length),n=0;n<e.length;n++)i[n]=t(e[n]);return i}function O(e,t,i,n,a){if(!r(t.geometry))throw new p("feature.geometry is required.");if(null===t.geometry)I(t,e._entityCollection);else{var s=t.geometry.type,l=lt[s];if(!o(l))throw new p("Unknown geometry type: "+s);l(e,t,t.geometry,n,a)}}function R(e,t,i,n,r){for(var o=t.features,a=0,s=o.length;s>a;a++)O(e,o[a],void 0,n,r)}function L(e,t,i,n,r){for(var a=i.geometries,s=0,l=a.length;l>s;s++){var u=a[s],c=u.type,d=lt[c];if(!o(d))throw new p("Unknown geometry type: "+c);d(e,t,u,n,r)}}function N(e,i,a,s,l){var u=l.markerSymbol,c=l.markerColor,d=l.markerSize,h=i.properties;if(o(h)){var m=h["marker-color"];o(m)&&(c=t.fromCssColorString(m)),d=n(rt[h["marker-size"]],d);var p=h["marker-symbol"];o(p)&&(u=p)}at[0]=u,at[1]=c,at[2]=d,JSON.stringify(at);var v;v=r(u)?1===u.length?e._pinBuilder.fromText(u.toUpperCase(),c,d):e._pinBuilder.fromMakiIconId(u,c,d):e._pinBuilder.fromColor(c,d),e._promises.push(g(v,function(t){var n=new _;n.verticalOrigin=new E(f.BOTTOM),n.image=new E(t);var r=I(i,e._entityCollection);r.billboard=n,r.position=new w(a(s))}))}function z(e,t,i,n,r){N(e,t,n,i.coordinates,r)}function F(e,t,i,n,r){for(var o=i.coordinates,a=0;a<o.length;a++)N(e,t,n,o[a],r)}function B(e,i,n,a,s){var l=s.strokeMaterialProperty,u=s.strokeWidthProperty,c=i.properties;if(o(c)){var d=c["stroke-width"];o(d)&&(u=new E(d));var h,m=c.stroke;o(m)&&(h=t.fromCssColorString(m));var p=c["stroke-opacity"];o(p)&&1!==p&&(r(h)||(h=l.color.clone()),h.alpha=p),r(h)&&(l=new C(h))}var f=new T;f.material=l,f.width=u,f.positions=new E(D(a,n));var v=I(i,e._entityCollection);v.polyline=f}function V(e,t,i,n,r){B(e,t,n,i.coordinates,r)}function k(e,t,i,n,r){for(var o=i.coordinates,a=0;a<o.length;a++)B(e,t,n,o[a],r)}function U(e,i,n,a,s){if(0!==a.length&&0!==a[0].length){var l=s.strokeMaterialProperty.color,u=s.fillMaterialProperty,c=s.strokeWidthProperty,d=i.properties;if(o(d)){var h=d["stroke-width"];o(h)&&(c=new E(h));var p,f=d.stroke;o(f)&&(p=t.fromCssColorString(f));var v=d["stroke-opacity"];o(v)&&1!==v&&(r(p)||(p=s.strokeMaterialProperty.color.clone()),p.alpha=v),r(p)&&(l=new E(p));var g,_=d.fill;o(_)&&(g=t.fromCssColorString(_),g.alpha=u.color.alpha),v=d["fill-opacity"],o(v)&&v!==u.color.alpha&&(r(g)||(g=u.color.clone()),g.alpha=v),r(g)&&(u=new C(g))}var y=new x;y.outline=new E(!0),y.outlineColor=l,y.outlineWidth=c,y.material=u;for(var w=[],b=1,S=a.length;S>b;b++)w.push(new m(D(a[b],n)));var T=a[0];y.hierarchy=new E(new m(D(T,n),w)),T[0].length>2&&(y.perPositionHeight=new E(!0));var P=I(i,e._entityCollection);P.polygon=y}}function W(e,t,i,n,r){U(e,t,n,i.coordinates,r)}function G(e,t,i,n,r){for(var o=i.coordinates,a=0;a<o.length;a++)U(e,t,n,o[a],r)}function H(e,t,i,n,r){for(var o in i.objects)if(i.objects.hasOwnProperty(o)){var a=v.feature(i,i.objects[o]),s=st[a.type];s(e,a,a,n,r)}}function q(e,t,i,n){var o;r(n)&&(o=c(n)),r(o)&&e._name!==o&&(e._name=o,e._changed.raiseEvent(e));var a=st[t.type];if(!r(a))throw new p("Unsupported GeoJSON object type: "+t.type);var s=P,l=t.crs;if(r(l)){if(null===l)throw new p("crs is null.");if(!r(l.properties))throw new p("crs.properties is undefined.");var u=l.properties;if("name"===l.type){if(s=Y[u.name],!r(s))throw new p("Unknown crs name: "+u.name)}else if("link"===l.type){var d=X[u.href];if(r(d)||(d=Z[u.type]),!r(d))throw new p("Unable to resolve crs link: "+JSON.stringify(u));s=d(u)}else{if("EPSG"!==l.type)throw new p("Unknown crs type: "+l.type);if(s=Y["EPSG:"+u.code],!r(s))throw new p("Unknown crs EPSG code: "+u.code)}}return g(s,function(n){return e._entityCollection.removeAll(),a(e,t,t,n,i),g.all(e._promises,function(){return e._promises.length=0,b.setLoading(e,!1),e})})}var j,Y={"urn:ogc:def:crs:OGC:1.3:CRS84":P,"EPSG:4326":P},X={},Z={},J=48,K=t.ROYALBLUE,Q=t.YELLOW,$=2,et=t.fromBytes(255,255,0,100),tt=new E($),it=new C(Q),nt=new C(et),rt={small:24,medium:48,large:64},ot=["title","description","marker-size","marker-symbol","marker-color","stroke","stroke-opacity","stroke-width","fill","fill-opacity"],at=new Array(4),st={Feature:O,FeatureCollection:R,GeometryCollection:L,LineString:V,MultiLineString:k,MultiPoint:F,MultiPolygon:G,Point:z,Polygon:W,Topology:H},lt={GeometryCollection:L,LineString:V,MultiLineString:k,MultiPoint:F,MultiPolygon:G,Point:z,Polygon:W,Topology:H},ut=function(e){this._name=e,this._changed=new u,this._error=new u,this._isLoading=!1,this._loading=new u,this._entityCollection=new S,this._promises=[],this._pinBuilder=new h};return ut.fromUrl=function(e,t){s("GeoJsonDataSource.fromUrl","GeoJsonDataSource.fromUrl has been deprecated.  Use GeoJsonDataSource.load instead.");var i=new ut;return i.load(e,t),i},ut.load=function(e,t){return(new ut).load(e,t)},a(ut,{markerSize:{get:function(){return J},set:function(e){J=e}},markerSymbol:{get:function(){return j},set:function(e){j=e}},markerColor:{get:function(){return K},set:function(e){K=e}},stroke:{get:function(){return Q},set:function(e){Q=e,it.color.setValue(e)}},strokeWidth:{get:function(){return $},set:function(e){$=e,tt.setValue(e)}},fill:{get:function(){return et},set:function(e){et=e,nt=new C(et)}},crsNames:{get:function(){return Y}},crsLinkHrefs:{get:function(){return X}},crsLinkTypes:{get:function(){return Z}}}),a(ut.prototype,{name:{get:function(){return this._name}},clock:{value:void 0,writable:!1},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),ut.prototype.loadUrl=function(e,t){return s("GeoJsonDataSource.prototype.loadUrl","GeoJsonDataSource.loadUrl has been deprecated.  You can now pass a url to GeoJsonDataSource.load."),this.load(e,t)},ut.prototype.load=function(e,t){b.setLoading(this,!0);var i=e;t=n(t,n.EMPTY_OBJECT);var o=t.sourceUri;"string"==typeof e&&(r(o)||(o=e),i=d(e)),t={markerSize:n(t.markerSize,J),markerSymbol:n(t.markerSymbol,j),markerColor:n(t.markerColor,K),strokeWidthProperty:new E(n(t.strokeWidth,$)),strokeMaterialProperty:new C(n(t.stroke,Q)),fillMaterialProperty:new C(n(t.fill,et))};var a=this;return g(i,function(e){return q(a,e,t,o)}).otherwise(function(e){return b.setLoading(a,!1),a._error.raiseEvent(a,e),window.console.log(e),g.reject(e)})},ut}),define("Cesium/Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,i,n,r,o,a){"use strict";var s=function(e){this._ellipsoid=i(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return r(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,i){var r=this._semimajorAxis,o=t.longitude*r,a=t.latitude*r,s=t.height;return n(i)?(i.x=o,i.y=a,i.z=s,i):new e(o,a,s)},s.prototype.unproject=function(e,i){var r=this._oneOverSemimajorAxis,o=e.x*r,a=e.y*r,s=e.z;return n(i)?(i.longitude=o,i.latitude=a,i.height=s,i):new t(o,a,s)},s}),define("Cesium/Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Cesium/Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(e,t,n,r){this.x=i(e,0),this.y=i(t,0),this.width=i(n,0),this.height=i(r,0)};l.fromPoints=function(e,t){if(n(t)||(t=new l),!n(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var i=e.length,r=e[0].x,o=e[0].y,a=e[0].x,s=e[0].y,u=1;i>u;u++){var c=e[u],d=c.x,h=c.y;r=Math.min(d,r),a=Math.max(d,a),o=Math.min(h,o),s=Math.max(h,s)}return t.x=r,t.y=o,t.width=a-r,t.height=s-o,t};var u=new o,c=new t,d=new t;return l.fromRectangle=function(t,r,o){if(n(o)||(o=new l),!n(t))return o.x=0,o.y=0,o.width=0,o.height=0,o;r=i(r,u);var a=r.project(s.southwest(t,c)),h=r.project(s.northeast(t,d));return e.subtract(h,a,h),o.x=a.x,o.y=a.y,o.width=h.x,o.height=h.y,o},l.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new l(e.x,e.y,e.width,e.height):void 0},l.union=function(e,t,i){n(i)||(i=new l);var r=Math.min(e.x,t.x),o=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),s=Math.max(e.y+e.height,t.y+t.height);return i.x=r,i.y=o,i.width=a-r,i.height=s-o,i},l.expand=function(e,t,i){i=l.clone(e,i);var n=t.x-i.x,r=t.y-i.y;return n>i.width?i.width=n:0>n&&(i.width-=n,i.x=t.x),r>i.height?i.height=r:0>r&&(i.height-=r,i.y=t.y),i},l.intersect=function(e,t){var i=e.x,n=e.y,r=t.x,o=t.y;return i>r+t.width||i+e.width<r||n+e.height<o||n>o+t.height?a.OUTSIDE:a.INTERSECTING},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.intersect=function(e){return l.intersect(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l}),define("Cesium/Core/loadBlob",["./loadWithXhr"],function(e){"use strict";var t=function(t,i){return e({url:t,responseType:"blob",headers:i})};return t}),define("Cesium/Core/loadXML",["./loadWithXhr"],function(e){"use strict";var t=function(t,i){return e({url:t,responseType:"document",headers:i,overrideMimeType:"text/xml"})};return t}),define("Cesium/Core/NearFarScalar",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var i=function(t,i,n,r){this.near=e(t,0),this.nearValue=e(i,0),this.far=e(n,1),this.farValue=e(r,0)};return i.clone=function(e,n){return t(e)?t(n)?(n.near=e.near,n.nearValue=e.nearValue,n.far=e.far,n.farValue=e.farValue,n):new i(e.near,e.nearValue,e.far,e.farValue):void 0},i.packedLength=4,i.pack=function(t,i,n){n=e(n,0),i[n++]=t.near,i[n++]=t.nearValue,i[n++]=t.far,i[n]=t.farValue},i.unpack=function(n,r,o){return r=e(r,0),t(o)||(o=new i),o.near=n[r++],o.nearValue=n[r++],o.far=n[r++],o.farValue=n[r],o},i.equals=function(e,i){return e===i||t(e)&&t(i)&&e.near===i.near&&e.nearValue===i.nearValue&&e.far===i.far&&e.farValue===i.farValue},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),function(e,t){"function"==typeof define&&define.amd?define("Cesium/ThirdParty/Autolinker",[],function(){return e.returnExportsGlobal=t()}):"object"==typeof exports?module.exports=t():e.Autolinker=t()}(this,function(){var e=function(t){e.Util.assign(this,t),this.matchValidator=new e.MatchValidator};return e.prototype={constructor:e,urls:!0,email:!0,twitter:!0,newWindow:!0,stripPrefix:!0,className:"",htmlCharacterEntitiesRegex:/(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi,matcherRegex:function(){var e=/(^|[^\w])@(\w{1,15})/,t=/(?:[\-;:&=\+\$,\w\.]+@)/,i=/(?:[A-Za-z][-.+A-Za-z0-9]+:(?![A-Za-z][-.+A-Za-z0-9]+:\/\/)(?!\d+\/?)(?:\/\/)?)/,n=/(?:www\.)/,r=/[A-Za-z0-9\.\-]*[A-Za-z0-9\-]/,o=/\.(?:international|construction|contractors|enterprises|photography|productions|foundation|immobilien|industries|management|properties|technology|christmas|community|directory|education|equipment|institute|marketing|solutions|vacations|bargains|boutique|builders|catering|cleaning|clothing|computer|democrat|diamonds|graphics|holdings|lighting|partners|plumbing|supplies|training|ventures|academy|careers|company|cruises|domains|exposed|flights|florist|gallery|guitars|holiday|kitchen|neustar|okinawa|recipes|rentals|reviews|shiksha|singles|support|systems|agency|berlin|camera|center|coffee|condos|dating|estate|events|expert|futbol|kaufen|luxury|maison|monash|museum|nagoya|photos|repair|report|social|supply|tattoo|tienda|travel|viajes|villas|vision|voting|voyage|actor|build|cards|cheap|codes|dance|email|glass|house|mango|ninja|parts|photo|shoes|solar|today|tokyo|tools|watch|works|aero|arpa|asia|best|bike|blue|buzz|camp|club|cool|coop|farm|fish|gift|guru|info|jobs|kiwi|kred|land|limo|link|menu|mobi|moda|name|pics|pink|post|qpon|rich|ruhr|sexy|tips|vote|voto|wang|wien|wiki|zone|bar|bid|biz|cab|cat|ceo|com|edu|gov|int|kim|mil|net|onl|org|pro|pub|red|tel|uno|wed|xxx|xyz|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw)\b/,a=/[\-A-Za-z0-9+&@#\/%=~_()|'$*\[\]?!:,.;]*[\-A-Za-z0-9+&@#\/%=~_()|'$*\[\]]/;return new RegExp(["(",e.source,")","|","(",t.source,r.source,o.source,")","|","(","(?:","(",i.source,r.source,")","|","(?:","(.?//)?",n.source,r.source,")","|","(?:","(.?//)?",r.source,o.source,")",")","(?:"+a.source+")?",")"].join(""),"gi")}(),charBeforeProtocolRelMatchRegex:/^(.)?\/\//,link:function(t){var i=this,n=this.getHtmlParser(),r=this.htmlCharacterEntitiesRegex,o=0,a=[];return n.parse(t,{processHtmlNode:function(e,t,i){"a"===t&&(i?o=Math.max(o-1,0):o++),a.push(e)},processTextNode:function(t){if(0===o)for(var n=e.Util.splitAndCapture(t,r),s=0,l=n.length;l>s;s++){var u=n[s],c=i.processTextNode(u);a.push(c)}else a.push(t)}}),a.join("")},getHtmlParser:function(){var t=this.htmlParser;return t||(t=this.htmlParser=new e.HtmlParser),t},getTagBuilder:function(){var t=this.tagBuilder;return t||(t=this.tagBuilder=new e.AnchorTagBuilder({newWindow:this.newWindow,truncate:this.truncate,className:this.className})),t},processTextNode:function(e){var t=this;return e.replace(this.matcherRegex,function(e,i,n,r,o,a,s,l,u){var c=t.processCandidateMatch(e,i,n,r,o,a,s,l,u);if(c){var d=t.createMatchReturnVal(c.match,c.matchStr);return c.prefixStr+d+c.suffixStr}return e})},processCandidateMatch:function(t,i,n,r,o,a,s,l,u){var c,d=l||u,h="",m="";if(i&&!this.twitter||o&&!this.email||a&&!this.urls||!this.matchValidator.isValidMatch(a,s,d))return null;if(this.matchHasUnbalancedClosingParen(t)&&(t=t.substr(0,t.length-1),m=")"),o)c=new e.match.Email({matchedText:t,email:o});else if(i)n&&(h=n,t=t.slice(1)),c=new e.match.Twitter({matchedText:t,twitterHandle:r});else{if(d){var p=d.match(this.charBeforeProtocolRelMatchRegex)[1]||"";p&&(h=p,t=t.slice(1))}c=new e.match.Url({matchedText:t,url:t,protocolUrlMatch:!!s,protocolRelativeMatch:!!d,stripPrefix:this.stripPrefix})}return{prefixStr:h,suffixStr:m,matchStr:t,match:c}},matchHasUnbalancedClosingParen:function(e){var t=e.charAt(e.length-1);if(")"===t){var i=e.match(/\(/g),n=e.match(/\)/g),r=i&&i.length||0,o=n&&n.length||0;if(o>r)return!0}return!1},createMatchReturnVal:function(t,i){var n;if(this.replaceFn&&(n=this.replaceFn.call(this,this,t)),"string"==typeof n)return n;if(n===!1)return i;if(n instanceof e.HtmlTag)return n.toString();var r=this.getTagBuilder(),o=r.build(t);return o.toString()}},e.link=function(t,i){var n=new e(i);return n.link(t)},e.match={},e.Util={abstractMethod:function(){throw"abstract"},assign:function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},extend:function(t,i){var n=t.prototype,r=function(){};r.prototype=n;var o;o=i.hasOwnProperty("constructor")?i.constructor:function(){n.constructor.apply(this,arguments)};var a=o.prototype=new r;return a.constructor=o,a.superclass=n,delete i.constructor,e.Util.assign(a,i),o},ellipsis:function(e,t,i){return e.length>t&&(i=null==i?"..":i,e=e.substring(0,t-i.length)+i),e},indexOf:function(e,t){if(Array.prototype.indexOf)return e.indexOf(t);for(var i=0,n=e.length;n>i;i++)if(e[i]===t)return i;return-1},splitAndCapture:function(e,t){if(!t.global)throw new Error("`splitRegex` must have the 'g' flag set");for(var i,n=[],r=0;i=t.exec(e);)n.push(e.substring(r,i.index)),n.push(i[0]),r=i.index+i[0].length;return n.push(e.substring(r)),n}},e.HtmlParser=e.Util.extend(Object,{htmlRegex:function(){var e=/[0-9a-zA-Z][0-9a-zA-Z:]*/,t=/[^\s\0"'>\/=\x01-\x1F\x7F]+/,i=/(?:"[^"]*?"|'[^']*?'|[^'"=<>`\s]+)/,n=t.source+"(?:\\s*=\\s*"+i.source+")?";return new RegExp(["(?:","<(!DOCTYPE)","(?:","\\s+","(?:",n,"|",i.source+")",")*",">",")","|","(?:","<(/)?","("+e.source+")","(?:","\\s+",n,")*","\\s*/?",">",")"].join(""),"gi")}(),parse:function(e,t){t=t||{};for(var i,n=t.processHtmlNode||function(){},r=t.processTextNode||function(){},o=this.htmlRegex,a=0;null!==(i=o.exec(e));){var s=i[0],l=i[1]||i[3],u=!!i[2],c=e.substring(a,i.index);c&&r(c),n(s,l.toLowerCase(),u),a=i.index+s.length}if(a<e.length){var d=e.substring(a);d&&r(d)}}}),e.HtmlTag=e.Util.extend(Object,{whitespaceRegex:/\s+/,constructor:function(t){e.Util.assign(this,t),this.innerHtml=this.innerHtml||this.innerHTML},setTagName:function(e){return this.tagName=e,this},getTagName:function(){return this.tagName||""},setAttr:function(e,t){var i=this.getAttrs();return i[e]=t,this},getAttr:function(e){return this.getAttrs()[e]},setAttrs:function(t){var i=this.getAttrs();return e.Util.assign(i,t),this},getAttrs:function(){return this.attrs||(this.attrs={})},setClass:function(e){return this.setAttr("class",e)},addClass:function(t){for(var i,n=this.getClass(),r=this.whitespaceRegex,o=e.Util.indexOf,a=n?n.split(r):[],s=t.split(r);i=s.shift();)-1===o(a,i)&&a.push(i);return this.getAttrs()["class"]=a.join(" "),this},removeClass:function(t){for(var i,n=this.getClass(),r=this.whitespaceRegex,o=e.Util.indexOf,a=n?n.split(r):[],s=t.split(r);a.length&&(i=s.shift());){var l=o(a,i);-1!==l&&a.splice(l,1)}return this.getAttrs()["class"]=a.join(" "),this},getClass:function(){return this.getAttrs()["class"]||""},hasClass:function(e){return-1!==(" "+this.getClass()+" ").indexOf(" "+e+" ")},setInnerHtml:function(e){return this.innerHtml=e,this},getInnerHtml:function(){return this.innerHtml||""},toString:function(){var e=this.getTagName(),t=this.buildAttrsStr();return t=t?" "+t:"",["<",e,t,">",this.getInnerHtml(),"</",e,">"].join("")},buildAttrsStr:function(){if(!this.attrs)return"";var e=this.getAttrs(),t=[];for(var i in e)e.hasOwnProperty(i)&&t.push(i+'="'+e[i]+'"');return t.join(" ")}}),e.MatchValidator=e.Util.extend(Object,{invalidProtocolRelMatchRegex:/^[\w]\/\//,hasFullProtocolRegex:/^[A-Za-z][-.+A-Za-z0-9]+:\/\//,uriSchemeRegex:/^[A-Za-z][-.+A-Za-z0-9]+:/,hasWordCharAfterProtocolRegex:/:[^\s]*?[A-Za-z]/,isValidMatch:function(e,t,i){return t&&!this.isValidUriScheme(t)||this.urlMatchDoesNotHaveProtocolOrDot(e,t)||this.urlMatchDoesNotHaveAtLeastOneWordChar(e,t)||this.isInvalidProtocolRelativeMatch(i)?!1:!0},isValidUriScheme:function(e){var t=e.match(this.uriSchemeRegex)[0];return"javascript:"!==t&&"vbscript:"!==t},urlMatchDoesNotHaveProtocolOrDot:function(e,t){return!(!e||t&&this.hasFullProtocolRegex.test(t)||-1!==e.indexOf("."))},urlMatchDoesNotHaveAtLeastOneWordChar:function(e,t){return e&&t?!this.hasWordCharAfterProtocolRegex.test(e):!1},isInvalidProtocolRelativeMatch:function(e){return!!e&&this.invalidProtocolRelMatchRegex.test(e)}}),e.AnchorTagBuilder=e.Util.extend(Object,{constructor:function(t){e.Util.assign(this,t)},build:function(t){var i=new e.HtmlTag({tagName:"a",attrs:this.createAttrs(t.getType(),t.getAnchorHref()),innerHtml:this.processAnchorText(t.getAnchorText())});return i},createAttrs:function(e,t){var i={href:t},n=this.createCssClass(e);return n&&(i["class"]=n),this.newWindow&&(i.target="_blank"),i},createCssClass:function(e){var t=this.className;return t?t+" "+t+"-"+e:""},processAnchorText:function(e){return e=this.doTruncate(e)},doTruncate:function(t){return e.Util.ellipsis(t,this.truncate||Number.POSITIVE_INFINITY)}}),e.match.Match=e.Util.extend(Object,{constructor:function(t){e.Util.assign(this,t)},getType:e.Util.abstractMethod,getMatchedText:function(){return this.matchedText},getAnchorHref:e.Util.abstractMethod,getAnchorText:e.Util.abstractMethod}),e.match.Email=e.Util.extend(e.match.Match,{getType:function(){return"email"},getEmail:function(){return this.email},getAnchorHref:function(){return"mailto:"+this.email},getAnchorText:function(){return this.email}}),e.match.Twitter=e.Util.extend(e.match.Match,{getType:function(){return"twitter"},getTwitterHandle:function(){return this.twitterHandle},getAnchorHref:function(){return"https://twitter.com/"+this.twitterHandle},getAnchorText:function(){return"@"+this.twitterHandle}}),e.match.Url=e.Util.extend(e.match.Match,{urlPrefixRegex:/^(https?:\/\/)?(www\.)?/i,protocolRelativeRegex:/^\/\//,protocolPrepended:!1,getType:function(){return"url"},getUrl:function(){var e=this.url;return this.protocolRelativeMatch||this.protocolUrlMatch||this.protocolPrepended||(e=this.url="http://"+e,this.protocolPrepended=!0),e},getAnchorHref:function(){var e=this.getUrl();return e.replace(/&amp;/g,"&")},getAnchorText:function(){var e=this.getUrl();return this.protocolRelativeMatch&&(e=this.stripProtocolRelativePrefix(e)),this.stripPrefix&&(e=this.stripUrlPrefix(e)),e=this.removeTrailingSlash(e)},stripUrlPrefix:function(e){return e.replace(this.urlPrefixRegex,"")},stripProtocolRelativePrefix:function(e){return e.replace(this.protocolRelativeRegex,"")},removeTrailingSlash:function(e){return"/"===e.charAt(e.length-1)&&(e=e.slice(0,-1)),e}}),e}),define("Cesium/ThirdParty/zip",["../Core/buildModuleUrl"],function(e){var t={};return function(t){function i(){var e=-1,t=this;t.append=function(i){var n,r=t.table;for(n=0;n<i.length;n++)e=e>>>8^r[255&(e^i[n])]},t.get=function(){return~e}}function n(e,t,i){return e.slice?e.slice(t,t+i):e.webkitSlice?e.webkitSlice(t,t+i):e.mozSlice?e.mozSlice(t,t+i):e.msSlice?e.msSlice(t,t+i):void 0}function r(e,t){var i,n;return i=new ArrayBuffer(e),n=new Uint8Array(i),t&&n.set(t,0),{buffer:i,array:n,view:new DataView(i)}}function o(){}function a(e){function t(t,i){var o=new Blob([e],{type:V});n=new l(o),n.init(function(){r.size=n.size,t()},i)}function i(e,t,i,r){n.readUint8Array(e,t,i,r)}var n,r=this;r.size=0,r.init=t,r.readUint8Array=i}function s(e){function t(t){for(var i=e.length;"="==e.charAt(i-1);)i--;n=e.indexOf(",")+1,o.size=Math.floor(.75*(i-n)),t()}function i(t,i,o){var a,s=r(i),l=4*Math.floor(t/3),u=4*Math.ceil((t+i)/3),c=window.atob(e.substring(l+n,u+n)),d=t-3*Math.floor(l/4);for(a=d;d+i>a;a++)s.array[a-d]=c.charCodeAt(a);o(s.array)}var n,o=this;o.size=0,o.init=t,o.readUint8Array=i}function l(e){function t(t){this.size=e.size,t()}function i(t,i,r,o){var a=new FileReader;a.onload=function(e){r(new Uint8Array(e.target.result))},a.onerror=o,a.readAsArrayBuffer(n(e,t,i))}var r=this;r.size=0,r.init=t,r.readUint8Array=i}function u(){}function c(e){function t(e){r=new Blob([],{type:V}),e()}function i(e,t){r=new Blob([r,P?e:e.buffer],{type:V}),t()}function n(t,i){var n=new FileReader;n.onload=function(e){t(e.target.result)},n.onerror=i,n.readAsText(r,e)}var r,o=this;o.init=t,o.writeUint8Array=i,o.getData=n}function d(e){function t(t){o+="data:"+(e||"")+";base64,",t()}function i(e,t){var i,n=a.length,r=a;for(a="",i=0;i<3*Math.floor((n+e.length)/3)-n;i++)r+=String.fromCharCode(e[i]);for(;i<e.length;i++)a+=String.fromCharCode(e[i]);r.length>2?o+=window.btoa(r):a=r,t()}function n(e){e(o+window.btoa(a))}var r=this,o="",a="";r.init=t,r.writeUint8Array=i,r.getData=n}function h(e){function t(t){r=new Blob([],{type:e}),t()}function i(t,i){r=new Blob([r,P?t:t.buffer],{type:e}),i()
}function n(e){e(r)}var r,o=this;o.init=t,o.writeUint8Array=i,o.getData=n}function m(e,t,i,n,r,o,a,s,l,u){function c(){e.removeEventListener(k,d,!1),s(p)}function d(e){var t=e.data,n=t.data;t.onappend&&(p+=n.length,i.writeUint8Array(n,function(){o(!1,n),h()},u)),t.onflush&&(n?(p+=n.length,i.writeUint8Array(n,function(){o(!1,n),c()},u)):c()),t.progress&&a&&a(m+t.current,r)}function h(){m=f*z,r>m?t.readUint8Array(n+m,Math.min(z,r-m),function(t){e.postMessage({append:!0,data:t}),f++,a&&a(m,r),o(!0,t)},l):e.postMessage({flush:!0})}var m,p,f=0;p=0,e.addEventListener(k,d,!1),h()}function p(e,t,i,n,r,o,a,s,l,u){function c(){var p;d=h*z,r>d?t.readUint8Array(n+d,Math.min(z,r-d),function(t){var s=e.append(t,function(){a&&a(n+d,r)});m+=s.length,o(!0,t),i.writeUint8Array(s,function(){o(!1,s),h++,setTimeout(c,1)},u),a&&a(d,r)},l):(p=e.flush(),p?(m+=p.length,i.writeUint8Array(p,function(){o(!1,p),s(m)},u)):s(m))}var d,h=0,m=0;c()}function f(e,n,r,o,a,s,l,u,c){function d(e,t){a&&!e&&v.append(t)}function h(e){s(e,v.get())}var f,v=new i;return t.zip.useWebWorkers?(f=new Worker(t.zip.workerScriptsPath+F),m(f,e,n,r,o,d,l,h,u,c)):p(new t.zip.Inflater,e,n,r,o,d,l,h,u,c),f}function v(e,n,r,o,a,s,l){function u(e,t){e&&f.append(t)}function c(e){o(e,f.get())}function d(){h.removeEventListener(k,d,!1),m(h,e,n,0,e.size,u,a,c,s,l)}var h,f=new i;return t.zip.useWebWorkers?(h=new Worker(t.zip.workerScriptsPath+B),h.addEventListener(k,d,!1),h.postMessage({init:!0,level:r})):p(new t.zip.Deflater,e,n,0,e.size,u,a,c,s,l),h}function g(e,t,n,r,o,a,s,l,u){function c(){var i=d*z;r>i?e.readUint8Array(n+i,Math.min(z,r-i),function(e){o&&h.append(e),s&&s(i,r,e),t.writeUint8Array(e,function(){d++,c()},u)},l):a(r,h.get())}var d=0,h=new i;c()}function _(e){var t,i,n="",r=["Ç","ü","é","â","ä","à","å","ç","ê","ë","è","ï","î","ì","Ä","Å","É","æ","Æ","ô","ö","ò","û","ù","ÿ","Ö","Ü","ø","£","Ø","×","ƒ","á","í","ó","ú","ñ","Ñ","ª","º","¿","®","¬","½","¼","¡","«","»","_","_","_","¦","¦","?","Â","À","©","¦","¦","+","+","¢","¥","+","+","-","-","+","-","+","ã","Ã","+","+","-","-","¦","-","+","¤","ð","?","Ê","Ë","È","i","?","Î","?","+","+","_","_","¦","Ì","_","Ó","ß","Ô","Ò","õ","Õ","µ","þ","Þ","Ú","Û","Ù","ý","?","¯","´","­","±","_","¾","¶","§","÷","¸","°","¨","·","¹","³","²","_"," "];for(t=0;t<e.length;t++)i=255&e.charCodeAt(t),n+=i>127?r[i-128]:String.fromCharCode(i);return n}function y(e){return decodeURIComponent(escape(e))}function C(e){var t,i="";for(t=0;t<e.length;t++)i+=String.fromCharCode(e[t]);return i}function w(e){var t=(4294901760&e)>>16,i=65535&e;try{return new Date(1980+((65024&t)>>9),((480&t)>>5)-1,31&t,(63488&i)>>11,(2016&i)>>5,2*(31&i),0)}catch(n){}}function E(e,t,i,n,r){return e.version=t.view.getUint16(i,!0),e.bitFlag=t.view.getUint16(i+2,!0),e.compressionMethod=t.view.getUint16(i+4,!0),e.lastModDateRaw=t.view.getUint32(i+6,!0),e.lastModDate=w(e.lastModDateRaw),1===(1&e.bitFlag)?(r(M),void 0):((n||8!=(8&e.bitFlag))&&(e.crc32=t.view.getUint32(i+10,!0),e.compressedSize=t.view.getUint32(i+14,!0),e.uncompressedSize=t.view.getUint32(i+18,!0)),4294967295===e.compressedSize||4294967295===e.uncompressedSize?(r(I),void 0):(e.filenameLength=t.view.getUint16(i+22,!0),e.extraFieldLength=t.view.getUint16(i+24,!0),void 0))}function b(e,t){function i(){}function n(i,o){e.readUint8Array(e.size-i,i,function(e){var t=r(e.length,e).view;1347093766!=t.getUint32(0)?n(i+1,o):o(t)},function(){t(D)})}return i.prototype.getData=function(i,n,o,a){function s(e,t){h&&h.terminate(),h=null,e&&e(t)}function l(e){var t=r(4);return t.view.setUint32(0,e),m.crc32==t.view.getUint32(0)}function u(e,t){a&&!l(t)?c():i.getData(function(e){s(n,e)})}function c(){s(t,L)}function d(){s(t,R)}var h,m=this;e.readUint8Array(m.offset,30,function(n){var s,l=r(n.length,n);return 1347093252!=l.view.getUint32(0)?(t(A),void 0):(E(m,l,4,!1,t),s=m.offset+30+m.filenameLength+m.extraFieldLength,i.init(function(){0===m.compressionMethod?g(e,i,s,m.compressedSize,a,u,o,c,d):h=f(e,i,s,m.compressedSize,a,u,o,c,d)},d),void 0)},c)},{getEntries:function(o){return e.size<22?(t(A),void 0):(n(22,function(n){var a,s;a=n.getUint32(16,!0),s=n.getUint16(8,!0),e.readUint8Array(a,e.size-a,function(e){var n,a,l,u,c=0,d=[],h=r(e.length,e);for(n=0;s>n;n++){if(a=new i,1347092738!=h.view.getUint32(c))return t(A),void 0;E(a,h,c+6,!0,t),a.commentLength=h.view.getUint16(c+32,!0),a.directory=16==(16&h.view.getUint8(c+38)),a.offset=h.view.getUint32(c+42,!0),l=C(h.array.subarray(c+46,c+46+a.filenameLength)),a.filename=2048===(2048&a.bitFlag)?y(l):_(l),a.directory||"/"!=a.filename.charAt(a.filename.length-1)||(a.directory=!0),u=C(h.array.subarray(c+46+a.filenameLength+a.extraFieldLength,c+46+a.filenameLength+a.extraFieldLength+a.commentLength)),a.comment=2048===(2048&a.bitFlag)?y(u):_(u),d.push(a),c+=46+a.filenameLength+a.extraFieldLength+a.commentLength}o(d)},function(){t(D)})}),void 0)},close:function(e){e&&e()}}}function S(e){return unescape(encodeURIComponent(e))}function x(e){var t,i=[];for(t=0;t<e.length;t++)i.push(e.charCodeAt(t));return i}function T(e,t,i){function n(e,t){s&&s.terminate(),s=null,e&&e(t)}function o(){n(t,O)}function a(){n(t,L)}var s,l={},u=[],c=0;return{add:function(d,h,m,p,f){function _(t){var n;b=f.lastModDate||new Date,w=r(26),l[d]={headerArray:w.array,directory:f.directory,filename:E,offset:c,comment:x(S(f.comment||""))},w.view.setUint32(0,335546376),f.version&&w.view.setUint8(0,f.version),i||0===f.level||f.directory||w.view.setUint16(4,2048),w.view.setUint16(6,(b.getHours()<<6|b.getMinutes())<<5|b.getSeconds()/2,!0),w.view.setUint16(8,(b.getFullYear()-1980<<4|b.getMonth()+1)<<5|b.getDate(),!0),w.view.setUint16(22,E.length,!0),n=r(30+E.length),n.view.setUint32(0,1347093252),n.array.set(w.array,4),n.array.set(E,30),c+=n.array.length,e.writeUint8Array(n.array,t,o)}function y(t,i){var a=r(16);c+=t||0,a.view.setUint32(0,1347094280),"undefined"!=typeof i&&(w.view.setUint32(10,i,!0),a.view.setUint32(4,i,!0)),h&&(a.view.setUint32(8,t,!0),w.view.setUint32(14,t,!0),a.view.setUint32(12,h.size,!0),w.view.setUint32(18,h.size,!0)),e.writeUint8Array(a.array,function(){c+=16,n(m)},o)}function C(){return f=f||{},d=d.trim(),f.directory&&"/"!=d.charAt(d.length-1)&&(d+="/"),l.hasOwnProperty(d)?(t(N),void 0):(E=x(S(d)),u.push(d),_(function(){h?i||0===f.level?g(h,e,0,h.size,!0,y,p,a,o):s=v(h,e,f.level,y,p,a,o):y()},o),void 0)}var w,E,b;h?h.init(C,a):C()},close:function(t){var i,a,s,d=0,h=0;for(a=0;a<u.length;a++)s=l[u[a]],d+=46+s.filename.length+s.comment.length;for(i=r(d+22),a=0;a<u.length;a++)s=l[u[a]],i.view.setUint32(h,1347092738),i.view.setUint16(h+4,5120),i.array.set(s.headerArray,h+6),i.view.setUint16(h+32,s.comment.length,!0),s.directory&&i.view.setUint8(h+38,16),i.view.setUint32(h+42,s.offset,!0),i.array.set(s.filename,h+46),i.array.set(s.comment,h+46+s.filename.length),h+=46+s.filename.length+s.comment.length;i.view.setUint32(h,1347093766),i.view.setUint16(h+8,u.length,!0),i.view.setUint16(h+10,u.length,!0),i.view.setUint32(h+12,d,!0),i.view.setUint32(h+16,c,!0),e.writeUint8Array(i.array,function(){n(function(){e.getData(t)})},o)}}}var P,A="File format is not recognized.",M="File contains encrypted entry.",I="File is using Zip64 (4gb+ file size).",D="Error while reading zip file.",O="Error while writing zip file.",R="Error while writing file data.",L="Error while reading file data.",N="File already exists.",z=524288,F="inflate.js",B="deflate.js",V="text/plain",k="message";try{P=0===new Blob([new DataView(new ArrayBuffer(0))]).size}catch(U){}i.prototype.table=function(){var e,t,i,n=[];for(e=0;256>e;e++){for(i=e,t=0;8>t;t++)1&i?i=3988292384^i>>>1:i>>>=1;n[e]=i}return n}(),a.prototype=new o,a.prototype.constructor=a,s.prototype=new o,s.prototype.constructor=s,l.prototype=new o,l.prototype.constructor=l,u.prototype.getData=function(e){e(this.data)},c.prototype=new u,c.prototype.constructor=c,d.prototype=new u,d.prototype.constructor=d,h.prototype=new u,h.prototype.constructor=h,t.zip={Reader:o,Writer:u,BlobReader:l,Data64URIReader:s,TextReader:a,BlobWriter:h,Data64URIWriter:d,TextWriter:c,createReader:function(e,t,i){e.init(function(){t(b(e,i))},i)},createWriter:function(e,t,i,n){e.init(function(){t(T(e,i,n))},i)},workerScriptsPath:e("ThirdParty/Workers/"),useWebWorkers:!0}}(t),t.zip}),define("Cesium/DataSources/ScaledPositionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/ReferenceFrame","./Property"],function(e,t,i,n,r,o,a){"use strict";var s=function(e){this._definitionChanged=new r,this._value=void 0,this._removeSubscription=void 0,this.setValue(e)};return t(s.prototype,{isConstant:{get:function(){return a.isConstant(this._value)}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return e(this._value)?this._value.referenceFrame:o.FIXED}}}),s.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},s.prototype.setValue=function(t){this._value!==t&&(this._value=t,e(this._removeSubscription)&&(this._removeSubscription(),this._removeSubscription=void 0),e(t)&&(this._removeSubscription=t.definitionChanged.addEventListener(this._raiseDefinitionChanged,this)),this._definitionChanged.raiseEvent(this))},s.prototype.getValueInReferenceFrame=function(t,i,r){return e(this._value)?(r=this._value.getValueInReferenceFrame(t,i,r),e(r)?n.WGS84.scaleToGeodeticSurface(r,r):void 0):void 0},s.prototype.equals=function(e){return this===e||e instanceof s&&this._value===e._value},s.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},s}),define("Cesium/DataSources/KmlDataSource",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/ClockRange","../Core/ClockStep","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/getFilenameFromUri","../Core/Iso8601","../Core/JulianDate","../Core/loadBlob","../Core/loadXML","../Core/Math","../Core/NearFarScalar","../Core/PinBuilder","../Core/PolygonHierarchy","../Core/Rectangle","../Core/RuntimeError","../Core/TimeInterval","../Core/TimeIntervalCollection","../Scene/HorizontalOrigin","../Scene/LabelStyle","../ThirdParty/Autolinker","../ThirdParty/Uri","../ThirdParty/when","../ThirdParty/zip","./BillboardGraphics","./CompositePositionProperty","./ConstantPositionProperty","./DataSource","./DataSourceClock","./Entity","./EntityCollection","./LabelGraphics","./PathGraphics","./PolygonGraphics","./PolylineGraphics","./PositionPropertyArray","./RectangleGraphics","./ReferenceProperty","./SampledPositionProperty","./ScaledPositionProperty","./TimeIntervalCollectionProperty","./WallGraphics"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M,I,D,O,R,L,N,z,F,B,V,k,U,W,G,H,q,j,Y,X,Z){"use strict";function J(e){var t=e.slice(0,Math.min(4,e.size)),i=I.defer(),n=new FileReader;return n.addEventListener("load",function(){i.resolve(1347093252===new DataView(n.result).getUint32(0,!1))}),n.addEventListener("error",function(){i.reject(n.error)}),n.readAsArrayBuffer(t),i}function K(e){var t=I.defer(),i=new FileReader;return i.addEventListener("load",function(){t.resolve(i.result)}),i.addEventListener("error",function(){t.reject(i.error)}),i.readAsText(e),t}function Q(e,t,i,n){t.getData(new D.TextWriter,function(e){i.kml=Qt.parseFromString(e,"application/xml"),n.resolve()})}function $(e,t,i,n){var r=s(Kt.detectFromFilename(t.filename),"application/octet-stream");t.getData(new D.Data64URIWriter(r),function(e){i[t.filename]=e,n.resolve()})}function et(e,t,i,n){for(var r=n.keys,o=new M("."),a=e.querySelectorAll(t),s=0;s<a.length;s++){var l=a[s],u=l.getAttribute(i),c=new M(u).resolve(o).toString(),d=r.indexOf(c);if(-1!==d){var h=r[d];l.setAttribute(i,n[h]),"a"===t&&null===l.getAttribute("download")&&l.setAttribute("download",h)}}}function tt(e,t){return l(t)&&new M(e).isAbsolute()&&(e=t.getURL(e)),e}function it(e,t){var i=st(e,"id");i=l(i)?i:a();var n=t.getOrCreateEntity(i);return l(n.kml)||(n.addProperty("kml"),n.kml=new ci),n}function nt(e,t){return"absolute"===e||"relativeToGround"===e||"relativeToSeaFloor"===t}function rt(e){if(!l(e))return void 0;var t=e.match(/[^\s,\n]+/g);if(2!==t.length&&3!==t.length)return window.console.log("KML - Invalid coordinates: "+e),void 0;var n=parseFloat(t[0]),r=parseFloat(t[1]),o=parseFloat(t[2]);return n=isNaN(n)?0:n,r=isNaN(r)?0:r,o=isNaN(o)?0:o,i.fromDegrees(n,r,o)}function ot(e){if(!l(e))return void 0;for(var t=e.textContent.match(/[^\s\n]+/g),i=t.length,n=new Array(i),r=0,o=0;i>o;o++)n[r++]=rt(t[o]);return n}function at(e,t){if(!l(e))return void 0;var i=e.getAttribute(t);if(null!==i){var n=parseFloat(i);return isNaN(n)?void 0:n}return void 0}function st(e,t){if(!l(e))return void 0;var i=e.getAttribute(t);return null!==i?i:void 0}function lt(e,t,i){if(!l(e))return void 0;for(var n=e.childNodes,r=n.length,o=0;r>o;o++){var a=n[o];if(a.localName===t&&-1!==i.indexOf(a.namespaceURI))return a}return void 0}function ut(e,t,i){if(!l(e))return void 0;for(var n=[],r=e.getElementsByTagName(t),o=r.length,a=0;o>a;a++){var s=r[a];s.localName===t&&-1!==i.indexOf(s.namespaceURI)&&n.push(s)}return n}function ct(e,t,i){if(!l(e))return[];for(var n=[],r=e.childNodes,o=r.length,a=0;o>a;a++){var s=r[a];s.localName===t&&-1!==i.indexOf(s.namespaceURI)&&n.push(s)}return n}function dt(e,t,i){var n=lt(e,t,i);if(l(n)){var r=parseFloat(n.textContent);return isNaN(r)?void 0:r}return void 0}function ht(e,t,i){var n=lt(e,t,i);return l(n)?n.textContent.trim():void 0}function mt(e,t,i){var n=lt(e,t,i);return l(n)?"1"===n.textContent:void 0}function pt(e,t,i,n){if(!l(e))return void 0;var r=!1;if(l(n)){var o=n[e];l(o)&&(r=!0,e=o)}if(!r&&l(i)){var a=new M(document.location.href);i=new M(i),e=new M(e).resolve(i.resolve(a)).toString(),e=tt(e,t)}return e}function ft(e,t){if(!l(e))return void 0;"#"===e[0]&&(e=e.substring(1));var i=parseInt(e.substring(0,2),16)/255,n=parseInt(e.substring(2,4),16)/255,r=parseInt(e.substring(4,6),16)/255,a=parseInt(e.substring(6,8),16)/255;return t?(a>0?oi.maximumRed=a:oi.red=0,r>0?oi.maximumGreen=r:oi.green=0,n>0?oi.maximumBlue=n:oi.blue=0,oi.alpha=i,o.fromRandom(oi)):new o(a,r,n,i)}function vt(e,t,i){var n=ht(e,t,i);return l(n)?ft(n,"random"===ht(e,"colorMode",i)):void 0}function gt(e){var t=lt(e,"TimeStamp",ri.kmlgx),i=ht(t,"when",ri.kmlgx);if(!l(t)||!l(i)||0===i.length)return void 0;var n=f.fromIso8601(i),r=new x;return r.addInterval(new S({start:n,stop:p.MAXIMUM_VALUE})),r}function _t(e){var t=lt(e,"TimeSpan",ri.kmlgx);if(!l(t))return void 0;var i,n=lt(t,"begin",ri.kmlgx),r=l(n)?f.fromIso8601(n.textContent):void 0,o=lt(t,"end",ri.kmlgx),a=l(o)?f.fromIso8601(o.textContent):void 0;if(l(r)&&l(a)){if(f.lessThan(a,r)){var s=r;r=a,a=s}i=new x,i.addInterval(new S({start:r,stop:a}))}else l(r)?(i=new x,i.addInterval(new S({start:r,stop:p.MAXIMUM_VALUE}))):l(a)&&(i=new x,i.addInterval(new S({start:p.MINIMUM_VALUE,stop:a})));return i}function yt(){var e=new O;return e.width=ei,e.height=ei,e.scaleByDistance=new y(2414016,1,16093e3,.1),e}function Ct(){var e=new U;return e.outline=!0,e.outlineColor=o.WHITE,e}function wt(){var e=new V;return e.translucencyByDistance=new y(3e6,1,5e6,0),e.pixelOffset=new t(17,0),e.horizontalOrigin=T.LEFT,e.font="16px sans-serif",e.style=P.FILL_AND_OUTLINE,e}function Et(n,r,o,a,u){var c=dt(r,"scale",ri.kml),d=dt(r,"heading",ri.kml),h=vt(r,"color",ri.kml),m=lt(r,"Icon",ri.kml),p=ht(m,"href",ri.kml),f=pt(p,n._proxy,a,u),v=dt(m,"x",ri.gx),g=dt(m,"y",ri.gx),y=dt(m,"w",ri.gx),C=dt(m,"h",ri.gx),w=lt(r,"hotSpot",ri.kml),E=at(w,"x"),b=at(w,"y"),S=st(w,"xunits"),x=st(w,"yunits"),T=o.billboard;l(T)||(T=yt(n),o.billboard=T),T.image=f,T.scale=c,T.color=h,(l(v)||l(g)||l(y)||l(C))&&(T.imageSubRegion=new e(v,g,y,C)),l(d)&&0!==d&&(T.rotation=_.toRadians(-d),T.alignedAxis=i.UNIT_Z),c=s(c,1);var P,A;l(E)&&("pixels"===S?P=-E*c:"insetPixels"===S?P=(E-ei)*c:"fraction"===S&&(P=-ei*c*E),P+=.5*ei*c),l(b)&&("pixels"===x?A=b:"insetPixels"===x?A=-b:"fraction"===x&&(A=b*ei),A-=.5*ei*c),(l(P)||l(A))&&(T.pixelOffset=new t(P,A))}function bt(e,t,i,n,r){for(var a=0,u=t.childNodes.length;u>a;a++){var c=t.childNodes.item(a);if("IconStyle"===c.nodeName)Et(e,c,i,n,r);else if("LabelStyle"===c.nodeName){var d=i.label;l(d)||(d=wt(),i.label=d),d.scale=s(dt(c,"scale",ri.kml),d.scale),d.fillColor=s(vt(c,"color",ri.kml),d.fillColor),d.text=i.name}else if("LineStyle"===c.nodeName){var h=i.polyline;l(h)||(h=new W,i.polyline=h),h.width=dt(c,"width",ri.kml),h.material=vt(c,"color",ri.kml)}else if("PolyStyle"===c.nodeName){var m=i.polygon;l(m)||(m=Ct(),i.polygon=m),m.material=s(vt(c,"color",ri.kml),m.material),m.fill=s(mt(c,"fill",ri.kml),m.fill),m.outline=s(mt(c,"outline",ri.kml),m.outline)}else if("BalloonStyle"===c.nodeName){var p=s(ft(ht(c,"bgColor",ri.kml)),o.WHITE),f=s(ft(ht(c,"textColor",ri.kml)),o.BLACK),v=ht(c,"text",ri.kml);i.addProperty("balloonStyle"),i.balloonStyle={bgColor:p,textColor:f,text:v}}}}function St(e,t,i,n,r,o){var a=new F,s=ct(i,"Style",ri.kml),u=s.length;u>0&&bt(t,s[u-1],a,r,o);var c=ht(i,"styleUrl",ri.kml);if(l(c)){var d=c,h=n.getById(d);l(h)||(h=n.getById("#"+d)),l(h)&&a.merge(h)}return a}function xt(e,t,i){return I(g(tt(t,e._proxy)),function(n){return Tt(e,n,i,t,!0)})}function Tt(e,t,i,n,r,o){var a,s,u,c,d=ut(t,"Style",ri.kml);if(l(d)){var h=d.length;for(a=0;h>a;a++)c=d[a],s=st(c,"id"),l(s)&&(s="#"+s,r&&l(n)&&(s=n+s),l(i.getById(s))||(u=new F({id:s}),i.add(u),bt(e,c,u,n,o)))}var m=ut(t,"StyleMap",ri.kml);if(l(m)){var p=m.length;for(a=0;p>a;a++){var f=m[a];if(s=st(f,"id"),l(s))for(var v=ct(f,"Pair",ri.kml),g=0;g<v.length;g++){var _=v[g];if("normal"===ht(_,"key",ri.kml)){if(s="#"+s,r&&l(n)&&(s=n+s),!l(i.getById(s))){u=i.getOrCreateEntity(s);var y=ht(_,"styleUrl",ri.kml);if(l(y)){var C=i.getOrCreateEntity(y);l(C)&&u.merge(C)}else c=lt(_,"Style",ri.kml),bt(e,c,u,n,o)}break}}}}var w={},E=[],b=t.getElementsByTagName("styleUrl"),S=b.length;for(a=0;S>a;a++){var x=b[a].textContent;if("#"!==x[0]){var T=x.split("#");if(2===T.length){var P=T[0];if(!l(w[P])){if(l(n)){var A=new M(document.location.href);n=new M(n),P=new M(P).resolve(n.resolve(A)).toString()}E.push(xt(e,P,i,n))}}}}return E}function Pt(e,t,i){var n=new q(e._entityCollection,t.id,["position"]),r=new Y(t.position);t.polyline=l(i.polyline)?i.polyline.clone():new W,t.polyline.positions=new G([n,r])}function At(e,t,i){return"relativeToSeaFloor"===i||"absolute"===t||"relativeToGround"===t?e:((l(t)&&"clampToGround"!==t||l(i)&&"clampToSeaFloor"!==i)&&window.console.log("KML - Unknown altitudeMode: "+s(t,i)),new Y(e))}function Mt(e,t,i){if(!l(e))return void 0;if("relativeToSeaFloor"===i||"absolute"===t||"relativeToGround"===t)return e;(l(t)&&"clampToGround"!==t||l(i)&&"clampToSeaFloor"!==i)&&window.console.log("KML - Unknown altitudeMode: "+s(t,i));for(var n=e.length,r=0;n>r;r++){var o=e[r];d.WGS84.scaleToGeodeticSurface(o,o)}return e}function It(e,i,n){var r=i.label;l(r)||(r=l(n.label)?n.label.clone():wt(),i.label=r),r.text=i.name;var a=i.billboard;if(l(a)||(a=l(n.billboard)?n.billboard.clone():yt(),i.billboard=a),l(a.image)||(a.image=e._pinBuilder.fromColor(o.YELLOW,64)),l(a.scale)){var s=a.scale.getValue();0!==s?r.pixelOffset=new t(16*s+1,0):(r.pixelOffset=void 0,r.horizontalOrigin=void 0)}}function Dt(e,t,i){var n=t.path;l(n)||(n=new k,n.leadTime=0,t.path=n);var r=i.polyline;l(r)&&(n.material=r.material,n.width=r.width)}function Ot(e,t,i,n){var r=ht(t,"coordinates",ri.kml),o=ht(t,"altitudeMode",ri.kml),a=ht(t,"altitudeMode",ri.gx),s=mt(t,"extrude",ri.kml),u=rt(r);l(u)&&(i.position=At(new L(u),o,a),It(e,i,n),s&&nt(o,a)&&Pt(e,i,n))}function Rt(e,t,i,n){var r=lt(t,"coordinates",ri.kml),a=ht(t,"altitudeMode",ri.kml),s=ht(t,"altitudeMode",ri.gx),u=mt(t,"extrude",ri.kml),c=mt(t,"tessellate",ri.kml),d=nt(a,s),h=ot(r),m=n.polyline;if(d&&u){var p=new Z;i.wall=p,p.positions=h;var f=n.polygon;l(f)&&(p.fill=f.fill,p.outline=f.outline,p.material=f.material),l(m)&&(p.outlineColor=l(m.material)?m.material.color:o.WHITE,p.outlineWidth=m.width)}else m=l(m)?m.clone():new W,i.polyline=m,m.positions=Mt(h,a,s),(!c||d)&&(m.followSurface=!1)}function Lt(e,t,i,n){var r=lt(t,"outerBoundaryIs",ri.kml),a=lt(r,"LinearRing",ri.kml),s=lt(a,"coordinates",ri.kml),u=ot(s),c=mt(t,"extrude",ri.kml),d=ht(t,"altitudeMode",ri.kml),h=ht(t,"altitudeMode",ri.gx),m=nt(d,h),p=l(n.polygon)?n.polygon.clone():Ct(),f=n.polyline;if(l(f)&&(p.outlineColor=l(f.material)?f.material.color:o.WHITE,p.outlineWidth=f.width),i.polygon=p,m&&(p.perPositionHeight=!0,p.extrudedHeight=c?0:void 0),l(u)){for(var v=new w(u),g=ct(t,"innerBoundaryIs",ri.kml),_=0;_<g.length;_++){a=ct(g[_],"LinearRing",ri.kml);for(var y=0;y<a.length;y++)s=lt(a[y],"coordinates",ri.kml),u=ot(s),l(u)&&v.holes.push(new w(u))}p.hierarchy=v}}function Nt(e,t,i,n){for(var r=ht(t,"altitudeMode",ri.kml),o=ht(t,"altitudeMode",ri.gx),a=ct(t,"coord",ri.gx),s=ct(t,"when",ri.kml),u=mt(t,"extrude",ri.kml),c=nt(r,o),d=Math.min(a.length,s.length),h=[],m=[],p=0;d>p;p++){var v=rt(a[p].textContent);l(v)&&(h.push(v),m.push(f.fromIso8601(s[p].textContent)))}var g=new j;g.addSamples(m,h),i.position=At(g,r,o),It(e,i,n),Dt(e,i,n),i.availability=new x,s.length>0&&i.availability.addInterval(new S({start:m[0],stop:m[m.length-1]})),c&&u&&Pt(e,i,n)}function zt(e,t,i,n,r,o,a,s,l){var u=e[0],c=e[e.length-1],d=new j;d.addSamples(e,t),i.intervals.addInterval(new S({start:u,stop:c,isStartIncluded:l,isStopIncluded:l,data:At(d,a,s)})),n.addInterval(new S({start:u,stop:c,isStartIncluded:l,isStopIncluded:l})),r.intervals.addInterval(new S({start:u,stop:c,isStartIncluded:l,isStopIncluded:l,data:o}))}function Ft(e,t,i,n){for(var r,o,a,s=mt(t,"interpolate",ri.gx),u=ct(t,"Track",ri.gx),c=!1,d=new X,h=new x,m=new R,p=0,v=u.length;v>p;p++){var g=u[p],_=ct(g,"when",ri.kml),y=ct(g,"coord",ri.gx),C=ht(g,"altitudeMode",ri.kml),w=ht(g,"altitudeMode",ri.gx),E=nt(C,w),b=mt(g,"extrude",ri.kml),S=Math.min(y.length,_.length),T=[];r=[];for(var P=0;S>P;P++){var A=rt(y[P].textContent);l(A)&&(T.push(A),r.push(f.fromIso8601(_[P].textContent)))}s&&(l(o)&&zt([o,r[0]],[a,T[0]],m,h,d,!1,"absolute",void 0,!1),o=r[S-1],a=T[T.length-1]),zt(r,T,m,h,d,E&&b,C,w,!0),c=c||E&&b}i.availability=h,i.position=m,It(e,i,n),Dt(e,i,n),c&&(Pt(e,i,n),i.polyline.show=d)}function Bt(e,t,i,n){for(var r=t.childNodes,o=0,a=r.length;a>o;o++){var s=r.item(o),u=si[s.localName];if(l(u)){var c=it(s,e._entityCollection);c.parent=i,c.name=i.name,c.availability=i.availability,c.description=i.description,c.kml=i.kml,u(e,s,c,n)}}}function Vt(e,t){var i=lt(e,"ExtendedData",ri.kml);if(!l(i))return void 0;var n={},r=ct(i,"Data",ri.kml);if(l(r))for(var o=r.length,a=0;o>a;a++){var s=r[a],u=st(s,"name");l(u)&&(n[u]={displayName:ht(s,"displayName",ri.kml),value:ht(s,"value",ri.kml)})}t.kml.extendedData=n}function kt(e,t,i,n){var r,a,u,c=t.kml,d=c.extendedData,h=ht(e,"description",ri.kml),m=s(t.balloonStyle,i.balloonStyle),p=o.WHITE,f=o.BLACK,v=h;l(m)&&(p=s(m.bgColor,o.WHITE),f=s(m.textColor,o.BLACK),v=s(m.text,h));var g;if(l(v)){if(v=v.replace("$[name]",s(t.name,"")),v=v.replace("$[description]",s(h,"")),v=v.replace("$[address]",s(c.address,"")),v=v.replace("$[Snippet]",s(c.snippet,"")),v=v.replace("$[id]",t.id),v=v.replace("$[geDirections]",""),l(d)){var _=v.match(/\$\[.+?\]/g);if(null!==_)for(r=0;r<_.length;r++){var y=_[r],C=y.substr(2,y.length-3),w=/\/displayName$/.test(C);C=C.replace(/\/displayName$/,""),g=d[C],l(g)&&(g=w?g.displayName:g.value),l(g)&&(v=v.replace(y,s(g,"")))}}}else if(l(d)&&(u=Object.keys(d),u.length>0)){for(v='<table class="cesium-infoBox-defaultTable cesium-infoBox-defaultTable-lighter"><tbody>',r=0;r<u.length;r++)a=u[r],g=d[a],v+="<tr><th>"+s(g.displayName,a)+"</th><td>"+s(g.value,"")+"</td></tr>";v+="</tbody></table>"}if(l(v)){v=$t.link(v),ai.innerHTML=v;var E=ai.querySelectorAll("a");for(r=0;r<E.length;r++)E[r].setAttribute("target","_blank");l(n)&&n.keys.length>1&&(et(ai,"a","href",n),et(ai,"img","src",n));var b='<div class="cesium-infoBox-description-lighter" style="';b+="overflow:auto;",b+="word-wrap:break-word;",b+="background-color:"+p.toCssColorString()+";",b+="color:"+f.toCssColorString()+";",b+='">',b+=ai.innerHTML+"</div>",ai.innerHTML="",t.description=b}}function Ut(e,t,i,n,r,o,a){var u=it(i,n),c=u.kml,d=St(u,e,i,r,o,a),h=ht(i,"name",ri.kml);u.name=h,u.parent=t;var m=_t(i);l(m)||(m=gt(i)),u.availability=m;var p=mt(i,"visibility",ri.kml);u.show=s(p,!0);var f=lt(i,"author",ri.atom),v=c.author;v.name=ht(f,"name",ri.atom),v.uri=ht(f,"uri",ri.atom),v.email=ht(f,"email",ri.atom);var g=lt(i,"link",ri.atom),_=c.link;return _.href=st(g,"href"),_.hreflang=st(g,"hreflang"),_.rel=st(g,"rel"),_.type=st(g,"type"),_.title=st(g,"title"),_.length=st(g,"length"),c.address=ht(i,"address",ri.kml),c.phoneNumber=ht(i,"phoneNumber",ri.kml),c.snippet=ht(i,"Snippet",ri.kml),Vt(i,u),kt(i,u,d,a),{entity:u,styleEntity:d}}function Wt(e,t,i,n,r,o,a){for(var s=Object.keys(li),l=s.length,u=0;l>u;u++)for(var c=s[u],d=li[c],h=i.childNodes,m=h.length,p=0;m>p;p++){var f=h[p];f.localName===c&&-1!==ri.kml.indexOf(f.namespaceURI)&&d(e,t,f,n,r,o,a)}}function Gt(e,t,i,n,r,o,a){var s=Ut(e,t,i,n,r,o,a);Wt(e,s.entity,i,n,r,o,a)}function Ht(e,t,i,n,r,o,a){for(var s=Ut(e,t,i,n,r,o,a),u=s.entity,c=s.styleEntity,d=!1,h=i.childNodes,m=0,p=h.length;p>m&&!d;m++){var f=h.item(m),v=si[f.localName];l(v)&&(v(e,f,u,c),d=!0)}d||(u.merge(c),It(e,u,c))}function qt(e,t,i,n,r,o,a){var s=Ut(e,t,i,n,r,o,a),u=s.entity;s.stylEntity;var c,d=!1,h=ot(lt(i,"LatLonQuad",ri.gx));if(l(h))c=Ct(),c.hierarchy=new w(h),u.polygon=c,d=!0;else{c=new H,u.rectangle=c;var m=lt(i,"LatLonBox",ri.kml);if(l(m)){var p=dt(m,"west",ri.kml),f=dt(m,"south",ri.kml),v=dt(m,"east",ri.kml),g=dt(m,"north",ri.kml);l(p)&&(p=_.negativePiToPi(_.toRadians(p))),l(f)&&(f=_.negativePiToPi(_.toRadians(f))),l(v)&&(v=_.negativePiToPi(_.toRadians(v))),l(g)&&(g=_.negativePiToPi(_.toRadians(g))),c.coordinates=new E(p,f,v,g);var y=dt(m,"rotation",ri.kml);l(y)&&(c.rotation=_.toRadians(y))}}var C=lt(i,"Icon",ri.kml),b=ht(C,"href",ri.kml);l(b)?(d&&window.console.log("KML - gx:LatLonQuad Icon does not support texture projection."),c.material=pt(b,e._proxy,o,a)):c.material=vt(i,"color",ri.kml);var S=ht(i,"altitudeMode",ri.kml);l(S)?"absolute"===S?c.height=dt(i,"altitude",ri.kml):"clampToGround"===S||window.console.log("KML - Unknown altitudeMode: "+S):(S=ht(i,"altitudeMode",ri.gx),"relativeToSeaFloor"===S?(window.console.log("KML - altitudeMode relativeToSeaFloor is currently not supported, treating as absolute."),c.height=dt(i,"altitude",ri.kml)):"clampToSeaFloor"===S?window.console.log("KML - altitudeMode clampToSeaFloor is currently not supported, treating as clampToGround."):l(S)&&window.console.log("KML - Unknown altitudeMode: "+S))}function jt(e,t,i){window.console.log("KML - Unsupported feature: "+i.nodeName)}function Yt(e,t,i,n,r,o,a){var s=Ut(e,t,i,n,r,o,a),u=s.entity,c=lt(i,"Link",ri.kml);if(l(c)){var d=ht(c,"href",ri.kml);if(l(d)){d=pt(d,void 0,o,a);var h=new ui(e._proxy),m=I(h.load(d),function(){for(var t=h.entities.values,i=0;i<t.length;i++)e._entityCollection.suspendEvents(),t[i].parent=u,e._entityCollection.add(t[i]),e._entityCollection.resumeEvents()});e._promises.push(m)}}}function Xt(e,t,i,n,r,o,a){var s=li[t.nodeName];l(s)?s(e,i,t,n,r,o,a):window.console.log("KML - Unsupported feature node: "+t.nodeName)}function Zt(e,t,i,o){var a=e._entityCollection;e._promises=[],a.removeAll();var s=t.documentElement,u="Document"===s.localName?s:lt(s,"Document",ri.kml),c=ht(u,"name",ri.kml);!l(c)&&l(i)&&(c=m(i));var d=new B;return I.all(Tt(e,t,d,i,!1,o),function(){var s=t.documentElement;return"kml"===s.nodeName&&(s=s.firstElementChild),Xt(e,s,void 0,a,d,i,o),I.all(e._promises,function(){var t,i=a.computeAvailability(),o=i.start,s=i.stop,l=f.equals(o,p.MINIMUM_VALUE),u=f.equals(s,p.MAXIMUM_VALUE);if(!l||!u){var d;l&&(d=new Date,d.setHours(0,0,0,0),o=f.fromDate(d)),u&&(d=new Date,d.setHours(24,0,0,0),s=f.fromDate(d)),t=new z,t.startTime=o,t.stopTime=s,t.currentTime=f.clone(o),t.clockRange=n.LOOP_STOP,t.clockStep=r.SYSTEM_CLOCK_MULTIPLIER,t.multiplier=Math.round(Math.min(Math.max(f.secondsDifference(s,o)/60,1),31556900))}var h=!1;return e._name!==c&&(e._name=c,h=!0),t!==e._clock&&(h=!0,e._clock=t),h&&e._changed.raiseEvent(e),N.setLoading(e,!1),e})})}function Jt(e,t,i){var n=I.defer();return D.createReader(new D.BlobReader(t),function(t){t.getEntries(function(r){for(var o=[],a=!1,s={},u=0;u<r.length;u++){var c=r[u];if(!c.directory){var d=I.defer();o.push(d.promise),!a&&/\.kml$/i.test(c.filename)?(a=!0,Q(t,c,s,d)):$(t,c,s,d)}}I.all(o).then(function(){return t.close(),l(s.kml)?(s.keys=Object.keys(s),Zt(e,s.kml,i,s)):(n.reject(new b("KMZ file does not contain a KML document.")),void 0)}).then(n.resolve).otherwise(n.reject)})},function(e){n.reject(e)}),n}var Kt={avi:"video/x-msvideo",bmp:"image/bmp",bz2:"application/x-bzip2",chm:"application/vnd.ms-htmlhelp",css:"text/css",csv:"text/csv",doc:"application/msword",dvi:"application/x-dvi",eps:"application/postscript",flv:"video/x-flv",gif:"image/gif",gz:"application/x-gzip",htm:"text/html",html:"text/html",ico:"image/vnd.microsoft.icon",jnlp:"application/x-java-jnlp-file",jpeg:"image/jpeg",jpg:"image/jpeg",m3u:"audio/x-mpegurl",m4v:"video/mp4",mathml:"application/mathml+xml",mid:"audio/midi",midi:"audio/midi",mov:"video/quicktime",mp3:"audio/mpeg",mp4:"video/mp4",mp4v:"video/mp4",mpeg:"video/mpeg",mpg:"video/mpeg",odp:"application/vnd.oasis.opendocument.presentation",ods:"application/vnd.oasis.opendocument.spreadsheet",odt:"application/vnd.oasis.opendocument.text",ogg:"application/ogg",pdf:"application/pdf",png:"image/png",pps:"application/vnd.ms-powerpoint",ppt:"application/vnd.ms-powerpoint",ps:"application/postscript",qt:"video/quicktime",rdf:"application/rdf+xml",rss:"application/rss+xml",rtf:"application/rtf",svg:"image/svg+xml",swf:"application/x-shockwave-flash",text:"text/plain",tif:"image/tiff",tiff:"image/tiff",txt:"text/plain",wav:"audio/x-wav",wma:"audio/x-ms-wma",wmv:"video/x-ms-wmv",xml:"application/xml",zip:"application/zip",detectFromFilename:function(e){var t=e.toLowerCase();return t=t.substr(t.lastIndexOf(".")+1),Kt[t]}},Qt=new DOMParser,$t=new A({stripPrefix:!1,twitter:!1,email:!1,replaceFn:function(e,t){return t.protocolUrlMatch?void 0:!1}}),ei=32,ti=[null,void 0,"http://www.opengis.net/kml/2.2","http://earth.google.com/kml/2.2","http://earth.google.com/kml/2.1","http://earth.google.com/kml/2.0"],ii=["http://www.google.com/kml/ext/2.2"],ni=["http://www.w3.org/2005/Atom"],ri={kml:ti,gx:ii,atom:ni,kmlgx:ti.concat(ii)},oi={},ai=document.createElement("div"),si={Point:Ot,LineString:Rt,LinearRing:Rt,Polygon:Lt,Track:Nt,MultiTrack:Ft,MultiGeometry:Bt},li={Document:Wt,Folder:Gt,Placemark:Ht,NetworkLink:Yt,GroundOverlay:qt,PhotoOverlay:jt,ScreenOverlay:jt},ui=function(e){this._changed=new h,this._error=new h,this._loading=new h,this._clock=void 0,this._entityCollection=new B,this._name=void 0,this._isLoading=!1,this._proxy=e,this._pinBuilder=new C,this._promises=[]};ui.load=function(e,t){t=s(t,s.EMPTY_OBJECT);var i=new ui(t.proxy);return i.load(e,t)},u(ui.prototype,{name:{get:function(){return this._name}},clock:{get:function(){return this._clock}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),ui.prototype.load=function(e,t){N.setLoading(this,!0),t=s(t,s.EMPTY_OBJECT);var i=t.sourceUri,n=e;"string"==typeof e&&(n=v(tt(e,this._proxy)),i=s(i,e));var r=this;return I(n,function(e){return e instanceof Blob?J(e).then(function(t){return t?Jt(r,e,i):I(K(e)).then(function(e){var t,n;try{t=Qt.parseFromString(e,"application/xml")}catch(o){n=o.toString()}if(l(n)||t.body||"parsererror"===t.documentElement.tagName){var a=l(n)?n:t.documentElement.firstChild.nodeValue;throw a||(a=t.body.innerText),new b(a)}return Zt(r,t,i,void 0)})}):I(Zt(r,e,i,void 0))}).otherwise(function(e){return N.setLoading(r,!1),r._error.raiseEvent(r,e),window.console.log(e),I.reject(e)
})};var ci=function(){this.author={name:void 0,uri:void 0,email:void 0},this.link={href:void 0,hreflang:void 0,rel:void 0,type:void 0,title:void 0,length:void 0},this.address=void 0,this.phoneNumber=void 0,this.snippet=void 0,this.extendedData=void 0};return ui}),define("Cesium/Core/appendForwardSlash",[],function(){"use strict";var e=function(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e};return e}),define("Cesium/Core/Credit",["./defined","./defineProperties","./DeveloperError"],function(e,t){"use strict";var i=0,n={},r=function(t,r,o){var a=e(o),s=e(r),l=e(t);l||s||(t=o),this._text=t,this._imageUrl=r,this._link=o,this._hasLink=a,this._hasImage=s;var u,c=JSON.stringify([t,r,o]);e(n[c])?u=n[c]:(u=i++,n[c]=u),this._id=u};return t(r.prototype,{text:{get:function(){return this._text}},imageUrl:{get:function(){return this._imageUrl}},link:{get:function(){return this._link}},id:{get:function(){return this._id}}}),r.prototype.hasImage=function(){return this._hasImage},r.prototype.hasLink=function(){return this._hasLink},r.equals=function(t,i){return t===i||e(t)&&e(i)&&t._id===i._id},r.prototype.equals=function(e){return r.equals(this,e)},r}),define("Cesium/Core/GeographicTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./GeographicProjection","./Math","./Rectangle"],function(e,t,i,n,r,o,a,s,l){"use strict";var u=function(e){e=t(e,{}),this._ellipsoid=t(e.ellipsoid,o.WGS84),this._rectangle=t(e.rectangle,l.MAX_VALUE),this._projection=new a(this._ellipsoid),this._numberOfLevelZeroTilesX=t(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=t(e.numberOfLevelZeroTilesY,1)};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),u.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},u.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},u.prototype.rectangleToNativeRectangle=function(e,t){var n=s.toDegrees(e.west),r=s.toDegrees(e.south),o=s.toDegrees(e.east),a=s.toDegrees(e.north);return i(t)?(t.west=n,t.south=r,t.east=o,t.north=a,t):new l(n,r,o,a)},u.prototype.tileXYToNativeRectangle=function(e,t,i,n){var r=this.tileXYToRectangle(e,t,i,n);return r.west=s.toDegrees(r.west),r.south=s.toDegrees(r.south),r.east=s.toDegrees(r.east),r.north=s.toDegrees(r.north),r},u.prototype.tileXYToRectangle=function(e,t,n,r){var o=this._rectangle,a=this.getNumberOfXTilesAtLevel(n),s=this.getNumberOfYTilesAtLevel(n),u=o.width/a,c=e*u+o.west,d=(e+1)*u+o.west,h=o.height/s,m=o.north-t*h,p=o.north-(t+1)*h;return i(r)||(r=new l(c,p,d,m)),r.west=c,r.south=p,r.east=d,r.north=m,r},u.prototype.positionToTileXY=function(t,n,r){var o=this._rectangle;if(!l.contains(o,t))return void 0;var a=this.getNumberOfXTilesAtLevel(n),u=this.getNumberOfYTilesAtLevel(n),c=o.width/a,d=o.height/u,h=t.longitude;o.east<o.west&&(h+=s.TWO_PI);var m=0|(h-o.west)/c;m>=a&&(m=a-1);var p=0|(o.north-t.latitude)/d;return p>=u&&(p=u-1),i(r)?(r.x=m,r.y=p,r):new e(m,p)},u}),define("Cesium/Core/TileProviderError",["./defaultValue","./defined","./formatError"],function(e,t,i){"use strict";var n=function(t,i,n,r,o,a){this.provider=t,this.message=i,this.x=n,this.y=r,this.level=o,this.timesRetried=e(a,0),this.retry=!1};return n.handleError=function(e,r,o,a,s,l,u,c){var d=e;return t(e)?(d.provider=r,d.message=a,d.x=s,d.y=l,d.level=u,d.retry=!1,++d.timesRetried):d=new n(r,a,s,l,u,0),o.numberOfListeners>0?o.raiseEvent(d):console.log('An error occurred in "'+r.constructor.name+'": '+i(a)),d.retry&&t(c)&&c(),d},n.handleSuccess=function(e){t(e)&&(e.timesRetried=-1)},n}),define("Cesium/Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(e){this._ellipsoid=i(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return r(l.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),l.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},l.geodeticLatitudeToMercatorAngle=function(e){e>l.MaximumLatitude?e=l.MaximumLatitude:e<-l.MaximumLatitude&&(e=-l.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},l.MaximumLatitude=l.mercatorAngleToGeodeticLatitude(Math.PI),l.prototype.project=function(t,i){var r=this._semimajorAxis,o=t.longitude*r,a=l.geodeticLatitudeToMercatorAngle(t.latitude)*r,s=t.height;return n(i)?(i.x=o,i.y=a,i.z=s,i):new e(o,a,s)},l.prototype.unproject=function(e,i){var r=this._oneOverSemimajorAxis,o=e.x*r,a=l.mercatorAngleToGeodeticLatitude(e.y*r),s=e.z;return n(i)?(i.longitude=o,i.latitude=a,i.height=s,i):new t(o,a,s)},l}),define("Cesium/Core/WebMercatorTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Rectangle","./WebMercatorProjection"],function(e,t,i,n,r,o,a){"use strict";var s=function(n){if(n=t(n,{}),this._ellipsoid=t(n.ellipsoid,r.WGS84),this._numberOfLevelZeroTilesX=t(n.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=t(n.numberOfLevelZeroTilesY,1),this._projection=new a(this._ellipsoid),i(n.rectangleSouthwestInMeters)&&i(n.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=n.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=n.rectangleNortheastInMeters;else{var s=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new e(-s,-s),this._rectangleNortheastInMeters=new e(s,s)}var l=this._projection.unproject(this._rectangleSouthwestInMeters),u=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new o(l.longitude,l.latitude,u.longitude,u.latitude)};return n(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),s.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},s.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},s.prototype.rectangleToNativeRectangle=function(e,t){var n=this._projection,r=n.project(o.southwest(e)),a=n.project(o.northeast(e));return i(t)?(t.west=r.x,t.south=r.y,t.east=a.x,t.north=a.y,t):new o(r.x,r.y,a.x,a.y)},s.prototype.tileXYToNativeRectangle=function(e,t,n,r){var a=this.getNumberOfXTilesAtLevel(n),s=this.getNumberOfYTilesAtLevel(n),l=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/a,u=this._rectangleSouthwestInMeters.x+e*l,c=this._rectangleSouthwestInMeters.x+(e+1)*l,d=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/s,h=this._rectangleNortheastInMeters.y-t*d,m=this._rectangleNortheastInMeters.y-(t+1)*d;return i(r)?(r.west=u,r.south=m,r.east=c,r.north=h,r):new o(u,m,c,h)},s.prototype.tileXYToRectangle=function(t,i,n,r){var o=this.tileXYToNativeRectangle(t,i,n,r),a=this._projection,s=a.unproject(new e(o.west,o.south)),l=a.unproject(new e(o.east,o.north));return o.west=s.longitude,o.south=s.latitude,o.east=l.longitude,o.north=l.latitude,o},s.prototype.positionToTileXY=function(t,n,r){var a=this._rectangle;if(!o.contains(a,t))return void 0;var s=this.getNumberOfXTilesAtLevel(n),l=this.getNumberOfYTilesAtLevel(n),u=this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x,c=u/s,d=this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y,h=d/l,m=this._projection,p=m.project(t),f=p.x-this._rectangleSouthwestInMeters.x,v=this._rectangleNortheastInMeters.y-p.y,g=0|f/c;g>=s&&(g=s-1);var _=0|v/h;return _>=l&&(_=l-1),i(r)?(r.x=g,r.y=_,r):new e(g,_)},s}),define("Cesium/Core/loadImageViaBlob",["../ThirdParty/when","./loadBlob","./loadImage"],function(e,t,i){"use strict";var n=/^data:/,r=function(r){return n.test(r)?i(r):t(r).then(function(t){var n=window.URL.createObjectURL(t);return i(n,!1).then(function(e){return e.blob=t,window.URL.revokeObjectURL(n),e},function(t){return window.URL.revokeObjectURL(n),e.reject(t)})})},o=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();return o?r:i}),define("Cesium/Core/throttleRequestByServer",["../ThirdParty/Uri","../ThirdParty/when","./defaultValue"],function(e,t,i){"use strict";function n(t){var i=new e(t).resolve(a);i.normalize();var n=i.authority;return/:/.test(n)||(n=n+":"+("https"===i.scheme?"443":"80")),n}var r=6,o={},a=new e(document.location.href),s=function(e,a){var s=n(e),l=i(o[s],0);return l>=r?void 0:(o[s]=l+1,t(a(e),function(e){return o[s]--,e}).otherwise(function(e){return o[s]--,t.reject(e)}))};return s}),define("Cesium/Scene/ImageryProvider",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/loadImage","../Core/loadImageViaBlob","../Core/throttleRequestByServer"],function(e,t,i,n,r,o){"use strict";var a=function(){this.defaultAlpha=void 0,this.defaultBrightness=void 0,this.defaultContrast=void 0,this.defaultHue=void 0,this.defaultSaturation=void 0,this.defaultGamma=void 0,i.throwInstantiationError()};return t(a.prototype,{ready:{get:i.throwInstantiationError},rectangle:{get:i.throwInstantiationError},tileWidth:{get:i.throwInstantiationError},tileHeight:{get:i.throwInstantiationError},maximumLevel:{get:i.throwInstantiationError},minimumLevel:{get:i.throwInstantiationError},tilingScheme:{get:i.throwInstantiationError},tileDiscardPolicy:{get:i.throwInstantiationError},errorEvent:{get:i.throwInstantiationError},credit:{get:i.throwInstantiationError},proxy:{get:i.throwInstantiationError},hasAlphaChannel:{get:i.throwInstantiationError}}),a.prototype.getTileCredits=i.throwInstantiationError,a.prototype.requestImage=i.throwInstantiationError,a.prototype.pickFeatures=i.throwInstantiationError,a.loadImage=function(t,i){return e(t.tileDiscardPolicy)?o(i,r):o(i,n)},a}),define("Cesium/Scene/TileMapServiceImageryProvider",["../Core/appendForwardSlash","../Core/Cartesian2","../Core/Cartographic","../Core/Credit","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/GeographicTilingScheme","../Core/loadXML","../Core/Rectangle","../Core/TileProviderError","../Core/WebMercatorTilingScheme","../ThirdParty/when","./ImageryProvider"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f){"use strict";function v(e,t,i,n){var r=e._tilingScheme.getNumberOfYTilesAtLevel(n),a=e._url+n+"/"+t+"/"+(r-i-1)+"."+e._fileExtension,s=e._proxy;return o(s)&&(a=s.getURL(a)),a}var g=function(a){function s(e){for(var n,a,s,l,c=/tileformat/i,p=/tileset/i,f=/tilesets/i,_=/boundingbox/i,w=/srs/i,E=[],b=e.childNodes[0].childNodes,S=0;S<b.length;S++)if(c.test(b.item(S).nodeName))n=b.item(S);else if(f.test(b.item(S).nodeName)){s=b.item(S);for(var x=b.item(S).childNodes,T=0;T<x.length;T++)p.test(x.item(T).nodeName)&&E.push(x.item(T))}else _.test(b.item(S).nodeName)?a=b.item(S):w.test(b.item(S).nodeName)&&(l=b.item(S).textContent);C._fileExtension=r(C._fileExtension,n.getAttribute("extension")),C._tileWidth=r(C._tileWidth,parseInt(n.getAttribute("width"),10)),C._tileHeight=r(C._tileHeight,parseInt(n.getAttribute("height"),10)),C._minimumLevel=r(C._minimumLevel,parseInt(E[0].getAttribute("order"),10)),C._maximumLevel=r(C._maximumLevel,parseInt(E[E.length-1].getAttribute("order"),10));var P=s.getAttribute("profile"),A=!1;if(("geodetic"===P||"mercator"===P)&&(A=!0),!o(C._tilingScheme))if("geodetic"===P||"global-geodetic"===P)C._tilingScheme=new u;else{if("mercator"!==P&&"global-mercator"!==P){var M=g+"tilemapresource.xml specifies an unsupported profile attribute, "+P+".";return y=h.handleError(y,C,C._errorEvent,M,void 0,void 0,void 0,v),void 0}C._tilingScheme=new m}var I=C._tilingScheme;if(!o(C._rectangle)){var D,O,R,L;if(A)D=new t(parseFloat(a.getAttribute("miny")),parseFloat(a.getAttribute("minx"))),O=new t(parseFloat(a.getAttribute("maxy")),parseFloat(a.getAttribute("maxx"))),R=i.fromDegrees(D.x,D.y),L=i.fromDegrees(O.x,O.y);else if(D=new t(parseFloat(a.getAttribute("minx")),parseFloat(a.getAttribute("miny"))),O=new t(parseFloat(a.getAttribute("maxx")),parseFloat(a.getAttribute("maxy"))),C._tilingScheme instanceof u)R=i.fromDegrees(D.x,D.y),L=i.fromDegrees(O.x,O.y);else{var N=C._tilingScheme.projection;R=N.unproject(D),L=N.unproject(O)}C._rectangle=new d(R.longitude,R.latitude,L.longitude,L.latitude)}C._rectangle.west<I.rectangle.west&&(C._rectangle.west=I.rectangle.west),C._rectangle.east>I.rectangle.east&&(C._rectangle.east=I.rectangle.east),C._rectangle.south<I.rectangle.south&&(C._rectangle.south=I.rectangle.south),C._rectangle.north>I.rectangle.north&&(C._rectangle.north=I.rectangle.north);var z=I.positionToTileXY(d.southwest(C._rectangle),C._minimumLevel),F=I.positionToTileXY(d.northeast(C._rectangle),C._minimumLevel),B=(Math.abs(F.x-z.x)+1)*(Math.abs(F.y-z.y)+1);B>4&&(C._minimumLevel=0),C._tilingScheme=I,C._ready=!0}function f(){C._fileExtension=r(a.fileExtension,"png"),C._tileWidth=r(a.tileWidth,256),C._tileHeight=r(a.tileHeight,256),C._minimumLevel=r(a.minimumLevel,0),C._maximumLevel=r(a.maximumLevel,18),C._tilingScheme=o(a.tilingScheme)?a.tilingScheme:new m,C._rectangle=r(a.rectangle,C._tilingScheme.rectangle),C._ready=!0}function v(){var e=g+"tilemapresource.xml",t=C._proxy;o(t)&&(e=t.getURL(e)),p(c(e),s,f)}a=r(a,{});var g=e(a.url);this._url=g,this._ready=!1,this._proxy=a.proxy,this._tileDiscardPolicy=a.tileDiscardPolicy,this._errorEvent=new l,this._fileExtension=a.fileExtension,this._tileWidth=a.tileWidth,this._tileHeight=a.tileHeight,this._minimumLevel=a.minimumLevel,this._maximumLevel=a.maximumLevel,this._rectangle=d.clone(a.rectangle),this._tilingScheme=a.tilingScheme;var _=a.credit;"string"==typeof _&&(_=new n(_)),this._credit=_;var y,C=this;v()};return a(g.prototype,{url:{get:function(){return this._url}},proxy:{get:function(){return this._proxy}},tileWidth:{get:function(){return this._tileWidth}},tileHeight:{get:function(){return this._tileHeight}},maximumLevel:{get:function(){return this._maximumLevel}},minimumLevel:{get:function(){return this._minimumLevel}},tilingScheme:{get:function(){return this._tilingScheme}},rectangle:{get:function(){return this._rectangle}},tileDiscardPolicy:{get:function(){return this._tileDiscardPolicy}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},credit:{get:function(){return this._credit}},hasAlphaChannel:{get:function(){return!0}}}),g.prototype.getTileCredits=function(){return void 0},g.prototype.requestImage=function(e,t,i){var n=v(this,e,t,i);return f.loadImage(this,n)},g.prototype.pickFeatures=function(){return void 0},g}),define("Cesium/Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,i){this.start=e(t,0),this.stop=e(i,0)};return t}),define("Cesium/Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,i,n,r,o,a,s,l,u,c){"use strict";var d=function(t,n){this.center=e.clone(i(t,e.ZERO)),this.radius=i(n,0)},h=new e,m=new e,p=new e,f=new e,v=new e,g=new e,_=new e,y=new e,C=new e,w=new e,E=new e,b=new e;d.fromPoints=function(t,i){if(n(i)||(i=new d),!n(t)||0===t.length)return i.center=e.clone(e.ZERO,i.center),i.radius=0,i;for(var r=e.clone(t[0],_),o=e.clone(r,h),a=e.clone(r,m),s=e.clone(r,p),l=e.clone(r,f),u=e.clone(r,v),c=e.clone(r,g),S=t.length,x=1;S>x;x++){e.clone(t[x],r);var T=r.x,P=r.y,A=r.z;T<o.x&&e.clone(r,o),T>l.x&&e.clone(r,l),P<a.y&&e.clone(r,a),P>u.y&&e.clone(r,u),A<s.z&&e.clone(r,s),A>c.z&&e.clone(r,c)}var M=e.magnitudeSquared(e.subtract(l,o,y)),I=e.magnitudeSquared(e.subtract(u,a,y)),D=e.magnitudeSquared(e.subtract(c,s,y)),O=o,R=l,L=M;I>L&&(L=I,O=a,R=u),D>L&&(L=D,O=s,R=c);var N=C;N.x=.5*(O.x+R.x),N.y=.5*(O.y+R.y),N.z=.5*(O.z+R.z);var z=e.magnitudeSquared(e.subtract(R,N,y)),F=Math.sqrt(z),B=w;B.x=o.x,B.y=a.y,B.z=s.z;var V=E;V.x=l.x,V.y=u.y,V.z=c.z;var k=e.multiplyByScalar(e.add(B,V,y),.5,b),U=0;for(x=0;S>x;x++){e.clone(t[x],r);var W=e.magnitude(e.subtract(r,k,y));W>U&&(U=W);var G=e.magnitudeSquared(e.subtract(r,N,y));if(G>z){var H=Math.sqrt(G);F=.5*(F+H),z=F*F;var q=H-F;N.x=(F*N.x+q*r.x)/H,N.y=(F*N.y+q*r.y)/H,N.z=(F*N.z+q*r.z)/H}}return U>F?(e.clone(N,i.center),i.radius=F):(e.clone(k,i.center),i.radius=U),i};var S=new a,x=new e,T=new e,P=new t,A=new t;d.fromRectangle2D=function(e,t,i){return d.fromRectangleWithHeights2D(e,t,0,0,i)},d.fromRectangleWithHeights2D=function(t,r,o,a,s){if(n(s)||(s=new d),!n(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;r=i(r,S),c.southwest(t,P),P.height=o,c.northeast(t,A),A.height=a;var l=r.project(P,x),u=r.project(A,T),h=u.x-l.x,m=u.y-l.y,p=u.z-l.z;s.radius=.5*Math.sqrt(h*h+m*m+p*p);var f=s.center;return f.x=l.x+.5*h,f.y=l.y+.5*m,f.z=l.z+.5*p,s};var M=[];d.fromRectangle3D=function(e,t,r,a){t=i(t,o.WGS84),r=i(r,0);var s;return n(e)&&(s=c.subsample(e,t,r,M)),d.fromPoints(s,a)},d.fromVertices=function(t,r,o,a){if(n(a)||(a=new d),!n(t)||0===t.length)return a.center=e.clone(e.ZERO,a.center),a.radius=0,a;r=i(r,e.ZERO),o=i(o,3);var s=_;s.x=t[0]+r.x,s.y=t[1]+r.y,s.z=t[2]+r.z;for(var l=e.clone(s,h),u=e.clone(s,m),c=e.clone(s,p),S=e.clone(s,f),x=e.clone(s,v),T=e.clone(s,g),P=t.length,A=0;P>A;A+=o){var M=t[A]+r.x,I=t[A+1]+r.y,D=t[A+2]+r.z;s.x=M,s.y=I,s.z=D,M<l.x&&e.clone(s,l),M>S.x&&e.clone(s,S),I<u.y&&e.clone(s,u),I>x.y&&e.clone(s,x),D<c.z&&e.clone(s,c),D>T.z&&e.clone(s,T)}var O=e.magnitudeSquared(e.subtract(S,l,y)),R=e.magnitudeSquared(e.subtract(x,u,y)),L=e.magnitudeSquared(e.subtract(T,c,y)),N=l,z=S,F=O;R>F&&(F=R,N=u,z=x),L>F&&(F=L,N=c,z=T);var B=C;B.x=.5*(N.x+z.x),B.y=.5*(N.y+z.y),B.z=.5*(N.z+z.z);var V=e.magnitudeSquared(e.subtract(z,B,y)),k=Math.sqrt(V),U=w;U.x=l.x,U.y=u.y,U.z=c.z;var W=E;W.x=S.x,W.y=x.y,W.z=T.z;var G=e.multiplyByScalar(e.add(U,W,y),.5,b),H=0;for(A=0;P>A;A+=o){s.x=t[A]+r.x,s.y=t[A+1]+r.y,s.z=t[A+2]+r.z;var q=e.magnitude(e.subtract(s,G,y));q>H&&(H=q);var j=e.magnitudeSquared(e.subtract(s,B,y));if(j>V){var Y=Math.sqrt(j);k=.5*(k+Y),V=k*k;var X=Y-k;B.x=(k*B.x+X*s.x)/Y,B.y=(k*B.y+X*s.y)/Y,B.z=(k*B.z+X*s.z)/Y}}return H>k?(e.clone(B,a.center),a.radius=k):(e.clone(G,a.center),a.radius=H),a},d.fromCornerPoints=function(t,i,r){n(r)||(r=new d);var o=r.center;return e.add(t,i,o),e.multiplyByScalar(o,.5,o),r.radius=e.distance(o,i),r},d.fromEllipsoid=function(t,i){return n(i)||(i=new d),e.clone(e.ZERO,i.center),i.radius=t.maximumRadius,i};var I=new e;d.fromBoundingSpheres=function(t,i){if(n(i)||(i=new d),!n(t)||0===t.length)return i.center=e.clone(e.ZERO,i.center),i.radius=0,i;var r=t.length;if(1===r)return d.clone(t[0],i);if(2===r)return d.union(t[0],t[1],i);for(var o=[],a=0;r>a;a++)o.push(t[a].center);i=d.fromPoints(o,i);var s=i.center,l=i.radius;for(a=0;r>a;a++){var u=t[a];l=Math.max(l,e.distance(s,u.center,I)+u.radius)}return i.radius=l,i},d.clone=function(t,i){return n(t)?n(i)?(i.center=e.clone(t.center,i.center),i.radius=t.radius,i):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,n){n=i(n,0);var r=e.center;t[n++]=r.x,t[n++]=r.y,t[n++]=r.z,t[n]=e.radius},d.unpack=function(e,t,r){t=i(t,0),n(r)||(r=new d);var o=r.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],r.radius=e[t],r};var D=new e,O=new e;d.union=function(t,i,r){n(r)||(r=new d);var o=t.center,a=i.center;e.add(o,a,O);var s=e.multiplyByScalar(O,.5,O),l=e.magnitude(e.subtract(o,s,D))+t.radius,u=e.magnitude(e.subtract(a,s,D))+i.radius;return r.radius=Math.max(l,u),e.clone(s,r.center),r};var R=new e;d.expand=function(t,i,n){n=d.clone(t,n);var r=e.magnitude(e.subtract(i,n.center,R));return r>n.radius&&(n.radius=r),n},d.intersect=function(t,i){var n=t.center,r=t.radius,o=e.dot(i,n)+i.w;return-r>o?s.OUTSIDE:r>o?s.INTERSECTING:s.INSIDE},d.transform=function(e,t,i){return n(i)||(i=new d),i.center=u.multiplyByPoint(t,e.center,i.center),i.radius=u.getMaximumScale(t)*e.radius,i};var L=new e;d.distanceSquaredTo=function(t,i){var n=e.subtract(t.center,i,L);return e.magnitudeSquared(n)-t.radius*t.radius},d.transformWithoutScale=function(e,t,i){return n(i)||(i=new d),i.center=u.multiplyByPoint(t,e.center,i.center),i.radius=e.radius,i};var N=new e;d.computePlaneDistances=function(t,i,r,o){n(o)||(o=new l);var a=e.subtract(t.center,i,N),s=e.multiplyByScalar(r,e.dot(r,a),N),u=e.magnitude(s);return o.start=u-t.radius,o.stop=u+t.radius,o};for(var z=new e,F=new e,B=new e,V=new e,k=new e,U=new t,W=new Array(8),G=0;8>G;++G)W[G]=new e;var H=new a;return d.projectTo2D=function(t,n,r){n=i(n,H);var o=n.ellipsoid,a=t.center,s=t.radius,l=o.geodeticSurfaceNormal(a,z),u=e.cross(e.UNIT_Z,l,F);e.normalize(u,u);var c=e.cross(l,u,B);e.normalize(c,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(u,s,u);var h=e.negate(c,k),m=e.negate(u,V),p=W,f=p[0];e.add(l,c,f),e.add(f,u,f),f=p[1],e.add(l,c,f),e.add(f,m,f),f=p[2],e.add(l,h,f),e.add(f,m,f),f=p[3],e.add(l,h,f),e.add(f,u,f),e.negate(l,l),f=p[4],e.add(l,c,f),e.add(f,u,f),f=p[5],e.add(l,c,f),e.add(f,m,f),f=p[6],e.add(l,h,f),e.add(f,m,f),f=p[7],e.add(l,h,f),e.add(f,u,f);for(var v=p.length,g=0;v>g;++g){var _=p[g];e.add(a,_,_);var y=o.cartesianToCartographic(_,U);n.project(y,_)}r=d.fromPoints(p,r),a=r.center;var C=a.x,w=a.y,E=a.z;return a.x=E,a.y=C,a.z=w,r},d.equals=function(t,i){return t===i||n(t)&&n(i)&&e.equals(t.center,i.center)&&t.radius===i.radius},d.prototype.intersect=function(e){return d.intersect(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Cesium/Core/destroyObject",["./defaultValue","./DeveloperError"],function(e,t){"use strict";function i(){return!0}var n=function(n,r){function o(){throw new t(r)}r=e(r,"This object was destroyed, i.e., destroy() was called.");for(var a in n)"function"==typeof n[a]&&(n[a]=o);return n.isDestroyed=i,void 0};return n}),define("Cesium/Core/ScreenSpaceEventType",["./freezeObject"],function(e){"use strict";var t={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,RIGHT_DOUBLE_CLICK:8,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MIDDLE_DOUBLE_CLICK:13,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19};return e(t)}),define("Cesium/DataSources/BoundingSphereState",["../Core/freezeObject"],function(e){"use strict";var t={DONE:0,PENDING:1,FAILED:2};return e(t)}),define("Cesium/DataSources/DataSourceCollection",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../ThirdParty/when"],function(e,t,i,n,r,o,a){"use strict";var s=function(){this._dataSources=[],this._dataSourceAdded=new o,this._dataSourceRemoved=new o};return i(s.prototype,{length:{get:function(){return this._dataSources.length}},dataSourceAdded:{get:function(){return this._dataSourceAdded}},dataSourceRemoved:{get:function(){return this._dataSourceRemoved}}}),s.prototype.add=function(e){var t=this,i=this._dataSources;return a(e,function(e){return i===t._dataSources&&(t._dataSources.push(e),t._dataSourceAdded.raiseEvent(t,e)),e})},s.prototype.remove=function(t,i){i=e(i,!1);var n=this._dataSources.indexOf(t);return-1!==n?(this._dataSources.splice(n,1),this._dataSourceRemoved.raiseEvent(this,t),i&&"function"==typeof t.destroy&&t.destroy(),!0):!1},s.prototype.removeAll=function(t){t=e(t,!1);for(var i=this._dataSources,n=0,r=i.length;r>n;++n){var o=i[n];this._dataSourceRemoved.raiseEvent(this,o),t&&"function"==typeof o.destroy&&o.destroy()}this._dataSources=[]},s.prototype.contains=function(e){return-1!==this.indexOf(e)},s.prototype.indexOf=function(e){return this._dataSources.indexOf(e)},s.prototype.get=function(e){return this._dataSources[e]},s.prototype.isDestroyed=function(){return!1},s.prototype.destroy=function(){return this.removeAll(!0),n(this)},s}),define("Cesium/Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,i,n,r){"use strict";var o={};o.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var i=t.x,n=t.y;t.x=(1-Math.abs(n))*r.signNotZero(i),t.y=(1-Math.abs(i))*r.signNotZero(n)}return t.x=r.toSNorm(t.x),t.y=r.toSNorm(t.y),t},o.octDecode=function(e,i,n){if(n.x=r.fromSNorm(e),n.y=r.fromSNorm(i),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var o=n.x;n.x=(1-Math.abs(n.y))*r.signNotZero(o),n.y=(1-Math.abs(o))*r.signNotZero(n.y)}return t.normalize(n,n)},o.octPackFloat=function(e){return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,t){var i=e/256,n=Math.floor(i),r=256*(i-n);return o.octDecode(n,r,t)},o.octPack=function(e,t,i,n){var r=o.octEncodeFloat(e),s=o.octEncodeFloat(t),l=o.octEncode(i,a);return n.x=65536*l.x+r,n.y=65536*l.y+s,n},o.octUnpack=function(e,t,i,n){var r=e.x/65536,a=Math.floor(r),s=65536*(r-a);r=e.y/65536;var l=Math.floor(r),u=65536*(r-l);o.octDecodeFloat(s,t),o.octDecodeFloat(u,i),o.octDecode(a,l,n)},o.compressTextureCoordinates=function(e){var t=1===e.x?4095:0|4096*e.x,i=1===e.y?4095:0|4096*e.y;return 4096*t+i},o.decompressTextureCoordinates=function(e,t){var i=e/4096;return t.x=Math.floor(i)/4096,t.y=i-Math.floor(i),t},o}),define("Cesium/Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,i,n,r){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t);default:throw new i("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(t,n,r,a){switch(r=e(r,0),a=e(a,(n.byteLength-r)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(n,r,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,r,a);case o.SHORT:return new Int16Array(n,r,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,r,a);case o.FLOAT:return new Float32Array(n,r,a);case o.DOUBLE:return new Float64Array(n,r,a);default:throw new i("componentDatatype is not a valid value.")}},r(o)}),define("Cesium/Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var i=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};i.encode=function(e,i){t(i)||(i={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),i.high=n,i.low=e-n):(n=65536*Math.floor(-e/65536),i.high=-n,i.low=e+n),i};var n={high:0,low:0};i.fromCartesian=function(e,r){t(r)||(r=new i);var o=r.high,a=r.low;return i.encode(e.x,n),o.x=n.high,a.x=n.low,i.encode(e.y,n),o.y=n.high,a.y=n.low,i.encode(e.z,n),o.z=n.high,a.z=n.low,r};var r=new i;return i.writeElements=function(e,t,n){i.fromCartesian(e,r);var o=r.high,a=r.low;t[n]=o.x,t[n+1]=o.y,t[n+2]=o.z,t[n+3]=a.x,t[n+4]=a.y,t[n+5]=a.z},i}),define("Cesium/Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,i,n){"use strict";var r={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return r.getSizeInBytes=function(e){switch(e){case r.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case r.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case r.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},r.validate=function(t){return e(t)&&(t===r.UNSIGNED_BYTE||t===r.UNSIGNED_SHORT||t===r.UNSIGNED_INT)},r.createTypedArray=function(e,t){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},r.createTypedArrayFromArrayBuffer=function(e,t,i,r){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,i,r):new Uint16Array(t,i,r)},i(r)}),define("Cesium/Renderer/BufferUsage",["../Core/freezeObject"],function(e){"use strict";var t={STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,validate:function(e){return e===t.STREAM_DRAW||e===t.STATIC_DRAW||e===t.DYNAMIC_DRAW}};return e(t)}),define("Cesium/Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Cesium/Renderer/DrawCommand",["../Core/defaultValue","../Core/PrimitiveType"],function(e,t){"use strict";var i=function(i){i=e(i,e.EMPTY_OBJECT),this.boundingVolume=i.boundingVolume,this.cull=e(i.cull,!0),this.modelMatrix=i.modelMatrix,this.primitiveType=e(i.primitiveType,t.TRIANGLES),this.vertexArray=i.vertexArray,this.count=i.count,this.offset=e(i.offset,0),this.shaderProgram=i.shaderProgram,this.uniformMap=i.uniformMap,this.renderState=i.renderState,this.framebuffer=i.framebuffer,this.pass=i.pass,this.executeInClosestFrustum=e(i.executeInClosestFrustum,!1),this.owner=i.owner,this.debugShowBoundingVolume=e(i.debugShowBoundingVolume,!1),this.debugOverlappingFrustums=0,this.oit=void 0};return i.prototype.execute=function(e,t,i,n){e.draw(this,t,i,n)},i}),define("Cesium/Shaders/Builtin/Constants/degreesPerRadian",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for converting radians to degrees.\n *\n * @alias czm_degreesPerRadian\n * @glslConstant\n *\n * @see CesiumMath.DEGREES_PER_RADIAN\n *\n * @example\n * // GLSL declaration\n * const float czm_degreesPerRadian = ...;\n *\n * // Example\n * float deg = czm_degreesPerRadian * rad;\n */\nconst float czm_degreesPerRadian = 57.29577951308232;"}),define("Cesium/Shaders/Builtin/Constants/depthRange",[],function(){"use strict";return"/**\n * A built-in GLSL vec2 constant for defining the depth range.\n * This is a workaround to a bug where IE11 does not implement gl_DepthRange.\n *\n * @alias czm_depthRange\n * @glslConstant\n *\n * @example\n * // GLSL declaration\n * float depthRangeNear = czm_depthRange.near;\n * float depthRangeFar = czm_depthRange.far;\n *\n */\nconst czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);"}),define("Cesium/Shaders/Builtin/Constants/epsilon1",[],function(){"use strict";return"/**\n * 0.1\n *\n * @name czm_epsilon1\n * @glslConstant\n */\nconst float czm_epsilon1 = 0.1;"}),define("Cesium/Shaders/Builtin/Constants/epsilon2",[],function(){"use strict";return"/**\n * 0.01\n *\n * @name czm_epsilon2\n * @glslConstant\n */\nconst float czm_epsilon2 = 0.01;"}),define("Cesium/Shaders/Builtin/Constants/epsilon3",[],function(){"use strict";return"/**\n * 0.001\n *\n * @name czm_epsilon3\n * @glslConstant\n */\nconst float czm_epsilon3 = 0.001;"}),define("Cesium/Shaders/Builtin/Constants/epsilon4",[],function(){"use strict";return"/**\n * 0.0001\n *\n * @name czm_epsilon4\n * @glslConstant\n */\nconst float czm_epsilon4 = 0.0001;"}),define("Cesium/Shaders/Builtin/Constants/epsilon5",[],function(){"use strict";return"/**\n * 0.00001\n *\n * @name czm_epsilon5\n * @glslConstant\n */\nconst float czm_epsilon5 = 0.00001;"}),define("Cesium/Shaders/Builtin/Constants/epsilon6",[],function(){"use strict";
return"/**\n * 0.000001\n *\n * @name czm_epsilon6\n * @glslConstant\n */\nconst float czm_epsilon6 = 0.000001;"}),define("Cesium/Shaders/Builtin/Constants/epsilon7",[],function(){"use strict";return"/**\n * 0.0000001\n *\n * @name czm_epsilon7\n * @glslConstant\n */\nconst float czm_epsilon7 = 0.0000001;"}),define("Cesium/Shaders/Builtin/Constants/infinity",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_infinity\n * @glslConstant\n */\nconst float czm_infinity = 5906376272000.0;  // Distance from the Sun to Pluto in meters.  TODO: What is best given lowp, mediump, and highp?"}),define("Cesium/Shaders/Builtin/Constants/oneOverPi",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>1/pi</code>.\n *\n * @alias czm_oneOverPi\n * @glslConstant\n *\n * @see CesiumMath.ONE_OVER_PI\n *\n * @example\n * // GLSL declaration\n * const float czm_oneOverPi = ...;\n *\n * // Example\n * float pi = 1.0 / czm_oneOverPi;\n */\nconst float czm_oneOverPi = 0.3183098861837907;"}),define("Cesium/Shaders/Builtin/Constants/oneOverTwoPi",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>1/2pi</code>.\n *\n * @alias czm_oneOverTwoPi\n * @glslConstant\n *\n * @see CesiumMath.ONE_OVER_TWO_PI\n *\n * @example\n * // GLSL declaration\n * const float czm_oneOverTwoPi = ...;\n *\n * // Example\n * float pi = 2.0 * czm_oneOverTwoPi;\n */\nconst float czm_oneOverTwoPi = 0.15915494309189535;"}),define("Cesium/Shaders/Builtin/Constants/pi",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>Math.PI</code>.\n *\n * @alias czm_pi\n * @glslConstant\n *\n * @see CesiumMath.PI\n *\n * @example\n * // GLSL declaration\n * const float czm_pi = ...;\n *\n * // Example\n * float twoPi = 2.0 * czm_pi;\n */\nconst float czm_pi = 3.141592653589793;"}),define("Cesium/Shaders/Builtin/Constants/piOverFour",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>pi/4</code>.\n *\n * @alias czm_piOverFour\n * @glslConstant\n *\n * @see CesiumMath.PI_OVER_FOUR\n *\n * @example\n * // GLSL declaration\n * const float czm_piOverFour = ...;\n *\n * // Example\n * float pi = 4.0 * czm_piOverFour;\n */\nconst float czm_piOverFour = 0.7853981633974483;"}),define("Cesium/Shaders/Builtin/Constants/piOverSix",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>pi/6</code>.\n *\n * @alias czm_piOverSix\n * @glslConstant\n *\n * @see CesiumMath.PI_OVER_SIX\n *\n * @example\n * // GLSL declaration\n * const float czm_piOverSix = ...;\n *\n * // Example\n * float pi = 6.0 * czm_piOverSix;\n */\nconst float czm_piOverSix = 0.5235987755982988;"}),define("Cesium/Shaders/Builtin/Constants/piOverThree",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>pi/3</code>.\n *\n * @alias czm_piOverThree\n * @glslConstant\n *\n * @see CesiumMath.PI_OVER_THREE\n *\n * @example\n * // GLSL declaration\n * const float czm_piOverThree = ...;\n *\n * // Example\n * float pi = 3.0 * czm_piOverThree;\n */\nconst float czm_piOverThree = 1.0471975511965976;"}),define("Cesium/Shaders/Builtin/Constants/piOverTwo",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>pi/2</code>.\n *\n * @alias czm_piOverTwo\n * @glslConstant\n *\n * @see CesiumMath.PI_OVER_TWO\n *\n * @example\n * // GLSL declaration\n * const float czm_piOverTwo = ...;\n *\n * // Example\n * float pi = 2.0 * czm_piOverTwo;\n */\nconst float czm_piOverTwo = 1.5707963267948966;"}),define("Cesium/Shaders/Builtin/Constants/radiansPerDegree",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for converting degrees to radians.\n *\n * @alias czm_radiansPerDegree\n * @glslConstant\n *\n * @see CesiumMath.RADIANS_PER_DEGREE\n *\n * @example\n * // GLSL declaration\n * const float czm_radiansPerDegree = ...;\n *\n * // Example\n * float rad = czm_radiansPerDegree * deg;\n */\nconst float czm_radiansPerDegree = 0.017453292519943295;"}),define("Cesium/Shaders/Builtin/Constants/sceneMode2D",[],function(){"use strict";return"/**\n * The constant identifier for the 2D {@link SceneMode}\n *\n * @name czm_sceneMode2D\n * @glslConstant\n * @see czm_sceneMode\n * @see czm_sceneModeColumbusView\n * @see czm_sceneMode3D\n * @see czm_sceneModeMorphing\n */\nconst float czm_sceneMode2D = 2.0;"}),define("Cesium/Shaders/Builtin/Constants/sceneMode3D",[],function(){"use strict";return"/**\n * The constant identifier for the 3D {@link SceneMode}\n *\n * @name czm_sceneMode3D\n * @glslConstant\n * @see czm_sceneMode\n * @see czm_sceneMode2D\n * @see czm_sceneModeColumbusView\n * @see czm_sceneModeMorphing\n */\nconst float czm_sceneMode3D = 3.0;"}),define("Cesium/Shaders/Builtin/Constants/sceneModeColumbusView",[],function(){"use strict";return"/**\n * The constant identifier for the Columbus View {@link SceneMode}\n *\n * @name czm_sceneModeColumbusView\n * @glslConstant\n * @see czm_sceneMode\n * @see czm_sceneMode2D\n * @see czm_sceneMode3D\n * @see czm_sceneModeMorphing\n */\nconst float czm_sceneModeColumbusView = 1.0;"}),define("Cesium/Shaders/Builtin/Constants/sceneModeMorphing",[],function(){"use strict";return"/**\n * The constant identifier for the Morphing {@link SceneMode}\n *\n * @name czm_sceneModeMorphing\n * @glslConstant\n * @see czm_sceneMode\n * @see czm_sceneMode2D\n * @see czm_sceneModeColumbusView\n * @see czm_sceneMode3D\n */\nconst float czm_sceneModeMorphing = 0.0;"}),define("Cesium/Shaders/Builtin/Constants/solarRadius",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for one solar radius.\n *\n * @alias czm_solarRadius\n * @glslConstant\n *\n * @see CesiumMath.SOLAR_RADIUS\n *\n * @example\n * // GLSL declaration\n * const float czm_solarRadius = ...;\n */\nconst float czm_solarRadius = 695500000.0;"}),define("Cesium/Shaders/Builtin/Constants/threePiOver2",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>3pi/2</code>.\n *\n * @alias czm_threePiOver2\n * @glslConstant\n *\n * @see CesiumMath.THREE_PI_OVER_TWO\n *\n * @example\n * // GLSL declaration\n * const float czm_threePiOver2 = ...;\n *\n * // Example\n * float pi = (2.0 / 3.0) * czm_threePiOver2;\n */\nconst float czm_threePiOver2 = 4.71238898038469;"}),define("Cesium/Shaders/Builtin/Constants/twoPi",[],function(){"use strict";return"/**\n * A built-in GLSL floating-point constant for <code>2pi</code>.\n *\n * @alias czm_twoPi\n * @glslConstant\n *\n * @see CesiumMath.TWO_PI\n *\n * @example\n * // GLSL declaration\n * const float czm_twoPi = ...;\n *\n * // Example\n * float pi = czm_twoPi / 2.0;\n */\nconst float czm_twoPi = 6.283185307179586;"}),define("Cesium/Shaders/Builtin/Constants/webMercatorMaxLatitude",[],function(){"use strict";return"/**\n * The maximum latitude, in radians, both North and South, supported by a Web Mercator\n * (EPSG:3857) projection.  Technically, the Mercator projection is defined\n * for any latitude up to (but not including) 90 degrees, but it makes sense\n * to cut it off sooner because it grows exponentially with increasing latitude.\n * The logic behind this particular cutoff value, which is the one used by\n * Google Maps, Bing Maps, and Esri, is that it makes the projection\n * square.  That is, the rectangle is equal in the X and Y directions.\n *\n * The constant value is computed as follows:\n *   czm_pi * 0.5 - (2.0 * atan(exp(-czm_pi)))\n *\n * @name czm_webMercatorMaxLatitude\n * @glslConstant\n */\nconst float czm_webMercatorMaxLatitude = 1.4844222297453324;"}),define("Cesium/Shaders/Builtin/Structs/depthRangeStruct",[],function(){"use strict";return"/**\n * @name czm_depthRangeStruct\n * @glslStruct\n */\nstruct czm_depthRangeStruct\n{\n    float near;\n    float far;\n};"}),define("Cesium/Shaders/Builtin/Structs/ellipsoid",[],function(){"use strict";return"/** DOC_TBA\n *\n * @name czm_ellipsoid\n * @glslStruct\n */\nstruct czm_ellipsoid\n{\n    vec3 center;\n    vec3 radii;\n    vec3 inverseRadii;\n    vec3 inverseRadiiSquared;\n};"}),define("Cesium/Shaders/Builtin/Structs/material",[],function(){"use strict";return"/**\n * Holds material information that can be used for lighting. Returned by all czm_getMaterial functions.\n *\n * @name czm_material\n * @glslStruct\n *\n * @property {vec3} diffuse Incoming light that scatters evenly in all directions.\n * @property {float} specular Intensity of incoming light reflecting in a single direction.\n * @property {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.\n * @property {vec3} normal Surface's normal in eye coordinates. It is used for effects such as normal mapping. The default is the surface's unmodified normal.\n * @property {vec3} emission Light emitted by the material equally in all directions. The default is vec3(0.0), which emits no light.\n * @property {float} alpha Opacity of this material. 0.0 is completely transparent; 1.0 is completely opaque.\n */\nstruct czm_material\n{\n    vec3 diffuse;\n    float specular;\n    float shininess;\n    vec3 normal;\n    vec3 emission;\n    float alpha;\n};"}),define("Cesium/Shaders/Builtin/Structs/materialInput",[],function(){"use strict";return"/**\n * Used as input to every material's czm_getMaterial function.\n *\n * @name czm_materialInput\n * @glslStruct\n *\n * @property {float} s 1D texture coordinates.\n * @property {vec2} st 2D texture coordinates.\n * @property {vec3} str 3D texture coordinates.\n * @property {vec3} normalEC Unperturbed surface normal in eye coordinates.\n * @property {mat3} tangentToEyeMatrix Matrix for converting a tangent space normal to eye space.\n * @property {vec3} positionToEyeEC Vector from the fragment to the eye in eye coordinates.  The magnitude is the distance in meters from the fragment to the eye.\n */\nstruct czm_materialInput\n{\n    float s;\n    vec2 st;\n    vec3 str;\n    vec3 normalEC;\n    mat3 tangentToEyeMatrix;\n    vec3 positionToEyeEC;\n};"}),define("Cesium/Shaders/Builtin/Structs/ray",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_ray\n * @glslStruct\n */\nstruct czm_ray\n{\n    vec3 origin;\n    vec3 direction;\n};"}),define("Cesium/Shaders/Builtin/Structs/raySegment",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_raySegment\n * @glslStruct\n */\nstruct czm_raySegment\n{\n    float start;\n    float stop;\n};\n\n/**\n * DOC_TBA\n *\n * @name czm_emptyRaySegment\n * @glslConstant \n */\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\n\n/**\n * DOC_TBA\n *\n * @name czm_fullRaySegment\n * @glslConstant \n */\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n"}),define("Cesium/Shaders/Builtin/Functions/RGBToXYZ",[],function(){"use strict";return"/**\n * Converts an RGB color to CIE Yxy.\n * <p>The conversion is described in\n * {@link http://content.gpwiki.org/index.php/D3DBook:High-Dynamic_Range_Rendering#Luminance_Transform|Luminance Transform}\n * </p>\n * \n * @name czm_RGBToXYZ\n * @glslFunction\n * \n * @param {vec3} rgb The color in RGB.\n *\n * @returns {vec3} The color in CIE Yxy.\n *\n * @example\n * vec3 xyz = czm_RGBToXYZ(rgb);\n * xyz.x = max(xyz.x - luminanceThreshold, 0.0);\n * rgb = czm_XYZToRGB(xyz);\n */\nvec3 czm_RGBToXYZ(vec3 rgb)\n{\n    const mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n                              0.3576, 0.7152, 0.1192,\n                              0.1805, 0.0722, 0.9505);\n    vec3 xyz = RGB2XYZ * rgb;\n    vec3 Yxy;\n    Yxy.r = xyz.g;\n    float temp = dot(vec3(1.0), xyz);\n    Yxy.gb = xyz.rg / temp;\n    return Yxy;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/XYZToRGB",[],function(){"use strict";return"/**\n * Converts a CIE Yxy color to RGB.\n * <p>The conversion is described in\n * {@link http://content.gpwiki.org/index.php/D3DBook:High-Dynamic_Range_Rendering#Luminance_Transform|Luminance Transform}\n * </p>\n * \n * @name czm_XYZToRGB\n * @glslFunction\n * \n * @param {vec3} Yxy The color in CIE Yxy.\n *\n * @returns {vec3} The color in RGB.\n *\n * @example\n * vec3 xyz = czm_RGBToXYZ(rgb);\n * xyz.x = max(xyz.x - luminanceThreshold, 0.0);\n * rgb = czm_XYZToRGB(xyz);\n */\nvec3 czm_XYZToRGB(vec3 Yxy)\n{\n    const mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n                              -1.5371,  1.8760, -0.2040,\n                              -0.4985,  0.0416,  1.0572);\n    vec3 xyz;\n    xyz.r = Yxy.r * Yxy.g / Yxy.b;\n    xyz.g = Yxy.r;\n    xyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\n    \n    return XYZ2RGB * xyz;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/alphaWeight",[],function(){"use strict";return"/**\n * @private\n */\nfloat czm_alphaWeight(float a)\n{\n    float z;\n    if (czm_sceneMode != czm_sceneMode2D)\n    {\n        float x = 2.0 * (gl_FragCoord.x - czm_viewport.x) / czm_viewport.z - 1.0;\n	    float y = 2.0 * (gl_FragCoord.y - czm_viewport.y) / czm_viewport.w - 1.0;\n	    z = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\n	    vec4 q = vec4(x, y, z, 0.0);\n	    q /= gl_FragCoord.w;\n	    z = (czm_inverseProjectionOIT * q).z;\n    }\n    else\n    {\n        z = gl_FragCoord.z * (czm_currentFrustum.y - czm_currentFrustum.x) + czm_currentFrustum.x;\n    }\n    \n    // See Weighted Blended Order-Independent Transparency for examples of different weighting functions:\n    // http://jcgt.org/published/0002/02/09/\n    return pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 100.0 / (1e-5 + pow(abs(z) / 10.0, 3.0) + pow(abs(z) / 200.0, 6.0))));\n}"}),define("Cesium/Shaders/Builtin/Functions/antialias",[],function(){"use strict";return"/**\n * Procedural anti-aliasing by blurring two colors that meet at a sharp edge.\n *\n * @name czm_antialias\n * @glslFunction\n *\n * @param {vec4} color1 The color on one side of the edge.\n * @param {vec4} color2 The color on the other side of the edge.\n * @param {vec4} currentcolor The current color, either <code>color1</code> or <code>color2</code>.\n * @param {float} dist The distance to the edge in texture coordinates.\n * @param {float} [fuzzFactor=0.1] Controls the blurriness between the two colors.\n * @returns {vec4} The anti-aliased color.\n *\n * @example\n * // GLSL declarations\n * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor);\n * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist);\n *\n * // get the color for a material that has a sharp edge at the line y = 0.5 in texture space\n * float dist = abs(textureCoordinates.t - 0.5);\n * vec4 currentColor = mix(bottomColor, topColor, step(0.5, textureCoordinates.t));\n * vec4 color = czm_antialias(bottomColor, topColor, currentColor, dist, 0.1);\n */\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\n    float val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\n    float val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\n    val1 = val1 * (1.0 - val2);\n    val1 = val1 * val1 * (3.0 - (2.0 * val1));\n    val1 = pow(val1, 0.5); //makes the transition nicer\n    \n    vec4 midColor = (color1 + color2) * 0.5;\n    return mix(midColor, currentColor, val1);\n}\n\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\n    return czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/columbusViewMorph",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_columbusViewMorph\n * @glslFunction\n */\nvec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\n    // Just linear for now.\n    vec3 p = mix(position2D.xyz, position3D.xyz, time);\n    return vec4(p, 1.0);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/computePosition",[],function(){"use strict";return"/**\n * Returns a position in model coordinates relative to eye taking into\n * account the current scene mode: 3D, 2D, or Columbus view.\n * <p>\n * This uses standard position attributes, <code>position3DHigh</code>, \n * <code>position3DLow</code>, <code>position2DHigh</code>, and <code>position2DLow</code>, \n * and should be used when writing a vertex shader for an {@link Appearance}.\n * </p>\n *\n * @name czm_computePosition\n * @glslFunction\n *\n * @returns {vec4} The position relative to eye.\n *\n * @example\n * vec4 p = czm_computePosition();\n * v_positionEC = (czm_modelViewRelativeToEye * p).xyz;\n * gl_Position = czm_modelViewProjectionRelativeToEye * p;\n *\n * @see czm_translateRelativeToEye\n */\nvec4 czm_computePosition();\n"}),define("Cesium/Shaders/Builtin/Functions/cosineAndSine",[],function(){"use strict";return"/**\n * @private\n */\nvec2 cordic(float angle)\n{\n// Scale the vector by the appropriate factor for the 24 iterations to follow.\n    vec2 vector = vec2(6.0725293500888267e-1, 0.0);\n// Iteration 1\n    float sense = (angle < 0.0) ? -1.0 : 1.0;\n //   float factor = sense * 1.0;  // 2^-0\n    mat2 rotation = mat2(1.0, sense, -sense, 1.0);\n    vector = rotation * vector;\n    angle -= sense * 7.8539816339744828e-1;  // atan(2^-0)\n// Iteration 2\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    float factor = sense * 5.0e-1;  // 2^-1\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 4.6364760900080609e-1;  // atan(2^-1)\n// Iteration 3\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 2.5e-1;  // 2^-2\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 2.4497866312686414e-1;  // atan(2^-2)\n// Iteration 4\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.25e-1;  // 2^-3\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.2435499454676144e-1;  // atan(2^-3)\n// Iteration 5\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 6.25e-2;  // 2^-4\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 6.2418809995957350e-2;  // atan(2^-4)\n// Iteration 6\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 3.125e-2;  // 2^-5\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 3.1239833430268277e-2;  // atan(2^-5)\n// Iteration 7\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.5625e-2;  // 2^-6\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.5623728620476831e-2;  // atan(2^-6)\n// Iteration 8\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 7.8125e-3;  // 2^-7\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 7.8123410601011111e-3;  // atan(2^-7)\n// Iteration 9\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 3.90625e-3;  // 2^-8\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 3.9062301319669718e-3;  // atan(2^-8)\n// Iteration 10\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.953125e-3;  // 2^-9\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.9531225164788188e-3;  // atan(2^-9)\n// Iteration 11\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 9.765625e-4;  // 2^-10\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 9.7656218955931946e-4;  // atan(2^-10)\n// Iteration 12\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 4.8828125e-4;  // 2^-11\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 4.8828121119489829e-4;  // atan(2^-11)\n// Iteration 13\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 2.44140625e-4;  // 2^-12\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 2.4414062014936177e-4;  // atan(2^-12)\n// Iteration 14\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.220703125e-4;  // 2^-13\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.2207031189367021e-4;  // atan(2^-13)\n// Iteration 15\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 6.103515625e-5;  // 2^-14\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 6.1035156174208773e-5;  // atan(2^-14)\n// Iteration 16\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 3.0517578125e-5;  // 2^-15\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 3.0517578115526096e-5;  // atan(2^-15)\n// Iteration 17\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.52587890625e-5;  // 2^-16\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.5258789061315762e-5;  // atan(2^-16)\n// Iteration 18\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 7.62939453125e-6;  // 2^-17\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 7.6293945311019700e-6;  // atan(2^-17)\n// Iteration 19\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 3.814697265625e-6;  // 2^-18\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 3.8146972656064961e-6;  // atan(2^-18)\n// Iteration 20\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.9073486328125e-6;  // 2^-19\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 1.9073486328101870e-6;  // atan(2^-19)\n// Iteration 21\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 9.5367431640625e-7;  // 2^-20\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 9.5367431640596084e-7;  // atan(2^-20)\n// Iteration 22\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 4.76837158203125e-7;  // 2^-21\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 4.7683715820308884e-7;  // atan(2^-21)\n// Iteration 23\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 2.384185791015625e-7;  // 2^-22\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n    angle -= sense * 2.3841857910155797e-7;  // atan(2^-22)\n// Iteration 24\n    sense = (angle < 0.0) ? -1.0 : 1.0;\n    factor = sense * 1.1920928955078125e-7;  // 2^-23\n    rotation[0][1] = factor;\n    rotation[1][0] = -factor;\n    vector = rotation * vector;\n//    angle -= sense * 1.1920928955078068e-7;  // atan(2^-23)\n\n    return vector;\n}\n\n/**\n * Computes the cosine and sine of the provided angle using the CORDIC algorithm.\n *\n * @name czm_cosineAndSine\n * @glslFunction\n *\n * @param {float} angle The angle in radians.\n *\n * @returns {vec2} The resulting cosine of the angle (as the x coordinate) and sine of the angle (as the y coordinate).\n *\n * @example\n * vec2 v = czm_cosineAndSine(czm_piOverSix);\n * float cosine = v.x;\n * float sine = v.y;\n */\nvec2 czm_cosineAndSine(float angle)\n{\n    if (angle < -czm_piOverTwo || angle > czm_piOverTwo)\n    {\n        if (angle < 0.0)\n        {\n            return -cordic(angle + czm_pi);\n        }\n        else\n        {\n            return -cordic(angle - czm_pi);\n        }\n    }\n    else\n    {\n        return cordic(angle);\n    }\n}"}),define("Cesium/Shaders/Builtin/Functions/decompressTextureCoordinates",[],function(){"use strict";return"/**\n * Decompresses texture coordinates that were packed into a single float.\n *\n * @name czm_decompressTextureCoordinates\n * @glslFunction\n *\n * @param {float} encoded The compressed texture coordinates.\n * @returns {vec2} The decompressed texture coordinates.\n */\n vec2 czm_decompressTextureCoordinates(float encoded)\n {\n    float temp = encoded / 4096.0;\n    float stx = floor(temp) / 4096.0;\n    float sty = temp - floor(temp);\n    return vec2(stx, sty);\n }\n"}),define("Cesium/Shaders/Builtin/Functions/eastNorthUpToEyeCoordinates",[],function(){"use strict";return"/**\n * Computes a 3x3 rotation matrix that transforms vectors from an ellipsoid's east-north-up coordinate system \n * to eye coordinates.  In east-north-up coordinates, x points east, y points north, and z points along the \n * surface normal.  East-north-up can be used as an ellipsoid's tangent space for operations such as bump mapping.\n * <br /><br />\n * The ellipsoid is assumed to be centered at the model coordinate's origin.\n *\n * @name czm_eastNorthUpToEyeCoordinates\n * @glslFunction\n *\n * @param {vec3} positionMC The position on the ellipsoid in model coordinates.\n * @param {vec3} normalEC The normalized ellipsoid surface normal, at <code>positionMC</code>, in eye coordinates.\n *\n * @returns {mat3} A 3x3 rotation matrix that transforms vectors from the east-north-up coordinate system to eye coordinates.\n *\n * @example\n * // Transform a vector defined in the east-north-up coordinate \n * // system, (0, 0, 1) which is the surface normal, to eye \n * // coordinates.\n * mat3 m = czm_eastNorthUpToEyeCoordinates(positionMC, normalEC);\n * vec3 normalEC = m * vec3(0.0, 0.0, 1.0);\n */\nmat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\n    vec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));  // normalized surface tangent in model coordinates\n    vec3 tangentEC = normalize(czm_normal3D * tangentMC);                // normalized surface tangent in eye coordiantes\n    vec3 bitangentEC = normalize(cross(normalEC, tangentEC));            // normalized surface bitangent in eye coordinates\n\n    return mat3(\n        tangentEC.x,   tangentEC.y,   tangentEC.z,\n        bitangentEC.x, bitangentEC.y, bitangentEC.z,\n        normalEC.x,    normalEC.y,    normalEC.z);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/ellipsoidContainsPoint",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_ellipsoidContainsPoint\n * @glslFunction\n *\n */\nbool czm_ellipsoidContainsPoint(czm_ellipsoid ellipsoid, vec3 point)\n{\n    vec3 scaled = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\n    return (dot(scaled, scaled) <= 1.0);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/ellipsoidNew",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_ellipsoidNew\n * @glslFunction\n *\n */\nczm_ellipsoid czm_ellipsoidNew(vec3 center, vec3 radii)\n{\n    vec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\n    vec3 inverseRadiiSquared = inverseRadii * inverseRadii;\n    czm_ellipsoid temp = czm_ellipsoid(center, radii, inverseRadii, inverseRadiiSquared);\n    return temp;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/ellipsoidWgs84TextureCoordinates",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_ellipsoidWgs84TextureCoordinates\n * @glslFunction\n */\nvec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\n    return vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/equalsEpsilon",[],function(){"use strict";return"/**\n * Compares <code>left</code> and <code>right</code> componentwise. Returns <code>true</code>\n * if they are within <code>epsilon</code> and <code>false</code> otherwise. The inputs\n * <code>left</code> and <code>right</code> can be <code>float</code>s, <code>vec2</code>s,\n * <code>vec3</code>s, or <code>vec4</code>s.\n *\n * @name czm_equalsEpsilon\n * @glslFunction\n *\n * @param {} left The first vector.\n * @param {} right The second vector.\n * @param {float} epsilon The epsilon to use for equality testing.\n * @returns {bool} <code>true</code> if the components are within <code>epsilon</code> and <code>false</code> otherwise.\n *\n * @example\n * // GLSL declarations\n * bool czm_equalsEpsilon(float left, float right, float epsilon);\n * bool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon);\n * bool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon);\n * bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon);\n */\nbool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\n    return all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\n\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\n    return all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\n\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\n    return all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\n\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\n    return (abs(left - right) <= epsilon);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/eyeOffset",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_eyeOffset\n * @glslFunction\n *\n * @param {vec4} positionEC DOC_TBA.\n * @param {vec3} eyeOffset DOC_TBA.\n *\n * @returns {vec4} DOC_TBA.\n */\nvec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\n    // This equation is approximate in x and y.\n    vec4 p = positionEC;\n    vec4 zEyeOffset = normalize(p) * eyeOffset.z;\n    p.xy += eyeOffset.xy + zEyeOffset.xy;\n    p.z += zEyeOffset.z;\n    return p;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/eyeToWindowCoordinates",[],function(){"use strict";return"/**\n * Transforms a position from eye to window coordinates.  The transformation\n * from eye to clip coordinates is done using {@link czm_projection}.\n * The transform from normalized device coordinates to window coordinates is\n * done using {@link czm_viewportTransformation}, which assumes a depth range\n * of <code>near = 0</code> and <code>far = 1</code>.\n * <br /><br />\n * This transform is useful when there is a need to manipulate window coordinates\n * in a vertex shader as done by {@link BillboardCollection}.\n *\n * @name czm_eyeToWindowCoordinates\n * @glslFunction\n *\n * @param {vec4} position The position in eye coordinates to transform.\n *\n * @returns {vec4} The transformed position in window coordinates.\n *\n * @see czm_modelToWindowCoordinates\n * @see czm_projection\n * @see czm_viewportTransformation\n * @see BillboardCollection\n *\n * @example\n * vec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\n */\nvec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\n    vec4 q = czm_projection * positionEC;                        // clip coordinates\n    q.xyz /= q.w;                                                // normalized device coordinates\n    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates\n    return q;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/geodeticSurfaceNormal",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_geodeticSurfaceNormal\n * @glslFunction\n *\n * @param {vec3} positionOnEllipsoid DOC_TBA\n * @param {vec3} ellipsoidCenter DOC_TBA\n * @param {vec3} oneOverEllipsoidRadiiSquared DOC_TBA\n * \n * @returns {vec3} DOC_TBA.\n */\nvec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\n    return normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/getDefaultMaterial",[],function(){"use strict";return"/**\n * An czm_material with default values. Every material's czm_getMaterial\n * should use this default material as a base for the material it returns.\n * The default normal value is given by materialInput.normalEC.\n *\n * @name czm_getDefaultMaterial\n * @glslFunction \n *\n * @param {czm_materialInput} input The input used to construct the default material.\n * \n * @returns {czm_material} The default material.\n *\n * @see czm_materialInput\n * @see czm_material\n * @see czm_getMaterial\n */\nczm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\n    czm_material material;\n    material.diffuse = vec3(0.0);\n    material.specular = 0.0;\n    material.shininess = 1.0;\n    material.normal = materialInput.normalEC;\n    material.emission = vec3(0.0);\n    material.alpha = 1.0;\n    return material;\n}\n"
}),define("Cesium/Shaders/Builtin/Functions/getLambertDiffuse",[],function(){"use strict";return"/**\n * Calculates the intensity of diffusely reflected light.\n *\n * @name czm_getLambertDiffuse\n * @glslFunction\n *\n * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.\n * @param {vec3} normalEC The surface normal in eye coordinates.\n *\n * @returns {float} The intensity of the diffuse reflection.\n *\n * @see czm_phong\n *\n * @example\n * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);\n * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);\n * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);\n */\nfloat czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\n    return max(dot(lightDirectionEC, normalEC), 0.0);\n}"}),define("Cesium/Shaders/Builtin/Functions/getSpecular",[],function(){"use strict";return"/**\n * Calculates the specular intensity of reflected light.\n *\n * @name czm_getSpecular\n * @glslFunction\n *\n * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.\n * @param {vec3} toEyeEC Unit vector pointing to the eye position in eye coordinates.\n * @param {vec3} normalEC The surface normal in eye coordinates.\n * @param {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.\n *\n * @returns {float} The intensity of the specular highlight.\n *\n * @see czm_phong\n *\n * @example\n * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);\n * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);\n * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);\n */\nfloat czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\n    vec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\n    float specular = max(dot(toReflectedLight, toEyeEC), 0.0);\n    return pow(specular, shininess);\n}"}),define("Cesium/Shaders/Builtin/Functions/getWaterNoise",[],function(){"use strict";return"/**\n * @private\n */\nvec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\n    float cosAngle = cos(angleInRadians);\n    float sinAngle = sin(angleInRadians);\n\n    // time dependent sampling directions\n    vec2 s0 = vec2(1.0/17.0, 0.0);\n    vec2 s1 = vec2(-1.0/29.0, 0.0);\n    vec2 s2 = vec2(1.0/101.0, 1.0/59.0);\n    vec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\n\n    // rotate sampling direction by specified angle\n    s0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\n    s1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\n    s2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\n    s3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\n\n    vec2 uv0 = (uv/103.0) + (time * s0);\n    vec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\n    vec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\n    vec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\n\n    uv0 = fract(uv0);\n    uv1 = fract(uv1);\n    uv2 = fract(uv2);\n    uv3 = fract(uv3);\n    vec4 noise = (texture2D(normalMap, uv0)) +\n                 (texture2D(normalMap, uv1)) +\n                 (texture2D(normalMap, uv2)) +\n                 (texture2D(normalMap, uv3));\n\n    // average and scale to between -1 and 1\n    return ((noise / 4.0) - 0.5) * 2.0;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/getWgs84EllipsoidEC",[],function(){"use strict";return"/**\n * Returns the WGS84 ellipsoid, with its center at the origin of world coordinates, in eye coordinates.\n *\n * @name czm_getWgs84EllipsoidEC\n * @glslFunction\n *\n * @returns {czm_ellipsoid} The WGS84 ellipsoid, with its center at the origin of world coordinates, in eye coordinates.\n *\n * @see Ellipsoid.WGS84\n *\n * @example\n * czm_ellipsoid ellipsoid = czm_getWgs84EllipsoidEC();\n */\nczm_ellipsoid czm_getWgs84EllipsoidEC()\n{\n    vec3 radii = vec3(6378137.0, 6378137.0, 6356752.314245);\n    vec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\n    vec3 inverseRadiiSquared = inverseRadii * inverseRadii;\n    czm_ellipsoid temp = czm_ellipsoid(czm_view[3].xyz, radii, inverseRadii, inverseRadiiSquared);\n    return temp;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/hue",[],function(){"use strict";return"/**\n * Adjusts the hue of a color.\n * \n * @name czm_hue\n * @glslFunction\n * \n * @param {vec3} rgb The color.\n * @param {float} adjustment The amount to adjust the hue of the color in radians.\n *\n * @returns {float} The color with the hue adjusted.\n *\n * @example\n * vec3 adjustHue = czm_hue(color, czm_pi); // The same as czm_hue(color, -czm_pi)\n */\nvec3 czm_hue(vec3 rgb, float adjustment)\n{\n    const mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n                            0.595716, -0.274453, -0.321263,\n                            0.211456, -0.522591,  0.311135);\n    const mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n                            1.0, -0.2721, -0.6474,\n                            1.0, -1.107,   1.7046);\n    \n    vec3 yiq = toYIQ * rgb;\n    float hue = atan(yiq.z, yiq.y) + adjustment;\n    float chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\n    \n    vec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\n    return toRGB * color;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/isEmpty",[],function(){"use strict";return"/**\n * Determines if a time interval is empty.\n *\n * @name czm_isEmpty\n * @glslFunction \n * \n * @param {czm_raySegment} interval The interval to test.\n * \n * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.\n *\n * @example\n * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true\n * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false\n * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.\n */\nbool czm_isEmpty(czm_raySegment interval)\n{\n    return (interval.stop < 0.0);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/isFull",[],function(){"use strict";return"/**\n * Determines if a time interval is empty.\n *\n * @name czm_isFull\n * @glslFunction \n * \n * @param {czm_raySegment} interval The interval to test.\n * \n * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.\n *\n * @example\n * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true\n * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false\n * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.\n */\nbool czm_isFull(czm_raySegment interval)\n{\n    return (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/latitudeToWebMercatorFraction",[],function(){"use strict";return"/**\n * Computes the fraction of a Web Wercator rectangle at which a given geodetic latitude is located.\n *\n * @name czm_latitudeToWebMercatorFraction\n * @glslFunction\n *\n * @param {float} latitude The geodetic latitude, in radians.\n * @param {float} southMercatorYLow The low portion of the Web Mercator coordinate of the southern boundary of the rectangle.\n * @param {float} southMercatorYHigh The high portion of the Web Mercator coordinate of the southern boundary of the rectangle.\n * @param {float} oneOverMercatorHeight The total height of the rectangle in Web Mercator coordinates.\n *\n * @returns {float} The fraction of the rectangle at which the latitude occurs.  If the latitude is the southern\n *          boundary of the rectangle, the return value will be zero.  If it is the northern boundary, the return\n *          value will be 1.0.  Latitudes in between are mapped according to the Web Mercator projection.\n */ \nfloat czm_latitudeToWebMercatorFraction(float latitude, float southMercatorYLow, float southMercatorYHigh, float oneOverMercatorHeight)\n{\n    float sinLatitude = sin(latitude);\n    float mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\n    \n    // mercatorY - southMercatorY in simulated double precision.\n    float t1 = 0.0 - southMercatorYLow;\n    float e = t1 - 0.0;\n    float t2 = ((-southMercatorYLow - e) + (0.0 - (t1 - e))) + mercatorY - southMercatorYHigh;\n    float highDifference = t1 + t2;\n    float lowDifference = t2 - (highDifference - t1);\n    \n    return highDifference * oneOverMercatorHeight + lowDifference * oneOverMercatorHeight;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/luminance",[],function(){"use strict";return"/**\n * Computes the luminance of a color. \n *\n * @name czm_luminance\n * @glslFunction\n *\n * @param {vec3} rgb The color.\n * \n * @returns {float} The luminance.\n *\n * @example\n * float light = czm_luminance(vec3(0.0)); // 0.0\n * float dark = czm_luminance(vec3(1.0));  // ~1.0 \n */\nfloat czm_luminance(vec3 rgb)\n{\n    // Algorithm from Chapter 10 of Graphics Shaders.\n    const vec3 W = vec3(0.2125, 0.7154, 0.0721);\n    return dot(rgb, W);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/modelToWindowCoordinates",[],function(){"use strict";return"/**\n * Transforms a position from model to window coordinates.  The transformation\n * from model to clip coordinates is done using {@link czm_modelViewProjection}.\n * The transform from normalized device coordinates to window coordinates is\n * done using {@link czm_viewportTransformation}, which assumes a depth range\n * of <code>near = 0</code> and <code>far = 1</code>.\n * <br /><br />\n * This transform is useful when there is a need to manipulate window coordinates\n * in a vertex shader as done by {@link BillboardCollection}.\n * <br /><br />\n * This function should not be confused with {@link czm_viewportOrthographic},\n * which is an orthographic projection matrix that transforms from window \n * coordinates to clip coordinates.\n *\n * @name czm_modelToWindowCoordinates\n * @glslFunction\n *\n * @param {vec4} position The position in model coordinates to transform.\n *\n * @returns {vec4} The transformed position in window coordinates.\n *\n * @see czm_eyeToWindowCoordinates\n * @see czm_modelViewProjection\n * @see czm_viewportTransformation\n * @see czm_viewportOrthographic\n * @see BillboardCollection\n *\n * @example\n * vec4 positionWC = czm_modelToWindowCoordinates(positionMC);\n */\nvec4 czm_modelToWindowCoordinates(vec4 position)\n{\n    vec4 q = czm_modelViewProjection * position;                // clip coordinates\n    q.xyz /= q.w;                                                // normalized device coordinates\n    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates\n    return q;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/multiplyWithColorBalance",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_multiplyWithColorBalance\n * @glslFunction\n */\nvec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\n    // Algorithm from Chapter 10 of Graphics Shaders.\n    const vec3 W = vec3(0.2125, 0.7154, 0.0721);\n    \n    vec3 target = left * right;\n    float leftLuminance = dot(left, W);\n    float rightLuminance = dot(right, W);\n    float targetLuminance = dot(target, W);\n    \n    return ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n"}),define("Cesium/Shaders/Builtin/Functions/octDecode",[],function(){"use strict";return"/**\n * Decodes a unit-length vector in 'oct' encoding to a normalized 3-component Cartesian vector.\n * The 'oct' encoding is described in \"A Survey of Efficient Representations of Independent Unit Vectors\",\n * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/\n * \n * @name czm_octDecode\n * @param {vec2} encoded The oct-encoded, unit-length vector\n * @returns {vec3} The decoded and normalized vector\n */\n vec3 czm_octDecode(vec2 encoded)\n {\n    encoded = encoded / 255.0 * 2.0 - 1.0;\n    vec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));\n    if (v.z < 0.0)\n    {\n        v.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);\n    }\n    \n    return normalize(v);\n }\n\n /**\n * Decodes a unit-length vector in 'oct' encoding packed into a floating-point number to a normalized 3-component Cartesian vector.\n * The 'oct' encoding is described in \"A Survey of Efficient Representations of Independent Unit Vectors\",\n * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/\n * \n * @name czm_octDecode\n * @param {float} encoded The oct-encoded, unit-length vector\n * @returns {vec3} The decoded and normalized vector\n */\n vec3 czm_octDecode(float encoded)\n {\n    float temp = encoded / 256.0;\n    float x = floor(temp);\n    float y = (temp - x) * 256.0;\n    return czm_octDecode(vec2(x, y));\n }\n \n/**\n * Decodes three unit-length vectors in 'oct' encoding packed into two floating-point numbers to normalized 3-component Cartesian vectors.\n * The 'oct' encoding is described in \"A Survey of Efficient Representations of Independent Unit Vectors\",\n * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/\n * \n * @name czm_octDecode\n * @param {vec2} encoded The packed oct-encoded, unit-length vectors.\n * @param {vec3} vector1 One decoded and normalized vector.\n * @param {vec3} vector2 One decoded and normalized vector.\n * @param {vec3} vector3 One decoded and normalized vector.\n */\n  void czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)\n {\n    float temp = encoded.x / 65536.0;\n    float x = floor(temp);\n    float encodedFloat1 = (temp - x) * 65536.0;\n\n    temp = encoded.y / 65536.0;\n    float y = floor(temp);\n    float encodedFloat2 = (temp - y) * 65536.0;\n\n    vector1 = czm_octDecode(encodedFloat1);\n    vector2 = czm_octDecode(encodedFloat2);\n    vector3 = czm_octDecode(vec2(x, y));\n }\n "}),define("Cesium/Shaders/Builtin/Functions/phong",[],function(){"use strict";return"float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\n    return czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\n\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\n    return czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\n\n/**\n * Computes a color using the Phong lighting model.\n *\n * @name czm_phong\n * @glslFunction\n *\n * @param {vec3} toEye A normalized vector from the fragment to the eye in eye coordinates.\n * @param {czm_material} material The fragment's material.\n * \n * @returns {vec4} The computed color.\n * \n * @example\n * vec3 positionToEyeEC = // ...\n * czm_material material = // ...\n * gl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n *\n * @see czm_getMaterial\n */\nvec4 czm_phong(vec3 toEye, czm_material material)\n{\n    // Diffuse from directional light sources at eye (for top-down)\n    float diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);\n    if (czm_sceneMode == czm_sceneMode3D) {\n        // (and horizon views in 3D)\n        diffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\n    }\n\n    // Specular from sun and pseudo-moon\n    float specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material) + czm_private_getSpecularOfMaterial(czm_moonDirectionEC, toEye, material);\n\n    // Temporary workaround for adding ambient.\n    vec3 materialDiffuse = material.diffuse * 0.5;\n    \n    vec3 ambient = materialDiffuse;\n    vec3 color = ambient + material.emission;\n    color += materialDiffuse * diffuse;\n    color += material.specular * specular;\n\n    return vec4(color, material.alpha);\n}\n\nvec4 czm_private_phong(vec3 toEye, czm_material material)\n{\n    float diffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\n    float specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material);\n\n    vec3 ambient = vec3(0.0);\n    vec3 color = ambient + material.emission;\n    color += material.diffuse * diffuse;\n    color += material.specular * specular;\n\n    return vec4(color, material.alpha);\n}"}),define("Cesium/Shaders/Builtin/Functions/pointAlongRay",[],function(){"use strict";return"/**\n * Computes the point along a ray at the given time.  <code>time</code> can be positive, negative, or zero.\n *\n * @name czm_pointAlongRay\n * @glslFunction\n *\n * @param {czm_ray} ray The ray to compute the point along.\n * @param {float} time The time along the ray.\n * \n * @returns {vec3} The point along the ray at the given time.\n * \n * @example\n * czm_ray ray = czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)); // origin, direction\n * vec3 v = czm_pointAlongRay(ray, 2.0); // (2.0, 0.0, 0.0)\n */\nvec3 czm_pointAlongRay(czm_ray ray, float time)\n{\n    return ray.origin + (time * ray.direction);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/rayEllipsoidIntersectionInterval",[],function(){"use strict";return"/**\n * DOC_TBA\n *\n * @name czm_rayEllipsoidIntersectionInterval\n * @glslFunction\n */\nczm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, czm_ellipsoid ellipsoid)\n{\n   // ray and ellipsoid center in eye coordinates.  radii in model coordinates.\n    vec3 q = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\n    vec3 w = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\n   \n    q = q - ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ellipsoid.center, 1.0)).xyz;\n    \n    float q2 = dot(q, q);\n    float qw = dot(q, w);\n    \n    if (q2 > 1.0) // Outside ellipsoid.\n    {\n        if (qw >= 0.0) // Looking outward or tangent (0 intersections).\n        {\n            return czm_emptyRaySegment;\n        }\n        else // qw < 0.0.\n        {\n            float qw2 = qw * qw;\n            float difference = q2 - 1.0; // Positively valued.\n            float w2 = dot(w, w);\n            float product = w2 * difference;\n            \n            if (qw2 < product) // Imaginary roots (0 intersections).\n            {\n                return czm_emptyRaySegment;     \n            }   \n            else if (qw2 > product) // Distinct roots (2 intersections).\n            {\n                float discriminant = qw * qw - product;\n                float temp = -qw + sqrt(discriminant); // Avoid cancellation.\n                float root0 = temp / w2;\n                float root1 = difference / temp;\n                if (root0 < root1)\n                {\n                    czm_raySegment i = czm_raySegment(root0, root1);\n                    return i;\n                }\n                else\n                {\n                    czm_raySegment i = czm_raySegment(root1, root0);\n                    return i;\n                }\n            }\n            else // qw2 == product.  Repeated roots (2 intersections).\n            {\n                float root = sqrt(difference / w2);\n                czm_raySegment i = czm_raySegment(root, root);\n                return i;\n            }\n        }\n    }\n    else if (q2 < 1.0) // Inside ellipsoid (2 intersections).\n    {\n        float difference = q2 - 1.0; // Negatively valued.\n        float w2 = dot(w, w);\n        float product = w2 * difference; // Negatively valued.\n        float discriminant = qw * qw - product;\n        float temp = -qw + sqrt(discriminant); // Positively valued.\n        czm_raySegment i = czm_raySegment(0.0, temp / w2);\n        return i;\n    }\n    else // q2 == 1.0. On ellipsoid.\n    {\n        if (qw < 0.0) // Looking inward.\n        {\n            float w2 = dot(w, w);\n            czm_raySegment i = czm_raySegment(0.0, -qw / w2);\n            return i;\n        }\n        else // qw >= 0.0.  Looking outward or tangent.\n        {\n            return czm_emptyRaySegment;\n        }\n    }\n}\n"}),define("Cesium/Shaders/Builtin/Functions/saturation",[],function(){"use strict";return"/**\n * Adjusts the saturation of a color.\n * \n * @name czm_saturation\n * @glslFunction\n * \n * @param {vec3} rgb The color.\n * @param {float} adjustment The amount to adjust the saturation of the color.\n *\n * @returns {float} The color with the saturation adjusted.\n *\n * @example\n * vec3 greyScale = czm_saturation(color, 0.0);\n * vec3 doubleSaturation = czm_saturation(color, 2.0);\n */\nvec3 czm_saturation(vec3 rgb, float adjustment)\n{\n    // Algorithm from Chapter 16 of OpenGL Shading Language\n    const vec3 W = vec3(0.2125, 0.7154, 0.0721);\n    vec3 intensity = vec3(dot(rgb, W));\n    return mix(intensity, rgb, adjustment);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/signNotZero",[],function(){"use strict";return"/**\n * Returns 1.0 if the given value is positive or zero, and -1.0 if it is negative.  This is similar to the GLSL\n * built-in function <code>sign</code> except that returns 1.0 instead of 0.0 when the input value is 0.0.\n * \n * @name czm_signNotZero\n * @glslFunction\n *\n * @param {} value The value for which to determine the sign.\n * @returns {} 1.0 if the value is positive or zero, -1.0 if the value is negative.\n */\nfloat czm_signNotZero(float value)\n{\n    return value >= 0.0 ? 1.0 : -1.0;\n}\n\nvec2 czm_signNotZero(vec2 value)\n{\n    return vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));\n}\n\nvec3 czm_signNotZero(vec3 value)\n{\n    return vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));\n}\n\nvec4 czm_signNotZero(vec4 value)\n{\n    return vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));\n}"}),define("Cesium/Shaders/Builtin/Functions/tangentToEyeSpaceMatrix",[],function(){"use strict";return"/**\n * Creates a matrix that transforms vectors from tangent space to eye space.\n *\n * @name czm_tangentToEyeSpaceMatrix\n * @glslFunction\n * \n * @param {vec3} normalEC The normal vector in eye coordinates.\n * @param {vec3} tangentEC The tangent vector in eye coordinates.\n * @param {vec3} binormalEC The binormal vector in eye coordinates.\n *\n * @returns {mat3} The matrix that transforms from tangent space to eye space.\n *\n * @example\n * mat3 tangentToEye = czm_tangentToEyeSpaceMatrix(normalEC, tangentEC, binormalEC);\n * vec3 normal = tangentToEye * texture2D(normalMap, st).xyz;\n */\nmat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 binormalEC)\n{\n    vec3 normal = normalize(normalEC);\n    vec3 tangent = normalize(tangentEC);\n    vec3 binormal = normalize(binormalEC);\n    return mat3(tangent.x,  tangent.y,  tangent.z,\n                binormal.x, binormal.y, binormal.z,\n                normal.x,   normal.y,   normal.z);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/translateRelativeToEye",[],function(){"use strict";return"/**\n * Translates a position (or any <code>vec3</code>) that was encoded with {@link EncodedCartesian3},\n * and then provided to the shader as separate <code>high</code> and <code>low</code> bits to\n * be relative to the eye.  As shown in the example, the position can then be transformed in eye\n * or clip coordinates using {@link czm_modelViewRelativeToEye} or {@link czm_modelViewProjectionRelativeToEye},\n * respectively.\n * <p>\n * This technique, called GPU RTE, eliminates jittering artifacts when using large coordinates as\n * described in {@link http://blogs.agi.com/insight3d/index.php/2008/09/03/precisions-precisions/|Precisions, Precisions}.\n * </p>\n *\n * @name czm_translateRelativeToEye\n * @glslFunction\n *\n * @param {vec3} high The position's high bits.\n * @param {vec3} low The position's low bits.\n * @returns {vec3} The position translated to be relative to the camera's position.\n *\n * @example\n * attribute vec3 positionHigh;\n * attribute vec3 positionLow;\n * \n * void main() \n * {\n *   vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\n *   gl_Position = czm_modelViewProjectionRelativeToEye * p;\n * }\n *\n * @see czm_modelViewRelativeToEye\n * @see czm_modelViewProjectionRelativeToEye\n * @see czm_computePosition\n * @see EncodedCartesian3\n */\nvec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\n    vec3 highDifference = high - czm_encodedCameraPositionMCHigh;\n    vec3 lowDifference = low - czm_encodedCameraPositionMCLow;\n\n    return vec4(highDifference + lowDifference, 1.0);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/translucentPhong",[],function(){"use strict";return"/**\n * @private\n */\nvec4 czm_translucentPhong(vec3 toEye, czm_material material)\n{\n    // Diffuse from directional light sources at eye (for top-down and horizon views)\n    float diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);\n    diffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);\n    diffuse = clamp(diffuse, 0.0, 1.0);\n\n    // Specular from sun and pseudo-moon\n    float specular = czm_getSpecular(czm_sunDirectionEC, toEye, material.normal, material.shininess);\n    specular += czm_getSpecular(czm_moonDirectionEC, toEye, material.normal, material.shininess);\n\n    // Temporary workaround for adding ambient.\n    vec3 materialDiffuse = material.diffuse * 0.5;\n\n    vec3 ambient = materialDiffuse;\n    vec3 color = ambient + material.emission;\n    color += materialDiffuse * diffuse;\n    color += material.specular * specular;\n\n    return vec4(color, material.alpha);\n}"}),define("Cesium/Shaders/Builtin/Functions/transpose",[],function(){"use strict";return"/**\n * Returns the transpose of the matrix.  The input <code>matrix</code> can be \n * a <code>mat2</code>, <code>mat3</code>, or <code>mat4</code>.\n *\n * @name czm_transpose\n * @glslFunction\n *\n * @param {} matrix The matrix to transpose.\n *\n * @returns {} The transposed matrix.\n *\n * @example\n * // GLSL declarations\n * mat2 czm_transpose(mat2 matrix);\n * mat3 czm_transpose(mat3 matrix);\n * mat4 czm_transpose(mat4 matrix);\n *\n * // Tranpose a 3x3 rotation matrix to find its inverse.\n * mat3 eastNorthUpToEye = czm_eastNorthUpToEyeCoordinates(\n *     positionMC, normalEC);\n * mat3 eyeToEastNorthUp = czm_transpose(eastNorthUpToEye);\n */\nmat2 czm_transpose(mat2 matrix)\n{\n    return mat2(\n        matrix[0][0], matrix[1][0],\n        matrix[0][1], matrix[1][1]);\n}\n\nmat3 czm_transpose(mat3 matrix)\n{\n    return mat3(\n        matrix[0][0], matrix[1][0], matrix[2][0],\n        matrix[0][1], matrix[1][1], matrix[2][1],\n        matrix[0][2], matrix[1][2], matrix[2][2]);\n}\n\nmat4 czm_transpose(mat4 matrix)\n{\n    return mat4(\n        matrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\n        matrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\n        matrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\n        matrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n"}),define("Cesium/Shaders/Builtin/Functions/windowToEyeCoordinates",[],function(){"use strict";return"/**\n * Transforms a position from window to eye coordinates.\n * The transform from window to normalized device coordinates is done using components\n * of (@link czm_viewport} and {@link czm_viewportTransformation} instead of calculating\n * the inverse of <code>czm_viewportTransformation</code>. The transformation from \n * normalized device coordinates to clip coordinates is done using <code>positionWC.w</code>,\n * which is expected to be the scalar used in the perspective divide. The transformation\n * from clip to eye coordinates is done using {@link czm_inverseProjection}.\n *\n * @name czm_windowToEyeCoordinates\n * @glslFunction\n *\n * @param {vec4} fragmentCoordinate The position in window coordinates to transform.\n *\n * @returns {vec4} The transformed position in eye coordinates.\n *\n * @see czm_modelToWindowCoordinates\n * @see czm_eyeToWindowCoordinates\n * @see czm_inverseProjection\n * @see czm_viewport\n * @see czm_viewportTransformation\n *\n * @example\n * vec4 positionEC = czm_windowToEyeCoordinates(gl_FragCoord);\n */\nvec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\n    float x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\n    float y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\n    float z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\n    vec4 q = vec4(x, y, z, 1.0);\n    q /= fragmentCoordinate.w;\n    q = czm_inverseProjection * q;\n    return q;\n}\n"}),define("Cesium/Shaders/Builtin/CzmBuiltins",["./Constants/degreesPerRadian","./Constants/depthRange","./Constants/epsilon1","./Constants/epsilon2","./Constants/epsilon3","./Constants/epsilon4","./Constants/epsilon5","./Constants/epsilon6","./Constants/epsilon7","./Constants/infinity","./Constants/oneOverPi","./Constants/oneOverTwoPi","./Constants/pi","./Constants/piOverFour","./Constants/piOverSix","./Constants/piOverThree","./Constants/piOverTwo","./Constants/radiansPerDegree","./Constants/sceneMode2D","./Constants/sceneMode3D","./Constants/sceneModeColumbusView","./Constants/sceneModeMorphing","./Constants/solarRadius","./Constants/threePiOver2","./Constants/twoPi","./Constants/webMercatorMaxLatitude","./Structs/depthRangeStruct","./Structs/ellipsoid","./Structs/material","./Structs/materialInput","./Structs/ray","./Structs/raySegment","./Functions/RGBToXYZ","./Functions/XYZToRGB","./Functions/alphaWeight","./Functions/antialias","./Functions/columbusViewMorph","./Functions/computePosition","./Functions/cosineAndSine","./Functions/decompressTextureCoordinates","./Functions/eastNorthUpToEyeCoordinates","./Functions/ellipsoidContainsPoint","./Functions/ellipsoidNew","./Functions/ellipsoidWgs84TextureCoordinates","./Functions/equalsEpsilon","./Functions/eyeOffset","./Functions/eyeToWindowCoordinates","./Functions/geodeticSurfaceNormal","./Functions/getDefaultMaterial","./Functions/getLambertDiffuse","./Functions/getSpecular","./Functions/getWaterNoise","./Functions/getWgs84EllipsoidEC","./Functions/hue","./Functions/isEmpty","./Functions/isFull","./Functions/latitudeToWebMercatorFraction","./Functions/luminance","./Functions/modelToWindowCoordinates","./Functions/multiplyWithColorBalance","./Functions/octDecode","./Functions/phong","./Functions/pointAlongRay","./Functions/rayEllipsoidIntersectionInterval","./Functions/saturation","./Functions/signNotZero","./Functions/tangentToEyeSpaceMatrix","./Functions/translateRelativeToEye","./Functions/translucentPhong","./Functions/transpose","./Functions/windowToEyeCoordinates"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M,I,D,O,R,L,N,z,F,B,V,k,U,W,G,H,q,j,Y,X,Z,J,K,Q,$,et,tt,it,nt,rt,ot,at,st,lt,ut,ct,dt,ht,mt,pt,ft,vt){"use strict";return{czm_degreesPerRadian:e,czm_depthRange:t,czm_epsilon1:i,czm_epsilon2:n,czm_epsilon3:r,czm_epsilon4:o,czm_epsilon5:a,czm_epsilon6:s,czm_epsilon7:l,czm_infinity:u,czm_oneOverPi:c,czm_oneOverTwoPi:d,czm_pi:h,czm_piOverFour:m,czm_piOverSix:p,czm_piOverThree:f,czm_piOverTwo:v,czm_radiansPerDegree:g,czm_sceneMode2D:_,czm_sceneMode3D:y,czm_sceneModeColumbusView:C,czm_sceneModeMorphing:w,czm_solarRadius:E,czm_threePiOver2:b,czm_twoPi:S,czm_webMercatorMaxLatitude:x,czm_depthRangeStruct:T,czm_ellipsoid:P,czm_material:A,czm_materialInput:M,czm_ray:I,czm_raySegment:D,czm_RGBToXYZ:O,czm_XYZToRGB:R,czm_alphaWeight:L,czm_antialias:N,czm_columbusViewMorph:z,czm_computePosition:F,czm_cosineAndSine:B,czm_decompressTextureCoordinates:V,czm_eastNorthUpToEyeCoordinates:k,czm_ellipsoidContainsPoint:U,czm_ellipsoidNew:W,czm_ellipsoidWgs84TextureCoordinates:G,czm_equalsEpsilon:H,czm_eyeOffset:q,czm_eyeToWindowCoordinates:j,czm_geodeticSurfaceNormal:Y,czm_getDefaultMaterial:X,czm_getLambertDiffuse:Z,czm_getSpecular:J,czm_getWaterNoise:K,czm_getWgs84EllipsoidEC:Q,czm_hue:$,czm_isEmpty:et,czm_isFull:tt,czm_latitudeToWebMercatorFraction:it,czm_luminance:nt,czm_modelToWindowCoordinates:rt,czm_multiplyWithColorBalance:ot,czm_octDecode:at,czm_phong:st,czm_pointAlongRay:lt,czm_rayEllipsoidIntersectionInterval:ut,czm_saturation:ct,czm_signNotZero:dt,czm_tangentToEyeSpaceMatrix:ht,czm_translateRelativeToEye:mt,czm_translucentPhong:pt,czm_transpose:ft,czm_windowToEyeCoordinates:vt}
}),define("Cesium/Renderer/AutomaticUniforms",["../Core/Cartesian3","../Core/Matrix4"],function(e,t){"use strict";var i=new e,n=function(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue};if("undefined"==typeof WebGLRenderingContext)return{};var r={};r[WebGLRenderingContext.FLOAT]="float",r[WebGLRenderingContext.FLOAT_VEC2]="vec2",r[WebGLRenderingContext.FLOAT_VEC3]="vec3",r[WebGLRenderingContext.FLOAT_VEC4]="vec4",r[WebGLRenderingContext.INT]="int",r[WebGLRenderingContext.INT_VEC2]="ivec2",r[WebGLRenderingContext.INT_VEC3]="ivec3",r[WebGLRenderingContext.INT_VEC4]="ivec4",r[WebGLRenderingContext.BOOL]="bool",r[WebGLRenderingContext.BOOL_VEC2]="bvec2",r[WebGLRenderingContext.BOOL_VEC3]="bvec3",r[WebGLRenderingContext.BOOL_VEC4]="bvec4",r[WebGLRenderingContext.FLOAT_MAT2]="mat2",r[WebGLRenderingContext.FLOAT_MAT3]="mat3",r[WebGLRenderingContext.FLOAT_MAT4]="mat4",r[WebGLRenderingContext.SAMPLER_2D]="sampler2D",r[WebGLRenderingContext.SAMPLER_CUBE]="samplerCube",n.prototype.getDeclaration=function(e){var t="uniform "+r[this._datatype]+" "+e,i=this._size;return t+=1===i?";":"["+i.toString()+"];"};var o={czm_viewport:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_model:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_inverseProjectionOIT:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseProjectionOIT}}),czm_infiniteProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_normal:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight2D:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_sunPositionWC:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_encodedCameraPositionMCHigh:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new n({size:1,datatype:WebGLRenderingContext.FLOAT_VEC3,getValue:function(e){return t.getTranslation(e.inverseView,i)}}),czm_frameNumber:new n({size:1,datatype:WebGLRenderingContext.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new n({size:1,datatype:WebGLRenderingContext.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new n({size:1,datatype:WebGLRenderingContext.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_temeToPseudoFixed:new n({size:1,datatype:WebGLRenderingContext.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_resolutionScale:new n({size:1,datatype:WebGLRenderingContext.FLOAT,getValue:function(e){return e.resolutionScale}})};return o}),define("Cesium/Renderer/ShaderSource",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Shaders/Builtin/CzmBuiltins","./AutomaticUniforms"],function(e,t,i,n,r){"use strict";function o(e){return e.replace(/\/\*\*[\s\S]*?\*\//gm,function(e){for(var t=e.match(/\n/gm).length,i="",n=0;t>n;++n)i+="\n";return i})}function a(e,i,n){for(var r,a=0;a<n.length;++a)n[a].name===e&&(r=n[a]);return t(r)||(i=o(i),r={name:e,glslSource:i,dependsOn:[],requiredBy:[],evaluated:!1},n.push(r)),r}function s(e,i){if(!e.evaluated){e.evaluated=!0;var n=e.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);t(n)&&null!==n&&(n=n.filter(function(e,t){return n.indexOf(e)===t}),n.forEach(function(t){if(t!==e.name&&d._czmBuiltinsAndUniforms.hasOwnProperty(t)){var n=a(t,d._czmBuiltinsAndUniforms[t],i);e.dependsOn.push(n),n.requiredBy.push(e),s(n,i)}}))}}function l(e){for(var t=[],n=[];e.length>0;){var r=e.pop();n.push(r),0===r.requiredBy.length&&t.push(r)}for(;t.length>0;){var o=t.shift();e.push(o);for(var a=0;a<o.dependsOn.length;++a){var s=o.dependsOn[a],l=s.requiredBy.indexOf(o);s.requiredBy.splice(l,1),0===s.requiredBy.length&&t.push(s)}}for(var u=[],c=0;c<n.length;++c)0!==n[c].requiredBy.length&&u.push(n[c]);if(0!==u.length){var d="A circular dependency was found in the following built-in functions/structs/constants: \n";for(c=0;c<u.length;++c)d=d+u[c].name+"\n";throw new i(d)}}function u(e){var t=[],i=a("main",e,t);s(i,t),l(t);for(var n="",r=t.length-1;r>=0;--r)n=n+t[r].glslSource+"\n";return n.replace(i.glslSource,"")}function c(e,n){var r,a,s="",l=e.sources;if(t(l))for(r=0,a=l.length;a>r;++r)s+="\n#line 0\n"+l[r];s=o(s);var c;s=s.replace(/#version\s+(.*?)\n/gm,function(e,n){if(t(c)&&c!==n)throw new i("inconsistent versions found: "+c+" and "+n);return c=n,"\n"});var d=e.pickColorQualifier;t(d)&&(s=s.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_old_main()"),s+="\n"+d+" vec4 czm_pickColor;\nvoid main()\n{\n    czm_old_main();\n    if (gl_FragColor.a == 0.0) {\n        discard;\n    }\n    gl_FragColor = czm_pickColor;\n}");var h="";t(c)&&(h="#version "+c),n&&(h+="#ifdef GL_FRAGMENT_PRECISION_HIGH\n    precision highp float;\n#else\n    precision mediump float;\n#endif\n\n");var m=e.defines;if(t(m))for(r=0,a=m.length;a>r;++r){var p=m[r];0!==p.length&&(h+="#define "+p+"\n")}return e.includeBuiltIns&&(h+=u(s)),h+="\n#line 0\n",h+=s}var d=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.pickColorQualifier;this.defines=t(i.defines)?i.defines.slice(0):[],this.sources=t(i.sources)?i.sources.slice(0):[],this.pickColorQualifier=n,this.includeBuiltIns=e(i.includeBuiltIns,!0)};d.prototype.clone=function(){return new d({sources:this.sources,defines:this.defines,pickColorQuantifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})},d.prototype.createCombinedVertexShader=function(){return c(this,!1)},d.prototype.createCombinedFragmentShader=function(){return c(this,!0)},d._czmBuiltinsAndUniforms={};for(var h in n)n.hasOwnProperty(h)&&(d._czmBuiltinsAndUniforms[h]=n[h]);for(var m in r)if(r.hasOwnProperty(m)){var p=r[m];"function"==typeof p.getDeclaration&&(d._czmBuiltinsAndUniforms[m]=p.getDeclaration(m))}return d}),define("Cesium/Renderer/VertexArrayFacade",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./BufferUsage"],function(e,t,i,n,r,o,a){"use strict";function s(e,t){if(t.needsCommit&&t.vertexSizeInBytes>0){t.needsCommit=!1;var n=t.vertexBuffer,r=e._size*t.vertexSizeInBytes,o=i(n);if(!o||n.sizeInBytes<r)return o&&n.destroy(),t.vertexBuffer=e._context.createVertexBuffer(t.arrayBuffer,t.usage),t.vertexBuffer.vertexArrayDestroyable=!1,!0;t.vertexBuffer.copyFromArrayView(t.arrayBuffer)}return!1}function l(e,t,i){if(e.needsCommit&&e.vertexSizeInBytes>0){var n=e.vertexSizeInBytes*t,r=e.vertexSizeInBytes*i;e.vertexBuffer.copyFromArrayView(new Uint8Array(e.arrayBuffer,n,r),n)}}function u(e){var t=e.va;if(i(t)){for(var n=t.length,r=0;n>r;++r)t[r].va.destroy();e.va=void 0}}var c=function(t,n,r){function o(t,i){return e.getSizeInBytes(i.componentDatatype)-e.getSizeInBytes(t.componentDatatype)}var s=c._verifyAttributes(n);r=r||0;for(var l,u,d=[],h={},m=s.length,p=0;m>p;++p){var f=s[p];f.vertexBuffer?d.push(f):(u=f.usage,l=h[u],i(l)||(l=h[u]=[]),l.push(f))}this._buffersByUsage={},this._allBuffers=[];for(u in h)if(h.hasOwnProperty(u)){l=h[u],l.sort(o);var v,g=c._vertexSizeInBytes(l);switch(Number(u)){case a.STATIC_DRAW:v=a.STATIC_DRAW;break;case a.STREAM_DRAW:v=a.STREAM_DRAW;break;case a.DYNAMIC_DRAW:v=a.DYNAMIC_DRAW}var _={vertexSizeInBytes:g,vertexBuffer:void 0,usage:v,needsCommit:!1,arrayBuffer:void 0,arrayViews:c._createArrayViews(l,g)};this._buffersByUsage[u]=_,this._allBuffers.push(_)}this._size=0,this._precreated=d,this._context=t,this.writers=void 0,this.va=void 0,this.resize(r)};c._verifyAttributes=function(i){for(var n=[],o=0;o<i.length;++o){var s=i[o],l={index:t(s.index,o),enabled:t(s.enabled,!0),componentsPerAttribute:s.componentsPerAttribute,componentDatatype:s.componentDatatype||e.FLOAT,normalize:s.normalize||!1,vertexBuffer:s.vertexBuffer,usage:s.usage||a.STATIC_DRAW};if(n.push(l),1!==l.componentsPerAttribute&&2!==l.componentsPerAttribute&&3!==l.componentsPerAttribute&&4!==l.componentsPerAttribute)throw new r("attribute.componentsPerAttribute must be in the range [1, 4].");var u=l.componentDatatype;if(!e.validate(u))throw new r("Attribute must have a valid componentDatatype or not specify it.");if(!a.validate(l.usage))throw new r("Attribute must have a valid usage or not specify it.")}for(var c=new Array(n.length),d=0;d<n.length;++d){var h=n[d],m=h.index;if(c[m])throw new r("Index "+m+" is used by more than one attribute.");c[m]=!0}return n},c._vertexSizeInBytes=function(t){for(var i=0,n=t.length,r=0;n>r;++r){var o=t[r];i+=o.componentsPerAttribute*e.getSizeInBytes(o.componentDatatype)}var a=n>0?e.getSizeInBytes(t[0].componentDatatype):0,s=a>0?i%a:0,l=0===s?0:a-s;return i+=l},c._createArrayViews=function(t,i){for(var n=[],r=0,o=t.length,a=0;o>a;++a){var s=t[a],l=s.componentDatatype;n.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:l,normalize:s.normalize,offsetInBytes:r,vertexSizeInComponentType:i/e.getSizeInBytes(l),view:void 0}),r+=s.componentsPerAttribute*e.getSizeInBytes(l)}return n},c.prototype.resize=function(e){this._size=e;var t=this._allBuffers;this.writers=[];for(var i=0,n=t.length;n>i;++i){var r=t[i];c._resize(r,this._size),c._appendWriters(this.writers,r)}u(this)},c._resize=function(t,n){if(t.vertexSizeInBytes>0){var r=new ArrayBuffer(n*t.vertexSizeInBytes);if(i(t.arrayBuffer))for(var o=new Uint8Array(r),a=new Uint8Array(t.arrayBuffer),s=a.length,l=0;s>l;++l)o[l]=a[l];for(var u=t.arrayViews,c=u.length,d=0;c>d;++d){var h=u[d];h.view=e.createArrayBufferView(h.componentDatatype,r,h.offsetInBytes)}t.arrayBuffer=r}};var d=[function(e,t,i){return function(n,r){t[n*i]=r,e.needsCommit=!0}},function(e,t,i){return function(n,r,o){var a=n*i;t[a]=r,t[a+1]=o,e.needsCommit=!0}},function(e,t,i){return function(n,r,o,a){var s=n*i;t[s]=r,t[s+1]=o,t[s+2]=a,e.needsCommit=!0}},function(e,t,i){return function(n,r,o,a,s){var l=n*i;t[l]=r,t[l+1]=o,t[l+2]=a,t[l+3]=s,e.needsCommit=!0}}];return c._appendWriters=function(e,t){for(var i=t.arrayViews,n=i.length,r=0;n>r;++r){var o=i[r];e[o.index]=d[o.componentsPerAttribute-1](t,o.view,o.vertexSizeInComponentType)}},c.prototype.commit=function(e){for(var t,n=!1,r=this._allBuffers,a=0,l=r.length;l>a;++a)t=r[a],n=s(this,t)||n;if(n||!i(this.va)){var d=this._buffersByUsage;u(this);for(var h=this.va=[],m=Math.ceil(this._size/o.SIXTY_FOUR_KILOBYTES),p=0;m>p;++p){var f=[];for(var v in d)d.hasOwnProperty(v)&&(t=d[v],c._appendAttributes(f,t,p*t.vertexSizeInBytes*o.SIXTY_FOUR_KILOBYTES));f=f.concat(this._precreated),h.push({va:this._context.createVertexArray(f,e),indicesCount:1.5*(p!==m-1?o.SIXTY_FOUR_KILOBYTES:this._size%o.SIXTY_FOUR_KILOBYTES)})}}},c._appendAttributes=function(e,t,i){for(var n=t.arrayViews,r=n.length,o=0;r>o;++o){var a=n[o];e.push({index:a.index,enabled:a.enabled,componentsPerAttribute:a.componentsPerAttribute,componentDatatype:a.componentDatatype,normalize:a.normalize,vertexBuffer:t.vertexBuffer,offsetInBytes:i+a.offsetInBytes,strideInBytes:t.vertexSizeInBytes})}},c.prototype.subCommit=function(e,t){for(var i=this._allBuffers,n=0,r=i.length;r>n;++n)l(i[n],e,t)},c.prototype.endSubCommits=function(){for(var e=this._allBuffers,t=0,i=e.length;i>t;++t)e[t].needsCommit=!1},c.prototype.isDestroyed=function(){return!1},c.prototype.destroy=function(){for(var e=this._allBuffers,t=0,i=e.length;i>t;++t){var r=e[t];r.vertexBuffer=r.vertexBuffer&&r.vertexBuffer.destroy()}return u(this),n(this)},c}),define("Cesium/Shaders/BillboardCollectionFS",[],function(){"use strict";return"uniform sampler2D u_atlas;\n\nvarying vec2 v_textureCoordinates;\n\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\n\nvoid main()\n{\n#ifdef RENDER_FOR_PICK\n    vec4 vertexColor = vec4(1.0, 1.0, 1.0, 1.0);\n#else\n    vec4 vertexColor = v_color;\n#endif\n    \n    vec4 color = texture2D(u_atlas, v_textureCoordinates) * vertexColor;\n    if (color.a == 0.0)\n    {\n        discard;\n    }\n    \n#ifdef RENDER_FOR_PICK\n    gl_FragColor = v_pickColor;\n#else\n    gl_FragColor = color;\n#endif\n}"}),define("Cesium/Shaders/BillboardCollectionVS",[],function(){"use strict";return"attribute vec4 positionHighAndScale;\nattribute vec4 positionLowAndRotation;   \nattribute vec4 compressedAttribute0;        // pixel offset, translate, horizontal origin, vertical origin, show, texture coordinates, direction\nattribute vec4 compressedAttribute1;        // aligned axis, translucency by distance, image width\nattribute vec4 compressedAttribute2;        // image height, color, pick color, 2 bytes free\nattribute vec3 eyeOffset;                   // eye offset in meters\nattribute vec4 scaleByDistance;             // near, nearScale, far, farScale\nattribute vec4 pixelOffsetScaleByDistance;  // near, nearScale, far, farScale\n\nvarying vec2 v_textureCoordinates;\n\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\n\nfloat getNearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\n    float valueAtMin = nearFarScalar.y;\n    float valueAtMax = nearFarScalar.w;\n    float nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\n    float farDistanceSq = nearFarScalar.z * nearFarScalar.z;\n\n    float t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\n\n    t = pow(clamp(t, 0.0, 1.0), 0.2);\n\n    return mix(valueAtMin, valueAtMax, t);\n}\n\nconst float UPPER_BOUND = 32768.0;\n\nconst float SHIFT_LEFT16 = 65536.0;\nconst float SHIFT_LEFT8 = 256.0;\nconst float SHIFT_LEFT7 = 128.0;\nconst float SHIFT_LEFT5 = 32.0;\nconst float SHIFT_LEFT3 = 8.0;\nconst float SHIFT_LEFT2 = 4.0;\nconst float SHIFT_LEFT1 = 2.0;\n\nconst float SHIFT_RIGHT8 = 1.0 / 256.0;\nconst float SHIFT_RIGHT7 = 1.0 / 128.0;\nconst float SHIFT_RIGHT5 = 1.0 / 32.0;\nconst float SHIFT_RIGHT3 = 1.0 / 8.0;\nconst float SHIFT_RIGHT2 = 1.0 / 4.0;\nconst float SHIFT_RIGHT1 = 1.0 / 2.0;\n\nvoid main() \n{\n    // Modifying this shader may also require modifications to Billboard._computeScreenSpacePosition\n    \n    // unpack attributes\n    vec3 positionHigh = positionHighAndScale.xyz;\n    vec3 positionLow = positionLowAndRotation.xyz;\n    float scale = positionHighAndScale.w;\n    \n#if defined(ROTATION) || defined(ALIGNED_AXIS)\n    float rotation = positionLowAndRotation.w;\n#endif\n\n    float compressed = compressedAttribute0.x;\n    \n    vec2 pixelOffset;\n    pixelOffset.x = floor(compressed * SHIFT_RIGHT7);\n    compressed -= pixelOffset.x * SHIFT_LEFT7;\n    pixelOffset.x -= UPPER_BOUND;\n    \n    vec2 origin;\n    origin.x = floor(compressed * SHIFT_RIGHT5);\n    compressed -= origin.x * SHIFT_LEFT5;\n    \n    origin.y = floor(compressed * SHIFT_RIGHT3);\n    compressed -= origin.y * SHIFT_LEFT3;\n    \n    origin -= vec2(1.0);\n    \n    float show = floor(compressed * SHIFT_RIGHT2);\n    compressed -= show * SHIFT_LEFT2;\n    \n    vec2 direction;\n    direction.x = floor(compressed * SHIFT_RIGHT1);\n    direction.y = compressed - direction.x * SHIFT_LEFT1;\n    \n    float temp = compressedAttribute0.y  * SHIFT_RIGHT8;\n    pixelOffset.y = -(floor(temp) - UPPER_BOUND);\n    \n    vec2 translate;\n    translate.y = (temp - floor(temp)) * SHIFT_LEFT16;\n    \n    temp = compressedAttribute0.z * SHIFT_RIGHT8;\n    translate.x = floor(temp) - UPPER_BOUND;\n    \n    translate.y += (temp - floor(temp)) * SHIFT_LEFT8;\n    translate.y -= UPPER_BOUND;\n    \n    vec2 textureCoordinates = czm_decompressTextureCoordinates(compressedAttribute0.w);\n    \n    temp = compressedAttribute1.x * SHIFT_RIGHT8;\n    \n    vec2 imageSize = vec2(floor(temp), compressedAttribute2.w);\n    \n#ifdef EYE_DISTANCE_TRANSLUCENCY\n    vec4 translucencyByDistance;\n    translucencyByDistance.x = compressedAttribute1.z;\n    translucencyByDistance.z = compressedAttribute1.w;\n    \n    translucencyByDistance.y = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\n    \n    temp = compressedAttribute1.y * SHIFT_RIGHT8;\n    translucencyByDistance.w = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\n#endif\n\n#ifdef ALIGNED_AXIS\n    vec3 alignedAxis = czm_octDecode(floor(compressedAttribute1.y * SHIFT_RIGHT8));\n#else\n    vec3 alignedAxis = vec3(0.0);\n#endif\n    \n#ifdef RENDER_FOR_PICK\n    temp = compressedAttribute2.y;\n#else\n    temp = compressedAttribute2.x;\n#endif\n\n    vec4 color;\n    temp = temp * SHIFT_RIGHT8;\n    color.b = (temp - floor(temp)) * SHIFT_LEFT8;\n    temp = floor(temp) * SHIFT_RIGHT8;\n    color.g = (temp - floor(temp)) * SHIFT_LEFT8;\n    color.r = floor(temp);\n    \n    temp = compressedAttribute2.z * SHIFT_RIGHT8;\n    \n#ifdef RENDER_FOR_PICK\n    color.a = (temp - floor(temp)) * SHIFT_LEFT8;\n    vec4 pickColor = color / 255.0;\n#else\n    color.a = floor(temp);\n    color /= 255.0;\n#endif\n    \n    ///////////////////////////////////////////////////////////////////////////\n    \n    vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\n    vec4 positionEC = czm_modelViewRelativeToEye * p;\n    positionEC = czm_eyeOffset(positionEC, eyeOffset);\n    positionEC.xyz *= show;\n    \n    ///////////////////////////////////////////////////////////////////////////     \n\n#if defined(EYE_DISTANCE_SCALING) || defined(EYE_DISTANCE_TRANSLUCENCY) || defined(EYE_DISTANCE_PIXEL_OFFSET)\n    float lengthSq;\n    if (czm_sceneMode == czm_sceneMode2D)\n    {\n        // 2D camera distance is a special case\n        // treat all billboards as flattened to the z=0.0 plane\n        lengthSq = czm_eyeHeight2D.y;\n    }\n    else\n    {\n        lengthSq = dot(positionEC.xyz, positionEC.xyz);\n    }\n#endif\n\n#ifdef EYE_DISTANCE_SCALING\n    scale *= getNearFarScalar(scaleByDistance, lengthSq);\n    // push vertex behind near plane for clipping\n    if (scale == 0.0)\n    {\n        positionEC.xyz = vec3(0.0);\n    }\n#endif\n\n    float translucency = 1.0;\n#ifdef EYE_DISTANCE_TRANSLUCENCY\n    translucency = getNearFarScalar(translucencyByDistance, lengthSq);\n    // push vertex behind near plane for clipping\n    if (translucency == 0.0)\n    {\n        positionEC.xyz = vec3(0.0);\n    }\n#endif\n\n#ifdef EYE_DISTANCE_PIXEL_OFFSET\n    float pixelOffsetScale = getNearFarScalar(pixelOffsetScaleByDistance, lengthSq);\n    pixelOffset *= pixelOffsetScale;\n#endif\n\n    vec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\n    \n    vec2 halfSize = imageSize * scale * czm_resolutionScale;\n    halfSize *= ((direction * 2.0) - 1.0);\n    \n    positionWC.xy += (origin * abs(halfSize));\n    \n#if defined(ROTATION) || defined(ALIGNED_AXIS)\n    if (!all(equal(alignedAxis, vec3(0.0))) || rotation != 0.0)\n    {\n        float angle = rotation;\n        if (!all(equal(alignedAxis, vec3(0.0))))\n        {\n            vec3 pos = positionEC.xyz + czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow;\n            vec3 normal = normalize(cross(alignedAxis, pos));\n            vec4 tangent = vec4(normalize(cross(pos, normal)), 0.0);\n            tangent = czm_modelViewProjection * tangent;\n            angle += sign(-tangent.x) * acos(tangent.y / length(tangent.xy));\n        }\n        \n        float cosTheta = cos(angle);\n        float sinTheta = sin(angle);\n        mat2 rotationMatrix = mat2(cosTheta, sinTheta, -sinTheta, cosTheta);\n        halfSize = rotationMatrix * halfSize;\n    }\n#endif\n    \n    positionWC.xy += halfSize;\n    positionWC.xy += translate;\n    positionWC.xy += (pixelOffset * czm_resolutionScale);\n\n    gl_Position = czm_viewportOrthographic * vec4(positionWC.xy, -positionWC.z, 1.0);\n    v_textureCoordinates = textureCoordinates;\n\n#ifdef RENDER_FOR_PICK\n    v_pickColor = pickColor;\n#else\n    v_color = color;\n    v_color.a *= translucency;\n#endif\n}\n"}),define("Cesium/Scene/SceneMode",["../Core/freezeObject"],function(e){"use strict";var t={MORPHING:0,COLUMBUS_VIEW:1,SCENE2D:2,SCENE3D:3};return t.getMorphTime=function(e){return e===t.SCENE3D?1:e===t.MORPHING?void 0:0},e(t)}),define("Cesium/Scene/SceneTransforms",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/defined","../Core/DeveloperError","../Core/Math","../Core/Matrix4","./SceneMode"],function(e,t,i,n,r,o,a,s,l,u){"use strict";var c={},d=new n(0,0,0,1),h=new n,m=new l;c.wgs84ToWindowCoordinates=function(e,t,i){var r=c.computeActualWgs84Position(e.frameState,t,d);if(!o(r))return void 0;var a=e.camera,s=l.multiply(a.frustum.projectionMatrix,a.viewMatrix,m);return l.multiplyByVector(s,n.fromElements(r.x,r.y,r.z,1,h),h),h.z<0&&e.mode!==u.SCENE2D?void 0:(i=c.clipToGLWindowCoordinates(e,h,i),i.y=e.canvas.clientHeight-i.y,i)},c.wgs84ToDrawingBufferCoordinates=function(e,t,i){var r=c.computeActualWgs84Position(e.frameState,t,d);if(!o(r))return void 0;var a=e.camera,s=l.multiply(a.frustum.projectionMatrix,a.viewMatrix,m);return l.multiplyByVector(s,n.fromElements(r.x,r.y,r.z,1,h),h),h.z<0&&e.mode!==u.SCENE2D?void 0:c.clipToDrawingBufferCoordinates(e,h,i)};var p=new i,f=new r;c.computeActualWgs84Position=function(e,t,n){var r=e.mode;if(r===u.SCENE3D)return i.clone(t,n);var a=e.mapProjection,l=a.ellipsoid.cartesianToCartographic(t,f);if(!o(l))return void 0;if(a.project(l,p),r===u.COLUMBUS_VIEW)return i.fromElements(p.z,p.x,p.y,n);if(r===u.SCENE2D)return i.fromElements(0,p.x,p.y,n);var c=e.morphTime;return i.fromElements(s.lerp(p.z,t.x,c),s.lerp(p.x,t.y,c),s.lerp(p.y,t.z,c),n)};var v=new i,g=new i,_=new e,y=new l;return c.clipToGLWindowCoordinates=function(e,n,r){var o=e.canvas;return i.divideByScalar(n,n.w,v),_.width=o.clientWidth,_.height=o.clientHeight,l.computeViewportTransformation(_,0,1,y),l.multiplyByPoint(y,v,g),t.fromCartesian3(g,r)},c.clipToDrawingBufferCoordinates=function(e,n,r){return i.divideByScalar(n,n.w,v),_.width=e.drawingBufferWidth,_.height=e.drawingBufferHeight,l.computeViewportTransformation(_,0,1,y),l.multiplyByPoint(y,v,g),t.fromCartesian3(g,r)},c.transformWindowToDrawingBuffer=function(e,i,n){var r=e.canvas,o=e.drawingBufferWidth/r.clientWidth,a=e.drawingBufferHeight/r.clientHeight;return t.fromElements(i.x*o,i.y*a,n)},c}),define("Cesium/Scene/Billboard",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/NearFarScalar","./HorizontalOrigin","./SceneMode","./SceneTransforms","./VerticalOrigin"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f){"use strict";function v(e,t){var i=e._billboardCollection;s(i)&&(i._updateBillboard(e,t),e._dirty=!0)}var g=function(e,n){e=a(e,a.EMPTY_OBJECT),this._show=a(e.show,!0),this._position=i.clone(a(e.position,i.ZERO)),this._actualPosition=i.clone(this._position),this._pixelOffset=t.clone(a(e.pixelOffset,t.ZERO)),this._translate=new t(0,0),this._eyeOffset=i.clone(a(e.eyeOffset,i.ZERO)),this._verticalOrigin=a(e.verticalOrigin,f.CENTER),this._horizontalOrigin=a(e.horizontalOrigin,h.CENTER),this._scale=a(e.scale,1),this._color=r.clone(a(e.color,r.WHITE)),this._rotation=a(e.rotation,0),this._alignedAxis=i.clone(a(e.alignedAxis,i.ZERO)),this._width=e.width,this._height=e.height,this._scaleByDistance=e.scaleByDistance,this._translucencyByDistance=e.translucencyByDistance,this._pixelOffsetScaleByDistance=e.pixelOffsetScaleByDistance,this._id=e.id,this._collection=a(e.collection,n),this._pickId=void 0,this._pickPrimitive=a(e._pickPrimitive,this),this._billboardCollection=n,this._dirty=!1,this._index=-1,this._imageIndex=-1,this._imageIndexPromise=void 0,this._imageId=void 0,this._image=void 0,this._imageSubRegion=void 0,this._imageWidth=void 0,this._imageHeight=void 0;var l=e.image,u=e.imageId;s(l)&&(s(u)||(u="string"==typeof l?l:s(l.src)?l.src:o()),this._imageId=u,this._image=l),s(e.imageSubRegion)&&(this._imageId=u,this._imageSubRegion=e.imageSubRegion),s(this._billboardCollection._textureAtlas)&&this._loadImage()},_=g.SHOW_INDEX=0,y=g.POSITION_INDEX=1,C=g.PIXEL_OFFSET_INDEX=2,w=g.EYE_OFFSET_INDEX=3,E=g.HORIZONTAL_ORIGIN_INDEX=4,b=g.VERTICAL_ORIGIN_INDEX=5,S=g.SCALE_INDEX=6,x=g.IMAGE_INDEX_INDEX=7,T=g.COLOR_INDEX=8,P=g.ROTATION_INDEX=9,A=g.ALIGNED_AXIS_INDEX=10,M=g.SCALE_BY_DISTANCE_INDEX=11,I=g.TRANSLUCENCY_BY_DISTANCE_INDEX=12,D=g.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX=13;g.NUMBER_OF_PROPERTIES=14,l(g.prototype,{show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,v(this,_))}},position:{get:function(){return this._position},set:function(e){var t=this._position;i.equals(t,e)||(i.clone(e,t),i.clone(e,this._actualPosition),v(this,y))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(e){var i=this._pixelOffset;t.equals(i,e)||(t.clone(e,i),v(this,C))}},scaleByDistance:{get:function(){return this._scaleByDistance},set:function(e){var t=this._scaleByDistance;d.equals(t,e)||(this._scaleByDistance=d.clone(e,t),v(this,M))}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){var t=this._translucencyByDistance;d.equals(t,e)||(this._translucencyByDistance=d.clone(e,t),v(this,I))}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){var t=this._pixelOffsetScaleByDistance;d.equals(t,e)||(this._pixelOffsetScaleByDistance=d.clone(e,t),v(this,D))}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){var t=this._eyeOffset;i.equals(t,e)||(i.clone(e,t),v(this,w))}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){this._horizontalOrigin!==e&&(this._horizontalOrigin=e,v(this,E))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){this._verticalOrigin!==e&&(this._verticalOrigin=e,v(this,b))}},scale:{get:function(){return this._scale},set:function(e){this._scale!==e&&(this._scale=e,v(this,S))}},color:{get:function(){return this._color},set:function(e){var t=this._color;r.equals(t,e)||(r.clone(e,t),v(this,T))}},rotation:{get:function(){return this._rotation},set:function(e){this._rotation!==e&&(this._rotation=e,v(this,P))}},alignedAxis:{get:function(){return this._alignedAxis},set:function(e){var t=this._alignedAxis;i.equals(t,e)||(i.clone(e,t),v(this,A))}},width:{get:function(){return a(this._width,this._imageWidth)},set:function(e){this._width!==e&&(this._width=e,v(this,x))}},height:{get:function(){return a(this._height,this._imageHeight)},set:function(e){this._height!==e&&(this._height=e,v(this,x))}},id:{get:function(){return this._id},set:function(e){this._id=e,s(this._pickId)&&(this._pickId.object.id=e)}},pickPrimitive:{get:function(){return this._pickPrimitive},set:function(e){this._pickPrimitive=e,s(this._pickId)&&(this._pickId.object.primitive=e)}},image:{get:function(){return this._imageId},set:function(e){s(e)?"string"==typeof e?this.setImage(e,e):s(e.src)?this.setImage(e.src,e):this.setImage(o(),e):(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=void 0,this._image=void 0,this._imageIndexPromise=void 0,v(this,x))}},ready:{get:function(){return-1!==this._imageIndex}}}),g.prototype.getPickId=function(e){return s(this._pickId)||(this._pickId=e.createPickId({primitive:this._pickPrimitive,collection:this._collection,id:this._id})),this._pickId},g.prototype._loadImage=function(){var t,i=this._billboardCollection._textureAtlas,n=this._imageId,r=this._image,o=this._imageSubRegion;if(s(r)&&(t=i.addImage(n,r)),s(o)&&(t=i.addSubRegion(n,o)),this._imageIndexPromise=t,s(t)){var a=this;t.then(function(t){if(a._imageId===n&&a._image===r&&e.equals(a._imageSubRegion,o)){var s=i.textureCoordinates[t];
a._imageWidth=i.texture.width*s.width,a._imageHeight=i.texture.height*s.height,a._imageIndex=t,a._ready=!0,a._image=void 0,a._imageIndexPromise=void 0,v(a,x)}}).otherwise(function(e){console.error("Error loading image for billboard: "+e),a._imageIndexPromise=void 0})}},g.prototype.setImage=function(e,t){this._imageId!==e&&(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=e,this._image=t,s(this._billboardCollection._textureAtlas)&&this._loadImage())},g.prototype.setImageSubRegion=function(t,i){this._imageId===t&&e.equals(this._imageSubRegion,i)||(this._imageIndex=-1,this._imageId=t,this._imageSubRegion=e.clone(i),s(this._billboardCollection._textureAtlas)&&this._loadImage())},g.prototype._setTranslate=function(e){var i=this._translate;t.equals(i,e)||(t.clone(e,i),v(this,C))},g.prototype._getActualPosition=function(){return this._actualPosition},g.prototype._setActualPosition=function(e){i.clone(e,this._actualPosition),v(this,y)};var O=new n;g._computeActualPosition=function(e,t,i){return t.mode===m.SCENE3D?e:(c.multiplyByPoint(i,e,O),p.computeActualWgs84Position(t,O))};var R=new c,L=new n,N=new i,z=new t,F=new t;g._computeScreenSpacePosition=function(e,r,o,a,s,l){var u=s.camera,d=u.viewMatrix,h=u.frustum.projectionMatrix,m=c.multiplyTransformation(d,e,R),f=c.multiplyByVector(m,n.fromElements(r.x,r.y,r.z,1,L),L),v=i.multiplyComponents(o,i.normalize(f,N),N);f.x+=o.x+v.x,f.y+=o.y+v.y,f.z+=v.z;var g=c.multiplyByVector(h,f,L),_=p.clipToGLWindowCoordinates(s,g,l);a=t.clone(a,F),a.y=-a.y;var y=t.multiplyByScalar(a,s.context.uniformState.resolutionScale,z);return _.x+=y.x,_.y+=y.y,_};var B=new t(0,0);return g.prototype.computeScreenSpacePosition=function(e,i){var n=this._billboardCollection;s(i)||(i=new t),t.clone(this._pixelOffset,B),t.add(B,this._translate,B);var r=n.modelMatrix,o=g._computeScreenSpacePosition(r,this._actualPosition,this._eyeOffset,B,e,i);return o.y=e.canvas.clientHeight-o.y,o},g.prototype.equals=function(n){return this===n||s(n)&&this._id===n._id&&i.equals(this._position,n._position)&&this._imageId===n._imageId&&this._show===n._show&&this._scale===n._scale&&this._verticalOrigin===n._verticalOrigin&&this._horizontalOrigin===n._horizontalOrigin&&e.equals(this._imageSubRegion,n._imageSubRegion)&&r.equals(this._color,n._color)&&t.equals(this._pixelOffset,n._pixelOffset)&&t.equals(this._translate,n._translate)&&i.equals(this._eyeOffset,n._eyeOffset)&&d.equals(this._scaleByDistance,n._scaleByDistance)&&d.equals(this._translucencyByDistance,n._translucencyByDistance)&&d.equals(this._pixelOffsetScaleByDistance,n._pixelOffsetScaleByDistance)},g.prototype._destroy=function(){this.image=void 0,this._pickId=this._pickId&&this._pickId.destroy(),this._billboardCollection=void 0},g}),define("Cesium/Scene/BlendEquation",["../Core/freezeObject"],function(e){"use strict";var t={ADD:32774,SUBTRACT:32778,REVERSE_SUBTRACT:32779};return e(t)}),define("Cesium/Scene/BlendFunction",["../Core/freezeObject"],function(e){"use strict";var t={ZERO:0,ONE:1,SOURCE_COLOR:768,ONE_MINUS_SOURCE_COLOR:769,DESTINATION_COLOR:774,ONE_MINUS_DESTINATION_COLOR:775,SOURCE_ALPHA:770,ONE_MINUS_SOURCE_ALPHA:771,DESTINATION_ALPHA:772,ONE_MINUS_DESTINATION_ALPHA:773,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,SOURCE_ALPHA_SATURATE:776};return e(t)}),define("Cesium/Scene/BlendingState",["../Core/freezeObject","./BlendEquation","./BlendFunction"],function(e,t,i){"use strict";var n={DISABLED:e({enabled:!1}),ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:i.SOURCE_ALPHA,functionSourceAlpha:i.SOURCE_ALPHA,functionDestinationRgb:i.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:i.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:i.ONE,functionSourceAlpha:i.ONE,functionDestinationRgb:i.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:i.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:i.SOURCE_ALPHA,functionSourceAlpha:i.SOURCE_ALPHA,functionDestinationRgb:i.ONE,functionDestinationAlpha:i.ONE})};return e(n)}),define("Cesium/Scene/Pass",["../Core/freezeObject"],function(e){"use strict";var t={GLOBE:0,OPAQUE:1,TRANSLUCENT:2,OVERLAY:3,NUMBER_OF_PASSES:4};return e(t)}),define("Cesium/Core/PixelFormat",["./freezeObject"],function(e){"use strict";var t={DEPTH_COMPONENT:6402,DEPTH_STENCIL:34041,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,validate:function(e){return e===t.DEPTH_COMPONENT||e===t.DEPTH_STENCIL||e===t.ALPHA||e===t.RGB||e===t.RGBA||e===t.LUMINANCE||e===t.LUMINANCE_ALPHA},isColorFormat:function(e){return e===t.ALPHA||e===t.RGB||e===t.RGBA||e===t.LUMINANCE||e===t.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===t.DEPTH_COMPONENT||e===t.DEPTH_STENCIL}};return e(t)}),define("Cesium/Scene/TextureAtlas",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/loadImage","../Core/PixelFormat","../Core/RuntimeError","../ThirdParty/when"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";function h(e,i,r,o,a){this.bottomLeft=n(e,t.ZERO),this.topRight=n(i,t.ZERO),this.childNode1=r,this.childNode2=o,this.imageIndex=a}function m(e,i){var n=e.numberOfImages,o=2;if(n>0){var a=e._texture.width,s=e._texture.height,l=o*(a+i.width+e._borderWidthInPixels),u=o*(s+i.height+e._borderWidthInPixels),c=a/l,d=s/u,m=new h(new t(a+e._borderWidthInPixels,0),new t(l,s)),p=new h(new t,new t(l,s),e._root,m),f=new h(new t(0,s+e._borderWidthInPixels),new t(l,u)),v=new h(new t,new t(l,u),p,f);e._root=v;for(var g=0;g<e._textureCoordinates.length;g++){var _=e._textureCoordinates[g];r(_)&&(_.x*=c,_.y*=d,_.width*=c,_.height*=d)}var y=e._context.createTexture2D({width:l,height:u,pixelFormat:e._pixelFormat}),C=e._context.createFramebuffer({colorTextures:[e._texture]});C._bind(),y.copyFromFramebuffer(0,0,0,0,a,s),C._unBind(),C.destroy(),e._texture=y}else{var w=o*(i.width+e._borderWidthInPixels),E=o*(i.height+e._borderWidthInPixels);e._texture=e._texture&&e._texture.destroy(),e._texture=e._context.createTexture2D({width:w,height:E,pixelFormat:e._pixelFormat}),e._root=new h(new t,new t(w,E))}}function p(e,i,n){if(!r(i))return void 0;if(!r(i.childNode1)&&!r(i.childNode2)){if(r(i.imageIndex))return void 0;var o=i.topRight.x-i.bottomLeft.x,a=i.topRight.y-i.bottomLeft.y,s=o-n.width,l=a-n.height;if(0>s||0>l)return void 0;if(0===s&&0===l)return i;if(s>l){i.childNode1=new h(new t(i.bottomLeft.x,i.bottomLeft.y),new t(i.bottomLeft.x+n.width,i.topRight.y));var u=i.bottomLeft.x+n.width+e._borderWidthInPixels;u<i.topRight.x&&(i.childNode2=new h(new t(u,i.bottomLeft.y),new t(i.topRight.x,i.topRight.y)))}else{i.childNode1=new h(new t(i.bottomLeft.x,i.bottomLeft.y),new t(i.topRight.x,i.bottomLeft.y+n.height));var c=i.bottomLeft.y+n.height+e._borderWidthInPixels;c<i.topRight.y&&(i.childNode2=new h(new t(i.bottomLeft.x,c),new t(i.topRight.x,i.topRight.y)))}return p(e,i.childNode1,n)}return p(e,i.childNode1,n)||p(e,i.childNode2,n)}function f(t,n,o){var a=p(t,t._root,n);if(r(a)){a.imageIndex=o;var s=t._texture.width,l=t._texture.height,u=a.topRight.x-a.bottomLeft.x,c=a.topRight.y-a.bottomLeft.y,d=a.bottomLeft.x/s,h=a.bottomLeft.y/l,v=u/s,g=c/l;t._textureCoordinates[o]=new e(d,h,v,g),t._texture.copyFrom(n,a.bottomLeft.x,a.bottomLeft.y)}else m(t,n),f(t,n,o);t._guid=i()}var v=new t(16,16),g=function(e){e=n(e,n.EMPTY_OBJECT);var r=n(e.borderWidthInPixels,1),o=n(e.initialSize,v);this._context=e.context,this._pixelFormat=n(e.pixelFormat,u.RGBA),this._borderWidthInPixels=r,this._textureCoordinates=[],this._guid=i(),this._idHash={},this._texture=this._context.createTexture2D({width:o.x,height:o.y,pixelFormat:this._pixelFormat}),this._root=new h(new t,new t(o.x,o.y))};return o(g.prototype,{borderWidthInPixels:{get:function(){return this._borderWidthInPixels}},textureCoordinates:{get:function(){return this._textureCoordinates}},texture:{get:function(){return this._texture}},numberOfImages:{get:function(){return this._textureCoordinates.length}},guid:{get:function(){return this._guid}}}),g.prototype.addImage=function(e,t){var i=this._idHash[e];if(r(i))return i;"function"==typeof t?t=t(e):"string"==typeof t&&(t=l(t));var n=this;return i=d(t,function(e){if(n.isDestroyed())return-1;var t=n.numberOfImages;return f(n,e,t),t}),this._idHash[e]=i,i},g.prototype.addSubRegion=function(t,n){var o=this._idHash[t];if(!r(o))throw new c('image with id "'+t+'" not found in the atlas.');var a=this;return d(o,function(t){if(-1===t)return-1;var r=a._texture.width,o=a._texture.height,s=a.numberOfImages,l=a._textureCoordinates[t],u=l.x+n.x/r,c=l.y+n.y/o,d=n.width/r,h=n.height/o;return a._textureCoordinates.push(new e(u,c,d,h)),a._guid=i(),s})},g.prototype.isDestroyed=function(){return!1},g.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),a(this)},g}),define("Cesium/Scene/BillboardCollection",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/IndexDatatype","../Core/Math","../Core/Matrix4","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/ShaderSource","../Renderer/VertexArrayFacade","../Shaders/BillboardCollectionFS","../Shaders/BillboardCollectionVS","./Billboard","./BlendingState","./HorizontalOrigin","./Pass","./SceneMode","./TextureAtlas"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T){"use strict";function P(e){for(var t=e.length,i=0;t>i;++i)e[i]&&e[i]._destroy()}function A(e){if(e._billboardsRemoved){e._billboardsRemoved=!1;for(var t=[],i=e._billboards,n=i.length,r=0,o=0;n>r;++r){var a=i[r];a&&(a._index=o++,t.push(a))}e._billboards=t}}function M(e){var t=16384,i=e.cache.billboardCollection_indexBuffer;if(s(i))return i;for(var n=6*t,r=new Uint16Array(n),o=0,a=0;n>o;o+=6,a+=4)r[o]=a,r[o+1]=a+1,r[o+2]=a+2,r[o+3]=a+0,r[o+4]=a+2,r[o+5]=a+3;return i=e.createIndexBuffer(r,f.STATIC_DRAW,h.UNSIGNED_SHORT),i.vertexArrayDestroyable=!1,e.cache.billboardCollection_indexBuffer=i,i}function I(e,t,i){return new _(e,[{index:nt.positionHighAndScale,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[G]},{index:nt.positionLowAndRotation,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[G]},{index:nt.compressedAttribute0,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[H]},{index:nt.compressedAttribute1,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[et]},{index:nt.compressedAttribute2,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[J]},{index:nt.eyeOffset,componentsPerAttribute:3,componentDatatype:o.FLOAT,usage:i[q]},{index:nt.scaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[$]},{index:nt.pixelOffsetScaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:i[tt]}],4*t)}function D(e,i,n,r,o){var a=4*o._index,s=o._getActualPosition();e._mode===x.SCENE3D&&(t.expand(e._baseVolume,s,e._baseVolume),e._boundingVolumeDirty=!0),d.fromCartesian(s,ot);var l=o.scale,u=o.rotation;0!==u&&(e._shaderRotation=!0),e._maxScale=Math.max(e._maxScale,l);var c=r[nt.positionHighAndScale],h=ot.high;c(a+0,h.x,h.y,h.z,l),c(a+1,h.x,h.y,h.z,l),c(a+2,h.x,h.y,h.z,l),c(a+3,h.x,h.y,h.z,l);var m=r[nt.positionLowAndRotation],p=ot.low;m(a+0,p.x,p.y,p.z,u),m(a+1,p.x,p.y,p.z,u),m(a+2,p.x,p.y,p.z,u),m(a+3,p.x,p.y,p.z,u)}function O(t,i,n,r,o){var a=4*o._index,s=o.pixelOffset,l=s.x,u=s.y,c=o._translate,d=c.x,h=c.y;t._maxPixelOffset=Math.max(t._maxPixelOffset,Math.abs(l+d),Math.abs(-u+h));var p=o.horizontalOrigin,f=o.verticalOrigin,v=o.show;0===o.color.alpha&&(v=!1),t._allHorizontalCenter=t._allHorizontalCenter&&p===b.CENTER;var g=0,_=0,y=0,C=0,w=o._imageIndex;if(-1!==w){var E=n[w];g=E.x,_=E.y,y=E.width,C=E.height}var S=g+y,x=_+C,T=Math.floor(m.clamp(l,-st,st)+st)*ct;T+=(p+1)*dt,T+=(f+1)*ht,T+=(v?1:0)*mt;var P=Math.floor(m.clamp(u,-st,st)+st)*ut,A=Math.floor(m.clamp(d,-st,st)+st)*ut,M=(m.clamp(h,-st,st)+st)*pt,I=Math.floor(M),D=Math.floor((M-I)*ut);P+=I,A+=D,at.x=g,at.y=_;var O=e.compressTextureCoordinates(at);at.x=S;var R=e.compressTextureCoordinates(at);at.y=x;var L=e.compressTextureCoordinates(at);at.x=g;var N=e.compressTextureCoordinates(at),z=r[nt.compressedAttribute0];z(a+0,T+ft,P,A,O),z(a+1,T+vt,P,A,R),z(a+2,T+gt,P,A,L),z(a+3,T+_t,P,A,N)}function R(t,i,r,o,l){var u=4*l._index,c=l.alignedAxis;n.equals(c,n.ZERO)||(t._shaderAlignedAxis=!0);var d=0,h=1,p=1,f=1,v=l.translucencyByDistance;s(v)&&(d=v.near,h=v.nearValue,p=v.far,f=v.farValue,(1!==h||1!==f)&&(t._shaderTranslucencyByDistance=!0));var g=0,_=l._imageIndex;if(-1!==_){var y=r[_];g=y.width}var C=t._textureAtlas.texture.width,w=Math.ceil(.5*a(l.width,C*g));t._maxSize=Math.max(t._maxSize,w);var E=m.clamp(w,0,lt),b=0;Math.abs(n.magnitudeSquared(c)-1)<m.EPSILON6&&(b=e.octEncodeFloat(c)),h=m.clamp(h,0,1),h=1===h?255:0|255*h,E=E*ut+h,f=m.clamp(f,0,1),f=1===f?255:0|255*f,b=b*ut+f;var S=o[nt.compressedAttribute1];S(u+0,E,b,d,p),S(u+1,E,b,d,p),S(u+2,E,b,d,p),S(u+3,E,b,d,p)}function L(e,t,i,n,o){var s=4*o._index,l=o.color,u=o.getPickId(t).color,c=0,d=o._imageIndex;if(-1!==d){var h=i[d];c=h.height}var m=e._textureAtlas.texture.dimensions,p=Math.ceil(.5*a(o.height,m.y*c));e._maxSize=Math.max(e._maxSize,p);var f=r.floatToByte(l.red),v=r.floatToByte(l.green),g=r.floatToByte(l.blue),_=f*lt+v*ut+g;f=r.floatToByte(u.red),v=r.floatToByte(u.green),g=r.floatToByte(u.blue);var y=f*lt+v*ut+g,C=r.floatToByte(l.alpha)*ut+r.floatToByte(u.alpha),w=n[nt.compressedAttribute2];w(s+0,_,y,C,p),w(s+1,_,y,C,p),w(s+2,_,y,C,p),w(s+3,_,y,C,p)}function N(e,t,i,n,r){var o=4*r._index,a=r.eyeOffset;e._maxEyeOffset=Math.max(e._maxEyeOffset,Math.abs(a.x),Math.abs(a.y),Math.abs(a.z));var s=n[nt.eyeOffset];s(o+0,a.x,a.y,a.z),s(o+1,a.x,a.y,a.z),s(o+2,a.x,a.y,a.z),s(o+3,a.x,a.y,a.z)}function z(e,t,i,n,r){var o=4*r._index,a=n[nt.scaleByDistance],l=0,u=1,c=1,d=1,h=r.scaleByDistance;s(h)&&(l=h.near,u=h.nearValue,c=h.far,d=h.farValue,(1!==u||1!==d)&&(e._shaderScaleByDistance=!0)),a(o+0,l,u,c,d),a(o+1,l,u,c,d),a(o+2,l,u,c,d),a(o+3,l,u,c,d)}function F(e,t,i,n,r){var o=4*r._index,a=n[nt.pixelOffsetScaleByDistance],l=0,u=1,c=1,d=1,h=r.pixelOffsetScaleByDistance;s(h)&&(l=h.near,u=h.nearValue,c=h.far,d=h.farValue,(1!==u||1!==d)&&(e._shaderPixelOffsetScaleByDistance=!0)),a(o+0,l,u,c,d),a(o+1,l,u,c,d),a(o+2,l,u,c,d),a(o+3,l,u,c,d)}function B(e,t,i,n,r){D(e,t,i,n,r),O(e,t,i,n,r),R(e,t,i,n,r),L(e,t,i,n,r),N(e,t,i,n,r),z(e,t,i,n,r),F(e,t,i,n,r)}function V(e,i,n,r,o,a){var l;r.mode===x.SCENE3D?(l=e._baseVolume,e._boundingVolumeDirty=!0):l=e._baseVolume2D;for(var u=[],c=0;n>c;++c){var d=i[c],h=d.position,m=w._computeActualPosition(h,r,o);s(m)&&(d._setActualPosition(m),a?u.push(m):t.expand(l,m,l))}a&&t.fromPoints(u,l)}function k(e,t){var i=t.mode,n=e._billboards,r=e._billboardsToUpdate,o=e._modelMatrix;e._createVertexArray||e._mode!==i||i!==x.SCENE3D&&!p.equals(o,e.modelMatrix)?(e._mode=i,p.clone(e.modelMatrix,o),e._createVertexArray=!0,(i===x.SCENE3D||i===x.SCENE2D||i===x.COLUMBUS_VIEW)&&V(e,n,n.length,t,o,!0)):i===x.MORPHING?V(e,n,n.length,t,o,!0):(i===x.SCENE2D||i===x.COLUMBUS_VIEW)&&V(e,r,e._billboardsToUpdateIndex,t,o,!1)}function U(e,t,i,r){var o=i.camera,a=o.frustum,s=n.subtract(o.positionWC,r.center,Ct),l=n.multiplyByScalar(o.directionWC,n.dot(s,o.directionWC),wt),u=Math.max(0,n.magnitude(l)-r.radius);yt.x=t.drawingBufferWidth,yt.y=t.drawingBufferHeight;var c=a.getPixelSize(yt,u),d=Math.max(c.x,c.y),h=2*d*e._maxScale*e._maxSize;e._allHorizontalCenter&&(h*=.5);var m=d*e._maxPixelOffset+e._maxEyeOffset;r.radius+=h+m}var W=w.SHOW_INDEX,G=w.POSITION_INDEX,H=w.PIXEL_OFFSET_INDEX,q=w.EYE_OFFSET_INDEX,j=w.HORIZONTAL_ORIGIN_INDEX,Y=w.VERTICAL_ORIGIN_INDEX,X=w.SCALE_INDEX,Z=w.IMAGE_INDEX_INDEX,J=w.COLOR_INDEX,K=w.ROTATION_INDEX,Q=w.ALIGNED_AXIS_INDEX,$=w.SCALE_BY_DISTANCE_INDEX,et=w.TRANSLUCENCY_BY_DISTANCE_INDEX,tt=w.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX,it=w.NUMBER_OF_PROPERTIES,nt={positionHighAndScale:0,positionLowAndRotation:1,compressedAttribute0:2,compressedAttribute1:3,compressedAttribute2:4,eyeOffset:5,scaleByDistance:6,pixelOffsetScaleByDistance:7},rt=function(e){e=a(e,a.EMPTY_OBJECT),this._textureAtlas=void 0,this._textureAtlasGUID=void 0,this._destroyTextureAtlas=!0,this._sp=void 0,this._rs=void 0,this._vaf=void 0,this._spPick=void 0,this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!1,this._shaderRotation=!1,this._compiledShaderRotation=!1,this._compiledShaderRotationPick=!1,this._shaderAlignedAxis=!1,this._compiledShaderAlignedAxis=!1,this._compiledShaderAlignedAxisPick=!1,this._shaderScaleByDistance=!1,this._compiledShaderScaleByDistance=!1,this._compiledShaderScaleByDistancePick=!1,this._shaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistancePick=!1,this._shaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistancePick=!1,this._propertiesChanged=new Uint32Array(it),this._maxSize=0,this._maxEyeOffset=0,this._maxScale=1,this._maxPixelOffset=0,this._allHorizontalCenter=!0,this._baseVolume=new t,this._baseVolumeWC=new t,this._baseVolume2D=new t,this._boundingVolume=new t,this._boundingVolumeDirty=!1,this._colorCommands=[],this._pickCommands=[],this.modelMatrix=p.clone(a(e.modelMatrix,p.IDENTITY)),this._modelMatrix=p.clone(p.IDENTITY),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this._mode=x.SCENE3D,this._buffersUsage=[f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW,f.STATIC_DRAW];var i=this;this._uniforms={u_atlas:function(){return i._textureAtlas.texture}}};l(rt.prototype,{length:{get:function(){return A(this),this._billboards.length}},textureAtlas:{get:function(){return this._textureAtlas},set:function(e){this._textureAtlas!==e&&(this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._textureAtlas=e,this._createVertexArray=!0)}},destroyTextureAtlas:{get:function(){return this._destroyTextureAtlas},set:function(e){this._destroyTextureAtlas=e}}}),rt.prototype.add=function(e){var t=new w(e,this);return t._index=this._billboards.length,this._billboards.push(t),this._createVertexArray=!0,t},rt.prototype.remove=function(e){return this.contains(e)?(this._billboards[e._index]=null,this._billboardsRemoved=!0,this._createVertexArray=!0,e._destroy(),!0):!1},rt.prototype.removeAll=function(){P(this._billboards),this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!0},rt.prototype._updateBillboard=function(e,t){e._dirty||(this._billboardsToUpdate[this._billboardsToUpdateIndex++]=e),++this._propertiesChanged[t]},rt.prototype.contains=function(e){return s(e)&&e._billboardCollection===this},rt.prototype.get=function(e){return A(this),this._billboards[e]},rt.prototype.computeNewBuffersUsage=function(){for(var e=this._buffersUsage,t=!1,i=this._propertiesChanged,n=0;it>n;++n){var r=0===i[n]?f.STATIC_DRAW:f.STREAM_DRAW;t=t||e[n]!==r,e[n]=r}return t};var ot=new d,at=new i,st=32768,lt=65536,ut=256,ct=128,dt=32,ht=8,mt=4,pt=1/256,ft=0,vt=2,gt=3,_t=1,yt=new i,Ct=new n,wt=new n,Et=[];return rt.prototype.update=function(e,i,n){A(this);var r=this._billboards,o=r.length,a=this._textureAtlas;if(!s(a)){a=this._textureAtlas=new T({context:e});for(var l=0;o>l;++l)r[l]._loadImage()}var u=a.textureCoordinates;if(0!==u.length){k(this,i),r=this._billboards,o=r.length;var c=this._billboardsToUpdate,d=this._billboardsToUpdateIndex,h=this._propertiesChanged,m=a.guid,f=this._createVertexArray||this._textureAtlasGUID!==m;this._textureAtlasGUID=m;var _,w=i.passes,b=w.pick;if(f||!b&&this.computeNewBuffersUsage()){this._createVertexArray=!1;for(var P=0;it>P;++P)h[P]=0;if(this._vaf=this._vaf&&this._vaf.destroy(),o>0){this._vaf=I(e,o,this._buffersUsage),_=this._vaf.writers;for(var V=0;o>V;++V){var rt=this._billboards[V];rt._dirty=!1,B(this,e,u,_,rt)}this._vaf.commit(M(e))}this._billboardsToUpdateIndex=0}else if(d>0){var ot=Et;ot.length=0,(h[G]||h[K]||h[X])&&ot.push(D),(h[Z]||h[H]||h[j]||h[Y]||h[W])&&ot.push(O),(h[Z]||h[Q]||h[et])&&ot.push(R),(h[Z]||h[J])&&ot.push(L),h[q]&&ot.push(N),h[$]&&ot.push(z),h[tt]&&ot.push(F);var at=ot.length;if(_=this._vaf.writers,d/o>.1){for(var st=0;d>st;++st){var lt=c[st];lt._dirty=!1;for(var ut=0;at>ut;++ut)ot[ut](this,e,u,_,lt)}this._vaf.commit(M(e))}else{for(var ct=0;d>ct;++ct){var dt=c[ct];dt._dirty=!1;for(var ht=0;at>ht;++ht)ot[ht](this,e,u,_,dt);this._vaf.subCommit(4*dt._index,4)}this._vaf.endSubCommits()}this._billboardsToUpdateIndex=0}if(d>1.5*o&&(c.length=o),s(this._vaf)&&s(this._vaf.va)){this._boundingVolumeDirty&&(this._boundingVolumeDirty=!1,t.transform(this._baseVolume,this.modelMatrix,this._baseVolumeWC));var mt,pt=p.IDENTITY;i.mode===x.SCENE3D?(pt=this.modelMatrix,mt=t.clone(this._baseVolumeWC,this._boundingVolume)):mt=t.clone(this._baseVolume2D,this._boundingVolume),U(this,e,i,mt);var ft,vt,gt,_t,yt,Ct;if(w.render){var wt=this._colorCommands;for(s(this._rs)||(this._rs=e.createRenderState({depthTest:{enabled:!0},blending:E.ALPHA_BLEND})),(!s(this._sp)||this._shaderRotation&&!this._compiledShaderRotation||this._shaderAlignedAxis&&!this._compiledShaderAlignedAxis||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistance||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistance||this._shaderPixelOffsetScaleByDistance&&!this._compiledShaderPixelOffsetScaleByDistance)&&(yt=new g({sources:[C]}),this._shaderRotation&&yt.defines.push("ROTATION"),this._shaderAlignedAxis&&yt.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&yt.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&yt.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&yt.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),this._sp=e.replaceShaderProgram(this._sp,yt,y,nt),this._compiledShaderRotation=this._shaderRotation,this._compiledShaderAlignedAxis=this._shaderAlignedAxis,this._compiledShaderScaleByDistance=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistance=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistance=this._shaderPixelOffsetScaleByDistance),ft=this._vaf.va,vt=ft.length,wt.length=vt,_t=0;vt>_t;++_t)gt=wt[_t],s(gt)||(gt=wt[_t]=new v({pass:S.OPAQUE,owner:this})),gt.boundingVolume=mt,gt.modelMatrix=pt,gt.count=ft[_t].indicesCount,gt.shaderProgram=this._sp,gt.uniformMap=this._uniforms,gt.vertexArray=ft[_t].va,gt.renderState=this._rs,gt.debugShowBoundingVolume=this.debugShowBoundingVolume,n.push(gt)}if(b){var bt=this._pickCommands;for((!s(this._spPick)||this._shaderRotation&&!this._compiledShaderRotationPick||this._shaderAlignedAxis&&!this._compiledShaderAlignedAxisPick||this._shaderScaleByDistance&&!this._compiledShaderScaleByDistancePick||this._shaderTranslucencyByDistance&&!this._compiledShaderTranslucencyByDistancePick||this._shaderPixelOffsetScaleByDistance&&!this._compiledShaderPixelOffsetScaleByDistancePick)&&(yt=new g({defines:["RENDER_FOR_PICK"],sources:[C]}),this._shaderRotation&&yt.defines.push("ROTATION"),this._shaderAlignedAxis&&yt.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&yt.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&yt.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&yt.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),Ct=new g({defines:["RENDER_FOR_PICK"],sources:[y]}),this._spPick=e.replaceShaderProgram(this._spPick,yt,Ct,nt),this._compiledShaderRotationPick=this._shaderRotation,this._compiledShaderAlignedAxisPick=this._shaderAlignedAxis,this._compiledShaderScaleByDistancePick=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistancePick=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistancePick=this._shaderPixelOffsetScaleByDistance),ft=this._vaf.va,vt=ft.length,bt.length=vt,_t=0;vt>_t;++_t)gt=bt[_t],s(gt)||(gt=bt[_t]=new v({pass:S.OPAQUE,owner:this})),gt.boundingVolume=mt,gt.modelMatrix=pt,gt.count=ft[_t].indicesCount,gt.shaderProgram=this._spPick,gt.uniformMap=this._uniforms,gt.vertexArray=ft[_t].va,gt.renderState=this._rs,n.push(gt)}}}},rt.prototype.isDestroyed=function(){return!1},rt.prototype.destroy=function(){return this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._sp=this._sp&&this._sp.destroy(),this._spPick=this._spPick&&this._spPick.destroy(),this._vaf=this._vaf&&this._vaf.destroy(),P(this._billboards),u(this)},rt}),define("Cesium/DataSources/BillboardVisualizer",["../Core/AssociativeArray","../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/BillboardCollection","../Scene/HorizontalOrigin","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";function p(e,t){if(o(e)){var i=e.billboard;o(i)&&(e.textureValue=void 0,e.billboard=void 0,i.show=!1,i.image=void 0,t.push(i._index))}}var f=r.WHITE,v=n.ZERO,g=i.ZERO,_=1,y=0,C=n.ZERO,w=c.CENTER,E=d.CENTER,b=new n,S=new r,x=new n,T=new i,P=new l,A=new l,M=new l,I=new t,D=function(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0},O=function(t,i){i.collectionChanged.addEventListener(O.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._billboardCollection=void 0,this._entityCollection=i,this._items=new e,this._onCollectionChanged(i,i.values,[],[])};return O.prototype.update=function(e){for(var t=this._items.values,i=this._unusedIndexes,n=0,r=t.length;r>n;n++){var a,s=t[n],l=s.entity,c=l._billboard,d=s.billboard,h=l.isShowing&&l.isAvailable(e)&&m.getValueOrDefault(c._show,e,!0);if(h&&(b=m.getValueOrUndefined(l._position,e,b),a=m.getValueOrUndefined(c._image,e),h=o(b)&&o(a)),h){if(!o(d)){var D=this._billboardCollection;o(D)||(D=new u,this._billboardCollection=D,this._scene.primitives.add(D));var O=i.length;d=O>0?D.get(i.pop()):D.add(),d.id=l,d.image=void 0,s.billboard=d}d.show=h,s.textureValue!==a&&(d.image=a,s.textureValue=a),d.position=b,d.color=m.getValueOrDefault(c._color,e,f,S),d.eyeOffset=m.getValueOrDefault(c._eyeOffset,e,v,x),d.pixelOffset=m.getValueOrDefault(c._pixelOffset,e,g,T),d.scale=m.getValueOrDefault(c._scale,e,_),d.rotation=m.getValueOrDefault(c._rotation,e,y),d.alignedAxis=m.getValueOrDefault(c._alignedAxis,e,C),d.horizontalOrigin=m.getValueOrDefault(c._horizontalOrigin,e,w),d.verticalOrigin=m.getValueOrDefault(c._verticalOrigin,e,E),d.width=m.getValueOrUndefined(c._width,e),d.height=m.getValueOrUndefined(c._height,e),d.scaleByDistance=m.getValueOrUndefined(c._scaleByDistance,e,P),d.translucencyByDistance=m.getValueOrUndefined(c._translucencyByDistance,e,A),d.pixelOffsetScaleByDistance=m.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,M);var R=m.getValueOrUndefined(c._imageSubRegion,e,I);o(R)&&d.setImageSubRegion(d._imageId,R)}else p(s,i)}return!0},O.prototype.getBoundingSphere=function(e,t){var i=this._items.get(e.id);return o(i)&&o(i.billboard)?(t.center=n.clone(i.billboard.position,t.center),t.radius=0,h.DONE):h.FAILED},O.prototype.isDestroyed=function(){return!1},O.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(O.prototype._onCollectionChanged,this),o(this._billboardCollection)&&this._scene.primitives.remove(this._billboardCollection),a(this)},O.prototype._onCollectionChanged=function(e,t,i,n){var r,a,s=this._unusedIndexes,l=this._items;for(r=t.length-1;r>-1;r--)a=t[r],o(a._billboard)&&o(a._position)&&l.set(a.id,new D(a));for(r=n.length-1;r>-1;r--)a=n[r],o(a._billboard)&&o(a._position)?l.contains(a.id)||l.set(a.id,new D(a)):(p(l.get(a.id),s),l.remove(a.id));for(r=i.length-1;r>-1;r--)a=i[r],p(l.get(a.id),s),l.remove(a.id)},O}),define("Cesium/Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Cesium/Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,i,n,r){"use strict";var o=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,r.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){var n=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&t(e.attributes[r])&&t(e.attributes[r].values)){var o=e.attributes[r],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new i("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Cesium/Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Cesium/Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Cesium/Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,i,n){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return r.POSITION_ONLY=n(new r({position:!0})),r.POSITION_AND_NORMAL=n(new r({position:!0,normal:!0})),r.POSITION_NORMAL_AND_ST=n(new r({position:!0,normal:!0,st:!0})),r.POSITION_AND_ST=n(new r({position:!0,st:!0})),r.POSITION_AND_COLOR=n(new r({position:!0,color:!0})),r.ALL=n(new r({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),r.DEFAULT=r.POSITION_NORMAL_AND_ST,r.packedLength=6,r.pack=function(t,i,n){n=e(n,0),i[n++]=t.position?1:0,i[n++]=t.normal?1:0,i[n++]=t.st?1:0,i[n++]=t.binormal?1:0,i[n++]=t.tangent?1:0,i[n++]=t.color?1:0},r.unpack=function(i,n,o){return n=e(n,0),t(o)||(o=new r),o.position=1===i[n++],o.normal=1===i[n++],o.st=1===i[n++],o.binormal=1===i[n++],o.tangent=1===i[n++],o.color=1===i[n++],o},r.clone=function(e,i){return t(e)?(t(i)||(i=new r),i.position=e.position,i.normal=e.normal,i.st=e.st,i.binormal=e.binormal,i.tangent=e.tangent,i.color=e.color,i):void 0},r}),define("Cesium/Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c){"use strict";var d=new t,h=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.minimumCorner,r=e.maximumCorner,o=n(e.vertexFormat,c.DEFAULT);this._minimumCorner=t.clone(i),this._maximumCorner=t.clone(r),this._vertexFormat=o,this._workerName="createBoxGeometry"};h.fromDimensions=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.dimensions,r=t.multiplyByScalar(i,.5,new t),o=t.negate(r,new t),a=r,s={minimumCorner:o,maximumCorner:a,vertexFormat:e.vertexFormat};return new h(s)},h.packedLength=2*t.packedLength+c.packedLength,h.pack=function(e,i,r){r=n(r,0),t.pack(e._minimumCorner,i,r),t.pack(e._maximumCorner,i,r+t.packedLength),c.pack(e._vertexFormat,i,r+2*t.packedLength)};var m=new t,p=new t,f=new c,v={minimumCorner:m,maximumCorner:p,vertexFormat:f};return h.unpack=function(e,i,o){i=n(i,0);
var a=t.unpack(e,i,m),s=t.unpack(e,i+t.packedLength,p),l=c.unpack(e,i+2*t.packedLength,f);return r(o)?(o._minimumCorner=t.clone(a,o._minimumCorner),o._maximumCorner=t.clone(s,o._maximumCorner),o._vertexFormat=c.clone(l,o._vertexFormat),o):new h(v)},h.createGeometry=function(n){var r,o,c=n._minimumCorner,h=n._maximumCorner,m=n._vertexFormat,p=new l;if(m.position&&(m.st||m.normal||m.binormal||m.tangent)){if(m.position&&(o=new Float64Array(72),o[0]=c.x,o[1]=c.y,o[2]=h.z,o[3]=h.x,o[4]=c.y,o[5]=h.z,o[6]=h.x,o[7]=h.y,o[8]=h.z,o[9]=c.x,o[10]=h.y,o[11]=h.z,o[12]=c.x,o[13]=c.y,o[14]=c.z,o[15]=h.x,o[16]=c.y,o[17]=c.z,o[18]=h.x,o[19]=h.y,o[20]=c.z,o[21]=c.x,o[22]=h.y,o[23]=c.z,o[24]=h.x,o[25]=c.y,o[26]=c.z,o[27]=h.x,o[28]=h.y,o[29]=c.z,o[30]=h.x,o[31]=h.y,o[32]=h.z,o[33]=h.x,o[34]=c.y,o[35]=h.z,o[36]=c.x,o[37]=c.y,o[38]=c.z,o[39]=c.x,o[40]=h.y,o[41]=c.z,o[42]=c.x,o[43]=h.y,o[44]=h.z,o[45]=c.x,o[46]=c.y,o[47]=h.z,o[48]=c.x,o[49]=h.y,o[50]=c.z,o[51]=h.x,o[52]=h.y,o[53]=c.z,o[54]=h.x,o[55]=h.y,o[56]=h.z,o[57]=c.x,o[58]=h.y,o[59]=h.z,o[60]=c.x,o[61]=c.y,o[62]=c.z,o[63]=h.x,o[64]=c.y,o[65]=c.z,o[66]=h.x,o[67]=c.y,o[68]=h.z,o[69]=c.x,o[70]=c.y,o[71]=h.z,p.position=new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:o})),m.normal){var f=new Float32Array(72);f[0]=0,f[1]=0,f[2]=1,f[3]=0,f[4]=0,f[5]=1,f[6]=0,f[7]=0,f[8]=1,f[9]=0,f[10]=0,f[11]=1,f[12]=0,f[13]=0,f[14]=-1,f[15]=0,f[16]=0,f[17]=-1,f[18]=0,f[19]=0,f[20]=-1,f[21]=0,f[22]=0,f[23]=-1,f[24]=1,f[25]=0,f[26]=0,f[27]=1,f[28]=0,f[29]=0,f[30]=1,f[31]=0,f[32]=0,f[33]=1,f[34]=0,f[35]=0,f[36]=-1,f[37]=0,f[38]=0,f[39]=-1,f[40]=0,f[41]=0,f[42]=-1,f[43]=0,f[44]=0,f[45]=-1,f[46]=0,f[47]=0,f[48]=0,f[49]=1,f[50]=0,f[51]=0,f[52]=1,f[53]=0,f[54]=0,f[55]=1,f[56]=0,f[57]=0,f[58]=1,f[59]=0,f[60]=0,f[61]=-1,f[62]=0,f[63]=0,f[64]=-1,f[65]=0,f[66]=0,f[67]=-1,f[68]=0,f[69]=0,f[70]=-1,f[71]=0,p.normal=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:f})}if(m.st){var v=new Float32Array(48);v[0]=0,v[1]=0,v[2]=1,v[3]=0,v[4]=1,v[5]=1,v[6]=0,v[7]=1,v[8]=1,v[9]=0,v[10]=0,v[11]=0,v[12]=0,v[13]=1,v[14]=1,v[15]=1,v[16]=0,v[17]=0,v[18]=1,v[19]=0,v[20]=1,v[21]=1,v[22]=0,v[23]=1,v[24]=1,v[25]=0,v[26]=0,v[27]=0,v[28]=0,v[29]=1,v[30]=1,v[31]=1,v[32]=1,v[33]=0,v[34]=0,v[35]=0,v[36]=0,v[37]=1,v[38]=1,v[39]=1,v[40]=0,v[41]=0,v[42]=1,v[43]=0,v[44]=1,v[45]=1,v[46]=0,v[47]=1,p.st=new s({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:v})}if(m.tangent){var g=new Float32Array(72);g[0]=1,g[1]=0,g[2]=0,g[3]=1,g[4]=0,g[5]=0,g[6]=1,g[7]=0,g[8]=0,g[9]=1,g[10]=0,g[11]=0,g[12]=-1,g[13]=0,g[14]=0,g[15]=-1,g[16]=0,g[17]=0,g[18]=-1,g[19]=0,g[20]=0,g[21]=-1,g[22]=0,g[23]=0,g[24]=0,g[25]=1,g[26]=0,g[27]=0,g[28]=1,g[29]=0,g[30]=0,g[31]=1,g[32]=0,g[33]=0,g[34]=1,g[35]=0,g[36]=0,g[37]=-1,g[38]=0,g[39]=0,g[40]=-1,g[41]=0,g[42]=0,g[43]=-1,g[44]=0,g[45]=0,g[46]=-1,g[47]=0,g[48]=-1,g[49]=0,g[50]=0,g[51]=-1,g[52]=0,g[53]=0,g[54]=-1,g[55]=0,g[56]=0,g[57]=-1,g[58]=0,g[59]=0,g[60]=1,g[61]=0,g[62]=0,g[63]=1,g[64]=0,g[65]=0,g[66]=1,g[67]=0,g[68]=0,g[69]=1,g[70]=0,g[71]=0,p.tangent=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:g})}if(m.binormal){var _=new Float32Array(72);_[0]=0,_[1]=1,_[2]=0,_[3]=0,_[4]=1,_[5]=0,_[6]=0,_[7]=1,_[8]=0,_[9]=0,_[10]=1,_[11]=0,_[12]=0,_[13]=1,_[14]=0,_[15]=0,_[16]=1,_[17]=0,_[18]=0,_[19]=1,_[20]=0,_[21]=0,_[22]=1,_[23]=0,_[24]=0,_[25]=0,_[26]=1,_[27]=0,_[28]=0,_[29]=1,_[30]=0,_[31]=0,_[32]=1,_[33]=0,_[34]=0,_[35]=1,_[36]=0,_[37]=0,_[38]=1,_[39]=0,_[40]=0,_[41]=1,_[42]=0,_[43]=0,_[44]=1,_[45]=0,_[46]=0,_[47]=1,_[48]=0,_[49]=0,_[50]=1,_[51]=0,_[52]=0,_[53]=1,_[54]=0,_[55]=0,_[56]=1,_[57]=0,_[58]=0,_[59]=1,_[60]=0,_[61]=0,_[62]=1,_[63]=0,_[64]=0,_[65]=1,_[66]=0,_[67]=0,_[68]=1,_[69]=0,_[70]=0,_[71]=1,p.binormal=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:_})}r=new Uint16Array(36),r[0]=0,r[1]=1,r[2]=2,r[3]=0,r[4]=2,r[5]=3,r[6]=6,r[7]=5,r[8]=4,r[9]=7,r[10]=6,r[11]=4,r[12]=8,r[13]=9,r[14]=10,r[15]=8,r[16]=10,r[17]=11,r[18]=14,r[19]=13,r[20]=12,r[21]=15,r[22]=14,r[23]=12,r[24]=18,r[25]=17,r[26]=16,r[27]=19,r[28]=18,r[29]=16,r[30]=20,r[31]=21,r[32]=22,r[33]=20,r[34]=22,r[35]=23}else o=new Float64Array(24),o[0]=c.x,o[1]=c.y,o[2]=c.z,o[3]=h.x,o[4]=c.y,o[5]=c.z,o[6]=h.x,o[7]=h.y,o[8]=c.z,o[9]=c.x,o[10]=h.y,o[11]=c.z,o[12]=c.x,o[13]=c.y,o[14]=h.z,o[15]=h.x,o[16]=c.y,o[17]=h.z,o[18]=h.x,o[19]=h.y,o[20]=h.z,o[21]=c.x,o[22]=h.y,o[23]=h.z,p.position=new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:o}),r=new Uint16Array(36),r[0]=4,r[1]=5,r[2]=6,r[3]=4,r[4]=6,r[5]=7,r[6]=1,r[7]=0,r[8]=3,r[9]=1,r[10]=3,r[11]=2,r[12]=1,r[13]=6,r[14]=5,r[15]=1,r[16]=2,r[17]=6,r[18]=2,r[19]=3,r[20]=7,r[21]=2,r[22]=7,r[23]=6,r[24]=3,r[25]=0,r[26]=4,r[27]=3,r[28]=4,r[29]=7,r[30]=0,r[31]=1,r[32]=5,r[33]=0,r[34]=5,r[35]=4;var y=t.subtract(h,c,d),C=.5*t.magnitude(y);return new a({attributes:p,indices:r,primitiveType:u.TRIANGLES,boundingSphere:new e(t.ZERO,C)})},h}),define("Cesium/Core/BoxOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType"],function(e,t,i,n,r,o,a,s,l,u){"use strict";var c=new t,d=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.minimumCorner,r=e.maximumCorner;this._min=t.clone(i),this._max=t.clone(r),this._workerName="createBoxOutlineGeometry"};d.fromDimensions=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.dimensions,r=t.multiplyByScalar(i,.5,new t),o=t.negate(r,new t),a=r,s={minimumCorner:o,maximumCorner:a};return new d(s)},d.packedLength=2*t.packedLength,d.pack=function(e,i,r){r=n(r,0),t.pack(e._min,i,r),t.pack(e._max,i,r+t.packedLength)};var h=new t,m=new t,p={minimumCorner:h,maximumCorner:m};return d.unpack=function(e,i,o){i=n(i,0);var a=t.unpack(e,i,h),s=t.unpack(e,i+t.packedLength,m);return r(o)?(o._min=t.clone(a,o._min),o._max=t.clone(s,o._max),o):new d(p)},d.createGeometry=function(n){var r=n._min,o=n._max,d=new l,h=new Uint16Array(24),m=new Float64Array(24);m[0]=r.x,m[1]=r.y,m[2]=r.z,m[3]=o.x,m[4]=r.y,m[5]=r.z,m[6]=o.x,m[7]=o.y,m[8]=r.z,m[9]=r.x,m[10]=o.y,m[11]=r.z,m[12]=r.x,m[13]=r.y,m[14]=o.z,m[15]=o.x,m[16]=r.y,m[17]=o.z,m[18]=o.x,m[19]=o.y,m[20]=o.z,m[21]=r.x,m[22]=o.y,m[23]=o.z,d.position=new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:m}),h[0]=4,h[1]=5,h[2]=5,h[3]=6,h[4]=6,h[5]=7,h[6]=7,h[7]=4,h[8]=0,h[9]=1,h[10]=1,h[11]=2,h[12]=2,h[13]=3,h[14]=3,h[15]=0,h[16]=0,h[17]=4,h[18]=1,h[19]=5,h[20]=2,h[21]=6,h[22]=3,h[23]=7;var p=t.subtract(o,r,c),f=.5*t.magnitude(p);return new a({attributes:d,indices:h,primitiveType:u.LINES,boundingSphere:new e(t.ZERO,f)})},d}),define("Cesium/Core/ColorGeometryInstanceAttribute",["./Color","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,i,n,r){"use strict";var o=function(t,n,r,o){t=i(t,1),n=i(n,1),r=i(r,1),o=i(o,1),this.value=new Uint8Array([e.floatToByte(t),e.floatToByte(n),e.floatToByte(r),e.floatToByte(o)])};return r(o.prototype,{componentDatatype:{get:function(){return t.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),o.fromColor=function(e){return new o(e.red,e.green,e.blue,e.alpha)},o.toValue=function(e,t){return n(t)?e.toBytes(t):new Uint8Array(e.toBytes())},o}),define("Cesium/Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,i,n){"use strict";var r=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return r}),define("Cesium/Core/ShowGeometryInstanceAttribute",["./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,i,n){"use strict";var r=function(e){e=t(e,!0),this.value=r.toValue(e)};return n(r.prototype,{componentDatatype:{get:function(){return e.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!0}}}),r.toValue=function(e,t){return i(t)?(t[0]=e,t):new Uint8Array([e])},r}),define("Cesium/Shaders/Appearances/AllMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\n\nvoid main()\n{\n    vec3 positionToEyeEC = -v_positionEC; \n    mat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_binormalEC);\n\n	vec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\n    normalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\n\n    czm_materialInput materialInput;\n    materialInput.normalEC = normalEC;\n    materialInput.tangentToEyeMatrix = tangentToEyeMatrix;\n    materialInput.positionToEyeEC = positionToEyeEC;\n    materialInput.st = v_st;\n    czm_material material = czm_getMaterial(materialInput);\n    \n#ifdef FLAT    \n    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\n    gl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),define("Cesium/Shaders/Appearances/AllMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 binormal;\nattribute vec2 st;\n\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\n\nvoid main() \n{\n    vec4 p = czm_computePosition();\n\n    v_positionEC = (czm_modelViewRelativeToEye * p).xyz;      // position in eye coordinates\n    v_normalEC = czm_normal * normal;                         // normal in eye coordinates\n    v_tangentEC = czm_normal * tangent;                       // tangent in eye coordinates\n    v_binormalEC = czm_normal * binormal;                     // binormal in eye coordinates\n    v_st = st;\n    \n    gl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),define("Cesium/Shaders/Appearances/BasicMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\n\nvoid main()\n{\n    vec3 positionToEyeEC = -v_positionEC; \n\n	vec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\n    normalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\n\n    czm_materialInput materialInput;\n    materialInput.normalEC = normalEC;\n    materialInput.positionToEyeEC = positionToEyeEC;\n    czm_material material = czm_getMaterial(materialInput);\n    \n#ifdef FLAT    \n    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\n    gl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),define("Cesium/Shaders/Appearances/BasicMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\n\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\n\nvoid main() \n{\n    vec4 p = czm_computePosition();\n\n    v_positionEC = (czm_modelViewRelativeToEye * p).xyz;      // position in eye coordinates\n    v_normalEC = czm_normal * normal;                         // normal in eye coordinates\n    \n    gl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),define("Cesium/Shaders/Appearances/TexturedMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\n\nvoid main()\n{\n    vec3 positionToEyeEC = -v_positionEC; \n\n	vec3 normalEC = normalize(v_normalEC);;\n#ifdef FACE_FORWARD\n    normalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\n\n    czm_materialInput materialInput;\n    materialInput.normalEC = normalEC;\n    materialInput.positionToEyeEC = positionToEyeEC;\n    materialInput.st = v_st;\n    czm_material material = czm_getMaterial(materialInput);\n    \n#ifdef FLAT    \n    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\n    gl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),define("Cesium/Shaders/Appearances/TexturedMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\n\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\n\nvoid main() \n{\n    vec4 p = czm_computePosition();\n\n    v_positionEC = (czm_modelViewRelativeToEye * p).xyz;      // position in eye coordinates\n    v_normalEC = czm_normal * normal;                         // normal in eye coordinates\n    v_st = st;\n    \n    gl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),define("Cesium/Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";var i=function(n,r,o){o=e(o,!1);var a,s,l,u={},c=t(n),d=t(r);if(c)for(a in n)n.hasOwnProperty(a)&&(s=n[a],d&&o&&"object"==typeof s&&r.hasOwnProperty(a)?(l=r[a],u[a]="object"==typeof l?i(s,l,o):s):u[a]=s);if(d)for(a in r)r.hasOwnProperty(a)&&!u.hasOwnProperty(a)&&(l=r[a],u[a]=l);return u};return i}),define("Cesium/Scene/CullFace",["../Core/freezeObject"],function(e){"use strict";var t={FRONT:1028,BACK:1029,FRONT_AND_BACK:1032};return e(t)}),define("Cesium/Scene/Appearance",["../Core/clone","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","./BlendingState","./CullFace"],function(e,t,i,n,r,o,a){"use strict";var s=function(e){e=i(e,i.EMPTY_OBJECT),this.material=e.material,this.translucent=i(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=i(e.closed,!1)};return r(s.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),s.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),n(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},s.prototype.isTranslucent=function(){return n(this.material)&&this.material.isTranslucent()||!n(this.material)&&this.translucent},s.prototype.getRenderState=function(){var t=this.isTranslucent(),i=e(this.renderState,!1);return t?(i.depthMask=!1,i.blending=o.ALPHA_BLEND):i.depthMask=!0,i},s.getDefaultRenderState=function(e,i,r){var s={depthTest:{enabled:!0}};return e&&(s.depthMask=!1,s.blending=o.ALPHA_BLEND),i&&(s.cull={enabled:!0,face:a.BACK}),n(r)&&(s=t(r,s,!0)),s},s}),define("Cesium/Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,i,n,r){"use strict";var o=function(e,i,n,r){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(i,0),this[3]=t(r,0)};o.packedLength=4,o.pack=function(e,i,n){n=t(n,0),i[n++]=e[0],i[n++]=e[1],i[n++]=e[2],i[n++]=e[3]},o.unpack=function(e,n,r){return n=t(n,0),i(r)||(r=new o),r[0]=e[n++],r[1]=e[n++],r[2]=e[n++],r[3]=e[n++],r},o.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,n,r){return n=t(n,0),i(r)||(r=new o),r[0]=e[n],r[1]=e[n+1],r[2]=e[n+2],r[3]=e[n+3],r},o.fromColumnMajorArray=function(e,t){return o.clone(e,t)},o.fromRowMajorArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){var n=Math.cos(e),r=Math.sin(e);return i(t)?(t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t):new o(n,-r,r,n)},o.toArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){return 2*e+t},o.getColumn=function(e,t,i){var n=2*t,r=e[n],o=e[n+1];return i.x=r,i.y=o,i},o.setColumn=function(e,t,i,n){n=o.clone(e,n);var r=2*t;return n[r]=i.x,n[r+1]=i.y,n},o.getRow=function(e,t,i){var n=e[t],r=e[t+2];return i.x=n,i.y=r,i},o.setRow=function(e,t,i,n){return n=o.clone(e,n),n[t]=i.x,n[t+2]=i.y,n};var a=new e;o.getScale=function(t,i){return i.x=e.magnitude(e.fromElements(t[0],t[1],a)),i.y=e.magnitude(e.fromElements(t[2],t[3],a)),i};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,t,i){var n=e[0]*t[0]+e[2]*t[1],r=e[0]*t[2]+e[2]*t[3],o=e[1]*t[0]+e[3]*t[1],a=e[1]*t[2]+e[3]*t[3];return i[0]=n,i[1]=o,i[2]=r,i[3]=a,i},o.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i},o.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i},o.multiplyByVector=function(e,t,i){var n=e[0]*t.x+e[2]*t.y,r=e[1]*t.x+e[3]*t.y;return i.x=n,i.y=r,i},o.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i},o.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},o.transpose=function(e,t){var i=e[0],n=e[2],r=e[1],o=e[3];return t[0]=i,t[1]=n,t[2]=r,t[3]=o,t},o.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},o.equals=function(e,t){return e===t||i(e)&&i(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]},o.equalsEpsilon=function(e,t,n){return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},o.IDENTITY=r(new o(1,0,0,1)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n"+"("+this[1]+", "+this[3]+")"},o}),define("Cesium/Renderer/PixelDatatype",["../Core/freezeObject"],function(e){"use strict";var t={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125,FLOAT:5126,UNSIGNED_INT_24_8_WEBGL:34042,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,validate:function(e){return e===t.UNSIGNED_BYTE||e===t.UNSIGNED_SHORT||e===t.UNSIGNED_INT||e===t.FLOAT||e===t.UNSIGNED_INT_24_8_WEBGL||e===t.UNSIGNED_SHORT_4_4_4_4||e===t.UNSIGNED_SHORT_5_5_5_1||e===t.UNSIGNED_SHORT_5_6_5}};return e(t)}),define("Cesium/Renderer/CubeMapFace",["../Core/defaultValue","../Core/defineProperties","../Core/DeveloperError","./PixelDatatype"],function(e,t){"use strict";var i=function(e,t,i,n,r,o,a,s,l){this._gl=e,this._texture=t,this._textureTarget=i,this._targetFace=n,this._pixelFormat=r,this._pixelDatatype=o,this._size=a,this._preMultiplyAlpha=s,this._flipY=l};return t(i.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),i.prototype.copyFrom=function(t,i,n){i=e(i,0),n=e(n,0);var r=this._gl,o=this._textureTarget;r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,this._flipY),r.activeTexture(r.TEXTURE0),r.bindTexture(o,this._texture),t.arrayBufferView?r.texSubImage2D(this._targetFace,0,i,n,t.width,t.height,this._pixelFormat,this._pixelDatatype,t.arrayBufferView):r.texSubImage2D(this._targetFace,0,i,n,this._pixelFormat,this._pixelDatatype,t),r.bindTexture(o,null)},i.prototype.copyFromFramebuffer=function(t,i,n,r,o,a){t=e(t,0),i=e(i,0),n=e(n,0),r=e(r,0),o=e(o,this._size),a=e(a,this._size);var s=this._gl,l=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),s.copyTexSubImage2D(this._targetFace,0,t,i,n,r,o,a),s.bindTexture(l,null)},i}),define("Cesium/Renderer/MipmapHint",["../Core/freezeObject"],function(e){"use strict";var t={DONT_CARE:4352,FASTEST:4353,NICEST:4354,validate:function(e){return e===t.DONT_CARE||e===t.FASTEST||e===t.NICEST}};return e(t)}),define("Cesium/Renderer/TextureMagnificationFilter",["../Core/freezeObject"],function(e){"use strict";var t={NEAREST:9728,LINEAR:9729,validate:function(e){return e===t.NEAREST||e===t.LINEAR}};return e(t)}),define("Cesium/Renderer/TextureMinificationFilter",["../Core/freezeObject"],function(e){"use strict";var t={NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,validate:function(e){return e===t.NEAREST||e===t.LINEAR||e===t.NEAREST_MIPMAP_NEAREST||e===t.LINEAR_MIPMAP_NEAREST||e===t.NEAREST_MIPMAP_LINEAR||e===t.LINEAR_MIPMAP_LINEAR}};return e(t)}),define("Cesium/Renderer/TextureWrap",["../Core/freezeObject"],function(e){"use strict";var t={CLAMP_TO_EDGE:33071,REPEAT:10497,MIRRORED_REPEAT:33648,validate:function(e){return e===t.CLAMP_TO_EDGE||e===t.REPEAT||e===t.MIRRORED_REPEAT}};return e(t)}),define("Cesium/Renderer/CubeMap",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./CubeMapFace","./MipmapHint","./PixelDatatype","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";var h=function(e,t,i,n,r,o,s,l,u){this._gl=e,this._textureFilterAnisotropic=t,this._textureTarget=i,this._texture=n,this._pixelFormat=r,this._pixelDatatype=o,this._size=s,this._preMultiplyAlpha=l,this._flipY=u,this._sampler=void 0,this._positiveX=new a(e,n,i,e.TEXTURE_CUBE_MAP_POSITIVE_X,r,o,s,l,u),this._negativeX=new a(e,n,i,e.TEXTURE_CUBE_MAP_NEGATIVE_X,r,o,s,l,u),this._positiveY=new a(e,n,i,e.TEXTURE_CUBE_MAP_POSITIVE_Y,r,o,s,l,u),this._negativeY=new a(e,n,i,e.TEXTURE_CUBE_MAP_NEGATIVE_Y,r,o,s,l,u),this._positiveZ=new a(e,n,i,e.TEXTURE_CUBE_MAP_POSITIVE_Z,r,o,s,l,u),this._negativeZ=new a(e,n,i,e.TEXTURE_CUBE_MAP_NEGATIVE_Z,r,o,s,l,u),this.sampler=void 0};return i(h.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var i=!0;if(!t(e)){i=!1;var n=c.LINEAR,o=u.LINEAR;this._pixelDatatype===l.FLOAT&&(n=c.NEAREST,o=u.NEAREST),e={wrapS:d.CLAMP_TO_EDGE,wrapT:d.CLAMP_TO_EDGE,minificationFilter:n,magnificationFilter:o,maximumAnisotropy:1}}if(this._pixelDatatype===l.FLOAT){if(e.minificationFilter!==c.NEAREST&&e.minificationFilter!==c.NEAREST_MIPMAP_NEAREST)throw new r("Only NEAREST and NEAREST_MIPMAP_NEAREST minification filters are supported for floating point textures.");if(e.magnificationFilter!==u.NEAREST)throw new r("Only the NEAREST magnification filter is supported for floating point textures.")}var a=this._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture),a.texParameteri(s,a.TEXTURE_MIN_FILTER,e.minificationFilter),a.texParameteri(s,a.TEXTURE_MAG_FILTER,e.magnificationFilter),a.texParameteri(s,a.TEXTURE_WRAP_S,e.wrapS),a.texParameteri(s,a.TEXTURE_WRAP_T,e.wrapT),t(this._textureFilterAnisotropic)&&a.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),a.bindTexture(s,null),this._sampler=i?{wrapS:e.wrapS,wrapT:e.wrapT,minificationFilter:e.minificationFilter,magnificationFilter:e.magnificationFilter,maximumAnisotropy:e.maximumAnisotropy}:void 0}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),h.prototype.generateMipmap=function(t){t=e(t,s.DONT_CARE);var i=this._gl,n=this._textureTarget;i.hint(i.GENERATE_MIPMAP_HINT,t),i.activeTexture(i.TEXTURE0),i.bindTexture(n,this._texture),i.generateMipmap(n),i.bindTexture(n,null)},h.prototype.isDestroyed=function(){return!1},h.prototype.destroy=function(){return this._gl.deleteTexture(this._texture),this._positiveX=n(this._positiveX),this._negativeX=n(this._negativeX),this._positiveY=n(this._positiveY),this._negativeY=n(this._negativeY),this._positiveZ=n(this._positiveZ),this._negativeZ=n(this._negativeZ),n(this)},h}),define("Cesium/Renderer/Texture",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/PixelFormat","./MipmapHint","./PixelDatatype","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,i,n,r,o,a,s,l,u,c,d,h){"use strict";var m=function(n,r){r=t(r,t.EMPTY_OBJECT);var a=r.source,l=i(a)?a.width:r.width,c=i(a)?a.height:r.height,d=t(r.pixelFormat,s.RGBA),h=t(r.pixelDatatype,u.UNSIGNED_BYTE);if(h===u.FLOAT&&!n.floatingPointTexture)throw new o("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.  Check context.floatingPointTexture.");if(s.isDepthFormat(d)&&!n.depthTexture)throw new o("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, this WebGL implementation must support WEBGL_depth_texture.  Check context.depthTexture.");var m=r.preMultiplyAlpha||d===s.RGB||d===s.LUMINANCE,p=t(r.flipY,!0),f=n._gl,v=f.TEXTURE_2D,g=f.createTexture();f.activeTexture(f.TEXTURE0),f.bindTexture(v,g),i(a)?(f.pixelStorei(f.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),f.pixelStorei(f.UNPACK_FLIP_Y_WEBGL,p),i(a.arrayBufferView)?f.texImage2D(v,0,d,l,c,0,d,h,a.arrayBufferView):i(a.framebuffer)?(a.framebuffer!==n.defaultFramebuffer&&a.framebuffer._bind(),f.copyTexImage2D(v,0,d,a.xOffset,a.yOffset,l,c,0),a.framebuffer!==n.defaultFramebuffer&&a.framebuffer._unBind()):f.texImage2D(v,0,d,d,h,a)):f.texImage2D(v,0,d,l,c,0,d,h,null),f.bindTexture(v,null),this._context=n,this._textureFilterAnisotropic=n._textureFilterAnisotropic,this._textureTarget=v,this._texture=g,this._pixelFormat=d,this._pixelDatatype=h,this._width=l,this._height=c,this._dimensions=new e(l,c),this._preMultiplyAlpha=m,this._flipY=p,this._sampler=void 0,this.sampler=void 0};return n(m.prototype,{sampler:{get:function(){return this._sampler},set:function(e){var t=!0;if(!i(e)){t=!1;var n=d.LINEAR,r=c.LINEAR;this._pixelDatatype===u.FLOAT&&(n=d.NEAREST,r=c.NEAREST),e={wrapS:h.CLAMP_TO_EDGE,wrapT:h.CLAMP_TO_EDGE,minificationFilter:n,magnificationFilter:r,maximumAnisotropy:1}}if(this._pixelDatatype===u.FLOAT){if(e.minificationFilter!==d.NEAREST&&e.minificationFilter!==d.NEAREST_MIPMAP_NEAREST)throw new o("Only NEAREST and NEAREST_MIPMAP_NEAREST minification filters are supported for floating point textures.");if(e.magnificationFilter!==c.NEAREST)throw new o("Only the NEAREST magnification filter is supported for floating point textures.")}var a=this._context._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture),a.texParameteri(s,a.TEXTURE_MIN_FILTER,e.minificationFilter),a.texParameteri(s,a.TEXTURE_MAG_FILTER,e.magnificationFilter),a.texParameteri(s,a.TEXTURE_WRAP_S,e.wrapS),a.texParameteri(s,a.TEXTURE_WRAP_T,e.wrapT),i(this._textureFilterAnisotropic)&&a.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),a.bindTexture(s,null),this._sampler=t?{wrapS:e.wrapS,wrapT:e.wrapT,minificationFilter:e.minificationFilter,magnificationFilter:e.magnificationFilter,maximumAnisotropy:e.maximumAnisotropy}:void 0}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},_target:{get:function(){return this._textureTarget}}}),m.prototype.copyFrom=function(e,i,n){i=t(i,0),n=t(n,0);var r=this._context._gl,o=this._textureTarget;r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,this._flipY),r.activeTexture(r.TEXTURE0),r.bindTexture(o,this._texture),e.arrayBufferView?r.texSubImage2D(o,0,i,n,e.width,e.height,this._pixelFormat,this._pixelDatatype,e.arrayBufferView):r.texSubImage2D(o,0,i,n,this._pixelFormat,this._pixelDatatype,e),r.bindTexture(o,null)},m.prototype.copyFromFramebuffer=function(e,i,n,r,o,a){e=t(e,0),i=t(i,0),n=t(n,0),r=t(r,0),o=t(o,this._width),a=t(a,this._height);var s=this._context._gl,l=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),s.copyTexSubImage2D(l,0,e,i,n,r,o,a),s.bindTexture(l,null)},m.prototype.generateMipmap=function(e){e=t(e,l.DONT_CARE);var i=this._context._gl,n=this._textureTarget;i.hint(i.GENERATE_MIPMAP_HINT,e),i.activeTexture(i.TEXTURE0),i.bindTexture(n,this._texture),i.generateMipmap(n),i.bindTexture(n,null)},m.prototype.isDestroyed=function(){return!1},m.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),r(this)},m}),define("Cesium/Shaders/Materials/BumpMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    vec2 st = materialInput.st;\n    \n    vec2 centerPixel = fract(repeat * st);\n    float centerBump = texture2D(image, centerPixel).channel;\n    \n    float imageWidth = float(imageDimensions.x);\n    vec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\n    float rightBump = texture2D(image, rightPixel).channel;\n    \n    float imageHeight = float(imageDimensions.y);\n    vec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\n    float topBump = texture2D(image, leftPixel).channel;\n    \n    vec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\n    vec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\n \n    material.normal = normalEC;\n    material.diffuse = vec3(0.01);\n    \n    return material;\n}"}),define("Cesium/Shaders/Materials/CheckerboardMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    vec2 st = materialInput.st;\n    \n    // From Stefan Gustavson's Procedural Textures in GLSL in OpenGL Insights\n    float b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);  // 0.0 or 1.0\n    \n    // Find the distance from the closest separator (region between two colors)\n    float scaledWidth = fract(repeat.s * st.s);\n    scaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\n    float scaledHeight = fract(repeat.t * st.t);\n    scaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\n    float value = min(scaledWidth, scaledHeight);\n    \n    vec4 currentColor = mix(lightColor, darkColor, b);\n    vec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\n    \n    material.diffuse = color.rgb;\n    material.alpha = color.a;\n    \n    return material;\n}\n"}),define("Cesium/Shaders/Materials/DotMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    \n    // From Stefan Gustavson's Procedural Textures in GLSL in OpenGL Insights\n    float b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));  // 0.0 or 1.0\n\n    vec4 color = mix(lightColor, darkColor, b);\n    material.diffuse = color.rgb;\n    material.alpha = color.a;\n    \n    return material;\n}\n"
}),define("Cesium/Shaders/Materials/FadeMaterial",[],function(){"use strict";return"uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\n\nfloat getTime(float t, float coord)\n{\n    float scalar = 1.0 / maximumDistance;\n    float q  = distance(t, coord) * scalar;\n    if (repeat)\n    {\n        float r = distance(t, coord + 1.0) * scalar;\n        float s = distance(t, coord - 1.0) * scalar;\n        q = min(min(r, s), q);\n    }\n    return clamp(q, 0.0, 1.0);\n}\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    \n    vec2 st = materialInput.st;\n    float s = getTime(time.x, st.s) * fadeDirection.s;\n    float t = getTime(time.y, st.t) * fadeDirection.t;\n    \n    float u = length(vec2(s, t));\n    vec4 color = mix(fadeInColor, fadeOutColor, u);\n    \n    material.emission = color.rgb;\n    material.alpha = color.a;\n    \n    return material;\n}\n"}),define("Cesium/Shaders/Materials/GridMaterial",[],function(){"use strict";return'#ifdef GL_OES_standard_derivatives\n    #extension GL_OES_standard_derivatives : enable\n#endif\n\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    vec2 st = materialInput.st;\n\n    float scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\n    scaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\n    float scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\n    scaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\n\n    float value;\n#ifdef GL_OES_standard_derivatives\n    // Fuzz Factor - Controls blurriness of lines\n    const float fuzz = 1.2;\n    vec2 thickness = (lineThickness * czm_resolutionScale) - 1.0;\n\n    // From "3D Engine Design for Virtual Globes" by Cozzi and Ring, Listing 4.13.\n    vec2 dx = abs(dFdx(st));\n    vec2 dy = abs(dFdy(st));\n    vec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\n    value = min(\n        smoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\n        smoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\n    // Fuzz Factor - Controls blurriness of lines\n    const float fuzz = 0.05;\n\n    vec2 range = 0.5 - (lineThickness * 0.05);\n    value = min(\n        1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n        1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\n\n    // Edges taken from RimLightingMaterial.glsl\n    // See http://www.fundza.com/rman_shaders/surface/fake_rim/fake_rim1.html\n    float dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\n    float sRim = smoothstep(0.8, 1.0, dRim);\n    value *= (1.0 - sRim);\n\n    vec3 halfColor = color.rgb * 0.5;\n    material.diffuse = halfColor;\n    material.emission = halfColor;\n    material.alpha = color.a * (1.0 - ((1.0 - cellAlpha) * value));\n\n    return material;\n}\n'}),define("Cesium/Shaders/Materials/NormalMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    \n    vec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\n    vec3 normalTangentSpace = textureValue.channels;\n    normalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\n    normalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\n    normalTangentSpace = normalize(normalTangentSpace);\n    vec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\n    \n    material.normal = normalEC;\n    \n    return material;\n}"}),define("Cesium/Shaders/Materials/PolylineArrowMaterial",[],function(){"use strict";return"#extension GL_OES_standard_derivatives : enable\n\nuniform vec4 color;\n\nvarying float v_width;\n\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\n    float slope = (p0.y - p1.y) / (p0.x - p1.x);\n    return slope * (x - p0.x) + p0.y;\n}\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    \n    vec2 st = materialInput.st;\n    \n    float base = 1.0 - abs(fwidth(st.s)) * 10.0;\n    vec2 center = vec2(1.0, 0.5);\n    float ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\n    float ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\n    \n    float halfWidth = 0.15;\n    float s = step(0.5 - halfWidth, st.t);\n    s *= 1.0 - step(0.5 + halfWidth, st.t);\n    s *= 1.0 - step(base, st.s);\n    \n    float t = step(base, materialInput.st.s);\n    t *= 1.0 - step(ptOnUpperLine, st.t);\n    t *= step(ptOnLowerLine, st.t);\n    \n    // Find the distance from the closest separator (region between two colors)\n    float dist;\n    if (st.s < base)\n    {\n        float d1 = abs(st.t - (0.5 - halfWidth));\n        float d2 = abs(st.t - (0.5 + halfWidth));\n        dist = min(d1, d2);\n    }\n    else\n    {\n        float d1 = czm_infinity;\n        if (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n        {\n            d1 = abs(st.s - base);\n        }\n        float d2 = abs(st.t - ptOnUpperLine);\n        float d3 = abs(st.t - ptOnLowerLine);\n        dist = min(min(d1, d2), d3);\n    }\n    \n    vec4 outsideColor = vec4(0.0);\n    vec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\n    vec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\n    \n    material.diffuse = outColor.rgb;\n    material.alpha = outColor.a;\n    return material;\n}\n"}),define("Cesium/Shaders/Materials/PolylineGlowMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform float glowPower;\n\nvarying float v_width;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    vec2 st = materialInput.st;\n    float glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\n\n    material.emission = max(vec3(glow - 1.0 + color.rgb), color.rgb);\n    material.alpha = clamp(0.0, 1.0, glow) * color.a;\n\n    return material;\n}\n"}),define("Cesium/Shaders/Materials/PolylineOutlineMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\n\nvarying float v_width;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    \n    vec2 st = materialInput.st;\n    float halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\n    float b = step(0.5 - halfInteriorWidth, st.t);\n    b *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\n    \n    // Find the distance from the closest separator (region between two colors)\n    float d1 = abs(st.t - (0.5 - halfInteriorWidth));\n    float d2 = abs(st.t - (0.5 + halfInteriorWidth));\n    float dist = min(d1, d2);\n    \n    vec4 currentColor = mix(outlineColor, color, b);\n    vec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\n    \n    material.diffuse = outColor.rgb;\n    material.alpha = outColor.a;\n    \n    return material;\n}\n"}),define("Cesium/Shaders/Materials/RimLightingMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    // See http://www.fundza.com/rman_shaders/surface/fake_rim/fake_rim1.html\n    float d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\n    float s = smoothstep(1.0 - width, 1.0, d);\n\n    material.diffuse = color.rgb;\n    material.emission = rimColor.rgb * s; \n    material.alpha = mix(color.a, rimColor.a, s);\n\n    return material;\n}\n"}),define("Cesium/Shaders/Materials/StripeMaterial",[],function(){"use strict";return"uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    // Based on the Stripes Fragment Shader in the Orange Book (11.1.2)\n    float coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\n    float value = fract((coord - offset) * (repeat * 0.5));\n    float dist = min(value, min(abs(value - 0.5), 1.0 - value));\n    \n    vec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\n    vec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\n    \n    material.diffuse = color.rgb;\n    material.alpha = color.a;\n    \n    return material;\n}\n"}),define("Cesium/Shaders/Materials/Water",[],function(){"use strict";return"// Thanks for the contribution Jonas\n// http://29a.ch/2012/7/19/webgl-terrain-rendering-water-fog\n\nuniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\n\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\n    czm_material material = czm_getDefaultMaterial(materialInput);\n\n    float time = czm_frameNumber * animationSpeed;\n    \n    // fade is a function of the distance from the fragment and the frequency of the waves\n    float fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\n            \n    float specularMapValue = texture2D(specularMap, materialInput.st).r;\n    \n    // note: not using directional motion at this time, just set the angle to 0.0;\n    vec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\n    vec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\n    \n    // fade out the normal perturbation as we move further from the water surface\n    normalTangentSpace.xy /= fade;\n        \n    // attempt to fade out the normal perturbation as we approach non water areas (low specular map value)\n    normalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\n    \n    normalTangentSpace = normalize(normalTangentSpace);\n    \n    // get ratios for alignment of the new normal vector with a vector perpendicular to the tangent plane\n    float tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\n    \n    // fade out water effect as specular map value decreases\n    material.alpha = specularMapValue;\n    \n    // base color is a blend of the water and non-water color based on the value from the specular map\n    // may need a uniform blend factor to better control this\n    material.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\n    \n    // diffuse highlights are based on how perturbed the normal is\n    material.diffuse += (0.1 * tsPerturbationRatio);\n    \n    material.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\n    \n    material.specular = specularIntensity;\n    material.shininess = 10.0;\n    \n    return material;\n}"}),define("Cesium/Scene/Material",["../Core/Cartesian2","../Core/clone","../Core/Color","../Core/combine","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/isArray","../Core/loadImage","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Renderer/CubeMap","../Renderer/Texture","../Shaders/Materials/BumpMapMaterial","../Shaders/Materials/CheckerboardMaterial","../Shaders/Materials/DotMaterial","../Shaders/Materials/FadeMaterial","../Shaders/Materials/GridMaterial","../Shaders/Materials/NormalMapMaterial","../Shaders/Materials/PolylineArrowMaterial","../Shaders/Materials/PolylineGlowMaterial","../Shaders/Materials/PolylineOutlineMaterial","../Shaders/Materials/RimLightingMaterial","../Shaders/Materials/StripeMaterial","../Shaders/Materials/Water","../ThirdParty/when"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M){"use strict";function I(e,i){e=o(e,o.EMPTY_OBJECT),i._strict=o(e.strict,!1),i._count=o(e.count,0),i._template=t(o(e.fabric,o.EMPTY_OBJECT)),i._template.uniforms=t(o(i._template.uniforms,o.EMPTY_OBJECT)),i._template.materials=t(o(i._template.materials,o.EMPTY_OBJECT)),i.type=a(i._template.type)?i._template.type:r(),i.shaderSource="",i.materials={},i.uniforms={},i._uniforms={},i._translucentFunctions=[];var s,l=H._materialCache.getMaterial(i.type);if(a(l)){var u=t(l.fabric,!0);i._template=n(i._template,u,!0),s=l.translucent}L(i),a(l)||H._materialCache.addMaterial(i.type,i),N(i),B(i),U(i);var c=0===i._translucentFunctions.length?!0:void 0;if(s=o(s,c),s=o(e.translucent,s),a(s))if("function"==typeof s){var d=function(){return s(i)};i._translucentFunctions.push(d)}else i._translucentFunctions.push(s)}function D(e,t,i,n){if(a(e))for(var r in e)if(e.hasOwnProperty(r)){var o=-1!==t.indexOf(r);(n&&!o||!n&&o)&&i(r,t)}}function O(e,t){for(var i="fabric: property name '"+e+"' is not valid. It should be ",n=0;n<t.length;n++){var r="'"+t[n]+"'";i+=n===t.length-1?"or "+r+".":r+", "}throw new u(i)}function R(e){var t="fabric: uniforms and materials cannot share the same property '"+e+"'";throw new u(t)}function L(e){var t=e._template,i=t.uniforms,n=t.materials,r=t.components;if(a(r)&&a(t.source))throw new u("fabric: cannot have source and components in the same template.");D(t,q,O,!0),D(r,j,O,!0);var o=[];for(var s in n)n.hasOwnProperty(s)&&o.push(s);D(i,o,R,!1)}function N(e){var t=e._template.components,i=e._template.source;if(a(i))e.shaderSource+=i+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",a(t))for(var n in t)t.hasOwnProperty(n)&&(e.shaderSource+="material."+n+" = "+t[n]+";\n");e.shaderSource+="return material;\n}\n"}}function z(e){return function(t,i){var n,r,o=t.uniforms,s=o[e],l=t._textures[e];if(s instanceof v&&s!==l)return H._textureCache.releaseTexture(t._texturePaths[e]),t._texturePaths[e]=void 0,t._textures[e]=s,n=e+"Dimensions",o.hasOwnProperty(n)&&(r=o[n],r.x=s._width,r.y=s._height),void 0;if(a(l)||(t._texturePaths[e]=void 0,l=t._textures[e]=i.defaultTexture,n=e+"Dimensions",o.hasOwnProperty(n)&&(r=o[n],r.x=l._width,r.y=l._height)),s!==H.DefaultImageId&&s!==t._texturePaths[e]){var u=H._textureCache.getTexture(s);a(u)?(H._textureCache.releaseTexture(t._texturePaths[e]),t._textures[e]=u):"string"==typeof s?M(d(s),function(i){t._loadedImages.push({id:e,image:i})}):s instanceof HTMLCanvasElement&&t._loadedImages.push({id:e,image:s}),t._texturePaths[e]=s}}}function F(e){return function(t,i){var n=t.uniforms[e];if(n instanceof f)return H._textureCache.releaseTexture(t._texturePaths[e]),t._texturePaths[e]=void 0,t._textures[e]=n,void 0;if(a(t._textures[e])||(t._texturePaths[e]=void 0,t._textures[e]=i.defaultCubeMap),n!==H.DefaultCubeMapId){var r=n.positiveX+n.negativeX+n.positiveY+n.negativeY+n.positiveZ+n.negativeZ;if(r!==t._texturePaths[e]){var o=H._textureCache.getTexture(r);if(a(o))H._textureCache.releaseTexture(t._texturePaths[e]),t._textures[e]=o;else{var s=[d(n.positiveX),d(n.negativeX),d(n.positiveY),d(n.negativeY),d(n.positiveZ),d(n.negativeZ)];M.all(s).then(function(i){t._loadedCubeMaps.push({id:e,images:i})})}t._texturePaths[e]=r}}}}function B(e){var t=e._template.uniforms;for(var i in t)t.hasOwnProperty(i)&&V(e,i)}function V(e,t){var i=e._strict,n=e._template.uniforms,r=n[t],o=k(r);if(!a(o))throw new u("fabric: uniform '"+t+"' has invalid type.");if("channels"===o){if(0===W(e,t,r,!1)&&i)throw new u("strict: shader source does not use channels '"+t+"'.")}else{if("sampler2D"===o){var s=t+"Dimensions";G(e,s)>0&&(n[s]={type:"ivec3",x:1,y:1},V(e,s))}var l=new RegExp("uniform\\s+"+o+"\\s+"+t+"\\s*;");if(!l.test(e.shaderSource)){var c="uniform "+o+" "+t+";";e.shaderSource=c+e.shaderSource}var d=t+"_"+e._count++;if(1===W(e,t,d)&&i)throw new u("strict: shader source does not use uniform '"+t+"'.");if(e.uniforms[t]=r,"sampler2D"===o)e._uniforms[d]=function(){return e._textures[t]},e._updateFunctions.push(z(t));else if("samplerCube"===o)e._uniforms[d]=function(){return e._textures[t]},e._updateFunctions.push(F(t));else if(-1!==o.indexOf("mat")){var h=new Y[o];e._uniforms[d]=function(){return Y[o].fromColumnMajorArray(e.uniforms[t],h)}}else e._uniforms[d]=function(){return e.uniforms[t]}}}function k(e){var t=e.type;if(!a(t)){var i=typeof e;if("number"===i)t="float";else if("boolean"===i)t="bool";else if("string"===i||e instanceof HTMLCanvasElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===H.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===i)if(c(e))(4===e.length||9===e.length||16===e.length)&&(t="mat"+Math.sqrt(e.length));else{var n=0;for(var r in e)e.hasOwnProperty(r)&&(n+=1);n>=2&&4>=n?t="vec"+n:6===n&&(t="samplerCube")}}return t}function U(e){var t=e._strict,i=e._template.materials;for(var r in i)if(i.hasOwnProperty(r)){var o=new H({strict:t,fabric:i[r],count:e._count});e._count=o._count,e._uniforms=n(e._uniforms,o._uniforms,!0),e.materials[r]=o,e._translucentFunctions=e._translucentFunctions.concat(o._translucentFunctions);var a="czm_getMaterial",s=a+"_"+e._count++;W(o,a,s),e.shaderSource=o.shaderSource+e.shaderSource;var l=s+"(materialInput)";if(0===W(e,r,l)&&t)throw new u("strict: shader source does not use material '"+r+"'.")}}function W(e,t,i,n){n=o(n,!0);var r=0,a="([\\w])?",s="([\\w"+(n?".":"")+"])?",l=new RegExp(s+t+a,"g");return e.shaderSource=e.shaderSource.replace(l,function(e,t,n){return t||n?e:(r+=1,i)}),r}function G(e,t,i){return W(e,t,t,i)}var H=function(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],I(e,this),s(this,{type:{value:this.type,writable:!1}}),a(H._uniformList[this.type])||(H._uniformList[this.type]=Object.keys(this._uniforms))};H._uniformList={},H.fromType=function(e,t){var i=new H({fabric:{type:e}});if(a(t))for(var n in t)t.hasOwnProperty(n)&&(i.uniforms[n]=t[n]);return i},H.prototype.isTranslucent=function(){if(a(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,i=t.length,n=0;i>n;++n){var r=t[n];if(e="function"==typeof r?e&&r():e&&r,!e)break}return e},H.prototype.update=function(e){var t,i,n=this._loadedImages,r=n.length;for(t=0;r>t;++t){var o=n[t];i=o.id;var s=o.image,l=H._textureCache.getTexture(this._texturePaths[i]);a(l)||(l=e.createTexture2D({source:s}),H._textureCache.addTexture(this._texturePaths[i],l)),this._textures[i]=l;var u=i+"Dimensions";if(this.uniforms.hasOwnProperty(u)){var c=this.uniforms[u];c.x=l._width,c.y=l._height}}n.length=0;var d=this._loadedCubeMaps;for(r=d.length,t=0;r>t;++t){var h=d[t];i=h.id;var m=h.images,p=H._textureCache.getTexture(this._texturePaths[i]);a(p)||(p=e.createCubeMap({source:{positiveX:m[0],negativeX:m[1],positiveY:m[2],negativeY:m[3],positiveZ:m[4],negativeZ:m[5]}}),H._textureCache.addTexture(this._texturePaths[i],p)),this._textures[i]=p}d.length=0;var f=this._updateFunctions;for(r=f.length,t=0;r>t;++t)f[t](this,e);var v=this.materials;for(var g in v)v.hasOwnProperty(g)&&v[g].update(e)},H.prototype.isDestroyed=function(){return!1},H.prototype.destroy=function(){var e=this.materials,t=this.uniforms;for(var i in t)if(t.hasOwnProperty(i)){var n=this._texturePaths[i];H._textureCache.releaseTexture(n)}for(var r in e)e.hasOwnProperty(r)&&e[r].destroy();return l(this)};var q=["type","materials","uniforms","components","source"],j=["diffuse","specular","shininess","normal","emission","alpha"],Y={mat2:h,mat3:m,mat4:p};return H._textureCache={_textures:{},addTexture:function(e,t){this._textures[e]={texture:t,count:1}},getTexture:function(e){var t=this._textures[e];return a(t)?(t.count++,t.texture):void 0},releaseTexture:function(e){var t=this._textures[e];a(t)&&0===--t.count&&(t.texture=t.texture&&t.texture.destroy(),this._textures[e]=void 0)}},H._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},H.DefaultImageId="czm_defaultImage",H.DefaultCubeMapId="czm_defaultCubeMap",H.ColorType="Color",H._materialCache.addMaterial(H.ColorType,{fabric:{type:H.ColorType,uniforms:{color:new i(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),H.ImageType="Image",H._materialCache.addMaterial(H.ImageType,{fabric:{type:H.ImageType,uniforms:{image:H.DefaultImageId,repeat:new e(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a"}},translucent:!0}),H.DiffuseMapType="DiffuseMap",H._materialCache.addMaterial(H.DiffuseMapType,{fabric:{type:H.DiffuseMapType,uniforms:{image:H.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),H.AlphaMapType="AlphaMap",H._materialCache.addMaterial(H.AlphaMapType,{fabric:{type:H.AlphaMapType,uniforms:{image:H.DefaultImageId,channel:"a",repeat:new e(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),H.SpecularMapType="SpecularMap",H._materialCache.addMaterial(H.SpecularMapType,{fabric:{type:H.SpecularMapType,uniforms:{image:H.DefaultImageId,channel:"r",repeat:new e(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),H.EmissionMapType="EmissionMap",H._materialCache.addMaterial(H.EmissionMapType,{fabric:{type:H.EmissionMapType,uniforms:{image:H.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),H.BumpMapType="BumpMap",H._materialCache.addMaterial(H.BumpMapType,{fabric:{type:H.BumpMapType,uniforms:{image:H.DefaultImageId,channel:"r",strength:.8,repeat:new e(1,1)},source:g},translucent:!1}),H.NormalMapType="NormalMap",H._materialCache.addMaterial(H.NormalMapType,{fabric:{type:H.NormalMapType,uniforms:{image:H.DefaultImageId,channels:"rgb",strength:.8,repeat:new e(1,1)},source:E},translucent:!1}),H.GridType="Grid",H._materialCache.addMaterial(H.GridType,{fabric:{type:H.GridType,uniforms:{color:new i(0,1,0,1),cellAlpha:.1,lineCount:new e(8,8),lineThickness:new e(1,1),lineOffset:new e(0,0)},source:w},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),H.StripeType="Stripe",H._materialCache.addMaterial(H.StripeType,{fabric:{type:H.StripeType,uniforms:{horizontal:!0,evenColor:new i(1,1,1,.5),oddColor:new i(0,0,1,.5),offset:0,repeat:5},source:P},translucent:function(e){var t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<0}}),H.CheckerboardType="Checkerboard",H._materialCache.addMaterial(H.CheckerboardType,{fabric:{type:H.CheckerboardType,uniforms:{lightColor:new i(1,1,1,.5),darkColor:new i(0,0,0,.5),repeat:new e(5,5)},source:_},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),H.DotType="Dot",H._materialCache.addMaterial(H.DotType,{fabric:{type:H.DotType,uniforms:{lightColor:new i(1,1,0,.75),darkColor:new i(0,1,1,.75),repeat:new e(5,5)},source:y},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),H.WaterType="Water",H._materialCache.addMaterial(H.WaterType,{fabric:{type:H.WaterType,uniforms:{baseWaterColor:new i(.2,.3,.6,1),blendColor:new i(0,1,.699,1),specularMap:H.DefaultImageId,normalMap:H.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:A},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<0}}),H.RimLightingType="RimLighting",H._materialCache.addMaterial(H.RimLightingType,{fabric:{type:H.RimLightingType,uniforms:{color:new i(1,0,0,.7),rimColor:new i(1,1,1,.4),width:.3},source:T},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<0}}),H.FadeType="Fade",H._materialCache.addMaterial(H.FadeType,{fabric:{type:H.FadeType,uniforms:{fadeInColor:new i(1,0,0,1),fadeOutColor:new i(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new e(.5,.5)},source:C},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<0}}),H.PolylineArrowType="PolylineArrow",H._materialCache.addMaterial(H.PolylineArrowType,{fabric:{type:H.PolylineArrowType,uniforms:{color:new i(1,1,1,1)},source:b},translucent:!0}),H.PolylineGlowType="PolylineGlow",H._materialCache.addMaterial(H.PolylineGlowType,{fabric:{type:H.PolylineGlowType,uniforms:{color:new i(0,.5,1,1),glowPower:.25},source:S},translucent:!0}),H.PolylineOutlineType="PolylineOutline",H._materialCache.addMaterial(H.PolylineOutlineType,{fabric:{type:H.PolylineOutlineType,uniforms:{color:new i(1,1,1,1),outlineColor:new i(1,0,0,1),outlineWidth:1},source:x},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),H}),define("Cesium/Scene/MaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/freezeObject","../Core/VertexFormat","../Shaders/Appearances/AllMaterialAppearanceFS","../Shaders/Appearances/AllMaterialAppearanceVS","../Shaders/Appearances/BasicMaterialAppearanceFS","../Shaders/Appearances/BasicMaterialAppearanceVS","../Shaders/Appearances/TexturedMaterialAppearanceFS","../Shaders/Appearances/TexturedMaterialAppearanceVS","./Appearance","./Material"],function(e,t,i,n,r,o,a,s,l,u,c,d,h){"use strict";var m=function(i){i=e(i,e.EMPTY_OBJECT);var n=e(i.translucent,!0),r=e(i.closed,!1),o=e(i.materialSupport,m.MaterialSupport.TEXTURED);this.material=t(i.material)?i.material:h.fromType(h.ColorType),this.translucent=n,this._vertexShaderSource=e(i.vertexShaderSource,o.vertexShaderSource),this._fragmentShaderSource=e(i.fragmentShaderSource,o.fragmentShaderSource),this._renderState=d.getDefaultRenderState(n,r,i.renderState),this._closed=r,this._materialSupport=o,this._vertexFormat=o.vertexFormat,this._flat=e(i.flat,!1),this._faceForward=e(i.faceForward,!r)};return i(m.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),m.prototype.getFragmentShaderSource=d.prototype.getFragmentShaderSource,m.prototype.isTranslucent=d.prototype.isTranslucent,m.prototype.getRenderState=d.prototype.getRenderState,m.MaterialSupport={BASIC:n({vertexFormat:r.POSITION_AND_NORMAL,vertexShaderSource:l,fragmentShaderSource:s}),TEXTURED:n({vertexFormat:r.POSITION_NORMAL_AND_ST,vertexShaderSource:c,fragmentShaderSource:u}),ALL:n({vertexFormat:r.ALL,vertexShaderSource:a,fragmentShaderSource:o})},m}),define("Cesium/Shaders/Appearances/PerInstanceColorAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\n\nvoid main()\n{\n    vec3 positionToEyeEC = -v_positionEC;\n    \n	vec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\n    normalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\n    \n    czm_materialInput materialInput;\n    materialInput.normalEC = normalEC;\n    materialInput.positionToEyeEC = positionToEyeEC;\n    czm_material material = czm_getDefaultMaterial(materialInput);\n    material.diffuse = v_color.rgb;\n    material.alpha = v_color.a;\n    \n    gl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n}\n"}),define("Cesium/Shaders/Appearances/PerInstanceColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\n\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\n\nvoid main() \n{\n    vec4 p = czm_computePosition();\n\n    v_positionEC = (czm_modelViewRelativeToEye * p).xyz;      // position in eye coordinates\n    v_normalEC = czm_normal * normal;                         // normal in eye coordinates\n    v_color = color;\n    \n    gl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),define("Cesium/Shaders/Appearances/PerInstanceFlatColorAppearanceFS",[],function(){"use strict";return"varying vec4 v_color;\n\nvoid main()\n{\n    gl_FragColor = v_color;\n}\n"}),define("Cesium/Shaders/Appearances/PerInstanceFlatColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\n\nvarying vec4 v_color;\n\nvoid main() \n{\n    vec4 p = czm_computePosition();\n\n    v_color = color;\n    \n    gl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),define("Cesium/Scene/PerInstanceColorAppearance",["../Core/defaultValue","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PerInstanceColorAppearanceFS","../Shaders/Appearances/PerInstanceColorAppearanceVS","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/Appearances/PerInstanceFlatColorAppearanceVS","./Appearance"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.translucent,!0),u=e(t.closed,!1),c=e(t.flat,!1),d=c?a:r,h=c?o:n,m=c?l.FLAT_VERTEX_FORMAT:l.VERTEX_FORMAT;this.material=void 0,this.translucent=i,this._vertexShaderSource=e(t.vertexShaderSource,d),this._fragmentShaderSource=e(t.fragmentShaderSource,h),this._renderState=s.getDefaultRenderState(i,u,t.renderState),this._closed=u,this._vertexFormat=m,this._flat=c,this._faceForward=e(t.faceForward,!u)};return t(l.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),l.VERTEX_FORMAT=i.POSITION_AND_NORMAL,l.FLAT_VERTEX_FORMAT=i.POSITION_ONLY,l.prototype.getFragmentShaderSource=s.prototype.getFragmentShaderSource,l.prototype.isTranslucent=s.prototype.isTranslucent,l.prototype.getRenderState=s.prototype.getRenderState,l}),define("Cesium/Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.value=t.value};return t}),define("Cesium/Core/subdivideArray",["./defined","./DeveloperError"],function(){"use strict";var e=function(e,t){for(var i=[],n=e.length,r=0;n>r;){var o=Math.ceil((n-r)/t--);i.push(e.slice(r,r+o)),r+=o}return i};return e}),define("Cesium/Core/TaskProcessor",["../ThirdParty/Uri","../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./destroyObject","./DeveloperError","./isCrossOriginUrl","./RuntimeError","require"],function(e,t,i,n,r,o,a,s,l,u){"use strict";function c(){if(!r(v._canTransferArrayBuffer)){var e=new Worker(h("Workers/transferTypedArrayTest.js"));
e.postMessage=n(e.webkitPostMessage,e.postMessage);var i=99,o=new Int8Array([i]);try{e.postMessage({array:o},[o.buffer])}catch(a){return v._canTransferArrayBuffer=!1,v._canTransferArrayBuffer}var s=t.defer();e.onmessage=function(t){var n=t.data.array,o=r(n)&&n[0]===i;s.resolve(o),e.terminate(),v._canTransferArrayBuffer=o},v._canTransferArrayBuffer=s.promise}return v._canTransferArrayBuffer}function d(e,t){--e._activeTasks;var i=t.id;if(r(i)){var n=e._deferreds,o=n[i];if(r(t.error)){var s=t.error;"RuntimeError"===s.name?(s=new l(t.error.message),s.stack=t.error.stack):"DeveloperError"===s.name&&(s=new a(t.error.message),s.stack=t.error.stack),o.reject(s)}else o.resolve(t.result);delete n[i]}}function h(e){var t=i(e);if(s(t)){var n,r='importScripts("'+t+'");';try{n=new Blob([r],{type:"application/javascript"})}catch(o){var a=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,l=new a;l.append(r),n=l.getBlob("application/javascript")}var u=window.URL||window.webkitURL;t=u.createObjectURL(n)}return t}function m(){return r(f)||(f=h("Workers/cesiumWorkerBootstrapper.js")),f}function p(t){var o=new Worker(m());o.postMessage=n(o.webkitPostMessage,o.postMessage);var a={loaderConfig:{},workerModule:v._workerModulePrefix+t._workerName};if(r(v._loaderConfig))a.loaderConfig=v._loaderConfig;else if(r(u.toUrl)){var s=new e("..").resolve(new e(i("Workers/cesiumWorkerBootstrapper.js"))).toString();a.loaderConfig.baseUrl=s}else a.loaderConfig.paths={Workers:i("Workers")};return o.postMessage(a),o.onmessage=function(e){d(t,e.data)},o}var f,v=function(e,t){this._workerName=e,this._maximumActiveTasks=n(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0},g=[];return v.prototype.scheduleTask=function(e,i){if(r(this._worker)||(this._worker=p(this)),this._activeTasks>=this._maximumActiveTasks)return void 0;++this._activeTasks;var n=this;return t(c(),function(o){r(i)?o||(i.length=0):i=g;var a=n._nextID++,s=t.defer();return n._deferreds[a]=s,n._worker.postMessage({id:a,parameters:e,canTransferArrayBuffer:o},i),s.promise})},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){return r(this._worker)&&this._worker.terminate(),o(this)},v._defaultWorkerModulePrefix="Workers/",v._workerModulePrefix=v._defaultWorkerModulePrefix,v._loaderConfig=void 0,v._canTransferArrayBuffer=void 0,v}),define("Cesium/Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,i){"use strict";var n=new t,r=new t,o=new t,a=function(a,s,l,u,c){i(c)||(c=new t);var d,h,m,p,f,v,g,_;i(s.z)?(d=t.subtract(l,s,n),h=t.subtract(u,s,r),m=t.subtract(a,s,o),p=t.dot(d,d),f=t.dot(d,h),v=t.dot(d,m),g=t.dot(h,h),_=t.dot(h,m)):(d=e.subtract(l,s,n),h=e.subtract(u,s,r),m=e.subtract(a,s,o),p=e.dot(d,d),f=e.dot(d,h),v=e.dot(d,m),g=e.dot(h,h),_=e.dot(h,m));var y=1/(p*g-f*f);return c.y=(g*v-f*_)*y,c.z=(p*_-f*v)*y,c.x=1-c.y-c.z,c};return a}),define("Cesium/Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function i(e,i,n){var r=e+i;return t.sign(e)!==t.sign(i)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(i)))<n?0:r}var n={};return n.computeDiscriminant=function(e,t,i){var n=t*t-4*e*i;return n},n.computeRealRoots=function(e,n,r){var o;if(0===e)return 0===n?[]:[-r/n];if(0===n){if(0===r)return[0,0];var a=Math.abs(r),s=Math.abs(e);if(s>a&&a/s<t.EPSILON14)return[0,0];if(a>s&&s/a<t.EPSILON14)return[];if(o=-r/e,0>o)return[];var l=Math.sqrt(o);return[-l,l]}if(0===r)return o=-n/e,0>o?[o,0]:[0,o];var u=n*n,c=4*e*r,d=i(u,-c,t.EPSILON14);if(0>d)return[];var h=-.5*i(n,t.sign(n)*Math.sqrt(d),t.EPSILON14);return n>0?[h/e,r/h]:[r/h,h/e]},n}),define("Cesium/Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function i(e,t,i,n){var r,o,a=e,s=t/3,l=i/3,u=n,c=a*l,d=s*u,h=s*s,m=l*l,p=a*l-h,f=a*u-s*l,v=s*u-m,g=4*p*v-f*f;if(0>g){var _,y,C;h*d>=c*m?(_=a,y=p,C=-2*s*p+a*f):(_=u,y=v,C=-u*f+2*l*v);var w=0>C?-1:1,E=-w*Math.abs(_)*Math.sqrt(-g);o=-C+E;var b=o/2,S=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),x=o===E?-S:-y/S;return r=0>=y?S+x:-C/(S*S+x*x+y),h*d>=c*m?[(r-s)/a]:[-u/(r+l)]}var T=p,P=-2*s*p+a*f,A=v,M=-u*f+2*l*v,I=Math.sqrt(g),D=Math.sqrt(3)/2,O=Math.abs(Math.atan2(a*I,-P)/3);r=2*Math.sqrt(-T);var R=Math.cos(O);o=r*R;var L=r*(-R/2-D*Math.sin(O)),N=o+L>2*s?o-s:L-s,z=a,F=N/z;O=Math.abs(Math.atan2(u*I,-M)/3),r=2*Math.sqrt(-A),R=Math.cos(O),o=r*R,L=r*(-R/2-D*Math.sin(O));var B=-u,V=2*l>o+L?o+l:L+l,k=B/V,U=z*V,W=-N*V-z*B,G=N*B,H=(l*W-s*G)/(-s*W+l*U);return H>=F?k>=F?k>=H?[F,H,k]:[F,k,H]:[k,F,H]:k>=F?[H,F,k]:k>=H?[H,k,F]:[k,H,F]}var n={};return n.computeDiscriminant=function(e,t,i,n){var r=e*e,o=t*t,a=i*i,s=n*n,l=18*e*t*i*n+o*a-27*r*s-4*(e*a*i+o*t*n);return l},n.computeRealRoots=function(e,n,r,o){var a,s;if(0===e)return t.computeRealRoots(n,r,o);if(0===n){if(0===r){if(0===o)return[0,0,0];s=-o/e;var l=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}return 0===o?(a=t.computeRealRoots(e,0,r),0===a.Length?[0]:[a[0],0,a[1]]):i(e,0,r,o)}return 0===r?0===o?(s=-n/e,0>s?[s,0,0]:[0,0,s]):i(e,n,0,o):0===o?(a=t.computeRealRoots(e,n,r),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):i(e,n,r,o)},n}),define("Cesium/Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,i,n){"use strict";function r(t,r,o,a){var s=t*t,l=r-3*s/8,u=o-r*t/2+s*t/8,c=a-o*t/4+r*s/16-3*s*s/256,d=e.computeRealRoots(1,2*l,l*l-4*c,-u*u);if(d.length>0){var h=-t/4,m=d[d.length-1];if(Math.abs(m)<i.EPSILON14){var p=n.computeRealRoots(1,l,c);if(2===p.length){var f,v=p[0],g=p[1];if(v>=0&&g>=0){var _=Math.sqrt(v),y=Math.sqrt(g);return[h-y,h-_,h+_,h+y]}if(v>=0&&0>g)return f=Math.sqrt(v),[h-f,h+f];if(0>v&&g>=0)return f=Math.sqrt(g),[h-f,h+f]}return[]}if(m>0){var C=Math.sqrt(m),w=(l+m-u/C)/2,E=(l+m+u/C)/2,b=n.computeRealRoots(1,C,w),S=n.computeRealRoots(1,-C,E);return 0!==b.length?(b[0]+=h,b[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,b[1]<=S[0]?[b[0],b[1],S[0],S[1]]:S[1]<=b[0]?[S[0],S[1],b[0],b[1]]:b[0]>=S[0]&&b[1]<=S[1]?[S[0],b[0],b[1],S[1]]:S[0]>=b[0]&&S[1]<=b[1]?[b[0],S[0],S[1],b[1]]:b[0]>S[0]&&b[0]<S[1]?[S[0],b[0],S[1],b[1]]:[b[0],S[0],b[1],S[1]]):b):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function o(t,r,o,a){var s=o*o,l=r*r,u=t*t,c=-2*r,d=o*t+l-4*a,h=u*a-o*r*t+s,m=e.computeRealRoots(1,c,d,h);if(m.length>0){var p,f,v=m[0],g=r-v,_=g*g,y=t/2,C=g/2,w=_-4*a,E=_+4*Math.abs(a),b=u-4*v,S=u+4*Math.abs(v);if(0>v||b*E>w*S){var x=Math.sqrt(b);p=x/2,f=0===x?0:(t*C-o)/x}else{var T=Math.sqrt(w);p=0===T?0:(t*C-o)/T,f=T/2}var P,A;0===y&&0===p?(P=0,A=0):i.sign(y)===i.sign(p)?(P=y+p,A=v/P):(A=y-p,P=v/A);var M,I;0===C&&0===f?(M=0,I=0):i.sign(C)===i.sign(f)?(M=C+f,I=a/M):(I=C-f,M=a/I);var D=n.computeRealRoots(1,P,M),O=n.computeRealRoots(1,A,I);if(0!==D.length)return 0!==O.length?D[1]<=O[0]?[D[0],D[1],O[0],O[1]]:O[1]<=D[0]?[O[0],O[1],D[0],D[1]]:D[0]>=O[0]&&D[1]<=O[1]?[O[0],D[0],D[1],O[1]]:O[0]>=D[0]&&O[1]<=D[1]?[D[0],O[0],O[1],D[1]]:D[0]>O[0]&&D[0]<O[1]?[O[0],D[0],O[1],D[1]]:[D[0],O[0],D[1],O[1]]:D;if(0!==O.length)return O}return[]}var a={};return a.computeDiscriminant=function(e,t,i,n,r){var o=e*e,a=o*e,s=t*t,l=s*t,u=i*i,c=u*i,d=n*n,h=d*n,m=r*r,p=m*r,f=s*u*d-4*l*h-4*e*c*d+18*e*t*i*h-27*o*d*d+256*a*p+r*(18*l*i*n-4*s*c+16*e*u*u-80*e*t*u*n-6*e*s*d+144*o*i*d)+m*(144*e*s*i-27*s*s-128*o*u-192*o*t*n);return f},a.computeRealRoots=function(t,n,a,s,l){if(Math.abs(t)<i.EPSILON15)return e.computeRealRoots(n,a,s,l);var u=n/t,c=a/t,d=s/t,h=l/t,m=0>u?1:0;switch(m+=0>c?m+1:m,m+=0>d?m+1:m,m+=0>h?m+1:m){case 0:return r(u,c,d,h);case 1:return o(u,c,d,h);case 2:return o(u,c,d,h);case 3:return r(u,c,d,h);case 4:return r(u,c,d,h);case 5:return o(u,c,d,h);case 6:return r(u,c,d,h);case 7:return r(u,c,d,h);case 8:return o(u,c,d,h);case 9:return r(u,c,d,h);case 10:return r(u,c,d,h);case 11:return o(u,c,d,h);case 12:return r(u,c,d,h);case 13:return r(u,c,d,h);case 14:return r(u,c,d,h);case 15:return r(u,c,d,h);default:return void 0}},a}),define("Cesium/Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,i){"use strict";var n=function(i,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(i,e.ZERO)),this.direction=n};return n.getPoint=function(t,n,r){return i(r)||(r=new e),r=e.multiplyByScalar(t.direction,n,r),e.add(t.origin,r,r)},n}),define("Cesium/Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,i,n,r,o,a,s,l,u){"use strict";function c(t,n,r,a,s){s=i(s,!1);var l,u,c,d,h,m=t.origin,p=t.direction,f=e.subtract(r,n,v),w=e.subtract(a,n,g),E=e.cross(p,w,_),b=e.dot(f,E);if(s){if(b<o.EPSILON6)return void 0;if(l=e.subtract(m,n,y),c=e.dot(l,E),0>c||c>b)return void 0;if(u=e.cross(l,f,C),d=e.dot(p,u),0>d||c+d>b)return void 0;h=e.dot(w,u)/b}else{if(Math.abs(b)<o.EPSILON6)return void 0;var S=1/b;if(l=e.subtract(m,n,y),c=e.dot(l,E)*S,0>c||c>1)return void 0;if(u=e.cross(l,f,C),d=e.dot(p,u)*S,0>d||c+d>1)return void 0;h=e.dot(w,u)*S}return h}function d(e,t,i,n){var r=t*t-4*e*i;if(0>r)return void 0;if(r>0){var o=1/(2*e),a=Math.sqrt(r),s=(-t+a)*o,l=(-t-a)*o;return l>s?(n.root0=s,n.root1=l):(n.root0=l,n.root1=s),n}var u=-t/(2*e);return 0===u?void 0:(n.root0=n.root1=u,n)}function h(t,i,r){n(r)||(r={});var o=t.origin,a=t.direction,s=i.center,l=i.radius*i.radius,u=e.subtract(o,s,_),c=e.dot(a,a),h=2*e.dot(a,u),m=e.magnitudeSquared(u)-l,p=d(c,h,m,E);return n(p)?(r.start=p.root0,r.stop=p.root1,r):void 0}function m(e,t,i){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<i?0:n}function p(t,i,n,r,u){var c,d=r*r,h=u*u,p=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*h,f=u*(r*m(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],o.EPSILON15)+i.y),v=t[a.COLUMN0ROW0]*d+t[a.COLUMN2ROW2]*h+r*i.x+n,g=h*m(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],o.EPSILON15),_=u*(r*m(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+i.z),y=[];if(0===_&&0===g){if(c=s.computeRealRoots(p,f,v),0===c.length)return y;var C=c[0],w=Math.sqrt(Math.max(1-C*C,0));if(y.push(new e(r,u*C,u*-w)),y.push(new e(r,u*C,u*w)),2===c.length){var E=c[1],b=Math.sqrt(Math.max(1-E*E,0));y.push(new e(r,u*E,u*-b)),y.push(new e(r,u*E,u*b))}return y}var S=_*_,x=g*g,T=p*p,P=_*g,A=T+x,M=2*(f*p+P),I=2*v*p+f*f-x+S,D=2*(v*f-P),O=v*v-S;if(0===A&&0===M&&0===I&&0===D)return y;c=l.computeRealRoots(A,M,I,D,O);var R=c.length;if(0===R)return y;for(var L=0;R>L;++L){var N,z=c[L],F=z*z,B=Math.max(1-F,0),V=Math.sqrt(B);N=o.sign(p)===o.sign(v)?m(p*F+v,f*z,o.EPSILON12):o.sign(v)===o.sign(f*z)?m(p*F,f*z+v,o.EPSILON12):m(p*F+f*z,v,o.EPSILON12);var k=m(g*z,_,o.EPSILON15),U=N*k;0>U?y.push(new e(r,u*z,u*V)):U>0?y.push(new e(r,u*z,u*-V)):0!==V?(y.push(new e(r,u*z,u*-V)),y.push(new e(r,u*z,u*V)),++L):y.push(new e(r,u*z,u*V))}return y}var f={};f.rayPlane=function(t,i,r){n(r)||(r=new e);var a=t.origin,s=t.direction,l=i.normal,u=e.dot(l,s);if(Math.abs(u)<o.EPSILON15)return void 0;var c=(-i.distance-e.dot(l,a))/u;return 0>c?void 0:(r=e.multiplyByScalar(s,c,r),e.add(a,r,r))};var v=new e,g=new e,_=new e,y=new e,C=new e;f.rayTriangle=function(t,i,r,o,a,s){var l=c(t,i,r,o,a);return!n(l)||0>l?void 0:(n(s)||(s=new e),e.multiplyByScalar(t.direction,l,s),e.add(t.origin,s,s))};var w=new u;f.lineSegmentTriangle=function(t,i,r,o,a,s,l){var u=w;e.clone(t,u.origin),e.subtract(i,t,u.direction),e.normalize(u.direction,u.direction);var d=c(u,r,o,a,s);return!n(d)||0>d||d>e.distance(t,i)?void 0:(n(l)||(l=new e),e.multiplyByScalar(u.direction,d,l),e.add(u.origin,l,l))};var E={root0:0,root1:0};f.raySphere=function(e,t,i){return i=h(e,t,i),!n(i)||i.stop<0?void 0:(i.start=Math.max(i.start,0),i)};var b=new u;f.lineSegmentSphere=function(t,i,r,o){var a=b;e.clone(t,a.origin);var s=e.subtract(i,t,a.direction),l=e.magnitude(s);return e.normalize(s,s),o=h(a,r,o),!n(o)||o.stop<0||o.start>l?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,l),o)};var S=new e,x=new e;f.rayEllipsoid=function(t,i){var n,r,o,a,s,l=i.oneOverRadii,u=e.multiplyComponents(l,t.origin,S),c=e.multiplyComponents(l,t.direction,x),d=e.magnitudeSquared(u),h=e.dot(u,c);if(d>1){if(h>=0)return void 0;var m=h*h;if(n=d-1,r=e.magnitudeSquared(c),o=r*n,o>m)return void 0;if(m>o){a=h*h-o,s=-h+Math.sqrt(a);var p=s/r,f=n/s;return f>p?{start:p,stop:f}:{start:f,stop:p}}var v=Math.sqrt(n/r);return{start:v,stop:v}}return 1>d?(n=d-1,r=e.magnitudeSquared(c),o=r*n,a=h*h-o,s=-h+Math.sqrt(a),{start:0,stop:s/r}):0>h?(r=e.magnitudeSquared(c),{start:0,stop:-h/r}):void 0};var T=new e,P=new e,A=new e,M=new e,I=new e,D=new a,O=new a,R=new a,L=new a,N=new a,z=new a,F=new a,B=new e,V=new e,k=new t;f.grazingAltitudeLocation=function(t,i){var r=t.origin,s=t.direction,l=i.geodeticSurfaceNormal(r,T);if(e.dot(s,l)>=0)return r;var u=n(this.rayEllipsoid(t,i)),c=i.transformPositionToScaledSpace(s,T),d=e.normalize(c,c),h=e.mostOrthogonalAxis(c,M),m=e.normalize(e.cross(h,d,P),P),f=e.normalize(e.cross(d,m,A),A),v=D;v[0]=d.x,v[1]=d.y,v[2]=d.z,v[3]=m.x,v[4]=m.y,v[5]=m.z,v[6]=f.x,v[7]=f.y,v[8]=f.z;var g=a.transpose(v,O),_=a.fromScale(i.radii,R),y=a.fromScale(i.oneOverRadii,L),C=N;C[0]=0,C[1]=-s.z,C[2]=s.y,C[3]=s.z,C[4]=0,C[5]=-s.x,C[6]=-s.y,C[7]=s.x,C[8]=0;var w,E,b=a.multiply(a.multiply(g,y,z),C,z),S=a.multiply(a.multiply(b,_,F),v,F),x=a.multiplyByVector(b,r,I),U=p(S,e.negate(x,T),0,0,1),W=U.length;if(W>0){for(var G=e.clone(e.ZERO,V),H=Number.NEGATIVE_INFINITY,q=0;W>q;++q){w=a.multiplyByVector(_,a.multiplyByVector(v,U[q],B),B);var j=e.normalize(e.subtract(w,r,M),M),Y=e.dot(j,s);Y>H&&(H=Y,G=e.clone(w,G))}var X=i.cartesianToCartographic(G,k);return H=o.clamp(H,0,1),E=e.magnitude(e.subtract(G,r,M))*Math.sqrt(1-H*H),E=u?-E:E,X.height=E,i.cartographicToCartesian(X,new e)}return void 0};var U=new e;return f.lineSegmentPlane=function(t,i,r,a){n(a)||(a=new e);var s=e.subtract(i,t,U),l=r.normal,u=e.dot(l,s);if(Math.abs(u)<o.EPSILON6)return void 0;var c=e.dot(l,t),d=-(r.distance+c)/u;return 0>d||d>1?void 0:(e.multiplyByScalar(s,d,a),e.add(t,a,a),a)},f.trianglePlaneIntersection=function(t,i,n,r){var o=r.normal,a=r.distance,s=e.dot(o,t)+a<0,l=e.dot(o,i)+a<0,u=e.dot(o,n)+a<0,c=0;c+=s?1:0,c+=l?1:0,c+=u?1:0;var d,h;if((1===c||2===c)&&(d=new e,h=new e),1===c){if(s)return f.lineSegmentPlane(t,i,r,d),f.lineSegmentPlane(t,n,r,h),{positions:[t,i,n,d,h],indices:[0,3,4,1,2,4,1,4,3]};if(l)return f.lineSegmentPlane(i,n,r,d),f.lineSegmentPlane(i,t,r,h),{positions:[t,i,n,d,h],indices:[1,3,4,2,0,4,2,4,3]};if(u)return f.lineSegmentPlane(n,t,r,d),f.lineSegmentPlane(n,i,r,h),{positions:[t,i,n,d,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===c){if(!s)return f.lineSegmentPlane(i,t,r,d),f.lineSegmentPlane(n,t,r,h),{positions:[t,i,n,d,h],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return f.lineSegmentPlane(n,i,r,d),f.lineSegmentPlane(t,i,r,h),{positions:[t,i,n,d,h],indices:[2,0,4,2,4,3,1,3,4]};if(!u)return f.lineSegmentPlane(t,n,r,d),f.lineSegmentPlane(i,n,r,h),{positions:[t,i,n,d,h],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},f}),define("Cesium/Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var i=function(t,i){this.normal=e.clone(t),this.distance=i};return i.fromPointNormal=function(n,r,o){var a=-e.dot(r,n);return t(o)?(e.clone(r,o.normal),o.distance=a,o):new i(r,a)},i.getPointDistance=function(t,i){return e.dot(t.normal,i)+t.distance},i}),define("Cesium/Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var i={};return i.calculateACMR=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.indices,r=i.maximumIndex,o=e(i.cacheSize,24),a=n.length;if(!t(r)){r=0;for(var s=0,l=n[s];a>s;)l>r&&(r=l),++s,l=n[s]}for(var u=[],c=0;r+1>c;c++)u[c]=0;for(var d=o+1,h=0;a>h;++h)d-u[n[h]]>o&&(u[n[h]]=d,++d);return(d-o+1)/(a/3)},i.tipsify=function(i){function n(e,t,i,n){for(;t.length>=1;){var r=t[t.length-1];if(t.splice(t.length-1,1),e[r].numLiveTriangles>0)return r}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function r(e,t,i,r,o,a,s){for(var l,u=-1,c=-1,d=0;d<i.length;){var h=i[d];r[h].numLiveTriangles&&(l=0,o-r[h].timeStamp+2*r[h].numLiveTriangles<=t&&(l=o-r[h].timeStamp),(l>c||-1===c)&&(c=l,u=h)),++d}return-1===u?n(r,a,e,s):u}i=e(i,e.EMPTY_OBJECT);var o,a=i.indices,s=i.maximumIndex,l=e(i.cacheSize,24),u=a.length,c=0,d=0,h=a[d],m=u;if(t(s))c=s+1;else{for(;m>d;)h>c&&(c=h),++d,h=a[d];if(-1===c)return 0;++c}for(var p=[],f=0;c>f;f++)p[f]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};d=0;for(var v=0;m>d;)p[a[d]].vertexTriangles.push(v),++p[a[d]].numLiveTriangles,p[a[d+1]].vertexTriangles.push(v),++p[a[d+1]].numLiveTriangles,p[a[d+2]].vertexTriangles.push(v),++p[a[d+2]].numLiveTriangles,++v,d+=3;var g=0,_=l+1;o=1;var y,C,w=[],E=[],b=0,S=[],x=u/3,T=[];for(f=0;x>f;f++)T[f]=!1;for(var P,A;-1!==g;){w=[],C=p[g],A=C.vertexTriangles.length;for(var M=0;A>M;++M)if(v=C.vertexTriangles[M],!T[v]){T[v]=!0,d=v+v+v;for(var I=0;3>I;++I)P=a[d],w.push(P),E.push(P),S[b]=P,++b,y=p[P],--y.numLiveTriangles,_-y.timeStamp>l&&(y.timeStamp=_,++_),++d}g=r(a,l,w,p,_,E,c)}return S},i}),define("Cesium/Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x){"use strict";function T(e,t,i,n,r){e[t++]=i,e[t++]=n,e[t++]=n,e[t++]=r,e[t++]=r,e[t]=i}function P(e){for(var t=e.length,i=6*(t/3),n=g.createTypedArray(t,i),r=0,o=0;t>o;o+=3,r+=6)T(n,r,e[o],e[o+1],e[o+2]);return n}function A(e){var t=e.length;if(t>=3){var i=6*(t-2),n=g.createTypedArray(t,i);T(n,0,e[0],e[1],e[2]);for(var r=6,o=3;t>o;++o,r+=6)T(n,r,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function M(e){if(e.length>0){for(var t=e.length-1,i=6*(t-1),n=g.createTypedArray(t,i),r=e[0],o=0,a=1;t>a;++a,o+=6)T(n,o,r,e[a],e[a+1]);return n}return new Uint16Array}function I(e){var t={};for(var i in e)if(e.hasOwnProperty(i)&&u(e[i])&&u(e[i].values)){var n=e[i];t[i]=new p({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function D(e,t,i){for(var n in t)if(t.hasOwnProperty(n)&&u(t[n])&&u(t[n].values))for(var r=t[n],o=0;o<r.componentsPerAttribute;++o)e[n].values.push(r.values[i*r.componentsPerAttribute+o])}function O(e,t){if(u(t))for(var i=t.values,n=i.length,o=0;n>o;o+=3)r.unpack(i,o,ot),E.multiplyByPoint(e,ot,ot),r.pack(ot,i,o)}function R(e,t){if(u(t))for(var i=t.values,n=i.length,o=0;n>o;o+=3)r.unpack(i,o,ot),w.multiplyByVector(e,ot,ot),ot=r.normalize(ot,ot),r.pack(ot,i,o)}function L(e,t){var i,n=e.length,r={},o=e[0][t].attributes;for(i in o)if(o.hasOwnProperty(i)&&u(o[i])&&u(o[i].values)){for(var a=o[i],l=a.values.length,c=!0,d=1;n>d;++d){var h=e[d][t].attributes[i];if(!u(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){c=!1;break}l+=h.values.length}c&&(r[i]=new p({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:s.createTypedArray(a.componentDatatype,l)}))}return r}function N(e,t){var n,o,a,s,l=e.length;e[0].modelMatrix;var c,d,h,p=u(e[0][t].indices),f=e[0][t].primitiveType,v=L(e,t);for(n in v)if(v.hasOwnProperty(n))for(c=v[n].values,s=0,o=0;l>o;++o)for(d=e[o][t].attributes[n].values,h=d.length,a=0;h>a;++a)c[s++]=d[a];var _;if(p){var y=0;for(o=0;l>o;++o)y+=e[o][t].indices.length;var C=m.computeNumberOfVertices(new m({attributes:v,primitiveType:S.POINTS})),w=g.createTypedArray(C,y),E=0,b=0;for(o=0;l>o;++o){var x=e[o][t].indices,T=x.length;for(s=0;T>s;++s)w[E++]=b+x[s];b+=m.computeNumberOfVertices(e[o][t])}_=w}var P,A=new r,M=0;for(o=0;l>o;++o){if(P=e[o][t].boundingSphere,!u(P)){A=void 0;break}r.add(P.center,A,A)}if(u(A))for(r.divideByScalar(A,l,A),o=0;l>o;++o){P=e[o][t].boundingSphere;var I=r.magnitude(r.subtract(P.center,A,lt))+P.radius;I>M&&(M=I)}return new m({attributes:v,indices:_,primitiveType:f,boundingSphere:u(A)?new i(A,M):void 0})}function z(e){if(u(e.indices))return e;for(var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,t),n=0;t>n;++n)i[n]=n;return e.indices=i,e}function F(e){var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,3*(t-2));i[0]=1,i[1]=0,i[2]=2;for(var n=3,r=3;t>r;++r)i[n++]=r-1,i[n++]=0,i[n++]=r;return e.indices=i,e.primitiveType=S.TRIANGLES,e}function B(e){var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,3*(t-2));i[0]=0,i[1]=1,i[2]=2,t>3&&(i[3]=0,i[4]=2,i[5]=3);for(var n=6,r=3;t-1>r;r+=2)i[n++]=r,i[n++]=r-1,i[n++]=r+1,t>r+2&&(i[n++]=r,i[n++]=r+1,i[n++]=r+2);return e.indices=i,e.primitiveType=S.TRIANGLES,e}function V(e){if(u(e.indices))return e;for(var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,t),n=0;t>n;++n)i[n]=n;return e.indices=i,e}function k(e){var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,2*(t-1));i[0]=0,i[1]=1;for(var n=2,r=2;t>r;++r)i[n++]=r-1,i[n++]=r;return e.indices=i,e.primitiveType=S.LINES,e}function U(e){var t=m.computeNumberOfVertices(e),i=g.createTypedArray(t,2*t);i[0]=0,i[1]=1;for(var n=2,r=2;t>r;++r)i[n++]=r-1,i[n++]=r;return i[n++]=t-1,i[n]=0,e.indices=i,e.primitiveType=S.LINES,e}function W(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return F(e);case S.TRIANGLE_STRIP:return B(e);case S.TRIANGLES:return z(e);case S.LINE_STRIP:return k(e);case S.LINE_LOOP:return U(e);case S.LINES:return V(e)}return e}function G(e,t){Math.abs(e.y)<C.EPSILON6&&(e.y=t?-C.EPSILON6:C.EPSILON6)}function H(e,t,i){if(0!==e.y&&0!==t.y&&0!==i.y)return G(e,e.y<0),G(t,t.y<0),G(i,i.y<0),void 0;var n,r=Math.abs(e.y),o=Math.abs(t.y),a=Math.abs(i.y);n=r>o?r>a?C.sign(e.y):C.sign(i.y):o>a?C.sign(t.y):C.sign(i.y);var s=0>n;G(e,s),G(t,s),G(i,s)}function q(e,t,i,n){r.add(e,r.multiplyByScalar(r.subtract(t,e,Ct),e.y/(e.y-t.y),Ct),i),r.clone(i,n),G(i,!0),G(n,!1)}function j(e,t,i){if(e.x>=0||t.x>=0||i.x>=0)return void 0;H(e,t,i);var n=e.y<0,r=t.y<0,o=i.y<0,a=0;a+=n?1:0,a+=r?1:0,a+=o?1:0;var s=xt.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(q(e,t,wt,bt),q(e,i,Et,St),s[0]=0,s[3]=1,s[4]=2,s[6]=1):r?(q(t,i,wt,bt),q(t,e,Et,St),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(q(i,e,wt,bt),q(i,t,Et,St),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?r?o||(q(i,e,wt,bt),q(i,t,Et,St),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(q(t,i,wt,bt),q(t,e,Et,St),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(q(e,t,wt,bt),q(e,i,Et,St),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var l=xt.positions;return l[0]=e,l[1]=t,l[2]=i,l.length=3,(1===a||2===a)&&(l[3]=wt,l[4]=Et,l[5]=bt,l[6]=St,l.length=7),xt}function Y(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var r in n)if(n.hasOwnProperty(r)&&u(n[r])&&u(n[r].values)){var o=n[r];o.values=s.createTypedArray(o.componentDatatype,o.values)}var a=m.computeNumberOfVertices(e);return e.indices=g.createTypedArray(a,e.indices),t&&(e.boundingSphere=i.fromVertices(n.position.values)),e}function X(e){var t=e.attributes,i={};for(var n in t)if(t.hasOwnProperty(n)&&u(t[n])&&u(t[n].values)){var r=t[n];i[n]=new p({componentDatatype:r.componentDatatype,componentsPerAttribute:r.componentsPerAttribute,normalize:r.normalize,values:[]})}return new m({attributes:i,indices:[],primitiveType:e.primitiveType})}function Z(e,t,i){var n=u(e.geometry.boundingSphere);t=Y(t,n),i=Y(i,n),u(i)&&!u(t)?e.geometry=i:!u(i)&&u(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=i,e.geometry=void 0)}function J(e,i,o,a,s,l,c,d,h,m,p){if(u(l)||u(c)||u(d)||u(h)){var f=r.fromArray(s,3*e,Tt),v=r.fromArray(s,3*i,Pt),g=r.fromArray(s,3*o,At),_=t(a,f,v,g,Mt);if(u(l)){var y=r.fromArray(l,3*e,Tt),C=r.fromArray(l,3*i,Pt),w=r.fromArray(l,3*o,At);r.multiplyByScalar(y,_.x,y),r.multiplyByScalar(C,_.y,C),r.multiplyByScalar(w,_.z,w);var E=r.add(y,C,y);r.add(E,w,E),r.normalize(E,E),r.pack(E,m.normal.values,3*p)}if(u(c)){var b=r.fromArray(c,3*e,Tt),S=r.fromArray(c,3*i,Pt),x=r.fromArray(c,3*o,At);r.multiplyByScalar(b,_.x,b),r.multiplyByScalar(S,_.y,S),r.multiplyByScalar(x,_.z,x);var T=r.add(b,S,b);r.add(T,x,T),r.normalize(T,T),r.pack(T,m.binormal.values,3*p)}if(u(d)){var P=r.fromArray(d,3*e,Tt),A=r.fromArray(d,3*i,Pt),M=r.fromArray(d,3*o,At);r.multiplyByScalar(P,_.x,P),r.multiplyByScalar(A,_.y,A),r.multiplyByScalar(M,_.z,M);var I=r.add(P,A,P);r.add(I,M,I),r.normalize(I,I),r.pack(I,m.tangent.values,3*p)}if(u(h)){var D=n.fromArray(h,2*e,It),O=n.fromArray(h,2*i,Dt),R=n.fromArray(h,2*o,Ot);n.multiplyByScalar(D,_.x,D),n.multiplyByScalar(O,_.y,O),n.multiplyByScalar(R,_.z,R);var L=n.add(D,O,D);n.add(L,R,L),n.pack(L,m.st.values,2*p)}}}function K(e,t,i,n,r,o){var a=e.position.values.length/3;if(-1!==r){var s=n[r],l=i[s];return-1===l?(i[s]=a,e.position.values.push(o.x,o.y,o.z),t.push(a),a):(t.push(l),l)}return e.position.values.push(o.x,o.y,o.z),t.push(a),a}function Q(e){var t,i,n,o,a,s=e.geometry,l=s.attributes,c=l.position.values,d=u(l.normal)?l.normal.values:void 0,h=u(l.binormal)?l.binormal.values:void 0,m=u(l.tangent)?l.tangent.values:void 0,p=u(l.st)?l.st.values:void 0,f=s.indices,v=X(s),g=X(s),_=[];_.length=c.length/3;var y=[];for(y.length=c.length/3,a=0;a<_.length;++a)_[a]=-1,y[a]=-1;var C=f.length;for(a=0;C>a;a+=3){var w=f[a],E=f[a+1],b=f[a+2],S=r.fromArray(c,3*w),x=r.fromArray(c,3*E),T=r.fromArray(c,3*b),P=j(S,x,T);if(u(P)&&P.positions.length>3)for(var A=P.positions,M=P.indices,I=M.length,D=0;I>D;++D){var O=M[D],R=A[O];R.y<0?(t=g.attributes,i=g.indices,n=_):(t=v.attributes,i=v.indices,n=y),o=K(t,i,n,f,3>O?a+O:-1,R),J(w,E,b,R,c,d,h,m,p,t,o)}else u(P)&&(S=P.positions[0],x=P.positions[1],T=P.positions[2]),S.y<0?(t=g.attributes,i=g.indices,n=_):(t=v.attributes,i=v.indices,n=y),o=K(t,i,n,f,a,S),J(w,E,b,S,c,d,h,m,p,t,o),o=K(t,i,n,f,a+1,x),J(w,E,b,x,c,d,h,m,p,t,o),o=K(t,i,n,f,a+2,T),J(w,E,b,T,c,d,h,m,p,t,o)}Z(e,g,v)}function $(e){var t,i=e.geometry,n=i.attributes,o=n.position.values,a=i.indices,s=X(i),l=X(i),c=a.length,d=[];d.length=o.length/3;var h=[];for(h.length=o.length/3,t=0;t<d.length;++t)d[t]=-1,h[t]=-1;for(t=0;c>t;t+=2){var m=a[t],p=a[t+1],f=r.fromArray(o,3*m,Tt),v=r.fromArray(o,3*p,Pt);Math.abs(f.y)<C.EPSILON6&&(f.y=f.y<0?-C.EPSILON6:C.EPSILON6),Math.abs(v.y)<C.EPSILON6&&(v.y=v.y<0?-C.EPSILON6:C.EPSILON6);var g=s.attributes,_=s.indices,w=h,E=l.attributes,b=l.indices,S=d,x=y.lineSegmentPlane(f,v,Rt,At);if(u(x)){var T=r.multiplyByScalar(r.UNIT_Y,5*C.EPSILON9,Lt);f.y<0&&(r.negate(T,T),g=l.attributes,_=l.indices,w=d,E=s.attributes,b=s.indices,S=h);var P=r.add(x,T,Nt);K(g,_,w,a,t,f),K(g,_,w,a,-1,P),r.negate(T,T),r.add(x,T,P),K(E,b,S,a,-1,P),K(E,b,S,a,t+1,v)}else{var A,M,I;f.y<0?(A=l.attributes,M=l.indices,I=d):(A=s.attributes,M=s.indices,I=h),K(A,M,I,a,t,f),K(A,M,I,a,t+1,v)}}Z(e,l,s)}function et(e){var t=e.geometry,i=t.attributes,a=i.position.values,s=i.prevPosition.values,l=i.nextPosition.values,c=i.expandAndWidth.values;t.indices;var d,h,m,p=u(i.st)?i.st.values:void 0,f=u(i.color)?i.color.values:void 0,v=X(t),g=X(t),_=a.length/3;for(d=0;_>d;d+=4){var w=d,E=d+1,b=d+2,S=d+3,x=r.fromArray(a,3*w,Bt),T=r.fromArray(a,3*E,Vt),P=r.fromArray(a,3*b,kt),A=r.fromArray(a,3*S,Ut);Math.abs(x.y)<C.EPSILON6&&(x.y=C.EPSILON6*(P.y<0?-1:1),T.y=x.y),Math.abs(P.y)<C.EPSILON6&&(P.y=C.EPSILON6*(x.y<0?-1:1),A.y=P.y);var M=v.attributes,I=v.indices,D=g.attributes,O=g.indices,R=y.lineSegmentPlane(x,P,Rt,Wt);if(u(R)){var L=r.multiplyByScalar(r.UNIT_Y,5*C.EPSILON9,Gt);x.y<0&&(r.negate(L,L),M=g.attributes,I=g.indices,D=v.attributes,O=v.indices);var N=r.add(R,L,Ht);for(M.position.values.push(x.x,x.y,x.z,T.x,T.y,T.z),M.position.values.push(N.x,N.y,N.z),M.position.values.push(N.x,N.y,N.z),r.negate(L,L),r.add(R,L,N),D.position.values.push(N.x,N.y,N.z),D.position.values.push(N.x,N.y,N.z),D.position.values.push(P.x,P.y,P.z,A.x,A.y,A.z),h=3*w;3*w+6>h;++h)M.prevPosition.values.push(s[h]);for(M.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),D.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),h=3*b;3*b+6>h;++h)D.prevPosition.values.push(s[h]);for(h=3*w;3*w+6>h;++h)M.nextPosition.values.push(l[h]);for(M.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),D.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),h=3*b;3*b+6>h;++h)D.nextPosition.values.push(l[h]);var z=n.fromArray(c,2*w,zt),F=Math.abs(z.y);M.expandAndWidth.values.push(-1,F,1,F),M.expandAndWidth.values.push(-1,-F,1,-F),D.expandAndWidth.values.push(-1,F,1,F),D.expandAndWidth.values.push(-1,-F,1,-F);var B=r.magnitudeSquared(r.subtract(R,x,Ut));if(B/=r.magnitudeSquared(r.subtract(P,x,Ut)),u(f)){var V=o.fromArray(f,4*w,qt),k=o.fromArray(f,4*b,qt),U=C.lerp(V.x,k.x,B),W=C.lerp(V.y,k.y,B),G=C.lerp(V.z,k.z,B),H=C.lerp(V.w,k.w,B);for(h=4*w;4*w+8>h;++h)M.color.values.push(f[h]);for(M.color.values.push(U,W,G,H),M.color.values.push(U,W,G,H),D.color.values.push(U,W,G,H),D.color.values.push(U,W,G,H),h=4*b;4*b+8>h;++h)D.color.values.push(f[h])}if(u(p)){var q=n.fromArray(p,2*w,zt),j=n.fromArray(p,2*(d+3),Ft),Y=C.lerp(q.x,j.x,B);for(h=2*w;2*w+4>h;++h)M.st.values.push(p[h]);for(M.st.values.push(Y,q.y),M.st.values.push(Y,j.y),D.st.values.push(Y,q.y),D.st.values.push(Y,j.y),h=2*b;2*b+4>h;++h)D.st.values.push(p[h])}m=M.position.values.length/3-4,I.push(m,m+2,m+1),I.push(m+1,m+2,m+3),m=D.position.values.length/3-4,O.push(m,m+2,m+1),O.push(m+1,m+2,m+3)}else{var J,K;for(x.y<0?(J=g.attributes,K=g.indices):(J=v.attributes,K=v.indices),J.position.values.push(x.x,x.y,x.z),J.position.values.push(T.x,T.y,T.z),J.position.values.push(P.x,P.y,P.z),J.position.values.push(A.x,A.y,A.z),h=3*d;3*d+12>h;++h)J.prevPosition.values.push(s[h]),J.nextPosition.values.push(l[h]);for(h=2*d;2*d+8>h;++h)J.expandAndWidth.values.push(c[h]),u(p)&&J.st.values.push(p[h]);if(u(f))for(h=4*d;4*d+16>h;++h)J.color.values.push(f[h]);m=J.position.values.length/3-4,K.push(m,m+2,m+1),K.push(m+1,m+2,m+3)}}Z(e,g,v)}var tt={};tt.toWireframe=function(e){var t=e.indices;if(u(t)){switch(e.primitiveType){case S.TRIANGLES:e.indices=P(t);break;case S.TRIANGLE_STRIP:e.indices=A(t);break;case S.TRIANGLE_FAN:e.indices=M(t);break;default:throw new c("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=S.LINES}return e},tt.createLineSegmentsForVectors=function(e,t,n){t=l(t,"normal"),n=l(n,1e4);for(var r=e.attributes.position.values,o=e.attributes[t].values,a=r.length,c=new Float64Array(2*a),d=0,h=0;a>h;h+=3)c[d++]=r[h],c[d++]=r[h+1],c[d++]=r[h+2],c[d++]=r[h]+o[h]*n,c[d++]=r[h+1]+o[h+1]*n,c[d++]=r[h+2]+o[h+2]*n;var f,v=e.boundingSphere;return u(v)&&(f=new i(v.center,v.radius+n)),new m({attributes:{position:new p({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:S.LINES,boundingSphere:f})},tt.createAttributeLocations=function(e){var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,r={},o=0,a=i.length;for(t=0;a>t;++t){var s=i[t];u(n[s])&&(r[s]=o++)}for(var l in n)n.hasOwnProperty(l)&&!u(r[l])&&(r[l]=o++);return r},tt.reorderForPreVertexCache=function(e){var t=m.computeNumberOfVertices(e),i=e.indices;if(u(i)){for(var n=new Int32Array(t),r=0;t>r;r++)n[r]=-1;for(var o,a=i,l=a.length,c=g.createTypedArray(t,l),d=0,h=0,p=0;l>d;)o=n[a[d]],-1!==o?c[h]=o:(o=a[d],n[o]=p,c[h]=p,++p),++d,++h;e.indices=c;var f=e.attributes;for(var v in f)if(f.hasOwnProperty(v)&&u(f[v])&&u(f[v].values)){for(var _=f[v],y=_.values,C=0,w=_.componentsPerAttribute,E=s.createTypedArray(_.componentDatatype,p*w);t>C;){var b=n[C];if(-1!==b)for(r=0;w>r;r++)E[w*b+r]=y[w*C+r];++C}_.values=E}}return e},tt.reorderForPostVertexCache=function(e,t){var i=e.indices;if(e.primitiveType===S.TRIANGLES&&u(i)){for(var n=i.length,r=0,o=0;n>o;o++)i[o]>r&&(r=i[o]);e.indices=x.tipsify({indices:i,maximumIndex:r,cacheSize:t})}return e},tt.fitToUnsignedShortIndices=function(e){var t=[],i=m.computeNumberOfVertices(e);if(u(e.indices)&&i>C.SIXTY_FOUR_KILOBYTES){var n,r=[],o=[],a=0,s=I(e.attributes),l=e.indices,c=l.length;
e.primitiveType===S.TRIANGLES?n=3:e.primitiveType===S.LINES?n=2:e.primitiveType===S.POINTS&&(n=1);for(var d=0;c>d;d+=n){for(var h=0;n>h;++h){var p=l[d+h],f=r[p];u(f)||(f=a++,r[p]=f,D(s,e.attributes,p)),o.push(f)}a+n>C.SIXTY_FOUR_KILOBYTES&&(t.push(new m({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),r=[],o=[],a=0,s=I(e.attributes))}0!==o.length&&t.push(new m({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var it=new r,nt=new a;tt.projectTo2D=function(e,t,i,n,o){var a=e.attributes[t];o=u(o)?o:new h;for(var l=o.ellipsoid,d=a.values,m=new Float64Array(d.length),f=0,v=0;v<d.length;v+=3){var g=r.fromArray(d,v,it),_=l.cartesianToCartographic(g,nt);if(!u(_))throw new c("Could not project point ("+g.x+", "+g.y+", "+g.z+") to 2D.");var y=o.project(_,it);m[f++]=y.x,m[f++]=y.y,m[f++]=y.z}return e.attributes[i]=a,e.attributes[n]=new p({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:m}),delete e.attributes[t],e};var rt={high:0,low:0};tt.encodeAttribute=function(e,t,i,n){for(var r=e.attributes[t],o=r.values,a=o.length,l=new Float32Array(a),u=new Float32Array(a),c=0;a>c;++c)d.encode(o[c],rt),l[c]=rt.high,u[c]=rt.low;var h=r.componentsPerAttribute;return e.attributes[i]=new p({componentDatatype:s.FLOAT,componentsPerAttribute:h,values:l}),e.attributes[n]=new p({componentDatatype:s.FLOAT,componentsPerAttribute:h,values:u}),delete e.attributes[t],e};var ot=new r,at=new E,st=new w;tt.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(E.equals(t,E.IDENTITY))return e;var n=e.geometry.attributes;O(t,n.position),O(t,n.prevPosition),O(t,n.nextPosition),(u(n.normal)||u(n.binormal)||u(n.tangent))&&(E.inverse(t,at),E.transpose(at,at),E.getRotation(at,st),R(st,n.normal),R(st,n.binormal),R(st,n.tangent));var r=e.geometry.boundingSphere;return u(r)&&(e.geometry.boundingSphere=i.transform(r,t,r)),e.modelMatrix=E.clone(E.IDENTITY),e};var lt=new r;tt.combineInstances=function(e){for(var t=[],i=[],n=e.length,r=0;n>r;++r){var o=e[r];u(o.geometry)?t.push(o):i.push(o)}var a=[];return t.length>0&&a.push(N(t,"geometry")),i.length>0&&(a.push(N(i,"westHemisphereGeometry")),a.push(N(i,"eastHemisphereGeometry"))),a};var ut=new r,ct=new r,dt=new r,ht=new r;tt.computeNormal=function(e){for(var t=e.indices,i=e.attributes,n=i.position.values,o=i.position.values.length/3,a=t.length,l=new Array(o),u=new Array(a/3),c=new Array(a),d=0;o>d;d++)l[d]={indexOffset:0,count:0,currentCount:0};var h=0;for(d=0;a>d;d+=3){var m=t[d],f=t[d+1],v=t[d+2],g=3*m,_=3*f,y=3*v;ct.x=n[g],ct.y=n[g+1],ct.z=n[g+2],dt.x=n[_],dt.y=n[_+1],dt.z=n[_+2],ht.x=n[y],ht.y=n[y+1],ht.z=n[y+2],l[m].count++,l[f].count++,l[v].count++,r.subtract(dt,ct,dt),r.subtract(ht,ct,ht),u[h]=r.cross(dt,ht,new r),h++}var C=0;for(d=0;o>d;d++)l[d].indexOffset+=C,C+=l[d].count;h=0;var w;for(d=0;a>d;d+=3){w=l[t[d]];var E=w.indexOffset+w.currentCount;c[E]=h,w.currentCount++,w=l[t[d+1]],E=w.indexOffset+w.currentCount,c[E]=h,w.currentCount++,w=l[t[d+2]],E=w.indexOffset+w.currentCount,c[E]=h,w.currentCount++,h++}var b=new Float32Array(3*o);for(d=0;o>d;d++){var S=3*d;if(w=l[d],w.count>0){for(r.clone(r.ZERO,ut),h=0;h<w.count;h++)r.add(ut,u[c[w.indexOffset+h]],ut);r.normalize(ut,ut),b[S]=ut.x,b[S+1]=ut.y,b[S+2]=ut.z}else b[S]=0,b[S+1]=0,b[S+2]=1}return e.attributes.normal=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:b}),e};var mt=new r,pt=new r,ft=new r;tt.computeBinormalAndTangent=function(e){e.attributes;for(var t=e.indices,i=e.attributes.position.values,n=e.attributes.normal.values,o=e.attributes.st.values,a=e.attributes.position.values.length/3,l=t.length,u=new Array(3*a),c=0;c<u.length;c++)u[c]=0;var d,h,m;for(c=0;l>c;c+=3){var f=t[c],v=t[c+1],g=t[c+2];d=3*f,h=3*v,m=3*g;var _=2*f,y=2*v,C=2*g,w=i[d],E=i[d+1],b=i[d+2],S=o[_],x=o[_+1],T=o[y+1]-x,P=o[C+1]-x,A=1/((o[y]-S)*P-(o[C]-S)*T),M=(P*(i[h]-w)-T*(i[m]-w))*A,I=(P*(i[h+1]-E)-T*(i[m+1]-E))*A,D=(P*(i[h+2]-b)-T*(i[m+2]-b))*A;u[d]+=M,u[d+1]+=I,u[d+2]+=D,u[h]+=M,u[h+1]+=I,u[h+2]+=D,u[m]+=M,u[m+1]+=I,u[m+2]+=D}var O=new Float32Array(3*a),R=new Float32Array(3*a);for(c=0;a>c;c++){d=3*c,h=d+1,m=d+2;var L=r.fromArray(n,d,mt),N=r.fromArray(u,d,ft),z=r.dot(L,N);r.multiplyByScalar(L,z,pt),r.normalize(r.subtract(N,pt,N),N),R[d]=N.x,R[h]=N.y,R[m]=N.z,r.normalize(r.cross(L,N,N),N),O[d]=N.x,O[h]=N.y,O[m]=N.z}return e.attributes.tangent=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:R}),e.attributes.binormal=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:O}),e};var vt=new n,gt=new r,_t=new r,yt=new r;tt.compressVertices=function(t){var i=t.attributes.normal,o=t.attributes.st;if(!u(i)&&!u(o))return t;var a,l,c,d,h=t.attributes.tangent,m=t.attributes.binormal;u(i)&&(a=i.values),u(o)&&(l=o.values),u(h)&&(c=h.values),m&&(d=m.values);var f=u(a)?a.length:l.length,v=u(a)?3:2,g=f/v,_=g,y=u(l)&&u(a)?2:1;y+=u(c)||u(d)?1:0,_*=y;for(var C=new Float32Array(_),w=0,E=0;g>E;++E){u(l)&&(n.fromArray(l,2*E,vt),C[w++]=e.compressTextureCoordinates(vt));var b=3*E;u(a)&&u(c)&&u(d)?(r.fromArray(a,b,gt),r.fromArray(c,b,_t),r.fromArray(d,b,yt),e.octPack(gt,_t,yt,vt),C[w++]=vt.x,C[w++]=vt.y):(u(a)&&(r.fromArray(a,b,gt),C[w++]=e.octEncodeFloat(gt)),u(c)&&(r.fromArray(c,b,gt),C[w++]=e.octEncodeFloat(gt)),u(d)&&(r.fromArray(d,b,gt),C[w++]=e.octEncodeFloat(gt)))}return t.attributes.compressedAttributes=new p({componentDatatype:s.FLOAT,componentsPerAttribute:y,values:C}),u(a)&&delete t.attributes.normal,u(l)&&delete t.attributes.st,u(c)&&delete t.attributes.tangent,u(d)&&delete t.attributes.binormal,t};var Ct=new r,wt=new r,Et=new r,bt=new r,St=new r,xt={positions:new Array(7),indices:new Array(9)},Tt=new r,Pt=new r,At=new r,Mt=new r,It=new n,Dt=new n,Ot=new n,Rt=b.fromPointNormal(r.ZERO,r.UNIT_Y),Lt=new r,Nt=new r,zt=new n,Ft=new n,Bt=new r,Vt=new r,kt=new r,Ut=new r,Wt=new r,Gt=new r,Ht=new r,qt=new o;return new o,tt.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(u(n)){var r=n.center.x-n.radius;if(r>0||i.intersect(n,o.UNIT_Y)!==_.INTERSECTING)return e}if(t.geometryType!==v.NONE)switch(t.geometryType){case v.POLYLINES:et(e);break;case v.TRIANGLES:Q(e);break;case v.LINES:$(e)}else W(t),t.primitiveType===S.TRIANGLES?Q(e):t.primitiveType===S.LINES&&$(e);return e},tt}),define("Cesium/Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f){"use strict";function v(e,t,i){var n,r=!i,o=e.length;if(!r&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!p.equals(a,e[n].modelMatrix)){r=!0;break}}if(r)for(n=0;o>n;++n)h.transformToWorldCoordinates(e[n]);else p.multiplyTransformation(t,e[0].modelMatrix,t)}function g(e,n){var r=e.attributes,o=r.position,a=4*(o.values.length/o.componentsPerAttribute);r.pickColor=new c({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var s=t.floatToByte(n.red),l=t.floatToByte(n.green),u=t.floatToByte(n.blue),d=t.floatToByte(n.alpha),h=r.pickColor.values,m=0;a>m;m+=4)h[m]=s,h[m+1]=l,h[m+2]=u,h[m+3]=d}function _(e,t){for(var i=e.length,n=0;i>n;++n){var o=e[n],a=t[n];r(o.geometry)?g(o.geometry,a):(g(o.westHemisphereGeometry,a),g(o.eastHemisphereGeometry,a))}}function y(e){var t,i=e.length,n=[],o=e[0].attributes;for(t in o)if(o.hasOwnProperty(t)){for(var a=o[t],s=!0,l=1;i>l;++l){var u=e[l].attributes[t];if(!r(u)||a.componentDatatype!==u.componentDatatype||a.componentsPerAttribute!==u.componentsPerAttribute||a.normalize!==u.normalize){s=!1;break}}s&&n.push(t)}return n}function C(e,t,n){for(var r=u.computeNumberOfVertices(t),o=n.length,a=0;o>a;++a){for(var s=n[a],l=e[s],d=l.componentDatatype,h=l.value,m=h.length,p=i.createTypedArray(d,r*m),f=0;r>f;++f)p.set(h,f*m);t.attributes[s]=new c({componentDatatype:d,componentsPerAttribute:m,normalize:l.normalize,values:p})}}function w(e,t){for(var i=e.length,n=0;i>n;++n){var o=e[n],a=o.attributes;r(o.geometry)?C(a,o.geometry,t):(C(a,o.westHemisphereGeometry,t),C(a,o.eastHemisphereGeometry,t))}}function E(t){var n,o,a=t.instances,s=t.pickIds,l=t.projection,u=t.elementIndexUintSupported,c=t.scene3DOnly,d=t.allowPicking,m=t.vertexCacheOptimize,p=t.compressVertices,f=t.modelMatrix,g=a.length;if(a[0].geometry.primitiveType,v(a,f,c),!c)for(n=0;g>n;++n)h.splitLongitude(a[n]);d&&_(a,s);var C=y(a);if(w(a,C),m)for(n=0;g>n;++n){var E=a[n];r(E.geometry)?(h.reorderForPostVertexCache(E.geometry),h.reorderForPreVertexCache(E.geometry)):(h.reorderForPostVertexCache(E.westHemisphereGeometry),h.reorderForPreVertexCache(E.westHemisphereGeometry),h.reorderForPostVertexCache(E.eastHemisphereGeometry),h.reorderForPreVertexCache(E.eastHemisphereGeometry))}var b=h.combineInstances(a);for(g=b.length,n=0;g>n;++n){o=b[n];var S,x=o.attributes;if(c)for(S in x)x.hasOwnProperty(S)&&x[S].componentDatatype===i.DOUBLE&&h.encodeAttribute(o,S,S+"3DHigh",S+"3DLow");else for(S in x)if(x.hasOwnProperty(S)&&x[S].componentDatatype===i.DOUBLE){var T=S+"3D",P=S+"2D";h.projectTo2D(o,S,T,P,l),r(o.boundingSphere)&&"position"===S&&(o.boundingSphereCV=e.fromVertices(o.attributes.position2D.values)),h.encodeAttribute(o,T,T+"High",T+"Low"),h.encodeAttribute(o,P,P+"High",P+"Low")}p&&h.compressVertices(o)}if(!u){var A=[];for(g=b.length,n=0;g>n;++n)o=b[n],A=A.concat(h.fitToUnsignedShortIndices(o));b=A}return b}function b(e,t,n){for(var r=[],o=e.attributes,a=n.length,s=0;a>s;++s){var l=n[s],u=o[l],c=u.componentDatatype;c===i.DOUBLE&&(c=i.FLOAT);var d=i.createTypedArray(c,u.values);r.push({index:t[l],componentDatatype:c,componentsPerAttribute:u.componentsPerAttribute,normalize:u.normalize,values:d}),delete o[l]}return r}function S(e,t,i,o,a,s,l,c,d){var h=u.computeNumberOfVertices(t);r(l[e])||(l[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var m=o.length,p=0;m>p;++p)for(var f=o[p],v=a[f],g=h;g>0;){for(var _,y=n(d[f],0),C=s[y],w=C.length,E=0;w>E&&(_=C[E],_.index!==v);++E);r(l[e][f])||(l[e][f]={dirty:!1,valid:!0,value:i[f].value,indices:[]});var b,S=_.values.length/_.componentsPerAttribute,x=n(c[f],0);S>x+g?(b=g,l[e][f].indices.push({attribute:_,offset:x,count:b}),c[f]=x+g):(b=S-x,l[e][f].indices.push({attribute:_,offset:x,count:b}),c[f]=0,d[f]=y+1),g-=b}}function x(e,t,i,n,o){var a,s,l,u=[],c=e.length,d={},h={};for(a=0;c>a;++a)s=e[a],l=s.attributes,r(s.geometry)&&S(a,s.geometry,l,o,n,i,u,d,h);for(a=0;c>a;++a)s=e[a],l=s.attributes,r(s.westHemisphereGeometry)&&S(a,s.westHemisphereGeometry,l,o,n,i,u,d,h);for(a=0;c>a;++a)s=e[a],l=s.attributes,r(s.eastHemisphereGeometry)&&S(a,s.eastHemisphereGeometry,l,o,n,i,u,d,h);for(c=t.length,a=0;c>a;++a){s=t[a],l=s.attributes;var m={};u.push(m);for(var p=o.length,f=0;p>f;++f){var v=o[f];m[v]={dirty:!1,valid:!1,value:l[v].value,indices:[]}}}return u}function T(e,t){var i=e.attributes;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];r(o)&&r(o.values)&&t.push(o.values.buffer)}r(e.indices)&&t.push(e.indices.buffer)}function P(e,t){for(var i=e.length,n=0;i>n;++n)T(e[n],t)}function A(e,t){for(var i=e.length,n=0;i>n;++n)for(var r=e[n],o=r.length,a=0;o>a;++a)t.push(r[a].values.buffer)}function M(t){for(var i=1,n=t.length,o=0;n>o;o++){var a=t[o];if(++i,r(a)){var s=a.attributes;i+=6+2*e.packedLength+(r(a.indices)?a.indices.length:0);for(var l in s)if(s.hasOwnProperty(l)&&r(s[l])){var u=s[l];i+=5+u.values.length}}}return i}function I(e,t){for(var i=e.length,n=new Uint32Array(e.length),r=0;i>r;++r)n[r]=e[r].toRgba();return t.push(n.buffer),n}function D(e){for(var i=e.length,n=new Array(i),r=0;i>r;r++)n[r]=t.fromRgba(e[r]);return n}function O(e){for(var t=e.length,i=1+17*t,n=0;t>n;n++){var o=e[n].attributes;for(var a in o)if(o.hasOwnProperty(a)&&r(o[a])){var s=o[a];i+=5+s.value.length}}return i}function R(e,t){var i=new Float64Array(O(e)),n={},o=[],a=e.length,s=0;i[s++]=a;for(var l=0;a>l;l++){var u=e[l];p.pack(u.modelMatrix,i,s),s+=p.packedLength;var c=u.attributes,d=[];for(var h in c)c.hasOwnProperty(h)&&r(c[h])&&(d.push(h),r(n[h])||(n[h]=o.length,o.push(h)));i[s++]=d.length;for(var m=0;m<d.length;m++){var f=d[m],v=c[f];i[s++]=n[f],i[s++]=v.componentDatatype,i[s++]=v.componentsPerAttribute,i[s++]=v.normalize,i[s++]=v.value.length,i.set(v.value,s),s+=v.value.length}}return t.push(i.buffer),{stringTable:o,packedData:i}}function L(e){for(var t=e.packedData,n=e.stringTable,r=new Array(t[0]),o=0,a=1;a<t.length;){var s=p.unpack(t,a);a+=p.packedLength;for(var l={},u=t[a++],c=0;u>c;c++){for(var d=n[t[a++]],h=t[a++],m=t[a++],f=0!==t[a++],v=t[a++],g=i.createTypedArray(h,v),_=0;v>_;_++)g[_]=t[a++];l[d]={componentDatatype:h,componentsPerAttribute:m,normalize:f,value:g}}r[o++]={attributes:l,modelMatrix:s}}return r}function N(t){for(var i=t.length,n=1+i,o=0;i>o;o++){var a=t[o];n+=2,n+=r(a.boundingSphere)?e.packedLength:0,n+=r(a.boundingSphereCV)?e.packedLength:0;for(var s in a)if(a.hasOwnProperty(s)&&r(a[s])&&"boundingSphere"!==s&&"boundingSphereCV"!==s){var l=a[s];n+=4+3*l.indices.length+l.value.length}}return n}function z(t,i){var n=new Float64Array(N(t)),o=[],a=[],s={},l=t.length,u=0;n[u++]=l;for(var c=0;l>c;c++){var d=t[c],h=d.boundingSphere,m=r(h);n[u++]=m?1:0,m&&(e.pack(h,n,u),u+=e.packedLength),h=d.boundingSphereCV,m=r(h),n[u++]=m?1:0,m&&(e.pack(h,n,u),u+=e.packedLength);var p=[];for(var f in d)d.hasOwnProperty(f)&&r(d[f])&&"boundingSphere"!==f&&"boundingSphereCV"!==f&&(p.push(f),r(s[f])||(s[f]=o.length,o.push(f)));n[u++]=p.length;for(var v=0;v<p.length;v++){var g=p[v],_=d[g];n[u++]=s[g],n[u++]=_.valid?1:0;var y=_.indices,C=y.length;n[u++]=C;for(var w=0;C>w;w++){var E=y[w];n[u++]=E.count,n[u++]=E.offset;var b=a.indexOf(E.attribute);-1===b&&(b=a.length,a.push(E.attribute)),n[u++]=b}n[u++]=_.value.length,n.set(_.value,u),u+=_.value.length}}return i.push(n.buffer),{stringTable:o,packedData:n,attributeTable:a}}function F(t){for(var n=t.stringTable,r=t.attributeTable,o=t.packedData,a=new Array(o[0]),s=0,l=1,u=o.length;u>l;){var c={},d=1===o[l++];d&&(c.boundingSphere=e.unpack(o,l),l+=e.packedLength),d=1===o[l++],d&&(c.boundingSphereCV=e.unpack(o,l),l+=e.packedLength);for(var h=o[l++],m=0;h>m;m++){for(var p=n[o[l++]],f=1===o[l++],v=o[l++],g=v>0?new Array(v):void 0,_=0;v>_;_++){var y={};y.count=o[l++],y.offset=o[l++],y.attribute=r[o[l++]],g[_]=y}for(var C=o[l++],w=f?i.createTypedArray(g[0].attribute.componentDatatype,C):new Array(C),E=0;C>E;E++)w[E]=o[l++];c[p]={dirty:!1,valid:f,indices:g,value:w}}a[s++]=c}return a}if(!s.supportsTypedArrays())return{};var B={};return B.combineGeometry=function(e){var t,i,n,o,a,s=e.instances,l=e.invalidInstances;if(s.length>0){t=E(e),i=h.createAttributeLocations(t[0]),o=y(s),n=[],a=t.length;for(var u=0;a>u;++u){var c=t[u];n.push(b(c,i,o))}}o=r(o)?o:y(l);var d=x(s,l,n,i,o);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:i,vaAttributes:n,vaAttributeLocations:d,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.packCreateGeometryResults=function(t,i){var n=new Float64Array(M(t)),o=[],a={},s=t.length,l=0;n[l++]=s;for(var u=0;s>u;u++){var c=t[u],d=r(c);if(n[l++]=d?1:0,d){n[l++]=c.primitiveType,n[l++]=c.geometryType;var h=r(c.boundingSphere)?1:0;n[l++]=h,h&&e.pack(c.boundingSphere,n,l),l+=e.packedLength;var m=r(c.boundingSphereCV)?1:0;n[l++]=m,m&&e.pack(c.boundingSphereCV,n,l),l+=e.packedLength;var p=c.attributes,f=[];for(var v in p)p.hasOwnProperty(v)&&r(p[v])&&(f.push(v),r(a[v])||(a[v]=o.length,o.push(v)));n[l++]=f.length;for(var g=0;g<f.length;g++){var _=f[g],y=p[_];n[l++]=a[_],n[l++]=y.componentDatatype,n[l++]=y.componentsPerAttribute,n[l++]=y.normalize?1:0,n[l++]=y.values.length,n.set(y.values,l),l+=y.values.length}var C=r(c.indices)?c.indices.length:0;n[l++]=C,C>0&&(n.set(c.indices,l),l+=C)}}return i.push(n.buffer),{stringTable:o,packedData:n}},B.unpackCreateGeometryResults=function(t){for(var n,r=t.stringTable,o=t.packedData,a=new Array(o[0]),s=0,l=1;l<o.length;){var h=1===o[l++];if(h){var p,f,v=o[l++],g=o[l++],_=1===o[l++];_&&(p=e.unpack(o,l)),l+=e.packedLength;var y=1===o[l++];y&&(f=e.unpack(o,l)),l+=e.packedLength;var C,w,E,b=new d,S=o[l++];for(n=0;S>n;n++){var x=r[o[l++]],T=o[l++];E=o[l++];var P=0!==o[l++];C=o[l++],w=i.createTypedArray(T,C);for(var A=0;C>A;A++)w[A]=o[l++];b[x]=new c({componentDatatype:T,componentsPerAttribute:E,normalize:P,values:w})}var M;if(C=o[l++],C>0){var I=w.length/E;for(M=m.createTypedArray(I,C),n=0;C>n;n++)M[n]=o[l++]}a[s++]=new u({primitiveType:v,geometryType:g,boundingSphere:p,indices:M,attributes:b})}else a[s++]=void 0}return a},B.packCombineGeometryParameters=function(e,t){for(var i=e.createGeometryResults,n=i.length,r=0;n>r;r++)t.push(i[r].packedData.buffer);var o;return e.allowPicking&&(o=I(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:R(e.instances,t),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof l,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},B.unpackCombineGeometryParameters=function(e){for(var t=L(e.packedInstances),i=e.allowPicking,n=i?D(e.packedPickIds):void 0,o=e.createGeometryResults,s=o.length,u=0,c=[],d=[],h=[],m=[],v=[],g=0;s>g;g++)for(var _=B.unpackCreateGeometryResults(o[g]),y=_.length,C=0;y>C;C++){var w=_[C],E=t[u];r(w)?(E.geometry=w,c.push(E),h.push(u),i&&v.push(n[u])):(d.push(E),m.push(u)),++u}var b=a.clone(e.ellipsoid),S=e.isGeographic?new l(b):new f(b);return{instances:c,invalidInstances:d,validInstancesIndices:h,invalidInstancesIndices:m,pickIds:v,ellipsoid:b,projection:S,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:p.clone(e.modelMatrix)}},B.packCombineGeometryResults=function(e,t){return r(e.geometries)&&(P(e.geometries,t),A(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:z(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:F(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},B}),define("Cesium/Scene/PrimitiveState",["../Core/freezeObject"],function(e){"use strict";var t={READY:0,CREATING:1,CREATED:2,COMBINING:3,COMBINED:4,COMPLETE:5,FAILED:6};return e(t)}),define("Cesium/Scene/Primitive",["../Core/BoundingSphere","../Core/clone","../Core/combine","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryInstance","../Core/GeometryInstanceAttribute","../Core/isArray","../Core/Matrix4","../Core/subdivideArray","../Core/TaskProcessor","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/ShaderSource","../ThirdParty/when","./CullFace","./Pass","./PrimitivePipeline","./PrimitiveState","./SceneMode"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P){"use strict";function A(e){return new d({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,values:new e.values.constructor(e.values)})}function M(t){var i=t.attributes,n=new h;for(var r in i)i.hasOwnProperty(r)&&o(i[r])&&(n[r]=A(i[r]));var a;if(o(t.indices)){var s=t.indices;a=new s.constructor(s)}return new c({attributes:n,indices:a,primitiveType:t.primitiveType,boundingSphere:e.clone(t.boundingSphere)})}function I(e){return new p({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,value:new e.value.constructor(e.value)})}function D(e,t){var i=e.attributes,n={};for(var r in i)i.hasOwnProperty(r)&&(n[r]=I(i[r]));return new m({geometry:t,modelMatrix:v.clone(e.modelMatrix),attributes:n,pickPrimitive:e.pickPrimitive,id:e.id})}function O(e,t,i){for(var n,r="",o="",a="";null!==(n=H.exec(t));){var s=n[1],l="vec4 czm_compute"+s[0].toUpperCase()+s.substr(1)+"()";"vec4 czm_computePosition()"!==l&&(r+=l+";\n"),i?a+=l+"\n"+"{\n"+"    return czm_translateRelativeToEye("+s+"3DHigh, "+s+"3DLow);\n"+"}\n\n":(o+="attribute vec3 "+s+"2DHigh;\n"+"attribute vec3 "+s+"2DLow;\n",a+=l+"\n"+"{\n"+"    vec4 p;\n"+"    if (czm_morphTime == 1.0)\n"+"    {\n"+"        p = czm_translateRelativeToEye("+s+"3DHigh, "+s+"3DLow);\n"+"    }\n"+"    else if (czm_morphTime == 0.0)\n"+"    {\n"+"        p = czm_translateRelativeToEye("+s+"2DHigh.zxy, "+s+"2DLow.zxy);\n"+"    }\n"+"    else\n"+"    {\n"+"        p = czm_columbusViewMorph(\n"+"                czm_translateRelativeToEye("+s+"2DHigh.zxy, "+s+"2DLow.zxy),\n"+"                czm_translateRelativeToEye("+s+"3DHigh, "+s+"3DLow),\n"+"                czm_morphTime);\n"+"    }\n"+"    return p;\n"+"}\n\n")}return[r,o,t,a].join("\n")}function R(e){var t=e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_old_main()"),i="attribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}";return t+"\n"+i}function L(e,t){if(!o(e._attributeLocations.show))return t;var i=t.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_non_show_main()"),n="attribute float show;\nvoid main() \n{ \n    czm_non_show_main(); \n    gl_Position *= show; \n}";return i+"\n"+n}function N(e,t){if(!e.compressVertices)return t;var i=-1!==t.search(/attribute\s+vec3\s+normal;/g),n=-1!==t.search(/attribute\s+vec2\s+st;/g);if(!i&&!n)return t;var r=-1!==t.search(/attribute\s+vec3\s+tangent;/g),o=-1!==t.search(/attribute\s+vec3\s+binormal;/g),a=n&&i?2:1;a+=r||o?1:0;var s=a>1?"vec"+a:"float",l="compressedAttributes",u="attribute "+s+" "+l+";",c="",d="";if(n){c+="vec2 st;\n";var h=a>1?l+".x":l;d+="    st = czm_decompressTextureCoordinates("+h+");\n"}i&&r&&o?(c+="vec3 normal;\nvec3 tangent;\nvec3 binormal;\n",d+="    czm_octDecode("+l+"."+(n?"yz":"xy")+", normal, tangent, binormal);\n"):(i&&(c+="vec3 normal;\n",d+="    normal = czm_octDecode("+l+(a>1?"."+(n?"y":"x"):"")+");\n"),r&&(c+="vec3 tangent;\n",d+="    tangent = czm_octDecode("+l+"."+(n&&i?"z":"y")+");\n"),o&&(c+="vec3 binormal;\n",d+="    binormal = czm_octDecode("+l+"."+(n&&i?"z":"y")+");\n"));var m=t;m=m.replace(/attribute\s+vec3\s+normal;/g,""),m=m.replace(/attribute\s+vec2\s+st;/g,""),m=m.replace(/attribute\s+vec3\s+tangent;/g,""),m=m.replace(/attribute\s+vec3\s+binormal;/g,""),m=m.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,"void czm_non_compressed_main()");var p="void main() \n{ \n"+d+"    czm_non_compressed_main(); \n"+"}";return[u,c,m,p].join("\n")}function z(e){e.vertexAttributes}function F(e,t,i){for(var n=[],a=i.length,s=0;a>s;++s){var l={primitive:r(i[s].pickPrimitive,t)};o(i[s].id)&&(l.id=i[s].id);var u=e.createPickId(l);t._pickIds.push(u),n.push(u.color)}return n}function B(e,t){return function(){return e[t]}}function V(e,t){var i=t[e];return function(){return o(i)&&o(i.value)?t[e].value:i}}function k(e,t,i){return function(n){var r=t[e];r.value=n,!r.dirty&&r.valid&&(i.push(r),r.dirty=!0)}}function U(e,t,i,n){e._error=n,e._state=i,t.afterRender.push(function(){e._ready=e._state===T.COMPLETE||e._state===T.FAILED,o(n)?e._readyPromise.reject(n):e._readyPromise.resolve(e)})}var W=function(e){e=r(e,r.EMPTY_OBJECT),this.geometryInstances=e.geometryInstances,this.appearance=e.appearance,this._appearance=void 0,this._material=void 0,this.modelMatrix=v.clone(r(e.modelMatrix,v.IDENTITY)),this._modelMatrix=new v,this.show=r(e.show,!0),this._vertexCacheOptimize=r(e.vertexCacheOptimize,!1),this._interleave=r(e.interleave,!1),this._releaseGeometryInstances=r(e.releaseGeometryInstances,!0),this._allowPicking=r(e.allowPicking,!0),this._asynchronous=r(e.asynchronous,!0),this._compressVertices=r(e.compressVertices,!0),this.cull=r(e.cull,!0),this.debugShowBoundingVolume=r(e.debugShowBoundingVolume,!1),this._translucent=void 0,this._state=T.READY,this._geometries=[],this._vaAttributes=void 0,this._error=void 0,this._numberOfInstances=0,this._validModelMatrix=!1,this._boundingSpheres=[],this._boundingSphereWC=[],this._boundingSphereCV=[],this._boundingSphere2D=[],this._boundingSphereMorph=[],this._perInstanceAttributeLocations=void 0,this._perInstanceAttributeCache=[],this._instanceIds=[],this._lastPerInstanceAttributeIndex=0,this._dirtyAttributes=[],this._va=[],this._attributeLocations=void 0,this._primitiveType=void 0,this._frontFaceRS=void 0,this._backFaceRS=void 0,this._sp=void 0,this._pickRS=void 0,this._pickSP=void 0,this._pickIds=[],this._colorCommands=[],this._pickCommands=[],this._createGeometryResults=void 0,this._ready=!1,this._readyPromise=E.defer()};a(W.prototype,{vertexCacheOptimize:{get:function(){return this._vertexCacheOptimize}},interleave:{get:function(){return this._interleave}},releaseGeometryInstances:{get:function(){return this._releaseGeometryInstances}},allowPicking:{get:function(){return this._allowPicking}},asynchronous:{get:function(){return this._asynchronous}},compressVertices:{get:function(){return this._compressVertices}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}}});var G,H=/attribute\s+vec(?:3|4)\s+(.*)3DHigh;/g,q=Math.max(u.hardwareConcurrency-1,1),j=new _("combineGeometry",Number.POSITIVE_INFINITY);return W.prototype.update=function(a,s,u){if(!(!o(this.geometryInstances)&&0===this._va.length||o(this.geometryInstances)&&f(this.geometryInstances)&&0===this.geometryInstances.length||!o(this.appearance)||s.mode!==P.SCENE3D&&s.scene3DOnly||!s.passes.render&&!s.passes.pick)){if(o(this._error))throw this._error;if(this._state!==T.FAILED){var c,d,h,m,p,A,I,V,k,W,H,Y,X,Z,J=s.mapProjection,K=this.allowPicking,Q=this._instanceIds,$=s.scene3DOnly,et=this;if(this._state!==T.COMPLETE&&this._state!==T.COMBINED)if(this.asynchronous){if(this._state===T.READY){Y=f(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],this._numberOfInstances=A=Y.length;var tt=[],it=[];for(I=0;A>I;++I)h=Y[I].geometry,Q.push(Y[I].id),it.push({moduleName:h._workerName,geometry:h});if(!o(G))for(G=new Array(q),I=0;q>I;I++)G[I]=new _("createGeometry",Number.POSITIVE_INFINITY);var nt;for(it=g(it,q),I=0;I<it.length;I++){var rt=0,ot=it[I],at=ot.length;for(V=0;at>V;++V)nt=ot[V],h=nt.geometry,o(h.constructor.pack)&&(nt.offset=rt,rt+=r(h.constructor.packedLength,h.packedLength));var st;if(rt>0){var lt=new Float64Array(rt);for(st=[lt.buffer],V=0;at>V;++V)nt=ot[V],h=nt.geometry,o(h.constructor.pack)&&(h.constructor.pack(h,lt,nt.offset),nt.geometry=lt)}tt.push(G[I].scheduleTask({subTasks:it[I]},st))}this._state=T.CREATING,E.all(tt,function(e){et._createGeometryResults=e,et._state=T.CREATED}).otherwise(function(e){U(et,s,T.FAILED,e)})}else if(this._state===T.CREATED){var ut=[];Y=f(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],W=j.scheduleTask(x.packCombineGeometryParameters({createGeometryResults:this._createGeometryResults,instances:Y,pickIds:K?F(a,this,Y):void 0,ellipsoid:J.ellipsoid,projection:J,elementIndexUintSupported:a.elementIndexUint,scene3DOnly:$,allowPicking:K,vertexCacheOptimize:this.vertexCacheOptimize,compressVertices:this.compressVertices,modelMatrix:this.modelMatrix},ut),ut),this._createGeometryResults=void 0,this._state=T.COMBINING,E(W,function(e){var t=x.unpackCombineGeometryResults(e);et._geometries=t.geometries,et._attributeLocations=t.attributeLocations,et._vaAttributes=t.vaAttributes,et._perInstanceAttributeLocations=t.perInstanceAttributeLocations,et.modelMatrix=v.clone(t.modelMatrix,et.modelMatrix),et._validModelMatrix=!v.equals(et.modelMatrix,v.IDENTITY);for(var i=e.validInstancesIndices,n=e.invalidInstancesIndices,r=et._instanceIds,a=new Array(r.length),l=i.length,u=0;l>u;++u)a[u]=r[i[u]];for(var c=n.length,d=0;c>d;++d)a[l+d]=r[n[d]];et._instanceIds=a,o(et._geometries)?et._state=T.COMBINED:U(et,s,T.FAILED,void 0)}).otherwise(function(e){U(et,s,T.FAILED,e)})}}else{Y=f(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],this._numberOfInstances=A=Y.length,Z=new Array(A),X=new Array(A);var ct=[],dt=0;for(I=0;A>I;I++){H=Y[I],h=H.geometry;var ht;ht=o(h.attributes)&&o(h.primitiveType)?M(h):h.constructor.createGeometry(h),o(ht)?(Z[dt]=ht,X[dt++]=D(H,ht),Q.push(H.id)):ct.push(H)}Z.length=dt,X.length=dt;var mt=x.combineGeometry({instances:X,invalidInstances:ct,pickIds:K?F(a,this,X):void 0,ellipsoid:J.ellipsoid,projection:J,elementIndexUintSupported:a.elementIndexUint,scene3DOnly:$,allowPicking:K,vertexCacheOptimize:this.vertexCacheOptimize,compressVertices:this.compressVertices,modelMatrix:this.modelMatrix});for(this._geometries=mt.geometries,this._attributeLocations=mt.attributeLocations,this._vaAttributes=mt.vaAttributes,this._perInstanceAttributeLocations=mt.vaAttributeLocations,this.modelMatrix=v.clone(mt.modelMatrix,this.modelMatrix),this._validModelMatrix=!v.equals(this.modelMatrix,v.IDENTITY),I=0;I<ct.length;++I)H=ct[I],Q.push(H.id);o(this._geometries)?this._state=T.COMBINED:U(this,s,T.FAILED,void 0)}var pt=this._attributeLocations;if(this._state===T.COMBINED){Z=this._geometries;var ft=this._vaAttributes,vt=[];for(A=Z.length,I=0;A>I;++I){h=Z[I],m=ft[I];var gt=m.length;for(V=0;gt>V;++V)p=m[V],p.vertexBuffer=a.createVertexBuffer(p.values,y.DYNAMIC_DRAW),delete p.values;if(vt.push(a.createVertexArrayFromGeometry({geometry:h,attributeLocations:pt,bufferUsage:y.STATIC_DRAW,interleave:this._interleave,vertexArrayAttributes:m})),this._boundingSpheres.push(e.clone(h.boundingSphere)),this._boundingSphereWC.push(new e),!$){var _t=h.boundingSphereCV.center,yt=_t.x,Ct=_t.y,wt=_t.z;_t.x=wt,_t.y=yt,_t.z=Ct,this._boundingSphereCV.push(e.clone(h.boundingSphereCV)),this._boundingSphere2D.push(new e),this._boundingSphereMorph.push(new e)}}this._va=vt,this._primitiveType=Z[0].primitiveType,this.releaseGeometryInstances&&(this.geometryInstances=void 0),this._geometries=void 0,U(this,s,T.COMPLETE,void 0)}if(this.show&&this._state===T.COMPLETE){var Et=this.appearance,bt=Et.material,St=!1,xt=!1;this._appearance!==Et?(this._appearance=Et,this._material=bt,St=!0,xt=!0):this._material!==bt&&(this._material=bt,xt=!0);var Tt=this._appearance.isTranslucent();this._translucent!==Tt&&(this._translucent=Tt,St=!0),o(this._material)&&this._material.update(a);var Pt=Et.closed&&Tt;if(St){var At,Mt=Et.getRenderState();Pt?(At=t(Mt,!1),At.cull={enabled:!0,face:b.BACK},this._frontFaceRS=a.createRenderState(At),At.cull.face=b.FRONT,this._backFaceRS=a.createRenderState(At)):(this._frontFaceRS=a.createRenderState(Mt),this._backFaceRS=this._frontFaceRS),K?Pt?(At=t(Mt,!1),At.cull={enabled:!1},this._pickRS=a.createRenderState(At)):this._pickRS=this._frontFaceRS:(At=t(Mt,!1),At.colorMask={red:!1,green:!1,blue:!1,alpha:!1},Pt?(At.cull={enabled:!1},this._pickRS=a.createRenderState(At)):this._pickRS=a.createRenderState(At))}if(xt){var It=O(this,Et.vertexShaderSource,$);It=L(this,It),It=N(this,It);var Dt=Et.getFragmentShaderSource();if(this._sp=a.replaceShaderProgram(this._sp,It,Dt,pt),z(this._sp,pt),K){var Ot=new w({sources:[Dt],pickColorQualifier:"varying"});this._pickSP=a.replaceShaderProgram(this._pickSP,R(It),Ot,pt)}else this._pickSP=a.createShaderProgram(It,Dt,pt);z(this._pickSP,pt)}var Rt=this._colorCommands,Lt=this._pickCommands;if(St||xt){var Nt=o(bt)?bt._uniforms:void 0,zt={},Ft=Et.uniforms;if(o(Ft))for(var Bt in Ft)if(Ft.hasOwnProperty(Bt)){if(o(Nt)&&o(Nt[Bt]))throw new l("Appearance and material have a uniform with the same name: "+Bt);
zt[Bt]=B(Ft,Bt)}var Vt=i(zt,Nt),kt=Tt?S.TRANSLUCENT:S.OPAQUE;Rt.length=this._va.length*(Pt?2:1),Lt.length=this._va.length,A=Rt.length;var Ut=0,Wt=0;for(I=0;A>I;++I)Pt&&(c=Rt[I],o(c)||(c=Rt[I]=new C({owner:this,primitiveType:this._primitiveType})),c.vertexArray=this._va[Wt],c.renderState=this._backFaceRS,c.shaderProgram=this._sp,c.uniformMap=Vt,c.pass=kt,++I),c=Rt[I],o(c)||(c=Rt[I]=new C({owner:this,primitiveType:this._primitiveType})),c.vertexArray=this._va[Wt],c.renderState=this._frontFaceRS,c.shaderProgram=this._sp,c.uniformMap=Vt,c.pass=kt,d=Lt[Ut],o(d)||(d=Lt[Ut]=new C({owner:this,primitiveType:this._primitiveType})),d.vertexArray=this._va[Wt],d.renderState=this._pickRS,d.shaderProgram=this._pickSP,d.uniformMap=Vt,d.pass=kt,++Ut,++Wt}if(this._dirtyAttributes.length>0){for(m=this._dirtyAttributes,A=m.length,I=0;A>I;++I){p=m[I];var Gt=p.value,Ht=p.indices,qt=Ht.length;for(V=0;qt>V;++V){k=Ht[V];for(var jt=k.offset,Yt=k.count,Xt=k.attribute,Zt=Xt.componentDatatype,Jt=Xt.componentsPerAttribute,Kt=n.createTypedArray(Zt,Yt*Jt),Qt=0;Yt>Qt;++Qt)Kt.set(Gt,Qt*Jt);var $t=jt*Jt*n.getSizeInBytes(Zt);Xt.vertexBuffer.copyFromArrayView(Kt,$t)}p.dirty=!1}m.length=0}var ei=this.modelMatrix;if(!v.equals(ei,this._modelMatrix))for(v.clone(ei,this._modelMatrix),A=this._boundingSpheres.length,I=0;A>I;++I){var ti=this._boundingSpheres[I];o(ti)&&(this._boundingSphereWC[I]=e.transform(ti,ei,this._boundingSphereWC[I]),$||(this._boundingSphere2D[I]=e.clone(this._boundingSphereCV[I],this._boundingSphere2D[I]),this._boundingSphere2D[I].center.x=0,this._boundingSphereMorph[I]=e.union(this._boundingSphereWC[I],this._boundingSphereCV[I])))}var ii;s.mode===P.SCENE3D?ii=this._boundingSphereWC:s.mode===P.COLUMBUS_VIEW?ii=this._boundingSphereCV:s.mode===P.SCENE2D&&o(this._boundingSphere2D)?ii=this._boundingSphere2D:o(this._boundingSphereMorph)&&(ii=this._boundingSphereMorph);var ni=s.passes;if(ni.render)for(A=Rt.length,I=0;A>I;++I){var ri=Pt?Math.floor(I/2):I;Rt[I].modelMatrix=ei,Rt[I].boundingVolume=ii[ri],Rt[I].cull=this.cull,Rt[I].debugShowBoundingVolume=this.debugShowBoundingVolume,u.push(Rt[I])}if(ni.pick)for(A=Lt.length,I=0;A>I;++I)Lt[I].modelMatrix=ei,Lt[I].boundingVolume=ii[I],Lt[I].cull=this.cull,u.push(Lt[I])}}}},W.prototype.getGeometryInstanceAttributes=function(e){for(var t=-1,i=this._lastPerInstanceAttributeIndex,n=this._instanceIds,r=n.length,s=0;r>s;++s){var l=(i+s)%r;if(e===n[l]){t=l;break}}if(-1===t)return void 0;var u=this._perInstanceAttributeCache[t];if(o(u))return u;var c=this._perInstanceAttributeLocations[t];u={};var d={},h=!1;for(var m in c)c.hasOwnProperty(m)&&(h=!0,d[m]={get:V(m,c)},"boundingSphere"!==m&&"boundingSphereCV"!==m&&(d[m].set=k(m,c,this._dirtyAttributes)));return h&&a(u,d),this._lastPerInstanceAttributeIndex=t,this._perInstanceAttributeCache[t]=u,u},W.prototype.isDestroyed=function(){return!1},W.prototype.destroy=function(){var e,t;this._sp=this._sp&&this._sp.destroy(),this._pickSP=this._pickSP&&this._pickSP.destroy();var i=this._va;for(e=i.length,t=0;e>t;++t)i[t].destroy();this._va=void 0;var n=this._pickIds;for(e=n.length,t=0;e>t;++t)n[t].destroy();return this._pickIds=void 0,s(this)},W}),define("Cesium/DataSources/dynamicGeometryGetBoundingSphere",["../Core/BoundingSphere","../Core/defined","../Core/DeveloperError","./BoundingSphereState"],function(e,t,i,n){"use strict";var r=function(i,r,o,a){var s;return t(r)&&r.show&&r.ready&&(s=r.getGeometryInstanceAttributes(i),t(s)&&t(s.boundingSphere))?(e.transform(s.boundingSphere,r.modelMatrix,a),n.DONE):t(o)&&o.show&&o.ready&&(s=o.getGeometryInstanceAttributes(i),t(s)&&t(s.boundingSphere))?(e.transform(s.boundingSphere,o.modelMatrix,a),n.DONE):t(r)&&!r.ready||t(o)&&!o.ready?n.PENDING:n.FAILED};return r}),define("Cesium/DataSources/MaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Scene/Material"],function(e,t,i,n,r){"use strict";var o=function(){n.throwInstantiationError()};return i(o.prototype,{isConstant:{get:n.throwInstantiationError},definitionChanged:{get:n.throwInstantiationError}}),o.prototype.getType=n.throwInstantiationError,o.prototype.getValue=n.throwInstantiationError,o.prototype.equals=n.throwInstantiationError,o.getValue=function(i,n,o){var a;return t(n)&&(a=n.getType(i),t(a))?(t(o)&&o.type===a||(o=r.fromType(a)),n.getValue(i,o.uniforms),o):(t(o)&&o.type===r.ColorType||(o=r.fromType(r.ColorType)),e.clone(e.WHITE,o.uniforms.color),o)},o}),define("Cesium/DataSources/BoxGeometryUpdater",["../Core/BoxGeometry","../Core/BoxOutlineGeometry","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(i.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(i.BLACK),T=new i,P=function(e){this.id=e,this.vertexFormat=void 0,this.dimensions=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"box",e.box,void 0)};a(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),a(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(t){var r,a,s=this._entity,l=s.isAvailable(t),u=new h(l&&this._showProperty.getValue(t)&&this._fillProperty.getValue(t));if(this._materialProperty instanceof v){var m=i.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(m=this._materialProperty.color.getValue(t)),a=n.fromColor(m),r={show:u,color:a}}else r={show:u};return new c({id:s,geometry:e.fromDimensions(this._options),modelMatrix:s._getModelMatrix(d.MINIMUM_VALUE),attributes:r})},A.prototype.createOutlineGeometryInstance=function(e){var r=this._entity,o=r.isAvailable(e),a=C.getValueOrDefault(this._outlineColorProperty,e,i.BLACK);return new c({id:r,geometry:t.fromDimensions(this._options),modelMatrix:r._getModelMatrix(d.MINIMUM_VALUE),attributes:{show:new h(o&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:n.fromColor(a)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),s(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"position"===t||"orientation"===t||"box"===t){var i=this._entity.box;if(!o(i))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var n=i.fill,a=o(n)&&n.isConstant?n.getValue(d.MINIMUM_VALUE):!0,s=i.outline,l=o(s);if(l&&s.isConstant&&(l=s.getValue(d.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var u=i.dimensions,c=e.position,h=i.show;if(!o(u)||!o(c)||o(h)&&h.isConstant&&!h.getValue(d.MINIMUM_VALUE))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var f=r(i.material,w),g=f instanceof v;this._materialProperty=f,this._fillProperty=r(n,b),this._showProperty=r(h,E),this._showOutlineProperty=r(i.outline,S),this._outlineColorProperty=l?r(i.outlineColor,x):void 0;var _=i.outlineWidth;if(this._fillEnabled=a,this._outlineEnabled=l,c.isConstant&&C.isConstant(e.orientation)&&u.isConstant&&C.isConstant(_)){var y=this._options;y.vertexFormat=g?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,y.dimensions=u.getValue(d.MINIMUM_VALUE,y.dimensions),this._outlineWidth=o(_)?_.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(r){var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.box;if(l.isShowing&&l.isAvailable(r)&&C.getValueOrDefault(u.show,r,!0)){var d=this._options,h=l._getModelMatrix(r),v=C.getValueOrUndefined(u.dimensions,r,d.dimensions);if(o(h)&&o(v)){if(d.dimensions=v,C.getValueOrDefault(u.fill,r,!0)){var g=y.getValue(r,s.fillMaterialProperty,this._material);this._material=g;var _=new m({material:g,translucent:g.isTranslucent(),closed:!0});d.vertexFormat=_.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:e.fromDimensions(d),modelMatrix:h}),appearance:_,asynchronous:!1}))}if(C.getValueOrDefault(u.outline,r,!1)){d.vertexFormat=p.VERTEX_FORMAT;var w=C.getValueOrClonedDefault(u.outlineColor,r,i.BLACK,T),E=C.getValueOrDefault(u.outlineWidth,r,1),b=1!==w.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:t.fromDimensions(d),modelMatrix:h,attributes:{color:n.fromColor(w)}}),appearance:new p({flat:!0,translucent:b,renderState:{lineWidth:s._scene.clampLineWidth(E)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},A}),define("Cesium/Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),define("Cesium/Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,i,n,r,o,a,s){"use strict";function l(e){var t=e._uSquared,i=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,r=(i-n)/i,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-r)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),u=l*s,c=Math.atan2(s,o),d=l*a,h=d*d,m=1-h,p=Math.sqrt(m),f=t/4,v=f*f,g=v*f,_=v*v,y=1+f-3*v/4+5*g/4-175*_/64,C=1-f+15*v/8-35*g/8,w=1-3*f+35*v/4,E=1-5*f,b=y*c-C*Math.sin(2*c)*f/2-w*Math.sin(4*c)*v/16-E*Math.sin(6*c)*g/48-5*Math.sin(8*c)*_/512,S=e._constants;S.a=i,S.b=n,S.f=r,S.cosineHeading=o,S.sineHeading=a,S.tanU=s,S.cosineU=l,S.sineU=u,S.sigma=c,S.sineAlpha=d,S.sineSquaredAlpha=h,S.cosineSquaredAlpha=m,S.cosineAlpha=p,S.u2Over4=f,S.u4Over16=v,S.u6Over64=g,S.u8Over256=_,S.a0=y,S.a1=C,S.a2=w,S.a3=E,S.distanceRatio=b}function u(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,i,n,r,o,a){var s=u(e,i);return(1-s)*e*t*(n+s*r*(a+s*o*(2*a*a-1)))}function d(e,t,i,n,r,o,a){var l,u,d,h,m,p=(t-i)/t,f=o-n,v=Math.atan((1-p)*Math.tan(r)),g=Math.atan((1-p)*Math.tan(a)),_=Math.cos(v),y=Math.sin(v),C=Math.cos(g),w=Math.sin(g),E=_*C,b=_*w,S=y*w,x=y*C,T=f,P=s.TWO_PI,A=Math.cos(T),M=Math.sin(T);do{A=Math.cos(T),M=Math.sin(T);var I=b-x*A;d=Math.sqrt(C*C*M*M+I*I),u=S+E*A,l=Math.atan2(d,u);var D;0===d?(D=0,h=1):(D=E*M/d,h=1-D*D),P=T,m=u-2*S/h,isNaN(m)&&(m=0),T=f+c(p,D,h,l,d,u,m)}while(Math.abs(T-P)>s.EPSILON12);var O=h*(t*t-i*i)/(i*i),R=1+O*(4096+O*(O*(320-175*O)-768))/16384,L=O*(256+O*(O*(74-47*O)-128))/1024,N=m*m,z=L*d*(m+L*(u*(2*N-1)-L*m*(4*d*d-3)*(4*N-3)/6)/4),F=i*R*(l-z),B=Math.atan2(C*M,b-x*A),V=Math.atan2(_*M,b*A-x);e._distance=F,e._startHeading=B,e._endHeading=V,e._uSquared=O}function h(i,n,r,o){e.normalize(o.cartographicToCartesian(n,p),m),e.normalize(o.cartographicToCartesian(r,p),p),d(i,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,r.longitude,r.latitude),i._start=t.clone(n,i._start),i._end=t.clone(r,i._end),i._start.height=0,i._end.height=0,l(i)}var m=new e,p=new e,f=function(e,r,o){var s=i(o,a.WGS84);this._ellipsoid=s,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(r)&&h(this,e,r,s)};return r(f.prototype,{surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),f.prototype.setEndPoints=function(e,t){h(this,e,t,this._ellipsoid)},f.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},f.prototype.interpolateUsingSurfaceDistance=function(e,i){var r=this._constants,o=r.distanceRatio+e/r.b,a=Math.cos(2*o),s=Math.cos(4*o),l=Math.cos(6*o),u=Math.sin(2*o),d=Math.sin(4*o),h=Math.sin(6*o),m=Math.sin(8*o),p=o*o,f=o*p,v=r.u8Over256,g=r.u2Over4,_=r.u6Over64,y=r.u4Over16,C=2*f*v*a/3+o*(1-g+7*y/4-15*_/4+579*v/64-(y-15*_/4+187*v/16)*a-(5*_/4-115*v/16)*s-29*v*l/16)+(g/2-y+71*_/32-85*v/16)*u+(5*y/16-5*_/4+383*v/96)*d-p*((_-11*v/2)*u+5*v*d/2)+(29*_/96-29*v/16)*h+539*v*m/1536,w=Math.asin(Math.sin(C)*r.cosineAlpha),E=Math.atan(r.a/r.b*Math.tan(w));C-=r.sigma;var b=Math.cos(2*r.sigma+C),S=Math.sin(C),x=Math.cos(C),T=r.cosineU*x,P=r.sineU*S,A=Math.atan2(S*r.sineHeading,T-P*r.cosineHeading),M=A-c(r.f,r.sineAlpha,r.cosineSquaredAlpha,C,S,x,b);return n(i)?(i.longitude=this._start.longitude+M,i.latitude=E,i.height=0,i):new t(this._start.longitude+M,E,0)},f}),define("Cesium/Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";function h(e,t,i){var n=S;n.length=e;var r;if(t===i){for(r=0;e>r;r++)n[r]=t;return n}var o=i-t,a=o/e;for(r=0;e>r;r++){var s=t+r*a;n[r]=s}return n}function m(t,i,n,r,o,a,s,l){var u=r.scaleToGeodeticSurface(t,A),c=r.scaleToGeodeticSurface(i,M),d=p.numberOfPoints(t,i,n),m=r.cartesianToCartographic(u,x),f=r.cartesianToCartographic(c,T),v=h(d,o,a);I.setEndPoints(m,f);var g=I.surfaceDistance/d,_=l;m.height=o;var y=r.cartographicToCartesian(m,P);e.pack(y,s,_),_+=3;for(var C=1;d>C;C++){var w=I.interpolateUsingSurfaceDistance(C*g,T);w.height=v[C],y=r.cartographicToCartesian(w,P),e.pack(y,s,_),_+=3}return _}var p={};p.numberOfPoints=function(t,i,n){var r=e.distance(t,i);return Math.ceil(r/n)};var f=new t;p.extractHeights=function(e,t){for(var i=e.length,n=new Array(i),r=0;i>r;r++){var o=e[r];n[r]=t.cartesianToCartographic(o,f).height}return n};var v=new c,g=new e,_=new e,y=new d(e.ZERO,0),C=new e,w=new d(e.ZERO,0),E=new e,b=new e,S=[],x=new t,T=new t,P=new e,A=new e,M=new e,I=new a;p.wrapLongitude=function(t,r){var o=[],a=[];if(n(t)&&t.length>0){r=i(r,c.IDENTITY);var l=c.inverseTransformation(r,v),u=c.multiplyByPoint(l,e.ZERO,g),h=c.multiplyByPointAsVector(l,e.UNIT_Y,_),m=d.fromPointNormal(u,h,y),p=c.multiplyByPointAsVector(l,e.UNIT_X,C),f=d.fromPointNormal(u,p,w),S=1;o.push(e.clone(t[0]));for(var x=o[0],T=t.length,P=1;T>P;++P){var A=t[P];if(d.getPointDistance(f,x)<0||d.getPointDistance(f,A)<0){var M=s.lineSegmentPlane(x,A,m,E);if(n(M)){var I=e.multiplyByScalar(h,5e-9,b);d.getPointDistance(m,x)<0&&e.negate(I,I),o.push(e.add(M,I,new e)),a.push(S+1),e.negate(I,I),o.push(e.add(M,I,new e)),S=1}}o.push(e.clone(t[P])),S++,x=A}a.push(S)}return{positions:o,lengths:a}};var D=u.EPSILON7;return p.removeDuplicates=function(t){var i=t.length;if(2>i)return void 0;var n,r,o;for(n=1;i>n&&(r=t[n-1],o=t[n],!e.equalsEpsilon(r,o,D));++n);if(n===i)return void 0;for(var a=t.slice(0,n);i>n;++n)o=t[n],e.equalsEpsilon(r,o,D)||(a.push(e.clone(o)),r=o);return a},p.generateArc=function(t){n(t)||(t={});var r=t.positions,a=i(t.ellipsoid,o.WGS84),s=i(t.height,0),c=t.minDistance;if(!n(c)){var d=i(t.granularity,u.RADIANS_PER_DEGREE);c=u.chordLength(d,a.maximumRadius)}var h,f=r.length,v=0;for(h=0;f-1>h;h++)v+=p.numberOfPoints(r[h],r[h+1],c);var g=3*(v+1),_=new Array(g),y=0,C=l(s);for(h=0;f-1>h;h++){var w=r[h],E=r[h+1],b=C?s[h]:s,T=C?s[h+1]:s;y=m(w,E,c,a,b,T,_,y)}S.length=0;var A=r[f-1],M=a.cartesianToCartographic(A,x);M.height=C?s[f-1]:s;var I=a.cartographicToCartesian(M,P);return e.pack(I,_,g-3),_},p.generateCartesianArc=function(t){for(var i=p.generateArc(t),n=i.length/3,r=new Array(n),o=0;n>o;o++)r[o]=e.unpack(i,3*o);return r},p}),define("Cesium/Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,i,n,r){"use strict";var o=function(n,r,o){this.minimum=e.clone(t(n,e.ZERO)),this.maximum=e.clone(t(r,e.ZERO)),i(o)?o=e.clone(o):(o=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(o,.5,o)),this.center=o};o.fromPoints=function(t,n){if(i(n)||(n=new o),!i(t)||0===t.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var r=t[0].x,a=t[0].y,s=t[0].z,l=t[0].x,u=t[0].y,c=t[0].z,d=t.length,h=1;d>h;h++){var m=t[h],p=m.x,f=m.y,v=m.z;r=Math.min(p,r),l=Math.max(p,l),a=Math.min(f,a),u=Math.max(f,u),s=Math.min(v,s),c=Math.max(v,c)}var g=n.minimum;g.x=r,g.y=a,g.z=s;var _=n.maximum;_.x=l,_.y=u,_.z=c;var y=e.add(g,_,n.center);return e.multiplyByScalar(y,.5,y),n},o.clone=function(t,n){return i(t)?i(n)?(n.minimum=e.clone(t.minimum,n.minimum),n.maximum=e.clone(t.maximum,n.maximum),n.center=e.clone(t.center,n.center),n):new o(t.minimum,t.maximum):void 0},o.equals=function(t,n){return t===n||i(t)&&i(n)&&e.equals(t.center,n.center)&&e.equals(t.minimum,n.minimum)&&e.equals(t.maximum,n.maximum)};var a=new e;return o.intersect=function(t,i){a=e.subtract(t.maximum,t.minimum,a);var n=e.multiplyByScalar(a,.5,a),o=n.x*Math.abs(i.x)+n.y*Math.abs(i.y)+n.z*Math.abs(i.z),s=e.dot(t.center,i)+i.w;return s-o>0?r.INSIDE:0>s+o?r.OUTSIDE:r.INTERSECTING},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.intersect=function(e){return o.intersect(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o}),define("Cesium/Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";var p=new n,f=function(e,t){t=r(t,l.WGS84),e=t.scaleToGeodeticSurface(e);var n=m.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=i.fromCartesian4(c.getColumn(n,0,p)),this._yAxis=i.fromCartesian4(c.getColumn(n,1,p));var o=i.fromCartesian4(c.getColumn(n,2,p));this._plane=d.fromPointNormal(e,o)};a(f.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var v=new e;f.fromPoints=function(t,i){var n=e.fromPoints(t,v);return new f(n.center,i)};var g=new h,_=new i;f.prototype.projectPointOntoPlane=function(e,n){var r=g;r.origin=e,i.normalize(e,r.direction);var a=u.rayPlane(r,this._plane,_);if(o(a)||(i.negate(r.direction,r.direction),a=u.rayPlane(r,this._plane,_)),o(a)){var s=i.subtract(a,this._origin,a),l=i.dot(this._xAxis,s),c=i.dot(this._yAxis,s);return o(n)?(n.x=l,n.y=c,n):new t(l,c)}return void 0},f.prototype.projectPointsOntoPlane=function(e,t){o(t)||(t=[]);for(var i=0,n=e.length,r=0;n>r;r++){var a=this.projectPointOntoPlane(e[r],t[i]);o(a)&&(t[i]=a,i++)}return t.length=i,t};var y=new i;return f.prototype.projectPointsOntoEllipsoid=function(e,t){var n=e.length;o(t)?t.length=n:t=new Array(n);for(var r=this._ellipsoid,a=this._origin,s=this._xAxis,l=this._yAxis,u=y,c=0;n>c;++c){var d=e[c];i.multiplyByScalar(s,d.x,u),o(t[c])||(t[c]=new i);var h=i.add(a,u,t[c]);i.multiplyByScalar(l,d.y,u),i.add(h,u,h),r.scaleToGeocentricSurface(h,h)}return t},f}),define("Cesium/Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";function h(e,t){for(var i=new Array(e.length),n=0;n<e.length;n++){var r=e[n];L=t.cartesianToCartographic(r,L),i[n]=L.height,e[n]=t.scaleToGeodeticSurface(r,r)}return i}function m(e,i,n,r){var o,a=e[0],s=e[1],l=t.angleBetween(a,s),u=Math.ceil(l/r),c=new Array(u);if(i===n){for(o=0;u>o;o++)c[o]=i;return c.push(n),c}var d=n-i,h=d/u;for(o=1;u>o;o++){var m=i+o*h;c[o]=m}return c[0]=i,c.push(n),c}function p(i,n,r,a){var s=new o(r,a),l=s.projectPointOntoPlane(t.add(r,i,Y),Y),u=s.projectPointOntoPlane(t.add(r,n,X),X),c=e.angleBetween(l,u);return u.x*l.y-u.y*l.x>=0?-c:c}function f(e,i,n,r,o,a,u,c){var h=k,m=U;z=d.eastNorthUpToFixedFrame(e,o,z),h=l.multiplyByPointAsVector(z,N,h),h=t.normalize(h,h);var f=p(h,i,e,o);B=s.fromRotationZ(f,B),W.z=a,z=l.multiplyTransformation(z,l.fromRotationTranslation(B,W,F),z);var v=V;v[0]=u;for(var g=0;c>g;g++)for(var _=0;_<n.length;_+=3)m=t.fromArray(n,_,m),m=s.multiplyByVector(v,m,m),m=l.multiplyByPoint(z,m,m),r.push(m.x,m.y,m.z);return r}function v(e,i,n,r,o,a,s){for(var l=0;l<e.length;l+=3){var u=t.fromArray(e,l,G);r=f(u,i,n,r,o,a[l/3],s,1)}return r}function g(e,t){var i=e.length,n=new Array(6*i),r=0,o=t.x+t.width/2,a=t.y+t.height/2,s=e[0];n[r++]=s.x-o,n[r++]=0,n[r++]=s.y-a;for(var l=1;i>l;l++){s=e[l];var u=s.x-o,c=s.y-a;n[r++]=u,n[r++]=0,n[r++]=c,n[r++]=u,n[r++]=0,n[r++]=c}return s=e[0],n[r++]=s.x-o,n[r++]=0,n[r++]=s.y-a,n}function _(e,t){for(var i=e.length,n=new Array(3*i),r=0,o=t.x+t.width/2,a=t.y+t.height/2,s=0;i>s;s++)n[r++]=e[s].x-o,n[r++]=0,n[r++]=e[s].y-a;return n}function y(e,i,n,o,l,u,d,h,m,p){var v,g=t.angleBetween(t.subtract(i,e,D),t.subtract(n,e,O)),_=o===r.BEVELED?0:Math.ceil(g/a.toRadians(5));v=l?s.fromQuaternion(c.fromAxisAngle(t.negate(e,D),g/(_+1),H),j):s.fromQuaternion(c.fromAxisAngle(e,g/(_+1),H),j);var y,C;if(i=t.clone(i,q),_>0)for(var w=p?2:1,E=0;_>E;E++)i=s.multiplyByVector(v,i,i),y=t.subtract(i,e,D),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(i,O),d=f(C,y,h,d,u,m,1,w);else y=t.subtract(i,e,D),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(i,O),d=f(C,y,h,d,u,m,1,1),n=t.clone(n,q),y=t.subtract(n,e,D),y=t.normalize(y,y),l||(y=t.negate(y,y)),C=u.scaleToGeodeticSurface(n,O),d=f(C,y,h,d,u,m,1,1);return d}function C(e,t){return a.equalsEpsilon(e.latitude,t.latitude,a.EPSILON6)&&a.equalsEpsilon(e.longitude,t.longitude,a.EPSILON6)}var w=[new t,new t],E=new t,b=new t,S=new t,x=new t,T=new t,P=new t,A=new t,M=new t,I=new t,D=new t,O=new t,R={},L=new n,N=new t(-1,0,0),z=new l,F=new l,B=new s,V=s.IDENTITY.clone(),k=new t,U=new i,W=new t,G=new t,H=new c,q=new t,j=new s;R.removeDuplicatesFromShape=function(t){for(var i=t.length,n=[],r=i-1,o=0;i>o;r=o++){var a=t[r],s=t[o];e.equals(a,s)||n.push(s)}return n};var Y=new t,X=new t;R.angleIsGreaterThanPi=function(e,i,n,r){var a=new o(n,r),s=a.projectPointOntoPlane(t.add(n,e,Y),Y),l=a.projectPointOntoPlane(t.add(n,i,X),X);return l.x*s.y-l.y*s.x>=0};var Z=new n,J=new n;R.removeDuplicatesFromPositions=function(e,t){var i=e.length;if(2>i)return e.slice(0);var n=[];n.push(e[0]);for(var r=1;i>r;++r){var o=e[r-1],a=e[r],s=t.cartesianToCartographic(o,Z),l=t.cartesianToCartographic(a,J);C(s,l)||n.push(a)}return n};var K=new t,Q=new t;return R.computePositions=function(e,i,n,o,s){var l=o._ellipsoid,c=h(e,l),d=o._granularity,p=o._cornerType,C=s?g(i,n):_(i,n),O=s?_(i,n):void 0,L=n.height/2,N=n.width/2,z=e.length,F=[],B=s?[]:void 0,V=E,k=b,U=S,W=x,G=T,H=P,q=A,j=M,Y=I,X=e[0],Z=e[1];W=l.geodeticSurfaceNormal(X,W),V=t.subtract(Z,X,V),V=t.normalize(V,V),j=t.cross(W,V,j),j=t.normalize(j,j);var J=c[0],$=c[1];s&&(B=f(X,j,O,B,l,J+L,1,1)),Y=t.clone(X,Y),X=Z,k=t.negate(V,k);for(var et,tt,it=1;z-1>it;it++){var nt=s?2:1;Z=e[it+1],V=t.subtract(Z,X,V),V=t.normalize(V,V),U=t.add(V,k,U),U=t.normalize(U,U),W=l.geodeticSurfaceNormal(X,W);var rt=t.multiplyByScalar(W,t.dot(V,W),K);t.subtract(V,rt,rt),t.normalize(rt,rt);var ot=t.multiplyByScalar(W,t.dot(k,W),Q);t.subtract(k,ot,ot),t.normalize(ot,ot);var at=!a.equalsEpsilon(Math.abs(t.dot(rt,ot)),1,a.EPSILON7);if(at){U=t.cross(U,W,U),U=t.cross(W,U,U),U=t.normalize(U,U);var st=1/Math.max(.25,t.magnitude(t.cross(U,k,D))),lt=R.angleIsGreaterThanPi(V,k,X,l);lt?(G=t.add(X,t.multiplyByScalar(U,st*N,U),G),H=t.add(G,t.multiplyByScalar(j,N,H),H),w[0]=t.clone(Y,w[0]),w[1]=t.clone(H,w[1]),et=m(w,J+L,$+L,d),tt=u.generateArc({positions:w,granularity:d,ellipsoid:l}),F=v(tt,j,C,F,l,et,1),j=t.cross(W,V,j),j=t.normalize(j,j),q=t.add(G,t.multiplyByScalar(j,N,q),q),p===r.ROUNDED||p===r.BEVELED?y(G,H,q,p,lt,l,F,C,$+L,s):(U=t.negate(U,U),F=f(X,U,C,F,l,$+L,st,nt)),Y=t.clone(q,Y)):(G=t.add(X,t.multiplyByScalar(U,st*N,U),G),H=t.add(G,t.multiplyByScalar(j,-N,H),H),w[0]=t.clone(Y,w[0]),w[1]=t.clone(H,w[1]),et=m(w,J+L,$+L,d),tt=u.generateArc({positions:w,granularity:d,ellipsoid:l}),F=v(tt,j,C,F,l,et,1),j=t.cross(W,V,j),j=t.normalize(j,j),q=t.add(G,t.multiplyByScalar(j,-N,q),q),p===r.ROUNDED||p===r.BEVELED?y(G,H,q,p,lt,l,F,C,$+L,s):F=f(X,U,C,F,l,$+L,st,nt),Y=t.clone(q,Y)),k=t.negate(V,k)}else F=f(Y,j,C,F,l,J+L,1,1),Y=X;J=$,$=c[it+1],X=Z}w[0]=t.clone(Y,w[0]),w[1]=t.clone(X,w[1]),et=m(w,J+L,$+L,d),tt=u.generateArc({positions:w,granularity:d,ellipsoid:l}),F=v(tt,j,C,F,l,et,1),s&&(B=f(X,j,O,B,l,$+L,1,1)),z=F.length;var ut=s?z+B.length:z,ct=new Float64Array(ut);return ct.set(F),s&&ct.set(B,z),ct},R}),define("Cesium/Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./isArray","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,t,i,n,r,o,a,s,l){"use strict";function u(i,n,a,s,u){var c=e.angleBetween(e.subtract(n,i,f),e.subtract(a,i,v)),d=s===t.BEVELED?1:Math.ceil(c/r.toRadians(5))+1,h=3*d,m=new Array(h);m[h-3]=a.x,m[h-2]=a.y,m[h-1]=a.z;var p;p=u?o.fromQuaternion(l.fromAxisAngle(e.negate(i,f),c/d,I),D):o.fromQuaternion(l.fromAxisAngle(i,c/d,I),D);var g=0;n=e.clone(n,f);for(var _=0;d>_;_++)n=o.multiplyByVector(p,n,n),m[g++]=n.x,m[g++]=n.y,m[g++]=n.z;return m}function c(i){var n=C,r=w,o=E,a=i[1];r=e.fromArray(i[1],a.length-3,r),o=e.fromArray(i[0],0,o),n=e.multiplyByScalar(e.add(r,o,n),.5,n);var s=u(n,r,o,t.ROUNDED,!1),l=i.length-1,c=i[l-1];a=i[l],r=e.fromArray(c,c.length-3,r),o=e.fromArray(a,0,o),n=e.multiplyByScalar(e.add(r,o,n),.5,n);var d=u(n,r,o,t.ROUNDED,!1);return[s,d]}function d(t,i,n,r){var o=f;return r?o=e.add(t,i,o):(i=e.negate(i,i),o=e.add(t,i,o)),[o.x,o.y,o.z,n.x,n.y,n.z]}function h(t,i,n,r){for(var o=new Array(t.length),a=new Array(t.length),s=e.multiplyByScalar(i,n,f),l=e.negate(s,v),u=0,c=t.length-1,d=0;d<t.length;d+=3){var h=e.fromArray(t,d,g),m=e.add(h,l,_);o[u++]=m.x,o[u++]=m.y,o[u++]=m.z;var p=e.add(h,s,_);a[c--]=p.z,a[c--]=p.y,a[c--]=p.x}return r.push(o,a),r}function m(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}var p={},f=new e,v=new e,g=new e,_=new e,y=[new e,new e],C=new e,w=new e,E=new e,b=new e,S=new e,x=new e,T=new e,P=new e,A=new e,M=new e,I=new l,D=new o;p.addAttribute=function(e,t,n,r){var o=t.x,a=t.y,s=t.z;i(n)&&(e[n]=o,e[n+1]=a,e[n+2]=s),i(r)&&(e[r]=s,e[r-1]=a,e[r-2]=o)};var O=new e,R=new e;p.computePositions=function(i){var n=i.granularity,o=i.positions,l=i.ellipsoid;o=m(o,l);var p=i.width/2,v=i.cornerType,g=i.saveAttributes,_=C,I=w,D=E,L=b,N=S,z=x,F=T,B=P,V=A,k=M,U=[],W=g?[]:void 0,G=g?[]:void 0,H=o[0],q=o[1];I=e.normalize(e.subtract(q,H,I),I),_=l.geodeticSurfaceNormal(H,_),L=e.normalize(e.cross(_,I,L),L),g&&(W.push(L.x,L.y,L.z),G.push(_.x,_.y,_.z)),F=e.clone(H,F),H=q,D=e.negate(I,D);var j,Y,X=[],Z=o.length;for(Y=1;Z-1>Y;Y++){_=l.geodeticSurfaceNormal(H,_),q=o[Y+1],I=e.normalize(e.subtract(q,H,I),I),N=e.normalize(e.add(I,D,N),N);var J=e.multiplyByScalar(_,e.dot(I,_),O);e.subtract(I,J,J),e.normalize(J,J);var K=e.multiplyByScalar(_,e.dot(D,_),R);e.subtract(D,K,K),e.normalize(K,K);var Q=!r.equalsEpsilon(Math.abs(e.dot(J,K)),1,r.EPSILON7);if(Q){N=e.cross(N,_,N),N=e.cross(_,N,N);var $=p/Math.max(.25,e.magnitude(e.cross(N,D,f))),et=s.angleIsGreaterThanPi(I,D,H,l);N=e.multiplyByScalar(N,$,N),et?(B=e.add(H,N,B),k=e.add(B,e.multiplyByScalar(L,p,k),k),V=e.add(B,e.multiplyByScalar(L,2*p,V),V),y[0]=e.clone(F,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:n,ellipsoid:l}),U=h(j,L,p,U),g&&(W.push(L.x,L.y,L.z),G.push(_.x,_.y,_.z)),z=e.clone(V,z),L=e.normalize(e.cross(_,I,L),L),V=e.add(B,e.multiplyByScalar(L,2*p,V),V),F=e.add(B,e.multiplyByScalar(L,p,F),F),v===t.ROUNDED||v===t.BEVELED?X.push({leftPositions:u(B,z,V,v,et)}):X.push({leftPositions:d(H,e.negate(N,N),V,et)})):(V=e.add(H,N,V),k=e.add(V,e.negate(e.multiplyByScalar(L,p,k),k),k),B=e.add(V,e.negate(e.multiplyByScalar(L,2*p,B),B),B),y[0]=e.clone(F,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:n,ellipsoid:l}),U=h(j,L,p,U),g&&(W.push(L.x,L.y,L.z),G.push(_.x,_.y,_.z)),z=e.clone(B,z),L=e.normalize(e.cross(_,I,L),L),B=e.add(V,e.negate(e.multiplyByScalar(L,2*p,B),B),B),F=e.add(V,e.negate(e.multiplyByScalar(L,p,F),F),F),v===t.ROUNDED||v===t.BEVELED?X.push({rightPositions:u(V,z,B,v,et)}):X.push({rightPositions:d(H,N,B,et)})),D=e.negate(I,D)}H=q}_=l.geodeticSurfaceNormal(H,_),y[0]=e.clone(F,y[0]),y[1]=e.clone(H,y[1]),j=a.generateArc({positions:y,granularity:n,ellipsoid:l}),U=h(j,L,p,U),g&&(W.push(L.x,L.y,L.z),G.push(_.x,_.y,_.z));var tt;return v===t.ROUNDED&&(tt=c(U)),{positions:U,corners:X,lefts:W,normals:G,endPositions:tt}};var L=new e,N=new e;return p.scaleToGeodeticHeight=function(t,i,r,o){var a=t.length,s=n(o)?o:new Array(t.length);s.length=t.length;for(var l=i,u=0;a>u;u+=3){var c=r.scaleToGeodeticSurface(e.fromArray(t,u,N),N),d=L;0!==i&&(d=r.geodeticSurfaceNormal(c,d),d=e.multiplyByScalar(d,l,d),c=e.add(c,d,c)),s[u]=c.x,s[u+1]=c.y,s[u+2]=c.z}return s},p}),define("Cesium/Core/CorridorGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v){"use strict";function g(e,i,n,o,a,s){var l=e.normals,u=e.tangents,c=e.binormals,d=t.normalize(t.cross(n,i,A),A);s.normal&&r.addAttribute(l,i,o,a),s.binormal&&r.addAttribute(c,n,o,a),s.tangent&&r.addAttribute(u,d,o,a)}function _(e,n,o){var s,l,u,p=e.positions,f=e.corners,v=e.endPositions,_=e.lefts,y=e.normals,C=new d,w=0,T=0,I=0;for(l=0;l<p.length;l+=2)u=p[l].length-3,w+=u,I+=2*u,T+=p[l+1].length-3;
for(w+=3,T+=3,l=0;l<f.length;l++){s=f[l];var D=f[l].leftPositions;a(D)?(u=D.length,w+=u,I+=u):(u=f[l].rightPositions.length,T+=u,I+=u)}var O,R=a(v);R&&(O=v[0].length-3,w+=O,T+=O,O/=3,I+=6*O);var L,N,z,F,B,V,k=w+T,U=new Float64Array(k),W=n.normal?new Float32Array(k):void 0,G=n.tangent?new Float32Array(k):void 0,H=n.binormal?new Float32Array(k):void 0,q={normals:W,tangents:G,binormals:H},j=0,Y=k-1,X=E,Z=b,J=O/2,K=h.createTypedArray(k/3,I),Q=0;if(R){V=S,B=x;var $=v[0];for(X=t.fromArray(y,0,X),Z=t.fromArray(_,0,Z),l=0;J>l;l++)V=t.fromArray($,3*(J-1-l),V),B=t.fromArray($,3*(J+l),B),r.addAttribute(U,B,j),r.addAttribute(U,V,void 0,Y),g(q,X,Z,j,Y,n),N=j/3,F=N+1,L=(Y-2)/3,z=L-1,K[Q++]=L,K[Q++]=N,K[Q++]=z,K[Q++]=z,K[Q++]=N,K[Q++]=F,j+=3,Y-=3}var et=0,tt=0,it=p[et++],nt=p[et++];U.set(it,j),U.set(nt,Y-nt.length+1),Z=t.fromArray(_,tt,Z);var rt,ot;for(u=nt.length-3,l=0;u>l;l+=3)rt=o.geodeticSurfaceNormal(t.fromArray(it,l,A),A),ot=o.geodeticSurfaceNormal(t.fromArray(nt,u-l,M),M),X=t.normalize(t.add(rt,ot,X),X),g(q,X,Z,j,Y,n),N=j/3,F=N+1,L=(Y-2)/3,z=L-1,K[Q++]=L,K[Q++]=N,K[Q++]=z,K[Q++]=z,K[Q++]=N,K[Q++]=F,j+=3,Y-=3;for(rt=o.geodeticSurfaceNormal(t.fromArray(it,u,A),A),ot=o.geodeticSurfaceNormal(t.fromArray(nt,u,M),M),X=t.normalize(t.add(rt,ot,X),X),tt+=3,l=0;l<f.length;l++){var at;s=f[l];var st,lt,ut=s.leftPositions,ct=s.rightPositions,dt=P,ht=S,mt=x;if(X=t.fromArray(y,tt,X),a(ut)){for(g(q,X,Z,void 0,Y,n),Y-=3,st=F,lt=z,at=0;at<ut.length/3;at++)dt=t.fromArray(ut,3*at,dt),K[Q++]=st,K[Q++]=lt-at-1,K[Q++]=lt-at,r.addAttribute(U,dt,void 0,Y),ht=t.fromArray(U,3*(lt-at-1),ht),mt=t.fromArray(U,3*st,mt),Z=t.normalize(t.subtract(ht,mt,Z),Z),g(q,X,Z,void 0,Y,n),Y-=3;dt=t.fromArray(U,3*st,dt),ht=t.subtract(t.fromArray(U,3*lt,ht),dt,ht),mt=t.subtract(t.fromArray(U,3*(lt-at),mt),dt,mt),Z=t.normalize(t.add(ht,mt,Z),Z),g(q,X,Z,j,void 0,n),j+=3}else{for(g(q,X,Z,j,void 0,n),j+=3,st=z,lt=F,at=0;at<ct.length/3;at++)dt=t.fromArray(ct,3*at,dt),K[Q++]=st,K[Q++]=lt+at,K[Q++]=lt+at+1,r.addAttribute(U,dt,j),ht=t.fromArray(U,3*st,ht),mt=t.fromArray(U,3*(lt+at),mt),Z=t.normalize(t.subtract(ht,mt,Z),Z),g(q,X,Z,j,void 0,n),j+=3;dt=t.fromArray(U,3*st,dt),ht=t.subtract(t.fromArray(U,3*(lt+at),ht),dt,ht),mt=t.subtract(t.fromArray(U,3*lt,mt),dt,mt),Z=t.normalize(t.negate(t.add(mt,ht,Z),Z),Z),g(q,X,Z,void 0,Y,n),Y-=3}for(it=p[et++],nt=p[et++],it.splice(0,3),nt.splice(nt.length-3,3),U.set(it,j),U.set(nt,Y-nt.length+1),u=nt.length-3,tt+=3,Z=t.fromArray(_,tt,Z),at=0;at<nt.length;at+=3)rt=o.geodeticSurfaceNormal(t.fromArray(it,at,A),A),ot=o.geodeticSurfaceNormal(t.fromArray(nt,u-at,M),M),X=t.normalize(t.add(rt,ot,X),X),g(q,X,Z,j,Y,n),F=j/3,N=F-1,z=(Y-2)/3,L=z+1,K[Q++]=L,K[Q++]=N,K[Q++]=z,K[Q++]=z,K[Q++]=N,K[Q++]=F,j+=3,Y-=3;j-=3,Y+=3}if(X=t.fromArray(y,y.length-3,X),g(q,X,Z,j,Y,n),R){j+=3,Y-=3,V=S,B=x;var pt=v[1];for(l=0;J>l;l++)V=t.fromArray(pt,3*(O-l-1),V),B=t.fromArray(pt,3*l,B),r.addAttribute(U,V,void 0,Y),r.addAttribute(U,B,j),g(q,X,Z,j,Y,n),F=j/3,N=F-1,z=(Y-2)/3,L=z+1,K[Q++]=L,K[Q++]=N,K[Q++]=z,K[Q++]=z,K[Q++]=N,K[Q++]=F,j+=3,Y-=3}if(C.position=new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:U}),n.st){var ft,vt,gt=new Float32Array(2*(k/3)),_t=0;if(R){w/=3,T/=3;var yt=Math.PI/(O+1);vt=1/(w-O+1),ft=1/(T-O+1);var Ct,wt=O/2;for(l=wt+1;O+1>l;l++)Ct=m.PI_OVER_TWO+yt*l,gt[_t++]=ft*(1+Math.cos(Ct)),gt[_t++]=.5*(1+Math.sin(Ct));for(l=1;T-O+1>l;l++)gt[_t++]=l*ft,gt[_t++]=0;for(l=O;l>wt;l--)Ct=m.PI_OVER_TWO-l*yt,gt[_t++]=1-ft*(1+Math.cos(Ct)),gt[_t++]=.5*(1+Math.sin(Ct));for(l=wt;l>0;l--)Ct=m.PI_OVER_TWO-yt*l,gt[_t++]=1-vt*(1+Math.cos(Ct)),gt[_t++]=.5*(1+Math.sin(Ct));for(l=w-O;l>0;l--)gt[_t++]=l*vt,gt[_t++]=1;for(l=1;wt+1>l;l++)Ct=m.PI_OVER_TWO+yt*l,gt[_t++]=vt*(1+Math.cos(Ct)),gt[_t++]=.5*(1+Math.sin(Ct))}else{for(w/=3,T/=3,vt=1/(w-1),ft=1/(T-1),l=0;T>l;l++)gt[_t++]=l*ft,gt[_t++]=0;for(l=w;l>0;l--)gt[_t++]=(l-1)*vt,gt[_t++]=1}C.st=new c({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:gt})}return n.normal&&(C.normal=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:q.normals})),n.tangent&&(C.tangent=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:q.tangents})),n.binormal&&(C.binormal=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:q.binormals})),{attributes:C,indices:K}}function y(e,i){if(!(i.normal||i.binormal||i.tangent||i.st))return e;var n,o,a=e.position.values;(i.normal||i.binormal)&&(n=e.normal.values,o=e.binormal.values);var s,l=e.position.values.length/18,u=3*l,c=2*l,d=2*u;if(i.normal||i.binormal||i.tangent){var h=i.normal?new Float32Array(6*u):void 0,m=i.binormal?new Float32Array(6*u):void 0,p=i.tangent?new Float32Array(6*u):void 0,f=E,v=b,g=S,_=x,y=T,C=P,w=d;for(s=0;u>s;s+=3){var A=w+d;f=t.fromArray(a,s,f),v=t.fromArray(a,s+u,v),g=t.fromArray(a,(s+3)%u,g),v=t.subtract(v,f,v),g=t.subtract(g,f,g),_=t.normalize(t.cross(v,g,_),_),i.normal&&(r.addAttribute(h,_,A),r.addAttribute(h,_,A+3),r.addAttribute(h,_,w),r.addAttribute(h,_,w+3)),(i.tangent||i.binormal)&&(C=t.fromArray(n,s,C),i.binormal&&(r.addAttribute(m,C,A),r.addAttribute(m,C,A+3),r.addAttribute(m,C,w),r.addAttribute(m,C,w+3)),i.tangent&&(y=t.normalize(t.cross(C,_,y),y),r.addAttribute(p,y,A),r.addAttribute(p,y,A+3),r.addAttribute(p,y,w),r.addAttribute(p,y,w+3))),w+=6}if(i.normal){for(h.set(n),s=0;u>s;s+=3)h[s+u]=-n[s],h[s+u+1]=-n[s+1],h[s+u+2]=-n[s+2];e.normal.values=h}else e.normal=void 0;if(i.binormal?(m.set(o),m.set(o,u),e.binormal.values=m):e.binormal=void 0,i.tangent){var M=e.tangent.values;p.set(M),p.set(M,u),e.tangent.values=p}}if(i.st){var I=e.st.values,D=new Float32Array(6*c);D.set(I),D.set(I,c);for(var O=2*c,R=0;2>R;R++){for(D[O++]=I[0],D[O++]=I[1],s=2;c>s;s+=2){var L=I[s],N=I[s+1];D[O++]=L,D[O++]=N,D[O++]=L,D[O++]=N}D[O++]=I[0],D[O++]=I[1]}e.st.values=D}return e}function C(e,t,i){i[t++]=e[0],i[t++]=e[1],i[t++]=e[2];for(var n=3;n<e.length;n+=3){var r=e[n],o=e[n+1],a=e[n+2];i[t++]=r,i[t++]=o,i[t++]=a,i[t++]=r,i[t++]=o,i[t++]=a}return i[t++]=e[0],i[t++]=e[1],i[t++]=e[2],i}function w(e,t){var i=new v({position:t.positon,normal:t.normal||t.binormal,tangent:t.tangent,binormal:t.normal||t.binormal,st:t.st}),n=e.ellipsoid,o=r.computePositions(e),a=_(o,i,n),s=e.height,l=e.extrudedHeight,u=a.attributes,c=a.indices,d=u.position.values,m=d.length,p=new Float64Array(6*m),f=new Float64Array(m);f.set(d);var g=new Float64Array(4*m);d=r.scaleToGeodeticHeight(d,s,n,d),g=C(d,0,g),f=r.scaleToGeodeticHeight(f,l,n,f),g=C(f,2*m,g),p.set(d),p.set(f,m),p.set(g,2*m),u.position.values=p,m/=3;var w,E=c.length,b=m+m,S=h.createTypedArray(p.length/3,2*E+3*b);S.set(c);var x=E;for(w=0;E>w;w+=3){var T=c[w],P=c[w+1],A=c[w+2];S[x++]=A+m,S[x++]=P+m,S[x++]=T+m}u=y(u,t);var M,I,D,O;for(w=0;b>w;w+=2)M=w+b,I=M+b,D=M+1,O=I+1,S[x++]=M,S[x++]=I,S[x++]=D,S[x++]=D,S[x++]=I,S[x++]=O;return{attributes:u,indices:S}}var E=new t,b=new t,S=new t,x=new t,T=new t,P=new t,A=new t,M=new t,I=function(e){e=o(e,o.EMPTY_OBJECT);var i=e.positions,r=e.width;this._positions=i,this._ellipsoid=l.clone(o(e.ellipsoid,l.WGS84)),this._vertexFormat=v.clone(o(e.vertexFormat,v.DEFAULT)),this._width=r,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,n.ROUNDED),this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry",this.packedLength=1+i.length*t.packedLength+l.packedLength+v.packedLength+5};I.pack=function(e,i,n){n=o(n,0);var r=e._positions,a=r.length;i[n++]=a;for(var s=0;a>s;++s,n+=t.packedLength)t.pack(r[s],i,n);l.pack(e._ellipsoid,i,n),n+=l.packedLength,v.pack(e._vertexFormat,i,n),n+=v.packedLength,i[n++]=e._width,i[n++]=e._height,i[n++]=e._extrudedHeight,i[n++]=e._cornerType,i[n]=e._granularity};var D=l.clone(l.UNIT_SPHERE),O=new v,R={positions:void 0,ellipsoid:D,vertexFormat:O,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return I.unpack=function(e,i,n){i=o(i,0);for(var r=e[i++],s=new Array(r),u=0;r>u;++u,i+=t.packedLength)s[u]=t.unpack(e,i);var c=l.unpack(e,i,D);i+=l.packedLength;var d=v.unpack(e,i,O);i+=v.packedLength;var h=e[i++],m=e[i++],p=e[i++],f=e[i++],g=e[i];return a(n)?(n._positions=s,n._ellipsoid=l.clone(c,n._ellipsoid),n._vertexFormat=v.clone(d,n._vertexFormat),n._width=h,n._height=m,n._extrudedHeight=p,n._cornerType=f,n._granularity=g,n):(R.positions=s,R.width=h,R.height=m,R.extrudedHeight=p,R.cornerType=f,R.granularity=g,new I(R))},I.createGeometry=function(t){var i=t._positions,n=t._height,o=t._extrudedHeight,s=n!==o,l=p.removeDuplicates(i);if(a(l)||(l=i),l.length<2)return void 0;var c,d=t._ellipsoid,h=t._vertexFormat,m={ellipsoid:d,positions:l,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!0};if(s){var v=Math.max(n,o);o=Math.min(n,o),n=v,m.height=n,m.extrudedHeight=o,c=w(m,h)}else{var g=r.computePositions(m);c=_(g,h,d),c.attributes.position.values=r.scaleToGeodeticHeight(c.attributes.position.values,n,d,c.attributes.position.values)}var y=c.attributes,C=e.fromVertices(y.position.values,void 0,3);return h.position||(c.attributes.position.values=void 0),new u({attributes:y,indices:c.indices,primitiveType:f.TRIANGLES,boundingSphere:C})},I}),define("Cesium/Core/CorridorOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f){"use strict";function v(e,o){var s,l,u,m=[],p=e.positions,f=e.corners,v=e.endPositions,g=new d,w=0,E=0,b=0;for(l=0;l<p.length;l+=2)u=p[l].length-3,w+=u,b+=4*(u/3),E+=p[l+1].length-3;for(w+=3,E+=3,l=0;l<f.length;l++){s=f[l];var S=f[l].leftPositions;a(S)?(u=S.length,w+=u,b+=2*(u/3)):(u=f[l].rightPositions.length,E+=u,b+=2*(u/3))}var x,T=a(v);T&&(x=v[0].length-3,w+=x,E+=x,x/=3,b+=4*x);var P,A,M,I,D,O,R=w+E,L=new Float64Array(R),N=0,z=R-1,F=x/2,B=h.createTypedArray(R/3,b+4),V=0;if(B[V++]=N/3,B[V++]=(z-2)/3,T){m.push(N/3),O=_,D=y;var k=v[0];for(l=0;F>l;l++)O=t.fromArray(k,3*(F-1-l),O),D=t.fromArray(k,3*(F+l),D),r.addAttribute(L,D,N),r.addAttribute(L,O,void 0,z),A=N/3,I=A+1,P=(z-2)/3,M=P-1,B[V++]=P,B[V++]=M,B[V++]=A,B[V++]=I,N+=3,z-=3}var U=0,W=p[U++],G=p[U++];for(L.set(W,N),L.set(G,z-G.length+1),u=G.length-3,m.push(N/3,(z-2)/3),l=0;u>l;l+=3)A=N/3,I=A+1,P=(z-2)/3,M=P-1,B[V++]=P,B[V++]=M,B[V++]=A,B[V++]=I,N+=3,z-=3;for(l=0;l<f.length;l++){var H;s=f[l];var q,j=s.leftPositions,Y=s.rightPositions,X=C;if(a(j)){for(z-=3,q=M,m.push(I),H=0;H<j.length/3;H++)X=t.fromArray(j,3*H,X),B[V++]=q-H-1,B[V++]=q-H,r.addAttribute(L,X,void 0,z),z-=3;m.push(q-Math.floor(j.length/6)),o===n.BEVELED&&m.push((z-2)/3+1),N+=3}else{for(N+=3,q=I,m.push(M),H=0;H<Y.length/3;H++)X=t.fromArray(Y,3*H,X),B[V++]=q+H,B[V++]=q+H+1,r.addAttribute(L,X,N),N+=3;m.push(q+Math.floor(Y.length/6)),o===n.BEVELED&&m.push(N/3-1),z-=3}for(W=p[U++],G=p[U++],W.splice(0,3),G.splice(G.length-3,3),L.set(W,N),L.set(G,z-G.length+1),u=G.length-3,H=0;H<G.length;H+=3)I=N/3,A=I-1,M=(z-2)/3,P=M+1,B[V++]=P,B[V++]=M,B[V++]=A,B[V++]=I,N+=3,z-=3;N-=3,z+=3,m.push(N/3,(z-2)/3)}if(T){N+=3,z-=3,O=_,D=y;var Z=v[1];for(l=0;F>l;l++)O=t.fromArray(Z,3*(x-l-1),O),D=t.fromArray(Z,3*l,D),r.addAttribute(L,O,void 0,z),r.addAttribute(L,D,N),I=N/3,A=I-1,M=(z-2)/3,P=M+1,B[V++]=P,B[V++]=M,B[V++]=A,B[V++]=I,N+=3,z-=3;m.push(N/3)}else m.push(N/3,(z-2)/3);return B[V++]=N/3,B[V++]=(z-2)/3,g.position=new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:L}),{attributes:g,indices:B,wallIndices:m}}function g(e){var t=e.ellipsoid,i=r.computePositions(e),n=v(i,e.cornerType),o=n.wallIndices,a=e.height,s=e.extrudedHeight,l=n.attributes,u=n.indices,c=l.position.values,d=c.length,m=new Float64Array(d);m.set(c);var p=new Float64Array(2*d);c=r.scaleToGeodeticHeight(c,a,t,c),m=r.scaleToGeodeticHeight(m,s,t,m),p.set(c),p.set(m,d),l.position.values=p,d/=3;var f,g=u.length,_=h.createTypedArray(p.length/3,2*(g+o.length));_.set(u);var y=g;for(f=0;g>f;f+=2){var C=u[f],w=u[f+1];_[y++]=C+d,_[y++]=w+d}var E,b;for(f=0;f<o.length;f++)E=o[f],b=E+d,_[y++]=E,_[y++]=b;return{attributes:l,indices:_}}var _=new t,y=new t,C=new t,w=function(e){e=o(e,o.EMPTY_OBJECT);var i=e.positions,r=e.width;this._positions=i,this._ellipsoid=l.clone(o(e.ellipsoid,l.WGS84)),this._width=r,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,n.ROUNDED),this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createCorridorOutlineGeometry",this.packedLength=1+i.length*t.packedLength+l.packedLength+5};w.pack=function(e,i,n){n=o(n,0);var r=e._positions,a=r.length;i[n++]=a;for(var s=0;a>s;++s,n+=t.packedLength)t.pack(r[s],i,n);l.pack(e._ellipsoid,i,n),n+=l.packedLength,i[n++]=e._width,i[n++]=e._height,i[n++]=e._extrudedHeight,i[n++]=e._cornerType,i[n]=e._granularity};var E=l.clone(l.UNIT_SPHERE),b={positions:void 0,ellipsoid:E,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return w.unpack=function(e,i,n){i=o(i,0);for(var r=e[i++],s=new Array(r),u=0;r>u;++u,i+=t.packedLength)s[u]=t.unpack(e,i);var c=l.unpack(e,i,E);i+=l.packedLength;var d=e[i++],h=e[i++],m=e[i++],p=e[i++],f=e[i];return a(n)?(n._positions=s,n._ellipsoid=l.clone(c,n._ellipsoid),n._width=d,n._height=h,n._extrudedHeight=m,n._cornerType=p,n._granularity=f,n):(b.positions=s,b.width=d,b.height=h,b.extrudedHeight=m,b.cornerType=p,b.granularity=f,new w(b))},w.createGeometry=function(t){var i=t._positions,n=t._height,o=t._extrudedHeight,s=n!==o,l=p.removeDuplicates(i);if(a(l)||(l=i),l.length<2)return void 0;var c,d=t._ellipsoid,h={ellipsoid:d,positions:l,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!1};if(s){var m=Math.max(n,o);o=Math.min(n,o),n=m,h.height=n,h.extrudedHeight=o,c=g(h)}else{var _=r.computePositions(h);c=v(_,h.cornerType),c.attributes.position.values=r.scaleToGeodeticHeight(c.attributes.position.values,n,d,c.attributes.position.values)}var y=c.attributes,C=e.fromVertices(y.position.values,void 0,3);return new u({attributes:y,indices:c.indices,primitiveType:f.LINES,boundingSphere:C})},w}),define("Cesium/DataSources/CorridorGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CorridorGeometry","../Core/CorridorOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(e.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(e.BLACK),T=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.positions=void 0,this.width=void 0,this.cornerType=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"corridor",e.corridor,void 0)};a(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),a(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(n){var r,a,s=this._entity,l=s.isAvailable(n),u=new h(l&&this._showProperty.getValue(n)&&this._fillProperty.getValue(n));if(this._materialProperty instanceof v){var d=e.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(d=this._materialProperty.color.getValue(n)),a=t.fromColor(d),r={show:u,color:a}}else r={show:u};return new c({id:s,geometry:new i(this._options),attributes:r})},A.prototype.createOutlineGeometryInstance=function(i){var r=this._entity,o=r.isAvailable(i),a=C.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new c({id:r,geometry:new n(this._options),attributes:{show:new h(o&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(a)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),s(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"corridor"===t){var i=this._entity.corridor;if(!o(i))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var n=i.fill,a=o(n)&&n.isConstant?n.getValue(d.MINIMUM_VALUE):!0,s=i.outline,l=o(s);if(l&&s.isConstant&&(l=s.getValue(d.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var u=i.positions,c=i.show;if(o(c)&&c.isConstant&&!c.getValue(d.MINIMUM_VALUE)||!o(u))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var h=r(i.material,w),f=h instanceof v;this._materialProperty=h,this._fillProperty=r(n,b),this._showProperty=r(c,E),this._showOutlineProperty=r(i.outline,S),this._outlineColorProperty=l?r(i.outlineColor,x):void 0;var g=i.height,_=i.extrudedHeight,y=i.granularity,T=i.width,P=i.outlineWidth,A=i.cornerType;if(this._isClosed=o(_),this._fillEnabled=a,this._outlineEnabled=l,u.isConstant&&C.isConstant(g)&&C.isConstant(_)&&C.isConstant(y)&&C.isConstant(T)&&C.isConstant(P)&&C.isConstant(A)){var M=this._options;M.vertexFormat=f?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,M.positions=u.getValue(d.MINIMUM_VALUE,M.positions),M.height=o(g)?g.getValue(d.MINIMUM_VALUE):void 0,M.extrudedHeight=o(_)?_.getValue(d.MINIMUM_VALUE):void 0,M.granularity=o(y)?y.getValue(d.MINIMUM_VALUE):void 0,M.width=o(T)?T.getValue(d.MINIMUM_VALUE):void 0,M.cornerType=o(A)?A.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=o(P)?P.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(r){var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.corridor;if(l.isShowing&&l.isAvailable(r)&&C.getValueOrDefault(u.show,r,!0)){var d=this._options,h=C.getValueOrUndefined(u.positions,r,d.positions),v=C.getValueOrUndefined(u.width,r);if(o(h)&&o(v)){if(d.positions=h,d.width=v,d.height=C.getValueOrUndefined(u.height,r),d.extrudedHeight=C.getValueOrUndefined(u.extrudedHeight,r),d.granularity=C.getValueOrUndefined(u.granularity,r),d.cornerType=C.getValueOrUndefined(u.cornerType,r),!o(u.fill)||u.fill.getValue(r)){var g=y.getValue(r,s.fillMaterialProperty,this._material);this._material=g;var _=new m({material:g,translucent:g.isTranslucent(),closed:o(d.extrudedHeight)});d.vertexFormat=_.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:new i(d)}),appearance:_,asynchronous:!1}))}if(o(u.outline)&&u.outline.getValue(r)){d.vertexFormat=p.VERTEX_FORMAT;var w=C.getValueOrClonedDefault(u.outlineColor,r,e.BLACK,T),E=C.getValueOrDefault(u.outlineWidth,r,1),b=1!==w.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:new n(d),attributes:{color:t.fromColor(w)}}),appearance:new p({flat:!0,translucent:b,renderState:{lineWidth:s._scene.clampLineWidth(E)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},A}),define("Cesium/DataSources/CustomDataSource",["../Core/defineProperties","../Core/Event","./DataSource","./EntityCollection"],function(e,t,i,n){"use strict";var r=function(e){this._name=e,this._clock=void 0,this._changed=new t,this._error=new t,this._isLoading=!1,this._loading=new t,this._entityCollection=new n};return e(r.prototype,{name:{get:function(){return this._name},set:function(e){this._name!==e&&(this._name=e,this._changed.raiseEvent(this))}},clock:{get:function(){return this._clock},set:function(e){this._clock!==e&&(this._clock=e,this._changed.raiseEvent(this))}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading},set:function(e){i.setLoading(this,e)}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),r}),define("Cesium/Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,i,n,r,o){var a,s=.5*t,l=-s,u=r+r,c=o?2*u:u,d=new Float64Array(3*c),h=0,m=0,p=o?3*u:0,f=o?3*(u+r):3*r;for(a=0;r>a;a++){var v=a/r*e.TWO_PI,g=Math.cos(v),_=Math.sin(v),y=g*n,C=_*n,w=g*i,E=_*i;d[m+p]=y,d[m+p+1]=C,d[m+p+2]=l,d[m+f]=w,d[m+f+1]=E,d[m+f+2]=s,m+=3,o&&(d[h++]=y,d[h++]=C,d[h++]=l,d[h++]=w,d[h++]=E,d[h++]=s)}return d},t}),define("Cesium/Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p){"use strict";var f=new t,v=new i,g=new i,_=new i,y=new i,C=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,i=e.topRadius,n=e.bottomRadius,r=o(e.vertexFormat,p.DEFAULT),a=o(e.slices,128);this._length=t,this._topRadius=i,this._bottomRadius=n,this._vertexFormat=p.clone(r),this._slices=a,this._workerName="createCylinderGeometry"};C.packedLength=p.packedLength+4,C.pack=function(e,t,i){i=o(i,0),p.pack(e._vertexFormat,t,i),i+=p.packedLength,t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i]=e._slices};var w=new p,E={vertexFormat:w,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};return C.unpack=function(e,t,i){t=o(t,0);var n=p.unpack(e,t,w);t+=p.packedLength;var r=e[t++],s=e[t++],l=e[t++],u=e[t];return a(i)?(i._vertexFormat=p.clone(n,i._vertexFormat),i._length=r,i._topRadius=s,i._bottomRadius=l,i._slices=u,i):(E.length=r,E.topRadius=s,E.bottomRadius=l,E.slices=u,new C(E))},C.createGeometry=function(o){var a,s=o._length,p=o._topRadius,C=o._bottomRadius,w=o._vertexFormat,E=o._slices,b=E+E,S=E+b,x=b+b,T=r.computePositions(s,p,C,E,!0),P=w.st?new Float32Array(2*x):void 0,A=w.normal?new Float32Array(3*x):void 0,M=w.tangent?new Float32Array(3*x):void 0,I=w.binormal?new Float32Array(3*x):void 0,D=w.normal||w.tangent||w.binormal;if(D){var O=w.tangent||w.binormal,R=0,L=0,N=0,z=v;z.z=0;var F=_,B=g;for(a=0;E>a;a++){var V=a/E*h.TWO_PI,k=Math.cos(V),U=Math.sin(V);D&&(z.x=k,z.y=U,O&&(F=i.normalize(i.cross(i.UNIT_Z,z,F),F)),w.normal&&(A[R++]=k,A[R++]=U,A[R++]=0,A[R++]=k,A[R++]=U,A[R++]=0),w.tangent&&(M[L++]=F.x,M[L++]=F.y,M[L++]=F.z,M[L++]=F.x,M[L++]=F.y,M[L++]=F.z),w.binormal&&(B=i.normalize(i.cross(z,F,B),B),I[N++]=B.x,I[N++]=B.y,I[N++]=B.z,I[N++]=B.x,I[N++]=B.y,I[N++]=B.z))}for(a=0;E>a;a++)w.normal&&(A[R++]=0,A[R++]=0,A[R++]=-1),w.tangent&&(M[L++]=1,M[L++]=0,M[L++]=0),w.binormal&&(I[N++]=0,I[N++]=-1,I[N++]=0);for(a=0;E>a;a++)w.normal&&(A[R++]=0,A[R++]=0,A[R++]=1),w.tangent&&(M[L++]=1,M[L++]=0,M[L++]=0),w.binormal&&(I[N++]=0,I[N++]=1,I[N++]=0)}var W=12*E-12,G=d.createTypedArray(x,W),H=0,q=0;for(a=0;E-1>a;a++)G[H++]=q,G[H++]=q+2,G[H++]=q+3,G[H++]=q,G[H++]=q+3,G[H++]=q+1,q+=2;for(G[H++]=b-2,G[H++]=0,G[H++]=1,G[H++]=b-2,G[H++]=1,G[H++]=b-1,a=1;E-1>a;a++)G[H++]=b+a+1,G[H++]=b+a,G[H++]=b;for(a=1;E-1>a;a++)G[H++]=S,G[H++]=S+a,G[H++]=S+a+1;var j=0;if(w.st){var Y=Math.max(p,C);for(a=0;x>a;a++){var X=i.fromArray(T,3*a,y);P[j++]=(X.x+Y)/(2*Y),P[j++]=(X.y+Y)/(2*Y)}}var Z=new c;w.position&&(Z.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:T})),w.normal&&(Z.normal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:A})),w.tangent&&(Z.tangent=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:M})),w.binormal&&(Z.binormal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:I})),w.st&&(Z.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:P})),f.x=.5*s,f.y=Math.max(C,p);var J=new e(i.ZERO,t.magnitude(f));return new l({attributes:Z,indices:G,primitiveType:m.TRIANGLES,boundingSphere:J})},C}),define("Cesium/Core/CylinderOutlineGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./PrimitiveType"],function(e,t,i,n,r,o,a,s,l,u,c,d,h){"use strict";var m=new t,p=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,i=e.topRadius,n=e.bottomRadius,r=o(e.slices,128),a=Math.max(o(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=i,this._bottomRadius=n,this._slices=r,this._numberOfVerticalLines=a,this._workerName="createCylinderOutlineGeometry"};p.packedLength=5,p.pack=function(e,t,i){i=o(i,0),t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i]=e._numberOfVerticalLines};var f={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0};return p.unpack=function(e,t,i){t=o(t,0);var n=e[t++],r=e[t++],s=e[t++],l=e[t++],u=e[t];return a(i)?(i._length=n,i._topRadius=r,i._bottomRadius=s,i._slices=l,i._numberOfVerticalLines=u,i):(f.length=n,f.topRadius=r,f.bottomRadius=s,f.slices=l,f.numberOfVerticalLines=u,new p(f))},p.createGeometry=function(o){var a,s=o._length,p=o._topRadius,f=o._bottomRadius,v=o._slices,g=o._numberOfVerticalLines,_=2*v,y=r.computePositions(s,p,f,v,!1),C=2*v;if(g>0){var w=Math.min(g,v);a=Math.round(v/w),C+=w}for(var E=d.createTypedArray(_,2*C),b=0,S=0;v-1>S;S++)E[b++]=S,E[b++]=S+1,E[b++]=S+v,E[b++]=S+1+v;if(E[b++]=v-1,E[b++]=0,E[b++]=v+v-1,E[b++]=v,g>0)for(S=0;v>S;S+=a)E[b++]=S,E[b++]=S+v;var x=new c;x.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:y}),m.x=.5*s,m.y=Math.max(f,p);var T=new e(i.ZERO,t.magnitude(m));return new l({attributes:x,indices:E,primitiveType:h.LINES,boundingSphere:T})},p}),define("Cesium/DataSources/CylinderGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CylinderGeometry","../Core/CylinderOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w){"use strict";var E=new g(t.WHITE),b=new _(!0),S=new _(!0),x=new _(!1),T=new _(t.BLACK),P=new t,A=function(e){this.id=e,this.vertexFormat=void 0,this.length=void 0,this.topRadius=void 0,this.bottomRadius=void 0,this.slices=void 0,this.numberOfVerticalLines=void 0},M=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(M.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new A(e),this._onEntityPropertyChanged(e,"cylinder",e.cylinder,void 0)};s(M,{perInstanceColorAppearanceType:{value:f},materialAppearanceType:{value:p}}),s(M.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!a(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!a(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),M.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},M.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},M.prototype.createFillGeometryInstance=function(e){var r,o,s=this._entity,l=s.isAvailable(e),u=new m(l&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof g){var c=t.WHITE;a(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(c=this._materialProperty.color.getValue(e)),o=i.fromColor(c),r={show:u,color:o}}else r={show:u};return new d({id:s,geometry:new n(this._options),modelMatrix:s._getModelMatrix(h.MINIMUM_VALUE),attributes:r})},M.prototype.createOutlineGeometryInstance=function(e){var n=this._entity,o=n.isAvailable(e),a=w.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new d({id:n,geometry:new r(this._options),modelMatrix:n._getModelMatrix(h.MINIMUM_VALUE),attributes:{show:new m(o&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:i.fromColor(a)}})},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){this._entitySubscription(),l(this)},M.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"position"===t||"orientation"===t||"cylinder"===t){var i=e.cylinder;if(!a(i))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;
var n=i.fill,r=a(n)&&n.isConstant?n.getValue(h.MINIMUM_VALUE):!0,s=i.outline,l=a(s);if(l&&s.isConstant&&(l=s.getValue(h.MINIMUM_VALUE)),!r&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var u=e.position,c=i.length,d=i.topRadius,m=i.bottomRadius,v=i.show;if(a(v)&&v.isConstant&&!v.getValue(h.MINIMUM_VALUE)||!a(u)||!a(c)||!a(d)||!a(m))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var _=o(i.material,E),y=_ instanceof g;this._materialProperty=_,this._fillProperty=o(n,S),this._showProperty=o(v,b),this._showOutlineProperty=o(i.outline,x),this._outlineColorProperty=l?o(i.outlineColor,T):void 0;var C=i.slices,P=i.outlineWidth,A=i.numberOfVerticalLines;if(this._fillEnabled=r,this._outlineEnabled=l,u.isConstant&&w.isConstant(e.orientation)&&c.isConstant&&d.isConstant&&m.isConstant&&w.isConstant(C)&&w.isConstant(P)&&w.isConstant(A)){var M=this._options;M.vertexFormat=y?f.VERTEX_FORMAT:p.MaterialSupport.TEXTURED.vertexFormat,M.length=c.getValue(h.MINIMUM_VALUE),M.topRadius=d.getValue(h.MINIMUM_VALUE),M.bottomRadius=m.getValue(h.MINIMUM_VALUE),M.slices=a(C)?C.getValue(h.MINIMUM_VALUE):void 0,M.numberOfVerticalLines=a(A)?A.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=a(P)?P.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},M.prototype.createDynamicUpdater=function(e){return new I(e,this)};var I=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new A(t._entity)};return I.prototype.update=function(e){var o=this._primitives;o.removeAndDestroy(this._primitive),o.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,u=l.cylinder;if(l.isShowing&&l.isAvailable(e)&&w.getValueOrDefault(u.show,e,!0)){var c=this._options,h=l._getModelMatrix(e),m=w.getValueOrUndefined(u.length,e),g=w.getValueOrUndefined(u.topRadius,e),_=w.getValueOrUndefined(u.bottomRadius,e);if(a(h)&&a(m)&&a(g)&&a(_)){if(c.length=m,c.topRadius=g,c.bottomRadius=_,c.slices=w.getValueOrUndefined(u.slices,e),c.numberOfVerticalLines=w.getValueOrUndefined(u.numberOfVerticalLines,e),w.getValueOrDefault(u.fill,e,!0)){var y=C.getValue(e,s.fillMaterialProperty,this._material);this._material=y;var E=new p({material:y,translucent:y.isTranslucent(),closed:!0});c.vertexFormat=E.vertexFormat,this._primitive=o.add(new v({geometryInstances:new d({id:l,geometry:new n(c),modelMatrix:h}),appearance:E,asynchronous:!1}))}if(w.getValueOrDefault(u.outline,e,!1)){c.vertexFormat=f.VERTEX_FORMAT;var b=w.getValueOrClonedDefault(u.outlineColor,e,t.BLACK,P),S=w.getValueOrDefault(u.outlineWidth,e,1),x=1!==b.alpha;this._outlinePrimitive=o.add(new v({geometryInstances:new d({id:l,geometry:new r(c),modelMatrix:h,attributes:{color:i.fromColor(b)}}),appearance:new f({flat:!0,translucent:x,renderState:{lineWidth:s._scene.clampLineWidth(S)}}),asynchronous:!1}))}}}},I.prototype.getBoundingSphere=function(e,t){return y(e,this._primitive,this._outlinePrimitive,t)},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),l(this)},M}),define("Cesium/Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,i,n){"use strict";function r(t,r,o,c,d,h,m,p,f,v){var g=t+r;e.multiplyByScalar(c,Math.cos(g),a),e.multiplyByScalar(o,Math.sin(g),s),e.add(a,s,a);var _=Math.cos(t);_*=_;var y=Math.sin(t);y*=y;var C=h/Math.sqrt(m*_+d*y),w=C/p;return n.fromAxisAngle(a,w,l),i.fromQuaternion(l,u),i.multiplyByVector(u,f,v),e.normalize(v,v),e.multiplyByScalar(v,p,v),v}var o={},a=new e,s=new e,l=new n,u=new i,c=new e,d=new e,h=new e,m=new e;o.raisePositionsToHeight=function(t,i,n){for(var r=i.ellipsoid,o=i.height,a=i.extrudedHeight,s=n?2*(t.length/3):t.length/3,l=new Float64Array(3*s),u=t.length,p=n?u:0,f=0;u>f;f+=3){var v=f+1,g=f+2,_=e.fromArray(t,f,c);r.scaleToGeodeticSurface(_,_);var y=e.clone(_,d),C=r.geodeticSurfaceNormal(_,m),w=e.multiplyByScalar(C,o,h);e.add(_,w,_),n&&(e.multiplyByScalar(C,a,w),e.add(y,w,y),l[f+p]=y.x,l[v+p]=y.y,l[g+p]=y.z),l[f]=_.x,l[v]=_.y,l[g]=_.z}return l};var p=new e,f=new e,v=new e;return o.computeEllipsePositions=function(i,n,o){var a=i.semiMinorAxis,s=i.semiMajorAxis,l=i.rotation,u=i.center,m=8*i.granularity,g=a*a,_=s*s,y=s*a,C=e.magnitude(u),w=e.normalize(u,p),E=e.cross(e.UNIT_Z,u,f);E=e.normalize(E,E);var b=e.cross(w,E,v),S=1+Math.ceil(t.PI_OVER_TWO/m),x=t.PI_OVER_TWO/(S-1),T=t.PI_OVER_TWO-S*x;0>T&&(S-=Math.ceil(Math.abs(T)/x));var P,A,M,I,D,O=2*S*(S+1),R=n?new Array(3*O):void 0,L=0,N=c,z=d,F=3*(2*S+2*(S-1)),B=F-1,V=0,k=o?new Array(F):void 0;for(T=t.PI_OVER_TWO,P=0;S>P;++P){if(N=r(T,l,b,E,g,y,_,C,w,N),z=r(Math.PI-T,l,b,E,g,y,_,C,w,z),n){for(R[L++]=N.x,R[L++]=N.y,R[L++]=N.z,M=2*P+2,A=1;M-1>A;++A)I=A/(M-1),D=e.lerp(N,z,I,h),R[L++]=D.x,R[L++]=D.y,R[L++]=D.z;R[L++]=z.x,R[L++]=z.y,R[L++]=z.z}o&&(k[B--]=N.z,k[B--]=N.y,k[B--]=N.x,0!==P&&(k[V++]=z.x,k[V++]=z.y,k[V++]=z.z)),T=t.PI_OVER_TWO-(P+1)*x}for(P=S;P>0;--P){if(T=t.PI_OVER_TWO-(P-1)*x,N=r(-T,l,b,E,g,y,_,C,w,N),z=r(T+Math.PI,l,b,E,g,y,_,C,w,z),n){for(R[L++]=N.x,R[L++]=N.y,R[L++]=N.z,M=2*(P-1)+2,A=1;M-1>A;++A)I=A/(M-1),D=e.lerp(N,z,I,h),R[L++]=D.x,R[L++]=D.y,R[L++]=D.z;R[L++]=z.x,R[L++]=z.y,R[L++]=z.z}o&&(k[B--]=N.z,k[B--]=N.y,k[B--]=N.x,1!==P&&(k[V++]=z.x,k[V++]=z.y,k[V++]=z.z))}var U={};return n&&(U.positions=R,U.numPts=S),o&&(U.outerPositions=k),U},o}),define("Cesium/Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w){"use strict";function E(e,n,o){var a=n.vertexFormat,s=n.center,u=n.semiMajorAxis,d=n.semiMinorAxis,p=n.ellipsoid,f=n.stRotation,v=o?2*(e.length/3):e.length/3,g=a.st?new Float32Array(2*v):void 0,y=a.normal?new Float32Array(3*v):void 0,w=a.tangent?new Float32Array(3*v):void 0,E=a.binormal?new Float32Array(3*v):void 0,b=0,S=N,x=z,T=F,P=new c(p),D=P.project(p.cartesianToCartographic(s,B),V),W=p.scaleToGeodeticSurface(s,A);p.geodeticSurfaceNormal(W,W);for(var G=C.fromAxisAngle(W,f,L),H=_.fromQuaternion(G,R),q=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,k),j=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,U),Y=e.length,X=o?Y:0,Z=2*(X/3),J=0;Y>J;J+=3){var K=J+1,Q=J+2,$=i.fromArray(e,J,A);if(a.st){var et=_.multiplyByVector(H,$,M),tt=P.project(p.cartesianToCartographic(et,B),I);i.subtract(tt,D,tt),O.x=(tt.x+u)/(2*u),O.y=(tt.y+d)/(2*d),q.x=Math.min(O.x,q.x),q.y=Math.min(O.y,q.y),j.x=Math.max(O.x,j.x),j.y=Math.max(O.y,j.y),o&&(g[b+Z]=O.x,g[b+1+Z]=O.y),g[b++]=O.x,g[b++]=O.y}S=p.geodeticSurfaceNormal($,S),(a.normal||a.tangent||a.binormal)&&((a.tangent||a.binormal)&&(x=i.cross(i.UNIT_Z,S,x),_.multiplyByVector(H,x,x)),a.normal&&(y[J]=S.x,y[K]=S.y,y[Q]=S.z,o&&(y[J+X]=-S.x,y[K+X]=-S.y,y[Q+X]=-S.z)),a.tangent&&(w[J]=x.x,w[K]=x.y,w[Q]=x.z,o&&(w[J+X]=-x.x,w[K+X]=-x.y,w[Q+X]=-x.z)),a.binormal&&(T=i.cross(S,x,T),E[J]=T.x,E[K]=T.y,E[Q]=T.z,o&&(E[J+X]=T.x,E[K+X]=T.y,E[Q+X]=T.z)))}if(a.st){Y=g.length;for(var it=0;Y>it;it+=2)g[it]=(g[it]-q.x)/(j.x-q.x),g[it+1]=(g[it+1]-q.y)/(j.y-q.y)}var nt=new m;if(a.position){var rt=l.raisePositionsToHeight(e,n,o);nt.position=new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:rt})}return a.st&&(nt.st=new h({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:g})),a.normal&&(nt.normal=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:y})),a.tangent&&(nt.tangent=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:w})),a.binormal&&(nt.binormal=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:E})),nt}function b(e){var t,i,n,r,o,a=new Array(2*e*(e+1)),s=0;for(r=1;e>r;++r){for(n=r*(r+1),t=(r-1)*r,a[s++]=n++,a[s++]=t,a[s++]=n,i=2*r,o=0;i-1>o;++o)a[s++]=n,a[s++]=t++,a[s++]=t,a[s++]=n++,a[s++]=t,a[s++]=n;a[s++]=n++,a[s++]=t,a[s++]=n}for(i=2*e,++n,++t,r=0;i-1>r;++r)a[s++]=n,a[s++]=t++,a[s++]=t,a[s++]=n++,a[s++]=t,a[s++]=n;for(++t,++n,r=e-1;r>0;--r){for(a[s++]=t++,a[s++]=t,a[s++]=n,i=2*r,o=0;i-1>o;++o)a[s++]=n,a[s++]=t++,a[s++]=t,a[s++]=n++,a[s++]=t,a[s++]=n;a[s++]=t++,a[s++]=t++,a[s++]=n++}return a}function S(t){var n=t.center;W=i.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(n,W),t.height,W),W=i.add(n,W,W);var r=new e(W,t.semiMajorAxis),o=l.computeEllipsePositions(t,!0,!1),a=o.positions,s=o.numPts,u=E(a,t,!1),c=b(s);return c=v.createTypedArray(a.length/3,c),{boundingSphere:r,attributes:u,indices:c}}function x(e,n){var o=n.vertexFormat,a=n.center,s=n.semiMajorAxis,l=n.semiMinorAxis,u=n.ellipsoid,d=n.height,p=n.extrudedHeight,f=n.stRotation,v=2*(e.length/3),g=new Float64Array(3*v),y=o.st?new Float32Array(2*v):void 0,w=o.normal?new Float32Array(3*v):void 0,E=o.tangent?new Float32Array(3*v):void 0,b=o.binormal?new Float32Array(3*v):void 0,S=0,x=N,T=z,P=F,W=new c(u),G=W.project(u.cartesianToCartographic(a,B),V),H=u.scaleToGeodeticSurface(a,A);u.geodeticSurfaceNormal(H,H);for(var q=C.fromAxisAngle(H,f,L),j=_.fromQuaternion(q,R),Y=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,k),X=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,U),Z=e.length,J=2*(Z/3),K=0;Z>K;K+=3){var Q,$=K+1,et=K+2,tt=i.fromArray(e,K,A);if(o.st){var it=_.multiplyByVector(j,tt,M),nt=W.project(u.cartesianToCartographic(it,B),I);i.subtract(nt,G,nt),O.x=(nt.x+s)/(2*s),O.y=(nt.y+l)/(2*l),Y.x=Math.min(O.x,Y.x),Y.y=Math.min(O.y,Y.y),X.x=Math.max(O.x,X.x),X.y=Math.max(O.y,X.y),y[S+J]=O.x,y[S+1+J]=O.y,y[S++]=O.x,y[S++]=O.y}tt=u.scaleToGeodeticSurface(tt,tt),Q=i.clone(tt,M),x=u.geodeticSurfaceNormal(tt,x);var rt=i.multiplyByScalar(x,d,D);if(tt=i.add(tt,rt,tt),rt=i.multiplyByScalar(x,p,rt),Q=i.add(Q,rt,Q),o.position&&(g[K+Z]=Q.x,g[$+Z]=Q.y,g[et+Z]=Q.z,g[K]=tt.x,g[$]=tt.y,g[et]=tt.z),o.normal||o.tangent||o.binormal){P=i.clone(x,P);var ot=i.fromArray(e,(K+3)%Z,D);i.subtract(ot,tt,ot);var at=i.subtract(Q,tt,I);x=i.normalize(i.cross(at,ot,x),x),o.normal&&(w[K]=x.x,w[$]=x.y,w[et]=x.z,w[K+Z]=x.x,w[$+Z]=x.y,w[et+Z]=x.z),o.tangent&&(T=i.normalize(i.cross(P,x,T),T),E[K]=T.x,E[$]=T.y,E[et]=T.z,E[K+Z]=T.x,E[K+1+Z]=T.y,E[K+2+Z]=T.z),o.binormal&&(b[K]=P.x,b[$]=P.y,b[et]=P.z,b[K+Z]=P.x,b[$+Z]=P.y,b[et+Z]=P.z)}}if(o.st){Z=y.length;for(var st=0;Z>st;st+=2)y[st]=(y[st]-Y.x)/(X.x-Y.x),y[st+1]=(y[st+1]-Y.y)/(X.y-Y.y)}var lt=new m;return o.position&&(lt.position=new h({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:g})),o.st&&(lt.st=new h({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:y})),o.normal&&(lt.normal=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:w})),o.tangent&&(lt.tangent=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:E})),o.binormal&&(lt.binormal=new h({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:b})),lt}function T(e){for(var t=e.length/3,i=v.createTypedArray(t,6*t),n=0,r=0;t>r;r++){var o=r,a=r+t,s=(o+1)%t,l=s+t;i[n++]=o,i[n++]=a,i[n++]=s,i[n++]=s,i[n++]=a,i[n++]=l}return i}function P(t){var n=t.center,r=t.ellipsoid,o=t.semiMajorAxis,a=i.multiplyByScalar(r.geodeticSurfaceNormal(n,A),t.height,A);G.center=i.add(n,a,G.center),G.radius=o,a=i.multiplyByScalar(r.geodeticSurfaceNormal(n,a),t.extrudedHeight,a),H.center=i.add(n,a,H.center),H.radius=o;var s=l.computeEllipsePositions(t,!0,!0),u=s.positions,c=s.numPts,h=s.outerPositions,m=e.union(G,H),g=E(u,t,!0),_=b(c),C=_.length;_.length=2*C;for(var w=u.length/3,S=0;C>S;S+=3)_[S+C]=_[S+2]+w,_[S+1+C]=_[S+1]+w,_[S+2+C]=_[S]+w;var P=v.createTypedArray(2*w/3,_),M=new d({attributes:g,indices:P,primitiveType:y.TRIANGLES}),I=x(h,t);_=T(h);var D=v.createTypedArray(2*h.length/3,_),O=new d({attributes:I,indices:D,primitiveType:y.TRIANGLES}),R=f.combineInstances([new p({geometry:M}),new p({geometry:O})]);return{boundingSphere:m,attributes:R[0].attributes,indices:R[0].indices}}var A=new i,M=new i,I=new i,D=new i,O=new t,R=new _,L=new C,N=new i,z=new i,F=new i,B=new n,V=new i,k=new t,U=new t,W=new i,G=new e,H=new e,q=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.center,n=o(e.ellipsoid,u.WGS84),r=e.semiMajorAxis,s=e.semiMinorAxis,l=o(e.granularity,g.RADIANS_PER_DEGREE),c=o(e.height,0),d=e.extrudedHeight,h=a(d)&&Math.abs(c-d)>1,m=o(e.vertexFormat,w.DEFAULT);this._center=i.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=s,this._ellipsoid=u.clone(n),this._rotation=o(e.rotation,0),this._stRotation=o(e.stRotation,0),this._height=c,this._granularity=l,this._vertexFormat=w.clone(m),this._extrudedHeight=o(d,c),this._extrude=h,this._workerName="createEllipseGeometry"};q.packedLength=i.packedLength+u.packedLength+w.packedLength+8,q.pack=function(e,t,n){n=o(n,0),i.pack(e._center,t,n),n+=i.packedLength,u.pack(e._ellipsoid,t,n),n+=u.packedLength,w.pack(e._vertexFormat,t,n),n+=w.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n]=e._extrude?1:0};var j=new i,Y=new u,X=new w,Z={center:j,ellipsoid:Y,vertexFormat:X,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return q.unpack=function(e,t,n){t=o(t,0);var r=i.unpack(e,t,j);t+=i.packedLength;var s=u.unpack(e,t,Y);t+=u.packedLength;var l=w.unpack(e,t,X);t+=w.packedLength;var c=e[t++],d=e[t++],h=e[t++],m=e[t++],p=e[t++],f=e[t++],v=e[t++],g=1===e[t];return a(n)?(n._center=i.clone(r,n._center),n._ellipsoid=u.clone(s,n._ellipsoid),n._vertexFormat=w.clone(l,n._vertexFormat),n._semiMajorAxis=c,n._semiMinorAxis=d,n._rotation=h,n._stRotation=m,n._height=p,n._granularity=f,n._extrudedHeight=v,n._extrude=g,n):(Z.height=p,Z.extrudedHeight=v,Z.granularity=f,Z.stRotation=m,Z.rotation=h,Z.semiMajorAxis=c,Z.semiMinorAxis=d,new q(Z))},q.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,i={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(i.extrudedHeight=Math.min(e._extrudedHeight,e._height),i.height=Math.max(e._extrudedHeight,e._height),t=P(i)):t=S(i),new d({attributes:t.attributes,indices:t.indices,primitiveType:y.TRIANGLES,boundingSphere:t.boundingSphere})},q}),define("Cesium/Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";function p(n){var r=n.center;g=t.multiplyByScalar(n.ellipsoid.geodeticSurfaceNormal(r,g),n.height,g),g=t.add(r,g,g);for(var o=new e(g,n.semiMajorAxis),s=a.computeEllipsePositions(n,!1,!0).outerPositions,l=new c({position:new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(s,n,!1)})}),h=s.length/3,m=d.createTypedArray(h,2*h),p=0,f=0;h>f;++f)m[p++]=f,m[p++]=(f+1)%h;return{boundingSphere:o,attributes:l,indices:m}}function f(r){var o=n(r.numberOfVerticalLines,16);o=Math.max(o,0);var s=r.center,l=r.ellipsoid,h=r.semiMajorAxis,m=t.multiplyByScalar(l.geodeticSurfaceNormal(s,v),r.height,v);_.center=t.add(s,m,_.center),_.radius=h,m=t.multiplyByScalar(l.geodeticSurfaceNormal(s,m),r.extrudedHeight,m),y.center=t.add(s,m,y.center),y.radius=h;var p=a.computeEllipsePositions(r,!1,!0).outerPositions,f=new c({position:new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(p,r,!0)})});p=f.position.values;var g=e.union(_,y),C=p.length/3,w=d.createTypedArray(C,2*C+2*o);C/=2;var E,b=0;for(E=0;C>E;++E)w[b++]=E,w[b++]=(E+1)%C,w[b++]=E+C,w[b++]=(E+1)%C+C;var S;if(o>0){var x=Math.min(o,C);S=Math.round(C/x)}var T=Math.min(S*o,C);if(o>0)for(E=0;T>E;E+=S)w[b++]=E,w[b++]=E+C;return{boundingSphere:g,attributes:f,indices:w}}var v=new t,g=new t,_=new e,y=new e,C=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.center,o=n(e.ellipsoid,s.WGS84),a=e.semiMajorAxis,l=e.semiMinorAxis,u=n(e.granularity,h.RADIANS_PER_DEGREE),c=n(e.height,0),d=e.extrudedHeight,m=r(d)&&Math.abs(c-d)>1;this._center=t.clone(i),this._semiMajorAxis=a,this._semiMinorAxis=l,this._ellipsoid=s.clone(o),this._rotation=n(e.rotation,0),this._height=c,this._granularity=u,this._extrudedHeight=d,this._extrude=m,this._numberOfVerticalLines=Math.max(n(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};C.packedLength=t.packedLength+s.packedLength+9,C.pack=function(e,i,o){o=n(o,0),t.pack(e._center,i,o),o+=t.packedLength,s.pack(e._ellipsoid,i,o),o+=s.packedLength,i[o++]=e._semiMajorAxis,i[o++]=e._semiMinorAxis,i[o++]=e._rotation,i[o++]=e._height,i[o++]=e._granularity,i[o++]=r(e._extrudedHeight)?1:0,i[o++]=n(e._extrudedHeight,0),i[o++]=e._extrude?1:0,i[o]=e._numberOfVerticalLines};var w=new t,E=new s,b={center:w,ellipsoid:E,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return C.unpack=function(e,i,o){i=n(i,0);var a=t.unpack(e,i,w);i+=t.packedLength;var l=s.unpack(e,i,E);i+=s.packedLength;var u=e[i++],c=e[i++],d=e[i++],h=e[i++],m=e[i++],p=e[i++],f=e[i++],v=1===e[i++],g=e[i];return r(o)?(o._center=t.clone(a,o._center),o._ellipsoid=s.clone(l,o._ellipsoid),o._semiMajorAxis=u,o._semiMinorAxis=c,o._rotation=d,o._height=h,o._granularity=m,o._extrudedHeight=p?f:void 0,o._extrude=v,o._numberOfVerticalLines=g,o):(b.height=h,b.extrudedHeight=p?f:void 0,b.granularity=m,b.rotation=d,b.semiMajorAxis=u,b.semiMinorAxis=c,b.numberOfVerticalLines=g,new C(b))},C.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,i={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(i.extrudedHeight=Math.min(e._extrudedHeight,e._height),i.height=Math.max(e._extrudedHeight,e._height),t=f(i)):t=p(i),new l({attributes:t.attributes,indices:t.indices,primitiveType:m.LINES,boundingSphere:t.boundingSphere})},C}),define("Cesium/DataSources/EllipseGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipseGeometry","../Core/EllipseOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(e.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(e.BLACK),T=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.center=void 0,this.semiMajorAxis=void 0,this.semiMinorAxis=void 0,this.rotation=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0,this.numberOfVerticalLines=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"ellipse",e.ellipse,void 0)};r(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),r(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(i){var r,o,a=this._entity,l=a.isAvailable(i),u=new h(l&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var d=e.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(d=this._materialProperty.color.getValue(i)),o=t.fromColor(d),r={show:u,color:o}}else r={show:u};return new c({id:a,geometry:new s(this._options),attributes:r})},A.prototype.createOutlineGeometryInstance=function(i){var n=this._entity,r=n.isAvailable(i),o=C.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new c({id:n,geometry:new l(this._options),attributes:{show:new h(r&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(o)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),o(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"position"===t||"ellipse"===t){var r=this._entity.ellipse;if(!n(r))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=r.fill,a=n(o)&&o.isConstant?o.getValue(d.MINIMUM_VALUE):!0,s=r.outline,l=n(s);if(l&&s.isConstant&&(l=s.getValue(d.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var u=this._entity.position,c=r.semiMajorAxis,h=r.semiMinorAxis,f=r.show;if(n(f)&&f.isConstant&&!f.getValue(d.MINIMUM_VALUE)||!n(u)||!n(c)||!n(h))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var g=i(r.material,w),_=g instanceof v;this._materialProperty=g,this._fillProperty=i(o,b),this._showProperty=i(f,E),this._showOutlineProperty=i(r.outline,S),this._outlineColorProperty=l?i(r.outlineColor,x):void 0;var y=r.rotation,T=r.height,P=r.extrudedHeight,A=r.granularity,M=r.stRotation,I=r.outlineWidth,D=r.numberOfVerticalLines;if(this._isClosed=n(P),this._fillEnabled=a,this._outlineEnabled=l,u.isConstant&&c.isConstant&&h.isConstant&&C.isConstant(y)&&C.isConstant(T)&&C.isConstant(P)&&C.isConstant(A)&&C.isConstant(M)&&C.isConstant(I)&&C.isConstant(D)){var O=this._options;O.vertexFormat=_?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,O.center=u.getValue(d.MINIMUM_VALUE,O.center),O.semiMajorAxis=c.getValue(d.MINIMUM_VALUE,O.semiMajorAxis),O.semiMinorAxis=h.getValue(d.MINIMUM_VALUE,O.semiMinorAxis),O.rotation=n(y)?y.getValue(d.MINIMUM_VALUE):void 0,O.height=n(T)?T.getValue(d.MINIMUM_VALUE):void 0,O.extrudedHeight=n(P)?P.getValue(d.MINIMUM_VALUE):void 0,O.granularity=n(A)?A.getValue(d.MINIMUM_VALUE):void 0,O.stRotation=n(M)?M.getValue(d.MINIMUM_VALUE):void 0,O.numberOfVerticalLines=n(D)?D.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=n(I)?I.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(i){var r=this._primitives;r.removeAndDestroy(this._primitive),r.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,u=a.ellipse;if(a.isShowing&&a.isAvailable(i)&&C.getValueOrDefault(u.show,i,!0)){var d=this._options,h=C.getValueOrUndefined(a.position,i,d.center),v=C.getValueOrUndefined(u.semiMajorAxis,i),g=C.getValueOrUndefined(u.semiMinorAxis,i);if(n(h)&&n(v)&&n(g)){if(d.center=h,d.semiMajorAxis=v,d.semiMinorAxis=g,d.rotation=C.getValueOrUndefined(u.rotation,i),d.height=C.getValueOrUndefined(u.height,i),d.extrudedHeight=C.getValueOrUndefined(u.extrudedHeight,i),d.granularity=C.getValueOrUndefined(u.granularity,i),d.stRotation=C.getValueOrUndefined(u.stRotation,i),d.numberOfVerticalLines=C.getValueOrUndefined(u.numberOfVerticalLines,i),C.getValueOrDefault(u.fill,i,!0)){var _=y.getValue(i,o.fillMaterialProperty,this._material);this._material=_;var w=new m({material:_,translucent:_.isTranslucent(),closed:n(d.extrudedHeight)});d.vertexFormat=w.vertexFormat,this._primitive=r.add(new f({geometryInstances:new c({id:a,geometry:new s(d)}),appearance:w,asynchronous:!1}))}if(C.getValueOrDefault(u.outline,i,!1)){d.vertexFormat=p.VERTEX_FORMAT;var E=C.getValueOrClonedDefault(u.outlineColor,i,e.BLACK,T),b=C.getValueOrDefault(u.outlineWidth,i,1),S=1!==E.alpha;this._outlinePrimitive=r.add(new f({geometryInstances:new c({id:a,geometry:new l(d),attributes:{color:t.fromColor(E)}}),appearance:new p({flat:!0,translucent:S,renderState:{lineWidth:o._scene.clampLineWidth(b)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},A}),define("Cesium/Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p){"use strict";var f=new i,v=new i,g=new i,_=new i,y=new i,C=new i(1,1,1),w=Math.cos,E=Math.sin,b=function(e){e=r(e,r.EMPTY_OBJECT);var t=r(e.radii,C),n=r(e.stackPartitions,64),o=r(e.slicePartitions,64),a=r(e.vertexFormat,p.DEFAULT);this._radii=i.clone(t),this._stackPartitions=n,this._slicePartitions=o,this._vertexFormat=p.clone(a),this._workerName="createEllipsoidGeometry"};b.packedLength=i.packedLength+p.packedLength+2,b.pack=function(e,t,n){n=r(n,0),i.pack(e._radii,t,n),n+=i.packedLength,p.pack(e._vertexFormat,t,n),n+=p.packedLength,t[n++]=e._stackPartitions,t[n]=e._slicePartitions};var S=new i,x=new p,T={radii:S,vertexFormat:x,stackPartitions:void 0,slicePartitions:void 0};return b.unpack=function(e,t,n){t=r(t,0);var a=i.unpack(e,t,S);t+=i.packedLength;var s=p.unpack(e,t,x);t+=p.packedLength;var l=e[t++],u=e[t];return o(n)?(n._radii=i.clone(a,n._radii),n._vertexFormat=p.clone(s,n._vertexFormat),n._stackPartitions=l,n._slicePartitions=u,n):(T.stackPartitions=l,T.slicePartitions=u,new b(T))},b.createGeometry=function(r){var o,a,p=r._radii,C=s.fromCartesian3(p),b=r._vertexFormat,S=r._slicePartitions+1,x=r._stackPartitions+1,T=x*S,P=new Float64Array(3*T),A=6*(S-1)*(x-1),M=d.createTypedArray(T,A),I=b.normal?new Float32Array(3*T):void 0,D=b.tangent?new Float32Array(3*T):void 0,O=b.binormal?new Float32Array(3*T):void 0,R=b.st?new Float32Array(2*T):void 0,L=new Array(S),N=new Array(S),z=0;for(o=0;S>o;o++){var F=h.TWO_PI*o/(S-1);L[o]=w(F),N[o]=E(F),P[z++]=0,P[z++]=0,P[z++]=p.z}for(o=1;x-1>o;o++){var B=Math.PI*o/(x-1),V=E(B),k=p.x*V,U=p.y*V,W=p.z*w(B);for(a=0;S>a;a++)P[z++]=L[a]*k,P[z++]=N[a]*U,P[z++]=W}for(o=0;S>o;o++)P[z++]=0,P[z++]=0,P[z++]=-p.z;var G=new c;b.position&&(G.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:P}));var H=0,q=0,j=0,Y=0;if(b.st||b.normal||b.tangent||b.binormal){for(o=0;T>o;o++){var X=i.fromArray(P,3*o,f),Z=C.geodeticSurfaceNormal(X,v);if(b.st){var J=t.negate(Z,y);t.magnitude(J)<h.EPSILON6&&(z=3*(o+S*Math.floor(.5*x)),z>P.length&&(z=3*(o-S*Math.floor(.5*x))),i.fromArray(P,z,J),C.geodeticSurfaceNormal(J,J),t.negate(J,J)),R[H++]=Math.atan2(J.y,J.x)/h.TWO_PI+.5,R[H++]=Math.asin(Z.z)/Math.PI+.5}if(b.normal&&(I[q++]=Z.x,I[q++]=Z.y,I[q++]=Z.z),b.tangent||b.binormal){var K=g;if(S>o||o>T-S-1?(i.cross(i.UNIT_X,Z,K),i.normalize(K,K)):(i.cross(i.UNIT_Z,Z,K),i.normalize(K,K)),b.tangent&&(D[j++]=K.x,D[j++]=K.y,D[j++]=K.z),b.binormal){var Q=i.cross(Z,K,_);i.normalize(Q,Q),O[Y++]=Q.x,O[Y++]=Q.y,O[Y++]=Q.z}}}b.st&&(G.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:R})),b.normal&&(G.normal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:I})),b.tangent&&(G.tangent=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:D})),b.binormal&&(G.binormal=new u({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:O}))}for(z=0,o=0;x>o;o++){var $=o*S,et=(o+1)*S;for(a=0;S-1>a;a++)M[z++]=et+a,M[z++]=et+a+1,M[z++]=$+a+1,M[z++]=et+a,M[z++]=$+a+1,M[z++]=$+a}return new l({attributes:G,indices:M,primitiveType:m.TRIANGLES,boundingSphere:e.fromEllipsoid(C)})},b}),define("Cesium/Core/EllipsoidOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,i,n,r,o,a,s,l,u,c,d,h){"use strict";var m=new t(1,1,1),p=Math.cos,f=Math.sin,v=function(e){e=n(e,n.EMPTY_OBJECT);var i=n(e.radii,m),r=n(e.stackPartitions,10),o=n(e.slicePartitions,8),a=n(e.subdivisions,128);this._radii=t.clone(i),this._stackPartitions=r,this._slicePartitions=o,this._subdivisions=a,this._workerName="createEllipsoidOutlineGeometry"};v.packedLength=t.packedLength+3,v.pack=function(e,i,r){r=n(r,0),t.pack(e._radii,i,r),r+=t.packedLength,i[r++]=e._stackPartitions,i[r++]=e._slicePartitions,i[r]=e._subdivisions};var g=new t,_={radii:g,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return v.unpack=function(e,i,o){i=n(i,0);var a=t.unpack(e,i,g);i+=t.packedLength;var s=e[i++],l=e[i++],u=e[i++];return r(o)?(o._radii=t.clone(a,o._radii),o._stackPartitions=s,o._slicePartitions=l,o._subdivisions=u,o):(_.stackPartitions=s,_.slicePartitions=l,_.subdivisions=u,new v(_))},v.createGeometry=function(t){var n,r,o,m,v,g,_=t._radii,y=a.fromCartesian3(_),C=t._stackPartitions,w=t._slicePartitions,E=t._subdivisions,b=E*(C+w-1),S=b-w+2,x=new Float64Array(3*S),T=c.createTypedArray(S,2*b),P=0,A=new Array(E),M=new Array(E);for(n=0;E>n;n++)o=d.TWO_PI*n/E,A[n]=p(o),M[n]=f(o);for(n=1;C>n;n++)for(m=Math.PI*n/C,v=p(m),g=f(m),r=0;E>r;r++)x[P++]=_.x*A[r]*g,x[P++]=_.y*M[r]*g,x[P++]=_.z*v;for(A.length=w,M.length=w,n=0;w>n;n++)o=d.TWO_PI*n/w,A[n]=p(o),M[n]=f(o);for(x[P++]=0,x[P++]=0,x[P++]=_.z,n=1;E>n;n++)for(m=Math.PI*n/E,v=p(m),g=f(m),r=0;w>r;r++)x[P++]=_.x*A[r]*g,x[P++]=_.y*M[r]*g,x[P++]=_.z*v;
for(x[P++]=0,x[P++]=0,x[P++]=-_.z,P=0,n=0;C-1>n;++n){var I=n*E;for(r=0;E-1>r;++r)T[P++]=I+r,T[P++]=I+r+1;T[P++]=I+E-1,T[P++]=I}var D=E*(C-1);for(r=1;w+1>r;++r)T[P++]=D,T[P++]=D+r;for(n=0;E-2>n;++n){var O=n*w+1+D,R=(n+1)*w+1+D;for(r=0;w-1>r;++r)T[P++]=R+r,T[P++]=O+r;T[P++]=R+w-1,T[P++]=O+w-1}var L=x.length/3-1;for(r=L-1;r>L-w-1;--r)T[P++]=L,T[P++]=r;var N=new u({position:new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:x})});return new s({attributes:N,indices:T,primitiveType:h.LINES,boundingSphere:e.fromEllipsoid(y)})},v}),define("Cesium/DataSources/EllipsoidGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipsoidGeometry","../Core/EllipsoidOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/Matrix4","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","../Scene/SceneMode","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b){"use strict";var S=new y(t.WHITE),x=new C(!0),T=new C(!0),P=new C(!1),A=new C(t.BLACK),M=new e,I=new t,D=new e(1,1,1),O=function(e){this.id=e,this.vertexFormat=void 0,this.radii=void 0,this.stackPartitions=void 0,this.slicePartitions=void 0,this.subdivisions=void 0},R=function(e,t){this._scene=t,this._entity=e,this._entitySubscription=e.definitionChanged.addEventListener(R.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new O(e),this._onEntityPropertyChanged(e,"ellipsoid",e.ellipsoid,void 0)};o(R,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:f}}),o(R.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!r(this._entity.availability)&&b.isConstant(this._showProperty)&&b.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!r(this._entity.availability)&&b.isConstant(this._showProperty)&&b.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),R.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},R.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},R.prototype.createFillGeometryInstance=function(e){var n,o,a=this._entity,s=a.isAvailable(e),u=new p(s&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof y){var c=t.WHITE;r(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(c=this._materialProperty.color.getValue(e)),o=i.fromColor(c),n={show:u,color:o}}else n={show:u};return new d({id:a,geometry:new l(this._options),modelMatrix:a._getModelMatrix(h.MINIMUM_VALUE),attributes:n})},R.prototype.createOutlineGeometryInstance=function(e){var n=this._entity,r=n.isAvailable(e),o=b.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new d({id:n,geometry:new u(this._options),modelMatrix:n._getModelMatrix(h.MINIMUM_VALUE),attributes:{show:new p(r&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:i.fromColor(o)}})},R.prototype.isDestroyed=function(){return!1},R.prototype.destroy=function(){this._entitySubscription(),a(this)},R.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"position"===t||"orientation"===t||"ellipsoid"===t){var i=e.ellipsoid;if(!r(i))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=i.fill,a=r(o)&&o.isConstant?o.getValue(h.MINIMUM_VALUE):!0,s=i.outline,l=r(s);if(l&&s.isConstant&&(l=s.getValue(h.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var u=e.position,c=i.radii,d=i.show;if(r(d)&&d.isConstant&&!d.getValue(h.MINIMUM_VALUE)||!r(u)||!r(c))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var m=n(i.material,S),p=m instanceof y;this._materialProperty=m,this._fillProperty=n(o,T),this._showProperty=n(d,x),this._showOutlineProperty=n(i.outline,P),this._outlineColorProperty=l?n(i.outlineColor,A):void 0,this._fillEnabled=a,this._outlineEnabled=l;var g=i.stackPartitions,_=i.slicePartitions,C=i.outlineWidth,w=i.subdivisions;if(u.isConstant&&b.isConstant(e.orientation)&&c.isConstant&&b.isConstant(g)&&b.isConstant(_)&&b.isConstant(C)&&b.isConstant(w)){var E=this._options;E.vertexFormat=p?v.VERTEX_FORMAT:f.MaterialSupport.TEXTURED.vertexFormat,E.radii=c.getValue(h.MINIMUM_VALUE,E.radii),E.stackPartitions=r(g)?g.getValue(h.MINIMUM_VALUE):void 0,E.slicePartitions=r(_)?_.getValue(h.MINIMUM_VALUE):void 0,E.subdivisions=r(w)?w.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=r(C)?C.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},R.prototype.createDynamicUpdater=function(e){return new L(e,this)};var L=function(e,t){this._entity=t._entity,this._scene=t._scene,this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new O(t._entity),this._modelMatrix=new m,this._material=void 0,this._attributes=void 0,this._outlineAttributes=void 0,this._lastSceneMode=void 0,this._lastShow=void 0,this._lastOutlineShow=void 0,this._lastOutlineWidth=void 0,this._lastOutlineColor=void 0};return L.prototype.update=function(e){var o=this._entity,a=o.ellipsoid;if(!o.isShowing||!o.isAvailable(e)||!b.getValueOrDefault(a.show,e,!0))return r(this._primitive)&&(this._primitive.show=!1),r(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1),void 0;var s=b.getValueOrUndefined(a.radii,e,M),c=o._getModelMatrix(e,this._modelMatrix);if(!r(c)||!r(s))return r(this._primitive)&&(this._primitive.show=!1),r(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1),void 0;var h,y=b.getValueOrDefault(a.fill,e,!0),C=b.getValueOrDefault(a.outline,e,!1),w=b.getValueOrClonedDefault(a.outlineColor,e,t.BLACK,I),x=E.getValue(e,n(a.material,S),this._material);this._material=x;var T=b.getValueOrUndefined(a.stackPartitions,e),P=b.getValueOrUndefined(a.slicePartitions,e),A=b.getValueOrUndefined(a.subdivisions,e),O=b.getValueOrDefault(a.outlineWidth,e,1),R=this._scene.mode,L=R===_.SCENE3D,N=this._options,z=!L||this._lastSceneMode!==R||!r(this._primitive)||N.stackPartitions!==T||N.slicePartitions!==P||N.subdivisions!==A||this._lastOutlineWidth!==O;if(z){var F=this._primitives;F.removeAndDestroy(this._primitive),F.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0,this._lastSceneMode=R,this._lastOutlineWidth=O,N.stackPartitions=T,N.slicePartitions=P,N.subdivisions=A,N.radii=L?D:s,h=new f({material:x,translucent:x.isTranslucent(),closed:!0}),N.vertexFormat=h.vertexFormat,this._primitive=F.add(new g({geometryInstances:new d({id:o,geometry:new l(N),modelMatrix:L?void 0:c,attributes:{show:new p(y)}}),appearance:h,asynchronous:!1})),N.vertexFormat=v.VERTEX_FORMAT,this._outlinePrimitive=F.add(new g({geometryInstances:new d({id:o,geometry:new u(N),modelMatrix:L?void 0:c,attributes:{show:new p(C),color:i.fromColor(w)}}),appearance:new v({flat:!0,translucent:1!==w.alpha,renderState:{lineWidth:this._geometryUpdater._scene.clampLineWidth(O)}}),asynchronous:!1})),this._lastShow=y,this._lastOutlineShow=C,this._lastOutlineColor=t.clone(w,this._lastOutlineColor)}else if(this._primitive.ready){var B=this._primitive,V=this._outlinePrimitive;B.show=!0,V.show=!0,h=B.appearance,h.material=x;var k=this._attributes;r(k)||(k=B.getGeometryInstanceAttributes(o),this._attributes=k),y!==this._lastShow&&(k.show=p.toValue(y,k.show),this._lastShow=y);var U=this._outlineAttributes;r(U)||(U=V.getGeometryInstanceAttributes(o),this._outlineAttributes=U),C!==this._lastOutlineShow&&(U.show=p.toValue(C,U.show),this._lastOutlineShow=C),t.equals(w,this._lastOutlineColor)||(U.color=i.toValue(w,U.color),t.clone(w,this._lastOutlineColor))}L&&(s.x=Math.max(s.x,.001),s.y=Math.max(s.y,.001),s.z=Math.max(s.z,.001),c=m.multiplyByScale(c,s,c),this._primitive.modelMatrix=c,this._outlinePrimitive.modelMatrix=c)},L.prototype.getBoundingSphere=function(e,t){return w(e,this._primitive,this._outlinePrimitive,t)},L.prototype.isDestroyed=function(){return!1},L.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),a(this)},R}),define("Cesium/DataSources/StaticGeometryColorBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState"],function(e,t,i,n,r,o,a){"use strict";var s=new t,l=function(t,i,n,r){this.translucent=i,this.appearanceType=n,this.closed=r,this.primitives=t,this.createPrimitive=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.subscriptions=new e,this.showsUpdated=new e,this.itemsToRemove=[]};l.prototype.add=function(e,t){var i=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(i,t),this.updaters.set(i,e),e.hasConstantFill&&e.fillMaterialProperty.isConstant){var n=this;this.subscriptions.set(i,e.entity.definitionChanged.addEventListener(function(t,i){"isShowing"===i&&n.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(i,e)},l.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var i=this.subscriptions.get(t);n(i)&&(i(),this.subscriptions.remove(t))}},l.prototype.update=function(e){var a=!0,l=0,u=this.primitive,c=this.primitives;if(this.createPrimitive){n(u)&&(n(this.oldPrimitive)?c.remove(u):this.oldPrimitive=u),this.attributes.removeAll();var d=this.geometry.values;d.length>0&&(u=new o({asynchronous:!0,geometryInstances:d,appearance:new this.appearanceType({translucent:this.translucent,closed:this.closed})}),c.add(u),a=!1),this.primitive=u,this.createPrimitive=!1}else if(n(u)&&u.ready){n(this.oldPrimitive)&&(c.remove(this.oldPrimitive),this.oldPrimitive=void 0);for(var h=this.updatersWithAttributes.values,m=h.length,p=0;m>p;p++){var f=h[p],v=this.geometry.get(f.entity.id),g=this.attributes.get(v.id.id);if(n(g)||(g=u.getGeometryInstanceAttributes(v.id),this.attributes.set(v.id.id,g)),!f.fillMaterialProperty.isConstant){var _=f.fillMaterialProperty.color;_.getValue(e,s),t.equals(g._lastColor,s)||(g._lastColor=t.clone(s,g._lastColor),g.color=i.toValue(s,g.color),(this.translucent&&255===g.color[3]||!this.translucent&&255!==g.color[3])&&(this.itemsToRemove[l++]=f))}var y=f.entity.isShowing&&(f.hasConstantFill||f.isFilled(e)),C=1===g.show[0];y!==C&&(g.show=r.toValue(y,g.show))}this.updateShows(u)}else n(u)&&!u.ready&&(a=!1);return this.itemsToRemove.length=l,a},l.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,i=t.length,o=0;i>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),l=this.attributes.get(s.id.id);n(l)||(l=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,l));var u=a.entity.isShowing,c=1===l.show[0];u!==c&&(l.show=r.toValue(u,l.show))}this.showsUpdated.removeAll()},l.prototype.contains=function(e){return this.updaters.contains(e.id)},l.prototype.getBoundingSphere=function(e,t){var i=this.primitive;if(!i.ready)return a.PENDING;var r=i.getGeometryInstanceAttributes(e);return!n(r)||!n(r.boundingSphere)||n(r.show)&&0===r.show[0]?a.FAILED:(r.boundingSphere.clone(t),a.DONE)},l.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;n(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var i=this.oldPrimitive;n(i)&&(e.remove(i),this.oldPrimitive=void 0)};var u=function(e,t,i){this._solidBatch=new l(e,!1,t,i),this._translucentBatch=new l(e,!0,t,i)};return u.prototype.add=function(e,t){var i=t.createFillGeometryInstance(e);255===i.attributes.color.value[3]?this._solidBatch.add(t,i):this._translucentBatch.add(t,i)},u.prototype.remove=function(e){this._solidBatch.remove(e)||this._translucentBatch.remove(e)},u.prototype.update=function(e){var t,i,n=this._solidBatch.update(e);n=this._translucentBatch.update(e)&&n;var r=this._solidBatch.itemsToRemove,o=r.length;if(o>0)for(t=0;o>t;t++)i=r[t],this._solidBatch.remove(i),this._translucentBatch.add(i,i.createFillGeometryInstance(e));r=this._translucentBatch.itemsToRemove;var a=r.length;if(a>0)for(t=0;a>t;t++)i=r[t],this._translucentBatch.remove(i),this._solidBatch.add(i,i.createFillGeometryInstance(e));return(o>0||a>0)&&(n=this._solidBatch.update(e)&&n,n=this._translucentBatch.update(e)&&n),n},u.prototype.getBoundingSphere=function(e,t){return this._solidBatch.contains(e)?this._solidBatch.getBoundingSphere(e,t):this._translucentBatch.contains(e)?this._translucentBatch.getBoundingSphere(e,t):a.FAILED},u.prototype.removeAllPrimitives=function(){this._solidBatch.removeAllPrimitives(),this._translucentBatch.removeAllPrimitives()},u}),define("Cesium/DataSources/StaticGeometryPerMaterialBatch",["../Core/AssociativeArray","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState","./MaterialProperty"],function(e,t,i,n,r,o){"use strict";var a=function(t,i,n,r){this.primitives=t,this.appearanceType=i,this.materialProperty=n,this.closed=r,this.updaters=new e,this.createPrimitive=!0,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.material=void 0,this.updatersWithAttributes=new e,this.attributes=new e,this.invalidated=!1,this.removeMaterialSubscription=n.definitionChanged.addEventListener(a.prototype.onMaterialChanged,this),this.subscriptions=new e,this.showsUpdated=new e};a.prototype.onMaterialChanged=function(){this.invalidated=!0},a.prototype.isMaterial=function(e){var i=this.materialProperty,n=e.fillMaterialProperty;return n===i?!0:t(i)?i.equals(n):!1},a.prototype.add=function(e,t){var i=t.entity.id;if(this.updaters.set(i,t),this.geometry.set(i,t.createFillGeometryInstance(e)),t.hasConstantFill&&t.fillMaterialProperty.isConstant){var n=this;this.subscriptions.set(i,t.entity.definitionChanged.addEventListener(function(e,i){"isShowing"===i&&n.showsUpdated.set(e.id,t)}))}else this.updatersWithAttributes.set(i,t);this.createPrimitive=!0},a.prototype.remove=function(e){var i=e.entity.id,n=this.updaters.remove(i);if(n){this.geometry.remove(i),this.updatersWithAttributes.remove(i);var r=this.subscriptions.get(i);t(r)&&(r(),this.subscriptions.remove(i))}return this.createPrimitive=n,n},a.prototype.update=function(e){var r=!0,a=this.primitive,s=this.primitives,l=this.geometry.values;if(this.createPrimitive)t(a)&&(t(this.oldPrimitive)?s.remove(a):this.oldPrimitive=a),l.length>0&&(this.material=o.getValue(e,this.materialProperty,this.material),a=new n({asynchronous:!0,geometryInstances:l,appearance:new this.appearanceType({material:this.material,translucent:this.material.isTranslucent(),closed:this.closed})}),s.add(a),r=!1),this.primitive=a,this.createPrimitive=!1;else if(t(a)&&a.ready){t(this.oldPrimitive)&&(s.remove(this.oldPrimitive),this.oldPrimitive=void 0),this.material=o.getValue(e,this.materialProperty,this.material),this.primitive.appearance.material=this.material;for(var u=this.updatersWithAttributes.values,c=u.length,d=0;c>d;d++){var h=u[d],m=h.entity,p=this.geometry.get(m.id),f=this.attributes.get(p.id.id);t(f)||(f=a.getGeometryInstanceAttributes(p.id),this.attributes.set(p.id.id,f));var v=m.isShowing&&(h.hasConstantFill||h.isFilled(e)),g=1===f.show[0];v!==g&&(f.show=i.toValue(v,f.show))}this.updateShows(a)}else t(a)&&!a.ready&&(r=!1);return r},a.prototype.updateShows=function(e){for(var n=this.showsUpdated.values,r=n.length,o=0;r>o;o++){var a=n[o],s=a.entity,l=this.geometry.get(s.id),u=this.attributes.get(l.id.id);t(u)||(u=e.getGeometryInstanceAttributes(l.id),this.attributes.set(l.id.id,u));var c=s.isShowing,d=1===u.show[0];c!==d&&(u.show=i.toValue(c,u.show))}this.showsUpdated.removeAll()},a.prototype.contains=function(e){return this.updaters.contains(e.id)},a.prototype.getBoundingSphere=function(e,i){var n=this.primitive;if(!n.ready)return r.PENDING;var o=n.getGeometryInstanceAttributes(e);return!t(o)||!t(o.boundingSphere)||t(o.show)&&0===o.show[0]?r.FAILED:(o.boundingSphere.clone(i),r.DONE)},a.prototype.destroy=function(){var e=this.primitive,i=this.primitives;t(e)&&i.remove(e);var n=this.oldPrimitive;t(n)&&i.remove(n),this.removeMaterialSubscription()};var s=function(e,t,i){this._items=[],this._primitives=e,this._appearanceType=t,this._closed=i};return s.prototype.add=function(e,t){for(var i=this._items,n=i.length,r=0;n>r;r++){var o=i[r];if(o.isMaterial(t))return o.add(e,t),void 0}var s=new a(this._primitives,this._appearanceType,t.fillMaterialProperty,this._closed);s.add(e,t),i.push(s)},s.prototype.remove=function(e){for(var t=this._items,i=t.length,n=i-1;n>=0;n--){var r=t[n];if(r.remove(e)){0===r.updaters.length&&(t.splice(n,1),r.destroy());break}}},s.prototype.update=function(e){var t,i=this._items,n=i.length;for(t=n-1;t>=0;t--){var r=i[t];if(r.invalidated){i.splice(t,1);for(var o=r.updaters.values,a=o.length,s=0;a>s;s++)this.add(e,o[s]);r.destroy()}}var l=!0;for(t=0;n>t;t++)l=i[t].update(e)&&l;return l},s.prototype.getBoundingSphere=function(e,t){for(var i=this._items,n=i.length,o=0;n>o;o++){var a=i[o];if(a.contains(e))return a.getBoundingSphere(e,t)}return r.FAILED},s.prototype.removeAllPrimitives=function(){for(var e=this._items,t=e.length,i=0;t>i;i++)e[i].destroy();this._items.length=0},s}),define("Cesium/DataSources/StaticOutlineGeometryBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./BoundingSphereState"],function(e,t,i,n,r,o,a,s){"use strict";var l=function(t,i,n){this.translucent=i,this.primitives=t,this.createPrimitive=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.itemsToRemove=[],this.width=n,this.subscriptions=new e,this.showsUpdated=new e};l.prototype.add=function(e,t){var i=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(i,t),this.updaters.set(i,e),e.hasConstantOutline&&e.outlineColorProperty.isConstant){var n=this;this.subscriptions.set(i,e.entity.definitionChanged.addEventListener(function(t,i){"isShowing"===i&&n.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(i,e)},l.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var i=this.subscriptions.get(t);n(i)&&(i(),this.subscriptions.remove(t))}};var u=new t;l.prototype.update=function(e){var s=!0,l=0,c=this.primitive,d=this.primitives;if(this.createPrimitive){this.attributes.removeAll(),n(c)&&(n(this.oldPrimitive)?d.remove(c):this.oldPrimitive=c);var h=this.geometry.values;h.length>0&&(c=new a({asynchronous:!0,geometryInstances:h,appearance:new o({flat:!0,translucent:this.translucent,renderState:{lineWidth:this.width}})}),d.add(c),s=!1),this.primitive=c,this.createPrimitive=!1}else if(n(c)&&c.ready){n(this.oldPrimitive)&&(d.remove(this.oldPrimitive),this.oldPrimitive=void 0);for(var m=this.updatersWithAttributes.values,p=m.length,f=0;p>f;f++){var v=m[f],g=this.geometry.get(v.entity.id),_=this.attributes.get(g.id.id);if(n(_)||(_=c.getGeometryInstanceAttributes(g.id),this.attributes.set(g.id.id,_)),!v.outlineColorProperty.isConstant){var y=v.outlineColorProperty;y.getValue(e,u),t.equals(_._lastColor,u)||(_._lastColor=t.clone(u,_._lastColor),_.color=i.toValue(u,_.color),(this.translucent&&255===_.color[3]||!this.translucent&&255!==_.color[3])&&(this.itemsToRemove[l++]=v))}var C=v.entity.isShowing&&(v.hasConstantOutline||v.isOutlineVisible(e)),w=1===_.show[0];C!==w&&(_.show=r.toValue(C,_.show))}this.updateShows(c)}else n(c)&&!c.ready&&(s=!1);return this.itemsToRemove.length=l,s},l.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,i=t.length,o=0;i>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),l=this.attributes.get(s.id.id);n(l)||(l=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,l));var u=a.entity.isShowing,c=1===l.show[0];u!==c&&(l.show=r.toValue(u,l.show))}this.showsUpdated.removeAll()},l.prototype.contains=function(e){return this.updaters.contains(e.id)},l.prototype.getBoundingSphere=function(e,t){var i=this.primitive;if(!i.ready)return s.PENDING;var r=i.getGeometryInstanceAttributes(e);return!n(r)||!n(r.boundingSphere)||n(r.show)&&0===r.show[0]?s.FAILED:(r.boundingSphere.clone(t),s.DONE)},l.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;n(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var i=this.oldPrimitive;n(i)&&(e.remove(i),this.oldPrimitive=void 0)};var c=function(t,i){this._primitives=t,this._scene=i,this._solidBatches=new e,this._translucentBatches=new e};return c.prototype.add=function(e,t){var i,r,o=t.createOutlineGeometryInstance(e),a=this._scene.clampLineWidth(t.outlineWidth);255===o.attributes.color.value[3]?(i=this._solidBatches,r=i.get(a),n(r)||(r=new l(this._primitives,!1,a),i.set(a,r)),r.add(t,o)):(i=this._translucentBatches,r=i.get(a),n(r)||(r=new l(this._primitives,!0,a),i.set(a,r)),r.add(t,o))},c.prototype.remove=function(e){var t,i=this._solidBatches.values,n=i.length;for(t=0;n>t;t++)if(i[t].remove(e))return;var r=this._translucentBatches.values,o=r.length;for(t=0;o>t;t++)if(r[t].remove(e))return},c.prototype.update=function(e){var t,i,n,r,o,a=this._solidBatches.values,s=a.length,l=this._translucentBatches.values,u=l.length,c=!0,d=!1;do{for(d=!1,i=0;s>i;i++){r=a[i],c=r.update(e),o=r.itemsToRemove;var h=o.length;if(h>0)for(d=!0,t=0;h>t;t++)n=o[t],r.remove(n),this.add(e,n)}for(i=0;u>i;i++){r=l[i],c=r.update(e),o=r.itemsToRemove;var m=o.length;if(m>0)for(d=!0,t=0;m>t;t++)n=o[t],r.remove(n),this.add(e,n)}}while(d);return c},c.prototype.getBoundingSphere=function(e,t){var i,n=this._solidBatches.values,r=n.length;for(i=0;r>i;i++){var o=n[i];if(o.contains(e))return o.getBoundingSphere(e,t)}var a=this._translucentBatches.values,l=a.length;for(i=0;l>i;i++){var u=a[i];if(u.contains(e))return u.getBoundingSphere(e,t)}return s.FAILED},c.prototype.removeAllPrimitives=function(){var e,t=this._solidBatches.values,i=t.length;for(e=0;i>e;e++)t[e].removeAllPrimitives();var n=this._translucentBatches.values,r=n.length;for(e=0;r>e;e++)n[e].removeAllPrimitives()},c}),define("Cesium/DataSources/GeometryVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/defined","../Core/destroyObject","../Core/DeveloperError","./BoundingSphereState","./ColorMaterialProperty","./StaticGeometryColorBatch","./StaticGeometryPerMaterialBatch","./StaticOutlineGeometryBatch"],function(e,t,i,n,r,o,a,s,l,u){"use strict";function c(e,t){for(var i=e._batches,n=i.length,r=0;n>r;r++)i[r].remove(t)}function d(e,t,i){return i.isDynamic?(e._dynamicBatch.add(t,i),void 0):(i.outlineEnabled&&e._outlineBatch.add(t,i),i.fillEnabled&&(i.isClosed?i.fillMaterialProperty instanceof a?e._closedColorBatch.add(t,i):e._closedMaterialBatch.add(t,i):i.fillMaterialProperty instanceof a?e._openColorBatch.add(t,i):e._openMaterialBatch.add(t,i)),void 0)}var h=[],m=function(t){this._primitives=t,this._dynamicUpdaters=new e};m.prototype.add=function(e,t){this._dynamicUpdaters.set(t.entity.id,t.createDynamicUpdater(this._primitives))},m.prototype.remove=function(e){var t=e.entity.id,n=this._dynamicUpdaters.get(t);i(n)&&(this._dynamicUpdaters.remove(t),n.destroy())},m.prototype.update=function(e){for(var t=this._dynamicUpdaters.values,i=0,n=t.length;n>i;i++)t[i].update(e);return!0},m.prototype.removeAllPrimitives=function(){for(var e=this._dynamicUpdaters.values,t=0,i=e.length;i>t;t++)e[t].destroy();this._dynamicUpdaters.removeAll()},m.prototype.getBoundingSphere=function(e,t){var n=this._dynamicUpdaters.get(e.id);return i(n)&&i(n.getBoundingSphere)?n.getBoundingSphere(e,t):o.FAILED};var p=function(t,i,n){this._type=t;var r=i.primitives;this._scene=i,this._primitives=r,this._entityCollection=void 0,this._addedObjects=new e,this._removedObjects=new e,this._changedObjects=new e,this._outlineBatch=new u(r,i),this._closedColorBatch=new s(r,t.perInstanceColorAppearanceType,!0),this._closedMaterialBatch=new l(r,t.materialAppearanceType,!0),this._openColorBatch=new s(r,t.perInstanceColorAppearanceType,!1),this._openMaterialBatch=new l(r,t.materialAppearanceType,!1),this._dynamicBatch=new m(r),this._batches=[this._closedColorBatch,this._closedMaterialBatch,this._openColorBatch,this._openMaterialBatch,this._dynamicBatch,this._outlineBatch],this._subscriptions=new e,this._updaters=new e,this._entityCollection=n,n.collectionChanged.addEventListener(p.prototype._onCollectionChanged,this),this._onCollectionChanged(n,n.values,h)};p.prototype.update=function(e){var t,i,n,r,o=this._addedObjects,a=o.values,s=this._removedObjects,l=s.values,u=this._changedObjects,h=u.values;for(t=h.length-1;t>-1;t--)i=h[t],n=i.id,r=this._updaters.get(n),r.entity===i?(c(this,r),d(this,e,r)):(l.push(i),a.push(i));for(t=l.length-1;t>-1;t--)i=l[t],n=i.id,r=this._updaters.get(n),c(this,r),r.destroy(),this._updaters.remove(n),this._subscriptions.get(n)(),this._subscriptions.remove(n);for(t=a.length-1;t>-1;t--)i=a[t],n=i.id,r=new this._type(i,this._scene),this._updaters.set(n,r),d(this,e,r),this._subscriptions.set(n,r.geometryChanged.addEventListener(p._onGeometryChanged,this));o.removeAll(),s.removeAll(),u.removeAll();var m=!0,f=this._batches,v=f.length;for(t=0;v>t;t++)m=f[t].update(e)&&m;return m};var f=[],v=new t;return p.prototype.getBoundingSphere=function(e,i){for(var n=f,r=v,a=0,s=o.DONE,l=this._batches,u=l.length,c=0;u>c;c++){if(s=l[c].getBoundingSphere(e,r),s===o.PENDING)return o.PENDING;s===o.DONE&&(n[a]=t.clone(r,n[a]),a++)}return 0===a?o.FAILED:(n.length=a,t.fromBoundingSpheres(n,i),o.DONE)},p.prototype.isDestroyed=function(){return!1},p.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(p.prototype._onCollectionChanged,this),this._addedObjects.removeAll(),this._removedObjects.removeAll();var e,t=this._batches,i=t.length;for(e=0;i>e;e++)t[e].removeAllPrimitives();var r=this._subscriptions.values;for(i=r.length,e=0;i>e;e++)r[e]();return this._subscriptions.removeAll(),n(this)},p._onGeometryChanged=function(e){var t=this._removedObjects,n=this._changedObjects,r=e.entity,o=r.id;i(t.get(o))||i(n.get(o))||n.set(o,r)},p.prototype._onCollectionChanged=function(e,t,i){var n,r,o,a=this._addedObjects,s=this._removedObjects,l=this._changedObjects;for(n=i.length-1;n>-1;n--)o=i[n],r=o.id,a.remove(r)||(s.set(r,o),l.remove(r));for(n=t.length-1;n>-1;n--)o=t[n],r=o.id,s.remove(r)?l.set(r,o):a.set(r,o)},p}),define("Cesium/Scene/Label",["../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/NearFarScalar","./Billboard","./HorizontalOrigin","./LabelStyle","./VerticalOrigin"],function(e,t,i,n,r,o,a,s,l,u,c,d){"use strict";function h(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._rebindAllGlyphs=!0}function m(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._repositionAllGlyphs=!0}var p=function(r,o){r=n(r,n.EMPTY_OBJECT),this._text=n(r.text,""),this._show=n(r.show,!0),this._font=n(r.font,"30px sans-serif"),this._fillColor=i.clone(n(r.fillColor,i.WHITE)),this._outlineColor=i.clone(n(r.outlineColor,i.BLACK)),this._outlineWidth=n(r.outlineWidth,1),this._style=n(r.style,c.FILL),this._verticalOrigin=n(r.verticalOrigin,d.BOTTOM),this._horizontalOrigin=n(r.horizontalOrigin,u.LEFT),this._pixelOffset=e.clone(n(r.pixelOffset,e.ZERO)),this._eyeOffset=t.clone(n(r.eyeOffset,t.ZERO)),this._position=t.clone(n(r.position,t.ZERO)),this._scale=n(r.scale,1),this._id=r.id,this._translucencyByDistance=r.translucencyByDistance,this._pixelOffsetScaleByDistance=r.pixelOffsetScaleByDistance,this._labelCollection=o,this._glyphs=[],this._rebindAllGlyphs=!0,this._repositionAllGlyphs=!0};return o(p.prototype,{show:{get:function(){return this._show},set:function(e){if(this._show!==e){this._show=e;for(var t=this._glyphs,i=0,n=t.length;n>i;i++){var o=t[i];r(o.billboard)&&(o.billboard.show=e)}}}},position:{get:function(){return this._position},set:function(e){var i=this._position;if(!t.equals(i,e)){t.clone(e,i);for(var n=this._glyphs,o=0,a=n.length;a>o;o++){var s=n[o];r(s.billboard)&&(s.billboard.position=e)}}}},text:{get:function(){return this._text},set:function(e){this._text!==e&&(this._text=e,h(this))}},font:{get:function(){return this._font},set:function(e){this._font!==e&&(this._font=e,h(this))}},fillColor:{get:function(){return this._fillColor},set:function(e){var t=this._fillColor;i.equals(t,e)||(i.clone(e,t),h(this))}},outlineColor:{get:function(){return this._outlineColor},set:function(e){var t=this._outlineColor;i.equals(t,e)||(i.clone(e,t),h(this))}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){this._outlineWidth!==e&&(this._outlineWidth=e,h(this))}},style:{get:function(){return this._style},set:function(e){this._style!==e&&(this._style=e,h(this))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(t){var i=this._pixelOffset;if(!e.equals(i,t)){e.clone(t,i);for(var n=this._glyphs,o=0,a=n.length;a>o;o++){var s=n[o];r(s.billboard)&&(s.billboard.pixelOffset=t)}}}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){var t=this._translucencyByDistance;if(!s.equals(t,e)){this._translucencyByDistance=s.clone(e,t);for(var i=this._glyphs,n=0,o=i.length;o>n;n++){var a=i[n];r(a.billboard)&&(a.billboard.translucencyByDistance=e)}}}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){var t=this._pixelOffsetScaleByDistance;if(!s.equals(t,e)){this._pixelOffsetScaleByDistance=s.clone(e,t);for(var i=this._glyphs,n=0,o=i.length;o>n;n++){var a=i[n];r(a.billboard)&&(a.billboard.pixelOffsetScaleByDistance=e)}}}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){var i=this._eyeOffset;if(!t.equals(i,e)){t.clone(e,i);for(var n=this._glyphs,o=0,a=n.length;a>o;o++){var s=n[o];r(s.billboard)&&(s.billboard.eyeOffset=e)}}}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){this._horizontalOrigin!==e&&(this._horizontalOrigin=e,m(this))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){if(this._verticalOrigin!==e){this._verticalOrigin=e;for(var t=this._glyphs,i=0,n=t.length;n>i;i++){var o=t[i];r(o.billboard)&&(o.billboard.verticalOrigin=e)
}m(this)}}},scale:{get:function(){return this._scale},set:function(e){if(this._scale!==e){this._scale=e;for(var t=this._glyphs,i=0,n=t.length;n>i;i++){var o=t[i];r(o.billboard)&&(o.billboard.scale=e)}m(this)}}},id:{get:function(){return this._id},set:function(e){if(this._id!==e){this._id=e;for(var t=this._glyphs,i=0,n=t.length;n>i;i++){var o=t[i];r(o.billboard)&&(o.billboard.id=e)}}}}}),p.prototype.computeScreenSpacePosition=function(t,i){r(i)||(i=new e);var n=this._labelCollection,o=n.modelMatrix,a=l._computeActualPosition(this._position,t.frameState,o),s=l._computeScreenSpacePosition(o,a,this._eyeOffset,this._pixelOffset,t,i);return s.y=t.canvas.clientHeight-s.y,s},p.prototype.equals=function(n){return this===n||r(n)&&this._show===n._show&&this._scale===n._scale&&this._style===n._style&&this._verticalOrigin===n._verticalOrigin&&this._horizontalOrigin===n._horizontalOrigin&&this._text===n._text&&this._font===n._font&&t.equals(this._position,n._position)&&i.equals(this._fillColor,n._fillColor)&&i.equals(this._outlineColor,n._outlineColor)&&e.equals(this._pixelOffset,n._pixelOffset)&&t.equals(this._eyeOffset,n._eyeOffset)&&s.equals(this._translucencyByDistance,n._translucencyByDistance)&&s.equals(this._pixelOffsetScaleByDistance,n._pixelOffsetScaleByDistance)&&this._id===n._id},p.prototype.isDestroyed=function(){return!1},p}),define("Cesium/Scene/LabelCollection",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Core/writeTextToCanvas","./BillboardCollection","./HorizontalOrigin","./Label","./LabelStyle","./TextureAtlas","./VerticalOrigin"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";function p(){this.textureInfo=void 0,this.dimensions=void 0,this.billboard=void 0}function f(e,t,i){this.labelCollection=e,this.index=t,this.dimensions=i}function v(e,t,i,n,r,o,a){return E.font=t,E.fillColor=i,E.strokeColor=n,E.strokeWidth=r,E.textBaseline=a===m.BOTTOM?"bottom":a===m.TOP?"top":"middle",E.fill=o===d.FILL||o===d.FILL_AND_OUTLINE,E.stroke=o===d.OUTLINE||o===d.FILL_AND_OUTLINE,s(e,E)}function g(e,t){t.textureInfo=void 0,t.dimensions=void 0;var n=t.billboard;i(n)&&(n.show=!1,n.image=void 0,e._spareBillboards.push(n),t.billboard=void 0)}function _(e,t,i,n){e.addImage(t,i).then(function(e){n.index=e})}function y(e,t){var n,r,o,a=t._text,s=a.length,l=t._glyphs,c=l.length;if(c>s)for(r=s;c>r;++r)g(e,l[r]);l.length=s;var d=e._glyphTextureCache;for(o=0;s>o;++o){var h=a.charAt(o),m=t._font,y=t._fillColor,C=t._outlineColor,w=t._outlineWidth,E=t._style,b=t._verticalOrigin,S=JSON.stringify([h,m,y.toRgba(),C.toRgba(),w,+E,+b]),x=d[S];if(!i(x)){var T=v(h,m,y,C,w,E,b);x=new f(e,-1,T.dimensions),d[S]=x,T.width>0&&T.height>0&&_(e._textureAtlas,S,T,x)}if(n=l[o],i(n)?-1===x.index?g(e,n):i(n.textureInfo)&&(n.textureInfo=void 0):(n=new p,l[o]=n),n.textureInfo=x,n.dimensions=x.dimensions,-1!==x.index){var P=n.billboard;i(P)||(P=e._spareBillboards.length>0?e._spareBillboards.pop():e._billboardCollection.add({collection:e}),n.billboard=P),P.show=t._show,P.position=t._position,P.eyeOffset=t._eyeOffset,P.pixelOffset=t._pixelOffset,P.horizontalOrigin=u.LEFT,P.verticalOrigin=t._verticalOrigin,P.scale=t._scale,P.pickPrimitive=t,P.id=t._id,P.image=S,P.translucencyByDistance=t._translucencyByDistance,P.pixelOffsetScaleByDistance=t._pixelOffsetScaleByDistance}}t._repositionAllGlyphs=!0}function C(e,t){var n,r,o=e._glyphs,a=0,s=0,l=0,c=o.length;for(l=0;c>l;++l)n=o[l],r=n.dimensions,a+=r.computedWidth,s=Math.max(s,r.height);var d=e._scale,h=e._horizontalOrigin,p=0;h===u.CENTER?p-=a/2*d:h===u.RIGHT&&(p-=a*d),b.x=p*t,b.y=0;var f=e._verticalOrigin;for(l=0;c>l;++l)n=o[l],r=n.dimensions,f===m.BOTTOM||r.height===s?b.y=-r.descent*d:f===m.TOP?b.y=-(s-r.height)*d-r.descent*d:f===m.CENTER&&(b.y=-(s-r.height)/2*d-r.descent*d),b.y*=t,i(n.billboard)&&n.billboard._setTranslate(b),b.x+=r.computedWidth*d*t}function w(e,t){for(var i=t._glyphs,n=0,o=i.length;o>n;++n)g(e,i[n]);t._labelCollection=void 0,r(t)}var E={},b=new e,S=function(e){e=t(e,t.EMPTY_OBJECT),this._textureAtlas=void 0,this._billboardCollection=new l,this._billboardCollection.destroyTextureAtlas=!1,this._spareBillboards=[],this._glyphTextureCache={},this._labels=[],this._labelsToUpdate=[],this._totalGlyphCount=0,this._resolutionScale=void 0,this.modelMatrix=a.clone(t(e.modelMatrix,a.IDENTITY)),this.debugShowBoundingVolume=t(e.debugShowBoundingVolume,!1)};return n(S.prototype,{length:{get:function(){return this._labels.length}}}),S.prototype.add=function(e){var t=new c(e,this);return this._labels.push(t),this._labelsToUpdate.push(t),t},S.prototype.remove=function(e){if(i(e)&&e._labelCollection===this){var t=this._labels.indexOf(e);if(-1!==t)return this._labels.splice(t,1),w(this,e),!0}return!1},S.prototype.removeAll=function(){for(var e=this._labels,t=0,i=e.length;i>t;++t)w(this,e[t]);e.length=0},S.prototype.contains=function(e){return i(e)&&e._labelCollection===this},S.prototype.get=function(e){return this._labels[e]},S.prototype.update=function(e,t,n){var r=this._billboardCollection;r.modelMatrix=this.modelMatrix,r.debugShowBoundingVolume=this.debugShowBoundingVolume,i(this._textureAtlas)||(this._textureAtlas=new h({context:e}),r.textureAtlas=this._textureAtlas);var o=e.uniformState,a=o.resolutionScale,s=this._resolutionScale!==a;this._resolutionScale=a;var l;l=s?this._labels:this._labelsToUpdate;for(var u=0,c=l.length;c>u;++u){var d=l[u];if(!d.isDestroyed()){var m=d._glyphs.length;d._rebindAllGlyphs&&(y(this,d),d._rebindAllGlyphs=!1),(s||d._repositionAllGlyphs)&&(C(d,a),d._repositionAllGlyphs=!1);var p=d._glyphs.length-m;this._totalGlyphCount+=p}}this._labelsToUpdate.length=0,r.update(e,t,n)},S.prototype.isDestroyed=function(){return!1},S.prototype.destroy=function(){return this.removeAll(),this._billboardCollection=this._billboardCollection.destroy(),this._textureAtlas=this._textureAtlas&&this._textureAtlas.destroy(),r(this)},S}),define("Cesium/DataSources/LabelVisualizer",["../Core/AssociativeArray","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/HorizontalOrigin","../Scene/LabelCollection","../Scene/LabelStyle","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";function p(e,t){if(r(e)){var i=e.label;r(i)&&(t.push(e.index),i.show=!1,e.label=void 0,e.index=-1)}}var f=1,v="30px sans-serif",g=c.FILL,_=n.WHITE,y=n.BLACK,C=1,w=t.ZERO,E=i.ZERO,b=l.CENTER,S=d.CENTER,x=new i,T=new n,P=new n,A=new i,M=new t,I=new s,D=new s,O=function(e){this.entity=e,this.label=void 0,this.index=void 0},R=function(t,i){i.collectionChanged.addEventListener(R.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._labelCollection=void 0,this._entityCollection=i,this._items=new e,this._onCollectionChanged(i,i.values,[],[])};return R.prototype.update=function(e){for(var t=this._items.values,i=this._unusedIndexes,n=0,o=t.length;o>n;n++){var a,s=t[n],l=s.entity,c=l._label,d=s.label,h=l.isShowing&&l.isAvailable(e)&&m.getValueOrDefault(c._show,e,!0);if(h&&(x=m.getValueOrUndefined(l._position,e,x),a=m.getValueOrUndefined(c._text,e),h=r(x)&&r(a)),h){if(!r(d)){var O=this._labelCollection;r(O)||(O=new u,this._labelCollection=O,this._scene.primitives.add(O));var R=i.length;if(R>0){var L=i.pop();s.index=L,d=O.get(L)}else d=O.add(),s.index=O.length-1;d.id=l,s.label=d}d.show=!0,d.position=x,d.text=a,d.scale=m.getValueOrDefault(c._scale,e,f),d.font=m.getValueOrDefault(c._font,e,v),d.style=m.getValueOrDefault(c._style,e,g),d.fillColor=m.getValueOrDefault(c._fillColor,e,_,T),d.outlineColor=m.getValueOrDefault(c._outlineColor,e,y,P),d.outlineWidth=m.getValueOrDefault(c._outlineWidth,e,C),d.pixelOffset=m.getValueOrDefault(c._pixelOffset,e,w,M),d.eyeOffset=m.getValueOrDefault(c._eyeOffset,e,E,A),d.horizontalOrigin=m.getValueOrDefault(c._horizontalOrigin,e,b),d.verticalOrigin=m.getValueOrDefault(c._verticalOrigin,e,S),d.translucencyByDistance=m.getValueOrUndefined(c._translucencyByDistance,e,I),d.pixelOffsetScaleByDistance=m.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,D)}else p(s,i)}return!0},R.prototype.getBoundingSphere=function(e,t){var n=this._items.get(e.id);return r(n)&&r(n.label)?(t.center=i.clone(n.label.position,t.center),t.radius=0,h.DONE):h.FAILED},R.prototype.isDestroyed=function(){return!1},R.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(R.prototype._onCollectionChanged,this),r(this._labelCollection)&&this._scene.primitives.remove(this._labelCollection),o(this)},R.prototype._onCollectionChanged=function(e,t,i,n){var o,a,s=this._unusedIndexes,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],r(a._label)&&r(a._position)&&l.set(a.id,new O(a));for(o=n.length-1;o>-1;o--)a=n[o],r(a._label)&&r(a._position)?l.contains(a.id)||l.set(a.id,new O(a)):(p(l.get(a.id),s),l.remove(a.id));for(o=i.length-1;o>-1;o--)a=i[o],p(l.get(a.id),s),l.remove(a.id)},R}),define("Cesium/Core/loadArrayBuffer",["./loadWithXhr"],function(e){"use strict";var t=function(t,i){return e({url:t,responseType:"arraybuffer",headers:i})};return t}),define("Cesium/Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,i=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,i},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Cesium/ThirdParty/gltfDefaults",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";function i(i){t(i.accessors)||(i.accessors={});var n=i.accessors;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];o.byteStride=e(o.byteStride,0)}}function n(i){t(i.animations)||(i.animations={});var n=i.animations;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];t(o.channels)||(o.channels=[]),t(o.parameters)||(o.parameters={}),t(o.samplers)||(o.samplers={});var a=n.samplers;for(var s in a)if(a.hasOwnProperty(s)){var l=a[s];l.interpolation=e(l.interpolation,"LINEAR")}}}function r(i){t(i.asset)||(i.asset={});var n=i.asset;t(n.profile)&&"string"!=typeof n.profile||(n.profile={});var r=n.profile;n.premultipliedAlpha=e(i.asset.premultipliedAlpha,!1),r.api=e(r.api,"WebGL"),r.version=e(r.version,"1.0.2"),n.version=e(i.version,"0.9")}function o(i){t(i.buffers)||(i.buffers={});var n=i.buffers;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];o.type=e(o.type,"arraybuffer")}}function a(e){t(e.bufferViews)||(e.bufferViews={})}function s(e){t(e.cameras)||(e.cameras={})}function l(e){t(e.images)||(e.images={})}function u(i){t(i.lights)||(i.lights={});var n=i.lights;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];if("ambient"===o.type){t(o.ambient)||(o.ambient={});var a=o.ambient;t(a.color)||(a.color=[1,1,1])}else if("directional"===o.type){t(o.directional)||(o.directional={});var s=o.directional;t(s.color)||(s.color=[1,1,1])}else if("point"===o.type){t(o.point)||(o.point={});var l=o.point;t(l.color)||(l.color=[1,1,1]),l.constantAttenuation=e(l.constantAttenuation,1),l.linearAttenuation=e(l.linearAttenuation,0),l.quadraticAttenuation=e(l.quadraticAttenuation,0)}else if("spot"===o.type){t(o.spot)||(o.spot={});var u=o.spot;t(u.color)||(u.color=[1,1,1]),u.constantAttenuation=e(u.constantAttenuation,1),u.fallOffAngle=e(u.fallOffAngle,3.14159265),u.fallOffExponent=e(u.fallOffExponent,0),u.linearAttenuation=e(u.linearAttenuation,0),u.quadraticAttenuation=e(u.quadraticAttenuation,0)}}}function c(e){t(e.materials)||(e.materials={});var i=e.materials;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n].instanceTechnique;t(r.values)||(r.values={})}}function d(i){t(i.meshes)||(i.meshes={});var n=i.meshes;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];t(o.primitives)||(o.primitives=[]);for(var a=o.primitives.length,s=a.length,l=0;s>l;++l){var u=a[l];t(u.attributes)||(u.attributes={});var c=e(u.primitive,WebGLRenderingContext.TRIANGLES);u.mode=e(u.mode,c)}}}function h(e){t(e.nodes)||(e.nodes={});var i=e.nodes;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n];t(r.children)||(r.children=[]),t(r.matrix)||(t(r.translation)&&t(r.rotation)&&t(r.scale)?(t(r.translation)||(r.translation=[0,0,0]),t(r.rotation)||(r.rotation=[1,0,0,0]),t(r.scale)||(r.scale=[1,1,1])):r.matrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}}function m(e){t(e.programs)||(e.programs={});var i=e.programs;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n];t(r.attributes)||(r.attributes=[])}}function p(i){t(i.samplers)||(i.samplers={});var n=i.samplers;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];o.magFilter=e(o.magFilter,WebGLRenderingContext.LINEAR),o.minFilter=e(o.minFilter,WebGLRenderingContext.NEAREST_MIPMAP_LINEAR),o.wrapS=e(o.wrapS,WebGLRenderingContext.REPEAT),o.wrapT=e(o.wrapT,WebGLRenderingContext.REPEAT)}}function f(e){t(e.scenes)||(e.scenes={});var i=e.scenes;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n];t(r.node)||(r.node=[])}}function v(e){t(e.shaders)||(e.shaders={})}function g(e){t(e.skins)||(e.skins={});var i=e.skins;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n];t(r.bindShapeMatrix)&&(r.bindShapeMatrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}}function _(e){t(e.enable)||(e.enable=[]),t(e.disable)||(e.disable=[])}function y(e){t(e.techniques)||(e.techniques={});var i=e.techniques;for(var n in i)if(i.hasOwnProperty(n)){var r=i[n];t(r.parameters)||(r.parameters={});var o=r.passes;for(var a in o)if(o.hasOwnProperty(a)){var s=o[a],l=s.instanceProgram;t(l.attributes)||(l.attributes={}),t(l.uniforms)||(l.uniforms={}),t(s.states)||(s.states={}),_(s.states)}}}function C(i){t(i.textures)||(i.textures={});var n=i.textures;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];o.format=e(o.format,WebGLRenderingContext.RGBA),o.internalFormat=e(o.internalFormat,o.format),o.target=e(o.target,WebGLRenderingContext.TEXTURE_2D),o.type=e(o.type,WebGLRenderingContext.UNSIGNED_BYTE)}}var w=function(e){return t(e)?(t(e.allExtensions)||(e.allExtensions=[]),i(e),n(e),r(e),o(e),a(e),s(e),l(e),u(e),c(e),d(e),h(e),m(e),p(e),f(e),v(e),g(e),y(e),C(e),e):void 0};return w}),define("Cesium/Scene/getModelAccessor",["../Core/ComponentDatatype"],function(e){"use strict";var t={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16},i=function(i){var n=i.componentType,r=t[i.type];return{componentsPerAttribute:r,createArrayBufferView:function(t,i,o){return e.createArrayBufferView(n,t,i,r*o)}}};return i}),define("Cesium/Core/Spline",["./defaultValue","./defined","./DeveloperError"],function(e,t,i){"use strict";var n=function(){this.times=void 0,this.points=void 0,i.throwInstantiationError()};return n.prototype.evaluate=i.throwInstantiationError,n.prototype.findTimeInterval=function(t,i){var n=this.times,r=n.length;if(i=e(i,0),t>=n[i]){if(r>i+1&&t<n[i+1])return i;if(r>i+2&&t<n[i+2])return i+1}else if(i-1>=0&&t>=n[i-1])return i-1;var o;if(t>n[i])for(o=i;r-1>o&&!(t>=n[o]&&t<n[o+1]);++o);else for(o=i-1;o>=0&&!(t>=n[o]&&t<n[o+1]);--o);return o===r-1&&(o=r-2),o},n}),define("Cesium/Core/LinearSpline",["./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Spline"],function(e,t,i,n,r,o){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT);var i=e.points,n=e.times;this._times=n,this._points=i,this._lastTimeIndex=0};return n(a.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),a.prototype.findTimeInterval=o.prototype.findTimeInterval,a.prototype.evaluate=function(t,n){var r=this.points,o=this.times,a=this._lastTimeIndex=this.findTimeInterval(t,this._lastTimeIndex),s=(t-o[a])/(o[a+1]-o[a]);return i(n)||(n=new e),e.lerp(r[a],r[a+1],s,n)},a}),define("Cesium/Core/QuaternionSpline",["./defaultValue","./defined","./defineProperties","./DeveloperError","./Quaternion","./Spline"],function(e,t,i,n,r,o){"use strict";function a(e,i,n){var o=e.length,a=new Array(o);a[0]=t(i)?i:e[0],a[o-1]=t(n)?n:e[o-1];for(var s=1;o-1>s;++s)a[s]=r.computeInnerQuadrangle(e[s-1],e[s],e[s+1],new r);return a}function s(e){var i=e.points,n=e.innerQuadrangles,o=e.times;if(i.length<3){var a=o[0],s=1/(o[1]-a),l=i[0],u=i[1];return function(e,i){t(i)||(i=new r);var n=(e-a)*s;return r.fastSlerp(l,u,n,i)}}return function(a,s){t(s)||(s=new r);var l=e._lastTimeIndex=e.findTimeInterval(a,e._lastTimeIndex),u=(a-o[l])/(o[l+1]-o[l]),c=i[l],d=i[l+1],h=n[l],m=n[l+1];return r.fastSquad(c,d,h,m,u,s)}}var l=function(t){t=e(t,e.EMPTY_OBJECT);var i=t.points,n=t.times,r=t.firstInnerQuadrangle,o=t.lastInnerQuadrangle,l=a(i,r,o);this._times=n,this._points=i,this._innerQuadrangles=l,this._evaluateFunction=s(this),this._lastTimeIndex=0};return i(l.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},innerQuadrangles:{get:function(){return this._innerQuadrangles}}}),l.prototype.findTimeInterval=o.prototype.findTimeInterval,l.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},l}),define("Cesium/Scene/ModelAnimationCache",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/LinearSpline","../Core/Matrix4","../Core/Quaternion","../Core/QuaternionSpline","./getModelAccessor"],function(e,t,i,n,r,o,a,s){"use strict";function l(e,i){var n=e.gltf,r=n.buffers,o=n.bufferViews,a=o[i.bufferView],l=r[a.buffer],u=a.byteOffset+i.byteOffset,c=i.count*s(i).componentsPerAttribute;return e.cacheKey+"//"+t(l.path,"")+"/"+u+"/"+c}function u(e,t,i){return e.cacheKey+"//"+t+"/"+i}var c=function(){},d={},h=new e;c.getAnimationParameterValues=function(t,n){var r=l(t,n),a=d[r];if(!i(a)){var u,c=t._loadResources.buffers,m=t.gltf,p=m.bufferViews,f=p[n.bufferView],v=n.componentType,g=n.type,_=n.count,y=s(n).createArrayBufferView(c[f.buffer],f.byteOffset+n.byteOffset,_);if(v===WebGLRenderingContext.FLOAT&&"SCALAR"===g)a=y;else if(v===WebGLRenderingContext.FLOAT&&"VEC3"===g)for(a=new Array(_),u=0;_>u;++u)a[u]=e.fromArray(y,3*u);else if(v===WebGLRenderingContext.FLOAT&&"VEC4"===g)for(a=new Array(_),u=0;_>u;++u){var C=4*u;a[u]=o.fromAxisAngle(e.fromArray(y,C,h),y[C+3])}i(t.cacheKey)&&(d[r]=a)}return a};var m={},p=function(e){this._value=e};p.prototype.evaluate=function(){return this._value},c.getAnimationSpline=function(e,t,r,o,s,l){var c=u(e,t,o),d=m[c];if(!i(d)){var h=l[s.input],f=e.gltf.accessors[r.parameters[s.output]],v=l[s.output];if(1===h.length&&1===v.length)d=new p(v[0]);else{var g=f.componentType,_=f.type;"LINEAR"===s.interpolation&&(g===WebGLRenderingContext.FLOAT&&"VEC3"===_?d=new n({times:h,points:v}):g===WebGLRenderingContext.FLOAT&&"VEC4"===_&&(d=new a({times:h,points:v})))}i(e.cacheKey)&&(m[c]=d)}return d};var f={};return c.getSkinInverseBindMatrices=function(e,t){var n=l(e,t),o=f[n];if(!i(o)){var a=e._loadResources.buffers,u=e.gltf,c=u.bufferViews,d=c[t.bufferView],h=t.componentType,m=t.type,p=t.count,v=s(t).createArrayBufferView(a[d.buffer],d.byteOffset+t.byteOffset,p);if(o=new Array(p),h===WebGLRenderingContext.FLOAT&&"MAT4"===m)for(var g=0;p>g;++g)o[g]=r.fromArray(v,16*g);f[n]=o}return o},c}),define("Cesium/Scene/ModelAnimationLoop",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,REPEAT:1,MIRRORED_REPEAT:2};return e(t)}),define("Cesium/Scene/ModelAnimationState",["../Core/freezeObject"],function(e){"use strict";return e({STOPPED:0,ANIMATING:1})}),define("Cesium/Scene/ModelAnimation",["../Core/defaultValue","../Core/defineProperties","../Core/Event","../Core/JulianDate","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,i,n,r,o){"use strict";var a=function(t,a,s){this._name=t.name,this._startTime=n.clone(t.startTime),this._delay=e(t.delay,0),this._stopTime=t.stopTime,this.removeOnStop=e(t.removeOnStop,!1),this._speedup=e(t.speedup,1),this._reverse=e(t.reverse,!1),this._loop=e(t.loop,r.NONE),this.start=new i,this.update=new i,this.stop=new i,this._state=o.STOPPED,this._runtimeAnimation=s,this._computedStartTime=void 0,this._duration=void 0;var l=this;this._raiseStartEvent=function(){l.start.raiseEvent(a,l)},this._updateEventTime=0,this._raiseUpdateEvent=function(){l.update.raiseEvent(a,l,l._updateEventTime)},this._raiseStopEvent=function(){l.stop.raiseEvent(a,l)}};return t(a.prototype,{name:{get:function(){return this._name}},startTime:{get:function(){return this._startTime}},delay:{get:function(){return this._delay}},stopTime:{get:function(){return this._stopTime}},speedup:{get:function(){return this._speedup}},reverse:{get:function(){return this._reverse}},loop:{get:function(){return this._loop}}}),a}),define("Cesium/Scene/ModelAnimationCollection",["../Core/clone","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","../Core/Math","./ModelAnimation","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,i,n,r,o,a,s,l,u,c){"use strict";function d(e,t){for(var i=e.channelEvaluators,n=i.length,r=0;n>r;++r)i[r](t)}function h(e,t,i){return function(){e.animationRemoved.raiseEvent(t,i)}}var m=function(e){this.animationAdded=new o,this.animationRemoved=new o,this._model=e,this._scheduledAnimations=[],this._previousTime=void 0};n(m.prototype,{length:{get:function(){return this._scheduledAnimations.length}}}),m.prototype.add=function(e){e=t(e,t.EMPTY_OBJECT);var i=this._model,n=i._runtime.animations,r=n[e.name],o=new l(e,i,r);return this._scheduledAnimations.push(o),this.animationAdded.raiseEvent(i,o),o},m.prototype.addAll=function(i){i=t(i,t.EMPTY_OBJECT),i=e(i);for(var n=[],r=this._model._animationIds,o=r.length,a=0;o>a;++a)i.name=r[a],n.push(this.add(i));return n},m.prototype.remove=function(e){if(i(e)){var t=this._scheduledAnimations,n=t.indexOf(e);if(-1!==n)return t.splice(n,1),this.animationRemoved.raiseEvent(this._model,e),!0}return!1},m.prototype.removeAll=function(){var e=this._model,t=this._scheduledAnimations,i=t.length;this._scheduledAnimations=[];for(var n=0;i>n;++n)this.animationRemoved.raiseEvent(e,t[n])},m.prototype.contains=function(e){return i(e)?-1!==this._scheduledAnimations.indexOf(e):!1},m.prototype.get=function(e){return this._scheduledAnimations[e]};var p=[];return m.prototype.update=function(e){if(a.equals(e.time,this._previousTime))return!1;this._previousTime=a.clone(e.time,this._previousTime);for(var n=!1,r=e.time,o=this._model,l=this._scheduledAnimations,m=l.length,f=0;m>f;++f){var v=l[f],g=v._runtimeAnimation;i(v._computedStartTime)||(v._computedStartTime=a.addSeconds(t(v.startTime,r),v.delay,new a)),i(v._duration)||(v._duration=g.stopTime*(1/v.speedup));var _=v._computedStartTime,y=v._duration,C=v.stopTime,w=0!==y?a.secondsDifference(r,_)/y:0,E=w>=0,b=E&&(1>=w||v.loop===u.REPEAT||v.loop===u.MIRRORED_REPEAT)&&(!i(C)||a.lessThanOrEquals(r,C));if(b){if(v._state===c.STOPPED&&(v._state=c.ANIMATING,v.start.numberOfListeners>0&&e.afterRender.push(v._raiseStartEvent)),v.loop===u.REPEAT)w-=Math.floor(w);else if(v.loop===u.MIRRORED_REPEAT){var S=Math.floor(w),x=w-S;w=1===S%2?1-x:x}v.reverse&&(w=1-w);var T=w*y*v.speedup;T=s.clamp(T,g.startTime,g.stopTime),d(g,T),v.update.numberOfListeners>0&&(v._updateEventTime=T,e.afterRender.push(v._raiseUpdateEvent)),n=!0}else E&&v._state===c.ANIMATING&&(v._state=c.STOPPED,v.stop.numberOfListeners>0&&e.afterRender.push(v._raiseStopEvent),v.removeOnStop&&p.push(v))}m=p.length;for(var P=0;m>P;++P){var A=p[P];l.splice(l.indexOf(A),1),e.afterRender.push(h(this,o,A))}return p.length=0,n},m}),define("Cesium/Scene/ModelMaterial",["../Core/defined","../Core/defineProperties","../Core/DeveloperError"],function(e,t){"use strict";var i=function(e,t,i){this._name=t.name,this._id=i,this._uniformMap=e._uniformMaps[i]};return t(i.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}}}),i.prototype.setValue=function(e,t){var i=this._uniformMap.values[e];i.value=i.clone(t,i.value)},i.prototype.getValue=function(t){var i=this._uniformMap.values[t];return e(i)?i.value:void 0},i}),define("Cesium/Scene/ModelMesh",["../Core/defineProperties"],function(e){"use strict";var t=function(e,t,i){for(var n=[],r=e.primitives,o=r.length,a=0;o>a;++a){var s=r[a];n[a]=t[s.material]}this._name=e.name,this._materials=n,this._id=i};return e(t.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},materials:{get:function(){return this._materials}}}),t}),define("Cesium/Scene/ModelNode",["../Core/defaultValue","../Core/defineProperties","../Core/Matrix4"],function(e,t,i){"use strict";var n=function(e,t,n,r,o){this._model=e,this._runtimeNode=n,this._name=t.name,this._id=r,this.useMatrix=!1,this._show=!0,this._matrix=i.clone(o)};return t(n.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,this._model._perNodeShowDirty=!0)}},matrix:{get:function(){return this._matrix},set:function(e){this._matrix=i.clone(e,this._matrix),this.useMatrix=!0;var t=this._model;t._cesiumAnimationsDirty=!0,this._runtimeNode.dirtyNumber=t._maxDirtyNumber}}}),n.prototype.setMatrix=function(e){i.clone(e,this._matrix)},n}),define("Cesium/Scene/Model",["../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/clone","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/IndexDatatype","../Core/loadArrayBuffer","../Core/loadImage","../Core/loadText","../Core/Math","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/PrimitiveType","../Core/Quaternion","../Core/Queue","../Core/RuntimeError","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/ShaderSource","../Renderer/TextureMinificationFilter","../Renderer/TextureWrap","../ThirdParty/gltfDefaults","../ThirdParty/Uri","../ThirdParty/when","./getModelAccessor","./ModelAnimationCache","./ModelAnimationCollection","./ModelMaterial","./ModelMesh","./ModelNode","./Pass","./SceneMode"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T,P,A,M,I,D,O,R,L,N,z,F,B,V){"use strict";function k(){this.buffersToCreate=new E,this.buffers={},this.pendingBufferLoads=0,this.programsToCreate=new E,this.shaders={},this.pendingShaderLoads=0,this.texturesToCreate=new E,this.pendingTextureLoads=0,this.createSamplers=!0,this.createSkins=!0,this.createRuntimeAnimations=!0,this.createVertexArrays=!0,this.createRenderStates=!0,this.createUniformMaps=!0,this.createRuntimeNodes=!0,this.skinnedNodesNames=[]}function U(e){var t=[];if(s(e)&&s(e.gltf)){var i=e.gltf.animations;for(var n in i)i.hasOwnProperty(n)&&t.push(n)}return t}function W(e,t){e._cachedGltf=t,e._animationIds=U(t)}function G(e,t,i){return e._runtime[t][i]}function H(t){for(var n=t.nodes,r=t.meshes,o=t.accessors,l=t.scenes[t.scene].nodes,u=l.length,c=[],d=new i(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),h=new i(Number.MIN_VALUE,Number.MIN_VALUE,Number.MIN_VALUE),m=0;u>m;++m){var p=n[l[m]];for(p._transformToRoot=et(p),c.push(p);c.length>0;){p=c.pop();var f=p._transformToRoot,v=a(p.meshes,s(p.instanceSkin)?p.instanceSkin.meshes:void 0);if(s(v))for(var g=v.length,_=0;g>_;++_)for(var C=r[v[_]].primitives,w=C.length,E=0;w>E;++E){var b=C[E].attributes.POSITION;if(s(b)){var S=o[b],x=i.fromArray(S.min,0,ei),T=i.fromArray(S.max,0,ti);s(d)&&s(h)&&(y.multiplyByPoint(f,x,x),y.multiplyByPoint(f,T,T),i.minimumByComponent(d,x,d),i.maximumByComponent(h,T,h))}}for(var P=p.children,A=P.length,M=0;A>M;++M){var I=n[P[M]];I._transformToRoot=et(I),y.multiplyTransformation(f,I._transformToRoot,I._transformToRoot),c.push(I)}delete p._transformToRoot}}var D=e.fromCornerPoints(d,h);return e.transformWithoutScale(D,Xt,D)}function q(e,t,i){return function(){e._loadError=new b("Failed to load external "+t+": "+i),e._state=Jt.FAILED}}function j(e,t){return function(i){var n=e._loadResources;n.buffers[t]=i,--n.pendingBufferLoads}}function Y(e){var t=e.gltf.buffers;for(var i in t)if(t.hasOwnProperty(i)){var n=t[i];if("arraybuffer"===n.type){++e._loadResources.pendingBufferLoads;var r=new I(n.uri),o=r.resolve(e._baseUri).toString();m(o).then(j(e,i)).otherwise(q(e,"buffer",o))}else"text"===n.type}}function X(e){var t=e.gltf.bufferViews;for(var i in t)t.hasOwnProperty(i)&&e._loadResources.buffersToCreate.enqueue(i)}function Z(e,t){return function(i){var n=e._loadResources;n.shaders[t]=i,--n.pendingShaderLoads}}function J(e){var t=e.gltf.shaders;for(var i in t)if(t.hasOwnProperty(i)){++e._loadResources.pendingShaderLoads;var n=t[i],r=new I(n.uri),o=r.resolve(e._baseUri).toString();f(o).then(Z(e,i)).otherwise(q(e,"shader",o))}}function K(e){var t=e.gltf.programs;for(var i in t)t.hasOwnProperty(i)&&e._loadResources.programsToCreate.enqueue(i)}function Q(e,t){return function(i){var n=e._loadResources;--n.pendingTextureLoads,n.texturesToCreate.enqueue({name:t,image:i})}}function $(e){var t=e.gltf.images,i=e.gltf.textures;for(var n in i)if(i.hasOwnProperty(n)){++e._loadResources.pendingTextureLoads;var r=i[n],o=new I(t[r.source].uri),a=o.resolve(e._baseUri).toString();p(a).then(Q(e,n)).otherwise(q(e,"image",a))}}function et(e){if(s(e.matrix))return y.fromArray(e.matrix);var t=i.fromArray(e.rotation,0,ii);return y.fromTranslationQuaternionRotationScale(i.fromArray(e.translation,0,ni),w.fromAxisAngle(t,e.rotation[3],ri),i.fromArray(e.scale,0,oi))}function tt(e){var t={},i={},n=[],r=e._loadResources.skinnedNodesNames,o=e.gltf.nodes;for(var a in o)if(o.hasOwnProperty(a)){var l=o[a],u={matrix:void 0,translation:void 0,rotation:void 0,scale:void 0,computedShow:!0,transformToRoot:new y,computedMatrix:new y,dirtyNumber:0,commands:[],inverseBindMatrices:void 0,bindShapeMatrix:void 0,joints:[],computedJointMatrices:[],jointName:l.jointName,children:[],parents:[],publicNode:void 0};u.publicNode=new F(e,l,u,a,et(l)),t[a]=u,i[l.name]=u,s(l.instanceSkin)&&(r.push(a),n.push(u))}e._runtime.nodes=t,e._runtime.nodesByName=i,e._runtime.skinnedNodes=n}function it(e){var t={},i={},n=e.gltf.materials,r=e._uniformMaps;for(var o in n)if(n.hasOwnProperty(o)){r[o]={uniformMap:void 0,values:void 0,jointMatrixUniformName:void 0};var a=n[o],s=new N(e,a,o);t[a.name]=s,i[o]=s}e._runtime.materialsByName=t,e._runtime.materialsById=i}function nt(e){var t={},i=e._runtime.materialsById,n=e.gltf.meshes;for(var r in n)if(n.hasOwnProperty(r)){var o=n[r];t[o.name]=new z(o,i,r)}e._runtime.meshesByName=t}function rt(e){e._loadRendererResourcesFromCache||(Y(e),X(e),J(e),K(e),$(e)),it(e),nt(e),tt(e)}function ot(e,t){var i=e._loadResources;if(0===i.pendingBufferLoads){for(var n,r,o=e.gltf.bufferViews,a=i.buffers,l=e._rendererResources.buffers;i.buffersToCreate.length>0;){var u=i.buffersToCreate.dequeue();if(r=o[u],r.target===WebGLRenderingContext.ARRAY_BUFFER){n=new Uint8Array(a[r.buffer],r.byteOffset,r.byteLength);var c=t.createVertexBuffer(n,S.STATIC_DRAW);c.vertexArrayDestroyable=!1,l[u]=c}}var d=e.gltf.accessors;for(var h in d)if(d.hasOwnProperty(h)){var m=d[h];if(r=o[m.bufferView],r.target===WebGLRenderingContext.ELEMENT_ARRAY_BUFFER&&!s(l[m.bufferView])){n=new Uint8Array(a[r.buffer],r.byteOffset,r.byteLength);var p=t.createIndexBuffer(n,S.STATIC_DRAW,m.componentType);p.vertexArrayDestroyable=!1,l[m.bufferView]=p}}}}function at(e){for(var t={},i=e.length,n=0;i>n;++n)t[e[n]]=n;return t}function st(e,t,i){var n=t.gltf.programs,r=t._loadResources.shaders,o=n[e],a=at(o.attributes),s=r[o.vertexShader],l=r[o.fragmentShader];if(t._rendererResources.programs[e]=i.createShaderProgram(s,l,a),t.allowPicking){var u=new T({sources:[l],pickColorQualifier:"uniform"});t._rendererResources.pickPrograms[e]=i.createShaderProgram(s,u,a)}}function lt(e,t){var i,n=e._loadResources;if(0===n.pendingShaderLoads)if(e.asynchronous)n.programsToCreate.length>0&&(i=n.programsToCreate.dequeue(),st(i,e,t));
else for(;n.programsToCreate.length>0;)i=n.programsToCreate.dequeue(),st(i,e,t)}function ut(e,t){var i=e._loadResources;if(i.createSamplers){i.createSamplers=!1;var n=e._rendererResources.samplers,r=e.gltf.samplers;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];n[o]=t.createSampler({wrapS:a.wrapS,wrapT:a.wrapT,minificationFilter:a.minFilter,magnificationFilter:a.magFilter})}}}function ct(e,t,i){var n=t.gltf.textures,r=n[e.name],o=t._rendererResources.samplers,a=o[r.sampler],s=a.minificationFilter===P.NEAREST_MIPMAP_NEAREST||a.minificationFilter===P.NEAREST_MIPMAP_LINEAR||a.minificationFilter===P.LINEAR_MIPMAP_NEAREST||a.minificationFilter===P.LINEAR_MIPMAP_LINEAR,l=s||a.wrapS===A.REPEAT||a.wrapS===A.MIRRORED_REPEAT||a.wrapT===A.REPEAT||a.wrapT===A.MIRRORED_REPEAT,u=e.image,c=!v.isPowerOfTwo(u.width)||!v.isPowerOfTwo(u.height);if(l&&c){var d=document.createElement("canvas");d.width=v.nextPowerOfTwo(u.width),d.height=v.nextPowerOfTwo(u.height);var h=d.getContext("2d");h.drawImage(u,0,0,u.width,u.height,0,0,d.width,d.height),u=d}var m;r.target===WebGLRenderingContext.TEXTURE_2D&&(m=i.createTexture2D({source:u,pixelFormat:r.internalFormat,pixelDatatype:r.type,flipY:!1})),s&&m.generateMipmap(),m.sampler=a,t._rendererResources.textures[e.name]=m}function dt(e,t){var i,n=e._loadResources;if(e.asynchronous)n.texturesToCreate.length>0&&(i=n.texturesToCreate.dequeue(),ct(i,e,t));else for(;n.texturesToCreate.length>0;)i=n.texturesToCreate.dequeue(),ct(i,e,t)}function ht(e,t){var i=e.gltf;i.programs;var n=i.techniques,r=i.materials,o={},a=n[r[t.material].instanceTechnique.technique],s=a.parameters,l=a.passes[a.pass],u=l.instanceProgram,c=u.attributes,d=e._rendererResources.programs[u.program].vertexAttributes;for(var h in d)if(d.hasOwnProperty(h)){var m=s[c[h]];o[m.semantic]=d[h].index}return o}function mt(e,t){for(var i=e.length,n=0;i>n;++n)for(var r=[e[n]];r.length>0;){var o=r.pop();if(o.jointName===t)return o;for(var a=o.children,s=a.length,l=0;s>l;++l)r.push(a[l])}return void 0}function pt(e,t){for(var i=e.gltf,n=i.skins,r=i.nodes,o=e._runtime.nodes,a=e._loadResources.skinnedNodesNames,s=a.length,l=0;s>l;++l){var u=a[l],c=o[u],d=r[u].instanceSkin,h=t[d.skin];c.inverseBindMatrices=h.inverseBindMatrices,c.bindShapeMatrix=h.bindShapeMatrix;for(var m=[],p=d.skeletons,f=p.length,v=0;f>v;++v)m.push(o[p[v]]);for(var g=n[d.skin].jointNames,_=g.length,y=0;_>y;++y){var C=g[y];c.joints.push(mt(m,C))}}}function ft(e){var t=e._loadResources;if(t.finishedBuffersCreation()&&t.createSkins){t.createSkins=!1;var i=e.gltf,n=i.accessors,r=i.skins,o={};for(var a in r)if(r.hasOwnProperty(a)){var s,l=r[a],u=n[l.inverseBindMatrices];y.equals(l.bindShapeMatrix,y.IDENTITY)||(s=y.clone(l.bindShapeMatrix)),o[a]={inverseBindMatrices:R.getSkinInverseBindMatrices(e,u),bindShapeMatrix:s}}pt(e,o)}}function vt(e,t,i,n){return function(r){t[i]=n.evaluate(r,t[i]),t.dirtyNumber=e._maxDirtyNumber}}function gt(e){var t=e._loadResources;if(t.finishedPendingLoads()&&t.createRuntimeAnimations){t.createRuntimeAnimations=!1,e._runtime.animations={};var i,n=e._runtime.nodes,r=e.gltf.animations,o=e.gltf.accessors;for(var a in r)if(r.hasOwnProperty(a)){var s=r[a],l=s.channels,u=s.parameters,c=s.samplers,d={};for(i in u)u.hasOwnProperty(i)&&(d[i]=R.getAnimationParameterValues(e,o[u[i]]));for(var h=Number.MAX_VALUE,m=-Number.MAX_VALUE,p=l.length,f=new Array(p),v=0;p>v;++v){var g=l[v],_=g.target,y=c[g.sampler],C=d[y.input];h=Math.min(h,C[0]),m=Math.max(m,C[C.length-1]);var w=R.getAnimationSpline(e,a,s,g.sampler,y,d);f[v]=vt(e,n[_.id],_.path,w)}e._runtime.animations[a]={startTime:h,stopTime:m,channelEvaluators:f}}}}function _t(e,t){var i=e._loadResources;if(i.finishedBuffersCreation()&&i.finishedProgramCreation()&&i.createVertexArrays){i.createVertexArrays=!1;var n=e._rendererResources.buffers,r=e._rendererResources.vertexArrays,o=e.gltf,a=o.accessors,l=o.meshes;for(var u in l)if(l.hasOwnProperty(u))for(var c=l[u].primitives,d=c.length,h=0;d>h;++h){var m=c[h],p=ht(e,m),f=[],v=m.attributes;for(var g in v)if(v.hasOwnProperty(g)){var _=p[g];if(s(_)){var y=a[v[g]];f.push({index:_,vertexBuffer:n[y.bufferView],componentsPerAttribute:O(y).componentsPerAttribute,componentDatatype:y.componentType,normalize:!1,offsetInBytes:y.byteOffset,strideInBytes:y.byteStride})}}var C=a[m.indices],w=n[C.bufferView];r[u+".primitive."+h]=t.createVertexArray(f,w)}}}function yt(e){var t={};t[WebGLRenderingContext.BLEND]=!1,t[WebGLRenderingContext.CULL_FACE]=!1,t[WebGLRenderingContext.DEPTH_TEST]=!1,t[WebGLRenderingContext.POLYGON_OFFSET_FILL]=!1,t[WebGLRenderingContext.SCISSOR_TEST]=!1;var i,n=e.enable,r=n.length;for(i=0;r>i;++i)t[n[i]]=!0;return t}function Ct(e,t){var i=e._loadResources;if(i.createRenderStates){i.createRenderStates=!1;var n=e._rendererResources.renderStates,r=e.gltf.techniques;for(var o in r)if(r.hasOwnProperty(o)){var l=r[o],u=l.passes[l.pass],c=u.states,d=yt(c),h=a(c.functions,a.EMPTY_OBJECT),m=a(h.blendColor,[0,0,0,0]),p=a(h.blendEquationSeparate,[WebGLRenderingContext.FUNC_ADD,WebGLRenderingContext.FUNC_ADD]),f=a(h.blendFuncSeparate,[WebGLRenderingContext.ONE,WebGLRenderingContext.ONE,WebGLRenderingContext.ZERO,WebGLRenderingContext.ZERO]),v=a(h.colorMask,[!0,!0,!0,!0]),g=a(h.depthRange,[0,1]),_=a(h.polygonOffset,[0,0]),y=a(h.scissor,[0,0,0,0]);n[o]=t.createRenderState({frontFace:s(h.frontFace)?h.frontFace[0]:WebGLRenderingContext.CCW,cull:{enabled:d[WebGLRenderingContext.CULL_FACE],face:s(h.cullFace)?h.cullFace[0]:WebGLRenderingContext.BACK},lineWidth:s(h.lineWidth)?h.lineWidth[0]:1,polygonOffset:{enabled:d[WebGLRenderingContext.POLYGON_OFFSET_FILL],factor:_[0],units:_[1]},scissorTest:{enabled:d[WebGLRenderingContext.SCISSOR_TEST],rectangle:{x:y[0],y:y[1],width:y[2],height:y[3]}},depthRange:{near:g[0],far:g[1]},depthTest:{enabled:d[WebGLRenderingContext.DEPTH_TEST],func:s(h.depthFunc)?h.depthFunc[0]:WebGLRenderingContext.LESS},colorMask:{red:v[0],green:v[1],blue:v[2],alpha:v[3]},depthMask:s(h.depthMask)?h.depthMask[0]:!0,blending:{enabled:d[WebGLRenderingContext.BLEND],color:{red:m[0],green:m[1],blue:m[2],alpha:m[3]},equationRgb:p[0],equationAlpha:p[1],functionSourceRgb:f[0],functionSourceAlpha:f[1],functionDestinationRgb:f[2],functionDestinationAlpha:f[3]}})}}}function wt(e){var t={value:e,clone:function(e){return e},func:function(){return t.value}};return t}function Et(e){var i={value:t.fromArray(e),clone:t.clone,func:function(){return i.value}};return i}function bt(e){var t={value:i.fromArray(e),clone:i.clone,func:function(){return t.value}};return t}function St(e){var t={value:n.fromArray(e),clone:n.clone,func:function(){return t.value}};return t}function xt(e){var t={value:g.fromColumnMajorArray(e),clone:g.clone,func:function(){return t.value}};return t}function Tt(e){var t={value:_.fromColumnMajorArray(e),clone:_.clone,func:function(){return t.value}};return t}function Pt(e){var t={value:y.fromColumnMajorArray(e),clone:y.clone,func:function(){return t.value}};return t}function At(e,t){var i={value:t._rendererResources.textures[e],clone:function(e){return e},func:function(){return i.value}};return i}function Mt(e,t){var i=t._runtime.nodes[e];return function(){return i.computedMatrix}}function It(e,t){var i=e._loadResources;if(i.finishedTextureCreation()&&i.finishedProgramCreation()&&i.createUniformMaps){i.createUniformMaps=!1;var n=e.gltf,r=n.materials,o=n.techniques;n.programs;var a=e._uniformMaps;for(var l in r)if(r.hasOwnProperty(l)){var u,c=r[l],d=c.instanceTechnique,h=d.values,m=o[d.technique],p=m.parameters,f=m.passes[m.pass],v=f.instanceProgram,g=v.uniforms,_={},y={};for(var C in g)if(g.hasOwnProperty(C)){var w=g[C],E=p[w];if(s(h[w])){var b=si[E.type](h[w],e);_[C]=b.func,y[w]=b}else if(s(E.semantic))"JOINTMATRIX"!==E.semantic?_[C]=ai[E.semantic](t.uniformState):u=C;else if(s(E.source))_[C]=Mt(E.source,e);else if(s(E.value)){var S=si[E.type](E.value,e);_[C]=S.func,y[w]=S}}var x=a[l];x.uniformMap=_,x.values=y,x.jointMatrixUniformName=u}}}function Dt(e){return function(){return e}}function Ot(e){return function(){return e.computedJointMatrices}}function Rt(t,n,r,l){var u=t._nodeCommands,c=t._pickIds,d=t.allowPicking,m=t._runtime.meshesByName;t.debugShowBoundingVolume;for(var p=t._rendererResources,f=p.vertexArrays,v=p.programs,g=p.pickPrograms,_=p.renderStates,C=t._uniformMaps,w=t.gltf,E=w.accessors,b=w.meshes,S=w.techniques,T=w.materials,P=s(n.meshes)?n.meshes:n.instanceSkin.meshes,A=P.length,M=0;A>M;++M)for(var I=P[M],D=b[I],O=D.primitives,R=O.length,L=0;R>L;++L){var N,z=O[L],F=E[z.indices],V=T[z.material].instanceTechnique,k=S[V.technique],U=k.passes[k.pass],W=U.instanceProgram,G=z.attributes.POSITION;if(s(G)){var H=E[G];N=e.fromCornerPoints(i.fromArray(H.min),i.fromArray(H.max))}var q=f[I+".primitive."+L],j=F.count,Y=F.byteOffset/h.getSizeInBytes(F.componentType),X=C[z.material],Z=X.uniformMap;if(s(X.jointMatrixUniformName)){var J={};J[X.jointMatrixUniformName]=Ot(r),Z=o(Z,J)}var K,Q=_[V.technique],$=Q.blending.enabled,et={primitive:a(t.pickPrimitive,t),id:t.id,node:r.publicNode,mesh:m[D.name]},tt=new x({boundingVolume:new e,modelMatrix:new y,primitiveType:z.mode,vertexArray:q,count:j,offset:Y,shaderProgram:v[W.program],uniformMap:Z,renderState:Q,owner:et,pass:$?B.TRANSLUCENT:B.OPAQUE});if(d){var it=l.createPickId(et);c.push(it);var nt=o(Z,{czm_pickColor:Dt(it.color)});K=new x({boundingVolume:new e,modelMatrix:new y,primitiveType:z.mode,vertexArray:q,count:j,offset:Y,shaderProgram:g[W.program],uniformMap:nt,renderState:Q,owner:et,pass:$?B.TRANSLUCENT:B.OPAQUE})}var rt={show:!0,boundingSphere:N,command:tt,pickCommand:K};r.commands.push(rt),u.push(rt)}}function Lt(e,t){var n=e._loadResources;if(n.finishedPendingLoads()&&n.finishedResourceCreation()&&n.createRuntimeNodes){n.createRuntimeNodes=!1;for(var r=[],o=e._runtime.nodes,a=e.gltf,l=a.nodes,u=a.scenes[a.scene],c=u.nodes,d=c.length,h=[],m=new i,p=0;d>p;++p)for(h.push({parentRuntimeNode:void 0,gltfNode:l[c[p]],id:c[p]});h.length>0;){var f=h.pop(),v=f.parentRuntimeNode,g=f.gltfNode,_=o[f.id];0===_.parents.length&&(s(g.matrix)?_.matrix=y.fromColumnMajorArray(g.matrix):(m=i.fromArray(g.rotation,0,m),_.translation=i.fromArray(g.translation),_.rotation=w.fromAxisAngle(m,g.rotation[3]),_.scale=i.fromArray(g.scale))),s(v)?(v.children.push(_),_.parents.push(v)):r.push(_),(s(g.meshes)||s(g.instanceSkin))&&Rt(e,g,_,t);for(var C=g.children,E=C.length,b=0;E>b;++b)h.push({parentRuntimeNode:_,gltfNode:l[C[b]],id:C[b]})}e._runtime.rootNodes=r,e._runtime.nodes=o}}function Nt(e,t){if(e._loadRendererResourcesFromCache){var i=e._rendererResources,n=e._cachedRendererResources;i.buffers=n.buffers,i.vertexArrays=n.vertexArrays,i.programs=n.programs,i.pickPrograms=n.pickPrograms,i.textures=n.textures,i.samplers=n.samplers,i.renderStates=n.renderStates}else ot(e,t),lt(e,t),ut(e,t),dt(e,t);ft(e),gt(e),e._loadRendererResourcesFromCache||(_t(e,t),Ct(e,t)),It(e,t),Lt(e,t)}function zt(e,t){var i=e.publicNode,n=i.matrix;i.useMatrix&&s(n)?y.clone(n,t):s(e.matrix)?y.clone(e.matrix,t):(y.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t),i.setMatrix(t))}function Ft(t,i,n){for(var r=t._maxDirtyNumber,o=t.allowPicking,a=t._runtime.rootNodes,s=a.length,l=li,u=t._computedModelMatrix,c=0;s>c;++c){var d=a[c];for(zt(d,d.transformToRoot),l.push(d);l.length>0;){d=l.pop();var h=d.transformToRoot,m=d.commands;if(d.dirtyNumber===r||i||n){var p=m.length;if(p>0)for(var f=0;p>f;++f){var v=m[f],g=v.command;if(y.multiplyTransformation(u,h,g.modelMatrix),e.transform(v.boundingSphere,g.modelMatrix,g.boundingVolume),o){var _=v.pickCommand;y.clone(g.modelMatrix,_.modelMatrix),e.clone(g.boundingVolume,_.boundingVolume)}}else d.computedMatrix=y.multiplyTransformation(u,h,d.computedMatrix)}for(var C=d.children,w=C.length,E=0;w>E;++E){var b=C[E];b.dirtyNumber=Math.max(b.dirtyNumber,d.dirtyNumber),(b.dirtyNumber===r||n)&&(zt(b,b.transformToRoot),y.multiplyTransformation(h,b.transformToRoot,b.transformToRoot)),l.push(b)}}}++t._maxDirtyNumber}function Bt(e){for(var t=e._runtime.skinnedNodes,i=t.length,n=0;i>n;++n){var r=t[n];ui=y.inverseTransformation(r.transformToRoot,ui);for(var o=r.computedJointMatrices,a=r.joints,l=r.bindShapeMatrix,u=r.inverseBindMatrices,c=u.length,d=0;c>d;++d)s(o[d])||(o[d]=new y),o[d]=y.multiplyTransformation(ui,a[d].transformToRoot,o[d]),o[d]=y.multiplyTransformation(o[d],u[d],o[d]),s(l)&&(o[d]=y.multiplyTransformation(o[d],l,o[d]))}}function Vt(e){for(var t=e._runtime.rootNodes,i=t.length,n=li,r=0;i>r;++r){var o=t[r];for(o.computedShow=o.publicNode.show,n.push(o);n.length>0;){o=n.pop();for(var a=o.computedShow,s=o.commands,l=s.length,u=0;l>u;++u)s[u].show=a;for(var c=o.children,d=c.length,h=0;d>h;++h){var m=c[h];m.computedShow=a&&m.publicNode.show,n.push(m)}}}}function kt(e){var t=e.id;if(e._id!==t){e._id=t;for(var i=e._pickIds,n=i.length,r=0;n>r;++r)i[r].object.id=t}}function Ut(e){if(e._debugWireframe!==e.debugWireframe){e._debugWireframe=e.debugWireframe;for(var t=e.debugWireframe?C.LINES:C.TRIANGLES,i=e._nodeCommands,n=i.length,r=0;n>r;++r)i[r].command.primitiveType=t}}function Wt(e){if(e.debugShowBoundingVolume!==e._debugShowBoundingVolume){e._debugShowBoundingVolume=e.debugShowBoundingVolume;for(var t=e.debugShowBoundingVolume,i=e._nodeCommands,n=i.length,r=0;n>r;r++)i[r].command.debugShowBoundingVolume=t}}function Gt(e,t,n,r){var o=r.camera,a=o.frustum,s=i.subtract(o.positionWC,e,di),l=i.multiplyByScalar(o.directionWC,i.dot(s,o.directionWC),hi),u=Math.max(a.near,i.magnitude(l)-t);ci.x=n.drawingBufferWidth,ci.y=n.drawingBufferHeight;var c=a.getPixelSize(ci,u),d=Math.max(c.x,c.y);return d}function Ht(e,t,i){var n=e.scale;if(0!==e.minimumPixelSize){var r=Math.max(t.drawingBufferWidth,t.drawingBufferHeight),o=e.modelMatrix;mi.x=o[12],mi.y=o[13],mi.z=o[14];var a=e.boundingSphere.radius,s=Gt(mi,a,t,i),l=1/s,u=Math.min(l*2*a,r);u<e.minimumPixelSize&&(n=e.minimumPixelSize*s/(2*e._initialRadius))}return n}function qt(e){s(e._cacheKey)&&s(e._cachedGltf)&&0===--e._cachedGltf.count&&delete Qt[e._cacheKey],e._cachedGltf=void 0}function jt(e){for(var t in e)e.hasOwnProperty(t)&&e[t].destroy()}function Yt(e){jt(e.buffers),jt(e.vertexArrays),jt(e.programs),jt(e.pickPrograms),jt(e.textures)}var Xt=y.fromRotationTranslation(_.fromRotationX(v.PI_OVER_TWO)),Zt=new i,Jt={NEEDS_LOAD:0,LOADING:1,LOADED:2,FAILED:3};k.prototype.finishedPendingLoads=function(){return 0===this.pendingBufferLoads&&0===this.pendingShaderLoads&&0===this.pendingTextureLoads},k.prototype.finishedResourceCreation=function(){return 0===this.buffersToCreate.length&&0===this.programsToCreate.length&&0===this.texturesToCreate.length},k.prototype.finishedBuffersCreation=function(){return 0===this.pendingBufferLoads&&0===this.buffersToCreate.length},k.prototype.finishedProgramCreation=function(){return 0===this.pendingShaderLoads&&0===this.programsToCreate.length},k.prototype.finishedTextureCreation=function(){return 0===this.pendingTextureLoads&&0===this.texturesToCreate.length};var Kt=function(e){this._gltf=M(e.gltf),this.ready=e.ready,this.modelsToLoad=[],this.count=0};l(Kt.prototype,{gltf:{set:function(e){this._gltf=M(e)},get:function(){return this._gltf}}});var Qt={},$t=function(t){t=a(t,a.EMPTY_OBJECT);var i=t.cacheKey;this._cacheKey=i,this._cachedGltf=void 0,this._releaseGltfJson=a(t.releaseGltfJson,!1),this._animationIds=void 0;var n;s(i)&&s(Qt[i])&&Qt[i].ready?(n=Qt[i],++n.count):s(t.gltf)&&(n=new Kt({gltf:t.gltf,ready:!0}),n.count=1,s(i)&&(Qt[i]=n)),W(this,n),this._basePath=a(t.basePath,"");var r=new I(document.location.href),o=new I(this._basePath);this._baseUri=o.resolve(r),this.show=a(t.show,!0),this.modelMatrix=y.clone(a(t.modelMatrix,y.IDENTITY)),this._modelMatrix=y.clone(this.modelMatrix),this.scale=a(t.scale,1),this._scale=this.scale,this.minimumPixelSize=a(t.minimumPixelSize,0),this._minimumPixelSize=this.minimumPixelSize,this.id=t.id,this._id=t.id,this.pickPrimitive=t.pickPrimitive,this._allowPicking=a(t.allowPicking,!0),this._ready=!1,this._readyPromise=D.defer(),this.activeAnimations=new L(this),this._asynchronous=a(t.asynchronous,!0),this.debugShowBoundingVolume=a(t.debugShowBoundingVolume,!1),this._debugShowBoudingVolume=!1,this.debugWireframe=a(t.debugWireframe,!1),this._debugWireframe=!1,this._computedModelMatrix=new y,this._initialRadius=void 0,this._boundingSphere=void 0,this._scaledBoundingSphere=new e,this._state=Jt.NEEDS_LOAD,this._loadError=void 0,this._loadResources=void 0,this._perNodeShowDirty=!1,this._cesiumAnimationsDirty=!1,this._maxDirtyNumber=0,this._runtime={animations:void 0,rootNodes:void 0,nodes:void 0,nodesByName:void 0,skinnedNodes:void 0,meshesByName:void 0,materialsByName:void 0,materialsById:void 0},this._uniformMaps={},this._rendererResources={buffers:{},vertexArrays:{},programs:{},pickPrograms:{},textures:{},samplers:{},renderStates:{}},this._cachedRendererResources=void 0,this._loadRendererResourcesFromCache=!1,this._nodeCommands=[],this._pickIds=[]};l($t.prototype,{gltf:{get:function(){return s(this._cachedGltf)?this._cachedGltf.gltf:void 0}},releaseGltfJson:{get:function(){return this._releaseGltfJson}},cacheKey:{get:function(){return this._cacheKey}},basePath:{get:function(){return this._basePath}},boundingSphere:{get:function(){var e=y.getScale(this.modelMatrix,Zt);i.multiplyByScalar(e,this.scale,e);var t=this._scaledBoundingSphere;return t.center=i.multiplyComponents(this._boundingSphere.center,e,t.center),t.radius=i.maximumComponent(e)*this._initialRadius,t}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},asynchronous:{get:function(){return this._asynchronous}},allowPicking:{get:function(){return this._allowPicking}}}),$t.fromGltf=function(e){var t=e.url,i="",n=t.lastIndexOf("/");-1!==n&&(i=t.substring(0,n+1));var o=e.cacheKey;if(!s(o)){var a=new I(document.location.href),l=new I(t);o=l.resolve(a).toString()}e=r(e),e.basePath=i,e.cacheKey=o;var u=new $t(e),c=Qt[o];return s(c)?c.ready||(++c.count,c.modelsToLoad.push(u)):(c=new Kt({ready:!1}),c.count=1,c.modelsToLoad.push(u),W(u,c),Qt[o]=c,f(t,e.headers).then(function(e){c.gltf=JSON.parse(e);for(var t=c.modelsToLoad,i=t.length,n=0;i>n;++n){var r=t[n];r.isDestroyed()||W(r,c)}c.modelsToLoad=void 0,c.ready=!0}).otherwise(q(u,"gltf",t))),u},$t._gltfCache=Qt,$t.prototype.getNode=function(e){var t=G(this,"nodesByName",e);return s(t)?t.publicNode:void 0},$t.prototype.getMesh=function(e){return G(this,"meshesByName",e)},$t.prototype.getMaterial=function(e){return G(this,"materialsByName",e)};var ei=new i,ti=new i,ii=new i,ni=new i,ri=new w,oi=new i,ai={MODEL:function(e){return function(){return e.model}},VIEW:function(e){return function(){return e.view}},PROJECTION:function(e){return function(){return e.projection}},MODELVIEW:function(e){return function(){return e.modelView}},MODELVIEWPROJECTION:function(e){return function(){return e.modelViewProjection}},MODELINVERSE:function(e){return function(){return e.inverseModel}},VIEWINVERSE:function(e){return function(){return e.inverseView}},PROJECTIONINVERSE:function(e){return function(){return e.inverseProjection}},MODELVIEWINVERSE:function(e){return function(){return e.inverseModelView}},MODELVIEWPROJECTIONINVERSE:function(e){return function(){return e.inverseModelViewProjection}},MODELINVERSETRANSPOSE:function(e){return function(){return e.inverseTranposeModel}},MODELVIEWINVERSETRANSPOSE:function(e){return function(){return e.normal}},VIEWPORT:function(e){return function(){return e.viewportCartesian4}}},si={};"undefined"!=typeof WebGLRenderingContext&&(si[WebGLRenderingContext.FLOAT]=wt,si[WebGLRenderingContext.FLOAT_VEC2]=Et,si[WebGLRenderingContext.FLOAT_VEC3]=bt,si[WebGLRenderingContext.FLOAT_VEC4]=St,si[WebGLRenderingContext.INT]=wt,si[WebGLRenderingContext.INT_VEC2]=Et,si[WebGLRenderingContext.INT_VEC3]=bt,si[WebGLRenderingContext.INT_VEC4]=St,si[WebGLRenderingContext.BOOL]=wt,si[WebGLRenderingContext.BOOL_VEC2]=Et,si[WebGLRenderingContext.BOOL_VEC3]=bt,si[WebGLRenderingContext.BOOL_VEC4]=St,si[WebGLRenderingContext.FLOAT_MAT2]=xt,si[WebGLRenderingContext.FLOAT_MAT3]=Tt,si[WebGLRenderingContext.FLOAT_MAT4]=Pt,si[WebGLRenderingContext.SAMPLER_2D]=At);var li=[],ui=new y,ci=new t,di=new i,hi=new i,mi=new i,pi=function(e,t){this.buffers=void 0,this.vertexArrays=void 0,this.programs=void 0,this.pickPrograms=void 0,this.textures=void 0,this.samplers=void 0,this.renderStates=void 0,this.ready=!1,this.context=e,this.cacheKey=t,this.count=0};return pi.prototype.release=function(){return 0===--this.count?(s(this.cacheKey)&&delete this.context.cache.modelRendererResourceCache[this.cacheKey],Yt(this),u(this)):void 0},$t.prototype.update=function(e,t,i){if(t.mode===V.SCENE3D){if(this._state===Jt.NEEDS_LOAD&&s(this.gltf)){var n,r=this.cacheKey;if(s(r)){e.cache.modelRendererResourceCache=a(e.cache.modelRendererResourceCache,{});var o=e.cache.modelRendererResourceCache;if(n=o[this.cacheKey],s(n)){if(!n.ready)return;++n.count,this._loadRendererResourcesFromCache=!0}else n=new pi(e,r),n.count=1,o[this.cacheKey]=n;this._cachedRendererResources=n}else n=new pi(e),n.count=1,this._cachedRendererResources=n;this._state=Jt.LOADING,this._boundingSphere=H(this.gltf),this._initialRadius=this._boundingSphere.radius,this._loadResources=new k,rt(this)}var l=!1;if(this._state===Jt.FAILED)throw this._loadError;if(this._state===Jt.LOADING){Nt(this,e);var u=this._loadResources;if(u.finishedPendingLoads()&&u.finishedResourceCreation()){this._state=Jt.LOADED,this._loadResources=void 0;var c=this._rendererResources,d=this._cachedRendererResources;d.buffers=c.buffers,d.vertexArrays=c.vertexArrays,d.programs=c.programs,d.pickPrograms=c.pickPrograms,d.textures=c.textures,d.samplers=c.samplers,d.renderStates=c.renderStates,d.ready=!0,this.releaseGltfJson&&qt(this),l=!0}}var h=this.show&&0!==this.scale;if(h&&this._state===Jt.LOADED||l){var m=this.activeAnimations.update(t)||this._cesiumAnimationsDirty;this._cesiumAnimationsDirty=!1;var p=!y.equals(this._modelMatrix,this.modelMatrix)||this._scale!==this.scale||this._minimumPixelSize!==this.minimumPixelSize||0!==this.minimumPixelSize;if(p||l){y.clone(this.modelMatrix,this._modelMatrix),this._scale=this.scale,this._minimumPixelSize=this.minimumPixelSize;var f=Ht(this,e,t),v=this._computedModelMatrix;y.multiplyByUniformScale(this.modelMatrix,f,v),y.multiplyTransformation(v,Xt,v)}(m||p||l)&&(Ft(this,p,l),(m||l)&&Bt(this)),this._perNodeShowDirty&&(this._perNodeShowDirty=!1,Vt(this)),kt(this,e),Ut(this),Wt(this)}if(l){var g=this;return t.afterRender.push(function(){g._ready=!0,g.readyPromise.resolve(g)}),void 0}if(h){var _,C,w=t.passes,E=this._nodeCommands,b=E.length;if(w.render)for(_=0;b>_;++_)C=E[_],C.show&&i.push(C.command);if(w.pick)for(_=0;b>_;++_)C=E[_],C.show&&i.push(C.pickCommand)}}},$t.prototype.isDestroyed=function(){return!1},$t.prototype.destroy=function(){this._rendererResources=void 0,this._cachedRendererResources=this._cachedRendererResources&&this._cachedRendererResources.release();for(var e=this._pickIds,t=e.length,i=0;t>i;++i)e[i].destroy();return qt(this),u(this)},$t}),define("Cesium/DataSources/ModelVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/Cartesian3","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Scene/Model","../Scene/ModelAnimationLoop","./BoundingSphereState","./Property"],function(e,t,i,n,r,o,a,s,l,u,c){"use strict";function d(e,t,i,r){var o=i[t.id];n(o)&&(r.removeAndDestroy(o.modelPrimitive),delete i[t.id])}function h(e){e.activeAnimations.addAll({loop:l.REPEAT})}function m(e){console.error(e)}var p=1,f=0,v=function(t,i){i.collectionChanged.addEventListener(v.prototype._onCollectionChanged,this),this._scene=t,this._primitives=t.primitives,this._entityCollection=i,this._modelHash={},this._entitiesToVisualize=new e,this._modelMatrixScratch=new a,this._onCollectionChanged(i,i.values,[],[])};return v.prototype.update=function(e){this._scene.context;var t=this._entitiesToVisualize.values,i=this._modelHash,r=this._primitives;this._scene;for(var o=0,l=t.length;l>o;o++){var u,d,v=t[o],g=v._model,_=i[v.id],y=v.isShowing&&v.isAvailable(e)&&c.getValueOrDefault(g._show,e,!0);if(y&&(d=v._getModelMatrix(e,this._modelMatrixScratch),u=c.getValueOrUndefined(g._uri,e),y=n(d)&&n(u)),y){var C=n(_)?_.modelPrimitive:void 0;n(C)&&u===_.uri||(n(C)&&(r.removeAndDestroy(C),delete i[v.id]),C=s.fromGltf({url:u}),C.readyPromise.then(h).otherwise(m),C.id=v,r.add(C),_={modelPrimitive:C,uri:u},i[v.id]=_),C.show=!0,C.scale=c.getValueOrDefault(g._scale,e,p),C.minimumPixelSize=c.getValueOrDefault(g._minimumPixelSize,e,f),C.modelMatrix=a.clone(d,C.modelMatrix)}else n(_)&&(_.modelPrimitive.show=!1)}return!0},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(v.prototype._onCollectionChanged,this);for(var e=this._entitiesToVisualize.values,t=this._modelHash,i=this._primitives,n=e.length-1;n>-1;n--)d(this,e[n],t,i);return r(this)},v.prototype.getBoundingSphere=function(e,i){var r=this._modelHash[e.id];if(!n(r))return u.FAILED;var o=r.modelPrimitive;return n(o)&&o.show?o.ready?(t.transform(o.boundingSphere,o.modelMatrix,i),u.DONE):u.PENDING:u.FAILED},v.prototype._onCollectionChanged=function(e,t,i,r){var o,a,s=this._entitiesToVisualize,l=this._modelHash,u=this._primitives;for(o=t.length-1;o>-1;o--)a=t[o],n(a._model)&&n(a._position)&&s.set(a.id,a);for(o=r.length-1;o>-1;o--)a=r[o],n(a._model)&&n(a._position)?s.set(a.id,a):(d(this,a,l,u),s.remove(a.id));for(o=i.length-1;o>-1;o--)a=i[o],d(this,a,l,u),s.remove(a.id)},v}),define("Cesium/Shaders/PolylineCommon",[],function(){"use strict";return"void clipLineSegmentToNearPlane(\n    vec3 p0,\n    vec3 p1,\n    out vec4 positionWC,\n    out bool clipped,\n    out bool culledByNearPlane)\n{\n    culledByNearPlane = false;\n    clipped = false;\n    \n    vec3 p1ToP0 = p1 - p0;\n    float magnitude = length(p1ToP0);\n    vec3 direction = normalize(p1ToP0);\n    float endPoint0Distance =  -(czm_currentFrustum.x + p0.z);\n    float denominator = -direction.z;\n    \n    if (endPoint0Distance < 0.0 && abs(denominator) < czm_epsilon7)\n    {\n        culledByNearPlane = true;\n    }\n    else if (endPoint0Distance < 0.0 && abs(denominator) > czm_epsilon7)\n    {\n        // t = (-plane distance - dot(plane normal, ray origin)) / dot(plane normal, ray direction)\n        float t = (czm_currentFrustum.x + p0.z) / denominator;\n        if (t < 0.0 || t > magnitude)\n        {\n            culledByNearPlane = true;\n        }\n        else\n        {\n            p0 = p0 + t * direction;\n            clipped = true;\n        }\n    }\n    \n    positionWC = czm_eyeToWindowCoordinates(vec4(p0, 1.0));\n}\n\nvec4 getPolylineWindowCoordinates(vec4 position, vec4 previous, vec4 next, float expandDirection, float width, bool usePrevious) {\n    vec4 endPointWC, p0, p1;\n    bool culledByNearPlane, clipped;\n    \n    vec4 positionEC = czm_modelViewRelativeToEye * position;\n    vec4 prevEC = czm_modelViewRelativeToEye * previous;\n    vec4 nextEC = czm_modelViewRelativeToEye * next;\n    \n    clipLineSegmentToNearPlane(prevEC.xyz, positionEC.xyz, p0, clipped, culledByNearPlane);\n    clipLineSegmentToNearPlane(nextEC.xyz, positionEC.xyz, p1, clipped, culledByNearPlane);\n    clipLineSegmentToNearPlane(positionEC.xyz, usePrevious ? prevEC.xyz : nextEC.xyz, endPointWC, clipped, culledByNearPlane);\n    \n    if (culledByNearPlane)\n    {\n        return vec4(0.0, 0.0, 0.0, 1.0);\n    }\n    \n    vec2 prevWC = normalize(p0.xy - endPointWC.xy);\n    vec2 nextWC = normalize(p1.xy - endPointWC.xy);\n    \n    float expandWidth = width * 0.5;\n    vec2 direction;\n\n    if (czm_equalsEpsilon(normalize(previous.xyz - position.xyz), vec3(0.0), czm_epsilon1) || czm_equalsEpsilon(prevWC, -nextWC, czm_epsilon1))\n    {\n        direction = vec2(-nextWC.y, nextWC.x);\n    }\n    else if (czm_equalsEpsilon(normalize(next.xyz - position.xyz), vec3(0.0), czm_epsilon1) || clipped)\n    {\n        direction = vec2(prevWC.y, -prevWC.x);\n    }\n    else\n    {\n        vec2 normal = vec2(-nextWC.y, nextWC.x);\n        direction = normalize((nextWC + prevWC) * 0.5);\n        if (dot(direction, normal) < 0.0)\n        {\n            direction = -direction;\n        }\n\n        // The sine of the angle between the two vectors is given by the formula\n        //         |a x b| = |a||b|sin(theta)\n        // which is\n        //     float sinAngle = length(cross(vec3(direction, 0.0), vec3(nextWC, 0.0)));\n        // Because the z components of both vectors are zero, the x and y coordinate will be zero.\n        // Therefore, the sine of the angle is just the z component of the cross product.\n        float sinAngle = abs(direction.x * nextWC.y - direction.y * nextWC.x);\n        expandWidth = clamp(expandWidth / sinAngle, 0.0, width * 2.0);\n    }\n\n    vec2 offset = direction * expandDirection * expandWidth * czm_resolutionScale;\n    return vec4(endPointWC.xy + offset, -endPointWC.z, 1.0);\n}\n"}),define("Cesium/Shaders/PolylineFS",[],function(){"use strict";return"varying vec2 v_st;\n\nvoid main()\n{\n    czm_materialInput materialInput;\n    \n    materialInput.s = v_st.s;\n    materialInput.st = v_st;\n    materialInput.str = vec3(v_st, 0.0);\n    \n    czm_material material = czm_getMaterial(materialInput);\n    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n}"}),define("Cesium/Shaders/PolylineVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 position2DHigh;\nattribute vec3 position2DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 prevPosition2DHigh;\nattribute vec3 prevPosition2DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec3 nextPosition2DHigh;\nattribute vec3 nextPosition2DLow;\nattribute vec4 texCoordExpandWidthAndShow;\nattribute vec4 pickColor;\n\nvarying vec2  v_st;\nvarying float v_width;\nvarying vec4  czm_pickColor;\n\nvoid main() \n{\n    float texCoord = texCoordExpandWidthAndShow.x;\n    float expandDir = texCoordExpandWidthAndShow.y;\n    float width = abs(texCoordExpandWidthAndShow.z) + 0.5;\n    bool usePrev = texCoordExpandWidthAndShow.z < 0.0;\n    float show = texCoordExpandWidthAndShow.w;\n    \n    vec4 p, prev, next;\n    if (czm_morphTime == 1.0)\n    {\n        p = czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz);\n        prev = czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz);\n        next = czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz);\n    }\n    else if (czm_morphTime == 0.0)\n    {\n        p = czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy);\n        prev = czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy);\n        next = czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy);\n    }\n    else\n    {\n        p = czm_columbusViewMorph(\n                czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy),\n                czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz),\n                czm_morphTime);\n        prev = czm_columbusViewMorph(\n                czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy),\n                czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz),\n                czm_morphTime);\n        next = czm_columbusViewMorph(\n                czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy),\n                czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz),\n                czm_morphTime);\n    }\n    \n    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\n    gl_Position = czm_viewportOrthographic * positionWC * show;\n    \n    v_st = vec2(texCoord, clamp(expandDir, 0.0, 1.0));\n    v_width = width;\n    czm_pickColor = pickColor;\n}\n"}),define("Cesium/Scene/Polyline",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/PolylinePipeline","./Material"],function(e,t,i,n,r,o,a,s,l,u){"use strict";
function c(e,t){++e._propertiesChanged[t];var i=e._polylineCollection;r(i)&&(i._updatePolyline(e,t),e._dirty=!0)}var d=function(o,a){o=n(o,n.EMPTY_OBJECT),this._show=n(o.show,!0),this._width=n(o.width,1),this._loop=n(o.loop,!1),this._material=o.material,r(this._material)||(this._material=u.fromType(u.ColorType,{color:new i(1,1,1,1)}));var c=o.positions;r(c)||(c=[]),this._positions=c,this._actualPositions=l.removeDuplicates(c),r(this._actualPositions)||(this._actualPositions=c),this._loop&&this._actualPositions.length>2&&(this._actualPositions===this._positions&&(this._actualPositions=c.slice()),this._actualPositions.push(t.clone(this._actualPositions[0]))),this._length=this._actualPositions.length,this._id=o.id;var d;r(a)&&(d=s.clone(a.modelMatrix)),this._modelMatrix=d,this._segments=l.wrapLongitude(this._actualPositions,d),this._actualLength=void 0,this._propertiesChanged=new Uint32Array(g),this._polylineCollection=a,this._dirty=!1,this._pickId=void 0,this._boundingVolume=e.fromPoints(this._actualPositions),this._boundingVolumeWC=e.transform(this._boundingVolume,this._modelMatrix),this._boundingVolume2D=new e},h=d.SHOW_INDEX=0,m=d.WIDTH_INDEX=1,p=d.POSITION_INDEX=2,f=d.MATERIAL_INDEX=3,v=d.POSITION_SIZE_INDEX=4,g=d.NUMBER_OF_PROPERTIES=5;return o(d.prototype,{show:{get:function(){return this._show},set:function(e){e!==this._show&&(this._show=e,c(this,h))}},positions:{get:function(){return this._positions},set:function(i){var n=l.removeDuplicates(i);r(n)||(n=i),this._loop&&n.length>2&&(n===i&&(n=i.slice()),n.push(t.clone(n[0]))),(this._actualPositions.length!==n.length||this._actualPositions.length!==this._length)&&c(this,v),this._positions=i,this._actualPositions=n,this._length=n.length,this._boundingVolume=e.fromPoints(this._actualPositions,this._boundingVolume),this._boundingVolumeWC=e.transform(this._boundingVolume,this._modelMatrix,this._boundingVolumeWC),c(this,p),this.update()}},material:{get:function(){return this._material},set:function(e){this._material!==e&&(this._material=e,c(this,f))}},width:{get:function(){return this._width},set:function(e){var t=this._width;e!==t&&(this._width=e,c(this,m))}},loop:{get:function(){return this._loop},set:function(e){if(e!==this._loop){var i=this._actualPositions;e?i.length>2&&!t.equals(i[0],i[i.length-1])&&(i.length===this._positions.length&&(this._actualPositions=i=this._positions.slice()),i.push(t.clone(i[0]))):i.length>2&&t.equals(i[0],i[i.length-1])&&(i.length-1===this._positions.length?this._actualPositions=this._positions:i.pop()),this._loop=e,c(this,v)}}},id:{get:function(){return this._id},set:function(e){this._id=e,r(this._pickId)&&(this._pickId.object.id=e)}}}),d.prototype.update=function(){var t=s.IDENTITY;r(this._polylineCollection)&&(t=this._polylineCollection.modelMatrix);var i=this._segments.positions.length,n=this._segments.lengths,o=this._propertiesChanged[p]>0||this._propertiesChanged[v]>0;if((!s.equals(t,this._modelMatrix)||o)&&(this._segments=l.wrapLongitude(this._actualPositions,t),this._boundingVolumeWC=e.transform(this._boundingVolume,t,this._boundingVolumeWC)),this._modelMatrix=t,this._segments.positions.length!==i)c(this,v);else for(var a=n.length,u=0;a>u;++u)if(n[u]!==this._segments.lengths[u]){c(this,v);break}},d.prototype.getPickId=function(e){return r(this._pickId)||(this._pickId=e.createPickId({primitive:this,collection:this._polylineCollection,id:this._id})),this._pickId},d.prototype._clean=function(){this._dirty=!1;for(var e=this._propertiesChanged,t=0;g-1>t;++t)e[t]=0},d.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._material=this._material&&this._material.destroy(),this._polylineCollection=void 0},d}),define("Cesium/Scene/PolylineCollection",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/IndexDatatype","../Core/Intersect","../Core/Math","../Core/Matrix4","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/ShaderSource","../Shaders/PolylineCommon","../Shaders/PolylineFS","../Shaders/PolylineVS","./BlendingState","./Material","./Pass","./Polyline","./SceneMode"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S,x,T){"use strict";function P(t,i,n,r,o,a,l){for(var u=r.length,c=0,d=!0,h=t._vertexArrays,m=t.debugShowBoundingVolume,p=h.length,f=0;p>f;++f)for(var v=h[f],_=v.buckets,y=_.length,C=0;y>C;++C){for(var w,E,b,x=_[C],P=x.offset,A=l?x.bucket.shaderProgram:x.bucket.pickShaderProgram,M=x.bucket.polylines,D=M.length,O=0,R=0;D>R;++R){var L=M[R],N=I(L._material);if(N!==w){if(s(w)&&O>0){var z=E.isTranslucent();c>=u?(b=new g({owner:t}),r.push(b)):b=r[c],++c,b.boundingVolume=e.clone(Y,b.boundingVolume),b.modelMatrix=a,b.shaderProgram=A,b.vertexArray=v.va,b.renderState=z?t._translucentRS:t._opaqueRS,b.pass=z?S.TRANSLUCENT:S.OPAQUE,b.debugShowBoundingVolume=l?m:!1,b.uniformMap=E._uniforms,b.count=O,b.offset=P,P+=O,O=0,d=!0,o.push(b)}E=L._material,E.update(i),w=N}for(var F=L._locatorBuckets,B=F.length,V=0;B>V;++V){var k=F[V];k.locator===x&&(O+=k.count)}var U;n.mode===T.SCENE3D?U=L._boundingVolumeWC:n.mode===T.COLUMBUS_VIEW?U=L._boundingVolume2D:n.mode===T.SCENE2D?s(L._boundingVolume2D)&&(U=e.clone(L._boundingVolume2D,X),U.center.x=0):s(L._boundingVolumeWC)&&s(L._boundingVolume2D)&&(U=e.union(L._boundingVolumeWC,L._boundingVolume2D,X)),d?(d=!1,e.clone(U,Y)):e.union(U,Y,Y)}s(w)&&O>0&&(c>=u?(b=new g({owner:t}),r.push(b)):b=r[c],++c,b.boundingVolume=e.clone(Y,b.boundingVolume),b.modelMatrix=a,b.shaderProgram=A,b.vertexArray=v.va,b.renderState=E.isTranslucent()?t._translucentRS:t._opaqueRS,b.pass=E.isTranslucent()?S.TRANSLUCENT:S.OPAQUE,b.debugShowBoundingVolume=l?m:!1,b.uniformMap=E._uniforms,b.count=O,b.offset=P,d=!0,o.push(b)),w=void 0}r.length=c}function A(e){for(var t=e._buffersUsage,i=!1,n=e._propertiesChanged,r=0;H-2>r;++r){var o=t[r];n[r]?o.bufferUsage!==v.STREAM_DRAW?(i=!0,o.bufferUsage=v.STREAM_DRAW,o.frameCount=100):o.frameCount=100:o.bufferUsage!==v.STATIC_DRAW&&(0===o.frameCount?(i=!0,o.bufferUsage=v.STATIC_DRAW):o.frameCount--)}return i}function M(e,t,i){e._createVertexArray=!1,L(e),N(e),D(e);var n,r,a=[[]],l=a[0],u=[0],c=0,d=[[]],m=0,f=e._polylineBuckets;for(n in f)f.hasOwnProperty(n)&&(r=f[n],r.updateShader(t),m+=r.lengthOfPositions);if(m>0){var g,_=e._mode,y=new Float32Array(3*6*m),C=new Uint8Array(4*m),w=new Float32Array(4*m),E=0,b=0,S=0;for(n in f)if(f.hasOwnProperty(n)){r=f[n],r.write(y,C,w,E,b,S,t,i),_===T.MORPHING&&(s(g)||(g=new Float32Array(3*6*m)),r.writeForMorph(g,E));var x=r.lengthOfPositions;E+=3*6*x,b+=4*x,S+=4*x,c=r.updateIndices(a,u,d,c)}var P=e._buffersUsage[U].bufferUsage,A=e._buffersUsage[V].bufferUsage,M=e._buffersUsage[k].bufferUsage,I=A===v.STREAM_DRAW||M===v.STREAM_DRAW?v.STREAM_DRAW:v.STATIC_DRAW;e._positionBuffer=t.createVertexBuffer(y,P);var O;s(g)&&(O=t.createVertexBuffer(g,P)),e._pickColorBuffer=t.createVertexBuffer(C,v.STATIC_DRAW),e._texCoordExpandWidthAndShowBuffer=t.createVertexBuffer(w,I);for(var R=4*Uint8Array.BYTES_PER_ELEMENT,z=3*Float32Array.BYTES_PER_ELEMENT,F=4*Float32Array.BYTES_PER_ELEMENT,B=0,W=a.length,G=0;W>G;++G)if(l=a[G],l.length>0){var H=new Uint16Array(l),j=t.createIndexBuffer(H,v.STATIC_DRAW,h.UNSIGNED_SHORT);B+=u[G];var Y,X,J,K,Q=6*(G*z*p.SIXTY_FOUR_KILOBYTES-B*z),$=z+Q,et=z+$,tt=z+et,it=z+tt,nt=z+it,rt=G*R*p.SIXTY_FOUR_KILOBYTES-B*R,ot=G*F*p.SIXTY_FOUR_KILOBYTES-B*F,at=[{index:q.position3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:Q,strideInBytes:6*z},{index:q.position3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:$,strideInBytes:6*z},{index:q.position2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:Q,strideInBytes:6*z},{index:q.position2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:$,strideInBytes:6*z},{index:q.prevPosition3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:et,strideInBytes:6*z},{index:q.prevPosition3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:tt,strideInBytes:6*z},{index:q.prevPosition2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:et,strideInBytes:6*z},{index:q.prevPosition2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:tt,strideInBytes:6*z},{index:q.nextPosition3DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:it,strideInBytes:6*z},{index:q.nextPosition3DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:nt,strideInBytes:6*z},{index:q.nextPosition2DHigh,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:it,strideInBytes:6*z},{index:q.nextPosition2DLow,componentsPerAttribute:3,componentDatatype:o.FLOAT,offsetInBytes:nt,strideInBytes:6*z},{index:q.texCoordExpandWidthAndShow,componentsPerAttribute:4,componentDatatype:o.FLOAT,vertexBuffer:e._texCoordExpandWidthAndShowBuffer,offsetInBytes:ot},{index:q.pickColor,componentsPerAttribute:4,componentDatatype:o.UNSIGNED_BYTE,vertexBuffer:e._pickColorBuffer,offsetInBytes:rt,normalize:!0}];_===T.SCENE3D?(Y=e._positionBuffer,X="vertexBuffer",J=Z,K="value"):_===T.SCENE2D||_===T.COLUMBUS_VIEW?(Y=Z,X="value",J=e._positionBuffer,K="vertexBuffer"):(Y=O,X="vertexBuffer",J=e._positionBuffer,K="vertexBuffer"),at[0][X]=Y,at[1][X]=Y,at[2][K]=J,at[3][K]=J,at[4][X]=Y,at[5][X]=Y,at[6][K]=J,at[7][K]=J,at[8][X]=Y,at[9][X]=Y,at[10][K]=J,at[11][K]=J;var st=t.createVertexArray(at,j);e._vertexArrays.push({va:st,buckets:d[G]})}}}function I(e){var t=b._uniformList[e.type],i=t.length;J.length=2*i;for(var n=0,r=0;i>r;++r){var o=t[r];J[n]=o,J[n+1]=e._uniforms[o](),n+=2}return e.type+":"+JSON.stringify(J)}function D(e){for(var t=e._mode,i=e._modelMatrix,n=e._polylineBuckets={},r=e._polylines,o=r.length,a=0;o>a;++a){var l=r[a];if(l._actualPositions.length>1){l.update();var u=l.material,c=n[u.type];s(c)||(c=n[u.type]=new K(u,t,i)),c.addPolyline(l)}}}function O(e,t){var i=t.mode;e._mode===i&&f.equals(e._modelMatrix,e.modelMatrix)||(e._mode=i,e._modelMatrix=f.clone(e.modelMatrix),e._createVertexArray=!0)}function R(e){if(e._polylinesRemoved){e._polylinesRemoved=!1;for(var t=[],i=e._polylines.length,n=0,r=0;i>n;++n){var o=e._polylines[n];s(o)&&(o._index=r++,t.push(o))}e._polylines=t}}function L(e){for(var t=e._polylines,i=t.length,n=0;i>n;++n)if(s(t[n])){var r=t[n]._bucket;s(r)&&(r.shaderProgram=r.shaderProgram&&r.shaderProgram.destroy())}}function N(e){for(var t=e._vertexArrays.length,i=0;t>i;++i)e._vertexArrays[i].va.destroy();e._vertexArrays.length=0}function z(e){for(var t=e._polylines,i=t.length,n=0;i>n;++n)s(t[n])&&t[n]._destroy()}function F(e,t,i){this.count=e,this.offset=t,this.bucket=i}function B(e){return t.dot(t.UNIT_X,e._boundingVolume.center)<0||e._boundingVolume.intersect(i.UNIT_Y)===m.INTERSECTING}var V=x.SHOW_INDEX,k=x.WIDTH_INDEX,U=x.POSITION_INDEX,W=x.MATERIAL_INDEX,G=x.POSITION_SIZE_INDEX,H=x.NUMBER_OF_PROPERTIES,q={texCoordExpandWidthAndShow:0,position3DHigh:1,position3DLow:2,position2DHigh:3,position2DLow:4,prevPosition3DHigh:5,prevPosition3DLow:6,prevPosition2DHigh:7,prevPosition2DLow:8,nextPosition3DHigh:9,nextPosition3DLow:10,nextPosition2DHigh:11,nextPosition2DLow:12,pickColor:13},j=function(e){e=a(e,a.EMPTY_OBJECT),this.modelMatrix=f.clone(a(e.modelMatrix,f.IDENTITY)),this._modelMatrix=f.clone(f.IDENTITY),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this._opaqueRS=void 0,this._translucentRS=void 0,this._colorCommands=[],this._pickCommands=[],this._polylinesUpdated=!1,this._polylinesRemoved=!1,this._createVertexArray=!1,this._propertiesChanged=new Uint32Array(H),this._polylines=[],this._polylineBuckets={},this._buffersUsage=[{bufferUsage:v.STATIC_DRAW,frameCount:0},{bufferUsage:v.STATIC_DRAW,frameCount:0},{bufferUsage:v.STATIC_DRAW,frameCount:0}],this._mode=void 0,this._polylinesToUpdate=[],this._vertexArrays=[],this._positionBuffer=void 0,this._pickColorBuffer=void 0,this._texCoordExpandWidthAndShowBuffer=void 0};l(j.prototype,{length:{get:function(){return R(this),this._polylines.length}}}),j.prototype.add=function(e){var t=new x(e,this);return t._index=this._polylines.length,this._polylines.push(t),this._createVertexArray=!0,t},j.prototype.remove=function(e){if(this.contains(e)){if(this._polylines[e._index]=void 0,this._polylinesRemoved=!0,this._createVertexArray=!0,s(e._bucket)){var t=e._bucket;t.shaderProgram=t.shaderProgram&&t.shaderProgram.destroy(),t.pickShaderProgram=t.pickShaderProgram&&t.pickShaderProgram.destroy()}return e._destroy(),!0}return!1},j.prototype.removeAll=function(){L(this),z(this),this._polylineBuckets={},this._polylinesRemoved=!1,this._polylines.length=0,this._polylinesToUpdate.length=0,this._createVertexArray=!0},j.prototype.contains=function(e){return s(e)&&e._polylineCollection===this},j.prototype.get=function(e){return R(this),this._polylines[e]},j.prototype.update=function(e,t,i){if(R(this),0!==this._polylines.length){O(this,t);var n,r=t.mapProjection,o=this._propertiesChanged;if(this._createVertexArray||A(this))M(this,e,r);else if(this._polylinesUpdated){var a=this._polylinesToUpdate;if(this._mode!==T.SCENE3D)for(var l=a.length,u=0;l>u;++u)n=a[u],n.update();if(o[G]||o[W])M(this,e,r);else for(var c=a.length,d=this._polylineBuckets,h=0;c>h;++h){n=a[h],o=n._propertiesChanged;var m=n._bucket,p=0;for(var v in d)if(d.hasOwnProperty(v)){if(d[v]===m){(o[U]||o[V]||o[k])&&m.writeUpdate(p,n,this._positionBuffer,this._texCoordExpandWidthAndShowBuffer,r);break}p+=d[v].lengthOfPositions}n._clean()}a.length=0,this._polylinesUpdated=!1}o=this._propertiesChanged;for(var g=0;H>g;++g)o[g]=0;var _=f.IDENTITY;t.mode===T.SCENE3D&&(_=this.modelMatrix);var y=t.passes,C=0!==t.morphTime;if(s(this._opaqueRS)&&this._opaqueRS.depthTest.enabled===C||(this._opaqueRS=e.createRenderState({depthMask:C,depthTest:{enabled:C}})),s(this._translucentRS)&&this._translucentRS.depthTest.enabled===C||(this._translucentRS=e.createRenderState({blending:E.ALPHA_BLEND,depthMask:!C,depthTest:{enabled:C}})),y.render){var w=this._colorCommands;P(this,e,t,w,i,_,!0)}if(y.pick){var b=this._pickCommands;P(this,e,t,b,i,_,!1)}}};var Y=new e,X=new e;j.prototype.isDestroyed=function(){return!1},j.prototype.destroy=function(){return N(this),L(this),z(this),u(this)};var Z=[0,0,0],J=[];j.prototype._updatePolyline=function(e,t){this._polylinesUpdated=!0,this._polylinesToUpdate.push(e),++this._propertiesChanged[t]};var K=function(e,t,i){this.polylines=[],this.lengthOfPositions=0,this.material=e,this.shaderProgram=void 0,this.pickShaderProgram=void 0,this.mode=t,this.modelMatrix=i};K.prototype.addPolyline=function(e){var t=this.polylines;t.push(e),e._actualLength=this.getPolylinePositionsLength(e),this.lengthOfPositions+=e._actualLength,e._bucket=this},K.prototype.updateShader=function(e){if(!s(this.shaderProgram)){var t=new _({sources:[y,w]}),i=new _({sources:[this.material.shaderSource,C]}),n=new _({sources:i.sources,pickColorQualifier:"varying"});this.shaderProgram=e.createShaderProgram(t,i,q),this.pickShaderProgram=e.createShaderProgram(t,n,q)}},K.prototype.getPolylinePositionsLength=function(e){var t;if(this.mode===T.SCENE3D||!B(e))return t=e._actualPositions.length,4*t-4;var i=0,n=e._segments.lengths;t=n.length;for(var r=0;t>r;++r)i+=4*n[r]-4;return i};var Q=new t,$=new t,et=new t,tt=new t;K.prototype.write=function(e,i,n,o,a,s,l,u){for(var c=this.mode,h=this.polylines,m=h.length,p=0;m>p;++p)for(var f,v=h[p],g=v.width,_=v.show&&g>0,y=this.getSegments(v,u),C=y.positions,w=y.lengths,E=C.length,b=v.getPickId(l).color,S=0,x=0,P=0;E>P;++P){0===P?v._loop?f=C[E-2]:(f=tt,t.subtract(C[0],C[1],f),t.add(C[0],f,f)):f=C[P-1],$.x=f.x,$.y=f.y,$.z=c!==T.SCENE2D?f.z:0,f=C[P],Q.x=f.x,Q.y=f.y,Q.z=c!==T.SCENE2D?f.z:0,P===E-1?v._loop?f=C[1]:(f=tt,t.subtract(C[E-1],C[E-2],f),t.add(C[E-1],f,f)):f=C[P+1],et.x=f.x,et.y=f.y,et.z=c!==T.SCENE2D?f.z:0;var A=w[S];P===x+A&&(x+=A,++S);for(var M=0===P-x,I=P===x+w[S]-1,D=M?2:0,O=I?2:4,R=D;O>R;++R){d.writeElements(Q,e,o),d.writeElements($,e,o+6),d.writeElements(et,e,o+12),i[a]=r.floatToByte(b.red),i[a+1]=r.floatToByte(b.green),i[a+2]=r.floatToByte(b.blue),i[a+3]=r.floatToByte(b.alpha);var L=0>R-2?-1:1;n[s]=P/(E-1),n[s+1]=2*(R%2)-1,n[s+2]=L*g,n[s+3]=_,o+=18,a+=4,s+=4}}};var it=new t,nt=new t,rt=new t,ot=new t;K.prototype.writeForMorph=function(e,i){for(var n=this.modelMatrix,r=this.polylines,o=r.length,a=0;o>a;++a)for(var s=r[a],l=s._segments.positions,u=s._segments.lengths,c=l.length,h=0,m=0,p=0;c>p;++p){var v;0===p?s._loop?v=l[c-2]:(v=ot,t.subtract(l[0],l[1],v),t.add(l[0],v,v)):v=l[p-1],v=f.multiplyByPoint(n,v,nt);var g,_=f.multiplyByPoint(n,l[p],it);p===c-1?s._loop?g=l[1]:(g=ot,t.subtract(l[c-1],l[c-2],g),t.add(l[c-1],g,g)):g=l[p+1],g=f.multiplyByPoint(n,g,rt);var y=u[h];p===m+y&&(m+=y,++h);for(var C=0===p-m,w=p===m+u[h]-1,E=C?2:0,b=w?2:4,S=E;b>S;++S)d.writeElements(_,e,i),d.writeElements(v,e,i+6),d.writeElements(g,e,i+12),i+=18}};var at=new Array(1);K.prototype.updateIndices=function(e,t,i,n){var r=i.length-1,o=new F(0,n,this);i[r].push(o);var a=0,s=e[e.length-1],l=0;s.length>0&&(l=s[s.length-1]+1);for(var u=this.polylines,c=u.length,d=0;c>d;++d){var h=u[d];h._locatorBuckets=[];var m;if(this.mode===T.SCENE3D){m=at;var f=h._actualPositions.length;if(!(f>0))continue;m[0]=f}else m=h._segments.lengths;var v=m.length;if(v>0){for(var g=0,_=0;v>_;++_)for(var y=m[_]-1,C=0;y>C;++C)l+4>=p.SIXTY_FOUR_KILOBYTES-1&&(h._locatorBuckets.push({locator:o,count:g}),g=0,t.push(4),s=[],e.push(s),l=0,o.count=a,a=0,n=0,o=new F(0,0,this),i[++r]=[o]),s.push(l,l+2,l+1),s.push(l+1,l+2,l+3),g+=6,a+=6,n+=6,l+=4;h._locatorBuckets.push({locator:o,count:g}),l+4>=p.SIXTY_FOUR_KILOBYTES-1&&(t.push(0),s=[],e.push(s),l=0,o.count=a,n=0,a=0,o=new F(0,0,this),i[++r]=[o])}h._clean()}return o.count=a,n},K.prototype.getPolylineStartIndex=function(e){for(var t=this.polylines,i=0,n=t.length,r=0;n>r;++r){var o=t[r];if(o===e)break;i+=o._actualLength}return i};var st={positions:void 0,lengths:void 0},lt=new Array(1),ut=new t,ct=new n;K.prototype.getSegments=function(i,n){var r=i._actualPositions;if(this.mode===T.SCENE3D)return lt[0]=r.length,st.positions=r,st.lengths=lt,st;B(i)&&(r=i._segments.positions);for(var o,a=n.ellipsoid,s=[],l=this.modelMatrix,u=r.length,c=ut,d=0;u>d;++d)o=r[d],c=f.multiplyByPoint(l,o,c),s.push(n.project(a.cartesianToCartographic(c,ct)));if(s.length>0){i._boundingVolume2D=e.fromPoints(s,i._boundingVolume2D);var h=i._boundingVolume2D.center;i._boundingVolume2D.center=new t(h.z,h.x,h.y)}return st.positions=s,st.lengths=i._segments.lengths,st};var dt,ht;return K.prototype.writeUpdate=function(e,i,n,r,o){var a=this.mode,l=i._actualLength;if(l){e+=this.getPolylineStartIndex(i);var u=dt,c=ht,h=3*6*l;!s(u)||u.length<h?(u=dt=new Float32Array(h),c=ht=new Float32Array(4*l)):u.length>h&&(u=new Float32Array(u.buffer,0,h),c=new Float32Array(c.buffer,0,4*l));var m,p=0,f=0,v=this.getSegments(i,o),g=v.positions,_=v.lengths,y=0,C=0,w=i.width,E=i.show&&w>0;l=g.length;for(var b=0;l>b;++b){0===b?i._loop?m=g[l-2]:(m=tt,t.subtract(g[0],g[1],m),t.add(g[0],m,m)):m=g[b-1],$.x=m.x,$.y=m.y,$.z=a!==T.SCENE2D?m.z:0,m=g[b],Q.x=m.x,Q.y=m.y,Q.z=a!==T.SCENE2D?m.z:0,b===l-1?i._loop?m=g[1]:(m=tt,t.subtract(g[l-1],g[l-2],m),t.add(g[l-1],m,m)):m=g[b+1],et.x=m.x,et.y=m.y,et.z=a!==T.SCENE2D?m.z:0;var S=_[y];b===C+S&&(C+=S,++y);for(var x=0===b-C,P=b===C+_[y]-1,A=x?2:0,M=P?2:4,I=A;M>I;++I){d.writeElements(Q,u,p),d.writeElements($,u,p+6),d.writeElements(et,u,p+12);var D=0>I-2?-1:1;c[f]=b/(l-1),c[f+1]=2*(I%2)-1,c[f+2]=D*w,c[f+3]=E,p+=18,f+=4}}n.copyFromArrayView(u,18*Float32Array.BYTES_PER_ELEMENT*e),r.copyFromArrayView(c,4*Float32Array.BYTES_PER_ELEMENT*e)}},j}),define("Cesium/DataSources/PathVisualizer",["../Core/AssociativeArray","../Core/Cartesian3","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/JulianDate","../Core/Matrix3","../Core/Matrix4","../Core/ReferenceFrame","../Core/TimeInterval","../Core/Transforms","../Scene/PolylineCollection","../Scene/SceneMode","./CompositePositionProperty","./ConstantPositionProperty","./MaterialProperty","./Property","./ReferenceProperty","./SampledPositionProperty","./ScaledPositionProperty","./TimeIntervalCollectionPositionProperty"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";function w(e,t,n,r,a,s,l,u,c){var d,h=u;d=e.getValueInReferenceFrame(t,s,c[h]),i(d)&&(c[h++]=d);for(var m,p,f,v=!i(a)||o.lessThanOrEquals(a,t)||o.greaterThanOrEquals(a,n),g=0,_=r.length,y=r[g],C=n,w=!1;_>g;){if(!v&&o.greaterThanOrEquals(y,a)&&(d=e.getValueInReferenceFrame(a,s,c[h]),i(d)&&(c[h++]=d),v=!0),o.greaterThan(y,t)&&o.lessThan(y,C)&&!y.equals(a)&&(d=e.getValueInReferenceFrame(y,s,c[h]),i(d)&&(c[h++]=d)),_-1>g){if(l>0&&!w){var E=r[g+1],b=o.secondsDifference(E,y);w=b>l,w&&(m=Math.ceil(b/l),p=0,f=b/Math.max(m,2),m=Math.max(m-1,1))}if(w&&m>p){y=o.addSeconds(y,f,new o),p++;continue}}w=!1,g++,y=r[g]}return d=e.getValueInReferenceFrame(n,s,c[h]),i(d)&&(c[h++]=d),h}function E(e,t,n,r,a,s,l,u){for(var c,d=0,h=l,m=t,p=Math.max(s,60),f=!i(r)||o.lessThanOrEquals(r,t)||o.greaterThanOrEquals(r,n);o.lessThan(m,n);)!f&&o.greaterThanOrEquals(m,r)&&(f=!0,c=e.getValueInReferenceFrame(r,a,u[h]),i(c)&&(u[h]=c,h++)),c=e.getValueInReferenceFrame(m,a,u[h]),i(c)&&(u[h]=c,h++),d++,m=o.addSeconds(t,p*d,new o);return c=e.getValueInReferenceFrame(n,a,u[h]),i(c)&&(u[h]=c,h++),h}function b(e,t,n,r,a,s,l,c){O.start=t,O.stop=n;for(var d=l,h=e.intervals,m=0;m<h.length;m++){var p=h.get(m);if(!u.intersect(p,O,I).isEmpty){var f=p.start;p.isStartIncluded||(f=p.isStopIncluded?p.stop:o.addSeconds(p.start,o.secondsDifference(p.stop,p.start)/2,new o));var v=e.getValueInReferenceFrame(f,a,c[d]);i(v)&&(c[d]=v,d++)}}return d}function S(e,t,n,r,o,a,s,l){var u=e.getValueInReferenceFrame(t,o,l[s]);return i(u)&&(l[s++]=u),s}function x(e,t,i,n,r,a,s,l){D.start=t,D.stop=i;for(var c=s,d=e.intervals,h=0;h<d.length;h++){var m=d.get(h);if(!u.intersect(m,D,I).isEmpty){var p=m.start,f=m.stop,v=t;o.greaterThan(p,v)&&(v=p);var g=i;o.lessThan(f,g)&&(g=f),c=T(m.data,v,g,n,r,a,c,l)}}return c}function T(e,t,i,n,r,o,a,s){for(var l=e;l instanceof g||l instanceof y;)l instanceof g&&(l=l.resolvedProperty),l instanceof y&&(l=l._value);if(l instanceof _){var u=l._property._times;a=w(e,t,i,u,n,r,o,a,s)}else a=l instanceof m?x(e,t,i,n,r,o,a,s):l instanceof C?b(e,t,i,n,r,o,a,s):l instanceof p?S(e,t,i,n,r,o,a,s):E(e,t,i,n,r,o,a,s);return a}function P(e,t,n,r,o,a,s){i(s)||(s=[]);var l=T(e,t,n,r,o,a,0,s);return s.length=l,s}var A=60,M=1,I=new u,D=new u,O=new u,R=function(e){this.entity=e,this.polyline=void 0,this.index=void 0,this.updater=void 0},L=new a,N=function(e,t){this._unusedIndexes=[],this._polylineCollection=new d,this._scene=e,this._referenceFrame=t,e.primitives.add(this._polylineCollection)};N.prototype.update=function(e){if(this._referenceFrame===l.INERTIAL){var n=c.computeIcrfToFixedMatrix(e,L);i(n)||(n=c.computeTemeToPseudoFixedMatrix(e,L)),s.fromRotationTranslation(n,t.ZERO,this._polylineCollection.modelMatrix)}},N.prototype.updateObject=function(e,t){var n,r,a=t.entity,s=a._path,l=a._position,u=s._show,c=t.polyline,d=a.isShowing&&(!i(u)||u.getValue(e));if(d){var h=v.getValueOrUndefined(s._leadTime,e),m=v.getValueOrUndefined(s._trailTime,e),p=a._availability,g=i(p),_=i(h),y=i(m);if(d=g||_&&y){if(y&&(n=o.addSeconds(e,-m,new o)),_&&(r=o.addSeconds(e,h,new o)),g){var C=p.start,w=p.stop;(!y||o.greaterThan(C,n))&&(n=C),(!_||o.lessThan(w,r))&&(r=w)}d=o.lessThan(n,r)}}if(!d)return i(c)&&(this._unusedIndexes.push(t.index),t.polyline=void 0,c.show=!1,t.index=void 0),void 0;if(!i(c)){var E=this._unusedIndexes,b=E.length;if(b>0){var S=E.pop();c=this._polylineCollection.get(S),t.index=S}else t.index=this._polylineCollection.length,c=this._polylineCollection.add();c.id=a,t.polyline=c}var x=v.getValueOrDefault(s._resolution,e,A);c.show=!0,c.positions=P(l,n,r,e,this._referenceFrame,x,c.positions),c.material=f.getValue(e,s._material,c.material),c.width=v.getValueOrDefault(s._width,e,M)},N.prototype.removeObject=function(e){var t=e.polyline;i(t)&&(this._unusedIndexes.push(e.index),e.polyline=void 0,t.show=!1,e.index=void 0)},N.prototype.destroy=function(){return this._scene.primitives.remove(this._polylineCollection),n(this)};var z=function(t,i){i.collectionChanged.addEventListener(z.prototype._onCollectionChanged,this),this._scene=t,this._updaters={},this._entityCollection=i,this._items=new e,this._onCollectionChanged(i,i.values,[],[])};return z.prototype.update=function(e){var t=this._updaters;for(var n in t)t.hasOwnProperty(n)&&t[n].update(e);for(var r=this._items.values,o=0,a=r.length;a>o;o++){var s=r[o],u=s.entity,c=u._position,d=s.updater,m=l.FIXED;this._scene.mode===h.SCENE3D&&(m=c.referenceFrame);var p=this._updaters[m];d===p&&i(p)?p.updateObject(e,s):(i(d)&&d.removeObject(s),i(p)||(p=new N(this._scene,m),p.update(e),this._updaters[m]=p),s.updater=p,i(p)&&p.updateObject(e,s))}return!0},z.prototype.isDestroyed=function(){return!1},z.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(z.prototype._onCollectionChanged,this);var e=this._updaters;for(var t in e)e.hasOwnProperty(t)&&e[t].destroy();return n(this)},z.prototype._onCollectionChanged=function(e,t,n,r){var o,a,s,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],i(a._path)&&i(a._position)&&l.set(a.id,new R(a));for(o=r.length-1;o>-1;o--)a=r[o],i(a._path)&&i(a._position)?l.contains(a.id)||l.set(a.id,new R(a)):(s=l.get(a.id),i(s)&&(s.updater.removeObject(s),l.remove(a.id)));for(o=n.length-1;o>-1;o--)a=n[o],s=l.get(a.id),i(s)&&(s.updater.removeObject(s),l.remove(a.id))},z._subSample=P,z}),define("Cesium/DataSources/PointVisualizer",["../Core/AssociativeArray","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/BillboardCollection","./BoundingSphereState","./Property"],function(e,t,i,n,r,o,a,s,l,u){"use strict";function c(e,t){if(n(e)){var i=e.billboard;n(i)&&(e.billboard=void 0,i.show=!1,i.image=void 0,t.push(i._index))}}function d(e,t,i,n,r){return function(){var o=document.createElement("canvas"),a=r+2*n;o.height=o.width=a;var s=o.getContext("2d");return s.clearRect(0,0,a,a),0!==n&&(s.beginPath(),s.arc(a/2,a/2,a/2,0,2*Math.PI,!0),s.closePath(),s.fillStyle=i,s.fill(),1>e&&(s.save(),s.globalCompositeOperation="destination-out",s.beginPath(),s.arc(a/2,a/2,r/2,0,2*Math.PI,!0),s.closePath(),s.fillStyle="black",s.fill(),s.restore())),s.beginPath(),s.arc(a/2,a/2,r/2,0,2*Math.PI,!0),s.closePath(),s.fillStyle=t,s.fill(),o}}var h=i.WHITE,m=i.BLACK,p=0,f=1,v=new i,g=new t,_=new i,y=new a,C=function(e){this.entity=e,this.billboard=void 0,this.color=void 0,this.outlineColor=void 0,this.pixelSize=void 0,this.outlineWidth=void 0},w=function(t,i){i.collectionChanged.addEventListener(w.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._entityCollection=i,this._billboardCollection=void 0,this._items=new e,this._onCollectionChanged(i,i.values,[],[])};return w.prototype.update=function(e){for(var t=this._items.values,r=this._unusedIndexes,o=0,a=t.length;a>o;o++){var l=t[o],C=l.entity,w=C._point,E=l.billboard,b=C.isShowing&&C.isAvailable(e)&&u.getValueOrDefault(w._show,e,!0);if(b&&(g=u.getValueOrUndefined(C._position,e,g),b=n(g)),b){var S=!1,x=!1;if(!n(E)){S=!0;var T=this._billboardCollection;n(T)||(T=new s,this._billboardCollection=T,this._scene.primitives.add(T));var P=r.length;E=P>0?T.get(r.pop()):T.add(),E.id=C,E.image=void 0,l.billboard=E,x=!0}E.show=!0,E.position=g,E.scaleByDistance=u.getValueOrUndefined(w._scaleByDistance,e,y);var A=w._color,M=w._outlineColor,I=u.getValueOrDefault(A,e,h,v),D=u.getValueOrDefault(M,e,m,_),O=Math.round(u.getValueOrDefault(w._outlineWidth,e,p)),R=Math.max(1,Math.round(u.getValueOrDefault(w._pixelSize,e,f)));if(O>0?(E.scale=1,x=x||O!==l.outlineWidth||R!==l.pixelSize||!i.equals(I,l.color)||!i.equals(D,l.outlineColor)):(E.scale=R/50,R=50,x=x||O!==l.outlineWidth||!i.equals(I,l.color)||!i.equals(D,l.outlineColor)),x){l.color=i.clone(I,l.color),l.outlineColor=i.clone(D,l.outlineColor),l.pixelSize=R,l.outlineWidth=O;var L=I.alpha,N=I.toCssColorString(),z=D.toCssColorString(),F=JSON.stringify([N,R,z,O]);E.setImage(F,d(L,N,z,O,R))}}else c(l,r)}return!0},w.prototype.getBoundingSphere=function(e,i){var r=this._items.get(e.id);return n(r)&&n(r.billboard)?(i.center=t.clone(r.billboard.position,i.center),i.radius=0,l.DONE):l.FAILED},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(w.prototype._onCollectionChanged,this),n(this._billboardCollection)&&this._scene.primitives.remove(this._billboardCollection),r(this)},w.prototype._onCollectionChanged=function(e,t,i,r){var o,a,s=this._unusedIndexes,l=this._items;for(o=t.length-1;o>-1;o--)a=t[o],n(a._point)&&n(a._position)&&l.set(a.id,new C(a));for(o=r.length-1;o>-1;o--)a=r[o],n(a._point)&&n(a._position)?l.contains(a.id)||l.set(a.id,new C(a)):(c(l.get(a.id),s),l.remove(a.id));for(o=i.length-1;o>-1;o--)a=i[o],c(l.get(a.id),s),l.remove(a.id)},w}),define("Cesium/Core/PolygonGeometryLibrary",["./Cartesian3","./defaultValue","./defined","./Ellipsoid"],function(e,t,i,n){"use strict";function r(t,i,n,r){return e.subtract(i,t,a),e.multiplyByScalar(a,n/r,a),e.add(t,a,a),[a.x,a.y,a.z]}var o={};o.computeHierarchyPackedLength=function(t){for(var n=0,r=[t];r.length>0;){var o=r.pop();if(i(o)){n+=2;var a=o.positions,s=o.holes;if(i(a)&&(n+=a.length*e.packedLength),i(s))for(var l=s.length,u=0;l>u;++u)r.push(s[u])}}return n},o.packPolygonHierarchy=function(t,n,r){for(var o=[t];o.length>0;){var a=o.pop();if(i(a)){var s=a.positions,l=a.holes;if(n[r++]=i(s)?s.length:0,n[r++]=i(l)?l.length:0,i(s))for(var u=s.length,c=0;u>c;++c,r+=3)e.pack(s[c],n,r);if(i(l))for(var d=l.length,h=0;d>h;++h)o.push(l[h])}}return r},o.unpackPolygonHierarchy=function(t,i){for(var n=t[i++],r=t[i++],a=new Array(n),s=r>0?new Array(r):void 0,l=0;n>l;++l,i+=e.packedLength)a[l]=e.unpack(t,i);for(var u=0;r>u;++u)s[u]=o.unpackPolygonHierarchy(t,i),i=s[u].startingIndex,delete s[u].startingIndex;return{positions:a,holes:s,startingIndex:i}};var a=new e;o.subdivideLineCount=function(t,i,n){var r=e.distance(t,i),o=r/n,a=Math.max(0,Math.ceil(Math.log(o)/Math.log(2)));return Math.pow(2,a)},o.subdivideLine=function(t,n,a,s){var l=o.subdivideLineCount(t,n,a),u=e.distance(t,n),c=u/l;i(s)||(s=[]);var d=s;d.length=3*l;for(var h=0,m=0;l>m;m++){var p=r(t,n,m*c,u);d[h++]=p[0],d[h++]=p[1],d[h++]=p[2]}return d};var s=new e,l=new e,u=new e,c=new e;return o.scaleToGeodeticHeightExtruded=function(r,o,a,d,h){d=t(d,n.WGS84);var m=s,p=l,f=u,v=c;if(i(r)&&i(r.attributes)&&i(r.attributes.position))for(var g=r.attributes.position.values,_=g.length/2,y=0;_>y;y+=3)e.fromArray(g,y,f),d.geodeticSurfaceNormal(f,m),v=d.scaleToGeodeticSurface(f,v),p=e.multiplyByScalar(m,a,p),p=e.add(v,p,p),g[y+_]=p.x,g[y+1+_]=p.y,g[y+2+_]=p.z,h&&(v=e.clone(f,v)),p=e.multiplyByScalar(m,o,p),p=e.add(v,p,p),g[y]=p.x,g[y+1]=p.y,g[y+2]=p.z;return r},o}),define("Cesium/Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var i=new t,n=function(t,n,r,o){return e(t,n,r,o,i),i.x>0&&i.y>0&&i.z>0};return n}),define("Cesium/Core/WindingOrder",["./freezeObject"],function(e){"use strict";var t={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return e(t)}),define("Cesium/Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p){"use strict";function f(t,i,n){var r=e.subtract(i,t,N),o=e.subtract(n,i,z);return r.x*o.y-r.y*o.x>=0}function v(e){for(var t=e[0].x,i=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,i=n);return i}function g(e){for(var t=e[0][0].x,i=0,n=0;n<e.length;n++){var r=e[n][v(e[n])].x;
r>t&&(t=r,i=n)}return i}function _(e){for(var t=[],i=0;i<e.length;i++){var n=e[(i-1+e.length)%e.length],r=e[i],o=e[(i+1)%e.length];f(n,r,o)||t.push(r)}return t}function y(t,i){for(var n=0;n<t.length;n++)if(e.equals(i,t[n]))return n;return-1}function C(i,r,o){o=n(o,[]);var a=Number.MAX_VALUE,s=v(r),l=new e(r[s].x,i.y);o.push(s),o.push((s+1)%r.length);for(var u=r[0].x,c=u,d=1;d<r.length;++d)r[d].x<u?u=r[d].x:r[d].x>c&&(c=r[d].x);c+=c-u;var h=new t(c,i.y,0);for(d=0;d<r.length;d++){var m=r[d],p=r[(d+1)%r.length];if((m.x>=i.x||p.x>=i.x)&&(m.y>=i.y&&p.y<=i.y||m.y<=i.y&&p.y>=i.y)){var f=(p.y-m.y)*(h.x-i.x)-(p.x-m.x)*(h.y-i.y);if(0!==f){f=1/f;var g=((p.x-m.x)*(i.y-m.y)-(p.y-m.y)*(i.x-m.x))*f,_=((h.x-i.x)*(i.y-m.y)-(h.y-i.y)*(i.x-m.x))*f;if(g>=0&&1>=g&&_>=0&&1>=_){var y=new e(i.x+g*(h.x-i.x),i.y+g*(h.y-i.y)),C=e.subtract(y,i,F);f=e.magnitudeSquared(C),a>f&&(l=y,a=f,o[0]=d,o[1]=(d+1)%r.length)}}}}return l}function w(t,i){var n=g(i),r=i[n],o=v(r),a=r[o],s=[],l=C(a,t,s),u=y(t,l);if(-1!==u)return u;var h=e.magnitudeSquared(e.subtract(t[s[0]],a,B)),m=e.magnitudeSquared(e.subtract(t[s[1]],a,B)),p=m>h?t[s[0]]:t[s[1]],f=_(t),w=f.indexOf(p);-1!==w&&f.splice(w,1);for(var E=[],b=0;b<f.length;b++){var S=f[b];d(S,a,l,p)&&E.push(S)}var x=Number.MAX_VALUE;if(E.length>0){var T=e.fromElements(1,0,B);for(b=0;b<E.length;b++){var P=e.subtract(E[b],a,V),A=e.magnitude(T)*e.magnitudeSquared(P);if(0!==A){var M=Math.abs(c.acosClamped(e.dot(T,P)/A));x>M&&(x=M,p=E[b])}}}return t.indexOf(p)}function E(e,i,n){for(var r=$.computeWindingOrder2D(e),o=0;o<i.length;o++){var a=i[o];t.equals(a[0],a[a.length-1])||a.push(a[0]);var l=$.computeWindingOrder2D(a);l===r&&a.reverse()}var u=s.fromPoints(e,n),c=u.projectPointsOntoPlane(e),d=[];for(o=0;o<i.length;o++)d.push(u.projectPointsOntoPlane(i[o]));var h=w(c,d),m=g(d),p=v(d[m]),f=i[m],_=[];for(o=0;o<e.length;o++)_.push(e[o]);var y,C=[];if(0!==p)for(y=0;y<=f.length;y++){var E=(y+p)%f.length;0!==E&&C.push(f[E])}else for(y=0;y<f.length;y++)C.push(f[(y+p)%f.length]);var b=_.lastIndexOf(e[h]);C.push(e[b]);var S=_.slice(0,b+1),x=_.slice(b+1);return _=S.concat(C,x),i.splice(m,1),_}function b(e){var t=c.nextRandomNumber(),i=Math.floor(t*e);return i===e&&i--,i}function S(e,t,i,n){var r=n[e].position,o=n[t].position,a=n[i].position,s=a.x,l=a.y,u=r.x-s,c=r.y-l,d=o.x-s,h=o.y-l;return u*h-c*d}function x(e,t){return e.x*t.y-e.y*t.x}function T(e,t){var i=t.length,n=c.mod(e-1,i),r=c.mod(e+1,i);return 0===S(n,r,e,t)?!1:!0}function P(t,i){return e.magnitudeSquared(i)<e.magnitudeSquared(t)}function A(t,i,n){if(!T(t,n))return t;var r=n[t].position,o=n[i].position,a=n.length,s=c.mod(t-1,a);if(!T(s,n))return s;var l=c.mod(t+1,a);if(!T(l,n))return l;var u=e.subtract(n[s].position,r,W),d=e.subtract(n[l].position,r,G),h=e.subtract(o,r,H),m=x(u,h),p=x(d,h);if(0===m)return P(u,h)?k:U;if(0===p)return P(d,h)?k:U;var f=x(u,d);return 0>f?0>m&&p>0?k:U:f>0?m>0&&0>p?U:k:void 0}function M(e,t,i){return(e>t||e>i)&&(t>e||i>e)||t===i&&t===e}function I(t,i,n,r){var o=e.subtract(n,t,j),a=i.x*r.y-i.y*r.x,s=a*a,l=e.magnitudeSquared(i),u=e.magnitudeSquared(r);if(s>q*l*u){var c=(o.x*r.y-o.y*r.x)/a;return e.add(t,e.multiplyByScalar(i,c,j),j)}return void 0}function D(t,i,n){for(var o=e.subtract(i,t,Y),a=n.length,s=0;a>s;s++){var l=n[s].position,u=n[c.mod(s+1,a)].position;if(!(e.equals(t,l)||e.equals(i,u)||e.equals(t,u)||e.equals(i,l))){var d=e.subtract(u,l,X),h=I(t,o,l,d);if(r(h)&&!(e.equals(h,t)||e.equals(h,i)||e.equals(h,l)||e.equals(h,u))){var m=h.x,p=h.y,f=M(m,t.x,i.x)&&M(p,t.y,i.y)&&M(m,l.x,u.x)&&M(p,l.y,u.y);if(f)return!0}}}return!1}function O(t,i,n){var r=A(t,i,n);if(r>=0)return r;var o=A(i,t,n);return o>=0?o:r!==k||o!==k||D(n[t].position,n[i].position,n)||e.equals(n[t].position,n[i].position)?J:Z}function R(e){return 0===S(1,2,0,e)}function L(e){var t=e.length;if(3===t)return R(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new o("Invalid polygon: must have at least three vertices.");for(var i,n,r=0,a=10*e.length,s=J;Z>s&&r++<a;){for(i=b(e.length),n=i+1;Math.abs(i-n)<2||Math.abs(i-n)>e.length-2;)n=b(e.length);if(i>n){var l=i;i=n,n=l}s=O(i,n,e)}if(s===Z){var u=e.splice(i,n-i+1,e[i],e[n]);return L(e).concat(L(u))}return s>=0?(e.splice(s,1),L(e)):[]}var N=new e,z=new e,F=new e,B=new e(1,0),V=new e,k=-1,U=-2,W=new t,G=new t,H=new t,q=c.EPSILON14,j=new e;new e;var Y=new e,X=new e,Z=-1,J=-2,K=new t,Q=new t,$={};$.removeDuplicates=function(e){for(var i=e.length,n=[],r=i-1,o=0;i>o;r=o++){var a=e[r],s=e[o];t.equals(a,s)||n.push(s)}return n},$.computeArea2D=function(e){for(var t=e.length,i=0,n=t-1,r=0;t>r;n=r++){var o=e[n],a=e[r];i+=o.x*a.y-a.x*o.y}return.5*i},$.computeWindingOrder2D=function(e){var t=$.computeArea2D(e);return t>0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},$.triangulate=function(e){for(var t=e.length,i=[],n=0;t>n;++n)i[n]={position:e[n],index:n};return L(i)};var et=new t,tt=new t,it=new t,nt=new t,rt=new t,ot=new t,at=new t;return $.computeSubdivision=function(e,o,a,s){s=n(s,c.RADIANS_PER_DEGREE);var d,m=a.slice(0),p=o.length,f=new Array(3*p),v=0;for(d=0;p>d;d++){var g=o[d];f[v++]=g.x,f[v++]=g.y,f[v++]=g.z}for(var _=[],y={},C=e.maximumRadius,w=c.chordLength(s,C),E=w*w;m.length>0;){var b,S,x=m.pop(),T=m.pop(),P=m.pop(),A=t.fromArray(f,3*P,et),M=t.fromArray(f,3*T,tt),I=t.fromArray(f,3*x,it),D=t.multiplyByScalar(t.normalize(A,nt),C,nt),O=t.multiplyByScalar(t.normalize(M,rt),C,rt),R=t.multiplyByScalar(t.normalize(I,ot),C,ot),L=t.magnitudeSquared(t.subtract(D,O,at)),N=t.magnitudeSquared(t.subtract(O,R,at)),z=t.magnitudeSquared(t.subtract(R,D,at)),F=Math.max(L,N,z);F>E?L===F?(b=Math.min(P,T)+" "+Math.max(P,T),d=y[b],r(d)||(S=t.add(A,M,at),t.multiplyByScalar(S,.5,S),f.push(S.x,S.y,S.z),d=f.length/3-1,y[b]=d),m.push(P,d,x),m.push(d,T,x)):N===F?(b=Math.min(T,x)+" "+Math.max(T,x),d=y[b],r(d)||(S=t.add(M,I,at),t.multiplyByScalar(S,.5,S),f.push(S.x,S.y,S.z),d=f.length/3-1,y[b]=d),m.push(T,d,P),m.push(d,x,P)):z===F&&(b=Math.min(x,P)+" "+Math.max(x,P),d=y[b],r(d)||(S=t.add(I,A,at),t.multiplyByScalar(S,.5,S),f.push(S.x,S.y,S.z),d=f.length/3-1,y[b]=d),m.push(x,d,T),m.push(d,P,T)):(_.push(P),_.push(T),_.push(x))}return new l({attributes:{position:new u({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:f})},indices:_,primitiveType:h.TRIANGLES})},$.scaleToGeodeticHeight=function(e,i,o,s){o=n(o,a.WGS84);var l=K,u=Q;if(i=n(i,0),s=n(s,!0),r(e)&&r(e.attributes)&&r(e.attributes.position))for(var c=e.attributes.position.values,d=c.length,h=0;d>h;h+=3)t.fromArray(c,h,u),s&&(u=o.scaleToGeodeticSurface(u,u)),l=o.geodeticSurfaceNormal(u,l),t.multiplyByScalar(l,i,l),t.add(u,l,u),c[h]=u.x,c[h+1]=u.y,c[h+2]=u.z;return e},$.eliminateHoles=function(e,i,r){r=n(r,a.WGS84);for(var o=[],s=0;s<i.length;s++){for(var l=[],u=0;u<i[s].length;u++)l.push(t.clone(i[s][u]));o.push(l)}for(var c=e;o.length>0;)c=E(c,o,r);return c},$}),define("Cesium/Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Quaternion","./Queue","./VertexFormat","./WindingOrder"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S){"use strict";function x(e,t,i,r){for(var o=w.fromAxisAngle(e._plane.normal,i,O),s=g.fromQuaternion(o,R),l=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,d=Number.NEGATIVE_INFINITY,h=t.length,m=0;h>m;++m){var p=n.clone(t[m],D);g.multiplyByVector(s,p,p);var f=e.projectPointOntoPlane(p,I);a(f)&&(l=Math.min(l,f.x),u=Math.max(u,f.x),c=Math.min(c,f.y),d=Math.max(d,f.y))}return r.x=l,r.y=c,r.width=u-l,r.height=d-c,r}function T(e,t,i,n){var o=u.fromPoints(t,e),a=o.projectPointsOntoPlane(t,L),s=y.computeWindingOrder2D(a);s===S.CLOCKWISE&&(a.reverse(),t.reverse());var l=y.triangulate(a);l.length<3&&(l=[0,1,2]);var h;if(n){for(var p=t.length,f=new Array(3*p),v=0,g=0;p>g;g++){var _=t[g];f[v++]=_.x,f[v++]=_.y,f[v++]=_.z}h=new c({attributes:{position:new d({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:f})},indices:l,primitiveType:C.TRIANGLES})}else h=y.computeSubdivision(e,t,l,i);return new m({geometry:h})}function P(e,t,o,a,s,l,c){if(e.st||e.normal||e.tangent||e.binormal){var h=u.fromPoints(o,a),m=x(h,o,s,N),p=W;p.x=m.x,p.y=m.y;var f=t.attributes.position.values,_=f.length,y=e.st?new Float32Array(2*(_/3)):void 0,C=e.normal?new Float32Array(_):void 0,E=e.tangent?new Float32Array(_):void 0,b=e.binormal?new Float32Array(_):void 0,S=0,T=0,P=F,A=B,M=V,I=!0,D=w.fromAxisAngle(h._plane.normal,s,q),O=g.fromQuaternion(D,j),R=_/2,L=_/3;l&&(_/=2);for(var Y=0;_>Y;Y+=3){var X=n.fromArray(f,Y,H);if(e.st){var Z=g.multiplyByVector(O,X,z),J=h.projectPointOntoPlane(Z,G);i.subtract(J,p,J),l&&(y[S+L]=J.x/m.width,y[S+1+L]=J.y/m.height),y[S]=J.x/m.width,y[S+1]=J.y/m.height,S+=2}if(e.normal||e.tangent||e.binormal){var K=T+1,Q=T+2;if(c){if(_>Y+3){var $=n.fromArray(f,Y+3,k);if(I){var et=n.fromArray(f,Y+_,U);n.subtract($,X,$),n.subtract(et,X,et),P=n.normalize(n.cross(et,$,P),P),I=!1}n.equalsEpsilon($,X,v.EPSILON10)&&(I=!0)}(e.tangent||e.binormal)&&(M=a.geodeticSurfaceNormal(X,M),e.tangent&&(A=n.normalize(n.cross(M,P,A),A)))}else P=a.geodeticSurfaceNormal(X,P),(e.tangent||e.binormal)&&(A=n.cross(n.UNIT_Z,P,A),A=n.normalize(g.multiplyByVector(O,A,A),A),e.binormal&&(M=n.normalize(n.cross(P,A,M),M)));e.normal&&(l&&!c?(C[T+R]=-P.x,C[K+R]=-P.y,C[Q+R]=-P.z):(C[T+R]=P.x,C[K+R]=P.y,C[Q+R]=P.z),C[T]=P.x,C[K]=P.y,C[Q]=P.z),e.tangent&&(l&&!c?(E[T+R]=-A.x,E[K+R]=-A.y,E[Q+R]=-A.z):(E[T+R]=A.x,E[K+R]=A.y,E[Q+R]=A.z),E[T]=A.x,E[K]=A.y,E[Q]=A.z),e.binormal&&(l&&(b[T+R]=M.x,b[K+R]=M.y,b[Q+R]=M.z),b[T]=M.x,b[K]=M.y,b[Q]=M.z),T+=3}}e.st&&(t.attributes.st=new d({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:y})),e.normal&&(t.attributes.normal=new d({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:C})),e.tangent&&(t.attributes.tangent=new d({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:E})),e.binormal&&(t.attributes.binormal=new d({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:b}))}return t}function A(e,t,i,o){var a,s,l,u,m,p=e.length,g=0;if(o)for(s=2*3*p,a=new Array(2*s),l=0;p>l;l++)u=e[l],m=e[(l+1)%p],a[g]=a[g+s]=u.x,++g,a[g]=a[g+s]=u.y,++g,a[g]=a[g+s]=u.z,++g,a[g]=a[g+s]=m.x,++g,a[g]=a[g+s]=m.y,++g,a[g]=a[g+s]=m.z,++g;else{var y=v.chordLength(i,t.maximumRadius),w=0;for(l=0;p>l;l++)w+=_.subdivideLineCount(e[l],e[(l+1)%p],y);for(s=3*(w+p),a=new Array(2*s),l=0;p>l;l++){u=e[l],m=e[(l+1)%p];for(var E=_.subdivideLine(u,m,y,Y),b=E.length,S=0;b>S;++S,++g)a[g]=E[S],a[g+s]=E[S];a[g]=m.x,a[g+s]=m.x,++g,a[g]=m.y,a[g+s]=m.y,++g,a[g]=m.z,a[g+s]=m.z,++g}}p=a.length;var x=f.createTypedArray(p/3,p-6*e.length),T=0;for(p/=6,l=0;p>l;l++){var P=l,A=P+1,M=P+p,I=M+1;u=n.fromArray(a,3*P,k),m=n.fromArray(a,3*A,U),n.equalsEpsilon(u,m,v.EPSILON14)||(x[T++]=P,x[T++]=M,x[T++]=A,x[T++]=A,x[T++]=M,x[T++]=I)}return new c({attributes:new h({position:new d({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:a})}),indices:x,primitiveType:C.TRIANGLES})}function M(e,t,i,n,o){var a=T(e,t,i,o).geometry,s=a.attributes.position.values,l=a.indices,p=s.concat(s),v=p.length/3,g=f.createTypedArray(v,2*l.length);g.set(l);var _,C=l.length,w=v/2;for(_=0;C>_;_+=3){var E=g[_]+w,b=g[_+1]+w,x=g[_+2]+w;g[_+C]=x,g[_+1+C]=b,g[_+2+C]=E}var P=new c({attributes:new h({position:new d({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:p})}),indices:g,primitiveType:a.primitiveType}),M={topAndBottom:new m({geometry:P}),walls:[]},I=n.outerRing,D=u.fromPoints(I,e),O=D.projectPointsOntoPlane(I,X),R=y.computeWindingOrder2D(O);R===S.CLOCKWISE&&I.reverse();var L=A(I,e,i,o);M.walls.push(new m({geometry:L}));var N=n.holes;for(_=0;_<N.length;_++){var z=N[_];D=u.fromPoints(z,e),O=D.projectPointsOntoPlane(z,X),R=y.computeWindingOrder2D(O),R===S.COUNTER_CLOCKWISE&&z.reverse(),L=A(z,e,i),M.walls.push(new m({geometry:L}))}return M}var I=new i,D=new n,O=new w,R=new g,L=[],N=new e,z=new n,F=new n,B=new n,V=new n,k=new n,U=new n,W=new i,G=new i,H=new n,q=new w,j=new g,Y=[],X=[],Z=function(e){var t=e.polygonHierarchy,i=o(e.vertexFormat,b.DEFAULT),n=o(e.ellipsoid,l.WGS84),r=o(e.granularity,v.RADIANS_PER_DEGREE),s=o(e.stRotation,0),u=o(e.height,0),c=o(e.perPositionHeight,!1),d=e.extrudedHeight,h=a(d)&&(!v.equalsEpsilon(u,d,v.EPSILON6)||c);if(h){var m=d;d=Math.min(m,u),u=Math.max(m,u)}this._vertexFormat=b.clone(i),this._ellipsoid=l.clone(n),this._granularity=r,this._stRotation=s,this._height=u,this._extrudedHeight=o(d,0),this._extrude=h,this._polygonHierarchy=t,this._perPositionHeight=c,this._workerName="createPolygonGeometry",this.packedLength=_.computeHierarchyPackedLength(t)+l.packedLength+b.packedLength+7};Z.fromPositions=function(e){e=o(e,o.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new Z(t)},Z.pack=function(e,t,i){i=o(i,0),i=_.packPolygonHierarchy(e._polygonHierarchy,t,i),l.pack(e._ellipsoid,t,i),i+=l.packedLength,b.pack(e._vertexFormat,t,i),i+=b.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._stRotation,t[i++]=e._extrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i]=e.packedLength};var J=l.clone(l.UNIT_SPHERE),K=new b,Q={polygonHierarchy:{}};return Z.unpack=function(e,t,i){t=o(t,0);var n=_.unpackPolygonHierarchy(e,t);t=n.startingIndex,delete n.startingIndex;var r=l.unpack(e,t,J);t+=l.packedLength;var s=b.unpack(e,t,K);t+=b.packedLength;var u=e[t++],c=e[t++],d=e[t++],h=e[t++],m=1===e[t++],p=1===e[t++],f=e[t];return a(i)||(i=new Z(Q)),i._polygonHierarchy=n,i._ellipsoid=l.clone(r,i._ellipsoid),i._vertexFormat=b.clone(s,i._vertexFormat),i._height=u,i._extrudedHeight=c,i._granularity=d,i._stRotation=h,i._extrude=m,i._perPositionHeight=p,i.packedLength=f,i},Z.createGeometry=function(e){var i,n,r,o=e._vertexFormat,s=e._ellipsoid,l=e._granularity,u=e._stRotation,d=e._height,h=e._extrudedHeight,m=e._extrude,v=e._polygonHierarchy,g=e._perPositionHeight,C=[],w=new E;w.enqueue(v),v=[];for(var b;0!==w.length;){var S=w.dequeue(),x=S.positions,A=S.holes;if(x=y.removeDuplicates(x),!(x.length<3)){var I=a(A)?A.length:0,D=[];for(b=0;I>b;b++){var O=A[b];if(O.positions=y.removeDuplicates(O.positions),!(O.positions.length<3)){D.push(O.positions);var R=0;a(O.holes)&&(R=O.holes.length);for(var L=0;R>L;L++)w.enqueue(O.holes[L])}}v.push({outerRing:x,holes:D});var N=D.length>0?y.eliminateHoles(x,D):x;C.push(N)}}if(0===C.length)return void 0;r=C[0];var z,F=[];if(m)for(b=0;b<C.length;b++){z=M(s,C[b],l,v[b],g),n=z.topAndBottom,n.geometry=_.scaleToGeodeticHeightExtruded(n.geometry,d,h,s,g),n.geometry=P(o,n.geometry,r,s,u,!0,!1),F.push(n),i=z.walls;for(var B=0;B<i.length;B++){var V=i[B];V.geometry=_.scaleToGeodeticHeightExtruded(V.geometry,d,h,s,g),V.geometry=P(o,V.geometry,r,s,u,!0,!0),F.push(V)}}else for(b=0;b<C.length;b++)z=T(s,C[b],l,g),z.geometry=y.scaleToGeodeticHeight(z.geometry,d,s,!g),z.geometry=P(o,z.geometry,r,s,u,!1,!1),F.push(z);z=p.combineInstances(F)[0],z.attributes.position.values=new Float64Array(z.attributes.position.values),z.indices=f.createTypedArray(z.attributes.position.values.length/3,z.indices);var k=z.attributes,U=t.fromVertices(k.position.values);return o.position||delete k.position,new c({attributes:k,indices:z.indices,primitiveType:z.primitiveType,boundingSphere:U})},Z}),define("Cesium/Core/PolygonOutlineGeometry",["./BoundingSphere","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_){"use strict";function y(e,i,n,r){var o=a.fromPoints(i,e),d=o.projectPointsOntoPlane(i,w),m=f.computeWindingOrder2D(d);m===_.CLOCKWISE&&(d.reverse(),i.reverse());var g,y,C=i.length,b=0;if(r)for(g=new Float64Array(3*2*C),y=0;C>y;y++){var S=i[y],x=i[(y+1)%C];g[b++]=S.x,g[b++]=S.y,g[b++]=S.z,g[b++]=x.x,g[b++]=x.y,g[b++]=x.z}else{var T=0;for(y=0;C>y;y++)T+=p.subdivideLineCount(i[y],i[(y+1)%C],n);for(g=new Float64Array(3*T),y=0;C>y;y++)for(var P=p.subdivideLine(i[y],i[(y+1)%C],n,E),A=P.length,M=0;A>M;++M)g[b++]=P[M]}C=g.length/3;var I=2*C,D=h.createTypedArray(C,I);for(b=0,y=0;C-1>y;y++)D[b++]=y,D[b++]=y+1;return D[b++]=C-1,D[b++]=0,new c({geometry:new s({attributes:new u({position:new l({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:g})}),indices:D,primitiveType:v.LINES})})}function C(e,i,n,r){var o=a.fromPoints(i,e),d=o.projectPointsOntoPlane(i,w),m=f.computeWindingOrder2D(d);m===_.CLOCKWISE&&(d.reverse(),i.reverse());var g,y,C=i.length,b=new Array(C),S=0;if(r)for(g=new Float64Array(2*3*2*C),y=0;C>y;++y){b[y]=S/3;var x=i[y],T=i[(y+1)%C];g[S++]=x.x,g[S++]=x.y,g[S++]=x.z,g[S++]=T.x,g[S++]=T.y,g[S++]=T.z}else{var P=0;for(y=0;C>y;y++)P+=p.subdivideLineCount(i[y],i[(y+1)%C],n);for(g=new Float64Array(2*3*P),y=0;C>y;++y){b[y]=S/3;for(var A=p.subdivideLine(i[y],i[(y+1)%C],n,E),M=A.length,I=0;M>I;++I)g[S++]=A[I]}}C=g.length/6;var D=b.length,O=2*(2*C+D),R=h.createTypedArray(C,O);for(S=0,y=0;C>y;++y)R[S++]=y,R[S++]=(y+1)%C,R[S++]=y+C,R[S++]=(y+1)%C+C;for(y=0;D>y;y++){var L=b[y];R[S++]=L,R[S++]=L+C}return new c({geometry:new s({attributes:new u({position:new l({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:g})}),indices:R,primitiveType:v.LINES})})}var w=[],E=[],b=function(e){var t=e.polygonHierarchy,r=i(e.ellipsoid,o.WGS84),a=i(e.granularity,m.RADIANS_PER_DEGREE),s=i(e.height,0),l=i(e.perPositionHeight,!1),u=e.extrudedHeight,c=n(u)&&(!m.equalsEpsilon(s,u,m.EPSILON6)||l);if(c){var d=u;u=Math.min(d,s),s=Math.max(d,s)}this._ellipsoid=o.clone(r),this._granularity=a,this._height=s,this._extrudedHeight=i(u,0),this._extrude=c,this._polygonHierarchy=t,this._perPositionHeight=l,this._workerName="createPolygonOutlineGeometry",this.packedLength=p.computeHierarchyPackedLength(t)+o.packedLength+6};b.pack=function(e,t,n){n=i(n,0),n=p.packPolygonHierarchy(e._polygonHierarchy,t,n),o.pack(e._ellipsoid,t,n),n+=o.packedLength,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._granularity,t[n++]=e._extrude?1:0,t[n++]=e._perPositionHeight?1:0,t[n++]=e.packedLength};var S=o.clone(o.UNIT_SPHERE),x={polygonHierarchy:{}};return b.unpack=function(e,t,r){t=i(t,0);var a=p.unpackPolygonHierarchy(e,t);t=a.startingIndex,delete a.startingIndex;var s=o.unpack(e,t,S);t+=o.packedLength;var l=e[t++],u=e[t++],c=e[t++],d=1===e[t++],h=1===e[t++],m=e[t++];return n(r)||(r=new b(x)),r._polygonHierarchy=a,r._ellipsoid=o.clone(s,r._ellipsoid),r._height=l,r._extrudedHeight=u,r._granularity=c,r._extrude=d,r._perPositionHeight=h,r.packedLength=m,r},b.fromPositions=function(e){e=i(e,i.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new b(t)},b.createGeometry=function(t){var i=t._ellipsoid,r=t._granularity,o=t._height,a=t._extrudedHeight,l=t._extrude,u=t._polygonHierarchy,c=t._perPositionHeight,h=[],v=new g;v.enqueue(u);for(var _;0!==v.length;){var w=v.dequeue(),E=w.positions;if(E=f.removeDuplicates(E),!(E.length<3)){var b=w.holes?w.holes.length:0;for(_=0;b>_;_++){var S=w.holes[_];if(S.positions=f.removeDuplicates(S.positions),!(S.positions.length<3)){h.push(S.positions);var x=0;n(S.holes)&&(x=S.holes.length);for(var T=0;x>T;T++)v.enqueue(S.holes[T])}}h.push(E)}}if(0===h.length)return void 0;var P,A=[],M=m.chordLength(r,i.maximumRadius);if(l)for(_=0;_<h.length;_++)P=C(i,h[_],M,c),P.geometry=p.scaleToGeodeticHeightExtruded(P.geometry,o,a,i,c),A.push(P);else for(_=0;_<h.length;_++)P=y(i,h[_],M,c),P.geometry=f.scaleToGeodeticHeight(P.geometry,o,i,!c),A.push(P);P=d.combineInstances(A)[0];var I=e.fromVertices(P.attributes.position.values);return new s({attributes:P.attributes,indices:P.indices,primitiveType:P.primitiveType,boundingSphere:I})},b}),define("Cesium/DataSources/PolygonGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/isArray","../Core/Iso8601","../Core/PolygonGeometry","../Core/PolygonHierarchy","../Core/PolygonOutlineGeometry","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E){"use strict";var b=new _(e.WHITE),S=new y(!0),x=new y(!0),T=new y(!1),P=new y(e.BLACK),A=new e,M=function(e){this.id=e,this.vertexFormat=void 0,this.polygonHierarchy=void 0,this.perPositionHeight=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0},I=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(I.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new s,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new M(e),this._onEntityPropertyChanged(e,"polygon",e.polygon,void 0)};r(I,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:f}}),r(I.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&E.isConstant(this._showProperty)&&E.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&E.isConstant(this._showProperty)&&E.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),I.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},I.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},I.prototype.createFillGeometryInstance=function(i){var r,o,a=this._entity,s=a.isAvailable(i),u=new p(s&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof _){var c=e.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(c=this._materialProperty.color.getValue(i)),o=t.fromColor(c),r={show:u,color:o}}else r={show:u};return new l({id:a,geometry:new d(this._options),attributes:r})},I.prototype.createOutlineGeometryInstance=function(i){var n=this._entity,r=n.isAvailable(i),o=E.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new l({id:n,geometry:new m(this._options),attributes:{show:new p(r&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(o)}})},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){this._entitySubscription(),o(this)},I.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"polygon"===t){var r=this._entity.polygon;if(!n(r))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=r.fill,a=n(o)&&o.isConstant?o.getValue(c.MINIMUM_VALUE):!0,s=r.outline,l=n(s);if(l&&s.isConstant&&(l=s.getValue(c.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var d=r.hierarchy,m=r.show;if(n(m)&&m.isConstant&&!m.getValue(c.MINIMUM_VALUE)||!n(d))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var p=i(r.material,b),g=p instanceof _;this._materialProperty=p,this._fillProperty=i(o,x),this._showProperty=i(m,S),this._showOutlineProperty=i(r.outline,T),this._outlineColorProperty=l?i(r.outlineColor,P):void 0;var y=r.height,C=r.extrudedHeight,w=r.granularity,A=r.stRotation,M=r.outlineWidth,I=r.perPositionHeight;if(this._fillEnabled=a,this._outlineEnabled=l,d.isConstant&&E.isConstant(y)&&E.isConstant(C)&&E.isConstant(w)&&E.isConstant(A)&&E.isConstant(M)&&E.isConstant(I)){var D=this._options;D.vertexFormat=g?v.VERTEX_FORMAT:f.MaterialSupport.TEXTURED.vertexFormat;var O=d.getValue(c.MINIMUM_VALUE);u(O)&&(O=new h(O));var R=n(y)?y.getValue(c.MINIMUM_VALUE):void 0,L=n(C)?C.getValue(c.MINIMUM_VALUE):void 0;D.polygonHierarchy=O,D.height=R,D.extrudedHeight=L,D.granularity=n(w)?w.getValue(c.MINIMUM_VALUE):void 0,D.stRotation=n(A)?A.getValue(c.MINIMUM_VALUE):void 0,D.perPositionHeight=n(I)?I.getValue(c.MINIMUM_VALUE):void 0,this._outlineWidth=n(M)?M.getValue(c.MINIMUM_VALUE):1,this._isClosed=n(L)&&L!==R,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},I.prototype.createDynamicUpdater=function(e){return new D(e,this)};var D=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new M(t._entity)};return D.prototype.update=function(i){var r=this._primitives;r.removeAndDestroy(this._primitive),r.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,s=a.polygon;if(a.isShowing&&a.isAvailable(i)&&E.getValueOrDefault(s.show,i,!0)){var c=this._options,p=E.getValueOrUndefined(s.hierarchy,i);if(n(p)){if(c.polygonHierarchy=u(p)?new h(p):p,c.height=E.getValueOrUndefined(s.height,i),c.extrudedHeight=E.getValueOrUndefined(s.extrudedHeight,i),c.granularity=E.getValueOrUndefined(s.granularity,i),c.stRotation=E.getValueOrUndefined(s.stRotation,i),c.perPositionHeight=E.getValueOrUndefined(s.perPositionHeight,i),E.getValueOrDefault(s.fill,i,!0)){var _=w.getValue(i,o.fillMaterialProperty,this._material);this._material=_;var y=new f({material:_,translucent:_.isTranslucent(),closed:n(c.extrudedHeight)&&c.extrudedHeight!==c.height});c.vertexFormat=y.vertexFormat,this._primitive=r.add(new g({geometryInstances:new l({id:a,geometry:new d(c)}),appearance:y,asynchronous:!1}))}if(E.getValueOrDefault(s.outline,i,!1)){c.vertexFormat=v.VERTEX_FORMAT;var C=E.getValueOrClonedDefault(s.outlineColor,i,e.BLACK,A),b=E.getValueOrDefault(s.outlineWidth,i,1),S=1!==C.alpha;this._outlinePrimitive=r.add(new g({geometryInstances:new l({id:a,geometry:new m(c),attributes:{color:t.fromColor(C)}}),appearance:new v({flat:!0,translucent:S,renderState:{lineWidth:o._scene.clampLineWidth(b)}}),asynchronous:!1}))}}}},D.prototype.getBoundingSphere=function(e,t){return C(e,this._primitive,this._outlinePrimitive,t)},D.prototype.isDestroyed=function(){return!1},D.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},I}),define("Cesium/Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v){"use strict";function g(e,t,n,r,o){var a=_;a.length=o;var s,l=n.red,u=n.green,c=n.blue,d=n.alpha,h=r.red,m=r.green,p=r.blue,f=r.alpha;if(i.equals(n,r)){for(s=0;o>s;s++)a[s]=i.clone(n);return a}var v=(h-l)/o,g=(m-u)/o,y=(p-c)/o,C=(f-d)/o;for(s=0;o>s;s++)a[s]=new i(l+s*v,u+s*g,c+s*y,d+s*C);return a}var _=[],y=function(e){e=r(e,r.EMPTY_OBJECT);var n=e.positions,a=e.colors,l=r(e.width,1),u=r(e.colorsPerVertex,!1);this._positions=n,this._colors=a,this._width=l,this._colorsPerVertex=u,this._vertexFormat=v.clone(r(e.vertexFormat,v.DEFAULT)),this._followSurface=r(e.followSurface,!0),this._granularity=r(e.granularity,m.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(r(e.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var c=1+n.length*t.packedLength;c+=o(a)?1+a.length*i.packedLength:1,this.packedLength=c+s.packedLength+v.packedLength+4};y.pack=function(e,n,a){a=r(a,0);var l,u=e._positions,c=u.length;for(n[a++]=c,l=0;c>l;++l,a+=t.packedLength)t.pack(u[l],n,a);var d=e._colors;for(c=o(d)?d.length:0,n[a++]=c,l=0;c>l;++l,a+=i.packedLength)i.pack(d[l],n,a);s.pack(e._ellipsoid,n,a),a+=s.packedLength,v.pack(e._vertexFormat,n,a),a+=v.packedLength,n[a++]=e._width,n[a++]=e._colorsPerVertex?1:0,n[a++]=e._followSurface?1:0,n[a]=e._granularity};var C=s.clone(s.UNIT_SPHERE),w=new v,E={positions:void 0,colors:void 0,ellipsoid:C,vertexFormat:w,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};y.unpack=function(e,n,a){n=r(n,0);var l,u=e[n++],c=new Array(u);for(l=0;u>l;++l,n+=t.packedLength)c[l]=t.unpack(e,n);u=e[n++];var d=u>0?new Array(u):void 0;for(l=0;u>l;++l,n+=i.packedLength)d[l]=i.unpack(e,n);var h=s.unpack(e,n,C);n+=s.packedLength;var m=v.unpack(e,n,w);n+=v.packedLength;var p=e[n++],f=1===e[n++],g=1===e[n++],_=e[n];return o(a)?(a._positions=c,a._colors=d,a._ellipsoid=s.clone(h,a._ellipsoid),a._vertexFormat=v.clone(m,a._vertexFormat),a._width=p,a._colorsPerVertex=f,a._followSurface=g,a._granularity=_,a):(E.positions=c,E.colors=d,E.width=p,E.colorsPerVertex=f,E.followSurface=g,E.granularity=_,new y(E))};var b=new t,S=new t,x=new t,T=new t;return y.createGeometry=function(r){var a,s,v,y=r._width,C=r._vertexFormat,w=r._colors,E=r._colorsPerVertex,P=r._followSurface,A=r._granularity,M=r._ellipsoid,I=m.chordLength(A,M.maximumRadius),D=p.removeDuplicates(r._positions);o(D)||(D=r._positions);var O=D.length;if(2>O)return void 0;if(P){var R=p.extractHeights(D,M);if(o(w)){var L=1;for(a=0;O-1>a;++a)L+=p.numberOfPoints(D[a],D[a+1],I);var N=new Array(L),z=0;for(a=0;O-1>a;++a){var F=D[a],B=D[a+1],V=w[a],k=p.numberOfPoints(F,B,I);if(E&&L>a){var U=w[a+1],W=g(F,B,V,U,k),G=W.length;for(s=0;G>s;++s)N[z++]=W[s]}else for(s=0;k>s;++s)N[z++]=i.clone(V)}N[z]=i.clone(w[w.length-1]),w=N,_.length=0}D=p.generateCartesianArc({positions:D,minDistance:I,ellipsoid:M,height:R})}O=D.length;var H,q=4*O-4,j=new Float64Array(3*q),Y=new Float64Array(3*q),X=new Float64Array(3*q),Z=new Float32Array(2*q),J=C.st?new Float32Array(2*q):void 0,K=o(w)?new Uint8Array(4*q):void 0,Q=0,$=0,et=0,tt=0;for(s=0;O>s;++s){0===s?(H=b,t.subtract(D[0],D[1],H),t.add(D[0],H,H)):H=D[s-1],t.clone(H,x),t.clone(D[s],S),s===O-1?(H=b,t.subtract(D[O-1],D[O-2],H),t.add(D[O-1],H,H)):H=D[s+1],t.clone(H,T);var it,nt;o(K)&&(it=0===s||E?w[s]:w[s-1],s!==O-1&&(nt=w[s]));var rt=0===s?2:0,ot=s===O-1?2:4;for(v=rt;ot>v;++v){t.pack(S,j,Q),t.pack(x,Y,Q),t.pack(T,X,Q),Q+=3;var at=0>v-2?-1:1;if(Z[$++]=2*(v%2)-1,Z[$++]=at*y,C.st&&(J[et++]=s/(O-1),J[et++]=Math.max(Z[$-2],0)),o(K)){var st=2>v?it:nt;K[tt++]=i.floatToByte(st.red),K[tt++]=i.floatToByte(st.green),K[tt++]=i.floatToByte(st.blue),K[tt++]=i.floatToByte(st.alpha)}}}var lt=new c;lt.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:j}),lt.prevPosition=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:Y}),lt.nextPosition=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:X}),lt.expandAndWidth=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:Z}),C.st&&(lt.st=new u({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:J})),o(K)&&(lt.color=new u({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:K,normalize:!0}));
var ut=h.createTypedArray(q,6*O-6),ct=0,dt=0,ht=O-1;for(s=0;ht>s;++s)ut[dt++]=ct,ut[dt++]=ct+2,ut[dt++]=ct+1,ut[dt++]=ct+1,ut[dt++]=ct+2,ut[dt++]=ct+3,ct+=4;return new l({attributes:lt,indices:ut,primitiveType:f.TRIANGLES,boundingSphere:e.fromPoints(D),geometryType:d.POLYLINES})},y}),define("Cesium/Shaders/Appearances/PolylineColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec4 color;\n\nvarying vec4 v_color;\n\nvoid main() \n{\n    float expandDir = expandAndWidth.x;\n    float width = abs(expandAndWidth.y) + 0.5;\n    bool usePrev = expandAndWidth.y < 0.0;\n    \n    vec4 p = czm_computePosition();\n    vec4 prev = czm_computePrevPosition();\n    vec4 next = czm_computeNextPosition();\n    \n    v_color = color;\n    \n    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\n    gl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),define("Cesium/Scene/PolylineColorAppearance",["../Core/defaultValue","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/Appearances/PolylineColorAppearanceVS","../Shaders/PolylineCommon","./Appearance"],function(e,t,i,n,r,o,a){"use strict";var s=o+"\n"+r,l=n,u=function(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.translucent,!0),n=!1,r=u.VERTEX_FORMAT;this.material=void 0,this.translucent=i,this._vertexShaderSource=e(t.vertexShaderSource,s),this._fragmentShaderSource=e(t.fragmentShaderSource,l),this._renderState=a.getDefaultRenderState(i,n,t.renderState),this._closed=n,this._vertexFormat=r};return t(u.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}}}),u.VERTEX_FORMAT=i.POSITION_ONLY,u.prototype.getFragmentShaderSource=a.prototype.getFragmentShaderSource,u.prototype.isTranslucent=a.prototype.isTranslucent,u.prototype.getRenderState=a.prototype.getRenderState,u}),define("Cesium/Shaders/Appearances/PolylineMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec2 expandAndWidth;\nattribute vec2 st;\n\nvarying float v_width;\nvarying vec2 v_st;\n\nvoid main() \n{\n    float expandDir = expandAndWidth.x;\n    float width = abs(expandAndWidth.y) + 0.5;\n    bool usePrev = expandAndWidth.y < 0.0;\n    \n    vec4 p = czm_computePosition();\n    vec4 prev = czm_computePrevPosition();\n    vec4 next = czm_computeNextPosition();\n    \n    v_width = width;\n    v_st = st;\n    \n    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\n    gl_Position = czm_viewportOrthographic * positionWC;\n}\n"}),define("Cesium/Scene/PolylineMaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PolylineMaterialAppearanceVS","../Shaders/PolylineCommon","../Shaders/PolylineFS","./Appearance","./Material"],function(e,t,i,n,r,o,a,s,l){"use strict";var u=o+"\n"+r,c=a,d=function(i){i=e(i,e.EMPTY_OBJECT);var n=e(i.translucent,!0),r=!1,o=d.VERTEX_FORMAT;this.material=t(i.material)?i.material:l.fromType(l.ColorType),this.translucent=n,this._vertexShaderSource=e(i.vertexShaderSource,u),this._fragmentShaderSource=e(i.fragmentShaderSource,c),this._renderState=s.getDefaultRenderState(n,r,i.renderState),this._closed=r,this._vertexFormat=o};return i(d.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}}}),d.VERTEX_FORMAT=n.POSITION_AND_ST,d.prototype.getFragmentShaderSource=s.prototype.getFragmentShaderSource,d.prototype.isTranslucent=s.prototype.isTranslucent,d.prototype.getRenderState=s.prototype.getRenderState,d}),define("Cesium/DataSources/PolylineGeometryUpdater",["../Core/BoundingSphere","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/PolylineGeometry","../Core/PolylinePipeline","../Core/ShowGeometryInstanceAttribute","../Scene/PolylineCollection","../Scene/PolylineColorAppearance","../Scene/PolylineMaterialAppearance","./BoundingSphereState","./ColorMaterialProperty","./ConstantProperty","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E){"use strict";var b={},S=new y(t.WHITE),x=new C(!0),T=function(e){this.id=e,this.vertexFormat=void 0,this.positions=void 0,this.width=void 0,this.followSurface=void 0,this.granularity=void 0},P=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(P.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._geometryChanged=new u,this._showProperty=void 0,this._materialProperty=void 0,this._options=new T(e),this._onEntityPropertyChanged(e,"polyline",e.polyline,void 0)};o(P,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:g}}),o(P.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!r(this._entity.availability)&&E.isConstant(this._showProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{value:!1},hasConstantOutline:{value:!0},outlineColorProperty:{value:void 0},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!1},geometryChanged:{get:function(){return this._geometryChanged}}}),P.prototype.isOutlineVisible=function(){return!1},P.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)},P.prototype.createFillGeometryInstance=function(e){var n,o,a=this._entity,s=a.isAvailable(e),l=new p(s&&this._showProperty.getValue(e));if(this._materialProperty instanceof y){var u=t.WHITE;r(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(u=this._materialProperty.color.getValue(e)),n=i.fromColor(u),o={show:l,color:n}}else o={show:l};return new c({id:a,geometry:new h(this._options),attributes:o})},P.prototype.createOutlineGeometryInstance=function(){},P.prototype.isDestroyed=function(){return!1},P.prototype.destroy=function(){this._entitySubscription(),a(this)},P.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"polyline"===t){var i=this._entity.polyline;if(!r(i))return this._fillEnabled&&(this._fillEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=i.positions,a=i.show;if(r(a)&&a.isConstant&&!a.getValue(d.MINIMUM_VALUE)||!r(o))return this._fillEnabled&&(this._fillEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var s=n(i.material,S),l=s instanceof y;this._materialProperty=s,this._showProperty=n(a,x),this._fillEnabled=!0;var u=i.width,c=i.followSurface,h=i.granularity;if(o.isConstant&&E.isConstant(u)&&E.isConstant(c)&&E.isConstant(h)){var m=this._options,p=o.getValue(d.MINIMUM_VALUE,m.positions);if(!r(p)||p.length<2)return this._fillEnabled&&(this._fillEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;m.vertexFormat=l?v.VERTEX_FORMAT:g.VERTEX_FORMAT,m.positions=p,m.width=r(u)?u.getValue(d.MINIMUM_VALUE):void 0,m.followSurface=r(c)?c.getValue(d.MINIMUM_VALUE):void 0,m.granularity=r(h)?h.getValue(d.MINIMUM_VALUE):void 0,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},P.prototype.createDynamicUpdater=function(e){return new A(e,this)};var A=function(e,t){var i=t._scene.id,n=b[i];!r(n)||n.isDestroyed()?(n=new f,b[i]=n,e.add(n)):e.contains(n)||e.add(n);var o=n.add();o.id=t._entity,this._line=o,this._primitives=e,this._geometryUpdater=t,this._positions=[]},M={positions:void 0,granularity:void 0,height:void 0};return A.prototype.update=function(e){var t=this._geometryUpdater,i=t._entity,n=i.polyline,o=this._line;if(!i.isShowing||!i.isAvailable(e)||!E.getValueOrDefault(n._show,e,!0))return o.show=!1,void 0;var a=n.positions,s=E.getValueOrUndefined(a,e,this._positions);if(!r(s)||s.length<2)return o.show=!1,void 0;var l=E.getValueOrDefault(n._followSurface,e,!0);l&&(M.positions=s,M.granularity=E.getValueOrUndefined(n._granularity,e),M.height=m.extractHeights(s,this._geometryUpdater._scene.globe.ellipsoid),s=m.generateCartesianArc(M)),o.show=!0,o.positions=s,o.material=w.getValue(e,t.fillMaterialProperty,o.material),o.width=E.getValueOrDefault(n._width,e,1)},A.prototype.getBoundingSphere=function(t,i){var n=this._line;return n.show&&n.positions.length>0?(e.fromPoints(n.positions,i),_.DONE):_.FAILED},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){var e=this._geometryUpdater,t=e._scene.id,i=b[t];i.remove(this._line),0===i.length&&(this._primitives.removeAndDestroy(i),delete b[t]),a(this)},P}),define("Cesium/Core/PolylineVolumeGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./VertexFormat","./WindingOrder"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";function w(e,i,n,o){var a=new h;o.position&&(a.position=new d({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:e}));var s,l,u,f,g,y,C=i.length,w=e.length/3,E=(w-2*C)/(2*C),b=v.triangulate(i),S=6*(E-1)*C+2*b.length,x=p.createTypedArray(w,S),T=2*C,P=0;for(s=0;E-1>s;s++){for(l=0;C-1>l;l++)u=2*l+2*s*C,y=u+T,f=u+1,g=f+T,x[P++]=f,x[P++]=u,x[P++]=g,x[P++]=g,x[P++]=u,x[P++]=y;u=2*C-2+2*s*C,f=u+1,g=f+T,y=u+T,x[P++]=f,x[P++]=u,x[P++]=g,x[P++]=g,x[P++]=u,x[P++]=y}if(o.st||o.tangent||o.binormal){var A,M,I=new Float32Array(2*w),D=1/(E-1),O=1/n.height,R=n.height/2,L=0;for(s=0;E>s;s++){for(A=s*D,M=O*(i[0].y+R),I[L++]=A,I[L++]=M,l=1;C>l;l++)M=O*(i[l].y+R),I[L++]=A,I[L++]=M,I[L++]=A,I[L++]=M;M=O*(i[0].y+R),I[L++]=A,I[L++]=M}for(l=0;C>l;l++)A=0,M=O*(i[l].y+R),I[L++]=A,I[L++]=M;for(l=0;C>l;l++)A=(E-1)*D,M=O*(i[l].y+R),I[L++]=A,I[L++]=M;a.st=new d({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:new Float32Array(I)})}var N=w-2*C;for(s=0;s<b.length;s+=3){var z=b[s]+N,F=b[s+1]+N,B=b[s+2]+N;x[P++]=z,x[P++]=F,x[P++]=B,x[P++]=B+C,x[P++]=F+C,x[P++]=z+C}var V=new c({attributes:a,indices:x,boundingSphere:t.fromVertices(e),primitiveType:_.TRIANGLES});return o.normal&&(V=m.computeNormal(V)),(o.tangent||o.binormal)&&(V=m.computeBinormalAndTangent(V),o.tangent||(V.attributes.tangent=void 0),o.binormal||(V.attributes.binormal=void 0),o.st||(V.attributes.st=void 0)),V}var E=function(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,r=e.shapePositions;this._positions=t,this._shape=r,this._ellipsoid=u.clone(a(e.ellipsoid,u.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._vertexFormat=y.clone(a(e.vertexFormat,y.DEFAULT)),this._granularity=a(e.granularity,f.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var s=1+t.length*n.packedLength;s+=1+r.length*i.packedLength,this.packedLength=s+u.packedLength+y.packedLength+2};E.pack=function(e,t,r){r=a(r,0);var o,s=e._positions,l=s.length;for(t[r++]=l,o=0;l>o;++o,r+=n.packedLength)n.pack(s[o],t,r);var c=e._shape;for(l=c.length,t[r++]=l,o=0;l>o;++o,r+=i.packedLength)i.pack(c[o],t,r);u.pack(e._ellipsoid,t,r),r+=u.packedLength,y.pack(e._vertexFormat,t,r),r+=y.packedLength,t[r++]=e._cornerType,t[r]=e._granularity};var b=u.clone(u.UNIT_SPHERE),S=new y,x={polylinePositions:void 0,shapePositions:void 0,ellipsoid:b,vertexFormat:S,cornerType:void 0,granularity:void 0};E.unpack=function(e,t,r){t=a(t,0);var o,l=e[t++],c=new Array(l);for(o=0;l>o;++o,t+=n.packedLength)c[o]=n.unpack(e,t);l=e[t++];var d=new Array(l);for(o=0;l>o;++o,t+=i.packedLength)d[o]=i.unpack(e,t);var h=u.unpack(e,t,b);t+=u.packedLength;var m=y.unpack(e,t,S);t+=y.packedLength;var p=e[t++],f=e[t];return s(r)?(r._positions=c,r._shape=d,r._ellipsoid=u.clone(h,r._ellipsoid),r._vertexFormat=y.clone(m,r._vertexFormat),r._cornerType=p,r._granularity=f,r):(x.polylinePositions=c,x.shapePositions=d,x.cornerType=p,x.granularity=f,new E(x))};var T=new e;return E.createGeometry=function(t){var i=t._positions,n=g.removeDuplicatesFromPositions(i,t._ellipsoid),r=t._shape;if(r=g.removeDuplicatesFromShape(r),n.length<2||r.length<3)return void 0;v.computeWindingOrder2D(r)===C.CLOCKWISE&&r.reverse();var o=e.fromPoints(r,T),a=g.computePositions(n,r,o,t,!0);return w(a,r,o,t._vertexFormat)},E}),define("Cesium/Core/PolylineVolumeOutlineGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./WindingOrder"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_){"use strict";function y(e,i){var n=new h;n.position=new d({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:e});var o,a,s=i.length,l=n.position.values.length/3,u=e.length/3,p=u/s,f=m.createTypedArray(l,2*s*(p+1)),v=0;o=0;var _=o*s;for(a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=p-1,_=o*s,a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=0;p-1>o;o++){var y=s*o,C=y+s;for(a=0;s>a;a++)f[v++]=a+y,f[v++]=a+C}var w=new c({attributes:n,indices:m.createTypedArray(l,f),boundingSphere:t.fromVertices(e),primitiveType:g.LINES});return w}var C=function(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,r=e.shapePositions;this._positions=t,this._shape=r,this._ellipsoid=u.clone(a(e.ellipsoid,u.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._granularity=a(e.granularity,p.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var s=1+t.length*n.packedLength;s+=1+r.length*i.packedLength,this.packedLength=s+u.packedLength+2};C.pack=function(e,t,r){r=a(r,0);var o,s=e._positions,l=s.length;for(t[r++]=l,o=0;l>o;++o,r+=n.packedLength)n.pack(s[o],t,r);var c=e._shape;for(l=c.length,t[r++]=l,o=0;l>o;++o,r+=i.packedLength)i.pack(c[o],t,r);u.pack(e._ellipsoid,t,r),r+=u.packedLength,t[r++]=e._cornerType,t[r]=e._granularity};var w=u.clone(u.UNIT_SPHERE),E={polylinePositions:void 0,shapePositions:void 0,ellipsoid:w,height:void 0,cornerType:void 0,granularity:void 0};C.unpack=function(e,t,r){t=a(t,0);var o,l=e[t++],c=new Array(l);for(o=0;l>o;++o,t+=n.packedLength)c[o]=n.unpack(e,t);l=e[t++];var d=new Array(l);for(o=0;l>o;++o,t+=i.packedLength)d[o]=i.unpack(e,t);var h=u.unpack(e,t,w);t+=u.packedLength;var m=e[t++],p=e[t];return s(r)?(r._positions=c,r._shape=d,r._ellipsoid=u.clone(h,r._ellipsoid),r._cornerType=m,r._granularity=p,r):(E.polylinePositions=c,E.shapePositions=d,E.cornerType=m,E.granularity=p,new C(E))};var b=new e;return C.createGeometry=function(t){var i=t._positions,n=v.removeDuplicatesFromPositions(i,t._ellipsoid),r=t._shape;if(r=v.removeDuplicatesFromShape(r),n.length<2||r.length<3)return void 0;f.computeWindingOrder2D(r)===_.CLOCKWISE&&r.reverse();var o=e.fromPoints(r,b),a=v.computePositions(n,r,o,t,!1);return y(a,r)},C}),define("Cesium/DataSources/PolylineVolumeGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/PolylineVolumeGeometry","../Core/PolylineVolumeOutlineGeometry","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(e.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(e.BLACK),T=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.polylinePositions=void 0,this.shapePositions=void 0,this.cornerType=void 0,this.granularity=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new s,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"polylineVolume",e.polylineVolume,void 0)};r(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),r(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(i){var r,o,a=this._entity,s=a.isAvailable(i),u=new h(s&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var d=e.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(d=this._materialProperty.color.getValue(i)),o=t.fromColor(d),r={show:u,color:o}}else r={show:u};return new l({id:a,geometry:new c(this._options),attributes:r})},A.prototype.createOutlineGeometryInstance=function(i){var n=this._entity,r=n.isAvailable(i),o=C.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new l({id:n,geometry:new d(this._options),attributes:{show:new h(r&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(o)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),o(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"polylineVolume"===t){var r=this._entity.polylineVolume;if(!n(r))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=r.fill,a=n(o)&&o.isConstant?o.getValue(u.MINIMUM_VALUE):!0,s=r.outline,l=n(s);if(l&&s.isConstant&&(l=s.getValue(u.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var c=r.positions,d=r.shape,h=r.show;if(!n(c)||!n(d)||n(h)&&h.isConstant&&!h.getValue(u.MINIMUM_VALUE))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var f=i(r.material,w),g=f instanceof v;this._materialProperty=f,this._fillProperty=i(o,b),this._showProperty=i(h,E),this._showOutlineProperty=i(r.outline,S),this._outlineColorProperty=l?i(r.outlineColor,x):void 0;var _=r.granularity,y=r.outlineWidth,T=r.cornerType;if(this._fillEnabled=a,this._outlineEnabled=l,c.isConstant&&d.isConstant&&C.isConstant(_)&&C.isConstant(y)&&C.isConstant(T)){var P=this._options;P.vertexFormat=g?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,P.polylinePositions=c.getValue(u.MINIMUM_VALUE,P.polylinePositions),P.shapePositions=d.getValue(u.MINIMUM_VALUE,P.shape),P.granularity=n(_)?_.getValue(u.MINIMUM_VALUE):void 0,P.cornerType=n(T)?T.getValue(u.MINIMUM_VALUE):void 0,this._outlineWidth=n(y)?y.getValue(u.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(i){var r=this._primitives;r.removeAndDestroy(this._primitive),r.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,s=a.polylineVolume;if(a.isShowing&&a.isAvailable(i)&&C.getValueOrDefault(s.show,i,!0)){var u=this._options,h=C.getValueOrUndefined(s.positions,i,u.polylinePositions),v=C.getValueOrUndefined(s.shape,i);if(n(h)&&n(v)){if(u.polylinePositions=h,u.shapePositions=v,u.granularity=C.getValueOrUndefined(s.granularity,i),u.cornerType=C.getValueOrUndefined(s.cornerType,i),!n(s.fill)||s.fill.getValue(i)){var g=y.getValue(i,o.fillMaterialProperty,this._material);this._material=g;var _=new m({material:g,translucent:g.isTranslucent(),closed:!0});u.vertexFormat=_.vertexFormat,this._primitive=r.add(new f({geometryInstances:new l({id:a,geometry:new c(u)}),appearance:_,asynchronous:!1}))}if(n(s.outline)&&s.outline.getValue(i)){u.vertexFormat=p.VERTEX_FORMAT;var w=C.getValueOrClonedDefault(s.outlineColor,i,e.BLACK,T),E=C.getValueOrDefault(s.outlineWidth,i,1),b=1!==w.alpha;this._outlinePrimitive=r.add(new f({geometryInstances:new l({id:a,geometry:new d(u),attributes:{color:t.fromColor(w)}}),appearance:new p({flat:!0,translucent:b,renderState:{lineWidth:o._scene.clampLineWidth(E)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},A}),define("Cesium/Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,i,n,r,o,a,s){"use strict";var l=Math.cos,u=Math.sin,c=Math.sqrt,d={};d.computePosition=function(e,t,n,r,o){var s=e.ellipsoid.radiiSquared,d=e.nwCorner,h=e.rectangle,m=d.latitude-e.granYCos*t+n*e.granXSin,p=l(m),f=u(m),v=s.z*f,g=d.longitude+t*e.granYSin+n*e.granXCos,_=p*l(g),y=p*u(g),C=s.x*_,w=s.y*y,E=c(C*_+w*y+v*f);r.x=C/E,r.y=w/E,r.z=v/E,i(e.vertexFormat)&&e.vertexFormat.st&&(o.x=(g-h.west)*e.lonScalar-.5,o.y=(m-h.south)*e.latScalar-.5,a.multiplyByVector(e.textureMatrix,o,o),o.x+=.5,o.y+=.5)};var h=new a,m=new e,p=new t,f=new e,v=new r;return d.computeOptions=function(t,r,l){var u,c,d,g,_,y=t._granularity,C=t._ellipsoid,w=t._surfaceHeight,E=t._rotation,b=t._extrudedHeight,S=r.east,x=r.west,T=r.north,P=r.south,A=T-P;x>S?(_=o.TWO_PI-x+S,u=Math.ceil(_/y)+1,c=Math.ceil(A/y)+1,d=_/(u-1),g=A/(c-1)):(_=S-x,u=Math.ceil(_/y)+1,c=Math.ceil(A/y)+1,d=_/(u-1),g=A/(c-1)),l=s.northwest(r,l);var M=s.center(r,p),I=g,D=d,O=0,R=0;if(i(E)){var L=Math.cos(E);I*=L,D*=L;var N=Math.sin(E);O=g*N,R=d*N,m=v.project(l,m),f=v.project(M,f),m=e.subtract(m,f,m);var z=a.fromRotation(E,h);m=a.multiplyByVector(z,m,m),m=e.add(m,f,m),l=v.unproject(m,l);var F=l.latitude,B=F+(u-1)*R,V=F-I*(c-1),k=F-I*(c-1)+(u-1)*R;T=Math.max(F,B,V,k),P=Math.min(F,B,V,k);var U=l.longitude,W=U+(u-1)*D,G=U+(c-1)*O,H=U+(c-1)*O+(u-1)*D;if(S=Math.max(U,W,G,H),x=Math.min(U,W,G,H),T<-o.PI_OVER_TWO||T>o.PI_OVER_TWO||P<-o.PI_OVER_TWO||P>o.PI_OVER_TWO)throw new n("Rotated extent is invalid.");r.north=T,r.south=P,r.east=S,r.west=x}return{granYCos:I,granYSin:O,granXCos:D,granXSin:R,ellipsoid:C,width:u,height:c,surfaceHeight:w,extrudedHeight:b,nwCorner:l,rectangle:r}},d}),define("Cesium/Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b){"use strict";function S(e,t){var i=new u({attributes:new d,primitiveType:y.TRIANGLES});return i.attributes.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(i.attributes.normal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(i.attributes.tangent=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(i.attributes.binormal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:t.binormals})),i}function x(e,t,n,r){for(var o=e.length,a=t.normal?new Float32Array(o):void 0,s=t.tangent?new Float32Array(o):void 0,l=t.binormal?new Float32Array(o):void 0,u=0,c=L,d=R,h=O,m=0;o>m;m+=3){var p=i.fromArray(e,m,D),f=u+1,v=u+2;(t.normal||t.tangent||t.binormal)&&(h=n.geodeticSurfaceNormal(p,h),(t.tangent||t.binormal)&&(i.cross(i.UNIT_Z,h,d),g.multiplyByVector(r,d,d),i.normalize(d,d),t.binormal&&i.normalize(i.cross(h,d,c),c)),t.normal&&(a[u]=h.x,a[f]=h.y,a[v]=h.z),t.tangent&&(s[u]=d.x,s[f]=d.y,s[v]=d.z),t.binormal&&(l[u]=c.x,l[f]=c.y,l[v]=c.z)),u+=3}return S(t,{positions:e,normals:a,tangents:s,binormals:l})}function T(e,t,n){for(var r=e.length,o=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,s=t.binormal?new Float32Array(r):void 0,l=0,u=0,c=0,d=!0,h=L,m=R,p=O,v=0;r>v;v+=6){var g=i.fromArray(e,v,D);if(t.normal||t.tangent||t.binormal){var _=i.fromArray(e,(v+6)%r,V);if(d){var y=i.fromArray(e,(v+3)%r,k);i.subtract(_,g,_),i.subtract(y,g,y),p=i.normalize(i.cross(y,_,p),p),d=!1}i.equalsEpsilon(_,g,f.EPSILON10)&&(d=!0),(t.tangent||t.binormal)&&(h=n.geodeticSurfaceNormal(g,h),t.tangent&&(m=i.normalize(i.cross(h,p,m),m))),t.normal&&(o[l++]=p.x,o[l++]=p.y,o[l++]=p.z,o[l++]=p.x,o[l++]=p.y,o[l++]=p.z),t.tangent&&(a[u++]=m.x,a[u++]=m.y,a[u++]=m.z,a[u++]=m.x,a[u++]=m.y,a[u++]=m.z),t.binormal&&(s[c++]=h.x,s[c++]=h.y,s[c++]=h.z,s[c++]=h.x,s[c++]=h.y,s[c++]=h.z)}}return S(t,{positions:e,normals:o,tangents:a,binormals:s})}function P(e){for(var t=e.vertexFormat,i=e.ellipsoid,n=e.size,o=e.height,a=e.width,s=t.position?new Float64Array(3*n):void 0,l=t.st?new Float32Array(2*n):void 0,u=0,d=0,h=D,m=z,f=Number.MAX_VALUE,v=Number.MAX_VALUE,g=Number.MIN_VALUE,_=Number.MIN_VALUE,y=0;o>y;++y)for(var C=0;a>C;++C)E.computePosition(e,y,C,h,m),s[u++]=h.x,s[u++]=h.y,s[u++]=h.z,t.st&&(l[d++]=m.x,l[d++]=m.y,f=Math.min(f,m.x),v=Math.min(v,m.y),g=Math.max(g,m.x),_=Math.max(_,m.y));if(t.st&&(0>f||0>v||g>1||_>1))for(var w=0;w<l.length;w+=2)l[w]=(l[w]-f)/(g-f),l[w+1]=(l[w+1]-v)/(_-v);for(var b=x(s,t,i,e.tangentRotationMatrix),S=6*(a-1)*(o-1),T=p.createTypedArray(n,S),P=0,A=0,M=0;o-1>M;++M){for(var I=0;a-1>I;++I){var O=P,R=O+a,L=R+1,N=O+1;T[A++]=O,T[A++]=R,T[A++]=N,T[A++]=N,T[A++]=R,T[A++]=L,++P}++P}return b.indices=T,t.st&&(b.attributes.st=new c({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:l})),b}function A(e,t,i,n,r){return e[t++]=n[i],e[t++]=n[i+1],e[t++]=n[i+2],e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],e}function M(e,t,i,n){return e[t++]=n[i],e[t++]=n[i+1],e[t++]=n[i],e[t++]=n[i+1],e}function I(e){var t,n=e.vertexFormat,o=e.surfaceHeight,a=e.extrudedHeight,s=Math.min(a,o),l=Math.max(a,o),u=e.height,d=e.width,v=e.ellipsoid,g=P(e);if(f.equalsEpsilon(s,l,.1))return g;g=_.scaleToGeodeticHeight(g,l,v,!1);var y=new Float64Array(g.attributes.position.values),C=y.length,w=2*C,E=new Float64Array(w);E.set(y),g=_.scaleToGeodeticHeight(g,s,v);var b=g.attributes.position.values;E.set(b,C),g.attributes.position.values=E;var S,x=n.normal?new Float32Array(w):void 0,I=n.tangent?new Float32Array(w):void 0,D=n.binormal?new Float32Array(w):void 0,O=n.st?new Float32Array(2*(w/3)):void 0;if(n.normal){var R=g.attributes.normal.values;for(x.set(R),t=0;C>t;t++)R[t]=-R[t];x.set(R,C),g.attributes.normal.values=x}if(n.tangent){var L=g.attributes.tangent.values;for(I.set(L),t=0;C>t;t++)L[t]=-L[t];I.set(L,C),g.attributes.tangent.values=I}if(n.binormal){var N=g.attributes.binormal.values;D.set(N),D.set(N,C),g.attributes.binormal.values=D}n.st&&(S=g.attributes.st.values,O.set(S),O.set(S,2*(C/3)),g.attributes.st.values=O);var z=g.indices,F=z.length,B=C/3,U=p.createTypedArray(w/3,2*F);for(U.set(z),t=0;F>t;t+=3)U[t+F]=z[t+2]+B,U[t+1+F]=z[t+1]+B,U[t+2+F]=z[t]+B;g.indices=U;var W=2*d+2*u-4,G=2*(W+4),H=new Float64Array(3*G),q=n.st?new Float32Array(2*G):void 0,j=0,Y=0,X=d*u;for(t=0;X>t;t+=d)H=A(H,j,3*t,y,b),j+=6,n.st&&(q=M(q,Y,2*t,S),Y+=4);for(t=X-d;X>t;t++)H=A(H,j,3*t,y,b),j+=6,n.st&&(q=M(q,Y,2*t,S),Y+=4);for(t=X-1;t>0;t-=d)H=A(H,j,3*t,y,b),j+=6,n.st&&(q=M(q,Y,2*t,S),Y+=4);for(t=d-1;t>=0;t--)H=A(H,j,3*t,y,b),j+=6,n.st&&(q=M(q,Y,2*t,S),Y+=4);var Z=T(H,n,v);n.st&&(Z.attributes.st=new c({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:q}));var J,K,Q,$,et=p.createTypedArray(G,6*W);C=H.length/3;var tt=0;for(t=0;C-1>t;t+=2){J=t,$=(J+2)%C;var it=i.fromArray(H,3*J,V),nt=i.fromArray(H,3*$,k);i.equalsEpsilon(it,nt,f.EPSILON10)||(K=(J+1)%C,Q=(K+2)%C,et[tt++]=J,et[tt++]=K,et[tt++]=$,et[tt++]=$,et[tt++]=K,et[tt++]=Q)}return Z.indices=et,Z=m.combineInstances([new h({geometry:g}),new h({geometry:Z})]),Z[0]}var D=new i,O=new i,R=new i,L=new i,N=new w,z=new t,F=new e,B=new e,V=new i,k=new i,U=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.rectangle,i=o(e.granularity,f.RADIANS_PER_DEGREE),n=o(e.ellipsoid,l.WGS84),r=o(e.height,0),s=o(e.rotation,0),u=o(e.stRotation,0),c=o(e.vertexFormat,b.DEFAULT),d=e.extrudedHeight,h=a(d)&&Math.abs(r-d)>1,m=o(e.closeTop,!0),p=o(e.closeBottom,!0);this._rectangle=t,this._granularity=i,this._ellipsoid=l.clone(n),this._surfaceHeight=r,this._rotation=s,this._stRotation=u,this._vertexFormat=b.clone(c),this._extrudedHeight=o(d,0),this._extrude=h,this._closeTop=m,this._closeBottom=p,this._workerName="createRectangleGeometry"};U.packedLength=w.packedLength+l.packedLength+b.packedLength+8,U.pack=function(e,t,i){i=o(i,0),w.pack(e._rectangle,t,i),i+=w.packedLength,l.pack(e._ellipsoid,t,i),i+=l.packedLength,b.pack(e._vertexFormat,t,i),i+=b.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._extrudedHeight,t[i++]=e._extrude?1:0,t[i++]=e._closeTop?1:0,t[i]=e._closeBottom?1:0};var W=new w,G=l.clone(l.UNIT_SPHERE),H=new b,q={rectangle:W,ellipsoid:G,vertexFormat:H,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0};U.unpack=function(e,t,i){t=o(t,0);var n=w.unpack(e,t,W);t+=w.packedLength;var r=l.unpack(e,t,G);t+=l.packedLength;var s=b.unpack(e,t,H);t+=b.packedLength;
var u=e[t++],c=e[t++],d=e[t++],h=e[t++],m=e[t++],p=1===e[t++],f=1===e[t++],v=1===e[t];return a(i)?(i._rectangle=w.clone(n,i._rectangle),i._ellipsoid=l.clone(r,i._ellipsoid),i._vertexFormat=b.clone(s,i._vertexFormat),i._granularity=u,i._surfaceHeight=c,i._rotation=d,i._stRotation=h,i._extrudedHeight=p?m:void 0,i._extrude=p,i._closeTop=f,i._closeBottom=v,i):(q.granularity=u,q.height=c,q.rotation=d,q.stRotation=h,q.extrudedHeight=p?m:void 0,q.closeTop=f,q.closeBottom=v,new U(q))};var j=new v,Y=new g,X=new n,Z=new C,J=new n;return U.createGeometry=function(t){var n=w.clone(t._rectangle,N),r=t._ellipsoid,o=t._surfaceHeight,s=t._extrude,l=t._extrudedHeight,c=t._stRotation,h=t._vertexFormat,m=E.computeOptions(t,n,X),p=j,f=Y;if(a(c)){v.fromRotation(-c,p);var y=w.center(n,J),b=r.cartographicToCartesian(y,V);i.normalize(b,b),C.fromAxisAngle(b,-c,Z),g.fromQuaternion(Z,f)}else v.clone(v.IDENTITY,p),g.clone(g.IDENTITY,f);m.lonScalar=1/n.width,m.latScalar=1/n.height,m.vertexFormat=h,m.textureMatrix=p,m.tangentRotationMatrix=f,m.size=m.width*m.height;var S,x;if(n=t._rectangle,s){S=I(m);var T=e.fromRectangle3D(n,r,o,B),A=e.fromRectangle3D(n,r,l,F);x=e.union(T,A)}else S=P(m),S=_.scaleToGeodeticHeight(S,o,r,!1),x=e.fromRectangle3D(n,r,o);return h.position||delete S.attributes.position,new u({attributes:new d(S.attributes),indices:S.indices,primitiveType:S.primitiveType,boundingSphere:x})},U}),define("Cesium/Core/RectangleOutlineGeometry",["./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Rectangle","./RectangleGeometryLibrary"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v){"use strict";function g(e){var t,i=e.size,r=e.height,o=e.width,a=new Float64Array(3*i),s=0,h=0,m=w;for(t=0;o>t;t++)v.computePosition(e,h,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(t=o-1,h=1;r>h;h++)v.computePosition(e,h,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(h=r-1,t=o-2;t>=0;t--)v.computePosition(e,h,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(t=0,h=r-2;h>0;h--)v.computePosition(e,h,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(var f=2*(a.length/3),g=d.createTypedArray(a.length/3,f),_=0,y=0;y<a.length/3-1;y++)g[_++]=y,g[_++]=y+1;g[_++]=a.length/3-1,g[_++]=0;var C=new l({attributes:new c,primitiveType:p.LINES});return C.attributes.position=new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:a}),C.indices=g,C}function _(e){var t=e.surfaceHeight,i=e.extrudedHeight,n=e.ellipsoid,r=Math.min(i,t),o=Math.max(i,t),a=g(e);if(h.equalsEpsilon(r,o,.1))return a;var s=e.height,l=e.width;a=m.scaleToGeodeticHeight(a,o,n,!1);var u=a.attributes.position.values,c=u.length,p=new Float64Array(2*c);p.set(u),a=m.scaleToGeodeticHeight(a,r,n);var f=a.attributes.position.values;p.set(f,c),a.attributes.position.values=p;var v=2*(p.length/3)+8,_=d.createTypedArray(p.length/3,v);c=p.length/6;for(var y=0,C=0;c-1>C;C++)_[y++]=C,_[y++]=C+1,_[y++]=C+c,_[y++]=C+c+1;return _[y++]=c-1,_[y++]=0,_[y++]=c+c-1,_[y++]=c,_[y++]=0,_[y++]=c,_[y++]=l-1,_[y++]=c+l-1,_[y++]=l+s-2,_[y++]=l+s-2+c,_[y++]=2*l+s-3,_[y++]=2*l+s-3+c,a.indices=_,a}var y=new e,C=new e,w=new t,E=new f,b=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.rectangle,i=r(e.granularity,h.RADIANS_PER_DEGREE),n=r(e.ellipsoid,s.WGS84),o=r(e.height,0),a=r(e.rotation,0),l=e.extrudedHeight;this._rectangle=t,this._granularity=i,this._ellipsoid=n,this._surfaceHeight=o,this._rotation=a,this._extrudedHeight=l,this._workerName="createRectangleOutlineGeometry"};b.packedLength=f.packedLength+s.packedLength+5,b.pack=function(e,t,i){i=r(i,0),f.pack(e._rectangle,t,i),i+=f.packedLength,s.pack(e._ellipsoid,t,i),i+=s.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=o(e._extrudedHeight)?1:0,t[i]=r(e._extrudedHeight,0)};var S=new f,x=s.clone(s.UNIT_SPHERE),T={rectangle:S,ellipsoid:x,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0};b.unpack=function(e,t,i){t=r(t,0);var n=f.unpack(e,t,S);t+=f.packedLength;var a=s.unpack(e,t,x);t+=s.packedLength;var l=e[t++],u=e[t++],c=e[t++],d=e[t++],h=e[t];return o(i)?(i._rectangle=f.clone(n,i._rectangle),i._ellipsoid=s.clone(a,i._ellipsoid),i._surfaceHeight=u,i._rotation=c,i._extrudedHeight=d?h:void 0,i):(T.granularity=l,T.height=u,T.rotation=c,T.extrudedHeight=d?h:void 0,new b(T))};var P=new i;return b.createGeometry=function(t){var i=f.clone(t._rectangle,E),n=t._ellipsoid,r=t._surfaceHeight,a=t._extrudedHeight,s=v.computeOptions(t,i,P);s.size=2*s.width+2*s.height-4;var u,c;if(i=t._rectangle,o(a)){u=_(s);var d=e.fromRectangle3D(i,n,r,C),h=e.fromRectangle3D(i,n,a,y);c=e.union(d,h)}else u=g(s),u=m.scaleToGeodeticHeight(u,r,n,!1),c=e.fromRectangle3D(i,n,r);return new l({attributes:u.attributes,indices:u.indices,primitiveType:p.LINES,boundingSphere:c})},b}),define("Cesium/DataSources/RectangleGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/RectangleGeometry","../Core/RectangleOutlineGeometry","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(e.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(e.BLACK),T=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.rectangle=void 0,this.closeBottom=void 0,this.closeTop=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0,this.rotation=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new s,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"rectangle",e.rectangle,void 0)};r(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),r(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(i){var r,o,a=this._entity,s=a.isAvailable(i),u=new h(s&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var d=e.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(d=this._materialProperty.color.getValue(i)),o=t.fromColor(d),r={show:u,color:o}}else r={show:u};return new l({id:a,geometry:new c(this._options),attributes:r})},A.prototype.createOutlineGeometryInstance=function(i){var n=this._entity,r=n.isAvailable(i),o=C.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new l({id:n,geometry:new d(this._options),attributes:{show:new h(r&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(o)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),o(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"rectangle"===t){var r=this._entity.rectangle;if(!n(r))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=r.fill,a=n(o)&&o.isConstant?o.getValue(u.MINIMUM_VALUE):!0,s=r.outline,l=n(s);if(l&&s.isConstant&&(l=s.getValue(u.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var c=r.coordinates,d=r.show;if(n(d)&&d.isConstant&&!d.getValue(u.MINIMUM_VALUE)||!n(c))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var h=i(r.material,w),f=h instanceof v;this._materialProperty=h,this._fillProperty=i(o,b),this._showProperty=i(d,E),this._showOutlineProperty=i(r.outline,S),this._outlineColorProperty=l?i(r.outlineColor,x):void 0;var g=r.height,_=r.extrudedHeight,y=r.granularity,T=r.stRotation,P=r.rotation,A=r.outlineWidth,M=r.closeBottom,I=r.closeTop;if(this._fillEnabled=a,this._outlineEnabled=l,c.isConstant&&C.isConstant(g)&&C.isConstant(_)&&C.isConstant(y)&&C.isConstant(T)&&C.isConstant(P)&&C.isConstant(A)&&C.isConstant(M)&&C.isConstant(I)){var D=this._options;D.vertexFormat=f?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,D.rectangle=c.getValue(u.MINIMUM_VALUE,D.rectangle),D.height=n(g)?g.getValue(u.MINIMUM_VALUE):void 0,D.extrudedHeight=n(_)?_.getValue(u.MINIMUM_VALUE):void 0,D.granularity=n(y)?y.getValue(u.MINIMUM_VALUE):void 0,D.stRotation=n(T)?T.getValue(u.MINIMUM_VALUE):void 0,D.rotation=n(P)?P.getValue(u.MINIMUM_VALUE):void 0,D.closeBottom=n(M)?M.getValue(u.MINIMUM_VALUE):void 0,D.closeTop=n(I)?I.getValue(u.MINIMUM_VALUE):void 0,this._isClosed=n(_)&&n(D.closeTop)&&n(D.closeBottom)&&D.closeTop&&D.closeBottom,this._outlineWidth=n(A)?A.getValue(u.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(i){var r=this._primitives;r.removeAndDestroy(this._primitive),r.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,s=a.rectangle;if(a.isShowing&&a.isAvailable(i)&&C.getValueOrDefault(s.show,i,!0)){var u=this._options,h=C.getValueOrUndefined(s.coordinates,i,u.rectangle);if(n(h)){if(u.rectangle=h,u.height=C.getValueOrUndefined(s.height,i),u.extrudedHeight=C.getValueOrUndefined(s.extrudedHeight,i),u.granularity=C.getValueOrUndefined(s.granularity,i),u.stRotation=C.getValueOrUndefined(s.stRotation,i),u.rotation=C.getValueOrUndefined(s.rotation,i),u.closeBottom=C.getValueOrUndefined(s.closeBottom,i),u.closeTop=C.getValueOrUndefined(s.closeTop,i),C.getValueOrDefault(s.fill,i,!0)){var v=y.getValue(i,o.fillMaterialProperty,this._material);this._material=v;var g=new m({material:v,translucent:v.isTranslucent(),closed:n(u.extrudedHeight)});u.vertexFormat=g.vertexFormat,this._primitive=r.add(new f({geometryInstances:new l({id:a,geometry:new c(u)}),appearance:g,asynchronous:!1}))}if(C.getValueOrDefault(s.outline,i,!1)){u.vertexFormat=p.VERTEX_FORMAT;var _=C.getValueOrClonedDefault(s.outlineColor,i,e.BLACK,T),w=C.getValueOrDefault(s.outlineWidth,i,1),E=1!==_.alpha;this._outlinePrimitive=r.add(new f({geometryInstances:new l({id:a,geometry:new d(u),attributes:{color:t.fromColor(_)}}),appearance:new p({flat:!0,translucent:E,renderState:{lineWidth:o._scene.clampLineWidth(w)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},A}),define("Cesium/Core/WallGeometryLibrary",["./Cartographic","./defined","./DeveloperError","./EllipsoidTangentPlane","./Math","./PolygonPipeline","./PolylinePipeline","./WindingOrder"],function(e,t,i,n,r,o,a,s){"use strict";function l(e,t){return r.equalsEpsilon(e.latitude,t.latitude,r.EPSILON14)&&r.equalsEpsilon(e.longitude,t.longitude,r.EPSILON14)}function u(i,n,r,o){var a=n.length;if(2>a)return{positions:n};var s=t(o),u=t(r),c=new Array(a),m=new Array(a),p=new Array(a),f=n[0];c[0]=f;var v=i.cartesianToCartographic(f,d);u&&(v.height=r[0]),m[0]=v.height,p[0]=s?o[0]:0;for(var g=1,_=1;a>_;++_){var y=n[_],C=i.cartesianToCartographic(y,h);u&&(C.height=r[_]),l(v,C)?v.height<C.height&&(m[g-1]=C.height):(c[g]=y,m[g]=C.height,p[g]=s?o[_]:0,e.clone(C,v),++g)}return c.length=g,m.length=g,p.length=g,{positions:c,topHeights:m,bottomHeights:p}}var c={},d=new e,h=new e,m=new Array(2),p=new Array(2),f={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};return c.computePositions=function(e,t,i,l,c,d){var h=u(e,t,i,l);if(t=h.positions,i=h.topHeights,l=h.bottomHeights,t.length<2)return void 0;if(t.length>=3){var v=n.fromPoints(t,e),g=v.projectPointsOntoPlane(t);o.computeWindingOrder2D(g)===s.CLOCKWISE&&(t.reverse(),i.reverse(),l.reverse())}var _,y,C=t.length,w=r.chordLength(c,e.maximumRadius),E=f;if(E.minDistance=w,E.ellipsoid=e,d){var b,S=0;for(b=0;C-1>b;b++)S+=a.numberOfPoints(t[b],t[b+1],w)+1;_=new Float64Array(3*S),y=new Float64Array(3*S);var x=m,T=p;E.positions=x,E.height=T;var P=0;for(b=0;C-1>b;b++){x[0]=t[b],x[1]=t[b+1],T[0]=i[b],T[1]=i[b+1];var A=a.generateArc(E);_.set(A,P),T[0]=l[b],T[1]=l[b+1],y.set(a.generateArc(E),P),P+=A.length}}else E.positions=t,E.height=i,_=new Float64Array(a.generateArc(E)),E.height=l,y=new Float64Array(a.generateArc(E));return{bottomPositions:y,topPositions:_}},c}),define("Cesium/Core/WallGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat","./WallGeometryLibrary"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p){"use strict";var f=new t,v=new t,g=new t,_=new t,y=new t,C=new t,w=new t,E=new t,b=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.positions,o=e.maximumHeights,s=e.minimumHeights,l=n(e.vertexFormat,m.DEFAULT),u=n(e.granularity,d.RADIANS_PER_DEGREE),c=n(e.ellipsoid,a.WGS84);this._positions=i,this._minimumHeights=s,this._maximumHeights=o,this._vertexFormat=m.clone(l),this._granularity=u,this._ellipsoid=a.clone(c),this._workerName="createWallGeometry";var h=1+i.length*t.packedLength+2;r(s)&&(h+=s.length),r(o)&&(h+=o.length),this.packedLength=h+a.packedLength+m.packedLength+1};b.pack=function(e,i,o){o=n(o,0);var s,l=e._positions,u=l.length;for(i[o++]=u,s=0;u>s;++s,o+=t.packedLength)t.pack(l[s],i,o);var c=e._minimumHeights;if(u=r(c)?c.length:0,i[o++]=u,r(c))for(s=0;u>s;++s)i[o++]=c[s];var d=e._maximumHeights;if(u=r(d)?d.length:0,i[o++]=u,r(d))for(s=0;u>s;++s)i[o++]=d[s];a.pack(e._ellipsoid,i,o),o+=a.packedLength,m.pack(e._vertexFormat,i,o),o+=m.packedLength,i[o]=e._granularity};var S=a.clone(a.UNIT_SPHERE),x=new m,T={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:S,vertexFormat:x,granularity:void 0};return b.unpack=function(e,i,o){i=n(i,0);var s,l=e[i++],u=new Array(l);for(s=0;l>s;++s,i+=t.packedLength)u[s]=t.unpack(e,i);l=e[i++];var c;if(l>0)for(c=new Array(l),s=0;l>s;++s)c[s]=e[i++];l=e[i++];var d;if(l>0)for(d=new Array(l),s=0;l>s;++s)d[s]=e[i++];var h=a.unpack(e,i,S);i+=a.packedLength;var p=m.unpack(e,i,x);i+=m.packedLength;var f=e[i];return r(o)?(o._positions=u,o._minimumHeights=c,o._maximumHeights=d,o._ellipsoid=a.clone(h,o._ellipsoid),o._vertexFormat=m.clone(p,o._vertexFormat),o._granularity=f,o):(T.positions=u,T.minimumHeights=c,T.maximumHeights=d,T.granularity=f,new b(T))},b.fromConstantHeights=function(e){e=n(e,n.EMPTY_OBJECT);var t,i,o=e.positions,a=e.minimumHeight,s=e.maximumHeight,l=r(a),u=r(s);if(l||u){var c=o.length;t=l?new Array(c):void 0,i=u?new Array(c):void 0;for(var d=0;c>d;++d)l&&(t[d]=a),u&&(i[d]=s)}var h={positions:o,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat};return new b(h)},b.createGeometry=function(n){var o=n._positions,a=n._minimumHeights,m=n._maximumHeights,b=n._vertexFormat,S=n._granularity,x=n._ellipsoid,T=p.computePositions(x,o,m,a,S,!0);if(!r(T))return void 0;var P=T.bottomPositions,A=T.topPositions,M=A.length,I=2*M,D=b.position?new Float64Array(I):void 0,O=b.normal?new Float32Array(I):void 0,R=b.tangent?new Float32Array(I):void 0,L=b.binormal?new Float32Array(I):void 0,N=b.st?new Float32Array(2*(I/3)):void 0,z=0,F=0,B=0,V=0,k=0,U=E,W=w,G=C,H=!0;M/=3;var q;for(q=0;M>q;++q){var j=3*q,Y=t.fromArray(A,j,f),X=t.fromArray(P,j,v);if(b.position&&(D[z++]=X.x,D[z++]=X.y,D[z++]=X.z,D[z++]=Y.x,D[z++]=Y.y,D[z++]=Y.z),b.normal||b.tangent||b.binormal){var Z,J=t.clone(t.ZERO,y),K=x.scaleToGeodeticSurface(t.fromArray(A,j,v),v);if(M>q+1&&(Z=x.scaleToGeodeticSurface(t.fromArray(A,j+3,g),g),J=t.fromArray(A,j+3,y)),H){var Q=t.subtract(J,Y,_),$=t.subtract(K,Y,f);U=t.normalize(t.cross($,Q,U),U),H=!1}t.equalsEpsilon(Z,K,d.EPSILON6)?H=!0:(b.tangent&&(W=t.normalize(t.subtract(Z,K,W),W)),b.binormal&&(G=t.normalize(t.cross(U,W,G),G))),b.normal&&(O[F++]=U.x,O[F++]=U.y,O[F++]=U.z,O[F++]=U.x,O[F++]=U.y,O[F++]=U.z),b.tangent&&(R[V++]=W.x,R[V++]=W.y,R[V++]=W.z,R[V++]=W.x,R[V++]=W.y,R[V++]=W.z),b.binormal&&(L[B++]=G.x,L[B++]=G.y,L[B++]=G.z,L[B++]=G.x,L[B++]=G.y,L[B++]=G.z)}if(b.st){var et=q/(M-1);N[k++]=et,N[k++]=0,N[k++]=et,N[k++]=1}}var tt=new u;b.position&&(tt.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:D})),b.normal&&(tt.normal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:O})),b.tangent&&(tt.tangent=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),b.binormal&&(tt.binormal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:L})),b.st&&(tt.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:N}));var it=I/3;I-=6;var nt=c.createTypedArray(it,I),rt=0;for(q=0;it-2>q;q+=2){var ot=q,at=q+2,st=t.fromArray(D,3*ot,f),lt=t.fromArray(D,3*at,v);if(!t.equalsEpsilon(st,lt,d.EPSILON6)){var ut=q+1,ct=q+3;nt[rt++]=ut,nt[rt++]=ot,nt[rt++]=ct,nt[rt++]=ct,nt[rt++]=ot,nt[rt++]=at}}return new s({attributes:tt,indices:nt,primitiveType:h.TRIANGLES,boundingSphere:new e.fromVertices(D)})},b}),define("Cesium/Core/WallOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";var p=new t,f=new t,v=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.positions,o=e.maximumHeights,s=e.minimumHeights,l=n(e.granularity,d.RADIANS_PER_DEGREE),u=n(e.ellipsoid,a.WGS84);this._positions=i,this._minimumHeights=s,this._maximumHeights=o,this._granularity=l,this._ellipsoid=a.clone(u),this._workerName="createWallOutlineGeometry";var c=1+i.length*t.packedLength+2;r(s)&&(c+=s.length),r(o)&&(c+=o.length),this.packedLength=c+a.packedLength+1};v.pack=function(e,i,o){o=n(o,0);var s,l=e._positions,u=l.length;for(i[o++]=u,s=0;u>s;++s,o+=t.packedLength)t.pack(l[s],i,o);var c=e._minimumHeights;if(u=r(c)?c.length:0,i[o++]=u,r(c))for(s=0;u>s;++s)i[o++]=c[s];var d=e._maximumHeights;if(u=r(d)?d.length:0,i[o++]=u,r(d))for(s=0;u>s;++s)i[o++]=d[s];a.pack(e._ellipsoid,i,o),o+=a.packedLength,i[o]=e._granularity};var g=a.clone(a.UNIT_SPHERE),_={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:g,granularity:void 0};return v.unpack=function(e,i,o){i=n(i,0);var s,l=e[i++],u=new Array(l);for(s=0;l>s;++s,i+=t.packedLength)u[s]=t.unpack(e,i);l=e[i++];var c;if(l>0)for(c=new Array(l),s=0;l>s;++s)c[s]=e[i++];l=e[i++];var d;if(l>0)for(d=new Array(l),s=0;l>s;++s)d[s]=e[i++];var h=a.unpack(e,i,g);i+=a.packedLength;var m=e[i];return r(o)?(o._positions=u,o._minimumHeights=c,o._maximumHeights=d,o._ellipsoid=a.clone(h,o._ellipsoid),o._granularity=m,o):(_.positions=u,_.minimumHeights=c,_.maximumHeights=d,_.granularity=m,new v(_))},v.fromConstantHeights=function(e){e=n(e,n.EMPTY_OBJECT);var t,i,o=e.positions,a=e.minimumHeight,s=e.maximumHeight,l=r(a),u=r(s);if(l||u){var c=o.length;t=l?new Array(c):void 0,i=u?new Array(c):void 0;for(var d=0;c>d;++d)l&&(t[d]=a),u&&(i[d]=s)}var h={positions:o,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid};return new v(h)},v.createGeometry=function(n){var o=n._positions,a=n._minimumHeights,v=n._maximumHeights,g=n._granularity,_=n._ellipsoid,y=m.computePositions(_,o,v,a,g,!1);if(!r(y))return void 0;var C=y.bottomPositions,w=y.topPositions,E=w.length,b=2*E,S=new Float64Array(b),x=0;E/=3;var T;for(T=0;E>T;++T){var P=3*T,A=t.fromArray(w,P,p),M=t.fromArray(C,P,f);S[x++]=M.x,S[x++]=M.y,S[x++]=M.z,S[x++]=A.x,S[x++]=A.y,S[x++]=A.z}var I=new u({position:new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:S})}),D=b/3;b=2*D-4+D;var O=c.createTypedArray(D,b),R=0;for(T=0;D-2>T;T+=2){var L=T,N=T+2,z=t.fromArray(S,3*L,p),F=t.fromArray(S,3*N,f);if(!t.equalsEpsilon(z,F,d.EPSILON6)){var B=T+1,V=T+3;O[R++]=B,O[R++]=L,O[R++]=B,O[R++]=V,O[R++]=L,O[R++]=N}}return O[R++]=D-2,O[R++]=D-1,new s({attributes:I,indices:O,primitiveType:h.LINES,boundingSphere:new e.fromVertices(S)})},v}),define("Cesium/DataSources/WallGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Core/WallGeometry","../Core/WallOutlineGeometry","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C){"use strict";var w=new v(e.WHITE),E=new g(!0),b=new g(!0),S=new g(!1),x=new g(e.BLACK),T=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.positions=void 0,this.minimumHeights=void 0,this.maximumHeights=void 0,this.granularity=void 0},A=function(e,t){this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new s,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"wall",e.wall,void 0)};r(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),r(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return!1}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(i){var r,o,a=this._entity,s=a.isAvailable(i),u=new c(s&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var h=e.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||s)&&(h=this._materialProperty.color.getValue(i)),o=t.fromColor(h),r={show:u,color:o}}else r={show:u};return new l({id:a,geometry:new d(this._options),attributes:r})},A.prototype.createOutlineGeometryInstance=function(i){var n=this._entity,r=n.isAvailable(i),o=C.getValueOrDefault(this._outlineColorProperty,i,e.BLACK);return new l({id:n,geometry:new h(this._options),attributes:{show:new c(r&&this._showProperty.getValue(i)&&this._showOutlineProperty.getValue(i)),color:t.fromColor(o)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),o(this)},A.prototype._onEntityPropertyChanged=function(e,t){if("availability"===t||"wall"===t){var r=this._entity.wall;if(!n(r))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var o=r.fill,a=n(o)&&o.isConstant?o.getValue(u.MINIMUM_VALUE):!0,s=r.outline,l=n(s);if(l&&s.isConstant&&(l=s.getValue(u.MINIMUM_VALUE)),!a&&!l)return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var c=r.positions,d=r.show;if(n(d)&&d.isConstant&&!d.getValue(u.MINIMUM_VALUE)||!n(c))return(this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)),void 0;var h=i(r.material,w),f=h instanceof v;this._materialProperty=h,this._fillProperty=i(o,b),this._showProperty=i(d,E),this._showOutlineProperty=i(r.outline,S),this._outlineColorProperty=l?i(r.outlineColor,x):void 0;var g=r.minimumHeights,_=r.maximumHeights,y=r.outlineWidth,T=r.granularity;if(this._fillEnabled=a,this._outlineEnabled=l,c.isConstant&&C.isConstant(g)&&C.isConstant(_)&&C.isConstant(y)&&C.isConstant(T)){var P=this._options;P.vertexFormat=f?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,P.positions=c.getValue(u.MINIMUM_VALUE,P.positions),P.minimumHeights=n(g)?g.getValue(u.MINIMUM_VALUE,P.minimumHeights):void 0,P.maximumHeights=n(_)?_.getValue(u.MINIMUM_VALUE,P.maximumHeights):void 0,P.granularity=n(T)?T.getValue(u.MINIMUM_VALUE):void 0,this._outlineWidth=n(y)?y.getValue(u.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){return new M(e,this)};var M=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return M.prototype.update=function(i){var r=this._primitives;r.removeAndDestroy(this._primitive),r.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,a=o._entity,s=a.wall;if(a.isShowing&&a.isAvailable(i)&&C.getValueOrDefault(s.show,i,!0)){var u=this._options,c=C.getValueOrUndefined(s.positions,i,u.positions);if(n(c)){if(u.positions=c,u.minimumHeights=C.getValueOrUndefined(s.minimumHeights,i,u.minimumHeights),u.maximumHeights=C.getValueOrUndefined(s.maximumHeights,i,u.maximumHeights),u.granularity=C.getValueOrUndefined(s.granularity,i),C.getValueOrDefault(s.fill,i,!0)){var v=y.getValue(i,o.fillMaterialProperty,this._material);this._material=v;var g=new m({material:v,translucent:v.isTranslucent(),closed:n(u.extrudedHeight)});u.vertexFormat=g.vertexFormat,this._primitive=r.add(new f({geometryInstances:new l({id:a,geometry:new d(u)}),appearance:g,asynchronous:!1}))}if(C.getValueOrDefault(s.outline,i,!1)){u.vertexFormat=p.VERTEX_FORMAT;var _=C.getValueOrClonedDefault(s.outlineColor,i,e.BLACK,T),w=C.getValueOrDefault(s.outlineWidth,i,1),E=1!==_.alpha;this._outlinePrimitive=r.add(new f({geometryInstances:new l({id:a,geometry:new h(u),attributes:{color:t.fromColor(_)}}),appearance:new p({flat:!0,translucent:E,renderState:{lineWidth:o._scene.clampLineWidth(w)}}),asynchronous:!1}))}}}},M.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},M.prototype.isDestroyed=function(){return!1},M.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},A}),define("Cesium/DataSources/DataSourceDisplay",["../Core/BoundingSphere","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EventHelper","./BillboardVisualizer","./BoundingSphereState","./BoxGeometryUpdater","./CorridorGeometryUpdater","./CustomDataSource","./CylinderGeometryUpdater","./EllipseGeometryUpdater","./EllipsoidGeometryUpdater","./GeometryVisualizer","./LabelVisualizer","./ModelVisualizer","./PathVisualizer","./PointVisualizer","./PolygonGeometryUpdater","./PolylineGeometryUpdater","./PolylineVolumeGeometryUpdater","./RectangleGeometryUpdater","./WallGeometryUpdater"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m,p,f,v,g,_,y,C,w,E,b,S){"use strict";var x=function(e){var i=e.scene,n=e.dataSourceCollection;this._eventHelper=new a,this._eventHelper.add(n.dataSourceAdded,this._onDataSourceAdded,this),this._eventHelper.add(n.dataSourceRemoved,this._onDataSourceRemoved,this),this._dataSourceCollection=n,this._scene=i,this._visualizersCallback=t(e.visualizersCallback,x.defaultVisualizersCallback);for(var r=0,o=n.length;o>r;r++)this._onDataSourceAdded(n,n.get(r));var s=new d;this._onDataSourceAdded(void 0,s),this._defaultDataSource=s};x.defaultVisualizersCallback=function(e,t){var i=t.entities;return[new s(e,i),new f(u,e,i),new f(h,e,i),new f(c,e,i),new f(m,e,i),new f(p,e,i),new f(C,e,i),new f(w,e,i),new f(E,e,i),new f(b,e,i),new f(S,e,i),new v(e,i),new g(e,i),new y(e,i),new _(e,i)]},n(x.prototype,{scene:{get:function(){return this._scene}},dataSources:{get:function(){return this._dataSourceCollection}},defaultDataSource:{get:function(){return this._defaultDataSource}}}),x.prototype.isDestroyed=function(){return!1},x.prototype.destroy=function(){this._eventHelper.removeAll();for(var e=this._dataSourceCollection,t=0,i=e.length;i>t;++t)this._onDataSourceRemoved(this._dataSourceCollection,e.get(t));return this._onDataSourceRemoved(void 0,this._defaultDataSource),r(this)},x.prototype.update=function(e){var t,n,r,o,a=!0,s=this._dataSourceCollection,l=s.length;for(t=0;l>t;t++){var u=s.get(t);for(i(u.update)&&(a=u.update(e)&&a),r=u._visualizers,o=r.length,n=0;o>n;n++)a=r[n].update(e)&&a}for(r=this._defaultDataSource._visualizers,o=r.length,n=0;o>n;n++)a=r[n].update(e)&&a;return a};var T=[],P=new e;return x.prototype.getBoundingSphere=function(t,n,r){var o,a,s=this._defaultDataSource;if(!s.entities.contains(t)){s=void 0;var u=this._dataSourceCollection;for(a=u.length,o=0;a>o;o++){var c=u.get(o);if(c.entities.contains(t)){s=c;break}}}if(!i(s))return l.FAILED;var d=T,h=P,m=0,p=l.DONE,f=s._visualizers,v=f.length;for(o=0;v>o;o++){var g=f[o];if(i(g.getBoundingSphere)){if(p=f[o].getBoundingSphere(t,h),!n&&p===l.PENDING)return l.PENDING;
p===l.DONE&&(d[m]=e.clone(h,d[m]),m++)}}return 0===m?l.FAILED:(d.length=m,e.fromBoundingSpheres(d,r),l.DONE)},x.prototype._onDataSourceAdded=function(e,t){var i=this._visualizersCallback(this._scene,t);t._visualizers=i},x.prototype._onDataSourceRemoved=function(e,t){for(var i=t._visualizers,n=i.length,r=0;n>r;r++)i[r].destroy(),t._visualizers=void 0},x}),define("Cesium/Scene/HeadingPitchRange",["../Core/defaultValue","../Core/defined"],function(e,t){"use strict";var i=function(t,i,n){this.heading=e(t,0),this.pitch=e(i,0),this.range=e(n,0)};return i.clone=function(e,n){return t(e)?(t(n)||(n=new i),n.heading=e.heading,n.pitch=e.pitch,n.range=e.range,n):void 0},i}),define("Cesium/DataSources/EntityView",["../Core/BoundingSphere","../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/JulianDate","../Core/Math","../Core/Matrix3","../Core/Matrix4","../Core/Transforms","../Scene/HeadingPitchRange","../Scene/SceneMode"],function(e,t,i,n,r,o,a,s,l,u,c,d,h,m){"use strict";function p(e,i,r,o,a,c){var h=!1,p=o.getValue(a,e._lastCartesian);if(n(p)){var P,A,M,I=!1,D=e.scene.mode;if(D===m.SCENE3D){x=s.addSeconds(a,.001,x);var O=o.getValue(x,y);if(n(O)){var R,L=d.computeFixedToIcrfMatrix(a,f),N=d.computeFixedToIcrfMatrix(x,v);n(L)&&n(N)?R=u.transpose(L,g):(R=d.computeTemeToPseudoFixedMatrix(a,g),L=u.transpose(R,f),N=d.computeTemeToPseudoFixedMatrix(x,v),u.transpose(N,N));var z=u.multiplyByVector(L,p,b),F=u.multiplyByVector(N,O,S);t.subtract(z,F,E);var B=1e3*t.magnitude(E),V=3986004418e5,k=-V/(B*B-2*V/t.magnitude(z));0>k||k>T*c.maximumRadius?(P=C,t.normalize(p,P),t.negate(P,P),M=t.clone(t.UNIT_Z,w),A=t.cross(M,P,y),t.magnitude(A)>l.EPSILON7&&(t.normalize(P,P),t.normalize(A,A),M=t.cross(P,A,w),t.normalize(M,M),I=!0)):t.equalsEpsilon(p,O,l.EPSILON7)||(M=C,t.normalize(z,M),t.normalize(F,F),A=t.cross(M,F,w),t.equalsEpsilon(A,t.ZERO,l.EPSILON7)||(P=t.cross(A,M,y),u.multiplyByVector(R,P,P),u.multiplyByVector(R,A,A),u.multiplyByVector(R,M,M),t.normalize(P,P),t.normalize(A,A),t.normalize(M,M),I=!0))}}n(e._boundingSphereOffset)&&t.add(e._boundingSphereOffset,p,p);var U=_;I?(U[0]=P.x,U[1]=P.y,U[2]=P.z,U[3]=0,U[4]=A.x,U[5]=A.y,U[6]=A.z,U[7]=0,U[8]=M.x,U[9]=M.y,U[10]=M.z,U[11]=0,U[12]=p.x,U[13]=p.y,U[14]=p.z,U[15]=0):d.eastNorthUpToFixedFrame(p,c,U);var W;W=D===m.SCENE2D&&0===e._offset2D.range||D!==m.SCENE2D&&t.equals(e._offset3D,t.ZERO)?void 0:D===m.SCENE2D?e._offset2D:e._offset3D,i.lookAtTransform(U,W),h=!0}r&&!h&&i.lookAtTransform(i.transform,e.scene.mode===m.SCENE2D?e._offset2D:e._offset3D)}var f=new u,v=new u,g=new u,_=new c,y=new t,C=new t,w=new t,E=new t,b=new t,S=new t,x=new s,T=1.25,P=function(n,r,o,s){this.entity=n,this.scene=r,this.ellipsoid=i(o,a.WGS84),this.boundingSphere=e.clone(s),this._boundingSphereOffset=void 0,this._lastEntity=void 0,this._mode=void 0,this._lastCartesian=new t,this._defaultOffset3D=void 0,this._defaultOffset2D=void 0,this._offset3D=new t,this._offset2D=new h};return r(P,{defaultOffset3D:{get:function(){return this._defaultOffset3D},set:function(e){this._defaultOffset3D=t.clone(e,new t),this._defaultOffset2D=new h(0,0,t.magnitude(this._defaultOffset3D))}}}),P.defaultOffset3D=new t(-14e3,3500,3500),P.prototype.update=function(e){var i=this.scene,r=this.entity,o=this.ellipsoid,a=i.mode;if(a!==m.MORPHING){var s=r.position,l=r!==this._lastEntity,u=a!==this._mode,c=this._offset3D,d=this._offset2D,f=i.camera,v=l||u;if(l){var g=r.viewFrom,_=n(g),y=this.boundingSphere;if(this._boundingSphereOffset=void 0,!_&&n(y)){var C=i.screenSpaceCameraController;C.minimumZoomDistance=Math.min(C.minimumZoomDistance,.5*y.radius),f.viewBoundingSphere(y),this._boundingSphereOffset=t.subtract(y.center,r.position.getValue(e),new t),v=!1}else _&&n(g.getValue(e,c))?(d.heading=0,d.range=t.magnitude(c)):(h.clone(P._defaultOffset2D,d),t.clone(P._defaultOffset3D,c))}else u||i.mode===m.MORPHING||(this._mode===m.SCENE2D?(d.heading=f.heading,d.range=f.frustum.right-f.frustum.left):(this._mode===m.SCENE3D||this._mode===m.COLUMBUS_VIEW)&&t.clone(f.position,c));this._lastEntity=r,this._mode=i.mode!==m.MORPHING?i.mode:this._mode,i.mode!==m.MORPHING&&p(this,f,v,s,e,o)}},P}),function(){!function(e){var t=this||(0,eval)("this"),i=t.document,n=t.navigator,r=t.jQuery,o=t.JSON;!function(e){"function"==typeof require&&"object"==typeof exports&&"object"==typeof module?e(module.exports||exports,require):"function"==typeof define&&define.amd?define("Cesium/ThirdParty/knockout-3.2.0",["exports","require"],e):e(t.ko={})}(function(a,s){function l(e,t){return null===e||typeof e in m?e===t:!1}function u(t,i){var n;return function(){n||(n=setTimeout(function(){n=e,t()},i))}}function c(e,t){var i;return function(){clearTimeout(i),i=setTimeout(e,t)}}function d(e,t,i,n){h.d[e]={init:function(e,r,o,a,s){var l,u;return h.s(function(){var o=h.a.c(r()),a=!i!=!o,c=!u;(c||t||a!==l)&&(c&&h.Y.la()&&(u=h.a.ia(h.f.childNodes(e),!0)),a?(c||h.f.T(e,h.a.ia(u)),h.Ca(n?n(s,o):s,e)):h.f.ja(e),l=a)},null,{o:e}),{controlsDescendantBindings:!0}}},h.h.ha[e]=!1,h.f.Q[e]=!0}var h="undefined"!=typeof a?a:{};h.b=function(e,t){for(var i=e.split("."),n=h,r=0;r<i.length-1;r++)n=n[i[r]];n[i[i.length-1]]=t},h.A=function(e,t,i){e[t]=i},h.version="3.2.0",h.b("version",h.version),h.a=function(){function a(e,t){for(var i in e)e.hasOwnProperty(i)&&t(i,e[i])}function s(e,t){if(t)for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e}function l(e,t){return e.__proto__=t,e}var u={__proto__:[]}instanceof Array,c={},d={};c[n&&/Firefox\/2/i.test(n.userAgent)?"KeyboardEvent":"UIEvents"]=["keyup","keydown","keypress"],c.MouseEvents="click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave".split(" "),a(c,function(e,t){if(t.length)for(var i=0,n=t.length;n>i;i++)d[t[i]]=e});var m={propertychange:!0},p=i&&function(){for(var t=3,n=i.createElement("div"),r=n.getElementsByTagName("i");n.innerHTML="<!--[if gt IE "+ ++t+"]><i></i><![endif]-->",r[0];);return t>4?t:e}();return{vb:["authenticity_token",/^__RequestVerificationToken(_.*)?$/],u:function(e,t){for(var i=0,n=e.length;n>i;i++)t(e[i],i)},m:function(e,t){if("function"==typeof Array.prototype.indexOf)return Array.prototype.indexOf.call(e,t);for(var i=0,n=e.length;n>i;i++)if(e[i]===t)return i;return-1},qb:function(e,t,i){for(var n=0,r=e.length;r>n;n++)if(t.call(i,e[n],n))return e[n];return null},ua:function(e,t){var i=h.a.m(e,t);i>0?e.splice(i,1):0===i&&e.shift()},rb:function(e){e=e||[];for(var t=[],i=0,n=e.length;n>i;i++)0>h.a.m(t,e[i])&&t.push(e[i]);return t},Da:function(e,t){e=e||[];for(var i=[],n=0,r=e.length;r>n;n++)i.push(t(e[n],n));return i},ta:function(e,t){e=e||[];for(var i=[],n=0,r=e.length;r>n;n++)t(e[n],n)&&i.push(e[n]);return i},ga:function(e,t){if(t instanceof Array)e.push.apply(e,t);else for(var i=0,n=t.length;n>i;i++)e.push(t[i]);return e},ea:function(e,t,i){var n=h.a.m(h.a.Xa(e),t);0>n?i&&e.push(t):i||e.splice(n,1)},xa:u,extend:s,za:l,Aa:u?l:s,G:a,na:function(e,t){if(!e)return e;var i,n={};for(i in e)e.hasOwnProperty(i)&&(n[i]=t(e[i],i,e));return n},Ka:function(e){for(;e.firstChild;)h.removeNode(e.firstChild)},oc:function(e){e=h.a.S(e);for(var t=i.createElement("div"),n=0,r=e.length;r>n;n++)t.appendChild(h.R(e[n]));return t},ia:function(e,t){for(var i=0,n=e.length,r=[];n>i;i++){var o=e[i].cloneNode(!0);r.push(t?h.R(o):o)}return r},T:function(e,t){if(h.a.Ka(e),t)for(var i=0,n=t.length;n>i;i++)e.appendChild(t[i])},Lb:function(e,t){var i=e.nodeType?[e]:e;if(0<i.length){for(var n=i[0],r=n.parentNode,o=0,a=t.length;a>o;o++)r.insertBefore(t[o],n);for(o=0,a=i.length;a>o;o++)h.removeNode(i[o])}},ka:function(e,t){if(e.length){for(t=8===t.nodeType&&t.parentNode||t;e.length&&e[0].parentNode!==t;)e.shift();if(1<e.length){var i=e[0],n=e[e.length-1];for(e.length=0;i!==n;)if(e.push(i),i=i.nextSibling,!i)return;e.push(n)}}return e},Nb:function(e,t){7>p?e.setAttribute("selected",t):e.selected=t},cb:function(t){return null===t||t===e?"":t.trim?t.trim():t.toString().replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")},vc:function(e,t){return e=e||"",t.length>e.length?!1:e.substring(0,t.length)===t},cc:function(e,t){if(e===t)return!0;if(11===e.nodeType)return!1;if(t.contains)return t.contains(3===e.nodeType?e.parentNode:e);if(t.compareDocumentPosition)return 16==(16&t.compareDocumentPosition(e));for(;e&&e!=t;)e=e.parentNode;return!!e},Ja:function(e){return h.a.cc(e,e.ownerDocument.documentElement)},ob:function(e){return!!h.a.qb(e,h.a.Ja)},t:function(e){return e&&e.tagName&&e.tagName.toLowerCase()},n:function(e,t,i){var n=p&&m[t];if(!n&&r)r(e).bind(t,i);else if(n||"function"!=typeof e.addEventListener){if("undefined"==typeof e.attachEvent)throw Error("Browser doesn't support addEventListener or attachEvent");var o=function(t){i.call(e,t)},a="on"+t;e.attachEvent(a,o),h.a.w.da(e,function(){e.detachEvent(a,o)})}else e.addEventListener(t,i,!1)},oa:function(e,n){if(!e||!e.nodeType)throw Error("element must be a DOM node when calling triggerEvent");var o;if("input"===h.a.t(e)&&e.type&&"click"==n.toLowerCase()?(o=e.type,o="checkbox"==o||"radio"==o):o=!1,r&&!o)r(e).trigger(n);else if("function"==typeof i.createEvent){if("function"!=typeof e.dispatchEvent)throw Error("The supplied element doesn't support dispatchEvent");o=i.createEvent(d[n]||"HTMLEvents"),o.initEvent(n,!0,!0,t,0,0,0,0,0,!1,!1,!1,!1,0,e),e.dispatchEvent(o)}else if(o&&e.click)e.click();else{if("undefined"==typeof e.fireEvent)throw Error("Browser doesn't support triggering events");e.fireEvent("on"+n)}},c:function(e){return h.C(e)?e():e},Xa:function(e){return h.C(e)?e.v():e},Ba:function(e,t,i){if(t){var n=/\S+/g,r=e.className.match(n)||[];h.a.u(t.match(n),function(e){h.a.ea(r,e,i)}),e.className=r.join(" ")}},bb:function(t,i){var n=h.a.c(i);(null===n||n===e)&&(n="");var r=h.f.firstChild(t);!r||3!=r.nodeType||h.f.nextSibling(r)?h.f.T(t,[t.ownerDocument.createTextNode(n)]):r.data=n,h.a.fc(t)},Mb:function(e,t){if(e.name=t,7>=p)try{e.mergeAttributes(i.createElement("<input name='"+e.name+"'/>"),!1)}catch(n){}},fc:function(e){p>=9&&(e=1==e.nodeType?e:e.parentNode,e.style&&(e.style.zoom=e.style.zoom))},dc:function(e){if(p){var t=e.style.width;e.style.width=0,e.style.width=t}},sc:function(e,t){e=h.a.c(e),t=h.a.c(t);for(var i=[],n=e;t>=n;n++)i.push(n);return i},S:function(e){for(var t=[],i=0,n=e.length;n>i;i++)t.push(e[i]);return t},yc:6===p,zc:7===p,L:p,xb:function(e,t){for(var i=h.a.S(e.getElementsByTagName("input")).concat(h.a.S(e.getElementsByTagName("textarea"))),n="string"==typeof t?function(e){return e.name===t}:function(e){return t.test(e.name)},r=[],o=i.length-1;o>=0;o--)n(i[o])&&r.push(i[o]);return r},pc:function(e){return"string"==typeof e&&(e=h.a.cb(e))?o&&o.parse?o.parse(e):new Function("return "+e)():null},eb:function(e,t,i){if(!o||!o.stringify)throw Error("Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js");return o.stringify(h.a.c(e),t,i)},qc:function(e,t,n){n=n||{};var r=n.params||{},o=n.includeFields||this.vb,s=e;if("object"==typeof e&&"form"===h.a.t(e))for(var s=e.action,l=o.length-1;l>=0;l--)for(var u=h.a.xb(e,o[l]),c=u.length-1;c>=0;c--)r[u[c].name]=u[c].value;t=h.a.c(t);var d=i.createElement("form");d.style.display="none",d.action=s,d.method="post";for(var m in t)e=i.createElement("input"),e.type="hidden",e.name=m,e.value=h.a.eb(h.a.c(t[m])),d.appendChild(e);a(r,function(e,t){var n=i.createElement("input");n.type="hidden",n.name=e,n.value=t,d.appendChild(n)}),i.body.appendChild(d),n.submitter?n.submitter(d):d.submit(),setTimeout(function(){d.parentNode.removeChild(d)},0)}}}(),h.b("utils",h.a),h.b("utils.arrayForEach",h.a.u),h.b("utils.arrayFirst",h.a.qb),h.b("utils.arrayFilter",h.a.ta),h.b("utils.arrayGetDistinctValues",h.a.rb),h.b("utils.arrayIndexOf",h.a.m),h.b("utils.arrayMap",h.a.Da),h.b("utils.arrayPushAll",h.a.ga),h.b("utils.arrayRemoveItem",h.a.ua),h.b("utils.extend",h.a.extend),h.b("utils.fieldsIncludedWithJsonPost",h.a.vb),h.b("utils.getFormFields",h.a.xb),h.b("utils.peekObservable",h.a.Xa),h.b("utils.postJson",h.a.qc),h.b("utils.parseJson",h.a.pc),h.b("utils.registerEventHandler",h.a.n),h.b("utils.stringifyJson",h.a.eb),h.b("utils.range",h.a.sc),h.b("utils.toggleDomNodeCssClass",h.a.Ba),h.b("utils.triggerEvent",h.a.oa),h.b("utils.unwrapObservable",h.a.c),h.b("utils.objectForEach",h.a.G),h.b("utils.addOrRemoveItem",h.a.ea),h.b("unwrap",h.a.c),Function.prototype.bind||(Function.prototype.bind=function(e){var t=this,i=Array.prototype.slice.call(arguments);return e=i.shift(),function(){return t.apply(e,i.concat(Array.prototype.slice.call(arguments)))}}),h.a.e=new function(){function t(t,o){var a=t[n];if(!a||"null"===a||!r[a]){if(!o)return e;a=t[n]="ko"+i++,r[a]={}}return r[a]}var i=0,n="__ko__"+(new Date).getTime(),r={};return{get:function(i,n){var r=t(i,!1);return r===e?e:r[n]},set:function(i,n,r){(r!==e||t(i,!1)!==e)&&(t(i,!0)[n]=r)},clear:function(e){var t=e[n];return t?(delete r[t],e[n]=null,!0):!1},F:function(){return i++ +n}}},h.b("utils.domData",h.a.e),h.b("utils.domData.clear",h.a.e.clear),h.a.w=new function(){function t(t,i){var r=h.a.e.get(t,n);return r===e&&i&&(r=[],h.a.e.set(t,n,r)),r}function i(e){var n=t(e,!1);if(n)for(var n=n.slice(0),r=0;r<n.length;r++)n[r](e);if(h.a.e.clear(e),h.a.w.cleanExternalData(e),a[e.nodeType])for(n=e.firstChild;e=n;)n=e.nextSibling,8===e.nodeType&&i(e)}var n=h.a.e.F(),o={1:!0,8:!0,9:!0},a={1:!0,9:!0};return{da:function(e,i){if("function"!=typeof i)throw Error("Callback must be a function");t(e,!0).push(i)},Kb:function(i,r){var o=t(i,!1);o&&(h.a.ua(o,r),0==o.length&&h.a.e.set(i,n,e))},R:function(e){if(o[e.nodeType]&&(i(e),a[e.nodeType])){var t=[];h.a.ga(t,e.getElementsByTagName("*"));for(var n=0,r=t.length;r>n;n++)i(t[n])}return e},removeNode:function(e){h.R(e),e.parentNode&&e.parentNode.removeChild(e)},cleanExternalData:function(e){r&&"function"==typeof r.cleanData&&r.cleanData([e])}}},h.R=h.a.w.R,h.removeNode=h.a.w.removeNode,h.b("cleanNode",h.R),h.b("removeNode",h.removeNode),h.b("utils.domNodeDisposal",h.a.w),h.b("utils.domNodeDisposal.addDisposeCallback",h.a.w.da),h.b("utils.domNodeDisposal.removeDisposeCallback",h.a.w.Kb),function(){h.a.ba=function(e){var n;if(r){if(r.parseHTML)n=r.parseHTML(e)||[];else if((n=r.clean([e]))&&n[0]){for(e=n[0];e.parentNode&&11!==e.parentNode.nodeType;)e=e.parentNode;e.parentNode&&e.parentNode.removeChild(e)}}else{var o=h.a.cb(e).toLowerCase();for(n=i.createElement("div"),o=o.match(/^<(thead|tbody|tfoot)/)&&[1,"<table>","</table>"]||!o.indexOf("<tr")&&[2,"<table><tbody>","</tbody></table>"]||(!o.indexOf("<td")||!o.indexOf("<th"))&&[3,"<table><tbody><tr>","</tr></tbody></table>"]||[0,"",""],e="ignored<div>"+o[1]+e+o[2]+"</div>","function"==typeof t.innerShiv?n.appendChild(t.innerShiv(e)):n.innerHTML=e;o[0]--;)n=n.lastChild;n=h.a.S(n.lastChild.childNodes)}return n},h.a.$a=function(t,i){if(h.a.Ka(t),i=h.a.c(i),null!==i&&i!==e)if("string"!=typeof i&&(i=i.toString()),r)r(t).html(i);else for(var n=h.a.ba(i),o=0;o<n.length;o++)t.appendChild(n[o])}}(),h.b("utils.parseHtmlFragment",h.a.ba),h.b("utils.setHtml",h.a.$a),h.D=function(){function t(e,i){if(e)if(8==e.nodeType){var n=h.D.Gb(e.nodeValue);null!=n&&i.push({bc:e,mc:n})}else if(1==e.nodeType)for(var n=0,r=e.childNodes,o=r.length;o>n;n++)t(r[n],i)}var i={};return{Ua:function(e){if("function"!=typeof e)throw Error("You can only pass a function to ko.memoization.memoize()");var t=(0|4294967296*(1+Math.random())).toString(16).substring(1)+(0|4294967296*(1+Math.random())).toString(16).substring(1);return i[t]=e,"<!--[ko_memo:"+t+"]-->"},Rb:function(t,n){var r=i[t];if(r===e)throw Error("Couldn't find any memo with ID "+t+". Perhaps it's already been unmemoized.");try{return r.apply(null,n||[]),!0}finally{delete i[t]}},Sb:function(e,i){var n=[];t(e,n);for(var r=0,o=n.length;o>r;r++){var a=n[r].bc,s=[a];i&&h.a.ga(s,i),h.D.Rb(n[r].mc,s),a.nodeValue="",a.parentNode&&a.parentNode.removeChild(a)}},Gb:function(e){return(e=e.match(/^\[ko_memo\:(.*?)\]$/))?e[1]:null}}}(),h.b("memoization",h.D),h.b("memoization.memoize",h.D.Ua),h.b("memoization.unmemoize",h.D.Rb),h.b("memoization.parseMemoText",h.D.Gb),h.b("memoization.unmemoizeDomNodeAndDescendants",h.D.Sb),h.La={throttle:function(e,t){e.throttleEvaluation=t;var i=null;return h.j({read:e,write:function(n){clearTimeout(i),i=setTimeout(function(){e(n)},t)}})},rateLimit:function(e,t){var i,n,r;"number"==typeof t?i=t:(i=t.timeout,n=t.method),r="notifyWhenChangesStop"==n?c:u,e.Ta(function(e){return r(e,i)})},notify:function(e,t){e.equalityComparer="always"==t?null:l}};var m={undefined:1,"boolean":1,number:1,string:1};h.b("extenders",h.La),h.Pb=function(e,t,i){this.target=e,this.wa=t,this.ac=i,this.Cb=!1,h.A(this,"dispose",this.K)},h.Pb.prototype.K=function(){this.Cb=!0,this.ac()},h.P=function(){h.a.Aa(this,h.P.fn),this.M={}};var p="change",f={U:function(e,t,i){var n=this;i=i||p;var r=new h.Pb(n,t?e.bind(t):e,function(){h.a.ua(n.M[i],r),n.nb&&n.nb()});return n.va&&n.va(i),n.M[i]||(n.M[i]=[]),n.M[i].push(r),r},notifySubscribers:function(e,t){if(t=t||p,this.Ab(t))try{h.k.Ea();for(var i,n=this.M[t].slice(0),r=0;i=n[r];++r)i.Cb||i.wa(e)}finally{h.k.end()}},Ta:function(e){var t,i,n,r=this,o=h.C(r);r.qa||(r.qa=r.notifySubscribers,r.notifySubscribers=function(e,t){t&&t!==p?"beforeChange"===t?r.kb(e):r.qa(e,t):r.lb(e)});var a=e(function(){o&&n===r&&(n=r()),t=!1,r.Pa(i,n)&&r.qa(i=n)});r.lb=function(e){t=!0,n=e,a()},r.kb=function(e){t||(i=e,r.qa(e,"beforeChange"))}},Ab:function(e){return this.M[e]&&this.M[e].length},yb:function(){var e=0;return h.a.G(this.M,function(t,i){e+=i.length}),e},Pa:function(e,t){return!this.equalityComparer||!this.equalityComparer(e,t)},extend:function(e){var t=this;return e&&h.a.G(e,function(e,i){var n=h.La[e];"function"==typeof n&&(t=n(t,i)||t)}),t}};h.A(f,"subscribe",f.U),h.A(f,"extend",f.extend),h.A(f,"getSubscriptionsCount",f.yb),h.a.xa&&h.a.za(f,Function.prototype),h.P.fn=f,h.Db=function(e){return null!=e&&"function"==typeof e.U&&"function"==typeof e.notifySubscribers},h.b("subscribable",h.P),h.b("isSubscribable",h.Db),h.Y=h.k=function(){function e(e){n.push(i),i=e}function t(){i=n.pop()}var i,n=[],r=0;return{Ea:e,end:t,Jb:function(e){if(i){if(!h.Db(e))throw Error("Only subscribable things can act as dependencies");i.wa(e,e.Vb||(e.Vb=++r))}},B:function(i,n,r){try{return e(),i.apply(n,r||[])}finally{t()}},la:function(){return i?i.s.la():void 0},ma:function(){return i?i.ma:void 0}}}(),h.b("computedContext",h.Y),h.b("computedContext.getDependenciesCount",h.Y.la),h.b("computedContext.isInitial",h.Y.ma),h.b("computedContext.isSleeping",h.Y.Ac),h.p=function(e){function t(){return 0<arguments.length?(t.Pa(i,arguments[0])&&(t.X(),i=arguments[0],t.W()),this):(h.k.Jb(t),i)}var i=e;return h.P.call(t),h.a.Aa(t,h.p.fn),t.v=function(){return i},t.W=function(){t.notifySubscribers(i)},t.X=function(){t.notifySubscribers(i,"beforeChange")},h.A(t,"peek",t.v),h.A(t,"valueHasMutated",t.W),h.A(t,"valueWillMutate",t.X),t},h.p.fn={equalityComparer:l};var v=h.p.rc="__ko_proto__";h.p.fn[v]=h.p,h.a.xa&&h.a.za(h.p.fn,h.P.fn),h.Ma=function(t,i){return null===t||t===e||t[v]===e?!1:t[v]===i?!0:h.Ma(t[v],i)},h.C=function(e){return h.Ma(e,h.p)},h.Ra=function(e){return"function"==typeof e&&e[v]===h.p||"function"==typeof e&&e[v]===h.j&&e.hc?!0:!1},h.b("observable",h.p),h.b("isObservable",h.C),h.b("isWriteableObservable",h.Ra),h.b("isWritableObservable",h.Ra),h.aa=function(e){if(e=e||[],"object"!=typeof e||!("length"in e))throw Error("The argument passed when initializing an observable array must be an array, or null, or undefined.");return e=h.p(e),h.a.Aa(e,h.aa.fn),e.extend({trackArrayChanges:!0})},h.aa.fn={remove:function(e){for(var t=this.v(),i=[],n="function"!=typeof e||h.C(e)?function(t){return t===e}:e,r=0;r<t.length;r++){var o=t[r];n(o)&&(0===i.length&&this.X(),i.push(o),t.splice(r,1),r--)}return i.length&&this.W(),i},removeAll:function(t){if(t===e){var i=this.v(),n=i.slice(0);return this.X(),i.splice(0,i.length),this.W(),n}return t?this.remove(function(e){return 0<=h.a.m(t,e)}):[]},destroy:function(e){var t=this.v(),i="function"!=typeof e||h.C(e)?function(t){return t===e}:e;this.X();for(var n=t.length-1;n>=0;n--)i(t[n])&&(t[n]._destroy=!0);this.W()},destroyAll:function(t){return t===e?this.destroy(function(){return!0}):t?this.destroy(function(e){return 0<=h.a.m(t,e)}):[]},indexOf:function(e){var t=this();return h.a.m(t,e)},replace:function(e,t){var i=this.indexOf(e);i>=0&&(this.X(),this.v()[i]=t,this.W())}},h.a.u("pop push reverse shift sort splice unshift".split(" "),function(e){h.aa.fn[e]=function(){var t=this.v();return this.X(),this.sb(t,e,arguments),t=t[e].apply(t,arguments),this.W(),t}}),h.a.u(["slice"],function(e){h.aa.fn[e]=function(){var t=this();return t[e].apply(t,arguments)}}),h.a.xa&&h.a.za(h.aa.fn,h.p.fn),h.b("observableArray",h.aa);var g="arrayChange";h.La.trackArrayChanges=function(e){function t(){if(!i){i=!0;var t=e.notifySubscribers;e.notifySubscribers=function(e,i){return i&&i!==p||++r,t.apply(this,arguments)};var o=[].concat(e.v()||[]);n=null,e.U(function(t){if(t=[].concat(t||[]),e.Ab(g)){var i;(!n||r>1)&&(n=h.a.Fa(o,t,{sparse:!0})),i=n,i.length&&e.notifySubscribers(i,g)}o=t,n=null,r=0})}}if(!e.sb){var i=!1,n=null,r=0,o=e.U;e.U=e.subscribe=function(e,i,n){return n===g&&t(),o.apply(this,arguments)},e.sb=function(e,t,o){function a(e,t,i){return s[s.length]={status:e,value:t,index:i}}if(i&&!r){var s=[],l=e.length,u=o.length,c=0;switch(t){case"push":c=l;case"unshift":for(t=0;u>t;t++)a("added",o[t],c+t);break;case"pop":c=l-1;case"shift":l&&a("deleted",e[c],c);break;case"splice":t=Math.min(Math.max(0,0>o[0]?l+o[0]:o[0]),l);for(var l=1===u?l:Math.min(t+(o[1]||0),l),u=t+u-2,c=Math.max(l,u),d=[],m=[],p=2;c>t;++t,++p)l>t&&m.push(a("deleted",e[t],t)),u>t&&d.push(a("added",o[p],t));h.a.wb(m,d);break;default:return}n=s}}}},h.s=h.j=function(t,i,n){function r(){h.a.G(x,function(e,t){t.K()}),x={}}function o(){r(),T=0,v=!0,m=!1}function a(){var e=l.throttleEvaluation;e&&e>=0?(clearTimeout(P),P=setTimeout(s,e)):l.ib?l.ib():s()}function s(t){if(p){if(_)throw Error("A 'pure' computed must not be called recursively")}else if(!v){if(b&&b()){if(!f)return S(),void 0}else f=!1;if(p=!0,y)try{var n={};h.k.Ea({wa:function(e,t){n[t]||(n[t]=1,++T)},s:l,ma:e}),T=0,d=g.call(i)}finally{h.k.end(),p=!1}else try{var r=x,o=T;h.k.Ea({wa:function(e,t){v||(o&&r[t]?(x[t]=r[t],++T,delete r[t],--o):x[t]||(x[t]=e.U(a),++T))},s:l,ma:_?e:!T}),x={},T=0;try{var s=i?g.call(i):g()}finally{h.k.end(),o&&h.a.G(r,function(e,t){t.K()}),m=!1}l.Pa(d,s)&&(l.notifySubscribers(d,"beforeChange"),d=s,!0!==t&&l.notifySubscribers(d))}finally{p=!1}T||S()}}function l(){if(0<arguments.length){if("function"!=typeof C)throw Error("Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.");return C.apply(i,arguments),this}return h.k.Jb(l),m&&s(!0),d}function u(){return m&&!T&&s(!0),d}function c(){return m||T>0}var d,m=!0,p=!1,f=!1,v=!1,g=t,_=!1,y=!1;if(g&&"object"==typeof g?(n=g,g=n.read):(n=n||{},g||(g=n.read)),"function"!=typeof g)throw Error("Pass a function that returns the value of the ko.computed");var C=n.write,w=n.disposeWhenNodeIsRemoved||n.o||null,E=n.disposeWhen||n.Ia,b=E,S=o,x={},T=0,P=null;i||(i=n.owner),h.P.call(l),h.a.Aa(l,h.j.fn),l.v=u,l.la=function(){return T},l.hc="function"==typeof n.write,l.K=function(){S()},l.Z=c;var A=l.Ta;return l.Ta=function(e){A.call(l,e),l.ib=function(){l.kb(d),m=!0,l.lb(l)}},n.pure?(y=_=!0,l.va=function(){y&&(y=!1,s(!0))},l.nb=function(){l.yb()||(r(),y=m=!0)}):n.deferEvaluation&&(l.va=function(){u(),delete l.va}),h.A(l,"peek",l.v),h.A(l,"dispose",l.K),h.A(l,"isActive",l.Z),h.A(l,"getDependenciesCount",l.la),w&&(f=!0,w.nodeType&&(b=function(){return!h.a.Ja(w)||E&&E()})),y||n.deferEvaluation||s(),w&&c()&&w.nodeType&&(S=function(){h.a.w.Kb(w,S),o()},h.a.w.da(w,S)),l},h.jc=function(e){return h.Ma(e,h.j)},f=h.p.rc,h.j[f]=h.p,h.j.fn={equalityComparer:l},h.j.fn[f]=h.j,h.a.xa&&h.a.za(h.j.fn,h.P.fn),h.b("dependentObservable",h.j),h.b("computed",h.j),h.b("isComputed",h.jc),h.Ib=function(e,t){return"function"==typeof e?h.s(e,t,{pure:!0}):(e=h.a.extend({},e),e.pure=!0,h.s(e,t))},h.b("pureComputed",h.Ib),function(){function t(r,o,a){if(a=a||new n,r=o(r),"object"!=typeof r||null===r||r===e||r instanceof Date||r instanceof String||r instanceof Number||r instanceof Boolean)return r;var s=r instanceof Array?[]:{};return a.save(r,s),i(r,function(i){var n=o(r[i]);switch(typeof n){case"boolean":case"number":case"string":case"function":s[i]=n;break;case"object":case"undefined":var l=a.get(n);s[i]=l!==e?l:t(n,o,a)}}),s}function i(e,t){if(e instanceof Array){for(var i=0;i<e.length;i++)t(i);"function"==typeof e.toJSON&&t("toJSON")}else for(i in e)t(i)}function n(){this.keys=[],this.hb=[]}h.Qb=function(e){if(0==arguments.length)throw Error("When calling ko.toJS, pass the object you want to convert.");return t(e,function(e){for(var t=0;h.C(e)&&10>t;t++)e=e();return e})},h.toJSON=function(e,t,i){return e=h.Qb(e),h.a.eb(e,t,i)},n.prototype={save:function(e,t){var i=h.a.m(this.keys,e);i>=0?this.hb[i]=t:(this.keys.push(e),this.hb.push(t))},get:function(t){return t=h.a.m(this.keys,t),t>=0?this.hb[t]:e}}}(),h.b("toJS",h.Qb),h.b("toJSON",h.toJSON),function(){h.i={q:function(t){switch(h.a.t(t)){case"option":return!0===t.__ko__hasDomDataOptionValue__?h.a.e.get(t,h.d.options.Va):7>=h.a.L?t.getAttributeNode("value")&&t.getAttributeNode("value").specified?t.value:t.text:t.value;case"select":return 0<=t.selectedIndex?h.i.q(t.options[t.selectedIndex]):e;default:return t.value}},ca:function(t,i,n){switch(h.a.t(t)){case"option":switch(typeof i){case"string":h.a.e.set(t,h.d.options.Va,e),"__ko__hasDomDataOptionValue__"in t&&delete t.__ko__hasDomDataOptionValue__,t.value=i;break;default:h.a.e.set(t,h.d.options.Va,i),t.__ko__hasDomDataOptionValue__=!0,t.value="number"==typeof i?i:""}break;case"select":(""===i||null===i)&&(i=e);for(var r,o=-1,a=0,s=t.options.length;s>a;++a)if(r=h.i.q(t.options[a]),r==i||""==r&&i===e){o=a;break}(n||o>=0||i===e&&1<t.size)&&(t.selectedIndex=o);break;default:(null===i||i===e)&&(i=""),t.value=i}}}}(),h.b("selectExtensions",h.i),h.b("selectExtensions.readValue",h.i.q),h.b("selectExtensions.writeValue",h.i.ca),h.h=function(){function e(e){e=h.a.cb(e),123===e.charCodeAt(0)&&(e=e.slice(1,-1));var t,i,a=[],s=e.match(n),l=0;if(s){s.push(",");for(var u,c=0;u=s[c];++c){var d=u.charCodeAt(0);if(44===d){if(0>=l){t&&a.push(i?{key:t,value:i.join("")}:{unknown:t}),t=i=l=0;continue}}else if(58===d){if(!i)continue}else if(47===d&&c&&1<u.length)(d=s[c-1].match(r))&&!o[d[0]]&&(e=e.substr(e.indexOf(u)+1),s=e.match(n),s.push(","),c=-1,u="/");else if(40===d||123===d||91===d)++l;else if(41===d||125===d||93===d)--l;else if(!t&&!i){t=34===d||39===d?u.slice(1,-1):u;continue}i?i.push(u):i=[u]}}return a}var t=["true","false","null","undefined"],i=/^(?:[$_a-z][$\w]*|(.+)(\.\s*[$_a-z][$\w]*|\[.+\]))$/i,n=RegExp("\"(?:[^\"\\\\]|\\\\.)*\"|'(?:[^'\\\\]|\\\\.)*'|/(?:[^/\\\\]|\\\\.)*/w*|[^\\s:,/][^,\"'{}()/:[\\]]*[^\\s,\"'{}()/:[\\]]|[^\\s]","g"),r=/[\])"'A-Za-z0-9_$]+$/,o={"in":1,"return":1,"typeof":1},a={};return{ha:[],V:a,Wa:e,ya:function(n,r){function o(e,n){var r;if(!c){var d=h.getBindingHandler(e);if(d&&d.preprocess&&!(n=d.preprocess(n,e,o)))return;(d=a[e])&&(r=n,0<=h.a.m(t,r)?r=!1:(d=r.match(i),r=null===d?!1:d[1]?"Object("+d[1]+")"+d[2]:r),d=r),d&&l.push("'"+e+"':function(_z){"+r+"=_z}")}u&&(n="function(){return "+n+" }"),s.push("'"+e+"':"+n)}r=r||{};var s=[],l=[],u=r.valueAccessors,c=r.bindingParams,d="string"==typeof n?e(n):n;return h.a.u(d,function(e){o(e.key||e.unknown,e.value)}),l.length&&o("_ko_property_writers","{"+l.join(",")+" }"),s.join(",")},lc:function(e,t){for(var i=0;i<e.length;i++)if(e[i].key==t)return!0;return!1},pa:function(e,t,i,n,r){e&&h.C(e)?!h.Ra(e)||r&&e.v()===n||e(n):(e=t.get("_ko_property_writers"))&&e[i]&&e[i](n)}}}(),h.b("expressionRewriting",h.h),h.b("expressionRewriting.bindingRewriteValidators",h.h.ha),h.b("expressionRewriting.parseObjectLiteral",h.h.Wa),h.b("expressionRewriting.preProcessBindings",h.h.ya),h.b("expressionRewriting._twoWayBindings",h.h.V),h.b("jsonExpressionRewriting",h.h),h.b("jsonExpressionRewriting.insertPropertyAccessorsIntoJson",h.h.ya),function(){function e(e){return 8==e.nodeType&&a.test(o?e.text:e.nodeValue)}function t(e){return 8==e.nodeType&&s.test(o?e.text:e.nodeValue)}function n(i,n){for(var r=i,o=1,a=[];r=r.nextSibling;){if(t(r)&&(o--,0===o))return a;a.push(r),e(r)&&o++}if(!n)throw Error("Cannot find closing comment tag to match: "+i.nodeValue);return null}function r(e,t){var i=n(e,t);return i?0<i.length?i[i.length-1].nextSibling:e.nextSibling:null}var o=i&&"<!--test-->"===i.createComment("test").text,a=o?/^\x3c!--\s*ko(?:\s+([\s\S]+))?\s*--\x3e$/:/^\s*ko(?:\s+([\s\S]+))?\s*$/,s=o?/^\x3c!--\s*\/ko\s*--\x3e$/:/^\s*\/ko\s*$/,l={ul:!0,ol:!0};h.f={Q:{},childNodes:function(t){return e(t)?n(t):t.childNodes},ja:function(t){if(e(t)){t=h.f.childNodes(t);for(var i=0,n=t.length;n>i;i++)h.removeNode(t[i])}else h.a.Ka(t)},T:function(t,i){if(e(t)){h.f.ja(t);for(var n=t.nextSibling,r=0,o=i.length;o>r;r++)n.parentNode.insertBefore(i[r],n)}else h.a.T(t,i)},Hb:function(t,i){e(t)?t.parentNode.insertBefore(i,t.nextSibling):t.firstChild?t.insertBefore(i,t.firstChild):t.appendChild(i)},Bb:function(t,i,n){n?e(t)?t.parentNode.insertBefore(i,n.nextSibling):n.nextSibling?t.insertBefore(i,n.nextSibling):t.appendChild(i):h.f.Hb(t,i)},firstChild:function(i){return e(i)?!i.nextSibling||t(i.nextSibling)?null:i.nextSibling:i.firstChild},nextSibling:function(i){return e(i)&&(i=r(i)),i.nextSibling&&t(i.nextSibling)?null:i.nextSibling},gc:e,xc:function(e){return(e=(o?e.text:e.nodeValue).match(a))?e[1]:null},Fb:function(i){if(l[h.a.t(i)]){var n=i.firstChild;if(n)do if(1===n.nodeType){var o;o=n.firstChild;var a=null;if(o)do if(a)a.push(o);else if(e(o)){var s=r(o,!0);s?o=s:a=[o]}else t(o)&&(a=[o]);while(o=o.nextSibling);if(o=a)for(a=n.nextSibling,s=0;s<o.length;s++)a?i.insertBefore(o[s],a):i.appendChild(o[s])}while(n=n.nextSibling)}}}}(),h.b("virtualElements",h.f),h.b("virtualElements.allowedBindings",h.f.Q),h.b("virtualElements.emptyNode",h.f.ja),h.b("virtualElements.insertAfter",h.f.Bb),h.b("virtualElements.prepend",h.f.Hb),h.b("virtualElements.setDomNodeChildren",h.f.T),function(){h.J=function(){this.Yb={}},h.a.extend(h.J.prototype,{nodeHasBindings:function(e){switch(e.nodeType){case 1:return null!=e.getAttribute("data-bind")||h.g.getComponentNameForNode(e);case 8:return h.f.gc(e);default:return!1}},getBindings:function(e,t){var i=this.getBindingsString(e,t),i=i?this.parseBindingsString(i,t,e):null;return h.g.mb(i,e,t,!1)},getBindingAccessors:function(e,t){var i=this.getBindingsString(e,t),i=i?this.parseBindingsString(i,t,e,{valueAccessors:!0}):null;return h.g.mb(i,e,t,!0)},getBindingsString:function(e){switch(e.nodeType){case 1:return e.getAttribute("data-bind");case 8:return h.f.xc(e);default:return null}},parseBindingsString:function(e,t,i,n){try{var r,o=this.Yb,a=e+(n&&n.valueAccessors||"");if(!(r=o[a])){var s,l="with($context){with($data||{}){return{"+h.h.ya(e,n)+"}}}";s=new Function("$context","$element",l),r=o[a]=s}return r(t,i)}catch(u){throw u.message="Unable to parse bindings.\nBindings value: "+e+"\nMessage: "+u.message,u}}}),h.J.instance=new h.J}(),h.b("bindingProvider",h.J),function(){function i(e){return function(){return e}}function n(e){return e()}function o(e){return h.a.na(h.k.B(e),function(t,i){return function(){return e()[i]}})}function a(e,t){return o(this.getBindings.bind(this,e,t))}function s(e,t,i){var n,r=h.f.firstChild(t),o=h.J.instance,a=o.preprocessNode;if(a){for(;n=r;)r=h.f.nextSibling(n),a.call(o,n);r=h.f.firstChild(t)}for(;n=r;)r=h.f.nextSibling(n),l(e,n,i)}function l(e,t,i){var n=!0,r=1===t.nodeType;r&&h.f.Fb(t),(r&&i||h.J.instance.nodeHasBindings(t))&&(n=c(t,null,e,i).shouldBindDescendants),n&&!m[h.a.t(t)]&&s(e,t,!r)}function u(e){var t=[],i={},n=[];return h.a.G(e,function r(o){if(!i[o]){var a=h.getBindingHandler(o);
a&&(a.after&&(n.push(o),h.a.u(a.after,function(t){if(e[t]){if(-1!==h.a.m(n,t))throw Error("Cannot combine the following bindings, because they have a cyclic dependency: "+n.join(", "));r(t)}}),n.length--),t.push({key:o,zb:a})),i[o]=!0}}),t}function c(t,i,r,o){var s=h.a.e.get(t,p);if(!i){if(s)throw Error("You cannot apply bindings multiple times to the same element.");h.a.e.set(t,p,!0)}!s&&o&&h.Ob(t,r);var l;if(i&&"function"!=typeof i)l=i;else{var c=h.J.instance,d=c.getBindingAccessors||a,m=h.j(function(){return(l=i?i(r,t):d.call(c,t,r))&&r.I&&r.I(),l},null,{o:t});l&&m.Z()||(m=null)}var f;if(l){var v=m?function(e){return function(){return n(m()[e])}}:function(e){return l[e]},g=function(){return h.a.na(m?m():l,n)};g.get=function(e){return l[e]&&n(v(e))},g.has=function(e){return e in l},o=u(l),h.a.u(o,function(i){var n=i.zb.init,o=i.zb.update,a=i.key;if(8===t.nodeType&&!h.f.Q[a])throw Error("The binding '"+a+"' cannot be used with virtual elements");try{"function"==typeof n&&h.k.B(function(){var i=n(t,v(a),g,r.$data,r);if(i&&i.controlsDescendantBindings){if(f!==e)throw Error("Multiple bindings ("+f+" and "+a+") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.");f=a}}),"function"==typeof o&&h.j(function(){o(t,v(a),g,r.$data,r)},null,{o:t})}catch(s){throw s.message='Unable to process binding "'+a+": "+l[a]+'"\nMessage: '+s.message,s}})}return{shouldBindDescendants:f===e}}function d(e){return e&&e instanceof h.N?e:new h.N(e)}h.d={};var m={script:!0};h.getBindingHandler=function(e){return h.d[e]},h.N=function(t,i,n,r){var o,a=this,s="function"==typeof t&&!h.C(t),l=h.j(function(){var e=s?t():t,o=h.a.c(e);return i?(i.I&&i.I(),h.a.extend(a,i),l&&(a.I=l)):(a.$parents=[],a.$root=o,a.ko=h),a.$rawData=e,a.$data=o,n&&(a[n]=o),r&&r(a,i,o),a.$data},null,{Ia:function(){return o&&!h.a.ob(o)},o:!0});l.Z()&&(a.I=l,l.equalityComparer=null,o=[],l.Tb=function(t){o.push(t),h.a.w.da(t,function(t){h.a.ua(o,t),o.length||(l.K(),a.I=l=e)})})},h.N.prototype.createChildContext=function(e,t,i){return new h.N(e,this,t,function(e,t){e.$parentContext=t,e.$parent=t.$data,e.$parents=(t.$parents||[]).slice(0),e.$parents.unshift(e.$parent),i&&i(e)})},h.N.prototype.extend=function(e){return new h.N(this.I||this.$data,this,null,function(t,i){t.$rawData=i.$rawData,h.a.extend(t,"function"==typeof e?e():e)})};var p=h.a.e.F(),f=h.a.e.F();h.Ob=function(e,t){return 2!=arguments.length?h.a.e.get(e,f):(h.a.e.set(e,f,t),t.I&&t.I.Tb(e),void 0)},h.ra=function(e,t,i){return 1===e.nodeType&&h.f.Fb(e),c(e,t,d(i),!0)},h.Wb=function(e,t,n){return n=d(n),h.ra(e,"function"==typeof t?o(t.bind(null,n,e)):h.a.na(t,i),n)},h.Ca=function(e,t){1!==t.nodeType&&8!==t.nodeType||s(d(e),t,!0)},h.pb=function(e,i){if(!r&&t.jQuery&&(r=t.jQuery),i&&1!==i.nodeType&&8!==i.nodeType)throw Error("ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node");i=i||t.document.body,l(d(e),i,!0)},h.Ha=function(t){switch(t.nodeType){case 1:case 8:var i=h.Ob(t);if(i)return i;if(t.parentNode)return h.Ha(t.parentNode)}return e},h.$b=function(t){return(t=h.Ha(t))?t.$data:e},h.b("bindingHandlers",h.d),h.b("applyBindings",h.pb),h.b("applyBindingsToDescendants",h.Ca),h.b("applyBindingAccessorsToNode",h.ra),h.b("applyBindingsToNode",h.Wb),h.b("contextFor",h.Ha),h.b("dataFor",h.$b)}(),function(e){function t(t,n){var a,s=r.hasOwnProperty(t)?r[t]:e;s||(s=r[t]=new h.P,i(t,function(e){o[t]=e,delete r[t],a?s.notifySubscribers(e):setTimeout(function(){s.notifySubscribers(e)},0)}),a=!0),s.U(n)}function i(e,t){n("getConfig",[e],function(i){i?n("loadComponent",[e,i],function(e){t(e)}):t(null)})}function n(t,i,r,o){o||(o=h.g.loaders.slice(0));var a=o.shift();if(a){var s=a[t];if(s){var l=!1;if(s.apply(a,i.concat(function(e){l?r(null):null!==e?r(e):n(t,i,r,o)}))!==e&&(l=!0,!a.suppressLoaderExceptions))throw Error("Component loaders must supply values by invoking the callback, not by returning values synchronously.")}else n(t,i,r,o)}else r(null)}var r={},o={};h.g={get:function(i,n){var r=o.hasOwnProperty(i)?o[i]:e;r?setTimeout(function(){n(r)},0):t(i,n)},tb:function(e){delete o[e]},jb:n},h.g.loaders=[],h.b("components",h.g),h.b("components.get",h.g.get),h.b("components.clearCachedDefinition",h.g.tb)}(),function(){function e(e,t,i,n){function r(){0===--s&&n(o)}var o={},s=2,l=i.template;i=i.viewModel,l?a(t,l,function(t){h.g.jb("loadTemplate",[e,t],function(e){o.template=e,r()})}):r(),i?a(t,i,function(t){h.g.jb("loadViewModel",[e,t],function(e){o[c]=e,r()})}):r()}function n(e,t,i){if("function"==typeof t)i(function(e){return new t(e)});else if("function"==typeof t[c])i(t[c]);else if("instance"in t){var r=t.instance;i(function(){return r})}else"viewModel"in t?n(e,t.viewModel,i):e("Unknown viewModel value: "+t)}function r(e){switch(h.a.t(e)){case"script":return h.a.ba(e.text);case"textarea":return h.a.ba(e.value);case"template":if(o(e.content))return h.a.ia(e.content.childNodes)}return h.a.ia(e.childNodes)}function o(e){return t.DocumentFragment?e instanceof DocumentFragment:e&&11===e.nodeType}function a(e,i,n){"string"==typeof i.require?s||t.require?(s||t.require)([i.require],n):e("Uses require, but no AMD loader is present"):n(i)}function l(e){return function(t){throw Error("Component '"+e+"': "+t)}}var u={};h.g.tc=function(e,t){if(!t)throw Error("Invalid configuration for "+e);if(h.g.Qa(e))throw Error("Component "+e+" is already registered");u[e]=t},h.g.Qa=function(e){return e in u},h.g.wc=function(e){delete u[e],h.g.tb(e)},h.g.ub={getConfig:function(e,t){t(u.hasOwnProperty(e)?u[e]:null)},loadComponent:function(t,i,n){var r=l(t);a(r,i,function(i){e(t,r,i,n)})},loadTemplate:function(e,n,a){if(e=l(e),"string"==typeof n)a(h.a.ba(n));else if(n instanceof Array)a(n);else if(o(n))a(h.a.S(n.childNodes));else if(n.element)if(n=n.element,t.HTMLElement?n instanceof HTMLElement:n&&n.tagName&&1===n.nodeType)a(r(n));else if("string"==typeof n){var s=i.getElementById(n);s?a(r(s)):e("Cannot find element with ID "+n)}else e("Unknown element type: "+n);else e("Unknown template value: "+n)},loadViewModel:function(e,t,i){n(l(e),t,i)}};var c="createViewModel";h.b("components.register",h.g.tc),h.b("components.isRegistered",h.g.Qa),h.b("components.unregister",h.g.wc),h.b("components.defaultLoader",h.g.ub),h.g.loaders.push(h.g.ub),h.g.Ub=u}(),function(){function e(e,i){var n=e.getAttribute("params");if(n){var n=t.parseBindingsString(n,i,e,{valueAccessors:!0,bindingParams:!0}),n=h.a.na(n,function(t){return h.s(t,null,{o:e})}),r=h.a.na(n,function(t){return t.Z()?h.s(function(){return h.a.c(t())},null,{o:e}):t.v()});return r.hasOwnProperty("$raw")||(r.$raw=n),r}return{$raw:{}}}h.g.getComponentNameForNode=function(e){return e=h.a.t(e),h.g.Qa(e)&&e},h.g.mb=function(t,i,n,r){if(1===i.nodeType){var o=h.g.getComponentNameForNode(i);if(o){if(t=t||{},t.component)throw Error('Cannot use the "component" binding on a custom element matching a component');var a={name:o,params:e(i,n)};t.component=r?function(){return a}:a}}return t};var t=new h.J;9>h.a.L&&(h.g.register=function(e){return function(t){return i.createElement(t),e.apply(this,arguments)}}(h.g.register),i.createDocumentFragment=function(e){return function(){var t,i=e(),n=h.g.Ub;for(t in n)n.hasOwnProperty(t)&&i.createElement(t);return i}}(i.createDocumentFragment))}(),function(){var e=0;h.d.component={init:function(t,i,n,r,o){function a(){var e=s&&s.dispose;"function"==typeof e&&e.call(s),l=null}var s,l;return h.a.w.da(t,a),h.s(function(){var n,r,u=h.a.c(i());if("string"==typeof u?n=u:(n=h.a.c(u.name),r=h.a.c(u.params)),!n)throw Error("No component name specified");var c=l=++e;h.g.get(n,function(e){if(l===c){if(a(),!e)throw Error("Unknown component '"+n+"'");var i=e.template;if(!i)throw Error("Component '"+n+"' has no template");i=h.a.ia(i),h.f.T(t,i);var i=r,u=e.createViewModel;e=u?u.call(e,i,{element:t}):i,i=o.createChildContext(e),s=e,h.Ca(i,t)}})},null,{o:t}),{controlsDescendantBindings:!0}}},h.f.Q.component=!0}();var _={"class":"className","for":"htmlFor"};h.d.attr={update:function(t,i){var n=h.a.c(i())||{};h.a.G(n,function(i,n){n=h.a.c(n);var r=!1===n||null===n||n===e;r&&t.removeAttribute(i),8>=h.a.L&&i in _?(i=_[i],r?t.removeAttribute(i):t[i]=n):r||t.setAttribute(i,n.toString()),"name"===i&&h.a.Mb(t,r?"":n.toString())})}},function(){h.d.checked={after:["value","attr"],init:function(t,i,n){function r(){var e=t.checked,r=d?a():e;if(!h.Y.ma()&&(!l||e)){var o=h.k.B(i);u?c!==r?(e&&(h.a.ea(o,r,!0),h.a.ea(o,c,!1)),c=r):h.a.ea(o,r,e):h.h.pa(o,n,"checked",r,!0)}}function o(){var e=h.a.c(i());t.checked=u?0<=h.a.m(e,a()):s?e:a()===e}var a=h.Ib(function(){return n.has("checkedValue")?h.a.c(n.get("checkedValue")):n.has("value")?h.a.c(n.get("value")):t.value}),s="checkbox"==t.type,l="radio"==t.type;if(s||l){var u=s&&h.a.c(i())instanceof Array,c=u?a():e,d=l||u;l&&!t.name&&h.d.uniqueName.init(t,function(){return!0}),h.s(r,null,{o:t}),h.a.n(t,"click",r),h.s(o,null,{o:t})}}},h.h.V.checked=!0,h.d.checkedValue={update:function(e,t){e.value=h.a.c(t())}}}(),h.d.css={update:function(e,t){var i=h.a.c(t());"object"==typeof i?h.a.G(i,function(t,i){i=h.a.c(i),h.a.Ba(e,t,i)}):(i=String(i||""),h.a.Ba(e,e.__ko__cssValue,!1),e.__ko__cssValue=i,h.a.Ba(e,i,!0))}},h.d.enable={update:function(e,t){var i=h.a.c(t());i&&e.disabled?e.removeAttribute("disabled"):i||e.disabled||(e.disabled=!0)}},h.d.disable={update:function(e,t){h.d.enable.update(e,function(){return!h.a.c(t())})}},h.d.event={init:function(e,t,i,n,r){var o=t()||{};h.a.G(o,function(o){"string"==typeof o&&h.a.n(e,o,function(e){var a,s=t()[o];if(s){try{var l=h.a.S(arguments);n=r.$data,l.unshift(n),a=s.apply(n,l)}finally{!0!==a&&(e.preventDefault?e.preventDefault():e.returnValue=!1)}!1===i.get(o+"Bubble")&&(e.cancelBubble=!0,e.stopPropagation&&e.stopPropagation())}})})}},h.d.foreach={Eb:function(e){return function(){var t=e(),i=h.a.Xa(t);return i&&"number"!=typeof i.length?(h.a.c(t),{foreach:i.data,as:i.as,includeDestroyed:i.includeDestroyed,afterAdd:i.afterAdd,beforeRemove:i.beforeRemove,afterRender:i.afterRender,beforeMove:i.beforeMove,afterMove:i.afterMove,templateEngine:h.O.Oa}):{foreach:t,templateEngine:h.O.Oa}}},init:function(e,t){return h.d.template.init(e,h.d.foreach.Eb(t))},update:function(e,t,i,n,r){return h.d.template.update(e,h.d.foreach.Eb(t),i,n,r)}},h.h.ha.foreach=!1,h.f.Q.foreach=!0,h.d.hasfocus={init:function(e,t,i){function n(n){e.__ko_hasfocusUpdating=!0;var r=e.ownerDocument;if("activeElement"in r){var o;try{o=r.activeElement}catch(a){o=r.body}n=o===e}r=t(),h.h.pa(r,i,"hasfocus",n,!0),e.__ko_hasfocusLastValue=n,e.__ko_hasfocusUpdating=!1}var r=n.bind(null,!0),o=n.bind(null,!1);h.a.n(e,"focus",r),h.a.n(e,"focusin",r),h.a.n(e,"blur",o),h.a.n(e,"focusout",o)},update:function(e,t){var i=!!h.a.c(t());e.__ko_hasfocusUpdating||e.__ko_hasfocusLastValue===i||(i?e.focus():e.blur(),h.k.B(h.a.oa,null,[e,i?"focusin":"focusout"]))}},h.h.V.hasfocus=!0,h.d.hasFocus=h.d.hasfocus,h.h.V.hasFocus=!0,h.d.html={init:function(){return{controlsDescendantBindings:!0}},update:function(e,t){h.a.$a(e,t())}},d("if"),d("ifnot",!1,!0),d("with",!0,!1,function(e,t){return e.createChildContext(t)});var y={};h.d.options={init:function(e){if("select"!==h.a.t(e))throw Error("options binding applies only to SELECT elements");for(;0<e.length;)e.remove(0);return{controlsDescendantBindings:!0}},update:function(t,i,n){function r(){return h.a.ta(t.options,function(e){return e.selected})}function o(e,t,i){var n=typeof t;return"function"==n?t(e):"string"==n?e[t]:i}function a(e,i){if(d.length){var n=0<=h.a.m(d,h.i.q(i[0]));h.a.Nb(i[0],n),m&&!n&&h.k.B(h.a.oa,null,[t,"change"])}}var s=0!=t.length&&t.multiple?t.scrollTop:null,l=h.a.c(i()),u=n.get("optionsIncludeDestroyed");i={};var c,d;d=t.multiple?h.a.Da(r(),h.i.q):0<=t.selectedIndex?[h.i.q(t.options[t.selectedIndex])]:[],l&&("undefined"==typeof l.length&&(l=[l]),c=h.a.ta(l,function(t){return u||t===e||null===t||!h.a.c(t._destroy)}),n.has("optionsCaption")&&(l=h.a.c(n.get("optionsCaption")),null!==l&&l!==e&&c.unshift(y)));var m=!1;i.beforeRemove=function(e){t.removeChild(e)},l=a,n.has("optionsAfterRender")&&(l=function(t,i){a(0,i),h.k.B(n.get("optionsAfterRender"),null,[i[0],t!==y?t:e])}),h.a.Za(t,c,function(i,r,a){return a.length&&(d=a[0].selected?[h.i.q(a[0])]:[],m=!0),r=t.ownerDocument.createElement("option"),i===y?(h.a.bb(r,n.get("optionsCaption")),h.i.ca(r,e)):(a=o(i,n.get("optionsValue"),i),h.i.ca(r,h.a.c(a)),i=o(i,n.get("optionsText"),a),h.a.bb(r,i)),[r]},i,l),h.k.B(function(){n.get("valueAllowUnset")&&n.has("value")?h.i.ca(t,h.a.c(n.get("value")),!0):(t.multiple?d.length&&r().length<d.length:d.length&&0<=t.selectedIndex?h.i.q(t.options[t.selectedIndex])!==d[0]:d.length||0<=t.selectedIndex)&&h.a.oa(t,"change")}),h.a.dc(t),s&&20<Math.abs(s-t.scrollTop)&&(t.scrollTop=s)}},h.d.options.Va=h.a.e.F(),h.d.selectedOptions={after:["options","foreach"],init:function(e,t,i){h.a.n(e,"change",function(){var n=t(),r=[];h.a.u(e.getElementsByTagName("option"),function(e){e.selected&&r.push(h.i.q(e))}),h.h.pa(n,i,"selectedOptions",r)})},update:function(e,t){if("select"!=h.a.t(e))throw Error("values binding applies only to SELECT elements");var i=h.a.c(t());i&&"number"==typeof i.length&&h.a.u(e.getElementsByTagName("option"),function(e){var t=0<=h.a.m(i,h.i.q(e));h.a.Nb(e,t)})}},h.h.V.selectedOptions=!0,h.d.style={update:function(t,i){var n=h.a.c(i()||{});h.a.G(n,function(i,n){n=h.a.c(n),(null===n||n===e||!1===n)&&(n=""),t.style[i]=n})}},h.d.submit={init:function(e,t,i,n,r){if("function"!=typeof t())throw Error("The value for a submit binding must be a function");h.a.n(e,"submit",function(i){var n,o=t();try{n=o.call(r.$data,e)}finally{!0!==n&&(i.preventDefault?i.preventDefault():i.returnValue=!1)}})}},h.d.text={init:function(){return{controlsDescendantBindings:!0}},update:function(e,t){h.a.bb(e,t())}},h.f.Q.text=!0,function(){if(t&&t.navigator)var i=function(e){return e?parseFloat(e[1]):void 0},n=t.opera&&t.opera.version&&parseInt(t.opera.version()),r=t.navigator.userAgent,o=i(r.match(/^(?:(?!chrome).)*version\/([^ ]*) safari/i)),a=i(r.match(/Firefox\/([^ ]*)/));if(10>h.a.L)var s=h.a.e.F(),l=h.a.e.F(),u=function(e){var t=this.activeElement;(t=t&&h.a.e.get(t,l))&&t(e)},c=function(e,t){var i=e.ownerDocument;h.a.e.get(i,s)||(h.a.e.set(i,s,!0),h.a.n(i,"selectionchange",u)),h.a.e.set(e,l,t)};h.d.textInput={init:function(t,i,r){function s(e,i){h.a.n(t,e,i)}function l(){var n=h.a.c(i());(null===n||n===e)&&(n=""),p!==e&&n===p?setTimeout(l,4):t.value!==n&&(f=n,t.value=n)}function u(){m||(p=t.value,m=setTimeout(d,4))}function d(){clearTimeout(m),p=m=e;var n=t.value;f!==n&&(f=n,h.h.pa(i(),r,"textInput",n))}var m,p,f=t.value;10>h.a.L?(s("propertychange",function(e){"value"===e.propertyName&&d()}),8==h.a.L&&(s("keyup",d),s("keydown",d)),8<=h.a.L&&(c(t,d),s("dragend",u))):(s("input",d),5>o&&"textarea"===h.a.t(t)?(s("keydown",u),s("paste",u),s("cut",u)):11>n?s("keydown",u):4>a&&(s("DOMAutoComplete",d),s("dragdrop",d),s("drop",d))),s("change",d),h.s(l,null,{o:t})}},h.h.V.textInput=!0,h.d.textinput={preprocess:function(e,t,i){i("textInput",e)}}}(),h.d.uniqueName={init:function(e,t){if(t()){var i="ko_unique_"+ ++h.d.uniqueName.Zb;h.a.Mb(e,i)}}},h.d.uniqueName.Zb=0,h.d.value={after:["options","foreach"],init:function(e,t,i){if("input"!=e.tagName.toLowerCase()||"checkbox"!=e.type&&"radio"!=e.type){var n=["change"],r=i.get("valueUpdate"),o=!1,a=null;r&&("string"==typeof r&&(r=[r]),h.a.ga(n,r),n=h.a.rb(n));var s=function(){a=null,o=!1;var n=t(),r=h.i.q(e);h.h.pa(n,i,"value",r)};!h.a.L||"input"!=e.tagName.toLowerCase()||"text"!=e.type||"off"==e.autocomplete||e.form&&"off"==e.form.autocomplete||-1!=h.a.m(n,"propertychange")||(h.a.n(e,"propertychange",function(){o=!0}),h.a.n(e,"focus",function(){o=!1}),h.a.n(e,"blur",function(){o&&s()})),h.a.u(n,function(t){var i=s;h.a.vc(t,"after")&&(i=function(){a=h.i.q(e),setTimeout(s,0)},t=t.substring(5)),h.a.n(e,t,i)});var l=function(){var n=h.a.c(t()),r=h.i.q(e);if(null!==a&&n===a)setTimeout(l,0);else if(n!==r)if("select"===h.a.t(e)){var o=i.get("valueAllowUnset"),r=function(){h.i.ca(e,n,o)};r(),o||n===h.i.q(e)?setTimeout(r,0):h.k.B(h.a.oa,null,[e,"change"])}else h.i.ca(e,n)};h.s(l,null,{o:e})}else h.ra(e,{checkedValue:t})},update:function(){}},h.h.V.value=!0,h.d.visible={update:function(e,t){var i=h.a.c(t()),n="none"!=e.style.display;i&&!n?e.style.display="":!i&&n&&(e.style.display="none")}},function(e){h.d[e]={init:function(t,i,n,r,o){return h.d.event.init.call(this,t,function(){var t={};return t[e]=i(),t},n,r,o)}}}("click"),h.H=function(){},h.H.prototype.renderTemplateSource=function(){throw Error("Override renderTemplateSource")},h.H.prototype.createJavaScriptEvaluatorBlock=function(){throw Error("Override createJavaScriptEvaluatorBlock")},h.H.prototype.makeTemplateSource=function(e,t){if("string"==typeof e){t=t||i;var n=t.getElementById(e);if(!n)throw Error("Cannot find template with ID "+e);return new h.r.l(n)}if(1==e.nodeType||8==e.nodeType)return new h.r.fa(e);throw Error("Unknown template type: "+e)},h.H.prototype.renderTemplate=function(e,t,i,n){return e=this.makeTemplateSource(e,n),this.renderTemplateSource(e,t,i)},h.H.prototype.isTemplateRewritten=function(e,t){return!1===this.allowTemplateRewriting?!0:this.makeTemplateSource(e,t).data("isRewritten")},h.H.prototype.rewriteTemplate=function(e,t,i){e=this.makeTemplateSource(e,i),t=t(e.text()),e.text(t),e.data("isRewritten",!0)},h.b("templateEngine",h.H),h.fb=function(){function e(e,t,i,n){e=h.h.Wa(e);for(var r=h.h.ha,o=0;o<e.length;o++){var a=e[o].key;if(r.hasOwnProperty(a)){var s=r[a];if("function"==typeof s){if(a=s(e[o].value))throw Error(a)}else if(!s)throw Error("This template engine does not support the '"+a+"' binding within its templates")}}return i="ko.__tr_ambtns(function($context,$element){return(function(){return{ "+h.h.ya(e,{valueAccessors:!0})+" } })()},'"+i.toLowerCase()+"')",n.createJavaScriptEvaluatorBlock(i)+t}var t=/(<([a-z]+\d*)(?:\s+(?!data-bind\s*=\s*)[a-z0-9\-]+(?:=(?:\"[^\"]*\"|\'[^\']*\'))?)*\s+)data-bind\s*=\s*(["'])([\s\S]*?)\3/gi,i=/\x3c!--\s*ko\b\s*([\s\S]*?)\s*--\x3e/g;return{ec:function(e,t,i){t.isTemplateRewritten(e,i)||t.rewriteTemplate(e,function(e){return h.fb.nc(e,t)},i)},nc:function(n,r){return n.replace(t,function(t,i,n,o,a){return e(a,i,n,r)}).replace(i,function(t,i){return e(i,"<!-- ko -->","#comment",r)})},Xb:function(e,t){return h.D.Ua(function(i,n){var r=i.nextSibling;r&&r.nodeName.toLowerCase()===t&&h.ra(r,e,n)})}}}(),h.b("__tr_ambtns",h.fb.Xb),function(){h.r={},h.r.l=function(e){this.l=e},h.r.l.prototype.text=function(){var e=h.a.t(this.l),e="script"===e?"text":"textarea"===e?"value":"innerHTML";if(0==arguments.length)return this.l[e];var t=arguments[0];"innerHTML"===e?h.a.$a(this.l,t):this.l[e]=t};var t=h.a.e.F()+"_";h.r.l.prototype.data=function(e){return 1===arguments.length?h.a.e.get(this.l,t+e):(h.a.e.set(this.l,t+e,arguments[1]),void 0)};var i=h.a.e.F();h.r.fa=function(e){this.l=e},h.r.fa.prototype=new h.r.l,h.r.fa.prototype.text=function(){if(0==arguments.length){var t=h.a.e.get(this.l,i)||{};return t.gb===e&&t.Ga&&(t.gb=t.Ga.innerHTML),t.gb}h.a.e.set(this.l,i,{gb:arguments[0]})},h.r.l.prototype.nodes=function(){return 0==arguments.length?(h.a.e.get(this.l,i)||{}).Ga:(h.a.e.set(this.l,i,{Ga:arguments[0]}),void 0)},h.b("templateSources",h.r),h.b("templateSources.domElement",h.r.l),h.b("templateSources.anonymousTemplate",h.r.fa)}(),function(){function t(e,t,i){var n;for(t=h.f.nextSibling(t);e&&(n=e)!==t;)e=h.f.nextSibling(n),i(n,e)}function i(e,i){if(e.length){var n=e[0],r=e[e.length-1],o=n.parentNode,a=h.J.instance,s=a.preprocessNode;if(s){if(t(n,r,function(e,t){var i=e.previousSibling,o=s.call(a,e);o&&(e===n&&(n=o[0]||t),e===r&&(r=o[o.length-1]||i))}),e.length=0,!n)return;n===r?e.push(n):(e.push(n,r),h.a.ka(e,o))}t(n,r,function(e){1!==e.nodeType&&8!==e.nodeType||h.pb(i,e)}),t(n,r,function(e){1!==e.nodeType&&8!==e.nodeType||h.D.Sb(e,[i])}),h.a.ka(e,o)}}function n(e){return e.nodeType?e:0<e.length?e[0]:null}function r(e,t,r,a,s){s=s||{};var l=e&&n(e),l=l&&l.ownerDocument,u=s.templateEngine||o;if(h.fb.ec(r,u,l),r=u.renderTemplate(r,a,s,l),"number"!=typeof r.length||0<r.length&&"number"!=typeof r[0].nodeType)throw Error("Template engine must return an array of DOM nodes");switch(l=!1,t){case"replaceChildren":h.f.T(e,r),l=!0;break;case"replaceNode":h.a.Lb(e,r),l=!0;break;case"ignoreTargetNode":break;default:throw Error("Unknown renderMode: "+t)}return l&&(i(r,a),s.afterRender&&h.k.B(s.afterRender,null,[r,a.$data])),r}var o;h.ab=function(t){if(t!=e&&!(t instanceof h.H))throw Error("templateEngine must inherit from ko.templateEngine");o=t},h.Ya=function(t,i,a,s,l){if(a=a||{},(a.templateEngine||o)==e)throw Error("Set a template engine before calling renderTemplate");if(l=l||"replaceChildren",s){var u=n(s);return h.j(function(){var e=i&&i instanceof h.N?i:new h.N(h.a.c(i)),o=h.C(t)?t():"function"==typeof t?t(e.$data,e):t,e=r(s,l,o,e,a);"replaceNode"==l&&(s=e,u=n(s))},null,{Ia:function(){return!u||!h.a.Ja(u)},o:u&&"replaceNode"==l?u.parentNode:u})}return h.D.Ua(function(e){h.Ya(t,i,a,e,"replaceNode")})},h.uc=function(t,n,o,a,s){function l(e,t){i(t,c),o.afterRender&&o.afterRender(t,e)}function u(e,i){c=s.createChildContext(e,o.as,function(e){e.$index=i});var n=h.C(t)?t():"function"==typeof t?t(e,c):t;return r(null,"ignoreTargetNode",n,c,o)}var c;return h.j(function(){var t=h.a.c(n)||[];"undefined"==typeof t.length&&(t=[t]),t=h.a.ta(t,function(t){return o.includeDestroyed||t===e||null===t||!h.a.c(t._destroy)}),h.k.B(h.a.Za,null,[a,t,u,o,l])},null,{o:a})};var a=h.a.e.F();h.d.template={init:function(e,t){var i=h.a.c(t());return"string"==typeof i||i.name?h.f.ja(e):(i=h.f.childNodes(e),i=h.a.oc(i),new h.r.fa(e).nodes(i)),{controlsDescendantBindings:!0}},update:function(t,i,n,r,o){var s,l=i();i=h.a.c(l),n=!0,r=null,"string"==typeof i?i={}:(l=i.name,"if"in i&&(n=h.a.c(i["if"])),n&&"ifnot"in i&&(n=!h.a.c(i.ifnot)),s=h.a.c(i.data)),"foreach"in i?r=h.uc(l||t,n&&i.foreach||[],i,t,o):n?(o="data"in i?o.createChildContext(s,i.as):o,r=h.Ya(l||t,o,i,t)):h.f.ja(t),o=r,(s=h.a.e.get(t,a))&&"function"==typeof s.K&&s.K(),h.a.e.set(t,a,o&&o.Z()?o:e)}},h.h.ha.template=function(e){return e=h.h.Wa(e),1==e.length&&e[0].unknown||h.h.lc(e,"name")?null:"This template engine does not support anonymous templates nested within its templates"},h.f.Q.template=!0}(),h.b("setTemplateEngine",h.ab),h.b("renderTemplate",h.Ya),h.a.wb=function(e,t,i){if(e.length&&t.length){var n,r,o,a,s;for(n=r=0;(!i||i>n)&&(a=e[r]);++r){for(o=0;s=t[o];++o)if(a.value===s.value){a.moved=s.index,s.moved=a.index,t.splice(o,1),n=o=0;break}n+=o}}},h.a.Fa=function(){function e(e,t,i,n,r){var o,a,s,l,u,c=Math.min,d=Math.max,m=[],p=e.length,f=t.length,v=f-p||1,g=p+f+1;for(o=0;p>=o;o++)for(l=s,m.push(s=[]),u=c(f,o+v),a=d(0,o-1);u>=a;a++)s[a]=a?o?e[o-1]===t[a-1]?l[a-1]:c(l[a]||g,s[a-1]||g)+1:a+1:o+1;for(c=[],d=[],v=[],o=p,a=f;o||a;)f=m[o][a]-1,a&&f===m[o][a-1]?d.push(c[c.length]={status:i,value:t[--a],index:a}):o&&f===m[o-1][a]?v.push(c[c.length]={status:n,value:e[--o],index:o}):(--a,--o,r.sparse||c.push({status:"retained",value:t[a]}));return h.a.wb(d,v,10*p),c.reverse()}return function(t,i,n){return n="boolean"==typeof n?{dontLimitMoves:n}:n||{},t=t||[],i=i||[],t.length<=i.length?e(t,i,"added","deleted",n):e(i,t,"deleted","added",n)}}(),h.b("utils.compareArrays",h.a.Fa),function(){function t(t,i,n,r,o){var a=[],s=h.j(function(){var e=i(n,o,h.a.ka(a,t))||[];0<a.length&&(h.a.Lb(a,e),r&&h.k.B(r,null,[n,e,o])),a.length=0,h.a.ga(a,e)},null,{o:t,Ia:function(){return!h.a.ob(a)}});return{$:a,j:s.Z()?s:e}}var i=h.a.e.F();h.a.Za=function(n,r,o,a,s){function l(e,t){C=d[t],g!==t&&(b[e]=C),C.Na(g++),h.a.ka(C.$,n),f.push(C),y.push(C)}function u(e,t){if(e)for(var i=0,n=t.length;n>i;i++)t[i]&&h.a.u(t[i].$,function(n){e(n,i,t[i].sa)})}r=r||[],a=a||{};var c=h.a.e.get(n,i)===e,d=h.a.e.get(n,i)||[],m=h.a.Da(d,function(e){return e.sa}),p=h.a.Fa(m,r,a.dontLimitMoves),f=[],v=0,g=0,_=[],y=[];r=[];for(var C,w,E,b=[],m=[],S=0;w=p[S];S++)switch(E=w.moved,w.status){case"deleted":E===e&&(C=d[v],C.j&&C.j.K(),_.push.apply(_,h.a.ka(C.$,n)),a.beforeRemove&&(r[S]=C,y.push(C))),v++;break;case"retained":l(S,v++);break;case"added":E!==e?l(S,E):(C={sa:w.value,Na:h.p(g++)},f.push(C),y.push(C),c||(m[S]=C))}u(a.beforeMove,b),h.a.u(_,a.beforeRemove?h.R:h.removeNode);for(var x,S=0,c=h.f.firstChild(n);C=y[S];S++){for(C.$||h.a.extend(C,t(n,o,C.sa,s,C.Na)),v=0;p=C.$[v];c=p.nextSibling,x=p,v++)p!==c&&h.f.Bb(n,p,x);!C.ic&&s&&(s(C.sa,C.$,C.Na),C.ic=!0)}u(a.beforeRemove,r),u(a.afterMove,b),u(a.afterAdd,m),h.a.e.set(n,i,f)}}(),h.b("utils.setDomNodeChildrenFromArrayMapping",h.a.Za),h.O=function(){this.allowTemplateRewriting=!1},h.O.prototype=new h.H,h.O.prototype.renderTemplateSource=function(e){var t=(9>h.a.L?0:e.nodes)?e.nodes():null;return t?h.a.S(t.cloneNode(!0).childNodes):(e=e.text(),h.a.ba(e))},h.O.Oa=new h.O,h.ab(h.O.Oa),h.b("nativeTemplateEngine",h.O),function(){h.Sa=function(){var e=this.kc=function(){if(!r||!r.tmpl)return 0;try{if(0<=r.tmpl.tag.tmpl.open.toString().indexOf("__"))return 2}catch(e){}return 1}();this.renderTemplateSource=function(t,n,o){if(o=o||{},2>e)throw Error("Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.");var a=t.data("precompiled");return a||(a=t.text()||"",a=r.template(null,"{{ko_with $item.koBindingContext}}"+a+"{{/ko_with}}"),t.data("precompiled",a)),t=[n.$data],n=r.extend({koBindingContext:n},o.templateOptions),n=r.tmpl(a,t,n),n.appendTo(i.createElement("div")),r.fragments={},n},this.createJavaScriptEvaluatorBlock=function(e){return"{{ko_code ((function() { return "+e+" })()) }}"},this.addTemplate=function(e,t){i.write("<script type='text/html' id='"+e+"'>"+t+"</script>")},e>0&&(r.tmpl.tag.ko_code={open:"__.push($1 || '');"},r.tmpl.tag.ko_with={open:"with($1) {",close:"} "})},h.Sa.prototype=new h.H;var e=new h.Sa;0<e.kc&&h.ab(e),h.b("jqueryTmplTemplateEngine",h.Sa)}()})}()}(),define("Cesium/ThirdParty/knockout-es5",[],function(){"use strict";function e(e,i){if(!e)throw new Error("When calling ko.track, you must pass an object as the first parameter.");var r=this,o=t(e,!0);return i=i||Object.getOwnPropertyNames(e),i.forEach(function(t){if(t!==d&&t!==h&&!(t in o)){var i=e[t],a=i instanceof Array,s=r.isObservable(i)?i:a?r.observableArray(i):r.observable(i);Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:s,set:r.isWriteableObservable(s)?s:void 0}),o[t]=s,a&&n(r,s)}}),e}function t(e,t){var i=e[d];return!i&&t&&(i={},Object.defineProperty(e,d,{value:i})),i}function i(t,i,n){var r=this,o={owner:t,deferEvaluation:!0};if("function"==typeof n)o.read=n;else{if("value"in n)throw new Error('For ko.defineProperty, you must not specify a "value" for the property. You must provide a "get" function.');if("function"!=typeof n.get)throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, or an options object containing a function called "get".');o.read=n.get,o.write=n.set}return t[i]=r.computed(o),e.call(r,t,[i]),t}function n(e,t){var i=null;e.computed(function(){i&&(i.dispose(),i=null);var n=t();n instanceof Array&&(i=r(e,t,n))})}function r(e,t,i){var n=o(e,i);return n.subscribe(t)}function o(e,t){var i=t[h];if(!i){i=new e.subscribable,Object.defineProperty(t,h,{value:i});var n={};a(t,i,n),s(e,t,i,n)}return i}function a(e,t,i){["pop","push","reverse","shift","sort","splice","unshift"].forEach(function(n){var r=e[n];e[n]=function(){var e=r.apply(this,arguments);return i.pause!==!0&&t.notifySubscribers(this),e}})}function s(e,t,i,n){["remove","removeAll","destroy","destroyAll","replace"].forEach(function(r){Object.defineProperty(t,r,{enumerable:!1,value:function(){var o;n.pause=!0;try{o=e.observableArray.fn[r].apply(e.observableArray(t),arguments)}finally{n.pause=!1}return i.notifySubscribers(t),o}})})}function l(e,i){if(!e)return null;var n=t(e,!1);return n&&n[i]||null}function u(e,t){var i=l(e,t);i&&i.valueHasMutated()}function c(t){t.track=e,t.getObservable=l,t.valueHasMutated=u,t.defineProperty=i}var d="__knockoutObservables",h="__knockoutSubscribable";return{attachToKo:c}}),define("Cesium/Widgets/SvgPathBindingHandler",[],function(){"use strict";var e="http://www.w3.org/2000/svg",t="cesium-svgPath-svg",i={register:function(i){i.bindingHandlers.cesiumSvgPath={init:function(n,r){var o=document.createElementNS(e,"svg:svg");o.setAttribute("class",t);var a=document.createElementNS(e,"path");return o.appendChild(a),i.virtualElements.setDomNodeChildren(n,[o]),i.computed({read:function(){var e=i.unwrap(r());a.setAttribute("d",i.unwrap(e.path));var n=i.unwrap(e.width),s=i.unwrap(e.height);o.setAttribute("width",n),o.setAttribute("height",s),o.setAttribute("viewBox","0 0 "+n+" "+s),e.css&&o.setAttribute("class",t+" "+i.unwrap(e.css))},disposeWhenNodeIsRemoved:n}),{controlsDescendantBindings:!0}}},i.virtualElements.allowedBindings.cesiumSvgPath=!0}};return i}),define("Cesium/ThirdParty/knockout",["./knockout-3.2.0","./knockout-es5","../Widgets/SvgPathBindingHandler"],function(e,t,i){"use strict";return t.attachToKo(e),i.register(e),e}),define("Cesium/Widgets/getElement",["../Core/DeveloperError"],function(){"use strict";var e=function(e){if("string"==typeof e){var t=document.getElementById(e);e=t}return e};return e}),define("Cesium/Widgets/subscribeAndEvaluate",["../ThirdParty/knockout"],function(e){"use strict";var t=function(t,i,n,r,o){return n.call(r,t[i]),e.getObservable(t,i).subscribe(n,r,o)};return t}),define("Cesium/Widgets/Animation/Animation",["../../Core/Color","../../Core/defined","../../Core/defineProperties","../../Core/destroyObject","../../Core/DeveloperError","../getElement","../subscribeAndEvaluate"],function(e,t,i,n,r,o,a){"use strict";function s(t){return e.fromCssColorString(window.getComputedStyle(t).getPropertyValue("color"))}function l(e){var t=document.createElementNS(v,e.tagName);for(var i in e)if(e.hasOwnProperty(i)&&"tagName"!==i)if("children"===i){var n,r=e.children.length;for(n=0;r>n;++n)t.appendChild(l(e.children[n]))}else 0===i.indexOf("xlink:")?t.setAttributeNS(g,i.substring(6),e[i]):"textContent"===i?t.textContent=e[i]:t.setAttribute(i,e[i]);return t}function u(e,t,i){var n=document.createElementNS(v,"text");n.setAttribute("x",e),n.setAttribute("y",t),n.setAttribute("class","cesium-animation-svgText");var r=document.createElementNS(v,"tspan");return r.textContent=i,n.appendChild(r),n}function c(e,t,i){e.setAttribute("transform","translate(100,100) rotate("+i+")"),t.setAttribute("transform","rotate("+i+")")}function d(e,t){var i=t.alpha,n=1-i;return T.red=e.red*n+t.red*i,T.green=e.green*n+t.green*i,T.blue=e.blue*n+t.blue*i,T.toCssColorString()}function h(e,t,i){var n={tagName:"g","class":"cesium-animation-rectButton",transform:"translate("+e+","+t+")",children:[{tagName:"rect","class":"cesium-animation-buttonGlow",width:32,height:32,rx:2,ry:2},{tagName:"rect","class":"cesium-animation-buttonMain",width:32,height:32,rx:4,ry:4},{tagName:"use","class":"cesium-animation-buttonPath","xlink:href":i},{tagName:"title",textContent:""}]};return l(n)}function m(e,t,i){var n={tagName:"g","class":"cesium-animation-rectButton",transform:"translate("+e+","+t+")",children:[{tagName:"use","class":"cesium-animation-buttonGlow","xlink:href":"#animation_pathWingButton"},{tagName:"use","class":"cesium-animation-buttonMain","xlink:href":"#animation_pathWingButton"},{tagName:"use","class":"cesium-animation-buttonPath","xlink:href":i},{tagName:"title",textContent:""}]};return l(n)}function p(e,t){var i=e._viewModel,n=i.shuttleRingDragging;if(!n||f===e)if("mousedown"===t.type||n&&"mousemove"===t.type||"touchstart"===t.type&&1===t.touches.length||n&&"touchmove"===t.type&&1===t.touches.length){var r,o,a=e._centerX,s=e._centerY,l=e._svgNode,u=l.getBoundingClientRect();if("touchstart"===t.type||"touchmove"===t.type?(r=t.touches[0].clientX,o=t.touches[0].clientY):(r=t.clientX,o=t.clientY),!n&&(r>u.right||r<u.left||o<u.top||o>u.bottom))return;var c=e._shuttleRingPointer.getBoundingClientRect(),d=r-a-u.left,h=o-s-u.top,m=180*Math.atan2(h,d)/Math.PI+90;
m>180&&(m-=360);var p=i.shuttleRingAngle;n||r<c.right&&r>c.left&&o>c.top&&o<c.bottom?(f=e,i.shuttleRingDragging=!0,i.shuttleRingAngle=m):p>m?i.slower():m>p&&i.faster(),t.preventDefault()}else e===f&&(f=void 0),i.shuttleRingDragging=!1}var f,v="http://www.w3.org/2000/svg",g="http://www.w3.org/1999/xlink",_=e.fromCssColorString("rgba(247,250,255,0.384)"),y=e.fromCssColorString("rgba(143,191,255,0.216)"),C=e.fromCssColorString("rgba(153,197,255,0.098)"),w=e.fromCssColorString("rgba(255,255,255,0.086)"),E=e.fromCssColorString("rgba(255,255,255,0.267)"),b=e.fromCssColorString("rgba(255,255,255,0)"),S=e.fromCssColorString("rgba(66,67,68,0.3)"),x=e.fromCssColorString("rgba(0,0,0,0.5)"),T=new e,P=function(e,t){this._viewModel=t,this.svgElement=e,this._enabled=void 0,this._toggled=void 0;var i=this;this._clickFunction=function(){var e=i._viewModel.command;e.canExecute&&e()},e.addEventListener("click",this._clickFunction,!0),this._subscriptions=[a(t,"toggled",this.setToggled,this),a(t,"tooltip",this.setTooltip,this),a(t.command,"canExecute",this.setEnabled,this)]};P.prototype.destroy=function(){this.svgElement.removeEventListener("click",this._clickFunction,!0);for(var e=this._subscriptions,t=0,i=e.length;i>t;t++)e[t].dispose();n(this)},P.prototype.isDestroyed=function(){return!1},P.prototype.setEnabled=function(e){if(this._enabled!==e){if(this._enabled=e,!e)return this.svgElement.setAttribute("class","cesium-animation-buttonDisabled"),void 0;if(this._toggled)return this.svgElement.setAttribute("class","cesium-animation-rectButton cesium-animation-buttonToggled"),void 0;this.svgElement.setAttribute("class","cesium-animation-rectButton")}},P.prototype.setToggled=function(e){this._toggled!==e&&(this._toggled=e,this._enabled&&(e?this.svgElement.setAttribute("class","cesium-animation-rectButton cesium-animation-buttonToggled"):this.svgElement.setAttribute("class","cesium-animation-rectButton")))},P.prototype.setTooltip=function(e){this.svgElement.getElementsByTagName("title")[0].textContent=e};var A=function(e,t){e=o(e),this._viewModel=t,this._container=e,this._centerX=0,this._centerY=0,this._defsElement=void 0,this._svgNode=void 0,this._topG=void 0,this._lastHeight=void 0,this._lastWidth=void 0;var i=document.createElement("style");i.textContent=".cesium-animation-rectButton .cesium-animation-buttonGlow { filter: url(#animation_blurred); }.cesium-animation-rectButton .cesium-animation-buttonMain { fill: url(#animation_buttonNormal); }.cesium-animation-buttonToggled .cesium-animation-buttonMain { fill: url(#animation_buttonToggled); }.cesium-animation-rectButton:hover .cesium-animation-buttonMain { fill: url(#animation_buttonHovered); }.cesium-animation-buttonDisabled .cesium-animation-buttonMain { fill: url(#animation_buttonDisabled); }.cesium-animation-shuttleRingG .cesium-animation-shuttleRingSwoosh { fill: url(#animation_shuttleRingSwooshGradient); }.cesium-animation-shuttleRingG:hover .cesium-animation-shuttleRingSwoosh { fill: url(#animation_shuttleRingSwooshHovered); }.cesium-animation-shuttleRingPointer { fill: url(#animation_shuttleRingPointerGradient); }.cesium-animation-shuttleRingPausePointer { fill: url(#animation_shuttleRingPointerPaused); }.cesium-animation-knobOuter { fill: url(#animation_knobOuter); }.cesium-animation-knobInner { fill: url(#animation_knobInner); }",document.head.insertBefore(i,document.head.childNodes[0]);var n=document.createElement("div");n.className="cesium-animation-theme",n.innerHTML='<div class="cesium-animation-themeNormal"></div><div class="cesium-animation-themeHover"></div><div class="cesium-animation-themeSelect"></div><div class="cesium-animation-themeDisabled"></div><div class="cesium-animation-themeKnob"></div><div class="cesium-animation-themePointer"></div><div class="cesium-animation-themeSwoosh"></div><div class="cesium-animation-themeSwooshHover"></div>',this._theme=n,this._themeNormal=n.childNodes[0],this._themeHover=n.childNodes[1],this._themeSelect=n.childNodes[2],this._themeDisabled=n.childNodes[3],this._themeKnob=n.childNodes[4],this._themePointer=n.childNodes[5],this._themeSwoosh=n.childNodes[6],this._themeSwooshHover=n.childNodes[7];var r=document.createElementNS(v,"svg:svg");this._svgNode=r,r.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink",g);var s=document.createElementNS(v,"g");this._topG=s,this._realtimeSVG=new P(m(3,4,"#animation_pathClock"),t.playRealtimeViewModel),this._playReverseSVG=new P(h(44,99,"#animation_pathPlayReverse"),t.playReverseViewModel),this._playForwardSVG=new P(h(124,99,"#animation_pathPlay"),t.playForwardViewModel),this._pauseSVG=new P(h(84,99,"#animation_pathPause"),t.pauseViewModel);var d=document.createElementNS(v,"g");d.appendChild(this._realtimeSVG.svgElement),d.appendChild(this._playReverseSVG.svgElement),d.appendChild(this._playForwardSVG.svgElement),d.appendChild(this._pauseSVG.svgElement);var f=l({tagName:"circle","class":"cesium-animation-shuttleRingBack",cx:100,cy:100,r:99});this._shuttleRingBackPanel=f;var _=l({tagName:"g","class":"cesium-animation-shuttleRingSwoosh",children:[{tagName:"use",transform:"translate(100,97) scale(-1,1)","xlink:href":"#animation_pathSwooshFX"},{tagName:"use",transform:"translate(100,97)","xlink:href":"#animation_pathSwooshFX"},{tagName:"line",x1:100,y1:8,x2:100,y2:22}]});this._shuttleRingSwooshG=_,this._shuttleRingPointer=l({tagName:"use","class":"cesium-animation-shuttleRingPointer","xlink:href":"#animation_pathPointer"});var y=l({tagName:"g",transform:"translate(100,100)"});this._knobOuter=l({tagName:"circle","class":"cesium-animation-knobOuter",cx:0,cy:0,r:71});var C=61,w=l({tagName:"circle","class":"cesium-animation-knobInner",cx:0,cy:0,r:C});this._knobDate=u(0,-24,""),this._knobTime=u(0,-7,""),this._knobStatus=u(0,-41,"");var E=l({tagName:"circle","class":"cesium-animation-blank",cx:0,cy:0,r:C}),b=document.createElementNS(v,"g");b.setAttribute("class","cesium-animation-shuttleRingG"),e.appendChild(n),s.appendChild(b),s.appendChild(y),s.appendChild(d),b.appendChild(f),b.appendChild(_),b.appendChild(this._shuttleRingPointer),y.appendChild(this._knobOuter),y.appendChild(w),y.appendChild(this._knobDate),y.appendChild(this._knobTime),y.appendChild(this._knobStatus),y.appendChild(E),r.appendChild(s),e.appendChild(r);var S=this,x=function(e){p(S,e)};this._mouseCallback=x,f.addEventListener("mousedown",x,!0),f.addEventListener("touchstart",x,!0),_.addEventListener("mousedown",x,!0),_.addEventListener("touchstart",x,!0),document.addEventListener("mousemove",x,!0),document.addEventListener("touchmove",x,!0),document.addEventListener("mouseup",x,!0),document.addEventListener("touchend",x,!0),this._shuttleRingPointer.addEventListener("mousedown",x,!0),this._shuttleRingPointer.addEventListener("touchstart",x,!0),this._knobOuter.addEventListener("mousedown",x,!0),this._knobOuter.addEventListener("touchstart",x,!0);var T,A=this._knobTime.childNodes[0],M=this._knobDate.childNodes[0],I=this._knobStatus.childNodes[0];this._subscriptions=[a(t.pauseViewModel,"toggled",function(e){T!==e&&(T=e,T?S._shuttleRingPointer.setAttribute("class","cesium-animation-shuttleRingPausePointer"):S._shuttleRingPointer.setAttribute("class","cesium-animation-shuttleRingPointer"))}),a(t,"shuttleRingAngle",function(e){c(S._shuttleRingPointer,S._knobOuter,e)}),a(t,"dateLabel",function(e){M.textContent!==e&&(M.textContent=e)}),a(t,"timeLabel",function(e){A.textContent!==e&&(A.textContent=e)}),a(t,"multiplierLabel",function(e){I.textContent!==e&&(I.textContent=e)})],this.applyThemeChanges(),this.resize()};return i(A.prototype,{container:{get:function(){return this._container}},viewModel:{get:function(){return this._viewModel}}}),A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){var e=this._mouseCallback;this._shuttleRingBackPanel.removeEventListener("mousedown",e,!0),this._shuttleRingBackPanel.removeEventListener("touchstart",e,!0),this._shuttleRingSwooshG.removeEventListener("mousedown",e,!0),this._shuttleRingSwooshG.removeEventListener("touchstart",e,!0),document.removeEventListener("mousemove",e,!0),document.removeEventListener("touchmove",e,!0),document.removeEventListener("mouseup",e,!0),document.removeEventListener("touchend",e,!0),this._shuttleRingPointer.removeEventListener("mousedown",e,!0),this._shuttleRingPointer.removeEventListener("touchstart",e,!0),this._knobOuter.removeEventListener("mousedown",e,!0),this._knobOuter.removeEventListener("touchstart",e,!0),this._container.removeChild(this._svgNode),this._container.removeChild(this._theme),this._realtimeSVG.destroy(),this._playReverseSVG.destroy(),this._playForwardSVG.destroy(),this._pauseSVG.destroy();for(var t=this._subscriptions,i=0,r=t.length;r>i;i++)t[i].dispose();return n(this)},A.prototype.resize=function(){var e=this._container.clientWidth,t=this._container.clientHeight;if(e!==this._lastWidth||t!==this._lastHeight){var i=this._svgNode,n=200,r=132,o=e,a=t;0===e&&0===t?(o=n,a=r):0===e?(a=t,o=n*(t/r)):0===t&&(o=e,a=r*(e/n));var s=o/n,l=a/r;i.style.cssText="width: "+o+"px; height: "+a+"px; position: absolute; bottom: 0; left: 0; overflow: hidden;",i.setAttribute("width",o),i.setAttribute("height",a),i.setAttribute("viewBox","0 0 "+o+" "+a),this._topG.setAttribute("transform","scale("+s+","+l+")"),this._centerX=Math.max(1,100*s),this._centerY=Math.max(1,100*l),this._lastHeight=e,this._lastWidth=t}},A.prototype.applyThemeChanges=function(){var e=s(this._themeNormal),i=s(this._themeHover),n=s(this._themeSelect),r=s(this._themeDisabled),o=s(this._themeKnob),a=s(this._themePointer),u=s(this._themeSwoosh),c=s(this._themeSwooshHover),h=l({tagName:"defs",children:[{id:"animation_buttonNormal",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-color":d(e,_)},{tagName:"stop",offset:"12%","stop-color":d(e,y)},{tagName:"stop",offset:"46%","stop-color":d(e,C)},{tagName:"stop",offset:"81%","stop-color":d(e,w)}]},{id:"animation_buttonHovered",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-color":d(i,_)},{tagName:"stop",offset:"12%","stop-color":d(i,y)},{tagName:"stop",offset:"46%","stop-color":d(i,C)},{tagName:"stop",offset:"81%","stop-color":d(i,w)}]},{id:"animation_buttonToggled",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-color":d(n,_)},{tagName:"stop",offset:"12%","stop-color":d(n,y)},{tagName:"stop",offset:"46%","stop-color":d(n,C)},{tagName:"stop",offset:"81%","stop-color":d(n,w)}]},{id:"animation_buttonDisabled",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-color":d(r,E)},{tagName:"stop",offset:"75%","stop-color":d(r,b)}]},{id:"animation_blurred",tagName:"filter",width:"200%",height:"200%",x:"-50%",y:"-50%",children:[{tagName:"feGaussianBlur",stdDeviation:4,"in":"SourceGraphic"}]},{id:"animation_shuttleRingSwooshGradient",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-opacity":.2,"stop-color":u.toCssColorString()},{tagName:"stop",offset:"85%","stop-opacity":.85,"stop-color":u.toCssColorString()},{tagName:"stop",offset:"95%","stop-opacity":.05,"stop-color":u.toCssColorString()}]},{id:"animation_shuttleRingSwooshHovered",tagName:"linearGradient",x1:"50%",y1:"0%",x2:"50%",y2:"100%",children:[{tagName:"stop",offset:"0%","stop-opacity":.2,"stop-color":c.toCssColorString()},{tagName:"stop",offset:"85%","stop-opacity":.85,"stop-color":c.toCssColorString()},{tagName:"stop",offset:"95%","stop-opacity":.05,"stop-color":c.toCssColorString()}]},{id:"animation_shuttleRingPointerGradient",tagName:"linearGradient",x1:"0%",y1:"50%",x2:"100%",y2:"50%",children:[{tagName:"stop",offset:"0%","stop-color":a.toCssColorString()},{tagName:"stop",offset:"40%","stop-color":a.toCssColorString()},{tagName:"stop",offset:"60%","stop-color":d(a,x)},{tagName:"stop",offset:"100%","stop-color":d(a,x)}]},{id:"animation_shuttleRingPointerPaused",tagName:"linearGradient",x1:"0%",y1:"50%",x2:"100%",y2:"50%",children:[{tagName:"stop",offset:"0%","stop-color":"#CCC"},{tagName:"stop",offset:"40%","stop-color":"#CCC"},{tagName:"stop",offset:"60%","stop-color":"#555"},{tagName:"stop",offset:"100%","stop-color":"#555"}]},{id:"animation_knobOuter",tagName:"linearGradient",x1:"20%",y1:"0%",x2:"90%",y2:"100%",children:[{tagName:"stop",offset:"5%","stop-color":d(o,_)},{tagName:"stop",offset:"60%","stop-color":d(o,S)},{tagName:"stop",offset:"85%","stop-color":d(o,y)}]},{id:"animation_knobInner",tagName:"linearGradient",x1:"20%",y1:"0%",x2:"90%",y2:"100%",children:[{tagName:"stop",offset:"5%","stop-color":d(o,S)},{tagName:"stop",offset:"60%","stop-color":d(o,_)},{tagName:"stop",offset:"85%","stop-color":d(o,w)}]},{id:"animation_pathReset",tagName:"path",transform:"translate(16,16) scale(0.85) translate(-16,-16)",d:"M24.316,5.318,9.833,13.682,9.833,5.5,5.5,5.5,5.5,25.5,9.833,25.5,9.833,17.318,24.316,25.682z"},{id:"animation_pathPause",tagName:"path",transform:"translate(16,16) scale(0.85) translate(-16,-16)",d:"M13,5.5,7.5,5.5,7.5,25.5,13,25.5zM24.5,5.5,19,5.5,19,25.5,24.5,25.5z"},{id:"animation_pathPlay",tagName:"path",transform:"translate(16,16) scale(0.85) translate(-16,-16)",d:"M6.684,25.682L24.316,15.5L6.684,5.318V25.682z"},{id:"animation_pathPlayReverse",tagName:"path",transform:"translate(16,16) scale(-0.85,0.85) translate(-16,-16)",d:"M6.684,25.682L24.316,15.5L6.684,5.318V25.682z"},{id:"animation_pathLoop",tagName:"path",transform:"translate(16,16) scale(0.85) translate(-16,-16)",d:"M24.249,15.499c-0.009,4.832-3.918,8.741-8.75,8.75c-2.515,0-4.768-1.064-6.365-2.763l2.068-1.442l-7.901-3.703l0.744,8.694l2.193-1.529c2.244,2.594,5.562,4.242,9.26,4.242c6.767,0,12.249-5.482,12.249-12.249H24.249zM15.499,6.75c2.516,0,4.769,1.065,6.367,2.764l-2.068,1.443l7.901,3.701l-0.746-8.693l-2.192,1.529c-2.245-2.594-5.562-4.245-9.262-4.245C8.734,3.25,3.25,8.734,3.249,15.499H6.75C6.758,10.668,10.668,6.758,15.499,6.75z"},{id:"animation_pathClock",tagName:"path",transform:"translate(16,16) scale(0.85) translate(-16,-15.5)",d:"M15.5,2.374C8.251,2.375,2.376,8.251,2.374,15.5C2.376,22.748,8.251,28.623,15.5,28.627c7.249-0.004,13.124-5.879,13.125-13.127C28.624,8.251,22.749,2.375,15.5,2.374zM15.5,25.623C9.909,25.615,5.385,21.09,5.375,15.5C5.385,9.909,9.909,5.384,15.5,5.374c5.59,0.01,10.115,4.535,10.124,10.125C25.615,21.09,21.091,25.615,15.5,25.623zM8.625,15.5c-0.001-0.552-0.448-0.999-1.001-1c-0.553,0-1,0.448-1,1c0,0.553,0.449,1,1,1C8.176,16.5,8.624,16.053,8.625,15.5zM8.179,18.572c-0.478,0.277-0.642,0.889-0.365,1.367c0.275,0.479,0.889,0.641,1.365,0.365c0.479-0.275,0.643-0.887,0.367-1.367C9.27,18.461,8.658,18.297,8.179,18.572zM9.18,10.696c-0.479-0.276-1.09-0.112-1.366,0.366s-0.111,1.09,0.365,1.366c0.479,0.276,1.09,0.113,1.367-0.366C9.821,11.584,9.657,10.973,9.18,10.696zM22.822,12.428c0.478-0.275,0.643-0.888,0.366-1.366c-0.275-0.478-0.89-0.642-1.366-0.366c-0.479,0.278-0.642,0.89-0.366,1.367C21.732,12.54,22.344,12.705,22.822,12.428zM12.062,21.455c-0.478-0.275-1.089-0.111-1.366,0.367c-0.275,0.479-0.111,1.09,0.366,1.365c0.478,0.277,1.091,0.111,1.365-0.365C12.704,22.344,12.54,21.732,12.062,21.455zM12.062,9.545c0.479-0.276,0.642-0.888,0.366-1.366c-0.276-0.478-0.888-0.642-1.366-0.366s-0.642,0.888-0.366,1.366C10.973,9.658,11.584,9.822,12.062,9.545zM22.823,18.572c-0.48-0.275-1.092-0.111-1.367,0.365c-0.275,0.479-0.112,1.092,0.367,1.367c0.477,0.275,1.089,0.113,1.365-0.365C23.464,19.461,23.3,18.848,22.823,18.572zM19.938,7.813c-0.477-0.276-1.091-0.111-1.365,0.366c-0.275,0.48-0.111,1.091,0.366,1.367s1.089,0.112,1.366-0.366C20.581,8.702,20.418,8.089,19.938,7.813zM23.378,14.5c-0.554,0.002-1.001,0.45-1.001,1c0.001,0.552,0.448,1,1.001,1c0.551,0,1-0.447,1-1C24.378,14.949,23.929,14.5,23.378,14.5zM15.501,6.624c-0.552,0-1,0.448-1,1l-0.46