/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return 2*(n.clamp(e,0,255)/255)-1},n.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},n.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},n.lerp=function(e,t,n){return(1-n)*e+n*t},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){var t=n.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},n.negativePiToPi=function(e){return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){var t=n.mod(e,n.TWO_PI);return Math.abs(t)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:t},n.mod=function(e,t){return(e%t+t)%t},n.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return a>=i||i<=r*Math.max(Math.abs(e),Math.abs(n))};var r=[1];n.factorial=function(e){var t=r.length;if(e>=t)for(var n=r[t-1],a=t;e>=a;a++)r.push(n*a);return r[e]},n.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},n.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,t,n){return t>e?t:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(t){a=new e(t)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)};i.fromSpherical=function(n,r){t(r)||(r=new i);var a=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(o),r},i.fromElements=function(e,n,r,a){return t(a)?(a.x=e,a.y=n,a.z=r,a):new i(e,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var n=i.dot(s,c),r=i.magnitude(i.cross(s,c,s));return Math.atan2(r,n)};var l=new i;i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):n.y<=n.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)},i.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,d=r*u-a*o;return n.x=c,n.y=l,n.z=d,n},i.fromDegrees=function(e,t,n,r,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,n,r,o)};var d=new i,f=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(n,r,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:h,c=Math.cos(r);d.x=c*Math.cos(n),d.y=c*Math.sin(n),d.z=Math.sin(r),d=i.normalize(d,d),i.multiplyComponents(s,d,f);var l=Math.sqrt(i.dot(d,f));return f=i.divideByScalar(f,l,f),d=i.multiplyByScalar(d,a,d),t(u)||(u=new i),i.add(f,d,u)},i.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=a.toRadians(e[o]);return i.fromRadiansArray(r,t,n)},i.fromRadiansArray=function(e,n,r){var a=e.length;t(r)?r.length=a/2:r=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=i.fromRadians(u,s,0,n,r[o/2])}return r},i.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=a.toRadians(e[o]),r[o+1]=a.toRadians(e[o+1]),r[o+2]=e[o+2];return i.fromRadiansArrayHeights(r,t,n)},i.fromRadiansArrayHeights=function(e,n,r){var a=e.length;t(r)?r.length=a/3:r=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=i.fromRadians(u,s,c,n,r[o/3])}return r},i.ZERO=r(new i(0,0,0)),i.UNIT_X=r(new i(1,0,0)),i.UNIT_Y=r(new i(0,1,0)),i.UNIT_Z=r(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r){this.longitude=e(t,0),this.latitude=e(n,0),this.height=e(r,0)};return i.fromRadians=function(n,r,a,o){return a=e(a,0),t(o)?(o.longitude=n,o.latitude=r,o.height=a,o):new i(n,r,a)},i.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,n,r)},i.clone=function(e,n){return t(e)?t(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height},i.equalsEpsilon=function(e,n,r){return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=r&&Math.abs(e.latitude-n.latitude)<=r&&Math.abs(e.height-n.height)<=r},i.ZERO=r(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,n)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,n){if(!r(t))return void 0;var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return r(t)||(t=new c),r(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,r,a){a=n(a,0),e.pack(t._radii,r,a)},c.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var l=new e,d=new e;c.prototype.cartographicToCartesian=function(t,n){var a=l,i=d;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var f=new e,h=new e,m=new e;c.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,h);if(!r(i))return void 0;var o=this.geodeticSurfaceNormal(i,f),s=e.subtract(n,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),d=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=d,a):new t(c,l,d)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var p=new e,y=new e;return c.prototype.scaleToGeodeticSurface=function(t,n){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,d=s.z,f=a*a*c*c,h=i*i*l*l,m=o*o*d*d,v=f+h+m,g=Math.sqrt(1/v),w=e.multiplyByScalar(t,g,p);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(w,n):void 0;var E=this._oneOverRadiiSquared,x=E.x,S=E.y,M=E.z,_=y;_.x=2*w.x*x,_.y=2*w.y*S,_.z=2*w.z*M;var O,T,P,A,R,N,z,I,b,C,D,U=(1-g)*e.magnitude(t)/(.5*e.magnitude(_)),L=0;do{U-=L,P=1/(1+U*x),A=1/(1+U*S),R=1/(1+U*M),N=P*P,z=A*A,I=R*R,b=N*P,C=z*A,D=I*R,O=f*N+h*z+m*I-1,T=f*b*x+h*C*S+m*D*M;var q=-2*T;L=O/q}while(Math.abs(O)>u.EPSILON12);return r(n)?(n.x=a*P,n.y=i*A,n.z=o*R,n):new e(a*P,i*A,o*R)},c.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},c.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},c.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";var u=function(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,n){this.start=e(t,0),this.stop=e(n,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n,r,a){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(a,0)};i.fromElements=function(e,n,r,a,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=a,o):new i(e,n,r,a)},i.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r++],a.z=n[r++],a.w=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,s);return i.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):n.y<=n.z?n.y<=n.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):n.z<=n.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)&&a.equalsEpsilon(e.z,n.z,r,i)&&a.equalsEpsilon(e.w,n.w,r,i)},i.ZERO=r(new i(0,0,0,0)),i.UNIT_X=r(new i(1,0,0,0)),i.UNIT_Y=r(new i(0,1,0,0)),i.UNIT_Z=r(new i(0,0,1,0)),i.UNIT_W=r(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function u(e){for(var t=0,n=0;3>n;++n){var r=e[c.getElementIndex(h[n],f[n])];t+=2*r*r}return Math.sqrt(t)}function s(e,t){for(var n=i.EPSILON15,r=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(h[o],f[o])]);u>r&&(a=o,r=u)}var s=1,l=0,d=f[a],m=h[a];if(Math.abs(e[c.getElementIndex(m,d)])>n){var p,y=e[c.getElementIndex(m,m)],v=e[c.getElementIndex(d,d)],g=e[c.getElementIndex(m,d)],w=(y-v)/2/g;p=0>w?-1/(-w+Math.sqrt(1+w*w)):1/(w+Math.sqrt(1+w*w)),s=1/Math.sqrt(1+p*p),l=p*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(d,d)]=t[c.getElementIndex(m,m)]=s,t[c.getElementIndex(m,d)]=l,t[c.getElementIndex(d,m)]=-l,t}var c=function(e,n,r,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},c.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,r,a){return r=t(r,0),n(a)||(a=new c),a[0]=e[r],a[1]=e[r+1],a[2]=e[r+2],a[3]=e[r+3],a[4]=e[r+4],a[5]=e[r+5],a[6]=e[r+6],a[7]=e[r+7],a[8]=e[r+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,d=e.z*e.z,f=e.z*e.w,h=e.w*e.w,m=r-u-d+h,p=2*(a-f),y=2*(i+l),v=2*(a+f),g=-r+u-d+h,w=2*(s-o),E=2*(i-l),x=2*(s+o),S=-r-u+d+h;return n(t)?(t[0]=m,t[1]=v,t[2]=E,t[3]=p,t[4]=g,t[5]=x,t[6]=y,t[7]=w,t[8]=S,t):new c(m,p,y,v,g,w,E,x,S)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new c(1,0,0,0,r,-a,0,a,r)},c.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new c(r,0,a,0,1,0,-a,0,r)},c.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(r,-a,0,a,r,0,0,0,1)},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},c.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var d=new e;c.getMaximumScale=function(t){return c.getScale(t,d),e.maximumComponent(d)},c.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=d,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],h=[2,2,1],m=new c,p=new c;return c.computeEigenDecomposition=function(e,t){var r=i.EPSILON20,a=10,l=0,d=0;n(t)||(t={});for(var f=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),y=r*o(h);a>d&&u(h)>y;)s(h,m),c.transpose(m,p),c.multiply(h,m,h),c.multiply(p,h,h),c.multiply(f,m,f),++l>2&&(++d,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},c.inverse=function(e,t){var n=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],d=e[6],f=e[7],h=e[8],m=c.determinant(e);if(Math.abs(m)<=i.EPSILON15)throw new r("matrix is not invertible");t[0]=s*h-f*l,t[1]=f*o-a*h,t[2]=a*l-s*o,t[3]=d*l-u*h,t[4]=n*h-d*o,t[5]=u*o-n*l,t[6]=u*f-d*s,t[7]=d*a-n*f,t[8]=n*s-u*a;var p=1/m;return c.multiplyByScalar(t,p,t)},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s){"use strict";var c=function(e,t,r,a,i,o,u,s,c,l,d,f,h,m,p,y){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(d,0),this[11]=n(p,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(y,0)};c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=n(a,e.ZERO),r(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,a){r(a)||(a=new c);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,d=t.x*t.z,f=t.x*t.w,h=t.y*t.y,m=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,g=t.w*t.w,w=s-h-y+g,E=2*(l-v),x=2*(d+p),S=2*(l+v),M=-s+h-y+g,_=2*(m-f),O=2*(d-p),T=2*(m+f),P=-s-h+y+g;return a[0]=w*i,a[1]=S*i,a[2]=O*i,a[3]=0,a[4]=E*o,a[5]=M*o,a[6]=T*o,a[7]=0,a[8]=x*u,a[9]=_*u,a[10]=P*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,d=new e,f=new e;c.fromCamera=function(t,n){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,d),d),e.normalize(e.cross(d,l,f),f);var u=d.x,s=d.y,h=d.z,m=l.x,p=l.y,y=l.z,v=f.x,g=f.y,w=f.z,E=a.x,x=a.y,S=a.z,M=u*-E+s*-x+h*-S,_=v*-E+g*-x+w*-S,O=m*E+p*x+y*S;return r(n)?(n[0]=u,n[1]=v,n[2]=-m,n[3]=0,n[4]=s,n[5]=g,n[6]=-p,n[7]=0,n[8]=h,n[9]=w,n[10]=-y,n[11]=0,n[12]=M,n[13]=_,n[14]=O,n[15]=1,n):new c(u,s,h,M,v,g,w,_,-m,-p,-y,O,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,d=-(r+n)*s,f=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=d,o[14]=f,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),d=-(i+a)/(i-a),f=-1,h=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=d,o[11]=f,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,d=-1,f=-2*a;
return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=d,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},c.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,d=.5*(r-t),f=c,h=l,m=d,p=i+c,y=o+l,v=t+d,g=1;return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=p,a[13]=y,a[14]=v,a[15]=g,a},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},c.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var h=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),n};var m=new e;c.getMaximumScale=function(t){return c.getScale(t,m),e.maximumComponent(m)},c.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],d=e[8],f=e[9],h=e[10],m=e[11],p=e[12],y=e[13],v=e[14],g=e[15],w=t[0],E=t[1],x=t[2],S=t[3],M=t[4],_=t[5],O=t[6],T=t[7],P=t[8],A=t[9],R=t[10],N=t[11],z=t[12],I=t[13],b=t[14],C=t[15],D=r*w+u*E+d*x+p*S,U=a*w+s*E+f*x+y*S,L=i*w+c*E+h*x+v*S,q=o*w+l*E+m*x+g*S,B=r*M+u*_+d*O+p*T,F=a*M+s*_+f*O+y*T,W=i*M+c*_+h*O+v*T,G=o*M+l*_+m*O+g*T,k=r*P+u*A+d*R+p*N,V=a*P+s*A+f*R+y*N,Y=i*P+c*A+h*R+v*N,j=o*P+l*A+m*R+g*N,H=r*z+u*I+d*b+p*C,Z=a*z+s*I+f*b+y*C,X=i*z+c*I+h*b+v*C,J=o*z+l*I+m*b+g*C;return n[0]=D,n[1]=U,n[2]=L,n[3]=q,n[4]=B,n[5]=F,n[6]=W,n[7]=G,n[8]=k,n[9]=V,n[10]=Y,n[11]=j,n[12]=H,n[13]=Z,n[14]=X,n[15]=J,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],d=e[10],f=e[12],h=e[13],m=e[14],p=t[0],y=t[1],v=t[2],g=t[4],w=t[5],E=t[6],x=t[8],S=t[9],M=t[10],_=t[12],O=t[13],T=t[14],P=r*p+o*y+c*v,A=a*p+u*y+l*v,R=i*p+s*y+d*v,N=r*g+o*w+c*E,z=a*g+u*w+l*E,I=i*g+s*w+d*E,b=r*x+o*S+c*M,C=a*x+u*S+l*M,D=i*x+s*S+d*M,U=r*_+o*O+c*T+f,L=a*_+u*O+l*T+h,q=i*_+s*O+d*T+m;return n[0]=P,n[1]=A,n[2]=R,n[3]=0,n[4]=N,n[5]=z,n[6]=I,n[7]=0,n[8]=b,n[9]=C,n[10]=D,n[11]=0,n[12]=U,n[13]=L,n[14]=q,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],d=e[10],f=t[0],h=t[1],m=t[2],p=t[3],y=t[4],v=t[5],g=t[6],w=t[7],E=t[8],x=r*f+o*h+c*m,S=a*f+u*h+l*m,M=i*f+s*h+d*m,_=r*p+o*y+c*v,O=a*p+u*y+l*v,T=i*p+s*y+d*v,P=r*g+o*w+c*E,A=a*g+u*w+l*E,R=i*g+s*w+d*E;return n[0]=x,n[1]=S,n[2]=M,n[3]=0,n[4]=_,n[5]=O,n[6]=T,n[7]=0,n[8]=P,n[9]=A,n[10]=R,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var p=new e;c.multiplyByUniformScale=function(e,t,n){return p.x=t,p.y=t,p.z=t,c.multiplyByScale(e,p,n)},c.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new u,v=new u,g=new t,w=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,y),v,o.EPSILON7)&&t.equals(c.getRow(e,3,g),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],l=e[12],d=e[1],f=e[5],h=e[9],m=e[13],p=e[2],E=e[6],x=e[10],S=e[14],M=e[3],_=e[7],O=e[11],T=e[15],P=x*T,A=S*O,R=E*T,N=S*_,z=E*O,I=x*_,b=p*T,C=S*M,D=p*O,U=x*M,L=p*_,q=E*M,B=P*f+N*h+z*m-(A*f+R*h+I*m),F=A*d+b*h+U*m-(P*d+C*h+D*m),W=R*d+C*f+L*m-(N*d+b*f+q*m),G=I*d+D*f+q*h-(z*d+U*f+L*h),k=A*a+R*i+I*l-(P*a+N*i+z*l),V=P*r+C*i+D*l-(A*r+b*i+U*l),Y=N*r+b*a+q*l-(R*r+C*a+L*l),j=z*r+U*a+L*i-(I*r+D*a+q*i);P=i*m,A=l*h,R=a*m,N=l*f,z=a*h,I=i*f,b=r*m,C=l*d,D=r*h,U=i*d,L=r*f,q=a*d;var H=P*_+N*O+z*T-(A*_+R*O+I*T),Z=A*M+b*O+U*T-(P*M+C*O+D*T),X=R*M+C*_+L*T-(N*M+b*_+q*T),J=I*M+D*_+q*O-(z*M+U*_+L*O),Q=R*x+I*S+A*E-(z*S+P*E+N*x),K=D*S+P*p+C*x-(b*x+U*S+A*p),$=b*E+q*S+N*p-(L*S+R*p+C*E),et=L*x+z*p+U*E-(D*E+q*x+I*p),tt=r*B+a*F+i*W+l*G;if(Math.abs(tt)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return tt=1/tt,n[0]=B*tt,n[1]=F*tt,n[2]=W*tt,n[3]=G*tt,n[4]=k*tt,n[5]=V*tt,n[6]=Y*tt,n[7]=j*tt,n[8]=H*tt,n[9]=Z*tt,n[10]=X*tt,n[11]=J*tt,n[12]=Q*tt,n[13]=K*tt,n[14]=$*tt,n[15]=et*tt,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],d=e[12],f=e[13],h=e[14],m=-n*d-r*f-a*h,p=-i*d-o*f-u*h,y=-s*d-c*f-l*h;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=m,t[13]=p,t[14]=y,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(a,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,a,i,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),n(o)?(o.west=e,o.south=r,o.east=a,o.north=i,o):new s(e,r,a,i)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];r=Math.min(r,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return n(t)?(t.west=r,t.south=i,t.east=a,t.north=o,t):new s(r,i,a,o)},s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.west=e[r++],a.south=e[r++],a.east=e[r++],a.north=e[r],a},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),d=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=d)return void 0;var f=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return f>=h?void 0:n(r)?(r.west=l,r.south=f,r.east=d,r.north=h,r):new s(l,f,d,h)},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(i>n||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,a,o){r=t(r,i.WGS84),a=t(a,0),n(o)||(o=[]);var l=0,d=e.north,f=e.south,h=e.east,m=e.west,p=c;p.height=a,p.longitude=m,p.latitude=d,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=h,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.latitude=f,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=m,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.latitude=0>d?d:f>0?f:0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(e,p)&&(o[l]=r.cartographicToCartesian(p,o[l]),l++);return 0===p.latitude&&(p.longitude=m,o[l]=r.cartographicToCartesian(p,o[l]),l++,p.longitude=h,o[l]=r.cartographicToCartesian(p,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l){"use strict";var d=function(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)},f=new e,h=new e,m=new e,p=new e,y=new e,v=new e,g=new e,w=new e,E=new e,x=new e,S=new e,M=new e;d.fromPoints=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var a=e.clone(t[0],g),i=e.clone(a,f),o=e.clone(a,h),u=e.clone(a,m),s=e.clone(a,p),c=e.clone(a,y),l=e.clone(a,v),_=t.length,O=1;_>O;O++){e.clone(t[O],a);var T=a.x,P=a.y,A=a.z;T<i.x&&e.clone(a,i),T>s.x&&e.clone(a,s),P<o.y&&e.clone(a,o),P>c.y&&e.clone(a,c),A<u.z&&e.clone(a,u),A>l.z&&e.clone(a,l)}var R=e.magnitudeSquared(e.subtract(s,i,w)),N=e.magnitudeSquared(e.subtract(c,o,w)),z=e.magnitudeSquared(e.subtract(l,u,w)),I=i,b=s,C=R;N>C&&(C=N,I=o,b=c),z>C&&(C=z,I=u,b=l);var D=E;D.x=.5*(I.x+b.x),D.y=.5*(I.y+b.y),D.z=.5*(I.z+b.z);var U=e.magnitudeSquared(e.subtract(b,D,w)),L=Math.sqrt(U),q=x;q.x=i.x,q.y=o.y,q.z=u.z;var B=S;B.x=s.x,B.y=c.y,B.z=l.z;var F=e.multiplyByScalar(e.add(q,B,w),.5,M),W=0;for(O=0;_>O;O++){e.clone(t[O],a);var G=e.magnitude(e.subtract(a,F,w));G>W&&(W=G);var k=e.magnitudeSquared(e.subtract(a,D,w));if(k>U){var V=Math.sqrt(k);L=.5*(L+V),U=L*L;var Y=V-L;D.x=(L*D.x+Y*a.x)/V,D.y=(L*D.y+Y*a.y)/V,D.z=(L*D.z+Y*a.z)/V}}return W>L?(e.clone(D,n.center),n.radius=L):(e.clone(F,n.center),n.radius=W),n};var _=new o,O=new e,T=new e,P=new t,A=new t;d.fromRectangle2D=function(e,t,n){return d.fromRectangleWithHeights2D(e,t,0,0,n)},d.fromRectangleWithHeights2D=function(t,a,i,o,u){if(r(u)||(u=new d),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,_),l.southwest(t,P),P.height=i,l.northeast(t,A),A.height=o;var s=a.project(P,O),c=a.project(A,T),f=c.x-s.x,h=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(f*f+h*h+m*m);var p=u.center;return p.x=s.x+.5*f,p.y=s.y+.5*h,p.z=s.z+.5*m,u};var R=[];d.fromRectangle3D=function(e,t,a,o){t=n(t,i.WGS84),a=n(a,0);var u;return r(e)&&(u=l.subsample(e,t,a,R)),d.fromPoints(u,o)},d.fromVertices=function(t,a,i,o){if(r(o)||(o=new d),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=n(a,e.ZERO),i=n(i,3);var u=g;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,f),c=e.clone(u,h),l=e.clone(u,m),_=e.clone(u,p),O=e.clone(u,y),T=e.clone(u,v),P=t.length,A=0;P>A;A+=i){var R=t[A]+a.x,N=t[A+1]+a.y,z=t[A+2]+a.z;u.x=R,u.y=N,u.z=z,R<s.x&&e.clone(u,s),R>_.x&&e.clone(u,_),N<c.y&&e.clone(u,c),N>O.y&&e.clone(u,O),z<l.z&&e.clone(u,l),z>T.z&&e.clone(u,T)}var I=e.magnitudeSquared(e.subtract(_,s,w)),b=e.magnitudeSquared(e.subtract(O,c,w)),C=e.magnitudeSquared(e.subtract(T,l,w)),D=s,U=_,L=I;b>L&&(L=b,D=c,U=O),C>L&&(L=C,D=l,U=T);var q=E;q.x=.5*(D.x+U.x),q.y=.5*(D.y+U.y),q.z=.5*(D.z+U.z);var B=e.magnitudeSquared(e.subtract(U,q,w)),F=Math.sqrt(B),W=x;W.x=s.x,W.y=c.y,W.z=l.z;var G=S;G.x=_.x,G.y=O.y,G.z=T.z;var k=e.multiplyByScalar(e.add(W,G,w),.5,M),V=0;for(A=0;P>A;A+=i){u.x=t[A]+a.x,u.y=t[A+1]+a.y,u.z=t[A+2]+a.z;var Y=e.magnitude(e.subtract(u,k,w));Y>V&&(V=Y);var j=e.magnitudeSquared(e.subtract(u,q,w));if(j>B){var H=Math.sqrt(j);F=.5*(F+H),B=F*F;var Z=H-F;q.x=(F*q.x+Z*u.x)/H,q.y=(F*q.y+Z*u.y)/H,q.z=(F*q.z+Z*u.z)/H}}return V>F?(e.clone(q,o.center),o.radius=F):(e.clone(k,o.center),o.radius=V),o},d.fromCornerPoints=function(t,n,a){r(a)||(a=new d);var i=a.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,n),a},d.fromEllipsoid=function(t,n){return r(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var N=new e;d.fromBoundingSpheres=function(t,n){if(r(n)||(n=new d),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=t.length;if(1===a)return d.clone(t[0],n);if(2===a)return d.union(t[0],t[1],n);for(var i=[],o=0;a>o;o++)i.push(t[o].center);n=d.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,N)+c.radius)}return n.radius=s,n},d.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,r){r=n(r,0);var a=e.center;t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius},d.unpack=function(e,t,a){t=n(t,0),r(a)||(a=new d);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var z=new e,I=new e;d.union=function(t,n,a){r(a)||(a=new d);var i=t.center,o=n.center;e.add(i,o,I);var u=e.multiplyByScalar(I,.5,I),s=e.magnitude(e.subtract(i,u,z))+t.radius,c=e.magnitude(e.subtract(o,u,z))+n.radius;return a.radius=Math.max(s,c),e.clone(u,a.center),a};var b=new e;d.expand=function(t,n,r){r=d.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,b));return a>r.radius&&(r.radius=a),r},d.intersect=function(t,n){var r=t.center,a=t.radius,i=e.dot(n,r)+n.w;return-a>i?u.OUTSIDE:a>i?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r(n)||(n=new d),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=c.getMaximumScale(t)*e.radius,n};var C=new e;d.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,C);return e.magnitudeSquared(r)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r(n)||(n=new d),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var D=new e;d.computePlaneDistances=function(t,n,a,i){r(i)||(i=new s);var o=e.subtract(t.center,n,D),u=e.multiplyByScalar(a,e.dot(a,o),D),c=e.magnitude(u);return i.start=c-t.radius,i.stop=c+t.radius,i};for(var U=new e,L=new e,q=new e,B=new e,F=new e,W=new t,G=new Array(8),k=0;8>k;++k)G[k]=new e;var V=new o;return d.projectTo2D=function(t,r,a){r=n(r,V);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,U),c=e.cross(e.UNIT_Z,s,L);e.normalize(c,c);var l=e.cross(s,c,q);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,F),h=e.negate(c,B),m=G,p=m[0];e.add(s,l,p),e.add(p,c,p),p=m[1],e.add(s,l,p),e.add(p,h,p),p=m[2],e.add(s,f,p),e.add(p,h,p),p=m[3],e.add(s,f,p),e.add(p,c,p),e.negate(s,s),p=m[4],e.add(s,l,p),e.add(p,c,p),p=m[5],e.add(s,l,p),e.add(p,h,p),p=m[6],e.add(s,f,p),e.add(p,h,p),p=m[7],e.add(s,f,p),e.add(p,c,p);for(var y=m.length,v=0;y>v;++v){var g=m[v];e.add(o,g,g);var w=i.cartesianToCartographic(g,W);r.project(w,g)}a=d.fromPoints(m,a),o=a.center;var E=o.x,x=o.y,S=o.z;return o.x=S,o.y=E,o.z=x,a},d.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},d.prototype.intersect=function(e){return d.intersect(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?r.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(r.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[r.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,v=r(e[1]))}return y}function i(){return a()&&v}function o(){if(!t(g)&&(g=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,w=r(e[1]))}return g}function u(){return o()&&w}function s(){if(!t(E)){E=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(E=!0,x=r(e[1]),x.isNightly=!!e[2])}return E}function c(){return s()&&x}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,M=r(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,M=r(e[1])))}return S}function d(){return l()&&M}function f(){if(!t(_)){_=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,O=r(e[1]))}return _}function h(){return t(T)||(T=/Windows/i.test(navigator.appVersion)),T}function m(){return f()&&O}function p(){return t(P)||(P=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),P}var y,v,g,w,E,x,S,M,_,O,T,P,A={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:d,isFirefox:f,firefoxVersion:m,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:p};return A.supportsFullscreen=function(){return n.supportsFullscreen()},A.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},A.supportsWebWorkers=function(){return"undefined"!=typeof Worker},A}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,a){"use strict";if(!r.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(t,r,a,o){switch(a=e(a,0),o=e(o,(r.byteLength-a)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(r,a,o);case i.UNSIGNED_BYTE:return new Uint8Array(r,a,o);case i.SHORT:return new Int16Array(r,a,o);case i.UNSIGNED_SHORT:return new Uint16Array(r,a,o);case i.FLOAT:return new Float32Array(r,a,o);case i.DOUBLE:return new Float64Array(r,a,o);default:throw new n("componentDatatype is not a valid value.")}},a(i)}),define("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){var t=e._uSquared,n=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,a=(n-r)/n,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),d=s*o,f=d*d,h=1-f,m=Math.sqrt(h),p=t/4,y=p*p,v=y*p,g=y*y,w=1+p-3*y/4+5*v/4-175*g/64,E=1-p+15*y/8-35*v/8,x=1-3*p+35*y/4,S=1-5*p,M=w*l-E*Math.sin(2*l)*p/2-x*Math.sin(4*l)*y/16-S*Math.sin(6*l)*v/48-5*Math.sin(8*l)*g/512,_=e._constants;_.a=n,_.b=r,_.f=a,_.cosineHeading=i,_.sineHeading=o,_.tanU=u,_.cosineU=s,_.sineU=c,_.sigma=l,_.sineAlpha=d,_.sineSquaredAlpha=f,_.cosineSquaredAlpha=h,_.cosineAlpha=m,_.u2Over4=p,_.u4Over16=y,_.u6Over64=v,_.u8Over256=g,_.a0=w,_.a1=E,_.a2=x,_.a3=S,_.distanceRatio=M}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,n,r,a,i,o){var u=c(e,n);return(1-u)*e*t*(r+u*a*(o+u*i*(2*o*o-1)))}function d(e,t,n,r,a,i,o){var s,c,d,f,h,m=(t-n)/t,p=i-r,y=Math.atan((1-m)*Math.tan(a)),v=Math.atan((1-m)*Math.tan(o)),g=Math.cos(y),w=Math.sin(y),E=Math.cos(v),x=Math.sin(v),S=g*E,M=g*x,_=w*x,O=w*E,T=p,P=u.TWO_PI,A=Math.cos(T),R=Math.sin(T);do{A=Math.cos(T),R=Math.sin(T);var N=M-O*A;d=Math.sqrt(E*E*R*R+N*N),c=_+S*A,s=Math.atan2(d,c);var z;0===d?(z=0,f=1):(z=S*R/d,f=1-z*z),P=T,h=c-2*_/f,isNaN(h)&&(h=0),T=p+l(m,z,f,s,d,c,h)}while(Math.abs(T-P)>u.EPSILON12);var I=f*(t*t-n*n)/(n*n),b=1+I*(4096+I*(I*(320-175*I)-768))/16384,C=I*(256+I*(I*(74-47*I)-128))/1024,D=h*h,U=C*d*(h+C*(c*(2*D-1)-C*h*(4*d*d-3)*(4*D-3)/6)/4),L=n*b*(s-U),q=Math.atan2(E*R,M-O*A),B=Math.atan2(g*R,M*A-O);e._distance=L,e._startHeading=q,e._endHeading=B,e._uSquared=I}function f(n,r,a,i){e.normalize(i.cartographicToCartesian(r,m),h),e.normalize(i.cartographicToCartesian(a,m),m),d(n,i.maximumRadius,i.minimumRadius,r.longitude,r.latitude,a.longitude,a.latitude),n._start=t.clone(r,n._start),n._end=t.clone(a,n._end),n._start.height=0,n._end.height=0,s(n)}var h=new e,m=new e,p=function(e,a,i){var u=n(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,r(e)&&r(a)&&f(this,e,a,u)};return a(p.prototype,{surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),p.prototype.setEndPoints=function(e,t){f(this,e,t,this._ellipsoid)},p.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},p.prototype.interpolateUsingSurfaceDistance=function(e,n){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),d=Math.sin(4*i),f=Math.sin(6*i),h=Math.sin(8*i),m=i*i,p=i*m,y=a.u8Over256,v=a.u2Over4,g=a.u6Over64,w=a.u4Over16,E=2*p*y*o/3+i*(1-v+7*w/4-15*g/4+579*y/64-(w-15*g/4+187*y/16)*o-(5*g/4-115*y/16)*u-29*y*s/16)+(v/2-w+71*g/32-85*y/16)*c+(5*w/16-5*g/4+383*y/96)*d-m*((g-11*y/2)*c+5*y*d/2)+(29*g/96-29*y/16)*f+539*y*h/1536,x=Math.asin(Math.sin(E)*a.cosineAlpha),S=Math.atan(a.a/a.b*Math.tan(x));E-=a.sigma;var M=Math.cos(2*a.sigma+E),_=Math.sin(E),O=Math.cos(E),T=a.cosineU*O,P=a.sineU*_,A=Math.atan2(_*a.sineHeading,T-P*a.cosineHeading),R=A-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,E,_,O,M);return r(n)?(n.longitude=this._start.longitude+R,n.latitude=S,n.height=0,n):new t(this._start.longitude+R,S,0)},p}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,0>i?[i,0]:[0,i];var c=r*r,l=4*e*a,d=n(c,-l,t.EPSILON14);if(0>d)return[];var f=-.5*n(r,t.sign(r)*Math.sqrt(d),t.EPSILON14);return r>0?[f/e,a/f]:[a/f,f/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,d=u*c,f=u*u,h=s*s,m=o*s-f,p=o*c-u*s,y=u*c-h,v=4*m*y-p*p;if(0>v){var g,w,E;f*d>=l*h?(g=o,w=m,E=-2*u*m+o*p):(g=c,w=y,E=-c*p+2*s*y);var x=0>E?-1:1,S=-x*Math.abs(g)*Math.sqrt(-v);i=-E+S;var M=i/2,_=0>M?-Math.pow(-M,1/3):Math.pow(M,1/3),O=i===S?-_:-w/_;return a=0>=w?_+O:-E/(_*_+O*O+w),f*d>=l*h?[(a-u)/o]:[-c/(a+s)]}var T=m,P=-2*u*m+o*p,A=y,R=-c*p+2*s*y,N=Math.sqrt(v),z=Math.sqrt(3)/2,I=Math.abs(Math.atan2(o*N,-P)/3);a=2*Math.sqrt(-T);var b=Math.cos(I);i=a*b;var C=a*(-b/2-z*Math.sin(I)),D=i+C>2*u?i-u:C-u,U=o,L=D/U;I=Math.abs(Math.atan2(c*N,-R)/3),a=2*Math.sqrt(-A),b=Math.cos(I),i=a*b,C=a*(-b/2-z*Math.sin(I));var q=-c,B=2*s>i+C?i+s:C+s,F=q/B,W=U*B,G=-D*B-U*q,k=D*q,V=(s*G-u*k)/(-u*G+s*W);return V>=L?F>=L?F>=V?[L,V,F]:[L,F,V]:[F,L,V]:F>=L?[V,L,F]:F>=V?[V,F,L]:[F,V,L]
}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,0>u?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,d=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(d.length>0){var f=-t/4,h=d[d.length-1];if(Math.abs(h)<n.EPSILON14){var m=r.computeRealRoots(1,s,l);if(2===m.length){var p,y=m[0],v=m[1];if(y>=0&&v>=0){var g=Math.sqrt(y),w=Math.sqrt(v);return[f-w,f-g,f+g,f+w]}if(y>=0&&0>v)return p=Math.sqrt(y),[f-p,f+p];if(0>y&&v>=0)return p=Math.sqrt(v),[f-p,f+p]}return[]}if(h>0){var E=Math.sqrt(h),x=(s+h-c/E)/2,S=(s+h+c/E)/2,M=r.computeRealRoots(1,E,x),_=r.computeRealRoots(1,-E,S);return 0!==M.length?(M[0]+=f,M[1]+=f,0!==_.length?(_[0]+=f,_[1]+=f,M[1]<=_[0]?[M[0],M[1],_[0],_[1]]:_[1]<=M[0]?[_[0],_[1],M[0],M[1]]:M[0]>=_[0]&&M[1]<=_[1]?[_[0],M[0],M[1],_[1]]:_[0]>=M[0]&&_[1]<=M[1]?[M[0],_[0],_[1],M[1]]:M[0]>_[0]&&M[0]<_[1]?[_[0],M[0],_[1],M[1]]:[M[0],_[0],M[1],_[1]]):M):0!==_.length?(_[0]+=f,_[1]+=f,_):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,d=i*t+s-4*o,f=c*o-i*a*t+u,h=e.computeRealRoots(1,l,d,f);if(h.length>0){var m,p,y=h[0],v=a-y,g=v*v,w=t/2,E=v/2,x=g-4*o,S=g+4*Math.abs(o),M=c-4*y,_=c+4*Math.abs(y);if(0>y||M*S>x*_){var O=Math.sqrt(M);m=O/2,p=0===O?0:(t*E-i)/O}else{var T=Math.sqrt(x);m=0===T?0:(t*E-i)/T,p=T/2}var P,A;0===w&&0===m?(P=0,A=0):n.sign(w)===n.sign(m)?(P=w+m,A=y/P):(A=w-m,P=y/A);var R,N;0===E&&0===p?(R=0,N=0):n.sign(E)===n.sign(p)?(R=E+p,N=o/R):(N=E-p,R=o/N);var z=r.computeRealRoots(1,P,R),I=r.computeRealRoots(1,A,N);if(0!==z.length)return 0!==I.length?z[1]<=I[0]?[z[0],z[1],I[0],I[1]]:I[1]<=z[0]?[I[0],I[1],z[0],z[1]]:z[0]>=I[0]&&z[1]<=I[1]?[I[0],z[0],z[1],I[1]]:I[0]>=z[0]&&I[1]<=z[1]?[z[0],I[0],I[1],z[1]]:z[0]>I[0]&&z[0]<I[1]?[I[0],z[0],I[1],z[1]]:[z[0],I[0],z[1],I[1]]:z;if(0!==I.length)return I}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,d=r*r,f=d*r,h=a*a,m=h*a,p=u*c*d-4*s*f-4*e*l*d+18*e*t*n*f-27*i*d*d+256*o*m+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*d+144*i*n*d)+h*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return p},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,d=u/t,f=s/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>d?h+1:h,h+=0>f?h+1:h){case 0:return a(c,l,d,f);case 1:return i(c,l,d,f);case 2:return i(c,l,d,f);case 3:return a(c,l,d,f);case 4:return a(c,l,d,f);case 5:return i(c,l,d,f);case 6:return a(c,l,d,f);case 7:return a(c,l,d,f);case 8:return i(c,l,d,f);case 9:return a(c,l,d,f);case 10:return a(c,l,d,f);case 11:return i(c,l,d,f);case 12:return a(c,l,d,f);case 13:return a(c,l,d,f);case 14:return a(c,l,d,f);case 15:return a(c,l,d,f);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";var r=function(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r};return r.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},r}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(t,r,a,o,u){u=n(u,!1);var s,c,l,d,f,h=t.origin,m=t.direction,p=e.subtract(a,r,y),x=e.subtract(o,r,v),S=e.cross(m,x,g),M=e.dot(p,S);if(u){if(M<i.EPSILON6)return void 0;if(s=e.subtract(h,r,w),l=e.dot(s,S),0>l||l>M)return void 0;if(c=e.cross(s,p,E),d=e.dot(m,c),0>d||l+d>M)return void 0;f=e.dot(x,c)/M}else{if(Math.abs(M)<i.EPSILON6)return void 0;var _=1/M;if(s=e.subtract(h,r,w),l=e.dot(s,S)*_,0>l||l>1)return void 0;if(c=e.cross(s,p,E),d=e.dot(m,c)*_,0>d||l+d>1)return void 0;f=e.dot(x,c)*_}return f}function d(e,t,n,r){var a=t*t-4*e*n;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);return 0===c?void 0:(r.root0=r.root1=c,r)}function f(t,n,a){r(a)||(a={});var i=t.origin,o=t.direction,u=n.center,s=n.radius*n.radius,c=e.subtract(i,u,g),l=e.dot(o,o),f=2*e.dot(o,c),h=e.magnitudeSquared(c)-s,m=d(l,f,h,S);return r(m)?(a.start=m.root0,a.stop=m.root1,a):void 0}function h(e,t,n){var r=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function m(t,n,r,a,c){var l,d=a*a,f=c*c,m=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*f,p=c*(a*h(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+n.y),y=t[o.COLUMN0ROW0]*d+t[o.COLUMN2ROW2]*f+a*n.x+r,v=f*h(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),g=c*(a*h(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+n.z),w=[];if(0===g&&0===v){if(l=u.computeRealRoots(m,p,y),0===l.length)return w;var E=l[0],x=Math.sqrt(Math.max(1-E*E,0));if(w.push(new e(a,c*E,c*-x)),w.push(new e(a,c*E,c*x)),2===l.length){var S=l[1],M=Math.sqrt(Math.max(1-S*S,0));w.push(new e(a,c*S,c*-M)),w.push(new e(a,c*S,c*M))}return w}var _=g*g,O=v*v,T=m*m,P=g*v,A=T+O,R=2*(p*m+P),N=2*y*m+p*p-O+_,z=2*(y*p-P),I=y*y-_;if(0===A&&0===R&&0===N&&0===z)return w;l=s.computeRealRoots(A,R,N,z,I);var b=l.length;if(0===b)return w;for(var C=0;b>C;++C){var D,U=l[C],L=U*U,q=Math.max(1-L,0),B=Math.sqrt(q);D=i.sign(m)===i.sign(y)?h(m*L+y,p*U,i.EPSILON12):i.sign(y)===i.sign(p*U)?h(m*L,p*U+y,i.EPSILON12):h(m*L+p*U,y,i.EPSILON12);var F=h(v*U,g,i.EPSILON15),W=D*F;0>W?w.push(new e(a,c*U,c*B)):W>0?w.push(new e(a,c*U,c*-B)):0!==B?(w.push(new e(a,c*U,c*-B)),w.push(new e(a,c*U,c*B)),++C):w.push(new e(a,c*U,c*B))}return w}var p={};p.rayPlane=function(t,n,a){r(a)||(a=new e);var o=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-n.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var y=new e,v=new e,g=new e,w=new e,E=new e;p.rayTriangle=function(t,n,a,i,o,u){var s=l(t,n,a,i,o);return!r(s)||0>s?void 0:(r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var x=new c;p.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=x;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var d=l(c,a,i,o,u);return!r(d)||0>d||d>e.distance(t,n)?void 0:(r(s)||(s=new e),e.multiplyByScalar(c.direction,d,s),e.add(c.origin,s,s))};var S={root0:0,root1:0};p.raySphere=function(e,t,n){return n=f(e,t,n),!r(n)||n.stop<0?void 0:(n.start=Math.max(n.start,0),n)};var M=new c;p.lineSegmentSphere=function(t,n,a,i){var o=M;e.clone(t,o.origin);var u=e.subtract(n,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=f(o,a,i),!r(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var _=new e,O=new e;p.rayEllipsoid=function(t,n){var r,a,i,o,u,s=n.oneOverRadii,c=e.multiplyComponents(s,t.origin,_),l=e.multiplyComponents(s,t.direction,O),d=e.magnitudeSquared(c),f=e.dot(c,l);if(d>1){if(f>=0)return void 0;var h=f*f;if(r=d-1,a=e.magnitudeSquared(l),i=a*r,i>h)return void 0;if(h>i){o=f*f-i,u=-f+Math.sqrt(o);var m=u/a,p=r/u;return p>m?{start:m,stop:p}:{start:p,stop:m}}var y=Math.sqrt(r/a);return{start:y,stop:y}}return 1>d?(r=d-1,a=e.magnitudeSquared(l),i=a*r,o=f*f-i,u=-f+Math.sqrt(o),{start:0,stop:u/a}):0>f?(a=e.magnitudeSquared(l),{start:0,stop:-f/a}):void 0};var T=new e,P=new e,A=new e,R=new e,N=new e,z=new o,I=new o,b=new o,C=new o,D=new o,U=new o,L=new o,q=new e,B=new e,F=new t;p.grazingAltitudeLocation=function(t,n){var a=t.origin,u=t.direction,s=n.geodeticSurfaceNormal(a,T);if(e.dot(u,s)>=0)return a;var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(u,T),d=e.normalize(l,l),f=e.mostOrthogonalAxis(l,R),h=e.normalize(e.cross(f,d,P),P),p=e.normalize(e.cross(d,h,A),A),y=z;y[0]=d.x,y[1]=d.y,y[2]=d.z,y[3]=h.x,y[4]=h.y,y[5]=h.z,y[6]=p.x,y[7]=p.y,y[8]=p.z;var v=o.transpose(y,I),g=o.fromScale(n.radii,b),w=o.fromScale(n.oneOverRadii,C),E=D;E[0]=0,E[1]=-u.z,E[2]=u.y,E[3]=u.z,E[4]=0,E[5]=-u.x,E[6]=-u.y,E[7]=u.x,E[8]=0;var x,S,M=o.multiply(o.multiply(v,w,U),E,U),_=o.multiply(o.multiply(M,g,L),y,L),O=o.multiplyByVector(M,a,N),W=m(_,e.negate(O,T),0,0,1),G=W.length;if(G>0){for(var k=e.clone(e.ZERO,B),V=Number.NEGATIVE_INFINITY,Y=0;G>Y;++Y){x=o.multiplyByVector(g,o.multiplyByVector(y,W[Y],q),q);var j=e.normalize(e.subtract(x,a,R),R),H=e.dot(j,u);H>V&&(V=H,k=e.clone(x,k))}var Z=n.cartesianToCartographic(k,F);return V=i.clamp(V,0,1),S=e.magnitude(e.subtract(k,a,R))*Math.sqrt(1-V*V),S=c?-S:S,Z.height=S,n.cartographicToCartesian(Z,new e)}return void 0};var W=new e;return p.lineSegmentPlane=function(t,n,a,o){r(o)||(o=new e);var u=e.subtract(n,t,W),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),d=-(a.distance+l)/c;return 0>d||d>1?void 0:(e.multiplyByScalar(u,d,o),e.add(t,o,o),o)},p.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var d,f;if((1===l||2===l)&&(d=new e,f=new e),1===l){if(u)return p.lineSegmentPlane(t,n,a,d),p.lineSegmentPlane(t,r,a,f),{positions:[t,n,r,d,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return p.lineSegmentPlane(n,r,a,d),p.lineSegmentPlane(n,t,a,f),{positions:[t,n,r,d,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(r,t,a,d),p.lineSegmentPlane(r,n,a,f),{positions:[t,n,r,d,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return p.lineSegmentPlane(n,t,a,d),p.lineSegmentPlane(r,t,a,f),{positions:[t,n,r,d,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return p.lineSegmentPlane(r,n,a,d),p.lineSegmentPlane(t,n,a,f),{positions:[t,n,r,d,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,r,a,d),p.lineSegmentPlane(n,r,a,f),{positions:[t,n,r,d,f],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},p}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var n=function(t,n){this.normal=e.clone(t),this.distance=n};return n.fromPointNormal=function(r,a,i){var o=-e.dot(a,r);return t(i)?(e.clone(a,i.normal),i.distance=o,i):new n(a,o)},n.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},n}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,n,r,a,i,o,u,s,c,l,d){"use strict";function f(e,t,n){var r=_;r.length=e;var a;if(t===n){for(a=0;e>a;a++)r[a]=t;return r}var i=n-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;r[a]=u}return r}function h(t,n,r,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,A),l=a.scaleToGeodeticSurface(n,R),d=m.numberOfPoints(t,n,r),h=a.cartesianToCartographic(c,O),p=a.cartesianToCartographic(l,T),y=f(d,i,o);N.setEndPoints(h,p);var v=N.surfaceDistance/d,g=s;h.height=i;var w=a.cartographicToCartesian(h,P);e.pack(w,u,g),g+=3;for(var E=1;d>E;E++){var x=N.interpolateUsingSurfaceDistance(E*v,T);x.height=y[E],w=a.cartographicToCartesian(x,P),e.pack(w,u,g),g+=3}return g}var m={};m.numberOfPoints=function(t,n,r){var a=e.distance(t,n);return Math.ceil(a/r)};var p=new t;m.extractHeights=function(e,t){for(var n=e.length,r=new Array(n),a=0;n>a;a++){var i=e[a];r[a]=t.cartesianToCartographic(i,p).height}return r};var y=new l,v=new e,g=new e,w=new d(e.ZERO,0),E=new e,x=new d(e.ZERO,0),S=new e,M=new e,_=[],O=new t,T=new t,P=new e,A=new e,R=new e,N=new o;m.wrapLongitude=function(t,a){var i=[],o=[];if(r(t)&&t.length>0){a=n(a,l.IDENTITY);var s=l.inverseTransformation(a,y),c=l.multiplyByPoint(s,e.ZERO,v),f=l.multiplyByPointAsVector(s,e.UNIT_Y,g),h=d.fromPointNormal(c,f,w),m=l.multiplyByPointAsVector(s,e.UNIT_X,E),p=d.fromPointNormal(c,m,x),_=1;i.push(e.clone(t[0]));for(var O=i[0],T=t.length,P=1;T>P;++P){var A=t[P];if(d.getPointDistance(p,O)<0||d.getPointDistance(p,A)<0){var R=u.lineSegmentPlane(O,A,h,S);if(r(R)){var N=e.multiplyByScalar(f,5e-9,M);d.getPointDistance(h,O)<0&&e.negate(N,N),i.push(e.add(R,N,new e)),o.push(_+1),e.negate(N,N),i.push(e.add(R,N,new e)),_=1}}i.push(e.clone(t[P])),_++,O=A}o.push(_)}return{positions:i,lengths:o}};var z=c.EPSILON7;return m.removeDuplicates=function(t){var n=t.length;if(2>n)return void 0;var r,a,i;for(r=1;n>r&&(a=t[r-1],i=t[r],!e.equalsEpsilon(a,i,z));++r);if(r===n)return void 0;for(var o=t.slice(0,r);n>r;++r)i=t[r],e.equalsEpsilon(a,i,z)||(o.push(e.clone(i)),a=i);return o},m.generateArc=function(t){r(t)||(t={});var a=t.positions,o=n(t.ellipsoid,i.WGS84),u=n(t.height,0),l=t.minDistance;if(!r(l)){var d=n(t.granularity,c.RADIANS_PER_DEGREE);l=c.chordLength(d,o.maximumRadius)}var f,p=a.length,y=0;for(f=0;p-1>f;f++)y+=m.numberOfPoints(a[f],a[f+1],l);var v=3*(y+1),g=new Array(v),w=0,E=s(u);for(f=0;p-1>f;f++){var x=a[f],S=a[f+1],M=E?u[f]:u,T=E?u[f+1]:u;w=h(x,S,l,o,M,T,g,w)}_.length=0;var A=a[p-1],R=o.cartesianToCartographic(A,O);R.height=E?u[p-1]:u;var N=o.cartographicToCartesian(R,P);return e.pack(N,g,v-3),g},m.generateCartesianArc=function(t){for(var n=m.generateArc(t),r=n.length/3,a=new Array(r),i=0;r>i;i++)a[i]=e.unpack(n,3*i);return a},m}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a){"use strict";var i=function(t,n){this.x=e(t,0),this.y=e(n,0)};i.fromElements=function(e,n,r){return t(r)?(r.x=e,r.y=n,r):new i(e,n)},i.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r]=t.y},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.x=n[r++],a.y=n[r],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},i.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var n=i.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},i.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},i.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},i.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},i.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,n,r){return i.multiplyByScalar(t,n,u),r=i.multiplyByScalar(e,1-n,r),i.add(u,r,r)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var n=i.normalize(e,l);return i.abs(n,n),t=n.x<=n.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y},i.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},i.equalsEpsilon=function(e,n,r,i){return e===n||t(e)&&t(n)&&a.equalsEpsilon(e.x,n.x,r,i)&&a.equalsEpsilon(e.y,n.y,r,i)},i.ZERO=r(new i(0,0)),i.UNIT_X=r(new i(1,0)),i.UNIT_Y=r(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,a){"use strict";var i=function(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i};i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,d=t.length,f=1;d>f;f++){var h=t[f],m=h.x,p=h.y,y=h.z;a=Math.min(m,a),s=Math.max(m,s),o=Math.min(p,o),c=Math.max(p,c),u=Math.min(y,u),l=Math.max(y,l)}var v=r.minimum;v.x=a,v.y=o,v.z=u;var g=r.maximum;g.x=s,g.y=c,g.z=l;var w=e.add(v,g,r.center);return e.multiplyByScalar(w,.5,w),r},i.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum):void 0},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return i.intersect=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),i=r.x*Math.abs(n.x)+r.y*Math.abs(n.y)+r.z*Math.abs(n.z),u=e.dot(t.center,n)+n.w;return u-i>0?a.INSIDE:0>u+i?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersect=function(e){return i.intersect(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return i(r)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(a){return i(a)}});return n}function o(){function e(e,t,n){return f(e,t,n)}function n(e){return m(e)}function a(e){return m(i(e))}function u(e){return h(e)}var s,c,l,d,f,h,m;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],d=[],f=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),d.push(a),r.promise},h=function(e){return p(d,e),e},m=function(e){return e=t(e),f=e.then,m=t,h=v,p(l,e),d=l=x,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return y(2,arguments),e(t,function(t){function u(e){p(e)}function s(e){m(e)}var c,l,d,f,h,m,p,y,g,w;if(g=t.length>>>0,c=Math.max(0,Math.min(n,g)),d=[],l=g-c+1,f=[],h=o(),c)for(y=h.progress,p=function(e){f.push(e),--l||(m=p=v,h.reject(f))},m=function(e){d.push(e),--c||(m=p=v,h.resolve(d))},w=0;g>w;++w)w in t&&e(t[w],s,u,y);else h.resolve(d);return h.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return y(1,arguments),f(e,g).then(t,n,r)}function d(){return f(arguments,g)}function f(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function h(t,n){var r=E.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},w.apply(t,r)})}function m(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function p(e,t){for(var n,r=0;n=e[r++];)n(t)}function y(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function v(){}function g(e){return e}var w,E,x;return e.defer=o,e.resolve=t,e.reject=n,e.join=d,e.all=l,e.map=f,e.reduce=h,e.any=c,e.some=s,e.chain=m,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(x,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(x,t)})})}},E=[].slice,w=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;a>i;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(){"use strict";var e=function(e,t,n){for(var r,a,i=0,o=e.length-1;o>=i;)if(r=~~((i+o)/2),a=n(e[r],t),0>a)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)};return e}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,d,f){var h,m,p,y,v;if("%%"==e)return"%";for(var g=!1,w="",E=!1,x=!1,S=" ",M=s.length,_=0;s&&M>_;_++)switch(s.charAt(_)){case" ":w=" ";break;case"+":w="+";break;case"-":g=!0;break;case"'":S=s.charAt(_+1);break;case"0":E=!0;break;case"#":x=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,g=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(d=d?"*"==d?+t[n++]:"*"==d.charAt(0)?+t[d.slice(1,-1)]:+d:"fFeE".indexOf(f)>-1?6:"d"==f?0:void 0,v=r?t[r.slice(0,-1)]:t[n++],f){case"s":return u(String(v),g,c,d,E,S);case"c":return u(String.fromCharCode(+v),g,c,d,E);case"b":return o(v,2,x,g,c,d,E);case"o":return o(v,8,x,g,c,d,E);case"x":return o(v,16,x,g,c,d,E);case"X":return o(v,16,x,g,c,d,E).toUpperCase();case"u":return o(v,10,x,g,c,d,E);case"i":case"d":return h=+v||0,h=Math.round(h-h%1),m=0>h?"-":w,v=m+a(String(Math.abs(h)),d,"0",!1),i(v,m,g,c,E);case"e":case"E":case"f":case"F":case"g":case"G":return h=+v,m=0>h?"-":w,p=["toExponential","toFixed","toPrecision"]["efg".indexOf(f.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(f)%2],v=m+Math.abs(h)[p](d),i(v,m,g,c,E)[y]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(){"use strict";function e(e){return 0===e%4&&0!==e%100||0===e%400}return e}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return R.compare(e.julianDate,t.julianDate)}function d(e){g.julianDate=e;var n=R.leapSeconds,r=t(n,g,l);0>r&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=R.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}R.addSeconds(e,a,e)}function f(e,n){g.julianDate=e;var r=R.leapSeconds,a=t(r,g,l);if(0>a&&(a=~a),0===a)return R.addSeconds(e,-r[0].offset,n);if(a>=r.length)return R.addSeconds(e,-r[a-1].offset,n);var i=R.secondsDifference(r[a].julianDate,e);return 0===i?R.addSeconds(e,-r[a].offset,n):1>=i?void 0:R.addSeconds(e,-r[--a].offset,n)}function h(e,t,n){var r=0|t/s.SECONDS_PER_DAY;return e+=r,t-=s.SECONDS_PER_DAY*r,0>t&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function m(e,t,n,r,a,i,o){var u=0|(t-14)/12,c=e+4800+u,l=(0|1461*c/4)+(0|367*(t-2-12*u)/12)-(0|3*((c+100)/100)/4)+n-32075;r-=12,0>r&&(r+=24);var d=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return d>=43200&&(l-=1),[l,d]}var p=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,g=new u,w=/^(\d{4})$/,E=/^(\d{4})-(\d{2})$/,x=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,_=/([Z+\-])?(\d{2})?:?(\d{2})?$/,O=/^(\d{2})(\.\d+)?/.source+_.source,T=/^(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+_.source,A="Invalid ISO 8601 date.",R=function(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,h(a,t,this),r===c.UTC&&d(this)};R.fromDate=function(e,t){var n=m(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(h(n[0],n[1],t),d(t),t):new R(n[0],n[1],c.UTC)},R.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,u,s=e.split("T"),l=1,f=1,p=0,g=0,_=0,N=0,z=s[0],I=s[1];if(!r(z))throw new a(A);var b;if(s=z.match(M),null!==s){if(b=z.split("-").length-1,b>0&&2!==b)throw new a(A);n=+s[1],l=+s[2],f=+s[3]}else if(s=z.match(E),null!==s)n=+s[1],l=+s[2];else if(s=z.match(w),null!==s)n=+s[1];else{var C;if(s=z.match(x),null!==s){if(n=+s[1],C=+s[2],u=o(n),1>C||u&&C>366||!u&&C>365)throw new a(A)}else{if(s=z.match(S),null===s)throw new a(A);n=+s[1];var D=+s[2],U=+s[3]||0;if(b=z.split("-").length-1,b>0&&(!r(s[3])&&1!==b||r(s[3])&&2!==b))throw new a(A);var L=new Date(Date.UTC(n,0,4));C=7*D+U-L.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(C),l=i.getUTCMonth()+1,f=i.getUTCDate()}if(u=o(n),1>l||l>12||1>f||(2!==l||!u)&&f>y[l-1]||u&&2===l&&f>v)throw new a(A);var q;if(r(I)){if(s=I.match(P),null!==s){if(b=I.split(":").length-1,b>0&&2!==b&&3!==b)throw new a(A);p=+s[1],g=+s[2],_=+s[3],N=1e3*+(s[4]||0),q=5}else if(s=I.match(T),null!==s){if(b=I.split(":").length-1,b>0&&1!==b)throw new a(A);p=+s[1],g=+s[2],_=60*+(s[3]||0),q=4}else{if(s=I.match(O),null===s)throw new a(A);p=+s[1],g=60*+(s[2]||0),q=3}if(g>=60||_>=61||p>24||24===p&&(g>0||_>0||N>0))throw new a(A);var B=s[q],F=+s[q+1],W=+(s[q+2]||0);switch(B){case"+":p-=F,g-=W;break;case"-":p+=F,g+=W;break;case"Z":break;default:g+=new Date(Date.UTC(n,l-1,f,p,g)).getTimezoneOffset()}}else g+=new Date(n,l-1,f).getTimezoneOffset();var G=60===_;for(G&&_--;g>=60;)g-=60,p++;for(;p>=24;)p-=24,f++;for(i=u&&2===l?v:y[l-1];f>i;)f-=i,l++,l>12&&(l-=12,n++),i=u&&2===l?v:y[l-1];for(;0>g;)g+=60,p--;for(;0>p;)p+=24,f--;for(;1>f;)l--,1>l&&(l+=12,n--),i=u&&2===l?v:y[l-1],f+=i;var k=m(n,l,f,p,g,_,N);return r(t)?(h(k[0],k[1],t),d(t)):t=new R(k[0],k[1],c.UTC),G&&R.addSeconds(t,1,t),t},R.now=function(e){return R.fromDate(new Date,e)};var N=new R(0,0,c.TAI);return R.toGregorianDate=function(e,t){var n=!1,a=f(e,N);r(a)||(R.addSeconds(e,-1,N),a=f(N,N),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=0|o+68569,l=0|4*c/146097;c=0|c-(0|(146097*l+3)/4);var d=0|4e3*(c+1)/1461001;c=0|c-(0|1461*d/4)+31;var h=0|80*c/2447,m=0|c-(0|2447*h/80);c=0|h/11;var p=0|h+2-12*c,y=0|100*(l-49)+d+c,v=0|u/s.SECONDS_PER_HOUR,g=u-v*s.SECONDS_PER_HOUR,w=0|g/s.SECONDS_PER_MINUTE;g-=w*s.SECONDS_PER_MINUTE;var E=0|g,x=(g-E)/s.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),n&&(E+=1),r(t)?(t.year=y,t.month=p,t.day=m,t.hour=v,t.minute=w,t.second=E,t.millisecond=x,t.isLeapSecond=n,t):new i(y,p,m,v,w,E,x,n)},R.toDate=function(e){var t=R.toGregorianDate(e,p),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},R.toIso8601=function(t,n){var a,i=R.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},R.clone=function(e,t){return r(e)?r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new R(e.dayNumber,e.secondsOfDay,c.TAI):void 0},R.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},R.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},R.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(R.secondsDifference(e,t))<=n},R.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},R.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},R.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},R.computeTaiMinusUtc=function(e){g.julianDate=e;var n=R.leapSeconds,r=t(n,g,l);return 0>r&&(r=~r,--r,0>r&&(r=0)),n[r].offset},R.addSeconds=function(e,t,n){return h(e.dayNumber,e.secondsOfDay+t,n)},R.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,r,n)},R.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,r,n)},R.addDays=function(e,t,n){var r=e.dayNumber+t;return h(r,e.secondsOfDay,n)},R.lessThan=function(e,t){return R.compare(e,t)<0},R.lessThanOrEquals=function(e,t){return R.compare(e,t)<=0},R.greaterThan=function(e,t){return R.compare(e,t)>0},R.greaterThanOrEquals=function(e,t){return R.compare(e,t)>=0},R.prototype.clone=function(e){return R.clone(this,e)},R.prototype.equals=function(e){return R.equals(this,e)},R.prototype.equalsEpsilon=function(e,t){return R.equalsEpsilon(this,e,t)},R.prototype.toString=function(){return R.toIso8601(this)},R.leapSeconds=[new u(new R(2441317,43210,c.TAI),10),new u(new R(2441499,43211,c.TAI),11),new u(new R(2441683,43212,c.TAI),12),new u(new R(2442048,43213,c.TAI),13),new u(new R(2442413,43214,c.TAI),14),new u(new R(2442778,43215,c.TAI),15),new u(new R(2443144,43216,c.TAI),16),new u(new R(2443509,43217,c.TAI),17),new u(new R(2443874,43218,c.TAI),18),new u(new R(2444239,43219,c.TAI),19),new u(new R(2444786,43220,c.TAI),20),new u(new R(2445151,43221,c.TAI),21),new u(new R(2445516,43222,c.TAI),22),new u(new R(2446247,43223,c.TAI),23),new u(new R(2447161,43224,c.TAI),24),new u(new R(2447892,43225,c.TAI),25),new u(new R(2448257,43226,c.TAI),26),new u(new R(2448804,43227,c.TAI),27),new u(new R(2449169,43228,c.TAI),28),new u(new R(2449534,43229,c.TAI),29),new u(new R(2450083,43230,c.TAI),30),new u(new R(2450630,43231,c.TAI),31),new u(new R(2451179,43232,c.TAI),32),new u(new R(2453736,43233,c.TAI),33),new u(new R(2454832,43234,c.TAI),34),new u(new R(2456109,43235,c.TAI),35)],R
}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var n=function(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,n,r,a,i){"use strict";function o(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function u(e,t){for(var n=o(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function s(e,n){n=t(n,"");var a=e[1],i=!!e[2],s=e[3];switch(n){case"":case"text":return o(i,s);case"arraybuffer":return u(i,s);case"blob":var c=u(i,s);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(o(i,s),a);case"json":return JSON.parse(o(i,s));default:throw new r("Unhandled responseType: "+n)}}var c=function(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,o=n.headers,u=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return c.load(t,r,a,i,o,n,u),n.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return c.load=function(e,t,r,o,u,c,d){var f=l.exec(e);if(null!==f)return c.resolve(s(f,t)),void 0;var h=new XMLHttpRequest;if(n(d)&&n(h.overrideMimeType)&&h.overrideMimeType(d),h.open(r,e,!0),n(u))for(var m in u)u.hasOwnProperty(m)&&h.setRequestHeader(m,u[m]);n(t)&&(h.responseType=t),h.onload=function(){200===h.status?n(h.response)?c.resolve(h.response):n(h.responseXML)&&h.responseXML.hasChildNodes()?c.resolve(h.responseXML):n(h.responseText)?c.resolve(h.responseText):c.reject(new i("unknown XMLHttpRequest response type.")):c.reject(new a(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(){c.reject(new a)},h.send(o)},c.defaultLoad=c.load,c}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,n){return e({url:t,headers:n})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";var a={Accept:"application/json,*/*;q=0.01"},i=function(n,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,r(n,i).then(function(e){return JSON.parse(e)})};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,d){"use strict";function f(e,t){return o.compare(e.julianDate,t)}function h(e,n){if(!r(n.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!r(n.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),h=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),m=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),p=n.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>h||0>m||0>p)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var y=e._samples=n.samples,v=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=m,e._taiMinusUtcSecondsColumn=p,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var g,w=e._addNewLeapSeconds,E=0,x=y.length;x>E;E+=e._columnCount){var S=y[E+a],M=y[E+p],_=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,O=new o(_,M,d.TAI);if(v.push(O),w){if(M!==g&&r(g)){var T=o.leapSeconds,P=t(T,O,f);if(0>P){var A=new u(O,M);T.splice(~P,0,A)}}g=M}}}function m(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function p(e,t,n){return t+e*(n-t)}function y(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return m(e,n,a,s,u),u;if(r.equals(l))return m(e,n,i,s,u),u;var d=o.secondsDifference(r,c)/o.secondsDifference(l,c),f=a*s,h=i*s,y=n[f+e._ut1MinusUtcSecondsColumn],v=n[h+e._ut1MinusUtcSecondsColumn],g=v-y;if(g>.5||-.5>g){var w=n[f+e._taiMinusUtcSecondsColumn],E=n[h+e._taiMinusUtcSecondsColumn];w!==E&&(l.equals(r)?y=v:v-=E-w)}return u.xPoleWander=p(d,n[f+e._xPoleWanderRadiansColumn],n[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=p(d,n[f+e._yPoleWanderRadiansColumn],n[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=p(d,n[f+e._xCelestialPoleOffsetRadiansColumn],n[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=p(d,n[f+e._yCelestialPoleOffsetRadiansColumn],n[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=p(d,y,v),u}var v=function(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))h(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){h(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return v.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),v.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},v.prototype.compute=function(e,n){if(!r(this._samples)){if(r(this._dataError))throw new c(this._dataError);return void 0}if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var d=i[u],f=i[u+1],h=o.lessThanOrEquals(d,e),m=!r(f),p=m||o.greaterThanOrEquals(f,e);if(h&&p)return s=u,!m&&f.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,n),n}var v=t(i,e,o.compare,this._dateColumn);return v>=0?(v<i.length-1&&i[v+1].equals(e)&&++v,s=v,l=v):(l=~v,s=l-1,0>s&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,n),n},v}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(n.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];for(r&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);("."==e||".."==e)&&n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,n,r){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;n>t;++t){var r=e[t].getAttribute("src"),a=d.exec(r);if(null!==a)return a[1]}return void 0}function i(){if(t(s))return s;var r;if(r="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(r))throw new n("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(r).resolve(new e(document.location.href))}function o(e){return r.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}var s,c,l,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,f=function(e){t(c)||(c=t(r.toUrl)?o:u),t(l)||(l=document.createElement("a"));var n=c(e);return l.href=n,l.href=l.href,l.href};return f._cesiumScriptRegex=d,f}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,n){this.x=e,this.y=t,this.s=n};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,t,n){var r=d;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function c(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=3*a*n._samplesPerXysFile,u=0,s=r.length;s>u;++u)t[o+u]=r[u];i.resolve()}),i.promise}var l=function(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)},d=new i(0,0,u.TAI);return l.prototype.preload=function(t,n,r,a){var i=s(this,t,n),o=s(this,r,a),u=0|i/this._stepSizeDays-this._interpolationOrder/2;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var d=0|u/this._samplesPerXysFile,f=0|l/this._samplesPerXysFile,h=[],m=d;f>=m;++m)h.push(c(this,m));return e.all(h)},l.prototype.computeXysRadians=function(e,t,n){var i=s(this,e,t);if(0>i)return void 0;var o=0|i/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(0|u/2);0>l&&(l=0);var d=l+u;d>=this._totalSamples&&(d=this._totalSamples-1,l=d-u,0>l&&(l=0));var f=!1,h=this._samples;if(r(h[3*l])||(c(this,0|l/this._samplesPerXysFile),f=!0),r(h[3*d])||(c(this,0|d/this._samplesPerXysFile),f=!0),f)return void 0;r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var m,p,y=i-l*this._stepSizeDays,v=this._work,g=this._denominators,w=this._coef,E=this._xTable;for(m=0;u>=m;++m)v[m]=y-E[m];for(m=0;u>=m;++m){for(w[m]=1,p=0;u>=p;++p)p!==m&&(w[m]*=v[p]);w[m]*=g[m];var x=3*(l+m);n.x+=w[m]*h[x++],n.y+=w[m]*h[x++],n.s+=w[m]*h[x]}return n},l}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u){"use strict";var s=function(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,r,a){var i=r/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,d=c.z*o,f=Math.cos(i);return n(a)?(a.x=u,a.y=l,a.z=d,a.w=f,a):new s(u,l,d,f)};var l=[1,2,0],d=new Array(3);s.fromRotationMatrix=function(e,t){var r,a,i,o,c,f=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=f+h+m;if(p>0)r=Math.sqrt(p+1),c=.5*r,r=.5/r,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var y=l,v=0;h>f&&(v=1),m>f&&m>h&&(v=2);var g=y[v],w=y[g];r=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(w,w)]+1);var E=d;E[v]=.5*r,r=.5/r,c=(e[u.getElementIndex(w,g)]-e[u.getElementIndex(g,w)])*r,E[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*r,E[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*r,a=-E[0],i=-E[1],o=-E[2]}return n(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var f=new s;s.fromHeadingPitchRoll=function(t,n,r,a){var i=s.fromAxisAngle(e.UNIT_X,r,f),o=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,f);return s.multiply(u,a,a)};var h=new e,m=new e,p=new s,y=new s,v=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new s),a.x=e[r],a.y=e[r+1],a.z=e[r+2],a.w=e[r+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,v),s.conjugate(v,v);for(var a=0,i=n-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),p),s.multiply(p,v,p),p.w<0&&s.negate(p,p),s.computeAxis(p,h);var u=s.computeAngle(p);r[o]=h.x*u,r[o+1]=h.y*u,r[o+2]=h.z*u}},s.unpackInterpolationResult=function(t,r,a,i,o){n(o)||(o=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(r,4*i,y),0===u?s.clone(s.IDENTITY,p):s.fromAxisAngle(m,u,p),s.multiply(p,y,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,d=o*u+r*l+a*c-i*s,f=o*s-r*c+a*l+i*u,h=o*c+r*s-a*u+i*l,m=o*l-r*u-a*s-i*c;return n.x=d,n.y=f,n.z=h,n.w=m,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var g=new s;s.lerp=function(e,t,n,r){return g=s.multiplyByScalar(t,n,g),r=s.multiplyByScalar(e,1-n,r),s.add(g,r,r)};var w=new s,E=new s,x=new s;s.slerp=function(e,t,n,r){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=w=s.negate(t,w)),1-a<o.EPSILON6)return s.lerp(e,i,n,r);var u=Math.acos(a);return E=s.multiplyByScalar(e,Math.sin((1-n)*u),E),x=s.multiplyByScalar(i,Math.sin(n*u),x),r=s.add(E,x,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},s.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var S=new e,M=new e,_=new s,O=new s;s.computeInnerQuadrangle=function(t,n,r,a){var i=s.conjugate(n,_);s.multiply(i,r,O);var o=s.log(O,S);s.multiply(i,t,O);var u=s.log(O,M);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,_),s.multiply(n,_,a)},s.squad=function(e,t,n,r,a,i){var o=s.slerp(e,t,a,_),u=s.slerp(n,r,a,O);return s.slerp(o,u,2*a*(1-a),i)};for(var T=new s,P=1.9011074535173003,A=a.supportsTypedArrays()?new Float32Array(8):[],R=a.supportsTypedArrays()?new Float32Array(8):[],N=a.supportsTypedArrays()?new Float32Array(8):[],z=a.supportsTypedArrays()?new Float32Array(8):[],I=0;7>I;++I){var b=I+1,C=2*b+1;A[I]=1/(b*C),R[I]=b/C}return A[7]=P/136,R[7]=8*P/17,s.fastSlerp=function(e,t,n,r){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,c=n*n,l=u*u,d=7;d>=0;--d)N[d]=(A[d]*c-R[d])*o,z[d]=(A[d]*l-R[d])*o;var f=a*n*(1+N[0]*(1+N[1]*(1+N[2]*(1+N[3]*(1+N[4]*(1+N[5]*(1+N[6]*(1+N[7])))))))),h=u*(1+z[0]*(1+z[1]*(1+z[2]*(1+z[3]*(1+z[4]*(1+z[5]*(1+z[6]*(1+z[7])))))))),m=s.multiplyByScalar(e,h,T);return s.multiplyByScalar(t,f,r),s.add(m,r,r)},s.fastSquad=function(e,t,n,r,a,i){var o=s.fastSlerp(e,t,a,_),u=s.fastSlerp(n,r,a,O);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h,m,p,y,v){"use strict";var g={},w=new n,E=new n,x=new n;g.eastNorthUpToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-o,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=w,s=E,l=x;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=l.x,r[5]=l.y,r[6]=l.z,r[7]=0,r[8]=u.x,r[9]=u.y,r[10]=u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var S=new n,M=new n,_=new n;g.northEastDownToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=S,s=M,l=_;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-u.x,r[9]=-u.y,r[10]=-u.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},g.northUpEastToFixedFrame=function(e,t,r){if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var o=h.sign(e.z);return i(r)?(r[0]=-o,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=o,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=w,s=E,l=x;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(u,s,l),i(r)?(r[0]=l.x,r[1]=l.y,r[2]=l.z,r[3]=0,r[4]=u.x,r[5]=u.y,r[6]=u.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new p(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var O=new y,T=new n(1,1,1),P=new p;g.headingPitchRollToFixedFrame=function(e,t,r,a,i,o){var u=y.fromHeadingPitchRoll(t,r,a,O),s=p.fromTranslationQuaternionRotationScale(n.ZERO,u,T,P);return o=g.eastNorthUpToFixedFrame(e,i,o),p.multiply(o,s,o)};var A=new p,R=new m;g.headingPitchRollQuaternion=function(e,t,n,r,a,i){var o=g.headingPitchRollToFixedFrame(e,t,n,r,a,A),u=p.getRotation(o,R);return y.fromRotationMatrix(u,i)};var N=24110.54841,z=8640184.812866,I=.093104,b=-62e-7,C=1.1772758384668e-19,D=72921158553e-15,U=h.TWO_PI/86400,L=new f;g.computeTemeToPseudoFixedMatrix=function(e,t){L=f.addSeconds(e,-f.computeTaiMinusUtc(e),L);var n,r=L.dayNumber,a=L.secondsOfDay,o=r-2451545;n=a>=43200?(o+.5)/v.DAYS_PER_JULIAN_CENTURY:(o-.5)/v.DAYS_PER_JULIAN_CENTURY;var u=N+n*(z+n*(I+n*b)),s=u*U%h.TWO_PI,c=D+C*(r-2451545.5),l=(a+.5*v.SECONDS_PER_DAY)%v.SECONDS_PER_DAY,d=s+c*l,p=Math.cos(d),y=Math.sin(d);return i(t)?(t[0]=p,t[1]=-y,t[2]=0,t[3]=y,t[4]=p,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(p,y,0,-y,p,0,0,0,1)},g.iau2006XysData=new l,g.earthOrientationParameters=u.NONE;var q=32.184,B=2451545;g.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+q,a=t.stop.dayNumber,i=t.stop.secondsOfDay+q,o=g.iau2006XysData.preload(n,r,a,i),u=g.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},g.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new m);var n=g.computeFixedToIcrfMatrix(e,t);return i(n)?m.transpose(n,t):void 0};var F=new d(0,0,0),W=new s(0,0,0,0,0,0),G=new m,k=new m;g.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new m);var n=g.earthOrientationParameters.compute(e,W);if(!i(n))return void 0;var r=e.dayNumber,a=e.secondsOfDay+q,o=g.iau2006XysData.computeXysRadians(r,a,F);if(!i(o))return void 0;var u=o.x+n.xPoleOffset,s=o.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=G;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var d=m.fromRotationZ(-o.s,k),p=m.multiply(l,d,G),y=e.dayNumber,w=e.secondsOfDay-f.computeTaiMinusUtc(e)+n.ut1MinusUtc,E=y-2451545,x=w/v.SECONDS_PER_DAY,S=.779057273264+x+.00273781191135448*(E+x);S=S%1*h.TWO_PI;var M=m.fromRotationZ(S,k),_=m.multiply(p,M,G),O=Math.cos(n.xPoleWander),T=Math.cos(n.yPoleWander),P=Math.sin(n.xPoleWander),A=Math.sin(n.yPoleWander),R=r-B+a/v.SECONDS_PER_DAY;R/=36525;var N=-47e-6*R*h.RADIANS_PER_DEGREE/3600,z=Math.cos(N),I=Math.sin(N),b=k;return b[0]=O*z,b[1]=O*I,b[2]=P,b[3]=-T*I+A*P*z,b[4]=T*z+A*P*I,b[5]=-A*O,b[6]=-A*I-T*P*z,b[7]=A*z-T*P*I,b[8]=T*O,m.multiply(_,b,t)};var V=new r;g.pointToWindowCoordinates=function(e,t,n,r){return r=g.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},g.pointToGLWindowCoordinates=function(e,n,a,o){i(o)||(o=new t);var u=V;return p.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,u),u),r.multiplyByScalar(u,1/u.w,u),p.multiplyByVector(n,u,u),t.fromCartesian4(u,o)};var Y=new n,j=new n,H=new n;return g.rotationMatrixFromPositionVelocity=function(e,t,r,o){var u=a(r,c.WGS84).geodeticSurfaceNormal(e,Y),s=n.cross(t,u,j);n.equalsEpsilon(s,n.ZERO,h.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var l=n.cross(s,t,H);return n.cross(t,l,s),n.negate(s,s),i(o)||(o=new m),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},g}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h){"use strict";var m=new r,p=function(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=h.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(l.getColumn(r,0,m)),this._yAxis=n.fromCartesian4(l.getColumn(r,1,m));var i=n.fromCartesian4(l.getColumn(r,2,m));this._plane=d.fromPointNormal(e,i)};o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var y=new e;p.fromPoints=function(t,n){var r=e.fromPoints(t,y);return new p(r.center,n)};var v=new f,g=new n;p.prototype.projectPointOntoPlane=function(e,r){var a=v;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,g);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,g)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}return void 0},p.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;r>a;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t};var w=new n;return p.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=w,l=0;r>l;++l){var d=e[l];n.multiplyByScalar(u,d.x,c),i(t[l])||(t[l]=new n);var f=n.add(o,c,t[l]);n.multiplyByScalar(s,d.y,c),n.add(f,c,f),a.scaleToGeocentricSurface(f,f)}return t},p}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,d){"use strict";function f(e,t){for(var n=new Array(e.length),r=0;r<e.length;r++){var a=e[r];C=t.cartesianToCartographic(a,C),n[r]=C.height,e[r]=t.scaleToGeodeticSurface(a,a)}return n}function h(e,n,r,a){var i,o=e[0],u=e[1],s=t.angleBetween(o,u),c=Math.ceil(s/a),l=new Array(c);if(n===r){for(i=0;c>i;i++)l[i]=n;return l.push(r),l}var d=r-n,f=d/c;for(i=1;c>i;i++){var h=n+i*f;l[i]=h}return l[0]=n,l.push(r),l}function m(n,r,a,o){var u=new i(a,o),s=u.projectPointOntoPlane(t.add(a,n,H),H),c=u.projectPointOntoPlane(t.add(a,r,Z),Z),l=e.angleBetween(s,c);return c.x*s.y-c.y*s.x>=0?-l:l}function p(e,n,r,a,i,o,c,l){var f=F,h=W;U=d.eastNorthUpToFixedFrame(e,i,U),f=s.multiplyByPointAsVector(U,D,f),f=t.normalize(f,f);var p=m(f,n,e,i);q=u.fromRotationZ(p,q),G.z=o,U=s.multiplyTransformation(U,s.fromRotationTranslation(q,G,L),U);var y=B;y[0]=c;for(var v=0;l>v;v++)for(var g=0;g<r.length;g+=3)h=t.fromArray(r,g,h),h=u.multiplyByVector(y,h,h),h=s.multiplyByPoint(U,h,h),a.push(h.x,h.y,h.z);return a}function y(e,n,r,a,i,o,u){for(var s=0;s<e.length;s+=3){var c=t.fromArray(e,s,k);a=p(c,n,r,a,i,o[s/3],u,1)}return a}function v(e,t){var n=e.length,r=new Array(6*n),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=e[0];r[a++]=u.x-i,r[a++]=0,r[a++]=u.y-o;for(var s=1;n>s;s++){u=e[s];var c=u.x-i,l=u.y-o;r[a++]=c,r[a++]=0,r[a++]=l,r[a++]=c,r[a++]=0,r[a++]=l}return u=e[0],r[a++]=u.x-i,r[a++]=0,r[a++]=u.y-o,r}function g(e,t){for(var n=e.length,r=new Array(3*n),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=0;n>u;u++)r[a++]=e[u].x-i,r[a++]=0,r[a++]=e[u].y-o;return r}function w(e,n,r,i,s,c,d,f,h,m){var y,v=t.angleBetween(t.subtract(n,e,z),t.subtract(r,e,I)),g=i===a.BEVELED?0:Math.ceil(v/o.toRadians(5));y=s?u.fromQuaternion(l.fromAxisAngle(t.negate(e,z),v/(g+1),V),j):u.fromQuaternion(l.fromAxisAngle(e,v/(g+1),V),j);var w,E;if(n=t.clone(n,Y),g>0)for(var x=m?2:1,S=0;g>S;S++)n=u.multiplyByVector(y,n,n),w=t.subtract(n,e,z),w=t.normalize(w,w),s||(w=t.negate(w,w)),E=c.scaleToGeodeticSurface(n,I),d=p(E,w,f,d,c,h,1,x);else w=t.subtract(n,e,z),w=t.normalize(w,w),s||(w=t.negate(w,w)),E=c.scaleToGeodeticSurface(n,I),d=p(E,w,f,d,c,h,1,1),r=t.clone(r,Y),w=t.subtract(r,e,z),w=t.normalize(w,w),s||(w=t.negate(w,w)),E=c.scaleToGeodeticSurface(r,I),d=p(E,w,f,d,c,h,1,1);return d}function E(e,t){return o.equalsEpsilon(e.latitude,t.latitude,o.EPSILON6)&&o.equalsEpsilon(e.longitude,t.longitude,o.EPSILON6)}var x=[new t,new t],S=new t,M=new t,_=new t,O=new t,T=new t,P=new t,A=new t,R=new t,N=new t,z=new t,I=new t,b={},C=new r,D=new t(-1,0,0),U=new s,L=new s,q=new u,B=u.IDENTITY.clone(),F=new t,W=new n,G=new t,k=new t,V=new l,Y=new t,j=new u;b.removeDuplicatesFromShape=function(t){for(var n=t.length,r=[],a=n-1,i=0;n>i;a=i++){var o=t[a],u=t[i];e.equals(o,u)||r.push(u)}return r};var H=new t,Z=new t;b.angleIsGreaterThanPi=function(e,n,r,a){var o=new i(r,a),u=o.projectPointOntoPlane(t.add(r,e,H),H),s=o.projectPointOntoPlane(t.add(r,n,Z),Z);return s.x*u.y-s.y*u.x>=0};var X=new r,J=new r;b.removeDuplicatesFromPositions=function(e,t){var n=e.length;if(2>n)return e.slice(0);var r=[];r.push(e[0]);for(var a=1;n>a;++a){var i=e[a-1],o=e[a],u=t.cartesianToCartographic(i,X),s=t.cartesianToCartographic(o,J);E(u,s)||r.push(o)}return r};var Q=new t,K=new t;return b.computePositions=function(e,n,r,i,u){var s=i._ellipsoid,l=f(e,s),d=i._granularity,m=i._cornerType,E=u?v(n,r):g(n,r),I=u?g(n,r):void 0,C=r.height/2,D=r.width/2,U=e.length,L=[],q=u?[]:void 0,B=S,F=M,W=_,G=O,k=T,V=P,Y=A,j=R,H=N,Z=e[0],X=e[1];G=s.geodeticSurfaceNormal(Z,G),B=t.subtract(X,Z,B),B=t.normalize(B,B),j=t.cross(G,B,j),j=t.normalize(j,j);var J=l[0],$=l[1];u&&(q=p(Z,j,I,q,s,J+C,1,1)),H=t.clone(Z,H),Z=X,F=t.negate(B,F);for(var et,tt,nt=1;U-1>nt;nt++){var rt=u?2:1;X=e[nt+1],B=t.subtract(X,Z,B),B=t.normalize(B,B),W=t.add(B,F,W),W=t.normalize(W,W),G=s.geodeticSurfaceNormal(Z,G);var at=t.multiplyByScalar(G,t.dot(B,G),Q);t.subtract(B,at,at),t.normalize(at,at);var it=t.multiplyByScalar(G,t.dot(F,G),K);t.subtract(F,it,it),t.normalize(it,it);var ot=!o.equalsEpsilon(Math.abs(t.dot(at,it)),1,o.EPSILON7);if(ot){W=t.cross(W,G,W),W=t.cross(G,W,W),W=t.normalize(W,W);var ut=1/Math.max(.25,t.magnitude(t.cross(W,F,z))),st=b.angleIsGreaterThanPi(B,F,Z,s);
st?(k=t.add(Z,t.multiplyByScalar(W,ut*D,W),k),V=t.add(k,t.multiplyByScalar(j,D,V),V),x[0]=t.clone(H,x[0]),x[1]=t.clone(V,x[1]),et=h(x,J+C,$+C,d),tt=c.generateArc({positions:x,granularity:d,ellipsoid:s}),L=y(tt,j,E,L,s,et,1),j=t.cross(G,B,j),j=t.normalize(j,j),Y=t.add(k,t.multiplyByScalar(j,D,Y),Y),m===a.ROUNDED||m===a.BEVELED?w(k,V,Y,m,st,s,L,E,$+C,u):(W=t.negate(W,W),L=p(Z,W,E,L,s,$+C,ut,rt)),H=t.clone(Y,H)):(k=t.add(Z,t.multiplyByScalar(W,ut*D,W),k),V=t.add(k,t.multiplyByScalar(j,-D,V),V),x[0]=t.clone(H,x[0]),x[1]=t.clone(V,x[1]),et=h(x,J+C,$+C,d),tt=c.generateArc({positions:x,granularity:d,ellipsoid:s}),L=y(tt,j,E,L,s,et,1),j=t.cross(G,B,j),j=t.normalize(j,j),Y=t.add(k,t.multiplyByScalar(j,-D,Y),Y),m===a.ROUNDED||m===a.BEVELED?w(k,V,Y,m,st,s,L,E,$+C,u):L=p(Z,W,E,L,s,$+C,ut,rt),H=t.clone(Y,H)),F=t.negate(B,F)}else L=p(H,j,E,L,s,J+C,1,1),H=Z;J=$,$=l[nt+1],Z=X}x[0]=t.clone(H,x[0]),x[1]=t.clone(Z,x[1]),et=h(x,J+C,$+C,d),tt=c.generateArc({positions:x,granularity:d,ellipsoid:s}),L=y(tt,j,E,L,s,et,1),u&&(q=p(Z,j,I,q,s,$+C,1,1)),U=L.length;var ct=u?U+q.length:U,lt=new Float64Array(ct);return lt.set(L),u&&lt.set(q,U),lt},b}),define("Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./isArray","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(n,r,o,u,c){var l=e.angleBetween(e.subtract(r,n,p),e.subtract(o,n,y)),d=u===t.BEVELED?1:Math.ceil(l/a.toRadians(5))+1,f=3*d,h=new Array(f);h[f-3]=o.x,h[f-2]=o.y,h[f-1]=o.z;var m;m=c?i.fromQuaternion(s.fromAxisAngle(e.negate(n,p),l/d,N),z):i.fromQuaternion(s.fromAxisAngle(n,l/d,N),z);var v=0;r=e.clone(r,p);for(var g=0;d>g;g++)r=i.multiplyByVector(m,r,r),h[v++]=r.x,h[v++]=r.y,h[v++]=r.z;return h}function l(n){var r=E,a=x,i=S,o=n[1];a=e.fromArray(n[1],o.length-3,a),i=e.fromArray(n[0],0,i),r=e.multiplyByScalar(e.add(a,i,r),.5,r);var u=c(r,a,i,t.ROUNDED,!1),s=n.length-1,l=n[s-1];o=n[s],a=e.fromArray(l,l.length-3,a),i=e.fromArray(o,0,i),r=e.multiplyByScalar(e.add(a,i,r),.5,r);var d=c(r,a,i,t.ROUNDED,!1);return[u,d]}function d(t,n,r,a){var i=p;return a?i=e.add(t,n,i):(n=e.negate(n,n),i=e.add(t,n,i)),[i.x,i.y,i.z,r.x,r.y,r.z]}function f(t,n,r,a){for(var i=new Array(t.length),o=new Array(t.length),u=e.multiplyByScalar(n,r,p),s=e.negate(u,y),c=0,l=t.length-1,d=0;d<t.length;d+=3){var f=e.fromArray(t,d,v),h=e.add(f,s,g);i[c++]=h.x,i[c++]=h.y,i[c++]=h.z;var m=e.add(f,u,g);o[l--]=m.z,o[l--]=m.y,o[l--]=m.x}return a.push(i,o),a}function h(e,t){for(var n=0;n<e.length;n++)e[n]=t.scaleToGeodeticSurface(e[n],e[n]);return e}var m={},p=new e,y=new e,v=new e,g=new e,w=[new e,new e],E=new e,x=new e,S=new e,M=new e,_=new e,O=new e,T=new e,P=new e,A=new e,R=new e,N=new s,z=new i;m.addAttribute=function(e,t,r,a){var i=t.x,o=t.y,u=t.z;n(r)&&(e[r]=i,e[r+1]=o,e[r+2]=u),n(a)&&(e[a]=u,e[a-1]=o,e[a-2]=i)};var I=new e,b=new e;m.computePositions=function(n){var r=n.granularity,i=n.positions,s=n.ellipsoid;i=h(i,s);var m=n.width/2,y=n.cornerType,v=n.saveAttributes,g=E,N=x,z=S,C=M,D=_,U=O,L=T,q=P,B=A,F=R,W=[],G=v?[]:void 0,k=v?[]:void 0,V=i[0],Y=i[1];N=e.normalize(e.subtract(Y,V,N),N),g=s.geodeticSurfaceNormal(V,g),C=e.normalize(e.cross(g,N,C),C),v&&(G.push(C.x,C.y,C.z),k.push(g.x,g.y,g.z)),L=e.clone(V,L),V=Y,z=e.negate(N,z);var j,H,Z=[],X=i.length;for(H=1;X-1>H;H++){g=s.geodeticSurfaceNormal(V,g),Y=i[H+1],N=e.normalize(e.subtract(Y,V,N),N),D=e.normalize(e.add(N,z,D),D);var J=e.multiplyByScalar(g,e.dot(N,g),I);e.subtract(N,J,J),e.normalize(J,J);var Q=e.multiplyByScalar(g,e.dot(z,g),b);e.subtract(z,Q,Q),e.normalize(Q,Q);var K=!a.equalsEpsilon(Math.abs(e.dot(J,Q)),1,a.EPSILON7);if(K){D=e.cross(D,g,D),D=e.cross(g,D,D);var $=m/Math.max(.25,e.magnitude(e.cross(D,z,p))),et=u.angleIsGreaterThanPi(N,z,V,s);D=e.multiplyByScalar(D,$,D),et?(q=e.add(V,D,q),F=e.add(q,e.multiplyByScalar(C,m,F),F),B=e.add(q,e.multiplyByScalar(C,2*m,B),B),w[0]=e.clone(L,w[0]),w[1]=e.clone(F,w[1]),j=o.generateArc({positions:w,granularity:r,ellipsoid:s}),W=f(j,C,m,W),v&&(G.push(C.x,C.y,C.z),k.push(g.x,g.y,g.z)),U=e.clone(B,U),C=e.normalize(e.cross(g,N,C),C),B=e.add(q,e.multiplyByScalar(C,2*m,B),B),L=e.add(q,e.multiplyByScalar(C,m,L),L),y===t.ROUNDED||y===t.BEVELED?Z.push({leftPositions:c(q,U,B,y,et)}):Z.push({leftPositions:d(V,e.negate(D,D),B,et)})):(B=e.add(V,D,B),F=e.add(B,e.negate(e.multiplyByScalar(C,m,F),F),F),q=e.add(B,e.negate(e.multiplyByScalar(C,2*m,q),q),q),w[0]=e.clone(L,w[0]),w[1]=e.clone(F,w[1]),j=o.generateArc({positions:w,granularity:r,ellipsoid:s}),W=f(j,C,m,W),v&&(G.push(C.x,C.y,C.z),k.push(g.x,g.y,g.z)),U=e.clone(q,U),C=e.normalize(e.cross(g,N,C),C),q=e.add(B,e.negate(e.multiplyByScalar(C,2*m,q),q),q),L=e.add(B,e.negate(e.multiplyByScalar(C,m,L),L),L),y===t.ROUNDED||y===t.BEVELED?Z.push({rightPositions:c(B,U,q,y,et)}):Z.push({rightPositions:d(V,D,q,et)})),z=e.negate(N,z)}V=Y}g=s.geodeticSurfaceNormal(V,g),w[0]=e.clone(L,w[0]),w[1]=e.clone(V,w[1]),j=o.generateArc({positions:w,granularity:r,ellipsoid:s}),W=f(j,C,m,W),v&&(G.push(C.x,C.y,C.z),k.push(g.x,g.y,g.z));var tt;return y===t.ROUNDED&&(tt=l(W)),{positions:W,corners:Z,lefts:G,normals:k,endPositions:tt}};var C=new e,D=new e;return m.scaleToGeodeticHeight=function(t,n,a,i){var o=t.length,u=r(i)?i:new Array(t.length);u.length=t.length;for(var s=n,c=0;o>c;c+=3){var l=a.scaleToGeodeticSurface(e.fromArray(t,c,D),D),d=C;0!==n&&(d=a.geodeticSurfaceNormal(l,d),d=e.multiplyByScalar(d,s,d),l=e.add(l,d,l)),u[c]=l.x,u[c+1]=l.y,u[c+2]=l.z}return u},m}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,a){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var r=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r){"use strict";var a={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,n,a){return e>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,a):new Uint16Array(t,n,a)},n(a)}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return a.POSITION_ONLY=r(new a({position:!0})),a.POSITION_AND_NORMAL=r(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=r(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=r(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=r(new a({position:!0,color:!0})),a.ALL=r(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.position?1:0,n[r++]=t.normal?1:0,n[r++]=t.st?1:0,n[r++]=t.binormal?1:0,n[r++]=t.tangent?1:0,n[r++]=t.color?1:0},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.position=1===n[r++],i.normal=1===n[r++],i.st=1===n[r++],i.binormal=1===n[r++],i.tangent=1===n[r++],i.color=1===n[r++],i},a.clone=function(e,n){return t(e)?(t(n)||(n=new a),n.position=e.position,n.normal=e.normal,n.st=e.st,n.binormal=e.binormal,n.tangent=e.tangent,n.color=e.color,n):void 0},a}),define("Core/CorridorGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,n,r,a,i,o,u,s,c,l,d,f,h,m,p,y){"use strict";function v(e,n,r,i,o,u){var s=e.normals,c=e.tangents,l=e.binormals,d=t.normalize(t.cross(r,n,A),A);u.normal&&a.addAttribute(s,n,i,o),u.binormal&&a.addAttribute(l,r,i,o),u.tangent&&a.addAttribute(c,d,i,o)}function g(e,r,i){var u,s,c,m=e.positions,p=e.corners,y=e.endPositions,g=e.lefts,w=e.normals,E=new d,x=0,T=0,N=0;for(s=0;s<m.length;s+=2)c=m[s].length-3,x+=c,N+=2*c,T+=m[s+1].length-3;for(x+=3,T+=3,s=0;s<p.length;s++){u=p[s];var z=p[s].leftPositions;o(z)?(c=z.length,x+=c,N+=c):(c=p[s].rightPositions.length,T+=c,N+=c)}var I,b=o(y);b&&(I=y[0].length-3,x+=I,T+=I,I/=3,N+=6*I);var C,D,U,L,q,B,F=x+T,W=new Float64Array(F),G=r.normal?new Float32Array(F):void 0,k=r.tangent?new Float32Array(F):void 0,V=r.binormal?new Float32Array(F):void 0,Y={normals:G,tangents:k,binormals:V},j=0,H=F-1,Z=S,X=M,J=I/2,Q=f.createTypedArray(F/3,N),K=0;if(b){B=_,q=O;var $=y[0];for(Z=t.fromArray(w,0,Z),X=t.fromArray(g,0,X),s=0;J>s;s++)B=t.fromArray($,3*(J-1-s),B),q=t.fromArray($,3*(J+s),q),a.addAttribute(W,q,j),a.addAttribute(W,B,void 0,H),v(Y,Z,X,j,H,r),D=j/3,L=D+1,C=(H-2)/3,U=C-1,Q[K++]=C,Q[K++]=D,Q[K++]=U,Q[K++]=U,Q[K++]=D,Q[K++]=L,j+=3,H-=3}var et=0,tt=0,nt=m[et++],rt=m[et++];W.set(nt,j),W.set(rt,H-rt.length+1),X=t.fromArray(g,tt,X);var at,it;for(c=rt.length-3,s=0;c>s;s+=3)at=i.geodeticSurfaceNormal(t.fromArray(nt,s,A),A),it=i.geodeticSurfaceNormal(t.fromArray(rt,c-s,R),R),Z=t.normalize(t.add(at,it,Z),Z),v(Y,Z,X,j,H,r),D=j/3,L=D+1,C=(H-2)/3,U=C-1,Q[K++]=C,Q[K++]=D,Q[K++]=U,Q[K++]=U,Q[K++]=D,Q[K++]=L,j+=3,H-=3;for(at=i.geodeticSurfaceNormal(t.fromArray(nt,c,A),A),it=i.geodeticSurfaceNormal(t.fromArray(rt,c,R),R),Z=t.normalize(t.add(at,it,Z),Z),tt+=3,s=0;s<p.length;s++){var ot;u=p[s];var ut,st,ct=u.leftPositions,lt=u.rightPositions,dt=P,ft=_,ht=O;if(Z=t.fromArray(w,tt,Z),o(ct)){for(v(Y,Z,X,void 0,H,r),H-=3,ut=L,st=U,ot=0;ot<ct.length/3;ot++)dt=t.fromArray(ct,3*ot,dt),Q[K++]=ut,Q[K++]=st-ot-1,Q[K++]=st-ot,a.addAttribute(W,dt,void 0,H),ft=t.fromArray(W,3*(st-ot-1),ft),ht=t.fromArray(W,3*ut,ht),X=t.normalize(t.subtract(ft,ht,X),X),v(Y,Z,X,void 0,H,r),H-=3;dt=t.fromArray(W,3*ut,dt),ft=t.subtract(t.fromArray(W,3*st,ft),dt,ft),ht=t.subtract(t.fromArray(W,3*(st-ot),ht),dt,ht),X=t.normalize(t.add(ft,ht,X),X),v(Y,Z,X,j,void 0,r),j+=3}else{for(v(Y,Z,X,j,void 0,r),j+=3,ut=U,st=L,ot=0;ot<lt.length/3;ot++)dt=t.fromArray(lt,3*ot,dt),Q[K++]=ut,Q[K++]=st+ot,Q[K++]=st+ot+1,a.addAttribute(W,dt,j),ft=t.fromArray(W,3*ut,ft),ht=t.fromArray(W,3*(st+ot),ht),X=t.normalize(t.subtract(ft,ht,X),X),v(Y,Z,X,j,void 0,r),j+=3;dt=t.fromArray(W,3*ut,dt),ft=t.subtract(t.fromArray(W,3*(st+ot),ft),dt,ft),ht=t.subtract(t.fromArray(W,3*st,ht),dt,ht),X=t.normalize(t.negate(t.add(ht,ft,X),X),X),v(Y,Z,X,void 0,H,r),H-=3}for(nt=m[et++],rt=m[et++],nt.splice(0,3),rt.splice(rt.length-3,3),W.set(nt,j),W.set(rt,H-rt.length+1),c=rt.length-3,tt+=3,X=t.fromArray(g,tt,X),ot=0;ot<rt.length;ot+=3)at=i.geodeticSurfaceNormal(t.fromArray(nt,ot,A),A),it=i.geodeticSurfaceNormal(t.fromArray(rt,c-ot,R),R),Z=t.normalize(t.add(at,it,Z),Z),v(Y,Z,X,j,H,r),L=j/3,D=L-1,U=(H-2)/3,C=U+1,Q[K++]=C,Q[K++]=D,Q[K++]=U,Q[K++]=U,Q[K++]=D,Q[K++]=L,j+=3,H-=3;j-=3,H+=3}if(Z=t.fromArray(w,w.length-3,Z),v(Y,Z,X,j,H,r),b){j+=3,H-=3,B=_,q=O;var mt=y[1];for(s=0;J>s;s++)B=t.fromArray(mt,3*(I-s-1),B),q=t.fromArray(mt,3*s,q),a.addAttribute(W,B,void 0,H),a.addAttribute(W,q,j),v(Y,Z,X,j,H,r),L=j/3,D=L-1,U=(H-2)/3,C=U+1,Q[K++]=C,Q[K++]=D,Q[K++]=U,Q[K++]=U,Q[K++]=D,Q[K++]=L,j+=3,H-=3}if(E.position=new l({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:W}),r.st){var pt,yt,vt=new Float32Array(2*(F/3)),gt=0;if(b){x/=3,T/=3;var wt=Math.PI/(I+1);yt=1/(x-I+1),pt=1/(T-I+1);var Et,xt=I/2;for(s=xt+1;I+1>s;s++)Et=h.PI_OVER_TWO+wt*s,vt[gt++]=pt*(1+Math.cos(Et)),vt[gt++]=.5*(1+Math.sin(Et));for(s=1;T-I+1>s;s++)vt[gt++]=s*pt,vt[gt++]=0;for(s=I;s>xt;s--)Et=h.PI_OVER_TWO-s*wt,vt[gt++]=1-pt*(1+Math.cos(Et)),vt[gt++]=.5*(1+Math.sin(Et));for(s=xt;s>0;s--)Et=h.PI_OVER_TWO-wt*s,vt[gt++]=1-yt*(1+Math.cos(Et)),vt[gt++]=.5*(1+Math.sin(Et));for(s=x-I;s>0;s--)vt[gt++]=s*yt,vt[gt++]=1;for(s=1;xt+1>s;s++)Et=h.PI_OVER_TWO+wt*s,vt[gt++]=yt*(1+Math.cos(Et)),vt[gt++]=.5*(1+Math.sin(Et))}else{for(x/=3,T/=3,yt=1/(x-1),pt=1/(T-1),s=0;T>s;s++)vt[gt++]=s*pt,vt[gt++]=0;for(s=x;s>0;s--)vt[gt++]=(s-1)*yt,vt[gt++]=1}E.st=new l({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:vt})}return r.normal&&(E.normal=new l({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:Y.normals})),r.tangent&&(E.tangent=new l({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:Y.tangents})),r.binormal&&(E.binormal=new l({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:Y.binormals})),{attributes:E,indices:Q}}function w(e,n){if(!(n.normal||n.binormal||n.tangent||n.st))return e;var r,i,o=e.position.values;(n.normal||n.binormal)&&(r=e.normal.values,i=e.binormal.values);var u,s=e.position.values.length/18,c=3*s,l=2*s,d=2*c;if(n.normal||n.binormal||n.tangent){var f=n.normal?new Float32Array(6*c):void 0,h=n.binormal?new Float32Array(6*c):void 0,m=n.tangent?new Float32Array(6*c):void 0,p=S,y=M,v=_,g=O,w=T,E=P,x=d;for(u=0;c>u;u+=3){var A=x+d;p=t.fromArray(o,u,p),y=t.fromArray(o,u+c,y),v=t.fromArray(o,(u+3)%c,v),y=t.subtract(y,p,y),v=t.subtract(v,p,v),g=t.normalize(t.cross(y,v,g),g),n.normal&&(a.addAttribute(f,g,A),a.addAttribute(f,g,A+3),a.addAttribute(f,g,x),a.addAttribute(f,g,x+3)),(n.tangent||n.binormal)&&(E=t.fromArray(r,u,E),n.binormal&&(a.addAttribute(h,E,A),a.addAttribute(h,E,A+3),a.addAttribute(h,E,x),a.addAttribute(h,E,x+3)),n.tangent&&(w=t.normalize(t.cross(E,g,w),w),a.addAttribute(m,w,A),a.addAttribute(m,w,A+3),a.addAttribute(m,w,x),a.addAttribute(m,w,x+3))),x+=6}if(n.normal){for(f.set(r),u=0;c>u;u+=3)f[u+c]=-r[u],f[u+c+1]=-r[u+1],f[u+c+2]=-r[u+2];e.normal.values=f}else e.normal=void 0;if(n.binormal?(h.set(i),h.set(i,c),e.binormal.values=h):e.binormal=void 0,n.tangent){var R=e.tangent.values;m.set(R),m.set(R,c),e.tangent.values=m}}if(n.st){var N=e.st.values,z=new Float32Array(6*l);z.set(N),z.set(N,l);for(var I=2*l,b=0;2>b;b++){for(z[I++]=N[0],z[I++]=N[1],u=2;l>u;u+=2){var C=N[u],D=N[u+1];z[I++]=C,z[I++]=D,z[I++]=C,z[I++]=D}z[I++]=N[0],z[I++]=N[1]}e.st.values=z}return e}function E(e,t,n){n[t++]=e[0],n[t++]=e[1],n[t++]=e[2];for(var r=3;r<e.length;r+=3){var a=e[r],i=e[r+1],o=e[r+2];n[t++]=a,n[t++]=i,n[t++]=o,n[t++]=a,n[t++]=i,n[t++]=o}return n[t++]=e[0],n[t++]=e[1],n[t++]=e[2],n}function x(e,t){var n=new y({position:t.positon,normal:t.normal||t.binormal,tangent:t.tangent,binormal:t.normal||t.binormal,st:t.st}),r=e.ellipsoid,i=a.computePositions(e),o=g(i,n,r),u=e.height,s=e.extrudedHeight,c=o.attributes,l=o.indices,d=c.position.values,h=d.length,m=new Float64Array(6*h),p=new Float64Array(h);p.set(d);var v=new Float64Array(4*h);d=a.scaleToGeodeticHeight(d,u,r,d),v=E(d,0,v),p=a.scaleToGeodeticHeight(p,s,r,p),v=E(p,2*h,v),m.set(d),m.set(p,h),m.set(v,2*h),c.position.values=m,h/=3;var x,S=l.length,M=h+h,_=f.createTypedArray(m.length/3,2*S+3*M);_.set(l);var O=S;for(x=0;S>x;x+=3){var T=l[x],P=l[x+1],A=l[x+2];_[O++]=A+h,_[O++]=P+h,_[O++]=T+h}c=w(c,t);var R,N,z,I;for(x=0;M>x;x+=2)R=x+M,N=R+M,z=R+1,I=N+1,_[O++]=R,_[O++]=N,_[O++]=z,_[O++]=z,_[O++]=N,_[O++]=I;return{attributes:c,indices:_}}var S=new t,M=new t,_=new t,O=new t,T=new t,P=new t,A=new t,R=new t,N=function(e){e=i(e,i.EMPTY_OBJECT);var n=e.positions,a=e.width;this._positions=n,this._ellipsoid=s.clone(i(e.ellipsoid,s.WGS84)),this._vertexFormat=y.clone(i(e.vertexFormat,y.DEFAULT)),this._width=a,this._height=i(e.height,0),this._extrudedHeight=i(e.extrudedHeight,this._height),this._cornerType=i(e.cornerType,r.ROUNDED),this._granularity=i(e.granularity,h.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry",this.packedLength=1+n.length*t.packedLength+s.packedLength+y.packedLength+5};N.pack=function(e,n,r){r=i(r,0);var a=e._positions,o=a.length;n[r++]=o;for(var u=0;o>u;++u,r+=t.packedLength)t.pack(a[u],n,r);s.pack(e._ellipsoid,n,r),r+=s.packedLength,y.pack(e._vertexFormat,n,r),r+=y.packedLength,n[r++]=e._width,n[r++]=e._height,n[r++]=e._extrudedHeight,n[r++]=e._cornerType,n[r]=e._granularity};var z=s.clone(s.UNIT_SPHERE),I=new y,b={positions:void 0,ellipsoid:z,vertexFormat:I,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return N.unpack=function(e,n,r){n=i(n,0);for(var a=e[n++],u=new Array(a),c=0;a>c;++c,n+=t.packedLength)u[c]=t.unpack(e,n);var l=s.unpack(e,n,z);n+=s.packedLength;var d=y.unpack(e,n,I);n+=y.packedLength;var f=e[n++],h=e[n++],m=e[n++],p=e[n++],v=e[n];return o(r)?(r._positions=u,r._ellipsoid=s.clone(l,r._ellipsoid),r._vertexFormat=y.clone(d,r._vertexFormat),r._width=f,r._height=h,r._extrudedHeight=m,r._cornerType=p,r._granularity=v,r):(b.positions=u,b.width=f,b.height=h,b.extrudedHeight=m,b.cornerType=p,b.granularity=v,new N(b))},N.createGeometry=function(t){var n=t._positions,r=t._height,i=t._extrudedHeight,u=r!==i,s=m.removeDuplicates(n);if(o(s)||(s=n),s.length<2)return void 0;var l,d=t._ellipsoid,f=t._vertexFormat,h={ellipsoid:d,positions:s,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!0};if(u){var y=Math.max(r,i);i=Math.min(r,i),r=y,h.height=r,h.extrudedHeight=i,l=x(h,f)}else{var v=a.computePositions(h);l=g(v,f,d),l.attributes.position.values=a.scaleToGeodeticHeight(l.attributes.position.values,r,d,l.attributes.position.values)}var w=l.attributes,E=e.fromVertices(w.position.values,void 0,3);return f.position||(l.attributes.position.values=void 0),new c({attributes:w,indices:l.indices,primitiveType:p.TRIANGLES,boundingSphere:E})},N}),define("Workers/createCorridorGeometry",["../Core/CorridorGeometry","../Core/defined","../Core/Ellipsoid"],function(e,t,n){"use strict";function r(r,a){return t(a)&&(r=e.unpack(r,a)),r._ellipsoid=n.clone(r._ellipsoid),e.createGeometry(r)}return r})}();