/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};r.EPSILON1=.1,r.EPSILON2=.01,r.EPSILON3=.001,r.EPSILON4=1e-4,r.EPSILON5=1e-5,r.EPSILON6=1e-6,r.EPSILON7=1e-7,r.EPSILON8=1e-8,r.EPSILON9=1e-9,r.EPSILON10=1e-10,r.EPSILON11=1e-11,r.EPSILON12=1e-12,r.EPSILON13=1e-13,r.EPSILON14=1e-14,r.EPSILON15=1e-15,r.EPSILON16=1e-16,r.EPSILON17=1e-17,r.EPSILON18=1e-18,r.EPSILON19=1e-19,r.EPSILON20=1e-20,r.GRAVITATIONALPARAMETER=3986004418e5,r.SOLAR_RADIUS=6955e5,r.LUNAR_RADIUS=1737400,r.SIXTY_FOUR_KILOBYTES=65536,r.sign=function(e){return e>0?1:0>e?-1:0},r.signNotZero=function(e){return 0>e?-1:1},r.toSNorm=function(e){return Math.round(255*(.5*r.clamp(e,-1,1)+.5))},r.fromSNorm=function(e){return 2*(r.clamp(e,0,255)/255)-1},r.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},r.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},r.lerp=function(e,t,r){return(1-r)*e+r*t},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=.5*Math.PI,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=.5*3*Math.PI,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(e){return e*r.RADIANS_PER_DEGREE},r.toDegrees=function(e){return e*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(e){var t=r.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},r.negativePiToPi=function(e){return r.zeroToTwoPi(e+r.PI)-r.PI},r.zeroToTwoPi=function(e){var t=r.mod(e,r.TWO_PI);return Math.abs(t)<r.EPSILON14&&Math.abs(e)>r.EPSILON14?r.TWO_PI:t},r.mod=function(e,t){return(e%t+t)%t},r.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return a>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var n=[1];r.factorial=function(e){var t=n.length;if(e>=t)for(var r=n[t-1],a=t;e>=a;a++)n.push(r*a);return n[e]},r.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},r.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},r.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},r.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new e;return r.setRandomNumberSeed=function(t){a=new e(t)},r.nextRandomNumber=function(){return a.random()},r.acosClamped=function(e){return Math.acos(r.clamp(e,-1,1))},r.asinClamped=function(e){return Math.asin(r.clamp(e,-1,1))},r.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},r}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,f=n*u-a*o;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,r,n,o)};var f=new i,d=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:h,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,d);var l=Math.sqrt(i.dot(f,d));return d=i.divideByScalar(d,l,d),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(d,f,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=a.toRadians(e[o]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=i.fromRadians(u,s,0,r,n[o/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=a.toRadians(e[o]),n[o+1]=a.toRadians(e[o+1]),n[o+2]=e[o+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=i.fromRadians(u,s,c,r,n[o/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,a,o){return a=e(a,0),t(o)?(o.longitude=r,o.latitude=n,o.height=a,o):new i(r,n,a)},i.fromDegrees=function(e,t,r,n){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,a){a=r(a,0),e.pack(t._radii,n,a)},c.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,r){var a=l,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,h=new e,m=new e;c.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,h);if(!n(i))return void 0;var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(r,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var y=new e,p=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,d=a*a*c*c,h=i*i*l*l,m=o*o*f*f,v=d+h+m,g=Math.sqrt(1/v),w=e.multiplyByScalar(t,g,y);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(w,r):void 0;var x=this._oneOverRadiiSquared,E=x.x,S=x.y,M=x.z,b=p;b.x=2*w.x*E,b.y=2*w.y*S,b.z=2*w.z*M;var T,A,O,z,I,N,R,P,_,L,C,q=(1-g)*e.magnitude(t)/(.5*e.magnitude(b)),D=0;do{q-=D,O=1/(1+q*E),z=1/(1+q*S),I=1/(1+q*M),N=O*O,R=z*z,P=I*I,_=N*O,L=R*z,C=P*I,T=d*N+h*R+m*P-1,A=d*_*E+h*L*S+m*C*M;var B=-2*A;D=T/B}while(Math.abs(T)>u.EPSILON12);return n(r)?(r.x=a*O,r.y=i*z,r.z=o*I,r):new e(a*O,i*z,o*I)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";var u=function(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n,a){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(a,0)};i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)&&a.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(h[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=i.EPSILON15,n=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(h[o],d[o])]);u>n&&(a=o,n=u)}var s=1,l=0,f=d[a],m=h[a];if(Math.abs(e[c.getElementIndex(m,f)])>r){var y,p=e[c.getElementIndex(m,m)],v=e[c.getElementIndex(f,f)],g=e[c.getElementIndex(m,f)],w=(p-v)/2/g;y=0>w?-1/(-w+Math.sqrt(1+w*w)):1/(w+Math.sqrt(1+w*w)),s=1/Math.sqrt(1+y*y),l=y*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(m,m)]=s,t[c.getElementIndex(m,f)]=l,t[c.getElementIndex(f,m)]=-l,t}var c=function(e,r,n,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a[4]=e[n++],a[5]=e[n++],a[6]=e[n++],a[7]=e[n++],a[8]=e[n++],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,f=e.z*e.z,d=e.z*e.w,h=e.w*e.w,m=n-u-f+h,y=2*(a-d),p=2*(i+l),v=2*(a+d),g=-n+u-f+h,w=2*(s-o),x=2*(i-l),E=2*(s+o),S=-n-u+f+h;return r(t)?(t[0]=m,t[1]=v,t[2]=x,t[3]=y,t[4]=g,t[5]=E,t[6]=p,t[7]=w,t[8]=S,t):new c(m,y,p,v,g,w,x,E,S)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new c(1,0,0,0,n,-a,0,a,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new c(n,0,a,0,1,0,-a,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-a,0,a,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var d=[1,0,0],h=[2,2,1],m=new c,y=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,a=10,l=0,f=0;r(t)||(t={});for(var d=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),p=n*o(h);a>f&&u(h)>p;)s(h,m),c.transpose(m,y),c.multiply(h,m,h),c.multiply(y,h,h),c.multiply(d,m,d),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},c.inverse=function(e,t){var r=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],f=e[6],d=e[7],h=e[8],m=c.determinant(e);if(Math.abs(m)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=s*h-d*l,t[1]=d*o-a*h,t[2]=a*l-s*o,t[3]=f*l-u*h,t[4]=r*h-f*o,t[5]=u*o-r*l,t[6]=u*d-f*s,t[7]=f*a-r*d,t[8]=r*s-u*a;var y=1/m;return c.multiplyByScalar(t,y,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s){"use strict";var c=function(e,t,n,a,i,o,u,s,c,l,f,d,h,m,y,p){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(m,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(y,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(d,0),this[15]=r(p,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=r(a,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,a){n(a)||(a=new c);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,d=t.x*t.w,h=t.y*t.y,m=t.y*t.z,y=t.y*t.w,p=t.z*t.z,v=t.z*t.w,g=t.w*t.w,w=s-h-p+g,x=2*(l-v),E=2*(f+y),S=2*(l+v),M=-s+h-p+g,b=2*(m-d),T=2*(f-y),A=2*(m+d),O=-s-h+p+g;return a[0]=w*i,a[1]=S*i,a[2]=T*i,a[3]=0,a[4]=x*o,a[5]=M*o,a[6]=A*o,a[7]=0,a[8]=E*u,a[9]=b*u,a[10]=O*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,d=new e;c.fromCamera=function(t,r){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,d),d);var u=f.x,s=f.y,h=f.z,m=l.x,y=l.y,p=l.z,v=d.x,g=d.y,w=d.z,x=a.x,E=a.y,S=a.z,M=u*-x+s*-E+h*-S,b=v*-x+g*-E+w*-S,T=m*x+y*E+p*S;return n(r)?(r[0]=u,r[1]=v,r[2]=-m,r[3]=0,r[4]=s,r[5]=g,r[6]=-y,r[7]=0,r[8]=h,r[9]=w,r[10]=-p,r[11]=0,r[12]=M,r[13]=b,r[14]=T,r[15]=1,r):new c(u,s,h,M,v,g,w,b,-m,-y,-p,T,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,f=-(n+r)*s,d=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=d,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+a)/(i-a),d=-1,h=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=d,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,d=-2*a;
return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=d,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),d=c,h=l,m=f,y=i+c,p=o+l,v=t+f,g=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=y,a[13]=p,a[14]=v,a[15]=g,a},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},c.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var h=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),r};var m=new e;c.getMaximumScale=function(t){return c.getScale(t,m),e.maximumComponent(m)},c.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],d=e[9],h=e[10],m=e[11],y=e[12],p=e[13],v=e[14],g=e[15],w=t[0],x=t[1],E=t[2],S=t[3],M=t[4],b=t[5],T=t[6],A=t[7],O=t[8],z=t[9],I=t[10],N=t[11],R=t[12],P=t[13],_=t[14],L=t[15],C=n*w+u*x+f*E+y*S,q=a*w+s*x+d*E+p*S,D=i*w+c*x+h*E+v*S,B=o*w+l*x+m*E+g*S,U=n*M+u*b+f*T+y*A,F=a*M+s*b+d*T+p*A,G=i*M+c*b+h*T+v*A,k=o*M+l*b+m*T+g*A,W=n*O+u*z+f*I+y*N,V=a*O+s*z+d*I+p*N,Y=i*O+c*z+h*I+v*N,j=o*O+l*z+m*I+g*N,H=n*R+u*P+f*_+y*L,Z=a*R+s*P+d*_+p*L,X=i*R+c*P+h*_+v*L,Q=o*R+l*P+m*_+g*L;return r[0]=C,r[1]=q,r[2]=D,r[3]=B,r[4]=U,r[5]=F,r[6]=G,r[7]=k,r[8]=W,r[9]=V,r[10]=Y,r[11]=j,r[12]=H,r[13]=Z,r[14]=X,r[15]=Q,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=e[12],h=e[13],m=e[14],y=t[0],p=t[1],v=t[2],g=t[4],w=t[5],x=t[6],E=t[8],S=t[9],M=t[10],b=t[12],T=t[13],A=t[14],O=n*y+o*p+c*v,z=a*y+u*p+l*v,I=i*y+s*p+f*v,N=n*g+o*w+c*x,R=a*g+u*w+l*x,P=i*g+s*w+f*x,_=n*E+o*S+c*M,L=a*E+u*S+l*M,C=i*E+s*S+f*M,q=n*b+o*T+c*A+d,D=a*b+u*T+l*A+h,B=i*b+s*T+f*A+m;return r[0]=O,r[1]=z,r[2]=I,r[3]=0,r[4]=N,r[5]=R,r[6]=P,r[7]=0,r[8]=_,r[9]=L,r[10]=C,r[11]=0,r[12]=q,r[13]=D,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=t[0],h=t[1],m=t[2],y=t[3],p=t[4],v=t[5],g=t[6],w=t[7],x=t[8],E=n*d+o*h+c*m,S=a*d+u*h+l*m,M=i*d+s*h+f*m,b=n*y+o*p+c*v,T=a*y+u*p+l*v,A=i*y+s*p+f*v,O=n*g+o*w+c*x,z=a*g+u*w+l*x,I=i*g+s*w+f*x;return r[0]=E,r[1]=S,r[2]=M,r[3]=0,r[4]=b,r[5]=T,r[6]=A,r[7]=0,r[8]=O,r[9]=z,r[10]=I,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var y=new e;c.multiplyByUniformScale=function(e,t,r){return y.x=t,y.y=t,y.z=t,c.multiplyByScale(e,y,r)},c.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new u,v=new u,g=new t,w=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,p),v,o.EPSILON7)&&t.equals(c.getRow(e,3,g),w))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],l=e[12],f=e[1],d=e[5],h=e[9],m=e[13],y=e[2],x=e[6],E=e[10],S=e[14],M=e[3],b=e[7],T=e[11],A=e[15],O=E*A,z=S*T,I=x*A,N=S*b,R=x*T,P=E*b,_=y*A,L=S*M,C=y*T,q=E*M,D=y*b,B=x*M,U=O*d+N*h+R*m-(z*d+I*h+P*m),F=z*f+_*h+q*m-(O*f+L*h+C*m),G=I*f+L*d+D*m-(N*f+_*d+B*m),k=P*f+C*d+B*h-(R*f+q*d+D*h),W=z*a+I*i+P*l-(O*a+N*i+R*l),V=O*n+L*i+C*l-(z*n+_*i+q*l),Y=N*n+_*a+B*l-(I*n+L*a+D*l),j=R*n+q*a+D*i-(P*n+C*a+B*i);O=i*m,z=l*h,I=a*m,N=l*d,R=a*h,P=i*d,_=n*m,L=l*f,C=n*h,q=i*f,D=n*d,B=a*f;var H=O*b+N*T+R*A-(z*b+I*T+P*A),Z=z*M+_*T+q*A-(O*M+L*T+C*A),X=I*M+L*b+D*A-(N*M+_*b+B*A),Q=P*M+C*b+B*T-(R*M+q*b+D*T),K=I*E+P*S+z*x-(R*S+O*x+N*E),J=C*S+O*y+L*E-(_*E+q*S+z*y),$=_*x+B*S+N*y-(D*S+I*y+L*x),et=D*E+R*y+q*x-(C*x+B*E+P*y),tt=n*U+a*F+i*G+l*k;if(Math.abs(tt)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return tt=1/tt,r[0]=U*tt,r[1]=F*tt,r[2]=G*tt,r[3]=k*tt,r[4]=W*tt,r[5]=V*tt,r[6]=Y*tt,r[7]=j*tt,r[8]=H*tt,r[9]=Z*tt,r[10]=X*tt,r[11]=Q*tt,r[12]=K*tt,r[13]=J*tt,r[14]=$*tt,r[15]=et*tt,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],d=e[13],h=e[14],m=-r*f-n*d-a*h,y=-i*f-o*d-u*h,p=-s*f-c*d-l*h;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=m,t[13]=y,t[14]=p,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(a,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,a,i,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),r(o)?(o.west=e,o.south=n,o.east=a,o.north=i,o):new s(e,n,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=a,t.north=o,t):new s(n,i,a,o)},s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var d=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return d>=h?void 0:r(n)?(n.west=l,n.south=d,n.east=f,n.north=h,n):new s(l,d,f,h)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,a,o){n=t(n,i.WGS84),a=t(a,0),r(o)||(o=[]);var l=0,f=e.north,d=e.south,h=e.east,m=e.west,y=c;y.height=a,y.longitude=m,y.latitude=f,o[l]=n.cartographicToCartesian(y,o[l]),l++,y.longitude=h,o[l]=n.cartographicToCartesian(y,o[l]),l++,y.latitude=d,o[l]=n.cartographicToCartesian(y,o[l]),l++,y.longitude=m,o[l]=n.cartographicToCartesian(y,o[l]),l++,y.latitude=0>f?f:d>0?d:0;for(var p=1;8>p;++p)y.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,y)&&(o[l]=n.cartographicToCartesian(y,o[l]),l++);return 0===y.latitude&&(y.longitude=m,o[l]=n.cartographicToCartesian(y,o[l]),l++,y.longitude=h,o[l]=n.cartographicToCartesian(y,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l){"use strict";var f=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},d=new e,h=new e,m=new e,y=new e,p=new e,v=new e,g=new e,w=new e,x=new e,E=new e,S=new e,M=new e;f.fromPoints=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var a=e.clone(t[0],g),i=e.clone(a,d),o=e.clone(a,h),u=e.clone(a,m),s=e.clone(a,y),c=e.clone(a,p),l=e.clone(a,v),b=t.length,T=1;b>T;T++){e.clone(t[T],a);var A=a.x,O=a.y,z=a.z;A<i.x&&e.clone(a,i),A>s.x&&e.clone(a,s),O<o.y&&e.clone(a,o),O>c.y&&e.clone(a,c),z<u.z&&e.clone(a,u),z>l.z&&e.clone(a,l)}var I=e.magnitudeSquared(e.subtract(s,i,w)),N=e.magnitudeSquared(e.subtract(c,o,w)),R=e.magnitudeSquared(e.subtract(l,u,w)),P=i,_=s,L=I;N>L&&(L=N,P=o,_=c),R>L&&(L=R,P=u,_=l);var C=x;C.x=.5*(P.x+_.x),C.y=.5*(P.y+_.y),C.z=.5*(P.z+_.z);var q=e.magnitudeSquared(e.subtract(_,C,w)),D=Math.sqrt(q),B=E;B.x=i.x,B.y=o.y,B.z=u.z;var U=S;U.x=s.x,U.y=c.y,U.z=l.z;var F=e.multiplyByScalar(e.add(B,U,w),.5,M),G=0;for(T=0;b>T;T++){e.clone(t[T],a);var k=e.magnitude(e.subtract(a,F,w));k>G&&(G=k);var W=e.magnitudeSquared(e.subtract(a,C,w));if(W>q){var V=Math.sqrt(W);D=.5*(D+V),q=D*D;var Y=V-D;C.x=(D*C.x+Y*a.x)/V,C.y=(D*C.y+Y*a.y)/V,C.z=(D*C.z+Y*a.z)/V}}return G>D?(e.clone(C,r.center),r.radius=D):(e.clone(F,r.center),r.radius=G),r};var b=new o,T=new e,A=new e,O=new t,z=new t;f.fromRectangle2D=function(e,t,r){return f.fromRectangleWithHeights2D(e,t,0,0,r)},f.fromRectangleWithHeights2D=function(t,a,i,o,u){if(n(u)||(u=new f),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=r(a,b),l.southwest(t,O),O.height=i,l.northeast(t,z),z.height=o;var s=a.project(O,T),c=a.project(z,A),d=c.x-s.x,h=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(d*d+h*h+m*m);var y=u.center;return y.x=s.x+.5*d,y.y=s.y+.5*h,y.z=s.z+.5*m,u};var I=[];f.fromRectangle3D=function(e,t,a,o){t=r(t,i.WGS84),a=r(a,0);var u;return n(e)&&(u=l.subsample(e,t,a,I)),f.fromPoints(u,o)},f.fromVertices=function(t,a,i,o){if(n(o)||(o=new f),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=r(a,e.ZERO),i=r(i,3);var u=g;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,d),c=e.clone(u,h),l=e.clone(u,m),b=e.clone(u,y),T=e.clone(u,p),A=e.clone(u,v),O=t.length,z=0;O>z;z+=i){var I=t[z]+a.x,N=t[z+1]+a.y,R=t[z+2]+a.z;u.x=I,u.y=N,u.z=R,I<s.x&&e.clone(u,s),I>b.x&&e.clone(u,b),N<c.y&&e.clone(u,c),N>T.y&&e.clone(u,T),R<l.z&&e.clone(u,l),R>A.z&&e.clone(u,A)}var P=e.magnitudeSquared(e.subtract(b,s,w)),_=e.magnitudeSquared(e.subtract(T,c,w)),L=e.magnitudeSquared(e.subtract(A,l,w)),C=s,q=b,D=P;_>D&&(D=_,C=c,q=T),L>D&&(D=L,C=l,q=A);var B=x;B.x=.5*(C.x+q.x),B.y=.5*(C.y+q.y),B.z=.5*(C.z+q.z);var U=e.magnitudeSquared(e.subtract(q,B,w)),F=Math.sqrt(U),G=E;G.x=s.x,G.y=c.y,G.z=l.z;var k=S;k.x=b.x,k.y=T.y,k.z=A.z;var W=e.multiplyByScalar(e.add(G,k,w),.5,M),V=0;for(z=0;O>z;z+=i){u.x=t[z]+a.x,u.y=t[z+1]+a.y,u.z=t[z+2]+a.z;var Y=e.magnitude(e.subtract(u,W,w));Y>V&&(V=Y);var j=e.magnitudeSquared(e.subtract(u,B,w));if(j>U){var H=Math.sqrt(j);F=.5*(F+H),U=F*F;var Z=H-F;B.x=(F*B.x+Z*u.x)/H,B.y=(F*B.y+Z*u.y)/H,B.z=(F*B.z+Z*u.z)/H}}return V>F?(e.clone(B,o.center),o.radius=F):(e.clone(W,o.center),o.radius=V),o},f.fromCornerPoints=function(t,r,a){n(a)||(a=new f);var i=a.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,r),a},f.fromEllipsoid=function(t,r){return n(r)||(r=new f),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var N=new e;f.fromBoundingSpheres=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=t.length;if(1===a)return f.clone(t[0],r);if(2===a)return f.union(t[0],t[1],r);for(var i=[],o=0;a>o;o++)i.push(t[o].center);r=f.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,N)+c.radius)}return r.radius=s,r},f.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius):void 0},f.packedLength=4,f.pack=function(e,t,n){n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},f.unpack=function(e,t,a){t=r(t,0),n(a)||(a=new f);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var R=new e,P=new e;f.union=function(t,r,a){n(a)||(a=new f);var i=t.center,o=r.center;e.add(i,o,P);var u=e.multiplyByScalar(P,.5,P),s=e.magnitude(e.subtract(i,u,R))+t.radius,c=e.magnitude(e.subtract(o,u,R))+r.radius;return a.radius=Math.max(s,c),e.clone(u,a.center),a};var _=new e;f.expand=function(t,r,n){n=f.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,_));return a>n.radius&&(n.radius=a),n},f.intersect=function(t,r){var n=t.center,a=t.radius,i=e.dot(r,n)+r.w;return-a>i?u.OUTSIDE:a>i?u.INTERSECTING:u.INSIDE},f.transform=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var L=new e;f.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,L);return e.magnitudeSquared(n)-t.radius*t.radius},f.transformWithoutScale=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var C=new e;f.computePlaneDistances=function(t,r,a,i){n(i)||(i=new s);var o=e.subtract(t.center,r,C),u=e.multiplyByScalar(a,e.dot(a,o),C),c=e.magnitude(u);return i.start=c-t.radius,i.stop=c+t.radius,i};for(var q=new e,D=new e,B=new e,U=new e,F=new e,G=new t,k=new Array(8),W=0;8>W;++W)k[W]=new e;var V=new o;return f.projectTo2D=function(t,n,a){n=r(n,V);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,q),c=e.cross(e.UNIT_Z,s,D);e.normalize(c,c);var l=e.cross(s,c,B);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var d=e.negate(l,F),h=e.negate(c,U),m=k,y=m[0];e.add(s,l,y),e.add(y,c,y),y=m[1],e.add(s,l,y),e.add(y,h,y),y=m[2],e.add(s,d,y),e.add(y,h,y),y=m[3],e.add(s,d,y),e.add(y,c,y),e.negate(s,s),y=m[4],e.add(s,l,y),e.add(y,c,y),y=m[5],e.add(s,l,y),e.add(y,h,y),y=m[6],e.add(s,d,y),e.add(y,h,y),y=m[7],e.add(s,d,y),e.add(y,c,y);for(var p=m.length,v=0;p>v;++v){var g=m[v];e.add(o,g,g);var w=i.cartesianToCartographic(g,G);n.project(w,g)}a=f.fromPoints(m,a),o=a.center;var x=o.x,E=o.y,S=o.z;return o.x=S,o.y=x,o.z=E,a},f.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?n.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(n.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[n.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,v=n(e[1]))}return p}function i(){return a()&&v}function o(){if(!t(g)&&(g=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,w=n(e[1]))}return g}function u(){return o()&&w}function s(){if(!t(x)){x=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(x=!0,E=n(e[1]),E.isNightly=!!e[2])}return x}function c(){return s()&&E}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,M=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,M=n(e[1])))}return S}function f(){return l()&&M}function d(){if(!t(b)){b=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(b=!0,T=n(e[1]))}return b}function h(){return t(A)||(A=/Windows/i.test(navigator.appVersion)),A}function m(){return d()&&T}function y(){return t(O)||(O=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),O}var p,v,g,w,x,E,S,M,b,T,A,O,z={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:d,firefoxVersion:m,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:y};return z.supportsFullscreen=function(){return r.supportsFullscreen()},z.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},z.supportsWebWorkers=function(){return"undefined"!=typeof Worker},z}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,a){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(t,n,a,o){switch(a=e(a,0),o=e(o,(n.byteLength-a)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(n,a,o);case i.UNSIGNED_BYTE:return new Uint8Array(n,a,o);case i.SHORT:return new Int16Array(n,a,o);case i.UNSIGNED_SHORT:return new Uint16Array(n,a,o);case i.FLOAT:return new Float32Array(n,a,o);case i.DOUBLE:return new Float64Array(n,a,o);default:throw new r("componentDatatype is not a valid value.")}},a(i)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,d=Math.cos(i);return r(a)?(a.x=u,a.y=l,a.z=f,a.w=d,a):new s(u,l,f,d)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var n,a,i,o,c,d=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=d+h+m;if(y>0)n=Math.sqrt(y+1),c=.5*n,n=.5/n,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var p=l,v=0;h>d&&(v=1),m>d&&m>h&&(v=2);var g=p[v],w=p[g];n=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(w,w)]+1);var x=f;x[v]=.5*n,n=.5/n,c=(e[u.getElementIndex(w,g)]-e[u.getElementIndex(g,w)])*n,x[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*n,x[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*n,a=-x[0],i=-x[1],o=-x[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var d=new s;s.fromHeadingPitchRoll=function(t,r,n,a){var i=s.fromAxisAngle(e.UNIT_X,n,d),o=s.fromAxisAngle(e.UNIT_Y,-r,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,d);return s.multiply(u,a,a)};var h=new e,m=new e,y=new s,p=new s,v=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.x=e[n],a.y=e[n+1],a.z=e[n+2],a.w=e[n+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,v),s.conjugate(v,v);for(var a=0,i=r-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),y),s.multiply(y,v,y),y.w<0&&s.negate(y,y),s.computeAxis(y,h);var u=s.computeAngle(y);n[o]=h.x*u,n[o+1]=h.y*u,n[o+2]=h.z*u}},s.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(n,4*i,p),0===u?s.clone(s.IDENTITY,y):s.fromAxisAngle(m,u,y),s.multiply(y,p,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w
},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+n*l+a*c-i*s,d=o*s-n*c+a*l+i*u,h=o*c+n*s-a*u+i*l,m=o*l-n*u-a*s-i*c;return r.x=f,r.y=d,r.z=h,r.w=m,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var g=new s;s.lerp=function(e,t,r,n){return g=s.multiplyByScalar(t,r,g),n=s.multiplyByScalar(e,1-r,n),s.add(g,n,n)};var w=new s,x=new s,E=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=w=s.negate(t,w)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return x=s.multiplyByScalar(e,Math.sin((1-r)*u),x),E=s.multiplyByScalar(i,Math.sin(r*u),E),n=s.add(x,E,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var S=new e,M=new e,b=new s,T=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,b);s.multiply(i,n,T);var o=s.log(T,S);s.multiply(i,t,T);var u=s.log(T,M);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,b),s.multiply(r,b,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,b),u=s.slerp(r,n,a,T);return s.slerp(o,u,2*a*(1-a),i)};for(var A=new s,O=1.9011074535173003,z=a.supportsTypedArrays()?new Float32Array(8):[],I=a.supportsTypedArrays()?new Float32Array(8):[],N=a.supportsTypedArrays()?new Float32Array(8):[],R=a.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var _=P+1,L=2*_+1;z[P]=1/(_*L),I[P]=_/L}return z[7]=O/136,I[7]=8*O/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,f=7;f>=0;--f)N[f]=(z[f]*c-I[f])*o,R[f]=(z[f]*l-I[f])*o;var d=a*r*(1+N[0]*(1+N[1]*(1+N[2]*(1+N[3]*(1+N[4]*(1+N[5]*(1+N[6]*(1+N[7])))))))),h=u*(1+R[0]*(1+R[1]*(1+R[2]*(1+R[3]*(1+R[4]*(1+R[5]*(1+R[6]*(1+R[7])))))))),m=s.multiplyByScalar(e,h,A);return s.multiplyByScalar(t,d,n),s.add(m,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,b),u=s.fastSlerp(r,n,a,T);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,n){"use strict";function a(t,a,i,l,f,d,h,m,y,p){var v=t+a;e.multiplyByScalar(l,Math.cos(v),o),e.multiplyByScalar(i,Math.sin(v),u),e.add(o,u,o);var g=Math.cos(t);g*=g;var w=Math.sin(t);w*=w;var x=d/Math.sqrt(h*g+f*w),E=x/m;return n.fromAxisAngle(o,E,s),r.fromQuaternion(s,c),r.multiplyByVector(c,y,p),e.normalize(p,p),e.multiplyByScalar(p,m,p),p}var i={},o=new e,u=new e,s=new n,c=new r,l=new e,f=new e,d=new e,h=new e;i.raisePositionsToHeight=function(t,r,n){for(var a=r.ellipsoid,i=r.height,o=r.extrudedHeight,u=n?2*(t.length/3):t.length/3,s=new Float64Array(3*u),c=t.length,m=n?c:0,y=0;c>y;y+=3){var p=y+1,v=y+2,g=e.fromArray(t,y,l);a.scaleToGeodeticSurface(g,g);var w=e.clone(g,f),x=a.geodeticSurfaceNormal(g,h),E=e.multiplyByScalar(x,i,d);e.add(g,E,g),n&&(e.multiplyByScalar(x,o,E),e.add(w,E,w),s[y+m]=w.x,s[p+m]=w.y,s[v+m]=w.z),s[y]=g.x,s[p]=g.y,s[v]=g.z}return s};var m=new e,y=new e,p=new e;return i.computeEllipsePositions=function(r,n,i){var o=r.semiMinorAxis,u=r.semiMajorAxis,s=r.rotation,c=r.center,h=8*r.granularity,v=o*o,g=u*u,w=u*o,x=e.magnitude(c),E=e.normalize(c,m),S=e.cross(e.UNIT_Z,c,y);S=e.normalize(S,S);var M=e.cross(E,S,p),b=1+Math.ceil(t.PI_OVER_TWO/h),T=t.PI_OVER_TWO/(b-1),A=t.PI_OVER_TWO-b*T;0>A&&(b-=Math.ceil(Math.abs(A)/T));var O,z,I,N,R,P=2*b*(b+1),_=n?new Array(3*P):void 0,L=0,C=l,q=f,D=3*(2*b+2*(b-1)),B=D-1,U=0,F=i?new Array(D):void 0;for(A=t.PI_OVER_TWO,O=0;b>O;++O){if(C=a(A,s,M,S,v,w,g,x,E,C),q=a(Math.PI-A,s,M,S,v,w,g,x,E,q),n){for(_[L++]=C.x,_[L++]=C.y,_[L++]=C.z,I=2*O+2,z=1;I-1>z;++z)N=z/(I-1),R=e.lerp(C,q,N,d),_[L++]=R.x,_[L++]=R.y,_[L++]=R.z;_[L++]=q.x,_[L++]=q.y,_[L++]=q.z}i&&(F[B--]=C.z,F[B--]=C.y,F[B--]=C.x,0!==O&&(F[U++]=q.x,F[U++]=q.y,F[U++]=q.z)),A=t.PI_OVER_TWO-(O+1)*T}for(O=b;O>0;--O){if(A=t.PI_OVER_TWO-(O-1)*T,C=a(-A,s,M,S,v,w,g,x,E,C),q=a(A+Math.PI,s,M,S,v,w,g,x,E,q),n){for(_[L++]=C.x,_[L++]=C.y,_[L++]=C.z,I=2*(O-1)+2,z=1;I-1>z;++z)N=z/(I-1),R=e.lerp(C,q,N,d),_[L++]=R.x,_[L++]=R.y,_[L++]=R.z;_[L++]=q.x,_[L++]=q.y,_[L++]=q.z}i&&(F[B--]=C.z,F[B--]=C.y,F[B--]=C.x,1!==O&&(F[U++]=q.x,F[U++]=q.y,F[U++]=q.z))}var G={};return n&&(G.positions=_,G.numPts=b),i&&(G.outerPositions=F),G},i}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*a.signNotZero(r),t.y=(1-Math.abs(r))*a.signNotZero(n)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=a.fromSNorm(e),n.y=a.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*a.signNotZero(i),n.y=(1-Math.abs(i))*a.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:0|4096*e.x,r=1===e.y?4095:0|4096*e.y;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=new t,a=new t,i=new t,o=function(o,u,s,c,l){r(l)||(l=new t);var f,d,h,m,y,p,v,g;r(u.z)?(f=t.subtract(s,u,n),d=t.subtract(c,u,a),h=t.subtract(o,u,i),m=t.dot(f,f),y=t.dot(f,d),p=t.dot(f,h),v=t.dot(d,d),g=t.dot(d,h)):(f=e.subtract(s,u,n),d=e.subtract(c,u,a),h=e.subtract(o,u,i),m=e.dot(f,f),y=e.dot(f,d),p=e.dot(f,h),v=e.dot(d,d),g=e.dot(d,h));var w=1/(m*v-y*y);return l.y=(v*p-y*g)*w,l.z=(m*g-y*p)*w,l.x=1-l.y-l.z,l};return o}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};r.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var n={high:0,low:0};r.fromCartesian=function(e,a){t(a)||(a=new r);var i=a.high,o=a.low;return r.encode(e.x,n),i.x=n.high,o.x=n.low,r.encode(e.y,n),i.y=n.high,o.y=n.low,r.encode(e.z,n),i.z=n.high,o.z=n.low,a};var a=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,a);var i=a.high,o=a.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=o.x,t[n+4]=o.y,t[n+5]=o.z},r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n){"use strict";var a={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,r,a){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,a):new Uint16Array(t,r,a)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*a,f=r(c,-l,t.EPSILON14);if(0>f)return[];var d=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[d/e,a/d]:[a/d,d/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,d=u*u,h=s*s,m=o*s-d,y=o*c-u*s,p=u*c-h,v=4*m*p-y*y;if(0>v){var g,w,x;d*f>=l*h?(g=o,w=m,x=-2*u*m+o*y):(g=c,w=p,x=-c*y+2*s*p);var E=0>x?-1:1,S=-E*Math.abs(g)*Math.sqrt(-v);i=-x+S;var M=i/2,b=0>M?-Math.pow(-M,1/3):Math.pow(M,1/3),T=i===S?-b:-w/b;return a=0>=w?b+T:-x/(b*b+T*T+w),d*f>=l*h?[(a-u)/o]:[-c/(a+s)]}var A=m,O=-2*u*m+o*y,z=p,I=-c*y+2*s*p,N=Math.sqrt(v),R=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*N,-O)/3);a=2*Math.sqrt(-A);var _=Math.cos(P);i=a*_;var L=a*(-_/2-R*Math.sin(P)),C=i+L>2*u?i-u:L-u,q=o,D=C/q;P=Math.abs(Math.atan2(c*N,-I)/3),a=2*Math.sqrt(-z),_=Math.cos(P),i=a*_,L=a*(-_/2-R*Math.sin(P));var B=-c,U=2*s>i+L?i+s:L+s,F=B/U,G=q*U,k=-C*U-q*B,W=C*B,V=(s*k-u*W)/(-u*k+s*G);return V>=D?F>=D?F>=V?[D,V,F]:[D,F,V]:[F,D,V]:F>=D?[V,D,F]:F>=V?[V,F,D]:[F,V,D]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var d=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var m=n.computeRealRoots(1,s,l);if(2===m.length){var y,p=m[0],v=m[1];if(p>=0&&v>=0){var g=Math.sqrt(p),w=Math.sqrt(v);return[d-w,d-g,d+g,d+w]}if(p>=0&&0>v)return y=Math.sqrt(p),[d-y,d+y];if(0>p&&v>=0)return y=Math.sqrt(v),[d-y,d+y]}return[]}if(h>0){var x=Math.sqrt(h),E=(s+h-c/x)/2,S=(s+h+c/x)/2,M=n.computeRealRoots(1,x,E),b=n.computeRealRoots(1,-x,S);return 0!==M.length?(M[0]+=d,M[1]+=d,0!==b.length?(b[0]+=d,b[1]+=d,M[1]<=b[0]?[M[0],M[1],b[0],b[1]]:b[1]<=M[0]?[b[0],b[1],M[0],M[1]]:M[0]>=b[0]&&M[1]<=b[1]?[b[0],M[0],M[1],b[1]]:b[0]>=M[0]&&b[1]<=M[1]?[M[0],b[0],b[1],M[1]]:M[0]>b[0]&&M[0]<b[1]?[b[0],M[0],b[1],M[1]]:[M[0],b[0],M[1],b[1]]):M):0!==b.length?(b[0]+=d,b[1]+=d,b):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,d=c*o-i*a*t+u,h=e.computeRealRoots(1,l,f,d);if(h.length>0){var m,y,p=h[0],v=a-p,g=v*v,w=t/2,x=v/2,E=g-4*o,S=g+4*Math.abs(o),M=c-4*p,b=c+4*Math.abs(p);if(0>p||M*S>E*b){var T=Math.sqrt(M);m=T/2,y=0===T?0:(t*x-i)/T}else{var A=Math.sqrt(E);m=0===A?0:(t*x-i)/A,y=A/2}var O,z;0===w&&0===m?(O=0,z=0):r.sign(w)===r.sign(m)?(O=w+m,z=p/O):(z=w-m,O=p/z);var I,N;0===x&&0===y?(I=0,N=0):r.sign(x)===r.sign(y)?(I=x+y,N=o/I):(N=x-y,I=o/N);var R=n.computeRealRoots(1,O,I),P=n.computeRealRoots(1,z,N);if(0!==R.length)return 0!==P.length?R[1]<=P[0]?[R[0],R[1],P[0],P[1]]:P[1]<=R[0]?[P[0],P[1],R[0],R[1]]:R[0]>=P[0]&&R[1]<=P[1]?[P[0],R[0],R[1],P[1]]:P[0]>=R[0]&&P[1]<=R[1]?[R[0],P[0],P[1],R[1]]:R[0]>P[0]&&R[0]<P[1]?[P[0],R[0],P[1],R[1]]:[R[0],P[0],R[1],P[1]]:R;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,d=f*n,h=a*a,m=h*a,y=u*c*f-4*s*d-4*e*l*f+18*e*t*r*d-27*i*f*f+256*o*m+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+h*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return y},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,f=u/t,d=s/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>f?h+1:h,h+=0>d?h+1:h){case 0:return a(c,l,f,d);case 1:return i(c,l,f,d);case 2:return i(c,l,f,d);case 3:return a(c,l,f,d);case 4:return a(c,l,f,d);case 5:return i(c,l,f,d);case 6:return a(c,l,f,d);case 7:return a(c,l,f,d);case 8:return i(c,l,f,d);case 9:return a(c,l,f,d);case 10:return a(c,l,f,d);case 11:return i(c,l,f,d);case 12:return a(c,l,f,d);case 13:return a(c,l,f,d);case 14:return a(c,l,f,d);case 15:return a(c,l,f,d);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return n.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,n,a,o,u){u=r(u,!1);var s,c,l,f,d,h=t.origin,m=t.direction,y=e.subtract(a,n,p),E=e.subtract(o,n,v),S=e.cross(m,E,g),M=e.dot(y,S);if(u){if(M<i.EPSILON6)return void 0;if(s=e.subtract(h,n,w),l=e.dot(s,S),0>l||l>M)return void 0;if(c=e.cross(s,y,x),f=e.dot(m,c),0>f||l+f>M)return void 0;d=e.dot(E,c)/M}else{if(Math.abs(M)<i.EPSILON6)return void 0;var b=1/M;if(s=e.subtract(h,n,w),l=e.dot(s,S)*b,0>l||l>1)return void 0;if(c=e.cross(s,y,x),f=e.dot(m,c)*b,0>f||l+f>1)return void 0;d=e.dot(E,c)*b}return d}function f(e,t,r,n){var a=t*t-4*e*r;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function d(t,r,a){n(a)||(a={});var i=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,g),l=e.dot(o,o),d=2*e.dot(o,c),h=e.magnitudeSquared(c)-s,m=f(l,d,h,S);return n(m)?(a.start=m.root0,a.stop=m.root1,a):void 0}function h(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function m(t,r,n,a,c){var l,f=a*a,d=c*c,m=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*d,y=c*(a*h(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+r.y),p=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*d+a*r.x+n,v=d*h(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),g=c*(a*h(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),w=[];if(0===g&&0===v){if(l=u.computeRealRoots(m,y,p),0===l.length)return w;var x=l[0],E=Math.sqrt(Math.max(1-x*x,0));if(w.push(new e(a,c*x,c*-E)),w.push(new e(a,c*x,c*E)),2===l.length){var S=l[1],M=Math.sqrt(Math.max(1-S*S,0));w.push(new e(a,c*S,c*-M)),w.push(new e(a,c*S,c*M))}return w}var b=g*g,T=v*v,A=m*m,O=g*v,z=A+T,I=2*(y*m+O),N=2*p*m+y*y-T+b,R=2*(p*y-O),P=p*p-b;if(0===z&&0===I&&0===N&&0===R)return w;l=s.computeRealRoots(z,I,N,R,P);var _=l.length;if(0===_)return w;for(var L=0;_>L;++L){var C,q=l[L],D=q*q,B=Math.max(1-D,0),U=Math.sqrt(B);C=i.sign(m)===i.sign(p)?h(m*D+p,y*q,i.EPSILON12):i.sign(p)===i.sign(y*q)?h(m*D,y*q+p,i.EPSILON12):h(m*D+y*q,p,i.EPSILON12);var F=h(v*q,g,i.EPSILON15),G=C*F;0>G?w.push(new e(a,c*q,c*U)):G>0?w.push(new e(a,c*q,c*-U)):0!==U?(w.push(new e(a,c*q,c*-U)),w.push(new e(a,c*q,c*U)),++L):w.push(new e(a,c*q,c*U))}return w}var y={};y.rayPlane=function(t,r,a){n(a)||(a=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var p=new e,v=new e,g=new e,w=new e,x=new e;y.rayTriangle=function(t,r,a,i,o,u){var s=l(t,r,a,i,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var E=new c;y.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=E;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var S={root0:0,root1:0};y.raySphere=function(e,t,r){return r=d(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var M=new c;y.lineSegmentSphere=function(t,r,a,i){var o=M;e.clone(t,o.origin);var u=e.subtract(r,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=d(o,a,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var b=new e,T=new e;y.rayEllipsoid=function(t,r){var n,a,i,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,b),l=e.multiplyComponents(s,t.direction,T),f=e.magnitudeSquared(c),d=e.dot(c,l);if(f>1){if(d>=0)return void 0;var h=d*d;if(n=f-1,a=e.magnitudeSquared(l),i=a*n,i>h)return void 0;if(h>i){o=d*d-i,u=-d+Math.sqrt(o);var m=u/a,y=n/u;return y>m?{start:m,stop:y}:{start:y,stop:m}}var p=Math.sqrt(n/a);return{start:p,stop:p}}return 1>f?(n=f-1,a=e.magnitudeSquared(l),i=a*n,o=d*d-i,u=-d+Math.sqrt(o),{start:0,stop:u/a}):0>d?(a=e.magnitudeSquared(l),{start:0,stop:-d/a}):void 0};var A=new e,O=new e,z=new e,I=new e,N=new e,R=new o,P=new o,_=new o,L=new o,C=new o,q=new o,D=new o,B=new e,U=new e,F=new t;y.grazingAltitudeLocation=function(t,r){var a=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(a,A);if(e.dot(u,s)>=0)return a;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,A),f=e.normalize(l,l),d=e.mostOrthogonalAxis(l,I),h=e.normalize(e.cross(d,f,O),O),y=e.normalize(e.cross(f,h,z),z),p=R;p[0]=f.x,p[1]=f.y,p[2]=f.z,p[3]=h.x,p[4]=h.y,p[5]=h.z,p[6]=y.x,p[7]=y.y,p[8]=y.z;var v=o.transpose(p,P),g=o.fromScale(r.radii,_),w=o.fromScale(r.oneOverRadii,L),x=C;x[0]=0,x[1]=-u.z,x[2]=u.y,x[3]=u.z,x[4]=0,x[5]=-u.x,x[6]=-u.y,x[7]=u.x,x[8]=0;var E,S,M=o.multiply(o.multiply(v,w,q),x,q),b=o.multiply(o.multiply(M,g,D),p,D),T=o.multiplyByVector(M,a,N),G=m(b,e.negate(T,A),0,0,1),k=G.length;if(k>0){for(var W=e.clone(e.ZERO,U),V=Number.NEGATIVE_INFINITY,Y=0;k>Y;++Y){E=o.multiplyByVector(g,o.multiplyByVector(p,G[Y],B),B);var j=e.normalize(e.subtract(E,a,I),I),H=e.dot(j,u);H>V&&(V=H,W=e.clone(E,W))}var Z=r.cartesianToCartographic(W,F);return V=i.clamp(V,0,1),S=e.magnitude(e.subtract(W,a,I))*Math.sqrt(1-V*V),S=c?-S:S,Z.height=S,r.cartographicToCartesian(Z,new e)}return void 0};var G=new e;return y.lineSegmentPlane=function(t,r,a,o){n(o)||(o=new e);var u=e.subtract(r,t,G),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),f=-(a.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(u,f,o),e.add(t,o,o),o)},y.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,d;if((1===l||2===l)&&(f=new e,d=new e),1===l){if(u)return y.lineSegmentPlane(t,r,a,f),y.lineSegmentPlane(t,n,a,d),{positions:[t,r,n,f,d],indices:[0,3,4,1,2,4,1,4,3]};if(s)return y.lineSegmentPlane(r,n,a,f),y.lineSegmentPlane(r,t,a,d),{positions:[t,r,n,f,d],indices:[1,3,4,2,0,4,2,4,3]};if(c)return y.lineSegmentPlane(n,t,a,f),y.lineSegmentPlane(n,r,a,d),{positions:[t,r,n,f,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return y.lineSegmentPlane(r,t,a,f),y.lineSegmentPlane(n,t,a,d),{positions:[t,r,n,f,d],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return y.lineSegmentPlane(n,r,a,f),y.lineSegmentPlane(t,r,a,d),{positions:[t,r,n,f,d],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return y.lineSegmentPlane(t,n,a,f),y.lineSegmentPlane(r,n,a,d),{positions:[t,r,n,f,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},y}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(t,r){this.normal=e.clone(t),this.distance=r};return r.fromPointNormal=function(n,a,i){var o=-e.dot(a,n);return t(i)?(e.clone(a,i.normal),i.distance=o,i):new r(a,o)},r.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},r}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};return r.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];o>u;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var f=i+1,d=0;o>d;++d)f-c[n[d]]>i&&(c[n[d]]=f,++f);return(f-i+1)/(o/3)},r.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var d=r[f];a[d].numLiveTriangles&&(s=0,i-a[d].timeStamp+2*a[d].numLiveTriangles<=t&&(s=i-a[d].timeStamp),(s>l||-1===l)&&(l=s,c=d)),++f}return-1===c?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,f=0,d=o[f],h=c;if(t(u))l=u+1;else{for(;h>f;)d>l&&(l=d),++f,d=o[f];if(-1===l)return 0;++l}for(var m=[],y=0;l>y;y++)m[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var p=0;h>f;)m[o[f]].vertexTriangles.push(p),++m[o[f]].numLiveTriangles,m[o[f+1]].vertexTriangles.push(p),++m[o[f+1]].numLiveTriangles,m[o[f+2]].vertexTriangles.push(p),++m[o[f+2]].numLiveTriangles,++p,f+=3;var v=0,g=s+1;i=1;var w,x,E=[],S=[],M=0,b=[],T=c/3,A=[];for(y=0;T>y;y++)A[y]=!1;for(var O,z;-1!==v;){E=[],x=m[v],z=x.vertexTriangles.length;for(var I=0;z>I;++I)if(p=x.vertexTriangles[I],!A[p]){A[p]=!0,f=p+p+p;for(var N=0;3>N;++N)O=o[f],E.push(O),S.push(O),b[M]=O,++M,w=m[O],--w.numLiveTriangles,g-w.timeStamp>s&&(w.timeStamp=g,++g),++f}v=a(o,s,E,m,g,S,l)}return b},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,m,y,p,v,g,w,x,E,S,M,b,T){"use strict";function A(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function O(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),a=0,i=0;t>i;i+=3,a+=6)A(n,a,e[i],e[i+1],e[i+2]);return n}function z(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);A(n,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)A(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function I(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),a=e[0],i=0,o=1;t>o;++o,i+=6)A(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function N(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new m({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function R(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,it),S.multiplyByPoint(e,it,it),a.pack(it,r,i)}function _(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,it),E.multiplyByVector(e,it,it),it=a.normalize(it,it),a.pack(it,r,i)}function L(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,f=1;n>f;++f){var d=e[f][t].attributes[r];if(!c(d)||o.componentDatatype!==d.componentDatatype||o.componentsPerAttribute!==d.componentsPerAttribute||o.normalize!==d.normalize){l=!1;break}s+=d.values.length}l&&(a[r]=new m({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function C(e,t){var n,i,o,u,s=e.length;e[0].modelMatrix;var l,f,d,m=c(e[0][t].indices),y=e[0][t].primitiveType,p=L(e,t);for(n in p)if(p.hasOwnProperty(n))for(l=p[n].values,u=0,i=0;s>i;++i)for(f=e[i][t].attributes[n].values,d=f.length,o=0;d>o;++o)l[u++]=f[o];var g;if(m){var w=0;for(i=0;s>i;++i)w+=e[i][t].indices.length;var x=h.computeNumberOfVertices(new h({attributes:p,primitiveType:b.POINTS})),E=v.createTypedArray(x,w),S=0,M=0;for(i=0;s>i;++i){var T=e[i][t].indices,A=T.length;for(u=0;A>u;++u)E[S++]=M+T[u];M+=h.computeNumberOfVertices(e[i][t])}g=E}var O,z=new a,I=0;for(i=0;s>i;++i){if(O=e[i][t].boundingSphere,!c(O)){z=void 0;break}a.add(O.center,z,z)}if(c(z))for(a.divideByScalar(z,s,z),i=0;s>i;++i){O=e[i][t].boundingSphere;var N=a.magnitude(a.subtract(O.center,z,st))+O.radius;N>I&&(I=N)}return new h({attributes:p,indices:g,primitiveType:y,boundingSphere:c(z)?new r(z,I):void 0})}function q(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function D(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;t>a;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=b.TRIANGLES,e}function B(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;t-1>a;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,t>a+2&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=b.TRIANGLES,e}function U(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function F(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=b.LINES,e}function G(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=b.LINES,e}function k(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return D(e);case b.TRIANGLE_STRIP:return B(e);case b.TRIANGLES:return q(e);case b.LINE_STRIP:return F(e);case b.LINE_LOOP:return G(e);case b.LINES:return U(e)}return e}function W(e,t){Math.abs(e.y)<x.EPSILON6&&(e.y=t?-x.EPSILON6:x.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return W(e,e.y<0),W(t,t.y<0),W(r,r.y<0),void 0;var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?x.sign(e.y):x.sign(r.y):i>o?x.sign(t.y):x.sign(r.y);var u=0>n;W(e,u),W(t,u),W(r,u)}function Y(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,xt),e.y/(e.y-t.y),xt),r),a.clone(r,n),W(r,!0),W(n,!1)}function j(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;V(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Tt.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(Y(e,t,Et,Mt),Y(e,r,St,bt),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(Y(t,r,Et,Mt),Y(t,e,St,bt),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(Y(r,e,Et,Mt),Y(r,t,St,bt),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(Y(r,e,Et,Mt),Y(r,t,St,bt),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(Y(t,r,Et,Mt),Y(t,e,St,bt),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(Y(e,t,Et,Mt),Y(e,r,St,bt),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Tt.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Et,s[4]=St,s[5]=Mt,s[6]=bt,s.length=7),Tt}function H(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=h.computeNumberOfVertices(e);return e.indices=v.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function Z(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new m({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function X(e,t,r){var n=c(e.geometry.boundingSphere);t=H(t,n),r=H(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Q(e,r,i,o,u,s,l,f,d,h,m){if(c(s)||c(l)||c(f)||c(d)){var y=a.fromArray(u,3*e,At),p=a.fromArray(u,3*r,Ot),v=a.fromArray(u,3*i,zt),g=t(o,y,p,v,It);if(c(s)){var w=a.fromArray(s,3*e,At),x=a.fromArray(s,3*r,Ot),E=a.fromArray(s,3*i,zt);a.multiplyByScalar(w,g.x,w),a.multiplyByScalar(x,g.y,x),a.multiplyByScalar(E,g.z,E);var S=a.add(w,x,w);a.add(S,E,S),a.normalize(S,S),a.pack(S,h.normal.values,3*m)}if(c(l)){var M=a.fromArray(l,3*e,At),b=a.fromArray(l,3*r,Ot),T=a.fromArray(l,3*i,zt);
a.multiplyByScalar(M,g.x,M),a.multiplyByScalar(b,g.y,b),a.multiplyByScalar(T,g.z,T);var A=a.add(M,b,M);a.add(A,T,A),a.normalize(A,A),a.pack(A,h.binormal.values,3*m)}if(c(f)){var O=a.fromArray(f,3*e,At),z=a.fromArray(f,3*r,Ot),I=a.fromArray(f,3*i,zt);a.multiplyByScalar(O,g.x,O),a.multiplyByScalar(z,g.y,z),a.multiplyByScalar(I,g.z,I);var N=a.add(O,z,O);a.add(N,I,N),a.normalize(N,N),a.pack(N,h.tangent.values,3*m)}if(c(d)){var R=n.fromArray(d,2*e,Nt),P=n.fromArray(d,2*r,Rt),_=n.fromArray(d,2*i,Pt);n.multiplyByScalar(R,g.x,R),n.multiplyByScalar(P,g.y,P),n.multiplyByScalar(_,g.z,_);var L=n.add(R,P,R);n.add(L,_,L),n.pack(L,h.st.values,2*m)}}}function K(e,t,r,n,a,i){var o=e.position.values.length/3;if(-1!==a){var u=n[a],s=r[u];return-1===s?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function J(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,d=c(s.binormal)?s.binormal.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,m=c(s.st)?s.st.values:void 0,y=u.indices,p=Z(u),v=Z(u),g=[];g.length=l.length/3;var w=[];for(w.length=l.length/3,o=0;o<g.length;++o)g[o]=-1,w[o]=-1;var x=y.length;for(o=0;x>o;o+=3){var E=y[o],S=y[o+1],M=y[o+2],b=a.fromArray(l,3*E),T=a.fromArray(l,3*S),A=a.fromArray(l,3*M),O=j(b,T,A);if(c(O)&&O.positions.length>3)for(var z=O.positions,I=O.indices,N=I.length,R=0;N>R;++R){var P=I[R],_=z[P];_.y<0?(t=v.attributes,r=v.indices,n=g):(t=p.attributes,r=p.indices,n=w),i=K(t,r,n,y,3>P?o+P:-1,_),Q(E,S,M,_,l,f,d,h,m,t,i)}else c(O)&&(b=O.positions[0],T=O.positions[1],A=O.positions[2]),b.y<0?(t=v.attributes,r=v.indices,n=g):(t=p.attributes,r=p.indices,n=w),i=K(t,r,n,y,o,b),Q(E,S,M,b,l,f,d,h,m,t,i),i=K(t,r,n,y,o+1,T),Q(E,S,M,T,l,f,d,h,m,t,i),i=K(t,r,n,y,o+2,A),Q(E,S,M,A,l,f,d,h,m,t,i)}X(e,v,p)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=Z(r),s=Z(r),l=o.length,f=[];f.length=i.length/3;var d=[];for(d.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,d[t]=-1;for(t=0;l>t;t+=2){var h=o[t],m=o[t+1],y=a.fromArray(i,3*h,At),p=a.fromArray(i,3*m,Ot);Math.abs(y.y)<x.EPSILON6&&(y.y=y.y<0?-x.EPSILON6:x.EPSILON6),Math.abs(p.y)<x.EPSILON6&&(p.y=p.y<0?-x.EPSILON6:x.EPSILON6);var v=u.attributes,g=u.indices,E=d,S=s.attributes,M=s.indices,b=f,T=w.lineSegmentPlane(y,p,_t,zt);if(c(T)){var A=a.multiplyByScalar(a.UNIT_Y,5*x.EPSILON9,Lt);y.y<0&&(a.negate(A,A),v=s.attributes,g=s.indices,E=f,S=u.attributes,M=u.indices,b=d);var O=a.add(T,A,Ct);K(v,g,E,o,t,y),K(v,g,E,o,-1,O),a.negate(A,A),a.add(T,A,O),K(S,M,b,o,-1,O),K(S,M,b,o,t+1,p)}else{var z,I,N;y.y<0?(z=s.attributes,I=s.indices,N=f):(z=u.attributes,I=u.indices,N=d),K(z,I,N,o,t,y),K(z,I,N,o,t+1,p)}}X(e,s,u)}function et(e){var t=e.geometry,r=t.attributes,o=r.position.values,u=r.prevPosition.values,s=r.nextPosition.values,l=r.expandAndWidth.values;t.indices;var f,d,h,m=c(r.st)?r.st.values:void 0,y=c(r.color)?r.color.values:void 0,p=Z(t),v=Z(t),g=o.length/3;for(f=0;g>f;f+=4){var E=f,S=f+1,M=f+2,b=f+3,T=a.fromArray(o,3*E,Bt),A=a.fromArray(o,3*S,Ut),O=a.fromArray(o,3*M,Ft),z=a.fromArray(o,3*b,Gt);Math.abs(T.y)<x.EPSILON6&&(T.y=x.EPSILON6*(O.y<0?-1:1),A.y=T.y),Math.abs(O.y)<x.EPSILON6&&(O.y=x.EPSILON6*(T.y<0?-1:1),z.y=O.y);var I=p.attributes,N=p.indices,R=v.attributes,P=v.indices,_=w.lineSegmentPlane(T,O,_t,kt);if(c(_)){var L=a.multiplyByScalar(a.UNIT_Y,5*x.EPSILON9,Wt);T.y<0&&(a.negate(L,L),I=v.attributes,N=v.indices,R=p.attributes,P=p.indices);var C=a.add(_,L,Vt);for(I.position.values.push(T.x,T.y,T.z,A.x,A.y,A.z),I.position.values.push(C.x,C.y,C.z),I.position.values.push(C.x,C.y,C.z),a.negate(L,L),a.add(_,L,C),R.position.values.push(C.x,C.y,C.z),R.position.values.push(C.x,C.y,C.z),R.position.values.push(O.x,O.y,O.z,z.x,z.y,z.z),d=3*E;3*E+6>d;++d)I.prevPosition.values.push(u[d]);for(I.prevPosition.values.push(T.x,T.y,T.z,T.x,T.y,T.z),R.prevPosition.values.push(T.x,T.y,T.z,T.x,T.y,T.z),d=3*M;3*M+6>d;++d)R.prevPosition.values.push(u[d]);for(d=3*E;3*E+6>d;++d)I.nextPosition.values.push(s[d]);for(I.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),R.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),d=3*M;3*M+6>d;++d)R.nextPosition.values.push(s[d]);var q=n.fromArray(l,2*E,qt),D=Math.abs(q.y);I.expandAndWidth.values.push(-1,D,1,D),I.expandAndWidth.values.push(-1,-D,1,-D),R.expandAndWidth.values.push(-1,D,1,D),R.expandAndWidth.values.push(-1,-D,1,-D);var B=a.magnitudeSquared(a.subtract(_,T,Gt));if(B/=a.magnitudeSquared(a.subtract(O,T,Gt)),c(y)){var U=i.fromArray(y,4*E,Yt),F=i.fromArray(y,4*M,Yt),G=x.lerp(U.x,F.x,B),k=x.lerp(U.y,F.y,B),W=x.lerp(U.z,F.z,B),V=x.lerp(U.w,F.w,B);for(d=4*E;4*E+8>d;++d)I.color.values.push(y[d]);for(I.color.values.push(G,k,W,V),I.color.values.push(G,k,W,V),R.color.values.push(G,k,W,V),R.color.values.push(G,k,W,V),d=4*M;4*M+8>d;++d)R.color.values.push(y[d])}if(c(m)){var Y=n.fromArray(m,2*E,qt),j=n.fromArray(m,2*(f+3),Dt),H=x.lerp(Y.x,j.x,B);for(d=2*E;2*E+4>d;++d)I.st.values.push(m[d]);for(I.st.values.push(H,Y.y),I.st.values.push(H,j.y),R.st.values.push(H,Y.y),R.st.values.push(H,j.y),d=2*M;2*M+4>d;++d)R.st.values.push(m[d])}h=I.position.values.length/3-4,N.push(h,h+2,h+1),N.push(h+1,h+2,h+3),h=R.position.values.length/3-4,P.push(h,h+2,h+1),P.push(h+1,h+2,h+3)}else{var Q,K;for(T.y<0?(Q=v.attributes,K=v.indices):(Q=p.attributes,K=p.indices),Q.position.values.push(T.x,T.y,T.z),Q.position.values.push(A.x,A.y,A.z),Q.position.values.push(O.x,O.y,O.z),Q.position.values.push(z.x,z.y,z.z),d=3*f;3*f+12>d;++d)Q.prevPosition.values.push(u[d]),Q.nextPosition.values.push(s[d]);for(d=2*f;2*f+8>d;++d)Q.expandAndWidth.values.push(l[d]),c(m)&&Q.st.values.push(m[d]);if(c(y))for(d=4*f;4*f+16>d;++d)Q.color.values.push(y[d]);h=Q.position.values.length/3-4,K.push(h,h+2,h+1),K.push(h+1,h+2,h+3)}}X(e,v,p)}var tt={};tt.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case b.TRIANGLES:e.indices=O(t);break;case b.TRIANGLE_STRIP:e.indices=z(t);break;case b.TRIANGLE_FAN:e.indices=I(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},tt.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),f=0,d=0;o>d;d+=3)l[f++]=a[d],l[f++]=a[d+1],l[f++]=a[d+2],l[f++]=a[d]+i[d]*n,l[f++]=a[d+1]+i[d+1]*n,l[f++]=a[d+2]+i[d+2]*n;var y,p=e.boundingSphere;return c(p)&&(y=new r(p.center,p.radius+n)),new h({attributes:{position:new m({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:b.LINES,boundingSphere:y})},tt.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},tt.reorderForPreVertexCache=function(e){var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;t>a;a++)n[a]=-1;for(var i,o=r,s=o.length,l=v.createTypedArray(t,s),f=0,d=0,m=0;s>f;)i=n[o[f]],-1!==i?l[d]=i:(i=o[f],n[i]=m,l[d]=m,++m),++f,++d;e.indices=l;var y=e.attributes;for(var p in y)if(y.hasOwnProperty(p)&&c(y[p])&&c(y[p].values)){for(var g=y[p],w=g.values,x=0,E=g.componentsPerAttribute,S=u.createTypedArray(g.componentDatatype,m*E);t>x;){var M=n[x];if(-1!==M)for(a=0;E>a;a++)S[E*M+a]=w[E*x+a];++x}g.values=S}}return e},tt.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===b.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;n>i;i++)r[i]>a&&(a=r[i]);e.indices=T.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},tt.fitToUnsignedShortIndices=function(e){var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>x.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=N(e.attributes),s=e.indices,l=s.length;e.primitiveType===b.TRIANGLES?n=3:e.primitiveType===b.LINES?n=2:e.primitiveType===b.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var d=0;n>d;++d){var m=s[f+d],y=a[m];c(y)||(y=o++,a[m]=y,R(u,e.attributes,m)),i.push(y)}o+n>x.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=N(e.attributes))}0!==i.length&&t.push(new h({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var rt=new a,nt=new o;tt.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new d;for(var s=i.ellipsoid,f=o.values,h=new Float64Array(f.length),y=0,p=0;p<f.length;p+=3){var v=a.fromArray(f,p,rt),g=s.cartesianToCartographic(v,nt);if(!c(g))throw new l("Could not project point ("+v.x+", "+v.y+", "+v.z+") to 2D.");var w=i.project(g,rt);h[y++]=w.x,h[y++]=w.y,h[y++]=w.z}return e.attributes[r]=o,e.attributes[n]=new m({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var at={high:0,low:0};tt.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)f.encode(i[l],at),s[l]=at.high,c[l]=at.low;var d=a.componentsPerAttribute;return e.attributes[r]=new m({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:s}),e.attributes[n]=new m({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:c}),delete e.attributes[t],e};var it=new a,ot=new S,ut=new E;tt.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(S.equals(t,S.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(S.inverse(t,ot),S.transpose(ot,ot),S.getRotation(ot,ut),_(ut,n.normal),_(ut,n.binormal),_(ut,n.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=S.clone(S.IDENTITY),e};var st=new a;tt.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;n>a;++a){var i=e[a];c(i.geometry)?t.push(i):r.push(i)}var o=[];return t.length>0&&o.push(C(t,"geometry")),r.length>0&&(o.push(C(r,"westHemisphereGeometry")),o.push(C(r,"eastHemisphereGeometry"))),o};var ct=new a,lt=new a,ft=new a,dt=new a;tt.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var d=0;for(f=0;o>f;f+=3){var h=t[f],y=t[f+1],p=t[f+2],v=3*h,g=3*y,w=3*p;lt.x=n[v],lt.y=n[v+1],lt.z=n[v+2],ft.x=n[g],ft.y=n[g+1],ft.z=n[g+2],dt.x=n[w],dt.y=n[w+1],dt.z=n[w+2],s[h].count++,s[y].count++,s[p].count++,a.subtract(ft,lt,ft),a.subtract(dt,lt,dt),c[d]=a.cross(ft,dt,new a),d++}var x=0;for(f=0;i>f;f++)s[f].indexOffset+=x,x+=s[f].count;d=0;var E;for(f=0;o>f;f+=3){E=s[t[f]];var S=E.indexOffset+E.currentCount;l[S]=d,E.currentCount++,E=s[t[f+1]],S=E.indexOffset+E.currentCount,l[S]=d,E.currentCount++,E=s[t[f+2]],S=E.indexOffset+E.currentCount,l[S]=d,E.currentCount++,d++}var M=new Float32Array(3*i);for(f=0;i>f;f++){var b=3*f;if(E=s[f],E.count>0){for(a.clone(a.ZERO,ct),d=0;d<E.count;d++)a.add(ct,c[l[E.indexOffset+d]],ct);a.normalize(ct,ct),M[b]=ct.x,M[b+1]=ct.y,M[b+2]=ct.z}else M[b]=0,M[b+1]=0,M[b+2]=1}return e.attributes.normal=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:M}),e};var ht=new a,mt=new a,yt=new a;tt.computeBinormalAndTangent=function(e){e.attributes;for(var t=e.indices,r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,d,h;for(l=0;s>l;l+=3){var y=t[l],p=t[l+1],v=t[l+2];f=3*y,d=3*p,h=3*v;var g=2*y,w=2*p,x=2*v,E=r[f],S=r[f+1],M=r[f+2],b=i[g],T=i[g+1],A=i[w+1]-T,O=i[x+1]-T,z=1/((i[w]-b)*O-(i[x]-b)*A),I=(O*(r[d]-E)-A*(r[h]-E))*z,N=(O*(r[d+1]-S)-A*(r[h+1]-S))*z,R=(O*(r[d+2]-M)-A*(r[h+2]-M))*z;c[f]+=I,c[f+1]+=N,c[f+2]+=R,c[d]+=I,c[d+1]+=N,c[d+2]+=R,c[h]+=I,c[h+1]+=N,c[h+2]+=R}var P=new Float32Array(3*o),_=new Float32Array(3*o);for(l=0;o>l;l++){f=3*l,d=f+1,h=f+2;var L=a.fromArray(n,f,ht),C=a.fromArray(c,f,yt),q=a.dot(L,C);a.multiplyByScalar(L,q,mt),a.normalize(a.subtract(C,mt,C),C),_[f]=C.x,_[d]=C.y,_[h]=C.z,a.normalize(a.cross(L,C,C),C),P[f]=C.x,P[d]=C.y,P[h]=C.z}return e.attributes.tangent=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:_}),e.attributes.binormal=new m({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e};var pt=new n,vt=new a,gt=new a,wt=new a;tt.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var o,s,l,f,d=t.attributes.tangent,h=t.attributes.binormal;c(r)&&(o=r.values),c(i)&&(s=i.values),c(d)&&(l=d.values),h&&(f=h.values);var y=c(o)?o.length:s.length,p=c(o)?3:2,v=y/p,g=v,w=c(s)&&c(o)?2:1;w+=c(l)||c(f)?1:0,g*=w;for(var x=new Float32Array(g),E=0,S=0;v>S;++S){c(s)&&(n.fromArray(s,2*S,pt),x[E++]=e.compressTextureCoordinates(pt));var M=3*S;c(o)&&c(l)&&c(f)?(a.fromArray(o,M,vt),a.fromArray(l,M,gt),a.fromArray(f,M,wt),e.octPack(vt,gt,wt,pt),x[E++]=pt.x,x[E++]=pt.y):(c(o)&&(a.fromArray(o,M,vt),x[E++]=e.octEncodeFloat(vt)),c(l)&&(a.fromArray(l,M,vt),x[E++]=e.octEncodeFloat(vt)),c(f)&&(a.fromArray(f,M,vt),x[E++]=e.octEncodeFloat(vt)))}return t.attributes.compressedAttributes=new m({componentDatatype:u.FLOAT,componentsPerAttribute:w,values:x}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var xt=new a,Et=new a,St=new a,Mt=new a,bt=new a,Tt={positions:new Array(7),indices:new Array(9)},At=new a,Ot=new a,zt=new a,It=new a,Nt=new n,Rt=new n,Pt=new n,_t=M.fromPointNormal(a.ZERO,a.UNIT_Y),Lt=new a,Ct=new a,qt=new n,Dt=new n,Bt=new a,Ut=new a,Ft=new a,Gt=new a,kt=new a,Wt=new a,Vt=new a,Yt=new i;return new i,tt.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersect(n,i.UNIT_Y)!==g.INTERSECTING)return e}if(t.geometryType!==p.NONE)switch(t.geometryType){case p.POLYLINES:et(e);break;case p.TRIANGLES:J(e);break;case p.LINES:$(e)}else k(t),t.primitiveType===b.TRIANGLES?J(e):t.primitiveType===b.LINES&&$(e);return e},tt}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.binormal?1:0,r[n++]=t.tangent?1:0,r[n++]=t.color?1:0},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.binormal=1===r[n++],i.tangent=1===r[n++],i.color=1===r[n++],i},a.clone=function(e,r){return t(e)?(t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},a}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,n,a,i,o,u,s,c,l,f,d,h,m,y,p,v,g,w,x,E){"use strict";function S(e,n,i){var o=n.vertexFormat,u=n.center,c=n.semiMajorAxis,f=n.semiMinorAxis,m=n.ellipsoid,y=n.stRotation,p=i?2*(e.length/3):e.length/3,v=o.st?new Float32Array(2*p):void 0,w=o.normal?new Float32Array(3*p):void 0,E=o.tangent?new Float32Array(3*p):void 0,S=o.binormal?new Float32Array(3*p):void 0,M=0,b=C,T=q,A=D,O=new l(m),R=O.project(m.cartesianToCartographic(u,B),U),k=m.scaleToGeodeticSurface(u,z);m.geodeticSurfaceNormal(k,k);for(var W=x.fromAxisAngle(k,y,L),V=g.fromQuaternion(W,_),Y=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,F),j=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),H=e.length,Z=i?H:0,X=2*(Z/3),Q=0;H>Q;Q+=3){var K=Q+1,J=Q+2,$=r.fromArray(e,Q,z);if(o.st){var et=g.multiplyByVector(V,$,I),tt=O.project(m.cartesianToCartographic(et,B),N);r.subtract(tt,R,tt),P.x=(tt.x+c)/(2*c),P.y=(tt.y+f)/(2*f),Y.x=Math.min(P.x,Y.x),Y.y=Math.min(P.y,Y.y),j.x=Math.max(P.x,j.x),j.y=Math.max(P.y,j.y),i&&(v[M+X]=P.x,v[M+1+X]=P.y),v[M++]=P.x,v[M++]=P.y}b=m.geodeticSurfaceNormal($,b),(o.normal||o.tangent||o.binormal)&&((o.tangent||o.binormal)&&(T=r.cross(r.UNIT_Z,b,T),g.multiplyByVector(V,T,T)),o.normal&&(w[Q]=b.x,w[K]=b.y,w[J]=b.z,i&&(w[Q+Z]=-b.x,w[K+Z]=-b.y,w[J+Z]=-b.z)),o.tangent&&(E[Q]=T.x,E[K]=T.y,E[J]=T.z,i&&(E[Q+Z]=-T.x,E[K+Z]=-T.y,E[J+Z]=-T.z)),o.binormal&&(A=r.cross(b,T,A),S[Q]=A.x,S[K]=A.y,S[J]=A.z,i&&(S[Q+Z]=A.x,S[K+Z]=A.y,S[J+Z]=A.z)))}if(o.st){H=v.length;for(var rt=0;H>rt;rt+=2)v[rt]=(v[rt]-Y.x)/(j.x-Y.x),v[rt+1]=(v[rt+1]-Y.y)/(j.y-Y.y)}var nt=new h;if(o.position){var at=s.raisePositionsToHeight(e,n,i);nt.position=new d({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:at})}return o.st&&(nt.st=new d({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:v})),o.normal&&(nt.normal=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:w})),o.tangent&&(nt.tangent=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:E})),o.binormal&&(nt.binormal=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:S})),nt}function M(e){var t,r,n,a,i,o=new Array(2*e*(e+1)),u=0;for(a=1;e>a;++a){for(n=a*(a+1),t=(a-1)*a,o[u++]=n++,o[u++]=t,o[u++]=n,r=2*a,i=0;r-1>i;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=n++,o[u++]=t,o[u++]=n}for(r=2*e,++n,++t,a=0;r-1>a;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;for(++t,++n,a=e-1;a>0;--a){for(o[u++]=t++,o[u++]=t,o[u++]=n,r=2*a,i=0;r-1>i;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=t++,o[u++]=t++,o[u++]=n++}return o}function b(t){var n=t.center;k=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(n,k),t.height,k),k=r.add(n,k,k);var a=new e(k,t.semiMajorAxis),i=s.computeEllipsePositions(t,!0,!1),o=i.positions,u=i.numPts,c=S(o,t,!1),l=M(u);return l=p.createTypedArray(o.length/3,l),{boundingSphere:a,attributes:c,indices:l}}function T(e,n){var i=n.vertexFormat,o=n.center,u=n.semiMajorAxis,s=n.semiMinorAxis,c=n.ellipsoid,f=n.height,m=n.extrudedHeight,y=n.stRotation,p=2*(e.length/3),v=new Float64Array(3*p),w=i.st?new Float32Array(2*p):void 0,E=i.normal?new Float32Array(3*p):void 0,S=i.tangent?new Float32Array(3*p):void 0,M=i.binormal?new Float32Array(3*p):void 0,b=0,T=C,A=q,O=D,k=new l(c),W=k.project(c.cartesianToCartographic(o,B),U),V=c.scaleToGeodeticSurface(o,z);c.geodeticSurfaceNormal(V,V);for(var Y=x.fromAxisAngle(V,y,L),j=g.fromQuaternion(Y,_),H=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,F),Z=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),X=e.length,Q=2*(X/3),K=0;X>K;K+=3){var J,$=K+1,et=K+2,tt=r.fromArray(e,K,z);if(i.st){var rt=g.multiplyByVector(j,tt,I),nt=k.project(c.cartesianToCartographic(rt,B),N);r.subtract(nt,W,nt),P.x=(nt.x+u)/(2*u),P.y=(nt.y+s)/(2*s),H.x=Math.min(P.x,H.x),H.y=Math.min(P.y,H.y),Z.x=Math.max(P.x,Z.x),Z.y=Math.max(P.y,Z.y),w[b+Q]=P.x,w[b+1+Q]=P.y,w[b++]=P.x,w[b++]=P.y}tt=c.scaleToGeodeticSurface(tt,tt),J=r.clone(tt,I),T=c.geodeticSurfaceNormal(tt,T);var at=r.multiplyByScalar(T,f,R);if(tt=r.add(tt,at,tt),at=r.multiplyByScalar(T,m,at),J=r.add(J,at,J),i.position&&(v[K+X]=J.x,v[$+X]=J.y,v[et+X]=J.z,v[K]=tt.x,v[$]=tt.y,v[et]=tt.z),i.normal||i.tangent||i.binormal){O=r.clone(T,O);var it=r.fromArray(e,(K+3)%X,R);r.subtract(it,tt,it);var ot=r.subtract(J,tt,N);T=r.normalize(r.cross(ot,it,T),T),i.normal&&(E[K]=T.x,E[$]=T.y,E[et]=T.z,E[K+X]=T.x,E[$+X]=T.y,E[et+X]=T.z),i.tangent&&(A=r.normalize(r.cross(O,T,A),A),S[K]=A.x,S[$]=A.y,S[et]=A.z,S[K+X]=A.x,S[K+1+X]=A.y,S[K+2+X]=A.z),i.binormal&&(M[K]=O.x,M[$]=O.y,M[et]=O.z,M[K+X]=O.x,M[$+X]=O.y,M[et+X]=O.z)}}if(i.st){X=w.length;for(var ut=0;X>ut;ut+=2)w[ut]=(w[ut]-H.x)/(Z.x-H.x),w[ut+1]=(w[ut+1]-H.y)/(Z.y-H.y)}var st=new h;return i.position&&(st.position=new d({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:v})),i.st&&(st.st=new d({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:w})),i.normal&&(st.normal=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:E})),i.tangent&&(st.tangent=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:S})),i.binormal&&(st.binormal=new d({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:M})),st}function A(e){for(var t=e.length/3,r=p.createTypedArray(t,6*t),n=0,a=0;t>a;a++){var i=a,o=a+t,u=(i+1)%t,s=u+t;r[n++]=i,r[n++]=o,r[n++]=u,r[n++]=u,r[n++]=o,r[n++]=s}return r}function O(t){var n=t.center,a=t.ellipsoid,i=t.semiMajorAxis,o=r.multiplyByScalar(a.geodeticSurfaceNormal(n,z),t.height,z);W.center=r.add(n,o,W.center),W.radius=i,o=r.multiplyByScalar(a.geodeticSurfaceNormal(n,o),t.extrudedHeight,o),V.center=r.add(n,o,V.center),V.radius=i;var u=s.computeEllipsePositions(t,!0,!0),c=u.positions,l=u.numPts,d=u.outerPositions,h=e.union(W,V),v=S(c,t,!0),g=M(l),x=g.length;g.length=2*x;for(var E=c.length/3,b=0;x>b;b+=3)g[b+x]=g[b+2]+E,g[b+1+x]=g[b+1]+E,g[b+2+x]=g[b]+E;var O=p.createTypedArray(2*E/3,g),I=new f({attributes:v,indices:O,primitiveType:w.TRIANGLES}),N=T(d,t);g=A(d);var R=p.createTypedArray(2*d.length/3,g),P=new f({attributes:N,indices:R,primitiveType:w.TRIANGLES}),_=y.combineInstances([new m({geometry:I}),new m({geometry:P})]);return{boundingSphere:h,attributes:_[0].attributes,indices:_[0].indices}}var z=new r,I=new r,N=new r,R=new r,P=new t,_=new g,L=new x,C=new r,q=new r,D=new r,B=new n,U=new r,F=new t,G=new t,k=new r,W=new e,V=new e,Y=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.center,n=i(e.ellipsoid,c.WGS84),a=e.semiMajorAxis,u=e.semiMinorAxis,s=i(e.granularity,v.RADIANS_PER_DEGREE),l=i(e.height,0),f=e.extrudedHeight,d=o(f)&&Math.abs(l-f)>1,h=i(e.vertexFormat,E.DEFAULT);this._center=r.clone(t),this._semiMajorAxis=a,this._semiMinorAxis=u,this._ellipsoid=c.clone(n),this._rotation=i(e.rotation,0),this._stRotation=i(e.stRotation,0),this._height=l,this._granularity=s,this._vertexFormat=E.clone(h),this._extrudedHeight=i(f,l),this._extrude=d,this._workerName="createEllipseGeometry"};Y.packedLength=r.packedLength+c.packedLength+E.packedLength+8,Y.pack=function(e,t,n){n=i(n,0),r.pack(e._center,t,n),n+=r.packedLength,c.pack(e._ellipsoid,t,n),n+=c.packedLength,E.pack(e._vertexFormat,t,n),n+=E.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n]=e._extrude?1:0};var j=new r,H=new c,Z=new E,X={center:j,ellipsoid:H,vertexFormat:Z,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return Y.unpack=function(e,t,n){t=i(t,0);var a=r.unpack(e,t,j);t+=r.packedLength;var u=c.unpack(e,t,H);t+=c.packedLength;var s=E.unpack(e,t,Z);t+=E.packedLength;var l=e[t++],f=e[t++],d=e[t++],h=e[t++],m=e[t++],y=e[t++],p=e[t++],v=1===e[t];return o(n)?(n._center=r.clone(a,n._center),n._ellipsoid=c.clone(u,n._ellipsoid),n._vertexFormat=E.clone(s,n._vertexFormat),n._semiMajorAxis=l,n._semiMinorAxis=f,n._rotation=d,n._stRotation=h,n._height=m,n._granularity=y,n._extrudedHeight=p,n._extrude=v,n):(X.height=m,X.extrudedHeight=p,X.granularity=y,X.stRotation=h,X.rotation=d,X.semiMajorAxis=l,X.semiMinorAxis=f,new Y(X))},Y.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=O(r)):t=b(r),new f({attributes:t.attributes,indices:t.indices,primitiveType:w.TRIANGLES,boundingSphere:t.boundingSphere})},Y}),define("Workers/createEllipseGeometry",["../Core/Cartesian3","../Core/defined","../Core/EllipseGeometry","../Core/Ellipsoid"],function(e,t,r,n){"use strict";function a(a,i){return t(i)&&(a=r.unpack(a,i)),a._center=e.clone(a._center),a._ellipsoid=n.clone(a._ellipsoid),r.createGeometry(a)}return a})}();