/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^e[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(t){return t>0?1:0>t?-1:0},n.signNotZero=function(t){return 0>t?-1:1},n.toSNorm=function(t){return Math.round(255*(.5*n.clamp(t,-1,1)+.5))},n.fromSNorm=function(t){return 2*(n.clamp(t,0,255)/255)-1},n.sinh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e-n)},n.cosh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e+n)},n.lerp=function(t,e,n){return(1-n)*t+n*e},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(t){return t*n.RADIANS_PER_DEGREE},n.toDegrees=function(t){return t*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(t){var e=n.TWO_PI,r=t-Math.floor(t/e)*e;return r<-Math.PI?r+e:r>=Math.PI?r-e:r},n.negativePiToPi=function(t){return n.zeroToTwoPi(t+n.PI)-n.PI},n.zeroToTwoPi=function(t){var e=n.mod(t,n.TWO_PI);return Math.abs(e)<n.EPSILON14&&Math.abs(t)>n.EPSILON14?n.TWO_PI:e},n.mod=function(t,e){return(t%e+e)%e},n.equalsEpsilon=function(t,n,r,i){i=e(i,r);var a=Math.abs(t-n);return i>=a||a<=r*Math.max(Math.abs(t),Math.abs(n))};var r=[1];n.factorial=function(t){var e=r.length;if(t>=e)for(var n=r[e-1],i=e;t>=i;i++)r.push(n*i);return r[t]},n.incrementWrap=function(t,n,r){return r=e(r,0),++t,t>n&&(t=r),t},n.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},n.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},n.clamp=function(t,e,n){return e>t?e:t>n?n:t};var i=new t;return n.setRandomNumberSeed=function(e){i=new t(e)},n.nextRandomNumber=function(){return i.random()},n.acosClamped=function(t){return Math.acos(n.clamp(t,-1,1))},n.asinClamped=function(t){return Math.asin(n.clamp(t,-1,1))},n.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)};a.fromSpherical=function(n,r){e(r)||(r=new a);var i=n.clock,o=n.cone,u=t(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(i),r.y=s*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(t,n,r,i){return e(i)?(i.x=t,i.y=n,i.z=r,i):new a(t,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n):new a(t.x,t.y,t.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(t,e){a.normalize(t,s),a.normalize(e,c);var n=a.dot(s,c),r=a.magnitude(a.cross(s,c,s));return Math.atan2(r,n)};var l=new a;a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,l);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Z,e):n.y<=n.z?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_Z,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)},a.cross=function(t,e,n){var r=t.x,i=t.y,a=t.z,o=e.x,u=e.y,s=e.z,c=i*s-a*u,l=a*o-r*s,f=r*u-i*o;return n.x=c,n.y=l,n.z=f,n},a.fromDegrees=function(t,e,n,r,o){var u=i.toRadians(t),s=i.toRadians(e);return a.fromRadians(u,s,n,r,o)};var f=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=t(i,0);var s=e(o)?o.radiiSquared:d,c=Math.cos(r);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(r),f=a.normalize(f,f),a.multiplyComponents(s,f,h);var l=Math.sqrt(a.dot(f,h));return h=a.divideByScalar(h,l,h),f=a.multiplyByScalar(f,i,f),e(u)||(u=new a),a.add(h,f,u)},a.fromDegreesArray=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o++)r[o]=i.toRadians(t[o]);return a.fromRadiansArray(r,e,n)},a.fromRadiansArray=function(t,n,r){var i=t.length;e(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=t[o],s=t[o+1];r[o/2]=a.fromRadians(u,s,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o+=3)r[o]=i.toRadians(t[o]),r[o+1]=i.toRadians(t[o+1]),r[o+2]=t[o+2];return a.fromRadiansArrayHeights(r,e,n)},a.fromRadiansArrayHeights=function(t,n,r){var i=t.length;e(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=t[o],s=t[o+1],c=t[o+2];r[o/3]=a.fromRadians(u,s,c,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)};return a.fromRadians=function(n,r,i,o){return i=t(i,0),e(o)?(o.longitude=n,o.latitude=r,o.height=i,o):new a(n,r,i)},a.fromDegrees=function(t,e,n,r){return t=i.toRadians(t),e=i.toRadians(e),a.fromRadians(t,e,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.longitude=t.longitude,n.latitude=t.latitude,n.height=t.height,n):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.longitude===n.longitude&&t.latitude===n.latitude&&t.height===n.height},a.equalsEpsilon=function(t,n,r){return t===n||e(t)&&e(n)&&Math.abs(t.longitude-n.longitude)<=r&&Math.abs(t.latitude-n.latitude)<=r&&Math.abs(t.height-n.height)<=r},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),n=Object.defineProperties;return e&&t(n)||(n=function(t){return t}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";function s(e,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),e._radii=new t(r,i,a),e._radiiSquared=new t(r*r,i*i,a*a),e._radiiToTheFourth=new t(r*r*r*r,i*i*i*i,a*a*a*a),e._oneOverRadii=new t(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),e._oneOverRadiiSquared=new t(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),e._minimumRadius=Math.min(r,i,a),e._maximumRadius=Math.max(r,i,a),e._centerToleranceSquared=u.EPSILON1}var c=function(t,e,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,t,e,n)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(e,n){if(!r(e))return void 0;var i=e._radii;return r(n)?(t.clone(i,n._radii),t.clone(e._radiiSquared,n._radiiSquared),t.clone(e._radiiToTheFourth,n._radiiToTheFourth),t.clone(e._oneOverRadii,n._oneOverRadii),t.clone(e._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=e._minimumRadius,n._maximumRadius=e._maximumRadius,n._centerToleranceSquared=e._centerToleranceSquared,n):new c(i.x,i.y,i.z)},c.fromCartesian3=function(t,e){return r(e)||(e=new c),r(t)?(s(e,t.x,t.y,t.z),e):e},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(t){return c.clone(this,t)},c.packedLength=t.packedLength,c.pack=function(e,r,i){i=n(i,0),t.pack(e._radii,r,i)},c.unpack=function(e,r,i){r=n(r,0);var a=t.unpack(e,r);return c.fromCartesian3(a,i)},c.prototype.geocentricSurfaceNormal=t.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(e,n){var i=e.longitude,a=e.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return r(n)||(n=new t),n.x=u,n.y=s,n.z=c,t.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(e,n){return r(n)||(n=new t),n=t.multiplyComponents(e,this._oneOverRadiiSquared,n),t.normalize(n,n)};var l=new t,f=new t;c.prototype.cartographicToCartesian=function(e,n){var i=l,a=f;this.geodeticSurfaceNormalCartographic(e,i),t.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(t.dot(i,a));return t.divideByScalar(a,o,a),t.multiplyByScalar(i,e.height,i),r(n)||(n=new t),t.add(a,i,n)},c.prototype.cartographicArrayToCartesianArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;i++)e[i]=this.cartographicToCartesian(t[i],e[i]);return e};var h=new t,d=new t,m=new t;c.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,d);if(!r(a))return void 0;var o=this.geodeticSurfaceNormal(a,h),s=t.subtract(n,a,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(t.dot(s,n))*t.magnitude(s);return r(i)?(i.longitude=c,i.latitude=l,i.height=f,i):new e(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;++i)e[i]=this.cartesianToCartographic(t[i],e[i]);return e};var y=new t,p=new t;return c.prototype.scaleToGeodeticSurface=function(e,n){var i=e.x,a=e.y,o=e.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,h=i*i*c*c,d=a*a*l*l,m=o*o*f*f,v=h+d+m,w=Math.sqrt(1/v),E=t.multiplyByScalar(e,w,y);if(v<this._centerToleranceSquared)return isFinite(w)?t.clone(E,n):void 0;var x=this._oneOverRadiiSquared,g=x.x,S=x.y,M=x.z,O=p;O.x=2*E.x*g,O.y=2*E.y*S,O.z=2*E.z*M;var z,T,_,I,N,R,b,A,P,C,L,q=(1-w)*t.magnitude(e)/(.5*t.magnitude(O)),U=0;do{q-=U,_=1/(1+q*g),I=1/(1+q*S),N=1/(1+q*M),R=_*_,b=I*I,A=N*N,P=R*_,C=b*I,L=A*N,z=h*R+d*b+m*A-1,T=h*P*g+d*C*S+m*L*M;var D=-2*T;U=z/D}while(Math.abs(z)>u.EPSILON12);return r(n)?(n.x=i*_,n.y=a*I,n.z=o*N,n):new t(i*_,a*I,o*N)},c.prototype.scaleToGeocentricSurface=function(e,n){r(n)||(n=new t);var i=e.x,a=e.y,o=e.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return t.multiplyByScalar(e,s,n)},c.prototype.transformPositionToScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._radii,n)},c.prototype.equals=function(e){return this===e||r(e)&&t.equals(this._radii,e._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,e,n,r,i,a,o){"use strict";var u=function(t){this._ellipsoid=n(t,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(e,n){var i=this._semimajorAxis,a=e.longitude*i,o=e.latitude*i,u=e.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new t(a,o,u)},u.prototype.unproject=function(t,n){var i=this._oneOverSemimajorAxis,a=t.x*i,o=t.y*i,u=t.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new e(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(e)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var e=function(e,n){this.start=t(e,0),this.stop=t(n,0)};return e}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)};a.fromElements=function(t,n,r,i,o){return e(o)?(o.x=t,o.y=n,o.z=r,o.w=i,o):new a(t,n,r,i)},a.fromColor=function(t,n){return e(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n.w=t.w,n):new a(t.x,t.y,t.z,t.w):void 0},a.packedLength=4,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n.w=Math.min(t.w,e.w),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n.w=Math.max(t.w,e.w),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e.w=t.w/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n.w=t.w*e.w,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e.w=Math.abs(t.w),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a;return a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,s);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z&&t.w===n.w},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]&&t.w===e[n+3]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)&&i.equalsEpsilon(t.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a){"use strict";function o(t){for(var e=0,n=0;9>n;++n){var r=t[n];e+=r*r}return Math.sqrt(e)}function u(t){for(var e=0,n=0;3>n;++n){var r=t[c.getElementIndex(d[n],h[n])];e+=2*r*r}return Math.sqrt(e)}function s(t,e){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(t[c.getElementIndex(d[o],h[o])]);u>r&&(i=o,r=u)}var s=1,l=0,f=h[i],m=d[i];if(Math.abs(t[c.getElementIndex(m,f)])>n){var y,p=t[c.getElementIndex(m,m)],v=t[c.getElementIndex(f,f)],w=t[c.getElementIndex(m,f)],E=(p-v)/2/w;y=0>E?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)),s=1/Math.sqrt(1+y*y),l=y*s}return e=c.clone(c.IDENTITY,e),e[c.getElementIndex(f,f)]=e[c.getElementIndex(m,m)]=s,e[c.getElementIndex(m,f)]=l,e[c.getElementIndex(f,m)]=-l,e}var c=function(t,n,r,i,a,o,u,s,c){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(u,0),this[3]=e(n,0),this[4]=e(a,0),this[5]=e(s,0),this[6]=e(r,0),this[7]=e(o,0),this[8]=e(c,0)};c.packedLength=9,c.pack=function(t,n,r){r=e(r,0),n[r++]=t[0],n[r++]=t[1],n[r++]=t[2],n[r++]=t[3],n[r++]=t[4],n[r++]=t[5],n[r++]=t[6],n[r++]=t[7],n[r++]=t[8]},c.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new c),i[0]=t[r++],i[1]=t[r++],i[2]=t[r++],i[3]=t[r++],i[4]=t[r++],i[5]=t[r++],i[6]=t[r++],i[7]=t[r++],i[8]=t[r++],i},c.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new c(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},c.fromArray=function(t,r,i){return r=e(r,0),n(i)||(i=new c),i[0]=t[r],i[1]=t[r+1],i[2]=t[r+2],i[3]=t[r+3],i[4]=t[r+4],i[5]=t[r+5],i[6]=t[r+6],i[7]=t[r+7],i[8]=t[r+8],i},c.fromColumnMajorArray=function(t,e){return c.clone(t,e)},c.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new c(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},c.fromQuaternion=function(t,e){var r=t.x*t.x,i=t.x*t.y,a=t.x*t.z,o=t.x*t.w,u=t.y*t.y,s=t.y*t.z,l=t.y*t.w,f=t.z*t.z,h=t.z*t.w,d=t.w*t.w,m=r-u-f+d,y=2*(i-h),p=2*(a+l),v=2*(i+h),w=-r+u-f+d,E=2*(s-o),x=2*(a-l),g=2*(s+o),S=-r-u+f+d;return n(e)?(e[0]=m,e[1]=v,e[2]=x,e[3]=y,e[4]=w,e[5]=g,e[6]=p,e[7]=E,e[8]=S,e):new c(m,y,p,v,w,E,x,g,S)},c.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new c(t.x,0,0,0,t.y,0,0,0,t.z)},c.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new c(t,0,0,0,t,0,0,0,t)},c.fromCrossProduct=function(t,e){return n(e)?(e[0]=0,e[1]=t.z,e[2]=-t.y,e[3]=-t.z,e[4]=0,e[5]=t.x,e[6]=t.y,e[7]=-t.x,e[8]=0,e):new c(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},c.fromRotationX=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=r,e[5]=i,e[6]=0,e[7]=-i,e[8]=r,e):new c(1,0,0,0,r,-i,0,i,r)},c.fromRotationY=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=0,e[2]=-i,e[3]=0,e[4]=1,e[5]=0,e[6]=i,e[7]=0,e[8]=r,e):new c(r,0,i,0,1,0,-i,0,r)},c.fromRotationZ=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=i,e[2]=0,e[3]=-i,e[4]=r,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new c(r,-i,0,i,r,0,0,0,1)},c.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},c.getElementIndex=function(t,e){return 3*t+e},c.getColumn=function(t,e,n){var r=3*e,i=t[r],a=t[r+1],o=t[r+2];return n.x=i,n.y=a,n.z=o,n},c.setColumn=function(t,e,n,r){r=c.clone(t,r);var i=3*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},c.getRow=function(t,e,n){var r=t[e],i=t[e+3],a=t[e+6];return n.x=r,n.y=i,n.z=a,n},c.setRow=function(t,e,n,r){return r=c.clone(t,r),r[e]=n.x,r[e+3]=n.y,r[e+6]=n.z,r};var l=new t;c.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],l)),n.y=t.magnitude(t.fromElements(e[3],e[4],e[5],l)),n.z=t.magnitude(t.fromElements(e[6],e[7],e[8],l)),n};var f=new t;c.getMaximumScale=function(e){return c.getScale(e,f),t.maximumComponent(f)},c.multiply=function(t,e,n){var r=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],i=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],a=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],o=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],u=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],s=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],c=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],l=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],f=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},c.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n},c.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n},c.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[3]*i+t[6]*a,u=t[1]*r+t[4]*i+t[7]*a,s=t[2]*r+t[5]*i+t[8]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n},c.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e},c.transpose=function(t,e){var n=t[0],r=t[3],i=t[6],a=t[1],o=t[4],u=t[7],s=t[2],c=t[5],l=t[8];return e[0]=n,e[1]=r,e[2]=i,e[3]=a,e[4]=o,e[5]=u,e[6]=s,e[7]=c,e[8]=l,e};var h=[1,0,0],d=[2,2,1],m=new c,y=new c;return c.computeEigenDecomposition=function(t,e){var r=a.EPSILON20,i=10,l=0,f=0;n(e)||(e={});for(var h=e.unitary=c.clone(c.IDENTITY,e.unitary),d=e.diagonal=c.clone(t,e.diagonal),p=r*o(d);i>f&&u(d)>p;)s(d,m),c.transpose(m,y),c.multiply(d,m,d),c.multiply(y,d,d),c.multiply(h,m,h),++l>2&&(++f,l=0);return e},c.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e},c.determinant=function(t){var e=t[0],n=t[3],r=t[6],i=t[1],a=t[4],o=t[7],u=t[2],s=t[5],c=t[8];return e*(a*c-s*o)+i*(s*r-n*c)+u*(n*o-a*r)},c.inverse=function(t,e){var n=t[0],i=t[1],o=t[2],u=t[3],s=t[4],l=t[5],f=t[6],h=t[7],d=t[8],m=c.determinant(t);if(Math.abs(m)<=a.EPSILON15)throw new r("matrix is not invertible");e[0]=s*d-h*l,e[1]=h*o-i*d,e[2]=i*l-s*o,e[3]=f*l-u*d,e[4]=n*d-f*o,e[5]=u*o-n*l,e[6]=u*h-f*s,e[7]=f*i-n*h,e[8]=n*s-u*i;var y=1/m;return c.multiplyByScalar(e,y,e)},c.equals=function(t,e){return t===e||n(t)&&n(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},c.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r},c.IDENTITY=i(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(t){return c.clone(this,t)},c.prototype.equals=function(t){return c.equals(this,t)},c.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]},c.prototype.equalsEpsilon=function(t,e){return c.equalsEpsilon(this,t,e)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var e=function(t){this.name="RuntimeError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,n,r,i,a,o,u,s){"use strict";var c=function(t,e,r,i,a,o,u,s,c,l,f,h,d,m,y,p){this[0]=n(t,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(e,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(p,0)};c.packedLength=16,c.pack=function(t,e,r){r=n(r,0),e[r++]=t[0],e[r++]=t[1],e[r++]=t[2],e[r++]=t[3],e[r++]=t[4],e[r++]=t[5],e[r++]=t[6],e[r++]=t[7],e[r++]=t[8],e[r++]=t[9],e[r++]=t[10],e[r++]=t[11],e[r++]=t[12],e[r++]=t[13],e[r++]=t[14],e[r]=t[15]},c.unpack=function(t,e,i){return e=n(e,0),r(i)||(i=new c),i[0]=t[e++],i[1]=t[e++],i[2]=t[e++],i[3]=t[e++],i[4]=t[e++],i[5]=t[e++],i[6]=t[e++],i[7]=t[e++],i[8]=t[e++],i[9]=t[e++],i[10]=t[e++],i[11]=t[e++],i[12]=t[e++],i[13]=t[e++],i[14]=t[e++],i[15]=t[e],i},c.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new c(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(t,e){return c.clone(t,e)},c.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new c(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},c.fromRotationTranslation=function(e,i,a){return i=n(i,t.ZERO),r(a)?(a[0]=e[0],a[1]=e[1],a[2]=e[2],a[3]=0,a[4]=e[3],a[5]=e[4],a[6]=e[5],a[7]=0,a[8]=e[6],a[9]=e[7],a[10]=e[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new c(e[0],e[3],e[6],i.x,e[1],e[4],e[7],i.y,e[2],e[5],e[8],i.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(t,e,n,i){r(i)||(i=new c);var a=n.x,o=n.y,u=n.z,s=e.x*e.x,l=e.x*e.y,f=e.x*e.z,h=e.x*e.w,d=e.y*e.y,m=e.y*e.z,y=e.y*e.w,p=e.z*e.z,v=e.z*e.w,w=e.w*e.w,E=s-d-p+w,x=2*(l-v),g=2*(f+y),S=2*(l+v),M=-s+d-p+w,O=2*(m-h),z=2*(f-y),T=2*(m+h),_=-s-d+p+w;return i[0]=E*a,i[1]=S*a,i[2]=z*a,i[3]=0,i[4]=x*o,i[5]=M*o,i[6]=T*o,i[7]=0,i[8]=g*u,i[9]=O*u,i[10]=_*u,i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i},c.fromTranslation=function(t,e){return c.fromRotationTranslation(u.IDENTITY,t,e)},c.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new c(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},c.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new c(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var l=new t,f=new t,h=new t;c.fromCamera=function(e,n){var i=e.eye,a=e.target,o=e.up;t.normalize(t.subtract(a,i,l),l),t.normalize(t.cross(l,o,f),f),t.normalize(t.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,m=l.x,y=l.y,p=l.z,v=h.x,w=h.y,E=h.z,x=i.x,g=i.y,S=i.z,M=u*-x+s*-g+d*-S,O=v*-x+w*-g+E*-S,z=m*x+y*g+p*S;return r(n)?(n[0]=u,n[1]=v,n[2]=-m,n[3]=0,n[4]=s,n[5]=w,n[6]=-y,n[7]=0,n[8]=d,n[9]=E,n[10]=-p,n[11]=0,n[12]=M,n[13]=O,n[14]=z,n[15]=1,n):new c(u,s,d,M,v,w,E,O,-m,-y,-p,z,0,0,0,1)},c.computePerspectiveFieldOfView=function(t,e,n,r,i){var a=Math.tan(.5*t),o=1/a,u=o/e,s=(r+n)/(n-r),c=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},c.computeOrthographicOffCenter=function(t,e,n,r,i,a,o){var u=1/(e-t),s=1/(r-n),c=1/(a-i),l=-(e+t)*u,f=-(r+n)*s,h=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(t,e,n,r,i,a,o){var u=2*i/(e-t),s=2*i/(r-n),c=(e+t)/(e-t),l=(r+n)/(r-n),f=-(a+i)/(a-i),h=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(t,e,n,r,i,a){var o=2*i/(e-t),u=2*i/(r-n),s=(e+t)/(e-t),c=(r+n)/(r-n),l=-1,f=-1,h=-2*i;
return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=l,a[11]=f,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},c.computeViewportTransformation=function(t,e,r,i){t=n(t,n.EMPTY_OBJECT);var a=n(t.x,0),o=n(t.y,0),u=n(t.width,0),s=n(t.height,0);e=n(e,0),r=n(r,1);var c=.5*u,l=.5*s,f=.5*(r-e),h=c,d=l,m=f,y=a+c,p=o+l,v=e+f,w=1;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=m,i[11]=0,i[12]=y,i[13]=p,i[14]=v,i[15]=w,i},c.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},c.getElementIndex=function(t,e){return 4*t+e},c.getColumn=function(t,e,n){var r=4*e,i=t[r],a=t[r+1],o=t[r+2],u=t[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},c.setColumn=function(t,e,n,r){r=c.clone(t,r);var i=4*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},c.getRow=function(t,e,n){var r=t[e],i=t[e+4],a=t[e+8],o=t[e+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},c.setRow=function(t,e,n,r){return r=c.clone(t,r),r[e]=n.x,r[e+4]=n.y,r[e+8]=n.z,r[e+12]=n.w,r};var d=new t;c.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],d)),n.y=t.magnitude(t.fromElements(e[4],e[5],e[6],d)),n.z=t.magnitude(t.fromElements(e[8],e[9],e[10],d)),n};var m=new t;c.getMaximumScale=function(e){return c.getScale(e,m),t.maximumComponent(m)},c.multiply=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[3],u=t[4],s=t[5],c=t[6],l=t[7],f=t[8],h=t[9],d=t[10],m=t[11],y=t[12],p=t[13],v=t[14],w=t[15],E=e[0],x=e[1],g=e[2],S=e[3],M=e[4],O=e[5],z=e[6],T=e[7],_=e[8],I=e[9],N=e[10],R=e[11],b=e[12],A=e[13],P=e[14],C=e[15],L=r*E+u*x+f*g+y*S,q=i*E+s*x+h*g+p*S,U=a*E+c*x+d*g+v*S,D=o*E+l*x+m*g+w*S,B=r*M+u*O+f*z+y*T,F=i*M+s*O+h*z+p*T,k=a*M+c*O+d*z+v*T,W=o*M+l*O+m*z+w*T,G=r*_+u*I+f*N+y*R,V=i*_+s*I+h*N+p*R,Y=a*_+c*I+d*N+v*R,j=o*_+l*I+m*N+w*R,H=r*b+u*A+f*P+y*C,Z=i*b+s*A+h*P+p*C,X=a*b+c*A+d*P+v*C,K=o*b+l*A+m*P+w*C;return n[0]=L,n[1]=q,n[2]=U,n[3]=D,n[4]=B,n[5]=F,n[6]=k,n[7]=W,n[8]=G,n[9]=V,n[10]=Y,n[11]=j,n[12]=H,n[13]=Z,n[14]=X,n[15]=K,n},c.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n[9]=t[9]+e[9],n[10]=t[10]+e[10],n[11]=t[11]+e[11],n[12]=t[12]+e[12],n[13]=t[13]+e[13],n[14]=t[14]+e[14],n[15]=t[15]+e[15],n},c.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n[9]=t[9]-e[9],n[10]=t[10]-e[10],n[11]=t[11]-e[11],n[12]=t[12]-e[12],n[13]=t[13]-e[13],n[14]=t[14]-e[14],n[15]=t[15]-e[15],n},c.multiplyTransformation=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],s=t[6],c=t[8],l=t[9],f=t[10],h=t[12],d=t[13],m=t[14],y=e[0],p=e[1],v=e[2],w=e[4],E=e[5],x=e[6],g=e[8],S=e[9],M=e[10],O=e[12],z=e[13],T=e[14],_=r*y+o*p+c*v,I=i*y+u*p+l*v,N=a*y+s*p+f*v,R=r*w+o*E+c*x,b=i*w+u*E+l*x,A=a*w+s*E+f*x,P=r*g+o*S+c*M,C=i*g+u*S+l*M,L=a*g+s*S+f*M,q=r*O+o*z+c*T+h,U=i*O+u*z+l*T+d,D=a*O+s*z+f*T+m;return n[0]=_,n[1]=I,n[2]=N,n[3]=0,n[4]=R,n[5]=b,n[6]=A,n[7]=0,n[8]=P,n[9]=C,n[10]=L,n[11]=0,n[12]=q,n[13]=U,n[14]=D,n[15]=1,n},c.multiplyByMatrix3=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],s=t[6],c=t[8],l=t[9],f=t[10],h=e[0],d=e[1],m=e[2],y=e[3],p=e[4],v=e[5],w=e[6],E=e[7],x=e[8],g=r*h+o*d+c*m,S=i*h+u*d+l*m,M=a*h+s*d+f*m,O=r*y+o*p+c*v,z=i*y+u*p+l*v,T=a*y+s*p+f*v,_=r*w+o*E+c*x,I=i*w+u*E+l*x,N=a*w+s*E+f*x;return n[0]=g,n[1]=S,n[2]=M,n[3]=0,n[4]=O,n[5]=z,n[6]=T,n[7]=0,n[8]=_,n[9]=I,n[10]=N,n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=t[15],n},c.multiplyByTranslation=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=r*t[0]+i*t[4]+a*t[8]+t[12],u=r*t[1]+i*t[5]+a*t[9]+t[13],s=r*t[2]+i*t[6]+a*t[10]+t[14];return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=o,n[13]=u,n[14]=s,n[15]=t[15],n};var y=new t;c.multiplyByUniformScale=function(t,e,n){return y.x=e,y.y=e,y.z=e,c.multiplyByScale(t,y,n)},c.multiplyByScale=function(t,e,n){var r=e.x,i=e.y,a=e.z;return 1===r&&1===i&&1===a?c.clone(t,n):(n[0]=r*t[0],n[1]=r*t[1],n[2]=r*t[2],n[3]=0,n[4]=i*t[4],n[5]=i*t[5],n[6]=i*t[6],n[7]=0,n[8]=a*t[8],n[9]=a*t[9],n[10]=a*t[10],n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=1,n)},c.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t[0]*r+t[4]*i+t[8]*a+t[12]*o,s=t[1]*r+t[5]*i+t[9]*a+t[13]*o,c=t[2]*r+t[6]*i+t[10]*a+t[14]*o,l=t[3]*r+t[7]*i+t[11]*a+t[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a,u=t[1]*r+t[5]*i+t[9]*a,s=t[2]*r+t[6]*i+t[10]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a+t[12],u=t[1]*r+t[5]*i+t[9]*a+t[13],s=t[2]*r+t[6]*i+t[10]*a+t[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n[9]=t[9]*e,n[10]=t[10]*e,n[11]=t[11]*e,n[12]=t[12]*e,n[13]=t[13]*e,n[14]=t[14]*e,n[15]=t[15]*e,n},c.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e},c.transpose=function(t,e){var n=t[1],r=t[2],i=t[3],a=t[6],o=t[7],u=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=n,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=r,e[9]=a,e[10]=t[10],e[11]=t[14],e[12]=i,e[13]=o,e[14]=u,e[15]=t[15],e},c.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e},c.equals=function(t,e){return t===e||r(t)&&r(e)&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[3]===e[3]&&t[7]===e[7]&&t[11]===e[11]&&t[15]===e[15]},c.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n&&Math.abs(t[9]-e[9])<=n&&Math.abs(t[10]-e[10])<=n&&Math.abs(t[11]-e[11])<=n&&Math.abs(t[12]-e[12])<=n&&Math.abs(t[13]-e[13])<=n&&Math.abs(t[14]-e[14])<=n&&Math.abs(t[15]-e[15])<=n},c.getTranslation=function(t,e){return e.x=t[12],e.y=t[13],e.z=t[14],e},c.getRotation=function(t,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e};var p=new u,v=new u,w=new e,E=new e(0,0,0,1);return c.inverse=function(t,n){if(u.equalsEpsilon(c.getRotation(t,p),v,o.EPSILON7)&&e.equals(c.getRow(t,3,w),E))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-t[12],n[13]=-t[13],n[14]=-t[14],n[15]=1,n;var r=t[0],i=t[4],a=t[8],l=t[12],f=t[1],h=t[5],d=t[9],m=t[13],y=t[2],x=t[6],g=t[10],S=t[14],M=t[3],O=t[7],z=t[11],T=t[15],_=g*T,I=S*z,N=x*T,R=S*O,b=x*z,A=g*O,P=y*T,C=S*M,L=y*z,q=g*M,U=y*O,D=x*M,B=_*h+R*d+b*m-(I*h+N*d+A*m),F=I*f+P*d+q*m-(_*f+C*d+L*m),k=N*f+C*h+U*m-(R*f+P*h+D*m),W=A*f+L*h+D*d-(b*f+q*h+U*d),G=I*i+N*a+A*l-(_*i+R*a+b*l),V=_*r+C*a+L*l-(I*r+P*a+q*l),Y=R*r+P*i+D*l-(N*r+C*i+U*l),j=b*r+q*i+U*a-(A*r+L*i+D*a);_=a*m,I=l*d,N=i*m,R=l*h,b=i*d,A=a*h,P=r*m,C=l*f,L=r*d,q=a*f,U=r*h,D=i*f;var H=_*O+R*z+b*T-(I*O+N*z+A*T),Z=I*M+P*z+q*T-(_*M+C*z+L*T),X=N*M+C*O+U*T-(R*M+P*O+D*T),K=A*M+L*O+D*z-(b*M+q*O+U*z),J=N*g+A*S+I*x-(b*S+_*x+R*g),Q=L*S+_*y+C*g-(P*g+q*S+I*y),$=P*x+D*S+R*y-(U*S+N*y+C*x),te=U*g+b*y+q*x-(L*x+D*g+A*y),ee=r*B+i*F+a*k+l*W;if(Math.abs(ee)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ee=1/ee,n[0]=B*ee,n[1]=F*ee,n[2]=k*ee,n[3]=W*ee,n[4]=G*ee,n[5]=V*ee,n[6]=Y*ee,n[7]=j*ee,n[8]=H*ee,n[9]=Z*ee,n[10]=X*ee,n[11]=K*ee,n[12]=J*ee,n[13]=Q*ee,n[14]=$*ee,n[15]=te*ee,n},c.inverseTransformation=function(t,e){var n=t[0],r=t[1],i=t[2],a=t[4],o=t[5],u=t[6],s=t[8],c=t[9],l=t[10],f=t[12],h=t[13],d=t[14],m=-n*f-r*h-i*d,y=-a*f-o*h-u*d,p=-s*f-c*h-l*d;return e[0]=n,e[1]=a,e[2]=s,e[3]=0,e[4]=r,e[5]=o,e[6]=c,e[7]=0,e[8]=i,e[9]=u,e[10]=l,e[11]=0,e[12]=m,e[13]=y,e[14]=p,e[15]=1,e},c.IDENTITY=a(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(t){return c.clone(this,t)},c.prototype.equals=function(t){return c.equals(this,t)},c.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]&&t[9]===e[n+9]&&t[10]===e[n+10]&&t[11]===e[n+11]&&t[12]===e[n+12]&&t[13]===e[n+13]&&t[14]===e[n+14]&&t[15]===e[n+15]},c.prototype.equalsEpsilon=function(t,e){return c.equalsEpsilon(this,t,e)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";var s=function(t,n,r,i){this.west=e(t,0),this.south=e(n,0),this.east=e(r,0),this.north=e(i,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(t,n,r){r=e(r,0),n[r++]=t.west,n[r++]=t.south,n[r++]=t.east,n[r]=t.north},s.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i.west=t[r++],i.south=t[r++],i.east=t[r++],i.north=t[r],i},s.computeWidth=function(t){var e=t.east,n=t.west;return n>e&&(e+=u.TWO_PI),e-n},s.computeHeight=function(t){return t.north-t.south},s.fromDegrees=function(t,r,i,a,o){return t=u.toRadians(e(t,0)),r=u.toRadians(e(r,0)),i=u.toRadians(e(i,0)),a=u.toRadians(e(a,0)),n(o)?(o.west=t,o.south=r,o.east=i,o.north=a,o):new s(t,r,i,a)},s.fromCartographicArray=function(t,e){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=t.length;c>u;u++){var l=t[u];r=Math.min(r,l.longitude),i=Math.max(i,l.longitude),a=Math.min(a,l.latitude),o=Math.max(o,l.latitude)}return n(e)?(e.west=r,e.south=a,e.east=i,e.north=o,e):new s(r,a,i,o)},s.packedLength=4,s.pack=function(t,n,r){r=e(r,0),n[r++]=t.west,n[r++]=t.south,n[r++]=t.east,n[r]=t.north},s.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i.west=t[r++],i.south=t[r++],i.east=t[r++],i.north=t[r],i},s.clone=function(t,e){return n(t)?n(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new s(t.west,t.south,t.east,t.north):void 0},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equals=function(t,e){return t===e||n(t)&&n(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},s.prototype.equalsEpsilon=function(t,e){return n(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},s.validate=function(){},s.southwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.south,r.height=0,r):new t(e.west,e.south)},s.northwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.north,r.height=0,r):new t(e.west,e.north)},s.northeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.north,r.height=0,r):new t(e.east,e.north)},s.southeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.south,r.height=0,r):new t(e.east,e.south)},s.center=function(e,r){var i=e.east,a=e.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),s=.5*(e.south+e.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new t(o,s)},s.intersection=function(t,e,r){var i=t.east,a=t.west,o=e.east,c=e.west;a>i&&o>0?i+=u.TWO_PI:c>o&&i>0&&(o+=u.TWO_PI),a>i&&0>c?c+=u.TWO_PI:c>o&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,c)),f=u.negativePiToPi(Math.min(i,o));if((t.west<t.east||e.west<e.east)&&l>=f)return void 0;var h=Math.max(t.south,e.south),d=Math.min(t.north,e.north);return h>=d?void 0:n(r)?(r.west=l,r.south=h,r.east=f,r.north=d,r):new s(l,h,f,d)},s.contains=function(t,e){var n=e.longitude,r=e.latitude,i=t.west,a=t.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=t.south&&r<=t.north};var c=new t;return s.subsample=function(t,r,i,o){r=e(r,a.WGS84),i=e(i,0),n(o)||(o=[]);var l=0,f=t.north,h=t.south,d=t.east,m=t.west,y=c;y.height=i,y.longitude=m,y.latitude=f,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=d,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.latitude=h,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=m,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.latitude=0>f?f:h>0?h:0;for(var p=1;8>p;++p)y.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(t,y)&&(o[l]=r.cartographicToCartesian(y,o[l]),l++);return 0===y.latitude&&(y.longitude=m,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=d,o[l]=r.cartographicToCartesian(y,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(t,e,n,r,i,a,o,u,s,c,l){"use strict";var f=function(e,r){this.center=t.clone(n(e,t.ZERO)),this.radius=n(r,0)},h=new t,d=new t,m=new t,y=new t,p=new t,v=new t,w=new t,E=new t,x=new t,g=new t,S=new t,M=new t;f.fromPoints=function(e,n){if(r(n)||(n=new f),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;for(var i=t.clone(e[0],w),a=t.clone(i,h),o=t.clone(i,d),u=t.clone(i,m),s=t.clone(i,y),c=t.clone(i,p),l=t.clone(i,v),O=e.length,z=1;O>z;z++){t.clone(e[z],i);var T=i.x,_=i.y,I=i.z;T<a.x&&t.clone(i,a),T>s.x&&t.clone(i,s),_<o.y&&t.clone(i,o),_>c.y&&t.clone(i,c),I<u.z&&t.clone(i,u),I>l.z&&t.clone(i,l)}var N=t.magnitudeSquared(t.subtract(s,a,E)),R=t.magnitudeSquared(t.subtract(c,o,E)),b=t.magnitudeSquared(t.subtract(l,u,E)),A=a,P=s,C=N;R>C&&(C=R,A=o,P=c),b>C&&(C=b,A=u,P=l);var L=x;L.x=.5*(A.x+P.x),L.y=.5*(A.y+P.y),L.z=.5*(A.z+P.z);var q=t.magnitudeSquared(t.subtract(P,L,E)),U=Math.sqrt(q),D=g;D.x=a.x,D.y=o.y,D.z=u.z;var B=S;B.x=s.x,B.y=c.y,B.z=l.z;var F=t.multiplyByScalar(t.add(D,B,E),.5,M),k=0;for(z=0;O>z;z++){t.clone(e[z],i);var W=t.magnitude(t.subtract(i,F,E));W>k&&(k=W);var G=t.magnitudeSquared(t.subtract(i,L,E));if(G>q){var V=Math.sqrt(G);U=.5*(U+V),q=U*U;var Y=V-U;L.x=(U*L.x+Y*i.x)/V,L.y=(U*L.y+Y*i.y)/V,L.z=(U*L.z+Y*i.z)/V}}return k>U?(t.clone(L,n.center),n.radius=U):(t.clone(F,n.center),n.radius=k),n};var O=new o,z=new t,T=new t,_=new e,I=new e;f.fromRectangle2D=function(t,e,n){return f.fromRectangleWithHeights2D(t,e,0,0,n)},f.fromRectangleWithHeights2D=function(e,i,a,o,u){if(r(u)||(u=new f),!r(e))return u.center=t.clone(t.ZERO,u.center),u.radius=0,u;i=n(i,O),l.southwest(e,_),_.height=a,l.northeast(e,I),I.height=o;var s=i.project(_,z),c=i.project(I,T),h=c.x-s.x,d=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(h*h+d*d+m*m);var y=u.center;return y.x=s.x+.5*h,y.y=s.y+.5*d,y.z=s.z+.5*m,u};var N=[];f.fromRectangle3D=function(t,e,i,o){e=n(e,a.WGS84),i=n(i,0);var u;return r(t)&&(u=l.subsample(t,e,i,N)),f.fromPoints(u,o)},f.fromVertices=function(e,i,a,o){if(r(o)||(o=new f),!r(e)||0===e.length)return o.center=t.clone(t.ZERO,o.center),o.radius=0,o;i=n(i,t.ZERO),a=n(a,3);var u=w;u.x=e[0]+i.x,u.y=e[1]+i.y,u.z=e[2]+i.z;for(var s=t.clone(u,h),c=t.clone(u,d),l=t.clone(u,m),O=t.clone(u,y),z=t.clone(u,p),T=t.clone(u,v),_=e.length,I=0;_>I;I+=a){var N=e[I]+i.x,R=e[I+1]+i.y,b=e[I+2]+i.z;u.x=N,u.y=R,u.z=b,N<s.x&&t.clone(u,s),N>O.x&&t.clone(u,O),R<c.y&&t.clone(u,c),R>z.y&&t.clone(u,z),b<l.z&&t.clone(u,l),b>T.z&&t.clone(u,T)}var A=t.magnitudeSquared(t.subtract(O,s,E)),P=t.magnitudeSquared(t.subtract(z,c,E)),C=t.magnitudeSquared(t.subtract(T,l,E)),L=s,q=O,U=A;P>U&&(U=P,L=c,q=z),C>U&&(U=C,L=l,q=T);var D=x;D.x=.5*(L.x+q.x),D.y=.5*(L.y+q.y),D.z=.5*(L.z+q.z);var B=t.magnitudeSquared(t.subtract(q,D,E)),F=Math.sqrt(B),k=g;k.x=s.x,k.y=c.y,k.z=l.z;var W=S;W.x=O.x,W.y=z.y,W.z=T.z;var G=t.multiplyByScalar(t.add(k,W,E),.5,M),V=0;for(I=0;_>I;I+=a){u.x=e[I]+i.x,u.y=e[I+1]+i.y,u.z=e[I+2]+i.z;var Y=t.magnitude(t.subtract(u,G,E));Y>V&&(V=Y);var j=t.magnitudeSquared(t.subtract(u,D,E));if(j>B){var H=Math.sqrt(j);F=.5*(F+H),B=F*F;var Z=H-F;D.x=(F*D.x+Z*u.x)/H,D.y=(F*D.y+Z*u.y)/H,D.z=(F*D.z+Z*u.z)/H}}return V>F?(t.clone(D,o.center),o.radius=F):(t.clone(G,o.center),o.radius=V),o},f.fromCornerPoints=function(e,n,i){r(i)||(i=new f);var a=i.center;return t.add(e,n,a),t.multiplyByScalar(a,.5,a),i.radius=t.distance(a,n),i},f.fromEllipsoid=function(e,n){return r(n)||(n=new f),t.clone(t.ZERO,n.center),n.radius=e.maximumRadius,n};var R=new t;f.fromBoundingSpheres=function(e,n){if(r(n)||(n=new f),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;var i=e.length;if(1===i)return f.clone(e[0],n);if(2===i)return f.union(e[0],e[1],n);for(var a=[],o=0;i>o;o++)a.push(e[o].center);n=f.fromPoints(a,n);var u=n.center,s=n.radius;for(o=0;i>o;o++){var c=e[o];s=Math.max(s,t.distance(u,c.center,R)+c.radius)}return n.radius=s,n},f.clone=function(e,n){return r(e)?r(n)?(n.center=t.clone(e.center,n.center),n.radius=e.radius,n):new f(e.center,e.radius):void 0},f.packedLength=4,f.pack=function(t,e,r){r=n(r,0);var i=t.center;e[r++]=i.x,e[r++]=i.y,e[r++]=i.z,e[r]=t.radius},f.unpack=function(t,e,i){e=n(e,0),r(i)||(i=new f);var a=i.center;return a.x=t[e++],a.y=t[e++],a.z=t[e++],i.radius=t[e],i};var b=new t,A=new t;f.union=function(e,n,i){r(i)||(i=new f);var a=e.center,o=n.center;t.add(a,o,A);var u=t.multiplyByScalar(A,.5,A),s=t.magnitude(t.subtract(a,u,b))+e.radius,c=t.magnitude(t.subtract(o,u,b))+n.radius;return i.radius=Math.max(s,c),t.clone(u,i.center),i};var P=new t;f.expand=function(e,n,r){r=f.clone(e,r);var i=t.magnitude(t.subtract(n,r.center,P));return i>r.radius&&(r.radius=i),r},f.intersect=function(e,n){var r=e.center,i=e.radius,a=t.dot(n,r)+n.w;return-i>a?u.OUTSIDE:i>a?u.INTERSECTING:u.INSIDE},f.transform=function(t,e,n){return r(n)||(n=new f),n.center=c.multiplyByPoint(e,t.center,n.center),n.radius=c.getMaximumScale(e)*t.radius,n};var C=new t;f.distanceSquaredTo=function(e,n){var r=t.subtract(e.center,n,C);return t.magnitudeSquared(r)-e.radius*e.radius},f.transformWithoutScale=function(t,e,n){return r(n)||(n=new f),n.center=c.multiplyByPoint(e,t.center,n.center),n.radius=t.radius,n};var L=new t;f.computePlaneDistances=function(e,n,i,a){r(a)||(a=new s);var o=t.subtract(e.center,n,L),u=t.multiplyByScalar(i,t.dot(i,o),L),c=t.magnitude(u);return a.start=c-e.radius,a.stop=c+e.radius,a};for(var q=new t,U=new t,D=new t,B=new t,F=new t,k=new e,W=new Array(8),G=0;8>G;++G)W[G]=new t;var V=new o;return f.projectTo2D=function(e,r,i){r=n(r,V);var a=r.ellipsoid,o=e.center,u=e.radius,s=a.geodeticSurfaceNormal(o,q),c=t.cross(t.UNIT_Z,s,U);t.normalize(c,c);var l=t.cross(s,c,D);t.normalize(l,l),t.multiplyByScalar(s,u,s),t.multiplyByScalar(l,u,l),t.multiplyByScalar(c,u,c);var h=t.negate(l,F),d=t.negate(c,B),m=W,y=m[0];t.add(s,l,y),t.add(y,c,y),y=m[1],t.add(s,l,y),t.add(y,d,y),y=m[2],t.add(s,h,y),t.add(y,d,y),y=m[3],t.add(s,h,y),t.add(y,c,y),t.negate(s,s),y=m[4],t.add(s,l,y),t.add(y,c,y),y=m[5],t.add(s,l,y),t.add(y,d,y),y=m[6],t.add(s,h,y),t.add(y,d,y),y=m[7],t.add(s,h,y),t.add(y,c,y);for(var p=m.length,v=0;p>v;++v){var w=m[v];t.add(o,w,w);var E=a.cartesianToCartographic(w,k);r.project(E,w)}i=f.fromPoints(m,i),o=i.center;var x=o.x,g=o.y,S=o.z;return o.x=S,o.y=x,o.z=g,i},f.equals=function(e,n){return e===n||r(e)&&r(n)&&t.equals(e.center,n.center)&&e.radius===n.radius},f.prototype.intersect=function(t){return f.intersect(this,t)},f.prototype.equals=function(t){return f.equals(this,t)},f.prototype.clone=function(t){return f.clone(this,t)},f}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n){this.x=t(e,0),this.y=t(n,0)};a.fromElements=function(t,n,r){return e(r)?(r.x=t,r.y=n,r):new a(t,n)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n):new a(t.x,t.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r]=e.y},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y)},a.minimumComponent=function(t){return Math.min(t.x,t.y)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(t,e){return a.normalize(t,s),a.normalize(e,c),i.acosClamped(a.dot(s,c))};var l=new a;return a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,l);return a.abs(n,n),e=n.x<=n.y?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Y,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)},a.ZERO=r(new a(0,0)),a.UNIT_X=r(new a(1,0)),a.UNIT_Y=r(new a(0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,e){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return e(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(t(n))return n;n=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof e[i]?(r.requestFullscreen=i,n=!0):(i=s+"RequestFullScreen","function"==typeof e[i]&&(r.requestFullscreen=i,n=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=s+"FullscreenEnabled",t(document[i])?r.fullscreenEnabled=i:(i=s+"FullScreenEnabled",t(document[i])&&(r.fullscreenEnabled=i)),i=s+"FullscreenElement",t(document[i])?r.fullscreenElement=i:(i=s+"FullScreenElement",t(document[i])&&(r.fullscreenElement=i)),i=s+"fullscreenchange",t(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=s+"fullscreenerror",t(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(t){i.supportsFullscreen()&&t[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,e,n){"use strict";function r(t){for(var e=t.split("."),n=0,r=e.length;r>n;++n)e[n]=parseInt(e[n],10);return e}function i(){if(!e(p)){p=!1;var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(p=!0,v=r(t[1]))}return p}function a(){return i()&&v}function o(){if(!e(w)&&(w=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(w=!0,E=r(t[1]))}return w}function u(){return o()&&E}function s(){if(!e(x)){x=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==t&&(x=!0,g=r(t[1]),g.isNightly=!!t[2])}return x}function c(){return s()&&g}function l(){if(!e(S)){S=!1;var t;"Microsoft Internet Explorer"===navigator.appName?(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(S=!0,M=r(t[1]))):"Netscape"===navigator.appName&&(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(S=!0,M=r(t[1])))}return S}function f(){return l()&&M}function h(){if(!e(O)){O=!1;var t=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(O=!0,z=r(t[1]))}return O}function d(){return e(T)||(T=/Windows/i.test(navigator.appVersion)),T}function m(){return h()&&z}function y(){return e(_)||(_=e(window.PointerEvent)&&(!e(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),_}var p,v,w,E,x,g,S,M,O,z,T,_,I={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:m,isWindows:d,hardwareConcurrency:t(navigator.hardwareConcurrency,3),supportsPointerEvents:y};return I.supportsFullscreen=function(){return n.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(t,e,n,r,i){"use strict";if(!r.supportsTypedArrays())return{};var a={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return a.getSizeInBytes=function(t){switch(t){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(t){return t instanceof Int8Array?a.BYTE:t instanceof Uint8Array?a.UNSIGNED_BYTE:t instanceof Int16Array?a.SHORT:t instanceof Uint16Array?a.UNSIGNED_SHORT:t instanceof Float32Array?a.FLOAT:t instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(t){return e(t)&&(t===a.BYTE||t===a.UNSIGNED_BYTE||t===a.SHORT||t===a.UNSIGNED_SHORT||t===a.FLOAT||t===a.DOUBLE)},a.createTypedArray=function(t,e){switch(t){case a.BYTE:return new Int8Array(e);case a.UNSIGNED_BYTE:return new Uint8Array(e);case a.SHORT:return new Int16Array(e);case a.UNSIGNED_SHORT:return new Uint16Array(e);case a.FLOAT:return new Float32Array(e);case a.DOUBLE:return new Float64Array(e);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,r,i,o){switch(i=t(i,0),o=t(o,(r.byteLength-i)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(r,i,o);case a.UNSIGNED_BYTE:return new Uint8Array(r,i,o);case a.SHORT:return new Int16Array(r,i,o);case a.UNSIGNED_SHORT:return new Uint16Array(r,i,o);case a.FLOAT:return new Float32Array(r,i,o);case a.DOUBLE:return new Float64Array(r,i,o);default:throw new n("componentDatatype is not a valid value.")}},i(a)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";var e={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return t(e)}),define("Core/PrimitiveType",["./freezeObject"],function(t){"use strict";var e={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===e.POINTS||t===e.LINES||t===e.LINE_LOOP||t===e.LINE_STRIP||t===e.TRIANGLES||t===e.TRIANGLE_STRIP||t===e.TRIANGLE_FAN}};return t(e)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,e,n,r,i){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=t(e.primitiveType,i.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=t(e.geometryType,r.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(t){var r=-1;for(var i in t.attributes)if(t.attributes.hasOwnProperty(i)&&e(t.attributes[i])&&e(t.attributes[i].values)){var a=t.attributes[i],o=a.values.length/a.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=t(e.normalize,!1),this.values=e.values};return e}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";var e=function(e){e=t(e,t.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.binormal=e.binormal,this.tangent=e.tangent,this.color=e.color};return e}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r){"use strict";var i={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return i.getSizeInBytes=function(t){switch(t){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(t,e){return t>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},i.createTypedArrayFromArrayBuffer=function(t,e,n,i){return t>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(e,n,i):new Uint16Array(e,n,i)},n(i)}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,e,n,r){"use strict";var i=function(e){e=t(e,t.EMPTY_OBJECT),this.position=t(e.position,!1),this.normal=t(e.normal,!1),this.st=t(e.st,!1),this.binormal=t(e.binormal,!1),this.tangent=t(e.tangent,!1),this.color=t(e.color,!1)};return i.POSITION_ONLY=r(new i({position:!0})),i.POSITION_AND_NORMAL=r(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=r(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=r(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=r(new i({position:!0,color:!0})),i.ALL=r(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(e,n,r){r=t(r,0),n[r++]=e.position?1:0,n[r++]=e.normal?1:0,n[r++]=e.st?1:0,n[r++]=e.binormal?1:0,n[r++]=e.tangent?1:0,n[r++]=e.color?1:0
},i.unpack=function(n,r,a){return r=t(r,0),e(a)||(a=new i),a.position=1===n[r++],a.normal=1===n[r++],a.st=1===n[r++],a.binormal=1===n[r++],a.tangent=1===n[r++],a.color=1===n[r++],a},i.clone=function(t,n){return e(t)?(e(n)||(n=new i),n.position=t.position,n.normal=t.normal,n.st=t.st,n.binormal=t.binormal,n.tangent=t.tangent,n.color=t.color,n):void 0},i}),define("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(t,e,n,r,i,a,o,u,s,c,l,f,h,d,m){"use strict";var y=new n,p=new n,v=new n,w=new n,E=new n,x=new n(1,1,1),g=Math.cos,S=Math.sin,M=function(t){t=i(t,i.EMPTY_OBJECT);var e=i(t.radii,x),r=i(t.stackPartitions,64),a=i(t.slicePartitions,64),o=i(t.vertexFormat,m.DEFAULT);this._radii=n.clone(e),this._stackPartitions=r,this._slicePartitions=a,this._vertexFormat=m.clone(o),this._workerName="createEllipsoidGeometry"};M.packedLength=n.packedLength+m.packedLength+2,M.pack=function(t,e,r){r=i(r,0),n.pack(t._radii,e,r),r+=n.packedLength,m.pack(t._vertexFormat,e,r),r+=m.packedLength,e[r++]=t._stackPartitions,e[r]=t._slicePartitions};var O=new n,z=new m,T={radii:O,vertexFormat:z,stackPartitions:void 0,slicePartitions:void 0};return M.unpack=function(t,e,r){e=i(e,0);var o=n.unpack(t,e,O);e+=n.packedLength;var u=m.unpack(t,e,z);e+=m.packedLength;var s=t[e++],c=t[e];return a(r)?(r._radii=n.clone(o,r._radii),r._vertexFormat=m.clone(u,r._vertexFormat),r._stackPartitions=s,r._slicePartitions=c,r):(T.stackPartitions=s,T.slicePartitions=c,new M(T))},M.createGeometry=function(i){var a,o,m=i._radii,x=u.fromCartesian3(m),M=i._vertexFormat,O=i._slicePartitions+1,z=i._stackPartitions+1,T=z*O,_=new Float64Array(3*T),I=6*(O-1)*(z-1),N=f.createTypedArray(T,I),R=M.normal?new Float32Array(3*T):void 0,b=M.tangent?new Float32Array(3*T):void 0,A=M.binormal?new Float32Array(3*T):void 0,P=M.st?new Float32Array(2*T):void 0,C=new Array(O),L=new Array(O),q=0;for(a=0;O>a;a++){var U=h.TWO_PI*a/(O-1);C[a]=g(U),L[a]=S(U),_[q++]=0,_[q++]=0,_[q++]=m.z}for(a=1;z-1>a;a++){var D=Math.PI*a/(z-1),B=S(D),F=m.x*B,k=m.y*B,W=m.z*g(D);for(o=0;O>o;o++)_[q++]=C[o]*F,_[q++]=L[o]*k,_[q++]=W}for(a=0;O>a;a++)_[q++]=0,_[q++]=0,_[q++]=-m.z;var G=new l;M.position&&(G.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:_}));var V=0,Y=0,j=0,H=0;if(M.st||M.normal||M.tangent||M.binormal){for(a=0;T>a;a++){var Z=n.fromArray(_,3*a,y),X=x.geodeticSurfaceNormal(Z,p);if(M.st){var K=e.negate(X,E);e.magnitude(K)<h.EPSILON6&&(q=3*(a+O*Math.floor(.5*z)),q>_.length&&(q=3*(a-O*Math.floor(.5*z))),n.fromArray(_,q,K),x.geodeticSurfaceNormal(K,K),e.negate(K,K)),P[V++]=Math.atan2(K.y,K.x)/h.TWO_PI+.5,P[V++]=Math.asin(X.z)/Math.PI+.5}if(M.normal&&(R[Y++]=X.x,R[Y++]=X.y,R[Y++]=X.z),M.tangent||M.binormal){var J=v;if(O>a||a>T-O-1?(n.cross(n.UNIT_X,X,J),n.normalize(J,J)):(n.cross(n.UNIT_Z,X,J),n.normalize(J,J)),M.tangent&&(b[j++]=J.x,b[j++]=J.y,b[j++]=J.z),M.binormal){var Q=n.cross(X,J,w);n.normalize(Q,Q),A[H++]=Q.x,A[H++]=Q.y,A[H++]=Q.z}}}M.st&&(G.st=new c({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:P})),M.normal&&(G.normal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:R})),M.tangent&&(G.tangent=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:b})),M.binormal&&(G.binormal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:A}))}for(q=0,a=0;z>a;a++){var $=a*O,te=(a+1)*O;for(o=0;O-1>o;o++)N[q++]=te+o,N[q++]=te+o+1,N[q++]=$+o+1,N[q++]=te+o,N[q++]=$+o+1,N[q++]=$+o}return new s({attributes:G,indices:N,primitiveType:d.TRIANGLES,boundingSphere:t.fromEllipsoid(x)})},M}),define("Workers/createEllipsoidGeometry",["../Core/defined","../Core/EllipsoidGeometry"],function(t,e){"use strict";return function(n,r){return t(r)&&(n=e.unpack(n,r)),e.createGeometry(n)}})}();