/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var r=Object.freeze;return t(r)||(r=function(t){return t}),r}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var r=function(t,r){return void 0!==t?t:r};return r.EMPTY_OBJECT=t({}),r}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var r=function(t){this.name="DeveloperError",this.message=t;var r;try{throw new Error}catch(e){r=e.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return t(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var e;for(this.mti==this.N+1&&this.init_genrand(5489),e=0;e<this.N-this.M;e++)t=this.mt[e]&this.UPPER_MASK|this.mt[e+1]&this.LOWER_MASK,this.mt[e]=this.mt[e+this.M]^t>>>1^r[1&t];for(;e<this.N-1;e++)t=this.mt[e]&this.UPPER_MASK|this.mt[e+1]&this.LOWER_MASK,this.mt[e]=this.mt[e+(this.M-this.N)]^t>>>1^r[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^r[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,r){"use strict";var e={};e.EPSILON1=.1,e.EPSILON2=.01,e.EPSILON3=.001,e.EPSILON4=1e-4,e.EPSILON5=1e-5,e.EPSILON6=1e-6,e.EPSILON7=1e-7,e.EPSILON8=1e-8,e.EPSILON9=1e-9,e.EPSILON10=1e-10,e.EPSILON11=1e-11,e.EPSILON12=1e-12,e.EPSILON13=1e-13,e.EPSILON14=1e-14,e.EPSILON15=1e-15,e.EPSILON16=1e-16,e.EPSILON17=1e-17,e.EPSILON18=1e-18,e.EPSILON19=1e-19,e.EPSILON20=1e-20,e.GRAVITATIONALPARAMETER=3986004418e5,e.SOLAR_RADIUS=6955e5,e.LUNAR_RADIUS=1737400,e.SIXTY_FOUR_KILOBYTES=65536,e.sign=function(t){return t>0?1:0>t?-1:0},e.signNotZero=function(t){return 0>t?-1:1},e.toSNorm=function(t){return Math.round(255*(.5*e.clamp(t,-1,1)+.5))},e.fromSNorm=function(t){return 2*(e.clamp(t,0,255)/255)-1},e.sinh=function(t){var r=Math.pow(Math.E,t),e=Math.pow(Math.E,-1*t);return.5*(r-e)},e.cosh=function(t){var r=Math.pow(Math.E,t),e=Math.pow(Math.E,-1*t);return.5*(r+e)},e.lerp=function(t,r,e){return(1-e)*t+e*r},e.PI=Math.PI,e.ONE_OVER_PI=1/Math.PI,e.PI_OVER_TWO=.5*Math.PI,e.PI_OVER_THREE=Math.PI/3,e.PI_OVER_FOUR=Math.PI/4,e.PI_OVER_SIX=Math.PI/6,e.THREE_PI_OVER_TWO=.5*3*Math.PI,e.TWO_PI=2*Math.PI,e.ONE_OVER_TWO_PI=1/(2*Math.PI),e.RADIANS_PER_DEGREE=Math.PI/180,e.DEGREES_PER_RADIAN=180/Math.PI,e.RADIANS_PER_ARCSECOND=e.RADIANS_PER_DEGREE/3600,e.toRadians=function(t){return t*e.RADIANS_PER_DEGREE},e.toDegrees=function(t){return t*e.DEGREES_PER_RADIAN},e.convertLongitudeRange=function(t){var r=e.TWO_PI,n=t-Math.floor(t/r)*r;return n<-Math.PI?n+r:n>=Math.PI?n-r:n},e.negativePiToPi=function(t){return e.zeroToTwoPi(t+e.PI)-e.PI},e.zeroToTwoPi=function(t){var r=e.mod(t,e.TWO_PI);return Math.abs(r)<e.EPSILON14&&Math.abs(t)>e.EPSILON14?e.TWO_PI:r},e.mod=function(t,r){return(t%r+r)%r},e.equalsEpsilon=function(t,e,n,o){o=r(o,n);var i=Math.abs(t-e);return o>=i||i<=n*Math.max(Math.abs(t),Math.abs(e))};var n=[1];e.factorial=function(t){var r=n.length;if(t>=r)for(var e=n[r-1],o=r;t>=o;o++)n.push(e*o);return n[t]},e.incrementWrap=function(t,e,n){return n=r(n,0),++t,t>e&&(t=n),t},e.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},e.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},e.clamp=function(t,r,e){return r>t?r:t>e?e:t};var o=new t;return e.setRandomNumberSeed=function(r){o=new t(r)},e.nextRandomNumber=function(){return o.random()},e.acosClamped=function(t){return Math.acos(e.clamp(t,-1,1))},e.asinClamped=function(t){return Math.asin(e.clamp(t,-1,1))},e.chordLength=function(t,r){return 2*r*Math.sin(.5*t)},e}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n){this.x=t(r,0),this.y=t(e,0),this.z=t(n,0)};i.fromSpherical=function(e,n){r(n)||(n=new i);var o=e.clock,a=e.cone,s=t(e.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(t,e,n,o){return r(o)?(o.x=t,o.y=e,o.z=n,o):new i(t,e,n)},i.clone=function(t,e){return r(t)?r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e):new i(t.x,t.y,t.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(r,e,n){n=t(n,0),e[n++]=r.x,e[n++]=r.y,e[n]=r.z},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},i.minimumByComponent=function(t,r,e){return e.x=Math.min(t.x,r.x),e.y=Math.min(t.y,r.y),e.z=Math.min(t.z,r.z),e},i.maximumByComponent=function(t,r,e){return e.x=Math.max(t.x,r.x),e.y=Math.max(t.y,r.y),e.z=Math.max(t.z,r.z),e},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,r){return i.subtract(t,r,a),i.magnitude(a)},i.distanceSquared=function(t,r){return i.subtract(t,r,a),i.magnitudeSquared(a)},i.normalize=function(t,r){var e=i.magnitude(t);return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r},i.dot=function(t,r){return t.x*r.x+t.y*r.y+t.z*r.z},i.multiplyComponents=function(t,r,e){return e.x=t.x*r.x,e.y=t.y*r.y,e.z=t.z*r.z,e},i.add=function(t,r,e){return e.x=t.x+r.x,e.y=t.y+r.y,e.z=t.z+r.z,e},i.subtract=function(t,r,e){return e.x=t.x-r.x,e.y=t.y-r.y,e.z=t.z-r.z,e},i.multiplyByScalar=function(t,r,e){return e.x=t.x*r,e.y=t.y*r,e.z=t.z*r,e},i.divideByScalar=function(t,r,e){return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e},i.negate=function(t,r){return r.x=-t.x,r.y=-t.y,r.z=-t.z,r},i.abs=function(t,r){return r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new i;i.lerp=function(t,r,e,n){return i.multiplyByScalar(r,e,s),n=i.multiplyByScalar(t,1-e,n),i.add(s,n,n)};var u=new i,l=new i;i.angleBetween=function(t,r){i.normalize(t,u),i.normalize(r,l);var e=i.dot(u,l),n=i.magnitude(i.cross(u,l,u));return Math.atan2(n,e)};var c=new i;i.mostOrthogonalAxis=function(t,r){var e=i.normalize(t,c);return i.abs(e,e),r=e.x<=e.y?e.x<=e.z?i.clone(i.UNIT_X,r):i.clone(i.UNIT_Z,r):e.y<=e.z?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_Z,r)},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z},i.equalsArray=function(t,r,e){return t.x===r[e]&&t.y===r[e+1]&&t.z===r[e+2]},i.equalsEpsilon=function(t,e,n,i){return t===e||r(t)&&r(e)&&o.equalsEpsilon(t.x,e.x,n,i)&&o.equalsEpsilon(t.y,e.y,n,i)&&o.equalsEpsilon(t.z,e.z,n,i)},i.cross=function(t,r,e){var n=t.x,o=t.y,i=t.z,a=r.x,s=r.y,u=r.z,l=o*u-i*s,c=i*a-n*u,f=n*s-o*a;return e.x=l,e.y=c,e.z=f,e},i.fromDegrees=function(t,r,e,n,a){var s=o.toRadians(t),u=o.toRadians(r);return i.fromRadians(s,u,e,n,a)};var f=new i,h=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(e,n,o,a,s){o=t(o,0);var u=r(a)?a.radiiSquared:d,l=Math.cos(n);f.x=l*Math.cos(e),f.y=l*Math.sin(e),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(u,f,h);var c=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,c,h),f=i.multiplyByScalar(f,o,f),r(s)||(s=new i),i.add(h,f,s)},i.fromDegreesArray=function(t,r,e){for(var n=new Array(t.length),a=0;a<t.length;a++)n[a]=o.toRadians(t[a]);return i.fromRadiansArray(n,r,e)},i.fromRadiansArray=function(t,e,n){var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var s=t[a],u=t[a+1];n[a/2]=i.fromRadians(s,u,0,e,n[a/2])}return n},i.fromDegreesArrayHeights=function(t,r,e){for(var n=new Array(t.length),a=0;a<t.length;a+=3)n[a]=o.toRadians(t[a]),n[a+1]=o.toRadians(t[a+1]),n[a+2]=t[a+2];return i.fromRadiansArrayHeights(n,r,e)},i.fromRadiansArrayHeights=function(t,e,n){var o=t.length;r(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var s=t[a],u=t[a+1],l=t[a+2];n[a/3]=i.fromRadians(s,u,l,e,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r,e){return i.equalsEpsilon(this,t,r,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n){this.longitude=t(r,0),this.latitude=t(e,0),this.height=t(n,0)};return i.fromRadians=function(e,n,o,a){return o=t(o,0),r(a)?(a.longitude=e,a.latitude=n,a.height=o,a):new i(e,n,o)},i.fromDegrees=function(t,r,e,n){return t=o.toRadians(t),r=o.toRadians(r),i.fromRadians(t,r,e,n)},i.clone=function(t,e){return r(t)?r(e)?(e.longitude=t.longitude,e.latitude=t.latitude,e.height=t.height,e):new i(t.longitude,t.latitude,t.height):void 0},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.longitude===e.longitude&&t.latitude===e.latitude&&t.height===e.height},i.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t.longitude-e.longitude)<=n&&Math.abs(t.latitude-e.latitude)<=n&&Math.abs(t.height-e.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r){return i.equalsEpsilon(this,t,r)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(t){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),e=Object.defineProperties;return r&&t(e)||(e=function(t){return t}),e}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o,i,a,s){"use strict";function u(r,n,o,i){n=e(n,0),o=e(o,0),i=e(i,0),r._radii=new t(n,o,i),r._radiiSquared=new t(n*n,o*o,i*i),r._radiiToTheFourth=new t(n*n*n*n,o*o*o*o,i*i*i*i),r._oneOverRadii=new t(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),r._oneOverRadiiSquared=new t(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),r._minimumRadius=Math.min(n,o,i),r._maximumRadius=Math.max(n,o,i),r._centerToleranceSquared=s.EPSILON1}var l=function(t,r,e){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,t,r,e)};o(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(r,e){if(!n(r))return void 0;var o=r._radii;return n(e)?(t.clone(o,e._radii),t.clone(r._radiiSquared,e._radiiSquared),t.clone(r._radiiToTheFourth,e._radiiToTheFourth),t.clone(r._oneOverRadii,e._oneOverRadii),t.clone(r._oneOverRadiiSquared,e._oneOverRadiiSquared),e._minimumRadius=r._minimumRadius,e._maximumRadius=r._maximumRadius,e._centerToleranceSquared=r._centerToleranceSquared,e):new l(o.x,o.y,o.z)},l.fromCartesian3=function(t,r){return n(r)||(r=new l),n(t)?(u(r,t.x,t.y,t.z),r):r},l.WGS84=a(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=a(new l(1,1,1)),l.MOON=a(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(t){return l.clone(this,t)},l.packedLength=t.packedLength,l.pack=function(r,n,o){o=e(o,0),t.pack(r._radii,n,o)},l.unpack=function(r,n,o){n=e(n,0);var i=t.unpack(r,n);return l.fromCartesian3(i,o)},l.prototype.geocentricSurfaceNormal=t.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(r,e){var o=r.longitude,i=r.latitude,a=Math.cos(i),s=a*Math.cos(o),u=a*Math.sin(o),l=Math.sin(i);return n(e)||(e=new t),e.x=s,e.y=u,e.z=l,t.normalize(e,e)},l.prototype.geodeticSurfaceNormal=function(r,e){return n(e)||(e=new t),e=t.multiplyComponents(r,this._oneOverRadiiSquared,e),t.normalize(e,e)};var c=new t,f=new t;l.prototype.cartographicToCartesian=function(r,e){var o=c,i=f;this.geodeticSurfaceNormalCartographic(r,o),t.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(t.dot(o,i));return t.divideByScalar(i,a,i),t.multiplyByScalar(o,r.height,o),n(e)||(e=new t),t.add(i,o,e)},l.prototype.cartographicArrayToCartesianArray=function(t,r){var e=t.length;n(r)?r.length=e:r=new Array(e);for(var o=0;e>o;o++)r[o]=this.cartographicToCartesian(t[o],r[o]);return r};var h=new t,d=new t,m=new t;l.prototype.cartesianToCartographic=function(e,o){var i=this.scaleToGeodeticSurface(e,d);if(!n(i))return void 0;var a=this.geodeticSurfaceNormal(i,h),u=t.subtract(e,i,m),l=Math.atan2(a.y,a.x),c=Math.asin(a.z),f=s.sign(t.dot(u,e))*t.magnitude(u);return n(o)?(o.longitude=l,o.latitude=c,o.height=f,o):new r(l,c,f)},l.prototype.cartesianArrayToCartographicArray=function(t,r){var e=t.length;n(r)?r.length=e:r=new Array(e);for(var o=0;e>o;++o)r[o]=this.cartesianToCartographic(t[o],r[o]);return r};var p=new t,g=new t;return l.prototype.scaleToGeodeticSurface=function(r,e){var o=r.x,i=r.y,a=r.z,u=this._oneOverRadii,l=u.x,c=u.y,f=u.z,h=o*o*l*l,d=i*i*c*c,m=a*a*f*f,E=h+d+m,y=Math.sqrt(1/E),v=t.multiplyByScalar(r,y,p);if(E<this._centerToleranceSquared)return isFinite(y)?t.clone(v,e):void 0;var C=this._oneOverRadiiSquared,S=C.x,w=C.y,M=C.z,R=g;R.x=2*v.x*S,R.y=2*v.y*w,R.z=2*v.z*M;var A,O,T,I,N,x,_,L,b,F,P,D=(1-y)*t.magnitude(r)/(.5*t.magnitude(R)),z=0;do{D-=z,T=1/(1+D*S),I=1/(1+D*w),N=1/(1+D*M),x=T*T,_=I*I,L=N*N,b=x*T,F=_*I,P=L*N,A=h*x+d*_+m*L-1,O=h*b*S+d*F*w+m*P*M;var B=-2*O;z=A/B}while(Math.abs(A)>s.EPSILON12);return n(e)?(e.x=o*T,e.y=i*I,e.z=a*N,e):new t(o*T,i*I,a*N)},l.prototype.scaleToGeocentricSurface=function(r,e){n(e)||(e=new t);var o=r.x,i=r.y,a=r.z,s=this._oneOverRadiiSquared,u=1/Math.sqrt(o*o*s.x+i*i*s.y+a*a*s.z);return t.multiplyByScalar(r,u,e)},l.prototype.transformPositionToScaledSpace=function(r,e){return n(e)||(e=new t),t.multiplyComponents(r,this._oneOverRadii,e)},l.prototype.transformPositionFromScaledSpace=function(r,e){return n(e)||(e=new t),t.multiplyComponents(r,this._radii,e)},l.prototype.equals=function(r){return this===r||n(r)&&t.equals(this._radii,r._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,r,e,n,o,i,a){"use strict";var s=function(t){this._ellipsoid=e(t,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,e){var o=this._semimajorAxis,i=r.longitude*o,a=r.latitude*o,s=r.height;return n(e)?(e.x=i,e.y=a,e.z=s,e):new t(i,a,s)},s.prototype.unproject=function(t,e){var o=this._oneOverSemimajorAxis,i=t.x*o,a=t.y*o,s=t.z;return n(e)?(e.longitude=i,e.latitude=a,e.height=s,e):new r(i,a,s)},s}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(r)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var r=function(r,e){this.start=t(r,0),this.stop=t(e,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o){"use strict";var i=function(r,e,n,o){this.x=t(r,0),this.y=t(e,0),this.z=t(n,0),this.w=t(o,0)};i.fromElements=function(t,e,n,o,a){return r(a)?(a.x=t,a.y=e,a.z=n,a.w=o,a):new i(t,e,n,o)},i.fromColor=function(t,e){return r(e)?(e.x=t.red,e.y=t.green,e.z=t.blue,e.w=t.alpha,e):new i(t.red,t.green,t.blue,t.alpha)},i.clone=function(t,e){return r(t)?r(e)?(e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e):new i(t.x,t.y,t.z,t.w):void 0},i.packedLength=4,i.pack=function(r,e,n){n=t(n,0),e[n++]=r.x,e[n++]=r.y,e[n++]=r.z,e[n]=r.w},i.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new i),o.x=e[n++],o.y=e[n++],o.z=e[n++],o.w=e[n],o},i.fromArray=i.unpack,i.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},i.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},i.minimumByComponent=function(t,r,e){return e.x=Math.min(t.x,r.x),e.y=Math.min(t.y,r.y),e.z=Math.min(t.z,r.z),e.w=Math.min(t.w,r.w),e},i.maximumByComponent=function(t,r,e){return e.x=Math.max(t.x,r.x),e.y=Math.max(t.y,r.y),e.z=Math.max(t.z,r.z),e.w=Math.max(t.w,r.w),e},i.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},i.magnitude=function(t){return Math.sqrt(i.magnitudeSquared(t))};var a=new i;i.distance=function(t,r){return i.subtract(t,r,a),i.magnitude(a)},i.distanceSquared=function(t,r){return i.subtract(t,r,a),i.magnitudeSquared(a)},i.normalize=function(t,r){var e=i.magnitude(t);return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r.w=t.w/e,r},i.dot=function(t,r){return t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},i.multiplyComponents=function(t,r,e){return e.x=t.x*r.x,e.y=t.y*r.y,e.z=t.z*r.z,e.w=t.w*r.w,e},i.add=function(t,r,e){return e.x=t.x+r.x,e.y=t.y+r.y,e.z=t.z+r.z,e.w=t.w+r.w,e},i.subtract=function(t,r,e){return e.x=t.x-r.x,e.y=t.y-r.y,e.z=t.z-r.z,e.w=t.w-r.w,e},i.multiplyByScalar=function(t,r,e){return e.x=t.x*r,e.y=t.y*r,e.z=t.z*r,e.w=t.w*r,e},i.divideByScalar=function(t,r,e){return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e.w=t.w/r,e},i.negate=function(t,r){return r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},i.abs=function(t,r){return r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new i;i.lerp=function(t,r,e,n){return i.multiplyByScalar(r,e,s),n=i.multiplyByScalar(t,1-e,n),i.add(s,n,n)};var u=new i;return i.mostOrthogonalAxis=function(t,r){var e=i.normalize(t,u);return i.abs(e,e),r=e.x<=e.y?e.x<=e.z?e.x<=e.w?i.clone(i.UNIT_X,r):i.clone(i.UNIT_W,r):e.z<=e.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r):e.y<=e.z?e.y<=e.w?i.clone(i.UNIT_Y,r):i.clone(i.UNIT_W,r):e.z<=e.w?i.clone(i.UNIT_Z,r):i.clone(i.UNIT_W,r)},i.equals=function(t,e){return t===e||r(t)&&r(e)&&t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},i.equalsArray=function(t,r,e){return t.x===r[e]&&t.y===r[e+1]&&t.z===r[e+2]&&t.w===r[e+3]},i.equalsEpsilon=function(t,e,n,i){return t===e||r(t)&&r(e)&&o.equalsEpsilon(t.x,e.x,n,i)&&o.equalsEpsilon(t.y,e.y,n,i)&&o.equalsEpsilon(t.z,e.z,n,i)&&o.equalsEpsilon(t.w,e.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(t){return i.clone(this,t)},i.prototype.equals=function(t){return i.equals(this,t)},i.prototype.equalsEpsilon=function(t,r,e){return i.equalsEpsilon(this,t,r,e)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n,o,i){"use strict";function a(t){for(var r=0,e=0;9>e;++e){var n=t[e];r+=n*n}return Math.sqrt(r)}function s(t){for(var r=0,e=0;3>e;++e){var n=t[l.getElementIndex(d[e],h[e])];r+=2*n*n}return Math.sqrt(r)}function u(t,r){for(var e=i.EPSILON15,n=0,o=1,a=0;3>a;++a){var s=Math.abs(t[l.getElementIndex(d[a],h[a])]);s>n&&(o=a,n=s)}var u=1,c=0,f=h[o],m=d[o];if(Math.abs(t[l.getElementIndex(m,f)])>e){var p,g=t[l.getElementIndex(m,m)],E=t[l.getElementIndex(f,f)],y=t[l.getElementIndex(m,f)],v=(g-E)/2/y;p=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),u=1/Math.sqrt(1+p*p),c=p*u}return r=l.clone(l.IDENTITY,r),r[l.getElementIndex(f,f)]=r[l.getElementIndex(m,m)]=u,r[l.getElementIndex(m,f)]=c,r[l.getElementIndex(f,m)]=-c,r}var l=function(t,e,n,o,i,a,s,u,l){this[0]=r(t,0),this[1]=r(o,0),this[2]=r(s,0),this[3]=r(e,0),this[4]=r(i,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(l,0)};l.packedLength=9,l.pack=function(t,e,n){n=r(n,0),e[n++]=t[0],e[n++]=t[1],e[n++]=t[2],e[n++]=t[3],e[n++]=t[4],e[n++]=t[5],e[n++]=t[6],e[n++]=t[7],e[n++]=t[8]},l.unpack=function(t,n,o){return n=r(n,0),e(o)||(o=new l),o[0]=t[n++],o[1]=t[n++],o[2]=t[n++],o[3]=t[n++],o[4]=t[n++],o[5]=t[n++],o[6]=t[n++],o[7]=t[n++],o[8]=t[n++],o},l.clone=function(t,r){return e(t)?e(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r):new l(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},l.fromArray=function(t,n,o){return n=r(n,0),e(o)||(o=new l),o[0]=t[n],o[1]=t[n+1],o[2]=t[n+2],o[3]=t[n+3],o[4]=t[n+4],o[5]=t[n+5],o[6]=t[n+6],o[7]=t[n+7],o[8]=t[n+8],o},l.fromColumnMajorArray=function(t,r){return l.clone(t,r)},l.fromRowMajorArray=function(t,r){return e(r)?(r[0]=t[0],r[1]=t[3],r[2]=t[6],r[3]=t[1],r[4]=t[4],r[5]=t[7],r[6]=t[2],r[7]=t[5],r[8]=t[8],r):new l(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},l.fromQuaternion=function(t,r){var n=t.x*t.x,o=t.x*t.y,i=t.x*t.z,a=t.x*t.w,s=t.y*t.y,u=t.y*t.z,c=t.y*t.w,f=t.z*t.z,h=t.z*t.w,d=t.w*t.w,m=n-s-f+d,p=2*(o-h),g=2*(i+c),E=2*(o+h),y=-n+s-f+d,v=2*(u-a),C=2*(i-c),S=2*(u+a),w=-n-s+f+d;return e(r)?(r[0]=m,r[1]=E,r[2]=C,r[3]=p,r[4]=y,r[5]=S,r[6]=g,r[7]=v,r[8]=w,r):new l(m,p,g,E,y,v,C,S,w)},l.fromScale=function(t,r){return e(r)?(r[0]=t.x,r[1]=0,r[2]=0,r[3]=0,r[4]=t.y,r[5]=0,r[6]=0,r[7]=0,r[8]=t.z,r):new l(t.x,0,0,0,t.y,0,0,0,t.z)},l.fromUniformScale=function(t,r){return e(r)?(r[0]=t,r[1]=0,r[2]=0,r[3]=0,r[4]=t,r[5]=0,r[6]=0,r[7]=0,r[8]=t,r):new l(t,0,0,0,t,0,0,0,t)},l.fromCrossProduct=function(t,r){return e(r)?(r[0]=0,r[1]=t.z,r[2]=-t.y,r[3]=-t.z,r[4]=0,r[5]=t.x,r[6]=t.y,r[7]=-t.x,r[8]=0,r):new l(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},l.fromRotationX=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new l(1,0,0,0,n,-o,0,o,n)},l.fromRotationY=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new l(n,0,o,0,1,0,-o,0,n)},l.fromRotationZ=function(t,r){var n=Math.cos(t),o=Math.sin(t);return e(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new l(n,-o,0,o,n,0,0,0,1)},l.toArray=function(t,r){return e(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},l.getElementIndex=function(t,r){return 3*t+r},l.getColumn=function(t,r,e){var n=3*r,o=t[n],i=t[n+1],a=t[n+2];return e.x=o,e.y=i,e.z=a,e},l.setColumn=function(t,r,e,n){n=l.clone(t,n);var o=3*r;return n[o]=e.x,n[o+1]=e.y,n[o+2]=e.z,n},l.getRow=function(t,r,e){var n=t[r],o=t[r+3],i=t[r+6];return e.x=n,e.y=o,e.z=i,e},l.setRow=function(t,r,e,n){return n=l.clone(t,n),n[r]=e.x,n[r+3]=e.y,n[r+6]=e.z,n};var c=new t;l.getScale=function(r,e){return e.x=t.magnitude(t.fromElements(r[0],r[1],r[2],c)),e.y=t.magnitude(t.fromElements(r[3],r[4],r[5],c)),e.z=t.magnitude(t.fromElements(r[6],r[7],r[8],c)),e};var f=new t;l.getMaximumScale=function(r){return l.getScale(r,f),t.maximumComponent(f)},l.multiply=function(t,r,e){var n=t[0]*r[0]+t[3]*r[1]+t[6]*r[2],o=t[1]*r[0]+t[4]*r[1]+t[7]*r[2],i=t[2]*r[0]+t[5]*r[1]+t[8]*r[2],a=t[0]*r[3]+t[3]*r[4]+t[6]*r[5],s=t[1]*r[3]+t[4]*r[4]+t[7]*r[5],u=t[2]*r[3]+t[5]*r[4]+t[8]*r[5],l=t[0]*r[6]+t[3]*r[7]+t[6]*r[8],c=t[1]*r[6]+t[4]*r[7]+t[7]*r[8],f=t[2]*r[6]+t[5]*r[7]+t[8]*r[8];return e[0]=n,e[1]=o,e[2]=i,e[3]=a,e[4]=s,e[5]=u,e[6]=l,e[7]=c,e[8]=f,e},l.add=function(t,r,e){return e[0]=t[0]+r[0],e[1]=t[1]+r[1],e[2]=t[2]+r[2],e[3]=t[3]+r[3],e[4]=t[4]+r[4],e[5]=t[5]+r[5],e[6]=t[6]+r[6],e[7]=t[7]+r[7],e[8]=t[8]+r[8],e},l.subtract=function(t,r,e){return e[0]=t[0]-r[0],e[1]=t[1]-r[1],e[2]=t[2]-r[2],e[3]=t[3]-r[3],e[4]=t[4]-r[4],e[5]=t[5]-r[5],e[6]=t[6]-r[6],e[7]=t[7]-r[7],e[8]=t[8]-r[8],e},l.multiplyByVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[3]*o+t[6]*i,s=t[1]*n+t[4]*o+t[7]*i,u=t[2]*n+t[5]*o+t[8]*i;return e.x=a,e.y=s,e.z=u,e},l.multiplyByScalar=function(t,r,e){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*r,e[5]=t[5]*r,e[6]=t[6]*r,e[7]=t[7]*r,e[8]=t[8]*r,e},l.negate=function(t,r){return r[0]=-t[0],r[1]=-t[1],r[2]=-t[2],r[3]=-t[3],r[4]=-t[4],r[5]=-t[5],r[6]=-t[6],r[7]=-t[7],r[8]=-t[8],r},l.transpose=function(t,r){var e=t[0],n=t[3],o=t[6],i=t[1],a=t[4],s=t[7],u=t[2],l=t[5],c=t[8];return r[0]=e,r[1]=n,r[2]=o,r[3]=i,r[4]=a,r[5]=s,r[6]=u,r[7]=l,r[8]=c,r};var h=[1,0,0],d=[2,2,1],m=new l,p=new l;return l.computeEigenDecomposition=function(t,r){var n=i.EPSILON20,o=10,c=0,f=0;e(r)||(r={});for(var h=r.unitary=l.clone(l.IDENTITY,r.unitary),d=r.diagonal=l.clone(t,r.diagonal),g=n*a(d);o>f&&s(d)>g;)u(d,m),l.transpose(m,p),l.multiply(d,m,d),l.multiply(p,d,d),l.multiply(h,m,h),++c>2&&(++f,c=0);return r},l.abs=function(t,r){return r[0]=Math.abs(t[0]),r[1]=Math.abs(t[1]),r[2]=Math.abs(t[2]),r[3]=Math.abs(t[3]),r[4]=Math.abs(t[4]),r[5]=Math.abs(t[5]),r[6]=Math.abs(t[6]),r[7]=Math.abs(t[7]),r[8]=Math.abs(t[8]),r},l.determinant=function(t){var r=t[0],e=t[3],n=t[6],o=t[1],i=t[4],a=t[7],s=t[2],u=t[5],l=t[8];return r*(i*l-u*a)+o*(u*n-e*l)+s*(e*a-i*n)},l.inverse=function(t,r){var e=t[0],o=t[1],a=t[2],s=t[3],u=t[4],c=t[5],f=t[6],h=t[7],d=t[8],m=l.determinant(t);if(Math.abs(m)<=i.EPSILON15)throw new n("matrix is not invertible");r[0]=u*d-h*c,r[1]=h*a-o*d,r[2]=o*c-u*a,r[3]=f*c-s*d,r[4]=e*d-f*a,r[5]=s*a-e*c,r[6]=s*h-f*u,r[7]=f*o-e*h,r[8]=e*u-s*o;var p=1/m;return l.multiplyByScalar(r,p,r)},l.equals=function(t,r){return t===r||e(t)&&e(r)&&t[0]===r[0]&&t[1]===r[1]&&t[2]===r[2]&&t[3]===r[3]&&t[4]===r[4]&&t[5]===r[5]&&t[6]===r[6]&&t[7]===r[7]&&t[8]===r[8]},l.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t[0]-r[0])<=n&&Math.abs(t[1]-r[1])<=n&&Math.abs(t[2]-r[2])<=n&&Math.abs(t[3]-r[3])<=n&&Math.abs(t[4]-r[4])<=n&&Math.abs(t[5]-r[5])<=n&&Math.abs(t[6]-r[6])<=n&&Math.abs(t[7]-r[7])<=n&&Math.abs(t[8]-r[8])<=n},l.IDENTITY=o(new l(1,0,0,0,1,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(t){return l.clone(this,t)},l.prototype.equals=function(t){return l.equals(this,t)},l.equalsArray=function(t,r,e){return t[0]===r[e]&&t[1]===r[e+1]&&t[2]===r[e+2]&&t[3]===r[e+3]&&t[4]===r[e+4]&&t[5]===r[e+5]&&t[6]===r[e+6]&&t[7]===r[e+7]&&t[8]===r[e+8]},l.prototype.equalsEpsilon=function(t,r){return l.equalsEpsilon(this,t,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var r=function(t){this.name="RuntimeError",this.message=t;var r;try{throw new Error}catch(e){r=e.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return t(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,r,e,n,o,i,a,s,u){"use strict";var l=function(t,r,n,o,i,a,s,u,l,c,f,h,d,m,p,g){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(l,0),this[3]=e(d,0),this[4]=e(r,0),this[5]=e(a,0),this[6]=e(c,0),this[7]=e(m,0),this[8]=e(n,0),this[9]=e(s,0),this[10]=e(f,0),this[11]=e(p,0),this[12]=e(o,0),this[13]=e(u,0),this[14]=e(h,0),this[15]=e(g,0)};l.packedLength=16,l.pack=function(t,r,n){n=e(n,0),r[n++]=t[0],r[n++]=t[1],r[n++]=t[2],r[n++]=t[3],r[n++]=t[4],r[n++]=t[5],r[n++]=t[6],r[n++]=t[7],r[n++]=t[8],r[n++]=t[9],r[n++]=t[10],r[n++]=t[11],r[n++]=t[12],r[n++]=t[13],r[n++]=t[14],r[n]=t[15]},l.unpack=function(t,r,o){return r=e(r,0),n(o)||(o=new l),o[0]=t[r++],o[1]=t[r++],o[2]=t[r++],o[3]=t[r++],o[4]=t[r++],o[5]=t[r++],o[6]=t[r++],o[7]=t[r++],o[8]=t[r++],o[9]=t[r++],o[10]=t[r++],o[11]=t[r++],o[12]=t[r++],o[13]=t[r++],o[14]=t[r++],o[15]=t[r],o},l.clone=function(t,r){return n(t)?n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r):new l(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(t,r){return l.clone(t,r)},l.fromRowMajorArray=function(t,r){return n(r)?(r[0]=t[0],r[1]=t[4],r[2]=t[8],r[3]=t[12],r[4]=t[1],r[5]=t[5],r[6]=t[9],r[7]=t[13],r[8]=t[2],r[9]=t[6],r[10]=t[10],r[11]=t[14],r[12]=t[3],r[13]=t[7],r[14]=t[11],r[15]=t[15],r):new l(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},l.fromRotationTranslation=function(r,o,i){return o=e(o,t.ZERO),n(i)?(i[0]=r[0],i[1]=r[1],i[2]=r[2],i[3]=0,i[4]=r[3],i[5]=r[4],i[6]=r[5],i[7]=0,i[8]=r[6],i[9]=r[7],i[10]=r[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new l(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(t,r,e,o){n(o)||(o=new l);var i=e.x,a=e.y,s=e.z,u=r.x*r.x,c=r.x*r.y,f=r.x*r.z,h=r.x*r.w,d=r.y*r.y,m=r.y*r.z,p=r.y*r.w,g=r.z*r.z,E=r.z*r.w,y=r.w*r.w,v=u-d-g+y,C=2*(c-E),S=2*(f+p),w=2*(c+E),M=-u+d-g+y,R=2*(m-h),A=2*(f-p),O=2*(m+h),T=-u-d+g+y;return o[0]=v*i,o[1]=w*i,o[2]=A*i,o[3]=0,o[4]=C*a,o[5]=M*a,o[6]=O*a,o[7]=0,o[8]=S*s,o[9]=R*s,o[10]=T*s,o[11]=0,o[12]=t.x,o[13]=t.y,o[14]=t.z,o[15]=1,o},l.fromTranslation=function(t,r){return l.fromRotationTranslation(s.IDENTITY,t,r)},l.fromScale=function(t,r){return n(r)?(r[0]=t.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=t.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=t.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},l.fromUniformScale=function(t,r){return n(r)?(r[0]=t,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=t,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=t,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var c=new t,f=new t,h=new t;l.fromCamera=function(r,e){var o=r.eye,i=r.target,a=r.up;t.normalize(t.subtract(i,o,c),c),t.normalize(t.cross(c,a,f),f),t.normalize(t.cross(f,c,h),h);var s=f.x,u=f.y,d=f.z,m=c.x,p=c.y,g=c.z,E=h.x,y=h.y,v=h.z,C=o.x,S=o.y,w=o.z,M=s*-C+u*-S+d*-w,R=E*-C+y*-S+v*-w,A=m*C+p*S+g*w;return n(e)?(e[0]=s,e[1]=E,e[2]=-m,e[3]=0,e[4]=u,e[5]=y,e[6]=-p,e[7]=0,e[8]=d,e[9]=v,e[10]=-g,e[11]=0,e[12]=M,e[13]=R,e[14]=A,e[15]=1,e):new l(s,u,d,M,E,y,v,R,-m,-p,-g,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(t,r,e,n,o){var i=Math.tan(.5*t),a=1/i,s=a/r,u=(n+e)/(e-n),l=2*n*e/(e-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=u,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o},l.computeOrthographicOffCenter=function(t,r,e,n,o,i,a){var s=1/(r-t),u=1/(n-e),l=1/(i-o),c=-(r+t)*s,f=-(n+e)*u,h=-(i+o)*l;return s*=2,u*=2,l*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=0,a[12]=c,a[13]=f,a[14]=h,a[15]=1,a},l.computePerspectiveOffCenter=function(t,r,e,n,o,i,a){var s=2*o/(r-t),u=2*o/(n-e),l=(r+t)/(r-t),c=(n+e)/(n-e),f=-(i+o)/(i-o),h=-1,d=-2*i*o/(i-o);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=l,a[9]=c,a[10]=f,a[11]=h,a[12]=0,a[13]=0,a[14]=d,a[15]=0,a},l.computeInfinitePerspectiveOffCenter=function(t,r,e,n,o,i){var a=2*o/(r-t),s=2*o/(n-e),u=(r+t)/(r-t),l=(n+e)/(n-e),c=-1,f=-1,h=-2*o;
return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=u,i[9]=l,i[10]=c,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},l.computeViewportTransformation=function(t,r,n,o){t=e(t,e.EMPTY_OBJECT);var i=e(t.x,0),a=e(t.y,0),s=e(t.width,0),u=e(t.height,0);r=e(r,0),n=e(n,1);var l=.5*s,c=.5*u,f=.5*(n-r),h=l,d=c,m=f,p=i+l,g=a+c,E=r+f,y=1;return o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=m,o[11]=0,o[12]=p,o[13]=g,o[14]=E,o[15]=y,o},l.toArray=function(t,r){return n(r)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},l.getElementIndex=function(t,r){return 4*t+r},l.getColumn=function(t,r,e){var n=4*r,o=t[n],i=t[n+1],a=t[n+2],s=t[n+3];return e.x=o,e.y=i,e.z=a,e.w=s,e},l.setColumn=function(t,r,e,n){n=l.clone(t,n);var o=4*r;return n[o]=e.x,n[o+1]=e.y,n[o+2]=e.z,n[o+3]=e.w,n},l.getRow=function(t,r,e){var n=t[r],o=t[r+4],i=t[r+8],a=t[r+12];return e.x=n,e.y=o,e.z=i,e.w=a,e},l.setRow=function(t,r,e,n){return n=l.clone(t,n),n[r]=e.x,n[r+4]=e.y,n[r+8]=e.z,n[r+12]=e.w,n};var d=new t;l.getScale=function(r,e){return e.x=t.magnitude(t.fromElements(r[0],r[1],r[2],d)),e.y=t.magnitude(t.fromElements(r[4],r[5],r[6],d)),e.z=t.magnitude(t.fromElements(r[8],r[9],r[10],d)),e};var m=new t;l.getMaximumScale=function(r){return l.getScale(r,m),t.maximumComponent(m)},l.multiply=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[3],s=t[4],u=t[5],l=t[6],c=t[7],f=t[8],h=t[9],d=t[10],m=t[11],p=t[12],g=t[13],E=t[14],y=t[15],v=r[0],C=r[1],S=r[2],w=r[3],M=r[4],R=r[5],A=r[6],O=r[7],T=r[8],I=r[9],N=r[10],x=r[11],_=r[12],L=r[13],b=r[14],F=r[15],P=n*v+s*C+f*S+p*w,D=o*v+u*C+h*S+g*w,z=i*v+l*C+d*S+E*w,B=a*v+c*C+m*S+y*w,U=n*M+s*R+f*A+p*O,q=o*M+u*R+h*A+g*O,G=i*M+l*R+d*A+E*O,W=a*M+c*R+m*A+y*O,Y=n*T+s*I+f*N+p*x,H=o*T+u*I+h*N+g*x,k=i*T+l*I+d*N+E*x,V=a*T+c*I+m*N+y*x,K=n*_+s*L+f*b+p*F,j=o*_+u*L+h*b+g*F,Z=i*_+l*L+d*b+E*F,Q=a*_+c*L+m*b+y*F;return e[0]=P,e[1]=D,e[2]=z,e[3]=B,e[4]=U,e[5]=q,e[6]=G,e[7]=W,e[8]=Y,e[9]=H,e[10]=k,e[11]=V,e[12]=K,e[13]=j,e[14]=Z,e[15]=Q,e},l.add=function(t,r,e){return e[0]=t[0]+r[0],e[1]=t[1]+r[1],e[2]=t[2]+r[2],e[3]=t[3]+r[3],e[4]=t[4]+r[4],e[5]=t[5]+r[5],e[6]=t[6]+r[6],e[7]=t[7]+r[7],e[8]=t[8]+r[8],e[9]=t[9]+r[9],e[10]=t[10]+r[10],e[11]=t[11]+r[11],e[12]=t[12]+r[12],e[13]=t[13]+r[13],e[14]=t[14]+r[14],e[15]=t[15]+r[15],e},l.subtract=function(t,r,e){return e[0]=t[0]-r[0],e[1]=t[1]-r[1],e[2]=t[2]-r[2],e[3]=t[3]-r[3],e[4]=t[4]-r[4],e[5]=t[5]-r[5],e[6]=t[6]-r[6],e[7]=t[7]-r[7],e[8]=t[8]-r[8],e[9]=t[9]-r[9],e[10]=t[10]-r[10],e[11]=t[11]-r[11],e[12]=t[12]-r[12],e[13]=t[13]-r[13],e[14]=t[14]-r[14],e[15]=t[15]-r[15],e},l.multiplyTransformation=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],l=t[8],c=t[9],f=t[10],h=t[12],d=t[13],m=t[14],p=r[0],g=r[1],E=r[2],y=r[4],v=r[5],C=r[6],S=r[8],w=r[9],M=r[10],R=r[12],A=r[13],O=r[14],T=n*p+a*g+l*E,I=o*p+s*g+c*E,N=i*p+u*g+f*E,x=n*y+a*v+l*C,_=o*y+s*v+c*C,L=i*y+u*v+f*C,b=n*S+a*w+l*M,F=o*S+s*w+c*M,P=i*S+u*w+f*M,D=n*R+a*A+l*O+h,z=o*R+s*A+c*O+d,B=i*R+u*A+f*O+m;return e[0]=T,e[1]=I,e[2]=N,e[3]=0,e[4]=x,e[5]=_,e[6]=L,e[7]=0,e[8]=b,e[9]=F,e[10]=P,e[11]=0,e[12]=D,e[13]=z,e[14]=B,e[15]=1,e},l.multiplyByMatrix3=function(t,r,e){var n=t[0],o=t[1],i=t[2],a=t[4],s=t[5],u=t[6],l=t[8],c=t[9],f=t[10],h=r[0],d=r[1],m=r[2],p=r[3],g=r[4],E=r[5],y=r[6],v=r[7],C=r[8],S=n*h+a*d+l*m,w=o*h+s*d+c*m,M=i*h+u*d+f*m,R=n*p+a*g+l*E,A=o*p+s*g+c*E,O=i*p+u*g+f*E,T=n*y+a*v+l*C,I=o*y+s*v+c*C,N=i*y+u*v+f*C;return e[0]=S,e[1]=w,e[2]=M,e[3]=0,e[4]=R,e[5]=A,e[6]=O,e[7]=0,e[8]=T,e[9]=I,e[10]=N,e[11]=0,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},l.multiplyByTranslation=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=n*t[0]+o*t[4]+i*t[8]+t[12],s=n*t[1]+o*t[5]+i*t[9]+t[13],u=n*t[2]+o*t[6]+i*t[10]+t[14];return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=a,e[13]=s,e[14]=u,e[15]=t[15],e};var p=new t;l.multiplyByUniformScale=function(t,r,e){return p.x=r,p.y=r,p.z=r,l.multiplyByScale(t,p,e)},l.multiplyByScale=function(t,r,e){var n=r.x,o=r.y,i=r.z;return 1===n&&1===o&&1===i?l.clone(t,e):(e[0]=n*t[0],e[1]=n*t[1],e[2]=n*t[2],e[3]=0,e[4]=o*t[4],e[5]=o*t[5],e[6]=o*t[6],e[7]=0,e[8]=i*t[8],e[9]=i*t[9],e[10]=i*t[10],e[11]=0,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=1,e)},l.multiplyByVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=r.w,s=t[0]*n+t[4]*o+t[8]*i+t[12]*a,u=t[1]*n+t[5]*o+t[9]*i+t[13]*a,l=t[2]*n+t[6]*o+t[10]*i+t[14]*a,c=t[3]*n+t[7]*o+t[11]*i+t[15]*a;return e.x=s,e.y=u,e.z=l,e.w=c,e},l.multiplyByPointAsVector=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[4]*o+t[8]*i,s=t[1]*n+t[5]*o+t[9]*i,u=t[2]*n+t[6]*o+t[10]*i;return e.x=a,e.y=s,e.z=u,e},l.multiplyByPoint=function(t,r,e){var n=r.x,o=r.y,i=r.z,a=t[0]*n+t[4]*o+t[8]*i+t[12],s=t[1]*n+t[5]*o+t[9]*i+t[13],u=t[2]*n+t[6]*o+t[10]*i+t[14];return e.x=a,e.y=s,e.z=u,e},l.multiplyByScalar=function(t,r,e){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*r,e[5]=t[5]*r,e[6]=t[6]*r,e[7]=t[7]*r,e[8]=t[8]*r,e[9]=t[9]*r,e[10]=t[10]*r,e[11]=t[11]*r,e[12]=t[12]*r,e[13]=t[13]*r,e[14]=t[14]*r,e[15]=t[15]*r,e},l.negate=function(t,r){return r[0]=-t[0],r[1]=-t[1],r[2]=-t[2],r[3]=-t[3],r[4]=-t[4],r[5]=-t[5],r[6]=-t[6],r[7]=-t[7],r[8]=-t[8],r[9]=-t[9],r[10]=-t[10],r[11]=-t[11],r[12]=-t[12],r[13]=-t[13],r[14]=-t[14],r[15]=-t[15],r},l.transpose=function(t,r){var e=t[1],n=t[2],o=t[3],i=t[6],a=t[7],s=t[11];return r[0]=t[0],r[1]=t[4],r[2]=t[8],r[3]=t[12],r[4]=e,r[5]=t[5],r[6]=t[9],r[7]=t[13],r[8]=n,r[9]=i,r[10]=t[10],r[11]=t[14],r[12]=o,r[13]=a,r[14]=s,r[15]=t[15],r},l.abs=function(t,r){return r[0]=Math.abs(t[0]),r[1]=Math.abs(t[1]),r[2]=Math.abs(t[2]),r[3]=Math.abs(t[3]),r[4]=Math.abs(t[4]),r[5]=Math.abs(t[5]),r[6]=Math.abs(t[6]),r[7]=Math.abs(t[7]),r[8]=Math.abs(t[8]),r[9]=Math.abs(t[9]),r[10]=Math.abs(t[10]),r[11]=Math.abs(t[11]),r[12]=Math.abs(t[12]),r[13]=Math.abs(t[13]),r[14]=Math.abs(t[14]),r[15]=Math.abs(t[15]),r},l.equals=function(t,r){return t===r||n(t)&&n(r)&&t[12]===r[12]&&t[13]===r[13]&&t[14]===r[14]&&t[0]===r[0]&&t[1]===r[1]&&t[2]===r[2]&&t[4]===r[4]&&t[5]===r[5]&&t[6]===r[6]&&t[8]===r[8]&&t[9]===r[9]&&t[10]===r[10]&&t[3]===r[3]&&t[7]===r[7]&&t[11]===r[11]&&t[15]===r[15]},l.equalsEpsilon=function(t,r,e){return t===r||n(t)&&n(r)&&Math.abs(t[0]-r[0])<=e&&Math.abs(t[1]-r[1])<=e&&Math.abs(t[2]-r[2])<=e&&Math.abs(t[3]-r[3])<=e&&Math.abs(t[4]-r[4])<=e&&Math.abs(t[5]-r[5])<=e&&Math.abs(t[6]-r[6])<=e&&Math.abs(t[7]-r[7])<=e&&Math.abs(t[8]-r[8])<=e&&Math.abs(t[9]-r[9])<=e&&Math.abs(t[10]-r[10])<=e&&Math.abs(t[11]-r[11])<=e&&Math.abs(t[12]-r[12])<=e&&Math.abs(t[13]-r[13])<=e&&Math.abs(t[14]-r[14])<=e&&Math.abs(t[15]-r[15])<=e},l.getTranslation=function(t,r){return r.x=t[12],r.y=t[13],r.z=t[14],r},l.getRotation=function(t,r){return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[4],r[4]=t[5],r[5]=t[6],r[6]=t[8],r[7]=t[9],r[8]=t[10],r};var g=new s,E=new s,y=new r,v=new r(0,0,0,1);return l.inverse=function(t,e){if(s.equalsEpsilon(l.getRotation(t,g),E,a.EPSILON7)&&r.equals(l.getRow(t,3,y),v))return e[0]=0,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=0,e[11]=0,e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=1,e;var n=t[0],o=t[4],i=t[8],c=t[12],f=t[1],h=t[5],d=t[9],m=t[13],p=t[2],C=t[6],S=t[10],w=t[14],M=t[3],R=t[7],A=t[11],O=t[15],T=S*O,I=w*A,N=C*O,x=w*R,_=C*A,L=S*R,b=p*O,F=w*M,P=p*A,D=S*M,z=p*R,B=C*M,U=T*h+x*d+_*m-(I*h+N*d+L*m),q=I*f+b*d+D*m-(T*f+F*d+P*m),G=N*f+F*h+z*m-(x*f+b*h+B*m),W=L*f+P*h+B*d-(_*f+D*h+z*d),Y=I*o+N*i+L*c-(T*o+x*i+_*c),H=T*n+F*i+P*c-(I*n+b*i+D*c),k=x*n+b*o+B*c-(N*n+F*o+z*c),V=_*n+D*o+z*i-(L*n+P*o+B*i);T=i*m,I=c*d,N=o*m,x=c*h,_=o*d,L=i*h,b=n*m,F=c*f,P=n*d,D=i*f,z=n*h,B=o*f;var K=T*R+x*A+_*O-(I*R+N*A+L*O),j=I*M+b*A+D*O-(T*M+F*A+P*O),Z=N*M+F*R+z*O-(x*M+b*R+B*O),Q=L*M+P*R+B*A-(_*M+D*R+z*A),X=N*S+L*w+I*C-(_*w+T*C+x*S),J=P*w+T*p+F*S-(b*S+D*w+I*p),$=b*C+B*w+x*p-(z*w+N*p+F*C),tr=z*S+_*p+D*C-(P*C+B*S+L*p),rr=n*U+o*q+i*G+c*W;if(Math.abs(rr)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return rr=1/rr,e[0]=U*rr,e[1]=q*rr,e[2]=G*rr,e[3]=W*rr,e[4]=Y*rr,e[5]=H*rr,e[6]=k*rr,e[7]=V*rr,e[8]=K*rr,e[9]=j*rr,e[10]=Z*rr,e[11]=Q*rr,e[12]=X*rr,e[13]=J*rr,e[14]=$*rr,e[15]=tr*rr,e},l.inverseTransformation=function(t,r){var e=t[0],n=t[1],o=t[2],i=t[4],a=t[5],s=t[6],u=t[8],l=t[9],c=t[10],f=t[12],h=t[13],d=t[14],m=-e*f-n*h-o*d,p=-i*f-a*h-s*d,g=-u*f-l*h-c*d;return r[0]=e,r[1]=i,r[2]=u,r[3]=0,r[4]=n,r[5]=a,r[6]=l,r[7]=0,r[8]=o,r[9]=s,r[10]=c,r[11]=0,r[12]=m,r[13]=p,r[14]=g,r[15]=1,r},l.IDENTITY=i(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(t){return l.clone(this,t)},l.prototype.equals=function(t){return l.equals(this,t)},l.equalsArray=function(t,r,e){return t[0]===r[e]&&t[1]===r[e+1]&&t[2]===r[e+2]&&t[3]===r[e+3]&&t[4]===r[e+4]&&t[5]===r[e+5]&&t[6]===r[e+6]&&t[7]===r[e+7]&&t[8]===r[e+8]&&t[9]===r[e+9]&&t[10]===r[e+10]&&t[11]===r[e+11]&&t[12]===r[e+12]&&t[13]===r[e+13]&&t[14]===r[e+14]&&t[15]===r[e+15]},l.prototype.equalsEpsilon=function(t,r){return l.equalsEpsilon(this,t,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,r,e,n,o,i,a,s){"use strict";var u=function(t,e,n,o){this.west=r(t,0),this.south=r(e,0),this.east=r(n,0),this.north=r(o,0)};n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(t,e,n){n=r(n,0),e[n++]=t.west,e[n++]=t.south,e[n++]=t.east,e[n]=t.north},u.unpack=function(t,n,o){return n=r(n,0),e(o)||(o=new u),o.west=t[n++],o.south=t[n++],o.east=t[n++],o.north=t[n],o},u.computeWidth=function(t){var r=t.east,e=t.west;return e>r&&(r+=s.TWO_PI),r-e},u.computeHeight=function(t){return t.north-t.south},u.fromDegrees=function(t,n,o,i,a){return t=s.toRadians(r(t,0)),n=s.toRadians(r(n,0)),o=s.toRadians(r(o,0)),i=s.toRadians(r(i,0)),e(a)?(a.west=t,a.south=n,a.east=o,a.north=i,a):new u(t,n,o,i)},u.fromCartographicArray=function(t,r){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=0,l=t.length;l>s;s++){var c=t[s];n=Math.min(n,c.longitude),o=Math.max(o,c.longitude),i=Math.min(i,c.latitude),a=Math.max(a,c.latitude)}return e(r)?(r.west=n,r.south=i,r.east=o,r.north=a,r):new u(n,i,o,a)},u.packedLength=4,u.pack=function(t,e,n){n=r(n,0),e[n++]=t.west,e[n++]=t.south,e[n++]=t.east,e[n]=t.north},u.unpack=function(t,n,o){return n=r(n,0),e(o)||(o=new u),o.west=t[n++],o.south=t[n++],o.east=t[n++],o.north=t[n],o},u.clone=function(t,r){return e(t)?e(r)?(r.west=t.west,r.south=t.south,r.east=t.east,r.north=t.north,r):new u(t.west,t.south,t.east,t.north):void 0},u.prototype.clone=function(t){return u.clone(this,t)},u.prototype.equals=function(t){return u.equals(this,t)},u.equals=function(t,r){return t===r||e(t)&&e(r)&&t.west===r.west&&t.south===r.south&&t.east===r.east&&t.north===r.north},u.prototype.equalsEpsilon=function(t,r){return e(t)&&Math.abs(this.west-t.west)<=r&&Math.abs(this.south-t.south)<=r&&Math.abs(this.east-t.east)<=r&&Math.abs(this.north-t.north)<=r},u.validate=function(){},u.southwest=function(r,n){return e(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new t(r.west,r.south)},u.northwest=function(r,n){return e(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new t(r.west,r.north)},u.northeast=function(r,n){return e(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new t(r.east,r.north)},u.southeast=function(r,n){return e(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new t(r.east,r.south)},u.center=function(r,n){var o=r.east,i=r.west;i>o&&(o+=s.TWO_PI);var a=s.negativePiToPi(.5*(i+o)),u=.5*(r.south+r.north);return e(n)?(n.longitude=a,n.latitude=u,n.height=0,n):new t(a,u)},u.intersection=function(t,r,n){var o=t.east,i=t.west,a=r.east,l=r.west;i>o&&a>0?o+=s.TWO_PI:l>a&&o>0&&(a+=s.TWO_PI),i>o&&0>l?l+=s.TWO_PI:l>a&&0>i&&(i+=s.TWO_PI);var c=s.negativePiToPi(Math.max(i,l)),f=s.negativePiToPi(Math.min(o,a));if((t.west<t.east||r.west<r.east)&&c>=f)return void 0;var h=Math.max(t.south,r.south),d=Math.min(t.north,r.north);return h>=d?void 0:e(n)?(n.west=c,n.south=h,n.east=f,n.north=d,n):new u(c,h,f,d)},u.contains=function(t,r){var e=r.longitude,n=r.latitude,o=t.west,i=t.east;return o>i&&(i+=s.TWO_PI,0>e&&(e+=s.TWO_PI)),(e>o||s.equalsEpsilon(e,o,s.EPSILON14))&&(i>e||s.equalsEpsilon(e,i,s.EPSILON14))&&n>=t.south&&n<=t.north};var l=new t;return u.subsample=function(t,n,o,a){n=r(n,i.WGS84),o=r(o,0),e(a)||(a=[]);var c=0,f=t.north,h=t.south,d=t.east,m=t.west,p=l;p.height=o,p.longitude=m,p.latitude=f,a[c]=n.cartographicToCartesian(p,a[c]),c++,p.longitude=d,a[c]=n.cartographicToCartesian(p,a[c]),c++,p.latitude=h,a[c]=n.cartographicToCartesian(p,a[c]),c++,p.longitude=m,a[c]=n.cartographicToCartesian(p,a[c]),c++,p.latitude=0>f?f:h>0?h:0;for(var g=1;8>g;++g)p.longitude=-Math.PI+g*s.PI_OVER_TWO,u.contains(t,p)&&(a[c]=n.cartographicToCartesian(p,a[c]),c++);return 0===p.latitude&&(p.longitude=m,a[c]=n.cartographicToCartesian(p,a[c]),c++,p.longitude=d,a[c]=n.cartographicToCartesian(p,a[c]),c++),a.length=c,a},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(t,r,e,n,o,i,a,s,u,l,c){"use strict";var f=function(r,n){this.center=t.clone(e(r,t.ZERO)),this.radius=e(n,0)},h=new t,d=new t,m=new t,p=new t,g=new t,E=new t,y=new t,v=new t,C=new t,S=new t,w=new t,M=new t;f.fromPoints=function(r,e){if(n(e)||(e=new f),!n(r)||0===r.length)return e.center=t.clone(t.ZERO,e.center),e.radius=0,e;for(var o=t.clone(r[0],y),i=t.clone(o,h),a=t.clone(o,d),s=t.clone(o,m),u=t.clone(o,p),l=t.clone(o,g),c=t.clone(o,E),R=r.length,A=1;R>A;A++){t.clone(r[A],o);var O=o.x,T=o.y,I=o.z;O<i.x&&t.clone(o,i),O>u.x&&t.clone(o,u),T<a.y&&t.clone(o,a),T>l.y&&t.clone(o,l),I<s.z&&t.clone(o,s),I>c.z&&t.clone(o,c)}var N=t.magnitudeSquared(t.subtract(u,i,v)),x=t.magnitudeSquared(t.subtract(l,a,v)),_=t.magnitudeSquared(t.subtract(c,s,v)),L=i,b=u,F=N;x>F&&(F=x,L=a,b=l),_>F&&(F=_,L=s,b=c);var P=C;P.x=.5*(L.x+b.x),P.y=.5*(L.y+b.y),P.z=.5*(L.z+b.z);var D=t.magnitudeSquared(t.subtract(b,P,v)),z=Math.sqrt(D),B=S;B.x=i.x,B.y=a.y,B.z=s.z;var U=w;U.x=u.x,U.y=l.y,U.z=c.z;var q=t.multiplyByScalar(t.add(B,U,v),.5,M),G=0;for(A=0;R>A;A++){t.clone(r[A],o);var W=t.magnitude(t.subtract(o,q,v));W>G&&(G=W);var Y=t.magnitudeSquared(t.subtract(o,P,v));if(Y>D){var H=Math.sqrt(Y);z=.5*(z+H),D=z*z;var k=H-z;P.x=(z*P.x+k*o.x)/H,P.y=(z*P.y+k*o.y)/H,P.z=(z*P.z+k*o.z)/H}}return G>z?(t.clone(P,e.center),e.radius=z):(t.clone(q,e.center),e.radius=G),e};var R=new a,A=new t,O=new t,T=new r,I=new r;f.fromRectangle2D=function(t,r,e){return f.fromRectangleWithHeights2D(t,r,0,0,e)},f.fromRectangleWithHeights2D=function(r,o,i,a,s){if(n(s)||(s=new f),!n(r))return s.center=t.clone(t.ZERO,s.center),s.radius=0,s;o=e(o,R),c.southwest(r,T),T.height=i,c.northeast(r,I),I.height=a;var u=o.project(T,A),l=o.project(I,O),h=l.x-u.x,d=l.y-u.y,m=l.z-u.z;s.radius=.5*Math.sqrt(h*h+d*d+m*m);var p=s.center;return p.x=u.x+.5*h,p.y=u.y+.5*d,p.z=u.z+.5*m,s};var N=[];f.fromRectangle3D=function(t,r,o,a){r=e(r,i.WGS84),o=e(o,0);var s;return n(t)&&(s=c.subsample(t,r,o,N)),f.fromPoints(s,a)},f.fromVertices=function(r,o,i,a){if(n(a)||(a=new f),!n(r)||0===r.length)return a.center=t.clone(t.ZERO,a.center),a.radius=0,a;o=e(o,t.ZERO),i=e(i,3);var s=y;s.x=r[0]+o.x,s.y=r[1]+o.y,s.z=r[2]+o.z;for(var u=t.clone(s,h),l=t.clone(s,d),c=t.clone(s,m),R=t.clone(s,p),A=t.clone(s,g),O=t.clone(s,E),T=r.length,I=0;T>I;I+=i){var N=r[I]+o.x,x=r[I+1]+o.y,_=r[I+2]+o.z;s.x=N,s.y=x,s.z=_,N<u.x&&t.clone(s,u),N>R.x&&t.clone(s,R),x<l.y&&t.clone(s,l),x>A.y&&t.clone(s,A),_<c.z&&t.clone(s,c),_>O.z&&t.clone(s,O)}var L=t.magnitudeSquared(t.subtract(R,u,v)),b=t.magnitudeSquared(t.subtract(A,l,v)),F=t.magnitudeSquared(t.subtract(O,c,v)),P=u,D=R,z=L;b>z&&(z=b,P=l,D=A),F>z&&(z=F,P=c,D=O);var B=C;B.x=.5*(P.x+D.x),B.y=.5*(P.y+D.y),B.z=.5*(P.z+D.z);var U=t.magnitudeSquared(t.subtract(D,B,v)),q=Math.sqrt(U),G=S;G.x=u.x,G.y=l.y,G.z=c.z;var W=w;W.x=R.x,W.y=A.y,W.z=O.z;var Y=t.multiplyByScalar(t.add(G,W,v),.5,M),H=0;for(I=0;T>I;I+=i){s.x=r[I]+o.x,s.y=r[I+1]+o.y,s.z=r[I+2]+o.z;var k=t.magnitude(t.subtract(s,Y,v));k>H&&(H=k);var V=t.magnitudeSquared(t.subtract(s,B,v));if(V>U){var K=Math.sqrt(V);q=.5*(q+K),U=q*q;var j=K-q;B.x=(q*B.x+j*s.x)/K,B.y=(q*B.y+j*s.y)/K,B.z=(q*B.z+j*s.z)/K}}return H>q?(t.clone(B,a.center),a.radius=q):(t.clone(Y,a.center),a.radius=H),a},f.fromCornerPoints=function(r,e,o){n(o)||(o=new f);var i=o.center;return t.add(r,e,i),t.multiplyByScalar(i,.5,i),o.radius=t.distance(i,e),o},f.fromEllipsoid=function(r,e){return n(e)||(e=new f),t.clone(t.ZERO,e.center),e.radius=r.maximumRadius,e};var x=new t;f.fromBoundingSpheres=function(r,e){if(n(e)||(e=new f),!n(r)||0===r.length)return e.center=t.clone(t.ZERO,e.center),e.radius=0,e;var o=r.length;if(1===o)return f.clone(r[0],e);if(2===o)return f.union(r[0],r[1],e);for(var i=[],a=0;o>a;a++)i.push(r[a].center);e=f.fromPoints(i,e);var s=e.center,u=e.radius;for(a=0;o>a;a++){var l=r[a];u=Math.max(u,t.distance(s,l.center,x)+l.radius)}return e.radius=u,e},f.clone=function(r,e){return n(r)?n(e)?(e.center=t.clone(r.center,e.center),e.radius=r.radius,e):new f(r.center,r.radius):void 0},f.packedLength=4,f.pack=function(t,r,n){n=e(n,0);var o=t.center;r[n++]=o.x,r[n++]=o.y,r[n++]=o.z,r[n]=t.radius},f.unpack=function(t,r,o){r=e(r,0),n(o)||(o=new f);var i=o.center;return i.x=t[r++],i.y=t[r++],i.z=t[r++],o.radius=t[r],o};var _=new t,L=new t;f.union=function(r,e,o){n(o)||(o=new f);var i=r.center,a=e.center;t.add(i,a,L);var s=t.multiplyByScalar(L,.5,L),u=t.magnitude(t.subtract(i,s,_))+r.radius,l=t.magnitude(t.subtract(a,s,_))+e.radius;return o.radius=Math.max(u,l),t.clone(s,o.center),o};var b=new t;f.expand=function(r,e,n){n=f.clone(r,n);var o=t.magnitude(t.subtract(e,n.center,b));return o>n.radius&&(n.radius=o),n},f.intersect=function(r,e){var n=r.center,o=r.radius,i=t.dot(e,n)+e.w;return-o>i?s.OUTSIDE:o>i?s.INTERSECTING:s.INSIDE},f.transform=function(t,r,e){return n(e)||(e=new f),e.center=l.multiplyByPoint(r,t.center,e.center),e.radius=l.getMaximumScale(r)*t.radius,e};var F=new t;f.distanceSquaredTo=function(r,e){var n=t.subtract(r.center,e,F);return t.magnitudeSquared(n)-r.radius*r.radius},f.transformWithoutScale=function(t,r,e){return n(e)||(e=new f),e.center=l.multiplyByPoint(r,t.center,e.center),e.radius=t.radius,e};var P=new t;f.computePlaneDistances=function(r,e,o,i){n(i)||(i=new u);var a=t.subtract(r.center,e,P),s=t.multiplyByScalar(o,t.dot(o,a),P),l=t.magnitude(s);return i.start=l-r.radius,i.stop=l+r.radius,i};for(var D=new t,z=new t,B=new t,U=new t,q=new t,G=new r,W=new Array(8),Y=0;8>Y;++Y)W[Y]=new t;var H=new a;return f.projectTo2D=function(r,n,o){n=e(n,H);var i=n.ellipsoid,a=r.center,s=r.radius,u=i.geodeticSurfaceNormal(a,D),l=t.cross(t.UNIT_Z,u,z);t.normalize(l,l);var c=t.cross(u,l,B);t.normalize(c,c),t.multiplyByScalar(u,s,u),t.multiplyByScalar(c,s,c),t.multiplyByScalar(l,s,l);var h=t.negate(c,q),d=t.negate(l,U),m=W,p=m[0];t.add(u,c,p),t.add(p,l,p),p=m[1],t.add(u,c,p),t.add(p,d,p),p=m[2],t.add(u,h,p),t.add(p,d,p),p=m[3],t.add(u,h,p),t.add(p,l,p),t.negate(u,u),p=m[4],t.add(u,c,p),t.add(p,l,p),p=m[5],t.add(u,c,p),t.add(p,d,p),p=m[6],t.add(u,h,p),t.add(p,d,p),p=m[7],t.add(u,h,p),t.add(p,l,p);for(var g=m.length,E=0;g>E;++E){var y=m[E];t.add(a,y,y);var v=i.cartesianToCartographic(y,G);n.project(v,y)}o=f.fromPoints(m,o),a=o.center;var C=a.x,S=a.y,w=a.z;return a.x=w,a.y=C,a.z=S,o},f.equals=function(r,e){return r===e||n(r)&&n(e)&&t.equals(r.center,e.center)&&r.radius===e.radius},f.prototype.intersect=function(t){return f.intersect(this,t)},f.prototype.equals=function(t){return f.equals(this,t)},f.prototype.clone=function(t){return f.clone(this,t)},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(t,r){"use strict";var e,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return r(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(t(e))return e;e=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",e=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;s>a;++a){var u=i[a];o=u+"RequestFullscreen","function"==typeof r[o]?(n.requestFullscreen=o,e=!0):(o=u+"RequestFullScreen","function"==typeof r[o]&&(n.requestFullscreen=o,e=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",t(document[o])?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",t(document[o])&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",t(document[o])?n.fullscreenElement=o:(o=u+"FullScreenElement",t(document[o])&&(n.fullscreenElement=o)),o=u+"fullscreenchange",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",t(document["on"+o])&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return e},o.requestFullscreen=function(t){o.supportsFullscreen()&&t[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(t,r,e){"use strict";function n(t){for(var r=t.split("."),e=0,n=r.length;n>e;++e)r[e]=parseInt(r[e],10);return r}function o(){if(!r(g)){g=!1;var t=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(g=!0,E=n(t[1]))}return g}function i(){return o()&&E}function a(){if(!r(y)&&(y=!1,!o()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var t=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(y=!0,v=n(t[1]))}return y}function s(){return a()&&v}function u(){if(!r(C)){C=!1;var t=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==t&&(C=!0,S=n(t[1]),S.isNightly=!!t[2])}return C}function l(){return u()&&S}function c(){if(!r(w)){w=!1;var t;"Microsoft Internet Explorer"===navigator.appName?(t=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(w=!0,M=n(t[1]))):"Netscape"===navigator.appName&&(t=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==t&&(w=!0,M=n(t[1])))}return w}function f(){return c()&&M}function h(){if(!r(R)){R=!1;var t=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==t&&(R=!0,A=n(t[1]))}return R}function d(){return r(O)||(O=/Windows/i.test(navigator.appVersion)),O}function m(){return h()&&A}function p(){return r(T)||(T=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),T}var g,E,y,v,C,S,w,M,R,A,O,T,I={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:l,isInternetExplorer:c,internetExplorerVersion:f,isFirefox:h,firefoxVersion:m,isWindows:d,hardwareConcurrency:t(navigator.hardwareConcurrency,3),supportsPointerEvents:p};return I.supportsFullscreen=function(){return e.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(t,r,e,n,o,i){"use strict";function a(t,r,e){return 0>e&&(e+=1),e>1&&(e-=1),1>6*e?t+6*(r-t)*e:1>2*e?r:2>3*e?t+6*(r-t)*(2/3-e):t}var s=function(r,e,n,o){this.red=t(r,1),this.green=t(e,1),this.blue=t(n,1),this.alpha=t(o,1)};s.fromCartesian4=function(t,e){return r(e)?(e.red=t.x,e.green=t.y,e.blue=t.z,e.alpha=t.w,e):new s(t.x,t.y,t.z,t.w)},s.fromBytes=function(e,n,o,i,a){return e=s.byteToFloat(t(e,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),i=s.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new s(e,n,o,i)},s.fromAlpha=function(t,e,n){return r(n)?(n.red=t.red,n.green=t.green,n.blue=t.blue,n.alpha=e,n):new s(t.red,t.green,t.blue,e)};var u,l,c;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(t){return l[0]=t,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(r,e,n,o){r=t(r,0)%1,e=t(e,0),n=t(n,0),o=t(o,1);var i=n,u=n,l=n;if(0!==e){var c;c=.5>n?n*(1+e):n+e-n*e;var f=2*n-c;i=a(f,c,r+1/3),u=a(f,c,r),l=a(f,c,r-1/3)}return new s(i,u,l,o)},s.fromRandom=function(e,n){e=t(e,t.EMPTY_OBJECT);var o=e.red;if(!r(o)){var a=t(e.minimumRed,0),u=t(e.maximumRed,1);o=a+i.nextRandomNumber()*(u-a)}var l=e.green;if(!r(l)){var c=t(e.minimumGreen,0),f=t(e.maximumGreen,1);l=c+i.nextRandomNumber()*(f-c)}var h=e.blue;if(!r(h)){var d=t(e.minimumBlue,0),m=t(e.maximumBlue,1);h=d+i.nextRandomNumber()*(m-d)}var p=e.alpha;if(!r(p)){var g=t(e.minimumAlpha,0),E=t(e.maximumAlpha,1);p=g+i.nextRandomNumber()*(E-g)}return r(n)?(n.red=o,n.green=l,n.blue=h,n.alpha=p,n):new s(o,l,h,p)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,d=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,m=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(e){var n=s[e.toUpperCase()];if(r(n))return s.clone(n);var o=f.exec(e);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(e),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=d.exec(e),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(t(o[4],"1.0"))):(o=m.exec(e),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(t(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(r,e,n){n=t(n,0),e[n++]=r.red,e[n++]=r.green,e[n++]=r.blue,e[n]=r.alpha},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.red=e[n++],o.green=e[n++],o.blue=e[n++],o.alpha=e[n],o},s.byteToFloat=function(t){return t/255},s.floatToByte=function(t){return 1===t?255:0|256*t},s.clone=function(t,e){return r(t)?r(e)?(e.red=t.red,e.green=t.green,e.blue=t.blue,e.alpha=t.alpha,e):new s(t.red,t.green,t.blue,t.alpha):void 0},s.equals=function(t,e){return t===e||r(t)&&r(e)&&t.red===e.red&&t.green===e.green&&t.blue===e.blue&&t.alpha===e.alpha},s.equalsArray=function(t,r,e){return t.red===r[e]&&t.green===r[e+1]&&t.blue===r[e+2]&&t.alpha===r[e+3]},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.prototype.equalsEpsilon=function(t,e){return this===t||r(t)&&Math.abs(this.red-t.red)<=e&&Math.abs(this.green-t.green)<=e&&Math.abs(this.blue-t.blue)<=e&&Math.abs(this.alpha-t.alpha)<=e},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var t=s.floatToByte(this.red),r=s.floatToByte(this.green),e=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+t+","+r+","+e+")":"rgba("+t+","+r+","+e+","+this.alpha+")"},s.prototype.toBytes=function(t){var e=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return r(t)?(t[0]=e,t[1]=n,t[2]=o,t[3]=i,t):[e,n,o,i]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.prototype.brighten=function(t,r){return t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},s.prototype.darken=function(t,r){return t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},s.prototype.withAlpha=function(t,r){return s.fromAlpha(this,t,r)},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUSCHIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s
}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(t,r,e,n,o){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(t){switch(t){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new e("componentDatatype is not a valid value.")}},i.fromTypedArray=function(t){return t instanceof Int8Array?i.BYTE:t instanceof Uint8Array?i.UNSIGNED_BYTE:t instanceof Int16Array?i.SHORT:t instanceof Uint16Array?i.UNSIGNED_SHORT:t instanceof Float32Array?i.FLOAT:t instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(t){return r(t)&&(t===i.BYTE||t===i.UNSIGNED_BYTE||t===i.SHORT||t===i.UNSIGNED_SHORT||t===i.FLOAT||t===i.DOUBLE)},i.createTypedArray=function(t,r){switch(t){case i.BYTE:return new Int8Array(r);case i.UNSIGNED_BYTE:return new Uint8Array(r);case i.SHORT:return new Int16Array(r);case i.UNSIGNED_SHORT:return new Uint16Array(r);case i.FLOAT:return new Float32Array(r);case i.DOUBLE:return new Float64Array(r);default:throw new e("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(r,n,o,a){switch(o=t(o,0),a=t(a,(n.byteLength-o)/i.getSizeInBytes(r)),r){case i.BYTE:return new Int8Array(n,o,a);case i.UNSIGNED_BYTE:return new Uint8Array(n,o,a);case i.SHORT:return new Int16Array(n,o,a);case i.UNSIGNED_SHORT:return new Uint16Array(n,o,a);case i.FLOAT:return new Float32Array(n,o,a);case i.DOUBLE:return new Float64Array(n,o,a);default:throw new e("componentDatatype is not a valid value.")}},o(i)}),define("Core/GeometryType",["./freezeObject"],function(t){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return t(r)}),define("Core/PrimitiveType",["./freezeObject"],function(t){"use strict";var r={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(t){return t===r.POINTS||t===r.LINES||t===r.LINE_LOOP||t===r.LINE_STRIP||t===r.TRIANGLES||t===r.TRIANGLE_STRIP||t===r.TRIANGLE_FAN}};return t(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(t,r,e,n,o){"use strict";var i=function(r){r=t(r,t.EMPTY_OBJECT),this.attributes=r.attributes,this.indices=r.indices,this.primitiveType=t(r.primitiveType,o.TRIANGLES),this.boundingSphere=r.boundingSphere,this.geometryType=t(r.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(t){var n=-1;for(var o in t.attributes)if(t.attributes.hasOwnProperty(o)&&r(t.attributes[o])&&r(t.attributes[o].values)){var i=t.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new e("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(t){"use strict";var r=function(r){r=t(r,t.EMPTY_OBJECT),this.componentDatatype=r.componentDatatype,this.componentsPerAttribute=r.componentsPerAttribute,this.normalize=t(r.normalize,!1),this.values=r.values};return r}),define("Core/GeometryAttributes",["./defaultValue"],function(t){"use strict";var r=function(r){r=t(r,t.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(t,r,e,n){"use strict";var o={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return o.getSizeInBytes=function(t){switch(t){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},o.validate=function(r){return t(r)&&(r===o.UNSIGNED_BYTE||r===o.UNSIGNED_SHORT||r===o.UNSIGNED_INT)},o.createTypedArray=function(t,r){return t>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(r):new Uint16Array(r)},o.createTypedArrayFromArrayBuffer=function(t,r,e,o){return t>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(r,e,o):new Uint16Array(r,e,o)},e(o)}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(t,r,e,n,o,i,a,s){"use strict";function u(t){var r=t._uSquared,e=t._ellipsoid.maximumRadius,n=t._ellipsoid.minimumRadius,o=(e-n)/e,i=Math.cos(t._startHeading),a=Math.sin(t._startHeading),s=(1-o)*Math.tan(t._start.latitude),u=1/Math.sqrt(1+s*s),l=u*s,c=Math.atan2(s,i),f=u*a,h=f*f,d=1-h,m=Math.sqrt(d),p=r/4,g=p*p,E=g*p,y=g*g,v=1+p-3*g/4+5*E/4-175*y/64,C=1-p+15*g/8-35*E/8,S=1-3*p+35*g/4,w=1-5*p,M=v*c-C*Math.sin(2*c)*p/2-S*Math.sin(4*c)*g/16-w*Math.sin(6*c)*E/48-5*Math.sin(8*c)*y/512,R=t._constants;R.a=e,R.b=n,R.f=o,R.cosineHeading=i,R.sineHeading=a,R.tanU=s,R.cosineU=u,R.sineU=l,R.sigma=c,R.sineAlpha=f,R.sineSquaredAlpha=h,R.cosineSquaredAlpha=d,R.cosineAlpha=m,R.u2Over4=p,R.u4Over16=g,R.u6Over64=E,R.u8Over256=y,R.a0=v,R.a1=C,R.a2=S,R.a3=w,R.distanceRatio=M}function l(t,r){return t*r*(4+t*(4-3*r))/16}function c(t,r,e,n,o,i,a){var s=l(t,e);return(1-s)*t*r*(n+s*o*(a+s*i*(2*a*a-1)))}function f(t,r,e,n,o,i,a){var u,l,f,h,d,m=(r-e)/r,p=i-n,g=Math.atan((1-m)*Math.tan(o)),E=Math.atan((1-m)*Math.tan(a)),y=Math.cos(g),v=Math.sin(g),C=Math.cos(E),S=Math.sin(E),w=y*C,M=y*S,R=v*S,A=v*C,O=p,T=s.TWO_PI,I=Math.cos(O),N=Math.sin(O);do{I=Math.cos(O),N=Math.sin(O);var x=M-A*I;f=Math.sqrt(C*C*N*N+x*x),l=R+w*I,u=Math.atan2(f,l);var _;0===f?(_=0,h=1):(_=w*N/f,h=1-_*_),T=O,d=l-2*R/h,isNaN(d)&&(d=0),O=p+c(m,_,h,u,f,l,d)}while(Math.abs(O-T)>s.EPSILON12);var L=h*(r*r-e*e)/(e*e),b=1+L*(4096+L*(L*(320-175*L)-768))/16384,F=L*(256+L*(L*(74-47*L)-128))/1024,P=d*d,D=F*f*(d+F*(l*(2*P-1)-F*d*(4*f*f-3)*(4*P-3)/6)/4),z=e*b*(u-D),B=Math.atan2(C*N,M-A*I),U=Math.atan2(y*N,M*I-A);t._distance=z,t._startHeading=B,t._endHeading=U,t._uSquared=L}function h(e,n,o,i){t.normalize(i.cartographicToCartesian(n,m),d),t.normalize(i.cartographicToCartesian(o,m),m),f(e,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,o.longitude,o.latitude),e._start=r.clone(n,e._start),e._end=r.clone(o,e._end),e._start.height=0,e._end.height=0,u(e)}var d=new t,m=new t,p=function(t,o,i){var s=e(i,a.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(t)&&n(o)&&h(this,t,o,s)};return o(p.prototype,{surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),p.prototype.setEndPoints=function(t,r){h(this,t,r,this._ellipsoid)},p.prototype.interpolateUsingFraction=function(t,r){return this.interpolateUsingSurfaceDistance(this._distance*t,r)},p.prototype.interpolateUsingSurfaceDistance=function(t,e){var o=this._constants,i=o.distanceRatio+t/o.b,a=Math.cos(2*i),s=Math.cos(4*i),u=Math.cos(6*i),l=Math.sin(2*i),f=Math.sin(4*i),h=Math.sin(6*i),d=Math.sin(8*i),m=i*i,p=i*m,g=o.u8Over256,E=o.u2Over4,y=o.u6Over64,v=o.u4Over16,C=2*p*g*a/3+i*(1-E+7*v/4-15*y/4+579*g/64-(v-15*y/4+187*g/16)*a-(5*y/4-115*g/16)*s-29*g*u/16)+(E/2-v+71*y/32-85*g/16)*l+(5*v/16-5*y/4+383*g/96)*f-m*((y-11*g/2)*l+5*g*f/2)+(29*y/96-29*g/16)*h+539*g*d/1536,S=Math.asin(Math.sin(C)*o.cosineAlpha),w=Math.atan(o.a/o.b*Math.tan(S));C-=o.sigma;var M=Math.cos(2*o.sigma+C),R=Math.sin(C),A=Math.cos(C),O=o.cosineU*A,T=o.sineU*R,I=Math.atan2(R*o.sineHeading,O-T*o.cosineHeading),N=I-c(o.f,o.sineAlpha,o.cosineSquaredAlpha,C,R,A,M);return n(e)?(e.longitude=this._start.longitude+N,e.latitude=w,e.height=0,e):new r(this._start.longitude+N,w,0)},p}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(t,r){"use strict";function e(t,e,n){var o=t+e;return r.sign(t)!==r.sign(e)&&Math.abs(o/Math.max(Math.abs(t),Math.abs(e)))<n?0:o}var n={};return n.computeDiscriminant=function(t,r,e){var n=r*r-4*t*e;return n},n.computeRealRoots=function(t,n,o){var i;if(0===t)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),s=Math.abs(t);if(s>a&&a/s<r.EPSILON14)return[0,0];if(a>s&&s/a<r.EPSILON14)return[];if(i=-o/t,0>i)return[];var u=Math.sqrt(i);return[-u,u]}if(0===o)return i=-n/t,0>i?[i,0]:[0,i];var l=n*n,c=4*t*o,f=e(l,-c,r.EPSILON14);if(0>f)return[];var h=-.5*e(n,r.sign(n)*Math.sqrt(f),r.EPSILON14);return n>0?[h/t,o/h]:[o/h,h/t]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(t,r){"use strict";function e(t,r,e,n){var o,i,a=t,s=r/3,u=e/3,l=n,c=a*u,f=s*l,h=s*s,d=u*u,m=a*u-h,p=a*l-s*u,g=s*l-d,E=4*m*g-p*p;if(0>E){var y,v,C;h*f>=c*d?(y=a,v=m,C=-2*s*m+a*p):(y=l,v=g,C=-l*p+2*u*g);var S=0>C?-1:1,w=-S*Math.abs(y)*Math.sqrt(-E);i=-C+w;var M=i/2,R=0>M?-Math.pow(-M,1/3):Math.pow(M,1/3),A=i===w?-R:-v/R;return o=0>=v?R+A:-C/(R*R+A*A+v),h*f>=c*d?[(o-s)/a]:[-l/(o+u)]}var O=m,T=-2*s*m+a*p,I=g,N=-l*p+2*u*g,x=Math.sqrt(E),_=Math.sqrt(3)/2,L=Math.abs(Math.atan2(a*x,-T)/3);o=2*Math.sqrt(-O);var b=Math.cos(L);i=o*b;var F=o*(-b/2-_*Math.sin(L)),P=i+F>2*s?i-s:F-s,D=a,z=P/D;L=Math.abs(Math.atan2(l*x,-N)/3),o=2*Math.sqrt(-I),b=Math.cos(L),i=o*b,F=o*(-b/2-_*Math.sin(L));var B=-l,U=2*u>i+F?i+u:F+u,q=B/U,G=D*U,W=-P*U-D*B,Y=P*B,H=(u*W-s*Y)/(-s*W+u*G);return H>=z?q>=z?q>=H?[z,H,q]:[z,q,H]:[q,z,H]:q>=z?[H,z,q]:q>=H?[H,q,z]:[q,H,z]}var n={};return n.computeDiscriminant=function(t,r,e,n){var o=t*t,i=r*r,a=e*e,s=n*n,u=18*t*r*e*n+i*a-27*o*s-4*(t*a*e+i*r*n);return u},n.computeRealRoots=function(t,n,o,i){var a,s;if(0===t)return r.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];s=-i/t;var u=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[u,u,u]}return 0===i?(a=r.computeRealRoots(t,0,o),0===a.Length?[0]:[a[0],0,a[1]]):e(t,0,o,i)}return 0===o?0===i?(s=-n/t,0>s?[s,0,0]:[0,0,s]):e(t,n,0,i):0===i?(a=r.computeRealRoots(t,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):e(t,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(t,r,e,n){"use strict";function o(r,o,i,a){var s=r*r,u=o-3*s/8,l=i-o*r/2+s*r/8,c=a-i*r/4+o*s/16-3*s*s/256,f=t.computeRealRoots(1,2*u,u*u-4*c,-l*l);if(f.length>0){var h=-r/4,d=f[f.length-1];if(Math.abs(d)<e.EPSILON14){var m=n.computeRealRoots(1,u,c);if(2===m.length){var p,g=m[0],E=m[1];if(g>=0&&E>=0){var y=Math.sqrt(g),v=Math.sqrt(E);return[h-v,h-y,h+y,h+v]}if(g>=0&&0>E)return p=Math.sqrt(g),[h-p,h+p];if(0>g&&E>=0)return p=Math.sqrt(E),[h-p,h+p]}return[]}if(d>0){var C=Math.sqrt(d),S=(u+d-l/C)/2,w=(u+d+l/C)/2,M=n.computeRealRoots(1,C,S),R=n.computeRealRoots(1,-C,w);return 0!==M.length?(M[0]+=h,M[1]+=h,0!==R.length?(R[0]+=h,R[1]+=h,M[1]<=R[0]?[M[0],M[1],R[0],R[1]]:R[1]<=M[0]?[R[0],R[1],M[0],M[1]]:M[0]>=R[0]&&M[1]<=R[1]?[R[0],M[0],M[1],R[1]]:R[0]>=M[0]&&R[1]<=M[1]?[M[0],R[0],R[1],M[1]]:M[0]>R[0]&&M[0]<R[1]?[R[0],M[0],R[1],M[1]]:[M[0],R[0],M[1],R[1]]):M):0!==R.length?(R[0]+=h,R[1]+=h,R):[]}}return[]}function i(r,o,i,a){var s=i*i,u=o*o,l=r*r,c=-2*o,f=i*r+u-4*a,h=l*a-i*o*r+s,d=t.computeRealRoots(1,c,f,h);if(d.length>0){var m,p,g=d[0],E=o-g,y=E*E,v=r/2,C=E/2,S=y-4*a,w=y+4*Math.abs(a),M=l-4*g,R=l+4*Math.abs(g);if(0>g||M*w>S*R){var A=Math.sqrt(M);m=A/2,p=0===A?0:(r*C-i)/A}else{var O=Math.sqrt(S);m=0===O?0:(r*C-i)/O,p=O/2}var T,I;0===v&&0===m?(T=0,I=0):e.sign(v)===e.sign(m)?(T=v+m,I=g/T):(I=v-m,T=g/I);var N,x;0===C&&0===p?(N=0,x=0):e.sign(C)===e.sign(p)?(N=C+p,x=a/N):(x=C-p,N=a/x);var _=n.computeRealRoots(1,T,N),L=n.computeRealRoots(1,I,x);if(0!==_.length)return 0!==L.length?_[1]<=L[0]?[_[0],_[1],L[0],L[1]]:L[1]<=_[0]?[L[0],L[1],_[0],_[1]]:_[0]>=L[0]&&_[1]<=L[1]?[L[0],_[0],_[1],L[1]]:L[0]>=_[0]&&L[1]<=_[1]?[_[0],L[0],L[1],_[1]]:_[0]>L[0]&&_[0]<L[1]?[L[0],_[0],L[1],_[1]]:[_[0],L[0],_[1],L[1]]:_;if(0!==L.length)return L}return[]}var a={};return a.computeDiscriminant=function(t,r,e,n,o){var i=t*t,a=i*t,s=r*r,u=s*r,l=e*e,c=l*e,f=n*n,h=f*n,d=o*o,m=d*o,p=s*l*f-4*u*h-4*t*c*f+18*t*r*e*h-27*i*f*f+256*a*m+o*(18*u*e*n-4*s*c+16*t*l*l-80*t*r*l*n-6*t*s*f+144*i*e*f)+d*(144*t*s*e-27*s*s-128*i*l-192*i*r*n);return p},a.computeRealRoots=function(r,n,a,s,u){if(Math.abs(r)<e.EPSILON15)return t.computeRealRoots(n,a,s,u);var l=n/r,c=a/r,f=s/r,h=u/r,d=0>l?1:0;switch(d+=0>c?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return o(l,c,f,h);case 1:return i(l,c,f,h);case 2:return i(l,c,f,h);case 3:return o(l,c,f,h);case 4:return o(l,c,f,h);case 5:return i(l,c,f,h);case 6:return o(l,c,f,h);case 7:return o(l,c,f,h);case 8:return i(l,c,f,h);case 9:return o(l,c,f,h);case 10:return o(l,c,f,h);case 11:return i(l,c,f,h);case 12:return o(l,c,f,h);case 13:return o(l,c,f,h);case 14:return o(l,c,f,h);case 15:return o(l,c,f,h);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(t,r,e){"use strict";var n=function(e,n){n=t.clone(r(n,t.ZERO)),t.equals(n,t.ZERO)||t.normalize(n,n),this.origin=t.clone(r(e,t.ZERO)),this.direction=n};return n.getPoint=function(r,n,o){return e(o)||(o=new t),o=t.multiplyByScalar(r.direction,n,o),t.add(r.origin,o,o)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(t,r,e,n,o,i,a,s,u,l){"use strict";function c(r,n,o,a,s){s=e(s,!1);var u,l,c,f,h,d=r.origin,m=r.direction,p=t.subtract(o,n,g),S=t.subtract(a,n,E),w=t.cross(m,S,y),M=t.dot(p,w);if(s){if(M<i.EPSILON6)return void 0;if(u=t.subtract(d,n,v),c=t.dot(u,w),0>c||c>M)return void 0;if(l=t.cross(u,p,C),f=t.dot(m,l),0>f||c+f>M)return void 0;h=t.dot(S,l)/M}else{if(Math.abs(M)<i.EPSILON6)return void 0;var R=1/M;if(u=t.subtract(d,n,v),c=t.dot(u,w)*R,0>c||c>1)return void 0;if(l=t.cross(u,p,C),f=t.dot(m,l)*R,0>f||c+f>1)return void 0;h=t.dot(S,l)*R}return h}function f(t,r,e,n){var o=r*r-4*t*e;if(0>o)return void 0;if(o>0){var i=1/(2*t),a=Math.sqrt(o),s=(-r+a)*i,u=(-r-a)*i;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var l=-r/(2*t);return 0===l?void 0:(n.root0=n.root1=l,n)}function h(r,e,o){n(o)||(o={});var i=r.origin,a=r.direction,s=e.center,u=e.radius*e.radius,l=t.subtract(i,s,y),c=t.dot(a,a),h=2*t.dot(a,l),d=t.magnitudeSquared(l)-u,m=f(c,h,d,w);return n(m)?(o.start=m.root0,o.stop=m.root1,o):void 0}function d(t,r,e){var n=t+r;return i.sign(t)!==i.sign(r)&&Math.abs(n/Math.max(Math.abs(t),Math.abs(r)))<e?0:n}function m(r,e,n,o,l){var c,f=o*o,h=l*l,m=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,p=l*(o*d(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],i.EPSILON15)+e.y),g=r[a.COLUMN0ROW0]*f+r[a.COLUMN2ROW2]*h+o*e.x+n,E=h*d(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],i.EPSILON15),y=l*(o*d(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+e.z),v=[];if(0===y&&0===E){if(c=s.computeRealRoots(m,p,g),0===c.length)return v;var C=c[0],S=Math.sqrt(Math.max(1-C*C,0));if(v.push(new t(o,l*C,l*-S)),v.push(new t(o,l*C,l*S)),2===c.length){var w=c[1],M=Math.sqrt(Math.max(1-w*w,0));v.push(new t(o,l*w,l*-M)),v.push(new t(o,l*w,l*M))}return v}var R=y*y,A=E*E,O=m*m,T=y*E,I=O+A,N=2*(p*m+T),x=2*g*m+p*p-A+R,_=2*(g*p-T),L=g*g-R;if(0===I&&0===N&&0===x&&0===_)return v;c=u.computeRealRoots(I,N,x,_,L);var b=c.length;if(0===b)return v;for(var F=0;b>F;++F){var P,D=c[F],z=D*D,B=Math.max(1-z,0),U=Math.sqrt(B);P=i.sign(m)===i.sign(g)?d(m*z+g,p*D,i.EPSILON12):i.sign(g)===i.sign(p*D)?d(m*z,p*D+g,i.EPSILON12):d(m*z+p*D,g,i.EPSILON12);var q=d(E*D,y,i.EPSILON15),G=P*q;0>G?v.push(new t(o,l*D,l*U)):G>0?v.push(new t(o,l*D,l*-U)):0!==U?(v.push(new t(o,l*D,l*-U)),v.push(new t(o,l*D,l*U)),++F):v.push(new t(o,l*D,l*U))}return v}var p={};p.rayPlane=function(r,e,o){n(o)||(o=new t);var a=r.origin,s=r.direction,u=e.normal,l=t.dot(u,s);if(Math.abs(l)<i.EPSILON15)return void 0;var c=(-e.distance-t.dot(u,a))/l;return 0>c?void 0:(o=t.multiplyByScalar(s,c,o),t.add(a,o,o))};var g=new t,E=new t,y=new t,v=new t,C=new t;p.rayTriangle=function(r,e,o,i,a,s){var u=c(r,e,o,i,a);return!n(u)||0>u?void 0:(n(s)||(s=new t),t.multiplyByScalar(r.direction,u,s),t.add(r.origin,s,s))};var S=new l;p.lineSegmentTriangle=function(r,e,o,i,a,s,u){var l=S;t.clone(r,l.origin),t.subtract(e,r,l.direction),t.normalize(l.direction,l.direction);var f=c(l,o,i,a,s);return!n(f)||0>f||f>t.distance(r,e)?void 0:(n(u)||(u=new t),t.multiplyByScalar(l.direction,f,u),t.add(l.origin,u,u))};var w={root0:0,root1:0};p.raySphere=function(t,r,e){return e=h(t,r,e),!n(e)||e.stop<0?void 0:(e.start=Math.max(e.start,0),e)};var M=new l;p.lineSegmentSphere=function(r,e,o,i){var a=M;t.clone(r,a.origin);var s=t.subtract(e,r,a.direction),u=t.magnitude(s);return t.normalize(s,s),i=h(a,o,i),!n(i)||i.stop<0||i.start>u?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,u),i)};var R=new t,A=new t;p.rayEllipsoid=function(r,e){var n,o,i,a,s,u=e.oneOverRadii,l=t.multiplyComponents(u,r.origin,R),c=t.multiplyComponents(u,r.direction,A),f=t.magnitudeSquared(l),h=t.dot(l,c);if(f>1){if(h>=0)return void 0;var d=h*h;if(n=f-1,o=t.magnitudeSquared(c),i=o*n,i>d)return void 0;if(d>i){a=h*h-i,s=-h+Math.sqrt(a);var m=s/o,p=n/s;return p>m?{start:m,stop:p}:{start:p,stop:m}}var g=Math.sqrt(n/o);return{start:g,stop:g}}return 1>f?(n=f-1,o=t.magnitudeSquared(c),i=o*n,a=h*h-i,s=-h+Math.sqrt(a),{start:0,stop:s/o}):0>h?(o=t.magnitudeSquared(c),{start:0,stop:-h/o}):void 0};var O=new t,T=new t,I=new t,N=new t,x=new t,_=new a,L=new a,b=new a,F=new a,P=new a,D=new a,z=new a,B=new t,U=new t,q=new r;p.grazingAltitudeLocation=function(r,e){var o=r.origin,s=r.direction,u=e.geodeticSurfaceNormal(o,O);if(t.dot(s,u)>=0)return o;var l=n(this.rayEllipsoid(r,e)),c=e.transformPositionToScaledSpace(s,O),f=t.normalize(c,c),h=t.mostOrthogonalAxis(c,N),d=t.normalize(t.cross(h,f,T),T),p=t.normalize(t.cross(f,d,I),I),g=_;g[0]=f.x,g[1]=f.y,g[2]=f.z,g[3]=d.x,g[4]=d.y,g[5]=d.z,g[6]=p.x,g[7]=p.y,g[8]=p.z;var E=a.transpose(g,L),y=a.fromScale(e.radii,b),v=a.fromScale(e.oneOverRadii,F),C=P;C[0]=0,C[1]=-s.z,C[2]=s.y,C[3]=s.z,C[4]=0,C[5]=-s.x,C[6]=-s.y,C[7]=s.x,C[8]=0;var S,w,M=a.multiply(a.multiply(E,v,D),C,D),R=a.multiply(a.multiply(M,y,z),g,z),A=a.multiplyByVector(M,o,x),G=m(R,t.negate(A,O),0,0,1),W=G.length;if(W>0){for(var Y=t.clone(t.ZERO,U),H=Number.NEGATIVE_INFINITY,k=0;W>k;++k){S=a.multiplyByVector(y,a.multiplyByVector(g,G[k],B),B);var V=t.normalize(t.subtract(S,o,N),N),K=t.dot(V,s);K>H&&(H=K,Y=t.clone(S,Y))}var j=e.cartesianToCartographic(Y,q);return H=i.clamp(H,0,1),w=t.magnitude(t.subtract(Y,o,N))*Math.sqrt(1-H*H),w=l?-w:w,j.height=w,e.cartographicToCartesian(j,new t)}return void 0};var G=new t;return p.lineSegmentPlane=function(r,e,o,a){n(a)||(a=new t);var s=t.subtract(e,r,G),u=o.normal,l=t.dot(u,s);if(Math.abs(l)<i.EPSILON6)return void 0;var c=t.dot(u,r),f=-(o.distance+c)/l;return 0>f||f>1?void 0:(t.multiplyByScalar(s,f,a),t.add(r,a,a),a)},p.trianglePlaneIntersection=function(r,e,n,o){var i=o.normal,a=o.distance,s=t.dot(i,r)+a<0,u=t.dot(i,e)+a<0,l=t.dot(i,n)+a<0,c=0;c+=s?1:0,c+=u?1:0,c+=l?1:0;var f,h;if((1===c||2===c)&&(f=new t,h=new t),1===c){if(s)return p.lineSegmentPlane(r,e,o,f),p.lineSegmentPlane(r,n,o,h),{positions:[r,e,n,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(u)return p.lineSegmentPlane(e,n,o,f),p.lineSegmentPlane(e,r,o,h),{positions:[r,e,n,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(l)return p.lineSegmentPlane(n,r,o,f),p.lineSegmentPlane(n,e,o,h),{positions:[r,e,n,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===c){if(!s)return p.lineSegmentPlane(e,r,o,f),p.lineSegmentPlane(n,r,o,h),{positions:[r,e,n,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!u)return p.lineSegmentPlane(n,e,o,f),p.lineSegmentPlane(r,e,o,h),{positions:[r,e,n,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return p.lineSegmentPlane(r,n,o,f),p.lineSegmentPlane(e,n,o,h),{positions:[r,e,n,f,h],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},p}),define("Core/isArray",["./defined"],function(t){"use strict";var r=Array.isArray;return t(r)||(r=function(t){return"[object Array]"===Object.prototype.toString.call(t)}),r}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(t,r){"use strict";var e=function(r,e){this.normal=t.clone(r),this.distance=e};return e.fromPointNormal=function(n,o,i){var a=-t.dot(o,n);return r(i)?(t.clone(o,i.normal),i.distance=a,i):new e(o,a)},e.getPointDistance=function(r,e){return t.dot(r.normal,e)+r.distance},e}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(t,r,e,n,o,i,a,s,u,l,c,f){"use strict";function h(t,r,e){var n=R;n.length=t;var o;if(r===e){for(o=0;t>o;o++)n[o]=r;return n}var i=e-r,a=i/t;for(o=0;t>o;o++){var s=r+o*a;n[o]=s}return n}function d(r,e,n,o,i,a,s,u){var l=o.scaleToGeodeticSurface(r,I),c=o.scaleToGeodeticSurface(e,N),f=m.numberOfPoints(r,e,n),d=o.cartesianToCartographic(l,A),p=o.cartesianToCartographic(c,O),g=h(f,i,a);x.setEndPoints(d,p);var E=x.surfaceDistance/f,y=u;d.height=i;var v=o.cartographicToCartesian(d,T);t.pack(v,s,y),y+=3;for(var C=1;f>C;C++){var S=x.interpolateUsingSurfaceDistance(C*E,O);S.height=g[C],v=o.cartographicToCartesian(S,T),t.pack(v,s,y),y+=3}return y}var m={};m.numberOfPoints=function(r,e,n){var o=t.distance(r,e);return Math.ceil(o/n)};var p=new r;m.extractHeights=function(t,r){for(var e=t.length,n=new Array(e),o=0;e>o;o++){var i=t[o];n[o]=r.cartesianToCartographic(i,p).height}return n};var g=new c,E=new t,y=new t,v=new f(t.ZERO,0),C=new t,S=new f(t.ZERO,0),w=new t,M=new t,R=[],A=new r,O=new r,T=new t,I=new t,N=new t,x=new a;m.wrapLongitude=function(r,o){var i=[],a=[];if(n(r)&&r.length>0){o=e(o,c.IDENTITY);var u=c.inverseTransformation(o,g),l=c.multiplyByPoint(u,t.ZERO,E),h=c.multiplyByPointAsVector(u,t.UNIT_Y,y),d=f.fromPointNormal(l,h,v),m=c.multiplyByPointAsVector(u,t.UNIT_X,C),p=f.fromPointNormal(l,m,S),R=1;i.push(t.clone(r[0]));for(var A=i[0],O=r.length,T=1;O>T;++T){var I=r[T];if(f.getPointDistance(p,A)<0||f.getPointDistance(p,I)<0){var N=s.lineSegmentPlane(A,I,d,w);if(n(N)){var x=t.multiplyByScalar(h,5e-9,M);f.getPointDistance(d,A)<0&&t.negate(x,x),i.push(t.add(N,x,new t)),a.push(R+1),t.negate(x,x),i.push(t.add(N,x,new t)),R=1}}i.push(t.clone(r[T])),R++,A=I}a.push(R)}return{positions:i,lengths:a}};var _=l.EPSILON7;return m.removeDuplicates=function(r){var e=r.length;if(2>e)return void 0;var n,o,i;for(n=1;e>n&&(o=r[n-1],i=r[n],!t.equalsEpsilon(o,i,_));++n);if(n===e)return void 0;for(var a=r.slice(0,n);e>n;++n)i=r[n],t.equalsEpsilon(o,i,_)||(a.push(t.clone(i)),o=i);return a},m.generateArc=function(r){n(r)||(r={});var o=r.positions,a=e(r.ellipsoid,i.WGS84),s=e(r.height,0),c=r.minDistance;if(!n(c)){var f=e(r.granularity,l.RADIANS_PER_DEGREE);c=l.chordLength(f,a.maximumRadius)}var h,p=o.length,g=0;for(h=0;p-1>h;h++)g+=m.numberOfPoints(o[h],o[h+1],c);var E=3*(g+1),y=new Array(E),v=0,C=u(s);for(h=0;p-1>h;h++){var S=o[h],w=o[h+1],M=C?s[h]:s,O=C?s[h+1]:s;v=d(S,w,c,a,M,O,y,v)}R.length=0;var I=o[p-1],N=a.cartesianToCartographic(I,A);N.height=C?s[p-1]:s;var x=a.cartographicToCartesian(N,T);return t.pack(x,y,E-3),y},m.generateCartesianArc=function(r){for(var e=m.generateArc(r),n=e.length/3,o=new Array(n),i=0;n>i;i++)o[i]=t.unpack(e,3*i);return o},m}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(t,r,e,n){"use strict";var o=function(r){r=t(r,t.EMPTY_OBJECT),this.position=t(r.position,!1),this.normal=t(r.normal,!1),this.st=t(r.st,!1),this.binormal=t(r.binormal,!1),this.tangent=t(r.tangent,!1),this.color=t(r.color,!1)};return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(r,e,n){n=t(n,0),e[n++]=r.position?1:0,e[n++]=r.normal?1:0,e[n++]=r.st?1:0,e[n++]=r.binormal?1:0,e[n++]=r.tangent?1:0,e[n++]=r.color?1:0},o.unpack=function(e,n,i){return n=t(n,0),r(i)||(i=new o),i.position=1===e[n++],i.normal=1===e[n++],i.st=1===e[n++],i.binormal=1===e[n++],i.tangent=1===e[n++],i.color=1===e[n++],i},o.clone=function(t,e){return r(t)?(r(e)||(e=new o),e.position=t.position,e.normal=t.normal,e.st=t.st,e.binormal=t.binormal,e.tangent=t.tangent,e.color=t.color,e):void 0},o}),define("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(t,r,e,n,o,i,a,s,u,l,c,f,h,d,m,p,g){"use strict";function E(t,r,n,o,i){var a=y;a.length=i;var s,u=n.red,l=n.green,c=n.blue,f=n.alpha,h=o.red,d=o.green,m=o.blue,p=o.alpha;if(e.equals(n,o)){for(s=0;i>s;s++)a[s]=e.clone(n);return a}var g=(h-u)/i,E=(d-l)/i,v=(m-c)/i,C=(p-f)/i;for(s=0;i>s;s++)a[s]=new e(u+s*g,l+s*E,c+s*v,f+s*C);return a}var y=[],v=function(t){t=o(t,o.EMPTY_OBJECT);var n=t.positions,a=t.colors,u=o(t.width,1),l=o(t.colorsPerVertex,!1);this._positions=n,this._colors=a,this._width=u,this._colorsPerVertex=l,this._vertexFormat=g.clone(o(t.vertexFormat,g.DEFAULT)),this._followSurface=o(t.followSurface,!0),this._granularity=o(t.granularity,d.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(o(t.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var c=1+n.length*r.packedLength;c+=i(a)?1+a.length*e.packedLength:1,this.packedLength=c+s.packedLength+g.packedLength+4};v.pack=function(t,n,a){a=o(a,0);var u,l=t._positions,c=l.length;for(n[a++]=c,u=0;c>u;++u,a+=r.packedLength)r.pack(l[u],n,a);var f=t._colors;for(c=i(f)?f.length:0,n[a++]=c,u=0;c>u;++u,a+=e.packedLength)e.pack(f[u],n,a);s.pack(t._ellipsoid,n,a),a+=s.packedLength,g.pack(t._vertexFormat,n,a),a+=g.packedLength,n[a++]=t._width,n[a++]=t._colorsPerVertex?1:0,n[a++]=t._followSurface?1:0,n[a]=t._granularity};var C=s.clone(s.UNIT_SPHERE),S=new g,w={positions:void 0,colors:void 0,ellipsoid:C,vertexFormat:S,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};v.unpack=function(t,n,a){n=o(n,0);var u,l=t[n++],c=new Array(l);for(u=0;l>u;++u,n+=r.packedLength)c[u]=r.unpack(t,n);l=t[n++];var f=l>0?new Array(l):void 0;for(u=0;l>u;++u,n+=e.packedLength)f[u]=e.unpack(t,n);var h=s.unpack(t,n,C);n+=s.packedLength;var d=g.unpack(t,n,S);n+=g.packedLength;var m=t[n++],p=1===t[n++],E=1===t[n++],y=t[n];return i(a)?(a._positions=c,a._colors=f,a._ellipsoid=s.clone(h,a._ellipsoid),a._vertexFormat=g.clone(d,a._vertexFormat),a._width=m,a._colorsPerVertex=p,a._followSurface=E,a._granularity=y,a):(w.positions=c,w.colors=f,w.width=m,w.colorsPerVertex=p,w.followSurface=E,w.granularity=y,new v(w))};var M=new r,R=new r,A=new r,O=new r;return v.createGeometry=function(o){var a,s,g,v=o._width,C=o._vertexFormat,S=o._colors,w=o._colorsPerVertex,T=o._followSurface,I=o._granularity,N=o._ellipsoid,x=d.chordLength(I,N.maximumRadius),_=m.removeDuplicates(o._positions);i(_)||(_=o._positions);var L=_.length;if(2>L)return void 0;if(T){var b=m.extractHeights(_,N);if(i(S)){var F=1;for(a=0;L-1>a;++a)F+=m.numberOfPoints(_[a],_[a+1],x);var P=new Array(F),D=0;for(a=0;L-1>a;++a){var z=_[a],B=_[a+1],U=S[a],q=m.numberOfPoints(z,B,x);if(w&&F>a){var G=S[a+1],W=E(z,B,U,G,q),Y=W.length;for(s=0;Y>s;++s)P[D++]=W[s]}else for(s=0;q>s;++s)P[D++]=e.clone(U)}P[D]=e.clone(S[S.length-1]),S=P,y.length=0}_=m.generateCartesianArc({positions:_,minDistance:x,ellipsoid:N,height:b})}L=_.length;var H,k=4*L-4,V=new Float64Array(3*k),K=new Float64Array(3*k),j=new Float64Array(3*k),Z=new Float32Array(2*k),Q=C.st?new Float32Array(2*k):void 0,X=i(S)?new Uint8Array(4*k):void 0,J=0,$=0,tr=0,rr=0;for(s=0;L>s;++s){0===s?(H=M,r.subtract(_[0],_[1],H),r.add(_[0],H,H)):H=_[s-1],r.clone(H,A),r.clone(_[s],R),s===L-1?(H=M,r.subtract(_[L-1],_[L-2],H),r.add(_[L-1],H,H)):H=_[s+1],r.clone(H,O);var er,nr;i(X)&&(er=0===s||w?S[s]:S[s-1],s!==L-1&&(nr=S[s]));var or=0===s?2:0,ir=s===L-1?2:4;for(g=or;ir>g;++g){r.pack(R,V,J),r.pack(A,K,J),r.pack(O,j,J),J+=3;var ar=0>g-2?-1:1;if(Z[$++]=2*(g%2)-1,Z[$++]=ar*v,C.st&&(Q[tr++]=s/(L-1),Q[tr++]=Math.max(Z[$-2],0)),i(X)){var sr=2>g?er:nr;X[rr++]=e.floatToByte(sr.red),X[rr++]=e.floatToByte(sr.green),X[rr++]=e.floatToByte(sr.blue),X[rr++]=e.floatToByte(sr.alpha)}}}var ur=new c;ur.position=new l({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:V}),ur.prevPosition=new l({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:K}),ur.nextPosition=new l({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:j}),ur.expandAndWidth=new l({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:Z}),C.st&&(ur.st=new l({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:Q})),i(X)&&(ur.color=new l({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:X,normalize:!0}));var lr=h.createTypedArray(k,6*L-6),cr=0,fr=0,hr=L-1;for(s=0;hr>s;++s)lr[fr++]=cr,lr[fr++]=cr+2,lr[fr++]=cr+1,lr[fr++]=cr+1,lr[fr++]=cr+2,lr[fr++]=cr+3,cr+=4;return new u({attributes:ur,indices:lr,primitiveType:p.TRIANGLES,boundingSphere:t.fromPoints(_),geometryType:f.POLYLINES})},v}),define("Workers/createPolylineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineGeometry"],function(t,r,e){"use strict";function n(n,o){return t(o)&&(n=e.unpack(n,o)),n._ellipsoid=r.clone(n._ellipsoid),e.createGeometry(n)}return n})}();