/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(r){e=r.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^t>>>1^e[1&t];for(;r<this.N-1;r++)t=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e){"use strict";var r={};r.EPSILON1=.1,r.EPSILON2=.01,r.EPSILON3=.001,r.EPSILON4=1e-4,r.EPSILON5=1e-5,r.EPSILON6=1e-6,r.EPSILON7=1e-7,r.EPSILON8=1e-8,r.EPSILON9=1e-9,r.EPSILON10=1e-10,r.EPSILON11=1e-11,r.EPSILON12=1e-12,r.EPSILON13=1e-13,r.EPSILON14=1e-14,r.EPSILON15=1e-15,r.EPSILON16=1e-16,r.EPSILON17=1e-17,r.EPSILON18=1e-18,r.EPSILON19=1e-19,r.EPSILON20=1e-20,r.GRAVITATIONALPARAMETER=3986004418e5,r.SOLAR_RADIUS=6955e5,r.LUNAR_RADIUS=1737400,r.SIXTY_FOUR_KILOBYTES=65536,r.sign=function(t){return t>0?1:0>t?-1:0},r.signNotZero=function(t){return 0>t?-1:1},r.toSNorm=function(t){return Math.round(255*(.5*r.clamp(t,-1,1)+.5))},r.fromSNorm=function(t){return 2*(r.clamp(t,0,255)/255)-1},r.sinh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e-r)},r.cosh=function(t){var e=Math.pow(Math.E,t),r=Math.pow(Math.E,-1*t);return.5*(e+r)},r.lerp=function(t,e,r){return(1-r)*t+r*e},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=.5*Math.PI,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=.5*3*Math.PI,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(t){return t*r.RADIANS_PER_DEGREE},r.toDegrees=function(t){return t*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(t){var e=r.TWO_PI,n=t-Math.floor(t/e)*e;return n<-Math.PI?n+e:n>=Math.PI?n-e:n},r.negativePiToPi=function(t){return r.zeroToTwoPi(t+r.PI)-r.PI},r.zeroToTwoPi=function(t){var e=r.mod(t,r.TWO_PI);return Math.abs(e)<r.EPSILON14&&Math.abs(t)>r.EPSILON14?r.TWO_PI:e},r.mod=function(t,e){return(t%e+e)%e},r.equalsEpsilon=function(t,r,n,i){i=e(i,n);var a=Math.abs(t-r);return i>=a||a<=n*Math.max(Math.abs(t),Math.abs(r))};var n=[1];r.factorial=function(t){var e=n.length;if(t>=e)for(var r=n[e-1],i=e;t>=i;i++)n.push(r*i);return n[t]},r.incrementWrap=function(t,r,n){return n=e(n,0),++t,t>r&&(t=n),t},r.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},r.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},r.clamp=function(t,e,r){return e>t?e:t>r?r:t};var i=new t;return r.setRandomNumberSeed=function(e){i=new t(e)},r.nextRandomNumber=function(){return i.random()},r.acosClamped=function(t){return Math.acos(r.clamp(t,-1,1))},r.asinClamped=function(t){return Math.asin(r.clamp(t,-1,1))},r.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},r}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,i){"use strict";var a=function(e,r){this.x=t(e,0),this.y=t(r,0)};a.fromElements=function(t,r,n){return e(n)?(n.x=t,n.y=r,n):new a(t,r)},a.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r):new a(t.x,t.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n]=e.y},a.unpack=function(r,n,i){return n=t(n,0),e(i)||(i=new a),i.x=r[n++],i.y=r[n],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y)},a.minimumComponent=function(t){return Math.min(t.x,t.y)},a.minimumByComponent=function(t,e,r){return r.x=Math.min(t.x,e.x),r.y=Math.min(t.y,e.y),r},a.maximumByComponent=function(t,e,r){return r.x=Math.max(t.x,e.x),r.y=Math.max(t.y,e.y),r},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var r=a.magnitude(t);return e.x=t.x/r,e.y=t.y/r,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y},a.multiplyComponents=function(t,e,r){return r.x=t.x*e.x,r.y=t.y*e.y,r},a.add=function(t,e,r){return r.x=t.x+e.x,r.y=t.y+e.y,r},a.subtract=function(t,e,r){return r.x=t.x-e.x,r.y=t.y-e.y,r},a.multiplyByScalar=function(t,e,r){return r.x=t.x*e,r.y=t.y*e,r},a.divideByScalar=function(t,e,r){return r.x=t.x/e,r.y=t.y/e,r},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e};var u=new a;a.lerp=function(t,e,r,n){return a.multiplyByScalar(e,r,u),n=a.multiplyByScalar(t,1-r,n),a.add(u,n,n)};var s=new a,c=new a;a.angleBetween=function(t,e){return a.normalize(t,s),a.normalize(e,c),i.acosClamped(a.dot(s,c))};var h=new a;return a.mostOrthogonalAxis=function(t,e){var r=a.normalize(t,h);return a.abs(r,r),e=r.x<=r.y?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Y,e)},a.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y},a.equalsArray=function(t,e,r){return t.x===e[r]&&t.y===e[r+1]},a.equalsEpsilon=function(t,r,n,a){return t===r||e(t)&&e(r)&&i.equalsEpsilon(t.x,r.x,n,a)&&i.equalsEpsilon(t.y,r.y,n,a)},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,r){return a.equalsEpsilon(this,t,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,i){"use strict";var a=function(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)};a.fromSpherical=function(r,n){e(n)||(n=new a);var i=r.clock,o=r.cone,u=t(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(i),n.y=s*Math.sin(i),n.z=u*Math.cos(o),n},a.fromElements=function(t,r,n,i){return e(i)?(i.x=t,i.y=r,i.z=n,i):new a(t,r,n)},a.clone=function(t,r){return e(t)?e(r)?(r.x=t.x,r.y=t.y,r.z=t.z,r):new a(t.x,t.y,t.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z},a.unpack=function(r,n,i){return n=t(n,0),e(i)||(i=new a),i.x=r[n++],i.y=r[n++],i.z=r[n],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,e,r){return r.x=Math.min(t.x,e.x),r.y=Math.min(t.y,e.y),r.z=Math.min(t.z,e.z),r},a.maximumByComponent=function(t,e,r){return r.x=Math.max(t.x,e.x),r.y=Math.max(t.y,e.y),r.z=Math.max(t.z,e.z),r},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var r=a.magnitude(t);return e.x=t.x/r,e.y=t.y/r,e.z=t.z/r,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},a.multiplyComponents=function(t,e,r){return r.x=t.x*e.x,r.y=t.y*e.y,r.z=t.z*e.z,r},a.add=function(t,e,r){return r.x=t.x+e.x,r.y=t.y+e.y,r.z=t.z+e.z,r},a.subtract=function(t,e,r){return r.x=t.x-e.x,r.y=t.y-e.y,r.z=t.z-e.z,r},a.multiplyByScalar=function(t,e,r){return r.x=t.x*e,r.y=t.y*e,r.z=t.z*e,r},a.divideByScalar=function(t,e,r){return r.x=t.x/e,r.y=t.y/e,r.z=t.z/e,r},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var u=new a;a.lerp=function(t,e,r,n){return a.multiplyByScalar(e,r,u),n=a.multiplyByScalar(t,1-r,n),a.add(u,n,n)};var s=new a,c=new a;a.angleBetween=function(t,e){a.normalize(t,s),a.normalize(e,c);var r=a.dot(s,c),n=a.magnitude(a.cross(s,c,s));return Math.atan2(n,r)};var h=new a;a.mostOrthogonalAxis=function(t,e){var r=a.normalize(t,h);return a.abs(r,r),e=r.x<=r.y?r.x<=r.z?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Z,e):r.y<=r.z?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_Z,e)},a.equals=function(t,r){return t===r||e(t)&&e(r)&&t.x===r.x&&t.y===r.y&&t.z===r.z},a.equalsArray=function(t,e,r){return t.x===e[r]&&t.y===e[r+1]&&t.z===e[r+2]},a.equalsEpsilon=function(t,r,n,a){return t===r||e(t)&&e(r)&&i.equalsEpsilon(t.x,r.x,n,a)&&i.equalsEpsilon(t.y,r.y,n,a)&&i.equalsEpsilon(t.z,r.z,n,a)},a.cross=function(t,e,r){var n=t.x,i=t.y,a=t.z,o=e.x,u=e.y,s=e.z,c=i*s-a*u,h=a*o-n*s,d=n*u-i*o;return r.x=c,r.y=h,r.z=d,r},a.fromDegrees=function(t,e,r,n,o){var u=i.toRadians(t),s=i.toRadians(e);return a.fromRadians(u,s,r,n,o)};var d=new a,f=new a,l=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(r,n,i,o,u){i=t(i,0);var s=e(o)?o.radiiSquared:l,c=Math.cos(n);d.x=c*Math.cos(r),d.y=c*Math.sin(r),d.z=Math.sin(n),d=a.normalize(d,d),a.multiplyComponents(s,d,f);var h=Math.sqrt(a.dot(d,f));return f=a.divideByScalar(f,h,f),d=a.multiplyByScalar(d,i,d),e(u)||(u=new a),a.add(f,d,u)},a.fromDegreesArray=function(t,e,r){for(var n=new Array(t.length),o=0;o<t.length;o++)n[o]=i.toRadians(t[o]);return a.fromRadiansArray(n,e,r)},a.fromRadiansArray=function(t,r,n){var i=t.length;e(n)?n.length=i/2:n=new Array(i/2);for(var o=0;i>o;o+=2){var u=t[o],s=t[o+1];n[o/2]=a.fromRadians(u,s,0,r,n[o/2])}return n},a.fromDegreesArrayHeights=function(t,e,r){for(var n=new Array(t.length),o=0;o<t.length;o+=3)n[o]=i.toRadians(t[o]),n[o+1]=i.toRadians(t[o+1]),n[o+2]=t[o+2];return a.fromRadiansArrayHeights(n,e,r)},a.fromRadiansArrayHeights=function(t,r,n){var i=t.length;e(n)?n.length=i/3:n=new Array(i/3);for(var o=0;i>o;o+=3){var u=t[o],s=t[o+1],c=t[o+2];n[o/3]=a.fromRadians(u,s,c,r,n[o/3])}return n},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,r){return a.equalsEpsilon(this,t,e,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(t,e,r,n,i){"use strict";var a={};a.octEncode=function(t,e){if(e.x=t.x/(Math.abs(t.x)+Math.abs(t.y)+Math.abs(t.z)),e.y=t.y/(Math.abs(t.x)+Math.abs(t.y)+Math.abs(t.z)),t.z<0){var r=e.x,n=e.y;e.x=(1-Math.abs(n))*i.signNotZero(r),e.y=(1-Math.abs(r))*i.signNotZero(n)}return e.x=i.toSNorm(e.x),e.y=i.toSNorm(e.y),e},a.octDecode=function(t,r,n){if(n.x=i.fromSNorm(t),n.y=i.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var a=n.x;n.x=(1-Math.abs(n.y))*i.signNotZero(a),n.y=(1-Math.abs(a))*i.signNotZero(n.y)}return e.normalize(n,n)},a.octPackFloat=function(t){return 256*t.x+t.y};var o=new t;return a.octEncodeFloat=function(t){return a.octEncode(t,o),a.octPackFloat(o)},a.octDecodeFloat=function(t,e){var r=t/256,n=Math.floor(r),i=256*(r-n);return a.octDecode(n,i,e)},a.octPack=function(t,e,r,n){var i=a.octEncodeFloat(t),u=a.octEncodeFloat(e),s=a.octEncode(r,o);return n.x=65536*s.x+i,n.y=65536*s.y+u,n},a.octUnpack=function(t,e,r,n){var i=t.x/65536,o=Math.floor(i),u=65536*(i-o);i=t.y/65536;var s=Math.floor(i),c=65536*(i-s);a.octDecodeFloat(u,e),a.octDecodeFloat(c,r),a.octDecode(o,s,n)},a.compressTextureCoordinates=function(t){var e=1===t.x?4095:0|4096*t.x,r=1===t.y?4095:0|4096*t.y;return 4096*e+r},a.decompressTextureCoordinates=function(t,e){var r=t/4096;return e.x=Math.floor(r)/4096,e.y=r-Math.floor(r),e},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,i){"use strict";var a=function(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)};return a.fromRadians=function(r,n,i,o){return i=t(i,0),e(o)?(o.longitude=r,o.latitude=n,o.height=i,o):new a(r,n,i)},a.fromDegrees=function(t,e,r,n){return t=i.toRadians(t),e=i.toRadians(e),a.fromRadians(t,e,r,n)},a.clone=function(t,r){return e(t)?e(r)?(r.longitude=t.longitude,r.latitude=t.latitude,r.height=t.height,r):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,r){return t===r||e(t)&&e(r)&&t.longitude===r.longitude&&t.latitude===r.latitude&&t.height===r.height},a.equalsEpsilon=function(t,r,n){return t===r||e(t)&&e(r)&&Math.abs(t.longitude-r.longitude)<=n&&Math.abs(t.latitude-r.latitude)<=n&&Math.abs(t.height-r.height)<=n},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),r=Object.defineProperties;return e&&t(r)||(r=function(t){return t}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n,i,a,o,u){"use strict";function s(e,n,i,a){n=r(n,0),i=r(i,0),a=r(a,0),e._radii=new t(n,i,a),e._radiiSquared=new t(n*n,i*i,a*a),e._radiiToTheFourth=new t(n*n*n*n,i*i*i*i,a*a*a*a),e._oneOverRadii=new t(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),e._oneOverRadiiSquared=new t(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),e._minimumRadius=Math.min(n,i,a),e._maximumRadius=Math.max(n,i,a),e._centerToleranceSquared=u.EPSILON1}var c=function(t,e,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,t,e,r)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(e,r){if(!n(e))return void 0;var i=e._radii;return n(r)?(t.clone(i,r._radii),t.clone(e._radiiSquared,r._radiiSquared),t.clone(e._radiiToTheFourth,r._radiiToTheFourth),t.clone(e._oneOverRadii,r._oneOverRadii),t.clone(e._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=e._minimumRadius,r._maximumRadius=e._maximumRadius,r._centerToleranceSquared=e._centerToleranceSquared,r):new c(i.x,i.y,i.z)},c.fromCartesian3=function(t,e){return n(e)||(e=new c),n(t)?(s(e,t.x,t.y,t.z),e):e},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(t){return c.clone(this,t)},c.packedLength=t.packedLength,c.pack=function(e,n,i){i=r(i,0),t.pack(e._radii,n,i)},c.unpack=function(e,n,i){n=r(n,0);var a=t.unpack(e,n);return c.fromCartesian3(a,i)},c.prototype.geocentricSurfaceNormal=t.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(e,r){var i=e.longitude,a=e.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return n(r)||(r=new t),r.x=u,r.y=s,r.z=c,t.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(e,r){return n(r)||(r=new t),r=t.multiplyComponents(e,this._oneOverRadiiSquared,r),t.normalize(r,r)};var h=new t,d=new t;c.prototype.cartographicToCartesian=function(e,r){var i=h,a=d;this.geodeticSurfaceNormalCartographic(e,i),t.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(t.dot(i,a));return t.divideByScalar(a,o,a),t.multiplyByScalar(i,e.height,i),n(r)||(r=new t),t.add(a,i,r)},c.prototype.cartographicArrayToCartesianArray=function(t,e){var r=t.length;n(e)?e.length=r:e=new Array(r);for(var i=0;r>i;i++)e[i]=this.cartographicToCartesian(t[i],e[i]);return e};var f=new t,l=new t,m=new t;c.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,l);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=t.subtract(r,a,m),c=Math.atan2(o.y,o.x),h=Math.asin(o.z),d=u.sign(t.dot(s,r))*t.magnitude(s);return n(i)?(i.longitude=c,i.latitude=h,i.height=d,i):new e(c,h,d)},c.prototype.cartesianArrayToCartographicArray=function(t,e){var r=t.length;n(e)?e.length=r:e=new Array(r);for(var i=0;r>i;++i)e[i]=this.cartesianToCartographic(t[i],e[i]);return e};var y=new t,p=new t;return c.prototype.scaleToGeodeticSurface=function(e,r){var i=e.x,a=e.y,o=e.z,s=this._oneOverRadii,c=s.x,h=s.y,d=s.z,f=i*i*c*c,l=a*a*h*h,m=o*o*d*d,x=f+l+m,g=Math.sqrt(1/x),v=t.multiplyByScalar(e,g,y);if(x<this._centerToleranceSquared)return isFinite(g)?t.clone(v,r):void 0;var E=this._oneOverRadiiSquared,S=E.x,_=E.y,M=E.z,I=p;I.x=2*v.x*S,I.y=2*v.y*_,I.z=2*v.z*M;var R,w,N,T,z,O,P,A,C,q,b,D=(1-g)*t.magnitude(e)/(.5*t.magnitude(I)),L=0;do{D-=L,N=1/(1+D*S),T=1/(1+D*_),z=1/(1+D*M),O=N*N,P=T*T,A=z*z,C=O*N,q=P*T,b=A*z,R=f*O+l*P+m*A-1,w=f*C*S+l*q*_+m*b*M;var U=-2*w;L=R/U}while(Math.abs(R)>u.EPSILON12);return n(r)?(r.x=i*N,r.y=a*T,r.z=o*z,r):new t(i*N,a*T,o*z)},c.prototype.scaleToGeocentricSurface=function(e,r){n(r)||(r=new t);var i=e.x,a=e.y,o=e.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return t.multiplyByScalar(e,s,r)},c.prototype.transformPositionToScaledSpace=function(e,r){return n(r)||(r=new t),t.multiplyComponents(e,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(e,r){return n(r)||(r=new t),t.multiplyComponents(e,this._radii,r)},c.prototype.equals=function(e){return this===e||n(e)&&t.equals(this._radii,e._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,r,n){"use strict";var i={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return i.getSizeInBytes=function(t){switch(t){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(t,e){return t>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},i.createTypedArrayFromArrayBuffer=function(t,e,r,i){return t>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(e,r,i):new Uint16Array(e,r,i)},r(i)}),define("Core/formatError",["./defined"],function(t){"use strict";var e=function(e){var r,n=e.name,i=e.message;r=t(n)&&t(i)?n+": "+i:e.toString();var a=e.stack;return t(a)&&(r+="\n"+a),r};return e}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(t,e,r){"use strict";var n=function(n){var i,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=n(s.parameters,a)}catch(c){o.error=c instanceof Error?{name:c.name,message:c.message,stack:c.stack}:c}e(i)||(i=t(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{i(o,a)}catch(c){o.result=void 0,o.error="postMessage failed with error: "+r(c)+"\n  with responseMessage: "+JSON.stringify(o),i(o)}}};return n}),define("Workers/createVerticesFromQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/IndexDatatype","../Core/Math","./createTaskProcessorWorker"],function(t,e,r,n,i,a,o,u,s){"use strict";function c(e,r){var n=e.quantizedVertices,s=n.length/3,c=e.octEncodedNormals,_=e.westIndices.length+e.eastIndices.length+e.southIndices.length+e.northIndices.length,M=e.minimumHeight,I=e.maximumHeight,R=e.relativeToCenter,w=e.rectangle,N=w.west,T=w.south,z=w.east,O=w.north,P=a.clone(e.ellipsoid),A=n.subarray(0,s),C=n.subarray(s,2*s),q=n.subarray(2*s,3*s),b=i(c),D=6;b&&(D+=1);for(var L=new Float32Array(s*D+_*D),U=0,k=0,B=0;s>U;++U,k+=D,B+=2){var F=A[U]/d,G=C[U]/d,W=u.lerp(M,I,q[U]/d);E.longitude=u.lerp(N,z,F),E.latitude=u.lerp(T,O,G),E.height=W,P.cartographicToCartesian(E,v),L[k+f]=v.x-R.x,L[k+l]=v.y-R.y,L[k+m]=v.z-R.z,L[k+y]=W,L[k+p]=F,L[k+x]=G,b&&(S.x=c[B],S.y=c[B+1],L[k+g]=t.octPackFloat(S))}var V=Math.max(0,2*(_-4)),Y=e.indices.length+3*V,H=o.createTypedArray(s+_,Y);H.set(e.indices,0);var K=s*D,Z=e.indices.length;return Z=h(L,K,H,Z,e.westIndices,R,P,w,e.westSkirtHeight,!0,b),K+=e.westIndices.length*D,Z=h(L,K,H,Z,e.southIndices,R,P,w,e.southSkirtHeight,!1,b),K+=e.southIndices.length*D,Z=h(L,K,H,Z,e.eastIndices,R,P,w,e.eastSkirtHeight,!1,b),K+=e.eastIndices.length*D,Z=h(L,K,H,Z,e.northIndices,R,P,w,e.northSkirtHeight,!0,b),K+=e.northIndices.length*D,r.push(L.buffer,H.buffer),{vertices:L.buffer,indices:H.buffer}}function h(t,e,n,i,a,o,s,c,h,d,f){var l,m,S,_=6;f&&(_+=1),d?(l=a.length-1,m=-1,S=-1):(l=0,m=a.length,S=1);var M=-1,I=e/_,R=c.north,w=c.south,N=c.east,T=c.west;T>N&&(N+=u.TWO_PI);for(var z=l;z!==m;z+=S){var O=a[z],P=O*_,A=t[P+p],C=t[P+x],q=t[P+y];E.longitude=u.lerp(T,N,A),E.latitude=u.lerp(w,R,C),E.height=q-h;var b=s.cartographicToCartesian(E,v);r.subtract(b,o,b),t[e++]=b.x,t[e++]=b.y,t[e++]=b.z,t[e++]=E.height,t[e++]=A,t[e++]=C,f&&(t[e++]=t[P+g]),-1!==M&&(n[i++]=M,n[i++]=I-1,n[i++]=O,n[i++]=I-1,n[i++]=I,n[i++]=O),M=O,++I}return i}var d=32767,f=0,l=1,m=2,y=3,p=4,x=5,g=6,v=new r,E=new n,S=new e;return s(c)})}();