/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var t=function(t){return void 0!==t};return t}),define("Core/freezeObject",["./defined"],function(t){"use strict";var e=Object.freeze;return t(e)||(e=function(t){return t}),e}),define("Core/defaultValue",["./freezeObject"],function(t){"use strict";var e=function(t,e){return void 0!==t?t:e};return e.EMPTY_OBJECT=t({}),e}),define("Core/DeveloperError",["./defined"],function(t){"use strict";var e=function(t){this.name="DeveloperError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e.throwInstantiationError=function(){throw new e("This function defines an interface and should not be called directly.")},e}),define("ThirdParty/mersenne-twister",[],function(){var t=function(t){void 0==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(t)};return t.prototype.init_genrand=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){var t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},t.prototype.genrand_int32=function(){var t,e=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^e[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^e[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^e[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=2636928640&t<<7,t^=4022730752&t<<15,t^=t>>>18,t>>>0},t.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},t}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(t,e){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(t){return t>0?1:0>t?-1:0},n.signNotZero=function(t){return 0>t?-1:1},n.toSNorm=function(t){return Math.round(255*(.5*n.clamp(t,-1,1)+.5))},n.fromSNorm=function(t){return 2*(n.clamp(t,0,255)/255)-1},n.sinh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e-n)},n.cosh=function(t){var e=Math.pow(Math.E,t),n=Math.pow(Math.E,-1*t);return.5*(e+n)},n.lerp=function(t,e,n){return(1-n)*t+n*e},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(t){return t*n.RADIANS_PER_DEGREE},n.toDegrees=function(t){return t*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(t){var e=n.TWO_PI,r=t-Math.floor(t/e)*e;return r<-Math.PI?r+e:r>=Math.PI?r-e:r},n.negativePiToPi=function(t){return n.zeroToTwoPi(t+n.PI)-n.PI},n.zeroToTwoPi=function(t){var e=n.mod(t,n.TWO_PI);return Math.abs(e)<n.EPSILON14&&Math.abs(t)>n.EPSILON14?n.TWO_PI:e},n.mod=function(t,e){return(t%e+e)%e},n.equalsEpsilon=function(t,n,r,i){i=e(i,r);var a=Math.abs(t-n);return i>=a||a<=r*Math.max(Math.abs(t),Math.abs(n))};var r=[1];n.factorial=function(t){var e=r.length;if(t>=e)for(var n=r[e-1],i=e;t>=i;i++)r.push(n*i);return r[t]},n.incrementWrap=function(t,n,r){return r=e(r,0),++t,t>n&&(t=r),t},n.isPowerOfTwo=function(t){return 0!==t&&0===(t&t-1)},n.nextPowerOfTwo=function(t){return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t,t},n.clamp=function(t,e,n){return e>t?e:t>n?n:t};var i=new t;return n.setRandomNumberSeed=function(e){i=new t(e)},n.nextRandomNumber=function(){return i.random()},n.acosClamped=function(t){return Math.acos(n.clamp(t,-1,1))},n.asinClamped=function(t){return Math.asin(n.clamp(t,-1,1))},n.chordLength=function(t,e){return 2*e*Math.sin(.5*t)},n}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n){this.x=t(e,0),this.y=t(n,0)};a.fromElements=function(t,n,r){return e(r)?(r.x=t,r.y=n,r):new a(t,n)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n):new a(t.x,t.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r]=e.y},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y)},a.minimumComponent=function(t){return Math.min(t.x,t.y)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(t,e){return a.normalize(t,s),a.normalize(e,c),i.acosClamped(a.dot(s,c))};var h=new a;return a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,h);return a.abs(n,n),e=n.x<=n.y?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Y,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)},a.ZERO=r(new a(0,0)),a.UNIT_X=r(new a(1,0)),a.UNIT_Y=r(new a(0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)};a.fromSpherical=function(n,r){e(r)||(r=new a);var i=n.clock,o=n.cone,u=t(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(i),r.y=s*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(t,n,r,i){return e(i)?(i.x=t,i.y=n,i.z=r,i):new a(t,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n):new a(t.x,t.y,t.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(t,e){a.normalize(t,s),a.normalize(e,c);var n=a.dot(s,c),r=a.magnitude(a.cross(s,c,s));return Math.atan2(r,n)};var h=new a;a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,h);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,e):a.clone(a.UNIT_Z,e):n.y<=n.z?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_Z,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)},a.cross=function(t,e,n){var r=t.x,i=t.y,a=t.z,o=e.x,u=e.y,s=e.z,c=i*s-a*u,h=a*o-r*s,l=r*u-i*o;return n.x=c,n.y=h,n.z=l,n},a.fromDegrees=function(t,e,n,r,o){var u=i.toRadians(t),s=i.toRadians(e);return a.fromRadians(u,s,n,r,o)};var l=new a,f=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=t(i,0);var s=e(o)?o.radiiSquared:d,c=Math.cos(r);l.x=c*Math.cos(n),l.y=c*Math.sin(n),l.z=Math.sin(r),l=a.normalize(l,l),a.multiplyComponents(s,l,f);var h=Math.sqrt(a.dot(l,f));return f=a.divideByScalar(f,h,f),l=a.multiplyByScalar(l,i,l),e(u)||(u=new a),a.add(f,l,u)},a.fromDegreesArray=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o++)r[o]=i.toRadians(t[o]);return a.fromRadiansArray(r,e,n)},a.fromRadiansArray=function(t,n,r){var i=t.length;e(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=t[o],s=t[o+1];r[o/2]=a.fromRadians(u,s,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(t,e,n){for(var r=new Array(t.length),o=0;o<t.length;o+=3)r[o]=i.toRadians(t[o]),r[o+1]=i.toRadians(t[o+1]),r[o+2]=t[o+2];return a.fromRadiansArrayHeights(r,e,n)},a.fromRadiansArrayHeights=function(t,n,r){var i=t.length;e(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=t[o],s=t[o+1],c=t[o+2];r[o/3]=a.fromRadians(u,s,c,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(t,e,n,r,i){"use strict";var a={};a.octEncode=function(t,e){if(e.x=t.x/(Math.abs(t.x)+Math.abs(t.y)+Math.abs(t.z)),e.y=t.y/(Math.abs(t.x)+Math.abs(t.y)+Math.abs(t.z)),t.z<0){var n=e.x,r=e.y;e.x=(1-Math.abs(r))*i.signNotZero(n),e.y=(1-Math.abs(n))*i.signNotZero(r)}return e.x=i.toSNorm(e.x),e.y=i.toSNorm(e.y),e},a.octDecode=function(t,n,r){if(r.x=i.fromSNorm(t),r.y=i.fromSNorm(n),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var a=r.x;r.x=(1-Math.abs(r.y))*i.signNotZero(a),r.y=(1-Math.abs(a))*i.signNotZero(r.y)}return e.normalize(r,r)},a.octPackFloat=function(t){return 256*t.x+t.y};var o=new t;return a.octEncodeFloat=function(t){return a.octEncode(t,o),a.octPackFloat(o)},a.octDecodeFloat=function(t,e){var n=t/256,r=Math.floor(n),i=256*(n-r);return a.octDecode(r,i,e)},a.octPack=function(t,e,n,r){var i=a.octEncodeFloat(t),u=a.octEncodeFloat(e),s=a.octEncode(n,o);return r.x=65536*s.x+i,r.y=65536*s.y+u,r},a.octUnpack=function(t,e,n,r){var i=t.x/65536,o=Math.floor(i),u=65536*(i-o);i=t.y/65536;var s=Math.floor(i),c=65536*(i-s);a.octDecodeFloat(u,e),a.octDecodeFloat(c,n),a.octDecode(o,s,r)},a.compressTextureCoordinates=function(t){var e=1===t.x?4095:0|4096*t.x,n=1===t.y?4095:0|4096*t.y;return 4096*e+n},a.decompressTextureCoordinates=function(t,e){var n=t/4096;return e.x=Math.floor(n)/4096,e.y=n-Math.floor(n),e},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)};return a.fromRadians=function(n,r,i,o){return i=t(i,0),e(o)?(o.longitude=n,o.latitude=r,o.height=i,o):new a(n,r,i)},a.fromDegrees=function(t,e,n,r){return t=i.toRadians(t),e=i.toRadians(e),a.fromRadians(t,e,n,r)},a.clone=function(t,n){return e(t)?e(n)?(n.longitude=t.longitude,n.latitude=t.latitude,n.height=t.height,n):new a(t.longitude,t.latitude,t.height):void 0},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.longitude===n.longitude&&t.latitude===n.latitude&&t.height===n.height},a.equalsEpsilon=function(t,n,r){return t===n||e(t)&&e(n)&&Math.abs(t.longitude-n.longitude)<=r&&Math.abs(t.latitude-n.latitude)<=r&&Math.abs(t.height-n.height)<=r},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e){return a.equalsEpsilon(this,t,e)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(t){"use strict";var e=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(t){return!1}}(),n=Object.defineProperties;return e&&t(n)||(n=function(t){return t}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";function s(e,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),e._radii=new t(r,i,a),e._radiiSquared=new t(r*r,i*i,a*a),e._radiiToTheFourth=new t(r*r*r*r,i*i*i*i,a*a*a*a),e._oneOverRadii=new t(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),e._oneOverRadiiSquared=new t(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),e._minimumRadius=Math.min(r,i,a),e._maximumRadius=Math.max(r,i,a),e._centerToleranceSquared=u.EPSILON1}var c=function(t,e,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,t,e,n)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(e,n){if(!r(e))return void 0;var i=e._radii;return r(n)?(t.clone(i,n._radii),t.clone(e._radiiSquared,n._radiiSquared),t.clone(e._radiiToTheFourth,n._radiiToTheFourth),t.clone(e._oneOverRadii,n._oneOverRadii),t.clone(e._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=e._minimumRadius,n._maximumRadius=e._maximumRadius,n._centerToleranceSquared=e._centerToleranceSquared,n):new c(i.x,i.y,i.z)},c.fromCartesian3=function(t,e){return r(e)||(e=new c),r(t)?(s(e,t.x,t.y,t.z),e):e},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(t){return c.clone(this,t)},c.packedLength=t.packedLength,c.pack=function(e,r,i){i=n(i,0),t.pack(e._radii,r,i)},c.unpack=function(e,r,i){r=n(r,0);var a=t.unpack(e,r);return c.fromCartesian3(a,i)},c.prototype.geocentricSurfaceNormal=t.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(e,n){var i=e.longitude,a=e.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return r(n)||(n=new t),n.x=u,n.y=s,n.z=c,t.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(e,n){return r(n)||(n=new t),n=t.multiplyComponents(e,this._oneOverRadiiSquared,n),t.normalize(n,n)};var h=new t,l=new t;c.prototype.cartographicToCartesian=function(e,n){var i=h,a=l;this.geodeticSurfaceNormalCartographic(e,i),t.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(t.dot(i,a));return t.divideByScalar(a,o,a),t.multiplyByScalar(i,e.height,i),r(n)||(n=new t),t.add(a,i,n)},c.prototype.cartographicArrayToCartesianArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;i++)e[i]=this.cartographicToCartesian(t[i],e[i]);return e};var f=new t,d=new t,m=new t;c.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,d);if(!r(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=t.subtract(n,a,m),c=Math.atan2(o.y,o.x),h=Math.asin(o.z),l=u.sign(t.dot(s,n))*t.magnitude(s);return r(i)?(i.longitude=c,i.latitude=h,i.height=l,i):new e(c,h,l)},c.prototype.cartesianArrayToCartographicArray=function(t,e){var n=t.length;r(e)?e.length=n:e=new Array(n);for(var i=0;n>i;++i)e[i]=this.cartesianToCartographic(t[i],e[i]);return e};var p=new t,y=new t;return c.prototype.scaleToGeodeticSurface=function(e,n){var i=e.x,a=e.y,o=e.z,s=this._oneOverRadii,c=s.x,h=s.y,l=s.z,f=i*i*c*c,d=a*a*h*h,m=o*o*l*l,x=f+d+m,v=Math.sqrt(1/x),g=t.multiplyByScalar(e,v,p);if(x<this._centerToleranceSquared)return isFinite(v)?t.clone(g,n):void 0;var w=this._oneOverRadiiSquared,M=w.x,z=w.y,S=w.z,E=y;E.x=2*g.x*M,E.y=2*g.y*z,E.z=2*g.z*S;var I,O,_,R,b,N,T,C,P,q,A,U=(1-v)*t.magnitude(e)/(.5*t.magnitude(E)),B=0;do{U-=B,_=1/(1+U*M),R=1/(1+U*z),b=1/(1+U*S),N=_*_,T=R*R,C=b*b,P=N*_,q=T*R,A=C*b,I=f*N+d*T+m*C-1,O=f*P*M+d*q*z+m*A*S;var L=-2*O;B=I/L}while(Math.abs(I)>u.EPSILON12);return r(n)?(n.x=i*_,n.y=a*R,n.z=o*b,n):new t(i*_,a*R,o*b)},c.prototype.scaleToGeocentricSurface=function(e,n){r(n)||(n=new t);var i=e.x,a=e.y,o=e.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return t.multiplyByScalar(e,s,n)},c.prototype.transformPositionToScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(e,n){return r(n)||(n=new t),t.multiplyComponents(e,this._radii,n)},c.prototype.equals=function(e){return this===e||r(e)&&t.equals(this._radii,e._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(t,e,n,r,i,a,o){"use strict";var u=function(t){this._ellipsoid=n(t,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(e,n){var i=this._semimajorAxis,a=e.longitude*i,o=e.latitude*i,u=e.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new t(a,o,u)},u.prototype.unproject=function(t,n){var i=this._oneOverSemimajorAxis,a=t.x*i,o=t.y*i,u=t.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new e(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(t){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return t(e)}),define("Core/Interval",["./defaultValue"],function(t){"use strict";var e=function(e,n){this.start=t(e,0),this.stop=t(n,0)};return e}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i){"use strict";var a=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)};a.fromElements=function(t,n,r,i,o){return e(o)?(o.x=t,o.y=n,o.z=r,o.w=i,o):new a(t,n,r,i)},a.fromColor=function(t,n){return e(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(t,n){return e(t)?e(n)?(n.x=t.x,n.y=t.y,n.z=t.z,n.w=t.w,n):new a(t.x,t.y,t.z,t.w):void 0},a.packedLength=4,a.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},a.unpack=function(n,r,i){return r=t(r,0),e(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(t){return Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,e,n){return n.x=Math.min(t.x,e.x),n.y=Math.min(t.y,e.y),n.z=Math.min(t.z,e.z),n.w=Math.min(t.w,e.w),n},a.maximumByComponent=function(t,e,n){return n.x=Math.max(t.x,e.x),n.y=Math.max(t.y,e.y),n.z=Math.max(t.z,e.z),n.w=Math.max(t.w,e.w),n},a.magnitudeSquared=function(t){return t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(t){return Math.sqrt(a.magnitudeSquared(t))};var o=new a;a.distance=function(t,e){return a.subtract(t,e,o),a.magnitude(o)},a.distanceSquared=function(t,e){return a.subtract(t,e,o),a.magnitudeSquared(o)},a.normalize=function(t,e){var n=a.magnitude(t);return e.x=t.x/n,e.y=t.y/n,e.z=t.z/n,e.w=t.w/n,e},a.dot=function(t,e){return t.x*e.x+t.y*e.y+t.z*e.z+t.w*e.w},a.multiplyComponents=function(t,e,n){return n.x=t.x*e.x,n.y=t.y*e.y,n.z=t.z*e.z,n.w=t.w*e.w,n},a.add=function(t,e,n){return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n.w=t.w+e.w,n},a.subtract=function(t,e,n){return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n.w=t.w-e.w,n},a.multiplyByScalar=function(t,e,n){return n.x=t.x*e,n.y=t.y*e,n.z=t.z*e,n.w=t.w*e,n},a.divideByScalar=function(t,e,n){return n.x=t.x/e,n.y=t.y/e,n.z=t.z/e,n.w=t.w/e,n},a.negate=function(t,e){return e.x=-t.x,e.y=-t.y,e.z=-t.z,e.w=-t.w,e},a.abs=function(t,e){return e.x=Math.abs(t.x),e.y=Math.abs(t.y),e.z=Math.abs(t.z),e.w=Math.abs(t.w),e};var u=new a;a.lerp=function(t,e,n,r){return a.multiplyByScalar(e,n,u),r=a.multiplyByScalar(t,1-n,r),a.add(u,r,r)};var s=new a;return a.mostOrthogonalAxis=function(t,e){var n=a.normalize(t,s);return a.abs(n,n),e=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,e):a.clone(a.UNIT_W,e):n.z<=n.w?a.clone(a.UNIT_Z,e):a.clone(a.UNIT_W,e)},a.equals=function(t,n){return t===n||e(t)&&e(n)&&t.x===n.x&&t.y===n.y&&t.z===n.z&&t.w===n.w},a.equalsArray=function(t,e,n){return t.x===e[n]&&t.y===e[n+1]&&t.z===e[n+2]&&t.w===e[n+3]},a.equalsEpsilon=function(t,n,r,a){return t===n||e(t)&&e(n)&&i.equalsEpsilon(t.x,n.x,r,a)&&i.equalsEpsilon(t.y,n.y,r,a)&&i.equalsEpsilon(t.z,n.z,r,a)&&i.equalsEpsilon(t.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(t){return a.clone(this,t)},a.prototype.equals=function(t){return a.equals(this,t)},a.prototype.equalsEpsilon=function(t,e,n){return a.equalsEpsilon(this,t,e,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r,i,a){"use strict";function o(t){for(var e=0,n=0;9>n;++n){var r=t[n];e+=r*r}return Math.sqrt(e)}function u(t){for(var e=0,n=0;3>n;++n){var r=t[c.getElementIndex(d[n],f[n])];e+=2*r*r}return Math.sqrt(e)}function s(t,e){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(t[c.getElementIndex(d[o],f[o])]);u>r&&(i=o,r=u)}var s=1,h=0,l=f[i],m=d[i];if(Math.abs(t[c.getElementIndex(m,l)])>n){var p,y=t[c.getElementIndex(m,m)],x=t[c.getElementIndex(l,l)],v=t[c.getElementIndex(m,l)],g=(y-x)/2/v;p=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+p*p),h=p*s}return e=c.clone(c.IDENTITY,e),e[c.getElementIndex(l,l)]=e[c.getElementIndex(m,m)]=s,e[c.getElementIndex(m,l)]=h,e[c.getElementIndex(l,m)]=-h,e}var c=function(t,n,r,i,a,o,u,s,c){this[0]=e(t,0),this[1]=e(i,0),this[2]=e(u,0),this[3]=e(n,0),this[4]=e(a,0),this[5]=e(s,0),this[6]=e(r,0),this[7]=e(o,0),this[8]=e(c,0)};c.packedLength=9,c.pack=function(t,n,r){r=e(r,0),n[r++]=t[0],n[r++]=t[1],n[r++]=t[2],n[r++]=t[3],n[r++]=t[4],n[r++]=t[5],n[r++]=t[6],n[r++]=t[7],n[r++]=t[8]},c.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new c),i[0]=t[r++],i[1]=t[r++],i[2]=t[r++],i[3]=t[r++],i[4]=t[r++],i[5]=t[r++],i[6]=t[r++],i[7]=t[r++],i[8]=t[r++],i},c.clone=function(t,e){return n(t)?n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):new c(t[0],t[3],t[6],t[1],t[4],t[7],t[2],t[5],t[8]):void 0},c.fromArray=function(t,r,i){return r=e(r,0),n(i)||(i=new c),i[0]=t[r],i[1]=t[r+1],i[2]=t[r+2],i[3]=t[r+3],i[4]=t[r+4],i[5]=t[r+5],i[6]=t[r+6],i[7]=t[r+7],i[8]=t[r+8],i},c.fromColumnMajorArray=function(t,e){return c.clone(t,e)},c.fromRowMajorArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],e):new c(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},c.fromQuaternion=function(t,e){var r=t.x*t.x,i=t.x*t.y,a=t.x*t.z,o=t.x*t.w,u=t.y*t.y,s=t.y*t.z,h=t.y*t.w,l=t.z*t.z,f=t.z*t.w,d=t.w*t.w,m=r-u-l+d,p=2*(i-f),y=2*(a+h),x=2*(i+f),v=-r+u-l+d,g=2*(s-o),w=2*(a-h),M=2*(s+o),z=-r-u+l+d;return n(e)?(e[0]=m,e[1]=x,e[2]=w,e[3]=p,e[4]=v,e[5]=M,e[6]=y,e[7]=g,e[8]=z,e):new c(m,p,y,x,v,g,w,M,z)},c.fromScale=function(t,e){return n(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=t.y,e[5]=0,e[6]=0,e[7]=0,e[8]=t.z,e):new c(t.x,0,0,0,t.y,0,0,0,t.z)},c.fromUniformScale=function(t,e){return n(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=t,e[5]=0,e[6]=0,e[7]=0,e[8]=t,e):new c(t,0,0,0,t,0,0,0,t)},c.fromCrossProduct=function(t,e){return n(e)?(e[0]=0,e[1]=t.z,e[2]=-t.y,e[3]=-t.z,e[4]=0,e[5]=t.x,e[6]=t.y,e[7]=-t.x,e[8]=0,e):new c(0,-t.z,t.y,t.z,0,-t.x,-t.y,t.x,0)},c.fromRotationX=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=r,e[5]=i,e[6]=0,e[7]=-i,e[8]=r,e):new c(1,0,0,0,r,-i,0,i,r)},c.fromRotationY=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=0,e[2]=-i,e[3]=0,e[4]=1,e[5]=0,e[6]=i,e[7]=0,e[8]=r,e):new c(r,0,i,0,1,0,-i,0,r)},c.fromRotationZ=function(t,e){var r=Math.cos(t),i=Math.sin(t);return n(e)?(e[0]=r,e[1]=i,e[2]=0,e[3]=-i,e[4]=r,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e):new c(r,-i,0,i,r,0,0,0,1)},c.toArray=function(t,e){return n(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},c.getElementIndex=function(t,e){return 3*t+e},c.getColumn=function(t,e,n){var r=3*e,i=t[r],a=t[r+1],o=t[r+2];return n.x=i,n.y=a,n.z=o,n},c.setColumn=function(t,e,n,r){r=c.clone(t,r);var i=3*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},c.getRow=function(t,e,n){var r=t[e],i=t[e+3],a=t[e+6];return n.x=r,n.y=i,n.z=a,n},c.setRow=function(t,e,n,r){return r=c.clone(t,r),r[e]=n.x,r[e+3]=n.y,r[e+6]=n.z,r};var h=new t;c.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],h)),n.y=t.magnitude(t.fromElements(e[3],e[4],e[5],h)),n.z=t.magnitude(t.fromElements(e[6],e[7],e[8],h)),n};var l=new t;c.getMaximumScale=function(e){return c.getScale(e,l),t.maximumComponent(l)},c.multiply=function(t,e,n){var r=t[0]*e[0]+t[3]*e[1]+t[6]*e[2],i=t[1]*e[0]+t[4]*e[1]+t[7]*e[2],a=t[2]*e[0]+t[5]*e[1]+t[8]*e[2],o=t[0]*e[3]+t[3]*e[4]+t[6]*e[5],u=t[1]*e[3]+t[4]*e[4]+t[7]*e[5],s=t[2]*e[3]+t[5]*e[4]+t[8]*e[5],c=t[0]*e[6]+t[3]*e[7]+t[6]*e[8],h=t[1]*e[6]+t[4]*e[7]+t[7]*e[8],l=t[2]*e[6]+t[5]*e[7]+t[8]*e[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=h,n[8]=l,n},c.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n},c.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n},c.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[3]*i+t[6]*a,u=t[1]*r+t[4]*i+t[7]*a,s=t[2]*r+t[5]*i+t[8]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n},c.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e},c.transpose=function(t,e){var n=t[0],r=t[3],i=t[6],a=t[1],o=t[4],u=t[7],s=t[2],c=t[5],h=t[8];return e[0]=n,e[1]=r,e[2]=i,e[3]=a,e[4]=o,e[5]=u,e[6]=s,e[7]=c,e[8]=h,e};var f=[1,0,0],d=[2,2,1],m=new c,p=new c;return c.computeEigenDecomposition=function(t,e){var r=a.EPSILON20,i=10,h=0,l=0;n(e)||(e={});for(var f=e.unitary=c.clone(c.IDENTITY,e.unitary),d=e.diagonal=c.clone(t,e.diagonal),y=r*o(d);i>l&&u(d)>y;)s(d,m),c.transpose(m,p),c.multiply(d,m,d),c.multiply(p,d,d),c.multiply(f,m,f),++h>2&&(++l,h=0);return e},c.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e},c.determinant=function(t){var e=t[0],n=t[3],r=t[6],i=t[1],a=t[4],o=t[7],u=t[2],s=t[5],c=t[8];return e*(a*c-s*o)+i*(s*r-n*c)+u*(n*o-a*r)},c.inverse=function(t,e){var n=t[0],i=t[1],o=t[2],u=t[3],s=t[4],h=t[5],l=t[6],f=t[7],d=t[8],m=c.determinant(t);if(Math.abs(m)<=a.EPSILON15)throw new r("matrix is not invertible");e[0]=s*d-f*h,e[1]=f*o-i*d,e[2]=i*h-s*o,e[3]=l*h-u*d,e[4]=n*d-l*o,e[5]=u*o-n*h,e[6]=u*f-l*s,e[7]=l*i-n*f,e[8]=n*s-u*i;var p=1/m;return c.multiplyByScalar(e,p,e)},c.equals=function(t,e){return t===e||n(t)&&n(e)&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},c.equalsEpsilon=function(t,e,r){return t===e||n(t)&&n(e)&&Math.abs(t[0]-e[0])<=r&&Math.abs(t[1]-e[1])<=r&&Math.abs(t[2]-e[2])<=r&&Math.abs(t[3]-e[3])<=r&&Math.abs(t[4]-e[4])<=r&&Math.abs(t[5]-e[5])<=r&&Math.abs(t[6]-e[6])<=r&&Math.abs(t[7]-e[7])<=r&&Math.abs(t[8]-e[8])<=r},c.IDENTITY=i(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(t){return c.clone(this,t)},c.prototype.equals=function(t){return c.equals(this,t)},c.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]},c.prototype.equalsEpsilon=function(t,e){return c.equalsEpsilon(this,t,e)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(t){"use strict";var e=function(t){this.name="RuntimeError",this.message=t;var e;try{throw new Error}catch(n){e=n.stack}this.stack=e};return e.prototype.toString=function(){var e=this.name+": "+this.message;return t(this.stack)&&(e+="\n"+this.stack.toString()),e},e}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(t,e,n,r,i,a,o,u,s){"use strict";var c=function(t,e,r,i,a,o,u,s,c,h,l,f,d,m,p,y){this[0]=n(t,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(e,0),this[5]=n(o,0),this[6]=n(h,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(p,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(y,0)
};c.packedLength=16,c.pack=function(t,e,r){r=n(r,0),e[r++]=t[0],e[r++]=t[1],e[r++]=t[2],e[r++]=t[3],e[r++]=t[4],e[r++]=t[5],e[r++]=t[6],e[r++]=t[7],e[r++]=t[8],e[r++]=t[9],e[r++]=t[10],e[r++]=t[11],e[r++]=t[12],e[r++]=t[13],e[r++]=t[14],e[r]=t[15]},c.unpack=function(t,e,i){return e=n(e,0),r(i)||(i=new c),i[0]=t[e++],i[1]=t[e++],i[2]=t[e++],i[3]=t[e++],i[4]=t[e++],i[5]=t[e++],i[6]=t[e++],i[7]=t[e++],i[8]=t[e++],i[9]=t[e++],i[10]=t[e++],i[11]=t[e++],i[12]=t[e++],i[13]=t[e++],i[14]=t[e++],i[15]=t[e],i},c.clone=function(t,e){return r(t)?r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):new c(t[0],t[4],t[8],t[12],t[1],t[5],t[9],t[13],t[2],t[6],t[10],t[14],t[3],t[7],t[11],t[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(t,e){return c.clone(t,e)},c.fromRowMajorArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e):new c(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},c.fromRotationTranslation=function(e,i,a){return i=n(i,t.ZERO),r(a)?(a[0]=e[0],a[1]=e[1],a[2]=e[2],a[3]=0,a[4]=e[3],a[5]=e[4],a[6]=e[5],a[7]=0,a[8]=e[6],a[9]=e[7],a[10]=e[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new c(e[0],e[3],e[6],i.x,e[1],e[4],e[7],i.y,e[2],e[5],e[8],i.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(t,e,n,i){r(i)||(i=new c);var a=n.x,o=n.y,u=n.z,s=e.x*e.x,h=e.x*e.y,l=e.x*e.z,f=e.x*e.w,d=e.y*e.y,m=e.y*e.z,p=e.y*e.w,y=e.z*e.z,x=e.z*e.w,v=e.w*e.w,g=s-d-y+v,w=2*(h-x),M=2*(l+p),z=2*(h+x),S=-s+d-y+v,E=2*(m-f),I=2*(l-p),O=2*(m+f),_=-s-d+y+v;return i[0]=g*a,i[1]=z*a,i[2]=I*a,i[3]=0,i[4]=w*o,i[5]=S*o,i[6]=O*o,i[7]=0,i[8]=M*u,i[9]=E*u,i[10]=_*u,i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i},c.fromTranslation=function(t,e){return c.fromRotationTranslation(u.IDENTITY,t,e)},c.fromScale=function(t,e){return r(e)?(e[0]=t.x,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t.y,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t.z,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new c(t.x,0,0,0,0,t.y,0,0,0,0,t.z,0,0,0,0,1)},c.fromUniformScale=function(t,e){return r(e)?(e[0]=t,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e):new c(t,0,0,0,0,t,0,0,0,0,t,0,0,0,0,1)};var h=new t,l=new t,f=new t;c.fromCamera=function(e,n){var i=e.eye,a=e.target,o=e.up;t.normalize(t.subtract(a,i,h),h),t.normalize(t.cross(h,o,l),l),t.normalize(t.cross(l,h,f),f);var u=l.x,s=l.y,d=l.z,m=h.x,p=h.y,y=h.z,x=f.x,v=f.y,g=f.z,w=i.x,M=i.y,z=i.z,S=u*-w+s*-M+d*-z,E=x*-w+v*-M+g*-z,I=m*w+p*M+y*z;return r(n)?(n[0]=u,n[1]=x,n[2]=-m,n[3]=0,n[4]=s,n[5]=v,n[6]=-p,n[7]=0,n[8]=d,n[9]=g,n[10]=-y,n[11]=0,n[12]=S,n[13]=E,n[14]=I,n[15]=1,n):new c(u,s,d,S,x,v,g,E,-m,-p,-y,I,0,0,0,1)},c.computePerspectiveFieldOfView=function(t,e,n,r,i){var a=Math.tan(.5*t),o=1/a,u=o/e,s=(r+n)/(n-r),c=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},c.computeOrthographicOffCenter=function(t,e,n,r,i,a,o){var u=1/(e-t),s=1/(r-n),c=1/(a-i),h=-(e+t)*u,l=-(r+n)*s,f=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=h,o[13]=l,o[14]=f,o[15]=1,o},c.computePerspectiveOffCenter=function(t,e,n,r,i,a,o){var u=2*i/(e-t),s=2*i/(r-n),c=(e+t)/(e-t),h=(r+n)/(r-n),l=-(a+i)/(a-i),f=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=h,o[10]=l,o[11]=f,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(t,e,n,r,i,a){var o=2*i/(e-t),u=2*i/(r-n),s=(e+t)/(e-t),c=(r+n)/(r-n),h=-1,l=-1,f=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=h,a[11]=l,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},c.computeViewportTransformation=function(t,e,r,i){t=n(t,n.EMPTY_OBJECT);var a=n(t.x,0),o=n(t.y,0),u=n(t.width,0),s=n(t.height,0);e=n(e,0),r=n(r,1);var c=.5*u,h=.5*s,l=.5*(r-e),f=c,d=h,m=l,p=a+c,y=o+h,x=e+l,v=1;return i[0]=f,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=m,i[11]=0,i[12]=p,i[13]=y,i[14]=x,i[15]=v,i},c.toArray=function(t,e){return r(e)?(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e):[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},c.getElementIndex=function(t,e){return 4*t+e},c.getColumn=function(t,e,n){var r=4*e,i=t[r],a=t[r+1],o=t[r+2],u=t[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},c.setColumn=function(t,e,n,r){r=c.clone(t,r);var i=4*e;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},c.getRow=function(t,e,n){var r=t[e],i=t[e+4],a=t[e+8],o=t[e+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},c.setRow=function(t,e,n,r){return r=c.clone(t,r),r[e]=n.x,r[e+4]=n.y,r[e+8]=n.z,r[e+12]=n.w,r};var d=new t;c.getScale=function(e,n){return n.x=t.magnitude(t.fromElements(e[0],e[1],e[2],d)),n.y=t.magnitude(t.fromElements(e[4],e[5],e[6],d)),n.z=t.magnitude(t.fromElements(e[8],e[9],e[10],d)),n};var m=new t;c.getMaximumScale=function(e){return c.getScale(e,m),t.maximumComponent(m)},c.multiply=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[3],u=t[4],s=t[5],c=t[6],h=t[7],l=t[8],f=t[9],d=t[10],m=t[11],p=t[12],y=t[13],x=t[14],v=t[15],g=e[0],w=e[1],M=e[2],z=e[3],S=e[4],E=e[5],I=e[6],O=e[7],_=e[8],R=e[9],b=e[10],N=e[11],T=e[12],C=e[13],P=e[14],q=e[15],A=r*g+u*w+l*M+p*z,U=i*g+s*w+f*M+y*z,B=a*g+c*w+d*M+x*z,L=o*g+h*w+m*M+v*z,D=r*S+u*E+l*I+p*O,W=i*S+s*E+f*I+y*O,k=a*S+c*E+d*I+x*O,V=o*S+h*E+m*I+v*O,j=r*_+u*R+l*b+p*N,F=i*_+s*R+f*b+y*N,Y=a*_+c*R+d*b+x*N,Z=o*_+h*R+m*b+v*N,G=r*T+u*C+l*P+p*q,H=i*T+s*C+f*P+y*q,X=a*T+c*C+d*P+x*q,K=o*T+h*C+m*P+v*q;return n[0]=A,n[1]=U,n[2]=B,n[3]=L,n[4]=D,n[5]=W,n[6]=k,n[7]=V,n[8]=j,n[9]=F,n[10]=Y,n[11]=Z,n[12]=G,n[13]=H,n[14]=X,n[15]=K,n},c.add=function(t,e,n){return n[0]=t[0]+e[0],n[1]=t[1]+e[1],n[2]=t[2]+e[2],n[3]=t[3]+e[3],n[4]=t[4]+e[4],n[5]=t[5]+e[5],n[6]=t[6]+e[6],n[7]=t[7]+e[7],n[8]=t[8]+e[8],n[9]=t[9]+e[9],n[10]=t[10]+e[10],n[11]=t[11]+e[11],n[12]=t[12]+e[12],n[13]=t[13]+e[13],n[14]=t[14]+e[14],n[15]=t[15]+e[15],n},c.subtract=function(t,e,n){return n[0]=t[0]-e[0],n[1]=t[1]-e[1],n[2]=t[2]-e[2],n[3]=t[3]-e[3],n[4]=t[4]-e[4],n[5]=t[5]-e[5],n[6]=t[6]-e[6],n[7]=t[7]-e[7],n[8]=t[8]-e[8],n[9]=t[9]-e[9],n[10]=t[10]-e[10],n[11]=t[11]-e[11],n[12]=t[12]-e[12],n[13]=t[13]-e[13],n[14]=t[14]-e[14],n[15]=t[15]-e[15],n},c.multiplyTransformation=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],s=t[6],c=t[8],h=t[9],l=t[10],f=t[12],d=t[13],m=t[14],p=e[0],y=e[1],x=e[2],v=e[4],g=e[5],w=e[6],M=e[8],z=e[9],S=e[10],E=e[12],I=e[13],O=e[14],_=r*p+o*y+c*x,R=i*p+u*y+h*x,b=a*p+s*y+l*x,N=r*v+o*g+c*w,T=i*v+u*g+h*w,C=a*v+s*g+l*w,P=r*M+o*z+c*S,q=i*M+u*z+h*S,A=a*M+s*z+l*S,U=r*E+o*I+c*O+f,B=i*E+u*I+h*O+d,L=a*E+s*I+l*O+m;return n[0]=_,n[1]=R,n[2]=b,n[3]=0,n[4]=N,n[5]=T,n[6]=C,n[7]=0,n[8]=P,n[9]=q,n[10]=A,n[11]=0,n[12]=U,n[13]=B,n[14]=L,n[15]=1,n},c.multiplyByMatrix3=function(t,e,n){var r=t[0],i=t[1],a=t[2],o=t[4],u=t[5],s=t[6],c=t[8],h=t[9],l=t[10],f=e[0],d=e[1],m=e[2],p=e[3],y=e[4],x=e[5],v=e[6],g=e[7],w=e[8],M=r*f+o*d+c*m,z=i*f+u*d+h*m,S=a*f+s*d+l*m,E=r*p+o*y+c*x,I=i*p+u*y+h*x,O=a*p+s*y+l*x,_=r*v+o*g+c*w,R=i*v+u*g+h*w,b=a*v+s*g+l*w;return n[0]=M,n[1]=z,n[2]=S,n[3]=0,n[4]=E,n[5]=I,n[6]=O,n[7]=0,n[8]=_,n[9]=R,n[10]=b,n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=t[15],n},c.multiplyByTranslation=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=r*t[0]+i*t[4]+a*t[8]+t[12],u=r*t[1]+i*t[5]+a*t[9]+t[13],s=r*t[2]+i*t[6]+a*t[10]+t[14];return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=o,n[13]=u,n[14]=s,n[15]=t[15],n};var p=new t;c.multiplyByUniformScale=function(t,e,n){return p.x=e,p.y=e,p.z=e,c.multiplyByScale(t,p,n)},c.multiplyByScale=function(t,e,n){var r=e.x,i=e.y,a=e.z;return 1===r&&1===i&&1===a?c.clone(t,n):(n[0]=r*t[0],n[1]=r*t[1],n[2]=r*t[2],n[3]=0,n[4]=i*t[4],n[5]=i*t[5],n[6]=i*t[6],n[7]=0,n[8]=a*t[8],n[9]=a*t[9],n[10]=a*t[10],n[11]=0,n[12]=t[12],n[13]=t[13],n[14]=t[14],n[15]=1,n)},c.multiplyByVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t[0]*r+t[4]*i+t[8]*a+t[12]*o,s=t[1]*r+t[5]*i+t[9]*a+t[13]*o,c=t[2]*r+t[6]*i+t[10]*a+t[14]*o,h=t[3]*r+t[7]*i+t[11]*a+t[15]*o;return n.x=u,n.y=s,n.z=c,n.w=h,n},c.multiplyByPointAsVector=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a,u=t[1]*r+t[5]*i+t[9]*a,s=t[2]*r+t[6]*i+t[10]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(t,e,n){var r=e.x,i=e.y,a=e.z,o=t[0]*r+t[4]*i+t[8]*a+t[12],u=t[1]*r+t[5]*i+t[9]*a+t[13],s=t[2]*r+t[6]*i+t[10]*a+t[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(t,e,n){return n[0]=t[0]*e,n[1]=t[1]*e,n[2]=t[2]*e,n[3]=t[3]*e,n[4]=t[4]*e,n[5]=t[5]*e,n[6]=t[6]*e,n[7]=t[7]*e,n[8]=t[8]*e,n[9]=t[9]*e,n[10]=t[10]*e,n[11]=t[11]*e,n[12]=t[12]*e,n[13]=t[13]*e,n[14]=t[14]*e,n[15]=t[15]*e,n},c.negate=function(t,e){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=-t[7],e[8]=-t[8],e[9]=-t[9],e[10]=-t[10],e[11]=-t[11],e[12]=-t[12],e[13]=-t[13],e[14]=-t[14],e[15]=-t[15],e},c.transpose=function(t,e){var n=t[1],r=t[2],i=t[3],a=t[6],o=t[7],u=t[11];return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=n,e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=r,e[9]=a,e[10]=t[10],e[11]=t[14],e[12]=i,e[13]=o,e[14]=u,e[15]=t[15],e},c.abs=function(t,e){return e[0]=Math.abs(t[0]),e[1]=Math.abs(t[1]),e[2]=Math.abs(t[2]),e[3]=Math.abs(t[3]),e[4]=Math.abs(t[4]),e[5]=Math.abs(t[5]),e[6]=Math.abs(t[6]),e[7]=Math.abs(t[7]),e[8]=Math.abs(t[8]),e[9]=Math.abs(t[9]),e[10]=Math.abs(t[10]),e[11]=Math.abs(t[11]),e[12]=Math.abs(t[12]),e[13]=Math.abs(t[13]),e[14]=Math.abs(t[14]),e[15]=Math.abs(t[15]),e},c.equals=function(t,e){return t===e||r(t)&&r(e)&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[3]===e[3]&&t[7]===e[7]&&t[11]===e[11]&&t[15]===e[15]},c.equalsEpsilon=function(t,e,n){return t===e||r(t)&&r(e)&&Math.abs(t[0]-e[0])<=n&&Math.abs(t[1]-e[1])<=n&&Math.abs(t[2]-e[2])<=n&&Math.abs(t[3]-e[3])<=n&&Math.abs(t[4]-e[4])<=n&&Math.abs(t[5]-e[5])<=n&&Math.abs(t[6]-e[6])<=n&&Math.abs(t[7]-e[7])<=n&&Math.abs(t[8]-e[8])<=n&&Math.abs(t[9]-e[9])<=n&&Math.abs(t[10]-e[10])<=n&&Math.abs(t[11]-e[11])<=n&&Math.abs(t[12]-e[12])<=n&&Math.abs(t[13]-e[13])<=n&&Math.abs(t[14]-e[14])<=n&&Math.abs(t[15]-e[15])<=n},c.getTranslation=function(t,e){return e.x=t[12],e.y=t[13],e.z=t[14],e},c.getRotation=function(t,e){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e};var y=new u,x=new u,v=new e,g=new e(0,0,0,1);return c.inverse=function(t,n){if(u.equalsEpsilon(c.getRotation(t,y),x,o.EPSILON7)&&e.equals(c.getRow(t,3,v),g))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-t[12],n[13]=-t[13],n[14]=-t[14],n[15]=1,n;var r=t[0],i=t[4],a=t[8],h=t[12],l=t[1],f=t[5],d=t[9],m=t[13],p=t[2],w=t[6],M=t[10],z=t[14],S=t[3],E=t[7],I=t[11],O=t[15],_=M*O,R=z*I,b=w*O,N=z*E,T=w*I,C=M*E,P=p*O,q=z*S,A=p*I,U=M*S,B=p*E,L=w*S,D=_*f+N*d+T*m-(R*f+b*d+C*m),W=R*l+P*d+U*m-(_*l+q*d+A*m),k=b*l+q*f+B*m-(N*l+P*f+L*m),V=C*l+A*f+L*d-(T*l+U*f+B*d),j=R*i+b*a+C*h-(_*i+N*a+T*h),F=_*r+q*a+A*h-(R*r+P*a+U*h),Y=N*r+P*i+L*h-(b*r+q*i+B*h),Z=T*r+U*i+B*a-(C*r+A*i+L*a);_=a*m,R=h*d,b=i*m,N=h*f,T=i*d,C=a*f,P=r*m,q=h*l,A=r*d,U=a*l,B=r*f,L=i*l;var G=_*E+N*I+T*O-(R*E+b*I+C*O),H=R*S+P*I+U*O-(_*S+q*I+A*O),X=b*S+q*E+B*O-(N*S+P*E+L*O),K=C*S+A*E+L*I-(T*S+U*E+B*I),J=b*M+C*z+R*w-(T*z+_*w+N*M),Q=A*z+_*p+q*M-(P*M+U*z+R*p),$=P*w+L*z+N*p-(B*z+b*p+q*w),te=B*M+T*p+U*w-(A*w+L*M+C*p),ee=r*D+i*W+a*k+h*V;if(Math.abs(ee)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ee=1/ee,n[0]=D*ee,n[1]=W*ee,n[2]=k*ee,n[3]=V*ee,n[4]=j*ee,n[5]=F*ee,n[6]=Y*ee,n[7]=Z*ee,n[8]=G*ee,n[9]=H*ee,n[10]=X*ee,n[11]=K*ee,n[12]=J*ee,n[13]=Q*ee,n[14]=$*ee,n[15]=te*ee,n},c.inverseTransformation=function(t,e){var n=t[0],r=t[1],i=t[2],a=t[4],o=t[5],u=t[6],s=t[8],c=t[9],h=t[10],l=t[12],f=t[13],d=t[14],m=-n*l-r*f-i*d,p=-a*l-o*f-u*d,y=-s*l-c*f-h*d;return e[0]=n,e[1]=a,e[2]=s,e[3]=0,e[4]=r,e[5]=o,e[6]=c,e[7]=0,e[8]=i,e[9]=u,e[10]=h,e[11]=0,e[12]=m,e[13]=p,e[14]=y,e[15]=1,e},c.IDENTITY=a(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(t){return c.clone(this,t)},c.prototype.equals=function(t){return c.equals(this,t)},c.equalsArray=function(t,e,n){return t[0]===e[n]&&t[1]===e[n+1]&&t[2]===e[n+2]&&t[3]===e[n+3]&&t[4]===e[n+4]&&t[5]===e[n+5]&&t[6]===e[n+6]&&t[7]===e[n+7]&&t[8]===e[n+8]&&t[9]===e[n+9]&&t[10]===e[n+10]&&t[11]===e[n+11]&&t[12]===e[n+12]&&t[13]===e[n+13]&&t[14]===e[n+14]&&t[15]===e[n+15]},c.prototype.equalsEpsilon=function(t,e){return c.equalsEpsilon(this,t,e)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(t,e,n,r,i,a,o,u){"use strict";var s=function(t,n,r,i){this.west=e(t,0),this.south=e(n,0),this.east=e(r,0),this.north=e(i,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(t,n,r){r=e(r,0),n[r++]=t.west,n[r++]=t.south,n[r++]=t.east,n[r]=t.north},s.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i.west=t[r++],i.south=t[r++],i.east=t[r++],i.north=t[r],i},s.computeWidth=function(t){var e=t.east,n=t.west;return n>e&&(e+=u.TWO_PI),e-n},s.computeHeight=function(t){return t.north-t.south},s.fromDegrees=function(t,r,i,a,o){return t=u.toRadians(e(t,0)),r=u.toRadians(e(r,0)),i=u.toRadians(e(i,0)),a=u.toRadians(e(a,0)),n(o)?(o.west=t,o.south=r,o.east=i,o.north=a,o):new s(t,r,i,a)},s.fromCartographicArray=function(t,e){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=t.length;c>u;u++){var h=t[u];r=Math.min(r,h.longitude),i=Math.max(i,h.longitude),a=Math.min(a,h.latitude),o=Math.max(o,h.latitude)}return n(e)?(e.west=r,e.south=a,e.east=i,e.north=o,e):new s(r,a,i,o)},s.packedLength=4,s.pack=function(t,n,r){r=e(r,0),n[r++]=t.west,n[r++]=t.south,n[r++]=t.east,n[r]=t.north},s.unpack=function(t,r,i){return r=e(r,0),n(i)||(i=new s),i.west=t[r++],i.south=t[r++],i.east=t[r++],i.north=t[r],i},s.clone=function(t,e){return n(t)?n(e)?(e.west=t.west,e.south=t.south,e.east=t.east,e.north=t.north,e):new s(t.west,t.south,t.east,t.north):void 0},s.prototype.clone=function(t){return s.clone(this,t)},s.prototype.equals=function(t){return s.equals(this,t)},s.equals=function(t,e){return t===e||n(t)&&n(e)&&t.west===e.west&&t.south===e.south&&t.east===e.east&&t.north===e.north},s.prototype.equalsEpsilon=function(t,e){return n(t)&&Math.abs(this.west-t.west)<=e&&Math.abs(this.south-t.south)<=e&&Math.abs(this.east-t.east)<=e&&Math.abs(this.north-t.north)<=e},s.validate=function(){},s.southwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.south,r.height=0,r):new t(e.west,e.south)},s.northwest=function(e,r){return n(r)?(r.longitude=e.west,r.latitude=e.north,r.height=0,r):new t(e.west,e.north)},s.northeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.north,r.height=0,r):new t(e.east,e.north)},s.southeast=function(e,r){return n(r)?(r.longitude=e.east,r.latitude=e.south,r.height=0,r):new t(e.east,e.south)},s.center=function(e,r){var i=e.east,a=e.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),s=.5*(e.south+e.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new t(o,s)},s.intersection=function(t,e,r){var i=t.east,a=t.west,o=e.east,c=e.west;a>i&&o>0?i+=u.TWO_PI:c>o&&i>0&&(o+=u.TWO_PI),a>i&&0>c?c+=u.TWO_PI:c>o&&0>a&&(a+=u.TWO_PI);var h=u.negativePiToPi(Math.max(a,c)),l=u.negativePiToPi(Math.min(i,o));if((t.west<t.east||e.west<e.east)&&h>=l)return void 0;var f=Math.max(t.south,e.south),d=Math.min(t.north,e.north);return f>=d?void 0:n(r)?(r.west=h,r.south=f,r.east=l,r.north=d,r):new s(h,f,l,d)},s.contains=function(t,e){var n=e.longitude,r=e.latitude,i=t.west,a=t.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=t.south&&r<=t.north};var c=new t;return s.subsample=function(t,r,i,o){r=e(r,a.WGS84),i=e(i,0),n(o)||(o=[]);var h=0,l=t.north,f=t.south,d=t.east,m=t.west,p=c;p.height=i,p.longitude=m,p.latitude=l,o[h]=r.cartographicToCartesian(p,o[h]),h++,p.longitude=d,o[h]=r.cartographicToCartesian(p,o[h]),h++,p.latitude=f,o[h]=r.cartographicToCartesian(p,o[h]),h++,p.longitude=m,o[h]=r.cartographicToCartesian(p,o[h]),h++,p.latitude=0>l?l:f>0?f:0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(t,p)&&(o[h]=r.cartographicToCartesian(p,o[h]),h++);return 0===p.latitude&&(p.longitude=m,o[h]=r.cartographicToCartesian(p,o[h]),h++,p.longitude=d,o[h]=r.cartographicToCartesian(p,o[h]),h++),o.length=h,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(t,e,n,r,i,a,o,u,s,c,h){"use strict";var l=function(e,r){this.center=t.clone(n(e,t.ZERO)),this.radius=n(r,0)},f=new t,d=new t,m=new t,p=new t,y=new t,x=new t,v=new t,g=new t,w=new t,M=new t,z=new t,S=new t;l.fromPoints=function(e,n){if(r(n)||(n=new l),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;for(var i=t.clone(e[0],v),a=t.clone(i,f),o=t.clone(i,d),u=t.clone(i,m),s=t.clone(i,p),c=t.clone(i,y),h=t.clone(i,x),E=e.length,I=1;E>I;I++){t.clone(e[I],i);var O=i.x,_=i.y,R=i.z;O<a.x&&t.clone(i,a),O>s.x&&t.clone(i,s),_<o.y&&t.clone(i,o),_>c.y&&t.clone(i,c),R<u.z&&t.clone(i,u),R>h.z&&t.clone(i,h)}var b=t.magnitudeSquared(t.subtract(s,a,g)),N=t.magnitudeSquared(t.subtract(c,o,g)),T=t.magnitudeSquared(t.subtract(h,u,g)),C=a,P=s,q=b;N>q&&(q=N,C=o,P=c),T>q&&(q=T,C=u,P=h);var A=w;A.x=.5*(C.x+P.x),A.y=.5*(C.y+P.y),A.z=.5*(C.z+P.z);var U=t.magnitudeSquared(t.subtract(P,A,g)),B=Math.sqrt(U),L=M;L.x=a.x,L.y=o.y,L.z=u.z;var D=z;D.x=s.x,D.y=c.y,D.z=h.z;var W=t.multiplyByScalar(t.add(L,D,g),.5,S),k=0;for(I=0;E>I;I++){t.clone(e[I],i);var V=t.magnitude(t.subtract(i,W,g));V>k&&(k=V);var j=t.magnitudeSquared(t.subtract(i,A,g));if(j>U){var F=Math.sqrt(j);B=.5*(B+F),U=B*B;var Y=F-B;A.x=(B*A.x+Y*i.x)/F,A.y=(B*A.y+Y*i.y)/F,A.z=(B*A.z+Y*i.z)/F}}return k>B?(t.clone(A,n.center),n.radius=B):(t.clone(W,n.center),n.radius=k),n};var E=new o,I=new t,O=new t,_=new e,R=new e;l.fromRectangle2D=function(t,e,n){return l.fromRectangleWithHeights2D(t,e,0,0,n)},l.fromRectangleWithHeights2D=function(e,i,a,o,u){if(r(u)||(u=new l),!r(e))return u.center=t.clone(t.ZERO,u.center),u.radius=0,u;i=n(i,E),h.southwest(e,_),_.height=a,h.northeast(e,R),R.height=o;var s=i.project(_,I),c=i.project(R,O),f=c.x-s.x,d=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(f*f+d*d+m*m);var p=u.center;return p.x=s.x+.5*f,p.y=s.y+.5*d,p.z=s.z+.5*m,u};var b=[];l.fromRectangle3D=function(t,e,i,o){e=n(e,a.WGS84),i=n(i,0);var u;return r(t)&&(u=h.subsample(t,e,i,b)),l.fromPoints(u,o)},l.fromVertices=function(e,i,a,o){if(r(o)||(o=new l),!r(e)||0===e.length)return o.center=t.clone(t.ZERO,o.center),o.radius=0,o;i=n(i,t.ZERO),a=n(a,3);var u=v;u.x=e[0]+i.x,u.y=e[1]+i.y,u.z=e[2]+i.z;for(var s=t.clone(u,f),c=t.clone(u,d),h=t.clone(u,m),E=t.clone(u,p),I=t.clone(u,y),O=t.clone(u,x),_=e.length,R=0;_>R;R+=a){var b=e[R]+i.x,N=e[R+1]+i.y,T=e[R+2]+i.z;u.x=b,u.y=N,u.z=T,b<s.x&&t.clone(u,s),b>E.x&&t.clone(u,E),N<c.y&&t.clone(u,c),N>I.y&&t.clone(u,I),T<h.z&&t.clone(u,h),T>O.z&&t.clone(u,O)}var C=t.magnitudeSquared(t.subtract(E,s,g)),P=t.magnitudeSquared(t.subtract(I,c,g)),q=t.magnitudeSquared(t.subtract(O,h,g)),A=s,U=E,B=C;P>B&&(B=P,A=c,U=I),q>B&&(B=q,A=h,U=O);var L=w;L.x=.5*(A.x+U.x),L.y=.5*(A.y+U.y),L.z=.5*(A.z+U.z);var D=t.magnitudeSquared(t.subtract(U,L,g)),W=Math.sqrt(D),k=M;k.x=s.x,k.y=c.y,k.z=h.z;var V=z;V.x=E.x,V.y=I.y,V.z=O.z;var j=t.multiplyByScalar(t.add(k,V,g),.5,S),F=0;for(R=0;_>R;R+=a){u.x=e[R]+i.x,u.y=e[R+1]+i.y,u.z=e[R+2]+i.z;var Y=t.magnitude(t.subtract(u,j,g));Y>F&&(F=Y);var Z=t.magnitudeSquared(t.subtract(u,L,g));if(Z>D){var G=Math.sqrt(Z);W=.5*(W+G),D=W*W;var H=G-W;L.x=(W*L.x+H*u.x)/G,L.y=(W*L.y+H*u.y)/G,L.z=(W*L.z+H*u.z)/G}}return F>W?(t.clone(L,o.center),o.radius=W):(t.clone(j,o.center),o.radius=F),o},l.fromCornerPoints=function(e,n,i){r(i)||(i=new l);var a=i.center;return t.add(e,n,a),t.multiplyByScalar(a,.5,a),i.radius=t.distance(a,n),i},l.fromEllipsoid=function(e,n){return r(n)||(n=new l),t.clone(t.ZERO,n.center),n.radius=e.maximumRadius,n};var N=new t;l.fromBoundingSpheres=function(e,n){if(r(n)||(n=new l),!r(e)||0===e.length)return n.center=t.clone(t.ZERO,n.center),n.radius=0,n;var i=e.length;if(1===i)return l.clone(e[0],n);if(2===i)return l.union(e[0],e[1],n);for(var a=[],o=0;i>o;o++)a.push(e[o].center);n=l.fromPoints(a,n);var u=n.center,s=n.radius;for(o=0;i>o;o++){var c=e[o];s=Math.max(s,t.distance(u,c.center,N)+c.radius)}return n.radius=s,n},l.clone=function(e,n){return r(e)?r(n)?(n.center=t.clone(e.center,n.center),n.radius=e.radius,n):new l(e.center,e.radius):void 0},l.packedLength=4,l.pack=function(t,e,r){r=n(r,0);var i=t.center;e[r++]=i.x,e[r++]=i.y,e[r++]=i.z,e[r]=t.radius},l.unpack=function(t,e,i){e=n(e,0),r(i)||(i=new l);var a=i.center;return a.x=t[e++],a.y=t[e++],a.z=t[e++],i.radius=t[e],i};var T=new t,C=new t;l.union=function(e,n,i){r(i)||(i=new l);var a=e.center,o=n.center;t.add(a,o,C);var u=t.multiplyByScalar(C,.5,C),s=t.magnitude(t.subtract(a,u,T))+e.radius,c=t.magnitude(t.subtract(o,u,T))+n.radius;return i.radius=Math.max(s,c),t.clone(u,i.center),i};var P=new t;l.expand=function(e,n,r){r=l.clone(e,r);var i=t.magnitude(t.subtract(n,r.center,P));return i>r.radius&&(r.radius=i),r},l.intersect=function(e,n){var r=e.center,i=e.radius,a=t.dot(n,r)+n.w;return-i>a?u.OUTSIDE:i>a?u.INTERSECTING:u.INSIDE},l.transform=function(t,e,n){return r(n)||(n=new l),n.center=c.multiplyByPoint(e,t.center,n.center),n.radius=c.getMaximumScale(e)*t.radius,n};var q=new t;l.distanceSquaredTo=function(e,n){var r=t.subtract(e.center,n,q);return t.magnitudeSquared(r)-e.radius*e.radius},l.transformWithoutScale=function(t,e,n){return r(n)||(n=new l),n.center=c.multiplyByPoint(e,t.center,n.center),n.radius=t.radius,n};var A=new t;l.computePlaneDistances=function(e,n,i,a){r(a)||(a=new s);var o=t.subtract(e.center,n,A),u=t.multiplyByScalar(i,t.dot(i,o),A),c=t.magnitude(u);return a.start=c-e.radius,a.stop=c+e.radius,a};for(var U=new t,B=new t,L=new t,D=new t,W=new t,k=new e,V=new Array(8),j=0;8>j;++j)V[j]=new t;var F=new o;return l.projectTo2D=function(e,r,i){r=n(r,F);var a=r.ellipsoid,o=e.center,u=e.radius,s=a.geodeticSurfaceNormal(o,U),c=t.cross(t.UNIT_Z,s,B);t.normalize(c,c);var h=t.cross(s,c,L);t.normalize(h,h),t.multiplyByScalar(s,u,s),t.multiplyByScalar(h,u,h),t.multiplyByScalar(c,u,c);var f=t.negate(h,W),d=t.negate(c,D),m=V,p=m[0];t.add(s,h,p),t.add(p,c,p),p=m[1],t.add(s,h,p),t.add(p,d,p),p=m[2],t.add(s,f,p),t.add(p,d,p),p=m[3],t.add(s,f,p),t.add(p,c,p),t.negate(s,s),p=m[4],t.add(s,h,p),t.add(p,c,p),p=m[5],t.add(s,h,p),t.add(p,d,p),p=m[6],t.add(s,f,p),t.add(p,d,p),p=m[7],t.add(s,f,p),t.add(p,c,p);for(var y=m.length,x=0;y>x;++x){var v=m[x];t.add(o,v,v);var g=a.cartesianToCartographic(v,k);r.project(g,v)}i=l.fromPoints(m,i),o=i.center;var w=o.x,M=o.y,z=o.z;return o.x=z,o.y=w,o.z=M,i},l.equals=function(e,n){return e===n||r(e)&&r(n)&&t.equals(e.center,n.center)&&e.radius===n.radius},l.prototype.intersect=function(t){return l.intersect(this,t)},l.prototype.equals=function(t){return l.equals(this,t)},l.prototype.clone=function(t){return l.clone(this,t)},l}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(t,e,n,r,i,a,o){"use strict";function u(t,n,r){var i=t.transformPositionToScaledSpace(n,m),a=e.magnitudeSquared(i),o=Math.sqrt(a),u=e.divideByScalar(i,o,p);a=Math.max(1,a),o=Math.max(1,o);var s=e.dot(u,r),c=e.magnitude(e.cross(u,r,u)),h=1/o,l=Math.sqrt(a-1)*h;return 1/(s*h-c*l)}function s(t,n,r){return 0>=n||n===1/0||n!==n?void 0:e.multiplyByScalar(t,n,r)}function c(t,n){return t.transformPositionToScaledSpace(n,y),e.normalize(y,y)}var h=function(t,n){this._ellipsoid=t,this._cameraPosition=new e,this._cameraPositionInScaledSpace=new e,this._distanceToLimbInScaledSpaceSquared=0,r(n)&&(this.cameraPosition=n)};i(h.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(t){var n=this._ellipsoid,r=n.transformPositionToScaledSpace(t,this._cameraPositionInScaledSpace),i=e.magnitudeSquared(r)-1;e.clone(t,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=i}}});var l=new e;h.prototype.isPointVisible=function(t){var e=this._ellipsoid,n=e.transformPositionToScaledSpace(t,l);return this.isScaledSpacePointVisible(n)},h.prototype.isScaledSpacePointVisible=function(t){var n=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,i=e.subtract(t,n,l),a=-e.dot(i,n),o=a>r&&a*a/e.magnitudeSquared(i)>r;return!o},h.prototype.computeHorizonCullingPoint=function(t,n,i){r(i)||(i=new e);for(var a=this._ellipsoid,o=c(a,t),h=0,l=0,f=n.length;f>l;++l){var d=n[l],m=u(a,d,o);h=Math.max(h,m)}return s(o,h,i)};var f=new e;h.prototype.computeHorizonCullingPointFromVertices=function(t,i,a,o,h){r(h)||(h=new e),o=n(o,e.ZERO);for(var l=this._ellipsoid,d=c(l,t),m=0,p=0,y=i.length;y>p;p+=a){f.x=i[p]+o.x,f.y=i[p+1]+o.y,f.z=i[p+2]+o.z;var x=u(l,f,d);m=Math.max(m,x)}return s(d,m,h)};var d=[];h.prototype.computeHorizonCullingPointFromRectangle=function(n,r,i){var a=o.subsample(n,r,0,d),u=t.fromPoints(a);return e.magnitude(u.center)<.1*r.minimumRadius?void 0:this.computeHorizonCullingPoint(u.center,a,i)};var m=new e,p=new e,y=new e;return h}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(t,e,n,r){"use strict";var i={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return i.getSizeInBytes=function(t){switch(t){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(e){return t(e)&&(e===i.UNSIGNED_BYTE||e===i.UNSIGNED_SHORT||e===i.UNSIGNED_INT)},i.createTypedArray=function(t,e){return t>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(e):new Uint16Array(e)},i.createTypedArrayFromArrayBuffer=function(t,e,n,i){return t>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(e,n,i):new Uint16Array(e,n,i)},n(i)}),define("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(t,e){"use strict";var n={};return n.clipTriangleAtAxisAlignedThreshold=function(t,n,r,i,a,o){e(o)?o.length=0:o=[];var u,s,c;n?(u=t>r,s=t>i,c=t>a):(u=r>t,s=i>t,c=a>t);var h,l,f,d,m,p,y=u+s+c;return 1===y?u?(h=(t-r)/(i-r),l=(t-r)/(a-r),o.push(1),o.push(2),1!==l&&(o.push(-1),o.push(0),o.push(2),o.push(l)),1!==h&&(o.push(-1),o.push(0),o.push(1),o.push(h))):s?(f=(t-i)/(a-i),d=(t-i)/(r-i),o.push(2),o.push(0),1!==d&&(o.push(-1),o.push(1),o.push(0),o.push(d)),1!==f&&(o.push(-1),o.push(1),o.push(2),o.push(f))):c&&(m=(t-a)/(r-a),p=(t-a)/(i-a),o.push(0),o.push(1),1!==p&&(o.push(-1),o.push(2),o.push(1),o.push(p)),1!==m&&(o.push(-1),o.push(2),o.push(0),o.push(m))):2===y?u||r===t?s||i===t?c||a===t||(l=(t-r)/(a-r),f=(t-i)/(a-i),o.push(2),o.push(-1),o.push(0),o.push(2),o.push(l),o.push(-1),o.push(1),o.push(2),o.push(f)):(p=(t-a)/(i-a),h=(t-r)/(i-r),o.push(1),o.push(-1),o.push(2),o.push(1),o.push(p),o.push(-1),o.push(0),o.push(1),o.push(h)):(d=(t-i)/(r-i),m=(t-a)/(r-a),o.push(0),o.push(-1),o.push(1),o.push(0),o.push(d),o.push(-1),o.push(2),o.push(0),o.push(m)):3===y||(o.push(0),o.push(1),o.push(2)),o},n.computeBarycentricCoordinates=function(n,r,i,a,o,u,s,c,h){var l=i-s,f=s-o,d=u-c,m=a-c,p=1/(d*l+f*m),y=r-c,x=n-s,v=(d*x+f*y)*p,g=(-m*x+l*y)*p,w=1-v-g;return e(h)?(h.x=v,h.y=g,h.z=w,h):new t(v,g,w)},n}),define("Core/formatError",["./defined"],function(t){"use strict";var e=function(e){var n,r=e.name,i=e.message;n=t(r)&&t(i)?r+": "+i:e.toString();var a=e.stack;return t(a)&&(n+="\n"+a),n};return e}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(t,e,n){"use strict";var r=function(r){var i,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,a)}catch(c){o.error=c instanceof Error?{name:c.name,message:c.message,stack:c.stack}:c}e(i)||(i=t(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{i(o,a)}catch(c){o.result=void 0,o.error="postMessage failed with error: "+n(c)+"\n  with responseMessage: "+JSON.stringify(o),i(o)}}};return r}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/IndexDatatype","../Core/Intersections2D","../Core/Math","./createTaskProcessorWorker"],function(t,e,n,r,i,a,o,u,s,c,h,l){"use strict";function f(t,n){var i=t.isEastChild,l=t.isNorthChild,f=i?x:0,m=i?y:x,N=l?x:0,T=l?y:x,C=S,P=E,q=I,A=_;C.length=0,P.length=0,q.length=0,A.length=0;var U=O;U.length=0;var B,L,D,W,k={},V=t.vertices,j=t.encodedNormals,F=t.indices,Y=V.length/3,Z=V.subarray(0,Y),G=V.subarray(Y,2*Y),H=V.subarray(2*Y,3*Y),X=0,K=a(j);for(B=0,L=0;Y>B;++B,L+=2)D=Z[B],W=G[B],(i&&D>=x||!i&&x>=D)&&(l&&W>=x||!l&&x>=W)&&(k[B]=X,C.push(D),P.push(W),q.push(H[B]),K&&(A.push(j[L]),A.push(j[L+1])),++X);var J=[];J.push(new d),J.push(new d),J.push(new d);var Q=[];Q.push(new d),Q.push(new d),Q.push(new d);var $,te;for(B=0;B<F.length;B+=3){var ee=F[B],ne=F[B+1],re=F[B+2],ie=Z[ee],ae=Z[ne],oe=Z[re];J[0].initializeIndexed(Z,G,H,j,ee),J[1].initializeIndexed(Z,G,H,j,ne),J[2].initializeIndexed(Z,G,H,j,re);var ue=c.clipTriangleAtAxisAlignedThreshold(x,i,ie,ae,oe,v);$=0,$>=ue.length||($=Q[0].initializeFromClipResult(ue,$,J),$>=ue.length||($=Q[1].initializeFromClipResult(ue,$,J),$>=ue.length||($=Q[2].initializeFromClipResult(ue,$,J),te=c.clipTriangleAtAxisAlignedThreshold(x,l,Q[0].getV(),Q[1].getV(),Q[2].getV(),g),p(C,P,q,A,U,k,te,Q,K),$<ue.length&&(Q[2].clone(Q[1]),Q[2].initializeFromClipResult(ue,$,J),te=c.clipTriangleAtAxisAlignedThreshold(x,l,Q[0].getV(),Q[1].getV(),Q[2].getV(),g),p(C,P,q,A,U,k,te,Q,K)))))}var se=i?-y:0,ce=l?-y:0,he=t.minimumHeight,le=t.maximumHeight,fe=[],de=[],me=[],pe=[],ye=Number.MAX_VALUE,xe=-ye,ve=w;ve.length=0;var ge=o.clone(t.ellipsoid),we=t.childRectangle,Me=we.north,ze=we.south,Se=we.east,Ee=we.west;for(Ee>Se&&(Se+=h.TWO_PI),B=0;B<C.length;++B){D=Math.round(C[B]),f>=D?(fe.push(B),D=0):D>=m?(me.push(B),D=y):D=2*D+se,C[B]=D,W=Math.round(P[B]),N>=W?(de.push(B),W=0):W>=T?(pe.push(B),W=y):W=2*W+ce,P[B]=W;var Ie=h.lerp(he,le,q[B]/y);ye>Ie&&(ye=Ie),Ie>xe&&(xe=Ie),q[B]=Ie,M.longitude=h.lerp(Ee,Se,D/y),M.latitude=h.lerp(ze,Me,W/y),M.height=Ie,ge.cartographicToCartesian(M,z),ve.push(z.x),ve.push(z.y),ve.push(z.z)}var Oe=e.fromVertices(ve,r.ZERO,3,b),_e=new u(ge),Re=_e.computeHorizonCullingPointFromVertices(Oe.center,ve,3,Oe.center,R),be=xe-ye,Ne=new Uint16Array(C.length+P.length+q.length);
for(B=0;B<C.length;++B)Ne[B]=C[B];var Te=C.length;for(B=0;B<P.length;++B)Ne[Te+B]=P[B];for(Te+=P.length,B=0;B<q.length;++B)Ne[Te+B]=y*(q[B]-ye)/be;var Ce,Pe=s.createTypedArray(C.length,U);if(K){var qe=new Uint8Array(A);n.push(Ne.buffer,Pe.buffer,qe.buffer),Ce=qe.buffer}else n.push(Ne.buffer,Pe.buffer);return{vertices:Ne.buffer,encodedNormals:Ce,indices:Pe.buffer,minimumHeight:ye,maximumHeight:xe,westIndices:fe,southIndices:de,eastIndices:me,northIndices:pe,boundingSphere:Oe,horizonOcclusionPoint:Re}}function d(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function m(e,n){++T;var i=C[T],a=P[T];return i=t.octDecode(e.first.getNormalX(),e.first.getNormalY(),i),a=t.octDecode(e.second.getNormalX(),e.second.getNormalY(),a),z=r.lerp(i,a,e.ratio,z),r.normalize(z,z),t.octEncode(z,n),--T,n}function p(t,e,n,r,i,o,u,s,c){if(0!==u.length){for(var h=0,l=0;l<u.length;)l=q[h++].initializeFromClipResult(u,l,s);for(var f=0;h>f;++f){var d=q[f];if(d.isIndexed())d.newIndex=o[d.index],d.uBuffer=t,d.vBuffer=e,d.heightBuffer=n,c&&(d.normalBuffer=r);else{var m=d.getKey();if(a(o[m]))d.newIndex=o[m];else{var p=t.length;t.push(d.getU()),e.push(d.getV()),n.push(d.getH()),c&&(r.push(d.getNormalX()),r.push(d.getNormalY())),d.newIndex=p,o[m]=p}}}3===h?(i.push(q[0].newIndex),i.push(q[1].newIndex),i.push(q[2].newIndex)):4===h&&(i.push(q[0].newIndex),i.push(q[1].newIndex),i.push(q[2].newIndex),i.push(q[0].newIndex),i.push(q[2].newIndex),i.push(q[3].newIndex))}}var y=32767,x=0|y/2,v=[],g=[],w=[],M=new i,z=new r,S=[],E=[],I=[],O=[],_=[],R=new r,b=new e;d.prototype.clone=function(t){return a(t)||(t=new d),t.uBuffer=this.uBuffer,t.vBuffer=this.vBuffer,t.heightBuffer=this.heightBuffer,t.normalBuffer=this.normalBuffer,t.index=this.index,t.first=this.first,t.second=this.second,t.ratio=this.ratio,t},d.prototype.initializeIndexed=function(t,e,n,r,i){this.uBuffer=t,this.vBuffer=e,this.heightBuffer=n,this.normalBuffer=r,this.index=i,this.first=void 0,this.second=void 0,this.ratio=void 0},d.prototype.initializeInterpolated=function(t,e,n){this.vertexBuffer=void 0,this.index=void 0,this.newIndex=void 0,this.first=t,this.second=e,this.ratio=n},d.prototype.initializeFromClipResult=function(t,e,n){var r=e+1;return-1!==t[e]?n[t[e]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=n[t[r]],++r,this.second=n[t[r]],++r,this.ratio=t[r],++r),r},d.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},d.prototype.isIndexed=function(){return a(this.index)},d.prototype.getH=function(){return a(this.index)?this.heightBuffer[this.index]:h.lerp(this.first.getH(),this.second.getH(),this.ratio)},d.prototype.getU=function(){return a(this.index)?this.uBuffer[this.index]:h.lerp(this.first.getU(),this.second.getU(),this.ratio)},d.prototype.getV=function(){return a(this.index)?this.vBuffer[this.index]:h.lerp(this.first.getV(),this.second.getV(),this.ratio)};var N=new n,T=-1,C=[new r,new r],P=[new r,new r];d.prototype.getNormalX=function(){return a(this.index)?this.normalBuffer[2*this.index]:(N=m(this,N),N.x)},d.prototype.getNormalY=function(){return a(this.index)?this.normalBuffer[2*this.index+1]:(N=m(this,N),N.y)};var q=[];return q.push(new d),q.push(new d),q.push(new d),q.push(new d),l(f)})}();