/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};r.EPSILON1=.1,r.EPSILON2=.01,r.EPSILON3=.001,r.EPSILON4=1e-4,r.EPSILON5=1e-5,r.EPSILON6=1e-6,r.EPSILON7=1e-7,r.EPSILON8=1e-8,r.EPSILON9=1e-9,r.EPSILON10=1e-10,r.EPSILON11=1e-11,r.EPSILON12=1e-12,r.EPSILON13=1e-13,r.EPSILON14=1e-14,r.EPSILON15=1e-15,r.EPSILON16=1e-16,r.EPSILON17=1e-17,r.EPSILON18=1e-18,r.EPSILON19=1e-19,r.EPSILON20=1e-20,r.GRAVITATIONALPARAMETER=3986004418e5,r.SOLAR_RADIUS=6955e5,r.LUNAR_RADIUS=1737400,r.SIXTY_FOUR_KILOBYTES=65536,r.sign=function(e){return e>0?1:0>e?-1:0},r.signNotZero=function(e){return 0>e?-1:1},r.toSNorm=function(e){return Math.round(255*(.5*r.clamp(e,-1,1)+.5))},r.fromSNorm=function(e){return 2*(r.clamp(e,0,255)/255)-1},r.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},r.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},r.lerp=function(e,t,r){return(1-r)*e+r*t},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=.5*Math.PI,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=.5*3*Math.PI,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(e){return e*r.RADIANS_PER_DEGREE},r.toDegrees=function(e){return e*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(e){var t=r.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},r.negativePiToPi=function(e){return r.zeroToTwoPi(e+r.PI)-r.PI},r.zeroToTwoPi=function(e){var t=r.mod(e,r.TWO_PI);return Math.abs(t)<r.EPSILON14&&Math.abs(e)>r.EPSILON14?r.TWO_PI:t},r.mod=function(e,t){return(e%t+t)%t},r.equalsEpsilon=function(e,r,n,o){o=t(o,n);var i=Math.abs(e-r);return o>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var n=[1];r.factorial=function(e){var t=n.length;if(e>=t)for(var r=n[t-1],o=t;e>=o;o++)n.push(r*o);return n[e]},r.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},r.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},r.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},r.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return r.setRandomNumberSeed=function(t){o=new e(t)},r.nextRandomNumber=function(){return o.random()},r.acosClamped=function(e){return Math.acos(r.clamp(e,-1,1))},r.asinClamped=function(e){return Math.asin(r.clamp(e,-1,1))},r.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},r}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,s=e(r.magnitude,1),u=s*Math.sin(a);return n.x=u*Math.cos(o),n.y=u*Math.sin(o),n.z=s*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var u=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,u),i.normalize(t,c);var r=i.dot(u,c),n=i.magnitude(i.cross(u,c,u));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,o=e.y,i=e.z,a=t.x,s=t.y,u=t.z,c=o*u-i*s,l=i*a-n*u,f=n*s-o*a;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,a){var s=o.toRadians(e),u=o.toRadians(t);return i.fromRadians(s,u,r,n,a)};var f=new i,m=new i,h=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,o,a,s){o=e(o,0);var u=t(a)?a.radiiSquared:h,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(u,f,m);var l=Math.sqrt(i.dot(f,m));return m=i.divideByScalar(m,l,m),f=i.multiplyByScalar(f,o,f),t(s)||(s=new i),i.add(m,f,s)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a++)n[a]=o.toRadians(e[a]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var o=e.length;t(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var s=e[a],u=e[a+1];n[a/2]=i.fromRadians(s,u,0,r,n[a/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a+=3)n[a]=o.toRadians(e[a]),n[a+1]=o.toRadians(e[a+1]),n[a+2]=e[a+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var o=e.length;t(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var s=e[a],u=e[a+1],c=e[a+2];n[a/3]=i.fromRadians(s,u,c,r,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,o,a){return o=e(o,0),t(a)?(a.longitude=r,a.latitude=n,a.height=o,a):new i(r,n,o)},i.fromDegrees=function(e,t,r,n){return e=o.toRadians(e),t=o.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i,a,s){"use strict";function u(t,n,o,i){n=r(n,0),o=r(o,0),i=r(i,0),t._radii=new e(n,o,i),t._radiiSquared=new e(n*n,o*o,i*i),t._radiiToTheFourth=new e(n*n*n*n,o*o*o*o,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,o,i),t._maximumRadius=Math.max(n,o,i),t._centerToleranceSquared=s.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,e,t,r)};o(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var o=t._radii;return n(r)?(e.clone(o,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(o.x,o.y,o.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(u(t,e.x,e.y,e.z),t):t},c.WGS84=a(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=a(new c(1,1,1)),c.MOON=a(new c(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,o){o=r(o,0),e.pack(t._radii,n,o)},c.unpack=function(t,n,o){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,o)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var o=t.longitude,i=t.latitude,a=Math.cos(i),s=a*Math.cos(o),u=a*Math.sin(o),c=Math.sin(i);return n(r)||(r=new e),r.x=s,r.y=u,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,r){var o=l,i=f;this.geodeticSurfaceNormalCartographic(t,o),e.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(e.dot(o,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(o,t.height,o),n(r)||(r=new e),e.add(i,o,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var m=new e,h=new e,d=new e;c.prototype.cartesianToCartographic=function(r,o){var i=this.scaleToGeodeticSurface(r,h);if(!n(i))return void 0;var a=this.geodeticSurfaceNormal(i,m),u=e.subtract(r,i,d),c=Math.atan2(a.y,a.x),l=Math.asin(a.z),f=s.sign(e.dot(u,r))*e.magnitude(u);return n(o)?(o.longitude=c,o.latitude=l,o.height=f,o):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var p=new e,y=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var o=t.x,i=t.y,a=t.z,u=this._oneOverRadii,c=u.x,l=u.y,f=u.z,m=o*o*c*c,h=i*i*l*l,d=a*a*f*f,v=m+h+d,g=Math.sqrt(1/v),E=e.multiplyByScalar(t,g,p);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(E,r):void 0;var S=this._oneOverRadiiSquared,C=S.x,w=S.y,b=S.z,A=y;A.x=2*E.x*C,A.y=2*E.y*w,A.z=2*E.z*b;var x,T,M,I,O,R,N,L,P,z,D,F=(1-g)*e.magnitude(t)/(.5*e.magnitude(A)),_=0;do{F-=_,M=1/(1+F*C),I=1/(1+F*w),O=1/(1+F*b),R=M*M,N=I*I,L=O*O,P=R*M,z=N*I,D=L*O,x=m*R+h*N+d*L-1,T=m*P*C+h*z*w+d*D*b;var B=-2*T;_=x/B}while(Math.abs(x)>s.EPSILON12);return n(r)?(r.x=o*M,r.y=i*I,r.z=a*O,r):new e(o*M,i*I,a*O)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var o=t.x,i=t.y,a=t.z,s=this._oneOverRadiiSquared,u=1/Math.sqrt(o*o*s.x+i*i*s.y+a*a*s.z);return e.multiplyByScalar(t,u,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,i,a){"use strict";var s=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,s=t.height;return n(r)?(r.x=i,r.y=a,r.z=s,r):new e(i,a,s)},s.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=e.y*o,s=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=s,r):new t(i,a,s)},s}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n,o){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(o,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var u=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,u);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)&&o.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(h[r],m[r])];t+=2*n*n}return Math.sqrt(t)}function u(e,t){for(var r=i.EPSILON15,n=0,o=1,a=0;3>a;++a){var s=Math.abs(e[c.getElementIndex(h[a],m[a])]);s>n&&(o=a,n=s)}var u=1,l=0,f=m[o],d=h[o];if(Math.abs(e[c.getElementIndex(d,f)])>r){var p,y=e[c.getElementIndex(d,d)],v=e[c.getElementIndex(f,f)],g=e[c.getElementIndex(d,f)],E=(y-v)/2/g;p=0>E?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)),u=1/Math.sqrt(1+p*p),l=p*u}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(d,d)]=u,t[c.getElementIndex(d,f)]=l,t[c.getElementIndex(f,d)]=-l,t}var c=function(e,r,n,o,i,a,s,u,c){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(u,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,o=e.x*e.y,i=e.x*e.z,a=e.x*e.w,s=e.y*e.y,u=e.y*e.z,l=e.y*e.w,f=e.z*e.z,m=e.z*e.w,h=e.w*e.w,d=n-s-f+h,p=2*(o-m),y=2*(i+l),v=2*(o+m),g=-n+s-f+h,E=2*(u-a),S=2*(i-l),C=2*(u+a),w=-n-s+f+h;return r(t)?(t[0]=d,t[1]=v,t[2]=S,t[3]=p,t[4]=g,t[5]=C,t[6]=y,t[7]=E,t[8]=w,t):new c(d,p,y,v,g,E,S,C,w)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=o,t[6]=0,t[7]=-o,t[8]=n,t):new c(1,0,0,0,n,-o,0,o,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=n,t):new c(n,0,o,0,1,0,-o,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=o,t[2]=0,t[3]=-o,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-o,0,o,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,o=e[n],i=e[n+1],a=e[n+2];return r.x=o,r.y=i,r.z=a,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=3*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],o=e[t+3],i=e[t+6];return r.x=n,r.y=o,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],u=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=s,r[5]=u,r[6]=c,r[7]=l,r[8]=f,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[3]*o+e[6]*i,s=e[1]*n+e[4]*o+e[7]*i,u=e[2]*n+e[5]*o+e[8]*i;return r.x=a,r.y=s,r.z=u,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],s=e[7],u=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=o,t[3]=i,t[4]=a,t[5]=s,t[6]=u,t[7]=c,t[8]=l,t};var m=[1,0,0],h=[2,2,1],d=new c,p=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,o=10,l=0,f=0;r(t)||(t={});for(var m=t.unitary=c.clone(c.IDENTITY,t.unitary),h=t.diagonal=c.clone(e,t.diagonal),y=n*a(h);o>f&&s(h)>y;)u(h,d),c.transpose(d,p),c.multiply(h,d,h),c.multiply(p,h,h),c.multiply(m,d,m),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],o=e[1],i=e[4],a=e[7],s=e[2],u=e[5],c=e[8];return t*(i*c-u*a)+o*(u*n-r*c)+s*(r*a-i*n)},c.inverse=function(e,t){var r=e[0],o=e[1],a=e[2],s=e[3],u=e[4],l=e[5],f=e[6],m=e[7],h=e[8],d=c.determinant(e);if(Math.abs(d)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=u*h-m*l,t[1]=m*a-o*h,t[2]=o*l-u*a,t[3]=f*l-s*h,t[4]=r*h-f*a,t[5]=s*a-r*l,t[6]=s*m-f*u,t[7]=f*o-r*m,t[8]=r*u-s*o;var p=1/d;return c.multiplyByScalar(t,p,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=o(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,i,a,s,u){"use strict";var c=function(e,t,n,o,i,a,s,u,c,l,f,m,h,d,p,y){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(h,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(l,0),this[7]=r(d,0),this[8]=r(n,0),this[9]=r(s,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(o,0),this[13]=r(u,0),this[14]=r(m,0),this[15]=r(y,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new c),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,o,i){return o=r(o,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new c(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,o){n(o)||(o=new c);var i=r.x,a=r.y,s=r.z,u=t.x*t.x,l=t.x*t.y,f=t.x*t.z,m=t.x*t.w,h=t.y*t.y,d=t.y*t.z,p=t.y*t.w,y=t.z*t.z,v=t.z*t.w,g=t.w*t.w,E=u-h-y+g,S=2*(l-v),C=2*(f+p),w=2*(l+v),b=-u+h-y+g,A=2*(d-m),x=2*(f-p),T=2*(d+m),M=-u-h+y+g;return o[0]=E*i,o[1]=w*i,o[2]=x*i,o[3]=0,o[4]=S*a,o[5]=b*a,o[6]=T*a,o[7]=0,o[8]=C*s,o[9]=A*s,o[10]=M*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},c.fromTranslation=function(e,t){return c.fromRotationTranslation(s.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,m=new e;c.fromCamera=function(t,r){var o=t.eye,i=t.target,a=t.up;e.normalize(e.subtract(i,o,l),l),e.normalize(e.cross(l,a,f),f),e.normalize(e.cross(f,l,m),m);var s=f.x,u=f.y,h=f.z,d=l.x,p=l.y,y=l.z,v=m.x,g=m.y,E=m.z,S=o.x,C=o.y,w=o.z,b=s*-S+u*-C+h*-w,A=v*-S+g*-C+E*-w,x=d*S+p*C+y*w;return n(r)?(r[0]=s,r[1]=v,r[2]=-d,r[3]=0,r[4]=u,r[5]=g,r[6]=-p,r[7]=0,r[8]=h,r[9]=E,r[10]=-y,r[11]=0,r[12]=b,r[13]=A,r[14]=x,r[15]=1,r):new c(s,u,h,b,v,g,E,A,-d,-p,-y,x,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,o){var i=Math.tan(.5*e),a=1/i,s=a/t,u=(n+r)/(r-n),c=2*n*r/(r-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=u,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},c.computeOrthographicOffCenter=function(e,t,r,n,o,i,a){var s=1/(t-e),u=1/(n-r),c=1/(i-o),l=-(t+e)*s,f=-(n+r)*u,m=-(i+o)*c;return s*=2,u*=2,c*=-2,a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=0,a[12]=l,a[13]=f,a[14]=m,a[15]=1,a},c.computePerspectiveOffCenter=function(e,t,r,n,o,i,a){var s=2*o/(t-e),u=2*o/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+o)/(i-o),m=-1,h=-2*i*o/(i-o);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=l,a[10]=f,a[11]=m,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,i){var a=2*o/(t-e),s=2*o/(n-r),u=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,m=-2*o;
return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=u,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=m,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,o){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),a=r(e.y,0),s=r(e.width,0),u=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*s,l=.5*u,f=.5*(n-t),m=c,h=l,d=f,p=i+c,y=a+l,v=t+f,g=1;return o[0]=m,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=h,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=d,o[11]=0,o[12]=p,o[13]=y,o[14]=v,o[15]=g,o},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,o=e[n],i=e[n+1],a=e[n+2],s=e[n+3];return r.x=o,r.y=i,r.z=a,r.w=s,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=4*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},c.getRow=function(e,t,r){var n=e[t],o=e[t+4],i=e[t+8],a=e[t+12];return r.x=n,r.y=o,r.z=i,r.w=a,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var h=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),r};var d=new e;c.getMaximumScale=function(t){return c.getScale(t,d),e.maximumComponent(d)},c.multiply=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[3],s=e[4],u=e[5],c=e[6],l=e[7],f=e[8],m=e[9],h=e[10],d=e[11],p=e[12],y=e[13],v=e[14],g=e[15],E=t[0],S=t[1],C=t[2],w=t[3],b=t[4],A=t[5],x=t[6],T=t[7],M=t[8],I=t[9],O=t[10],R=t[11],N=t[12],L=t[13],P=t[14],z=t[15],D=n*E+s*S+f*C+p*w,F=o*E+u*S+m*C+y*w,_=i*E+c*S+h*C+v*w,B=a*E+l*S+d*C+g*w,U=n*b+s*A+f*x+p*T,G=o*b+u*A+m*x+y*T,q=i*b+c*A+h*x+v*T,k=a*b+l*A+d*x+g*T,V=n*M+s*I+f*O+p*R,W=o*M+u*I+m*O+y*R,Y=i*M+c*I+h*O+v*R,H=a*M+l*I+d*O+g*R,j=n*N+s*L+f*P+p*z,K=o*N+u*L+m*P+y*z,Z=i*N+c*L+h*P+v*z,X=a*N+l*L+d*P+g*z;return r[0]=D,r[1]=F,r[2]=_,r[3]=B,r[4]=U,r[5]=G,r[6]=q,r[7]=k,r[8]=V,r[9]=W,r[10]=Y,r[11]=H,r[12]=j,r[13]=K,r[14]=Z,r[15]=X,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],s=e[5],u=e[6],c=e[8],l=e[9],f=e[10],m=e[12],h=e[13],d=e[14],p=t[0],y=t[1],v=t[2],g=t[4],E=t[5],S=t[6],C=t[8],w=t[9],b=t[10],A=t[12],x=t[13],T=t[14],M=n*p+a*y+c*v,I=o*p+s*y+l*v,O=i*p+u*y+f*v,R=n*g+a*E+c*S,N=o*g+s*E+l*S,L=i*g+u*E+f*S,P=n*C+a*w+c*b,z=o*C+s*w+l*b,D=i*C+u*w+f*b,F=n*A+a*x+c*T+m,_=o*A+s*x+l*T+h,B=i*A+u*x+f*T+d;return r[0]=M,r[1]=I,r[2]=O,r[3]=0,r[4]=R,r[5]=N,r[6]=L,r[7]=0,r[8]=P,r[9]=z,r[10]=D,r[11]=0,r[12]=F,r[13]=_,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],s=e[5],u=e[6],c=e[8],l=e[9],f=e[10],m=t[0],h=t[1],d=t[2],p=t[3],y=t[4],v=t[5],g=t[6],E=t[7],S=t[8],C=n*m+a*h+c*d,w=o*m+s*h+l*d,b=i*m+u*h+f*d,A=n*p+a*y+c*v,x=o*p+s*y+l*v,T=i*p+u*y+f*v,M=n*g+a*E+c*S,I=o*g+s*E+l*S,O=i*g+u*E+f*S;return r[0]=C,r[1]=w,r[2]=b,r[3]=0,r[4]=A,r[5]=x,r[6]=T,r[7]=0,r[8]=M,r[9]=I,r[10]=O,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=n*e[0]+o*e[4]+i*e[8]+e[12],s=n*e[1]+o*e[5]+i*e[9]+e[13],u=n*e[2]+o*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=a,r[13]=s,r[14]=u,r[15]=e[15],r};var p=new e;c.multiplyByUniformScale=function(e,t,r){return p.x=t,p.y=t,p.z=t,c.multiplyByScale(e,p,r)},c.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,i=t.z;return 1===n&&1===o&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=t.w,s=e[0]*n+e[4]*o+e[8]*i+e[12]*a,u=e[1]*n+e[5]*o+e[9]*i+e[13]*a,c=e[2]*n+e[6]*o+e[10]*i+e[14]*a,l=e[3]*n+e[7]*o+e[11]*i+e[15]*a;return r.x=s,r.y=u,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i,s=e[1]*n+e[5]*o+e[9]*i,u=e[2]*n+e[6]*o+e[10]*i;return r.x=a,r.y=s,r.z=u,r},c.multiplyByPoint=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i+e[12],s=e[1]*n+e[5]*o+e[9]*i+e[13],u=e[2]*n+e[6]*o+e[10]*i+e[14];return r.x=a,r.y=s,r.z=u,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],o=e[3],i=e[6],a=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=a,t[14]=s,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new s,v=new s,g=new t,E=new t(0,0,0,1);return c.inverse=function(e,r){if(s.equalsEpsilon(c.getRotation(e,y),v,a.EPSILON7)&&t.equals(c.getRow(e,3,g),E))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],o=e[4],i=e[8],l=e[12],f=e[1],m=e[5],h=e[9],d=e[13],p=e[2],S=e[6],C=e[10],w=e[14],b=e[3],A=e[7],x=e[11],T=e[15],M=C*T,I=w*x,O=S*T,R=w*A,N=S*x,L=C*A,P=p*T,z=w*b,D=p*x,F=C*b,_=p*A,B=S*b,U=M*m+R*h+N*d-(I*m+O*h+L*d),G=I*f+P*h+F*d-(M*f+z*h+D*d),q=O*f+z*m+_*d-(R*f+P*m+B*d),k=L*f+D*m+B*h-(N*f+F*m+_*h),V=I*o+O*i+L*l-(M*o+R*i+N*l),W=M*n+z*i+D*l-(I*n+P*i+F*l),Y=R*n+P*o+B*l-(O*n+z*o+_*l),H=N*n+F*o+_*i-(L*n+D*o+B*i);M=i*d,I=l*h,O=o*d,R=l*m,N=o*h,L=i*m,P=n*d,z=l*f,D=n*h,F=i*f,_=n*m,B=o*f;var j=M*A+R*x+N*T-(I*A+O*x+L*T),K=I*b+P*x+F*T-(M*b+z*x+D*T),Z=O*b+z*A+_*T-(R*b+P*A+B*T),X=L*b+D*A+B*x-(N*b+F*A+_*x),Q=O*C+L*w+I*S-(N*w+M*S+R*C),J=D*w+M*p+z*C-(P*C+F*w+I*p),$=P*S+B*w+R*p-(_*w+O*p+z*S),et=_*C+N*p+F*S-(D*S+B*C+L*p),tt=n*U+o*G+i*q+l*k;if(Math.abs(tt)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return tt=1/tt,r[0]=U*tt,r[1]=G*tt,r[2]=q*tt,r[3]=k*tt,r[4]=V*tt,r[5]=W*tt,r[6]=Y*tt,r[7]=H*tt,r[8]=j*tt,r[9]=K*tt,r[10]=Z*tt,r[11]=X*tt,r[12]=Q*tt,r[13]=J*tt,r[14]=$*tt,r[15]=et*tt,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],i=e[4],a=e[5],s=e[6],u=e[8],c=e[9],l=e[10],f=e[12],m=e[13],h=e[14],d=-r*f-n*m-o*h,p=-i*f-a*m-s*h,y=-u*f-c*m-l*h;return t[0]=r,t[1]=i,t[2]=u,t[3]=0,t[4]=n,t[5]=a,t[6]=c,t[7]=0,t[8]=o,t[9]=s,t[10]=l,t[11]=0,t[12]=d,t[13]=p,t[14]=y,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,i,a,s){"use strict";var u=function(e,r,n,o){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(o,0)};n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},u.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new u),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},u.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=s.TWO_PI),t-r},u.computeHeight=function(e){return e.north-e.south},u.fromDegrees=function(e,n,o,i,a){return e=s.toRadians(t(e,0)),n=s.toRadians(t(n,0)),o=s.toRadians(t(o,0)),i=s.toRadians(t(i,0)),r(a)?(a.west=e,a.south=n,a.east=o,a.north=i,a):new u(e,n,o,i)},u.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=0,c=e.length;c>s;s++){var l=e[s];n=Math.min(n,l.longitude),o=Math.max(o,l.longitude),i=Math.min(i,l.latitude),a=Math.max(a,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=o,t.north=a,t):new u(n,i,o,a)},u.packedLength=4,u.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},u.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new u),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},u.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},u.validate=function(){},u.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},u.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},u.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},u.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},u.center=function(t,n){var o=t.east,i=t.west;i>o&&(o+=s.TWO_PI);var a=s.negativePiToPi(.5*(i+o)),u=.5*(t.south+t.north);return r(n)?(n.longitude=a,n.latitude=u,n.height=0,n):new e(a,u)},u.intersection=function(e,t,n){var o=e.east,i=e.west,a=t.east,c=t.west;i>o&&a>0?o+=s.TWO_PI:c>a&&o>0&&(a+=s.TWO_PI),i>o&&0>c?c+=s.TWO_PI:c>a&&0>i&&(i+=s.TWO_PI);var l=s.negativePiToPi(Math.max(i,c)),f=s.negativePiToPi(Math.min(o,a));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var m=Math.max(e.south,t.south),h=Math.min(e.north,t.north);return m>=h?void 0:r(n)?(n.west=l,n.south=m,n.east=f,n.north=h,n):new u(l,m,f,h)},u.contains=function(e,t){var r=t.longitude,n=t.latitude,o=e.west,i=e.east;return o>i&&(i+=s.TWO_PI,0>r&&(r+=s.TWO_PI)),(r>o||s.equalsEpsilon(r,o,s.EPSILON14))&&(i>r||s.equalsEpsilon(r,i,s.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return u.subsample=function(e,n,o,a){n=t(n,i.WGS84),o=t(o,0),r(a)||(a=[]);var l=0,f=e.north,m=e.south,h=e.east,d=e.west,p=c;p.height=o,p.longitude=d,p.latitude=f,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=h,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.latitude=m,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=d,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.latitude=0>f?f:m>0?m:0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*s.PI_OVER_TWO,u.contains(e,p)&&(a[l]=n.cartographicToCartesian(p,a[l]),l++);return 0===p.latitude&&(p.longitude=d,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=h,a[l]=n.cartographicToCartesian(p,a[l]),l++),a.length=l,a},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,r,n,o,i,a,s,u,c,l){"use strict";var f=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},m=new e,h=new e,d=new e,p=new e,y=new e,v=new e,g=new e,E=new e,S=new e,C=new e,w=new e,b=new e;f.fromPoints=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var o=e.clone(t[0],g),i=e.clone(o,m),a=e.clone(o,h),s=e.clone(o,d),u=e.clone(o,p),c=e.clone(o,y),l=e.clone(o,v),A=t.length,x=1;A>x;x++){e.clone(t[x],o);var T=o.x,M=o.y,I=o.z;T<i.x&&e.clone(o,i),T>u.x&&e.clone(o,u),M<a.y&&e.clone(o,a),M>c.y&&e.clone(o,c),I<s.z&&e.clone(o,s),I>l.z&&e.clone(o,l)}var O=e.magnitudeSquared(e.subtract(u,i,E)),R=e.magnitudeSquared(e.subtract(c,a,E)),N=e.magnitudeSquared(e.subtract(l,s,E)),L=i,P=u,z=O;R>z&&(z=R,L=a,P=c),N>z&&(z=N,L=s,P=l);var D=S;D.x=.5*(L.x+P.x),D.y=.5*(L.y+P.y),D.z=.5*(L.z+P.z);var F=e.magnitudeSquared(e.subtract(P,D,E)),_=Math.sqrt(F),B=C;B.x=i.x,B.y=a.y,B.z=s.z;var U=w;U.x=u.x,U.y=c.y,U.z=l.z;var G=e.multiplyByScalar(e.add(B,U,E),.5,b),q=0;for(x=0;A>x;x++){e.clone(t[x],o);var k=e.magnitude(e.subtract(o,G,E));k>q&&(q=k);var V=e.magnitudeSquared(e.subtract(o,D,E));if(V>F){var W=Math.sqrt(V);_=.5*(_+W),F=_*_;var Y=W-_;D.x=(_*D.x+Y*o.x)/W,D.y=(_*D.y+Y*o.y)/W,D.z=(_*D.z+Y*o.z)/W}}return q>_?(e.clone(D,r.center),r.radius=_):(e.clone(G,r.center),r.radius=q),r};var A=new a,x=new e,T=new e,M=new t,I=new t;f.fromRectangle2D=function(e,t,r){return f.fromRectangleWithHeights2D(e,t,0,0,r)},f.fromRectangleWithHeights2D=function(t,o,i,a,s){if(n(s)||(s=new f),!n(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;o=r(o,A),l.southwest(t,M),M.height=i,l.northeast(t,I),I.height=a;var u=o.project(M,x),c=o.project(I,T),m=c.x-u.x,h=c.y-u.y,d=c.z-u.z;s.radius=.5*Math.sqrt(m*m+h*h+d*d);var p=s.center;return p.x=u.x+.5*m,p.y=u.y+.5*h,p.z=u.z+.5*d,s};var O=[];f.fromRectangle3D=function(e,t,o,a){t=r(t,i.WGS84),o=r(o,0);var s;return n(e)&&(s=l.subsample(e,t,o,O)),f.fromPoints(s,a)},f.fromVertices=function(t,o,i,a){if(n(a)||(a=new f),!n(t)||0===t.length)return a.center=e.clone(e.ZERO,a.center),a.radius=0,a;o=r(o,e.ZERO),i=r(i,3);var s=g;s.x=t[0]+o.x,s.y=t[1]+o.y,s.z=t[2]+o.z;for(var u=e.clone(s,m),c=e.clone(s,h),l=e.clone(s,d),A=e.clone(s,p),x=e.clone(s,y),T=e.clone(s,v),M=t.length,I=0;M>I;I+=i){var O=t[I]+o.x,R=t[I+1]+o.y,N=t[I+2]+o.z;s.x=O,s.y=R,s.z=N,O<u.x&&e.clone(s,u),O>A.x&&e.clone(s,A),R<c.y&&e.clone(s,c),R>x.y&&e.clone(s,x),N<l.z&&e.clone(s,l),N>T.z&&e.clone(s,T)}var L=e.magnitudeSquared(e.subtract(A,u,E)),P=e.magnitudeSquared(e.subtract(x,c,E)),z=e.magnitudeSquared(e.subtract(T,l,E)),D=u,F=A,_=L;P>_&&(_=P,D=c,F=x),z>_&&(_=z,D=l,F=T);var B=S;B.x=.5*(D.x+F.x),B.y=.5*(D.y+F.y),B.z=.5*(D.z+F.z);var U=e.magnitudeSquared(e.subtract(F,B,E)),G=Math.sqrt(U),q=C;q.x=u.x,q.y=c.y,q.z=l.z;var k=w;k.x=A.x,k.y=x.y,k.z=T.z;var V=e.multiplyByScalar(e.add(q,k,E),.5,b),W=0;for(I=0;M>I;I+=i){s.x=t[I]+o.x,s.y=t[I+1]+o.y,s.z=t[I+2]+o.z;var Y=e.magnitude(e.subtract(s,V,E));Y>W&&(W=Y);var H=e.magnitudeSquared(e.subtract(s,B,E));if(H>U){var j=Math.sqrt(H);G=.5*(G+j),U=G*G;var K=j-G;B.x=(G*B.x+K*s.x)/j,B.y=(G*B.y+K*s.y)/j,B.z=(G*B.z+K*s.z)/j}}return W>G?(e.clone(B,a.center),a.radius=G):(e.clone(V,a.center),a.radius=W),a},f.fromCornerPoints=function(t,r,o){n(o)||(o=new f);var i=o.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),o.radius=e.distance(i,r),o},f.fromEllipsoid=function(t,r){return n(r)||(r=new f),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var R=new e;f.fromBoundingSpheres=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var o=t.length;if(1===o)return f.clone(t[0],r);if(2===o)return f.union(t[0],t[1],r);for(var i=[],a=0;o>a;a++)i.push(t[a].center);r=f.fromPoints(i,r);var s=r.center,u=r.radius;for(a=0;o>a;a++){var c=t[a];u=Math.max(u,e.distance(s,c.center,R)+c.radius)}return r.radius=u,r},f.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius):void 0},f.packedLength=4,f.pack=function(e,t,n){n=r(n,0);var o=e.center;t[n++]=o.x,t[n++]=o.y,t[n++]=o.z,t[n]=e.radius},f.unpack=function(e,t,o){t=r(t,0),n(o)||(o=new f);var i=o.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],o.radius=e[t],o};var N=new e,L=new e;f.union=function(t,r,o){n(o)||(o=new f);var i=t.center,a=r.center;e.add(i,a,L);var s=e.multiplyByScalar(L,.5,L),u=e.magnitude(e.subtract(i,s,N))+t.radius,c=e.magnitude(e.subtract(a,s,N))+r.radius;return o.radius=Math.max(u,c),e.clone(s,o.center),o};var P=new e;f.expand=function(t,r,n){n=f.clone(t,n);var o=e.magnitude(e.subtract(r,n.center,P));return o>n.radius&&(n.radius=o),n},f.intersect=function(t,r){var n=t.center,o=t.radius,i=e.dot(r,n)+r.w;return-o>i?s.OUTSIDE:o>i?s.INTERSECTING:s.INSIDE},f.transform=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var z=new e;f.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,z);return e.magnitudeSquared(n)-t.radius*t.radius},f.transformWithoutScale=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var D=new e;f.computePlaneDistances=function(t,r,o,i){n(i)||(i=new u);var a=e.subtract(t.center,r,D),s=e.multiplyByScalar(o,e.dot(o,a),D),c=e.magnitude(s);return i.start=c-t.radius,i.stop=c+t.radius,i};for(var F=new e,_=new e,B=new e,U=new e,G=new e,q=new t,k=new Array(8),V=0;8>V;++V)k[V]=new e;var W=new a;return f.projectTo2D=function(t,n,o){n=r(n,W);var i=n.ellipsoid,a=t.center,s=t.radius,u=i.geodeticSurfaceNormal(a,F),c=e.cross(e.UNIT_Z,u,_);e.normalize(c,c);var l=e.cross(u,c,B);e.normalize(l,l),e.multiplyByScalar(u,s,u),e.multiplyByScalar(l,s,l),e.multiplyByScalar(c,s,c);var m=e.negate(l,G),h=e.negate(c,U),d=k,p=d[0];e.add(u,l,p),e.add(p,c,p),p=d[1],e.add(u,l,p),e.add(p,h,p),p=d[2],e.add(u,m,p),e.add(p,h,p),p=d[3],e.add(u,m,p),e.add(p,c,p),e.negate(u,u),p=d[4],e.add(u,l,p),e.add(p,c,p),p=d[5],e.add(u,l,p),e.add(p,h,p),p=d[6],e.add(u,m,p),e.add(p,h,p),p=d[7],e.add(u,m,p),e.add(p,c,p);for(var y=d.length,v=0;y>v;++v){var g=d[v];e.add(a,g,g);var E=i.cartesianToCartographic(g,q);n.project(E,g)}o=f.fromPoints(d,o),a=o.center;var S=a.x,C=a.y,w=a.z;return a.x=w,a.y=S,a.z=C,o},f.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;s>a;++a){var u=i[a];o=u+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=u+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",e(document[o])?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",e(document[o])&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",e(document[o])?n.fullscreenElement=o:(o=u+"FullScreenElement",e(document[o])&&(n.fullscreenElement=o)),o=u+"fullscreenchange",e(document["on"+o])&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",e(document["on"+o])&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e){o.supportsFullscreen()&&e[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,v=n(e[1]))}return y}function i(){return o()&&v}function a(){if(!t(g)&&(g=!1,!o()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,E=n(e[1]))}return g}function s(){return a()&&E}function u(){if(!t(S)){S=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(S=!0,C=n(e[1]),C.isNightly=!!e[2])}return S}function c(){return u()&&C}function l(){if(!t(w)){w=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(w=!0,b=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(w=!0,b=n(e[1])))}return w}function f(){return l()&&b}function m(){if(!t(A)){A=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(A=!0,x=n(e[1]))}return A}function h(){return t(T)||(T=/Windows/i.test(navigator.appVersion)),T}function d(){return m()&&x}function p(){return t(M)||(M=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),M}var y,v,g,E,S,C,w,b,A,x,T,M,I={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:m,firefoxVersion:d,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:p};return I.supportsFullscreen=function(){return r.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var s=function(t,r,n,o){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(o,1)};s.fromCartesian4=function(e,r){return t(r)?(r.red=e.x,r.green=e.y,r.blue=e.z,r.alpha=e.w,r):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,n,o,i,a){return r=s.byteToFloat(e(r,255)),n=s.byteToFloat(e(n,255)),o=s.byteToFloat(e(o,255)),i=s.byteToFloat(e(i,255)),t(a)?(a.red=r,a.green=n,a.blue=o,a.alpha=i,a):new s(r,n,o,i)},s.fromAlpha=function(e,r,n){return t(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=r,n):new s(e.red,e.green,e.blue,r)};var u,c,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),c=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return c[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(t,r,n,o){t=e(t,0)%1,r=e(r,0),n=e(n,0),o=e(o,1);var i=n,u=n,c=n;if(0!==r){var l;l=.5>n?n*(1+r):n+r-n*r;var f=2*n-l;i=a(f,l,t+1/3),u=a(f,l,t),c=a(f,l,t-1/3)}return new s(i,u,c,o)},s.fromRandom=function(r,n){r=e(r,e.EMPTY_OBJECT);var o=r.red;if(!t(o)){var a=e(r.minimumRed,0),u=e(r.maximumRed,1);o=a+i.nextRandomNumber()*(u-a)}var c=r.green;if(!t(c)){var l=e(r.minimumGreen,0),f=e(r.maximumGreen,1);c=l+i.nextRandomNumber()*(f-l)}var m=r.blue;if(!t(m)){var h=e(r.minimumBlue,0),d=e(r.maximumBlue,1);m=h+i.nextRandomNumber()*(d-h)}var p=r.alpha;if(!t(p)){var y=e(r.minimumAlpha,0),v=e(r.maximumAlpha,1);p=y+i.nextRandomNumber()*(v-y)}return t(n)?(n.red=o,n.green=c,n.blue=m,n.alpha=p,n):new s(o,c,m,p)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,m=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(r){var n=s[r.toUpperCase()];if(t(n))return s.clone(n);var o=f.exec(r);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=m.exec(r),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=h.exec(r),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(r),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(t,r,n){n=e(n,0),r[n++]=t.red,r[n++]=t.green,r[n++]=t.blue,r[n]=t.alpha},s.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new s),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:0|256*e},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=o,e[3]=i,e):[r,n,o,i]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),c[0]},s.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},s.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUSCHIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s
}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,o){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(t,n,o,a){switch(o=e(o,0),a=e(a,(n.byteLength-o)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(n,o,a);case i.UNSIGNED_BYTE:return new Uint8Array(n,o,a);case i.SHORT:return new Int16Array(n,o,a);case i.UNSIGNED_SHORT:return new Uint16Array(n,o,a);case i.FLOAT:return new Float32Array(n,o,a);case i.DOUBLE:return new Float64Array(n,o,a);default:throw new r("componentDatatype is not a valid value.")}},o(i)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,o){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,o.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var o in e.attributes)if(e.attributes.hasOwnProperty(o)&&t(e.attributes[o])&&t(e.attributes[o].values)){var i=e.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,s),n=i.multiplyByScalar(e,1-r,n),i.add(s,n,n)};var u=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,u),i.normalize(t,c),o.acosClamped(i.dot(u,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,o){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*o.signNotZero(r),t.y=(1-Math.abs(r))*o.signNotZero(n)}return t.x=o.toSNorm(t.x),t.y=o.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=o.fromSNorm(e),n.y=o.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*o.signNotZero(i),n.y=(1-Math.abs(i))*o.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var a=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,a),i.octPackFloat(a)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),o=256*(r-n);return i.octDecode(n,o,t)},i.octPack=function(e,t,r,n){var o=i.octEncodeFloat(e),s=i.octEncodeFloat(t),u=i.octEncode(r,a);return n.x=65536*u.x+o,n.y=65536*u.y+s,n},i.octUnpack=function(e,t,r,n){var o=e.x/65536,a=Math.floor(o),s=65536*(o-a);o=e.y/65536;var u=Math.floor(o),c=65536*(o-u);i.octDecodeFloat(s,t),i.octDecodeFloat(c,r),i.octDecode(a,u,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:0|4096*e.x,r=1===e.y?4095:0|4096*e.y;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=new t,o=new t,i=new t,a=function(a,s,u,c,l){r(l)||(l=new t);var f,m,h,d,p,y,v,g;r(s.z)?(f=t.subtract(u,s,n),m=t.subtract(c,s,o),h=t.subtract(a,s,i),d=t.dot(f,f),p=t.dot(f,m),y=t.dot(f,h),v=t.dot(m,m),g=t.dot(m,h)):(f=e.subtract(u,s,n),m=e.subtract(c,s,o),h=e.subtract(a,s,i),d=e.dot(f,f),p=e.dot(f,m),y=e.dot(f,h),v=e.dot(m,m),g=e.dot(m,h));var E=1/(d*v-p*p);return l.y=(v*y-p*g)*E,l.z=(d*g-p*y)*E,l.x=1-l.y-l.z,l};return a}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};r.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var n={high:0,low:0};r.fromCartesian=function(e,o){t(o)||(o=new r);var i=o.high,a=o.low;return r.encode(e.x,n),i.x=n.high,a.x=n.low,r.encode(e.y,n),i.y=n.high,a.y=n.low,r.encode(e.z,n),i.z=n.high,a.z=n.low,o};var o=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,o);var i=o.high,a=o.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=a.x,t[n+4]=a.y,t[n+5]=a.z},r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var o=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return o}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n){"use strict";var o={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},o.validate=function(t){return e(t)&&(t===o.UNSIGNED_BYTE||t===o.UNSIGNED_SHORT||t===o.UNSIGNED_INT)},o.createTypedArray=function(e,t){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},o.createTypedArrayFromArrayBuffer=function(e,t,r,o){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,o):new Uint16Array(t,r,o)},r(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,o){var i;if(0===e)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),s=Math.abs(e);if(s>a&&a/s<t.EPSILON14)return[0,0];if(a>s&&s/a<t.EPSILON14)return[];if(i=-o/e,0>i)return[];var u=Math.sqrt(i);return[-u,u]}if(0===o)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*o,f=r(c,-l,t.EPSILON14);if(0>f)return[];var m=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[m/e,o/m]:[o/m,m/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var o,i,a=e,s=t/3,u=r/3,c=n,l=a*u,f=s*c,m=s*s,h=u*u,d=a*u-m,p=a*c-s*u,y=s*c-h,v=4*d*y-p*p;if(0>v){var g,E,S;m*f>=l*h?(g=a,E=d,S=-2*s*d+a*p):(g=c,E=y,S=-c*p+2*u*y);var C=0>S?-1:1,w=-C*Math.abs(g)*Math.sqrt(-v);i=-S+w;var b=i/2,A=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),x=i===w?-A:-E/A;return o=0>=E?A+x:-S/(A*A+x*x+E),m*f>=l*h?[(o-s)/a]:[-c/(o+u)]}var T=d,M=-2*s*d+a*p,I=y,O=-c*p+2*u*y,R=Math.sqrt(v),N=Math.sqrt(3)/2,L=Math.abs(Math.atan2(a*R,-M)/3);o=2*Math.sqrt(-T);var P=Math.cos(L);i=o*P;var z=o*(-P/2-N*Math.sin(L)),D=i+z>2*s?i-s:z-s,F=a,_=D/F;L=Math.abs(Math.atan2(c*R,-O)/3),o=2*Math.sqrt(-I),P=Math.cos(L),i=o*P,z=o*(-P/2-N*Math.sin(L));var B=-c,U=2*u>i+z?i+u:z+u,G=B/U,q=F*U,k=-D*U-F*B,V=D*B,W=(u*k-s*V)/(-s*k+u*q);return W>=_?G>=_?G>=W?[_,W,G]:[_,G,W]:[G,_,W]:G>=_?[W,_,G]:G>=W?[W,G,_]:[G,W,_]}var n={};return n.computeDiscriminant=function(e,t,r,n){var o=e*e,i=t*t,a=r*r,s=n*n,u=18*e*t*r*n+i*a-27*o*s-4*(e*a*r+i*t*n);return u},n.computeRealRoots=function(e,n,o,i){var a,s;if(0===e)return t.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];s=-i/e;var u=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[u,u,u]}return 0===i?(a=t.computeRealRoots(e,0,o),0===a.Length?[0]:[a[0],0,a[1]]):r(e,0,o,i)}return 0===o?0===i?(s=-n/e,0>s?[s,0,0]:[0,0,s]):r(e,n,0,i):0===i?(a=t.computeRealRoots(e,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):r(e,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function o(t,o,i,a){var s=t*t,u=o-3*s/8,c=i-o*t/2+s*t/8,l=a-i*t/4+o*s/16-3*s*s/256,f=e.computeRealRoots(1,2*u,u*u-4*l,-c*c);if(f.length>0){var m=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var d=n.computeRealRoots(1,u,l);if(2===d.length){var p,y=d[0],v=d[1];if(y>=0&&v>=0){var g=Math.sqrt(y),E=Math.sqrt(v);return[m-E,m-g,m+g,m+E]}if(y>=0&&0>v)return p=Math.sqrt(y),[m-p,m+p];if(0>y&&v>=0)return p=Math.sqrt(v),[m-p,m+p]}return[]}if(h>0){var S=Math.sqrt(h),C=(u+h-c/S)/2,w=(u+h+c/S)/2,b=n.computeRealRoots(1,S,C),A=n.computeRealRoots(1,-S,w);return 0!==b.length?(b[0]+=m,b[1]+=m,0!==A.length?(A[0]+=m,A[1]+=m,b[1]<=A[0]?[b[0],b[1],A[0],A[1]]:A[1]<=b[0]?[A[0],A[1],b[0],b[1]]:b[0]>=A[0]&&b[1]<=A[1]?[A[0],b[0],b[1],A[1]]:A[0]>=b[0]&&A[1]<=b[1]?[b[0],A[0],A[1],b[1]]:b[0]>A[0]&&b[0]<A[1]?[A[0],b[0],A[1],b[1]]:[b[0],A[0],b[1],A[1]]):b):0!==A.length?(A[0]+=m,A[1]+=m,A):[]}}return[]}function i(t,o,i,a){var s=i*i,u=o*o,c=t*t,l=-2*o,f=i*t+u-4*a,m=c*a-i*o*t+s,h=e.computeRealRoots(1,l,f,m);if(h.length>0){var d,p,y=h[0],v=o-y,g=v*v,E=t/2,S=v/2,C=g-4*a,w=g+4*Math.abs(a),b=c-4*y,A=c+4*Math.abs(y);if(0>y||b*w>C*A){var x=Math.sqrt(b);d=x/2,p=0===x?0:(t*S-i)/x}else{var T=Math.sqrt(C);d=0===T?0:(t*S-i)/T,p=T/2}var M,I;0===E&&0===d?(M=0,I=0):r.sign(E)===r.sign(d)?(M=E+d,I=y/M):(I=E-d,M=y/I);var O,R;0===S&&0===p?(O=0,R=0):r.sign(S)===r.sign(p)?(O=S+p,R=a/O):(R=S-p,O=a/R);var N=n.computeRealRoots(1,M,O),L=n.computeRealRoots(1,I,R);if(0!==N.length)return 0!==L.length?N[1]<=L[0]?[N[0],N[1],L[0],L[1]]:L[1]<=N[0]?[L[0],L[1],N[0],N[1]]:N[0]>=L[0]&&N[1]<=L[1]?[L[0],N[0],N[1],L[1]]:L[0]>=N[0]&&L[1]<=N[1]?[N[0],L[0],L[1],N[1]]:N[0]>L[0]&&N[0]<L[1]?[L[0],N[0],L[1],N[1]]:[N[0],L[0],N[1],L[1]]:N;if(0!==L.length)return L}return[]}var a={};return a.computeDiscriminant=function(e,t,r,n,o){var i=e*e,a=i*e,s=t*t,u=s*t,c=r*r,l=c*r,f=n*n,m=f*n,h=o*o,d=h*o,p=s*c*f-4*u*m-4*e*l*f+18*e*t*r*m-27*i*f*f+256*a*d+o*(18*u*r*n-4*s*l+16*e*c*c-80*e*t*c*n-6*e*s*f+144*i*r*f)+h*(144*e*s*r-27*s*s-128*i*c-192*i*t*n);return p},a.computeRealRoots=function(t,n,a,s,u){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,a,s,u);var c=n/t,l=a/t,f=s/t,m=u/t,h=0>c?1:0;switch(h+=0>l?h+1:h,h+=0>f?h+1:h,h+=0>m?h+1:h){case 0:return o(c,l,f,m);case 1:return i(c,l,f,m);case 2:return i(c,l,f,m);case 3:return o(c,l,f,m);case 4:return o(c,l,f,m);case 5:return i(c,l,f,m);case 6:return o(c,l,f,m);case 7:return o(c,l,f,m);case 8:return i(c,l,f,m);case 9:return o(c,l,f,m);case 10:return o(c,l,f,m);case 11:return i(c,l,f,m);case 12:return o(c,l,f,m);case 13:return o(c,l,f,m);case 14:return o(c,l,f,m);case 15:return o(c,l,f,m);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return n.getPoint=function(t,n,o){return r(o)||(o=new e),o=e.multiplyByScalar(t.direction,n,o),e.add(t.origin,o,o)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,o,i,a,s,u,c){"use strict";function l(t,n,o,a,s){s=r(s,!1);var u,c,l,f,m,h=t.origin,d=t.direction,p=e.subtract(o,n,y),C=e.subtract(a,n,v),w=e.cross(d,C,g),b=e.dot(p,w);if(s){if(b<i.EPSILON6)return void 0;if(u=e.subtract(h,n,E),l=e.dot(u,w),0>l||l>b)return void 0;if(c=e.cross(u,p,S),f=e.dot(d,c),0>f||l+f>b)return void 0;m=e.dot(C,c)/b}else{if(Math.abs(b)<i.EPSILON6)return void 0;var A=1/b;if(u=e.subtract(h,n,E),l=e.dot(u,w)*A,0>l||l>1)return void 0;if(c=e.cross(u,p,S),f=e.dot(d,c)*A,0>f||l+f>1)return void 0;m=e.dot(C,c)*A}return m}function f(e,t,r,n){var o=t*t-4*e*r;if(0>o)return void 0;if(o>0){var i=1/(2*e),a=Math.sqrt(o),s=(-t+a)*i,u=(-t-a)*i;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function m(t,r,o){n(o)||(o={});var i=t.origin,a=t.direction,s=r.center,u=r.radius*r.radius,c=e.subtract(i,s,g),l=e.dot(a,a),m=2*e.dot(a,c),h=e.magnitudeSquared(c)-u,d=f(l,m,h,w);return n(d)?(o.start=d.root0,o.stop=d.root1,o):void 0}function h(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function d(t,r,n,o,c){var l,f=o*o,m=c*c,d=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*m,p=c*(o*h(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],i.EPSILON15)+r.y),y=t[a.COLUMN0ROW0]*f+t[a.COLUMN2ROW2]*m+o*r.x+n,v=m*h(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],i.EPSILON15),g=c*(o*h(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),E=[];if(0===g&&0===v){if(l=s.computeRealRoots(d,p,y),0===l.length)return E;var S=l[0],C=Math.sqrt(Math.max(1-S*S,0));if(E.push(new e(o,c*S,c*-C)),E.push(new e(o,c*S,c*C)),2===l.length){var w=l[1],b=Math.sqrt(Math.max(1-w*w,0));E.push(new e(o,c*w,c*-b)),E.push(new e(o,c*w,c*b))}return E}var A=g*g,x=v*v,T=d*d,M=g*v,I=T+x,O=2*(p*d+M),R=2*y*d+p*p-x+A,N=2*(y*p-M),L=y*y-A;if(0===I&&0===O&&0===R&&0===N)return E;l=u.computeRealRoots(I,O,R,N,L);var P=l.length;if(0===P)return E;for(var z=0;P>z;++z){var D,F=l[z],_=F*F,B=Math.max(1-_,0),U=Math.sqrt(B);D=i.sign(d)===i.sign(y)?h(d*_+y,p*F,i.EPSILON12):i.sign(y)===i.sign(p*F)?h(d*_,p*F+y,i.EPSILON12):h(d*_+p*F,y,i.EPSILON12);var G=h(v*F,g,i.EPSILON15),q=D*G;0>q?E.push(new e(o,c*F,c*U)):q>0?E.push(new e(o,c*F,c*-U)):0!==U?(E.push(new e(o,c*F,c*-U)),E.push(new e(o,c*F,c*U)),++z):E.push(new e(o,c*F,c*U))}return E}var p={};p.rayPlane=function(t,r,o){n(o)||(o=new e);var a=t.origin,s=t.direction,u=r.normal,c=e.dot(u,s);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(u,a))/c;return 0>l?void 0:(o=e.multiplyByScalar(s,l,o),e.add(a,o,o))};var y=new e,v=new e,g=new e,E=new e,S=new e;p.rayTriangle=function(t,r,o,i,a,s){var u=l(t,r,o,i,a);return!n(u)||0>u?void 0:(n(s)||(s=new e),e.multiplyByScalar(t.direction,u,s),e.add(t.origin,s,s))};var C=new c;p.lineSegmentTriangle=function(t,r,o,i,a,s,u){var c=C;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,o,i,a,s);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(u)||(u=new e),e.multiplyByScalar(c.direction,f,u),e.add(c.origin,u,u))};var w={root0:0,root1:0};p.raySphere=function(e,t,r){return r=m(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var b=new c;p.lineSegmentSphere=function(t,r,o,i){var a=b;e.clone(t,a.origin);var s=e.subtract(r,t,a.direction),u=e.magnitude(s);return e.normalize(s,s),i=m(a,o,i),!n(i)||i.stop<0||i.start>u?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,u),i)};var A=new e,x=new e;p.rayEllipsoid=function(t,r){var n,o,i,a,s,u=r.oneOverRadii,c=e.multiplyComponents(u,t.origin,A),l=e.multiplyComponents(u,t.direction,x),f=e.magnitudeSquared(c),m=e.dot(c,l);if(f>1){if(m>=0)return void 0;var h=m*m;if(n=f-1,o=e.magnitudeSquared(l),i=o*n,i>h)return void 0;if(h>i){a=m*m-i,s=-m+Math.sqrt(a);var d=s/o,p=n/s;return p>d?{start:d,stop:p}:{start:p,stop:d}}var y=Math.sqrt(n/o);return{start:y,stop:y}}return 1>f?(n=f-1,o=e.magnitudeSquared(l),i=o*n,a=m*m-i,s=-m+Math.sqrt(a),{start:0,stop:s/o}):0>m?(o=e.magnitudeSquared(l),{start:0,stop:-m/o}):void 0};var T=new e,M=new e,I=new e,O=new e,R=new e,N=new a,L=new a,P=new a,z=new a,D=new a,F=new a,_=new a,B=new e,U=new e,G=new t;p.grazingAltitudeLocation=function(t,r){var o=t.origin,s=t.direction,u=r.geodeticSurfaceNormal(o,T);if(e.dot(s,u)>=0)return o;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(s,T),f=e.normalize(l,l),m=e.mostOrthogonalAxis(l,O),h=e.normalize(e.cross(m,f,M),M),p=e.normalize(e.cross(f,h,I),I),y=N;y[0]=f.x,y[1]=f.y,y[2]=f.z,y[3]=h.x,y[4]=h.y,y[5]=h.z,y[6]=p.x,y[7]=p.y,y[8]=p.z;var v=a.transpose(y,L),g=a.fromScale(r.radii,P),E=a.fromScale(r.oneOverRadii,z),S=D;S[0]=0,S[1]=-s.z,S[2]=s.y,S[3]=s.z,S[4]=0,S[5]=-s.x,S[6]=-s.y,S[7]=s.x,S[8]=0;var C,w,b=a.multiply(a.multiply(v,E,F),S,F),A=a.multiply(a.multiply(b,g,_),y,_),x=a.multiplyByVector(b,o,R),q=d(A,e.negate(x,T),0,0,1),k=q.length;if(k>0){for(var V=e.clone(e.ZERO,U),W=Number.NEGATIVE_INFINITY,Y=0;k>Y;++Y){C=a.multiplyByVector(g,a.multiplyByVector(y,q[Y],B),B);var H=e.normalize(e.subtract(C,o,O),O),j=e.dot(H,s);j>W&&(W=j,V=e.clone(C,V))}var K=r.cartesianToCartographic(V,G);return W=i.clamp(W,0,1),w=e.magnitude(e.subtract(V,o,O))*Math.sqrt(1-W*W),w=c?-w:w,K.height=w,r.cartographicToCartesian(K,new e)}return void 0};var q=new e;return p.lineSegmentPlane=function(t,r,o,a){n(a)||(a=new e);var s=e.subtract(r,t,q),u=o.normal,c=e.dot(u,s);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(u,t),f=-(o.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(s,f,a),e.add(t,a,a),a)},p.trianglePlaneIntersection=function(t,r,n,o){var i=o.normal,a=o.distance,s=e.dot(i,t)+a<0,u=e.dot(i,r)+a<0,c=e.dot(i,n)+a<0,l=0;l+=s?1:0,l+=u?1:0,l+=c?1:0;var f,m;if((1===l||2===l)&&(f=new e,m=new e),1===l){if(s)return p.lineSegmentPlane(t,r,o,f),p.lineSegmentPlane(t,n,o,m),{positions:[t,r,n,f,m],indices:[0,3,4,1,2,4,1,4,3]};if(u)return p.lineSegmentPlane(r,n,o,f),p.lineSegmentPlane(r,t,o,m),{positions:[t,r,n,f,m],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(n,t,o,f),p.lineSegmentPlane(n,r,o,m),{positions:[t,r,n,f,m],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!s)return p.lineSegmentPlane(r,t,o,f),p.lineSegmentPlane(n,t,o,m),{positions:[t,r,n,f,m],indices:[1,2,4,1,4,3,0,3,4]};if(!u)return p.lineSegmentPlane(n,r,o,f),p.lineSegmentPlane(t,r,o,m),{positions:[t,r,n,f,m],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,n,o,f),p.lineSegmentPlane(r,n,o,m),{positions:[t,r,n,f,m],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},p}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(t,r){this.normal=e.clone(t),this.distance=r};return r.fromPointNormal=function(n,o,i){var a=-e.dot(o,n);return t(i)?(e.clone(o,i.normal),i.distance=a,i):new r(o,a)},r.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},r}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};return r.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,o=r.maximumIndex,i=e(r.cacheSize,24),a=n.length;if(!t(o)){o=0;for(var s=0,u=n[s];a>s;)u>o&&(o=u),++s,u=n[s]}for(var c=[],l=0;o+1>l;l++)c[l]=0;for(var f=i+1,m=0;a>m;++m)f-c[n[m]]>i&&(c[n[m]]=f,++f);return(f-i+1)/(a/3)},r.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var o=t[t.length-1];if(t.splice(t.length-1,1),e[o].numLiveTriangles>0)return o}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function o(e,t,r,o,i,a,s){for(var u,c=-1,l=-1,f=0;f<r.length;){var m=r[f];o[m].numLiveTriangles&&(u=0,i-o[m].timeStamp+2*o[m].numLiveTriangles<=t&&(u=i-o[m].timeStamp),(u>l||-1===l)&&(l=u,c=m)),++f}return-1===c?n(o,a,e,s):c}r=e(r,e.EMPTY_OBJECT);var i,a=r.indices,s=r.maximumIndex,u=e(r.cacheSize,24),c=a.length,l=0,f=0,m=a[f],h=c;if(t(s))l=s+1;else{for(;h>f;)m>l&&(l=m),++f,m=a[f];if(-1===l)return 0;++l}for(var d=[],p=0;l>p;p++)d[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var y=0;h>f;)d[a[f]].vertexTriangles.push(y),++d[a[f]].numLiveTriangles,d[a[f+1]].vertexTriangles.push(y),++d[a[f+1]].numLiveTriangles,d[a[f+2]].vertexTriangles.push(y),++d[a[f+2]].numLiveTriangles,++y,f+=3;var v=0,g=u+1;i=1;var E,S,C=[],w=[],b=0,A=[],x=c/3,T=[];for(p=0;x>p;p++)T[p]=!1;for(var M,I;-1!==v;){C=[],S=d[v],I=S.vertexTriangles.length;for(var O=0;I>O;++O)if(y=S.vertexTriangles[O],!T[y]){T[y]=!0,f=y+y+y;for(var R=0;3>R;++R)M=a[f],C.push(M),w.push(M),A[b]=M,++b,E=d[M],--E.numLiveTriangles,g-E.timeStamp>u&&(E.timeStamp=g,++g),++f}v=o(a,u,C,d,g,w,l)}return A},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,o,i,a,s,u,c,l,f,m,h,d,p,y,v,g,E,S,C,w,b,A,x){"use strict";function T(e,t,r,n,o){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=o,e[t++]=o,e[t]=r}function M(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),o=0,i=0;t>i;i+=3,o+=6)T(n,o,e[i],e[i+1],e[i+2]);return n}function I(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);T(n,0,e[0],e[1],e[2]);for(var o=6,i=3;t>i;++i,o+=6)T(n,o,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),o=e[0],i=0,a=1;t>a;++a,i+=6)T(n,i,o,e[a],e[a+1]);return n}return new Uint16Array}function R(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function N(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var o=t[n],i=0;i<o.componentsPerAttribute;++i)e[n].values.push(o.values[r*o.componentsPerAttribute+i])}function L(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,it),w.multiplyByPoint(e,it,it),o.pack(it,r,i)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,it),C.multiplyByVector(e,it,it),it=o.normalize(it,it),o.pack(it,r,i)}function z(e,t){var r,n=e.length,o={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var a=i[r],u=a.values.length,l=!0,f=1;n>f;++f){var m=e[f][t].attributes[r];if(!c(m)||a.componentDatatype!==m.componentDatatype||a.componentsPerAttribute!==m.componentsPerAttribute||a.normalize!==m.normalize){l=!1;break}u+=m.values.length}l&&(o[r]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:s.createTypedArray(a.componentDatatype,u)}))}return o}function D(e,t){var n,i,a,s,u=e.length;e[0].modelMatrix;var l,f,m,d=c(e[0][t].indices),p=e[0][t].primitiveType,y=z(e,t);for(n in y)if(y.hasOwnProperty(n))for(l=y[n].values,s=0,i=0;u>i;++i)for(f=e[i][t].attributes[n].values,m=f.length,a=0;m>a;++a)l[s++]=f[a];var g;if(d){var E=0;for(i=0;u>i;++i)E+=e[i][t].indices.length;var S=h.computeNumberOfVertices(new h({attributes:y,primitiveType:A.POINTS})),C=v.createTypedArray(S,E),w=0,b=0;for(i=0;u>i;++i){var x=e[i][t].indices,T=x.length;for(s=0;T>s;++s)C[w++]=b+x[s];b+=h.computeNumberOfVertices(e[i][t])}g=C}var M,I=new o,O=0;for(i=0;u>i;++i){if(M=e[i][t].boundingSphere,!c(M)){I=void 0;break}o.add(M.center,I,I)}if(c(I))for(o.divideByScalar(I,u,I),i=0;u>i;++i){M=e[i][t].boundingSphere;var R=o.magnitude(o.subtract(M.center,I,ut))+M.radius;R>O&&(O=R)}return new h({attributes:y,indices:g,primitiveType:p,boundingSphere:c(I)?new r(I,O):void 0})}function F(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function _(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,o=3;t>o;++o)r[n++]=o-1,r[n++]=0,r[n++]=o;return e.indices=r,e.primitiveType=A.TRIANGLES,e}function B(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,o=3;t-1>o;o+=2)r[n++]=o,r[n++]=o-1,r[n++]=o+1,t>o+2&&(r[n++]=o,r[n++]=o+1,r[n++]=o+2);return e.indices=r,e.primitiveType=A.TRIANGLES,e}function U(e){if(c(e.indices))return e;for(var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return e.indices=r,e.primitiveType=A.LINES,e}function q(e){var t=h.computeNumberOfVertices(e),r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=A.LINES,e}function k(e){switch(e.primitiveType){case A.TRIANGLE_FAN:return _(e);case A.TRIANGLE_STRIP:return B(e);case A.TRIANGLES:return F(e);case A.LINE_STRIP:return G(e);case A.LINE_LOOP:return q(e);case A.LINES:return U(e)}return e}function V(e,t){Math.abs(e.y)<S.EPSILON6&&(e.y=t?-S.EPSILON6:S.EPSILON6)}function W(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return V(e,e.y<0),V(t,t.y<0),V(r,r.y<0),void 0;var n,o=Math.abs(e.y),i=Math.abs(t.y),a=Math.abs(r.y);n=o>i?o>a?S.sign(e.y):S.sign(r.y):i>a?S.sign(t.y):S.sign(r.y);var s=0>n;V(e,s),V(t,s),V(r,s)}function Y(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,St),e.y/(e.y-t.y),St),r),o.clone(r,n),V(r,!0),V(n,!1)}function H(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;W(e,t,r);var n=e.y<0,o=t.y<0,i=r.y<0,a=0;a+=n?1:0,a+=o?1:0,a+=i?1:0;var s=xt.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(Y(e,t,Ct,bt),Y(e,r,wt,At),s[0]=0,s[3]=1,s[4]=2,s[6]=1):o?(Y(t,r,Ct,bt),Y(t,e,wt,At),s[0]=1,s[3]=2,s[4]=0,s[6]=2):i&&(Y(r,e,Ct,bt),Y(r,t,wt,At),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?o?i||(Y(r,e,Ct,bt),Y(r,t,wt,At),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(Y(t,r,Ct,bt),Y(t,e,wt,At),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(Y(e,t,Ct,bt),Y(e,r,wt,At),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=xt.positions;return u[0]=e,u[1]=t,u[2]=r,u.length=3,(1===a||2===a)&&(u[3]=Ct,u[4]=wt,u[5]=bt,u[6]=At,u.length=7),xt}function j(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var o in n)if(n.hasOwnProperty(o)&&c(n[o])&&c(n[o].values)){var i=n[o];i.values=s.createTypedArray(i.componentDatatype,i.values)}var a=h.computeNumberOfVertices(e);return e.indices=v.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function K(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var o=t[n];r[n]=new d({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var n=c(e.geometry.boundingSphere);t=j(t,n),r=j(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function X(e,r,i,a,s,u,l,f,m,h,d){if(c(u)||c(l)||c(f)||c(m)){var p=o.fromArray(s,3*e,Tt),y=o.fromArray(s,3*r,Mt),v=o.fromArray(s,3*i,It),g=t(a,p,y,v,Ot);if(c(u)){var E=o.fromArray(u,3*e,Tt),S=o.fromArray(u,3*r,Mt),C=o.fromArray(u,3*i,It);o.multiplyByScalar(E,g.x,E),o.multiplyByScalar(S,g.y,S),o.multiplyByScalar(C,g.z,C);var w=o.add(E,S,E);o.add(w,C,w),o.normalize(w,w),o.pack(w,h.normal.values,3*d)}if(c(l)){var b=o.fromArray(l,3*e,Tt),A=o.fromArray(l,3*r,Mt),x=o.fromArray(l,3*i,It);o.multiplyByScalar(b,g.x,b),o.multiplyByScalar(A,g.y,A),o.multiplyByScalar(x,g.z,x);var T=o.add(b,A,b);o.add(T,x,T),o.normalize(T,T),o.pack(T,h.binormal.values,3*d)}if(c(f)){var M=o.fromArray(f,3*e,Tt),I=o.fromArray(f,3*r,Mt),O=o.fromArray(f,3*i,It);o.multiplyByScalar(M,g.x,M),o.multiplyByScalar(I,g.y,I),o.multiplyByScalar(O,g.z,O);var R=o.add(M,I,M);o.add(R,O,R),o.normalize(R,R),o.pack(R,h.tangent.values,3*d)}if(c(m)){var N=n.fromArray(m,2*e,Rt),L=n.fromArray(m,2*r,Nt),P=n.fromArray(m,2*i,Lt);n.multiplyByScalar(N,g.x,N),n.multiplyByScalar(L,g.y,L),n.multiplyByScalar(P,g.z,P);var z=n.add(N,L,N);n.add(z,P,z),n.pack(z,h.st.values,2*d)}}}function Q(e,t,r,n,o,i){var a=e.position.values.length/3;
if(-1!==o){var s=n[o],u=r[s];return-1===u?(r[s]=a,e.position.values.push(i.x,i.y,i.z),t.push(a),a):(t.push(u),u)}return e.position.values.push(i.x,i.y,i.z),t.push(a),a}function J(e){var t,r,n,i,a,s=e.geometry,u=s.attributes,l=u.position.values,f=c(u.normal)?u.normal.values:void 0,m=c(u.binormal)?u.binormal.values:void 0,h=c(u.tangent)?u.tangent.values:void 0,d=c(u.st)?u.st.values:void 0,p=s.indices,y=K(s),v=K(s),g=[];g.length=l.length/3;var E=[];for(E.length=l.length/3,a=0;a<g.length;++a)g[a]=-1,E[a]=-1;var S=p.length;for(a=0;S>a;a+=3){var C=p[a],w=p[a+1],b=p[a+2],A=o.fromArray(l,3*C),x=o.fromArray(l,3*w),T=o.fromArray(l,3*b),M=H(A,x,T);if(c(M)&&M.positions.length>3)for(var I=M.positions,O=M.indices,R=O.length,N=0;R>N;++N){var L=O[N],P=I[L];P.y<0?(t=v.attributes,r=v.indices,n=g):(t=y.attributes,r=y.indices,n=E),i=Q(t,r,n,p,3>L?a+L:-1,P),X(C,w,b,P,l,f,m,h,d,t,i)}else c(M)&&(A=M.positions[0],x=M.positions[1],T=M.positions[2]),A.y<0?(t=v.attributes,r=v.indices,n=g):(t=y.attributes,r=y.indices,n=E),i=Q(t,r,n,p,a,A),X(C,w,b,A,l,f,m,h,d,t,i),i=Q(t,r,n,p,a+1,x),X(C,w,b,x,l,f,m,h,d,t,i),i=Q(t,r,n,p,a+2,T),X(C,w,b,T,l,f,m,h,d,t,i)}Z(e,v,y)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,a=r.indices,s=K(r),u=K(r),l=a.length,f=[];f.length=i.length/3;var m=[];for(m.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,m[t]=-1;for(t=0;l>t;t+=2){var h=a[t],d=a[t+1],p=o.fromArray(i,3*h,Tt),y=o.fromArray(i,3*d,Mt);Math.abs(p.y)<S.EPSILON6&&(p.y=p.y<0?-S.EPSILON6:S.EPSILON6),Math.abs(y.y)<S.EPSILON6&&(y.y=y.y<0?-S.EPSILON6:S.EPSILON6);var v=s.attributes,g=s.indices,C=m,w=u.attributes,b=u.indices,A=f,x=E.lineSegmentPlane(p,y,Pt,It);if(c(x)){var T=o.multiplyByScalar(o.UNIT_Y,5*S.EPSILON9,zt);p.y<0&&(o.negate(T,T),v=u.attributes,g=u.indices,C=f,w=s.attributes,b=s.indices,A=m);var M=o.add(x,T,Dt);Q(v,g,C,a,t,p),Q(v,g,C,a,-1,M),o.negate(T,T),o.add(x,T,M),Q(w,b,A,a,-1,M),Q(w,b,A,a,t+1,y)}else{var I,O,R;p.y<0?(I=u.attributes,O=u.indices,R=f):(I=s.attributes,O=s.indices,R=m),Q(I,O,R,a,t,p),Q(I,O,R,a,t+1,y)}}Z(e,u,s)}function et(e){var t=e.geometry,r=t.attributes,a=r.position.values,s=r.prevPosition.values,u=r.nextPosition.values,l=r.expandAndWidth.values;t.indices;var f,m,h,d=c(r.st)?r.st.values:void 0,p=c(r.color)?r.color.values:void 0,y=K(t),v=K(t),g=a.length/3;for(f=0;g>f;f+=4){var C=f,w=f+1,b=f+2,A=f+3,x=o.fromArray(a,3*C,Bt),T=o.fromArray(a,3*w,Ut),M=o.fromArray(a,3*b,Gt),I=o.fromArray(a,3*A,qt);Math.abs(x.y)<S.EPSILON6&&(x.y=S.EPSILON6*(M.y<0?-1:1),T.y=x.y),Math.abs(M.y)<S.EPSILON6&&(M.y=S.EPSILON6*(x.y<0?-1:1),I.y=M.y);var O=y.attributes,R=y.indices,N=v.attributes,L=v.indices,P=E.lineSegmentPlane(x,M,Pt,kt);if(c(P)){var z=o.multiplyByScalar(o.UNIT_Y,5*S.EPSILON9,Vt);x.y<0&&(o.negate(z,z),O=v.attributes,R=v.indices,N=y.attributes,L=y.indices);var D=o.add(P,z,Wt);for(O.position.values.push(x.x,x.y,x.z,T.x,T.y,T.z),O.position.values.push(D.x,D.y,D.z),O.position.values.push(D.x,D.y,D.z),o.negate(z,z),o.add(P,z,D),N.position.values.push(D.x,D.y,D.z),N.position.values.push(D.x,D.y,D.z),N.position.values.push(M.x,M.y,M.z,I.x,I.y,I.z),m=3*C;3*C+6>m;++m)O.prevPosition.values.push(s[m]);for(O.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),N.prevPosition.values.push(x.x,x.y,x.z,x.x,x.y,x.z),m=3*b;3*b+6>m;++m)N.prevPosition.values.push(s[m]);for(m=3*C;3*C+6>m;++m)O.nextPosition.values.push(u[m]);for(O.nextPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),N.nextPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),m=3*b;3*b+6>m;++m)N.nextPosition.values.push(u[m]);var F=n.fromArray(l,2*C,Ft),_=Math.abs(F.y);O.expandAndWidth.values.push(-1,_,1,_),O.expandAndWidth.values.push(-1,-_,1,-_),N.expandAndWidth.values.push(-1,_,1,_),N.expandAndWidth.values.push(-1,-_,1,-_);var B=o.magnitudeSquared(o.subtract(P,x,qt));if(B/=o.magnitudeSquared(o.subtract(M,x,qt)),c(p)){var U=i.fromArray(p,4*C,Yt),G=i.fromArray(p,4*b,Yt),q=S.lerp(U.x,G.x,B),k=S.lerp(U.y,G.y,B),V=S.lerp(U.z,G.z,B),W=S.lerp(U.w,G.w,B);for(m=4*C;4*C+8>m;++m)O.color.values.push(p[m]);for(O.color.values.push(q,k,V,W),O.color.values.push(q,k,V,W),N.color.values.push(q,k,V,W),N.color.values.push(q,k,V,W),m=4*b;4*b+8>m;++m)N.color.values.push(p[m])}if(c(d)){var Y=n.fromArray(d,2*C,Ft),H=n.fromArray(d,2*(f+3),_t),j=S.lerp(Y.x,H.x,B);for(m=2*C;2*C+4>m;++m)O.st.values.push(d[m]);for(O.st.values.push(j,Y.y),O.st.values.push(j,H.y),N.st.values.push(j,Y.y),N.st.values.push(j,H.y),m=2*b;2*b+4>m;++m)N.st.values.push(d[m])}h=O.position.values.length/3-4,R.push(h,h+2,h+1),R.push(h+1,h+2,h+3),h=N.position.values.length/3-4,L.push(h,h+2,h+1),L.push(h+1,h+2,h+3)}else{var X,Q;for(x.y<0?(X=v.attributes,Q=v.indices):(X=y.attributes,Q=y.indices),X.position.values.push(x.x,x.y,x.z),X.position.values.push(T.x,T.y,T.z),X.position.values.push(M.x,M.y,M.z),X.position.values.push(I.x,I.y,I.z),m=3*f;3*f+12>m;++m)X.prevPosition.values.push(s[m]),X.nextPosition.values.push(u[m]);for(m=2*f;2*f+8>m;++m)X.expandAndWidth.values.push(l[m]),c(d)&&X.st.values.push(d[m]);if(c(p))for(m=4*f;4*f+16>m;++m)X.color.values.push(p[m]);h=X.position.values.length/3-4,Q.push(h,h+2,h+1),Q.push(h+1,h+2,h+3)}}Z(e,v,y)}var tt={};tt.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case A.TRIANGLES:e.indices=M(t);break;case A.TRIANGLE_STRIP:e.indices=I(t);break;case A.TRIANGLE_FAN:e.indices=O(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=A.LINES}return e},tt.createLineSegmentsForVectors=function(e,t,n){t=u(t,"normal"),n=u(n,1e4);for(var o=e.attributes.position.values,i=e.attributes[t].values,a=o.length,l=new Float64Array(2*a),f=0,m=0;a>m;m+=3)l[f++]=o[m],l[f++]=o[m+1],l[f++]=o[m+2],l[f++]=o[m]+i[m]*n,l[f++]=o[m+1]+i[m+1]*n,l[f++]=o[m+2]+i[m+2]*n;var p,y=e.boundingSphere;return c(y)&&(p=new r(y.center,y.radius+n)),new h({attributes:{position:new d({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:A.LINES,boundingSphere:p})},tt.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,o={},i=0,a=r.length;for(t=0;a>t;++t){var s=r[t];c(n[s])&&(o[s]=i++)}for(var u in n)n.hasOwnProperty(u)&&!c(o[u])&&(o[u]=i++);return o},tt.reorderForPreVertexCache=function(e){var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),o=0;t>o;o++)n[o]=-1;for(var i,a=r,u=a.length,l=v.createTypedArray(t,u),f=0,m=0,d=0;u>f;)i=n[a[f]],-1!==i?l[m]=i:(i=a[f],n[i]=d,l[m]=d,++d),++f,++m;e.indices=l;var p=e.attributes;for(var y in p)if(p.hasOwnProperty(y)&&c(p[y])&&c(p[y].values)){for(var g=p[y],E=g.values,S=0,C=g.componentsPerAttribute,w=s.createTypedArray(g.componentDatatype,d*C);t>S;){var b=n[S];if(-1!==b)for(o=0;C>o;o++)w[C*b+o]=E[C*S+o];++S}g.values=w}}return e},tt.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===A.TRIANGLES&&c(r)){for(var n=r.length,o=0,i=0;n>i;i++)r[i]>o&&(o=r[i]);e.indices=x.tipsify({indices:r,maximumIndex:o,cacheSize:t})}return e},tt.fitToUnsignedShortIndices=function(e){var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>S.SIXTY_FOUR_KILOBYTES){var n,o=[],i=[],a=0,s=R(e.attributes),u=e.indices,l=u.length;e.primitiveType===A.TRIANGLES?n=3:e.primitiveType===A.LINES?n=2:e.primitiveType===A.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var m=0;n>m;++m){var d=u[f+m],p=o[d];c(p)||(p=a++,o[d]=p,N(s,e.attributes,d)),i.push(p)}a+n>S.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:s,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),o=[],i=[],a=0,s=R(e.attributes))}0!==i.length&&t.push(new h({attributes:s,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var rt=new o,nt=new a;tt.projectTo2D=function(e,t,r,n,i){var a=e.attributes[t];i=c(i)?i:new m;for(var u=i.ellipsoid,f=a.values,h=new Float64Array(f.length),p=0,y=0;y<f.length;y+=3){var v=o.fromArray(f,y,rt),g=u.cartesianToCartographic(v,nt);if(!c(g))throw new l("Could not project point ("+v.x+", "+v.y+", "+v.z+") to 2D.");var E=i.project(g,rt);h[p++]=E.x,h[p++]=E.y,h[p++]=E.z}return e.attributes[r]=a,e.attributes[n]=new d({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var ot={high:0,low:0};tt.encodeAttribute=function(e,t,r,n){for(var o=e.attributes[t],i=o.values,a=i.length,u=new Float32Array(a),c=new Float32Array(a),l=0;a>l;++l)f.encode(i[l],ot),u[l]=ot.high,c[l]=ot.low;var m=o.componentsPerAttribute;return e.attributes[r]=new d({componentDatatype:s.FLOAT,componentsPerAttribute:m,values:u}),e.attributes[n]=new d({componentDatatype:s.FLOAT,componentsPerAttribute:m,values:c}),delete e.attributes[t],e};var it=new o,at=new w,st=new C;tt.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(w.equals(t,w.IDENTITY))return e;var n=e.geometry.attributes;L(t,n.position),L(t,n.prevPosition),L(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(w.inverse(t,at),w.transpose(at,at),w.getRotation(at,st),P(st,n.normal),P(st,n.binormal),P(st,n.tangent));var o=e.geometry.boundingSphere;return c(o)&&(e.geometry.boundingSphere=r.transform(o,t,o)),e.modelMatrix=w.clone(w.IDENTITY),e};var ut=new o;tt.combineInstances=function(e){for(var t=[],r=[],n=e.length,o=0;n>o;++o){var i=e[o];c(i.geometry)?t.push(i):r.push(i)}var a=[];return t.length>0&&a.push(D(t,"geometry")),r.length>0&&(a.push(D(r,"westHemisphereGeometry")),a.push(D(r,"eastHemisphereGeometry"))),a};var ct=new o,lt=new o,ft=new o,mt=new o;tt.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,a=t.length,u=new Array(i),c=new Array(a/3),l=new Array(a),f=0;i>f;f++)u[f]={indexOffset:0,count:0,currentCount:0};var m=0;for(f=0;a>f;f+=3){var h=t[f],p=t[f+1],y=t[f+2],v=3*h,g=3*p,E=3*y;lt.x=n[v],lt.y=n[v+1],lt.z=n[v+2],ft.x=n[g],ft.y=n[g+1],ft.z=n[g+2],mt.x=n[E],mt.y=n[E+1],mt.z=n[E+2],u[h].count++,u[p].count++,u[y].count++,o.subtract(ft,lt,ft),o.subtract(mt,lt,mt),c[m]=o.cross(ft,mt,new o),m++}var S=0;for(f=0;i>f;f++)u[f].indexOffset+=S,S+=u[f].count;m=0;var C;for(f=0;a>f;f+=3){C=u[t[f]];var w=C.indexOffset+C.currentCount;l[w]=m,C.currentCount++,C=u[t[f+1]],w=C.indexOffset+C.currentCount,l[w]=m,C.currentCount++,C=u[t[f+2]],w=C.indexOffset+C.currentCount,l[w]=m,C.currentCount++,m++}var b=new Float32Array(3*i);for(f=0;i>f;f++){var A=3*f;if(C=u[f],C.count>0){for(o.clone(o.ZERO,ct),m=0;m<C.count;m++)o.add(ct,c[l[C.indexOffset+m]],ct);o.normalize(ct,ct),b[A]=ct.x,b[A+1]=ct.y,b[A+2]=ct.z}else b[A]=0,b[A+1]=0,b[A+2]=1}return e.attributes.normal=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:b}),e};var ht=new o,dt=new o,pt=new o;tt.computeBinormalAndTangent=function(e){e.attributes;for(var t=e.indices,r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,a=e.attributes.position.values.length/3,u=t.length,c=new Array(3*a),l=0;l<c.length;l++)c[l]=0;var f,m,h;for(l=0;u>l;l+=3){var p=t[l],y=t[l+1],v=t[l+2];f=3*p,m=3*y,h=3*v;var g=2*p,E=2*y,S=2*v,C=r[f],w=r[f+1],b=r[f+2],A=i[g],x=i[g+1],T=i[E+1]-x,M=i[S+1]-x,I=1/((i[E]-A)*M-(i[S]-A)*T),O=(M*(r[m]-C)-T*(r[h]-C))*I,R=(M*(r[m+1]-w)-T*(r[h+1]-w))*I,N=(M*(r[m+2]-b)-T*(r[h+2]-b))*I;c[f]+=O,c[f+1]+=R,c[f+2]+=N,c[m]+=O,c[m+1]+=R,c[m+2]+=N,c[h]+=O,c[h+1]+=R,c[h+2]+=N}var L=new Float32Array(3*a),P=new Float32Array(3*a);for(l=0;a>l;l++){f=3*l,m=f+1,h=f+2;var z=o.fromArray(n,f,ht),D=o.fromArray(c,f,pt),F=o.dot(z,D);o.multiplyByScalar(z,F,dt),o.normalize(o.subtract(D,dt,D),D),P[f]=D.x,P[m]=D.y,P[h]=D.z,o.normalize(o.cross(z,D,D),D),L[f]=D.x,L[m]=D.y,L[h]=D.z}return e.attributes.tangent=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.binormal=new d({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:L}),e};var yt=new n,vt=new o,gt=new o,Et=new o;tt.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var a,u,l,f,m=t.attributes.tangent,h=t.attributes.binormal;c(r)&&(a=r.values),c(i)&&(u=i.values),c(m)&&(l=m.values),h&&(f=h.values);var p=c(a)?a.length:u.length,y=c(a)?3:2,v=p/y,g=v,E=c(u)&&c(a)?2:1;E+=c(l)||c(f)?1:0,g*=E;for(var S=new Float32Array(g),C=0,w=0;v>w;++w){c(u)&&(n.fromArray(u,2*w,yt),S[C++]=e.compressTextureCoordinates(yt));var b=3*w;c(a)&&c(l)&&c(f)?(o.fromArray(a,b,vt),o.fromArray(l,b,gt),o.fromArray(f,b,Et),e.octPack(vt,gt,Et,yt),S[C++]=yt.x,S[C++]=yt.y):(c(a)&&(o.fromArray(a,b,vt),S[C++]=e.octEncodeFloat(vt)),c(l)&&(o.fromArray(l,b,vt),S[C++]=e.octEncodeFloat(vt)),c(f)&&(o.fromArray(f,b,vt),S[C++]=e.octEncodeFloat(vt)))}return t.attributes.compressedAttributes=new d({componentDatatype:s.FLOAT,componentsPerAttribute:E,values:S}),c(a)&&delete t.attributes.normal,c(u)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var St=new o,Ct=new o,wt=new o,bt=new o,At=new o,xt={positions:new Array(7),indices:new Array(9)},Tt=new o,Mt=new o,It=new o,Ot=new o,Rt=new n,Nt=new n,Lt=new n,Pt=b.fromPointNormal(o.ZERO,o.UNIT_Y),zt=new o,Dt=new o,Ft=new n,_t=new n,Bt=new o,Ut=new o,Gt=new o,qt=new o,kt=new o,Vt=new o,Wt=new o,Yt=new i;return new i,tt.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var o=n.center.x-n.radius;if(o>0||r.intersect(n,i.UNIT_Y)!==g.INTERSECTING)return e}if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:et(e);break;case y.TRIANGLES:J(e);break;case y.LINES:$(e)}else k(t),t.primitiveType===A.TRIANGLES?J(e):t.primitiveType===A.LINES&&$(e);return e},tt}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,o,i,a,s){"use strict";var u=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},u.geodeticLatitudeToMercatorAngle=function(e){e>u.MaximumLatitude?e=u.MaximumLatitude:e<-u.MaximumLatitude&&(e=-u.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},u.MaximumLatitude=u.mercatorAngleToGeodeticLatitude(Math.PI),u.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=u.geodeticLatitudeToMercatorAngle(t.latitude)*o,s=t.height;return n(r)?(r.x=i,r.y=a,r.z=s,r):new e(i,a,s)},u.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=u.mercatorAngleToGeodeticLatitude(e.y*o),s=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=s,r):new t(i,a,s)},u}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,n,o,i,a,s,u,c,l,f,m,h,d,p){"use strict";function y(e,t,r){var n,o=!r,i=e.length;if(!o&&i>1){var a=e[0].modelMatrix;for(n=1;i>n;++n)if(!d.equals(a,e[n].modelMatrix)){o=!0;break}}if(o)for(n=0;i>n;++n)m.transformToWorldCoordinates(e[n]);else d.multiplyTransformation(t,e[0].modelMatrix,t)}function v(e,n){var o=e.attributes,i=o.position,a=4*(i.values.length/i.componentsPerAttribute);o.pickColor=new l({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var s=t.floatToByte(n.red),u=t.floatToByte(n.green),c=t.floatToByte(n.blue),f=t.floatToByte(n.alpha),m=o.pickColor.values,h=0;a>h;h+=4)m[h]=s,m[h+1]=u,m[h+2]=c,m[h+3]=f}function g(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=t[n];o(i.geometry)?v(i.geometry,a):(v(i.westHemisphereGeometry,a),v(i.eastHemisphereGeometry,a))}}function E(e){var t,r=e.length,n=[],i=e[0].attributes;for(t in i)if(i.hasOwnProperty(t)){for(var a=i[t],s=!0,u=1;r>u;++u){var c=e[u].attributes[t];if(!o(c)||a.componentDatatype!==c.componentDatatype||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){s=!1;break}}s&&n.push(t)}return n}function S(e,t,n){for(var o=c.computeNumberOfVertices(t),i=n.length,a=0;i>a;++a){for(var s=n[a],u=e[s],f=u.componentDatatype,m=u.value,h=m.length,d=r.createTypedArray(f,o*h),p=0;o>p;++p)d.set(m,p*h);t.attributes[s]=new l({componentDatatype:f,componentsPerAttribute:h,normalize:u.normalize,values:d})}}function C(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=i.attributes;o(i.geometry)?S(a,i.geometry,t):(S(a,i.westHemisphereGeometry,t),S(a,i.eastHemisphereGeometry,t))}}function w(t){var n,i,a=t.instances,s=t.pickIds,u=t.projection,c=t.elementIndexUintSupported,l=t.scene3DOnly,f=t.allowPicking,h=t.vertexCacheOptimize,d=t.compressVertices,p=t.modelMatrix,v=a.length;if(a[0].geometry.primitiveType,y(a,p,l),!l)for(n=0;v>n;++n)m.splitLongitude(a[n]);f&&g(a,s);var S=E(a);if(C(a,S),h)for(n=0;v>n;++n){var w=a[n];o(w.geometry)?(m.reorderForPostVertexCache(w.geometry),m.reorderForPreVertexCache(w.geometry)):(m.reorderForPostVertexCache(w.westHemisphereGeometry),m.reorderForPreVertexCache(w.westHemisphereGeometry),m.reorderForPostVertexCache(w.eastHemisphereGeometry),m.reorderForPreVertexCache(w.eastHemisphereGeometry))}var b=m.combineInstances(a);for(v=b.length,n=0;v>n;++n){i=b[n];var A,x=i.attributes;if(l)for(A in x)x.hasOwnProperty(A)&&x[A].componentDatatype===r.DOUBLE&&m.encodeAttribute(i,A,A+"3DHigh",A+"3DLow");else for(A in x)if(x.hasOwnProperty(A)&&x[A].componentDatatype===r.DOUBLE){var T=A+"3D",M=A+"2D";m.projectTo2D(i,A,T,M,u),o(i.boundingSphere)&&"position"===A&&(i.boundingSphereCV=e.fromVertices(i.attributes.position2D.values)),m.encodeAttribute(i,T,T+"High",T+"Low"),m.encodeAttribute(i,M,M+"High",M+"Low")}d&&m.compressVertices(i)}if(!c){var I=[];for(v=b.length,n=0;v>n;++n)i=b[n],I=I.concat(m.fitToUnsignedShortIndices(i));b=I}return b}function b(e,t,n){for(var o=[],i=e.attributes,a=n.length,s=0;a>s;++s){var u=n[s],c=i[u],l=c.componentDatatype;l===r.DOUBLE&&(l=r.FLOAT);var f=r.createTypedArray(l,c.values);o.push({index:t[u],componentDatatype:l,componentsPerAttribute:c.componentsPerAttribute,normalize:c.normalize,values:f}),delete i[u]}return o}function A(e,t,r,i,a,s,u,l,f){var m=c.computeNumberOfVertices(t);o(u[e])||(u[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var h=i.length,d=0;h>d;++d)for(var p=i[d],y=a[p],v=m;v>0;){for(var g,E=n(f[p],0),S=s[E],C=S.length,w=0;C>w&&(g=S[w],g.index!==y);++w);o(u[e][p])||(u[e][p]={dirty:!1,valid:!0,value:r[p].value,indices:[]});var b,A=g.values.length/g.componentsPerAttribute,x=n(l[p],0);A>x+v?(b=v,u[e][p].indices.push({attribute:g,offset:x,count:b}),l[p]=x+v):(b=A-x,u[e][p].indices.push({attribute:g,offset:x,count:b}),l[p]=0,f[p]=E+1),v-=b}}function x(e,t,r,n,i){var a,s,u,c=[],l=e.length,f={},m={};for(a=0;l>a;++a)s=e[a],u=s.attributes,o(s.geometry)&&A(a,s.geometry,u,i,n,r,c,f,m);for(a=0;l>a;++a)s=e[a],u=s.attributes,o(s.westHemisphereGeometry)&&A(a,s.westHemisphereGeometry,u,i,n,r,c,f,m);for(a=0;l>a;++a)s=e[a],u=s.attributes,o(s.eastHemisphereGeometry)&&A(a,s.eastHemisphereGeometry,u,i,n,r,c,f,m);for(l=t.length,a=0;l>a;++a){s=t[a],u=s.attributes;var h={};c.push(h);for(var d=i.length,p=0;d>p;++p){var y=i[p];h[y]={dirty:!1,valid:!1,value:u[y].value,indices:[]}}}return c}function T(e,t){var r=e.attributes;for(var n in r)if(r.hasOwnProperty(n)){var i=r[n];o(i)&&o(i.values)&&t.push(i.values.buffer)}o(e.indices)&&t.push(e.indices.buffer)}function M(e,t){for(var r=e.length,n=0;r>n;++n)T(e[n],t)}function I(e,t){for(var r=e.length,n=0;r>n;++n)for(var o=e[n],i=o.length,a=0;i>a;++a)t.push(o[a].values.buffer)}function O(t){for(var r=1,n=t.length,i=0;n>i;i++){var a=t[i];if(++r,o(a)){var s=a.attributes;r+=6+2*e.packedLength+(o(a.indices)?a.indices.length:0);for(var u in s)if(s.hasOwnProperty(u)&&o(s[u])){var c=s[u];r+=5+c.values.length}}}return r}function R(e,t){for(var r=e.length,n=new Uint32Array(e.length),o=0;r>o;++o)n[o]=e[o].toRgba();return t.push(n.buffer),n}function N(e){for(var r=e.length,n=new Array(r),o=0;r>o;o++)n[o]=t.fromRgba(e[o]);return n}function L(e){for(var t=e.length,r=1+17*t,n=0;t>n;n++){var i=e[n].attributes;for(var a in i)if(i.hasOwnProperty(a)&&o(i[a])){var s=i[a];r+=5+s.value.length}}return r}function P(e,t){var r=new Float64Array(L(e)),n={},i=[],a=e.length,s=0;r[s++]=a;for(var u=0;a>u;u++){var c=e[u];d.pack(c.modelMatrix,r,s),s+=d.packedLength;var l=c.attributes,f=[];for(var m in l)l.hasOwnProperty(m)&&o(l[m])&&(f.push(m),o(n[m])||(n[m]=i.length,i.push(m)));r[s++]=f.length;for(var h=0;h<f.length;h++){var p=f[h],y=l[p];r[s++]=n[p],r[s++]=y.componentDatatype,r[s++]=y.componentsPerAttribute,r[s++]=y.normalize,r[s++]=y.value.length,r.set(y.value,s),s+=y.value.length}}return t.push(r.buffer),{stringTable:i,packedData:r}}function z(e){for(var t=e.packedData,n=e.stringTable,o=new Array(t[0]),i=0,a=1;a<t.length;){var s=d.unpack(t,a);a+=d.packedLength;for(var u={},c=t[a++],l=0;c>l;l++){for(var f=n[t[a++]],m=t[a++],h=t[a++],p=0!==t[a++],y=t[a++],v=r.createTypedArray(m,y),g=0;y>g;g++)v[g]=t[a++];u[f]={componentDatatype:m,componentsPerAttribute:h,normalize:p,value:v}}o[i++]={attributes:u,modelMatrix:s}}return o}function D(t){for(var r=t.length,n=1+r,i=0;r>i;i++){var a=t[i];n+=2,n+=o(a.boundingSphere)?e.packedLength:0,n+=o(a.boundingSphereCV)?e.packedLength:0;for(var s in a)if(a.hasOwnProperty(s)&&o(a[s])&&"boundingSphere"!==s&&"boundingSphereCV"!==s){var u=a[s];n+=4+3*u.indices.length+u.value.length}}return n}function F(t,r){var n=new Float64Array(D(t)),i=[],a=[],s={},u=t.length,c=0;n[c++]=u;for(var l=0;u>l;l++){var f=t[l],m=f.boundingSphere,h=o(m);n[c++]=h?1:0,h&&(e.pack(m,n,c),c+=e.packedLength),m=f.boundingSphereCV,h=o(m),n[c++]=h?1:0,h&&(e.pack(m,n,c),c+=e.packedLength);var d=[];for(var p in f)f.hasOwnProperty(p)&&o(f[p])&&"boundingSphere"!==p&&"boundingSphereCV"!==p&&(d.push(p),o(s[p])||(s[p]=i.length,i.push(p)));n[c++]=d.length;for(var y=0;y<d.length;y++){var v=d[y],g=f[v];n[c++]=s[v],n[c++]=g.valid?1:0;var E=g.indices,S=E.length;n[c++]=S;for(var C=0;S>C;C++){var w=E[C];n[c++]=w.count,n[c++]=w.offset;var b=a.indexOf(w.attribute);-1===b&&(b=a.length,a.push(w.attribute)),n[c++]=b}n[c++]=g.value.length,n.set(g.value,c),c+=g.value.length}}return r.push(n.buffer),{stringTable:i,packedData:n,attributeTable:a}}function _(t){for(var n=t.stringTable,o=t.attributeTable,i=t.packedData,a=new Array(i[0]),s=0,u=1,c=i.length;c>u;){var l={},f=1===i[u++];f&&(l.boundingSphere=e.unpack(i,u),u+=e.packedLength),f=1===i[u++],f&&(l.boundingSphereCV=e.unpack(i,u),u+=e.packedLength);for(var m=i[u++],h=0;m>h;h++){for(var d=n[i[u++]],p=1===i[u++],y=i[u++],v=y>0?new Array(y):void 0,g=0;y>g;g++){var E={};E.count=i[u++],E.offset=i[u++],E.attribute=o[i[u++]],v[g]=E}for(var S=i[u++],C=p?r.createTypedArray(v[0].attribute.componentDatatype,S):new Array(S),w=0;S>w;w++)C[w]=i[u++];l[d]={dirty:!1,valid:p,indices:v,value:C}}a[s++]=l}return a}if(!s.supportsTypedArrays())return{};var B={};return B.combineGeometry=function(e){var t,r,n,i,a,s=e.instances,u=e.invalidInstances;if(s.length>0){t=w(e),r=m.createAttributeLocations(t[0]),i=E(s),n=[],a=t.length;for(var c=0;a>c;++c){var l=t[c];n.push(b(l,r,i))}}i=o(i)?i:E(u);var f=x(s,u,n,r,i);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,vaAttributes:n,vaAttributeLocations:f,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.packCreateGeometryResults=function(t,r){var n=new Float64Array(O(t)),i=[],a={},s=t.length,u=0;n[u++]=s;for(var c=0;s>c;c++){var l=t[c],f=o(l);if(n[u++]=f?1:0,f){n[u++]=l.primitiveType,n[u++]=l.geometryType;var m=o(l.boundingSphere)?1:0;n[u++]=m,m&&e.pack(l.boundingSphere,n,u),u+=e.packedLength;var h=o(l.boundingSphereCV)?1:0;n[u++]=h,h&&e.pack(l.boundingSphereCV,n,u),u+=e.packedLength;var d=l.attributes,p=[];for(var y in d)d.hasOwnProperty(y)&&o(d[y])&&(p.push(y),o(a[y])||(a[y]=i.length,i.push(y)));n[u++]=p.length;for(var v=0;v<p.length;v++){var g=p[v],E=d[g];n[u++]=a[g],n[u++]=E.componentDatatype,n[u++]=E.componentsPerAttribute,n[u++]=E.normalize?1:0,n[u++]=E.values.length,n.set(E.values,u),u+=E.values.length}var S=o(l.indices)?l.indices.length:0;n[u++]=S,S>0&&(n.set(l.indices,u),u+=S)}}return r.push(n.buffer),{stringTable:i,packedData:n}},B.unpackCreateGeometryResults=function(t){for(var n,o=t.stringTable,i=t.packedData,a=new Array(i[0]),s=0,u=1;u<i.length;){var m=1===i[u++];if(m){var d,p,y=i[u++],v=i[u++],g=1===i[u++];g&&(d=e.unpack(i,u)),u+=e.packedLength;var E=1===i[u++];E&&(p=e.unpack(i,u)),u+=e.packedLength;var S,C,w,b=new f,A=i[u++];for(n=0;A>n;n++){var x=o[i[u++]],T=i[u++];w=i[u++];var M=0!==i[u++];S=i[u++],C=r.createTypedArray(T,S);for(var I=0;S>I;I++)C[I]=i[u++];b[x]=new l({componentDatatype:T,componentsPerAttribute:w,normalize:M,values:C})}var O;if(S=i[u++],S>0){var R=C.length/w;for(O=h.createTypedArray(R,S),n=0;S>n;n++)O[n]=i[u++]}a[s++]=new c({primitiveType:y,geometryType:v,boundingSphere:d,indices:O,attributes:b})}else a[s++]=void 0}return a},B.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,o=0;n>o;o++)t.push(r[o].packedData.buffer);var i;return e.allowPicking&&(i=R(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:P(e.instances,t),packedPickIds:i,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof u,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},B.unpackCombineGeometryParameters=function(e){for(var t=z(e.packedInstances),r=e.allowPicking,n=r?N(e.packedPickIds):void 0,i=e.createGeometryResults,s=i.length,c=0,l=[],f=[],m=[],h=[],y=[],v=0;s>v;v++)for(var g=B.unpackCreateGeometryResults(i[v]),E=g.length,S=0;E>S;S++){var C=g[S],w=t[c];o(C)?(w.geometry=C,l.push(w),m.push(c),r&&y.push(n[c])):(f.push(w),h.push(c)),++c}var b=a.clone(e.ellipsoid),A=e.isGeographic?new u(b):new p(b);return{instances:l,invalidInstances:f,validInstancesIndices:m,invalidInstancesIndices:h,pickIds:y,ellipsoid:b,projection:A,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:d.clone(e.modelMatrix)}},B.packCombineGeometryResults=function(e,t){return o(e.geometries)&&(M(e.geometries,t),I(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:F(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:_(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},B}),define("Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r};return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";var n=function(n){var o,i=[],a={id:void 0,result:void 0,error:void 0};return function(s){var u=s.data;i.length=0,a.id=u.id,a.error=void 0,a.result=void 0;try{a.result=n(u.parameters,i)}catch(c){a.error=c instanceof Error?{name:c.name,message:c.message,stack:c.stack}:c}t(o)||(o=e(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(i.length=0);try{o(a,i)}catch(c){a.result=void 0,a.error="postMessage failed with error: "+r(c)+"\n  with responseMessage: "+JSON.stringify(a),o(a)}}};return n}),define("Workers/combineGeometry",["../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t){"use strict";function r(t,r){var n=e.unpackCombineGeometryParameters(t),o=e.combineGeometry(n);return e.packCombineGeometryResults(o,r)}return t(r)})}();