/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return 2*(n.clamp(e,0,255)/255)-1},n.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},n.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},n.lerp=function(e,t,n){return(1-n)*e+n*t},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){var t=n.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},n.negativePiToPi=function(e){return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){var t=n.mod(e,n.TWO_PI);return Math.abs(t)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:t},n.mod=function(e,t){return(e%t+t)%t},n.equalsEpsilon=function(e,n,r,i){i=t(i,r);var a=Math.abs(e-n);return i>=a||a<=r*Math.max(Math.abs(e),Math.abs(n))};var r=[1];n.factorial=function(e){var t=r.length;if(e>=t)for(var n=r[t-1],i=t;e>=i;i++)r.push(n*i);return r[e]},n.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},n.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,t,n){return t>e?t:e>n?n:e};var i=new e;return n.setRandomNumberSeed=function(t){i=new e(t)},n.nextRandomNumber=function(){return i.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0)};a.fromSpherical=function(n,r){t(r)||(r=new a);var i=n.clock,o=n.cone,u=e(n.magnitude,1),s=u*Math.sin(o);return r.x=s*Math.cos(i),r.y=s*Math.sin(i),r.z=u*Math.cos(o),r},a.fromElements=function(e,n,r,i){return t(i)?(i.x=e,i.y=n,i.z=r,i):new a(e,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r]=t.z},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var s=new a,c=new a;a.angleBetween=function(e,t){a.normalize(e,s),a.normalize(t,c);var n=a.dot(s,c),r=a.magnitude(a.cross(s,c,s));return Math.atan2(r,n)};var l=new a;a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,l);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Z,t):n.y<=n.z?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_Z,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)},a.cross=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=t.x,u=t.y,s=t.z,c=i*s-a*u,l=a*o-r*s,h=r*u-i*o;return n.x=c,n.y=l,n.z=h,n},a.fromDegrees=function(e,t,n,r,o){var u=i.toRadians(e),s=i.toRadians(t);return a.fromRadians(u,s,n,r,o)};var h=new a,f=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,r,i,o,u){i=e(i,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(r);h.x=c*Math.cos(n),h.y=c*Math.sin(n),h.z=Math.sin(r),h=a.normalize(h,h),a.multiplyComponents(s,h,f);var l=Math.sqrt(a.dot(h,f));return f=a.divideByScalar(f,l,f),h=a.multiplyByScalar(h,i,h),t(u)||(u=new a),a.add(f,h,u)},a.fromDegreesArray=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o++)r[o]=i.toRadians(e[o]);return a.fromRadiansArray(r,t,n)},a.fromRadiansArray=function(e,n,r){var i=e.length;t(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=e[o],s=e[o+1];r[o/2]=a.fromRadians(u,s,0,n,r[o/2])}return r},a.fromDegreesArrayHeights=function(e,t,n){for(var r=new Array(e.length),o=0;o<e.length;o+=3)r[o]=i.toRadians(e[o]),r[o+1]=i.toRadians(e[o+1]),r[o+2]=e[o+2];return a.fromRadiansArrayHeights(r,t,n)},a.fromRadiansArrayHeights=function(e,n,r){var i=e.length;t(r)?r.length=i/3:r=new Array(i/3);for(var o=0;i>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];r[o/3]=a.fromRadians(u,s,c,n,r[o/3])}return r},a.ZERO=r(new a(0,0,0)),a.UNIT_X=r(new a(1,0,0)),a.UNIT_Y=r(new a(0,1,0)),a.UNIT_Z=r(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r){this.longitude=e(t,0),this.latitude=e(n,0),this.height=e(r,0)};return a.fromRadians=function(n,r,i,o){return i=e(i,0),t(o)?(o.longitude=n,o.latitude=r,o.height=i,o):new a(n,r,i)},a.fromDegrees=function(e,t,n,r){return e=i.toRadians(e),t=i.toRadians(t),a.fromRadians(e,t,n,r)},a.clone=function(e,n){return t(e)?t(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height},a.equalsEpsilon=function(e,n,r){return e===n||t(e)&&t(n)&&Math.abs(e.longitude-n.longitude)<=r&&Math.abs(e.latitude-n.latitude)<=r&&Math.abs(e.height-n.height)<=r},a.ZERO=r(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";function s(t,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),t._radii=new e(r,i,a),t._radiiSquared=new e(r*r,i*i,a*a),t._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,i,a),t._maximumRadius=Math.max(r,i,a),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,n)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,n){if(!r(t))return void 0;var i=t._radii;return r(n)?(e.clone(i,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new c(i.x,i.y,i.z)},c.fromCartesian3=function(e,t){return r(t)||(t=new c),r(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,r,i){i=n(i,0),e.pack(t._radii,r,i)},c.unpack=function(t,r,i){r=n(r,0);var a=e.unpack(t,r);return c.fromCartesian3(a,i)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,n){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},c.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var l=new e,h=new e;c.prototype.cartographicToCartesian=function(t,n){var i=l,a=h;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),r(n)||(n=new e),e.add(a,i,n)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var f=new e,d=new e,m=new e;c.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,d);if(!r(a))return void 0;var o=this.geodeticSurfaceNormal(a,f),s=e.subtract(n,a,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),h=u.sign(e.dot(s,n))*e.magnitude(s);return r(i)?(i.longitude=c,i.latitude=l,i.height=h,i):new t(c,l,h)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t};var y=new e,p=new e;return c.prototype.scaleToGeodeticSurface=function(t,n){var i=t.x,a=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,h=s.z,f=i*i*c*c,d=a*a*l*l,m=o*o*h*h,v=f+d+m,w=Math.sqrt(1/v),g=e.multiplyByScalar(t,w,y);if(v<this._centerToleranceSquared)return isFinite(w)?e.clone(g,n):void 0;var x=this._oneOverRadiiSquared,E=x.x,M=x.y,S=x.z,z=p;z.x=2*g.x*E,z.y=2*g.y*M,z.z=2*g.z*S;var _,O,T,I,N,R,A,b,P,L,C,q=(1-w)*e.magnitude(t)/(.5*e.magnitude(z)),U=0;do{q-=U,T=1/(1+q*E),I=1/(1+q*M),N=1/(1+q*S),R=T*T,A=I*I,b=N*N,P=R*T,L=A*I,C=b*N,_=f*R+d*A+m*b-1,O=f*P*E+d*L*M+m*C*S;var B=-2*O;U=_/B}while(Math.abs(_)>u.EPSILON12);return r(n)?(n.x=i*T,n.y=a*I,n.z=o*N,n):new e(i*T,a*I,o*N)},c.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},c.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},c.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,i,a,o){"use strict";var u=function(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new e(a,o,u)},u.prototype.unproject=function(e,n){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,n){this.start=e(t,0),this.stop=e(n,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i){"use strict";var a=function(t,n,r,i){this.x=e(t,0),this.y=e(n,0),this.z=e(r,0),this.w=e(i,0)};a.fromElements=function(e,n,r,i,o){return t(o)?(o.x=e,o.y=n,o.z=r,o.w=i,o):new a(e,n,r,i)},a.fromColor=function(e,n){return t(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,n){return t(e)?t(n)?(n.x=e.x,n.y=e.y,n.z=e.z,n.w=e.w,n):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(t,n,r){r=e(r,0),n[r++]=t.x,n[r++]=t.y,n[r++]=t.z,n[r]=t.w},a.unpack=function(n,r,i){return r=e(r,0),t(i)||(i=new a),i.x=n[r++],i.y=n[r++],i.z=n[r++],i.w=n[r],i},a.fromArray=a.unpack,a.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},a.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},a.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,t){return a.subtract(e,t,o),a.magnitude(o)},a.distanceSquared=function(e,t){return a.subtract(e,t,o),a.magnitudeSquared(o)},a.normalize=function(e,t){var n=a.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},a.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},a.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},a.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},a.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},a.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},a.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},a.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},a.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new a;a.lerp=function(e,t,n,r){return a.multiplyByScalar(t,n,u),r=a.multiplyByScalar(e,1-n,r),a.add(u,r,r)};var s=new a;return a.mostOrthogonalAxis=function(e,t){var n=a.normalize(e,s);return a.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,t):a.clone(a.UNIT_W,t):n.z<=n.w?a.clone(a.UNIT_Z,t):a.clone(a.UNIT_W,t)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.x===n.x&&e.y===n.y&&e.z===n.z&&e.w===n.w},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},a.equalsEpsilon=function(e,n,r,a){return e===n||t(e)&&t(n)&&i.equalsEpsilon(e.x,n.x,r,a)&&i.equalsEpsilon(e.y,n.y,r,a)&&i.equalsEpsilon(e.z,n.z,r,a)&&i.equalsEpsilon(e.w,n.w,r,a)},a.ZERO=r(new a(0,0,0,0)),a.UNIT_X=r(new a(1,0,0,0)),a.UNIT_Y=r(new a(0,1,0,0)),a.UNIT_Z=r(new a(0,0,1,0)),a.UNIT_W=r(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e){for(var t=0,n=0;9>n;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function u(e){for(var t=0,n=0;3>n;++n){var r=e[c.getElementIndex(d[n],f[n])];t+=2*r*r}return Math.sqrt(t)}function s(e,t){for(var n=a.EPSILON15,r=0,i=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(d[o],f[o])]);u>r&&(i=o,r=u)}var s=1,l=0,h=f[i],m=d[i];if(Math.abs(e[c.getElementIndex(m,h)])>n){var y,p=e[c.getElementIndex(m,m)],v=e[c.getElementIndex(h,h)],w=e[c.getElementIndex(m,h)],g=(p-v)/2/w;y=0>g?-1/(-g+Math.sqrt(1+g*g)):1/(g+Math.sqrt(1+g*g)),s=1/Math.sqrt(1+y*y),l=y*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(h,h)]=t[c.getElementIndex(m,m)]=s,t[c.getElementIndex(m,h)]=l,t[c.getElementIndex(h,m)]=-l,t}var c=function(e,n,r,i,a,o,u,s,c){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(u,0),this[3]=t(n,0),this[4]=t(a,0),this[5]=t(s,0),this[6]=t(r,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,n,r){r=t(r,0),n[r++]=e[0],n[r++]=e[1],n[r++]=e[2],n[r++]=e[3],n[r++]=e[4],n[r++]=e[5],n[r++]=e[6],n[r++]=e[7],n[r++]=e[8]},c.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new c),i[0]=e[r++],i[1]=e[r++],i[2]=e[r++],i[3]=e[r++],i[4]=e[r++],i[5]=e[r++],i[6]=e[r++],i[7]=e[r++],i[8]=e[r++],i},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,r,i){return r=t(r,0),n(i)||(i=new c),i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],i[8]=e[r+8],i},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var r=e.x*e.x,i=e.x*e.y,a=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,h=e.z*e.z,f=e.z*e.w,d=e.w*e.w,m=r-u-h+d,y=2*(i-f),p=2*(a+l),v=2*(i+f),w=-r+u-h+d,g=2*(s-o),x=2*(a-l),E=2*(s+o),M=-r-u+h+d;return n(t)?(t[0]=m,t[1]=v,t[2]=x,t[3]=y,t[4]=w,t[5]=E,t[6]=p,t[7]=g,t[8]=M,t):new c(m,y,p,v,w,g,x,E,M)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=i,t[6]=0,t[7]=-i,t[8]=r,t):new c(1,0,0,0,r,-i,0,i,r)},c.fromRotationY=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=r,t):new c(r,0,i,0,1,0,-i,0,r)},c.fromRotationZ=function(e,t){var r=Math.cos(e),i=Math.sin(e);return n(t)?(t[0]=r,t[1]=i,t[2]=0,t[3]=-i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(r,-i,0,i,r,0,0,0,1)},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,n){var r=3*t,i=e[r],a=e[r+1],o=e[r+2];return n.x=i,n.y=a,n.z=o,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var i=3*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},c.getRow=function(e,t,n){var r=e[t],i=e[t+3],a=e[t+6];return n.x=r,n.y=i,n.z=a,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var l=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),n};var h=new e;c.getMaximumScale=function(t){return c.getScale(t,h),e.maximumComponent(h)},c.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=h,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},c.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[3]*i+e[6]*a,u=e[1]*r+e[4]*i+e[7]*a,s=e[2]*r+e[5]*i+e[8]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var n=e[0],r=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var f=[1,0,0],d=[2,2,1],m=new c,y=new c;return c.computeEigenDecomposition=function(e,t){var r=a.EPSILON20,i=10,l=0,h=0;n(t)||(t={});for(var f=t.unitary=c.clone(c.IDENTITY,t.unitary),d=t.diagonal=c.clone(e,t.diagonal),p=r*o(d);i>h&&u(d)>p;)s(d,m),c.transpose(m,y),c.multiply(d,m,d),c.multiply(y,d,d),c.multiply(f,m,f),++l>2&&(++h,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],n=e[3],r=e[6],i=e[1],a=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(a*c-s*o)+i*(s*r-n*c)+u*(n*o-a*r)},c.inverse=function(e,t){var n=e[0],i=e[1],o=e[2],u=e[3],s=e[4],l=e[5],h=e[6],f=e[7],d=e[8],m=c.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new r("matrix is not invertible");t[0]=s*d-f*l,t[1]=f*o-i*d,t[2]=i*l-s*o,t[3]=h*l-u*d,t[4]=n*d-h*o,t[5]=u*o-n*l,t[6]=u*f-h*s,t[7]=h*i-n*f,t[8]=n*s-u*i;var y=1/m;return c.multiplyByScalar(t,y,t)},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},c.IDENTITY=i(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,i,a,o,u,s){"use strict";var c=function(e,t,r,i,a,o,u,s,c,l,h,f,d,m,y,p){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(m,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(h,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(p,0)};c.packedLength=16,c.pack=function(e,t,r){r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15]},c.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new c),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,i,a){return i=n(i,e.ZERO),r(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new c(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,n,i){r(i)||(i=new c);var a=n.x,o=n.y,u=n.z,s=t.x*t.x,l=t.x*t.y,h=t.x*t.z,f=t.x*t.w,d=t.y*t.y,m=t.y*t.z,y=t.y*t.w,p=t.z*t.z,v=t.z*t.w,w=t.w*t.w,g=s-d-p+w,x=2*(l-v),E=2*(h+y),M=2*(l+v),S=-s+d-p+w,z=2*(m-f),_=2*(h-y),O=2*(m+f),T=-s-d+p+w;return i[0]=g*a,i[1]=M*a,i[2]=_*a,i[3]=0,i[4]=x*o,i[5]=S*o,i[6]=O*o,i[7]=0,i[8]=E*u,i[9]=z*u,i[10]=T*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,h=new e,f=new e;c.fromCamera=function(t,n){var i=t.eye,a=t.target,o=t.up;e.normalize(e.subtract(a,i,l),l),e.normalize(e.cross(l,o,h),h),e.normalize(e.cross(h,l,f),f);var u=h.x,s=h.y,d=h.z,m=l.x,y=l.y,p=l.z,v=f.x,w=f.y,g=f.z,x=i.x,E=i.y,M=i.z,S=u*-x+s*-E+d*-M,z=v*-x+w*-E+g*-M,_=m*x+y*E+p*M;return r(n)?(n[0]=u,n[1]=v,n[2]=-m,n[3]=0,n[4]=s,n[5]=w,n[6]=-y,n[7]=0,n[8]=d,n[9]=g,n[10]=-p,n[11]=0,n[12]=S,n[13]=z,n[14]=_,n[15]=1,n):new c(u,s,d,S,v,w,g,z,-m,-y,-p,_,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,n,r,i){var a=Math.tan(.5*e),o=1/a,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},c.computeOrthographicOffCenter=function(e,t,n,r,i,a,o){var u=1/(t-e),s=1/(r-n),c=1/(a-i),l=-(t+e)*u,h=-(r+n)*s,f=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=h,o[14]=f,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,n,r,i,a,o){var u=2*i/(t-e),s=2*i/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),h=-(a+i)/(a-i),f=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=h,o[11]=f,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,n,r,i,a){var o=2*i/(t-e),u=2*i/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,h=-1,f=-2*i;
return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=l,a[11]=h,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},c.computeViewportTransformation=function(e,t,r,i){e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,h=.5*(r-t),f=c,d=l,m=h,y=a+c,p=o+l,v=t+h,w=1;return i[0]=f,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=m,i[11]=0,i[12]=y,i[13]=p,i[14]=v,i[15]=w,i},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,n){var r=4*t,i=e[r],a=e[r+1],o=e[r+2],u=e[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},c.setColumn=function(e,t,n,r){r=c.clone(e,r);var i=4*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},c.getRow=function(e,t,n){var r=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},c.setRow=function(e,t,n,r){return r=c.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var d=new e;c.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),n};var m=new e;c.getMaximumScale=function(t){return c.getScale(t,m),e.maximumComponent(m)},c.multiply=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],h=e[8],f=e[9],d=e[10],m=e[11],y=e[12],p=e[13],v=e[14],w=e[15],g=t[0],x=t[1],E=t[2],M=t[3],S=t[4],z=t[5],_=t[6],O=t[7],T=t[8],I=t[9],N=t[10],R=t[11],A=t[12],b=t[13],P=t[14],L=t[15],C=r*g+u*x+h*E+y*M,q=i*g+s*x+f*E+p*M,U=a*g+c*x+d*E+v*M,B=o*g+l*x+m*E+w*M,D=r*S+u*z+h*_+y*O,W=i*S+s*z+f*_+p*O,F=a*S+c*z+d*_+v*O,k=o*S+l*z+m*_+w*O,V=r*T+u*I+h*N+y*R,G=i*T+s*I+f*N+p*R,j=a*T+c*I+d*N+v*R,Y=o*T+l*I+m*N+w*R,H=r*A+u*b+h*P+y*L,Z=i*A+s*b+f*P+p*L,X=a*A+c*b+d*P+v*L,K=o*A+l*b+m*P+w*L;return n[0]=C,n[1]=q,n[2]=U,n[3]=B,n[4]=D,n[5]=W,n[6]=F,n[7]=k,n[8]=V,n[9]=G,n[10]=j,n[11]=Y,n[12]=H,n[13]=Z,n[14]=X,n[15]=K,n},c.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},c.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},c.multiplyTransformation=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],h=e[10],f=e[12],d=e[13],m=e[14],y=t[0],p=t[1],v=t[2],w=t[4],g=t[5],x=t[6],E=t[8],M=t[9],S=t[10],z=t[12],_=t[13],O=t[14],T=r*y+o*p+c*v,I=i*y+u*p+l*v,N=a*y+s*p+h*v,R=r*w+o*g+c*x,A=i*w+u*g+l*x,b=a*w+s*g+h*x,P=r*E+o*M+c*S,L=i*E+u*M+l*S,C=a*E+s*M+h*S,q=r*z+o*_+c*O+f,U=i*z+u*_+l*O+d,B=a*z+s*_+h*O+m;return n[0]=T,n[1]=I,n[2]=N,n[3]=0,n[4]=R,n[5]=A,n[6]=b,n[7]=0,n[8]=P,n[9]=L,n[10]=C,n[11]=0,n[12]=q,n[13]=U,n[14]=B,n[15]=1,n},c.multiplyByMatrix3=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],h=e[10],f=t[0],d=t[1],m=t[2],y=t[3],p=t[4],v=t[5],w=t[6],g=t[7],x=t[8],E=r*f+o*d+c*m,M=i*f+u*d+l*m,S=a*f+s*d+h*m,z=r*y+o*p+c*v,_=i*y+u*p+l*v,O=a*y+s*p+h*v,T=r*w+o*g+c*x,I=i*w+u*g+l*x,N=a*w+s*g+h*x;return n[0]=E,n[1]=M,n[2]=S,n[3]=0,n[4]=z,n[5]=_,n[6]=O,n[7]=0,n[8]=T,n[9]=I,n[10]=N,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},c.multiplyByTranslation=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=r*e[0]+i*e[4]+a*e[8]+e[12],u=r*e[1]+i*e[5]+a*e[9]+e[13],s=r*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var y=new e;c.multiplyByUniformScale=function(e,t,n){return y.x=t,y.y=t,y.z=t,c.multiplyByScale(e,y,n)},c.multiplyByScale=function(e,t,n){var r=t.x,i=t.y,a=t.z;return 1===r&&1===i&&1===a?c.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},c.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*r+e[4]*i+e[8]*a+e[12]*o,s=e[1]*r+e[5]*i+e[9]*a+e[13]*o,c=e[2]*r+e[6]*i+e[10]*a+e[14]*o,l=e[3]*r+e[7]*i+e[11]*a+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},c.multiplyByPointAsVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a,u=e[1]*r+e[5]*i+e[9]*a,s=e[2]*r+e[6]*i+e[10]*a;return n.x=o,n.y=u,n.z=s,n},c.multiplyByPoint=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a+e[12],u=e[1]*r+e[5]*i+e[9]*a+e[13],s=e[2]*r+e[6]*i+e[10]*a+e[14];return n.x=o,n.y=u,n.z=s,n},c.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var n=e[1],r=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new u,v=new u,w=new t,g=new t(0,0,0,1);return c.inverse=function(e,n){if(u.equalsEpsilon(c.getRotation(e,p),v,o.EPSILON7)&&t.equals(c.getRow(e,3,w),g))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],i=e[4],a=e[8],l=e[12],h=e[1],f=e[5],d=e[9],m=e[13],y=e[2],x=e[6],E=e[10],M=e[14],S=e[3],z=e[7],_=e[11],O=e[15],T=E*O,I=M*_,N=x*O,R=M*z,A=x*_,b=E*z,P=y*O,L=M*S,C=y*_,q=E*S,U=y*z,B=x*S,D=T*f+R*d+A*m-(I*f+N*d+b*m),W=I*h+P*d+q*m-(T*h+L*d+C*m),F=N*h+L*f+U*m-(R*h+P*f+B*m),k=b*h+C*f+B*d-(A*h+q*f+U*d),V=I*i+N*a+b*l-(T*i+R*a+A*l),G=T*r+L*a+C*l-(I*r+P*a+q*l),j=R*r+P*i+B*l-(N*r+L*i+U*l),Y=A*r+q*i+U*a-(b*r+C*i+B*a);T=a*m,I=l*d,N=i*m,R=l*f,A=i*d,b=a*f,P=r*m,L=l*h,C=r*d,q=a*h,U=r*f,B=i*h;var H=T*z+R*_+A*O-(I*z+N*_+b*O),Z=I*S+P*_+q*O-(T*S+L*_+C*O),X=N*S+L*z+U*O-(R*S+P*z+B*O),K=b*S+C*z+B*_-(A*S+q*z+U*_),J=N*E+b*M+I*x-(A*M+T*x+R*E),Q=C*M+T*y+L*E-(P*E+q*M+I*y),$=P*x+B*M+R*y-(U*M+N*y+L*x),et=U*E+A*y+q*x-(C*x+B*E+b*y),tt=r*D+i*W+a*F+l*k;if(Math.abs(tt)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return tt=1/tt,n[0]=D*tt,n[1]=W*tt,n[2]=F*tt,n[3]=k*tt,n[4]=V*tt,n[5]=G*tt,n[6]=j*tt,n[7]=Y*tt,n[8]=H*tt,n[9]=Z*tt,n[10]=X*tt,n[11]=K*tt,n[12]=J*tt,n[13]=Q*tt,n[14]=$*tt,n[15]=et*tt,n},c.inverseTransformation=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],h=e[12],f=e[13],d=e[14],m=-n*h-r*f-i*d,y=-a*h-o*f-u*d,p=-s*h-c*f-l*d;return t[0]=n,t[1]=a,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=m,t[13]=y,t[14]=p,t[15]=1,t},c.IDENTITY=a(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";var s=function(e,n,r,i){this.west=t(e,0),this.south=t(n,0),this.east=t(r,0),this.north=t(i,0)};r(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i.west=e[r++],i.south=e[r++],i.east=e[r++],i.north=e[r],i},s.computeWidth=function(e){var t=e.east,n=e.west;return n>t&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,r,i,a,o){return e=u.toRadians(t(e,0)),r=u.toRadians(t(r,0)),i=u.toRadians(t(i,0)),a=u.toRadians(t(a,0)),n(o)?(o.west=e,o.south=r,o.east=i,o.north=a,o):new s(e,r,i,a)},s.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];r=Math.min(r,l.longitude),i=Math.max(i,l.longitude),a=Math.min(a,l.latitude),o=Math.max(o,l.latitude)}return n(t)?(t.west=r,t.south=a,t.east=i,t.north=o,t):new s(r,a,i,o)},s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.west,n[r++]=e.south,n[r++]=e.east,n[r]=e.north},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i.west=e[r++],i.south=e[r++],i.east=e[r++],i.north=e[r],i},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(){},s.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},s.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},s.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},s.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},s.center=function(t,r){var i=t.east,a=t.west;a>i&&(i+=u.TWO_PI);var o=u.negativePiToPi(.5*(a+i)),s=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=s,r.height=0,r):new e(o,s)},s.intersection=function(e,t,r){var i=e.east,a=e.west,o=t.east,c=t.west;a>i&&o>0?i+=u.TWO_PI:c>o&&i>0&&(o+=u.TWO_PI),a>i&&0>c?c+=u.TWO_PI:c>o&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,c)),h=u.negativePiToPi(Math.min(i,o));if((e.west<e.east||t.west<t.east)&&l>=h)return void 0;var f=Math.max(e.south,t.south),d=Math.min(e.north,t.north);return f>=d?void 0:n(r)?(r.west=l,r.south=f,r.east=h,r.north=d,r):new s(l,f,h,d)},s.contains=function(e,t){var n=t.longitude,r=t.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0),n(o)||(o=[]);var l=0,h=e.north,f=e.south,d=e.east,m=e.west,y=c;y.height=i,y.longitude=m,y.latitude=h,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=d,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.latitude=f,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=m,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.latitude=0>h?h:f>0?f:0;for(var p=1;8>p;++p)y.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,y)&&(o[l]=r.cartographicToCartesian(y,o[l]),l++);return 0===y.latitude&&(y.longitude=m,o[l]=r.cartographicToCartesian(y,o[l]),l++,y.longitude=d,o[l]=r.cartographicToCartesian(y,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,n,r,i,a,o,u,s,c,l){"use strict";var h=function(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)},f=new e,d=new e,m=new e,y=new e,p=new e,v=new e,w=new e,g=new e,x=new e,E=new e,M=new e,S=new e;h.fromPoints=function(t,n){if(r(n)||(n=new h),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var i=e.clone(t[0],w),a=e.clone(i,f),o=e.clone(i,d),u=e.clone(i,m),s=e.clone(i,y),c=e.clone(i,p),l=e.clone(i,v),z=t.length,_=1;z>_;_++){e.clone(t[_],i);var O=i.x,T=i.y,I=i.z;O<a.x&&e.clone(i,a),O>s.x&&e.clone(i,s),T<o.y&&e.clone(i,o),T>c.y&&e.clone(i,c),I<u.z&&e.clone(i,u),I>l.z&&e.clone(i,l)}var N=e.magnitudeSquared(e.subtract(s,a,g)),R=e.magnitudeSquared(e.subtract(c,o,g)),A=e.magnitudeSquared(e.subtract(l,u,g)),b=a,P=s,L=N;R>L&&(L=R,b=o,P=c),A>L&&(L=A,b=u,P=l);var C=x;C.x=.5*(b.x+P.x),C.y=.5*(b.y+P.y),C.z=.5*(b.z+P.z);var q=e.magnitudeSquared(e.subtract(P,C,g)),U=Math.sqrt(q),B=E;B.x=a.x,B.y=o.y,B.z=u.z;var D=M;D.x=s.x,D.y=c.y,D.z=l.z;var W=e.multiplyByScalar(e.add(B,D,g),.5,S),F=0;for(_=0;z>_;_++){e.clone(t[_],i);var k=e.magnitude(e.subtract(i,W,g));k>F&&(F=k);var V=e.magnitudeSquared(e.subtract(i,C,g));if(V>q){var G=Math.sqrt(V);U=.5*(U+G),q=U*U;var j=G-U;C.x=(U*C.x+j*i.x)/G,C.y=(U*C.y+j*i.y)/G,C.z=(U*C.z+j*i.z)/G}}return F>U?(e.clone(C,n.center),n.radius=U):(e.clone(W,n.center),n.radius=F),n};var z=new o,_=new e,O=new e,T=new t,I=new t;h.fromRectangle2D=function(e,t,n){return h.fromRectangleWithHeights2D(e,t,0,0,n)},h.fromRectangleWithHeights2D=function(t,i,a,o,u){if(r(u)||(u=new h),!r(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,z),l.southwest(t,T),T.height=a,l.northeast(t,I),I.height=o;var s=i.project(T,_),c=i.project(I,O),f=c.x-s.x,d=c.y-s.y,m=c.z-s.z;u.radius=.5*Math.sqrt(f*f+d*d+m*m);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*d,y.z=s.z+.5*m,u};var N=[];h.fromRectangle3D=function(e,t,i,o){t=n(t,a.WGS84),i=n(i,0);var u;return r(e)&&(u=l.subsample(e,t,i,N)),h.fromPoints(u,o)},h.fromVertices=function(t,i,a,o){if(r(o)||(o=new h),!r(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;i=n(i,e.ZERO),a=n(a,3);var u=w;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;for(var s=e.clone(u,f),c=e.clone(u,d),l=e.clone(u,m),z=e.clone(u,y),_=e.clone(u,p),O=e.clone(u,v),T=t.length,I=0;T>I;I+=a){var N=t[I]+i.x,R=t[I+1]+i.y,A=t[I+2]+i.z;u.x=N,u.y=R,u.z=A,N<s.x&&e.clone(u,s),N>z.x&&e.clone(u,z),R<c.y&&e.clone(u,c),R>_.y&&e.clone(u,_),A<l.z&&e.clone(u,l),A>O.z&&e.clone(u,O)}var b=e.magnitudeSquared(e.subtract(z,s,g)),P=e.magnitudeSquared(e.subtract(_,c,g)),L=e.magnitudeSquared(e.subtract(O,l,g)),C=s,q=z,U=b;P>U&&(U=P,C=c,q=_),L>U&&(U=L,C=l,q=O);var B=x;B.x=.5*(C.x+q.x),B.y=.5*(C.y+q.y),B.z=.5*(C.z+q.z);var D=e.magnitudeSquared(e.subtract(q,B,g)),W=Math.sqrt(D),F=E;F.x=s.x,F.y=c.y,F.z=l.z;var k=M;k.x=z.x,k.y=_.y,k.z=O.z;var V=e.multiplyByScalar(e.add(F,k,g),.5,S),G=0;for(I=0;T>I;I+=a){u.x=t[I]+i.x,u.y=t[I+1]+i.y,u.z=t[I+2]+i.z;var j=e.magnitude(e.subtract(u,V,g));j>G&&(G=j);var Y=e.magnitudeSquared(e.subtract(u,B,g));if(Y>D){var H=Math.sqrt(Y);W=.5*(W+H),D=W*W;var Z=H-W;B.x=(W*B.x+Z*u.x)/H,B.y=(W*B.y+Z*u.y)/H,B.z=(W*B.z+Z*u.z)/H}}return G>W?(e.clone(B,o.center),o.radius=W):(e.clone(V,o.center),o.radius=G),o},h.fromCornerPoints=function(t,n,i){r(i)||(i=new h);var a=i.center;return e.add(t,n,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,n),i},h.fromEllipsoid=function(t,n){return r(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var R=new e;h.fromBoundingSpheres=function(t,n){if(r(n)||(n=new h),!r(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=t.length;if(1===i)return h.clone(t[0],n);if(2===i)return h.union(t[0],t[1],n);for(var a=[],o=0;i>o;o++)a.push(t[o].center);n=h.fromPoints(a,n);var u=n.center,s=n.radius;for(o=0;i>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,R)+c.radius)}return n.radius=s,n},h.clone=function(t,n){return r(t)?r(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,r){r=n(r,0);var i=e.center;t[r++]=i.x,t[r++]=i.y,t[r++]=i.z,t[r]=e.radius},h.unpack=function(e,t,i){t=n(t,0),r(i)||(i=new h);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var A=new e,b=new e;h.union=function(t,n,i){r(i)||(i=new h);var a=t.center,o=n.center;e.add(a,o,b);var u=e.multiplyByScalar(b,.5,b),s=e.magnitude(e.subtract(a,u,A))+t.radius,c=e.magnitude(e.subtract(o,u,A))+n.radius;return i.radius=Math.max(s,c),e.clone(u,i.center),i};var P=new e;h.expand=function(t,n,r){r=h.clone(t,r);var i=e.magnitude(e.subtract(n,r.center,P));return i>r.radius&&(r.radius=i),r},h.intersect=function(t,n){var r=t.center,i=t.radius,a=e.dot(n,r)+n.w;return-i>a?u.OUTSIDE:i>a?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r(n)||(n=new h),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=c.getMaximumScale(t)*e.radius,n};var L=new e;h.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,L);return e.magnitudeSquared(r)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r(n)||(n=new h),n.center=c.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var C=new e;h.computePlaneDistances=function(t,n,i,a){r(a)||(a=new s);var o=e.subtract(t.center,n,C),u=e.multiplyByScalar(i,e.dot(i,o),C),c=e.magnitude(u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var q=new e,U=new e,B=new e,D=new e,W=new e,F=new t,k=new Array(8),V=0;8>V;++V)k[V]=new e;var G=new o;return h.projectTo2D=function(t,r,i){r=n(r,G);var a=r.ellipsoid,o=t.center,u=t.radius,s=a.geodeticSurfaceNormal(o,q),c=e.cross(e.UNIT_Z,s,U);e.normalize(c,c);var l=e.cross(s,c,B);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,W),d=e.negate(c,D),m=k,y=m[0];e.add(s,l,y),e.add(y,c,y),y=m[1],e.add(s,l,y),e.add(y,d,y),y=m[2],e.add(s,f,y),e.add(y,d,y),y=m[3],e.add(s,f,y),e.add(y,c,y),e.negate(s,s),y=m[4],e.add(s,l,y),e.add(y,c,y),y=m[5],e.add(s,l,y),e.add(y,d,y),y=m[6],e.add(s,f,y),e.add(y,d,y),y=m[7],e.add(s,f,y),e.add(y,c,y);for(var p=m.length,v=0;p>v;++v){var w=m[v];e.add(o,w,w);var g=a.cartesianToCartographic(w,F);r.project(g,w)}i=h.fromPoints(m,i),o=i.center;var x=o.x,E=o.y,M=o.z;return o.x=M,o.y=x,o.z=E,i},h.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},h.prototype.intersect=function(e){return h.intersect(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[r.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?r.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[r.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(r.requestFullscreen=i,n=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(r.requestFullscreen=i,n=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?r.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(r.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?r.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(r.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[r.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;r>n;++n)t[n]=parseInt(t[n],10);return t}function i(){if(!t(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,v=r(e[1]))}return p}function a(){return i()&&v}function o(){if(!t(w)&&(w=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(w=!0,g=r(e[1]))}return w}function u(){return o()&&g}function s(){if(!t(x)){x=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(x=!0,E=r(e[1]),E.isNightly=!!e[2])}return x}function c(){return s()&&E}function l(){if(!t(M)){M=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(M=!0,S=r(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(M=!0,S=r(e[1])))}return M}function h(){return l()&&S}function f(){if(!t(z)){z=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(z=!0,_=r(e[1]))}return z}function d(){return t(O)||(O=/Windows/i.test(navigator.appVersion)),O}function m(){return f()&&_}function y(){return t(T)||(T=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),T}var p,v,w,g,x,E,M,S,z,_,O,T,I={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:h,isFirefox:f,firefoxVersion:m,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:y};return I.supportsFullscreen=function(){return n.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,n,r,i){"use strict";if(!r.supportsTypedArrays())return{};var a={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return a.getSizeInBytes=function(e){switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,t){switch(e){case a.BYTE:return new Int8Array(t);case a.UNSIGNED_BYTE:return new Uint8Array(t);case a.SHORT:return new Int16Array(t);case a.UNSIGNED_SHORT:return new Uint16Array(t);case a.FLOAT:return new Float32Array(t);case a.DOUBLE:return new Float64Array(t);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(t,r,i,o){switch(i=e(i,0),o=e(o,(r.byteLength-i)/a.getSizeInBytes(t)),t){case a.BYTE:return new Int8Array(r,i,o);case a.UNSIGNED_BYTE:return new Uint8Array(r,i,o);case a.SHORT:return new Int16Array(r,i,o);case a.UNSIGNED_SHORT:return new Uint16Array(r,i,o);case a.FLOAT:return new Float32Array(r,i,o);case a.DOUBLE:return new Float64Array(r,i,o);default:throw new n("componentDatatype is not a valid value.")}},i(a)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,i,a,o,u){"use strict";var s=function(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)},c=new e;s.fromAxisAngle=function(t,r,i){var a=r/2,o=Math.sin(a);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,h=c.z*o,f=Math.cos(a);return n(i)?(i.x=u,i.y=l,i.z=h,i.w=f,i):new s(u,l,h,f)};var l=[1,2,0],h=new Array(3);s.fromRotationMatrix=function(e,t){var r,i,a,o,c,f=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=f+d+m;if(y>0)r=Math.sqrt(y+1),c=.5*r,r=.5/r,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*r,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*r,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*r;else{var p=l,v=0;d>f&&(v=1),m>f&&m>d&&(v=2);var w=p[v],g=p[w];r=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(w,w)]-e[u.getElementIndex(g,g)]+1);var x=h;x[v]=.5*r,r=.5/r,c=(e[u.getElementIndex(g,w)]-e[u.getElementIndex(w,g)])*r,x[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*r,x[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*r,i=-x[0],a=-x[1],o=-x[2]}return n(t)?(t.x=i,t.y=a,t.z=o,t.w=c,t):new s(i,a,o,c)};var f=new s;s.fromHeadingPitchRoll=function(t,n,r,i){var a=s.fromAxisAngle(e.UNIT_X,r,f),o=s.fromAxisAngle(e.UNIT_Y,-n,i);i=s.multiply(o,a,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,f);return s.multiply(u,i,i)};var d=new e,m=new e,y=new s,p=new s,v=new s;s.packedLength=4,s.pack=function(e,n,r){r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w},s.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new s),i.x=e[r],i.y=e[r+1],i.z=e[r+2],i.w=e[r+3],i},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,n,r){s.unpack(e,4*n,v),s.conjugate(v,v);for(var i=0,a=n-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),y),s.multiply(y,v,y),y.w<0&&s.negate(y,y),s.computeAxis(y,d);var u=s.computeAngle(y);r[o]=d.x*u,r[o+1]=d.y*u,r[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(r,4*a,p),0===u?s.clone(s.IDENTITY,y):s.fromAxisAngle(m,u,y),s.multiply(y,p,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var n=1/s.magnitude(e),r=e.x*n,i=e.y*n,a=e.z*n,o=e.w*n;return t.x=r,t.y=i,t.z=a,t.w=o,t},s.inverse=function(e,t){var n=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/n,t)},s.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},s.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,h=o*u+r*l+i*c-a*s,f=o*s-r*c+i*l+a*u,d=o*c+r*s-i*u+a*l,m=o*l-r*u-i*s-a*c;return n.x=h,n.y=f,n.z=d,n.w=m,n},s.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},s.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},s.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var w=new s;s.lerp=function(e,t,n,r){return w=s.multiplyByScalar(t,n,w),r=s.multiplyByScalar(e,1-n,r),s.add(w,r,r)};var g=new s,x=new s,E=new s;s.slerp=function(e,t,n,r){var i=s.dot(e,t),a=t;if(0>i&&(i=-i,a=g=s.negate(t,g)),1-i<o.EPSILON6)return s.lerp(e,a,n,r);var u=Math.acos(i);return x=s.multiplyByScalar(e,Math.sin((1-n)*u),x),E=s.multiplyByScalar(a,Math.sin(n*u),E),r=s.add(x,E,r),s.multiplyByScalar(r,1/Math.sin(u),r)},s.log=function(t,n){var r=o.acosClamped(t.w),i=0;return 0!==r&&(i=r/Math.sin(r)),e.multiplyByScalar(t,i,n)},s.exp=function(t,n){var r=e.magnitude(t),i=0;return 0!==r&&(i=Math.sin(r)/r),n.x=t.x*i,n.y=t.y*i,n.z=t.z*i,n.w=Math.cos(r),n};var M=new e,S=new e,z=new s,_=new s;s.computeInnerQuadrangle=function(t,n,r,i){var a=s.conjugate(n,z);s.multiply(a,r,_);var o=s.log(_,M);s.multiply(a,t,_);var u=s.log(_,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,z),s.multiply(n,z,i)},s.squad=function(e,t,n,r,i,a){var o=s.slerp(e,t,i,z),u=s.slerp(n,r,i,_);return s.slerp(o,u,2*i*(1-i),a)};for(var O=new s,T=1.9011074535173003,I=i.supportsTypedArrays()?new Float32Array(8):[],N=i.supportsTypedArrays()?new Float32Array(8):[],R=i.supportsTypedArrays()?new Float32Array(8):[],A=i.supportsTypedArrays()?new Float32Array(8):[],b=0;7>b;++b){var P=b+1,L=2*P+1;I[b]=1/(P*L),N[b]=P/L}return I[7]=T/136,N[7]=8*T/17,s.fastSlerp=function(e,t,n,r){var i,a=s.dot(e,t);a>=0?i=1:(i=-1,a=-a);for(var o=a-1,u=1-n,c=n*n,l=u*u,h=7;h>=0;--h)R[h]=(I[h]*c-N[h])*o,A[h]=(I[h]*l-N[h])*o;var f=i*n*(1+R[0]*(1+R[1]*(1+R[2]*(1+R[3]*(1+R[4]*(1+R[5]*(1+R[6]*(1+R[7])))))))),d=u*(1+A[0]*(1+A[1]*(1+A[2]*(1+A[3]*(1+A[4]*(1+A[5]*(1+A[6]*(1+A[7])))))))),m=s.multiplyByScalar(e,d,O);return s.multiplyByScalar(t,f,r),s.add(m,r,r)},s.fastSquad=function(e,t,n,r,i,a){var o=s.fastSlerp(e,t,i,z),u=s.fastSlerp(n,r,i,_);return s.fastSlerp(o,u,2*i*(1-i),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.x-t.x)<=r&&Math.abs(e.y-t.y)<=r&&Math.abs(e.z-t.z)<=r&&Math.abs(e.w-t.w)<=r
},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,n,r){"use strict";function i(t,i,a,l,h,f,d,m,y,p){var v=t+i;e.multiplyByScalar(l,Math.cos(v),o),e.multiplyByScalar(a,Math.sin(v),u),e.add(o,u,o);var w=Math.cos(t);w*=w;var g=Math.sin(t);g*=g;var x=f/Math.sqrt(d*w+h*g),E=x/m;return r.fromAxisAngle(o,E,s),n.fromQuaternion(s,c),n.multiplyByVector(c,y,p),e.normalize(p,p),e.multiplyByScalar(p,m,p),p}var a={},o=new e,u=new e,s=new r,c=new n,l=new e,h=new e,f=new e,d=new e;a.raisePositionsToHeight=function(t,n,r){for(var i=n.ellipsoid,a=n.height,o=n.extrudedHeight,u=r?2*(t.length/3):t.length/3,s=new Float64Array(3*u),c=t.length,m=r?c:0,y=0;c>y;y+=3){var p=y+1,v=y+2,w=e.fromArray(t,y,l);i.scaleToGeodeticSurface(w,w);var g=e.clone(w,h),x=i.geodeticSurfaceNormal(w,d),E=e.multiplyByScalar(x,a,f);e.add(w,E,w),r&&(e.multiplyByScalar(x,o,E),e.add(g,E,g),s[y+m]=g.x,s[p+m]=g.y,s[v+m]=g.z),s[y]=w.x,s[p]=w.y,s[v]=w.z}return s};var m=new e,y=new e,p=new e;return a.computeEllipsePositions=function(n,r,a){var o=n.semiMinorAxis,u=n.semiMajorAxis,s=n.rotation,c=n.center,d=8*n.granularity,v=o*o,w=u*u,g=u*o,x=e.magnitude(c),E=e.normalize(c,m),M=e.cross(e.UNIT_Z,c,y);M=e.normalize(M,M);var S=e.cross(E,M,p),z=1+Math.ceil(t.PI_OVER_TWO/d),_=t.PI_OVER_TWO/(z-1),O=t.PI_OVER_TWO-z*_;0>O&&(z-=Math.ceil(Math.abs(O)/_));var T,I,N,R,A,b=2*z*(z+1),P=r?new Array(3*b):void 0,L=0,C=l,q=h,U=3*(2*z+2*(z-1)),B=U-1,D=0,W=a?new Array(U):void 0;for(O=t.PI_OVER_TWO,T=0;z>T;++T){if(C=i(O,s,S,M,v,g,w,x,E,C),q=i(Math.PI-O,s,S,M,v,g,w,x,E,q),r){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,N=2*T+2,I=1;N-1>I;++I)R=I/(N-1),A=e.lerp(C,q,R,f),P[L++]=A.x,P[L++]=A.y,P[L++]=A.z;P[L++]=q.x,P[L++]=q.y,P[L++]=q.z}a&&(W[B--]=C.z,W[B--]=C.y,W[B--]=C.x,0!==T&&(W[D++]=q.x,W[D++]=q.y,W[D++]=q.z)),O=t.PI_OVER_TWO-(T+1)*_}for(T=z;T>0;--T){if(O=t.PI_OVER_TWO-(T-1)*_,C=i(-O,s,S,M,v,g,w,x,E,C),q=i(O+Math.PI,s,S,M,v,g,w,x,E,q),r){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,N=2*(T-1)+2,I=1;N-1>I;++I)R=I/(N-1),A=e.lerp(C,q,R,f),P[L++]=A.x,P[L++]=A.y,P[L++]=A.z;P[L++]=q.x,P[L++]=q.y,P[L++]=q.z}a&&(W[B--]=C.z,W[B--]=C.y,W[B--]=C.x,1!==T&&(W[D++]=q.x,W[D++]=q.y,W[D++]=q.z))}var F={};return r&&(F.positions=P,F.numPts=z),a&&(F.outerPositions=W),F},a}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,i){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(e){var r=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(r!==o&&-1!==r)throw new n("All attribute lists must have the same number of attributes.");r=o}return r},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r){"use strict";var i={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,n,i){return e>r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,i):new Uint16Array(t,n,i)},n(i)}),define("Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,n,r,i,a,o,u,s,c,l,h,f,d){"use strict";function m(r){var i=r.center;v=t.multiplyByScalar(r.ellipsoid.geodeticSurfaceNormal(i,v),r.height,v),v=t.add(i,v,v);for(var a=new e(v,r.semiMajorAxis),u=o.computeEllipsePositions(r,!1,!0).outerPositions,s=new l({position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:o.raisePositionsToHeight(u,r,!1)})}),f=u.length/3,d=h.createTypedArray(f,2*f),m=0,y=0;f>y;++y)d[m++]=y,d[m++]=(y+1)%f;return{boundingSphere:a,attributes:s,indices:d}}function y(i){var a=r(i.numberOfVerticalLines,16);a=Math.max(a,0);var u=i.center,s=i.ellipsoid,f=i.semiMajorAxis,d=t.multiplyByScalar(s.geodeticSurfaceNormal(u,p),i.height,p);w.center=t.add(u,d,w.center),w.radius=f,d=t.multiplyByScalar(s.geodeticSurfaceNormal(u,d),i.extrudedHeight,d),g.center=t.add(u,d,g.center),g.radius=f;var m=o.computeEllipsePositions(i,!1,!0).outerPositions,y=new l({position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:o.raisePositionsToHeight(m,i,!0)})});m=y.position.values;var v=e.union(w,g),x=m.length/3,E=h.createTypedArray(x,2*x+2*a);x/=2;var M,S=0;for(M=0;x>M;++M)E[S++]=M,E[S++]=(M+1)%x,E[S++]=M+x,E[S++]=(M+1)%x+x;var z;if(a>0){var _=Math.min(a,x);z=Math.round(x/_)}var O=Math.min(z*a,x);if(a>0)for(M=0;O>M;M+=z)E[S++]=M,E[S++]=M+x;return{boundingSphere:v,attributes:y,indices:E}}var p=new t,v=new t,w=new e,g=new e,x=function(e){e=r(e,r.EMPTY_OBJECT);var n=e.center,a=r(e.ellipsoid,u.WGS84),o=e.semiMajorAxis,s=e.semiMinorAxis,c=r(e.granularity,f.RADIANS_PER_DEGREE),l=r(e.height,0),h=e.extrudedHeight,d=i(h)&&Math.abs(l-h)>1;this._center=t.clone(n),this._semiMajorAxis=o,this._semiMinorAxis=s,this._ellipsoid=u.clone(a),this._rotation=r(e.rotation,0),this._height=l,this._granularity=c,this._extrudedHeight=h,this._extrude=d,this._numberOfVerticalLines=Math.max(r(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};x.packedLength=t.packedLength+u.packedLength+9,x.pack=function(e,n,a){a=r(a,0),t.pack(e._center,n,a),a+=t.packedLength,u.pack(e._ellipsoid,n,a),a+=u.packedLength,n[a++]=e._semiMajorAxis,n[a++]=e._semiMinorAxis,n[a++]=e._rotation,n[a++]=e._height,n[a++]=e._granularity,n[a++]=i(e._extrudedHeight)?1:0,n[a++]=r(e._extrudedHeight,0),n[a++]=e._extrude?1:0,n[a]=e._numberOfVerticalLines};var E=new t,M=new u,S={center:E,ellipsoid:M,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return x.unpack=function(e,n,a){n=r(n,0);var o=t.unpack(e,n,E);n+=t.packedLength;var s=u.unpack(e,n,M);n+=u.packedLength;var c=e[n++],l=e[n++],h=e[n++],f=e[n++],d=e[n++],m=e[n++],y=e[n++],p=1===e[n++],v=e[n];return i(a)?(a._center=t.clone(o,a._center),a._ellipsoid=u.clone(s,a._ellipsoid),a._semiMajorAxis=c,a._semiMinorAxis=l,a._rotation=h,a._height=f,a._granularity=d,a._extrudedHeight=m?y:void 0,a._extrude=p,a._numberOfVerticalLines=v,a):(S.height=f,S.extrudedHeight=m?y:void 0,S.granularity=d,S.rotation=h,S.semiMajorAxis=c,S.semiMinorAxis=l,S.numberOfVerticalLines=v,new x(S))},x.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,n={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(n.extrudedHeight=Math.min(e._extrudedHeight,e._height),n.height=Math.max(e._extrudedHeight,e._height),t=y(n)):t=m(n),new s({attributes:t.attributes,indices:t.indices,primitiveType:d.LINES,boundingSphere:t.boundingSphere})},x}),define("Workers/createEllipseOutlineGeometry",["../Core/Cartesian3","../Core/defined","../Core/EllipseOutlineGeometry","../Core/Ellipsoid"],function(e,t,n,r){"use strict";function i(i,a){return t(a)&&(i=n.unpack(i,a)),i._center=e.clone(i._center),i._ellipsoid=r.clone(i._ellipsoid),n.createGeometry(i)}return i})}();