/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};r.EPSILON1=.1,r.EPSILON2=.01,r.EPSILON3=.001,r.EPSILON4=1e-4,r.EPSILON5=1e-5,r.EPSILON6=1e-6,r.EPSILON7=1e-7,r.EPSILON8=1e-8,r.EPSILON9=1e-9,r.EPSILON10=1e-10,r.EPSILON11=1e-11,r.EPSILON12=1e-12,r.EPSILON13=1e-13,r.EPSILON14=1e-14,r.EPSILON15=1e-15,r.EPSILON16=1e-16,r.EPSILON17=1e-17,r.EPSILON18=1e-18,r.EPSILON19=1e-19,r.EPSILON20=1e-20,r.GRAVITATIONALPARAMETER=3986004418e5,r.SOLAR_RADIUS=6955e5,r.LUNAR_RADIUS=1737400,r.SIXTY_FOUR_KILOBYTES=65536,r.sign=function(e){return e>0?1:0>e?-1:0},r.signNotZero=function(e){return 0>e?-1:1},r.toSNorm=function(e){return Math.round(255*(.5*r.clamp(e,-1,1)+.5))},r.fromSNorm=function(e){return 2*(r.clamp(e,0,255)/255)-1},r.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},r.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},r.lerp=function(e,t,r){return(1-r)*e+r*t},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=.5*Math.PI,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=.5*3*Math.PI,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(e){return e*r.RADIANS_PER_DEGREE},r.toDegrees=function(e){return e*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(e){var t=r.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},r.negativePiToPi=function(e){return r.zeroToTwoPi(e+r.PI)-r.PI},r.zeroToTwoPi=function(e){var t=r.mod(e,r.TWO_PI);return Math.abs(t)<r.EPSILON14&&Math.abs(e)>r.EPSILON14?r.TWO_PI:t},r.mod=function(e,t){return(e%t+t)%t},r.equalsEpsilon=function(e,r,n,o){o=t(o,n);var i=Math.abs(e-r);return o>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var n=[1];r.factorial=function(e){var t=n.length;if(e>=t)for(var r=n[t-1],o=t;e>=o;o++)n.push(r*o);return n[e]},r.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},r.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},r.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},r.clamp=function(e,t,r){return t>e?t:e>r?r:e};var o=new e;return r.setRandomNumberSeed=function(t){o=new e(t)},r.nextRandomNumber=function(){return o.random()},r.acosClamped=function(e){return Math.acos(r.clamp(e,-1,1))},r.asinClamped=function(e){return Math.asin(r.clamp(e,-1,1))},r.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},r}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var o=r.clock,a=r.cone,u=e(r.magnitude,1),s=u*Math.sin(a);return n.x=s*Math.cos(o),n.y=s*Math.sin(o),n.z=u*Math.cos(a),n},i.fromElements=function(e,r,n,o){return t(o)?(o.x=e,o.y=r,o.z=n,o):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,o=e.y,i=e.z,a=t.x,u=t.y,s=t.z,c=o*s-i*u,l=i*a-n*s,f=n*u-o*a;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,a){var u=o.toRadians(e),s=o.toRadians(t);return i.fromRadians(u,s,r,n,a)};var f=new i,h=new i,m=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,o,a,u){o=e(o,0);var s=t(a)?a.radiiSquared:m,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,h);var l=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,l,h),f=i.multiplyByScalar(f,o,f),t(u)||(u=new i),i.add(h,f,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a++)n[a]=o.toRadians(e[a]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var o=e.length;t(n)?n.length=o/2:n=new Array(o/2);for(var a=0;o>a;a+=2){var u=e[a],s=e[a+1];n[a/2]=i.fromRadians(u,s,0,r,n[a/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),a=0;a<e.length;a+=3)n[a]=o.toRadians(e[a]),n[a+1]=o.toRadians(e[a+1]),n[a+2]=e[a+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var o=e.length;t(n)?n.length=o/3:n=new Array(o/3);for(var a=0;o>a;a+=3){var u=e[a],s=e[a+1],c=e[a+2];n[a/3]=i.fromRadians(u,s,c,r,n[a/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,o,a){return o=e(o,0),t(a)?(a.longitude=r,a.latitude=n,a.height=o,a):new i(r,n,o)},i.fromDegrees=function(e,t,r,n){return e=o.toRadians(e),t=o.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";function s(t,n,o,i){n=r(n,0),o=r(o,0),i=r(i,0),t._radii=new e(n,o,i),t._radiiSquared=new e(n*n,o*o,i*i),t._radiiToTheFourth=new e(n*n*n*n,o*o*o*o,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===o?0:1/o,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===o?0:1/(o*o),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,o,i),t._maximumRadius=Math.max(n,o,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};o(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var o=t._radii;return n(r)?(e.clone(o,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(o.x,o.y,o.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=a(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=a(new c(1,1,1)),c.MOON=a(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,o){o=r(o,0),e.pack(t._radii,n,o)},c.unpack=function(t,n,o){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,o)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var o=t.longitude,i=t.latitude,a=Math.cos(i),u=a*Math.cos(o),s=a*Math.sin(o),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,r){var o=l,i=f;this.geodeticSurfaceNormalCartographic(t,o),e.multiplyComponents(this._radiiSquared,o,i);var a=Math.sqrt(e.dot(o,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(o,t.height,o),n(r)||(r=new e),e.add(i,o,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var h=new e,m=new e,d=new e;c.prototype.cartesianToCartographic=function(r,o){var i=this.scaleToGeodeticSurface(r,m);if(!n(i))return void 0;var a=this.geodeticSurfaceNormal(i,h),s=e.subtract(r,i,d),c=Math.atan2(a.y,a.x),l=Math.asin(a.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(o)?(o.longitude=c,o.latitude=l,o.height=f,o):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var o=0;r>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t};var p=new e,v=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var o=t.x,i=t.y,a=t.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,h=o*o*c*c,m=i*i*l*l,d=a*a*f*f,y=h+m+d,g=Math.sqrt(1/y),E=e.multiplyByScalar(t,g,p);if(y<this._centerToleranceSquared)return isFinite(g)?e.clone(E,r):void 0;var S=this._oneOverRadiiSquared,C=S.x,w=S.y,b=S.z,x=v;x.x=2*E.x*C,x.y=2*E.y*w,x.z=2*E.z*b;var A,T,M,I,O,R,N,L,P,z,D,F=(1-g)*e.magnitude(t)/(.5*e.magnitude(x)),_=0;do{F-=_,M=1/(1+F*C),I=1/(1+F*w),O=1/(1+F*b),R=M*M,N=I*I,L=O*O,P=R*M,z=N*I,D=L*O,A=h*R+m*N+d*L-1,T=h*P*C+m*z*w+d*D*b;var B=-2*T;_=A/B}while(Math.abs(A)>u.EPSILON12);return n(r)?(r.x=o*M,r.y=i*I,r.z=a*O,r):new e(o*M,i*I,a*O)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var o=t.x,i=t.y,a=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(o*o*u.x+i*i*u.y+a*a*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,i,a){"use strict";var u=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},u.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=e.y*o,u=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=u,r):new t(i,a,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r,n,o){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(o,0)};i.fromElements=function(e,r,n,o,a){return t(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new i(e,r,n,o)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n++],o.z=r[n++],o.w=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)&&o.equalsEpsilon(e.z,r.z,n,i)&&o.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(m[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=i.EPSILON15,n=0,o=1,a=0;3>a;++a){var u=Math.abs(e[c.getElementIndex(m[a],h[a])]);u>n&&(o=a,n=u)}var s=1,l=0,f=h[o],d=m[o];if(Math.abs(e[c.getElementIndex(d,f)])>r){var p,v=e[c.getElementIndex(d,d)],y=e[c.getElementIndex(f,f)],g=e[c.getElementIndex(d,f)],E=(v-y)/2/g;p=0>E?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)),s=1/Math.sqrt(1+p*p),l=p*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(d,d)]=s,t[c.getElementIndex(d,f)]=l,t[c.getElementIndex(f,d)]=-l,t}var c=function(e,r,n,o,i,a,u,s,c){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(a,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,o){return n=t(n,0),r(o)||(o=new c),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,o=e.x*e.y,i=e.x*e.z,a=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,m=e.w*e.w,d=n-u-f+m,p=2*(o-h),v=2*(i+l),y=2*(o+h),g=-n+u-f+m,E=2*(s-a),S=2*(i-l),C=2*(s+a),w=-n-u+f+m;return r(t)?(t[0]=d,t[1]=y,t[2]=S,t[3]=p,t[4]=g,t[5]=C,t[6]=v,t[7]=E,t[8]=w,t):new c(d,p,v,y,g,E,S,C,w)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=o,t[6]=0,t[7]=-o,t[8]=n,t):new c(1,0,0,0,n,-o,0,o,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=n,t):new c(n,0,o,0,1,0,-o,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=o,t[2]=0,t[3]=-o,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-o,0,o,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,o=e[n],i=e[n+1],a=e[n+2];return r.x=o,r.y=i,r.z=a,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=3*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n},c.getRow=function(e,t,r){var n=e[t],o=e[t+3],i=e[t+6];return r.x=n,r.y=o,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],a=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[3]*o+e[6]*i,u=e[1]*n+e[4]*o+e[7]*i,s=e[2]*n+e[5]*o+e[8]*i;return r.x=a,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=o,t[3]=i,t[4]=a,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],m=[2,2,1],d=new c,p=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,o=10,l=0,f=0;r(t)||(t={});for(var h=t.unitary=c.clone(c.IDENTITY,t.unitary),m=t.diagonal=c.clone(e,t.diagonal),v=n*a(m);o>f&&u(m)>v;)s(m,d),c.transpose(d,p),c.multiply(m,d,m),c.multiply(p,m,m),c.multiply(h,d,h),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],o=e[1],i=e[4],a=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*a)+o*(s*n-r*c)+u*(r*a-i*n)},c.inverse=function(e,t){var r=e[0],o=e[1],a=e[2],u=e[3],s=e[4],l=e[5],f=e[6],h=e[7],m=e[8],d=c.determinant(e);if(Math.abs(d)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=s*m-h*l,t[1]=h*a-o*m,t[2]=o*l-s*a,t[3]=f*l-u*m,t[4]=r*m-f*a,t[5]=u*a-r*l,t[6]=u*h-f*s,t[7]=f*o-r*h,t[8]=r*s-u*o;var p=1/d;return c.multiplyByScalar(t,p,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=o(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,i,a,u,s){"use strict";var c=function(e,t,n,o,i,a,u,s,c,l,f,h,m,d,p,v){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(m,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(l,0),this[7]=r(d,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(p,0),this[12]=r(o,0),this[13]=r(s,0),this[14]=r(h,0),this[15]=r(v,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,o){return t=r(t,0),n(o)||(o=new c),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,o,i){return o=r(o,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=o.x,i[13]=o.y,i[14]=o.z,i[15]=1,i):new c(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,o){n(o)||(o=new c);var i=r.x,a=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,m=t.y*t.y,d=t.y*t.z,p=t.y*t.w,v=t.z*t.z,y=t.z*t.w,g=t.w*t.w,E=s-m-v+g,S=2*(l-y),C=2*(f+p),w=2*(l+y),b=-s+m-v+g,x=2*(d-h),A=2*(f-p),T=2*(d+h),M=-s-m+v+g;return o[0]=E*i,o[1]=w*i,o[2]=A*i,o[3]=0,o[4]=S*a,o[5]=b*a,o[6]=T*a,o[7]=0,o[8]=C*u,o[9]=x*u,o[10]=M*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,r){var o=t.eye,i=t.target,a=t.up;e.normalize(e.subtract(i,o,l),l),e.normalize(e.cross(l,a,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,m=f.z,d=l.x,p=l.y,v=l.z,y=h.x,g=h.y,E=h.z,S=o.x,C=o.y,w=o.z,b=u*-S+s*-C+m*-w,x=y*-S+g*-C+E*-w,A=d*S+p*C+v*w;return n(r)?(r[0]=u,r[1]=y,r[2]=-d,r[3]=0,r[4]=s,r[5]=g,r[6]=-p,r[7]=0,r[8]=m,r[9]=E,r[10]=-v,r[11]=0,r[12]=b,r[13]=x,r[14]=A,r[15]=1,r):new c(u,s,m,b,y,g,E,x,-d,-p,-v,A,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,o){var i=Math.tan(.5*e),a=1/i,u=a/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},c.computeOrthographicOffCenter=function(e,t,r,n,o,i,a){var u=1/(t-e),s=1/(n-r),c=1/(i-o),l=-(t+e)*u,f=-(n+r)*s,h=-(i+o)*c;return u*=2,s*=2,c*=-2,a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=0,a[12]=l,a[13]=f,a[14]=h,a[15]=1,a},c.computePerspectiveOffCenter=function(e,t,r,n,o,i,a){var u=2*o/(t-e),s=2*o/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+o)/(i-o),h=-1,m=-2*i*o/(i-o);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=l,a[10]=f,a[11]=h,a[12]=0,a[13]=0,a[14]=m,a[15]=0,a},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,o,i){var a=2*o/(t-e),u=2*o/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,h=-2*o;
return i[0]=a,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,o){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),a=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),h=c,m=l,d=f,p=i+c,v=a+l,y=t+f,g=1;return o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=d,o[11]=0,o[12]=p,o[13]=v,o[14]=y,o[15]=g,o},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,o=e[n],i=e[n+1],a=e[n+2],u=e[n+3];return r.x=o,r.y=i,r.z=a,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var o=4*t;return n[o]=r.x,n[o+1]=r.y,n[o+2]=r.z,n[o+3]=r.w,n},c.getRow=function(e,t,r){var n=e[t],o=e[t+4],i=e[t+8],a=e[t+12];return r.x=n,r.y=o,r.z=i,r.w=a,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var m=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),r};var d=new e;c.getMaximumScale=function(t){return c.getScale(t,d),e.maximumComponent(d)},c.multiply=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],m=e[10],d=e[11],p=e[12],v=e[13],y=e[14],g=e[15],E=t[0],S=t[1],C=t[2],w=t[3],b=t[4],x=t[5],A=t[6],T=t[7],M=t[8],I=t[9],O=t[10],R=t[11],N=t[12],L=t[13],P=t[14],z=t[15],D=n*E+u*S+f*C+p*w,F=o*E+s*S+h*C+v*w,_=i*E+c*S+m*C+y*w,B=a*E+l*S+d*C+g*w,U=n*b+u*x+f*A+p*T,G=o*b+s*x+h*A+v*T,q=i*b+c*x+m*A+y*T,k=a*b+l*x+d*A+g*T,V=n*M+u*I+f*O+p*R,W=o*M+s*I+h*O+v*R,Y=i*M+c*I+m*O+y*R,H=a*M+l*I+d*O+g*R,j=n*N+u*L+f*P+p*z,K=o*N+s*L+h*P+v*z,Z=i*N+c*L+m*P+y*z,X=a*N+l*L+d*P+g*z;return r[0]=D,r[1]=F,r[2]=_,r[3]=B,r[4]=U,r[5]=G,r[6]=q,r[7]=k,r[8]=V,r[9]=W,r[10]=Y,r[11]=H,r[12]=j,r[13]=K,r[14]=Z,r[15]=X,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],m=e[13],d=e[14],p=t[0],v=t[1],y=t[2],g=t[4],E=t[5],S=t[6],C=t[8],w=t[9],b=t[10],x=t[12],A=t[13],T=t[14],M=n*p+a*v+c*y,I=o*p+u*v+l*y,O=i*p+s*v+f*y,R=n*g+a*E+c*S,N=o*g+u*E+l*S,L=i*g+s*E+f*S,P=n*C+a*w+c*b,z=o*C+u*w+l*b,D=i*C+s*w+f*b,F=n*x+a*A+c*T+h,_=o*x+u*A+l*T+m,B=i*x+s*A+f*T+d;return r[0]=M,r[1]=I,r[2]=O,r[3]=0,r[4]=R,r[5]=N,r[6]=L,r[7]=0,r[8]=P,r[9]=z,r[10]=D,r[11]=0,r[12]=F,r[13]=_,r[14]=B,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],m=t[1],d=t[2],p=t[3],v=t[4],y=t[5],g=t[6],E=t[7],S=t[8],C=n*h+a*m+c*d,w=o*h+u*m+l*d,b=i*h+s*m+f*d,x=n*p+a*v+c*y,A=o*p+u*v+l*y,T=i*p+s*v+f*y,M=n*g+a*E+c*S,I=o*g+u*E+l*S,O=i*g+s*E+f*S;return r[0]=C,r[1]=w,r[2]=b,r[3]=0,r[4]=x,r[5]=A,r[6]=T,r[7]=0,r[8]=M,r[9]=I,r[10]=O,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=n*e[0]+o*e[4]+i*e[8]+e[12],u=n*e[1]+o*e[5]+i*e[9]+e[13],s=n*e[2]+o*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=a,r[13]=u,r[14]=s,r[15]=e[15],r};var p=new e;c.multiplyByUniformScale=function(e,t,r){return p.x=t,p.y=t,p.z=t,c.multiplyByScale(e,p,r)},c.multiplyByScale=function(e,t,r){var n=t.x,o=t.y,i=t.z;return 1===n&&1===o&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=o*e[4],r[5]=o*e[5],r[6]=o*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=t.w,u=e[0]*n+e[4]*o+e[8]*i+e[12]*a,s=e[1]*n+e[5]*o+e[9]*i+e[13]*a,c=e[2]*n+e[6]*o+e[10]*i+e[14]*a,l=e[3]*n+e[7]*o+e[11]*i+e[15]*a;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i,u=e[1]*n+e[5]*o+e[9]*i,s=e[2]*n+e[6]*o+e[10]*i;return r.x=a,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,o=t.y,i=t.z,a=e[0]*n+e[4]*o+e[8]*i+e[12],u=e[1]*n+e[5]*o+e[9]*i+e[13],s=e[2]*n+e[6]*o+e[10]*i+e[14];return r.x=a,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],o=e[3],i=e[6],a=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=a,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var v=new u,y=new u,g=new t,E=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,v),y,a.EPSILON7)&&t.equals(c.getRow(e,3,g),E))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],o=e[4],i=e[8],l=e[12],f=e[1],h=e[5],m=e[9],d=e[13],p=e[2],S=e[6],C=e[10],w=e[14],b=e[3],x=e[7],A=e[11],T=e[15],M=C*T,I=w*A,O=S*T,R=w*x,N=S*A,L=C*x,P=p*T,z=w*b,D=p*A,F=C*b,_=p*x,B=S*b,U=M*h+R*m+N*d-(I*h+O*m+L*d),G=I*f+P*m+F*d-(M*f+z*m+D*d),q=O*f+z*h+_*d-(R*f+P*h+B*d),k=L*f+D*h+B*m-(N*f+F*h+_*m),V=I*o+O*i+L*l-(M*o+R*i+N*l),W=M*n+z*i+D*l-(I*n+P*i+F*l),Y=R*n+P*o+B*l-(O*n+z*o+_*l),H=N*n+F*o+_*i-(L*n+D*o+B*i);M=i*d,I=l*m,O=o*d,R=l*h,N=o*m,L=i*h,P=n*d,z=l*f,D=n*m,F=i*f,_=n*h,B=o*f;var j=M*x+R*A+N*T-(I*x+O*A+L*T),K=I*b+P*A+F*T-(M*b+z*A+D*T),Z=O*b+z*x+_*T-(R*b+P*x+B*T),X=L*b+D*x+B*A-(N*b+F*x+_*A),Q=O*C+L*w+I*S-(N*w+M*S+R*C),J=D*w+M*p+z*C-(P*C+F*w+I*p),$=P*S+B*w+R*p-(_*w+O*p+z*S),et=_*C+N*p+F*S-(D*S+B*C+L*p),tt=n*U+o*G+i*q+l*k;if(Math.abs(tt)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return tt=1/tt,r[0]=U*tt,r[1]=G*tt,r[2]=q*tt,r[3]=k*tt,r[4]=V*tt,r[5]=W*tt,r[6]=Y*tt,r[7]=H*tt,r[8]=j*tt,r[9]=K*tt,r[10]=Z*tt,r[11]=X*tt,r[12]=Q*tt,r[13]=J*tt,r[14]=$*tt,r[15]=et*tt,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],o=e[2],i=e[4],a=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],m=e[14],d=-r*f-n*h-o*m,p=-i*f-a*h-u*m,v=-s*f-c*h-l*m;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=a,t[6]=c,t[7]=0,t[8]=o,t[9]=u,t[10]=l,t[11]=0,t[12]=d,t[13]=p,t[14]=v,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";var s=function(e,r,n,o){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(o,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,o,i,a){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),o=u.toRadians(t(o,0)),i=u.toRadians(t(i,0)),r(a)?(a.west=e,a.south=n,a.east=o,a.north=i,a):new s(e,n,o,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,a=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),o=Math.max(o,l.longitude),i=Math.min(i,l.latitude),a=Math.max(a,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=o,t.north=a,t):new s(n,i,o,a)},s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,o){return n=t(n,0),r(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var o=t.east,i=t.west;i>o&&(o+=u.TWO_PI);var a=u.negativePiToPi(.5*(i+o)),s=.5*(t.south+t.north);return r(n)?(n.longitude=a,n.latitude=s,n.height=0,n):new e(a,s)},s.intersection=function(e,t,n){var o=e.east,i=e.west,a=t.east,c=t.west;i>o&&a>0?o+=u.TWO_PI:c>a&&o>0&&(a+=u.TWO_PI),i>o&&0>c?c+=u.TWO_PI:c>a&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(o,a));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var h=Math.max(e.south,t.south),m=Math.min(e.north,t.north);return h>=m?void 0:r(n)?(n.west=l,n.south=h,n.east=f,n.north=m,n):new s(l,h,f,m)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,o=e.west,i=e.east;return o>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>o||u.equalsEpsilon(r,o,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,o,a){n=t(n,i.WGS84),o=t(o,0),r(a)||(a=[]);var l=0,f=e.north,h=e.south,m=e.east,d=e.west,p=c;p.height=o,p.longitude=d,p.latitude=f,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=m,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.latitude=h,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=d,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.latitude=0>f?f:h>0?h:0;for(var v=1;8>v;++v)p.longitude=-Math.PI+v*u.PI_OVER_TWO,s.contains(e,p)&&(a[l]=n.cartographicToCartesian(p,a[l]),l++);return 0===p.latitude&&(p.longitude=d,a[l]=n.cartographicToCartesian(p,a[l]),l++,p.longitude=m,a[l]=n.cartographicToCartesian(p,a[l]),l++),a.length=l,a},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,r,n,o,i,a,u,s,c,l){"use strict";var f=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},h=new e,m=new e,d=new e,p=new e,v=new e,y=new e,g=new e,E=new e,S=new e,C=new e,w=new e,b=new e;f.fromPoints=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var o=e.clone(t[0],g),i=e.clone(o,h),a=e.clone(o,m),u=e.clone(o,d),s=e.clone(o,p),c=e.clone(o,v),l=e.clone(o,y),x=t.length,A=1;x>A;A++){e.clone(t[A],o);var T=o.x,M=o.y,I=o.z;T<i.x&&e.clone(o,i),T>s.x&&e.clone(o,s),M<a.y&&e.clone(o,a),M>c.y&&e.clone(o,c),I<u.z&&e.clone(o,u),I>l.z&&e.clone(o,l)}var O=e.magnitudeSquared(e.subtract(s,i,E)),R=e.magnitudeSquared(e.subtract(c,a,E)),N=e.magnitudeSquared(e.subtract(l,u,E)),L=i,P=s,z=O;R>z&&(z=R,L=a,P=c),N>z&&(z=N,L=u,P=l);var D=S;D.x=.5*(L.x+P.x),D.y=.5*(L.y+P.y),D.z=.5*(L.z+P.z);var F=e.magnitudeSquared(e.subtract(P,D,E)),_=Math.sqrt(F),B=C;B.x=i.x,B.y=a.y,B.z=u.z;var U=w;U.x=s.x,U.y=c.y,U.z=l.z;var G=e.multiplyByScalar(e.add(B,U,E),.5,b),q=0;for(A=0;x>A;A++){e.clone(t[A],o);var k=e.magnitude(e.subtract(o,G,E));k>q&&(q=k);var V=e.magnitudeSquared(e.subtract(o,D,E));if(V>F){var W=Math.sqrt(V);_=.5*(_+W),F=_*_;var Y=W-_;D.x=(_*D.x+Y*o.x)/W,D.y=(_*D.y+Y*o.y)/W,D.z=(_*D.z+Y*o.z)/W}}return q>_?(e.clone(D,r.center),r.radius=_):(e.clone(G,r.center),r.radius=q),r};var x=new a,A=new e,T=new e,M=new t,I=new t;f.fromRectangle2D=function(e,t,r){return f.fromRectangleWithHeights2D(e,t,0,0,r)},f.fromRectangleWithHeights2D=function(t,o,i,a,u){if(n(u)||(u=new f),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;o=r(o,x),l.southwest(t,M),M.height=i,l.northeast(t,I),I.height=a;var s=o.project(M,A),c=o.project(I,T),h=c.x-s.x,m=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(h*h+m*m+d*d);var p=u.center;return p.x=s.x+.5*h,p.y=s.y+.5*m,p.z=s.z+.5*d,u};var O=[];f.fromRectangle3D=function(e,t,o,a){t=r(t,i.WGS84),o=r(o,0);var u;return n(e)&&(u=l.subsample(e,t,o,O)),f.fromPoints(u,a)},f.fromVertices=function(t,o,i,a){if(n(a)||(a=new f),!n(t)||0===t.length)return a.center=e.clone(e.ZERO,a.center),a.radius=0,a;o=r(o,e.ZERO),i=r(i,3);var u=g;u.x=t[0]+o.x,u.y=t[1]+o.y,u.z=t[2]+o.z;for(var s=e.clone(u,h),c=e.clone(u,m),l=e.clone(u,d),x=e.clone(u,p),A=e.clone(u,v),T=e.clone(u,y),M=t.length,I=0;M>I;I+=i){var O=t[I]+o.x,R=t[I+1]+o.y,N=t[I+2]+o.z;u.x=O,u.y=R,u.z=N,O<s.x&&e.clone(u,s),O>x.x&&e.clone(u,x),R<c.y&&e.clone(u,c),R>A.y&&e.clone(u,A),N<l.z&&e.clone(u,l),N>T.z&&e.clone(u,T)}var L=e.magnitudeSquared(e.subtract(x,s,E)),P=e.magnitudeSquared(e.subtract(A,c,E)),z=e.magnitudeSquared(e.subtract(T,l,E)),D=s,F=x,_=L;P>_&&(_=P,D=c,F=A),z>_&&(_=z,D=l,F=T);var B=S;B.x=.5*(D.x+F.x),B.y=.5*(D.y+F.y),B.z=.5*(D.z+F.z);var U=e.magnitudeSquared(e.subtract(F,B,E)),G=Math.sqrt(U),q=C;q.x=s.x,q.y=c.y,q.z=l.z;var k=w;k.x=x.x,k.y=A.y,k.z=T.z;var V=e.multiplyByScalar(e.add(q,k,E),.5,b),W=0;for(I=0;M>I;I+=i){u.x=t[I]+o.x,u.y=t[I+1]+o.y,u.z=t[I+2]+o.z;var Y=e.magnitude(e.subtract(u,V,E));Y>W&&(W=Y);var H=e.magnitudeSquared(e.subtract(u,B,E));if(H>U){var j=Math.sqrt(H);G=.5*(G+j),U=G*G;var K=j-G;B.x=(G*B.x+K*u.x)/j,B.y=(G*B.y+K*u.y)/j,B.z=(G*B.z+K*u.z)/j}}return W>G?(e.clone(B,a.center),a.radius=G):(e.clone(V,a.center),a.radius=W),a},f.fromCornerPoints=function(t,r,o){n(o)||(o=new f);var i=o.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),o.radius=e.distance(i,r),o},f.fromEllipsoid=function(t,r){return n(r)||(r=new f),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var R=new e;f.fromBoundingSpheres=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var o=t.length;if(1===o)return f.clone(t[0],r);if(2===o)return f.union(t[0],t[1],r);for(var i=[],a=0;o>a;a++)i.push(t[a].center);r=f.fromPoints(i,r);var u=r.center,s=r.radius;for(a=0;o>a;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,R)+c.radius)}return r.radius=s,r},f.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius):void 0},f.packedLength=4,f.pack=function(e,t,n){n=r(n,0);var o=e.center;t[n++]=o.x,t[n++]=o.y,t[n++]=o.z,t[n]=e.radius},f.unpack=function(e,t,o){t=r(t,0),n(o)||(o=new f);var i=o.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],o.radius=e[t],o};var N=new e,L=new e;f.union=function(t,r,o){n(o)||(o=new f);var i=t.center,a=r.center;e.add(i,a,L);var u=e.multiplyByScalar(L,.5,L),s=e.magnitude(e.subtract(i,u,N))+t.radius,c=e.magnitude(e.subtract(a,u,N))+r.radius;return o.radius=Math.max(s,c),e.clone(u,o.center),o};var P=new e;f.expand=function(t,r,n){n=f.clone(t,n);var o=e.magnitude(e.subtract(r,n.center,P));return o>n.radius&&(n.radius=o),n},f.intersect=function(t,r){var n=t.center,o=t.radius,i=e.dot(r,n)+r.w;return-o>i?u.OUTSIDE:o>i?u.INTERSECTING:u.INSIDE},f.transform=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var z=new e;f.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,z);return e.magnitudeSquared(n)-t.radius*t.radius},f.transformWithoutScale=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var D=new e;f.computePlaneDistances=function(t,r,o,i){n(i)||(i=new s);var a=e.subtract(t.center,r,D),u=e.multiplyByScalar(o,e.dot(o,a),D),c=e.magnitude(u);return i.start=c-t.radius,i.stop=c+t.radius,i};for(var F=new e,_=new e,B=new e,U=new e,G=new e,q=new t,k=new Array(8),V=0;8>V;++V)k[V]=new e;var W=new a;return f.projectTo2D=function(t,n,o){n=r(n,W);var i=n.ellipsoid,a=t.center,u=t.radius,s=i.geodeticSurfaceNormal(a,F),c=e.cross(e.UNIT_Z,s,_);e.normalize(c,c);var l=e.cross(s,c,B);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var h=e.negate(l,G),m=e.negate(c,U),d=k,p=d[0];e.add(s,l,p),e.add(p,c,p),p=d[1],e.add(s,l,p),e.add(p,m,p),p=d[2],e.add(s,h,p),e.add(p,m,p),p=d[3],e.add(s,h,p),e.add(p,c,p),e.negate(s,s),p=d[4],e.add(s,l,p),e.add(p,c,p),p=d[5],e.add(s,l,p),e.add(p,m,p),p=d[6],e.add(s,h,p),e.add(p,m,p),p=d[7],e.add(s,h,p),e.add(p,c,p);for(var v=d.length,y=0;v>y;++y){var g=d[y];e.add(a,g,g);var E=i.cartesianToCartographic(g,q);n.project(E,g)}o=f.fromPoints(d,o),a=o.center;var S=a.x,C=a.y,w=a.z;return a.x=w,a.y=S,a.z=C,o},f.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,u=i.length;u>a;++a){var s=i[a];o=s+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=s+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=s+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=s+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=s+"FullscreenEnabled",e(document[o])?n.fullscreenEnabled=o:(o=s+"FullScreenEnabled",e(document[o])&&(n.fullscreenEnabled=o)),o=s+"FullscreenElement",e(document[o])?n.fullscreenElement=o:(o=s+"FullScreenElement",e(document[o])&&(n.fullscreenElement=o)),o=s+"fullscreenchange",e(document["on"+o])&&("ms"===s&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=s+"fullscreenerror",e(document["on"+o])&&("ms"===s&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e){o.supportsFullscreen()&&e[n.requestFullscreen]()},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(v)){v=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(v=!0,y=n(e[1]))}return v}function i(){return o()&&y}function a(){if(!t(g)&&(g=!1,!o()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,E=n(e[1]))}return g}function u(){return a()&&E}function s(){if(!t(S)){S=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(S=!0,C=n(e[1]),C.isNightly=!!e[2])}return S}function c(){return s()&&C}function l(){if(!t(w)){w=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(w=!0,b=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(w=!0,b=n(e[1])))}return w}function f(){return l()&&b}function h(){if(!t(x)){x=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(x=!0,A=n(e[1]))}return x}function m(){return t(T)||(T=/Windows/i.test(navigator.appVersion)),T}function d(){return h()&&A}function p(){return t(M)||(M=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),M}var v,y,g,E,S,C,w,b,x,A,T,M,I={isChrome:o,chromeVersion:i,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:d,isWindows:m,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:p};return I.supportsFullscreen=function(){return r.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+6*(t-e)*(2/3-r):e}var u=function(t,r,n,o){this.red=e(t,1),this.green=e(r,1),this.blue=e(n,1),this.alpha=e(o,1)};u.fromCartesian4=function(e,r){return t(r)?(r.red=e.x,r.green=e.y,r.blue=e.z,r.alpha=e.w,r):new u(e.x,e.y,e.z,e.w)},u.fromBytes=function(r,n,o,i,a){return r=u.byteToFloat(e(r,255)),n=u.byteToFloat(e(n,255)),o=u.byteToFloat(e(o,255)),i=u.byteToFloat(e(i,255)),t(a)?(a.red=r,a.green=n,a.blue=o,a.alpha=i,a):new u(r,n,o,i)},u.fromAlpha=function(e,r,n){return t(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=r,n):new u(e.red,e.green,e.blue,r)};var s,c,l;n.supportsTypedArrays()&&(s=new ArrayBuffer(4),c=new Uint32Array(s),l=new Uint8Array(s)),u.fromRgba=function(e){return c[0]=e,u.fromBytes(l[0],l[1],l[2],l[3])},u.fromHsl=function(t,r,n,o){t=e(t,0)%1,r=e(r,0),n=e(n,0),o=e(o,1);var i=n,s=n,c=n;if(0!==r){var l;l=.5>n?n*(1+r):n+r-n*r;var f=2*n-l;i=a(f,l,t+1/3),s=a(f,l,t),c=a(f,l,t-1/3)}return new u(i,s,c,o)},u.fromRandom=function(r,n){r=e(r,e.EMPTY_OBJECT);var o=r.red;if(!t(o)){var a=e(r.minimumRed,0),s=e(r.maximumRed,1);o=a+i.nextRandomNumber()*(s-a)}var c=r.green;if(!t(c)){var l=e(r.minimumGreen,0),f=e(r.maximumGreen,1);c=l+i.nextRandomNumber()*(f-l)}var h=r.blue;if(!t(h)){var m=e(r.minimumBlue,0),d=e(r.maximumBlue,1);h=m+i.nextRandomNumber()*(d-m)}var p=r.alpha;if(!t(p)){var v=e(r.minimumAlpha,0),y=e(r.maximumAlpha,1);p=v+i.nextRandomNumber()*(y-v)}return t(n)?(n.red=o,n.green=c,n.blue=h,n.alpha=p,n):new u(o,c,h,p)};var f=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(r){var n=u[r.toUpperCase()];if(t(n))return u.clone(n);var o=f.exec(r);return null!==o?new u(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(r),null!==o?new u(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(r),null!==o?new u(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(r),null!==o?u.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},u.packedLength=4,u.pack=function(t,r,n){n=e(n,0),r[n++]=t.red,r[n++]=t.green,r[n++]=t.blue,r[n]=t.alpha},u.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new u),o.red=r[n++],o.green=r[n++],o.blue=r[n++],o.alpha=r[n],o},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:0|256*e},u.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new u(e.red,e.green,e.blue,e.alpha):void 0},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},u.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),t=u.floatToByte(this.green),r=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},u.prototype.toBytes=function(e){var r=u.floatToByte(this.red),n=u.floatToByte(this.green),o=u.floatToByte(this.blue),i=u.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=n,e[2]=o,e[3]=i,e):[r,n,o,i]},u.prototype.toRgba=function(){return l[0]=u.floatToByte(this.red),l[1]=u.floatToByte(this.green),l[2]=u.floatToByte(this.blue),l[3]=u.floatToByte(this.alpha),c[0]},u.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},u.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},u.prototype.withAlpha=function(e,t){return u.fromAlpha(this,e,t)},u.ALICEBLUE=o(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=o(u.fromCssColorString("#FAEBD7")),u.AQUA=o(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=o(u.fromCssColorString("#7FFFD4")),u.AZURE=o(u.fromCssColorString("#F0FFFF")),u.BEIGE=o(u.fromCssColorString("#F5F5DC")),u.BISQUE=o(u.fromCssColorString("#FFE4C4")),u.BLACK=o(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=o(u.fromCssColorString("#FFEBCD")),u.BLUE=o(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=o(u.fromCssColorString("#8A2BE2")),u.BROWN=o(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=o(u.fromCssColorString("#DEB887")),u.CADETBLUE=o(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=o(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=o(u.fromCssColorString("#D2691E")),u.CORAL=o(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=o(u.fromCssColorString("#6495ED")),u.CORNSILK=o(u.fromCssColorString("#FFF8DC")),u.CRIMSON=o(u.fromCssColorString("#DC143C")),u.CYAN=o(u.fromCssColorString("#00FFFF")),u.DARKBLUE=o(u.fromCssColorString("#00008B")),u.DARKCYAN=o(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=o(u.fromCssColorString("#B8860B")),u.DARKGRAY=o(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=o(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=o(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=o(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=o(u.fromCssColorString("#556B2F")),u.DARKORANGE=o(u.fromCssColorString("#FF8C00")),u.DARKORCHID=o(u.fromCssColorString("#9932CC")),u.DARKRED=o(u.fromCssColorString("#8B0000")),u.DARKSALMON=o(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=o(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=o(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=o(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=o(u.fromCssColorString("#00CED1")),u.DARKVIOLET=o(u.fromCssColorString("#9400D3")),u.DEEPPINK=o(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=o(u.fromCssColorString("#00BFFF")),u.DIMGRAY=o(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=o(u.fromCssColorString("#1E90FF")),u.FIREBRICK=o(u.fromCssColorString("#B22222")),u.FLORALWHITE=o(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=o(u.fromCssColorString("#228B22")),u.FUSCHIA=o(u.fromCssColorString("#FF00FF")),u.GAINSBORO=o(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=o(u.fromCssColorString("#F8F8FF")),u.GOLD=o(u.fromCssColorString("#FFD700")),u.GOLDENROD=o(u.fromCssColorString("#DAA520")),u.GRAY=o(u.fromCssColorString("#808080")),u.GREEN=o(u.fromCssColorString("#008000")),u.GREENYELLOW=o(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=o(u.fromCssColorString("#F0FFF0")),u.HOTPINK=o(u.fromCssColorString("#FF69B4")),u.INDIANRED=o(u.fromCssColorString("#CD5C5C")),u.INDIGO=o(u.fromCssColorString("#4B0082")),u.IVORY=o(u.fromCssColorString("#FFFFF0")),u.KHAKI=o(u.fromCssColorString("#F0E68C")),u.LAVENDER=o(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=o(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=o(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=o(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=o(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=o(u.fromCssColorString("#F08080")),u.LIGHTCYAN=o(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=o(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=o(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=o(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=o(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=o(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=o(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=o(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=o(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=o(u.fromCssColorString("#FFFFE0")),u.LIME=o(u.fromCssColorString("#00FF00")),u.LIMEGREEN=o(u.fromCssColorString("#32CD32")),u.LINEN=o(u.fromCssColorString("#FAF0E6")),u.MAGENTA=o(u.fromCssColorString("#FF00FF")),u.MAROON=o(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=o(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=o(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=o(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=o(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=o(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=o(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=o(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=o(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=o(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=o(u.fromCssColorString("#191970")),u.MINTCREAM=o(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=o(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=o(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=o(u.fromCssColorString("#FFDEAD")),u.NAVY=o(u.fromCssColorString("#000080")),u.OLDLACE=o(u.fromCssColorString("#FDF5E6")),u.OLIVE=o(u.fromCssColorString("#808000")),u.OLIVEDRAB=o(u.fromCssColorString("#6B8E23")),u.ORANGE=o(u.fromCssColorString("#FFA500")),u.ORANGERED=o(u.fromCssColorString("#FF4500")),u.ORCHID=o(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=o(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=o(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=o(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=o(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=o(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=o(u.fromCssColorString("#FFDAB9")),u.PERU=o(u.fromCssColorString("#CD853F")),u.PINK=o(u.fromCssColorString("#FFC0CB")),u.PLUM=o(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=o(u.fromCssColorString("#B0E0E6")),u.PURPLE=o(u.fromCssColorString("#800080")),u.RED=o(u.fromCssColorString("#FF0000")),u.ROSYBROWN=o(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=o(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=o(u.fromCssColorString("#8B4513")),u.SALMON=o(u.fromCssColorString("#FA8072")),u.SANDYBROWN=o(u.fromCssColorString("#F4A460")),u.SEAGREEN=o(u.fromCssColorString("#2E8B57")),u.SEASHELL=o(u.fromCssColorString("#FFF5EE")),u.SIENNA=o(u.fromCssColorString("#A0522D")),u.SILVER=o(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=o(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=o(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=o(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=o(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=o(u.fromCssColorString("#00FF7F")),u.STEELBLUE=o(u.fromCssColorString("#4682B4")),u.TAN=o(u.fromCssColorString("#D2B48C")),u.TEAL=o(u.fromCssColorString("#008080")),u.THISTLE=o(u.fromCssColorString("#D8BFD8")),u.TOMATO=o(u.fromCssColorString("#FF6347")),u.TURQUOISE=o(u.fromCssColorString("#40E0D0")),u.VIOLET=o(u.fromCssColorString("#EE82EE")),u.WHEAT=o(u.fromCssColorString("#F5DEB3")),u.WHITE=o(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=o(u.fromCssColorString("#F5F5F5")),u.YELLOW=o(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=o(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=o(new u(0,0,0,0)),u
}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,o){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(t,n,o,a){switch(o=e(o,0),a=e(a,(n.byteLength-o)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(n,o,a);case i.UNSIGNED_BYTE:return new Uint8Array(n,o,a);case i.SHORT:return new Int16Array(n,o,a);case i.UNSIGNED_SHORT:return new Uint16Array(n,o,a);case i.FLOAT:return new Float32Array(n,o,a);case i.DOUBLE:return new Float64Array(n,o,a);default:throw new r("componentDatatype is not a valid value.")}},o(i)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,o){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,o.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var o in e.attributes)if(e.attributes.hasOwnProperty(o)&&t(e.attributes[o])&&t(e.attributes[o].values)){var i=e.attributes[o],a=i.values.length/i.componentsPerAttribute;if(n!==a&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=a}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,o){return n=e(n,0),t(o)||(o=new i),o.x=r[n++],o.y=r[n],o},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var a=new i;i.distance=function(e,t){return i.subtract(e,t,a),i.magnitude(a)},i.distanceSquared=function(e,t){return i.subtract(e,t,a),i.magnitudeSquared(a)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),o.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&o.equalsEpsilon(e.x,r.x,n,i)&&o.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,o){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*o.signNotZero(r),t.y=(1-Math.abs(r))*o.signNotZero(n)}return t.x=o.toSNorm(t.x),t.y=o.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=o.fromSNorm(e),n.y=o.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*o.signNotZero(i),n.y=(1-Math.abs(i))*o.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var a=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,a),i.octPackFloat(a)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),o=256*(r-n);return i.octDecode(n,o,t)},i.octPack=function(e,t,r,n){var o=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,a);return n.x=65536*s.x+o,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var o=e.x/65536,a=Math.floor(o),u=65536*(o-a);o=e.y/65536;var s=Math.floor(o),c=65536*(o-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(a,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:0|4096*e.x,r=1===e.y?4095:0|4096*e.y;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=new t,o=new t,i=new t,a=function(a,u,s,c,l){r(l)||(l=new t);var f,h,m,d,p,v,y,g;r(u.z)?(f=t.subtract(s,u,n),h=t.subtract(c,u,o),m=t.subtract(a,u,i),d=t.dot(f,f),p=t.dot(f,h),v=t.dot(f,m),y=t.dot(h,h),g=t.dot(h,m)):(f=e.subtract(s,u,n),h=e.subtract(c,u,o),m=e.subtract(a,u,i),d=e.dot(f,f),p=e.dot(f,h),v=e.dot(f,m),y=e.dot(h,h),g=e.dot(h,m));var E=1/(d*y-p*p);return l.y=(y*v-p*g)*E,l.z=(d*g-p*v)*E,l.x=1-l.y-l.z,l};return a}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};r.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var n={high:0,low:0};r.fromCartesian=function(e,o){t(o)||(o=new r);var i=o.high,a=o.low;return r.encode(e.x,n),i.x=n.high,a.x=n.low,r.encode(e.y,n),i.y=n.high,a.y=n.low,r.encode(e.z,n),i.z=n.high,a.z=n.low,o};var o=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,o);var i=o.high,a=o.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=a.x,t[n+4]=a.y,t[n+5]=a.z},r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var o=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return o}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n){"use strict";var o={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},o.validate=function(t){return e(t)&&(t===o.UNSIGNED_BYTE||t===o.UNSIGNED_SHORT||t===o.UNSIGNED_INT)},o.createTypedArray=function(e,t){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},o.createTypedArrayFromArrayBuffer=function(e,t,r,o){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,o):new Uint16Array(t,r,o)},r(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,o){var i;if(0===e)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var a=Math.abs(o),u=Math.abs(e);if(u>a&&a/u<t.EPSILON14)return[0,0];if(a>u&&u/a<t.EPSILON14)return[];if(i=-o/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===o)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*o,f=r(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[h/e,o/h]:[o/h,h/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var o,i,a=e,u=t/3,s=r/3,c=n,l=a*s,f=u*c,h=u*u,m=s*s,d=a*s-h,p=a*c-u*s,v=u*c-m,y=4*d*v-p*p;if(0>y){var g,E,S;h*f>=l*m?(g=a,E=d,S=-2*u*d+a*p):(g=c,E=v,S=-c*p+2*s*v);var C=0>S?-1:1,w=-C*Math.abs(g)*Math.sqrt(-y);i=-S+w;var b=i/2,x=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),A=i===w?-x:-E/x;return o=0>=E?x+A:-S/(x*x+A*A+E),h*f>=l*m?[(o-u)/a]:[-c/(o+s)]}var T=d,M=-2*u*d+a*p,I=v,O=-c*p+2*s*v,R=Math.sqrt(y),N=Math.sqrt(3)/2,L=Math.abs(Math.atan2(a*R,-M)/3);o=2*Math.sqrt(-T);var P=Math.cos(L);i=o*P;var z=o*(-P/2-N*Math.sin(L)),D=i+z>2*u?i-u:z-u,F=a,_=D/F;L=Math.abs(Math.atan2(c*R,-O)/3),o=2*Math.sqrt(-I),P=Math.cos(L),i=o*P,z=o*(-P/2-N*Math.sin(L));var B=-c,U=2*s>i+z?i+s:z+s,G=B/U,q=F*U,k=-D*U-F*B,V=D*B,W=(s*k-u*V)/(-u*k+s*q);return W>=_?G>=_?G>=W?[_,W,G]:[_,G,W]:[G,_,W]:G>=_?[W,_,G]:G>=W?[W,G,_]:[G,W,_]}var n={};return n.computeDiscriminant=function(e,t,r,n){var o=e*e,i=t*t,a=r*r,u=n*n,s=18*e*t*r*n+i*a-27*o*u-4*(e*a*r+i*t*n);return s},n.computeRealRoots=function(e,n,o,i){var a,u;if(0===e)return t.computeRealRoots(n,o,i);if(0===n){if(0===o){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(a=t.computeRealRoots(e,0,o),0===a.Length?[0]:[a[0],0,a[1]]):r(e,0,o,i)}return 0===o?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(a=t.computeRealRoots(e,n,o),0===a.length?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]):r(e,n,o,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function o(t,o,i,a){var u=t*t,s=o-3*u/8,c=i-o*t/2+u*t/8,l=a-i*t/4+o*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,m=f[f.length-1];if(Math.abs(m)<r.EPSILON14){var d=n.computeRealRoots(1,s,l);if(2===d.length){var p,v=d[0],y=d[1];if(v>=0&&y>=0){var g=Math.sqrt(v),E=Math.sqrt(y);return[h-E,h-g,h+g,h+E]}if(v>=0&&0>y)return p=Math.sqrt(v),[h-p,h+p];if(0>v&&y>=0)return p=Math.sqrt(y),[h-p,h+p]}return[]}if(m>0){var S=Math.sqrt(m),C=(s+m-c/S)/2,w=(s+m+c/S)/2,b=n.computeRealRoots(1,S,C),x=n.computeRealRoots(1,-S,w);return 0!==b.length?(b[0]+=h,b[1]+=h,0!==x.length?(x[0]+=h,x[1]+=h,b[1]<=x[0]?[b[0],b[1],x[0],x[1]]:x[1]<=b[0]?[x[0],x[1],b[0],b[1]]:b[0]>=x[0]&&b[1]<=x[1]?[x[0],b[0],b[1],x[1]]:x[0]>=b[0]&&x[1]<=b[1]?[b[0],x[0],x[1],b[1]]:b[0]>x[0]&&b[0]<x[1]?[x[0],b[0],x[1],b[1]]:[b[0],x[0],b[1],x[1]]):b):0!==x.length?(x[0]+=h,x[1]+=h,x):[]}}return[]}function i(t,o,i,a){var u=i*i,s=o*o,c=t*t,l=-2*o,f=i*t+s-4*a,h=c*a-i*o*t+u,m=e.computeRealRoots(1,l,f,h);if(m.length>0){var d,p,v=m[0],y=o-v,g=y*y,E=t/2,S=y/2,C=g-4*a,w=g+4*Math.abs(a),b=c-4*v,x=c+4*Math.abs(v);if(0>v||b*w>C*x){var A=Math.sqrt(b);d=A/2,p=0===A?0:(t*S-i)/A}else{var T=Math.sqrt(C);d=0===T?0:(t*S-i)/T,p=T/2}var M,I;0===E&&0===d?(M=0,I=0):r.sign(E)===r.sign(d)?(M=E+d,I=v/M):(I=E-d,M=v/I);var O,R;0===S&&0===p?(O=0,R=0):r.sign(S)===r.sign(p)?(O=S+p,R=a/O):(R=S-p,O=a/R);var N=n.computeRealRoots(1,M,O),L=n.computeRealRoots(1,I,R);if(0!==N.length)return 0!==L.length?N[1]<=L[0]?[N[0],N[1],L[0],L[1]]:L[1]<=N[0]?[L[0],L[1],N[0],N[1]]:N[0]>=L[0]&&N[1]<=L[1]?[L[0],N[0],N[1],L[1]]:L[0]>=N[0]&&L[1]<=N[1]?[N[0],L[0],L[1],N[1]]:N[0]>L[0]&&N[0]<L[1]?[L[0],N[0],L[1],N[1]]:[N[0],L[0],N[1],L[1]]:N;if(0!==L.length)return L}return[]}var a={};return a.computeDiscriminant=function(e,t,r,n,o){var i=e*e,a=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,h=f*n,m=o*o,d=m*o,p=u*c*f-4*s*h-4*e*l*f+18*e*t*r*h-27*i*f*f+256*a*d+o*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+m*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return p},a.computeRealRoots=function(t,n,a,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,a,u,s);var c=n/t,l=a/t,f=u/t,h=s/t,m=0>c?1:0;switch(m+=0>l?m+1:m,m+=0>f?m+1:m,m+=0>h?m+1:m){case 0:return o(c,l,f,h);case 1:return i(c,l,f,h);case 2:return i(c,l,f,h);case 3:return o(c,l,f,h);case 4:return o(c,l,f,h);case 5:return i(c,l,f,h);case 6:return o(c,l,f,h);case 7:return o(c,l,f,h);case 8:return i(c,l,f,h);case 9:return o(c,l,f,h);case 10:return o(c,l,f,h);case 11:return i(c,l,f,h);case 12:return o(c,l,f,h);case 13:return o(c,l,f,h);case 14:return o(c,l,f,h);case 15:return o(c,l,f,h);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return n.getPoint=function(t,n,o){return r(o)||(o=new e),o=e.multiplyByScalar(t.direction,n,o),e.add(t.origin,o,o)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,o,i,a,u,s,c){"use strict";function l(t,n,o,a,u){u=r(u,!1);var s,c,l,f,h,m=t.origin,d=t.direction,p=e.subtract(o,n,v),C=e.subtract(a,n,y),w=e.cross(d,C,g),b=e.dot(p,w);if(u){if(b<i.EPSILON6)return void 0;if(s=e.subtract(m,n,E),l=e.dot(s,w),0>l||l>b)return void 0;if(c=e.cross(s,p,S),f=e.dot(d,c),0>f||l+f>b)return void 0;h=e.dot(C,c)/b}else{if(Math.abs(b)<i.EPSILON6)return void 0;var x=1/b;if(s=e.subtract(m,n,E),l=e.dot(s,w)*x,0>l||l>1)return void 0;if(c=e.cross(s,p,S),f=e.dot(d,c)*x,0>f||l+f>1)return void 0;h=e.dot(C,c)*x}return h}function f(e,t,r,n){var o=t*t-4*e*r;if(0>o)return void 0;if(o>0){var i=1/(2*e),a=Math.sqrt(o),u=(-t+a)*i,s=(-t-a)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function h(t,r,o){n(o)||(o={});var i=t.origin,a=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,g),l=e.dot(a,a),h=2*e.dot(a,c),m=e.magnitudeSquared(c)-s,d=f(l,h,m,w);return n(d)?(o.start=d.root0,o.stop=d.root1,o):void 0}function m(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function d(t,r,n,o,c){var l,f=o*o,h=c*c,d=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*h,p=c*(o*m(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],i.EPSILON15)+r.y),v=t[a.COLUMN0ROW0]*f+t[a.COLUMN2ROW2]*h+o*r.x+n,y=h*m(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],i.EPSILON15),g=c*(o*m(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),E=[];if(0===g&&0===y){if(l=u.computeRealRoots(d,p,v),0===l.length)return E;var S=l[0],C=Math.sqrt(Math.max(1-S*S,0));if(E.push(new e(o,c*S,c*-C)),E.push(new e(o,c*S,c*C)),2===l.length){var w=l[1],b=Math.sqrt(Math.max(1-w*w,0));E.push(new e(o,c*w,c*-b)),E.push(new e(o,c*w,c*b))}return E}var x=g*g,A=y*y,T=d*d,M=g*y,I=T+A,O=2*(p*d+M),R=2*v*d+p*p-A+x,N=2*(v*p-M),L=v*v-x;if(0===I&&0===O&&0===R&&0===N)return E;l=s.computeRealRoots(I,O,R,N,L);var P=l.length;if(0===P)return E;for(var z=0;P>z;++z){var D,F=l[z],_=F*F,B=Math.max(1-_,0),U=Math.sqrt(B);D=i.sign(d)===i.sign(v)?m(d*_+v,p*F,i.EPSILON12):i.sign(v)===i.sign(p*F)?m(d*_,p*F+v,i.EPSILON12):m(d*_+p*F,v,i.EPSILON12);var G=m(y*F,g,i.EPSILON15),q=D*G;0>q?E.push(new e(o,c*F,c*U)):q>0?E.push(new e(o,c*F,c*-U)):0!==U?(E.push(new e(o,c*F,c*-U)),E.push(new e(o,c*F,c*U)),++z):E.push(new e(o,c*F,c*U))}return E}var p={};p.rayPlane=function(t,r,o){n(o)||(o=new e);var a=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,a))/c;return 0>l?void 0:(o=e.multiplyByScalar(u,l,o),e.add(a,o,o))};var v=new e,y=new e,g=new e,E=new e,S=new e;p.rayTriangle=function(t,r,o,i,a,u){var s=l(t,r,o,i,a);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var C=new c;p.lineSegmentTriangle=function(t,r,o,i,a,u,s){var c=C;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,o,i,a,u);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var w={root0:0,root1:0};p.raySphere=function(e,t,r){return r=h(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var b=new c;p.lineSegmentSphere=function(t,r,o,i){var a=b;e.clone(t,a.origin);var u=e.subtract(r,t,a.direction),s=e.magnitude(u);return e.normalize(u,u),i=h(a,o,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var x=new e,A=new e;p.rayEllipsoid=function(t,r){var n,o,i,a,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,x),l=e.multiplyComponents(s,t.direction,A),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return void 0;var m=h*h;if(n=f-1,o=e.magnitudeSquared(l),i=o*n,i>m)return void 0;if(m>i){a=h*h-i,u=-h+Math.sqrt(a);var d=u/o,p=n/u;return p>d?{start:d,stop:p}:{start:p,stop:d}}var v=Math.sqrt(n/o);return{start:v,stop:v}}return 1>f?(n=f-1,o=e.magnitudeSquared(l),i=o*n,a=h*h-i,u=-h+Math.sqrt(a),{start:0,stop:u/o}):0>h?(o=e.magnitudeSquared(l),{start:0,stop:-h/o}):void 0};var T=new e,M=new e,I=new e,O=new e,R=new e,N=new a,L=new a,P=new a,z=new a,D=new a,F=new a,_=new a,B=new e,U=new e,G=new t;p.grazingAltitudeLocation=function(t,r){var o=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(o,T);if(e.dot(u,s)>=0)return o;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,T),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,O),m=e.normalize(e.cross(h,f,M),M),p=e.normalize(e.cross(f,m,I),I),v=N;v[0]=f.x,v[1]=f.y,v[2]=f.z,v[3]=m.x,v[4]=m.y,v[5]=m.z,v[6]=p.x,v[7]=p.y,v[8]=p.z;var y=a.transpose(v,L),g=a.fromScale(r.radii,P),E=a.fromScale(r.oneOverRadii,z),S=D;S[0]=0,S[1]=-u.z,S[2]=u.y,S[3]=u.z,S[4]=0,S[5]=-u.x,S[6]=-u.y,S[7]=u.x,S[8]=0;var C,w,b=a.multiply(a.multiply(y,E,F),S,F),x=a.multiply(a.multiply(b,g,_),v,_),A=a.multiplyByVector(b,o,R),q=d(x,e.negate(A,T),0,0,1),k=q.length;if(k>0){for(var V=e.clone(e.ZERO,U),W=Number.NEGATIVE_INFINITY,Y=0;k>Y;++Y){C=a.multiplyByVector(g,a.multiplyByVector(v,q[Y],B),B);var H=e.normalize(e.subtract(C,o,O),O),j=e.dot(H,u);j>W&&(W=j,V=e.clone(C,V))}var K=r.cartesianToCartographic(V,G);return W=i.clamp(W,0,1),w=e.magnitude(e.subtract(V,o,O))*Math.sqrt(1-W*W),w=c?-w:w,K.height=w,r.cartographicToCartesian(K,new e)}return void 0};var q=new e;return p.lineSegmentPlane=function(t,r,o,a){n(a)||(a=new e);var u=e.subtract(r,t,q),s=o.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),f=-(o.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(u,f,a),e.add(t,a,a),a)},p.trianglePlaneIntersection=function(t,r,n,o){var i=o.normal,a=o.distance,u=e.dot(i,t)+a<0,s=e.dot(i,r)+a<0,c=e.dot(i,n)+a<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return p.lineSegmentPlane(t,r,o,f),p.lineSegmentPlane(t,n,o,h),{positions:[t,r,n,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return p.lineSegmentPlane(r,n,o,f),p.lineSegmentPlane(r,t,o,h),{positions:[t,r,n,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(n,t,o,f),p.lineSegmentPlane(n,r,o,h),{positions:[t,r,n,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return p.lineSegmentPlane(r,t,o,f),p.lineSegmentPlane(n,t,o,h),{positions:[t,r,n,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return p.lineSegmentPlane(n,r,o,f),p.lineSegmentPlane(t,r,o,h),{positions:[t,r,n,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,n,o,f),p.lineSegmentPlane(r,n,o,h),{positions:[t,r,n,f,h],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},p}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(t,r){this.normal=e.clone(t),this.distance=r};return r.fromPointNormal=function(n,o,i){var a=-e.dot(o,n);return t(i)?(e.clone(o,i.normal),i.distance=a,i):new r(o,a)},r.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},r}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};return r.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,o=r.maximumIndex,i=e(r.cacheSize,24),a=n.length;if(!t(o)){o=0;for(var u=0,s=n[u];a>u;)s>o&&(o=s),++u,s=n[u]}for(var c=[],l=0;o+1>l;l++)c[l]=0;for(var f=i+1,h=0;a>h;++h)f-c[n[h]]>i&&(c[n[h]]=f,++f);return(f-i+1)/(a/3)},r.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var o=t[t.length-1];if(t.splice(t.length-1,1),e[o].numLiveTriangles>0)return o}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function o(e,t,r,o,i,a,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var h=r[f];o[h].numLiveTriangles&&(s=0,i-o[h].timeStamp+2*o[h].numLiveTriangles<=t&&(s=i-o[h].timeStamp),(s>l||-1===l)&&(l=s,c=h)),++f}return-1===c?n(o,a,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,a=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=a.length,l=0,f=0,h=a[f],m=c;if(t(u))l=u+1;else{for(;m>f;)h>l&&(l=h),++f,h=a[f];if(-1===l)return 0;++l}for(var d=[],p=0;l>p;p++)d[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var v=0;m>f;)d[a[f]].vertexTriangles.push(v),++d[a[f]].numLiveTriangles,d[a[f+1]].vertexTriangles.push(v),++d[a[f+1]].numLiveTriangles,d[a[f+2]].vertexTriangles.push(v),++d[a[f+2]].numLiveTriangles,++v,f+=3;var y=0,g=s+1;i=1;var E,S,C=[],w=[],b=0,x=[],A=c/3,T=[];for(p=0;A>p;p++)T[p]=!1;for(var M,I;-1!==y;){C=[],S=d[y],I=S.vertexTriangles.length;for(var O=0;I>O;++O)if(v=S.vertexTriangles[O],!T[v]){T[v]=!0,f=v+v+v;for(var R=0;3>R;++R)M=a[f],C.push(M),w.push(M),x[b]=M,++b,E=d[M],--E.numLiveTriangles,g-E.timeStamp>s&&(E.timeStamp=g,++g),++f}y=o(a,s,C,d,g,w,l)}return x},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,o,i,a,u,s,c,l,f,h,m,d,p,v,y,g,E,S,C,w,b,x,A){"use strict";function T(e,t,r,n,o){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=o,e[t++]=o,e[t]=r}function M(e){for(var t=e.length,r=6*(t/3),n=y.createTypedArray(t,r),o=0,i=0;t>i;i+=3,o+=6)T(n,o,e[i],e[i+1],e[i+2]);return n}function I(e){var t=e.length;if(t>=3){var r=6*(t-2),n=y.createTypedArray(t,r);T(n,0,e[0],e[1],e[2]);for(var o=6,i=3;t>i;++i,o+=6)T(n,o,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=y.createTypedArray(t,r),o=e[0],i=0,a=1;t>a;++a,i+=6)T(n,i,o,e[a],e[a+1]);return n}return new Uint16Array}function R(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function N(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var o=t[n],i=0;i<o.componentsPerAttribute;++i)e[n].values.push(o.values[r*o.componentsPerAttribute+i])}function L(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,it),w.multiplyByPoint(e,it,it),o.pack(it,r,i)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)o.unpack(r,i,it),C.multiplyByVector(e,it,it),it=o.normalize(it,it),o.pack(it,r,i)}function z(e,t){var r,n=e.length,o={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var a=i[r],s=a.values.length,l=!0,f=1;n>f;++f){var h=e[f][t].attributes[r];if(!c(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(o[r]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return o}function D(e,t){var n,i,a,u,s=e.length;e[0].modelMatrix;var l,f,h,d=c(e[0][t].indices),p=e[0][t].primitiveType,v=z(e,t);for(n in v)if(v.hasOwnProperty(n))for(l=v[n].values,u=0,i=0;s>i;++i)for(f=e[i][t].attributes[n].values,h=f.length,a=0;h>a;++a)l[u++]=f[a];var g;if(d){var E=0;for(i=0;s>i;++i)E+=e[i][t].indices.length;var S=m.computeNumberOfVertices(new m({attributes:v,primitiveType:x.POINTS})),C=y.createTypedArray(S,E),w=0,b=0;for(i=0;s>i;++i){var A=e[i][t].indices,T=A.length;for(u=0;T>u;++u)C[w++]=b+A[u];b+=m.computeNumberOfVertices(e[i][t])}g=C}var M,I=new o,O=0;for(i=0;s>i;++i){if(M=e[i][t].boundingSphere,!c(M)){I=void 0;break}o.add(M.center,I,I)}if(c(I))for(o.divideByScalar(I,s,I),i=0;s>i;++i){M=e[i][t].boundingSphere;var R=o.magnitude(o.subtract(M.center,I,st))+M.radius;R>O&&(O=R)}return new m({attributes:v,indices:g,primitiveType:p,boundingSphere:c(I)?new r(I,O):void 0})}function F(e){if(c(e.indices))return e;for(var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function _(e){var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,o=3;t>o;++o)r[n++]=o-1,r[n++]=0,r[n++]=o;return e.indices=r,e.primitiveType=x.TRIANGLES,e}function B(e){var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,o=3;t-1>o;o+=2)r[n++]=o,r[n++]=o-1,r[n++]=o+1,t>o+2&&(r[n++]=o,r[n++]=o+1,r[n++]=o+2);return e.indices=r,e.primitiveType=x.TRIANGLES,e}function U(e){if(c(e.indices))return e;for(var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function G(e){var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return e.indices=r,e.primitiveType=x.LINES,e}function q(e){var t=m.computeNumberOfVertices(e),r=y.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,o=2;t>o;++o)r[n++]=o-1,r[n++]=o;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=x.LINES,e}function k(e){switch(e.primitiveType){case x.TRIANGLE_FAN:return _(e);case x.TRIANGLE_STRIP:return B(e);case x.TRIANGLES:return F(e);case x.LINE_STRIP:return G(e);case x.LINE_LOOP:return q(e);case x.LINES:return U(e)}return e}function V(e,t){Math.abs(e.y)<S.EPSILON6&&(e.y=t?-S.EPSILON6:S.EPSILON6)}function W(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return V(e,e.y<0),V(t,t.y<0),V(r,r.y<0),void 0;var n,o=Math.abs(e.y),i=Math.abs(t.y),a=Math.abs(r.y);n=o>i?o>a?S.sign(e.y):S.sign(r.y):i>a?S.sign(t.y):S.sign(r.y);var u=0>n;V(e,u),V(t,u),V(r,u)}function Y(e,t,r,n){o.add(e,o.multiplyByScalar(o.subtract(t,e,St),e.y/(e.y-t.y),St),r),o.clone(r,n),V(r,!0),V(n,!1)}function H(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;W(e,t,r);var n=e.y<0,o=t.y<0,i=r.y<0,a=0;a+=n?1:0,a+=o?1:0,a+=i?1:0;var u=At.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(Y(e,t,Ct,bt),Y(e,r,wt,xt),u[0]=0,u[3]=1,u[4]=2,u[6]=1):o?(Y(t,r,Ct,bt),Y(t,e,wt,xt),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(Y(r,e,Ct,bt),Y(r,t,wt,xt),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?o?i||(Y(r,e,Ct,bt),Y(r,t,wt,xt),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(Y(t,r,Ct,bt),Y(t,e,wt,xt),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(Y(e,t,Ct,bt),Y(e,r,wt,xt),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=At.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===a||2===a)&&(s[3]=Ct,s[4]=wt,s[5]=bt,s[6]=xt,s.length=7),At}function j(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var o in n)if(n.hasOwnProperty(o)&&c(n[o])&&c(n[o].values)){var i=n[o];i.values=u.createTypedArray(i.componentDatatype,i.values)}var a=m.computeNumberOfVertices(e);return e.indices=y.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function K(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var o=t[n];r[n]=new d({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return new m({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var n=c(e.geometry.boundingSphere);t=j(t,n),r=j(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function X(e,r,i,a,u,s,l,f,h,m,d){if(c(s)||c(l)||c(f)||c(h)){var p=o.fromArray(u,3*e,Tt),v=o.fromArray(u,3*r,Mt),y=o.fromArray(u,3*i,It),g=t(a,p,v,y,Ot);if(c(s)){var E=o.fromArray(s,3*e,Tt),S=o.fromArray(s,3*r,Mt),C=o.fromArray(s,3*i,It);o.multiplyByScalar(E,g.x,E),o.multiplyByScalar(S,g.y,S),o.multiplyByScalar(C,g.z,C);var w=o.add(E,S,E);o.add(w,C,w),o.normalize(w,w),o.pack(w,m.normal.values,3*d)}if(c(l)){var b=o.fromArray(l,3*e,Tt),x=o.fromArray(l,3*r,Mt),A=o.fromArray(l,3*i,It);o.multiplyByScalar(b,g.x,b),o.multiplyByScalar(x,g.y,x),o.multiplyByScalar(A,g.z,A);var T=o.add(b,x,b);o.add(T,A,T),o.normalize(T,T),o.pack(T,m.binormal.values,3*d)}if(c(f)){var M=o.fromArray(f,3*e,Tt),I=o.fromArray(f,3*r,Mt),O=o.fromArray(f,3*i,It);o.multiplyByScalar(M,g.x,M),o.multiplyByScalar(I,g.y,I),o.multiplyByScalar(O,g.z,O);var R=o.add(M,I,M);o.add(R,O,R),o.normalize(R,R),o.pack(R,m.tangent.values,3*d)}if(c(h)){var N=n.fromArray(h,2*e,Rt),L=n.fromArray(h,2*r,Nt),P=n.fromArray(h,2*i,Lt);n.multiplyByScalar(N,g.x,N),n.multiplyByScalar(L,g.y,L),n.multiplyByScalar(P,g.z,P);var z=n.add(N,L,N);n.add(z,P,z),n.pack(z,m.st.values,2*d)}}}function Q(e,t,r,n,o,i){var a=e.position.values.length/3;
if(-1!==o){var u=n[o],s=r[u];return-1===s?(r[u]=a,e.position.values.push(i.x,i.y,i.z),t.push(a),a):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(a),a}function J(e){var t,r,n,i,a,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,h=c(s.binormal)?s.binormal.values:void 0,m=c(s.tangent)?s.tangent.values:void 0,d=c(s.st)?s.st.values:void 0,p=u.indices,v=K(u),y=K(u),g=[];g.length=l.length/3;var E=[];for(E.length=l.length/3,a=0;a<g.length;++a)g[a]=-1,E[a]=-1;var S=p.length;for(a=0;S>a;a+=3){var C=p[a],w=p[a+1],b=p[a+2],x=o.fromArray(l,3*C),A=o.fromArray(l,3*w),T=o.fromArray(l,3*b),M=H(x,A,T);if(c(M)&&M.positions.length>3)for(var I=M.positions,O=M.indices,R=O.length,N=0;R>N;++N){var L=O[N],P=I[L];P.y<0?(t=y.attributes,r=y.indices,n=g):(t=v.attributes,r=v.indices,n=E),i=Q(t,r,n,p,3>L?a+L:-1,P),X(C,w,b,P,l,f,h,m,d,t,i)}else c(M)&&(x=M.positions[0],A=M.positions[1],T=M.positions[2]),x.y<0?(t=y.attributes,r=y.indices,n=g):(t=v.attributes,r=v.indices,n=E),i=Q(t,r,n,p,a,x),X(C,w,b,x,l,f,h,m,d,t,i),i=Q(t,r,n,p,a+1,A),X(C,w,b,A,l,f,h,m,d,t,i),i=Q(t,r,n,p,a+2,T),X(C,w,b,T,l,f,h,m,d,t,i)}Z(e,y,v)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,a=r.indices,u=K(r),s=K(r),l=a.length,f=[];f.length=i.length/3;var h=[];for(h.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,h[t]=-1;for(t=0;l>t;t+=2){var m=a[t],d=a[t+1],p=o.fromArray(i,3*m,Tt),v=o.fromArray(i,3*d,Mt);Math.abs(p.y)<S.EPSILON6&&(p.y=p.y<0?-S.EPSILON6:S.EPSILON6),Math.abs(v.y)<S.EPSILON6&&(v.y=v.y<0?-S.EPSILON6:S.EPSILON6);var y=u.attributes,g=u.indices,C=h,w=s.attributes,b=s.indices,x=f,A=E.lineSegmentPlane(p,v,Pt,It);if(c(A)){var T=o.multiplyByScalar(o.UNIT_Y,5*S.EPSILON9,zt);p.y<0&&(o.negate(T,T),y=s.attributes,g=s.indices,C=f,w=u.attributes,b=u.indices,x=h);var M=o.add(A,T,Dt);Q(y,g,C,a,t,p),Q(y,g,C,a,-1,M),o.negate(T,T),o.add(A,T,M),Q(w,b,x,a,-1,M),Q(w,b,x,a,t+1,v)}else{var I,O,R;p.y<0?(I=s.attributes,O=s.indices,R=f):(I=u.attributes,O=u.indices,R=h),Q(I,O,R,a,t,p),Q(I,O,R,a,t+1,v)}}Z(e,s,u)}function et(e){var t=e.geometry,r=t.attributes,a=r.position.values,u=r.prevPosition.values,s=r.nextPosition.values,l=r.expandAndWidth.values;t.indices;var f,h,m,d=c(r.st)?r.st.values:void 0,p=c(r.color)?r.color.values:void 0,v=K(t),y=K(t),g=a.length/3;for(f=0;g>f;f+=4){var C=f,w=f+1,b=f+2,x=f+3,A=o.fromArray(a,3*C,Bt),T=o.fromArray(a,3*w,Ut),M=o.fromArray(a,3*b,Gt),I=o.fromArray(a,3*x,qt);Math.abs(A.y)<S.EPSILON6&&(A.y=S.EPSILON6*(M.y<0?-1:1),T.y=A.y),Math.abs(M.y)<S.EPSILON6&&(M.y=S.EPSILON6*(A.y<0?-1:1),I.y=M.y);var O=v.attributes,R=v.indices,N=y.attributes,L=y.indices,P=E.lineSegmentPlane(A,M,Pt,kt);if(c(P)){var z=o.multiplyByScalar(o.UNIT_Y,5*S.EPSILON9,Vt);A.y<0&&(o.negate(z,z),O=y.attributes,R=y.indices,N=v.attributes,L=v.indices);var D=o.add(P,z,Wt);for(O.position.values.push(A.x,A.y,A.z,T.x,T.y,T.z),O.position.values.push(D.x,D.y,D.z),O.position.values.push(D.x,D.y,D.z),o.negate(z,z),o.add(P,z,D),N.position.values.push(D.x,D.y,D.z),N.position.values.push(D.x,D.y,D.z),N.position.values.push(M.x,M.y,M.z,I.x,I.y,I.z),h=3*C;3*C+6>h;++h)O.prevPosition.values.push(u[h]);for(O.prevPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),N.prevPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),h=3*b;3*b+6>h;++h)N.prevPosition.values.push(u[h]);for(h=3*C;3*C+6>h;++h)O.nextPosition.values.push(s[h]);for(O.nextPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),N.nextPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),h=3*b;3*b+6>h;++h)N.nextPosition.values.push(s[h]);var F=n.fromArray(l,2*C,Ft),_=Math.abs(F.y);O.expandAndWidth.values.push(-1,_,1,_),O.expandAndWidth.values.push(-1,-_,1,-_),N.expandAndWidth.values.push(-1,_,1,_),N.expandAndWidth.values.push(-1,-_,1,-_);var B=o.magnitudeSquared(o.subtract(P,A,qt));if(B/=o.magnitudeSquared(o.subtract(M,A,qt)),c(p)){var U=i.fromArray(p,4*C,Yt),G=i.fromArray(p,4*b,Yt),q=S.lerp(U.x,G.x,B),k=S.lerp(U.y,G.y,B),V=S.lerp(U.z,G.z,B),W=S.lerp(U.w,G.w,B);for(h=4*C;4*C+8>h;++h)O.color.values.push(p[h]);for(O.color.values.push(q,k,V,W),O.color.values.push(q,k,V,W),N.color.values.push(q,k,V,W),N.color.values.push(q,k,V,W),h=4*b;4*b+8>h;++h)N.color.values.push(p[h])}if(c(d)){var Y=n.fromArray(d,2*C,Ft),H=n.fromArray(d,2*(f+3),_t),j=S.lerp(Y.x,H.x,B);for(h=2*C;2*C+4>h;++h)O.st.values.push(d[h]);for(O.st.values.push(j,Y.y),O.st.values.push(j,H.y),N.st.values.push(j,Y.y),N.st.values.push(j,H.y),h=2*b;2*b+4>h;++h)N.st.values.push(d[h])}m=O.position.values.length/3-4,R.push(m,m+2,m+1),R.push(m+1,m+2,m+3),m=N.position.values.length/3-4,L.push(m,m+2,m+1),L.push(m+1,m+2,m+3)}else{var X,Q;for(A.y<0?(X=y.attributes,Q=y.indices):(X=v.attributes,Q=v.indices),X.position.values.push(A.x,A.y,A.z),X.position.values.push(T.x,T.y,T.z),X.position.values.push(M.x,M.y,M.z),X.position.values.push(I.x,I.y,I.z),h=3*f;3*f+12>h;++h)X.prevPosition.values.push(u[h]),X.nextPosition.values.push(s[h]);for(h=2*f;2*f+8>h;++h)X.expandAndWidth.values.push(l[h]),c(d)&&X.st.values.push(d[h]);if(c(p))for(h=4*f;4*f+16>h;++h)X.color.values.push(p[h]);m=X.position.values.length/3-4,Q.push(m,m+2,m+1),Q.push(m+1,m+2,m+3)}}Z(e,y,v)}var tt={};tt.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case x.TRIANGLES:e.indices=M(t);break;case x.TRIANGLE_STRIP:e.indices=I(t);break;case x.TRIANGLE_FAN:e.indices=O(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=x.LINES}return e},tt.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var o=e.attributes.position.values,i=e.attributes[t].values,a=o.length,l=new Float64Array(2*a),f=0,h=0;a>h;h+=3)l[f++]=o[h],l[f++]=o[h+1],l[f++]=o[h+2],l[f++]=o[h]+i[h]*n,l[f++]=o[h+1]+i[h+1]*n,l[f++]=o[h+2]+i[h+2]*n;var p,v=e.boundingSphere;return c(v)&&(p=new r(v.center,v.radius+n)),new m({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:x.LINES,boundingSphere:p})},tt.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,o={},i=0,a=r.length;for(t=0;a>t;++t){var u=r[t];c(n[u])&&(o[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(o[s])&&(o[s]=i++);return o},tt.reorderForPreVertexCache=function(e){var t=m.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),o=0;t>o;o++)n[o]=-1;for(var i,a=r,s=a.length,l=y.createTypedArray(t,s),f=0,h=0,d=0;s>f;)i=n[a[f]],-1!==i?l[h]=i:(i=a[f],n[i]=d,l[h]=d,++d),++f,++h;e.indices=l;var p=e.attributes;for(var v in p)if(p.hasOwnProperty(v)&&c(p[v])&&c(p[v].values)){for(var g=p[v],E=g.values,S=0,C=g.componentsPerAttribute,w=u.createTypedArray(g.componentDatatype,d*C);t>S;){var b=n[S];if(-1!==b)for(o=0;C>o;o++)w[C*b+o]=E[C*S+o];++S}g.values=w}}return e},tt.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===x.TRIANGLES&&c(r)){for(var n=r.length,o=0,i=0;n>i;i++)r[i]>o&&(o=r[i]);e.indices=A.tipsify({indices:r,maximumIndex:o,cacheSize:t})}return e},tt.fitToUnsignedShortIndices=function(e){var t=[],r=m.computeNumberOfVertices(e);if(c(e.indices)&&r>S.SIXTY_FOUR_KILOBYTES){var n,o=[],i=[],a=0,u=R(e.attributes),s=e.indices,l=s.length;e.primitiveType===x.TRIANGLES?n=3:e.primitiveType===x.LINES?n=2:e.primitiveType===x.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var h=0;n>h;++h){var d=s[f+h],p=o[d];c(p)||(p=a++,o[d]=p,N(u,e.attributes,d)),i.push(p)}a+n>S.SIXTY_FOUR_KILOBYTES&&(t.push(new m({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),o=[],i=[],a=0,u=R(e.attributes))}0!==i.length&&t.push(new m({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var rt=new o,nt=new a;tt.projectTo2D=function(e,t,r,n,i){var a=e.attributes[t];i=c(i)?i:new h;for(var s=i.ellipsoid,f=a.values,m=new Float64Array(f.length),p=0,v=0;v<f.length;v+=3){var y=o.fromArray(f,v,rt),g=s.cartesianToCartographic(y,nt);if(!c(g))throw new l("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var E=i.project(g,rt);m[p++]=E.x,m[p++]=E.y,m[p++]=E.z}return e.attributes[r]=a,e.attributes[n]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:m}),delete e.attributes[t],e};var ot={high:0,low:0};tt.encodeAttribute=function(e,t,r,n){for(var o=e.attributes[t],i=o.values,a=i.length,s=new Float32Array(a),c=new Float32Array(a),l=0;a>l;++l)f.encode(i[l],ot),s[l]=ot.high,c[l]=ot.low;var h=o.componentsPerAttribute;return e.attributes[r]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:s}),e.attributes[n]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:c}),delete e.attributes[t],e};var it=new o,at=new w,ut=new C;tt.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(w.equals(t,w.IDENTITY))return e;var n=e.geometry.attributes;L(t,n.position),L(t,n.prevPosition),L(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(w.inverse(t,at),w.transpose(at,at),w.getRotation(at,ut),P(ut,n.normal),P(ut,n.binormal),P(ut,n.tangent));var o=e.geometry.boundingSphere;return c(o)&&(e.geometry.boundingSphere=r.transform(o,t,o)),e.modelMatrix=w.clone(w.IDENTITY),e};var st=new o;tt.combineInstances=function(e){for(var t=[],r=[],n=e.length,o=0;n>o;++o){var i=e[o];c(i.geometry)?t.push(i):r.push(i)}var a=[];return t.length>0&&a.push(D(t,"geometry")),r.length>0&&(a.push(D(r,"westHemisphereGeometry")),a.push(D(r,"eastHemisphereGeometry"))),a};var ct=new o,lt=new o,ft=new o,ht=new o;tt.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,a=t.length,s=new Array(i),c=new Array(a/3),l=new Array(a),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var h=0;for(f=0;a>f;f+=3){var m=t[f],p=t[f+1],v=t[f+2],y=3*m,g=3*p,E=3*v;lt.x=n[y],lt.y=n[y+1],lt.z=n[y+2],ft.x=n[g],ft.y=n[g+1],ft.z=n[g+2],ht.x=n[E],ht.y=n[E+1],ht.z=n[E+2],s[m].count++,s[p].count++,s[v].count++,o.subtract(ft,lt,ft),o.subtract(ht,lt,ht),c[h]=o.cross(ft,ht,new o),h++}var S=0;for(f=0;i>f;f++)s[f].indexOffset+=S,S+=s[f].count;h=0;var C;for(f=0;a>f;f+=3){C=s[t[f]];var w=C.indexOffset+C.currentCount;l[w]=h,C.currentCount++,C=s[t[f+1]],w=C.indexOffset+C.currentCount,l[w]=h,C.currentCount++,C=s[t[f+2]],w=C.indexOffset+C.currentCount,l[w]=h,C.currentCount++,h++}var b=new Float32Array(3*i);for(f=0;i>f;f++){var x=3*f;if(C=s[f],C.count>0){for(o.clone(o.ZERO,ct),h=0;h<C.count;h++)o.add(ct,c[l[C.indexOffset+h]],ct);o.normalize(ct,ct),b[x]=ct.x,b[x+1]=ct.y,b[x+2]=ct.z}else b[x]=0,b[x+1]=0,b[x+2]=1}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:b}),e};var mt=new o,dt=new o,pt=new o;tt.computeBinormalAndTangent=function(e){e.attributes;for(var t=e.indices,r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,a=e.attributes.position.values.length/3,s=t.length,c=new Array(3*a),l=0;l<c.length;l++)c[l]=0;var f,h,m;for(l=0;s>l;l+=3){var p=t[l],v=t[l+1],y=t[l+2];f=3*p,h=3*v,m=3*y;var g=2*p,E=2*v,S=2*y,C=r[f],w=r[f+1],b=r[f+2],x=i[g],A=i[g+1],T=i[E+1]-A,M=i[S+1]-A,I=1/((i[E]-x)*M-(i[S]-x)*T),O=(M*(r[h]-C)-T*(r[m]-C))*I,R=(M*(r[h+1]-w)-T*(r[m+1]-w))*I,N=(M*(r[h+2]-b)-T*(r[m+2]-b))*I;c[f]+=O,c[f+1]+=R,c[f+2]+=N,c[h]+=O,c[h+1]+=R,c[h+2]+=N,c[m]+=O,c[m+1]+=R,c[m+2]+=N}var L=new Float32Array(3*a),P=new Float32Array(3*a);for(l=0;a>l;l++){f=3*l,h=f+1,m=f+2;var z=o.fromArray(n,f,mt),D=o.fromArray(c,f,pt),F=o.dot(z,D);o.multiplyByScalar(z,F,dt),o.normalize(o.subtract(D,dt,D),D),P[f]=D.x,P[h]=D.y,P[m]=D.z,o.normalize(o.cross(z,D,D),D),L[f]=D.x,L[h]=D.y,L[m]=D.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.binormal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e};var vt=new n,yt=new o,gt=new o,Et=new o;tt.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var a,s,l,f,h=t.attributes.tangent,m=t.attributes.binormal;c(r)&&(a=r.values),c(i)&&(s=i.values),c(h)&&(l=h.values),m&&(f=m.values);var p=c(a)?a.length:s.length,v=c(a)?3:2,y=p/v,g=y,E=c(s)&&c(a)?2:1;E+=c(l)||c(f)?1:0,g*=E;for(var S=new Float32Array(g),C=0,w=0;y>w;++w){c(s)&&(n.fromArray(s,2*w,vt),S[C++]=e.compressTextureCoordinates(vt));var b=3*w;c(a)&&c(l)&&c(f)?(o.fromArray(a,b,yt),o.fromArray(l,b,gt),o.fromArray(f,b,Et),e.octPack(yt,gt,Et,vt),S[C++]=vt.x,S[C++]=vt.y):(c(a)&&(o.fromArray(a,b,yt),S[C++]=e.octEncodeFloat(yt)),c(l)&&(o.fromArray(l,b,yt),S[C++]=e.octEncodeFloat(yt)),c(f)&&(o.fromArray(f,b,yt),S[C++]=e.octEncodeFloat(yt)))}return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:E,values:S}),c(a)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var St=new o,Ct=new o,wt=new o,bt=new o,xt=new o,At={positions:new Array(7),indices:new Array(9)},Tt=new o,Mt=new o,It=new o,Ot=new o,Rt=new n,Nt=new n,Lt=new n,Pt=b.fromPointNormal(o.ZERO,o.UNIT_Y),zt=new o,Dt=new o,Ft=new n,_t=new n,Bt=new o,Ut=new o,Gt=new o,qt=new o,kt=new o,Vt=new o,Wt=new o,Yt=new i;return new i,tt.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var o=n.center.x-n.radius;if(o>0||r.intersect(n,i.UNIT_Y)!==g.INTERSECTING)return e}if(t.geometryType!==v.NONE)switch(t.geometryType){case v.POLYLINES:et(e);break;case v.TRIANGLES:J(e);break;case v.LINES:$(e)}else k(t),t.primitiveType===x.TRIANGLES?J(e):t.primitiveType===x.LINES&&$(e);return e},tt}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,o,i,a,u){"use strict";var s=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=s.geodeticLatitudeToMercatorAngle(t.latitude)*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},s.prototype.unproject=function(e,r){var o=this._oneOverSemimajorAxis,i=e.x*o,a=s.mercatorAngleToGeodeticLatitude(e.y*o),u=e.z;return n(r)?(r.longitude=i,r.latitude=a,r.height=u,r):new t(i,a,u)},s}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,n,o,i,a,u,s,c,l,f,h,m,d,p){"use strict";function v(e,t,r){var n,o=!r,i=e.length;if(!o&&i>1){var a=e[0].modelMatrix;for(n=1;i>n;++n)if(!d.equals(a,e[n].modelMatrix)){o=!0;break}}if(o)for(n=0;i>n;++n)h.transformToWorldCoordinates(e[n]);else d.multiplyTransformation(t,e[0].modelMatrix,t)}function y(e,n){var o=e.attributes,i=o.position,a=4*(i.values.length/i.componentsPerAttribute);o.pickColor=new l({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var u=t.floatToByte(n.red),s=t.floatToByte(n.green),c=t.floatToByte(n.blue),f=t.floatToByte(n.alpha),h=o.pickColor.values,m=0;a>m;m+=4)h[m]=u,h[m+1]=s,h[m+2]=c,h[m+3]=f}function g(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=t[n];o(i.geometry)?y(i.geometry,a):(y(i.westHemisphereGeometry,a),y(i.eastHemisphereGeometry,a))}}function E(e){var t,r=e.length,n=[],i=e[0].attributes;for(t in i)if(i.hasOwnProperty(t)){for(var a=i[t],u=!0,s=1;r>s;++s){var c=e[s].attributes[t];if(!o(c)||a.componentDatatype!==c.componentDatatype||a.componentsPerAttribute!==c.componentsPerAttribute||a.normalize!==c.normalize){u=!1;break}}u&&n.push(t)}return n}function S(e,t,n){for(var o=c.computeNumberOfVertices(t),i=n.length,a=0;i>a;++a){for(var u=n[a],s=e[u],f=s.componentDatatype,h=s.value,m=h.length,d=r.createTypedArray(f,o*m),p=0;o>p;++p)d.set(h,p*m);t.attributes[u]=new l({componentDatatype:f,componentsPerAttribute:m,normalize:s.normalize,values:d})}}function C(e,t){for(var r=e.length,n=0;r>n;++n){var i=e[n],a=i.attributes;o(i.geometry)?S(a,i.geometry,t):(S(a,i.westHemisphereGeometry,t),S(a,i.eastHemisphereGeometry,t))}}function w(t){var n,i,a=t.instances,u=t.pickIds,s=t.projection,c=t.elementIndexUintSupported,l=t.scene3DOnly,f=t.allowPicking,m=t.vertexCacheOptimize,d=t.compressVertices,p=t.modelMatrix,y=a.length;if(a[0].geometry.primitiveType,v(a,p,l),!l)for(n=0;y>n;++n)h.splitLongitude(a[n]);f&&g(a,u);var S=E(a);if(C(a,S),m)for(n=0;y>n;++n){var w=a[n];o(w.geometry)?(h.reorderForPostVertexCache(w.geometry),h.reorderForPreVertexCache(w.geometry)):(h.reorderForPostVertexCache(w.westHemisphereGeometry),h.reorderForPreVertexCache(w.westHemisphereGeometry),h.reorderForPostVertexCache(w.eastHemisphereGeometry),h.reorderForPreVertexCache(w.eastHemisphereGeometry))}var b=h.combineInstances(a);for(y=b.length,n=0;y>n;++n){i=b[n];var x,A=i.attributes;if(l)for(x in A)A.hasOwnProperty(x)&&A[x].componentDatatype===r.DOUBLE&&h.encodeAttribute(i,x,x+"3DHigh",x+"3DLow");else for(x in A)if(A.hasOwnProperty(x)&&A[x].componentDatatype===r.DOUBLE){var T=x+"3D",M=x+"2D";h.projectTo2D(i,x,T,M,s),o(i.boundingSphere)&&"position"===x&&(i.boundingSphereCV=e.fromVertices(i.attributes.position2D.values)),h.encodeAttribute(i,T,T+"High",T+"Low"),h.encodeAttribute(i,M,M+"High",M+"Low")}d&&h.compressVertices(i)}if(!c){var I=[];for(y=b.length,n=0;y>n;++n)i=b[n],I=I.concat(h.fitToUnsignedShortIndices(i));b=I}return b}function b(e,t,n){for(var o=[],i=e.attributes,a=n.length,u=0;a>u;++u){var s=n[u],c=i[s],l=c.componentDatatype;l===r.DOUBLE&&(l=r.FLOAT);var f=r.createTypedArray(l,c.values);o.push({index:t[s],componentDatatype:l,componentsPerAttribute:c.componentsPerAttribute,normalize:c.normalize,values:f}),delete i[s]}return o}function x(e,t,r,i,a,u,s,l,f){var h=c.computeNumberOfVertices(t);o(s[e])||(s[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var m=i.length,d=0;m>d;++d)for(var p=i[d],v=a[p],y=h;y>0;){for(var g,E=n(f[p],0),S=u[E],C=S.length,w=0;C>w&&(g=S[w],g.index!==v);++w);o(s[e][p])||(s[e][p]={dirty:!1,valid:!0,value:r[p].value,indices:[]});var b,x=g.values.length/g.componentsPerAttribute,A=n(l[p],0);x>A+y?(b=y,s[e][p].indices.push({attribute:g,offset:A,count:b}),l[p]=A+y):(b=x-A,s[e][p].indices.push({attribute:g,offset:A,count:b}),l[p]=0,f[p]=E+1),y-=b}}function A(e,t,r,n,i){var a,u,s,c=[],l=e.length,f={},h={};for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.geometry)&&x(a,u.geometry,s,i,n,r,c,f,h);for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.westHemisphereGeometry)&&x(a,u.westHemisphereGeometry,s,i,n,r,c,f,h);for(a=0;l>a;++a)u=e[a],s=u.attributes,o(u.eastHemisphereGeometry)&&x(a,u.eastHemisphereGeometry,s,i,n,r,c,f,h);for(l=t.length,a=0;l>a;++a){u=t[a],s=u.attributes;var m={};c.push(m);for(var d=i.length,p=0;d>p;++p){var v=i[p];m[v]={dirty:!1,valid:!1,value:s[v].value,indices:[]}}}return c}function T(e,t){var r=e.attributes;for(var n in r)if(r.hasOwnProperty(n)){var i=r[n];o(i)&&o(i.values)&&t.push(i.values.buffer)}o(e.indices)&&t.push(e.indices.buffer)}function M(e,t){for(var r=e.length,n=0;r>n;++n)T(e[n],t)}function I(e,t){for(var r=e.length,n=0;r>n;++n)for(var o=e[n],i=o.length,a=0;i>a;++a)t.push(o[a].values.buffer)}function O(t){for(var r=1,n=t.length,i=0;n>i;i++){var a=t[i];if(++r,o(a)){var u=a.attributes;r+=6+2*e.packedLength+(o(a.indices)?a.indices.length:0);for(var s in u)if(u.hasOwnProperty(s)&&o(u[s])){var c=u[s];r+=5+c.values.length}}}return r}function R(e,t){for(var r=e.length,n=new Uint32Array(e.length),o=0;r>o;++o)n[o]=e[o].toRgba();return t.push(n.buffer),n}function N(e){for(var r=e.length,n=new Array(r),o=0;r>o;o++)n[o]=t.fromRgba(e[o]);return n}function L(e){for(var t=e.length,r=1+17*t,n=0;t>n;n++){var i=e[n].attributes;for(var a in i)if(i.hasOwnProperty(a)&&o(i[a])){var u=i[a];r+=5+u.value.length}}return r}function P(e,t){var r=new Float64Array(L(e)),n={},i=[],a=e.length,u=0;r[u++]=a;for(var s=0;a>s;s++){var c=e[s];d.pack(c.modelMatrix,r,u),u+=d.packedLength;var l=c.attributes,f=[];for(var h in l)l.hasOwnProperty(h)&&o(l[h])&&(f.push(h),o(n[h])||(n[h]=i.length,i.push(h)));r[u++]=f.length;for(var m=0;m<f.length;m++){var p=f[m],v=l[p];r[u++]=n[p],r[u++]=v.componentDatatype,r[u++]=v.componentsPerAttribute,r[u++]=v.normalize,r[u++]=v.value.length,r.set(v.value,u),u+=v.value.length}}return t.push(r.buffer),{stringTable:i,packedData:r}}function z(e){for(var t=e.packedData,n=e.stringTable,o=new Array(t[0]),i=0,a=1;a<t.length;){var u=d.unpack(t,a);a+=d.packedLength;for(var s={},c=t[a++],l=0;c>l;l++){for(var f=n[t[a++]],h=t[a++],m=t[a++],p=0!==t[a++],v=t[a++],y=r.createTypedArray(h,v),g=0;v>g;g++)y[g]=t[a++];s[f]={componentDatatype:h,componentsPerAttribute:m,normalize:p,value:y}}o[i++]={attributes:s,modelMatrix:u}}return o}function D(t){for(var r=t.length,n=1+r,i=0;r>i;i++){var a=t[i];n+=2,n+=o(a.boundingSphere)?e.packedLength:0,n+=o(a.boundingSphereCV)?e.packedLength:0;for(var u in a)if(a.hasOwnProperty(u)&&o(a[u])&&"boundingSphere"!==u&&"boundingSphereCV"!==u){var s=a[u];n+=4+3*s.indices.length+s.value.length}}return n}function F(t,r){var n=new Float64Array(D(t)),i=[],a=[],u={},s=t.length,c=0;n[c++]=s;for(var l=0;s>l;l++){var f=t[l],h=f.boundingSphere,m=o(h);n[c++]=m?1:0,m&&(e.pack(h,n,c),c+=e.packedLength),h=f.boundingSphereCV,m=o(h),n[c++]=m?1:0,m&&(e.pack(h,n,c),c+=e.packedLength);var d=[];for(var p in f)f.hasOwnProperty(p)&&o(f[p])&&"boundingSphere"!==p&&"boundingSphereCV"!==p&&(d.push(p),o(u[p])||(u[p]=i.length,i.push(p)));n[c++]=d.length;for(var v=0;v<d.length;v++){var y=d[v],g=f[y];n[c++]=u[y],n[c++]=g.valid?1:0;var E=g.indices,S=E.length;n[c++]=S;for(var C=0;S>C;C++){var w=E[C];n[c++]=w.count,n[c++]=w.offset;var b=a.indexOf(w.attribute);-1===b&&(b=a.length,a.push(w.attribute)),n[c++]=b}n[c++]=g.value.length,n.set(g.value,c),c+=g.value.length}}return r.push(n.buffer),{stringTable:i,packedData:n,attributeTable:a}}function _(t){for(var n=t.stringTable,o=t.attributeTable,i=t.packedData,a=new Array(i[0]),u=0,s=1,c=i.length;c>s;){var l={},f=1===i[s++];f&&(l.boundingSphere=e.unpack(i,s),s+=e.packedLength),f=1===i[s++],f&&(l.boundingSphereCV=e.unpack(i,s),s+=e.packedLength);for(var h=i[s++],m=0;h>m;m++){for(var d=n[i[s++]],p=1===i[s++],v=i[s++],y=v>0?new Array(v):void 0,g=0;v>g;g++){var E={};E.count=i[s++],E.offset=i[s++],E.attribute=o[i[s++]],y[g]=E}for(var S=i[s++],C=p?r.createTypedArray(y[0].attribute.componentDatatype,S):new Array(S),w=0;S>w;w++)C[w]=i[s++];l[d]={dirty:!1,valid:p,indices:y,value:C}}a[u++]=l}return a}if(!u.supportsTypedArrays())return{};var B={};return B.combineGeometry=function(e){var t,r,n,i,a,u=e.instances,s=e.invalidInstances;if(u.length>0){t=w(e),r=h.createAttributeLocations(t[0]),i=E(u),n=[],a=t.length;for(var c=0;a>c;++c){var l=t[c];n.push(b(l,r,i))}}i=o(i)?i:E(s);var f=A(u,s,n,r,i);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,vaAttributes:n,vaAttributeLocations:f,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.packCreateGeometryResults=function(t,r){var n=new Float64Array(O(t)),i=[],a={},u=t.length,s=0;n[s++]=u;for(var c=0;u>c;c++){var l=t[c],f=o(l);if(n[s++]=f?1:0,f){n[s++]=l.primitiveType,n[s++]=l.geometryType;var h=o(l.boundingSphere)?1:0;n[s++]=h,h&&e.pack(l.boundingSphere,n,s),s+=e.packedLength;var m=o(l.boundingSphereCV)?1:0;n[s++]=m,m&&e.pack(l.boundingSphereCV,n,s),s+=e.packedLength;var d=l.attributes,p=[];for(var v in d)d.hasOwnProperty(v)&&o(d[v])&&(p.push(v),o(a[v])||(a[v]=i.length,i.push(v)));n[s++]=p.length;for(var y=0;y<p.length;y++){var g=p[y],E=d[g];n[s++]=a[g],n[s++]=E.componentDatatype,n[s++]=E.componentsPerAttribute,n[s++]=E.normalize?1:0,n[s++]=E.values.length,n.set(E.values,s),s+=E.values.length}var S=o(l.indices)?l.indices.length:0;n[s++]=S,S>0&&(n.set(l.indices,s),s+=S)}}return r.push(n.buffer),{stringTable:i,packedData:n}},B.unpackCreateGeometryResults=function(t){for(var n,o=t.stringTable,i=t.packedData,a=new Array(i[0]),u=0,s=1;s<i.length;){var h=1===i[s++];if(h){var d,p,v=i[s++],y=i[s++],g=1===i[s++];g&&(d=e.unpack(i,s)),s+=e.packedLength;var E=1===i[s++];E&&(p=e.unpack(i,s)),s+=e.packedLength;var S,C,w,b=new f,x=i[s++];for(n=0;x>n;n++){var A=o[i[s++]],T=i[s++];w=i[s++];var M=0!==i[s++];S=i[s++],C=r.createTypedArray(T,S);for(var I=0;S>I;I++)C[I]=i[s++];b[A]=new l({componentDatatype:T,componentsPerAttribute:w,normalize:M,values:C})}var O;if(S=i[s++],S>0){var R=C.length/w;for(O=m.createTypedArray(R,S),n=0;S>n;n++)O[n]=i[s++]}a[u++]=new c({primitiveType:v,geometryType:y,boundingSphere:d,indices:O,attributes:b})}else a[u++]=void 0}return a},B.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,o=0;n>o;o++)t.push(r[o].packedData.buffer);var i;return e.allowPicking&&(i=R(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:P(e.instances,t),packedPickIds:i,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof s,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},B.unpackCombineGeometryParameters=function(e){for(var t=z(e.packedInstances),r=e.allowPicking,n=r?N(e.packedPickIds):void 0,i=e.createGeometryResults,u=i.length,c=0,l=[],f=[],h=[],m=[],v=[],y=0;u>y;y++)for(var g=B.unpackCreateGeometryResults(i[y]),E=g.length,S=0;E>S;S++){var C=g[S],w=t[c];o(C)?(w.geometry=C,l.push(w),h.push(c),r&&v.push(n[c])):(f.push(w),m.push(c)),++c}var b=a.clone(e.ellipsoid),x=e.isGeographic?new s(b):new p(b);return{instances:l,invalidInstances:f,validInstancesIndices:h,invalidInstancesIndices:m,pickIds:v,ellipsoid:b,projection:x,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:d.clone(e.modelMatrix)}},B.packCombineGeometryResults=function(e,t){return o(e.geometries)&&(M(e.geometries,t),I(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:F(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},B.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:_(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},B}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,o){return t(e).then(r,n,o)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=o(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function o(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(o){return i(o)}});return r}function a(){function e(e,t,r){return h(e,t,r)}function r(e){return d(e)}function o(e){return d(i(e))}function u(e){return m(e)}var s,c,l,f,h,m,d;return c=new n(e),s={then:e,resolve:r,reject:o,progress:u,promise:c,resolver:{resolve:r,reject:o,progress:u}},l=[],f=[],h=function(e,t,r){var n,o;return n=a(),o="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,o)}),f.push(o),n.promise},m=function(e){return p(f,e),e},d=function(e){return e=t(e),h=e.then,d=t,m=y,p(l,e),f=l=C,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,o,i){return v(2,arguments),e(t,function(t){function u(e){p(e)}function s(e){d(e)}var c,l,f,h,m,d,p,v,g,E;if(g=t.length>>>0,c=Math.max(0,Math.min(r,g)),f=[],l=g-c+1,h=[],m=a(),c)for(v=m.progress,p=function(e){h.push(e),--l||(d=p=y,m.reject(h))},d=function(e){f.push(e),--c||(d=p=y,m.resolve(f))},E=0;g>E;++E)E in t&&e(t[E],s,u,v);else m.resolve(f);return m.then(n,o,i)})}function c(e,t,r,n){function o(e){return t?t(e[0]):e[0]}return s(e,1,o,r,n)}function l(e,t,r,n){return v(1,arguments),h(e,g).then(t,r,n)}function f(){return h(arguments,g)}function h(t,r){return e(t,function(t){var n,o,i,u,s,c;if(i=o=t.length>>>0,n=[],c=a(),i)for(u=function(t,o){e(t,r).then(function(e){n[o]=e,--i||c.resolve(n)},c.reject)},s=0;o>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function m(t,r){var n=S.call(arguments,1);return e(t,function(t){var o;return o=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,o)})})},E.apply(t,n)})}function d(t,r,n){var o=arguments.length>2;return e(t,function(e){return e=o?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function p(e,t){for(var r,n=0;r=e[n++];)r(t)}function v(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function y(){}function g(e){return e}var E,S,C;return e.defer=a,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=h,e.reduce=m,e.any=c,e.some=s,e.chain=d,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(C,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(C,t)})})}},S=[].slice,E=[].reduce||function(e){var t,r,n,o,i;if(i=0,t=Object(this),o=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;o>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r};return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";var n=function(n){var o,i=[],a={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=n(s.parameters,i)}catch(c){a.error=c instanceof Error?{name:c.name,message:c.message,stack:c.stack}:c}t(o)||(o=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{o(a,i)}catch(c){a.result=void 0,a.error="postMessage failed with error: "+r(c)+"\n  with responseMessage: "+JSON.stringify(a),o(a)}}};return n}),define("Workers/createGeometry",["../Core/defined","../Scene/PrimitivePipeline","../ThirdParty/when","./createTaskProcessorWorker","require"],function(e,t,r,n,o){"use strict";function i(t){var r=u[t];return e(r)||o(["./"+t],function(e){r=e,u[r]=e}),r}function a(r,n){for(var o=r.subTasks,a=o.length,u=new Array(a),s=0;a>s;s++){var c=o[s],l=c.geometry,f=c.moduleName;if(e(f)){var h=i(f);u[s]=h(l,c.offset)}else u[s]=l}return t.packCreateGeometryResults(u,n)}var u={};return n(a)})}();