/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};r.EPSILON1=.1,r.EPSILON2=.01,r.EPSILON3=.001,r.EPSILON4=1e-4,r.EPSILON5=1e-5,r.EPSILON6=1e-6,r.EPSILON7=1e-7,r.EPSILON8=1e-8,r.EPSILON9=1e-9,r.EPSILON10=1e-10,r.EPSILON11=1e-11,r.EPSILON12=1e-12,r.EPSILON13=1e-13,r.EPSILON14=1e-14,r.EPSILON15=1e-15,r.EPSILON16=1e-16,r.EPSILON17=1e-17,r.EPSILON18=1e-18,r.EPSILON19=1e-19,r.EPSILON20=1e-20,r.GRAVITATIONALPARAMETER=3986004418e5,r.SOLAR_RADIUS=6955e5,r.LUNAR_RADIUS=1737400,r.SIXTY_FOUR_KILOBYTES=65536,r.sign=function(e){return e>0?1:0>e?-1:0},r.signNotZero=function(e){return 0>e?-1:1},r.toSNorm=function(e){return Math.round(255*(.5*r.clamp(e,-1,1)+.5))},r.fromSNorm=function(e){return 2*(r.clamp(e,0,255)/255)-1},r.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},r.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},r.lerp=function(e,t,r){return(1-r)*e+r*t},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=.5*Math.PI,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=.5*3*Math.PI,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(e){return e*r.RADIANS_PER_DEGREE},r.toDegrees=function(e){return e*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(e){var t=r.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},r.negativePiToPi=function(e){return r.zeroToTwoPi(e+r.PI)-r.PI},r.zeroToTwoPi=function(e){var t=r.mod(e,r.TWO_PI);return Math.abs(t)<r.EPSILON14&&Math.abs(e)>r.EPSILON14?r.TWO_PI:t},r.mod=function(e,t){return(e%t+t)%t},r.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return a>=i||i<=n*Math.max(Math.abs(e),Math.abs(r))};var n=[1];r.factorial=function(e){var t=n.length;if(e>=t)for(var r=n[t-1],a=t;e>=a;a++)n.push(r*a);return n[e]},r.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},r.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},r.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},r.clamp=function(e,t,r){return t>e?t:e>r?r:e};var a=new e;return r.setRandomNumberSeed=function(t){a=new e(t)},r.nextRandomNumber=function(){return a.random()},r.acosClamped=function(e){return Math.acos(r.clamp(e,-1,1))},r.asinClamped=function(e){return Math.asin(r.clamp(e,-1,1))},r.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},r}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0)};i.fromSpherical=function(r,n){t(n)||(n=new i);var a=r.clock,o=r.cone,u=e(r.magnitude,1),s=u*Math.sin(o);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(o),n},i.fromElements=function(e,r,n,a){return t(a)?(a.x=e,a.y=r,a.z=n,a):new i(e,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new i(e.x,e.y,e.z):void 0},i.fromCartesian4=i.clone,i.packedLength=3,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n]=t.z},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){i.normalize(e,s),i.normalize(t,c);var r=i.dot(s,c),n=i.magnitude(i.cross(s,c,s));return Math.atan2(n,r)};var l=new i;i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Z,t):r.y<=r.z?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_Z,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)},i.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,f=n*u-a*o;return r.x=c,r.y=l,r.z=f,r},i.fromDegrees=function(e,t,r,n,o){var u=a.toRadians(e),s=a.toRadians(t);return i.fromRadians(u,s,r,n,o)};var f=new i,h=new i,d=new i(40680631590769,40680631590769,40408299984661.445);return i.fromRadians=function(r,n,a,o,u){a=e(a,0);var s=t(o)?o.radiiSquared:d,c=Math.cos(n);f.x=c*Math.cos(r),f.y=c*Math.sin(r),f.z=Math.sin(n),f=i.normalize(f,f),i.multiplyComponents(s,f,h);var l=Math.sqrt(i.dot(f,h));return h=i.divideByScalar(h,l,h),f=i.multiplyByScalar(f,a,f),t(u)||(u=new i),i.add(h,f,u)},i.fromDegreesArray=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=a.toRadians(e[o]);return i.fromRadiansArray(n,t,r)},i.fromRadiansArray=function(e,r,n){var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var o=0;a>o;o+=2){var u=e[o],s=e[o+1];n[o/2]=i.fromRadians(u,s,0,r,n[o/2])}return n},i.fromDegreesArrayHeights=function(e,t,r){for(var n=new Array(e.length),o=0;o<e.length;o+=3)n[o]=a.toRadians(e[o]),n[o+1]=a.toRadians(e[o+1]),n[o+2]=e[o+2];return i.fromRadiansArrayHeights(n,t,r)},i.fromRadiansArrayHeights=function(e,r,n){var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var o=0;a>o;o+=3){var u=e[o],s=e[o+1],c=e[o+2];n[o/3]=i.fromRadians(u,s,c,r,n[o/3])}return n},i.ZERO=n(new i(0,0,0)),i.UNIT_X=n(new i(1,0,0)),i.UNIT_Y=n(new i(0,1,0)),i.UNIT_Z=n(new i(0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},i}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(n,0)};return i.fromRadians=function(r,n,a,o){return a=e(a,0),t(o)?(o.longitude=r,o.latitude=n,o.height=a,o):new i(r,n,a)},i.fromDegrees=function(e,t,r,n){return e=a.toRadians(e),t=a.toRadians(t),i.fromRadians(e,t,r,n)},i.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new i(e.longitude,e.latitude,e.height):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},i.equalsEpsilon=function(e,r,n){return e===r||t(e)&&t(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n},i.ZERO=n(new i(0,0,0)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1}var c=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,t,r)};a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,r){if(!n(t))return void 0;var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new c(a.x,a.y,a.z)},c.fromCartesian3=function(e,t){return n(t)||(t=new c),n(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=o(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=o(new c(1,1,1)),c.MOON=o(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,n,a){a=r(a,0),e.pack(t._radii,n,a)},c.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return c.fromCartesian3(i,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,f=new e;c.prototype.cartographicToCartesian=function(t,r){var a=l,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},c.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var h=new e,d=new e,p=new e;c.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,d);if(!n(i))return void 0;var o=this.geodeticSurfaceNormal(i,h),s=e.subtract(r,i,p),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=f,a):new t(c,l,f)},c.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;r>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t};var m=new e,y=new e;return c.prototype.scaleToGeodeticSurface=function(t,r){var a=t.x,i=t.y,o=t.z,s=this._oneOverRadii,c=s.x,l=s.y,f=s.z,h=a*a*c*c,d=i*i*l*l,p=o*o*f*f,v=h+d+p,g=Math.sqrt(1/v),w=e.multiplyByScalar(t,g,m);if(v<this._centerToleranceSquared)return isFinite(g)?e.clone(w,r):void 0;var x=this._oneOverRadiiSquared,E=x.x,S=x.y,O=x.z,T=y;T.x=2*w.x*E,T.y=2*w.y*S,T.z=2*w.z*O;var M,_,P,b,N,A,I,C,R,z,D,L=(1-g)*e.magnitude(t)/(.5*e.magnitude(T)),q=0;do{L-=q,P=1/(1+L*E),b=1/(1+L*S),N=1/(1+L*O),A=P*P,I=b*b,C=N*N,R=A*P,z=I*b,D=C*N,M=h*A+d*I+p*C-1,_=h*R*E+d*z*S+p*D*O;var U=-2*_;q=M/U}while(Math.abs(M)>u.EPSILON12);return n(r)?(r.x=a*P,r.y=i*b,r.z=o*N,r):new e(a*P,i*b,o*N)},c.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},c.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},c.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},c.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r){this.x=e(t,0),this.y=e(r,0)};i.fromElements=function(e,r,n){return t(n)?(n.x=e,n.y=r,n):new i(e,r)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new i(e.x,e.y):void 0},i.fromCartesian3=i.clone,i.fromCartesian4=i.clone,i.packedLength=2,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n]=t.y},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y)},i.minimumComponent=function(e){return Math.min(e.x,e.y)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i,c=new i;i.angleBetween=function(e,t){return i.normalize(e,s),i.normalize(t,c),a.acosClamped(i.dot(s,c))};var l=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,l);return i.abs(r,r),t=r.x<=r.y?i.clone(i.UNIT_X,t):i.clone(i.UNIT_Y,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)},i.ZERO=n(new i(0,0)),i.UNIT_X=n(new i(1,0)),i.UNIT_Y=n(new i(0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+")"},i}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";var u=function(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.west=t(e,0),this.south=t(r,0),this.east=t(n,0),this.north=t(a,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){var t=e.east,r=e.west;return r>t&&(t+=u.TWO_PI),t-r},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,n,a,i,o){return e=u.toRadians(t(e,0)),n=u.toRadians(t(n,0)),a=u.toRadians(t(a,0)),i=u.toRadians(t(i,0)),r(o)?(o.west=e,o.south=n,o.east=a,o.north=i,o):new s(e,n,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=0,c=e.length;c>u;u++){var l=e[u];n=Math.min(n,l.longitude),a=Math.max(a,l.longitude),i=Math.min(i,l.latitude),o=Math.max(o,l.latitude)}return r(t)?(t.west=n,t.south=i,t.east=a,t.north=o,t):new s(n,i,a,o)},s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;i>a&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;i>a&&o>0?a+=u.TWO_PI:c>o&&a>0&&(o+=u.TWO_PI),i>a&&0>c?c+=u.TWO_PI:c>o&&0>i&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),f=u.negativePiToPi(Math.min(a,o));if((e.west<e.east||t.west<t.east)&&l>=f)return void 0;var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);return h>=d?void 0:r(n)?(n.west=l,n.south=h,n.east=f,n.north=d,n):new s(l,h,f,d)},s.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return a>i&&(i+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>a||u.equalsEpsilon(r,a,u.EPSILON14))&&(i>r||u.equalsEpsilon(r,i,u.EPSILON14))&&n>=e.south&&n<=e.north};var c=new e;return s.subsample=function(e,n,a,o){n=t(n,i.WGS84),a=t(a,0),r(o)||(o=[]);var l=0,f=e.north,h=e.south,d=e.east,p=e.west,m=c;m.height=a,m.longitude=p,m.latitude=f,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.latitude=h,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=p,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.latitude=0>f?f:h>0?h:0;for(var y=1;8>y;++y)m.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=n.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=p,o[l]=n.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=n.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,t,n,a){this.x=r(e,0),this.y=r(t,0),this.width=r(n,0),this.height=r(a,0)};s.fromPoints=function(e,t){if(n(t)||(t=new s),!n(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var r=e.length,a=e[0].x,i=e[0].y,o=e[0].x,u=e[0].y,c=1;r>c;c++){var l=e[c],f=l.x,h=l.y;a=Math.min(f,a),o=Math.max(f,o),i=Math.min(h,i),u=Math.max(h,u)}return t.x=a,t.y=i,t.width=o-a,t.height=u-i,t};var c=new i,l=new t,f=new t;return s.fromRectangle=function(t,a,i){if(n(i)||(i=new s),!n(t))return i.x=0,i.y=0,i.width=0,i.height=0,i;a=r(a,c);var o=a.project(u.southwest(t,l)),h=a.project(u.northeast(t,f));return e.subtract(h,o,h),i.x=o.x,i.y=o.y,i.width=h.x,i.height=h.y,i},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,t,r){n(r)||(r=new s);var a=Math.min(e.x,t.x),i=Math.min(e.y,t.y),o=Math.max(e.x+e.width,t.x+t.width),u=Math.max(e.y+e.height,t.y+t.height);return r.x=a,r.y=i,r.width=o-a,r.height=u-i,r},s.expand=function(e,t,r){r=s.clone(e,r);var n=t.x-r.x,a=t.y-r.y;return n>r.width?r.width=n:0>n&&(r.width-=n,r.x=t.x),a>r.height?r.height=a:0>a&&(r.height-=a,r.y=t.y),r},s.intersect=function(e,t){var r=e.x,n=e.y,a=t.x,i=t.y;return r>a+t.width||r+e.width<a||n+e.height<i||n>i+t.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a){"use strict";var i=function(t,r,n,a){this.x=e(t,0),this.y=e(r,0),this.z=e(n,0),this.w=e(a,0)};i.fromElements=function(e,r,n,a,o){return t(o)?(o.x=e,o.y=r,o.z=n,o.w=a,o):new i(e,r,n,a)},i.fromColor=function(e,r){return t(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new i(e.red,e.green,e.blue,e.alpha)},i.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new i(e.x,e.y,e.z,e.w):void 0},i.packedLength=4,i.pack=function(t,r,n){n=e(n,0),r[n++]=t.x,r[n++]=t.y,r[n++]=t.z,r[n]=t.w},i.unpack=function(r,n,a){return n=e(n,0),t(a)||(a=new i),a.x=r[n++],a.y=r[n++],a.z=r[n++],a.w=r[n],a},i.fromArray=i.unpack,i.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},i.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},i.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},i.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},i.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},i.magnitude=function(e){return Math.sqrt(i.magnitudeSquared(e))};var o=new i;i.distance=function(e,t){return i.subtract(e,t,o),i.magnitude(o)},i.distanceSquared=function(e,t){return i.subtract(e,t,o),i.magnitudeSquared(o)},i.normalize=function(e,t){var r=i.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},i.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},i.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},i.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},i.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},i.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},i.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},i.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},i.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var u=new i;i.lerp=function(e,t,r,n){return i.multiplyByScalar(t,r,u),n=i.multiplyByScalar(e,1-r,n),i.add(u,n,n)};var s=new i;return i.mostOrthogonalAxis=function(e,t){var r=i.normalize(e,s);return i.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?i.clone(i.UNIT_X,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t):r.y<=r.z?r.y<=r.w?i.clone(i.UNIT_Y,t):i.clone(i.UNIT_W,t):r.z<=r.w?i.clone(i.UNIT_Z,t):i.clone(i.UNIT_W,t)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},i.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},i.equalsEpsilon=function(e,r,n,i){return e===r||t(e)&&t(r)&&a.equalsEpsilon(e.x,r.x,n,i)&&a.equalsEpsilon(e.y,r.y,n,i)&&a.equalsEpsilon(e.z,r.z,n,i)&&a.equalsEpsilon(e.w,r.w,n,i)},i.ZERO=n(new i(0,0,0,0)),i.UNIT_X=n(new i(1,0,0,0)),i.UNIT_Y=n(new i(0,1,0,0)),i.UNIT_Z=n(new i(0,0,1,0)),i.UNIT_W=n(new i(0,0,0,1)),i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},i}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function u(e){for(var t=0,r=0;3>r;++r){var n=e[c.getElementIndex(d[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function s(e,t){for(var r=i.EPSILON15,n=0,a=1,o=0;3>o;++o){var u=Math.abs(e[c.getElementIndex(d[o],h[o])]);u>n&&(a=o,n=u)}var s=1,l=0,f=h[a],p=d[a];if(Math.abs(e[c.getElementIndex(p,f)])>r){var m,y=e[c.getElementIndex(p,p)],v=e[c.getElementIndex(f,f)],g=e[c.getElementIndex(p,f)],w=(y-v)/2/g;m=0>w?-1/(-w+Math.sqrt(1+w*w)):1/(w+Math.sqrt(1+w*w)),s=1/Math.sqrt(1+m*m),l=m*s}return t=c.clone(c.IDENTITY,t),t[c.getElementIndex(f,f)]=t[c.getElementIndex(p,p)]=s,t[c.getElementIndex(p,f)]=l,t[c.getElementIndex(f,p)]=-l,t}var c=function(e,r,n,a,i,o,u,s,c){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(u,0),this[3]=t(r,0),this[4]=t(i,0),this[5]=t(s,0),this[6]=t(n,0),this[7]=t(o,0),this[8]=t(c,0)};c.packedLength=9,c.pack=function(e,r,n){n=t(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8]},c.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a[4]=e[n++],a[5]=e[n++],a[6]=e[n++],a[7]=e[n++],a[8]=e[n++],a},c.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,n,a){return n=t(n,0),r(a)||(a=new c),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a[4]=e[n+4],a[5]=e[n+5],a[6]=e[n+6],a[7]=e[n+7],a[8]=e[n+8],a},c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,s=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,p=n-u-f+d,m=2*(a-h),y=2*(i+l),v=2*(a+h),g=-n+u-f+d,w=2*(s-o),x=2*(i-l),E=2*(s+o),S=-n-u+f+d;return r(t)?(t[0]=p,t[1]=v,t[2]=x,t[3]=m,t[4]=g,t[5]=E,t[6]=y,t[7]=w,t[8]=S,t):new c(p,m,y,v,g,w,x,E,S)},c.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new c(1,0,0,0,n,-a,0,a,n)},c.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new c(n,0,a,0,1,0,-a,0,n)},c.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new c(n,-a,0,a,n,0,0,0,1)},c.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,t){return 3*e+t},c.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n
},c.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var l=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],l)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],l)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],l)),r};var f=new e;c.getMaximumScale=function(t){return c.getScale(t,f),e.maximumComponent(f)},c.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},c.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var h=[1,0,0],d=[2,2,1],p=new c,m=new c;return c.computeEigenDecomposition=function(e,t){var n=i.EPSILON20,a=10,l=0,f=0;r(t)||(t={});for(var h=t.unitary=c.clone(c.IDENTITY,t.unitary),d=t.diagonal=c.clone(e,t.diagonal),y=n*o(d);a>f&&u(d)>y;)s(d,p),c.transpose(p,m),c.multiply(d,p,d),c.multiply(m,d,d),c.multiply(h,p,h),++l>2&&(++f,l=0);return t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},c.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},c.inverse=function(e,t){var r=e[0],a=e[1],o=e[2],u=e[3],s=e[4],l=e[5],f=e[6],h=e[7],d=e[8],p=c.determinant(e);if(Math.abs(p)<=i.EPSILON15)throw new n("matrix is not invertible");t[0]=s*d-h*l,t[1]=h*o-a*d,t[2]=a*l-s*o,t[3]=f*l-u*d,t[4]=r*d-f*o,t[5]=u*o-r*l,t[6]=u*h-f*s,t[7]=f*a-r*h,t[8]=r*s-u*a;var m=1/p;return c.multiplyByScalar(t,m,t)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},c.IDENTITY=a(new c(1,0,0,0,1,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s){"use strict";var c=function(e,t,n,a,i,o,u,s,c,l,f,h,d,p,m,y){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(p,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(m,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(h,0),this[15]=r(y,0)};c.packedLength=16,c.pack=function(e,t,n){n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15]},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},c.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,t){return c.clone(e,t)},c.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(t,a,i){return a=r(a,e.ZERO),n(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=a.x,i[13]=a.y,i[14]=a.z,i[15]=1,i):new c(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,t,r,a){n(a)||(a=new c);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,l=t.x*t.y,f=t.x*t.z,h=t.x*t.w,d=t.y*t.y,p=t.y*t.z,m=t.y*t.w,y=t.z*t.z,v=t.z*t.w,g=t.w*t.w,w=s-d-y+g,x=2*(l-v),E=2*(f+m),S=2*(l+v),O=-s+d-y+g,T=2*(p-h),M=2*(f-m),_=2*(p+h),P=-s-d+y+g;return a[0]=w*i,a[1]=S*i,a[2]=M*i,a[3]=0,a[4]=x*o,a[5]=O*o,a[6]=_*o,a[7]=0,a[8]=E*u,a[9]=T*u,a[10]=P*u,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},c.fromTranslation=function(e,t){return c.fromRotationTranslation(u.IDENTITY,e,t)},c.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,f=new e,h=new e;c.fromCamera=function(t,r){var a=t.eye,i=t.target,o=t.up;e.normalize(e.subtract(i,a,l),l),e.normalize(e.cross(l,o,f),f),e.normalize(e.cross(f,l,h),h);var u=f.x,s=f.y,d=f.z,p=l.x,m=l.y,y=l.z,v=h.x,g=h.y,w=h.z,x=a.x,E=a.y,S=a.z,O=u*-x+s*-E+d*-S,T=v*-x+g*-E+w*-S,M=p*x+m*E+y*S;return n(r)?(r[0]=u,r[1]=v,r[2]=-p,r[3]=0,r[4]=s,r[5]=g,r[6]=-m,r[7]=0,r[8]=d,r[9]=w,r[10]=-y,r[11]=0,r[12]=O,r[13]=T,r[14]=M,r[15]=1,r):new c(u,s,d,O,v,g,w,T,-p,-m,-y,M,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},c.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,f=-(n+r)*s,h=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},c.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),f=-(i+a)/(i-a),h=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},c.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,f=-1,h=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=f,i[12]=0,i[13]=0,i[14]=h,i[15]=0,i},c.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),h=c,d=l,p=f,m=i+c,y=o+l,v=t+f,g=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=p,a[11]=0,a[12]=m,a[13]=y,a[14]=v,a[15]=g,a},c.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,t){return 4*e+t},c.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},c.setColumn=function(e,t,r,n){n=c.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},c.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},c.setRow=function(e,t,r,n){return n=c.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var d=new e;c.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),r};var p=new e;c.getMaximumScale=function(t){return c.getScale(t,p),e.maximumComponent(p)},c.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],p=e[11],m=e[12],y=e[13],v=e[14],g=e[15],w=t[0],x=t[1],E=t[2],S=t[3],O=t[4],T=t[5],M=t[6],_=t[7],P=t[8],b=t[9],N=t[10],A=t[11],I=t[12],C=t[13],R=t[14],z=t[15],D=n*w+u*x+f*E+m*S,L=a*w+s*x+h*E+y*S,q=i*w+c*x+d*E+v*S,U=o*w+l*x+p*E+g*S,B=n*O+u*T+f*M+m*_,F=a*O+s*T+h*M+y*_,W=i*O+c*T+d*M+v*_,G=o*O+l*T+p*M+g*_,k=n*P+u*b+f*N+m*A,V=a*P+s*b+h*N+y*A,Y=i*P+c*b+d*N+v*A,j=o*P+l*b+p*N+g*A,H=n*I+u*C+f*R+m*z,Z=a*I+s*C+h*R+y*z,X=i*I+c*C+d*R+v*z,J=o*I+l*C+p*R+g*z;return r[0]=D,r[1]=L,r[2]=q,r[3]=U,r[4]=B,r[5]=F,r[6]=W,r[7]=G,r[8]=k,r[9]=V,r[10]=Y,r[11]=j,r[12]=H,r[13]=Z,r[14]=X,r[15]=J,r},c.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},c.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},c.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],p=e[14],m=t[0],y=t[1],v=t[2],g=t[4],w=t[5],x=t[6],E=t[8],S=t[9],O=t[10],T=t[12],M=t[13],_=t[14],P=n*m+o*y+c*v,b=a*m+u*y+l*v,N=i*m+s*y+f*v,A=n*g+o*w+c*x,I=a*g+u*w+l*x,C=i*g+s*w+f*x,R=n*E+o*S+c*O,z=a*E+u*S+l*O,D=i*E+s*S+f*O,L=n*T+o*M+c*_+h,q=a*T+u*M+l*_+d,U=i*T+s*M+f*_+p;return r[0]=P,r[1]=b,r[2]=N,r[3]=0,r[4]=A,r[5]=I,r[6]=C,r[7]=0,r[8]=R,r[9]=z,r[10]=D,r[11]=0,r[12]=L,r[13]=q,r[14]=U,r[15]=1,r},c.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],p=t[2],m=t[3],y=t[4],v=t[5],g=t[6],w=t[7],x=t[8],E=n*h+o*d+c*p,S=a*h+u*d+l*p,O=i*h+s*d+f*p,T=n*m+o*y+c*v,M=a*m+u*y+l*v,_=i*m+s*y+f*v,P=n*g+o*w+c*x,b=a*g+u*w+l*x,N=i*g+s*w+f*x;return r[0]=E,r[1]=S,r[2]=O,r[3]=0,r[4]=T,r[5]=M,r[6]=_,r[7]=0,r[8]=P,r[9]=b,r[10]=N,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},c.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var m=new e;c.multiplyByUniformScale=function(e,t,r){return m.x=t,m.y=t,m.z=t,c.multiplyByScale(e,m,r)},c.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?c.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},c.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},c.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},c.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},c.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},c.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},c.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},c.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},c.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},c.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},c.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var y=new u,v=new u,g=new t,w=new t(0,0,0,1);return c.inverse=function(e,r){if(u.equalsEpsilon(c.getRotation(e,y),v,o.EPSILON7)&&t.equals(c.getRow(e,3,g),w))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],l=e[12],f=e[1],h=e[5],d=e[9],p=e[13],m=e[2],x=e[6],E=e[10],S=e[14],O=e[3],T=e[7],M=e[11],_=e[15],P=E*_,b=S*M,N=x*_,A=S*T,I=x*M,C=E*T,R=m*_,z=S*O,D=m*M,L=E*O,q=m*T,U=x*O,B=P*h+A*d+I*p-(b*h+N*d+C*p),F=b*f+R*d+L*p-(P*f+z*d+D*p),W=N*f+z*h+q*p-(A*f+R*h+U*p),G=C*f+D*h+U*d-(I*f+L*h+q*d),k=b*a+N*i+C*l-(P*a+A*i+I*l),V=P*n+z*i+D*l-(b*n+R*i+L*l),Y=A*n+R*a+U*l-(N*n+z*a+q*l),j=I*n+L*a+q*i-(C*n+D*a+U*i);P=i*p,b=l*d,N=a*p,A=l*h,I=a*d,C=i*h,R=n*p,z=l*f,D=n*d,L=i*f,q=n*h,U=a*f;var H=P*T+A*M+I*_-(b*T+N*M+C*_),Z=b*O+R*M+L*_-(P*O+z*M+D*_),X=N*O+z*T+q*_-(A*O+R*T+U*_),J=C*O+D*T+U*M-(I*O+L*T+q*M),K=N*E+C*S+b*x-(I*S+P*x+A*E),Q=D*S+P*m+z*E-(R*E+L*S+b*m),$=R*x+U*S+A*m-(q*S+N*m+z*x),et=q*E+I*m+L*x-(D*x+U*E+C*m),tt=n*B+a*F+i*W+l*G;if(Math.abs(tt)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return tt=1/tt,r[0]=B*tt,r[1]=F*tt,r[2]=W*tt,r[3]=G*tt,r[4]=k*tt,r[5]=V*tt,r[6]=Y*tt,r[7]=j*tt,r[8]=H*tt,r[9]=Z*tt,r[10]=X*tt,r[11]=J*tt,r[12]=K*tt,r[13]=Q*tt,r[14]=$*tt,r[15]=et*tt,r},c.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],p=-r*f-n*h-a*d,m=-i*f-o*h-u*d,y=-s*f-c*h-l*d;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=p,t[13]=m,t[14]=y,t[15]=1,t},c.IDENTITY=i(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l){"use strict";var f=function(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)},h=new e,d=new e,p=new e,m=new e,y=new e,v=new e,g=new e,w=new e,x=new e,E=new e,S=new e,O=new e;f.fromPoints=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var a=e.clone(t[0],g),i=e.clone(a,h),o=e.clone(a,d),u=e.clone(a,p),s=e.clone(a,m),c=e.clone(a,y),l=e.clone(a,v),T=t.length,M=1;T>M;M++){e.clone(t[M],a);var _=a.x,P=a.y,b=a.z;_<i.x&&e.clone(a,i),_>s.x&&e.clone(a,s),P<o.y&&e.clone(a,o),P>c.y&&e.clone(a,c),b<u.z&&e.clone(a,u),b>l.z&&e.clone(a,l)}var N=e.magnitudeSquared(e.subtract(s,i,w)),A=e.magnitudeSquared(e.subtract(c,o,w)),I=e.magnitudeSquared(e.subtract(l,u,w)),C=i,R=s,z=N;A>z&&(z=A,C=o,R=c),I>z&&(z=I,C=u,R=l);var D=x;D.x=.5*(C.x+R.x),D.y=.5*(C.y+R.y),D.z=.5*(C.z+R.z);var L=e.magnitudeSquared(e.subtract(R,D,w)),q=Math.sqrt(L),U=E;U.x=i.x,U.y=o.y,U.z=u.z;var B=S;B.x=s.x,B.y=c.y,B.z=l.z;var F=e.multiplyByScalar(e.add(U,B,w),.5,O),W=0;for(M=0;T>M;M++){e.clone(t[M],a);var G=e.magnitude(e.subtract(a,F,w));G>W&&(W=G);var k=e.magnitudeSquared(e.subtract(a,D,w));if(k>L){var V=Math.sqrt(k);q=.5*(q+V),L=q*q;var Y=V-q;D.x=(q*D.x+Y*a.x)/V,D.y=(q*D.y+Y*a.y)/V,D.z=(q*D.z+Y*a.z)/V}}return W>q?(e.clone(D,r.center),r.radius=q):(e.clone(F,r.center),r.radius=W),r};var T=new o,M=new e,_=new e,P=new t,b=new t;f.fromRectangle2D=function(e,t,r){return f.fromRectangleWithHeights2D(e,t,0,0,r)},f.fromRectangleWithHeights2D=function(t,a,i,o,u){if(n(u)||(u=new f),!n(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=r(a,T),l.southwest(t,P),P.height=i,l.northeast(t,b),b.height=o;var s=a.project(P,M),c=a.project(b,_),h=c.x-s.x,d=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(h*h+d*d+p*p);var m=u.center;return m.x=s.x+.5*h,m.y=s.y+.5*d,m.z=s.z+.5*p,u};var N=[];f.fromRectangle3D=function(e,t,a,o){t=r(t,i.WGS84),a=r(a,0);var u;return n(e)&&(u=l.subsample(e,t,a,N)),f.fromPoints(u,o)},f.fromVertices=function(t,a,i,o){if(n(o)||(o=new f),!n(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;a=r(a,e.ZERO),i=r(i,3);var u=g;u.x=t[0]+a.x,u.y=t[1]+a.y,u.z=t[2]+a.z;for(var s=e.clone(u,h),c=e.clone(u,d),l=e.clone(u,p),T=e.clone(u,m),M=e.clone(u,y),_=e.clone(u,v),P=t.length,b=0;P>b;b+=i){var N=t[b]+a.x,A=t[b+1]+a.y,I=t[b+2]+a.z;u.x=N,u.y=A,u.z=I,N<s.x&&e.clone(u,s),N>T.x&&e.clone(u,T),A<c.y&&e.clone(u,c),A>M.y&&e.clone(u,M),I<l.z&&e.clone(u,l),I>_.z&&e.clone(u,_)}var C=e.magnitudeSquared(e.subtract(T,s,w)),R=e.magnitudeSquared(e.subtract(M,c,w)),z=e.magnitudeSquared(e.subtract(_,l,w)),D=s,L=T,q=C;R>q&&(q=R,D=c,L=M),z>q&&(q=z,D=l,L=_);var U=x;U.x=.5*(D.x+L.x),U.y=.5*(D.y+L.y),U.z=.5*(D.z+L.z);var B=e.magnitudeSquared(e.subtract(L,U,w)),F=Math.sqrt(B),W=E;W.x=s.x,W.y=c.y,W.z=l.z;var G=S;G.x=T.x,G.y=M.y,G.z=_.z;var k=e.multiplyByScalar(e.add(W,G,w),.5,O),V=0;for(b=0;P>b;b+=i){u.x=t[b]+a.x,u.y=t[b+1]+a.y,u.z=t[b+2]+a.z;var Y=e.magnitude(e.subtract(u,k,w));Y>V&&(V=Y);var j=e.magnitudeSquared(e.subtract(u,U,w));if(j>B){var H=Math.sqrt(j);F=.5*(F+H),B=F*F;var Z=H-F;U.x=(F*U.x+Z*u.x)/H,U.y=(F*U.y+Z*u.y)/H,U.z=(F*U.z+Z*u.z)/H}}return V>F?(e.clone(U,o.center),o.radius=F):(e.clone(k,o.center),o.radius=V),o},f.fromCornerPoints=function(t,r,a){n(a)||(a=new f);var i=a.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),a.radius=e.distance(i,r),a},f.fromEllipsoid=function(t,r){return n(r)||(r=new f),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var A=new e;f.fromBoundingSpheres=function(t,r){if(n(r)||(r=new f),!n(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=t.length;if(1===a)return f.clone(t[0],r);if(2===a)return f.union(t[0],t[1],r);for(var i=[],o=0;a>o;o++)i.push(t[o].center);r=f.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;a>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,A)+c.radius)}return r.radius=s,r},f.clone=function(t,r){return n(t)?n(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius):void 0},f.packedLength=4,f.pack=function(e,t,n){n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},f.unpack=function(e,t,a){t=r(t,0),n(a)||(a=new f);var i=a.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],a.radius=e[t],a};var I=new e,C=new e;f.union=function(t,r,a){n(a)||(a=new f);var i=t.center,o=r.center;e.add(i,o,C);var u=e.multiplyByScalar(C,.5,C),s=e.magnitude(e.subtract(i,u,I))+t.radius,c=e.magnitude(e.subtract(o,u,I))+r.radius;return a.radius=Math.max(s,c),e.clone(u,a.center),a};var R=new e;f.expand=function(t,r,n){n=f.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,R));return a>n.radius&&(n.radius=a),n},f.intersect=function(t,r){var n=t.center,a=t.radius,i=e.dot(r,n)+r.w;return-a>i?u.OUTSIDE:a>i?u.INTERSECTING:u.INSIDE},f.transform=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var z=new e;f.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,z);return e.magnitudeSquared(n)-t.radius*t.radius},f.transformWithoutScale=function(e,t,r){return n(r)||(r=new f),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var D=new e;f.computePlaneDistances=function(t,r,a,i){n(i)||(i=new s);var o=e.subtract(t.center,r,D),u=e.multiplyByScalar(a,e.dot(a,o),D),c=e.magnitude(u);return i.start=c-t.radius,i.stop=c+t.radius,i};for(var L=new e,q=new e,U=new e,B=new e,F=new e,W=new t,G=new Array(8),k=0;8>k;++k)G[k]=new e;var V=new o;return f.projectTo2D=function(t,n,a){n=r(n,V);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,L),c=e.cross(e.UNIT_Z,s,q);e.normalize(c,c);var l=e.cross(s,c,U);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var h=e.negate(l,F),d=e.negate(c,B),p=G,m=p[0];e.add(s,l,m),e.add(m,c,m),m=p[1],e.add(s,l,m),e.add(m,d,m),m=p[2],e.add(s,h,m),e.add(m,d,m),m=p[3],e.add(s,h,m),e.add(m,c,m),e.negate(s,s),m=p[4],e.add(s,l,m),e.add(m,c,m),m=p[5],e.add(s,l,m),e.add(m,d,m),m=p[6],e.add(s,h,m),e.add(m,d,m),m=p[7],e.add(s,h,m),e.add(m,c,m);for(var y=p.length,v=0;y>v;++v){var g=p[v];e.add(o,g,g);var w=i.cartesianToCartographic(g,W);n.project(w,g)}a=f.fromPoints(p,a),o=a.center;var x=o.x,E=o.y,S=o.z;return o.x=S,o.y=x,o.z=E,a},f.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.intersect=function(e){return f.intersect(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){return a.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return a.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return a.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return a.supportsFullscreen()?null!==a.element:void 0}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;u>o;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",e(document[a])?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",e(document[a])&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",e(document[a])?n.fullscreenElement=a:(a=s+"FullScreenElement",e(document[a])&&(n.fullscreenElement=a)),a=s+"fullscreenchange",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",e(document["on"+a])&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e){a.supportsFullscreen()&&e[n.requestFullscreen]()},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(y)){y=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,v=n(e[1]))}return y}function i(){return a()&&v}function o(){if(!t(g)&&(g=!1,!a()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,w=n(e[1]))}return g}function u(){return o()&&w}function s(){if(!t(x)){x=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(x=!0,E=n(e[1]),E.isNightly=!!e[2])}return x}function c(){return s()&&E}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,O=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,O=n(e[1])))}return S}function f(){return l()&&O}function h(){if(!t(T)){T=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(T=!0,M=n(e[1]))}return T}function d(){return t(_)||(_=/Windows/i.test(navigator.appVersion)),_}function p(){return h()&&M}function m(){return t(P)||(P=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),P}var y,v,g,w,x,E,S,O,T,M,_,P,b={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isFirefox:h,firefoxVersion:p,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return b.supportsFullscreen=function(){return r.supportsFullscreen()},b.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},b.supportsWebWorkers=function(){return"undefined"!=typeof Worker},b}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,n,a){"use strict";if(!n.supportsTypedArrays())return{};var i={BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,FLOAT:5126,DOUBLE:5130};return i.getSizeInBytes=function(e){switch(e){case i.BYTE:return Int8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.SHORT:return Int16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case i.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},i.fromTypedArray=function(e){return e instanceof Int8Array?i.BYTE:e instanceof Uint8Array?i.UNSIGNED_BYTE:e instanceof Int16Array?i.SHORT:e instanceof Uint16Array?i.UNSIGNED_SHORT:e instanceof Float32Array?i.FLOAT:e instanceof Float64Array?i.DOUBLE:void 0},i.validate=function(e){return t(e)&&(e===i.BYTE||e===i.UNSIGNED_BYTE||e===i.SHORT||e===i.UNSIGNED_SHORT||e===i.FLOAT||e===i.DOUBLE)},i.createTypedArray=function(e,t){switch(e){case i.BYTE:return new Int8Array(t);case i.UNSIGNED_BYTE:return new Uint8Array(t);case i.SHORT:return new Int16Array(t);case i.UNSIGNED_SHORT:return new Uint16Array(t);case i.FLOAT:return new Float32Array(t);case i.DOUBLE:return new Float64Array(t);default:throw new r("componentDatatype is not a valid value.")}},i.createArrayBufferView=function(t,n,a,o){switch(a=e(a,0),o=e(o,(n.byteLength-a)/i.getSizeInBytes(t)),t){case i.BYTE:return new Int8Array(n,a,o);case i.UNSIGNED_BYTE:return new Uint8Array(n,a,o);case i.SHORT:return new Int16Array(n,a,o);case i.UNSIGNED_SHORT:return new Uint16Array(n,a,o);case i.FLOAT:return new Float32Array(n,a,o);case i.DOUBLE:return new Float64Array(n,a,o);default:throw new r("componentDatatype is not a valid value.")}},a(i)}),define("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject"],function(e){"use strict";var t={POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return e(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";var i=function(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=void 0};return i.computeNumberOfVertices=function(e){var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;
if(n!==o&&-1!==n)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values};return t}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncode=function(e,t){if(t.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),t.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=t.x,n=t.y;t.x=(1-Math.abs(n))*a.signNotZero(r),t.y=(1-Math.abs(r))*a.signNotZero(n)}return t.x=a.toSNorm(t.x),t.y=a.toSNorm(t.y),t},i.octDecode=function(e,r,n){if(n.x=a.fromSNorm(e),n.y=a.fromSNorm(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var i=n.x;n.x=(1-Math.abs(n.y))*a.signNotZero(i),n.y=(1-Math.abs(i))*a.signNotZero(n.y)}return t.normalize(n,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=1===e.x?4095:0|4096*e.x,r=1===e.y?4095:0|4096*e.y;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096;return t.x=Math.floor(r)/4096,t.y=r-Math.floor(r),t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=new t,a=new t,i=new t,o=function(o,u,s,c,l){r(l)||(l=new t);var f,h,d,p,m,y,v,g;r(u.z)?(f=t.subtract(s,u,n),h=t.subtract(c,u,a),d=t.subtract(o,u,i),p=t.dot(f,f),m=t.dot(f,h),y=t.dot(f,d),v=t.dot(h,h),g=t.dot(h,d)):(f=e.subtract(s,u,n),h=e.subtract(c,u,a),d=e.subtract(o,u,i),p=e.dot(f,f),m=e.dot(f,h),y=e.dot(f,d),v=e.dot(h,h),g=e.dot(h,d));var w=1/(p*v-m*m);return l.y=(v*y-m*g)*w,l.z=(p*g-m*y)*w,l.x=1-l.y-l.z,l};return o}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};r.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var n={high:0,low:0};r.fromCartesian=function(e,a){t(a)||(a=new r);var i=a.high,o=a.low;return r.encode(e.x,n),i.x=n.high,o.x=n.low,r.encode(e.y,n),i.y=n.high,o.y=n.low,r.encode(e.z,n),i.z=n.high,o.z=n.low,a};var a=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,a);var i=a.high,o=a.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=o.x,t[n+4]=o.y,t[n+5]=o.z},r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=n.clone(e(t.modelMatrix,n.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return a}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n){"use strict";var a={UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123,UNSIGNED_INT:5125};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,r,a){return e>n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,a):new Uint16Array(t,r,a)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(u>o&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,0>i)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,0>i?[i,0]:[0,i];var c=n*n,l=4*e*a,f=r(c,-l,t.EPSILON14);if(0>f)return[];var h=-.5*r(n,t.sign(n)*Math.sqrt(f),t.EPSILON14);return n>0?[h/e,a/h]:[a/h,h/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,h=u*u,d=s*s,p=o*s-h,m=o*c-u*s,y=u*c-d,v=4*p*y-m*m;if(0>v){var g,w,x;h*f>=l*d?(g=o,w=p,x=-2*u*p+o*m):(g=c,w=y,x=-c*m+2*s*y);var E=0>x?-1:1,S=-E*Math.abs(g)*Math.sqrt(-v);i=-x+S;var O=i/2,T=0>O?-Math.pow(-O,1/3):Math.pow(O,1/3),M=i===S?-T:-w/T;return a=0>=w?T+M:-x/(T*T+M*M+w),h*f>=l*d?[(a-u)/o]:[-c/(a+s)]}var _=p,P=-2*u*p+o*m,b=y,N=-c*m+2*s*y,A=Math.sqrt(v),I=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*A,-P)/3);a=2*Math.sqrt(-_);var R=Math.cos(C);i=a*R;var z=a*(-R/2-I*Math.sin(C)),D=i+z>2*u?i-u:z-u,L=o,q=D/L;C=Math.abs(Math.atan2(c*A,-N)/3),a=2*Math.sqrt(-b),R=Math.cos(C),i=a*R,z=a*(-R/2-I*Math.sin(C));var U=-c,B=2*s>i+z?i+s:z+s,F=U/B,W=L*B,G=-D*B-L*U,k=D*U,V=(s*G-u*k)/(-u*G+s*W);return V>=q?F>=q?F>=V?[q,V,F]:[q,F,V]:[F,q,V]:F>=q?[V,q,F]:F>=V?[V,F,q]:[F,V,q]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,0>u?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<r.EPSILON14){var p=n.computeRealRoots(1,s,l);if(2===p.length){var m,y=p[0],v=p[1];if(y>=0&&v>=0){var g=Math.sqrt(y),w=Math.sqrt(v);return[h-w,h-g,h+g,h+w]}if(y>=0&&0>v)return m=Math.sqrt(y),[h-m,h+m];if(0>y&&v>=0)return m=Math.sqrt(v),[h-m,h+m]}return[]}if(d>0){var x=Math.sqrt(d),E=(s+d-c/x)/2,S=(s+d+c/x)/2,O=n.computeRealRoots(1,x,E),T=n.computeRealRoots(1,-x,S);return 0!==O.length?(O[0]+=h,O[1]+=h,0!==T.length?(T[0]+=h,T[1]+=h,O[1]<=T[0]?[O[0],O[1],T[0],T[1]]:T[1]<=O[0]?[T[0],T[1],O[0],O[1]]:O[0]>=T[0]&&O[1]<=T[1]?[T[0],O[0],O[1],T[1]]:T[0]>=O[0]&&T[1]<=O[1]?[O[0],T[0],T[1],O[1]]:O[0]>T[0]&&O[0]<T[1]?[T[0],O[0],T[1],O[1]]:[O[0],T[0],O[1],T[1]]):O):0!==T.length?(T[0]+=h,T[1]+=h,T):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,f=i*t+s-4*o,h=c*o-i*a*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var p,m,y=d[0],v=a-y,g=v*v,w=t/2,x=v/2,E=g-4*o,S=g+4*Math.abs(o),O=c-4*y,T=c+4*Math.abs(y);if(0>y||O*S>E*T){var M=Math.sqrt(O);p=M/2,m=0===M?0:(t*x-i)/M}else{var _=Math.sqrt(E);p=0===_?0:(t*x-i)/_,m=_/2}var P,b;0===w&&0===p?(P=0,b=0):r.sign(w)===r.sign(p)?(P=w+p,b=y/P):(b=w-p,P=y/b);var N,A;0===x&&0===m?(N=0,A=0):r.sign(x)===r.sign(m)?(N=x+m,A=o/N):(A=x-m,N=o/A);var I=n.computeRealRoots(1,P,N),C=n.computeRealRoots(1,b,A);if(0!==I.length)return 0!==C.length?I[1]<=C[0]?[I[0],I[1],C[0],C[1]]:C[1]<=I[0]?[C[0],C[1],I[0],I[1]]:I[0]>=C[0]&&I[1]<=C[1]?[C[0],I[0],I[1],C[1]]:C[0]>=I[0]&&C[1]<=I[1]?[I[0],C[0],C[1],I[1]]:I[0]>C[0]&&I[0]<C[1]?[C[0],I[0],C[1],I[1]]:[I[0],C[0],I[1],C[1]]:I;if(0!==C.length)return C}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,f=n*n,h=f*n,d=a*a,p=d*a,m=u*c*f-4*s*h-4*e*l*f+18*e*t*r*h-27*i*f*f+256*o*p+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*f+144*i*r*f)+d*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return m},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,f=u/t,h=s/t,d=0>c?1:0;switch(d+=0>l?d+1:d,d+=0>f?d+1:d,d+=0>h?d+1:d){case 0:return a(c,l,f,h);case 1:return i(c,l,f,h);case 2:return i(c,l,f,h);case 3:return a(c,l,f,h);case 4:return a(c,l,f,h);case 5:return i(c,l,f,h);case 6:return a(c,l,f,h);case 7:return a(c,l,f,h);case 8:return i(c,l,f,h);case 9:return a(c,l,f,h);case 10:return a(c,l,f,h);case 11:return i(c,l,f,h);case 12:return a(c,l,f,h);case 13:return a(c,l,f,h);case 14:return a(c,l,f,h);case 15:return a(c,l,f,h);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n=function(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n};return n.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(t,n,a,o,u){u=r(u,!1);var s,c,l,f,h,d=t.origin,p=t.direction,m=e.subtract(a,n,y),E=e.subtract(o,n,v),S=e.cross(p,E,g),O=e.dot(m,S);if(u){if(O<i.EPSILON6)return void 0;if(s=e.subtract(d,n,w),l=e.dot(s,S),0>l||l>O)return void 0;if(c=e.cross(s,m,x),f=e.dot(p,c),0>f||l+f>O)return void 0;h=e.dot(E,c)/O}else{if(Math.abs(O)<i.EPSILON6)return void 0;var T=1/O;if(s=e.subtract(d,n,w),l=e.dot(s,S)*T,0>l||l>1)return void 0;if(c=e.cross(s,m,x),f=e.dot(p,c)*T,0>f||l+f>1)return void 0;h=e.dot(E,c)*T}return h}function f(e,t,r,n){var a=t*t-4*e*r;if(0>a)return void 0;if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function h(t,r,a){n(a)||(a={});var i=t.origin,o=t.direction,u=r.center,s=r.radius*r.radius,c=e.subtract(i,u,g),l=e.dot(o,o),h=2*e.dot(o,c),d=e.magnitudeSquared(c)-s,p=f(l,h,d,S);return n(p)?(a.start=p.root0,a.stop=p.root1,a):void 0}function d(e,t,r){var n=e+t;return i.sign(e)!==i.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function p(t,r,n,a,c){var l,f=a*a,h=c*c,p=(t[o.COLUMN1ROW1]-t[o.COLUMN2ROW2])*h,m=c*(a*d(t[o.COLUMN1ROW0],t[o.COLUMN0ROW1],i.EPSILON15)+r.y),y=t[o.COLUMN0ROW0]*f+t[o.COLUMN2ROW2]*h+a*r.x+n,v=h*d(t[o.COLUMN2ROW1],t[o.COLUMN1ROW2],i.EPSILON15),g=c*(a*d(t[o.COLUMN2ROW0],t[o.COLUMN0ROW2])+r.z),w=[];if(0===g&&0===v){if(l=u.computeRealRoots(p,m,y),0===l.length)return w;var x=l[0],E=Math.sqrt(Math.max(1-x*x,0));if(w.push(new e(a,c*x,c*-E)),w.push(new e(a,c*x,c*E)),2===l.length){var S=l[1],O=Math.sqrt(Math.max(1-S*S,0));w.push(new e(a,c*S,c*-O)),w.push(new e(a,c*S,c*O))}return w}var T=g*g,M=v*v,_=p*p,P=g*v,b=_+M,N=2*(m*p+P),A=2*y*p+m*m-M+T,I=2*(y*m-P),C=y*y-T;if(0===b&&0===N&&0===A&&0===I)return w;l=s.computeRealRoots(b,N,A,I,C);var R=l.length;if(0===R)return w;for(var z=0;R>z;++z){var D,L=l[z],q=L*L,U=Math.max(1-q,0),B=Math.sqrt(U);D=i.sign(p)===i.sign(y)?d(p*q+y,m*L,i.EPSILON12):i.sign(y)===i.sign(m*L)?d(p*q,m*L+y,i.EPSILON12):d(p*q+m*L,y,i.EPSILON12);var F=d(v*L,g,i.EPSILON15),W=D*F;0>W?w.push(new e(a,c*L,c*B)):W>0?w.push(new e(a,c*L,c*-B)):0!==B?(w.push(new e(a,c*L,c*-B)),w.push(new e(a,c*L,c*B)),++z):w.push(new e(a,c*L,c*B))}return w}var m={};m.rayPlane=function(t,r,a){n(a)||(a=new e);var o=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON15)return void 0;var l=(-r.distance-e.dot(s,o))/c;return 0>l?void 0:(a=e.multiplyByScalar(u,l,a),e.add(o,a,a))};var y=new e,v=new e,g=new e,w=new e,x=new e;m.rayTriangle=function(t,r,a,i,o,u){var s=l(t,r,a,i,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u))};var E=new c;m.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=E;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var f=l(c,a,i,o,u);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(s)||(s=new e),e.multiplyByScalar(c.direction,f,s),e.add(c.origin,s,s))};var S={root0:0,root1:0};m.raySphere=function(e,t,r){return r=h(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var O=new c;m.lineSegmentSphere=function(t,r,a,i){var o=O;e.clone(t,o.origin);var u=e.subtract(r,t,o.direction),s=e.magnitude(u);return e.normalize(u,u),i=h(o,a,i),!n(i)||i.stop<0||i.start>s?void 0:(i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i)};var T=new e,M=new e;m.rayEllipsoid=function(t,r){var n,a,i,o,u,s=r.oneOverRadii,c=e.multiplyComponents(s,t.origin,T),l=e.multiplyComponents(s,t.direction,M),f=e.magnitudeSquared(c),h=e.dot(c,l);if(f>1){if(h>=0)return void 0;var d=h*h;if(n=f-1,a=e.magnitudeSquared(l),i=a*n,i>d)return void 0;if(d>i){o=h*h-i,u=-h+Math.sqrt(o);var p=u/a,m=n/u;return m>p?{start:p,stop:m}:{start:m,stop:p}}var y=Math.sqrt(n/a);return{start:y,stop:y}}return 1>f?(n=f-1,a=e.magnitudeSquared(l),i=a*n,o=h*h-i,u=-h+Math.sqrt(o),{start:0,stop:u/a}):0>h?(a=e.magnitudeSquared(l),{start:0,stop:-h/a}):void 0};var _=new e,P=new e,b=new e,N=new e,A=new e,I=new o,C=new o,R=new o,z=new o,D=new o,L=new o,q=new o,U=new e,B=new e,F=new t;m.grazingAltitudeLocation=function(t,r){var a=t.origin,u=t.direction,s=r.geodeticSurfaceNormal(a,_);if(e.dot(u,s)>=0)return a;var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(u,_),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,N),d=e.normalize(e.cross(h,f,P),P),m=e.normalize(e.cross(f,d,b),b),y=I;y[0]=f.x,y[1]=f.y,y[2]=f.z,y[3]=d.x,y[4]=d.y,y[5]=d.z,y[6]=m.x,y[7]=m.y,y[8]=m.z;var v=o.transpose(y,C),g=o.fromScale(r.radii,R),w=o.fromScale(r.oneOverRadii,z),x=D;x[0]=0,x[1]=-u.z,x[2]=u.y,x[3]=u.z,x[4]=0,x[5]=-u.x,x[6]=-u.y,x[7]=u.x,x[8]=0;var E,S,O=o.multiply(o.multiply(v,w,L),x,L),T=o.multiply(o.multiply(O,g,q),y,q),M=o.multiplyByVector(O,a,A),W=p(T,e.negate(M,_),0,0,1),G=W.length;if(G>0){for(var k=e.clone(e.ZERO,B),V=Number.NEGATIVE_INFINITY,Y=0;G>Y;++Y){E=o.multiplyByVector(g,o.multiplyByVector(y,W[Y],U),U);var j=e.normalize(e.subtract(E,a,N),N),H=e.dot(j,u);H>V&&(V=H,k=e.clone(E,k))}var Z=r.cartesianToCartographic(k,F);return V=i.clamp(V,0,1),S=e.magnitude(e.subtract(k,a,N))*Math.sqrt(1-V*V),S=c?-S:S,Z.height=S,r.cartographicToCartesian(Z,new e)}return void 0};var W=new e;return m.lineSegmentPlane=function(t,r,a,o){n(o)||(o=new e);var u=e.subtract(r,t,W),s=a.normal,c=e.dot(s,u);if(Math.abs(c)<i.EPSILON6)return void 0;var l=e.dot(s,t),f=-(a.distance+l)/c;return 0>f||f>1?void 0:(e.multiplyByScalar(u,f,o),e.add(t,o,o),o)},m.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if((1===l||2===l)&&(f=new e,h=new e),1===l){if(u)return m.lineSegmentPlane(t,r,a,f),m.lineSegmentPlane(t,n,a,h),{positions:[t,r,n,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return m.lineSegmentPlane(r,n,a,f),m.lineSegmentPlane(r,t,a,h),{positions:[t,r,n,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(n,t,a,f),m.lineSegmentPlane(n,r,a,h),{positions:[t,r,n,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(r,t,a,f),m.lineSegmentPlane(n,t,a,h),{positions:[t,r,n,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(n,r,a,f),m.lineSegmentPlane(t,r,a,h),{positions:[t,r,n,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,n,a,f),m.lineSegmentPlane(r,n,a,h),{positions:[t,r,n,f,h],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError"],function(e,t){"use strict";var r=function(t,r){this.normal=e.clone(t),this.distance=r};return r.fromPointNormal=function(n,a,i){var o=-e.dot(a,n);return t(i)?(e.clone(a,i.normal),i.distance=o,i):new r(a,o)},r.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},r}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t){"use strict";var r={};return r.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];o>u;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;a+1>l;l++)c[l]=0;for(var f=i+1,h=0;o>h;++h)f-c[n[h]]>i&&(c[n[h]]=f,++f);return(f-i+1)/(o/3)},r.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;n>i;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var h=r[f];a[h].numLiveTriangles&&(s=0,i-a[h].timeStamp+2*a[h].numLiveTriangles<=t&&(s=i-a[h].timeStamp),(s>l||-1===l)&&(l=s,c=h)),++f}return-1===c?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,f=0,h=o[f],d=c;if(t(u))l=u+1;else{for(;d>f;)h>l&&(l=h),++f,h=o[f];if(-1===l)return 0;++l}for(var p=[],m=0;l>m;m++)p[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var y=0;d>f;)p[o[f]].vertexTriangles.push(y),++p[o[f]].numLiveTriangles,p[o[f+1]].vertexTriangles.push(y),++p[o[f+1]].numLiveTriangles,p[o[f+2]].vertexTriangles.push(y),++p[o[f+2]].numLiveTriangles,++y,f+=3;var v=0,g=s+1;i=1;var w,x,E=[],S=[],O=0,T=[],M=c/3,_=[];for(m=0;M>m;m++)_[m]=!1;for(var P,b;-1!==v;){E=[],x=p[v],b=x.vertexTriangles.length;for(var N=0;b>N;++N)if(y=x.vertexTriangles[N],!_[y]){_[y]=!0,f=y+y+y;for(var A=0;3>A;++A)P=o[f],E.push(P),S.push(P),T[O]=P,++O,w=p[P],--w.numLiveTriangles,g-w.timeStamp>s&&(w.timeStamp=g,++g),++f}v=a(o,s,E,p,g,S,l)}return T},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,p,m,y,v,g,w,x,E,S,O,T,M){"use strict";function _(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function P(e){for(var t=e.length,r=6*(t/3),n=v.createTypedArray(t,r),a=0,i=0;t>i;i+=3,a+=6)_(n,a,e[i],e[i+1],e[i+2]);return n}function b(e){var t=e.length;if(t>=3){var r=6*(t-2),n=v.createTypedArray(t,r);_(n,0,e[0],e[1],e[2]);for(var a=6,i=3;t>i;++i,a+=6)_(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function N(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=v.createTypedArray(t,r),a=e[0],i=0,o=1;t>o;++o,i+=6)_(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function A(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new p({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function I(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function C(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,it),S.multiplyByPoint(e,it,it),a.pack(it,r,i)}function R(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;n>i;i+=3)a.unpack(r,i,it),E.multiplyByVector(e,it,it),it=a.normalize(it,it),a.pack(it,r,i)}function z(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,f=1;n>f;++f){var h=e[f][t].attributes[r];if(!c(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(a[r]=new p({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function D(e,t){var n,i,o,u,s=e.length;e[0].modelMatrix;var l,f,h,p=c(e[0][t].indices),m=e[0][t].primitiveType,y=z(e,t);for(n in y)if(y.hasOwnProperty(n))for(l=y[n].values,u=0,i=0;s>i;++i)for(f=e[i][t].attributes[n].values,h=f.length,o=0;h>o;++o)l[u++]=f[o];var g;if(p){var w=0;for(i=0;s>i;++i)w+=e[i][t].indices.length;var x=d.computeNumberOfVertices(new d({attributes:y,primitiveType:T.POINTS})),E=v.createTypedArray(x,w),S=0,O=0;for(i=0;s>i;++i){var M=e[i][t].indices,_=M.length;for(u=0;_>u;++u)E[S++]=O+M[u];O+=d.computeNumberOfVertices(e[i][t])}g=E}var P,b=new a,N=0;for(i=0;s>i;++i){if(P=e[i][t].boundingSphere,!c(P)){b=void 0;break}a.add(P.center,b,b)}if(c(b))for(a.divideByScalar(b,s,b),i=0;s>i;++i){P=e[i][t].boundingSphere;var A=a.magnitude(a.subtract(P.center,b,st))+P.radius;A>N&&(N=A)}return new d({attributes:y,indices:g,primitiveType:m,boundingSphere:c(b)?new r(b,N):void 0})}function L(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function q(e){var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;t>a;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=T.TRIANGLES,e}function U(e){var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;t-1>a;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,t>a+2&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=T.TRIANGLES,e}function B(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function F(e){var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=T.LINES,e}function W(e){var t=d.computeNumberOfVertices(e),r=v.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;t>a;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=T.LINES,e}function G(e){switch(e.primitiveType){case T.TRIANGLE_FAN:return q(e);case T.TRIANGLE_STRIP:return U(e);case T.TRIANGLES:return L(e);case T.LINE_STRIP:return F(e);case T.LINE_LOOP:return W(e);case T.LINES:return B(e)}return e}function k(e,t){Math.abs(e.y)<x.EPSILON6&&(e.y=t?-x.EPSILON6:x.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return k(e,e.y<0),k(t,t.y<0),k(r,r.y<0),void 0;var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?x.sign(e.y):x.sign(r.y):i>o?x.sign(t.y):x.sign(r.y);var u=0>n;k(e,u),k(t,u),k(r,u)}function Y(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,xt),e.y/(e.y-t.y),xt),r),a.clone(r,n),k(r,!0),k(n,!1)}function j(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;V(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Mt.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(Y(e,t,Et,Ot),Y(e,r,St,Tt),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(Y(t,r,Et,Ot),Y(t,e,St,Tt),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(Y(r,e,Et,Ot),Y(r,t,St,Tt),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(Y(r,e,Et,Ot),Y(r,t,St,Tt),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(Y(t,r,Et,Ot),Y(t,e,St,Tt),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(Y(e,t,Et,Ot),Y(e,r,St,Tt),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Mt.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Et,s[4]=St,s[5]=Ot,s[6]=Tt,s.length=7),Mt}function H(e,t){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=d.computeNumberOfVertices(e);return e.indices=v.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}function Z(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new p({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function X(e,t,r){var n=c(e.geometry.boundingSphere);t=H(t,n),r=H(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function J(e,r,i,o,u,s,l,f,h,d,p){if(c(s)||c(l)||c(f)||c(h)){var m=a.fromArray(u,3*e,_t),y=a.fromArray(u,3*r,Pt),v=a.fromArray(u,3*i,bt),g=t(o,m,y,v,Nt);if(c(s)){var w=a.fromArray(s,3*e,_t),x=a.fromArray(s,3*r,Pt),E=a.fromArray(s,3*i,bt);a.multiplyByScalar(w,g.x,w),a.multiplyByScalar(x,g.y,x),a.multiplyByScalar(E,g.z,E);var S=a.add(w,x,w);a.add(S,E,S),a.normalize(S,S),a.pack(S,d.normal.values,3*p)}if(c(l)){var O=a.fromArray(l,3*e,_t),T=a.fromArray(l,3*r,Pt),M=a.fromArray(l,3*i,bt);a.multiplyByScalar(O,g.x,O),a.multiplyByScalar(T,g.y,T),a.multiplyByScalar(M,g.z,M);var _=a.add(O,T,O);a.add(_,M,_),a.normalize(_,_),a.pack(_,d.binormal.values,3*p)}if(c(f)){var P=a.fromArray(f,3*e,_t),b=a.fromArray(f,3*r,Pt),N=a.fromArray(f,3*i,bt);a.multiplyByScalar(P,g.x,P),a.multiplyByScalar(b,g.y,b),a.multiplyByScalar(N,g.z,N);var A=a.add(P,b,P);a.add(A,N,A),a.normalize(A,A),a.pack(A,d.tangent.values,3*p)}if(c(h)){var I=n.fromArray(h,2*e,At),C=n.fromArray(h,2*r,It),R=n.fromArray(h,2*i,Ct);n.multiplyByScalar(I,g.x,I),n.multiplyByScalar(C,g.y,C),n.multiplyByScalar(R,g.z,R);var z=n.add(I,C,I);n.add(z,R,z),n.pack(z,d.st.values,2*p)}}}function K(e,t,r,n,a,i){var o=e.position.values.length/3;if(-1!==a){var u=n[a],s=r[u];return-1===s?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function Q(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,h=c(s.binormal)?s.binormal.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,p=c(s.st)?s.st.values:void 0,m=u.indices,y=Z(u),v=Z(u),g=[];g.length=l.length/3;var w=[];for(w.length=l.length/3,o=0;o<g.length;++o)g[o]=-1,w[o]=-1;var x=m.length;for(o=0;x>o;o+=3){var E=m[o],S=m[o+1],O=m[o+2],T=a.fromArray(l,3*E),M=a.fromArray(l,3*S),_=a.fromArray(l,3*O),P=j(T,M,_);if(c(P)&&P.positions.length>3)for(var b=P.positions,N=P.indices,A=N.length,I=0;A>I;++I){var C=N[I],R=b[C];R.y<0?(t=v.attributes,r=v.indices,n=g):(t=y.attributes,r=y.indices,n=w),i=K(t,r,n,m,3>C?o+C:-1,R),J(E,S,O,R,l,f,h,d,p,t,i)}else c(P)&&(T=P.positions[0],M=P.positions[1],_=P.positions[2]),T.y<0?(t=v.attributes,r=v.indices,n=g):(t=y.attributes,r=y.indices,n=w),i=K(t,r,n,m,o,T),J(E,S,O,T,l,f,h,d,p,t,i),i=K(t,r,n,m,o+1,M),J(E,S,O,M,l,f,h,d,p,t,i),i=K(t,r,n,m,o+2,_),J(E,S,O,_,l,f,h,d,p,t,i)}X(e,v,y)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=Z(r),s=Z(r),l=o.length,f=[];f.length=i.length/3;var h=[];for(h.length=i.length/3,t=0;t<f.length;++t)f[t]=-1,h[t]=-1;for(t=0;l>t;t+=2){var d=o[t],p=o[t+1],m=a.fromArray(i,3*d,_t),y=a.fromArray(i,3*p,Pt);Math.abs(m.y)<x.EPSILON6&&(m.y=m.y<0?-x.EPSILON6:x.EPSILON6),Math.abs(y.y)<x.EPSILON6&&(y.y=y.y<0?-x.EPSILON6:x.EPSILON6);var v=u.attributes,g=u.indices,E=h,S=s.attributes,O=s.indices,T=f,M=w.lineSegmentPlane(m,y,Rt,bt);if(c(M)){var _=a.multiplyByScalar(a.UNIT_Y,5*x.EPSILON9,zt);m.y<0&&(a.negate(_,_),v=s.attributes,g=s.indices,E=f,S=u.attributes,O=u.indices,T=h);var P=a.add(M,_,Dt);K(v,g,E,o,t,m),K(v,g,E,o,-1,P),a.negate(_,_),a.add(M,_,P),K(S,O,T,o,-1,P),K(S,O,T,o,t+1,y)}else{var b,N,A;m.y<0?(b=s.attributes,N=s.indices,A=f):(b=u.attributes,N=u.indices,A=h),K(b,N,A,o,t,m),K(b,N,A,o,t+1,y)}}X(e,s,u)}function et(e){var t=e.geometry,r=t.attributes,o=r.position.values,u=r.prevPosition.values,s=r.nextPosition.values,l=r.expandAndWidth.values;t.indices;var f,h,d,p=c(r.st)?r.st.values:void 0,m=c(r.color)?r.color.values:void 0,y=Z(t),v=Z(t),g=o.length/3;for(f=0;g>f;f+=4){var E=f,S=f+1,O=f+2,T=f+3,M=a.fromArray(o,3*E,Ut),_=a.fromArray(o,3*S,Bt),P=a.fromArray(o,3*O,Ft),b=a.fromArray(o,3*T,Wt);Math.abs(M.y)<x.EPSILON6&&(M.y=x.EPSILON6*(P.y<0?-1:1),_.y=M.y),Math.abs(P.y)<x.EPSILON6&&(P.y=x.EPSILON6*(M.y<0?-1:1),b.y=P.y);var N=y.attributes,A=y.indices,I=v.attributes,C=v.indices,R=w.lineSegmentPlane(M,P,Rt,Gt);if(c(R)){var z=a.multiplyByScalar(a.UNIT_Y,5*x.EPSILON9,kt);M.y<0&&(a.negate(z,z),N=v.attributes,A=v.indices,I=y.attributes,C=y.indices);var D=a.add(R,z,Vt);for(N.position.values.push(M.x,M.y,M.z,_.x,_.y,_.z),N.position.values.push(D.x,D.y,D.z),N.position.values.push(D.x,D.y,D.z),a.negate(z,z),a.add(R,z,D),I.position.values.push(D.x,D.y,D.z),I.position.values.push(D.x,D.y,D.z),I.position.values.push(P.x,P.y,P.z,b.x,b.y,b.z),h=3*E;3*E+6>h;++h)N.prevPosition.values.push(u[h]);for(N.prevPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),I.prevPosition.values.push(M.x,M.y,M.z,M.x,M.y,M.z),h=3*O;3*O+6>h;++h)I.prevPosition.values.push(u[h]);for(h=3*E;3*E+6>h;++h)N.nextPosition.values.push(s[h]);for(N.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),I.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),h=3*O;3*O+6>h;++h)I.nextPosition.values.push(s[h]);var L=n.fromArray(l,2*E,Lt),q=Math.abs(L.y);N.expandAndWidth.values.push(-1,q,1,q),N.expandAndWidth.values.push(-1,-q,1,-q),I.expandAndWidth.values.push(-1,q,1,q),I.expandAndWidth.values.push(-1,-q,1,-q);var U=a.magnitudeSquared(a.subtract(R,M,Wt));if(U/=a.magnitudeSquared(a.subtract(P,M,Wt)),c(m)){var B=i.fromArray(m,4*E,Yt),F=i.fromArray(m,4*O,Yt),W=x.lerp(B.x,F.x,U),G=x.lerp(B.y,F.y,U),k=x.lerp(B.z,F.z,U),V=x.lerp(B.w,F.w,U);for(h=4*E;4*E+8>h;++h)N.color.values.push(m[h]);for(N.color.values.push(W,G,k,V),N.color.values.push(W,G,k,V),I.color.values.push(W,G,k,V),I.color.values.push(W,G,k,V),h=4*O;4*O+8>h;++h)I.color.values.push(m[h])}if(c(p)){var Y=n.fromArray(p,2*E,Lt),j=n.fromArray(p,2*(f+3),qt),H=x.lerp(Y.x,j.x,U);for(h=2*E;2*E+4>h;++h)N.st.values.push(p[h]);for(N.st.values.push(H,Y.y),N.st.values.push(H,j.y),I.st.values.push(H,Y.y),I.st.values.push(H,j.y),h=2*O;2*O+4>h;++h)I.st.values.push(p[h])}d=N.position.values.length/3-4,A.push(d,d+2,d+1),A.push(d+1,d+2,d+3),d=I.position.values.length/3-4,C.push(d,d+2,d+1),C.push(d+1,d+2,d+3)}else{var J,K;for(M.y<0?(J=v.attributes,K=v.indices):(J=y.attributes,K=y.indices),J.position.values.push(M.x,M.y,M.z),J.position.values.push(_.x,_.y,_.z),J.position.values.push(P.x,P.y,P.z),J.position.values.push(b.x,b.y,b.z),h=3*f;3*f+12>h;++h)J.prevPosition.values.push(u[h]),J.nextPosition.values.push(s[h]);for(h=2*f;2*f+8>h;++h)J.expandAndWidth.values.push(l[h]),c(p)&&J.st.values.push(p[h]);if(c(m))for(h=4*f;4*f+16>h;++h)J.color.values.push(m[h]);d=J.position.values.length/3-4,K.push(d,d+2,d+1),K.push(d+1,d+2,d+3)}}X(e,v,y)}var tt={};tt.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case T.TRIANGLES:e.indices=P(t);break;case T.TRIANGLE_STRIP:e.indices=b(t);break;case T.TRIANGLE_FAN:e.indices=N(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=T.LINES}return e},tt.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),f=0,h=0;o>h;h+=3)l[f++]=a[h],l[f++]=a[h+1],l[f++]=a[h+2],l[f++]=a[h]+i[h]*n,l[f++]=a[h+1]+i[h+1]*n,l[f++]=a[h+2]+i[h+2]*n;
var m,y=e.boundingSphere;return c(y)&&(m=new r(y.center,y.radius+n)),new d({attributes:{position:new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:T.LINES,boundingSphere:m})},tt.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},tt.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;t>a;a++)n[a]=-1;for(var i,o=r,s=o.length,l=v.createTypedArray(t,s),f=0,h=0,p=0;s>f;)i=n[o[f]],-1!==i?l[h]=i:(i=o[f],n[i]=p,l[h]=p,++p),++f,++h;e.indices=l;var m=e.attributes;for(var y in m)if(m.hasOwnProperty(y)&&c(m[y])&&c(m[y].values)){for(var g=m[y],w=g.values,x=0,E=g.componentsPerAttribute,S=u.createTypedArray(g.componentDatatype,p*E);t>x;){var O=n[x];if(-1!==O)for(a=0;E>a;a++)S[E*O+a]=w[E*x+a];++x}g.values=S}}return e},tt.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===T.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;n>i;i++)r[i]>a&&(a=r[i]);e.indices=M.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},tt.fitToUnsignedShortIndices=function(e){var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>x.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=A(e.attributes),s=e.indices,l=s.length;e.primitiveType===T.TRIANGLES?n=3:e.primitiveType===T.LINES?n=2:e.primitiveType===T.POINTS&&(n=1);for(var f=0;l>f;f+=n){for(var h=0;n>h;++h){var p=s[f+h],m=a[p];c(m)||(m=o++,a[p]=m,I(u,e.attributes,p)),i.push(m)}o+n>x.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=A(e.attributes))}0!==i.length&&t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var rt=new a,nt=new o;tt.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new h;for(var s=i.ellipsoid,f=o.values,d=new Float64Array(f.length),m=0,y=0;y<f.length;y+=3){var v=a.fromArray(f,y,rt),g=s.cartesianToCartographic(v,nt);if(!c(g))throw new l("Could not project point ("+v.x+", "+v.y+", "+v.z+") to 2D.");var w=i.project(g,rt);d[m++]=w.x,d[m++]=w.y,d[m++]=w.z}return e.attributes[r]=o,e.attributes[n]=new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var at={high:0,low:0};tt.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;o>l;++l)f.encode(i[l],at),s[l]=at.high,c[l]=at.low;var h=a.componentsPerAttribute;return e.attributes[r]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:s}),e.attributes[n]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:h,values:c}),delete e.attributes[t],e};var it=new a,ot=new S,ut=new E;tt.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(S.equals(t,S.IDENTITY))return e;var n=e.geometry.attributes;C(t,n.position),C(t,n.prevPosition),C(t,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(S.inverse(t,ot),S.transpose(ot,ot),S.getRotation(ot,ut),R(ut,n.normal),R(ut,n.binormal),R(ut,n.tangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=S.clone(S.IDENTITY),e};var st=new a;tt.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;n>a;++a){var i=e[a];c(i.geometry)?t.push(i):r.push(i)}var o=[];return t.length>0&&o.push(D(t,"geometry")),r.length>0&&(o.push(D(r,"westHemisphereGeometry")),o.push(D(r,"eastHemisphereGeometry"))),o};var ct=new a,lt=new a,ft=new a,ht=new a;tt.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),f=0;i>f;f++)s[f]={indexOffset:0,count:0,currentCount:0};var h=0;for(f=0;o>f;f+=3){var d=t[f],m=t[f+1],y=t[f+2],v=3*d,g=3*m,w=3*y;lt.x=n[v],lt.y=n[v+1],lt.z=n[v+2],ft.x=n[g],ft.y=n[g+1],ft.z=n[g+2],ht.x=n[w],ht.y=n[w+1],ht.z=n[w+2],s[d].count++,s[m].count++,s[y].count++,a.subtract(ft,lt,ft),a.subtract(ht,lt,ht),c[h]=a.cross(ft,ht,new a),h++}var x=0;for(f=0;i>f;f++)s[f].indexOffset+=x,x+=s[f].count;h=0;var E;for(f=0;o>f;f+=3){E=s[t[f]];var S=E.indexOffset+E.currentCount;l[S]=h,E.currentCount++,E=s[t[f+1]],S=E.indexOffset+E.currentCount,l[S]=h,E.currentCount++,E=s[t[f+2]],S=E.indexOffset+E.currentCount,l[S]=h,E.currentCount++,h++}var O=new Float32Array(3*i);for(f=0;i>f;f++){var T=3*f;if(E=s[f],E.count>0){for(a.clone(a.ZERO,ct),h=0;h<E.count;h++)a.add(ct,c[l[E.indexOffset+h]],ct);a.normalize(ct,ct),O[T]=ct.x,O[T+1]=ct.y,O[T+2]=ct.z}else O[T]=0,O[T+1]=0,O[T+2]=1}return e.attributes.normal=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:O}),e};var dt=new a,pt=new a,mt=new a;tt.computeBinormalAndTangent=function(e){e.attributes;for(var t=e.indices,r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,h,d;for(l=0;s>l;l+=3){var m=t[l],y=t[l+1],v=t[l+2];f=3*m,h=3*y,d=3*v;var g=2*m,w=2*y,x=2*v,E=r[f],S=r[f+1],O=r[f+2],T=i[g],M=i[g+1],_=i[w+1]-M,P=i[x+1]-M,b=1/((i[w]-T)*P-(i[x]-T)*_),N=(P*(r[h]-E)-_*(r[d]-E))*b,A=(P*(r[h+1]-S)-_*(r[d+1]-S))*b,I=(P*(r[h+2]-O)-_*(r[d+2]-O))*b;c[f]+=N,c[f+1]+=A,c[f+2]+=I,c[h]+=N,c[h+1]+=A,c[h+2]+=I,c[d]+=N,c[d+1]+=A,c[d+2]+=I}var C=new Float32Array(3*o),R=new Float32Array(3*o);for(l=0;o>l;l++){f=3*l,h=f+1,d=f+2;var z=a.fromArray(n,f,dt),D=a.fromArray(c,f,mt),L=a.dot(z,D);a.multiplyByScalar(z,L,pt),a.normalize(a.subtract(D,pt,D),D),R[f]=D.x,R[h]=D.y,R[d]=D.z,a.normalize(a.cross(z,D,D),D),C[f]=D.x,C[h]=D.y,C[d]=D.z}return e.attributes.tangent=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:R}),e.attributes.binormal=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:C}),e};var yt=new n,vt=new a,gt=new a,wt=new a;tt.compressVertices=function(t){var r=t.attributes.normal,i=t.attributes.st;if(!c(r)&&!c(i))return t;var o,s,l,f,h=t.attributes.tangent,d=t.attributes.binormal;c(r)&&(o=r.values),c(i)&&(s=i.values),c(h)&&(l=h.values),d&&(f=d.values);var m=c(o)?o.length:s.length,y=c(o)?3:2,v=m/y,g=v,w=c(s)&&c(o)?2:1;w+=c(l)||c(f)?1:0,g*=w;for(var x=new Float32Array(g),E=0,S=0;v>S;++S){c(s)&&(n.fromArray(s,2*S,yt),x[E++]=e.compressTextureCoordinates(yt));var O=3*S;c(o)&&c(l)&&c(f)?(a.fromArray(o,O,vt),a.fromArray(l,O,gt),a.fromArray(f,O,wt),e.octPack(vt,gt,wt,yt),x[E++]=yt.x,x[E++]=yt.y):(c(o)&&(a.fromArray(o,O,vt),x[E++]=e.octEncodeFloat(vt)),c(l)&&(a.fromArray(l,O,vt),x[E++]=e.octEncodeFloat(vt)),c(f)&&(a.fromArray(f,O,vt),x[E++]=e.octEncodeFloat(vt)))}return t.attributes.compressedAttributes=new p({componentDatatype:u.FLOAT,componentsPerAttribute:w,values:x}),c(o)&&delete t.attributes.normal,c(s)&&delete t.attributes.st,c(l)&&delete t.attributes.tangent,c(f)&&delete t.attributes.binormal,t};var xt=new a,Et=new a,St=new a,Ot=new a,Tt=new a,Mt={positions:new Array(7),indices:new Array(9)},_t=new a,Pt=new a,bt=new a,Nt=new a,At=new n,It=new n,Ct=new n,Rt=O.fromPointNormal(a.ZERO,a.UNIT_Y),zt=new a,Dt=new a,Lt=new n,qt=new n,Ut=new a,Bt=new a,Ft=new a,Wt=new a,Gt=new a,kt=new a,Vt=new a,Yt=new i;return new i,tt.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersect(n,i.UNIT_Y)!==g.INTERSECTING)return e}if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:et(e);break;case y.TRIANGLES:Q(e);break;case y.LINES:$(e)}else G(t),t.primitiveType===T.TRIANGLES?Q(e):t.primitiveType===T.LINES&&$(e);return e},tt}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,r,n,a){"use strict";var i=function(n,a,i){this.minimum=e.clone(t(n,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),r(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i};i.fromPoints=function(t,n){if(r(n)||(n=new i),!r(t)||0===t.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var d=t[h],p=d.x,m=d.y,y=d.z;a=Math.min(p,a),s=Math.max(p,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(y,u),l=Math.max(y,l)}var v=n.minimum;v.x=a,v.y=o,v.z=u;var g=n.maximum;g.x=s,g.y=c,g.z=l;var w=e.add(v,g,n.center);return e.multiplyByScalar(w,.5,w),n},i.clone=function(t,n){return r(t)?r(n)?(n.minimum=e.clone(t.minimum,n.minimum),n.maximum=e.clone(t.maximum,n.maximum),n.center=e.clone(t.center,n.center),n):new i(t.minimum,t.maximum):void 0},i.equals=function(t,n){return t===n||r(t)&&r(n)&&e.equals(t.center,n.center)&&e.equals(t.minimum,n.minimum)&&e.equals(t.maximum,n.maximum)};var o=new e;return i.intersect=function(t,r){o=e.subtract(t.maximum,t.minimum,o);var n=e.multiplyByScalar(o,.5,o),i=n.x*Math.abs(r.x)+n.y*Math.abs(r.y)+n.z*Math.abs(r.z),u=e.dot(t.center,r)+r.w;return u-i>0?a.INSIDE:0>u+i?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersect=function(e){return i.intersect(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,a){return t(e).then(r,n,a)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=a(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function a(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(a){return i(a)}});return r}function o(){function e(e,t,r){return h(e,t,r)}function r(e){return p(e)}function a(e){return p(i(e))}function u(e){return d(e)}var s,c,l,f,h,d,p;return c=new n(e),s={then:e,resolve:r,reject:a,progress:u,promise:c,resolver:{resolve:r,reject:a,progress:u}},l=[],f=[],h=function(e,t,r){var n,a;return n=o(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,a)}),f.push(a),n.promise},d=function(e){return m(f,e),e},p=function(e){return e=t(e),h=e.then,p=t,d=v,m(l,e),f=l=E,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,a,i){return y(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){p(e)}var c,l,f,h,d,p,m,y,g,w;if(g=t.length>>>0,c=Math.max(0,Math.min(r,g)),f=[],l=g-c+1,h=[],d=o(),c)for(y=d.progress,m=function(e){h.push(e),--l||(p=m=v,d.reject(h))},p=function(e){f.push(e),--c||(p=m=v,d.resolve(f))},w=0;g>w;++w)w in t&&e(t[w],s,u,y);else d.resolve(f);return d.then(n,a,i)})}function c(e,t,r,n){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,r,n)}function l(e,t,r,n){return y(1,arguments),h(e,g).then(t,r,n)}function f(){return h(arguments,g)}function h(t,r){return e(t,function(t){var n,a,i,u,s,c;if(i=a=t.length>>>0,n=[],c=o(),i)for(u=function(t,a){e(t,r).then(function(e){n[a]=e,--i||c.resolve(n)},c.reject)},s=0;a>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function d(t,r){var n=x.call(arguments,1);return e(t,function(t){var a;return a=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,a)})})},w.apply(t,n)})}function p(t,r,n){var a=arguments.length>2;return e(t,function(e){return e=a?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function y(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function v(){}function g(e){return e}var w,x,E;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=p,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(E,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(E,t)})})}},x=[].slice,w=[].reduce||function(e){var t,r,n,a,i;if(i=0,t=Object(this),a=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=a)throw new TypeError}else n=r[1];for(;a>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(){"use strict";var e=function(e,t,r){for(var n,a,i=0,o=e.length-1;o>=i;)if(n=~~((i+o)/2),a=r(e[n],t),0>a)i=n+1;else{if(!(a>0))return n;o=n-1}return~(o+1)};return e}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,n,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=a};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],a=function(e,t,r,n){r||(r=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+a:a+e},i=function(e,t,r,n,i,o){var u=n-e.length;return u>0&&(e=r||!i?a(e,n,o,r):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+a(c.toString(t),u||0,"0",!1),i(e,r,n,o,s)},u=function(e,t,r,n,a,o){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,a,o)},s=function(e,n,s,c,l,f,h){var d,p,m,y,v;if("%%"==e)return"%";for(var g=!1,w="",x=!1,E=!1,S=" ",O=s.length,T=0;s&&O>T;T++)switch(s.charAt(T)){case" ":w=" ";break;case"+":w="+";break;case"-":g=!0;break;case"'":S=s.charAt(T+1);break;case"0":x=!0;break;case"#":E=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,g=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,v=n?t[n.slice(0,-1)]:t[r++],h){case"s":return u(String(v),g,c,f,x,S);case"c":return u(String.fromCharCode(+v),g,c,f,x);case"b":return o(v,2,E,g,c,f,x);case"o":return o(v,8,E,g,c,f,x);case"x":return o(v,16,E,g,c,f,x);case"X":return o(v,16,E,g,c,f,x).toUpperCase();case"u":return o(v,10,E,g,c,f,x);case"i":case"d":return d=+v||0,d=Math.round(d-d%1),p=0>d?"-":w,v=p+a(String(Math.abs(d)),f,"0",!1),i(v,p,g,c,x);case"e":case"E":case"f":case"F":case"g":case"G":return d=+v,p=0>d?"-":w,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],v=p+Math.abs(d)[m](f),i(v,p,g,c,x)[y]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,r,n,a,i,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(){"use strict";function e(e){return 0===e%4&&0!==e%100||0===e%400}return e}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function l(e,t){return N.compare(e.julianDate,t.julianDate)}function f(e){g.julianDate=e;var r=N.leapSeconds,n=t(r,g,l);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var a=r[n].offset;if(n>0){var i=N.secondsDifference(r[n].julianDate,e);i>a&&(n--,a=r[n].offset)}N.addSeconds(e,a,e)}function h(e,r){g.julianDate=e;var n=N.leapSeconds,a=t(n,g,l);if(0>a&&(a=~a),0===a)return N.addSeconds(e,-n[0].offset,r);if(a>=n.length)return N.addSeconds(e,-n[a-1].offset,r);var i=N.secondsDifference(n[a].julianDate,e);return 0===i?N.addSeconds(e,-n[a].offset,r):1>=i?void 0:N.addSeconds(e,-n[--a].offset,r)}function d(e,t,r){var n=0|t/s.SECONDS_PER_DAY;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,a,i,o){var u=0|(t-14)/12,c=e+4800+u,l=(0|1461*c/4)+(0|367*(t-2-12*u)/12)-(0|3*((c+100)/100)/4)+r-32075;n-=12,0>n&&(n+=24);var f=i+(n*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}var m=new i,y=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,g=new u,w=/^(\d{4})$/,x=/^(\d{4})-(\d{2})$/,E=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,O=/^(\d{4})-?(\d{2})-?(\d{2})$/,T=/([Z+\-])?(\d{2})?:?(\d{2})?$/,M=/^(\d{2})(\.\d+)?/.source+T.source,_=/^(\d{2}):?(\d{2})(\.\d+)?/.source+T.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+T.source,b="Invalid ISO 8601 date.",N=function(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,d(a,t,this),n===c.UTC&&f(this)};N.fromDate=function(e,t){var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(d(r[0],r[1],t),f(t),t):new N(r[0],r[1],c.UTC)},N.fromIso8601=function(e,t){e=e.replace(",",".");var r,i,u,s=e.split("T"),l=1,h=1,m=0,g=0,T=0,A=0,I=s[0],C=s[1];if(!n(I))throw new a(b);var R;if(s=I.match(O),null!==s){if(R=I.split("-").length-1,R>0&&2!==R)throw new a(b);r=+s[1],l=+s[2],h=+s[3]}else if(s=I.match(x),null!==s)r=+s[1],l=+s[2];else if(s=I.match(w),null!==s)r=+s[1];else{var z;if(s=I.match(E),null!==s){if(r=+s[1],z=+s[2],u=o(r),1>z||u&&z>366||!u&&z>365)throw new a(b)}else{if(s=I.match(S),null===s)throw new a(b);r=+s[1];var D=+s[2],L=+s[3]||0;if(R=I.split("-").length-1,R>0&&(!n(s[3])&&1!==R||n(s[3])&&2!==R))throw new a(b);var q=new Date(Date.UTC(r,0,4));z=7*D+L-q.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(z),l=i.getUTCMonth()+1,h=i.getUTCDate()}if(u=o(r),1>l||l>12||1>h||(2!==l||!u)&&h>y[l-1]||u&&2===l&&h>v)throw new a(b);var U;if(n(C)){if(s=C.match(P),null!==s){if(R=C.split(":").length-1,R>0&&2!==R&&3!==R)throw new a(b);m=+s[1],g=+s[2],T=+s[3],A=1e3*+(s[4]||0),U=5}else if(s=C.match(_),null!==s){if(R=C.split(":").length-1,R>0&&1!==R)throw new a(b);m=+s[1],g=+s[2],T=60*+(s[3]||0),U=4}else{if(s=C.match(M),null===s)throw new a(b);m=+s[1],g=60*+(s[2]||0),U=3}if(g>=60||T>=61||m>24||24===m&&(g>0||T>0||A>0))throw new a(b);var B=s[U],F=+s[U+1],W=+(s[U+2]||0);switch(B){case"+":m-=F,g-=W;break;case"-":m+=F,g+=W;break;case"Z":break;default:g+=new Date(Date.UTC(r,l-1,h,m,g)).getTimezoneOffset()}}else g+=new Date(r,l-1,h).getTimezoneOffset();var G=60===T;for(G&&T--;g>=60;)g-=60,m++;for(;m>=24;)m-=24,h++;for(i=u&&2===l?v:y[l-1];h>i;)h-=i,l++,l>12&&(l-=12,r++),i=u&&2===l?v:y[l-1];for(;0>g;)g+=60,m--;for(;0>m;)m+=24,h--;for(;1>h;)l--,1>l&&(l+=12,r--),i=u&&2===l?v:y[l-1],h+=i;var k=p(r,l,h,m,g,T,A);return n(t)?(d(k[0],k[1],t),f(t)):t=new N(k[0],k[1],c.UTC),G&&N.addSeconds(t,1,t),t},N.now=function(e){return N.fromDate(new Date,e)};var A=new N(0,0,c.TAI);return N.toGregorianDate=function(e,t){var r=!1,a=h(e,A);n(a)||(N.addSeconds(e,-1,A),a=h(A,A),r=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=0|o+68569,l=0|4*c/146097;c=0|c-(0|(146097*l+3)/4);var f=0|4e3*(c+1)/1461001;c=0|c-(0|1461*f/4)+31;var d=0|80*c/2447,p=0|c-(0|2447*d/80);c=0|d/11;var m=0|d+2-12*c,y=0|100*(l-49)+f+c,v=0|u/s.SECONDS_PER_HOUR,g=u-v*s.SECONDS_PER_HOUR,w=0|g/s.SECONDS_PER_MINUTE;g-=w*s.SECONDS_PER_MINUTE;var x=0|g,E=(g-x)/s.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),r&&(x+=1),n(t)?(t.year=y,t.month=m,t.day=p,t.hour=v,t.minute=w,t.second=x,t.millisecond=E,t.isLeapSecond=r,t):new i(y,m,p,v,w,x,E,r)},N.toDate=function(e){var t=N.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},N.toIso8601=function(t,r){var a,i=N.toGregorianDate(t,i);return n(r)||0===i.millisecond?n(r)&&0!==r?(a=(.01*i.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},N.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new N(e.dayNumber,e.secondsOfDay,c.TAI):void 0},N.compare=function(e,t){var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},N.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},N.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(N.secondsDifference(e,t))<=r},N.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},N.secondsDifference=function(e,t){var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},N.daysDifference=function(e,t){var r=e.dayNumber-t.dayNumber,n=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+n},N.computeTaiMinusUtc=function(e){g.julianDate=e;var r=N.leapSeconds,n=t(r,g,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},N.addSeconds=function(e,t,r){return d(e.dayNumber,e.secondsOfDay+t,r)},N.addMinutes=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,n,r)},N.addHours=function(e,t,r){var n=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,n,r)},N.addDays=function(e,t,r){var n=e.dayNumber+t;return d(n,e.secondsOfDay,r)},N.lessThan=function(e,t){return N.compare(e,t)<0},N.lessThanOrEquals=function(e,t){return N.compare(e,t)<=0},N.greaterThan=function(e,t){return N.compare(e,t)>0},N.greaterThanOrEquals=function(e,t){return N.compare(e,t)>=0},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.equalsEpsilon=function(e,t){return N.equalsEpsilon(this,e,t)},N.prototype.toString=function(){return N.toIso8601(this)},N.leapSeconds=[new u(new N(2441317,43210,c.TAI),10),new u(new N(2441499,43211,c.TAI),11),new u(new N(2441683,43212,c.TAI),12),new u(new N(2442048,43213,c.TAI),13),new u(new N(2442413,43214,c.TAI),14),new u(new N(2442778,43215,c.TAI),15),new u(new N(2443144,43216,c.TAI),16),new u(new N(2443509,43217,c.TAI),17),new u(new N(2443874,43218,c.TAI),18),new u(new N(2444239,43219,c.TAI),19),new u(new N(2444786,43220,c.TAI),20),new u(new N(2445151,43221,c.TAI),21),new u(new N(2445516,43222,c.TAI),22),new u(new N(2446247,43223,c.TAI),23),new u(new N(2447161,43224,c.TAI),24),new u(new N(2447892,43225,c.TAI),25),new u(new N(2448257,43226,c.TAI),26),new u(new N(2448804,43227,c.TAI),27),new u(new N(2449169,43228,c.TAI),28),new u(new N(2449534,43229,c.TAI),29),new u(new N(2450083,43230,c.TAI),30),new u(new N(2450630,43231,c.TAI),31),new u(new N(2451179,43232,c.TAI),32),new u(new N(2453736,43233,c.TAI),33),new u(new N(2454832,43234,c.TAI),34),new u(new N(2456109,43235,c.TAI),35)],N}),define("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var a=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n&&(o=t(o,n)),a[i]=o}return a};return t}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var a=r[n],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var r=function(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))};return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,r,n,a,i){"use strict";function o(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function u(e,t){for(var r=o(e,t),n=new ArrayBuffer(r.length),a=new Uint8Array(n),i=0;i<r.length;i++)a[i]=r.charCodeAt(i);return n}function s(e,r){r=t(r,"");var a=e[1],i=!!e[2],s=e[3];switch(r){case"":case"text":return o(i,s);case"arraybuffer":return u(i,s);case"blob":var c=u(i,s);return new Blob([c],{type:a});case"document":var l=new DOMParser;return l.parseFromString(o(i,s),a);case"json":return JSON.parse(o(i,s));default:throw new n("Unhandled responseType: "+r)}}var c=function(r){r=t(r,t.EMPTY_OBJECT);var n=r.responseType,a=t(r.method,"GET"),i=r.data,o=r.headers,u=r.overrideMimeType;return e(r.url,function(t){var r=e.defer();return c.load(t,n,a,i,o,r,u),r.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return c.load=function(e,t,n,o,u,c,f){var h=l.exec(e);if(null!==h)return c.resolve(s(h,t)),void 0;var d=new XMLHttpRequest;if(r(f)&&r(d.overrideMimeType)&&d.overrideMimeType(f),d.open(n,e,!0),r(u))for(var p in u)u.hasOwnProperty(p)&&d.setRequestHeader(p,u[p]);r(t)&&(d.responseType=t),d.onload=function(){200===d.status?r(d.response)?c.resolve(d.response):r(d.responseXML)&&d.responseXML.hasChildNodes()?c.resolve(d.responseXML):r(d.responseText)?c.resolve(d.responseText):c.reject(new i("unknown XMLHttpRequest response type.")):c.reject(new a(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(){c.reject(new a)},d.send(o)},c.defaultLoad=c.load,c}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,n){"use strict";var a={Accept:"application/json,*/*;q=0.01"},i=function(r,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,n(r,i).then(function(e){return JSON.parse(e)})};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function h(e,t){return o.compare(e.julianDate,t)}function d(e,r){if(!n(r.columnNames))return e._dataError="Error in loaded EOP data: The columnNames property is required.",void 0;if(!n(r.samples))return e._dataError="Error in loaded EOP data: The samples property is required.",void 0;var a=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>a||0>i||0>s||0>c||0>d||0>p||0>m)return e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns",void 0;var y=e._samples=r.samples,v=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var g,w=e._addNewLeapSeconds,x=0,E=y.length;E>x;x+=e._columnCount){var S=y[x+a],O=y[x+m],T=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(T,O,f.TAI);if(v.push(M),w){if(O!==g&&n(g)){var _=o.leapSeconds,P=t(_,M,h);if(0>P){var b=new u(M,O);_.splice(~P,0,b)}}g=O}}}function p(e,t,r,n,a){var i=r*n;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function y(e,t,r,n,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||n.equals(c))return p(e,r,a,s,u),u;if(n.equals(l))return p(e,r,i,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),h=a*s,d=i*s,y=r[h+e._ut1MinusUtcSecondsColumn],v=r[d+e._ut1MinusUtcSecondsColumn],g=v-y;if(g>.5||-.5>g){var w=r[h+e._taiMinusUtcSecondsColumn],x=r[d+e._taiMinusUtcSecondsColumn];w!==x&&(l.equals(n)?y=v:v-=x-w)}return u.xPoleWander=m(f,r[h+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[h+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[h+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[h+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,y,v),u}var v=function(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){d(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return v.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),v.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},v.prototype.compute=function(e,r){if(!n(this._samples)){if(n(this._dataError))throw new c(this._dataError);return void 0}if(n(r)||(r=new a(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=i[u],h=i[u+1],d=o.lessThanOrEquals(f,e),p=!n(h),m=p||o.greaterThanOrEquals(h,e);if(d&&m)return s=u,!p&&h.equals(e)&&++s,l=s+1,y(this,i,this._samples,e,s,l,r),r}var v=t(i,e,o.compare,this._dateColumn);return v>=0?(v<i.length-1&&i[v+1].equals(e)&&++v,s=v,l=v):(l=~v,s=l-1,0>s&&(s=0)),this._lastIndex=s,y(this,i,this._samples,e,s,l,r),r},v}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")
}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(r.path=t.authority&&""==t.path?"/"+this.path:t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,n){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),a=f.exec(n);if(null!==a)return a[1]}return void 0}function i(){if(t(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:a(),!t(n))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(t){return new e(t).resolve(i()).toString()}var s,c,l,f=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){t(c)||(c=t(n.toUrl)?o:u),t(l)||(l=document.createElement("a"));var r=c(e);return l.href=r,l.href=l.href,l.href};return h._cesiumScriptRegex=f,h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function c(r,a){if(r._chunkDownloadsInProgress[a])return r._chunkDownloadsInProgress[a];var i=e.defer();r._chunkDownloadsInProgress[a]=i;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){r._chunkDownloadsInProgress[a]=!1;for(var t=r._samples,n=e.samples,o=3*a*r._samplesPerXysFile,u=0,s=n.length;s>u;++u)t[o+u]=n[u];i.resolve()}),i.promise}var l=function(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;t>=s;++s){n[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;t>=c;++c)c!==s&&(n[s]*=s-c);n[s]=1/n[s]}this._work=new Array(t+1),this._coef=new Array(t+1)},f=new i(0,0,u.TAI);return l.prototype.preload=function(t,r,n,a){var i=s(this,t,r),o=s(this,n,a),u=0|i/this._stepSizeDays-this._interpolationOrder/2;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var f=0|u/this._samplesPerXysFile,h=0|l/this._samplesPerXysFile,d=[],p=f;h>=p;++p)d.push(c(this,p));return e.all(d)},l.prototype.computeXysRadians=function(e,t,r){var i=s(this,e,t);if(0>i)return void 0;var o=0|i/this._stepSizeDays;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(0|u/2);0>l&&(l=0);var f=l+u;f>=this._totalSamples&&(f=this._totalSamples-1,l=f-u,0>l&&(l=0));var h=!1,d=this._samples;if(n(d[3*l])||(c(this,0|l/this._samplesPerXysFile),h=!0),n(d[3*f])||(c(this,0|f/this._samplesPerXysFile),h=!0),h)return void 0;n(r)?(r.x=0,r.y=0,r.s=0):r=new a(0,0,0);var p,m,y=i-l*this._stepSizeDays,v=this._work,g=this._denominators,w=this._coef,x=this._xTable;for(p=0;u>=p;++p)v[p]=y-x[p];for(p=0;u>=p;++p){for(w[p]=1,m=0;u>=m;++m)m!==p&&(w[p]*=v[m]);w[p]*=g[p];var E=3*(l+p);r.x+=w[p]*d[E++],r.y+=w[p]*d[E++],r.s+=w[p]*d[E]}return r},l}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,a,i,o,u){"use strict";var s=function(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)},c=new e;s.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);c=e.normalize(t,c);var u=c.x*o,l=c.y*o,f=c.z*o,h=Math.cos(i);return r(a)?(a.x=u,a.y=l,a.z=f,a.w=h,a):new s(u,l,f,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,t){var n,a,i,o,c,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],p=e[u.COLUMN2ROW2],m=h+d+p;if(m>0)n=Math.sqrt(m+1),c=.5*n,n=.5/n,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,i=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,o=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var y=l,v=0;d>h&&(v=1),p>h&&p>d&&(v=2);var g=y[v],w=y[g];n=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(g,g)]-e[u.getElementIndex(w,w)]+1);var x=f;x[v]=.5*n,n=.5/n,c=(e[u.getElementIndex(w,g)]-e[u.getElementIndex(g,w)])*n,x[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*n,x[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*n,a=-x[0],i=-x[1],o=-x[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=c,t):new s(a,i,o,c)};var h=new s;s.fromHeadingPitchRoll=function(t,r,n,a){var i=s.fromAxisAngle(e.UNIT_X,n,h),o=s.fromAxisAngle(e.UNIT_Y,-r,a);a=s.multiply(o,i,o);var u=s.fromAxisAngle(e.UNIT_Z,-t,h);return s.multiply(u,a,a)};var d=new e,p=new e,m=new s,y=new s,v=new s;s.packedLength=4,s.pack=function(e,r,n){n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w},s.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new s),a.x=e[n],a.y=e[n+1],a.z=e[n+2],a.w=e[n+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,v),s.conjugate(v,v);for(var a=0,i=r-t+1;i>a;a++){var o=3*a;s.unpack(e,4*(t+a),m),s.multiply(m,v,m),m.w<0&&s.negate(m,m),s.computeAxis(m,d);var u=s.computeAngle(m);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new s),e.fromArray(t,0,p);var u=e.magnitude(p);return s.unpack(n,4*i,y),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(p,u,m),s.multiply(m,y,o)},s.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},s.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,t){var r=1/s.magnitude(e),n=e.x*r,a=e.y*r,i=e.z*r,o=e.w*r;return t.x=n,t.y=a,t.z=i,t.w=o,t},s.inverse=function(e,t){var r=s.magnitudeSquared(e);return t=s.conjugate(e,t),s.multiplyByScalar(t,1/r,t)},s.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},s.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},s.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},s.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},s.multiply=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+n*l+a*c-i*s,h=o*s-n*c+a*l+i*u,d=o*c+n*s-a*u+i*l,p=o*l-n*u-a*s-i*c;return r.x=f,r.y=h,r.z=d,r.w=p,r},s.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},s.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},s.computeAxis=function(e,t){var r=e.w;if(Math.abs(r-1)<o.EPSILON6)return t.x=t.y=t.z=0,t;var n=1/Math.sqrt(1-r*r);return t.x=e.x*n,t.y=e.y*n,t.z=e.z*n,t},s.computeAngle=function(e){return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var g=new s;s.lerp=function(e,t,r,n){return g=s.multiplyByScalar(t,r,g),n=s.multiplyByScalar(e,1-r,n),s.add(g,n,n)};var w=new s,x=new s,E=new s;s.slerp=function(e,t,r,n){var a=s.dot(e,t),i=t;if(0>a&&(a=-a,i=w=s.negate(t,w)),1-a<o.EPSILON6)return s.lerp(e,i,r,n);var u=Math.acos(a);return x=s.multiplyByScalar(e,Math.sin((1-r)*u),x),E=s.multiplyByScalar(i,Math.sin(r*u),E),n=s.add(x,E,n),s.multiplyByScalar(n,1/Math.sin(u),n)},s.log=function(t,r){var n=o.acosClamped(t.w),a=0;return 0!==n&&(a=n/Math.sin(n)),e.multiplyByScalar(t,a,r)},s.exp=function(t,r){var n=e.magnitude(t),a=0;return 0!==n&&(a=Math.sin(n)/n),r.x=t.x*a,r.y=t.y*a,r.z=t.z*a,r.w=Math.cos(n),r};var S=new e,O=new e,T=new s,M=new s;s.computeInnerQuadrangle=function(t,r,n,a){var i=s.conjugate(r,T);s.multiply(i,n,M);var o=s.log(M,S);s.multiply(i,t,M);var u=s.log(M,O);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),s.exp(o,T),s.multiply(r,T,a)},s.squad=function(e,t,r,n,a,i){var o=s.slerp(e,t,a,T),u=s.slerp(r,n,a,M);return s.slerp(o,u,2*a*(1-a),i)};for(var _=new s,P=1.9011074535173003,b=a.supportsTypedArrays()?new Float32Array(8):[],N=a.supportsTypedArrays()?new Float32Array(8):[],A=a.supportsTypedArrays()?new Float32Array(8):[],I=a.supportsTypedArrays()?new Float32Array(8):[],C=0;7>C;++C){var R=C+1,z=2*R+1;b[C]=1/(R*z),N[C]=R/z}return b[7]=P/136,N[7]=8*P/17,s.fastSlerp=function(e,t,r,n){var a,i=s.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-r,c=r*r,l=u*u,f=7;f>=0;--f)A[f]=(b[f]*c-N[f])*o,I[f]=(b[f]*l-N[f])*o;var h=a*r*(1+A[0]*(1+A[1]*(1+A[2]*(1+A[3]*(1+A[4]*(1+A[5]*(1+A[6]*(1+A[7])))))))),d=u*(1+I[0]*(1+I[1]*(1+I[2]*(1+I[3]*(1+I[4]*(1+I[5]*(1+I[6]*(1+I[7])))))))),p=s.multiplyByScalar(e,d,_);return s.multiplyByScalar(t,h,n),s.add(p,n,n)},s.fastSquad=function(e,t,r,n,a,i){var o=s.fastSlerp(e,t,a,T),u=s.fastSlerp(r,n,a,M);return s.fastSlerp(o,u,2*a*(1-a),i)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,p,m,y,v){"use strict";var g={},w=new r,x=new r,E=new r;g.eastNorthUpToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-o,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-o,0,e.x,1,0,0,e.y,0,0,o,e.z,0,0,0,1)}var u=w,s=x,l=E;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=s.x,n[1]=s.y,n[2]=s.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=u.x,n[9]=u.y,n[10]=u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(s.x,l.x,u.x,e.x,s.y,l.y,u.y,e.y,s.z,l.z,u.z,e.z,0,0,0,1)};var S=new r,O=new r,T=new r;g.northEastDownToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-o,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-o,0,0,e.x,0,1,0,e.y,0,0,-o,e.z,0,0,0,1)}var u=S,s=O,l=T;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=-u.x,n[9]=-u.y,n[10]=-u.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,s.x,-u.x,e.x,l.y,s.y,-u.y,e.y,l.z,s.z,-u.z,e.z,0,0,0,1)},g.northUpEastToFixedFrame=function(e,t,n){if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var o=d.sign(e.z);return i(n)?(n[0]=-o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=o,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-o,0,0,e.x,0,0,1,e.y,0,o,0,e.z,0,0,0,1)}var u=w,s=x,l=E;return t=a(t,c.WGS84),t.geodeticSurfaceNormal(e,u),s.x=-e.y,s.y=e.x,s.z=0,r.normalize(s,s),r.cross(u,s,l),i(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=u.x,n[5]=u.y,n[6]=u.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,u.x,s.x,e.x,l.y,u.y,s.y,e.y,l.z,u.z,s.z,e.z,0,0,0,1)};var M=new y,_=new r(1,1,1),P=new m;g.headingPitchRollToFixedFrame=function(e,t,n,a,i,o){var u=y.fromHeadingPitchRoll(t,n,a,M),s=m.fromTranslationQuaternionRotationScale(r.ZERO,u,_,P);return o=g.eastNorthUpToFixedFrame(e,i,o),m.multiply(o,s,o)};var b=new m,N=new p;g.headingPitchRollQuaternion=function(e,t,r,n,a,i){var o=g.headingPitchRollToFixedFrame(e,t,r,n,a,b),u=m.getRotation(o,N);return y.fromRotationMatrix(u,i)};var A=24110.54841,I=8640184.812866,C=.093104,R=-62e-7,z=1.1772758384668e-19,D=72921158553e-15,L=d.TWO_PI/86400,q=new h;g.computeTemeToPseudoFixedMatrix=function(e,t){q=h.addSeconds(e,-h.computeTaiMinusUtc(e),q);var r,n=q.dayNumber,a=q.secondsOfDay,o=n-2451545;r=a>=43200?(o+.5)/v.DAYS_PER_JULIAN_CENTURY:(o-.5)/v.DAYS_PER_JULIAN_CENTURY;var u=A+r*(I+r*(C+r*R)),s=u*L%d.TWO_PI,c=D+z*(n-2451545.5),l=(a+.5*v.SECONDS_PER_DAY)%v.SECONDS_PER_DAY,f=s+c*l,m=Math.cos(f),y=Math.sin(f);return i(t)?(t[0]=m,t[1]=-y,t[2]=0,t[3]=y,t[4]=m,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new p(m,y,0,-y,m,0,0,0,1)},g.iau2006XysData=new l,g.earthOrientationParameters=u.NONE;var U=32.184,B=2451545;g.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+U,a=t.stop.dayNumber,i=t.stop.secondsOfDay+U,o=g.iau2006XysData.preload(r,n,a,i),u=g.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},g.computeIcrfToFixedMatrix=function(e,t){i(t)||(t=new p);var r=g.computeFixedToIcrfMatrix(e,t);return i(r)?p.transpose(r,t):void 0};var F=new f(0,0,0),W=new s(0,0,0,0,0,0),G=new p,k=new p;g.computeFixedToIcrfMatrix=function(e,t){i(t)||(t=new p);var r=g.earthOrientationParameters.compute(e,W);if(!i(r))return void 0;var n=e.dayNumber,a=e.secondsOfDay+U,o=g.iau2006XysData.computeXysRadians(n,a,F);if(!i(o))return void 0;var u=o.x+r.xPoleOffset,s=o.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-s*s)),l=G;l[0]=1-c*u*u,l[3]=-c*u*s,l[6]=u,l[1]=-c*u*s,l[4]=1-c*s*s,l[7]=s,l[2]=-u,l[5]=-s,l[8]=1-c*(u*u+s*s);var f=p.fromRotationZ(-o.s,k),m=p.multiply(l,f,G),y=e.dayNumber,w=e.secondsOfDay-h.computeTaiMinusUtc(e)+r.ut1MinusUtc,x=y-2451545,E=w/v.SECONDS_PER_DAY,S=.779057273264+E+.00273781191135448*(x+E);S=S%1*d.TWO_PI;var O=p.fromRotationZ(S,k),T=p.multiply(m,O,G),M=Math.cos(r.xPoleWander),_=Math.cos(r.yPoleWander),P=Math.sin(r.xPoleWander),b=Math.sin(r.yPoleWander),N=n-B+a/v.SECONDS_PER_DAY;N/=36525;var A=-47e-6*N*d.RADIANS_PER_DEGREE/3600,I=Math.cos(A),C=Math.sin(A),R=k;return R[0]=M*I,R[1]=M*C,R[2]=P,R[3]=-_*C+b*P*I,R[4]=_*I+b*P*C,R[5]=-b*M,R[6]=-b*C-_*P*I,R[7]=b*I-_*P*C,R[8]=_*M,p.multiply(T,R,t)};var V=new n;g.pointToWindowCoordinates=function(e,t,r,n){return n=g.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},g.pointToGLWindowCoordinates=function(e,r,a,o){i(o)||(o=new t);var u=V;return m.multiplyByVector(e,n.fromElements(a.x,a.y,a.z,1,u),u),n.multiplyByScalar(u,1/u.w,u),m.multiplyByVector(r,u,u),t.fromCartesian4(u,o)};var Y=new r,j=new r,H=new r;return g.rotationMatrixFromPositionVelocity=function(e,t,n,o){var u=a(n,c.WGS84).geodeticSurfaceNormal(e,Y),s=r.cross(t,u,j);r.equalsEpsilon(s,r.ZERO,d.EPSILON6)&&(s=r.clone(r.UNIT_X,s));var l=r.cross(s,t,H);return r.cross(t,l,s),r.negate(s,s),i(o)||(o=new p),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o},g}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d){"use strict";var p=new n,m=function(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var n=d.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(l.getColumn(n,0,p)),this._yAxis=r.fromCartesian4(l.getColumn(n,1,p));var i=r.fromCartesian4(l.getColumn(n,2,p));this._plane=f.fromPointNormal(e,i)};o(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}}});var y=new e;m.fromPoints=function(t,r){var n=e.fromPoints(t,y);return new m(n.center,r)};var v=new h,g=new r;m.prototype.projectPointOntoPlane=function(e,n){var a=v;a.origin=e,r.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,g);if(i(o)||(r.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,g)),i(o)){var u=r.subtract(o,this._origin,o),s=r.dot(this._xAxis,u),l=r.dot(this._yAxis,u);return i(n)?(n.x=s,n.y=l,n):new t(s,l)}return void 0},m.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var o=this.projectPointOntoPlane(e[a],t[r]);i(o)&&(t[r]=o,r++)}return t.length=r,t};var w=new r;return m.prototype.projectPointsOntoEllipsoid=function(e,t){var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=w,l=0;n>l;++l){var f=e[l];r.multiplyByScalar(u,f.x,c),i(t[l])||(t[l]=new r);var h=r.add(o,c,t[l]);r.multiplyByScalar(s,f.y,c),r.add(h,c,h),a.scaleToGeocentricSurface(h,h)}return t},m}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var r=new t,n=function(t,n,a,i){return e(t,n,a,i,r),r.x>0&&r.y>0&&r.z>0};return n}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["./freezeObject"],function(e){"use strict";var t={CLOCKWISE:2304,COUNTER_CLOCKWISE:2305,validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return e(t)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,p){"use strict";function m(t,r,n){var a=e.subtract(r,t,D),i=e.subtract(n,r,L);return a.x*i.y-a.y*i.x>=0}function y(e){for(var t=e[0].x,r=0,n=0;n<e.length;n++)e[n].x>t&&(t=e[n].x,r=n);return r}function v(e){for(var t=e[0][0].x,r=0,n=0;n<e.length;n++){var a=e[n][y(e[n])].x;a>t&&(t=a,r=n)}return r}function g(e){for(var t=[],r=0;r<e.length;r++){var n=e[(r-1+e.length)%e.length],a=e[r],i=e[(r+1)%e.length];m(n,a,i)||t.push(a)}return t}function w(t,r){for(var n=0;n<t.length;n++)if(e.equals(r,t[n]))return n;return-1}function x(r,a,i){i=n(i,[]);var o=Number.MAX_VALUE,u=y(a),s=new e(a[u].x,r.y);i.push(u),i.push((u+1)%a.length);for(var c=a[0].x,l=c,f=1;f<a.length;++f)a[f].x<c?c=a[f].x:a[f].x>l&&(l=a[f].x);l+=l-c;var h=new t(l,r.y,0);for(f=0;f<a.length;f++){var d=a[f],p=a[(f+1)%a.length];if((d.x>=r.x||p.x>=r.x)&&(d.y>=r.y&&p.y<=r.y||d.y<=r.y&&p.y>=r.y)){var m=(p.y-d.y)*(h.x-r.x)-(p.x-d.x)*(h.y-r.y);if(0!==m){m=1/m;var v=((p.x-d.x)*(r.y-d.y)-(p.y-d.y)*(r.x-d.x))*m,g=((h.x-r.x)*(r.y-d.y)-(h.y-r.y)*(r.x-d.x))*m;if(v>=0&&1>=v&&g>=0&&1>=g){var w=new e(r.x+v*(h.x-r.x),r.y+v*(h.y-r.y)),x=e.subtract(w,r,q);m=e.magnitudeSquared(x),o>m&&(s=w,o=m,i[0]=f,i[1]=(f+1)%a.length)}}}}return s}function E(t,r){var n=v(r),a=r[n],i=y(a),o=a[i],u=[],s=x(o,t,u),c=w(t,s);if(-1!==c)return c;var h=e.magnitudeSquared(e.subtract(t[u[0]],o,U)),d=e.magnitudeSquared(e.subtract(t[u[1]],o,U)),p=d>h?t[u[0]]:t[u[1]],m=g(t),E=m.indexOf(p);-1!==E&&m.splice(E,1);for(var S=[],O=0;O<m.length;O++){var T=m[O];f(T,o,s,p)&&S.push(T)}var M=Number.MAX_VALUE;if(S.length>0){var _=e.fromElements(1,0,U);for(O=0;O<S.length;O++){var P=e.subtract(S[O],o,B),b=e.magnitude(_)*e.magnitudeSquared(P);if(0!==b){var N=Math.abs(l.acosClamped(e.dot(_,P)/b));M>N&&(M=N,p=S[O])}}}return t.indexOf(p)}function S(e,r,n){for(var a=$.computeWindingOrder2D(e),i=0;i<r.length;i++){var o=r[i];t.equals(o[0],o[o.length-1])||o.push(o[0]);var s=$.computeWindingOrder2D(o);s===a&&o.reverse()}var c=u.fromPoints(e,n),l=c.projectPointsOntoPlane(e),f=[];for(i=0;i<r.length;i++)f.push(c.projectPointsOntoPlane(r[i]));var h=E(l,f),d=v(f),p=y(f[d]),m=r[d],g=[];for(i=0;i<e.length;i++)g.push(e[i]);var w,x=[];if(0!==p)for(w=0;w<=m.length;w++){var S=(w+p)%m.length;0!==S&&x.push(m[S])}else for(w=0;w<m.length;w++)x.push(m[(w+p)%m.length]);var O=g.lastIndexOf(e[h]);x.push(e[O]);var T=g.slice(0,O+1),M=g.slice(O+1);return g=T.concat(x,M),r.splice(d,1),g}function O(e){var t=l.nextRandomNumber(),r=Math.floor(t*e);return r===e&&r--,r}function T(e,t,r,n){var a=n[e].position,i=n[t].position,o=n[r].position,u=o.x,s=o.y,c=a.x-u,l=a.y-s,f=i.x-u,h=i.y-s;return c*h-l*f}function M(e,t){return e.x*t.y-e.y*t.x}function _(e,t){var r=t.length,n=l.mod(e-1,r),a=l.mod(e+1,r);return 0===T(n,a,e,t)?!1:!0}function P(t,r){return e.magnitudeSquared(r)<e.magnitudeSquared(t)}function b(t,r,n){if(!_(t,n))return t;var a=n[t].position,i=n[r].position,o=n.length,u=l.mod(t-1,o);if(!_(u,n))return u;var s=l.mod(t+1,o);if(!_(s,n))return s;var c=e.subtract(n[u].position,a,G),f=e.subtract(n[s].position,a,k),h=e.subtract(i,a,V),d=M(c,h),p=M(f,h);if(0===d)return P(c,h)?F:W;if(0===p)return P(f,h)?F:W;var m=M(c,f);return 0>m?0>d&&p>0?F:W:m>0?d>0&&0>p?W:F:void 0}function N(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function A(t,r,n,a){var i=e.subtract(n,t,j),o=r.x*a.y-r.y*a.x,u=o*o,s=e.magnitudeSquared(r),c=e.magnitudeSquared(a);if(u>Y*s*c){var l=(i.x*a.y-i.y*a.x)/o;return e.add(t,e.multiplyByScalar(r,l,j),j)}return void 0}function I(t,r,n){for(var i=e.subtract(r,t,H),o=n.length,u=0;o>u;u++){var s=n[u].position,c=n[l.mod(u+1,o)].position;if(!(e.equals(t,s)||e.equals(r,c)||e.equals(t,c)||e.equals(r,s))){var f=e.subtract(c,s,Z),h=A(t,i,s,f);if(a(h)&&!(e.equals(h,t)||e.equals(h,r)||e.equals(h,s)||e.equals(h,c))){var d=h.x,p=h.y,m=N(d,t.x,r.x)&&N(p,t.y,r.y)&&N(d,s.x,c.x)&&N(p,s.y,c.y);if(m)return!0}}}return!1}function C(t,r,n){var a=b(t,r,n);if(a>=0)return a;var i=b(r,t,n);return i>=0?i:a!==F||i!==F||I(n[t].position,n[r].position,n)||e.equals(n[t].position,n[r].position)?J:X}function R(e){return 0===T(1,2,0,e)}function z(e){var t=e.length;if(3===t)return R(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new i("Invalid polygon: must have at least three vertices.");for(var r,n,a=0,o=10*e.length,u=J;X>u&&a++<o;){for(r=O(e.length),n=r+1;Math.abs(r-n)<2||Math.abs(r-n)>e.length-2;)n=O(e.length);if(r>n){var s=r;r=n,n=s}u=C(r,n,e)}if(u===X){var c=e.splice(r,n-r+1,e[r],e[n]);return z(e).concat(z(c))}return u>=0?(e.splice(u,1),z(e)):[]}var D=new e,L=new e,q=new e,U=new e(1,0),B=new e,F=-1,W=-2,G=new t,k=new t,V=new t,Y=l.EPSILON14,j=new e;new e;var H=new e,Z=new e,X=-1,J=-2,K=new t,Q=new t,$={};$.removeDuplicates=function(e){for(var r=e.length,n=[],a=r-1,i=0;r>i;a=i++){var o=e[a],u=e[i];t.equals(o,u)||n.push(u)}return n},$.computeArea2D=function(e){for(var t=e.length,r=0,n=t-1,a=0;t>a;n=a++){var i=e[n],o=e[a];r+=i.x*o.y-o.x*i.y}return.5*r},$.computeWindingOrder2D=function(e){var t=$.computeArea2D(e);return t>0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},$.triangulate=function(e){for(var t=e.length,r=[],n=0;t>n;++n)r[n]={position:e[n],index:n};return z(r)};var et=new t,tt=new t,rt=new t,nt=new t,at=new t,it=new t,ot=new t;return $.computeSubdivision=function(e,i,o,u){u=n(u,l.RADIANS_PER_DEGREE);var f,d=o.slice(0),p=i.length,m=new Array(3*p),y=0;for(f=0;p>f;f++){var v=i[f];m[y++]=v.x,m[y++]=v.y,m[y++]=v.z}for(var g=[],w={},x=e.maximumRadius,E=l.chordLength(u,x),S=E*E;d.length>0;){var O,T,M=d.pop(),_=d.pop(),P=d.pop(),b=t.fromArray(m,3*P,et),N=t.fromArray(m,3*_,tt),A=t.fromArray(m,3*M,rt),I=t.multiplyByScalar(t.normalize(b,nt),x,nt),C=t.multiplyByScalar(t.normalize(N,at),x,at),R=t.multiplyByScalar(t.normalize(A,it),x,it),z=t.magnitudeSquared(t.subtract(I,C,ot)),D=t.magnitudeSquared(t.subtract(C,R,ot)),L=t.magnitudeSquared(t.subtract(R,I,ot)),q=Math.max(z,D,L);q>S?z===q?(O=Math.min(P,_)+" "+Math.max(P,_),f=w[O],a(f)||(T=t.add(b,N,ot),t.multiplyByScalar(T,.5,T),m.push(T.x,T.y,T.z),f=m.length/3-1,w[O]=f),d.push(P,f,M),d.push(f,_,M)):D===q?(O=Math.min(_,M)+" "+Math.max(_,M),f=w[O],a(f)||(T=t.add(N,A,ot),t.multiplyByScalar(T,.5,T),m.push(T.x,T.y,T.z),f=m.length/3-1,w[O]=f),d.push(_,f,P),d.push(f,M,P)):L===q&&(O=Math.min(M,P)+" "+Math.max(M,P),f=w[O],a(f)||(T=t.add(A,b,ot),t.multiplyByScalar(T,.5,T),m.push(T.x,T.y,T.z),f=m.length/3-1,w[O]=f),d.push(M,f,_),d.push(f,P,_)):(g.push(P),g.push(_),g.push(M))}return new s({attributes:{position:new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:m})},indices:g,primitiveType:h.TRIANGLES})},$.scaleToGeodeticHeight=function(e,r,i,u){i=n(i,o.WGS84);var s=K,c=Q;if(r=n(r,0),u=n(u,!0),a(e)&&a(e.attributes)&&a(e.attributes.position))for(var l=e.attributes.position.values,f=l.length,h=0;f>h;h+=3)t.fromArray(l,h,c),u&&(c=i.scaleToGeodeticSurface(c,c)),s=i.geodeticSurfaceNormal(c,s),t.multiplyByScalar(s,r,s),t.add(c,s,c),l[h]=c.x,l[h+1]=c.y,l[h+2]=c.z;return e},$.eliminateHoles=function(e,r,a){a=n(a,o.WGS84);for(var i=[],u=0;u<r.length;u++){for(var s=[],c=0;c<r[u].length;c++)s.push(t.clone(r[u][c]));i.push(s)}for(var l=e;i.length>0;)l=S(l,i,a);return l},$}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,a=(r-n)/r,i=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-a)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,i),f=s*o,h=f*f,d=1-h,p=Math.sqrt(d),m=t/4,y=m*m,v=y*m,g=y*y,w=1+m-3*y/4+5*v/4-175*g/64,x=1-m+15*y/8-35*v/8,E=1-3*m+35*y/4,S=1-5*m,O=w*l-x*Math.sin(2*l)*m/2-E*Math.sin(4*l)*y/16-S*Math.sin(6*l)*v/48-5*Math.sin(8*l)*g/512,T=e._constants;T.a=r,T.b=n,T.f=a,T.cosineHeading=i,T.sineHeading=o,T.tanU=u,T.cosineU=s,T.sineU=c,T.sigma=l,T.sineAlpha=f,T.sineSquaredAlpha=h,T.cosineSquaredAlpha=d,T.cosineAlpha=p,T.u2Over4=m,T.u4Over16=y,T.u6Over64=v,T.u8Over256=g,T.a0=w,T.a1=x,T.a2=E,T.a3=S,T.distanceRatio=O}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,r,n,a,i,o){var u=c(e,r);return(1-u)*e*t*(n+u*a*(o+u*i*(2*o*o-1)))}function f(e,t,r,n,a,i,o){var s,c,f,h,d,p=(t-r)/t,m=i-n,y=Math.atan((1-p)*Math.tan(a)),v=Math.atan((1-p)*Math.tan(o)),g=Math.cos(y),w=Math.sin(y),x=Math.cos(v),E=Math.sin(v),S=g*x,O=g*E,T=w*E,M=w*x,_=m,P=u.TWO_PI,b=Math.cos(_),N=Math.sin(_);do{b=Math.cos(_),N=Math.sin(_);var A=O-M*b;f=Math.sqrt(x*x*N*N+A*A),c=T+S*b,s=Math.atan2(f,c);var I;0===f?(I=0,h=1):(I=S*N/f,h=1-I*I),P=_,d=c-2*T/h,isNaN(d)&&(d=0),_=m+l(p,I,h,s,f,c,d)}while(Math.abs(_-P)>u.EPSILON12);var C=h*(t*t-r*r)/(r*r),R=1+C*(4096+C*(C*(320-175*C)-768))/16384,z=C*(256+C*(C*(74-47*C)-128))/1024,D=d*d,L=z*f*(d+z*(c*(2*D-1)-z*d*(4*f*f-3)*(4*D-3)/6)/4),q=r*R*(s-L),U=Math.atan2(x*N,O-M*b),B=Math.atan2(g*N,O*b-M);e._distance=q,e._startHeading=U,e._endHeading=B,e._uSquared=C}function h(r,n,a,i){e.normalize(i.cartographicToCartesian(n,p),d),e.normalize(i.cartographicToCartesian(a,p),p),f(r,i.maximumRadius,i.minimumRadius,n.longitude,n.latitude,a.longitude,a.latitude),r._start=t.clone(n,r._start),r._end=t.clone(a,r._end),r._start.height=0,r._end.height=0,s(r)}var d=new e,p=new e,m=function(e,a,i){var u=r(i,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(a)&&h(this,e,a,u)};return a(m.prototype,{surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),m.prototype.setEndPoints=function(e,t){h(this,e,t,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},m.prototype.interpolateUsingSurfaceDistance=function(e,r){var a=this._constants,i=a.distanceRatio+e/a.b,o=Math.cos(2*i),u=Math.cos(4*i),s=Math.cos(6*i),c=Math.sin(2*i),f=Math.sin(4*i),h=Math.sin(6*i),d=Math.sin(8*i),p=i*i,m=i*p,y=a.u8Over256,v=a.u2Over4,g=a.u6Over64,w=a.u4Over16,x=2*m*y*o/3+i*(1-v+7*w/4-15*g/4+579*y/64-(w-15*g/4+187*y/16)*o-(5*g/4-115*y/16)*u-29*y*s/16)+(v/2-w+71*g/32-85*y/16)*c+(5*w/16-5*g/4+383*y/96)*f-p*((g-11*y/2)*c+5*y*f/2)+(29*g/96-29*y/16)*h+539*y*d/1536,E=Math.asin(Math.sin(x)*a.cosineAlpha),S=Math.atan(a.a/a.b*Math.tan(E));x-=a.sigma;var O=Math.cos(2*a.sigma+x),T=Math.sin(x),M=Math.cos(x),_=a.cosineU*M,P=a.sineU*T,b=Math.atan2(T*a.sineHeading,_-P*a.cosineHeading),N=b-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,x,T,M,O);return n(r)?(r.longitude=this._start.longitude+N,r.latitude=S,r.height=0,r):new t(this._start.longitude+N,S,0)},m}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function h(e,t,r){var n=T;n.length=e;var a;if(t===r){for(a=0;e>a;a++)n[a]=t;return n}var i=r-t,o=i/e;for(a=0;e>a;a++){var u=t+a*o;n[a]=u}return n}function d(t,r,n,a,i,o,u,s){var c=a.scaleToGeodeticSurface(t,b),l=a.scaleToGeodeticSurface(r,N),f=p.numberOfPoints(t,r,n),d=a.cartesianToCartographic(c,M),m=a.cartesianToCartographic(l,_),y=h(f,i,o);
A.setEndPoints(d,m);var v=A.surfaceDistance/f,g=s;d.height=i;var w=a.cartographicToCartesian(d,P);e.pack(w,u,g),g+=3;for(var x=1;f>x;x++){var E=A.interpolateUsingSurfaceDistance(x*v,_);E.height=y[x],w=a.cartographicToCartesian(E,P),e.pack(w,u,g),g+=3}return g}var p={};p.numberOfPoints=function(t,r,n){var a=e.distance(t,r);return Math.ceil(a/n)};var m=new t;p.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),a=0;r>a;a++){var i=e[a];n[a]=t.cartesianToCartographic(i,m).height}return n};var y=new l,v=new e,g=new e,w=new f(e.ZERO,0),x=new e,E=new f(e.ZERO,0),S=new e,O=new e,T=[],M=new t,_=new t,P=new e,b=new e,N=new e,A=new o;p.wrapLongitude=function(t,a){var i=[],o=[];if(n(t)&&t.length>0){a=r(a,l.IDENTITY);var s=l.inverseTransformation(a,y),c=l.multiplyByPoint(s,e.ZERO,v),h=l.multiplyByPointAsVector(s,e.UNIT_Y,g),d=f.fromPointNormal(c,h,w),p=l.multiplyByPointAsVector(s,e.UNIT_X,x),m=f.fromPointNormal(c,p,E),T=1;i.push(e.clone(t[0]));for(var M=i[0],_=t.length,P=1;_>P;++P){var b=t[P];if(f.getPointDistance(m,M)<0||f.getPointDistance(m,b)<0){var N=u.lineSegmentPlane(M,b,d,S);if(n(N)){var A=e.multiplyByScalar(h,5e-9,O);f.getPointDistance(d,M)<0&&e.negate(A,A),i.push(e.add(N,A,new e)),o.push(T+1),e.negate(A,A),i.push(e.add(N,A,new e)),T=1}}i.push(e.clone(t[P])),T++,M=b}o.push(T)}return{positions:i,lengths:o}};var I=c.EPSILON7;return p.removeDuplicates=function(t){var r=t.length;if(2>r)return void 0;var n,a,i;for(n=1;r>n&&(a=t[n-1],i=t[n],!e.equalsEpsilon(a,i,I));++n);if(n===r)return void 0;for(var o=t.slice(0,n);r>n;++n)i=t[n],e.equalsEpsilon(a,i,I)||(o.push(e.clone(i)),a=i);return o},p.generateArc=function(t){n(t)||(t={});var a=t.positions,o=r(t.ellipsoid,i.WGS84),u=r(t.height,0),l=t.minDistance;if(!n(l)){var f=r(t.granularity,c.RADIANS_PER_DEGREE);l=c.chordLength(f,o.maximumRadius)}var h,m=a.length,y=0;for(h=0;m-1>h;h++)y+=p.numberOfPoints(a[h],a[h+1],l);var v=3*(y+1),g=new Array(v),w=0,x=s(u);for(h=0;m-1>h;h++){var E=a[h],S=a[h+1],O=x?u[h]:u,_=x?u[h+1]:u;w=d(E,S,l,o,O,_,g,w)}T.length=0;var b=a[m-1],N=o.cartesianToCartographic(b,M);N.height=x?u[m-1]:u;var A=o.cartographicToCartesian(N,P);return e.pack(A,g,v-3),g},p.generateCartesianArc=function(t){for(var r=p.generateArc(t),n=r.length/3,a=new Array(n),i=0;n>i;i++)a[i]=e.unpack(r,3*i);return a},p}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,r,n,a,i,o,u,s,c,l,f){"use strict";function h(e,t){for(var r=new Array(e.length),n=0;n<e.length;n++){var a=e[n];z=t.cartesianToCartographic(a,z),r[n]=z.height,e[n]=t.scaleToGeodeticSurface(a,a)}return r}function d(e,r,n,a){var i,o=e[0],u=e[1],s=t.angleBetween(o,u),c=Math.ceil(s/a),l=new Array(c);if(r===n){for(i=0;c>i;i++)l[i]=r;return l.push(n),l}var f=n-r,h=f/c;for(i=1;c>i;i++){var d=r+i*h;l[i]=d}return l[0]=r,l.push(n),l}function p(r,n,a,o){var u=new i(a,o),s=u.projectPointOntoPlane(t.add(a,r,H),H),c=u.projectPointOntoPlane(t.add(a,n,Z),Z),l=e.angleBetween(s,c);return c.x*s.y-c.y*s.x>=0?-l:l}function m(e,r,n,a,i,o,c,l){var h=F,d=W;L=f.eastNorthUpToFixedFrame(e,i,L),h=s.multiplyByPointAsVector(L,D,h),h=t.normalize(h,h);var m=p(h,r,e,i);U=u.fromRotationZ(m,U),G.z=o,L=s.multiplyTransformation(L,s.fromRotationTranslation(U,G,q),L);var y=B;y[0]=c;for(var v=0;l>v;v++)for(var g=0;g<n.length;g+=3)d=t.fromArray(n,g,d),d=u.multiplyByVector(y,d,d),d=s.multiplyByPoint(L,d,d),a.push(d.x,d.y,d.z);return a}function y(e,r,n,a,i,o,u){for(var s=0;s<e.length;s+=3){var c=t.fromArray(e,s,k);a=m(c,r,n,a,i,o[s/3],u,1)}return a}function v(e,t){var r=e.length,n=new Array(6*r),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=e[0];n[a++]=u.x-i,n[a++]=0,n[a++]=u.y-o;for(var s=1;r>s;s++){u=e[s];var c=u.x-i,l=u.y-o;n[a++]=c,n[a++]=0,n[a++]=l,n[a++]=c,n[a++]=0,n[a++]=l}return u=e[0],n[a++]=u.x-i,n[a++]=0,n[a++]=u.y-o,n}function g(e,t){for(var r=e.length,n=new Array(3*r),a=0,i=t.x+t.width/2,o=t.y+t.height/2,u=0;r>u;u++)n[a++]=e[u].x-i,n[a++]=0,n[a++]=e[u].y-o;return n}function w(e,r,n,i,s,c,f,h,d,p){var y,v=t.angleBetween(t.subtract(r,e,I),t.subtract(n,e,C)),g=i===a.BEVELED?0:Math.ceil(v/o.toRadians(5));y=s?u.fromQuaternion(l.fromAxisAngle(t.negate(e,I),v/(g+1),V),j):u.fromQuaternion(l.fromAxisAngle(e,v/(g+1),V),j);var w,x;if(r=t.clone(r,Y),g>0)for(var E=p?2:1,S=0;g>S;S++)r=u.multiplyByVector(y,r,r),w=t.subtract(r,e,I),w=t.normalize(w,w),s||(w=t.negate(w,w)),x=c.scaleToGeodeticSurface(r,C),f=m(x,w,h,f,c,d,1,E);else w=t.subtract(r,e,I),w=t.normalize(w,w),s||(w=t.negate(w,w)),x=c.scaleToGeodeticSurface(r,C),f=m(x,w,h,f,c,d,1,1),n=t.clone(n,Y),w=t.subtract(n,e,I),w=t.normalize(w,w),s||(w=t.negate(w,w)),x=c.scaleToGeodeticSurface(n,C),f=m(x,w,h,f,c,d,1,1);return f}function x(e,t){return o.equalsEpsilon(e.latitude,t.latitude,o.EPSILON6)&&o.equalsEpsilon(e.longitude,t.longitude,o.EPSILON6)}var E=[new t,new t],S=new t,O=new t,T=new t,M=new t,_=new t,P=new t,b=new t,N=new t,A=new t,I=new t,C=new t,R={},z=new n,D=new t(-1,0,0),L=new s,q=new s,U=new u,B=u.IDENTITY.clone(),F=new t,W=new r,G=new t,k=new t,V=new l,Y=new t,j=new u;R.removeDuplicatesFromShape=function(t){for(var r=t.length,n=[],a=r-1,i=0;r>i;a=i++){var o=t[a],u=t[i];e.equals(o,u)||n.push(u)}return n};var H=new t,Z=new t;R.angleIsGreaterThanPi=function(e,r,n,a){var o=new i(n,a),u=o.projectPointOntoPlane(t.add(n,e,H),H),s=o.projectPointOntoPlane(t.add(n,r,Z),Z);return s.x*u.y-s.y*u.x>=0};var X=new n,J=new n;R.removeDuplicatesFromPositions=function(e,t){var r=e.length;if(2>r)return e.slice(0);var n=[];n.push(e[0]);for(var a=1;r>a;++a){var i=e[a-1],o=e[a],u=t.cartesianToCartographic(i,X),s=t.cartesianToCartographic(o,J);x(u,s)||n.push(o)}return n};var K=new t,Q=new t;return R.computePositions=function(e,r,n,i,u){var s=i._ellipsoid,l=h(e,s),f=i._granularity,p=i._cornerType,x=u?v(r,n):g(r,n),C=u?g(r,n):void 0,z=n.height/2,D=n.width/2,L=e.length,q=[],U=u?[]:void 0,B=S,F=O,W=T,G=M,k=_,V=P,Y=b,j=N,H=A,Z=e[0],X=e[1];G=s.geodeticSurfaceNormal(Z,G),B=t.subtract(X,Z,B),B=t.normalize(B,B),j=t.cross(G,B,j),j=t.normalize(j,j);var J=l[0],$=l[1];u&&(U=m(Z,j,C,U,s,J+z,1,1)),H=t.clone(Z,H),Z=X,F=t.negate(B,F);for(var et,tt,rt=1;L-1>rt;rt++){var nt=u?2:1;X=e[rt+1],B=t.subtract(X,Z,B),B=t.normalize(B,B),W=t.add(B,F,W),W=t.normalize(W,W),G=s.geodeticSurfaceNormal(Z,G);var at=t.multiplyByScalar(G,t.dot(B,G),K);t.subtract(B,at,at),t.normalize(at,at);var it=t.multiplyByScalar(G,t.dot(F,G),Q);t.subtract(F,it,it),t.normalize(it,it);var ot=!o.equalsEpsilon(Math.abs(t.dot(at,it)),1,o.EPSILON7);if(ot){W=t.cross(W,G,W),W=t.cross(G,W,W),W=t.normalize(W,W);var ut=1/Math.max(.25,t.magnitude(t.cross(W,F,I))),st=R.angleIsGreaterThanPi(B,F,Z,s);st?(k=t.add(Z,t.multiplyByScalar(W,ut*D,W),k),V=t.add(k,t.multiplyByScalar(j,D,V),V),E[0]=t.clone(H,E[0]),E[1]=t.clone(V,E[1]),et=d(E,J+z,$+z,f),tt=c.generateArc({positions:E,granularity:f,ellipsoid:s}),q=y(tt,j,x,q,s,et,1),j=t.cross(G,B,j),j=t.normalize(j,j),Y=t.add(k,t.multiplyByScalar(j,D,Y),Y),p===a.ROUNDED||p===a.BEVELED?w(k,V,Y,p,st,s,q,x,$+z,u):(W=t.negate(W,W),q=m(Z,W,x,q,s,$+z,ut,nt)),H=t.clone(Y,H)):(k=t.add(Z,t.multiplyByScalar(W,ut*D,W),k),V=t.add(k,t.multiplyByScalar(j,-D,V),V),E[0]=t.clone(H,E[0]),E[1]=t.clone(V,E[1]),et=d(E,J+z,$+z,f),tt=c.generateArc({positions:E,granularity:f,ellipsoid:s}),q=y(tt,j,x,q,s,et,1),j=t.cross(G,B,j),j=t.normalize(j,j),Y=t.add(k,t.multiplyByScalar(j,-D,Y),Y),p===a.ROUNDED||p===a.BEVELED?w(k,V,Y,p,st,s,q,x,$+z,u):q=m(Z,W,x,q,s,$+z,ut,nt),H=t.clone(Y,H)),F=t.negate(B,F)}else q=m(H,j,x,q,s,J+z,1,1),H=Z;J=$,$=l[rt+1],Z=X}E[0]=t.clone(H,E[0]),E[1]=t.clone(Z,E[1]),et=d(E,J+z,$+z,f),tt=c.generateArc({positions:E,granularity:f,ellipsoid:s}),q=y(tt,j,x,q,s,et,1),u&&(U=m(Z,j,C,U,s,$+z,1,1)),L=q.length;var ct=u?L+U.length:L,lt=new Float64Array(ct);return lt.set(q),u&&lt.set(U,L),lt},R}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";var a=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(t,r,n){n=e(n,0),r[n++]=t.position?1:0,r[n++]=t.normal?1:0,r[n++]=t.st?1:0,r[n++]=t.binormal?1:0,r[n++]=t.tangent?1:0,r[n++]=t.color?1:0},a.unpack=function(r,n,i){return n=e(n,0),t(i)||(i=new a),i.position=1===r[n++],i.normal=1===r[n++],i.st=1===r[n++],i.binormal=1===r[n++],i.tangent=1===r[n++],i.color=1===r[n++],i},a.clone=function(e,r){return t(e)?(t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},a}),define("Core/PolylineVolumeGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./VertexFormat","./WindingOrder"],function(e,t,r,n,a,i,o,u,s,c,l,f,h,d,p,m,y,v,g,w,x){"use strict";function E(e,r,n,i){var o=new h;i.position&&(o.position=new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:e}));var u,s,c,m,v,w,x=r.length,E=e.length/3,S=(E-2*x)/(2*x),O=y.triangulate(r),T=6*(S-1)*x+2*O.length,M=p.createTypedArray(E,T),_=2*x,P=0;for(u=0;S-1>u;u++){for(s=0;x-1>s;s++)c=2*s+2*u*x,w=c+_,m=c+1,v=m+_,M[P++]=m,M[P++]=c,M[P++]=v,M[P++]=v,M[P++]=c,M[P++]=w;c=2*x-2+2*u*x,m=c+1,v=m+_,w=c+_,M[P++]=m,M[P++]=c,M[P++]=v,M[P++]=v,M[P++]=c,M[P++]=w}if(i.st||i.tangent||i.binormal){var b,N,A=new Float32Array(2*E),I=1/(S-1),C=1/n.height,R=n.height/2,z=0;for(u=0;S>u;u++){for(b=u*I,N=C*(r[0].y+R),A[z++]=b,A[z++]=N,s=1;x>s;s++)N=C*(r[s].y+R),A[z++]=b,A[z++]=N,A[z++]=b,A[z++]=N;N=C*(r[0].y+R),A[z++]=b,A[z++]=N}for(s=0;x>s;s++)b=0,N=C*(r[s].y+R),A[z++]=b,A[z++]=N;for(s=0;x>s;s++)b=(S-1)*I,N=C*(r[s].y+R),A[z++]=b,A[z++]=N;o.st=new f({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:new Float32Array(A)})}var D=E-2*x;for(u=0;u<O.length;u+=3){var L=O[u]+D,q=O[u+1]+D,U=O[u+2]+D;M[P++]=L,M[P++]=q,M[P++]=U,M[P++]=U+x,M[P++]=q+x,M[P++]=L+x}var B=new l({attributes:o,indices:M,boundingSphere:t.fromVertices(e),primitiveType:g.TRIANGLES});return i.normal&&(B=d.computeNormal(B)),(i.tangent||i.binormal)&&(B=d.computeBinormalAndTangent(B),i.tangent||(B.attributes.tangent=void 0),i.binormal||(B.attributes.binormal=void 0),i.st||(B.attributes.st=void 0)),B}var S=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.polylinePositions,a=e.shapePositions;this._positions=t,this._shape=a,this._ellipsoid=c.clone(o(e.ellipsoid,c.WGS84)),this._cornerType=o(e.cornerType,i.ROUNDED),this._vertexFormat=w.clone(o(e.vertexFormat,w.DEFAULT)),this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var u=1+t.length*n.packedLength;u+=1+a.length*r.packedLength,this.packedLength=u+c.packedLength+w.packedLength+2};S.pack=function(e,t,a){a=o(a,0);var i,u=e._positions,s=u.length;for(t[a++]=s,i=0;s>i;++i,a+=n.packedLength)n.pack(u[i],t,a);var l=e._shape;for(s=l.length,t[a++]=s,i=0;s>i;++i,a+=r.packedLength)r.pack(l[i],t,a);c.pack(e._ellipsoid,t,a),a+=c.packedLength,w.pack(e._vertexFormat,t,a),a+=w.packedLength,t[a++]=e._cornerType,t[a]=e._granularity};var O=c.clone(c.UNIT_SPHERE),T=new w,M={polylinePositions:void 0,shapePositions:void 0,ellipsoid:O,vertexFormat:T,cornerType:void 0,granularity:void 0};S.unpack=function(e,t,a){t=o(t,0);var i,s=e[t++],l=new Array(s);for(i=0;s>i;++i,t+=n.packedLength)l[i]=n.unpack(e,t);s=e[t++];var f=new Array(s);for(i=0;s>i;++i,t+=r.packedLength)f[i]=r.unpack(e,t);var h=c.unpack(e,t,O);t+=c.packedLength;var d=w.unpack(e,t,T);t+=w.packedLength;var p=e[t++],m=e[t];return u(a)?(a._positions=l,a._shape=f,a._ellipsoid=c.clone(h,a._ellipsoid),a._vertexFormat=w.clone(d,a._vertexFormat),a._cornerType=p,a._granularity=m,a):(M.polylinePositions=l,M.shapePositions=f,M.cornerType=p,M.granularity=m,new S(M))};var _=new e;return S.createGeometry=function(t){var r=t._positions,n=v.removeDuplicatesFromPositions(r,t._ellipsoid),a=t._shape;if(a=v.removeDuplicatesFromShape(a),n.length<2||a.length<3)return void 0;y.computeWindingOrder2D(a)===x.CLOCKWISE&&a.reverse();var i=e.fromPoints(a,_),o=v.computePositions(n,a,i,t,!0);return E(o,a,i,t._vertexFormat)},S}),define("Workers/createPolylineVolumeGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineVolumeGeometry"],function(e,t,r){"use strict";function n(n,a){return e(a)&&(n=r.unpack(n,a)),n._ellipsoid=t.clone(n._ellipsoid),r.createGeometry(n)}return n})}();