<?php 
//------------------------------------------
//escrito por Jaime Rojas Landivar
//------------------------------------------

$_GET = array_merge($_GET,$_POST);
// Obtenemos el/los parametro(s) con el medoto get
$gid = $_GET["gid"];
$gid_objeto = $gid;

$conn = pg_connect("host=37.60.237.220 dbname=sigapas user=postgres password=sigapas2025s");
$result = pg_query($conn, "SELECT nextval('admin.reportes_seq')");
$row = pg_fetch_row($result);
$id_reporte = $row[0];

//------------------------------------------
// CONSULTAR DATOS DE LA TUBERÍA SELECCIONADA
//------------------------------------------
//$conn = pg_connect("host=37.60.237.220 dbname=sigapas user=postgres password=sigapas2025s");

$sql_datos = "
    SELECT 
        id_tuberia,
        diametro,
        pendiente,
        material,
        tipo_tuberia,
        profundidad,
        longitud,
        calle,
        estado_actual,
        responsable,
        ubicacion,
        distrito,
        otb,
        observaciones,
        usuario,
        to_char(fecha_usuario, 'DD/MM/YYYY') AS fecha_usuario,
        gestion
    FROM bdgeo.red_alcantarillado
    WHERE gid = $gid_objeto
";

$res_datos = pg_query($conn, $sql_datos);
$datos = array_change_key_case(pg_fetch_assoc($res_datos), CASE_LOWER); // normaliza claves
//pg_close($conn);


///////////////////////////////////////////////////////////////
// GENERAR IMAGEN PRINCIPAL DEL PLANO
//-------------------------------------------------------------

$srid="32719";
$nombre_layer = 'resaltado';
$nombre_original = 'prueba';
$nombre_tabla = 'bdgeo.red_alcantarillado';
$map_path =          '/var/www/html/jmapReport/map_files/';
$map_path_destino  = '/var/www/html/jmapReport/tmp/';

$nombre = $nombre_original.strval($id_reporte); 
$archivo_original = $map_path.$nombre_original.'.map';
$archivo_temporal = $map_path_destino.$nombre.'.map';

// Copiar el archivo
if (copy($archivo_original, $archivo_temporal)) {
    //echo "Mapfile copiado a: $archivo_temporal";
} else {
    echo 'Error al copiar el mapfile.';
}
@chmod($archivo_temporal, 0777);
@chown($archivo_temporal, 'www-data:www-data');



$sq = "
SELECT 
  round((cx - side / 2)::numeric, 13) AS ext1,
  round((cy - side / 2)::numeric, 13) AS ext2,
  round((cx + side / 2)::numeric, 13) AS ext3,
  round((cy + side / 2)::numeric, 13) AS ext4
FROM (
  SELECT 
    GREATEST(xmax - xmin, ymax - ymin) * 1.10 AS side, -- margen 10%
    cx, cy
  FROM (
    SELECT 
      ST_XMin(extent) AS xmin,
      ST_YMin(extent) AS ymin,
      ST_XMax(extent) AS xmax,
      ST_YMax(extent) AS ymax,
      ST_XMin(extent) + (ST_XMax(extent) - ST_XMin(extent)) / 2 AS cx,
      ST_YMin(extent) + (ST_YMax(extent) - ST_YMin(extent)) / 2 AS cy
    FROM (
      SELECT ST_Extent(geom)::geometry AS extent
      FROM (
        SELECT ST_Union(t.geom) AS geom
        FROM bdgeo.red_alcantarillado t
        WHERE t.gid = ".$gid_objeto."
      ) u
    ) side
  ) dim
) square;
";

//echo $sg;

$result = pg_query($conn, $sq);
$row = pg_fetch_assoc($result);
$ext1=$row["ext1"];
$ext2=$row["ext2"];
$ext3=$row["ext3"];
$ext4=$row["ext4"];
	
pg_free_result ($result);
pg_close ();


// Configuración básica
$layers = "sigapas1,red_alcantarillado,resaltado";
$layer = "resaltado";
$bbox  = $ext1.",".$ext2.",".$ext3.",".$ext4;  // coordenadas visibles
$width = 800;
$height = 800;
$epsg = "32719";
// URL base del WMS
$wms_url = "https://www.server1.jmap4.com/cgi-bin/mapserv";
$map_path = "/var/www/html/jmapReport/map_files/prueba.map";


// Construcción dinámica de la URL WMS GetMap
$url = $wms_url
     . "?map=" . urlencode($archivo_temporal)
     . "&SERVICE=WMS"
     . "&VERSION=1.0.0"
     . "&REQUEST=GetMap"
     . "&LAYERS=" . urlencode($layers)
     . "&STYLES=,," 
     . "&SRS=EPSG:" . $epsg
     . "&BBOX=" . urlencode($bbox)
     . "&WIDTH=" . $width 
     . "&HEIGHT=" . $height 
     . "&FORMAT=image/png"   
     . "&map.sigapas1.filter=1=1"
     . "&map.red_alcantarillado.filter=1=1"
     . "&map.resaltado.filter=GID=".$gid_objeto ;     



$cql_filter_value = "INCLUDE;INCLUDE;id_tuberia=".$datos['id_tuberia']; 
$url = "http://www.jmap4.com:8080/geoserver/wms?"
. "SERVICE=WMS"
. "&VERSION=1.1.1"
. "&REQUEST=GetMap"
. "&LAYERS=sigapas:orto_02_05parte1,sigapas:red_alcantarillado,sigapas:resaltado"
. "&STYLES=,," // Tres capas -> Tres estilos (vacío = default)
. "&SRS=EPSG:" . $epsg
. "&BBOX=" . urlencode($bbox)
. "&WIDTH=" . $width 
. "&HEIGHT=" . $height 
. "&FORMAT=image/png" 
// *** USAMOS URLENCODE PARA TODO EL VALOR DEL FILTRO ***
. "&CQL_FILTER=" . urlencode($cql_filter_value); 
//echo $url;
// ... el resto del código CURL

//echo "Descargando imagen desde:\n$url\n\n";

// Carpeta temporal para guardar la imagen
$tmp_dir = "/var/www/html/jmapReport/tmp";
if (!is_dir($tmp_dir)) mkdir($tmp_dir, 0777, true);

$nombre_imagen = $tmp_dir."/mapa".strval($id_reporte).".png";

//--------------------------------------------
// DESCARGAR IMAGEN CON CURL
//--------------------------------------------
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);

$data = curl_exec($ch);

if (curl_errno($ch)) {
    die("Error CURL: " . curl_error($ch));
}
curl_close($ch);

file_put_contents($nombre_imagen, $data);

// Verificar si la imagen se guardó
if (!file_exists($nombre_imagen)) {
    die("o se pudo guardar la imagen.\n");
}
//echo "magen guardada: $output_file\n";
///////////////////////////////////////////////////////////////
// FIN IMAGEN PRINCIPAL DEL PLANO
//-------------------------------------------------------------


///////////////////////////////////////////////////////////////
// GENERAR IMAGEN DE UBICACION por DISTRITO
//-------------------------------------------------------------
$srid="32719";
$nombre_layer = 'distritos';
$nombre_original = 'boDISTRITOS';
$nombre_tabla = 'bdgeo.distritos';
$map_path = '/var/www/html/jmapReport/map_files/';
$map_path_destino = '/var/www/html/jmapReport/tmp/';


$nombre = $nombre_original.strval($id_reporte); 
$archivo_original = $map_path.$nombre_original.'.map';
$archivo_temporal = $map_path_destino.$nombre.'.map';

// Copiar el archivo
if (copy($archivo_original, $archivo_temporal)) {
    //echo "Mapfile copiado a: $nombre";
} else {
    echo "Error al copiar el mapfile.";
}

$map = ms_newMapObj($archivo_temporal);
$layer = $map->getLayerByName($nombre_layer);
$data = "geom FROM (";
$data = $data."select * from bdgeo.distritos w ";
$data = $data."where w.gid in ";
$data = $data."(SELECT d.gid ";
$data = $data."FROM bdgeo.distritos d,";
$data = $data."bdgeo.red_alcantarillado a ";
$data = $data."WHERE a.gid = ".$gid_objeto;
$data = $data." AND ST_Intersects(st_setsrid(a.geom,32719), st_setsrid(d.geom,32719)))";
$data = $data.") AS foo USING UNIQUE gid USING SRID=".$srid;
//echo $data;
$layer->set("data", $data);
$map->save($archivo_temporal);

$layer = $map->getLayerByName('resaltado');
$layer->set("data", "geom FROM (SELECT * FROM bdgeo.red_alcantarillado WHERE gid = ".$gid_objeto.") AS foo USING UNIQUE gid USING SRID=".$srid);
$map->save($archivo_temporal);


//echo 'probando';
// DETERMINAR EL EXTEN ADECUADO AL OBJETO SELECCIONADO

if ($par_escala <= 0)
{
	$par_escala=1;
}

if ($par_escala > 9)
{
	$par_escala=9;
}

$sq = "select ";
$sq = $sq."cast(round(cast((x.campo1-(x.campo3-x.campo1)/10) as decimal),13) as text) as ext1, ";//solicitar explicacion.
$sq = $sq."cast(round(cast((x.campo2-(x.campo4-x.campo2)/10) as decimal),13) as text) as ext2, ";
$sq = $sq."cast(round(cast((x.campo3+(x.campo3-x.campo1)/10) as decimal),13) as text) as ext3, ";
$sq = $sq."cast(round(cast((x.campo4+(x.campo4-x.campo2)/10) as decimal),13) as text) as ext4 ";
$sq = $sq."from ";
$sq = $sq."(select "; 
$sq = $sq."cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1, ";
$sq = $sq."cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2, ";
$sq = $sq."cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3, ";
$sq = $sq."cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4 ";
$sq = $sq."from ";
$sq = $sq."(select "; 
$sq = $sq."replace(replace(substr(cast(a.bb as varchar),5),' ',',') ,')','') as bb  ";
$sq = $sq."from ";
$sq = $sq."(select ST_Extent(geom) bb from ";
$sq = $sq."(select 1 objectid, st_union(st_snaptogrid(ST_Transform(geom,4326),0.00000000000001)) geom ";
$sq = $sq."from ".$nombre_tabla." t ";
$sq = $sq."where t.gid in ";
$sq = $sq." (SELECT d.gid ";
$sq = $sq." FROM bdgeo.distritos d,";
$sq = $sq." bdgeo.red_alcantarillado a ";
$sq = $sq." WHERE a.gid = ".$gid_objeto;
$sq = $sq." AND ST_Intersects(st_setsrid(a.geom,32719), st_setsrid(d.geom,32719)))) e ";
$sq = $sq.") as a) as t1) as x;  ";

//echo $sq;

$ext1='                                          ';
$ext2='                                          ';
$ext3='                                          ';
$ext4='                                          ';

$result = pg_query ($conn, $sq);
if ($r_parcela = pg_fetch_array($result))
{
	$ext1=$r_parcela["ext1"];
	$ext2=$r_parcela["ext2"];
	$ext3=$r_parcela["ext3"];
	$ext4=$r_parcela["ext4"];
	//echo $ext1;
	//echo $ext2;
	//echo $ext3;
	//echo $ext4;

}
//echo "<p> " . 'despues de extent y de select'. ":</p>";
pg_free_result ($result);
pg_close ();




$map->setExtent( $ext1, $ext2, $ext3, $ext4 );

$imgo = $map->draw();

if($imgo->imagepath == "")
{echo "Erro IMAGEPATH vazio";exit;}
$nombre_imagen_distrito = $imgo->imagepath."imagen_".$nombre.".png";
$imgo->saveImage($nombre_imagen_distrito);

///////////////////////////////////////////////////////////////
// FIN IMAGEN DE UBICACION por DISTRITO
//-------------------------------------------------------------

//echo $nombre_imagen_distrito;

//$gid = $id_objeto;

//-----------CONFIGURACION Y CREACION DEL ARCHIVO PDF
require(dirname(__FILE__).'/pacotes/fpdf/fpdf.php');


$pdf = new FPDF("P", "mm", array(215, 279)); // Tamaño CARTA
$pdf->SetDisplayMode(100, "single");

// 🔧 Márgenes en milímetros
$margen_izq = 25;  // 3 cm
$margen_sup = 15;  // 2 cm
$margen_der = 15;  // 2 cm
$margen_inf = 15;  // 2 cm

$pdf->SetMargins($margen_izq, $margen_sup, $margen_der);
$pdf->SetAutoPageBreak(true, $margen_inf); // 🔧 margen inferior
$pdf->AddPage('P');
$pdf->SetLineWidth(0.1);

// 🔧 Área útil
$ancho_util = 215 - $margen_izq - $margen_der;
$alto_util  = 279 - $margen_sup - $margen_inf;

//----------IMAGEN PRINCIPAL DEL MAPA---------------------
$pdf->Rect($margen_izq, $margen_sup, $ancho_util, 30, 'D'); // TITULO
$pdf->Image($nombre_imagen, $margen_izq, $margen_sup + 30, 120, 115); // Imagen principal

$pdf->Rect($margen_izq, $margen_sup + 30, 120, 115, 'D'); // Contorno imagen principal
$pdf->Rect($margen_izq + 100 + 20, $margen_sup + 30, 55, 15, 'D'); // Título ubicación

$pdf->Image($nombre_imagen_distrito, $margen_izq + 100 + 20, $margen_sup + 45, 55, 55);
$pdf->Rect($margen_izq + 100 + 20, $margen_sup + 45, 55, 55, 'D');

$pdf->Rect($margen_izq + 100 + 20, $margen_sup + 100, 55, 15, 'D'); // Título referencia
$pdf->Rect($margen_izq + 100 + 20, $margen_sup + 115, 55, 30, 'D'); // Contorno referencia
$pdf->Rect($margen_izq, $margen_sup + 145, $ancho_util, 30, 'D'); // Datos objetos
$pdf->Rect($margen_izq, $margen_sup + 175, $ancho_util, 30, 'D'); // Descripción objetos
$pdf->Rect($margen_izq, $margen_sup + 205, $ancho_util, 45, 'D'); // Realizado por



//------------------------------------------
// CONSULTAR DATOS DE LA TUBERÍA SELECCIONADA
//------------------------------------------
$conn = pg_connect("host=37.60.237.220 dbname=sigapas user=postgres password=sigapas2025s");

$sql_datos = "
    SELECT 
        id_tuberia,
        diametro,
        pendiente,
        material,
        tipo_tuberia,
        profundidad,
        longitud,
        calle,
        estado_actual,
        responsable,
        ubicacion,
        distrito,
        otb,
        observaciones,
        usuario,
        to_char(fecha_usuario, 'DD/MM/YYYY') AS fecha_usuario,
        gestion
    FROM bdgeo.red_alcantarillado
    WHERE gid = $gid_objeto
";

$res_datos = pg_query($conn, $sql_datos);
$datos = array_change_key_case(pg_fetch_assoc($res_datos), CASE_LOWER); // normaliza claves
pg_close($conn);

//------------------------------------------
// FUNCIÓN PARA LIMPIAR LOS DATOS
//------------------------------------------
function limpiarDato($valor) {
    $valor = trim($valor ?? '');
    return $valor !== '' ? $valor : 'No disponible';
}

//------------------------------------------
// IMPRIMIR LOS DATOS EN COLUMNAS DINÁMICAS
//------------------------------------------
$pdf->SetFont('Arial', '', 9);
$pdf->SetTextColor(0, 0, 0);

// Posiciones iniciales
$y_inicial = 162;
$x_inicial = 40;
$espacio_columna = 60; // espacio horizontal entre columnas

// Datos organizados
$lineas = [
    "ID Tubería:"       => limpiarDato($datos['id_tuberia']),
    "Diámetro:"         => limpiarDato($datos['diametro']),
    "Material:"         => limpiarDato($datos['material']),
    "Tipo Tubería:"     => limpiarDato($datos['tipo_tuberia']),
    "Longitud (m):"     => limpiarDato($datos['longitud']),
    "Pendiente:"        => limpiarDato($datos['pendiente']),
    "Profundidad:"      => limpiarDato($datos['profundidad']),
    "Estado Actual:"    => limpiarDato($datos['estado_actual']),
    "Gestión:"          => limpiarDato($datos['gestion']),
    "Observaciones:"    => limpiarDato($datos['observaciones'])
];

// Dividir en grupos de 5 líneas por columna
$grupos = array_chunk($lineas, 5, true);

// Imprimir cada grupo en su propia columna
foreach ($grupos as $i => $grupo) {
    $x = $x_inicial + ($i * $espacio_columna);
    $y = $y_inicial;

    foreach ($grupo as $etiqueta => $valor) {
        $pdf->SetXY($x, $y);
        $pdf->Cell(0, 5, utf8_decode("$etiqueta $valor"), 0, 1);
        $y += 5;
    }
}


//------------------------------------------
// IMPRIMIR LOS DATOS EN EL RECUADRO
//------------------------------------------
$pdf->SetFont('Arial', '', 9);
$pdf->SetTextColor(0, 0, 0);
$y = 195; // posición inicial dentro del recuadro DATOS
$x = 90;

// Cada línea con etiqueta + valor
$lineas = [
    
    "Calle:"            => limpiarDato($datos['calle']),
    "Ubicación:"        => limpiarDato($datos['ubicacion']),
    "Distrito:"         => limpiarDato($datos['distrito']),
    "OTB:"              => limpiarDato($datos['otb'])
    
];

// Imprimir cada línea en el PDF
foreach ($lineas as $etiqueta => $valor) {
    $pdf->SetXY($x, $y);
    $pdf->Cell(0, 5, utf8_decode("$etiqueta $valor"), 0, 1);
    $y += 5;
}



//echo $nombre_imagen;
//$pdf->Rect(50, 10, $anchomap-20, $altomap-20, 'D');//Mapa CONTORNO DE LA HOJA


// ---------- AGREGAR LOGO ----------
$logo_path = dirname(__FILE__) . '/imagens/EMAPAS.jpeg'; // Cambia la ruta a tu logo
if (file_exists($logo_path)) {
    $pdf->Image($logo_path, 28, 15, 30, 0, 'JPEG'); // (x, y, ancho, alto automático)
}


// ---------- AGREGAR LOGO ----------
$logo_path = dirname(__FILE__) . '/imagens/sigapas.png'; // Cambia la ruta a tu logo
if (file_exists($logo_path)) {
    $pdf->Image($logo_path, 177, 18, 20, 0, 'PNG'); // (x, y, ancho, alto automático)
}


//--------  IMPRIMIR TÍTULO 
$pdf->SetFont('Arial', 'B', 14); // Tipo Arial, negrita, tamaño 16
$pdf->SetTextColor(45, 90, 134); // Color azul (#2d5a86 opcional)
$pdf->SetXY(15, 32); // Posición dentro del recuadro del título
$pdf->Cell(190, 10, utf8_decode('CERTIFICACION DE RED DE ALCANTARILLADO'), 0, 0, 'C');

//--------  IMPRIMIR TÍTULO UBICACION (CORREGIDO)
$pdf->SetFont('Arial', 'B', 10); // Tamaño de fuente ajustado
$pdf->SetTextColor(45, 90, 134);
// Se establece la posición XY en la esquina del recuadro (140, 40)
// La celda abarca el ancho (60) y alto (15) del recuadro para centrar el texto
$pdf->SetXY(142, 45);
$pdf->Cell(60, 15, utf8_decode('Ubicación'), 0, 0, 'C');

//--------  IMPRIMIR TÍTULO LEYENDA (CORREGIDO)
$pdf->SetFont('Arial', 'B', 10); // Tamaño de fuente ajustado
$pdf->SetTextColor(45, 90, 134);
// Se establece la posición XY en la esquina del recuadro (140, 115)
// La celda abarca el ancho (60) y alto (15) del recuadro para centrar el texto
$pdf->SetXY(142, 115);
$pdf->Cell(60, 15, utf8_decode('Leyenda'), 0, 0, 'C');

//ESTABLECER LINEAS PARA LA LEYENDA

// Establecer color azul (RGB)
$pdf->SetDrawColor(0, 0, 255); // Azul puro

// Grosor opcional
$pdf->SetLineWidth(0.7);

// Dibujar línea de 5 cm = 50 mm
// Ejemplo: dentro del recuadro de la leyenda
$x_inicio = $margen_izq + 104 + 15 + 5; // un poco a la derecha del borde del recuadro
$y_pos = $margen_sup + 125; // posición vertical donde quieres la línea

$pdf->Line($x_inicio, $y_pos, $x_inicio + 6, $y_pos); // Línea horizontal de 50 mm


// Establecer color celeste (RGB)
$pdf->SetDrawColor(135, 206, 235); // Celeste Claro

// Grosor opcional
$pdf->SetLineWidth(0.5);

// Dibujar línea de 5 cm = 50 mm
// Ejemplo: dentro del recuadro de la leyenda
$x_inicio = $margen_izq + 104 + 15 + 5; // un poco a la derecha del borde del recuadro
$y_pos = $margen_sup + 130; // posición vertical donde quieres la línea

$pdf->Line($x_inicio, $y_pos, $x_inicio + 6, $y_pos); // Línea horizontal de 50 mm
//////////////FIN DE LAS LINEAS PARA LA LEYENDA////

// TEXTO PARA LA LEYENDA 
$pdf->SetFont('Arial', '', 8);           // Texto normal
$pdf->SetTextColor(0, 0, 0);              // Negro
$pdf->SetXY(156, 137); // Posición con un pequeño margen (1mm)
$pdf->Cell(40, 5, utf8_decode('Red Alcantarillado Seleccionado'), 0, 0, 'L'); // 'L' para alinear a la izquierda

$pdf->SetFont('Arial', '', 8);           // Texto normal
$pdf->SetTextColor(0, 0, 0);              // Negro
$pdf->SetXY(156, 142); // Posición con un pequeño margen (1mm)
$pdf->Cell(40, 5, utf8_decode('Red Alcantarillado'), 0, 0, 'L'); // 'L' para alinear a la izquierda
///////FIN DE TEXTO DE LEYENDA/////

// TÍTULO DATOS (Esquineado)
$pdf->SetFont('Arial', 'B', 10); // Letra más pequeña para estos títulos
$pdf->SetTextColor(45, 90, 134); // Color azul (#2d5a86 opcional)
$pdf->SetXY(26, 160); // Posición con un pequeño margen (1mm)
$pdf->Cell(40, 5, utf8_decode('Datos:'), 0, 0, 'L'); // 'L' para alinear a la izquierda



// TÍTULO DESCRIPCIÓN (Esquineado)
$pdf->SetFont('Arial', 'B', 11); // Letra más pequeña para estos títulos
$pdf->SetTextColor(45, 90, 134); // Color azul (#2d5a86 opcional)
$pdf->SetXY(26, 190);
$pdf->Cell(40, 5, utf8_decode('Descripción:'), 0, 0, 'L');



// --- Contenido del campo (texto largo) ---
$pdf->SetFont('Arial', '', 11);           // Texto normal
$pdf->SetTextColor(0, 0, 0);              // Negro
$pdf->SetXY(50, 190);                     // Mover a la derecha del título
$pdf->MultiCell(150, 5, utf8_decode('Se encuentra ubicado en:'), 0, 'L');

// TÍTULO REALIZADA POR (Esquineado)
$pdf->SetFont('Arial', 'B', 9); // Letra más pequeña para estos títulos
$pdf->SetTextColor(45, 90, 134); // Color azul (#2d5a86 opcional)
$pdf->SetXY(95, 240);
$pdf->Cell(40, 5, utf8_decode('Realizado por:'), 0, 0, 'L');




$pdf->Close();
$nombre_archivo = "mapa_hoja".$hoja.".pdf";
$pdf->Output($nombre_archivo,"I", true);

?>